/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal.dynamic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.temporal.dynamic.GenericTaint$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.HistoricEvent;
import com.raphtory.api.analysis.visitor.ReducedEdge;
import com.raphtory.api.analysis.visitor.ReducedVertex;
import com.raphtory.api.analysis.visitor.Vertex;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`GenericTaint((startTime: Int, infectedNodes: Iterable[Long], stopNodes: Set[Long] = Set())`\n  *  : temporal tainting/infection dynamic\n  *\n  * A tainting/infection algorithm for a directed graph. Given the start node(s) and time\n  * this algorithm will spread taint/infect any node which has received an edge after this time.\n  * The following node will then infect any of its neighbours that receive an edge after the\n  * time it was first infected. This repeats until the latest timestamp/iterations are met.\n  *\n  * ## Parameters\n  *\n  *  {s}`startTime: Long`\n  *    : Time to start spreading taint\n  *\n  *  {s}`infectedNodes: Iterable[String]`\n  *    : List of node names that will start as tainted\n  *\n  *  {s}`stopNodes: Iterable[String] = Set()`\n  *    : If set, any node names that will not propagate taint\n  *\n  * ## States\n  *\n  *  {s}`taintStatus: Boolean`\n  *    : {s}`true` if node is infected/tainted\n  *\n  *  {s}`taintHistory: List[(String, Long, Long, String)]`\n  *    : List of taint messages received by the vertex. Each message has the format\n  *     {s}`(\"tainted\", edge.ID, event.time, name)`, where {s}`edge.ID` is the `ID` of the edge sending the message,\n  *     {s}`event.time` is the timestamp for the tainting event, and {s}`name` is the name of the source node for the\n  *     message\n  *\n  * ## Returns\n  *\n  * Table of all tainting events\n  *\n  *  | vertex name       | propagating edge   | time of event         | source node       |\n  *  | ----------------- | ------------------ | --------------------- | ----------------- |\n  *  | {s}`name: String` | {s}`edge.ID: Long` | {s}`event.time: Long` | {s}`name: String` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001\u0002\b\u0010\u0001iA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\b\u0001B\u0001B\u0003%\u0001\u0007C\u0003@\u0001\u0011\u0005\u0001\tC\u0003G\u0001\u0011\u0005s\tC\u0003V\u0001\u0011\u0005ckB\u0003p\u001f!\u0005\u0001OB\u0003\u000f\u001f!\u0005\u0011\u000fC\u0003@\u0011\u0011\u0005!\u0010C\u0003G\u0011\u0011\u00051\u0010C\u0005\u0002\u0018!\t\n\u0011\"\u0001\u0002\u001a!I\u0011q\u0006\u0005\u0012\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003kA\u0011\u0011!C\u0005\u0003o\u0011AbR3oKJL7\rV1j]RT!\u0001E\t\u0002\u000f\u0011Lh.Y7jG*\u0011!cE\u0001\ti\u0016l\u0007o\u001c:bY*\u0011A#F\u0001\u000bC2<wN]5uQ6\u001c(B\u0001\f\u0018\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E%j\u0011a\t\u0006\u0003I\u0015\n\u0011\"\u00197h_JLG\u000f[7\u000b\u0005\u0019:\u0013\u0001C1oC2L8/[:\u000b\u0005!*\u0012aA1qS&\u0011!f\t\u0002\u0011\u000f\u0016tWM]5d%\u0016$Wo\u0019;j_:\f\u0011b\u001d;beR$\u0016.\\3\u0011\u0005qi\u0013B\u0001\u0018\u001e\u0005\u0011auN\\4\u0002\u001b%tg-Z2uK\u0012tu\u000eZ3t!\r\t\u0004h\u000f\b\u0003eY\u0002\"aM\u000f\u000e\u0003QR!!N\r\u0002\rq\u0012xn\u001c;?\u0013\t9T$\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u00121aU3u\u0015\t9T\u0004\u0005\u00022y%\u0011QH\u000f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0013M$x\u000e\u001d(pI\u0016\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0003B\u0007\u0012+\u0005C\u0001\"\u0001\u001b\u0005y\u0001\"B\u0016\u0005\u0001\u0004a\u0003\"B\u0018\u0005\u0001\u0004\u0001\u0004b\u0002 \u0005!\u0003\u0005\r\u0001M\u0001\u0006CB\u0004H.\u001f\u000b\u0003\u0011.\u0003\"!S*\u000f\u0005)[E\u0002\u0001\u0005\u0006\u0019\u0016\u0001\r!T\u0001\u0006OJ\f\u0007\u000f\u001b\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0016\n\u0011b\u001a:ba\"4\u0018.Z<\n\u0005I{%\u0001E$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f\u0013\t!\u0016K\u0001\u0007SK\u0012,8-\u001a3He\u0006\u0004\b.\u0001\u0006uC\n,H.\u0019:jg\u0016$\"aV/\u0011\u0005a[V\"A-\u000b\u0005i+\u0013!\u0002;bE2,\u0017B\u0001/Z\u0005\u0015!\u0016M\u00197f\u0011\u0015ae\u00011\u0001_!\tqu,\u0003\u0002a\u001f\n9\"+\u001a3vG\u0016$wI]1qQB+'o\u001d9fGRLg/\u001a\u0015\u0005\u0001\tdW\u000e\u0005\u0002dU6\tAM\u0003\u0002fM\u0006A1oY1mC\u0012|7M\u0003\u0002hQ\u00069A/Y6fu>,'BA5\u0018\u0003\u00199\u0017\u000e\u001e5vE&\u00111\u000e\u001a\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\na.AG\u0002_)R#\u0002\t\u0011+Am\u001cX\u0010Y$f]\u0016\u0014\u0018n\u0019+bS:$\b\u0006K:uCJ$H+[7fu\u0001Je\u000e\u001e\u0017!S:4Wm\u0019;fI:{G-Z:;A%#XM]1cY\u0016\\Fj\u001c8h;2\u00023\u000f^8q\u001d>$Wm\u001d\u001e!'\u0016$8\fT8oOv\u0003S\bI*fi\"J\u0013\u0006\u0019\u0006!A)\u0002\u0003E\u000f\u0011uK6\u0004xN]1mAQ\f\u0017N\u001c;j]\u001e|\u0013N\u001c4fGRLwN\u001c\u0011es:\fW.[2\u000bA\u0001R#\u0002\t\u0011+A\u0005\u0003C/Y5oi&twmL5oM\u0016\u001cG/[8oA\u0005dwm\u001c:ji\"l\u0007EZ8sA\u0005\u0004C-\u001b:fGR,G\rI4sCBDg\u0006I$jm\u0016t\u0007\u0005\u001e5fAM$\u0018M\u001d;!]>$W\rK:*A\u0005tG\r\t;j[\u0016T\u0001\u0005\t\u0016!i\"L7\u000fI1mO>\u0014\u0018\u000e\u001e5nA]LG\u000e\u001c\u0011taJ,\u0017\r\u001a\u0011uC&tGoL5oM\u0016\u001cG\u000fI1os\u0002rw\u000eZ3!o\"L7\r\u001b\u0011iCN\u0004#/Z2fSZ,G\rI1oA\u0015$w-\u001a\u0011bMR,'\u000f\t;iSN\u0004C/[7f])\u0001\u0003E\u000b\u0011UQ\u0016\u0004cm\u001c7m_^Lgn\u001a\u0011o_\u0012,\u0007e^5mY\u0002\"\b.\u001a8!S:4Wm\u0019;!C:L\be\u001c4!SR\u001c\bE\\3jO\"\u0014w.\u001e:tAQD\u0017\r\u001e\u0011sK\u000e,\u0017N^3!C:\u0004S\rZ4fA\u00054G/\u001a:!i\",'\u0002\t\u0011+AQLW.\u001a\u0011ji\u0002:\u0018m\u001d\u0011gSJ\u001cH\u000fI5oM\u0016\u001cG/\u001a3/AQC\u0017n\u001d\u0011sKB,\u0017\r^:!k:$\u0018\u000e\u001c\u0011uQ\u0016\u0004C.\u0019;fgR\u0004C/[7fgR\fW\u000e]\u0018ji\u0016\u0014\u0018\r^5p]N\u0004\u0013M]3![\u0016$hF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0002\u0016M]1nKR,'o\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y:uCJ$H+[7fu\u0001buN\\4a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002C+[7fAQ|\u0007e\u001d;beR\u00043\u000f\u001d:fC\u0012Lgn\u001a\u0011uC&tGO\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b-\u001b8gK\u000e$X\r\u001a(pI\u0016\u001c(\bI%uKJ\f'\r\\3\\'R\u0014\u0018N\\4^A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004\u0005T5ti\u0002zg\r\t8pI\u0016\u0004c.Y7fg\u0002\"\b.\u0019;!o&dG\u000eI:uCJ$\b%Y:!i\u0006Lg\u000e^3e\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?agR|\u0007OT8eKNT\u0004%\u0013;fe\u0006\u0014G.Z.TiJLgnZ/!{\u0001\u001aV\r\u001e\u0015*A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004%\u00134!g\u0016$H\u0006I1os\u0002rw\u000eZ3!]\u0006lWm\u001d\u0011uQ\u0006$\be^5mY\u0002rw\u000e\u001e\u0011qe>\u0004\u0018mZ1uK\u0002\"\u0018-\u001b8u\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005I*uCR,7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b\r^1j]R\u001cF/\u0019;vgj\u0002#i\\8mK\u0006t\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!wNl\b\r\u001e:vK\u0002\u0004\u0013N\u001a\u0011o_\u0012,\u0007%[:!S:4Wm\u0019;fI>\"\u0018-\u001b8uK\u0012T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002$\u0018-\u001b8u\u0011&\u001cHo\u001c:zu\u0001b\u0015n\u001d;\\QM#(/\u001b8hY\u0001buN\\4-A1{gn\u001a\u0017!'R\u0014\u0018N\\4*;\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t'jgR\u0004sN\u001a\u0011uC&tG\u000fI7fgN\fw-Z:!e\u0016\u001cW-\u001b<fI\u0002\u0012\u0017\u0010\t;iK\u00022XM\u001d;fq:\u0002S)Y2iA5,7o]1hK\u0002B\u0017m\u001d\u0011uQ\u0016\u0004cm\u001c:nCRT\u0001\u0005\t\u0016!A\u0001\u0002\u0003e_:~A\"\u0012C/Y5oi\u0016$'\u0005\f\u0011fI\u001e,g&\u0013#-A\u00154XM\u001c;/i&lW\r\f\u0011oC6,\u0017\u0006\u0019\u0017!o\",'/\u001a\u0011|gv\u0004W\rZ4f]%#\u0005\rI5tAQDW\r\t1J\t\u0002\u0004sN\u001a\u0011uQ\u0016\u0004S\rZ4fAM,g\u000eZ5oO\u0002\"\b.\u001a\u0011nKN\u001c\u0018mZ3-\u0015\u0001\u0002#\u0006\t\u0011!A\u0001Z8/ 1fm\u0016tGO\f;j[\u0016\u0004\u0007%[:!i\",\u0007\u0005^5nKN$\u0018-\u001c9!M>\u0014\b\u0005\u001e5fAQ\f\u0017N\u001c;j]\u001e\u0004SM^3oi2\u0002\u0013M\u001c3!wNl\bM\\1nK\u0002\u0004\u0013n\u001d\u0011uQ\u0016\u0004c.Y7fA=4\u0007\u0005\u001e5fAM|WO]2fA9|G-\u001a\u0011g_J\u0004C\u000f[3\u000bA\u0001R\u0003\u0005\t\u0011!A5,7o]1hK*\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011SKR,(O\\:\u000bA\u0001R#\u0002\t\u0011+AQ\u000b'\r\\3!_\u001a\u0004\u0013\r\u001c7!i\u0006Lg\u000e^5oO\u0002*g/\u001a8ug*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005 \u0011wKJ$X\r\u001f\u0011oC6,\u0007\u0005\t\u0011!A\u0001\u0002C\u0010\t9s_B\fw-\u0019;j]\u001e\u0004S\rZ4fA\u0001\u0002C\u0010\t;j[\u0016\u0004sN\u001a\u0011fm\u0016tG\u000f\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011}AM|WO]2fA9|G-\u001a\u0011!A\u0001\u0002\u0003\u0005\t?\u000bA\u0001R\u0003\u0005\t?![5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}\u0015\u0001\u0002#\u0006\t\u0011}Am\u001cX\u0010\u00198b[\u0016T\u0004e\u0015;sS:<\u0007\r\t?!wNl\b-\u001a3hK:JEI\u000f\u0011M_:<\u0007\r\t?!wNl\b-\u001a<f]RtC/[7fu\u0001buN\\4aAq\u00043p]?a]\u0006lWM\u000f\u0011TiJLgn\u001a1!y*\u0001\u0003EK\u0018\u0002\u0019\u001d+g.\u001a:jGR\u000b\u0017N\u001c;\u0011\u0005\tC1c\u0001\u0005\u001ceB\u00111\u000f_\u0007\u0002i*\u0011QO^\u0001\u0003S>T\u0011a^\u0001\u0005U\u00064\u0018-\u0003\u0002zi\na1+\u001a:jC2L'0\u00192mKR\t\u0001\u000f\u0006\u0004By\u0006\u0005\u0011Q\u0003\u0005\u0006W)\u0001\r! \t\u00039yL!a`\u000f\u0003\u0007%sG\u000f\u0003\u00040\u0015\u0001\u0007\u00111\u0001\t\u0006\u0003\u000b\tya\u000f\b\u0005\u0003\u000f\tYAD\u00024\u0003\u0013I\u0011AH\u0005\u0004\u0003\u001bi\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003#\t\u0019B\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\ti!\b\u0005\t})\u0001\n\u00111\u0001\u0002\u0004\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u001c)\"\u00111AA\u000fW\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0015;\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00121\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u00024)\u001a\u0001'!\b\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005e\u0002\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}b/\u0001\u0003mC:<\u0017\u0002BA\"\u0003{\u0011aa\u00142kK\u000e$\b")
public class GenericTaint
implements GenericReduction {
    private final long startTime;
    private final Set<String> infectedNodes;
    private final Set<String> stopNodes;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static Set<String> $lessinit$greater$default$3() {
        return GenericTaint$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<String> apply$default$3() {
        return GenericTaint$.MODULE$.apply$default$3();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(Generic other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return (ConcreteReducedGraphPerspective)graph.reducedView().step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            GenericTaint.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            GenericTaint.$anonfun$apply$4(this, vertex);
            return BoxedUnit.UNIT;
        }, 100, true);
    }

    public Table tabularise(ReducedGraphPerspective graph) {
        return graph.vertexFilter((Function1<Vertex, Object>)(Function1 & Serializable)vertex -> BoxesRunTime.boxToBoolean((boolean)GenericTaint.$anonfun$tabularise$1(vertex))).step((Function1 & Serializable)vertex -> {
            GenericTaint.$anonfun$tabularise$2(vertex);
            return BoxedUnit.UNIT;
        }).select((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "propagatingEdge", "timeOfEvent", "sourceNode"})).explode((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"propagatingEdge", "timeOfEvent", "sourceNode"}));
    }

    public static final /* synthetic */ void $anonfun$apply$3(GenericTaint $this, ReducedEdge edge$1, ReducedVertex vertex$1, HistoricEvent event) {
        block0: {
            if (!(event.event() & event.time() >= $this.startTime)) break block0;
            edge$1.send(new Tuple4((Object)"tainted", edge$1.ID(), (Object)BoxesRunTime.boxToLong((long)event.time()), (Object)vertex$1.name(vertex$1.name$default$1())));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$2(GenericTaint $this, ReducedVertex vertex$1, ReducedEdge edge) {
        ((EntityVisitor)((Object)edge)).history().foreach((Function1 & Serializable)event -> {
            GenericTaint.$anonfun$apply$3($this, edge, vertex$1, event);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$1(GenericTaint $this, ReducedVertex vertex) {
        block0: {
            if (!$this.infectedNodes.contains((Object)vertex.name(vertex.name$default$1()))) break block0;
            Vector result = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)"tainted", (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToLong((long)$this.startTime), (Object)"startPoint")}));
            ((EntityVisitor)((Object)vertex)).setState("taintStatus", BoxesRunTime.boxToBoolean((boolean)true));
            ((EntityVisitor)((Object)vertex)).setState("taintHistory", result);
            ((EntityVisitor)((Object)vertex)).setState("name", vertex.name(vertex.name$default$1()));
            vertex.getOutEdges($this.startTime, vertex.getOutEdges$default$2()).foreach((Function1 & Serializable)edge -> {
                GenericTaint.$anonfun$apply$2($this, vertex, edge);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ long $anonfun$apply$6(Tuple4 item) {
        return BoxesRunTime.unboxToLong((Object)item._3());
    }

    public static final /* synthetic */ void $anonfun$apply$9(long infectionTime$1, ReducedEdge edge$2, ReducedVertex vertex$2, HistoricEvent event) {
        block0: {
            if (!(event.event() & event.time() >= infectionTime$1)) break block0;
            edge$2.send(new Tuple4((Object)"tainted", edge$2.ID(), (Object)BoxesRunTime.boxToLong((long)event.time()), (Object)vertex$2.name(vertex$2.name$default$1())));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$8(long infectionTime$1, ReducedVertex vertex$2, ReducedEdge edge) {
        ((EntityVisitor)((Object)edge)).history().foreach((Function1 & Serializable)event -> {
            GenericTaint.$anonfun$apply$9(infectionTime$1, edge, vertex$2, event);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$11(long infectionTime$1, ReducedEdge edge$3, ReducedVertex vertex$2, HistoricEvent event) {
        block0: {
            if (!(event.event() & event.time() >= infectionTime$1)) break block0;
            edge$3.send(new Tuple4((Object)"tainted", edge$3.ID(), (Object)BoxesRunTime.boxToLong((long)event.time()), (Object)vertex$2.name(vertex$2.name$default$1())));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$10(long infectionTime$1, ReducedVertex vertex$2, ReducedEdge edge) {
        ((EntityVisitor)((Object)edge)).history().foreach((Function1 & Serializable)event -> {
            GenericTaint.$anonfun$apply$11(infectionTime$1, edge, vertex$2, event);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$4(GenericTaint $this, ReducedVertex vertex) {
        Seq newMessages = (Seq)((SeqOps)vertex.messageQueue().map((Function1 & Serializable)item -> item)).distinct();
        long infectionTime = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)newMessages.map((Function1 & Serializable)item -> BoxesRunTime.boxToLong((long)GenericTaint.$anonfun$apply$6(item)))).min((Ordering)Ordering.Long$.MODULE$));
        Seq status = (Seq)((SeqOps)newMessages.map((Function1 & Serializable)item -> (String)item._1())).distinct();
        if (status.contains((Object)"tainted")) {
            if (!BoxesRunTime.unboxToBoolean((Object)((EntityVisitor)((Object)vertex)).getOrSetState("taintStatus", BoxesRunTime.boxToBoolean((boolean)false), ((EntityVisitor)((Object)vertex)).getOrSetState$default$3()))) {
                ((EntityVisitor)((Object)vertex)).setState("taintHistory", newMessages);
                ((EntityVisitor)((Object)vertex)).setState("taintStatus", BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                Vector oldState = (Vector)((EntityVisitor)((Object)vertex)).getState("taintHistory", ((EntityVisitor)((Object)vertex)).getState$default$2());
                Vector newState = (Vector)package$.MODULE$.Vector().concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Iterable[]{newMessages, oldState})).distinct();
                ((EntityVisitor)((Object)vertex)).setState("taintHistory", newState);
            }
            if ($this.stopNodes.isEmpty()) {
                vertex.getOutEdges(infectionTime, vertex.getOutEdges$default$2()).foreach((Function1 & Serializable)edge -> {
                    GenericTaint.$anonfun$apply$8(infectionTime, vertex, edge);
                    return BoxedUnit.UNIT;
                });
            } else if (!$this.stopNodes.contains((Object)vertex.name(vertex.name$default$1()))) {
                vertex.getOutEdges(infectionTime, vertex.getOutEdges$default$2()).foreach((Function1 & Serializable)edge -> {
                    GenericTaint.$anonfun$apply$10(infectionTime, vertex, edge);
                    return BoxedUnit.UNIT;
                });
            }
        } else {
            vertex.voteToHalt();
        }
    }

    public static final /* synthetic */ boolean $anonfun$tabularise$1(ReducedVertex vertex) {
        return BoxesRunTime.unboxToBoolean((Object)((EntityVisitor)((Object)vertex)).getStateOrElse("taintStatus", BoxesRunTime.boxToBoolean((boolean)false), ((EntityVisitor)((Object)vertex)).getStateOrElse$default$3()));
    }

    public static final /* synthetic */ void $anonfun$tabularise$2(ReducedVertex vertex) {
        Vector taintHistory = (Vector)((EntityVisitor)((Object)vertex)).getStateOrElse("taintHistory", package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$), ((EntityVisitor)((Object)vertex)).getStateOrElse$default$3());
        Tuple3 tuple3 = ((StrictOptimizedIterableOps)taintHistory.map((Function1 & Serializable)t -> new Tuple3(t._2(), t._3(), t._4()))).unzip3(Predef$.MODULE$.$conforms());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Vector propEdges = (Vector)tuple3._1();
        Vector timeOfEvents = (Vector)tuple3._2();
        Vector sourceNodes = (Vector)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)propEdges, (Object)timeOfEvents, (Object)sourceNodes);
        Tuple3 tuple33 = tuple32;
        Vector propEdges2 = (Vector)tuple33._1();
        Vector timeOfEvents2 = (Vector)tuple33._2();
        Vector sourceNodes2 = (Vector)tuple33._3();
        ((EntityVisitor)((Object)vertex)).setState("propagatingEdge", propEdges2);
        ((EntityVisitor)((Object)vertex)).setState("timeOfEvent", timeOfEvents2);
        ((EntityVisitor)((Object)vertex)).setState("sourceNode", sourceNodes2);
    }

    public GenericTaint(long startTime, Set<String> infectedNodes, Set<String> stopNodes) {
        this.startTime = startTime;
        this.infectedNodes = infectedNodes;
        this.stopNodes = stopNodes;
        BaseAlgorithm.$init$(this);
        GenericReduction.$init$(this);
    }
}

