/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.temporal.Descendants$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.ConcreteEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.HistoricEvent;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`Descendants(seed:String, time:Long, delta:Long=Long.MaxValue, directed:Boolean=true)`\n  *  : find all descendants of a vertex at a given time point\n  *\n  * The descendants of a seed vertex are defined as those vertices which can be reached from the seed vertex\n  * via a temporal path (in a temporal path the time of the next edge is always later than the time of the previous edge)\n  * starting after the specified time.\n  *\n  * ## Parameters\n  *\n  *  {s}`seed: String`\n  *    : The name of the target vertex\n  *\n  *  {s}`time: Long`\n  *    : The time of interest\n  *\n  *  {s}`delta: Long = Long.MaxValue`\n  *    : The maximum timespan for the temporal path. This is currently exclusive of the newest time\n  *       i.e. if looking forward a minute it will not include events that happen exactly 1 minute into the future.\n  *\n  *  {s}`directed: Boolean = true`\n  *    : whether to treat the network as directed\n  *\n  *  {s}`strict: Boolean = true`\n  *    : Whether firstActivityAfter is strict in its following of paths that happen exactly at the given time. True will not follow, False will.\n  *\n  * ## States\n  *\n  *  {s}`descendant: Boolean`\n  *    : flag indicating that the vertex is a descendant of {s}`seed`\n  *\n  * ## Returns\n  *\n  *  | vertex name       | is descendant of seed?   |\n  *  | ----------------- | ---------------------- |\n  *  | {s}`name: String` | {s}`descendant: Boolean` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\n\u0015\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!a\u0004A!A!\u0002\u0013I\u0004\"B\u001f\u0001\t\u0003q\u0004\"\u0002$\u0001\t\u0003:u!B4\u0015\u0011\u0003Ag!B\n\u0015\u0011\u0003I\u0007\"B\u001f\n\t\u0003)\b\"\u0002$\n\t\u00031\bb\u0002?\n#\u0003%\t! \u0005\n\u0003#I\u0011\u0013!C\u0001\u0003'A\u0011\"a\u0006\n#\u0003%\t!a\u0005\t\u0011\u0005e\u0011\"%A\u0005\u0002uD\u0011\"a\u0007\n#\u0003%\t!a\u0005\t\u0013\u0005u\u0011\"%A\u0005\u0002\u0005M\u0001\"CA\u0010\u0013\u0005\u0005I\u0011BA\u0011\u0005-!Um]2f]\u0012\fg\u000e^:\u000b\u0005U1\u0012\u0001\u0003;f[B|'/\u00197\u000b\u0005]A\u0012AC1mO>\u0014\u0018\u000e\u001e5ng*\u0011\u0011DG\u0001\te\u0006\u0004\b\u000e^8ss*\t1$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\u0011\u0011EF\u0001\bO\u0016tWM]5d\u0013\t\u0019\u0003E\u0001\u0005O_\u0012,G*[:u\u0003\u0011\u0019X-\u001a3\u0011\u0005\u0019zcBA\u0014.!\tA3&D\u0001*\u0015\tQC$\u0001\u0004=e>|GO\u0010\u0006\u0002Y\u0005)1oY1mC&\u0011afK\u0001\u0007!J,G-\u001a4\n\u0005A\n$AB*ue&twM\u0003\u0002/W\u0005!A/[7f!\t!T'D\u0001,\u0013\t14F\u0001\u0003M_:<\u0017!\u00023fYR\f\u0017\u0001\u00033je\u0016\u001cG/\u001a3\u0011\u0005QR\u0014BA\u001e,\u0005\u001d\u0011un\u001c7fC:\faa\u001d;sS\u000e$\u0018A\u0002\u001fj]&$h\b\u0006\u0004@\u0003\n\u001bE)\u0012\t\u0003\u0001\u0002i\u0011\u0001\u0006\u0005\u0006I\u0019\u0001\r!\n\u0005\u0006e\u0019\u0001\ra\r\u0005\bo\u0019\u0001\n\u00111\u00014\u0011\u001dAd\u0001%AA\u0002eBq\u0001\u0010\u0004\u0011\u0002\u0003\u0007\u0011(A\u0003baBd\u0017\u0010\u0006\u0002I\u0017B\u0011\u0011j\u0016\b\u0003\u0015.c\u0001\u0001C\u0003M\u000f\u0001\u0007Q*A\u0003he\u0006\u0004\b\u000e\u0005\u0002O+6\tqJ\u0003\u0002Q#\u0006IqM]1qQZLWm\u001e\u0006\u0003%N\u000b\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003)b\t1!\u00199j\u0013\t1vJ\u0001\tHe\u0006\u0004\b\u000eU3sgB,7\r^5wK&\u0011\u0001,\u0016\u0002\u0006\u000fJ\f\u0007\u000f\u001b\u0015\u0005\u0001i#W\r\u0005\u0002\\E6\tAL\u0003\u0002^=\u0006A1oY1mC\u0012|7M\u0003\u0002`A\u00069A/Y6fu>,'BA1\u001b\u0003\u00199\u0017\u000e\u001e5vE&\u00111\r\u0018\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\na-AF\b_)R#\u0002\t\u0011+Am\u001cX\u0010\u0019#fg\u000e,g\u000eZ1oiND3/Z3euM#(/\u001b8hY\u0001\"\u0018.\\3;\u0019>tw\r\f\u0011eK2$\u0018M\u000f'p]\u001elDj\u001c8h]5\u000b\u0007PV1mk\u0016d\u0003\u0005Z5sK\u000e$X\r\u001a\u001eC_>dW-\u00198>iJ,X-\u000b1\u000bA\u0001R\u0003\u0005\t\u001e!M&tG\rI1mY\u0002\"Wm]2f]\u0012\fg\u000e^:!_\u001a\u0004\u0013\r\t<feR,\u0007\u0010I1uA\u0005\u0004s-\u001b<f]\u0002\"\u0018.\\3!a>Lg\u000e\u001e\u0006!A)R\u0001\u0005\t\u0016!)\",\u0007\u0005Z3tG\u0016tG-\u00198ug\u0002zg\rI1!g\u0016,G\r\t<feR,\u0007\u0010I1sK\u0002\"WMZ5oK\u0012\u0004\u0013m\u001d\u0011uQ>\u001cX\r\t<feRL7-Z:!o\"L7\r\u001b\u0011dC:\u0004#-\u001a\u0011sK\u0006\u001c\u0007.\u001a3!MJ|W\u000e\t;iK\u0002\u001aX-\u001a3!m\u0016\u0014H/\u001a=\u000bA\u0001R\u0003E^5bA\u0005\u0004C/Z7q_J\fG\u000e\t9bi\"\u0004\u0003&\u001b8!C\u0002\"X-\u001c9pe\u0006d\u0007\u0005]1uQ\u0002\"\b.\u001a\u0011uS6,\u0007e\u001c4!i\",\u0007E\\3yi\u0002*GmZ3!SN\u0004\u0013\r\\<bsN\u0004C.\u0019;fe\u0002\"\b.\u00198!i\",\u0007\u0005^5nK\u0002zg\r\t;iK\u0002\u0002(/\u001a<j_V\u001c\b%\u001a3hK&R\u0001\u0005\t\u0016!gR\f'\u000f^5oO\u0002\ng\r^3sAQDW\rI:qK\u000eLg-[3eAQLW.\u001a\u0018\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003\u0005U1sC6,G/\u001a:t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?ag\u0016,GM\u000f\u0011TiJLgn\u001a1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001\"\u0006.\u001a\u0011oC6,\u0007e\u001c4!i\",\u0007\u0005^1sO\u0016$\bE^3si\u0016D(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004G/[7fu\u0001buN\\4a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002C\u000b[3!i&lW\rI8gA%tG/\u001a:fgRT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002$W\r\u001c;bu\u0001buN\\4!{\u0001buN\\4/\u001b\u0006Dh+\u00197vK\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t+iK\u0002j\u0017\r_5nk6\u0004C/[7fgB\fg\u000e\t4pe\u0002\"\b.\u001a\u0011uK6\u0004xN]1mAA\fG\u000f\u001b\u0018!)\"L7\u000fI5tA\r,(O]3oi2L\b%\u001a=dYV\u001c\u0018N^3!_\u001a\u0004C\u000f[3!]\u0016<Xm\u001d;!i&lWM\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A%tSM\f\u0011jM\u0002bwn\\6j]\u001e\u0004cm\u001c:xCJ$\u0007%\u0019\u0011nS:,H/\u001a\u0011ji\u0002:\u0018\u000e\u001c7!]>$\b%\u001b8dYV$W\rI3wK:$8\u000f\t;iCR\u0004\u0003.\u00199qK:\u0004S\r_1di2L\b%\r\u0011nS:,H/\u001a\u0011j]R|\u0007\u0005\u001e5fA\u0019,H/\u001e:f])\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~A\u0012L'/Z2uK\u0012T\u0004EQ8pY\u0016\fg\u000eI\u001f!iJ,X\r\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A]DW\r\u001e5fe\u0002\"x\u000e\t;sK\u0006$\b\u0005\u001e5fA9,Go^8sW\u0002\n7\u000f\t3je\u0016\u001cG/\u001a3\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1tiJL7\r\u001e\u001e!\u0005>|G.Z1oAu\u0002CO];fA*\u0001\u0003E\u000b\u0011!A\u0001R\u0004e\u00165fi\",'\u000f\t4jeN$\u0018i\u0019;jm&$\u00180\u00114uKJ\u0004\u0013n\u001d\u0011tiJL7\r\u001e\u0011j]\u0002JGo\u001d\u0011g_2dwn^5oO\u0002zg\r\t9bi\"\u001c\b\u0005\u001e5bi\u0002B\u0017\r\u001d9f]\u0002*\u00070Y2uYf\u0004\u0013\r\u001e\u0011uQ\u0016\u0004s-\u001b<f]\u0002\"\u0018.\\3/AQ\u0013X/\u001a\u0011xS2d\u0007E\\8uA\u0019|G\u000e\\8xY\u00012\u0015\r\\:fA]LG\u000e\u001c\u0018\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003e\u0015;bi\u0016\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004G-Z:dK:$\u0017M\u001c;;A\t{w\u000e\\3b]\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t4mC\u001e\u0004\u0013N\u001c3jG\u0006$\u0018N\\4!i\"\fG\u000f\t;iK\u00022XM\u001d;fq\u0002J7\u000fI1!I\u0016\u001c8-\u001a8eC:$\be\u001c4!wNl\bm]3fI\u0002T\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!%\u0016$XO\u001d8t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002C\u0010\t<feR,\u0007\u0010\t8b[\u0016\u0004\u0003\u0005\t\u0011!A\u0001b\b%[:!I\u0016\u001c8-\u001a8eC:$\be\u001c4!g\u0016,Gm\u0010\u0011!AqT\u0001\u0005\t\u0016!Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0006!A)\u0002\u0003\u0005 \u0011|gv\u0004g.Y7fu\u0001\u001aFO]5oO\u0002\u0004C\u0010I>t{\u0002$Wm]2f]\u0012\fg\u000e\u001e\u001e!\u0005>|G.Z1oA\u0002b(\u0002\t\u0011+_\u0005YA)Z:dK:$\u0017M\u001c;t!\t\u0001\u0015bE\u0002\nU6\u0004\"\u0001N6\n\u00051\\#AB!osJ+g\r\u0005\u0002og6\tqN\u0003\u0002qc\u0006\u0011\u0011n\u001c\u0006\u0002e\u0006!!.\u0019<b\u0013\t!xN\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001i)\u0019yt\u000f_={w\")Ae\u0003a\u0001K!)!g\u0003a\u0001g!9qg\u0003I\u0001\u0002\u0004\u0019\u0004b\u0002\u001d\f!\u0003\u0005\r!\u000f\u0005\by-\u0001\n\u00111\u0001:\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001aT#\u0001@+\u0005Mz8FAA\u0001!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-1&\u0001\u0006b]:|G/\u0019;j_:LA!a\u0004\u0002\u0006\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ*\"!!\u0006+\u0005ez\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a\t\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000br\u0003\u0011a\u0017M\\4\n\t\u00055\u0012q\u0005\u0002\u0007\u001f\nTWm\u0019;")
public class Descendants
extends NodeList {
    private final String seed;
    private final long time;
    private final long delta;
    private final boolean directed;
    private final boolean strict;

    public static boolean $lessinit$greater$default$5() {
        return Descendants$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return Descendants$.MODULE$.$lessinit$greater$default$4();
    }

    public static long $lessinit$greater$default$3() {
        return Descendants$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean apply$default$5() {
        return Descendants$.MODULE$.apply$default$5();
    }

    public static boolean apply$default$4() {
        return Descendants$.MODULE$.apply$default$4();
    }

    public static long apply$default$3() {
        return Descendants$.MODULE$.apply$default$3();
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        ConcreteGraphPerspective qual$1 = graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            Descendants.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable x$1 = (Function1 & Serializable)vertex -> {
            Descendants.$anonfun$apply$3(this, vertex);
            return BoxedUnit.UNIT;
        };
        boolean x$2 = true;
        int x$3 = 100;
        return qual$1.iterate(x$1, 100, true);
    }

    public static final /* synthetic */ void $anonfun$apply$2(Descendants $this, Vertex vertex$1, ConcreteEdge e) {
        Option<HistoricEvent> option = ((EntityVisitor)((Object)e)).firstActivityAfter($this.time, $this.strict);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            HistoricEvent event = (HistoricEvent)some.value();
            if (event.time() < $this.time + $this.delta) {
                vertex$1.messageVertex(e.ID(), BoxesRunTime.boxToLong((long)event.time()), SchemaProviderInstances$.MODULE$.longSchemaProvider());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$1(Descendants $this, Vertex vertex) {
        block0: {
            String string = vertex.name(vertex.name$default$1());
            String string2 = $this.seed;
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            ($this.directed ? vertex.outEdges() : vertex.edges()).foreach((Function1 & Serializable)e -> {
                Descendants.$anonfun$apply$2($this, vertex, e);
                return BoxedUnit.UNIT;
            });
            ((EntityVisitor)((Object)vertex)).setState("descendant", BoxesRunTime.boxToBoolean((boolean)false));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$4(Descendants $this, Vertex vertex$2, ConcreteEdge e) {
        Option<HistoricEvent> option = ((EntityVisitor)((Object)e)).firstActivityAfter($this.time, $this.strict);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            HistoricEvent event = (HistoricEvent)some.value();
            if (event.time() < $this.time + $this.delta) {
                vertex$2.messageVertex(e.ID(), BoxesRunTime.boxToLong((long)event.time()), SchemaProviderInstances$.MODULE$.longSchemaProvider());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$3(Descendants $this, Vertex vertex) {
        long earliestTime = BoxesRunTime.unboxToLong((Object)vertex.messageQueue().min((Ordering)Ordering.Long$.MODULE$));
        ((EntityVisitor)((Object)vertex)).setState("descendant", BoxesRunTime.boxToBoolean((boolean)true));
        ($this.directed ? vertex.outEdges() : vertex.edges()).foreach((Function1 & Serializable)e -> {
            Descendants.$anonfun$apply$4($this, vertex, e);
            return BoxedUnit.UNIT;
        });
    }

    public Descendants(String seed, long time, long delta, boolean directed, boolean strict) {
        this.seed = seed;
        this.time = time;
        this.delta = delta;
        this.directed = directed;
        this.strict = strict;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"descendant"}))), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"descendant"), (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
    }
}

