/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.motif.SquareCount$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`SquareCount()`\n  *   : Count undirected squares that a vertex is part of\n  *\n  *  This is similar to counting triangles and especially useful for\n  *  bipartite graphs. This implementation is based on the algorithm from\n  *  [Towards Distributed Square Counting in Large Graphs](https://doi.org/10.1109/hpec49654.2021.9622799)\n  *\n  * ## States\n  *\n  *  {s}`adjPlus: Array[Long]`\n  *    : List of neighbours that have a larger degree than the current vertex or the same degree and a larger ID\n  *      as computed by the [](com.raphtory.algorithms.generic.AdjPlus) algorithm.\n  *\n  *  {s}`squareCount: Long`\n  *    : Number of squares the vertex is part of\n  *\n  * Returns\n  *\n  *  | vertex name       | square count           |\n  *  | ----------------- | ---------------------- |\n  *  | {s}`name: String` | {s}`squareCount: Long` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u001d;Q!\u0002\u0004\t\u0002E1Qa\u0005\u0004\t\u0002QAQ!G\u0001\u0005\u0002iAQaG\u0001\u0005BqAqAL\u0001\u0002\u0002\u0013%q&A\u0006TcV\f'/Z\"pk:$(BA\u0004\t\u0003\u0015iw\u000e^5g\u0015\tI!\"A\u0004hK:,'/[2\u000b\u0005-a\u0011AC1mO>\u0014\u0018\u000e\u001e5ng*\u0011QBD\u0001\te\u0006\u0004\b\u000e^8ss*\tq\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\u0013\u00035\taAA\u0006TcV\f'/Z\"pk:$8CA\u0001\u0016!\t1r#D\u0001\t\u0013\tA\u0002B\u0001\u0005O_\u0012,G*[:u\u0003\u0019a\u0014N\\5u}Q\t\u0011#A\u0003baBd\u0017\u0010\u0006\u0002\u001eAA\u0011a\u0004\f\b\u0003?\u0001b\u0001\u0001C\u0003\"\u0007\u0001\u0007!%A\u0003he\u0006\u0004\b\u000e\u0005\u0002$U5\tAE\u0003\u0002&M\u0005IqM]1qQZLWm\u001e\u0006\u0003O!\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003S1\t1!\u00199j\u0013\tYCE\u0001\tHe\u0006\u0004\b\u000eU3sgB,7\r^5wK&\u0011QF\u000b\u0002\u0006\u000fJ\f\u0007\u000f[\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002aA\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0005Y\u0006twMC\u00016\u0003\u0011Q\u0017M^1\n\u0005]\u0012$AB(cU\u0016\u001cG\u000f\u000b\u0003\u0002s\r#\u0005C\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u0003!\u00198-\u00197bI>\u001c'B\u0001 @\u0003\u001d!\u0018m[3{_\u0016T!\u0001\u0011\b\u0002\r\u001dLG\u000f[;c\u0013\t\u00115H\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\u0005)\u0015Ab)0U)R\u0001\u0005\t\u0016!wNl\bmU9vCJ,7i\\;oi\"J\u0003M\u0003\u0011!U\u0001\u0002\u0003E\u000f\u0011D_VtG\u000fI;oI&\u0014Xm\u0019;fI\u0002\u001a\u0018/^1sKN\u0004C\u000f[1uA\u0005\u0004c/\u001a:uKb\u0004\u0013n\u001d\u0011qCJ$\be\u001c4\u000bA\u0001R#\u0002\t\u0011+A\u0001\"\u0006.[:!SN\u00043/[7jY\u0006\u0014\b\u0005^8!G>,h\u000e^5oO\u0002\"(/[1oO2,7\u000fI1oI\u0002*7\u000f]3dS\u0006dG.\u001f\u0011vg\u00164W\u000f\u001c\u0011g_JT\u0001\u0005\t\u0016!A\tL\u0007/\u0019:uSR,\u0007e\u001a:ba\"\u001ch\u0006\t+iSN\u0004\u0013.\u001c9mK6,g\u000e^1uS>t\u0007%[:!E\u0006\u001cX\r\u001a\u0011p]\u0002\"\b.\u001a\u0011bY\u001e|'/\u001b;i[\u00022'o\\7\u000bA\u0001R\u0003\u0005I.U_^\f'\u000fZ:!\t&\u001cHO]5ckR,G\rI*rk\u0006\u0014X\rI\"pk:$\u0018N\\4!S:\u0004C*\u0019:hK\u0002:%/\u00199igvC\u0003\u000e\u001e;qgjzs\u0006Z8j]=\u0014xmL\u00191]E\n\u0004'O\u0018ia\u0016\u001cG'\u000f\u001c6i9\u0012\u0004GM\u0019/sY\u0012$gN\u001d:S)\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011Ti\u0006$Xm\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y1eUBcWo\u001d\u001e!\u0003J\u0014\u0018-_.M_:<W\f\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A1K7\u000f\u001e\u0011pM\u0002rW-[4iE>,(o\u001d\u0011uQ\u0006$\b\u0005[1wK\u0002\n\u0007\u0005\\1sO\u0016\u0014\b\u0005Z3he\u0016,\u0007\u0005\u001e5b]\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!m\u0016\u0014H/\u001a=!_J\u0004C\u000f[3!g\u0006lW\r\t3fOJ,W\rI1oI\u0002\n\u0007\u0005\\1sO\u0016\u0014\b%\u0013#\u000bA\u0001R\u0003\u0005\t\u0011!A\u0001\n7\u000fI2p[B,H/\u001a3!Ef\u0004C\u000f[3!7vC3m\\7/e\u0006\u0004\b\u000e^8ss:\nGnZ8sSRDWn\u001d\u0018hK:,'/[2/\u0003\u0012T\u0007\u000b\\;tS\u0001\nGnZ8sSRDWN\f\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y:rk\u0006\u0014XmQ8v]RT\u0004\u0005T8oO\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t(v[\n,'\u000fI8gAM\fX/\u0019:fg\u0002\"\b.\u001a\u0011wKJ$X\r\u001f\u0011jg\u0002\u0002\u0018M\u001d;!_\u001aT\u0001\u0005\t\u0016\u000bA\u0001R\u0003EU3ukJt7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!y\u00022XM\u001d;fq\u0002r\u0017-\\3!A\u0001\u0002\u0003\u0005\t\u0011}AM\fX/\u0019:fA\r|WO\u001c;!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002CP\u0003\u0011!U\u0001\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}\u0015\u0001\u0002#\u0006\t\u0011}Am\u001cX\u0010\u00198b[\u0016T\u0004e\u0015;sS:<\u0007\r\t?!wNl\bm]9vCJ,7i\\;oij\u0002Cj\u001c8hA\u0002b(\u0002\t\u0011+_!\"\u0001!O\"E\u0001")
public final class SquareCount {
    public static ConcreteGraphPerspective apply(GraphPerspective graph) {
        return SquareCount$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return SquareCount$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return SquareCount$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static Generic $minus$greater(Generic other) {
        return SquareCount$.MODULE$.$minus$greater(other);
    }

    public static Table tabularise(GraphPerspective graph) {
        return SquareCount$.MODULE$.tabularise(graph);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return SquareCount$.MODULE$.name();
    }

    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public static Table run(GraphPerspective graph) {
        return SquareCount$.MODULE$.run(graph);
    }
}

