/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.AdjPlus$;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.algorithms.generic.motif.CountPQ$;
import com.raphtory.algorithms.generic.motif.CountPR$;
import com.raphtory.algorithms.generic.motif.CountQR$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`SquareCount()`\n  *   : Count undirected squares that a vertex is part of\n  *\n  *  This is similar to counting triangles and especially useful for\n  *  bipartite graphs. This implementation is based on the algorithm from\n  *  [Towards Distributed Square Counting in Large Graphs](https://doi.org/10.1109/hpec49654.2021.9622799)\n  *\n  * ## States\n  *\n  *  {s}`adjPlus: Array[Long]`\n  *    : List of neighbours that have a larger degree than the current vertex or the same degree and a larger ID\n  *      as computed by the [](com.raphtory.algorithms.generic.AdjPlus) algorithm.\n  *\n  *  {s}`squareCount: Long`\n  *    : Number of squares the vertex is part of\n  *\n  * Returns\n  *\n  *  | vertex name       | square count           |\n  *  | ----------------- | ---------------------- |\n  *  | {s}`name: String` | {s}`squareCount: Long` |\n  */")
public final class SquareCount$
extends NodeList {
    public static final SquareCount$ MODULE$ = new SquareCount$();

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return CountPQ$.MODULE$.apply(CountQR$.MODULE$.apply(CountPR$.MODULE$.apply(AdjPlus$.MODULE$.apply(graph))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SquareCount$.class);
    }

    private SquareCount$() {
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"squareCount"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

