/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.gametheory;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.gametheory.PrisonersDilemma$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@Scaladoc(value="/**\n  * {s}`PrisonersDilemma(proportionCoop: Float = 0.5f, benefit: Float, cost: Float = 1.0f, noGames: Int = 100)`\n  *   : run iterative game of prisoners dilemma\n  *\n  *   An iterative game of Prisoners' dilemma is played on the network. In each round, vertices simultaneously play a round\n  *   of Prisoners' dilemma with their neighbours, getting a payoff according to whether each player chose to cooperate (C)\n  *   or defect(D). After the game is played, a vertex adopts its strategy by choosing the highest scoring strategy in its\n  *   direct neighbourhood. This carries on until either a pre-defined number of games is played or if none of the vertices\n  *   change their strategy.\n  *\n  * ## Parameters\n  *\n  *   {s}`proportionCoop: Float=0.5f`\n  *    : Proportion of vertices that start out as cooperators (uniformly sampled). Alternatively, vertices\n  *     starting with a status \"cooperator\" set to 0 begin as cooperators.\n  *\n  *   {s}`benefit: Float`\n  *    : Benefit parameter for prisoners' dilemma game. See [1]\n  *\n  *   {s}`cost: Float`\n  *    : Cost parameter for prisoners' dilemma game. See [1]\n  *\n  *   {s}`noGames`\n  *    : Maximum number of games to be played.\n  *\n  *   {s}`seed`\n  *    : optional seed for testing purposes.\n  *\n  * ## States\n  *\n  *   {s}`cooperator: Int`\n  *    : The latest status: cooperator (0), or defector (1), of the vertex at that iteration.\n  *\n  *   {s}`cooperationHistory: mutable.Queue[Int]`\n  *    : The full history of a vertex' cooperation status for the games played.\n  *\n  * ## Returns\n  *\n  *   | vertex name       | cooperation history                 |\n  *   | ----------------- | ----------------------------------- |\n  *   | {s}`name: String` | {s}`cooperationHistory: Queue[Int]` |\n  *\n  * ## References\n  *\n  *   [1] Nowak, M. A., & May, R. M. (1992). Evolutionary games and spatial chaos. Nature, 359(6398), 826-829.\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.dynamic.WattsCascade)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001B\u0011#\u00015B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u007f!A1\t\u0001B\u0001B\u0003%q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0005A!A!\u0002\u0013)\u0005\"B%\u0001\t\u0003Q\u0005b\u0002*\u0001\u0005\u0004%Ia\u0015\u0005\u00075\u0002\u0001\u000b\u0011\u0002+\t\u000fm\u0003!\u0019!C\u00079\"1q\f\u0001Q\u0001\u000euCq\u0001\u0019\u0001C\u0002\u00135\u0011\r\u0003\u0004e\u0001\u0001\u0006iA\u0019\u0005\bK\u0002\u0011\r\u0011\"\u0004]\u0011\u00191\u0007\u0001)A\u0007;\"9q\r\u0001b\u0001\n\u001b\t\u0007B\u00025\u0001A\u00035!\rC\u0003j\u0001\u0011\u0005#\u000eC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018\u001d9\u00111\t\u0012\t\u0002\u0005\u0015cAB\u0011#\u0011\u0003\t9\u0005\u0003\u0004J-\u0011\u0005\u0011\u0011\f\u0005\u0007SZ!\t!a\u0017\t\u0013\u0005\u001dd#%A\u0005\u0002\u0005%\u0004\"CA@-E\u0005I\u0011AAA\u0011%\t)IFI\u0001\n\u0003\t\t\tC\u0005\u0002\bZ\t\n\u0011\"\u0001\u0002j!I\u0011\u0011\u0012\f\u0012\u0002\u0013\u0005\u0011\u0011\u000e\u0005\n\u0003\u00173\u0012\u0013!C\u0001\u0003\u0003C\u0011\"!$\u0017#\u0003%\t!!!\t\u0013\u0005=e#!A\u0005\n\u0005E%\u0001\u0005)sSN|g.\u001a:t\t&dW-\\7b\u0015\t\u0019C%\u0001\u0006hC6,G\u000f[3pefT!!\n\u0014\u0002\u000f\u001d,g.\u001a:jG*\u0011q\u0005K\u0001\u000bC2<wN]5uQ6\u001c(BA\u0015+\u0003!\u0011\u0018\r\u001d5u_JL(\"A\u0016\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001qC\u0007\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003kqj\u0011A\u000e\u0006\u0003oa\n\u0011\"\u00197h_JLG\u000f[7\u000b\u0005eR\u0014\u0001C1oC2L8/[:\u000b\u0005mB\u0013aA1qS&\u0011QH\u000e\u0002\b\u000f\u0016tWM]5d\u00039\u0001(o\u001c9peRLwN\\\"p_B\u0004\"a\f!\n\u0005\u0005\u0003$!\u0002$m_\u0006$\u0018a\u00022f]\u00164\u0017\u000e^\u0001\u0005G>\u001cH/A\u0004o_\u001e\u000bW.Z:\u0011\u0005=2\u0015BA$1\u0005\rIe\u000e^\u0001\u0005g\u0016,G-\u0001\u0004=S:LGO\u0010\u000b\u0007\u00176su\nU)\u0011\u00051\u0003Q\"\u0001\u0012\t\u000fy2\u0001\u0013!a\u0001\u007f!)!I\u0002a\u0001\u007f!91I\u0002I\u0001\u0002\u0004y\u0004b\u0002#\u0007!\u0003\u0005\r!\u0012\u0005\b\u0011\u001a\u0001\n\u00111\u0001F\u0003\r\u0011h\u000eZ\u000b\u0002)B\u0011Q\u000bW\u0007\u0002-*\u0011q\u000bM\u0001\u0005kRLG.\u0003\u0002Z-\n1!+\u00198e_6\fAA\u001d8eA\u0005Q1iT(Q\u000bJ\u000bEk\u0014*\u0016\u0003u{\u0011AX\u000f\u0002\u0001\u0005Y1iT(Q\u000bJ\u000bEk\u0014*!\u0003!!UIR#D)>\u0013V#\u00012\u0010\u0003\rl\u0012!A\u0001\n\t\u00163Ui\u0011+P%\u0002\n\u0001\u0002\u0015'B3N#V\tU\u0001\n!2\u000b\u0015l\u0015+F!\u0002\n!\"\u0016)E\u0003R+5\u000bV#Q\u0003-)\u0006\u000bR!U\u000bN#V\t\u0015\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005-t\u0007C\u00017w\u001d\tig\u000e\u0004\u0001\t\u000b=\f\u0002\u0019\u00019\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\u0005E$X\"\u0001:\u000b\u0005MD\u0014!C4sCBDg/[3x\u0013\t)(O\u0001\tHe\u0006\u0004\b\u000eU3sgB,7\r^5wK&\u0011q\u000f\u001e\u0002\u0006\u000fJ\f\u0007\u000f[\u0001\ta2\f\u0017p\u0015;faR1!0`A\u0006\u0003\u001b\u0001\"aL>\n\u0005q\u0004$\u0001B+oSRDQA \nA\u0002}\faA^3si\u0016D\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015\u0001(A\u0004wSNLGo\u001c:\n\t\u0005%\u00111\u0001\u0002\u0007-\u0016\u0014H/\u001a=\t\u000b\t\u0013\u0002\u0019A \t\u000b\r\u0013\u0002\u0019A \u0002\u0015U\u0004H-\u0019;f'R,\u0007\u000fF\u0002{\u0003'AQA`\nA\u0002}\f!\u0002^1ck2\f'/[:f)\u0011\tI\"!\n\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b9\u0003\u0015!\u0018M\u00197f\u0013\u0011\t\u0019#!\b\u0003\u000bQ\u000b'\r\\3\t\u000b=$\u0002\u0019\u00019)\u000f\u0001\tI#!\u0010\u0002@A!\u00111FA\u001d\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012\u0001C:dC2\fGm\\2\u000b\t\u0005M\u0012QG\u0001\bi\u0006\\WM_8f\u0015\r\t9DK\u0001\u0007O&$\b.\u001e2\n\t\u0005m\u0012Q\u0006\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\u0012\u0011\u0011I\u0001\u0010\u0002>R#F\u0003\u0011!U\u0001Z8/ 1Qe&\u001cxN\\3sg\u0012KG.Z7nC\"\u0002(o\u001c9peRLwN\\\"p_BT\u0004E\u00127pCR\u0004S\b\t\u0019/k\u0019d\u0003EY3oK\u001aLGO\u000f\u0011GY>\fG\u000f\f\u0011d_N$(\b\t$m_\u0006$\b%\u0010\u00112]A2G\u0006\t8p\u000f\u0006lWm\u001d\u001e!\u0013:$\b%\u0010\u00112aAJ\u0003M\u0003\u0011!U\u0001\u0002\u0003E\u000f\u0011sk:\u0004\u0013\u000e^3sCRLg/\u001a\u0011hC6,\u0007e\u001c4!aJL7o\u001c8feN\u0004C-\u001b7f[6\f'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011!\u0003:\u0004\u0013\u000e^3sCRLg/\u001a\u0011hC6,\u0007e\u001c4!!JL7o\u001c8feN<\u0003\u0005Z5mK6l\u0017\rI5tAAd\u0017-_3eA=t\u0007\u0005\u001e5fA9,Go^8sW:\u0002\u0013J\u001c\u0011fC\u000eD\u0007E]8v]\u0012d\u0003E^3si&\u001cWm\u001d\u0011tS6,H\u000e^1oK>,8\u000f\\=!a2\f\u0017\u0010I1!e>,h\u000e\u001a\u0006!A)\u0002\u0003\u0005I8gAA\u0013\u0018n]8oKJ\u001cx\u0005\t3jY\u0016lW.\u0019\u0011xSRD\u0007\u0005\u001e5fSJ\u0004c.Z5hQ\n|WO]:-A\u001d,G\u000f^5oO\u0002\n\u0007\u0005]1z_\u001a4\u0007%Y2d_J$\u0017N\\4!i>\u0004s\u000f[3uQ\u0016\u0014\b%Z1dQ\u0002\u0002H.Y=fe\u0002\u001a\u0007n\\:fAQ|\u0007eY8pa\u0016\u0014\u0018\r^3!Q\rK#\u0002\t\u0011+A\u0001\u0002sN\u001d\u0011eK\u001a,7\r\u001e\u0015ES9\u0002\u0013I\u001a;fe\u0002\"\b.\u001a\u0011hC6,\u0007%[:!a2\f\u00170\u001a3-A\u0005\u0004c/\u001a:uKb\u0004\u0013\rZ8qiN\u0004\u0013\u000e^:!gR\u0014\u0018\r^3hs\u0002\u0012\u0017\u0010I2i_>\u001c\u0018N\\4!i\",\u0007\u0005[5hQ\u0016\u001cH\u000fI:d_JLgn\u001a\u0011tiJ\fG/Z4zA%t\u0007%\u001b;t\u0015\u0001\u0002#\u0006\t\u0011!I&\u0014Xm\u0019;!]\u0016Lw\r\u001b2pkJDwn\u001c3/AQC\u0017n\u001d\u0011dCJ\u0014\u0018.Z:!_:\u0004SO\u001c;jY\u0002*\u0017\u000e\u001e5fe\u0002\n\u0007\u0005\u001d:f[\u0011,g-\u001b8fI\u0002rW/\u001c2fe\u0002zg\rI4b[\u0016\u001c\b%[:!a2\f\u00170\u001a3!_J\u0004\u0013N\u001a\u0011o_:,\u0007e\u001c4!i\",\u0007E^3si&\u001cWm\u001d\u0006!A)\u0002\u0003\u0005I2iC:<W\r\t;iK&\u0014\be\u001d;sCR,w-\u001f\u0018\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003\u0005U1sC6,G/\u001a:t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003e_:~AB\u0014x\u000e]8si&|gnQ8paj\u0002c\t\\8biv\u0002d&\u000e4a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002\u0003K]8q_J$\u0018n\u001c8!_\u001a\u0004c/\u001a:uS\u000e,7\u000f\t;iCR\u00043\u000f^1si\u0002zW\u000f\u001e\u0011bg\u0002\u001awn\u001c9fe\u0006$xN]:!QUt\u0017NZ8s[2L\be]1na2,G-\u000b\u0018!\u00032$XM\u001d8bi&4X\r\\=-AY,'\u000f^5dKNT\u0001\u0005\t\u0016!A\u0001\u0002\u0003e\u001d;beRLgn\u001a\u0011xSRD\u0007%\u0019\u0011ti\u0006$Xo\u001d\u0011#G>|\u0007/\u001a:bi>\u0014(\u0005I:fi\u0002\"x\u000e\t\u0019!E\u0016<\u0017N\u001c\u0011bg\u0002\u001awn\u001c9fe\u0006$xN]:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003e_:~A\n,g.\u001a4jij\u0002c\t\\8bi\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t\"f]\u00164\u0017\u000e\u001e\u0011qCJ\fW.\u001a;fe\u00022wN\u001d\u0011qe&\u001cxN\\3sg\u001e\u0002C-\u001b7f[6\f\u0007eZ1nK:\u00023+Z3!7Fj&\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011!wNl\bmY8tij\u0002c\t\\8bi\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\bI\"pgR\u0004\u0003/\u0019:b[\u0016$XM\u001d\u0011g_J\u0004\u0003O]5t_:,'o]\u0014!I&dW-\\7bA\u001d\fW.\u001a\u0018!'\u0016,\u0007eW\u0019^\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003e_:~A:|w)Y7fg\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\bI'bq&lW/\u001c\u0011ok6\u0014WM\u001d\u0011pM\u0002:\u0017-\\3tAQ|\u0007EY3!a2\f\u00170\u001a3/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003e_:~AN,W\r\u001a1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001z\u0007\u000f^5p]\u0006d\u0007e]3fI\u00022wN\u001d\u0011uKN$\u0018N\\4!aV\u0014\bo\\:fg:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!'R\fG/Z:\u000bA\u0001R#\u0002\t\u0011+A\u0001\u00023p]?aG>|\u0007/\u001a:bi>\u0014(\bI%oi\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t+iK\u0002b\u0017\r^3ti\u0002\u001aH/\u0019;vgj\u00023m\\8qKJ\fGo\u001c:!QAJC\u0006I8sA\u0011,g-Z2u_J\u0004\u0003&M\u0015-A=4\u0007\u0005\u001e5fAY,'\u000f^3yA\u0005$\b\u0005\u001e5bi\u0002JG/\u001a:bi&|gN\f\u0006!A)R\u0001\u0005\t\u0016!A\u0001Z8/ 1d_>\u0004XM]1uS>t\u0007*[:u_JL(\bI7vi\u0006\u0014G.\u001a\u0018Rk\u0016,XmW%oiv\u0003'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011UQ\u0016\u0004c-\u001e7mA!L7\u000f^8ss\u0002zg\rI1!m\u0016\u0014H/\u001a=(A\r|w\u000e]3sCRLwN\u001c\u0011ti\u0006$Xo\u001d\u0011g_J\u0004C\u000f[3!O\u0006lWm\u001d\u0011qY\u0006LX\r\u001a\u0018\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003EU3ukJt7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!Aq\u0004c/\u001a:uKb\u0004c.Y7fA\u0001\u0002\u0003\u0005\t\u0011!y\u0002\u001awn\u001c9fe\u0006$\u0018n\u001c8!Q&\u001cHo\u001c:zA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002CP\u0003\u0011!U\u0001\u0002\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}\u0015\u0001\u0002#\u0006\t\u0011!y\u0002Z8/ 1oC6,'\bI*ue&tw\r\u0019\u0011}Am\u001cX\u0010Y2p_B,'/\u0019;j_:D\u0015n\u001d;pefT\u0004%U;fk\u0016\\\u0016J\u001c;^A\u0002b(\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AI+g-\u001a:f]\u000e,7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!Am\u000bT\f\t(po\u0006\\G\u0006I'/A\u0005sC\u0006\t\u0014!\u001b\u0006LH\u0006\t*/A5s\u0003\u0005K\u0019:sIJc\u0006I#w_2,H/[8oCJL\beZ1nKN\u0004\u0013M\u001c3!gB\fG/[1mA\rD\u0017m\\:/A9\u000bG/\u001e:fY\u0001\u001aT'\u000f\u00157geB\u0014\u0006\f\u00119eYj\u0003HM\u001d/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0007\rY>tK\u0016\fGn]8~\u0015\u0001\u0002#\u0006I.^Q\r|WN\f:ba\"$xN]=/C2<wN]5uQ6\u001chfZ3oKJL7M\f3z]\u0006l\u0017n\u0019\u0018XCR$8oQ1tG\u0006$W-\u000b\u0006!A)\u0002\u0003\r\u00191\u000bA\u0001Rs&\u0001\tQe&\u001cxN\\3sg\u0012KG.Z7nCB\u0011AJF\n\u0005-9\nI\u0005\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\u0005%|'BAA*\u0003\u0011Q\u0017M^1\n\t\u0005]\u0013Q\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003\u000b\"2bSA/\u0003?\n\t'a\u0019\u0002f!9a\b\u0007I\u0001\u0002\u0004y\u0004\"\u0002\"\u0019\u0001\u0004y\u0004\"B\"\u0019\u0001\u0004y\u0004b\u0002#\u0019!\u0003\u0005\r!\u0012\u0005\b\u0011b\u0001\n\u00111\u0001F\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\nTCAA6U\ry\u0014QN\u0016\u0003\u0003_\u0002B!!\u001d\u0002|5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0010\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002~\u0005M$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u0004*\u001aQ)!\u001c\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIU\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005M\u0005\u0003BAK\u00037k!!a&\u000b\t\u0005e\u0015\u0011K\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001e\u0006]%AB(cU\u0016\u001cG\u000f")
public class PrisonersDilemma
implements Generic {
    private final float proportionCoop;
    private final float benefit;
    private final float cost;
    private final int noGames;
    private final Random rnd;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static int $lessinit$greater$default$5() {
        return PrisonersDilemma$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return PrisonersDilemma$.MODULE$.$lessinit$greater$default$4();
    }

    public static float $lessinit$greater$default$3() {
        return PrisonersDilemma$.MODULE$.$lessinit$greater$default$3();
    }

    public static float $lessinit$greater$default$1() {
        return PrisonersDilemma$.MODULE$.$lessinit$greater$default$1();
    }

    public static int apply$default$5() {
        return PrisonersDilemma$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return PrisonersDilemma$.MODULE$.apply$default$4();
    }

    public static float apply$default$1() {
        return PrisonersDilemma$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    private Random rnd() {
        return this.rnd;
    }

    private final int COOPERATOR() {
        return 0;
    }

    private final int DEFECTOR() {
        return 1;
    }

    private final int PLAYSTEP() {
        return 0;
    }

    private final int UPDATESTEP() {
        return 1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            PrisonersDilemma.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable x$1 = (Function1 & Serializable)vertex -> {
            PrisonersDilemma.$anonfun$apply$2(this, vertex);
            return BoxedUnit.UNIT;
        };
        boolean x$2 = true;
        int x$3 = this.noGames;
        return graph.iterate((Function1<Vertex, BoxedUnit>)x$1, x$3, true);
    }

    public void playStep(Vertex vertex, float benefit, float cost) {
        Seq neighbourStatuses = vertex.messageQueue();
        int myStatus = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("cooperator", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        float payoff = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)((IterableOps)neighbourStatuses.map((Function1 & Serializable)neighStatus -> PrisonersDilemma.$anonfun$playStep$1(myStatus, BoxesRunTime.unboxToInt((Object)neighStatus)))).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToFloat((float)PrisonersDilemma.$anonfun$playStep$2(benefit, cost, x0$1)))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
        vertex.messageAllNeighbours(new Tuple2((Object)BoxesRunTime.boxToInteger((int)myStatus), (Object)BoxesRunTime.boxToFloat((float)payoff)), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        vertex.messageSelf(new Tuple2((Object)BoxesRunTime.boxToInteger((int)myStatus), (Object)BoxesRunTime.boxToFloat((float)payoff)), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        ((EntityVisitor)((Object)vertex)).setState("step", BoxesRunTime.boxToInteger((int)1));
    }

    public void updateStep(Vertex vertex) {
        Seq neighbourStatuses = vertex.messageQueue();
        int currentStatus = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("cooperator", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        int newStatus = ((Tuple2)neighbourStatuses.maxBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToFloat((float)PrisonersDilemma.$anonfun$updateStep$1(x0$1)), (Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$))._1$mcI$sp();
        ((EntityVisitor)((Object)vertex)).setState("cooperator", BoxesRunTime.boxToInteger((int)newStatus));
        Queue history = (Queue)((EntityVisitor)((Object)vertex)).getState("cooperationHistory", ((EntityVisitor)((Object)vertex)).getState$default$2());
        history.$plus$eq((Object)BoxesRunTime.boxToInteger((int)newStatus));
        if (newStatus == currentStatus) {
            vertex.voteToHalt();
        }
        vertex.messageAllNeighbours(BoxesRunTime.boxToInteger((int)newStatus), SchemaProviderInstances$.MODULE$.intSchemaProvider());
        ((EntityVisitor)((Object)vertex)).setState("step", BoxesRunTime.boxToInteger((int)0));
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.select((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "cooperationHistory"}));
    }

    public static final /* synthetic */ void $anonfun$apply$1(PrisonersDilemma $this, Vertex vertex) {
        ((EntityVisitor)((Object)vertex)).getOrSetState("cooperator", $this.rnd().nextFloat() < $this.proportionCoop ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)1), ((EntityVisitor)((Object)vertex)).getOrSetState$default$3());
        int cooperationStatus = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("cooperator", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        ((EntityVisitor)((Object)vertex)).setState("cooperationHistory", Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{cooperationStatus})));
        vertex.messageAllNeighbours(BoxesRunTime.boxToInteger((int)cooperationStatus), SchemaProviderInstances$.MODULE$.intSchemaProvider());
        ((EntityVisitor)((Object)vertex)).setState("step", BoxesRunTime.boxToInteger((int)0));
        ((EntityVisitor)((Object)vertex)).setState("name", vertex.name(vertex.name$default$1()));
    }

    public static final /* synthetic */ void $anonfun$apply$2(PrisonersDilemma $this, Vertex vertex) {
        int stepType;
        int n = stepType = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("step", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        switch (n) {
            case 0: {
                $this.playStep(vertex, $this.benefit, $this.cost);
                break;
            }
            case 1: {
                $this.updateStep(vertex);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$playStep$1(int myStatus$1, int neighStatus) {
        return new Tuple2.mcII.sp(myStatus$1, neighStatus);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ float $anonfun$playStep$2(float benefit$1, float cost$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int n = tuple2._1$mcI$sp();
            int n2 = tuple2._2$mcI$sp();
            if (0 == n && 0 == n2) {
                return benefit$1 - cost$1;
            }
        }
        if (tuple2 != null) {
            int n = tuple2._1$mcI$sp();
            int n3 = tuple2._2$mcI$sp();
            if (0 == n && 1 == n3) {
                return -cost$1;
            }
        }
        if (tuple2 != null) {
            int n = tuple2._1$mcI$sp();
            int n4 = tuple2._2$mcI$sp();
            if (1 == n && 0 == n4) {
                return benefit$1;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int n = tuple2._1$mcI$sp();
        int n5 = tuple2._2$mcI$sp();
        if (1 != n) throw new MatchError((Object)tuple2);
        if (1 != n5) throw new MatchError((Object)tuple2);
        return 0.0f;
    }

    public static final /* synthetic */ float $anonfun$updateStep$1(Tuple2 x0$1) {
        float score;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        float f = score = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        return f;
    }

    public PrisonersDilemma(float proportionCoop, float benefit, float cost, int noGames, int seed) {
        this.proportionCoop = proportionCoop;
        this.benefit = benefit;
        this.cost = cost;
        this.noGames = noGames;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
        this.rnd = seed == -1 ? new Random() : new Random(seed);
    }
}

