/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.dynamic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.dynamic.RandomWalk$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.View;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@Scaladoc(value="/**\n  * {s}`RandomWalk(walkLength: Int = 10, numWalks: Int = 1, seed: Long = -1)`\n  *    : Implements random walks on unweighted graph\n  *\n  *  This algorithm starts `numWalks` unbiased random walks from each node\n  *  and terminates them after the walks have reached `walkLength` nodes. The network is treated as directed and if a\n  *  vertex has no outgoing edges, the walk remains at this vertex for the remaining steps.\n  *\n  * ## Parameters\n  *\n  *  {s}`walkLength: Int = 10`\n  *    : maximum length of generated walks\n  *\n  *  {s}`numWalks: Int = 1`\n  *    : number of walks to start for each node\n  *\n  *  {s}`seed: Long`\n  *    : seed for the random number generator\n  *\n  * ```{note}\n  * Currently, results are non-deterministic even with fixed seed, likely due to non-deterministic message order.\n  * ```\n  *\n  * ## States\n  *\n  *  {s}`walks: Array[ArrayBuffer[String]]`: List of nodes for each random walk started from this vertex\n  *\n  * ## Returns\n  *\n  * | vertex 1          | vertex 2          | ... | vertex `walkLength` |\n  * | ----------------- | ----------------- | --- | ------------------- |\n  * | {s}`name: String` | {s}`name: String` | ... | {s}`name: String`   |\n  *\n  *  Each row of the table corresponds to a single random walk and columns correspond to the vertex at a given step\n  */")
@ScalaSignature(bytes="\u0006\u0005\r\u0005b\u0001B$I\u0001MC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tQ\u0002\u0011\t\u0011)A\u0005K\"A\u0011\u000e\u0001B\u0001B\u0003%!\u000eC\u0003n\u0001\u0011\u0005a\u000eC\u0004u\u0001\t\u0007I\u0011C;\t\rq\u0004\u0001\u0015!\u0003w\u0011\u0015i\b\u0001\"\u0005\u007f\u0011\u001d\tI\u0002\u0001C!\u00037Aq!!\u000e\u0001\t\u0003\n9dB\u0004\u0002d!C\t!!\u001a\u0007\r\u001dC\u0005\u0012AA4\u0011\u0019i7\u0002\"\u0001\u0002z!9\u0011\u0011D\u0006\u0005\u0002\u0005m\u0004\"CAB\u0017E\u0005I\u0011AAC\u0011%\tYjCI\u0001\n\u0003\t)\tC\u0005\u0002\u001e.\t\n\u0011\"\u0001\u0002 \u001a9\u00111U\u0006\u0002\"\u0005\u0015\u0006BB7\u0012\t\u0003\tIK\u0002\u0004\u0003z-\u0001%1\u0010\u0005\u000b\u0005\u000b\u001b\"Q3A\u0005\u0002\t\u001d\u0005B\u0003BE'\tE\t\u0015!\u0003\u0003\u0002\"Q!1A\n\u0003\u0016\u0004%\tA!\u0002\t\u0013\t\u001d1C!E!\u0002\u0013)\u0007BB7\u0014\t\u0003\u0011Y\tC\u0005\u0003\u0012M\t\t\u0011\"\u0001\u0003\u0014\"I!\u0011E\n\u0012\u0002\u0013\u0005!\u0011\u0015\u0005\n\u0005W\u0019\u0012\u0013!C\u0001\u0005SC\u0011B!\r\u0014\u0003\u0003%\tEa\r\t\u0013\t}2#!A\u0005\u0002\t\u0015\u0001\"\u0003B!'\u0005\u0005I\u0011\u0001BW\u0011%\u0011IeEA\u0001\n\u0003\u0012Y\u0005C\u0005\u0003ZM\t\t\u0011\"\u0001\u00032\"I!QM\n\u0002\u0002\u0013\u0005#Q\u0017\u0005\n\u0005W\u001a\u0012\u0011!C!\u0005[B\u0011Ba\u001c\u0014\u0003\u0003%\tE!\u001d\t\u0013\tM4#!A\u0005B\tev!\u0003B_\u0017\u0005\u0005\t\u0012\u0001B`\r%\u0011IhCA\u0001\u0012\u0003\u0011\t\r\u0003\u0004nM\u0011\u0005!1\u0019\u0005\n\u0005_2\u0013\u0011!C#\u0005cB\u0011\"!\u0007'\u0003\u0003%\tI!2\t\u0013\tMg%!A\u0005\u0002\nU\u0007\"\u0003BxM\u0005\u0005I\u0011\u0002By\r\u0019\t)m\u0003!\u0002H\"Q\u0011Q\u001e\u0017\u0003\u0016\u0004%\t!a<\t\u0015\t\u0005AF!E!\u0002\u0013\t\t\u0010\u0003\u0006\u0003\u00041\u0012)\u001a!C\u0001\u0005\u000bA\u0011Ba\u0002-\u0005#\u0005\u000b\u0011B3\t\r5dC\u0011\u0001B\u0005\u0011%\u0011\t\u0002LA\u0001\n\u0003\u0011\u0019\u0002C\u0005\u0003\"1\n\n\u0011\"\u0001\u0003$!I!1\u0006\u0017\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005ca\u0013\u0011!C!\u0005gA\u0011Ba\u0010-\u0003\u0003%\tA!\u0002\t\u0013\t\u0005C&!A\u0005\u0002\t\r\u0003\"\u0003B%Y\u0005\u0005I\u0011\tB&\u0011%\u0011I\u0006LA\u0001\n\u0003\u0011Y\u0006C\u0005\u0003f1\n\t\u0011\"\u0011\u0003h!I!1\u000e\u0017\u0002\u0002\u0013\u0005#Q\u000e\u0005\n\u0005_b\u0013\u0011!C!\u0005cB\u0011Ba\u001d-\u0003\u0003%\tE!\u001e\b\u0013\te8\"!A\t\u0002\tmh!CAc\u0017\u0005\u0005\t\u0012\u0001B\u007f\u0011\u0019iw\b\"\u0001\u0003\u0000\"I!qN \u0002\u0002\u0013\u0015#\u0011\u000f\u0005\n\u00033y\u0014\u0011!CA\u0007\u0003A\u0011Ba5@\u0003\u0003%\tia\u0004\t\u0013\t=x(!A\u0005\n\tE\b\"CB\u0010\u0017E\u0005I\u0011AAP\u0011%\u0011yoCA\u0001\n\u0013\u0011\tP\u0001\u0006SC:$w.\\,bY.T!!\u0013&\u0002\u000f\u0011Lh.Y7jG*\u00111\nT\u0001\bO\u0016tWM]5d\u0015\tie*\u0001\u0006bY\u001e|'/\u001b;i[NT!a\u0014)\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011!U\u0001\u0004G>l7\u0001A\n\u0004\u0001QS\u0006CA+Y\u001b\u00051&\"A,\u0002\u000bM\u001c\u0017\r\\1\n\u0005e3&AB!osJ+g\r\u0005\u0002\\E6\tAL\u0003\u0002^=\u0006I\u0011\r\\4pe&$\b.\u001c\u0006\u0003?\u0002\f\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003C:\u000b1!\u00199j\u0013\t\u0019GLA\u0004HK:,'/[2\u0002\u0015]\fGn\u001b'f]\u001e$\b\u000e\u0005\u0002VM&\u0011qM\u0016\u0002\u0004\u0013:$\u0018\u0001\u00038v[^\u000bGn[:\u0002\tM,W\r\u001a\t\u0003+.L!\u0001\u001c,\u0003\t1{gnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\t=\f(o\u001d\t\u0003a\u0002i\u0011\u0001\u0013\u0005\u0006I\u0012\u0001\r!\u001a\u0005\u0006Q\u0012\u0001\r!\u001a\u0005\bS\u0012\u0001\n\u00111\u0001k\u0003\r\u0011h\u000eZ\u000b\u0002mB\u0011qO_\u0007\u0002q*\u0011\u0011PV\u0001\u0005kRLG.\u0003\u0002|q\n1!+\u00198e_6\fAA\u001d8eA\u0005y1/\u001a7fGRtU-[4iE>,(\u000fF\u0002\u0000\u0003\u000b\u0001B!!\u0001\u0002\u00169!\u00111AA\u0003\u0019\u0001Aq!a\u0002\b\u0001\u0004\tI!\u0001\u0004wKJ$X\r\u001f\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u00020\u0002\u000fYL7/\u001b;pe&!\u00111CA\u0007\u0005\u00191VM\u001d;fq&!\u0011qCA\t\u0005\u0019IE\tV=qK\u0006)\u0011\r\u001d9msR!\u0011QDA\u0011!\u0011\ty\"!\r\u000f\t\u0005\r\u0011\u0011\u0005\u0005\b\u0003GA\u0001\u0019AA\u0013\u0003\u00159'/\u00199i!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016=\u0006IqM]1qQZLWm^\u0005\u0005\u0003_\tIC\u0001\tHe\u0006\u0004\b\u000eU3sgB,7\r^5wK&!\u00111GA\u0017\u0005\u00159%/\u00199i\u0003)!\u0018MY;mCJL7/\u001a\u000b\u0005\u0003s\t)\u0005\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\tyDX\u0001\u0006i\u0006\u0014G.Z\u0005\u0005\u0003\u0007\niDA\u0003UC\ndW\rC\u0004\u0002$%\u0001\r!!\n)\u000f\u0001\tI%!\u0018\u0002`A!\u00111JA-\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013\u0001C:dC2\fGm\\2\u000b\t\u0005M\u0013QK\u0001\bi\u0006\\WM_8f\u0015\r\t9\u0006U\u0001\u0007O&$\b.\u001e2\n\t\u0005m\u0013Q\n\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\u0012\u0011\u0011M\u0001\u000b@=R#F\u0003\u0011!U\u0001Z8/ 1SC:$w.\\,bY.Ds/\u00197l\u0019\u0016tw\r\u001e5;A%sG\u000fI\u001f!cAb\u0003E\\;n/\u0006d7n\u001d\u001e!\u0013:$\b%\u0010\u00112Y\u0001\u001aX-\u001a3;A1{gn\u001a\u0011>A5\n\u0014\u0006\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A%k\u0007\u000f\\3nK:$8\u000f\t:b]\u0012|W\u000eI<bY.\u001c\be\u001c8!k:<X-[4ii\u0016$\u0007e\u001a:ba\"T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t+iSN\u0004\u0013\r\\4pe&$\b.\u001c\u0011ti\u0006\u0014Ho\u001d\u0011a]Vlw+\u00197lg\u0002\u0004SO\u001c2jCN,G\r\t:b]\u0012|W\u000eI<bY.\u001c\bE\u001a:p[\u0002*\u0017m\u00195!]>$WM\u0003\u0011!U\u0001\u0002\u0013M\u001c3!i\u0016\u0014X.\u001b8bi\u0016\u001c\b\u0005\u001e5f[\u0002\ng\r^3sAQDW\rI<bY.\u001c\b\u0005[1wK\u0002\u0012X-Y2iK\u0012\u0004\u0003m^1mW2+gn\u001a;iA\u0002rw\u000eZ3t]\u0001\"\u0006.\u001a\u0011oKR<xN]6!SN\u0004CO]3bi\u0016$\u0007%Y:!I&\u0014Xm\u0019;fI\u0002\ng\u000e\u001a\u0011jM\u0002\n'\u0002\t\u0011+A\u00012XM\u001d;fq\u0002B\u0017m\u001d\u0011o_\u0002zW\u000f^4pS:<\u0007%\u001a3hKNd\u0003\u0005\u001e5fA]\fGn\u001b\u0011sK6\f\u0017N\\:!CR\u0004C\u000f[5tAY,'\u000f^3yA\u0019|'\u000f\t;iK\u0002\u0012X-\\1j]&tw\rI:uKB\u001chF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0002\u0016M]1nKR,'o\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y<bY.dUM\\4uQj\u0002\u0013J\u001c;!{\u0001\n\u0004\u0007\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A5\f\u00070[7v[\u0002bWM\\4uQ\u0002zg\rI4f]\u0016\u0014\u0018\r^3eA]\fGn[:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1ok6<\u0016\r\\6tu\u0001Je\u000e\u001e\u0011>AE\u0002'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011ok6\u0014WM\u001d\u0011pM\u0002:\u0018\r\\6tAQ|\u0007e\u001d;beR\u0004cm\u001c:!K\u0006\u001c\u0007\u000e\t8pI\u0016T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002\u001cX-\u001a3;A1{gn\u001a1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001\u001aX-\u001a3!M>\u0014\b\u0005\u001e5fAI\fg\u000eZ8nA9,XNY3sA\u001d,g.\u001a:bi>\u0014(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t1aAntw\u000e^3~\u0015\u0001\u0002#\u0006I\"veJ,g\u000e\u001e7zY\u0001\u0012Xm];miN\u0004\u0013M]3!]>tW\u0006Z3uKJl\u0017N\\5ti&\u001c\u0007%\u001a<f]\u0002:\u0018\u000e\u001e5!M&DX\r\u001a\u0011tK\u0016$G\u0006\t7jW\u0016d\u0017\u0010\t3vK\u0002\"x\u000e\t8p]6\"W\r^3s[&t\u0017n\u001d;jG\u0002jWm]:bO\u0016\u0004sN\u001d3fe:R\u0001\u0005\t\u0016!A\u0002\u0004'\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AM#\u0018\r^3t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?ao\u0006d7n\u001d\u001e!\u0003J\u0014\u0018-_.BeJ\f\u0017PQ;gM\u0016\u00148l\u0015;sS:<W,\u00181;A1K7\u000f\u001e\u0011pM\u0002rw\u000eZ3tA\u0019|'\u000fI3bG\"\u0004#/\u00198e_6\u0004s/\u00197lAM$\u0018M\u001d;fI\u00022'o\\7!i\"L7\u000f\t<feR,\u0007P\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005 \u0011wKJ$X\r\u001f\u00112A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u0010\t<feR,\u0007\u0010\t\u001a!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001b\bE\f\u0018/Aq\u0004c/\u001a:uKb\u0004\u0003m^1mW2+gn\u001a;iA\u0002b(\u0002\t\u0011+Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}A5jS\u0006\t?![5jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}\u0015\u0001\u0002#\u0006\t?!wNl\bM\\1nKj\u00023\u000b\u001e:j]\u001e\u0004\u0007\u0005 \u0011|gv\u0004g.Y7fu\u0001\u001aFO]5oO\u0002\u0004C\u0010\t\u0018/]\u0001b\be_:~A:\fW.\u001a\u001e!'R\u0014\u0018N\\4aA\u0001\u0002CP\u0003\u0011!U)\u0001\u0003E\u000b\u0011!\u000b\u0006\u001c\u0007\u000e\t:po\u0002zg\r\t;iK\u0002\"\u0018M\u00197fA\r|'O]3ta>tGm\u001d\u0011u_\u0002\n\u0007e]5oO2,\u0007E]1oI>l\u0007e^1mW\u0002\ng\u000e\u001a\u0011d_2,XN\\:!G>\u0014(/Z:q_:$\u0007\u0005^8!i\",\u0007E^3si\u0016D\b%\u0019;!C\u0002:\u0017N^3oAM$X\r\u001d\u0006!A)z\u0013A\u0003*b]\u0012|WnV1mWB\u0011\u0001oC\n\u0005\u0017Q\u000bI\u0007\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\u0005%|'BAA:\u0003\u0011Q\u0017M^1\n\t\u0005]\u0014Q\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003K\"ra\\A?\u0003\u007f\n\t\tC\u0004e\u001bA\u0005\t\u0019A3\t\u000f!l\u0001\u0013!a\u0001K\"9\u0011.\u0004I\u0001\u0002\u0004Q\u0017aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d%fA3\u0002\n.\u0012\u00111\u0012\t\u0005\u0003\u001b\u000b9*\u0004\u0002\u0002\u0010*!\u0011\u0011SAJ\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0016Z\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI*a$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001aTCAAQU\rQ\u0017\u0011\u0012\u0002\b\u001b\u0016\u001c8/Y4f+\u0011\t9+!-\u0014\u0005E!FCAAV!\u0015\ti+EAX\u001b\u0005Y\u0001\u0003BA\u0002\u0003c#q!a-\u0012\u0005\u0004\t)L\u0001\u0005WKJ$X\r_%E#\u0011\t9,!0\u0011\u0007U\u000bI,C\u0002\u0002<Z\u0013qAT8uQ&tw\rE\u0002V\u0003\u007fK1!!1W\u0005\r\te._\u0015\u0004#1\u001a\"\u0001D*u_J,W*Z:tC\u001e,W\u0003BAe\u0003\u001f\u001cr\u0001LAf\u0003#\f9\u000eE\u0003\u0002.F\ti\r\u0005\u0003\u0002\u0004\u0005=GaBAZY\t\u0007\u0011Q\u0017\t\u0004+\u0006M\u0017bAAk-\n9\u0001K]8ek\u000e$\b\u0003BAm\u0003StA!a7\u0002f:!\u0011Q\\Ar\u001b\t\tyNC\u0002\u0002bJ\u000ba\u0001\u0010:p_Rt\u0014\"A,\n\u0007\u0005\u001dh+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u00141\u001e\u0006\u0004\u0003O4\u0016\u0001\u00028b[\u0016,\"!!=\u0011\t\u0005M\u00181 \b\u0005\u0003k\f9\u0010E\u0002\u0002^ZK1!!?W\u0003\u0019\u0001&/\u001a3fM&!\u0011Q`A\u0000\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011 ,\u0002\u000b9\fW.\u001a\u0011\u0002\r]\fGn[%E+\u0005)\u0017aB<bY.LE\t\t\u000b\u0007\u0005\u0017\u0011iAa\u0004\u0011\u000b\u00055F&!4\t\u000f\u00055\u0018\u00071\u0001\u0002r\"1!1A\u0019A\u0002\u0015\fAaY8qsV!!Q\u0003B\u000e)\u0019\u00119B!\b\u0003 A)\u0011Q\u0016\u0017\u0003\u001aA!\u00111\u0001B\u000e\t\u001d\t\u0019L\rb\u0001\u0003kC\u0011\"!<3!\u0003\u0005\r!!=\t\u0011\t\r!\u0007%AA\u0002\u0015\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0003&\t%RC\u0001B\u0014U\u0011\t\t0!#\u0005\u000f\u0005M6G1\u0001\u00026\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T\u0003BAC\u0005_!q!a-5\u0005\u0004\t),A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005k\u0001BAa\u000e\u0003>5\u0011!\u0011\b\u0006\u0005\u0005w\t\t(\u0001\u0003mC:<\u0017\u0002BA\u007f\u0005s\tA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002>\n\u0015\u0003\u0002\u0003B$o\u0005\u0005\t\u0019A3\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011i\u0005\u0005\u0004\u0003P\tU\u0013QX\u0007\u0003\u0005#R1Aa\u0015W\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005/\u0012\tF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B/\u0005G\u00022!\u0016B0\u0013\r\u0011\tG\u0016\u0002\b\u0005>|G.Z1o\u0011%\u00119%OA\u0001\u0002\u0004\ti,\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B\u001b\u0005SB\u0001Ba\u0012;\u0003\u0003\u0005\r!Z\u0001\tQ\u0006\u001c\bnQ8eKR\tQ-\u0001\u0005u_N#(/\u001b8h)\t\u0011)$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005;\u00129\bC\u0005\u0003Hu\n\t\u00111\u0001\u0002>\nYq+\u00197l\u001b\u0016\u001c8/Y4f+\u0011\u0011iHa!\u0014\u000fM\u0011y(!5\u0002XB)\u0011QV\t\u0003\u0002B!\u00111\u0001BB\t\u001d\t\u0019l\u0005b\u0001\u0003k\u000b\u0001b]8ve\u000e,\u0017\nR\u000b\u0003\u0005\u0003\u000b\u0011b]8ve\u000e,\u0017\n\u0012\u0011\u0015\r\t5%q\u0012BI!\u0015\tik\u0005BA\u0011\u001d\u0011)\t\u0007a\u0001\u0005\u0003CaAa\u0001\u0019\u0001\u0004)W\u0003\u0002BK\u00057#bAa&\u0003\u001e\n}\u0005#BAW'\te\u0005\u0003BA\u0002\u00057#q!a-\u001a\u0005\u0004\t)\fC\u0005\u0003\u0006f\u0001\n\u00111\u0001\u0003\u001a\"A!1A\r\u0011\u0002\u0003\u0007Q-\u0006\u0003\u0003$\n\u001dVC\u0001BSU\u0011\u0011\t)!#\u0005\u000f\u0005M&D1\u0001\u00026V!\u0011Q\u0011BV\t\u001d\t\u0019l\u0007b\u0001\u0003k#B!!0\u00030\"A!q\t\u0010\u0002\u0002\u0003\u0007Q\r\u0006\u0003\u0003^\tM\u0006\"\u0003B$A\u0005\u0005\t\u0019AA_)\u0011\u0011)Da.\t\u0011\t\u001d\u0013%!AA\u0002\u0015$BA!\u0018\u0003<\"I!q\t\u0013\u0002\u0002\u0003\u0007\u0011QX\u0001\f/\u0006d7.T3tg\u0006<W\rE\u0002\u0002.\u001a\u001aBA\n+\u0002jQ\u0011!qX\u000b\u0005\u0005\u000f\u0014i\r\u0006\u0004\u0003J\n='\u0011\u001b\t\u0006\u0003[\u001b\"1\u001a\t\u0005\u0003\u0007\u0011i\rB\u0004\u00024&\u0012\r!!.\t\u000f\t\u0015\u0015\u00061\u0001\u0003L\"1!1A\u0015A\u0002\u0015\fq!\u001e8baBd\u00170\u0006\u0003\u0003X\n\u001dH\u0003\u0002Bm\u0005S\u0004R!\u0016Bn\u0005?L1A!8W\u0005\u0019y\u0005\u000f^5p]B1QK!9\u0003f\u0016L1Aa9W\u0005\u0019!V\u000f\u001d7feA!\u00111\u0001Bt\t\u001d\t\u0019L\u000bb\u0001\u0003kC\u0011Ba;+\u0003\u0003\u0005\rA!<\u0002\u0007a$\u0003\u0007E\u0003\u0002.N\u0011)/\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003tB!!q\u0007B{\u0013\u0011\u00119P!\u000f\u0003\r=\u0013'.Z2u\u00031\u0019Fo\u001c:f\u001b\u0016\u001c8/Y4f!\r\tikP\n\u0005\u007fQ\u000bI\u0007\u0006\u0002\u0003|V!11AB\u0005)\u0019\u0019)aa\u0003\u0004\u000eA)\u0011Q\u0016\u0017\u0004\bA!\u00111AB\u0005\t\u001d\t\u0019L\u0011b\u0001\u0003kCq!!<C\u0001\u0004\t\t\u0010\u0003\u0004\u0003\u0004\t\u0003\r!Z\u000b\u0005\u0007#\u0019i\u0002\u0006\u0003\u0004\u0014\r]\u0001#B+\u0003\\\u000eU\u0001CB+\u0003b\u0006EX\rC\u0005\u0003l\u000e\u000b\t\u00111\u0001\u0004\u001aA)\u0011Q\u0016\u0017\u0004\u001cA!\u00111AB\u000f\t\u001d\t\u0019l\u0011b\u0001\u0003k\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004")
public class RandomWalk
implements Generic {
    private final int walkLength;
    private final int numWalks;
    private final Random rnd;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static long $lessinit$greater$default$3() {
        return RandomWalk$.MODULE$.$lessinit$greater$default$3();
    }

    public static long apply$default$3() {
        return RandomWalk$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return RandomWalk$.MODULE$.apply$default$2();
    }

    public static int apply$default$1() {
        return RandomWalk$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    public Random rnd() {
        return this.rnd;
    }

    public Object selectNeighbour(Vertex vertex) {
        Object object;
        View<Object> neighbours = vertex.outNeighbours();
        if (neighbours.isEmpty()) {
            object = vertex.ID();
        } else {
            int i = this.rnd().nextInt(neighbours.size());
            object = ((Tuple2)((IterableOnceOps)neighbours.zipWithIndex()).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RandomWalk.$anonfun$selectNeighbour$1(i, x$1))).get())._1();
        }
        return object;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            RandomWalk.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            RandomWalk.$anonfun$apply$4(this, vertex);
            return BoxedUnit.UNIT;
        }, this.walkLength, true).step((Function1 & Serializable)vertex -> {
            RandomWalk.$anonfun$apply$6(vertex);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        IndexedSeq steps = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.walkLength).map((Function1 & Serializable)x$2 -> RandomWalk.$anonfun$tabularise$1(BoxesRunTime.unboxToInt((Object)x$2)));
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            RandomWalk.$anonfun$tabularise$2(steps, vertex);
            return BoxedUnit.UNIT;
        }).select((Seq<String>)steps).explode((Seq<String>)steps);
    }

    public static final /* synthetic */ boolean $anonfun$selectNeighbour$1(int i$1, Tuple2 x$1) {
        return x$1._2$mcI$sp() == i$1;
    }

    public static final /* synthetic */ void $anonfun$apply$1(RandomWalk $this, Vertex vertex) {
        Vector walks = (Vector)package$.MODULE$.Vector().fill($this.numWalks, (Function0 & Serializable)() -> ArrayBuffer$.MODULE$.empty());
        ((EntityVisitor)((Object)vertex)).setState("walks", walks);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), $this.numWalks).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)walkID -> vertex.messageSelf(new WalkMessage<Object>(vertex.ID(), walkID), SchemaProviderInstances$.MODULE$.genericSchemaProvider()));
    }

    public static final /* synthetic */ void $anonfun$apply$4(RandomWalk $this, Vertex vertex) {
        vertex.messageQueue().foreach((Function1 & Serializable)x0$1 -> {
            Buffer buffer;
            Message message = x0$1;
            if (message instanceof WalkMessage) {
                WalkMessage walkMessage = (WalkMessage)message;
                Object source = walkMessage.sourceID();
                int walkID = walkMessage.walkID();
                vertex.messageVertex(source, new StoreMessage(vertex.name(vertex.name$default$1()), walkID), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                vertex.messageVertex($this.selectNeighbour(vertex), new WalkMessage(source, walkID), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                buffer = BoxedUnit.UNIT;
            } else if (message instanceof StoreMessage) {
                StoreMessage storeMessage = (StoreMessage)message;
                String name = storeMessage.name();
                int walkID = storeMessage.walkID();
                Vector walks = (Vector)((EntityVisitor)((Object)vertex)).getState("walks", ((EntityVisitor)((Object)vertex)).getState$default$2());
                buffer = ((Buffer)walks.apply(walkID)).append((Object)name);
            } else {
                throw new MatchError((Object)message);
            }
            return buffer;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$6(Vertex vertex) {
        vertex.messageQueue().foreach((Function1 & Serializable)x0$2 -> {
            BoxedUnit boxedUnit;
            Message message = x0$2;
            if (message instanceof WalkMessage) {
                boxedUnit = BoxedUnit.UNIT;
            } else if (message instanceof StoreMessage) {
                StoreMessage storeMessage = (StoreMessage)message;
                String name = storeMessage.name();
                int walkID = storeMessage.walkID();
                Vector walks = (Vector)((EntityVisitor)((Object)vertex)).getState("walks", ((EntityVisitor)((Object)vertex)).getState$default$2());
                boxedUnit = ((Buffer)walks.apply(walkID)).append((Object)name);
            } else {
                throw new MatchError((Object)message);
            }
            return boxedUnit;
        });
    }

    public static final /* synthetic */ String $anonfun$tabularise$1(int x$2) {
        return new StringBuilder(7).append("vertex ").append(x$2).toString();
    }

    public static final /* synthetic */ void $anonfun$tabularise$3(Vertex vertex$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String step = (String)tuple2._1();
        Vector nodesForThatStep = (Vector)tuple2._2();
        ((EntityVisitor)((Object)vertex$4)).setState(step, nodesForThatStep);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$tabularise$2(IndexedSeq steps$1, Vertex vertex) {
        ((IterableOnceOps)steps$1.zip((IterableOnce)((IterableOps)((EntityVisitor)((Object)vertex)).getState("walks", ((EntityVisitor)((Object)vertex)).getState$default$2())).transpose(Predef$.MODULE$.$conforms()))).foreach((Function1 & Serializable)x0$1 -> {
            RandomWalk.$anonfun$tabularise$3(vertex, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public RandomWalk(int walkLength, int numWalks, long seed) {
        this.walkLength = walkLength;
        this.numWalks = numWalks;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
        this.rnd = seed != -1L ? new Random(seed) : new Random();
    }

    public static abstract class Message<VertexID> {
    }

    public static class StoreMessage<VertexID>
    extends Message<VertexID>
    implements Product,
    Serializable {
        private final String name;
        private final int walkID;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String name() {
            return this.name;
        }

        public int walkID() {
            return this.walkID;
        }

        public <VertexID> StoreMessage<VertexID> copy(String name, int walkID) {
            return new StoreMessage<VertexID>(name, walkID);
        }

        public <VertexID> String copy$default$1() {
            return this.name();
        }

        public <VertexID> int copy$default$2() {
            return this.walkID();
        }

        public String productPrefix() {
            return "StoreMessage";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.name();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.walkID());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StoreMessage;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "name";
                    break;
                }
                case 1: {
                    string = "walkID";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.walkID());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StoreMessage)) return false;
            boolean bl = true;
            if (!bl) return false;
            StoreMessage storeMessage = (StoreMessage)x$1;
            if (this.walkID() != storeMessage.walkID()) return false;
            String string = this.name();
            String string2 = storeMessage.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!storeMessage.canEqual(this)) return false;
            return true;
        }

        public StoreMessage(String name, int walkID) {
            this.name = name;
            this.walkID = walkID;
            Product.$init$((Product)this);
        }
    }

    public static class WalkMessage<VertexID>
    extends Message<VertexID>
    implements Product,
    Serializable {
        private final VertexID sourceID;
        private final int walkID;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public VertexID sourceID() {
            return this.sourceID;
        }

        public int walkID() {
            return this.walkID;
        }

        public <VertexID> WalkMessage<VertexID> copy(VertexID sourceID, int walkID) {
            return new WalkMessage<VertexID>(sourceID, walkID);
        }

        public <VertexID> VertexID copy$default$1() {
            return this.sourceID();
        }

        public <VertexID> int copy$default$2() {
            return this.walkID();
        }

        public String productPrefix() {
            return "WalkMessage";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.sourceID();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.walkID());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof WalkMessage;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "sourceID";
                    break;
                }
                case 1: {
                    string = "walkID";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.sourceID()));
            n = Statics.mix((int)n, (int)this.walkID());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof WalkMessage)) return false;
            boolean bl = true;
            if (!bl) return false;
            WalkMessage walkMessage = (WalkMessage)x$1;
            if (this.walkID() != walkMessage.walkID()) return false;
            if (!BoxesRunTime.equals(this.sourceID(), walkMessage.sourceID())) return false;
            if (!walkMessage.canEqual(this)) return false;
            return true;
        }

        public WalkMessage(VertexID sourceID, int walkID) {
            this.sourceID = sourceID;
            this.walkID = walkID;
            Product.$init$((Product)this);
        }
    }
}

