/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.community;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.algorithms.generic.community.LPA$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;
import scala.util.Random$;

@Scaladoc(value="/**\n  * {s}`LPA(weight:String = \"\", maxIter:Int = 500, seed:Long = -1)`\n  *    : run synchronous label propagation based community detection\n  *\n  *   LPA returns the communities of the constructed graph as detected by synchronous label propagation.\n  *   Every vertex is assigned an initial label at random. Looking at the labels of its neighbours, a probability is assigned\n  *   to observed labels following an increasing function then the vertex\u2019s label is updated with the label with the highest\n  *   probability. If the new label is the same as the current label, the vertex votes to halt. This process iterates until\n  *   all vertex labels have converged. The algorithm is synchronous since every vertex updates its label at the same time.\n  *\n  * ## Parameters\n  *\n  *   {s}`weight: String = \"\"`\n  *    : Edge weight property. To be specified in case of weighted graph.\n  *\n  *   {s}`tieBreaker: TieBreaker = MinTieBreak`\n  *    : rule for breaking ties between equally weighted neighbourhood labels. Default is to pick the minimum valued label.\n  *\n  *   {s}`maxIter: Int = 500`\n  *    : Maximum iterations for algorithm to run.\n  *\n  *   {s}`seed: Long`\n  *    : Value used for the random selection, can be set to ensure same result is returned per run.\n  *      If not specified, it will generate a random seed.\n  *\n  *    {s}`stickinessProb: Float`\n  *    : Probability that regardless of the tiebreak algorithm used, a vertex will just keep its previous label.\n  *\n  * ## States\n  *\n  *    {s}`community: Long`\n  *      : The ID of the community the vertex belongs to\n  *\n  * ## Returns\n  *\n  *  | vertex name       | community label      |\n  *  | ----------------- | -------------------- |\n  *  | {s}`name: String` | {s}`community: Long` |\n  *\n  * ```{note}\n  *   This implementation of LPA incorporates probabilistic elements which makes it\n  *   non-deterministic; The returned communities may differ on multiple executions.\n  *   Which is why you may want to set the seed if testing.\n  * ```\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.community.SLPA), [](com.raphtory.algorithms.temporal.community.MultilayerLPA)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\r}f\u0001\u00020`\u0001)D\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\t}\u0002\u0011\t\u0011)A\u0005\u007f\"Q!Q\u0010\u0001\u0003\u0002\u0003\u0006IAa \t\u0015\t\u001d\u0005A!A!\u0002\u0013\u0011\t\u0001\u0003\u0006\u0003\f\u0002\u0011\t\u0011)A\u0005\u0003\u0003C!ba\u001a\u0001\u0005\u0007\u0005\u000b1BB5\u0011\u001d\t9\u0004\u0001C\u0001\u0007_B\u0011Ba;\u0001\u0005\u0004%Ia!!\t\u0011\r\r\u0005\u0001)A\u0005\u0005[D\u0011B!9\u0001\u0005\u0004%Ia!\"\t\u0011\r\u001d\u0005\u0001)A\u0005\u0005\u007fBq!a\u000f\u0001\t\u0003\u001aIiB\u0004\u0002\u0018}C\t!!\u0007\u0007\ry{\u0006\u0012AA\u000f\u0011\u001d\t9D\u0004C\u0001\u0003sAq!a\u000f\u000f\t\u0003\ti\u0004C\u0005\u0003\u000e:\t\n\u0011\"\u0001\u0003\u0010\"I!q\u0013\b\u0012\u0002\u0013\u0005!\u0011\u0014\u0005\n\u0005Cs\u0011\u0013!C\u0001\u0005GC\u0011Ba+\u000f#\u0003%\tA!,\t\u0013\tUf\"%A\u0005\u0002\t]\u0006b\u0002B`\u001d\u0011\u0005!\u0011\u0019\u0004\n\u0003sr\u0001\u0013aI\u0011\u0003wBq!! \u0018\r\u0003\tyH\u0002\u0004\u0003^9\u0001%q\f\u0005\b\u0003oIB\u0011\u0001B1\u0011\u001d\ti(\u0007C!\u0005KB\u0011\"!5\u001a\u0003\u0003%\tA!\u0019\t\u0013\u0005=\u0018$!A\u0005B\u0005E\b\"CA\u007f3\u0005\u0005I\u0011AA\u0000\u0011%\u00119!GA\u0001\n\u0003\u0011Y\u0007C\u0005\u0003\u0010e\t\t\u0011\"\u0011\u0003\u0012!I!qD\r\u0002\u0002\u0013\u0005!q\u000e\u0005\n\u0005WI\u0012\u0011!C!\u0005gB\u0011B!\r\u001a\u0003\u0003%\tEa\r\t\u0013\tU\u0012$!A\u0005B\t]\u0002\"\u0003B\u001d3\u0005\u0005I\u0011\tB<\u000f%\u0011IPDA\u0001\u0012\u0003\u0011YPB\u0005\u0003^9\t\t\u0011#\u0001\u0003~\"9\u0011qG\u0014\u0005\u0002\r-\u0001\"\u0003B\u001bO\u0005\u0005IQ\tB\u001c\u0011%\tYdJA\u0001\n\u0003\u0013\t\u0007C\u0005\u0004\u000e\u001d\n\t\u0011\"!\u0004\u0010!I1QC\u0014\u0002\u0002\u0013%1q\u0003\u0004\u0007\u0005\u007fq\u0001I!\u0011\t\u000f\u0005]R\u0006\"\u0001\u0003D!9\u0011QP\u0017\u0005B\t\u001d\u0003\"CAi[\u0005\u0005I\u0011\u0001B\"\u0011%\ty/LA\u0001\n\u0003\n\t\u0010C\u0005\u0002~6\n\t\u0011\"\u0001\u0002\u0000\"I!qA\u0017\u0002\u0002\u0013\u0005!Q\n\u0005\n\u0005\u001fi\u0013\u0011!C!\u0005#A\u0011Ba\b.\u0003\u0003%\tA!\u0015\t\u0013\t-R&!A\u0005B\tU\u0003\"\u0003B\u0019[\u0005\u0005I\u0011\tB\u001a\u0011%\u0011)$LA\u0001\n\u0003\u00129\u0004C\u0005\u0003:5\n\t\u0011\"\u0011\u0003Z\u001dI1q\u0004\b\u0002\u0002#\u00051\u0011\u0005\u0004\n\u0005\u007fq\u0011\u0011!E\u0001\u0007GAq!a\u000e<\t\u0003\u00199\u0003C\u0005\u00036m\n\t\u0011\"\u0012\u00038!I\u00111H\u001e\u0002\u0002\u0013\u0005%1\t\u0005\n\u0007\u001bY\u0014\u0011!CA\u0007SA\u0011b!\u0006<\u0003\u0003%Iaa\u0006\u0007\r\u0005-f\u0002QAW\u0011)\tI,\u0011BK\u0002\u0013\u0005\u00111\u0018\u0005\u000b\u0003\u0007\f%\u0011#Q\u0001\n\u0005u\u0006bBA\u001c\u0003\u0012\u0005\u0011Q\u0019\u0005\b\u0003{\nE\u0011IAf\u0011%\t\t.QA\u0001\n\u0003\t\u0019\u000eC\u0005\u0002X\u0006\u000b\n\u0011\"\u0001\u0002Z\"I\u0011q^!\u0002\u0002\u0013\u0005\u0013\u0011\u001f\u0005\n\u0003{\f\u0015\u0011!C\u0001\u0003\u007fD\u0011Ba\u0002B\u0003\u0003%\tA!\u0003\t\u0013\t=\u0011)!A\u0005B\tE\u0001\"\u0003B\u0010\u0003\u0006\u0005I\u0011\u0001B\u0011\u0011%\u0011Y#QA\u0001\n\u0003\u0012i\u0003C\u0005\u00032\u0005\u000b\t\u0011\"\u0011\u00034!I!QG!\u0002\u0002\u0013\u0005#q\u0007\u0005\n\u0005s\t\u0015\u0011!C!\u0005w9\u0011b!\f\u000f\u0003\u0003E\taa\f\u0007\u0013\u0005-f\"!A\t\u0002\rE\u0002bBA\u001c%\u0012\u00051\u0011\b\u0005\n\u0005k\u0011\u0016\u0011!C#\u0005oA\u0011\"a\u000fS\u0003\u0003%\tia\u000f\t\u0013\r5!+!A\u0005\u0002\u000e}\u0002\"CB\u000b%\u0006\u0005I\u0011BB\f\u0011%\u0019IEDI\u0001\n\u0003\u0019Y\u0005C\u0005\u0004P9\t\n\u0011\"\u0001\u0004R!I1Q\u000b\b\u0012\u0002\u0013\u00051q\u000b\u0005\n\u00077r\u0011\u0013!C\u0001\u0007;B\u0011b!\u0019\u000f#\u0003%\taa\u0019\t\u0013\rUa\"!A\u0005\n\r]!a\u0001'Q\u0003*\u0011\u0001-Y\u0001\nG>lW.\u001e8jifT!AY2\u0002\u000f\u001d,g.\u001a:jG*\u0011A-Z\u0001\u000bC2<wN]5uQ6\u001c(B\u00014h\u0003!\u0011\u0018\r\u001d5u_JL(\"\u00015\u0002\u0007\r|Wn\u0001\u0001\u0016\u0007-\u001cig\u0005\u0002\u0001YB\u0011QN\\\u0007\u0002C&\u0011q.\u0019\u0002\t\u001d>$W\rT5ti\u00061q/Z5hQR\u0004\"A]>\u000f\u0005ML\bC\u0001;x\u001b\u0005)(B\u0001<j\u0003\u0019a$o\\8u})\t\u00010A\u0003tG\u0006d\u0017-\u0003\u0002{o\u00061\u0001K]3eK\u001aL!\u0001`?\u0003\rM#(/\u001b8h\u0015\tQx/\u0001\u0006uS\u0016\u0014%/Z1lKJ\u00042!!\u0001\u0018\u001d\r\t\u0019!\u0004\b\u0005\u0003\u000b\t)B\u0004\u0003\u0002\b\u0005Ma\u0002BA\u0005\u0003#qA!a\u0003\u0002\u00109\u0019A/!\u0004\n\u0003!L!AZ4\n\u0005\u0011,\u0017B\u00012d\u0013\t\u0001\u0017-A\u0002M!\u0006\u00032!a\u0007\u000f\u001b\u0005y6#\u0002\b\u0002 \u0005\u001d\u0002\u0003BA\u0011\u0003Gi\u0011a^\u0005\u0004\u0003K9(AB!osJ+g\r\u0005\u0003\u0002*\u0005MRBAA\u0016\u0015\u0011\ti#a\f\u0002\u0005%|'BAA\u0019\u0003\u0011Q\u0017M^1\n\t\u0005U\u00121\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005e\u0011!B1qa2LX\u0003BA \u0003\u0013\"B\"!\u0011\u0002r\u0005M$1\u0010BC\u0005\u0013#B!a\u0011\u0002\\A)\u00111\u0004\u0001\u0002FA!\u0011qIA%\u0019\u0001!q!a\u0013\u0011\u0005\u0004\tiEA\u0001U#\u0011\ty%!\u0016\u0011\t\u0005\u0005\u0012\u0011K\u0005\u0004\u0003':(a\u0002(pi\"Lgn\u001a\t\u0005\u0003C\t9&C\u0002\u0002Z]\u00141!\u00118z\u0011%\ti\u0006EA\u0001\u0002\b\ty&\u0001\u0006fm&$WM\\2fII\u0002b!!\u0019\u0002l\u0005\u0015c\u0002BA2\u0003Or1\u0001^A3\u0013\u0005A\u0018bAA5o\u00069\u0001/Y2lC\u001e,\u0017\u0002BA7\u0003_\u0012qAT;nKJL7MC\u0002\u0002j]Dq\u0001\u001d\t\u0011\u0002\u0003\u0007\u0011\u000f\u0003\u0005\u007f!A\u0005\t\u0019AA;!\r\t9hF\u0007\u0002\u001d\tQA+[3Ce\u0016\f7.\u001a:\u0014\u0007]\ty\"A\u0006dQ>|7/\u001a'bE\u0016dGCBAA\u0003\u000f\u000b\t\n\u0005\u0003\u0002\"\u0005\r\u0015bAACo\n!Aj\u001c8h\u0011\u001d\tI\t\u0007a\u0001\u0003\u0017\u000b!\u0002]8tg2\u000b'-\u001a7t!\u0019\t\t'!$\u0002\u0002&!\u0011qRA8\u0005\u0011a\u0015n\u001d;\t\u000f\u0005M\u0005\u00041\u0001\u0002\u0016\u00061a/\u001a:uKb\u0004B!a&\u0002&6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*A\u0004wSNLGo\u001c:\u000b\t\u0005}\u0015\u0011U\u0001\tC:\fG._:jg*\u0019\u00111U3\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002(\u0006e%A\u0002,feR,\u00070\u000b\u0003\u0018\u00036J\"AD\"vgR|W\u000eV5f\u0005J,\u0017m[\n\n\u0003\u0006}\u0011QOAX\u0003k\u0003B!!\t\u00022&\u0019\u00111W<\u0003\u000fA\u0013x\u000eZ;diB!\u0011\u0011MA\\\u0013\u0011\t)$a\u001c\u0002\u0003\u0019,\"!!0\u0011\u0015\u0005\u0005\u0012qXAF\u0003+\u000b\t)C\u0002\u0002B^\u0014\u0011BR;oGRLwN\u001c\u001a\u0002\u0005\u0019\u0004C\u0003BAd\u0003\u0013\u00042!a\u001eB\u0011\u001d\tI\f\u0012a\u0001\u0003{#b!!!\u0002N\u0006=\u0007bBAE\u000b\u0002\u0007\u00111\u0012\u0005\b\u0003'+\u0005\u0019AAK\u0003\u0011\u0019w\u000e]=\u0015\t\u0005\u001d\u0017Q\u001b\u0005\n\u0003s3\u0005\u0013!a\u0001\u0003{\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\\*\"\u0011QXAoW\t\ty\u000e\u0005\u0003\u0002b\u0006-XBAAr\u0015\u0011\t)/a:\u0002\u0013Ut7\r[3dW\u0016$'bAAuo\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00181\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002tB!\u0011Q_A~\u001b\t\t9P\u0003\u0003\u0002z\u0006=\u0012\u0001\u00027b]\u001eL1\u0001`A|\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011\t\u0001\u0005\u0003\u0002\"\t\r\u0011b\u0001B\u0003o\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\u000bB\u0006\u0011%\u0011iASA\u0001\u0002\u0004\u0011\t!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005'\u0001bA!\u0006\u0003\u001c\u0005USB\u0001B\f\u0015\r\u0011Ib^\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u000f\u0005/\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!1\u0005B\u0015!\u0011\t\tC!\n\n\u0007\t\u001drOA\u0004C_>dW-\u00198\t\u0013\t5A*!AA\u0002\u0005U\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a=\u00030!I!QB'\u0002\u0002\u0003\u0007!\u0011A\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!\u0011A\u0001\ti>\u001cFO]5oOR\u0011\u00111_\u0001\u0007KF,\u0018\r\\:\u0015\t\t\r\"Q\b\u0005\n\u0005\u001b\u0001\u0016\u0011!a\u0001\u0003+\u00121\"T5o)&,'I]3bWNIQ&a\b\u0002v\u0005=\u0016Q\u0017\u000b\u0003\u0005\u000b\u00022!a\u001e.)\u0019\t\tI!\u0013\u0003L!9\u0011\u0011R\u0018A\u0002\u0005-\u0005bBAJ_\u0001\u0007\u0011Q\u0013\u000b\u0005\u0003+\u0012y\u0005C\u0005\u0003\u000eM\n\t\u00111\u0001\u0003\u0002Q!!1\u0005B*\u0011%\u0011i!NA\u0001\u0002\u0004\t)\u0006\u0006\u0003\u0002t\n]\u0003\"\u0003B\u0007m\u0005\u0005\t\u0019\u0001B\u0001)\u0011\u0011\u0019Ca\u0017\t\u0013\t5\u0011(!AA\u0002\u0005U#A\u0004*b]\u0012|W\u000eV5f\u0005J,\u0017m[\n\n3\u0005}\u0011QOAX\u0003k#\"Aa\u0019\u0011\u0007\u0005]\u0014\u0004\u0006\u0004\u0002\u0002\n\u001d$\u0011\u000e\u0005\b\u0003\u0013[\u0002\u0019AAF\u0011\u001d\t\u0019j\u0007a\u0001\u0003+#B!!\u0016\u0003n!I!QB\u0010\u0002\u0002\u0003\u0007!\u0011\u0001\u000b\u0005\u0005G\u0011\t\bC\u0005\u0003\u000e\u0005\n\t\u00111\u0001\u0002VQ!\u00111\u001fB;\u0011%\u0011iAIA\u0001\u0002\u0004\u0011\t\u0001\u0006\u0003\u0003$\te\u0004\"\u0003B\u0007K\u0005\u0005\t\u0019AA+\u0011%\u0011i\b\u0005I\u0001\u0002\u0004\u0011y(\u0001\bti&\u001c7.\u001b8fgN\u0004&o\u001c2\u0011\t\u0005\u0005\"\u0011Q\u0005\u0004\u0005\u0007;(!\u0002$m_\u0006$\b\"\u0003BD!A\u0005\t\u0019\u0001B\u0001\u0003\u001di\u0017\r_%uKJD\u0011Ba#\u0011!\u0003\u0005\r!!!\u0002\tM,W\rZ\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!!\u0011\u0013BK+\t\u0011\u0019JK\u0002r\u0003;$q!a\u0013\u0012\u0005\u0004\ti%A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0011\u0011YJa(\u0016\u0005\tu%\u0006BA;\u0003;$q!a\u0013\u0013\u0005\u0004\ti%A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011)K!+\u0016\u0005\t\u001d&\u0006\u0002B@\u0003;$q!a\u0013\u0014\u0005\u0004\ti%A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135+\u0011\u0011yKa-\u0016\u0005\tE&\u0006\u0002B\u0001\u0003;$q!a\u0013\u0015\u0005\u0004\ti%A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136+\u0011\u0011IL!0\u0016\u0005\tm&\u0006BAA\u0003;$q!a\u0013\u0016\u0005\u0004\ti%A\u0002ma\u0006,BAa1\u0003VRa!Q\u0019Bl\u00053\u0014YNa8\u0003jR!!q\u0019Bg!\u0011\t\tC!3\n\u0007\t-wO\u0001\u0003V]&$\bb\u0002Bh-\u0001\u000f!\u0011[\u0001\b]VlWM]5d!\u0019\t\t'a\u001b\u0003TB!\u0011q\tBk\t\u001d\tYE\u0006b\u0001\u0003\u001bBq!a%\u0017\u0001\u0004\t)\nC\u0003q-\u0001\u0007\u0011\u000fC\u0004\u0003^Z\u0001\r!!\u001e\u0002\u0011QLWM\u0011:fC.DqA!9\u0017\u0001\u0004\u0011\u0019/\u0001\u0002T!B!\u0011\u0011\u0005Bs\u0013\r\u00119o\u001e\u0002\u0007\t>,(\r\\3\t\u000f\t-h\u00031\u0001\u0003n\u0006\u0019!O\u001c3\u0011\t\t=(Q_\u0007\u0003\u0005cT1Aa=x\u0003\u0011)H/\u001b7\n\t\t](\u0011\u001f\u0002\u0007%\u0006tGm\\7\u0002\u001dI\u000bg\u000eZ8n)&,'I]3bWB\u0019\u0011qO\u0014\u0014\u000b\u001d\u0012y0a\n\u0011\r\r\u00051q\u0001B2\u001b\t\u0019\u0019AC\u0002\u0004\u0006]\fqA];oi&lW-\u0003\u0003\u0004\n\r\r!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oaQ\u0011!1`\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019c!\u0005\t\u0013\rM1&!AA\u0002\t\r\u0014a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111\u0011\u0004\t\u0005\u0003k\u001cY\"\u0003\u0003\u0004\u001e\u0005](AB(cU\u0016\u001cG/A\u0006NS:$\u0016.\u001a\"sK\u0006\\\u0007cAA<wM)1h!\n\u0002(A11\u0011AB\u0004\u0005\u000b\"\"a!\t\u0015\t\t\r21\u0006\u0005\n\u0007'y\u0014\u0011!a\u0001\u0005\u000b\nabQ;ti>lG+[3Ce\u0016\f7\u000eE\u0002\u0002xI\u001bRAUB\u001a\u0003O\u0001\u0002b!\u0001\u00046\u0005u\u0016qY\u0005\u0005\u0007o\u0019\u0019AA\tBEN$(/Y2u\rVt7\r^5p]F\"\"aa\f\u0015\t\u0005\u001d7Q\b\u0005\b\u0003s+\u0006\u0019AA_)\u0011\u0019\tea\u0012\u0011\r\u0005\u000521IA_\u0013\r\u0019)e\u001e\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\rMa+!AA\u0002\u0005\u001d\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0003\u0012\u000e5CaBA&1\n\u0007\u0011QJ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\t\tm51\u000b\u0003\b\u0003\u0017J&\u0019AA'\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU!!QUB-\t\u001d\tYE\u0017b\u0001\u0003\u001b\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T\u0003\u0002BX\u0007?\"q!a\u0013\\\u0005\u0004\ti%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0005\u0005s\u001b)\u0007B\u0004\u0002Lq\u0013\r!!\u0014\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0002b\u0005-41\u000e\t\u0005\u0003\u000f\u001ai\u0007B\u0004\u0002L\u0001\u0011\r!!\u0014\u0015\u0019\rE4qOB=\u0007w\u001aiha \u0015\t\rM4Q\u000f\t\u0006\u00037\u000111\u000e\u0005\b\u0007O:\u00019AB5\u0011\u001d\u0001x\u0001%AA\u0002EDqA`\u0004\u0011\u0002\u0003\u0007q\u0010C\u0005\u0003~\u001d\u0001\n\u00111\u0001\u0003\u0000!I!qQ\u0004\u0011\u0002\u0003\u0007!\u0011\u0001\u0005\n\u0005\u0017;\u0001\u0013!a\u0001\u0003\u0003+\"A!<\u0002\tItG\rI\u000b\u0003\u0005\u007f\n1a\u0015)!)\u0011\u0019Yia$\u0011\t\r55q\u0014\b\u0005\u0003\u000f\u001ay\tC\u0004\u0004\u00122\u0001\raa%\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\t\rU51T\u0007\u0003\u0007/SAa!'\u0002\u001e\u0006IqM]1qQZLWm^\u0005\u0005\u0007;\u001b9J\u0001\tHe\u0006\u0004\b\u000eU3sgB,7\r^5wK&!1\u0011UBN\u0005\u00159%/\u00199iQ\u001d\u00011QUB]\u0007w\u0003Baa*\u000466\u00111\u0011\u0016\u0006\u0005\u0007W\u001bi+\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\u0011\u0019yk!-\u0002\u000fQ\f7.\u001a>pK*\u001911W4\u0002\r\u001dLG\u000f[;c\u0013\u0011\u00199l!+\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#a!0\u0002!O|#F\u000b\u0006!A)\u00023p]?a\u0019B\u000b\u0005f^3jO\"$(h\u0015;sS:<\u0007%\u0010\u0011#E1\u0002S.\u0019=Ji\u0016\u0014((\u00138uAu\u0002S\u0007\r\u0019-AM,W\r\u001a\u001eM_:<\u0007%\u0010\u0011.c%\u0002'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011sk:\u00043/\u001f8dQJ|gn\\;tA1\f'-\u001a7!aJ|\u0007/Y4bi&|g\u000e\t2bg\u0016$\u0007eY8n[Vt\u0017\u000e^=!I\u0016$Xm\u0019;j_:T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t\u0011M!\u0006\u0003#/\u001a;ve:\u001c\b\u0005\u001e5fA\r|W.\\;oSRLWm\u001d\u0011pM\u0002\"\b.\u001a\u0011d_:\u001cHO];di\u0016$\u0007e\u001a:ba\"\u0004\u0013m\u001d\u0011eKR,7\r^3eA\tL\be]=oG\"\u0014xN\\8vg\u0002b\u0017MY3mAA\u0014x\u000e]1hCRLwN\u001c\u0018\u000bA\u0001R\u0003\u0005\t\u0011Fm\u0016\u0014\u0018\u0010\t<feR,\u0007\u0010I5tA\u0005\u001c8/[4oK\u0012\u0004\u0013M\u001c\u0011j]&$\u0018.\u00197!Y\u0006\u0014W\r\u001c\u0011bi\u0002\u0012\u0018M\u001c3p[:\u0002Cj\\8lS:<\u0007%\u0019;!i\",\u0007\u0005\\1cK2\u001c\be\u001c4!SR\u001c\bE\\3jO\"\u0014w.\u001e:tY\u0001\n\u0007\u0005\u001d:pE\u0006\u0014\u0017\u000e\\5us\u0002J7\u000fI1tg&<g.\u001a3\u000bA\u0001R\u0003\u0005\t\u0011u_\u0002z'm]3sm\u0016$\u0007\u0005\\1cK2\u001c\bEZ8mY><\u0018N\\4!C:\u0004\u0013N\\2sK\u0006\u001c\u0018N\\4!MVt7\r^5p]\u0002\"\b.\u001a8!i\",\u0007E^3si\u0016D(\u001daMtA1\f'-\u001a7!SN\u0004S\u000f\u001d3bi\u0016$\u0007e^5uQ\u0002\"\b.\u001a\u0011mC\n,G\u000eI<ji\"\u0004C\u000f[3!Q&<\u0007.Z:u\u0015\u0001\u0002#\u0006\t\u0011!aJ|'-\u00192jY&$\u0018P\f\u0011JM\u0002\"\b.\u001a\u0011oK^\u0004C.\u00192fY\u0002J7\u000f\t;iK\u0002\u001a\u0018-\\3!CN\u0004C\u000f[3!GV\u0014(/\u001a8uA1\f'-\u001a7-AQDW\r\t<feR,\u0007\u0010\t<pi\u0016\u001c\b\u0005^8!Q\u0006dGO\f\u0011UQ&\u001c\b\u0005\u001d:pG\u0016\u001c8\u000fI5uKJ\fG/Z:!k:$\u0018\u000e\u001c\u0006!A)\u0002\u0003\u0005I1mY\u00022XM\u001d;fq\u0002b\u0017MY3mg\u0002B\u0017M^3!G>tg/\u001a:hK\u0012t\u0003\u0005\u00165fA\u0005dwm\u001c:ji\"l\u0007%[:!gft7\r\u001b:p]>,8\u000fI:j]\u000e,\u0007%\u001a<fef\u0004c/\u001a:uKb\u0004S\u000f\u001d3bi\u0016\u001c\b%\u001b;tA1\f'-\u001a7!CR\u0004C\u000f[3!g\u0006lW\r\t;j[\u0016t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AA\u000b'/Y7fi\u0016\u00148O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!Am\u001cX\u0010Y<fS\u001eDGO\u000f\u0011TiJLgn\u001a\u0011>A\t\u0012\u0003M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!\u000b\u0012<W\rI<fS\u001eDG\u000f\t9s_B,'\u000f^=/AQ{\u0007EY3!gB,7-\u001b4jK\u0012\u0004\u0013N\u001c\u0011dCN,\u0007e\u001c4!o\u0016Lw\r\u001b;fI\u0002:'/\u00199i])\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005I>t{\u0002$\u0018.\u001a\"sK\u0006\\WM\u001d\u001e!)&,'I]3bW\u0016\u0014\b%\u0010\u0011NS:$\u0016.\u001a\"sK\u0006\\\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!eVdW\r\t4pe\u0002\u0012'/Z1lS:<\u0007\u0005^5fg\u0002\u0012W\r^<fK:\u0004S-];bY2L\be^3jO\"$X\r\u001a\u0011oK&<\u0007NY8ve\"|w\u000e\u001a\u0011mC\n,Gn\u001d\u0018!\t\u00164\u0017-\u001e7uA%\u001c\b\u0005^8!a&\u001c7\u000e\t;iK\u0002j\u0017N\\5nk6\u0004c/\u00197vK\u0012\u0004C.\u00192fY:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t\u0011|gv\u0004W.\u0019=Ji\u0016\u0014(\bI%oi\u0002j\u0004%\u000e\u00191A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004%T1yS6,X\u000eI5uKJ\fG/[8og\u00022wN\u001d\u0011bY\u001e|'/\u001b;i[\u0002\"x\u000e\t:v]:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t\u0011|gv\u00047/Z3eu\u0001buN\\4a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002c+\u00197vK\u0002*8/\u001a3!M>\u0014\b\u0005\u001e5fAI\fg\u000eZ8nAM,G.Z2uS>tG\u0006I2b]\u0002\u0012W\rI:fi\u0002\"x\u000eI3ogV\u0014X\rI:b[\u0016\u0004#/Z:vYR\u0004\u0013n\u001d\u0011sKR,(O\\3eAA,'\u000f\t:v]:R\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005I%gA9|G\u000fI:qK\u000eLg-[3eY\u0001JG\u000fI<jY2\u0004s-\u001a8fe\u0006$X\rI1!e\u0006tGm\\7!g\u0016,GM\f\u0006!A)R\u0001\u0005\t\u0016!A\u0001\u00023p]?agRL7m[5oKN\u001c\bK]8cu\u00012En\\1uA*\u0001\u0003E\u000b\u0011!A\u0001R\u0004\u0005\u0015:pE\u0006\u0014\u0017\u000e\\5us\u0002\"\b.\u0019;!e\u0016<\u0017M\u001d3mKN\u001c\be\u001c4!i\",\u0007\u0005^5fEJ,\u0017m\u001b\u0011bY\u001e|'/\u001b;i[\u0002*8/\u001a3-A\u0005\u0004c/\u001a:uKb\u0004s/\u001b7mA),8\u000f\u001e\u0011lK\u0016\u0004\b%\u001b;tAA\u0014XM^5pkN\u0004C.\u00192fY:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!'R\fG/Z:\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0002\u0003e_:~A\u000e|W.\\;oSRL(\b\t'p]\u001e\u0004'\u0002\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011;AQCW\rI%EA=4\u0007\u0005\u001e5fA\r|W.\\;oSRL\b\u0005\u001e5fAY,'\u000f^3yA\t,Gn\u001c8hg\u0002\"xN\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t?!m\u0016\u0014H/\u001a=!]\u0006lW\r\t\u0011!A\u0001\u0002\u0003\u0005 \u0011d_6lWO\\5us\u0002b\u0017MY3mA\u0001\u0002\u0003\u0005\t\u0011}\u0015\u0001\u0002#\u0006\t\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?![5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y*\u0001\u0003E\u000b\u0011!y\u0002Z8/ 1oC6,'\bI*ue&tw\r\u0019\u0011}Am\u001cX\u0010Y2p[6,h.\u001b;zu\u0001buN\\4aAqT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00191aw:|G/Z?\u000bA\u0001R\u0003\u0005\t\u0011UQ&\u001c\b%[7qY\u0016lWM\u001c;bi&|g\u000eI8gA1\u0003\u0016\tI5oG>\u0014\bo\u001c:bi\u0016\u001c\b\u0005\u001d:pE\u0006\u0014\u0017\u000e\\5ti&\u001c\u0007%\u001a7f[\u0016tGo\u001d\u0011xQ&\u001c\u0007\u000eI7bW\u0016\u001c\b%\u001b;\u000bA\u0001R\u0003\u0005\t\u0011o_:lC-\u001a;fe6Lg.[:uS\u000e\\\u0004\u0005\u00165fAI,G/\u001e:oK\u0012\u00043m\\7nk:LG/[3tA5\f\u0017\u0010\t3jM\u001a,'\u000fI8oA5,H\u000e^5qY\u0016\u0004S\r_3dkRLwN\\:/\u0015\u0001\u0002#\u0006\t\u0011!/\"L7\r\u001b\u0011jg\u0002:\b.\u001f\u0011z_V\u0004S.Y=!o\u0006tG\u000f\t;pAM,G\u000f\t;iK\u0002\u001aX-\u001a3!S\u001a\u0004C/Z:uS:<gF\u0003\u0011!U\u0001\u0002\u0007\r\u0019\u0006!A)R\u0001\u0005\t\u0016!A\u0002\u00047p]3fC2\u001cx. \u0006!A)\u00023,\u0018\u0015d_6t#/\u00199ii>\u0014\u0018PL1mO>\u0014\u0018\u000e\u001e5ng::WM\\3sS\u000et3m\\7nk:LG/\u001f\u0018T\u0019B\u000b\u0015\u0006\f\u0011\\;\"\u001aw.\u001c\u0018sCBDGo\u001c:z]\u0005dwm\u001c:ji\"l7O\f;f[B|'/\u00197/G>lW.\u001e8jiftS*\u001e7uS2\f\u00170\u001a:M!\u0006K#\u0002\t\u0011+A\u0001\u0004\u0007M\u0003\u0011!U=\u0002")
public class LPA<T>
extends NodeList {
    private final String weight;
    private final TieBreaker tieBreaker;
    private final int maxIter;
    private final Numeric<T> evidence$1;
    private final Random rnd;
    private final float SP;

    public static <T> long $lessinit$greater$default$5() {
        return LPA$.MODULE$.$lessinit$greater$default$5();
    }

    public static <T> int $lessinit$greater$default$4() {
        return LPA$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> float $lessinit$greater$default$3() {
        return LPA$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> TieBreaker $lessinit$greater$default$2() {
        return LPA$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> String $lessinit$greater$default$1() {
        return LPA$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> void lpa(Vertex vertex, String weight, TieBreaker tieBreak, double SP, Random rnd, Numeric<T> numeric) {
        LPA$.MODULE$.lpa(vertex, weight, tieBreak, SP, rnd, numeric);
    }

    public static <T> long apply$default$5() {
        return LPA$.MODULE$.apply$default$5();
    }

    public static <T> int apply$default$4() {
        return LPA$.MODULE$.apply$default$4();
    }

    public static <T> float apply$default$3() {
        return LPA$.MODULE$.apply$default$3();
    }

    public static <T> TieBreaker apply$default$2() {
        return LPA$.MODULE$.apply$default$2();
    }

    public static <T> String apply$default$1() {
        return LPA$.MODULE$.apply$default$1();
    }

    private Random rnd() {
        return this.rnd;
    }

    private float SP() {
        return this.SP;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            LPA.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            LPA$.MODULE$.lpa(vertex, this.weight, this.tieBreaker, this.SP(), this.rnd(), this.evidence$1);
            return BoxedUnit.UNIT;
        }, this.maxIter, false);
    }

    public static final /* synthetic */ void $anonfun$apply$1(LPA $this, Vertex vertex) {
        long lab = $this.rnd().nextLong();
        ((EntityVisitor)((Object)vertex)).setState("community", BoxesRunTime.boxToLong((long)lab));
        vertex.messageAllNeighbours(new Tuple2(vertex.ID(), (Object)BoxesRunTime.boxToLong((long)lab)), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
    }

    public LPA(String weight, TieBreaker tieBreaker, float stickinessProb, int maxIter, long seed, Numeric<T> evidence$1) {
        this.weight = weight;
        this.tieBreaker = tieBreaker;
        this.maxIter = maxIter;
        this.evidence$1 = evidence$1;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"community"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
        this.rnd = seed == -1L ? new Random() : new Random(seed);
        this.SP = stickinessProb;
    }

    public static class CustomTieBreak
    implements TieBreaker,
    Product,
    Serializable {
        private final Function2<List<Object>, Vertex, Object> f;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Function2<List<Object>, Vertex, Object> f() {
            return this.f;
        }

        @Override
        public long chooseLabel(List<Object> possLabels, Vertex vertex) {
            return BoxesRunTime.unboxToLong((Object)this.f().apply(possLabels, (Object)vertex));
        }

        public CustomTieBreak copy(Function2<List<Object>, Vertex, Object> f) {
            return new CustomTieBreak(f);
        }

        public Function2<List<Object>, Vertex, Object> copy$default$1() {
            return this.f();
        }

        public String productPrefix() {
            return "CustomTieBreak";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.f();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CustomTieBreak;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "f";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CustomTieBreak)) return false;
            boolean bl = true;
            if (!bl) return false;
            CustomTieBreak customTieBreak = (CustomTieBreak)x$1;
            Function2<List<Object>, Vertex, Object> function2 = this.f();
            Function2<List<Object>, Vertex, Object> function22 = customTieBreak.f();
            if (function2 == null) {
                if (function22 != null) {
                    return false;
                }
            } else if (!function2.equals(function22)) return false;
            if (!customTieBreak.canEqual(this)) return false;
            return true;
        }

        public CustomTieBreak(Function2<List<Object>, Vertex, Object> f) {
            this.f = f;
            Product.$init$((Product)this);
        }
    }

    public static class MinTieBreak
    implements TieBreaker,
    Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public long chooseLabel(List<Object> possLabels, Vertex vertex) {
            return BoxesRunTime.unboxToLong((Object)possLabels.min((Ordering)Ordering.Long$.MODULE$));
        }

        public MinTieBreak copy() {
            return new MinTieBreak();
        }

        public String productPrefix() {
            return "MinTieBreak";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            Object object = Statics.ioobe((int)x$1);
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MinTieBreak;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            String string = (String)Statics.ioobe((int)x$1);
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof MinTieBreak;
            return bl && ((MinTieBreak)x$1).canEqual(this);
        }

        public MinTieBreak() {
            Product.$init$((Product)this);
        }
    }

    public static class RandomTieBreak
    implements TieBreaker,
    Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public long chooseLabel(List<Object> possLabels, Vertex vertex) {
            return BoxesRunTime.unboxToLong((Object)possLabels.apply(Random$.MODULE$.nextInt(possLabels.length())));
        }

        public RandomTieBreak copy() {
            return new RandomTieBreak();
        }

        public String productPrefix() {
            return "RandomTieBreak";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            Object object = Statics.ioobe((int)x$1);
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RandomTieBreak;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            String string = (String)Statics.ioobe((int)x$1);
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof RandomTieBreak;
            return bl && ((RandomTieBreak)x$1).canEqual(this);
        }

        public RandomTieBreak() {
            Product.$init$((Product)this);
        }
    }

    public static interface TieBreaker {
        public long chooseLabel(List<Object> var1, Vertex var2);
    }
}

