/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.centrality;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.algorithms.generic.centrality.Distinctiveness$;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.ConcreteEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.View;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`Distinctiveness(alpha: Double=1.0, weightProperty=\"weight\")`\n  *  : compute distinctiveness centralities of nodes\n  *\n  * Distinctiveness centrality measures importance of a node through how it\n  * bridges different parts of the graph, approximating this by connections to\n  * low degree nodes. For more info read\n  * [Distinctiveness centrality in social networks](https://journals.plos.org/plosone/article/file?id=10.1371/journal.pone.0233276&type=printable)\n  *\n  * ```{note}\n  * The network is treated as undirected.\n  * ```\n  *\n  * ## Parameters\n  *\n  *  {s}`alpha: Double = 1.0`\n  *    : tuning exponent\n  *\n  *  {s}`weightProperty: String = \"weight\"`\n  *    : name of property to use for edge weight. If not found, edge weight is treated as number of edge occurrences.\n  *\n  * ## States\n  *\n  *  {s}`D1: Double`, ... , {s}`D5: Double`\n  *    : versions of distinctiveness centrality\n  *\n  * ## Returns\n  *\n  *  | vertex name       | D1              | ... | D5              |\n  *  | ----------------- | --------------- | --- | --------------- |\n  *  | {s}`name: String` | {s}`D1: Double` | ... | {s}`D5: Double` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001\u0002\u000b\u0016\u0001\u0001B\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\b\u0001B\u0001B\u0003-!\bC\u0003O\u0001\u0011\u0005q\nC\u0003W\u0001\u0011\u0005s\u000bC\u0003i\u0001\u0011%\u0011\u000eC\u0004\u0002\f\u0001!I!!\u0004\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u0011q\u0007\u0001\u0005\n\u0005e\u0002bBA'\u0001\u0011%\u0011qJ\u0004\b\u0003\u007f*\u0002\u0012AAA\r\u0019!R\u0003#\u0001\u0002\u0004\"1a\n\u0004C\u0001\u00037CaA\u0016\u0007\u0005\u0002\u0005u\u0005\"CAZ\u0019E\u0005I\u0011AA[\u0011%\ty\rDI\u0001\n\u0003\t\t\u000eC\u0005\u0002Z2\t\n\u0011\"\u0001\u0002\\\"I\u0011q\u001c\u0007\u0012\u0002\u0013\u0005\u0011\u0011\u001d\u0005\n\u0003Kd\u0011\u0011!C\u0005\u0003O\u0014q\u0002R5ti&t7\r^5wK:,7o\u001d\u0006\u0003-]\t!bY3oiJ\fG.\u001b;z\u0015\tA\u0012$A\u0004hK:,'/[2\u000b\u0005iY\u0012AC1mO>\u0014\u0018\u000e\u001e5ng*\u0011A$H\u0001\te\u0006\u0004\b\u000e^8ss*\ta$A\u0002d_6\u001c\u0001!\u0006\u0002\"\u000bN\u0011\u0001A\t\t\u0003G\u0011j\u0011aF\u0005\u0003K]\u0011\u0001BT8eK2K7\u000f^\u0001\u0006C2\u0004\b.\u0019\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\t>,(\r\\3\u0002\u001d],\u0017n\u001a5u!J|\u0007/\u001a:usB\u0011qF\u000e\b\u0003aQ\u0002\"!M\u0015\u000e\u0003IR!aM\u0010\u0002\rq\u0012xn\u001c;?\u0013\t)\u0014&\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b*\u0003\u001dqW/\\3sS\u000e\u00042a\u000f!D\u001d\tadH\u0004\u00022{%\t!&\u0003\u0002@S\u00059\u0001/Y2lC\u001e,\u0017BA!C\u0005\u001dqU/\\3sS\u000eT!aP\u0015\u0011\u0005\u0011+E\u0002\u0001\u0003\u0006\r\u0002\u0011\ra\u0012\u0002\u0002)F\u0011\u0001j\u0013\t\u0003Q%K!AS\u0015\u0003\u000f9{G\u000f[5oOB\u0011\u0001\u0006T\u0005\u0003\u001b&\u00121!\u00118z\u0003\u0019a\u0014N\\5u}Q\u0019\u0001\u000bV+\u0015\u0005E\u001b\u0006c\u0001*\u0001\u00076\tQ\u0003C\u0003:\t\u0001\u000f!\bC\u0004'\tA\u0005\t\u0019A\u0014\t\u000f5\"\u0001\u0013!a\u0001]\u0005)\u0011\r\u001d9msR\u0011\u0001L\u0017\t\u00033\u001at!\u0001\u0012.\t\u000bm+\u0001\u0019\u0001/\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\u0005u#W\"\u00010\u000b\u0005}\u0003\u0017!C4sCBDg/[3x\u0015\t\t'-\u0001\u0005b]\u0006d\u0017p]5t\u0015\t\u00197$A\u0002ba&L!!\u001a0\u0003!\u001d\u0013\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0017BA4e\u0005\u00159%/\u00199i\u0003\t!\u0015\u0007\u0006\u0002kkR1qe[A\u0003\u0003\u0013AQ\u0001\u001c\u0004A\u00025\f\u0001\"\\3tg\u0006<Wm\u001d\t\u0004w9\u0004\u0018BA8C\u0005\u0011a\u0015n\u001d;\u0011\r!\n8o`\u0014(\u0013\t\u0011\u0018F\u0001\u0004UkBdW\r\u000e\t\u0003ivt!\u0001R;\t\u000bY4\u0001\u0019A<\u0002\rY,'\u000f^3y!\tA80D\u0001z\u0015\tQ\b-A\u0004wSNLGo\u001c:\n\u0005qL(A\u0002,feR,\u00070\u0003\u0002\u007fw\n1\u0011\n\u0012+za\u0016\u00042\u0001KA\u0001\u0013\r\t\u0019!\u000b\u0002\u0004\u0013:$\bBBA\u0004\r\u0001\u0007q%A\u0004o_:{G-Z:\t\u000b\u00192\u0001\u0019A\u0014\u0002\u0005\u0011\u0013D\u0003BA\b\u00037!raJA\t\u0003;\ty\u0002\u0003\u0004m\u000f\u0001\u0007\u00111\u0003\t\u0005w9\f)\u0002E\u0004)c\u0006]qpJ\u0014\u0011\u0007\u0005eQPD\u0002E\u00037AQA^\u0004A\u0002]Da!a\u0002\b\u0001\u00049\u0003\"\u0002\u0014\b\u0001\u00049\u0013A\u0001#4)\u0011\t)#!\r\u0015\u000f\u001d\n9#a\r\u00026!1A\u000e\u0003a\u0001\u0003S\u0001Ba\u000f8\u0002,A9\u0001&]A\u0017\u007f\u001e:\u0003cAA\u0018{:\u0019A)!\r\t\u000bYD\u0001\u0019A<\t\r\u0005\u001d\u0001\u00021\u0001(\u0011\u00151\u0003\u00021\u0001(\u0003\t!E\u0007\u0006\u0003\u0002<\u0005\u001dCcB\u0014\u0002>\u0005%\u00131\n\u0005\u0007Y&\u0001\r!a\u0010\u0011\tmr\u0017\u0011\t\t\bQE\f\u0019e`\u0014(!\r\t)% \b\u0004\t\u0006\u001d\u0003\"\u0002<\n\u0001\u00049\bBBA\u0004\u0013\u0001\u0007q\u0005C\u0003'\u0013\u0001\u0007q%\u0001\u0002EkQ!\u0011\u0011KA/)\u001d9\u00131KA0\u0003CBa\u0001\u001c\u0006A\u0002\u0005U\u0003\u0003B\u001eo\u0003/\u0002r\u0001K9\u0002Z}<s\u0005E\u0002\u0002\\ut1\u0001RA/\u0011\u00151(\u00021\u0001x\u0011\u0019\t9A\u0003a\u0001O!)aE\u0003a\u0001O!:\u0001!!\u001a\u0002z\u0005m\u0004\u0003BA4\u0003kj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\tg\u000e\fG.\u00193pG*!\u0011qNA9\u0003\u001d!\u0018m[3{_\u0016T1!a\u001d\u001e\u0003\u00199\u0017\u000e\u001e5vE&!\u0011qOA5\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017EAA?\u0003!\u0005xF\u000b\u0016\u000bA\u0001R\u0003e_:~A\u0012K7\u000f^5oGRLg/\u001a8fgND\u0013\r\u001c9iCj\u0002Ci\\;cY\u0016l\u0014G\f\u0019-A],\u0017n\u001a5u!J|\u0007/\u001a:usv\u0012s/Z5hQR\u0014\u0013\u0006\u0019\u0006!A)\u0002\u0003E\u000f\u0011d_6\u0004X\u000f^3!I&\u001cH/\u001b8di&4XM\\3tg\u0002\u001aWM\u001c;sC2LG/[3tA=4\u0007E\\8eKNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005R5ti&t7\r^5wK:,7o\u001d\u0011dK:$(/\u00197jif\u0004S.Z1tkJ,7\u000fI5na>\u0014H/\u00198dK\u0002zg\rI1!]>$W\r\t;ie>,x\r\u001b\u0011i_^\u0004\u0013\u000e\u001e\u0006!A)\u0002#M]5eO\u0016\u001c\b\u0005Z5gM\u0016\u0014XM\u001c;!a\u0006\u0014Ho\u001d\u0011pM\u0002\"\b.\u001a\u0011he\u0006\u0004\b\u000e\f\u0011baB\u0014x\u000e_5nCRLgn\u001a\u0011uQ&\u001c\bEY=!G>tg.Z2uS>t7\u000f\t;p\u0015\u0001\u0002#\u0006\t7po\u0002\"Wm\u001a:fK\u0002rw\u000eZ3t]\u00012uN\u001d\u0011n_J,\u0007%\u001b8g_\u0002\u0012X-\u00193\u000bA\u0001R\u0003e\u0017#jgRLgn\u0019;jm\u0016tWm]:!G\u0016tGO]1mSRL\b%\u001b8!g>\u001c\u0017.\u00197!]\u0016$xo\u001c:lgvC\u0003\u000e\u001e;qgjzsF[8ve:\fGn\u001d\u0018qY>\u001chf\u001c:h_Adwn]8oK>\n'\u000f^5dY\u0016|c-\u001b7f\u007f%$W(\r\u0019/cM:\u0014g\f6pkJt\u0017\r\u001c\u0018q_:,g\u0006\r\u001a4gI:dG\n;za\u0016l\u0004O]5oi\u0006\u0014G.Z\u0015\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0004\u0007m\u001f8pi\u0016l(\u0002\t\u0011+AQCW\r\t8fi^|'o\u001b\u0011jg\u0002\"(/Z1uK\u0012\u0004\u0013m\u001d\u0011v]\u0012L'/Z2uK\u0012t#\u0002\t\u0011+A\u0001\u0004\u0007M\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0002\u0016M]1nKR,'o\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y1ma\"\f'\b\t#pk\ndW\rI\u001f!c9\u0002\u0004M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!iVt\u0017N\\4!Kb\u0004xN\\3oi*\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~A^,\u0017n\u001a5u!J|\u0007/\u001a:usj\u00023\u000b\u001e:j]\u001e\u0004S\b\t\u0012xK&<\u0007\u000e\u001e\u0012a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002c.Y7fA=4\u0007\u0005\u001d:pa\u0016\u0014H/\u001f\u0011u_\u0002*8/\u001a\u0011g_J\u0004S\rZ4fA],\u0017n\u001a5u]\u0001Je\r\t8pi\u00022w.\u001e8eY\u0001*GmZ3!o\u0016Lw\r\u001b;!SN\u0004CO]3bi\u0016$\u0007%Y:!]Vl'-\u001a:!_\u001a\u0004S\rZ4fA=\u001c7-\u001e:sK:\u001cWm\u001d\u0018\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003e\u0015;bi\u0016\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004G)\r\u001e!\t>,(\r\\3aY\u0001rcF\f\u0011-Am\u001cX\u0010\u0019#6u\u0001\"u.\u001e2mK\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t<feNLwN\\:!_\u001a\u0004C-[:uS:\u001cG/\u001b<f]\u0016\u001c8\u000fI2f]R\u0014\u0018\r\\5us*\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011SKR,(O\\:\u000bA\u0001R#\u0002\t\u0011+A\u0001b\bE^3si\u0016D\bE\\1nK\u0002\u0002\u0003\u0005\t\u0011!Aq\u0004C)\r\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t?!]9r\u0003\u0005 \u0011Ek\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AqT\u0001\u0005\t\u0016!Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0011.[5\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017!y*\u0001\u0003E\u000b\u0011!y\u0002Z8/ 1oC6,'\bI*ue&tw\r\u0019\u0011}Am\u001cX\u0010\u0019#2u\u0001\"u.\u001e2mK\u0002\u0004C\u0010\t\u0018/]\u0001b\be_:~A\u0012+$\b\t#pk\ndW\r\u0019\u0011}\u0015\u0001\u0002#fL\u0001\u0010\t&\u001cH/\u001b8di&4XM\\3tgB\u0011!\u000bD\n\u0006\u0019\u0005\u0015\u00151\u0012\t\u0004Q\u0005\u001d\u0015bAAES\t1\u0011I\\=SK\u001a\u0004B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*\u0001\u0002j_*\u0011\u0011QS\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001a\u0006=%\u0001D*fe&\fG.\u001b>bE2,GCAAA+\u0011\ty*a*\u0015\r\u0005\u0005\u0016qVAY)\u0011\t\u0019+!+\u0011\tI\u0003\u0011Q\u0015\t\u0004\t\u0006\u001dF!\u0002$\u000f\u0005\u00049\u0005\"CAV\u001d\u0005\u0005\t9AAW\u0003))g/\u001b3f]\u000e,G%\r\t\u0005w\u0001\u000b)\u000bC\u0004'\u001dA\u0005\t\u0019A\u0014\t\u000f5r\u0001\u0013!a\u0001]\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u00028\u00065WCAA]U\r9\u00131X\u0016\u0003\u0003{\u0003B!a0\u0002J6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\f)-A\u0005v]\u000eDWmY6fI*\u0019\u0011qY\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002L\u0006\u0005'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)ai\u0004b\u0001\u000f\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'\u0006\u0003\u0002T\u0006]WCAAkU\rq\u00131\u0018\u0003\u0006\rB\u0011\raR\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\t\u0005]\u0016Q\u001c\u0003\u0006\rF\u0011\raR\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\t\u0005M\u00171\u001d\u0003\u0006\rJ\u0011\raR\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003S\u0004B!a;\u0002r6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\u0019*\u0001\u0003mC:<\u0017\u0002BAz\u0003[\u0014aa\u00142kK\u000e$\b")
public class Distinctiveness<T>
extends NodeList {
    private final double alpha;
    private final Numeric<T> numeric;

    public static <T> String $lessinit$greater$default$2() {
        return Distinctiveness$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> double $lessinit$greater$default$1() {
        return Distinctiveness$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> String apply$default$2() {
        return Distinctiveness$.MODULE$.apply$default$2();
    }

    public static <T> double apply$default$1() {
        return Distinctiveness$.MODULE$.apply$default$1();
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            Distinctiveness.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, graphState) -> {
            Distinctiveness.$anonfun$apply$3(this, vertex, graphState);
            return BoxedUnit.UNIT;
        });
    }

    private double D1(Vertex vertex, List<Tuple4<Object, Object, Object, Object>> messages, double noNodes, double alpha) {
        List<Tuple4<Object, Object, Object, Object>> list = messages;
        return BoxesRunTime.unboxToDouble((Object)list.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)Distinctiveness.$anonfun$D1$1(this, vertex, noNodes, alpha, x0$1))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    private double D2(Vertex vertex, List<Tuple4<Object, Object, Object, Object>> messages, double noNodes, double alpha) {
        List<Tuple4<Object, Object, Object, Object>> list = messages;
        return BoxesRunTime.unboxToDouble((Object)list.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)Distinctiveness.$anonfun$D2$1(noNodes, alpha, x0$1))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    private double D3(Vertex vertex, List<Tuple4<Object, Object, Object, Object>> messages, double noNodes, double alpha) {
        List<Tuple4<Object, Object, Object, Object>> list = messages;
        return BoxesRunTime.unboxToDouble((Object)list.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)Distinctiveness.$anonfun$D3$1(this, vertex, alpha, x0$1))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    private double D4(Vertex vertex, List<Tuple4<Object, Object, Object, Object>> messages, double noNodes, double alpha) {
        List<Tuple4<Object, Object, Object, Object>> list = messages;
        return BoxesRunTime.unboxToDouble((Object)list.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)Distinctiveness.$anonfun$D4$1(this, vertex, alpha, x0$1))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    private double D5(Vertex vertex, List<Tuple4<Object, Object, Object, Object>> messages, double noNodes, double alpha) {
        List<Tuple4<Object, Object, Object, Object>> list = messages;
        return BoxesRunTime.unboxToDouble((Object)list.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)Distinctiveness.$anonfun$D5$1(alpha, x0$1))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$apply$1(Distinctiveness $this, Vertex vertex) {
        View<ConcreteEdge> edges = vertex.edges();
        int degree = edges.size();
        double weight = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)edges.map((Function1 & Serializable)e -> BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(Numeric.Implicits$.MODULE$.infixNumericOps(e.weight($this.numeric), $this.numeric).toDouble(), $this.alpha)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double nodeWeight = Numeric.Implicits$.MODULE$.infixNumericOps(vertex.weightedTotalDegree($this.numeric), $this.numeric).toDouble();
        vertex.messageAllNeighbours(new Tuple4(vertex.ID(), (Object)BoxesRunTime.boxToInteger((int)degree), (Object)BoxesRunTime.boxToDouble((double)weight), (Object)BoxesRunTime.boxToDouble((double)nodeWeight)), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
    }

    public static final /* synthetic */ void $anonfun$apply$3(Distinctiveness $this, Vertex vertex, GraphState graphState) {
        List messages = vertex.messageQueue().toList();
        int N = graphState.nodeCount();
        ((EntityVisitor)((Object)vertex)).setState("D1", BoxesRunTime.boxToDouble((double)$this.D1(vertex, (List<Tuple4<Object, Object, Object, Object>>)messages, N, $this.alpha)));
        ((EntityVisitor)((Object)vertex)).setState("D2", BoxesRunTime.boxToDouble((double)$this.D2(vertex, (List<Tuple4<Object, Object, Object, Object>>)messages, N, $this.alpha)));
        ((EntityVisitor)((Object)vertex)).setState("D3", BoxesRunTime.boxToDouble((double)$this.D3(vertex, (List<Tuple4<Object, Object, Object, Object>>)messages, N, $this.alpha)));
        ((EntityVisitor)((Object)vertex)).setState("D4", BoxesRunTime.boxToDouble((double)$this.D4(vertex, (List<Tuple4<Object, Object, Object, Object>>)messages, N, $this.alpha)));
        ((EntityVisitor)((Object)vertex)).setState("D5", BoxesRunTime.boxToDouble((double)$this.D5(vertex, (List<Tuple4<Object, Object, Object, Object>>)messages, N, $this.alpha)));
    }

    public static final /* synthetic */ double $anonfun$D1$1(Distinctiveness $this, Vertex vertex$1, double noNodes$1, double alpha$1, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Object id = tuple4._1();
        int degree = BoxesRunTime.unboxToInt((Object)tuple4._2());
        double edgeWeight = Numeric.Implicits$.MODULE$.infixNumericOps(((IterableOnceOps)vertex$1.getEdge(id).map((Function1 & Serializable)x$1 -> x$1.weight($this.numeric))).sum($this.numeric), $this.numeric).toDouble();
        double d = edgeWeight * (package$.MODULE$.log10(noNodes$1 - 1.0) - alpha$1 * package$.MODULE$.log10((double)degree));
        return d;
    }

    public static final /* synthetic */ double $anonfun$D2$1(double noNodes$2, double alpha$2, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        int degree = BoxesRunTime.unboxToInt((Object)tuple4._2());
        double d = package$.MODULE$.log10(noNodes$2 - 1.0) - alpha$2 * package$.MODULE$.log10((double)degree);
        return d;
    }

    public static final /* synthetic */ double $anonfun$D3$1(Distinctiveness $this, Vertex vertex$2, double alpha$3, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Object id = tuple4._1();
        double nodePowerWeight = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double nodeSumWeight = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        double edgeWeight = Numeric.Implicits$.MODULE$.infixNumericOps(((IterableOnceOps)vertex$2.getEdge(id).map((Function1 & Serializable)x$2 -> x$2.weight($this.numeric))).sum($this.numeric), $this.numeric).toDouble();
        double d = edgeWeight * (package$.MODULE$.log10(nodeSumWeight / 2.0) - package$.MODULE$.log10(nodePowerWeight - package$.MODULE$.pow(edgeWeight, alpha$3) + 1.0));
        return d;
    }

    public static final /* synthetic */ double $anonfun$D4$1(Distinctiveness $this, Vertex vertex$3, double alpha$4, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Object id = tuple4._1();
        double nodePowerWeight = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double edgeWeight = Numeric.Implicits$.MODULE$.infixNumericOps(((IterableOnceOps)vertex$3.getEdge(id).map((Function1 & Serializable)x$3 -> x$3.weight($this.numeric))).sum($this.numeric), $this.numeric).toDouble();
        double d = package$.MODULE$.pow(edgeWeight, alpha$4 + 1.0) / nodePowerWeight;
        return d;
    }

    public static final /* synthetic */ double $anonfun$D5$1(double alpha$5, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        int degree = BoxesRunTime.unboxToInt((Object)tuple4._2());
        double d = package$.MODULE$.pow((double)degree, (double)-1 * alpha$5);
        return d;
    }

    public Distinctiveness(double alpha, String weightProperty, Numeric<T> numeric) {
        this.alpha = alpha;
        this.numeric = numeric;
        super((Seq<String>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"D1", "D2", "D3", "D4", "D5"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

