/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.centrality;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.GraphState;
import com.raphtory.algorithms.generic.GraphState$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Scaladoc(value="/**\n  * {s}`Assortativity()`\n  *  : compute assortativity coefficient of networks\n  *\n  * Assortativity coefficient is the Pearson coefficient between pairs of linked nodes\n  * the value is between [-1,1]\n  * positive value indicate a correlation between nodes of similar degree, and vice versa.\n  *\n  *\n  * ```{note}\n  * The network is treated as undirected.\n  * ```\n  *\n  * ## Returns\n  * | vertex name       | Assortativity              |\n  * | ----------------- | -------------------------- |\n  * | {s}`name: String` | {s}`Assortativity: Double` |\n  *\n  *\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\u0006\r\u0001]AQ\u0001\b\u0001\u0005\u0002uAQ\u0001\t\u0001\u0005B\u0005BQa\r\u0001\u0005\u0002QBQ!\u0014\u0001\u0005\u00029CQ!\u0018\u0001\u0005\u0002y;Qa\u001d\u0007\t\u0002Q4Qa\u0003\u0007\t\u0002UDa\u0001H\u0004\u0005\u0002\u0005\r\u0001\"\u0002\u0011\b\t\u0003i\u0002\"CA\u0003\u000f\u0005\u0005I\u0011BA\u0004\u00055\t5o]8si\u0006$\u0018N^5us*\u0011QBD\u0001\u000bG\u0016tGO]1mSRL(BA\b\u0011\u0003\u001d9WM\\3sS\u000eT!!\u0005\n\u0002\u0015\u0005dwm\u001c:ji\"l7O\u0003\u0002\u0014)\u0005A!/\u00199ii>\u0014\u0018PC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a55\ta\"\u0003\u0002\u001c\u001d\tQqI]1qQN#\u0018\r^3\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005a\u0011!B1qa2LHC\u0001\u0012&!\t\u0019\u0013G\u0004\u0002%K1\u0001\u0001\"\u0002\u0014\u0003\u0001\u00049\u0013!B4sCBD\u0007C\u0001\u00150\u001b\u0005I#B\u0001\u0016,\u0003%9'/\u00199im&,wO\u0003\u0002-[\u0005A\u0011M\\1msNL7O\u0003\u0002/%\u0005\u0019\u0011\r]5\n\u0005AJ#\u0001E$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f\u0013\t\u0011tFA\u0003He\u0006\u0004\b.\u0001\u0005NCBlUM]4f)\r)\u0014j\u0013\t\u0005m}\u0012UI\u0004\u00028{A\u0011\u0001hO\u0007\u0002s)\u0011!HF\u0001\u0007yI|w\u000e\u001e \u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015IA\u0002NCBT!AP\u001e\u0011\u0005Y\u001a\u0015B\u0001#B\u0005\u0019\u0019FO]5oOB\u0011aiR\u0007\u0002w%\u0011\u0001j\u000f\u0002\u0007\t>,(\r\\3\t\u000b)\u001b\u0001\u0019A\u001b\u0002\u0003aDQ\u0001T\u0002A\u0002U\n\u0011!_\u0001\n\u0019&\u001cH/T3sO\u0016$2aT.]!\r\u0001V\u000b\u0017\b\u0003#Ns!\u0001\u000f*\n\u0003qJ!\u0001V\u001e\u0002\u000fA\f7m[1hK&\u0011ak\u0016\u0002\u0005\u0019&\u001cHO\u0003\u0002UwA\u0011a)W\u0005\u00035n\u00121!\u00138u\u0011\u0015QE\u00011\u0001P\u0011\u0015aE\u00011\u0001P\u0003-\u0019\u0017\r\\2vY\u0006$\u0018n\u001c8\u0015\t\u0015{\u0016m\u0019\u0005\u0006A\u0016\u0001\r!N\u0001\u0004]*\\\u0007\"\u00022\u0006\u0001\u0004y\u0015a\u00023fOJ,Wm\u001d\u0005\u0006I\u0016\u0001\r!R\u0001\u0006K\u0012<Wm\u001d\u0015\u0005\u0001\u0019\u0004\u0018\u000f\u0005\u0002h]6\t\u0001N\u0003\u0002jU\u0006A1oY1mC\u0012|7M\u0003\u0002lY\u00069A/Y6fu>,'BA7\u0015\u0003\u00199\u0017\u000e\u001e5vE&\u0011q\u000e\u001b\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\n!/\u0001C5_)R#\u0002\t\u0011+Am\u001cX\u0010Y!tg>\u0014H/\u0019;jm&$\u0018\u0010K\u0015a\u0015\u0001\u0002#\u0006\t\u0011;A\r|W\u000e];uK\u0002\n7o]8si\u0006$\u0018N^5us\u0002\u001aw.\u001a4gS\u000eLWM\u001c;!_\u001a\u0004c.\u001a;x_J\\7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011BgN|'\u000f^1uSZLG/\u001f\u0011d_\u00164g-[2jK:$\b%[:!i\",\u0007\u0005U3beN|g\u000eI2pK\u001a4\u0017nY5f]R\u0004#-\u001a;xK\u0016t\u0007\u0005]1jeN\u0004sN\u001a\u0011mS:\\W\r\u001a\u0011o_\u0012,7O\u0003\u0011!U\u0001\"\b.\u001a\u0011wC2,X\rI5tA\t,Go^3f]\u0002ZV&\r\u00172;*\u0001\u0003E\u000b\u0011q_NLG/\u001b<fAY\fG.^3!S:$\u0017nY1uK\u0002\n\u0007eY8se\u0016d\u0017\r^5p]\u0002\u0012W\r^<fK:\u0004cn\u001c3fg\u0002zg\rI:j[&d\u0017M\u001d\u0011eK\u001e\u0014X-\u001a\u0017!C:$\u0007E^5dK\u00022XM]:b])\u0001\u0003E\u000b\u0006!A)R\u0001\u0005\t\u0016!A\u0002\u00047P\\8uKvT\u0001\u0005\t\u0016!)\",\u0007E\\3uo>\u00148\u000eI5tAQ\u0014X-\u0019;fI\u0002\n7\u000fI;oI&\u0014Xm\u0019;fI:R\u0001\u0005\t\u0016!A\u0002\u0004'\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AI+G/\u001e:og*\u0001\u0003E\u000b\u0011}AY,'\u000f^3yA9\fW.\u001a\u0011!A\u0001\u0002\u0003\u0005\t?!\u0003N\u001cxN\u001d;bi&4\u0018\u000e^=!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011}\u0015\u0001\u0002#\u0006\t?![5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?\u000bA\u0001R\u0003\u0005 \u0011|gv\u0004g.Y7fu\u0001\u001aFO]5oO\u0002\u0004C\u0010I>t{\u0002\f5o]8si\u0006$\u0018N^5usj\u0002Ci\\;cY\u0016\u0004\u0007\u0005 \u0006!A)R\u0001\u0005\t\u0016\u000bA\u0001Rs&A\u0007BgN|'\u000f^1uSZLG/\u001f\t\u0003?\u001d\u00192a\u0002<z!\t1u/\u0003\u0002yw\t1\u0011I\\=SK\u001a\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u0005%|'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003Y(\u0001D*fe&\fG.\u001b>bE2,G#\u0001;\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005%\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=Q0\u0001\u0003mC:<\u0017\u0002BA\n\u0003\u001b\u0011aa\u00142kK\u000e$\b")
public class Assortativity
extends GraphState {
    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.setGlobalState((Function1<com.raphtory.api.analysis.graphstate.GraphState, BoxedUnit>)(Function1 & Serializable)globalState -> {
            Assortativity.$anonfun$apply$1(this, globalState);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, globalState) -> {
            Assortativity.$anonfun$apply$4(vertex, globalState);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, globalState) -> {
            Assortativity.$anonfun$apply$5(vertex, globalState);
            return BoxedUnit.UNIT;
        }).setGlobalState((Function1<com.raphtory.api.analysis.graphstate.GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            state.newConstant("assortativity", BoxesRunTime.boxToDouble((double)this.calculation((Map<String, Object>)((Map)state.apply("linkCounter").value()), (List<Object>)((List)state.apply("nodeDegrees").value()), BoxesRunTime.unboxToDouble(state.apply("sumOfDegrees").value()))));
            return BoxedUnit.UNIT;
        });
    }

    public Map<String, Object> MapMerge(Map<String, Object> x, Map<String, Object> y) {
        return (Map)x.$plus$plus((IterableOnce)y.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t._1()), (Object)BoxesRunTime.boxToDouble((double)(t._2$mcD$sp() + BoxesRunTime.unboxToDouble((Object)x.getOrElse(t._1(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)))))));
    }

    public List<Object> ListMerge(List<Object> x, List<Object> y) {
        return y.nonEmpty() ? (x.contains(y.head()) ? x : (List)x.$plus$plus(y)) : x;
    }

    public double calculation(Map<String, Object> njk, List<Object> degrees, double edges) {
        DoubleRef sigma_1 = DoubleRef.create((double)0.0);
        DoubleRef sigma_2 = DoubleRef.create((double)0.0);
        DoubleRef molecular_1 = DoubleRef.create((double)0.0);
        DoubleRef molecular_2 = DoubleRef.create((double)0.0);
        scala.collection.mutable.Map excessDegreeDistribution = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef Pjk = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        degrees.foreach((Function1)(JFunction1.mcVI.sp & Serializable)k -> degrees.foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            Pjk$1.elem = this.MapMerge((Map<String, Object>)((Map)Pjk$1.elem), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(11).append(Integer.toString(k)).append(',').append(Integer.toString(j)).toString()), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)njk.getOrElse((Object)new StringBuilder(11).append(Integer.toString(k)).append(',').append(Integer.toString(j)).toString(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) / edges)))}))));
        }));
        degrees.foreach((Function1)(JFunction1.mcVI.sp & Serializable)k -> degrees.foreach((Function1 & Serializable)j -> Assortativity.$anonfun$calculation$5(excessDegreeDistribution, k, Pjk, BoxesRunTime.unboxToInt((Object)j))));
        degrees.foreach((Function1)(JFunction1.mcVI.sp & Serializable)degreeK -> {
            sigma_1$1.elem += package$.MODULE$.pow((double)degreeK, 2.0) * BoxesRunTime.unboxToDouble((Object)excessDegreeDistribution.getOrElse((Object)BoxesRunTime.boxToInteger((int)degreeK), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
            sigma_2$1.elem += (double)degreeK * BoxesRunTime.unboxToDouble((Object)excessDegreeDistribution.getOrElse((Object)BoxesRunTime.boxToInteger((int)degreeK), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
            degrees.foreach((Function1)(JFunction1.mcVI.sp & Serializable)degreeJ -> {
                molecular_1$1.elem += (double)(degreeJ * degreeK) * BoxesRunTime.unboxToDouble((Object)((Map)Pjk$1.elem).getOrElse((Object)new StringBuilder(11).append(Integer.toString(degreeJ)).append(',').append(Integer.toString(degreeK)).toString(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
                molecular_2$1.elem += (double)(degreeJ * degreeK) * BoxesRunTime.unboxToDouble((Object)excessDegreeDistribution.getOrElse((Object)BoxesRunTime.boxToInteger((int)degreeJ), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) * BoxesRunTime.unboxToDouble((Object)excessDegreeDistribution.getOrElse((Object)BoxesRunTime.boxToInteger((int)degreeK), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
            });
        });
        sigma_2.elem = package$.MODULE$.pow(sigma_2.elem, 2.0);
        return (molecular_1.elem - molecular_2.elem) / (sigma_1.elem - sigma_2.elem);
    }

    public static final /* synthetic */ void $anonfun$apply$1(Assortativity $this, com.raphtory.api.analysis.graphstate.GraphState globalState) {
        globalState.newAccumulator("linkCounter", Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), true, (Function2 & Serializable)(x, y) -> $this.MapMerge((Map<String, Object>)x, (Map<String, Object>)y));
        globalState.newAccumulator("nodeDegrees", scala.package$.MODULE$.List().apply((Seq)Nil$.MODULE$), true, (Function2 & Serializable)(x, y) -> $this.ListMerge((List<Object>)x, (List<Object>)y));
        globalState.newAdder("sumOfDegrees", true, Numeric.DoubleIsFractional$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$apply$4(Vertex vertex, com.raphtory.api.analysis.graphstate.GraphState globalState) {
        vertex.messageAllNeighbours(BoxesRunTime.boxToInteger((int)vertex.degree()), SchemaProviderInstances$.MODULE$.intSchemaProvider());
        globalState.apply("sumOfDegrees").$plus$eq(BoxesRunTime.boxToDouble((double)vertex.degree()));
        globalState.apply("nodeDegrees").$plus$eq(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{vertex.degree()})));
    }

    public static final /* synthetic */ void $anonfun$apply$5(Vertex vertex, com.raphtory.api.analysis.graphstate.GraphState globalState) {
        vertex.messageQueue().foreach((Function1)(JFunction1.mcVI.sp & Serializable)degree -> globalState.apply("linkCounter").$plus$eq(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(11).append(Integer.toString(vertex.degree())).append(',').append(Integer.toString(degree)).toString()), (Object)BoxesRunTime.boxToDouble((double)1.0))}))));
    }

    public static final /* synthetic */ Object $anonfun$calculation$5(scala.collection.mutable.Map excessDegreeDistribution$1, int k$2, ObjectRef Pjk$1, int j) {
        Growable growable;
        if (excessDegreeDistribution$1.contains((Object)BoxesRunTime.boxToInteger((int)k$2))) {
            excessDegreeDistribution$1.update((Object)BoxesRunTime.boxToInteger((int)k$2), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)excessDegreeDistribution$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)k$2), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) + BoxesRunTime.unboxToDouble((Object)((Map)Pjk$1.elem).getOrElse((Object)new StringBuilder(11).append(Integer.toString(j)).append(',').append(Integer.toString(k$2)).toString(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)))));
            growable = BoxedUnit.UNIT;
        } else {
            growable = excessDegreeDistribution$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k$2)), ((Map)Pjk$1.elem).getOrElse((Object)new StringBuilder(11).append(Integer.toString(j)).append(',').append(Integer.toString(k$2)).toString(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)));
        }
        return growable;
    }

    public Assortativity() {
        super((Seq<String>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"assortativity"}))), GraphState$.MODULE$.$lessinit$greater$default$2());
    }
}

