/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.algorithm.NodeListOutput;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`NodeList(properties: Seq[String] = Seq.empty[String], defaults: Map[String, Any] = Map.empty[String, Any])`\n  * {s}`NodeList(properties: String*)`\n  * {s}`NodeList(defaults: Map[String, Any], properties: String*)`\n  * : Write out nodes with selected properties to table with optional default values\n  *\n  * The first column in the table is the node's name and the other columns correspond to the selected properties\n  *\n  * Property names are looked up on a node's computational state first and then in a node's property.\n  * This means that this algorithm can be used as the last step in an algorithm chain to include output\n  * of intermediate results or non-default state. It is also useful as the base class for custom algorithms that\n  * should return a table of vertex states as result.\n  *\n  * ## Parameters\n  *\n  * {s}`properties: Seq[String]`\n  * : Sequence of property names\n  *\n  * {s}`defaults: Map[String, Any]`\n  * : Map from property names to default values\n  * (if a property name is not found on a node, it is first looked up in defaults,\n  * and if not found there, set to {s}`None`)\n  *\n  * ## Returns\n  *\n  * | vertex name       | Property1       | ... |\n  * | ----------------- | --------------- | --- |\n  * | {s}`name: String` | {s}`value: Any` | ... |\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.ConnectedComponents),\n  * [](com.raphtory.algorithms.generic.centrality.AverageNeighbourDegree),\n  * [](com.raphtory.algorithms.generic.centrality.Degree),\n  * [](com.raphtory.algorithms.generic.centrality.Distinctiveness),\n  * [](com.raphtory.algorithms.generic.centrality.PageRank),\n  * [](com.raphtory.algorithms.generic.centrality.WeightedDegree),\n  * [](com.raphtory.algorithms.generic.centrality.WeightedPageRank),\n  * [](com.raphtory.algorithms.generic.community.LPA),\n  * [](com.raphtory.algorithms.generic.dynamic.DiscreteSI),\n  * [](com.raphtory.algorithms.generic.dynamic.WattsCascade)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001B\b\u0011\u0001eA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!)a\t\u0001C\u0001\u000f\u001e)!\f\u0005E\u00017\u001a)q\u0002\u0005E\u00019\")a)\u0002C\u0001Q\")\u0011.\u0002C\u0001U\"9\u0001/BI\u0001\n\u0003\t\bb\u0002?\u0006#\u0003%\t! \u0005\u0006S\u0016!\ta \u0005\u0007S\u0016!\t!!\u0003\t\u0013\u0005=Q!%A\u0005\u0002\u0005E\u0001\u0002CA\u000b\u000bE\u0005I\u0011A?\t\u0013\u0005]Q!!A\u0005\n\u0005e!\u0001\u0003(pI\u0016d\u0015n\u001d;\u000b\u0005E\u0011\u0012aB4f]\u0016\u0014\u0018n\u0019\u0006\u0003'Q\t!\"\u00197h_JLG\u000f[7t\u0015\t)b#\u0001\u0005sCBDGo\u001c:z\u0015\u00059\u0012aA2p[\u000e\u00011c\u0001\u0001\u001bIA\u00111DI\u0007\u00029)\u0011QDH\u0001\nC2<wN]5uQ6T!a\b\u0011\u0002\u0011\u0005t\u0017\r\\=tSNT!!\t\u000b\u0002\u0007\u0005\u0004\u0018.\u0003\u0002$9\tqaj\u001c3f\u0019&\u001cHoT;uaV$\bCA\u000e&\u0013\t1CDA\u0004HK:,'/[2\u0002\u0015A\u0014x\u000e]3si&,7\u000fE\u0002*gYr!A\u000b\u0019\u000f\u0005-rS\"\u0001\u0017\u000b\u00055B\u0012A\u0002\u001fs_>$h(C\u00010\u0003\u0015\u00198-\u00197b\u0013\t\t$'A\u0004qC\u000e\\\u0017mZ3\u000b\u0003=J!\u0001N\u001b\u0003\u0007M+\u0017O\u0003\u00022eA\u0011qg\u000f\b\u0003qe\u0002\"a\u000b\u001a\n\u0005i\u0012\u0014A\u0002)sK\u0012,g-\u0003\u0002={\t11\u000b\u001e:j]\u001eT!A\u000f\u001a\u0002\u0011\u0011,g-Y;miN\u0004Ba\u000e!7\u0005&\u0011\u0011)\u0010\u0002\u0004\u001b\u0006\u0004\bCA\"E\u001b\u0005\u0011\u0014BA#3\u0005\r\te._\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007!S5\n\u0005\u0002J\u00015\t\u0001\u0003C\u0004(\u0007A\u0005\t\u0019\u0001\u0015\t\u000fy\u001a\u0001\u0013!a\u0001\u007f!\"\u0001!T,Y!\tqU+D\u0001P\u0015\t\u0001\u0016+\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\t\u00116+A\u0004uC.,'p\\3\u000b\u0005Q3\u0012AB4ji\",(-\u0003\u0002W\u001f\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001Z\u0003=%sF\u000b\u0016\u000bA\u0001R\u0003e_:~A:{G-\u001a'jgRD\u0003O]8qKJ$\u0018.Z:;AM+\u0017oW*ue&tw-\u0018\u0011>AM+\u0017OL3naRL8l\u0015;sS:<W\f\f\u0011eK\u001a\fW\u000f\u001c;tu\u0001j\u0015\r].TiJLgn\u001a\u0017!\u0003:LX\fI\u001f!\u001b\u0006\u0004h&Z7qif\\6\u000b\u001e:j]\u001ed\u0003%\u00118z;&\u0002'\u0002\t\u0011+Am\u001cX\u0010\u0019(pI\u0016d\u0015n\u001d;)aJ|\u0007/\u001a:uS\u0016\u001c(\bI*ue&twMK\u0015a\u0015\u0001\u0002#\u0006I>t{\u0002tu\u000eZ3MSN$\b\u0006Z3gCVdGo\u001d\u001e!\u001b\u0006\u00048l\u0015;sS:<G\u0006I!osvc\u0003\u0005\u001d:pa\u0016\u0014H/[3tu\u0001\u001aFO]5oO*J\u0003M\u0003\u0011!U\u0001R\u0004e\u0016:ji\u0016\u0004s.\u001e;!]>$Wm\u001d\u0011xSRD\u0007e]3mK\u000e$X\r\u001a\u0011qe>\u0004XM\u001d;jKN\u0004Co\u001c\u0011uC\ndW\rI<ji\"\u0004s\u000e\u001d;j_:\fG\u000e\t3fM\u0006,H\u000e\u001e\u0011wC2,Xm\u001d\u0006!A)R\u0001\u0005\t\u0016!)\",\u0007EZ5sgR\u00043m\u001c7v[:\u0004\u0013N\u001c\u0011uQ\u0016\u0004C/\u00192mK\u0002J7\u000f\t;iK\u0002rw\u000eZ3(g\u0002r\u0017-\\3!C:$\u0007\u0005\u001e5fA=$\b.\u001a:!G>dW/\u001c8tA\r|'O]3ta>tG\r\t;pAQDW\rI:fY\u0016\u001cG/\u001a3!aJ|\u0007/\u001a:uS\u0016\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t)s_B,'\u000f^=!]\u0006lWm\u001d\u0011be\u0016\u0004Cn\\8lK\u0012\u0004S\u000f\u001d\u0011p]\u0002\n\u0007E\\8eK\u001e\u001a\beY8naV$\u0018\r^5p]\u0006d\u0007e\u001d;bi\u0016\u0004c-\u001b:ti\u0002\ng\u000e\u001a\u0011uQ\u0016t\u0007%\u001b8!C\u0002rw\u000eZ3(g\u0002\u0002(o\u001c9feRLhF\u0003\u0011!U\u0001\"\u0006.[:![\u0016\fgn\u001d\u0011uQ\u0006$\b\u0005\u001e5jg\u0002\nGnZ8sSRDW\u000eI2b]\u0002\u0012W\rI;tK\u0012\u0004\u0013m\u001d\u0011uQ\u0016\u0004C.Y:uAM$X\r\u001d\u0011j]\u0002\ng\u000eI1mO>\u0014\u0018\u000e\u001e5nA\rD\u0017-\u001b8!i>\u0004\u0013N\\2mk\u0012,\u0007e\\;uaV$(\u0002\t\u0011+A=4\u0007%\u001b8uKJlW\rZ5bi\u0016\u0004#/Z:vYR\u001c\be\u001c:!]>tW\u0006Z3gCVdG\u000fI:uCR,g\u0006I%uA%\u001c\b%\u00197t_\u0002*8/\u001a4vY\u0002\n7\u000f\t;iK\u0002\u0012\u0017m]3!G2\f7o\u001d\u0011g_J\u00043-^:u_6\u0004\u0013\r\\4pe&$\b.\\:!i\"\fGO\u0003\u0011!U\u0001\u001a\bn\\;mI\u0002\u0012X\r^;s]\u0002\n\u0007\u0005^1cY\u0016\u0004sN\u001a\u0011wKJ$X\r\u001f\u0011ti\u0006$Xm\u001d\u0011bg\u0002\u0012Xm];mi:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!!\u0006\u0014\u0018-\\3uKJ\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006I>t{\u0002\u0004(o\u001c9feRLWm\u001d\u001e!'\u0016\f8l\u0015;sS:<W\f\u0019\u0006!A)\u0002#\bI*fcV,gnY3!_\u001a\u0004\u0003O]8qKJ$\u0018\u0010\t8b[\u0016\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006I>t{\u0002$WMZ1vYR\u001c(\bI'ban\u001bFO]5oO2\u0002\u0013I\\=^A*\u0001\u0003E\u000b\u0011;A5\u000b\u0007\u000f\t4s_6\u0004\u0003O]8qKJ$\u0018\u0010\t8b[\u0016\u001c\b\u0005^8!I\u00164\u0017-\u001e7uAY\fG.^3t\u0015\u0001\u0002#\u0006\t\u0015jM\u0002\n\u0007\u0005\u001d:pa\u0016\u0014H/\u001f\u0011oC6,\u0007%[:!]>$\bEZ8v]\u0012\u0004sN\u001c\u0011bA9|G-\u001a\u0017!SR\u0004\u0013n\u001d\u0011gSJ\u001cH\u000f\t7p_.,G\rI;qA%t\u0007\u0005Z3gCVdGo\u001d\u0017\u000bA\u0001R\u0003%\u00198eA%4\u0007E\\8uA\u0019|WO\u001c3!i\",'/\u001a\u0017!g\u0016$\b\u0005^8!wNl\bMT8oK\u0002L#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AI+G/\u001e:og*\u0001\u0003E\u000b\u0006!A)\u0002C\u0010\t<feR,\u0007\u0010\t8b[\u0016\u0004\u0003\u0005\t\u0011!A\u0001b\b\u0005\u0015:pa\u0016\u0014H/_\u0019!A\u0001\u0002\u0003\u0005\t\u0011}A9rc\u0006\t?\u000bA\u0001R\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&\f\u0011}\u0015\u0001\u0002#\u0006\t?!wNl\bM\\1nKj\u00023\u000b\u001e:j]\u001e\u0004\u0007\u0005 \u0011|gv\u0004g/\u00197vKj\u0002\u0013I\\=aAq\u0004cF\f\u0018!y*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\r\u00191|g\u0016,\u0017\r\\:p{*\u0001\u0003E\u000b\u0011\\;\"\u001aw.\u001c\u0018sCBDGo\u001c:z]\u0005dwm\u001c:ji\"l7OL4f]\u0016\u0014\u0018n\u0019\u0018D_:tWm\u0019;fI\u000e{W\u000e]8oK:$8/\u000b\u0017\u000bA\u0001R\u0003eW/)G>lgF]1qQR|'/\u001f\u0018bY\u001e|'/\u001b;i[Nts-\u001a8fe&\u001cgfY3oiJ\fG.\u001b;z]\u00053XM]1hK:+\u0017n\u001a5c_V\u0014H)Z4sK\u0016LCF\u0003\u0011!U\u0001ZV\fK2p[:\u0012\u0018\r\u001d5u_JLh&\u00197h_JLG\u000f[7t]\u001d,g.\u001a:jG:\u001aWM\u001c;sC2LG/\u001f\u0018EK\u001e\u0014X-Z\u0015-\u0015\u0001\u0002#\u0006I.^Q\r|WN\f:ba\"$xN]=/C2<wN]5uQ6\u001chfZ3oKJL7ML2f]R\u0014\u0018\r\\5us:\"\u0015n\u001d;j]\u000e$\u0018N^3oKN\u001c\u0018\u0006\f\u0006!A)\u00023,\u0018\u0015d_6t#/\u00199ii>\u0014\u0018PL1mO>\u0014\u0018\u000e\u001e5ng::WM\\3sS\u000et3-\u001a8ue\u0006d\u0017\u000e^=/!\u0006<WMU1oW&b#\u0002\t\u0011+Amk\u0006fY8n]I\f\u0007\u000f\u001b;peft\u0013\r\\4pe&$\b.\\:/O\u0016tWM]5d]\r,g\u000e\u001e:bY&$\u0018PL,fS\u001eDG/\u001a3EK\u001e\u0014X-Z\u0015-\u0015\u0001\u0002#\u0006I.^Q\r|WN\f:ba\"$xN]=/C2<wN]5uQ6\u001chfZ3oKJL7ML2f]R\u0014\u0018\r\\5us::V-[4ii\u0016$\u0007+Y4f%\u0006t7.\u000b\u0017\u000bA\u0001R\u0003eW/)G>lgF]1qQR|'/\u001f\u0018bY\u001e|'/\u001b;i[Nts-\u001a8fe&\u001cgfY8n[Vt\u0017\u000e^=/\u0019B\u000b\u0015\u0006\f\u0006!A)\u00023,\u0018\u0015d_6t#/\u00199ii>\u0014\u0018PL1mO>\u0014\u0018\u000e\u001e5ng::WM\\3sS\u000etC-\u001f8b[&\u001cg\u0006R5tGJ,G/Z*JS1R\u0001\u0005\t\u0016!7vC3m\\7/e\u0006\u0004\b\u000e^8ss:\nGnZ8sSRDWn\u001d\u0018hK:,'/[2/Ift\u0017-\\5d]]\u000bG\u000f^:DCN\u001c\u0017\rZ3*\u0015\u0001\u0002#\u0006\t1aA*\u0001\u0003EK\u0018\u0002\u00119{G-\u001a'jgR\u0004\"!S\u0003\u0014\u0007\u0015i\u0006\r\u0005\u0002D=&\u0011qL\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017AA5p\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003m\u000bQ!\u00199qYf$2\u0001S6p\u0011\u001d9s\u0001%AA\u00021\u00042!K77\u0013\tqWG\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001dqt\u0001%AA\u0002}\nq\"\u00199qYf$C-\u001a4bk2$H%M\u000b\u0002e*\u0012An]\u0016\u0002iB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001f\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002|m\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII*\u0012A \u0016\u0003\u007fM$2\u0001SA\u0001\u0011\u00199#\u00021\u0001\u0002\u0004A!1)!\u00027\u0013\r\t9A\r\u0002\u000byI,\u0007/Z1uK\u0012tD#\u0002%\u0002\f\u00055\u0001\"\u0002 \f\u0001\u0004y\u0004BB\u0014\f\u0001\u0004\t\u0019!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003'Q#\u0001K:\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\t\u0003Z\u0001\u0005Y\u0006tw-\u0003\u0003\u0002&\u0005}!AB(cU\u0016\u001cG\u000f")
public class NodeList
extends NodeListOutput
implements Generic {
    public static Map<String, Object> $lessinit$greater$default$2() {
        return NodeList$.MODULE$.$lessinit$greater$default$2();
    }

    public static Seq<String> $lessinit$greater$default$1() {
        return NodeList$.MODULE$.$lessinit$greater$default$1();
    }

    public static Map<String, Object> apply$default$2() {
        return NodeList$.MODULE$.apply$default$2();
    }

    public static Iterable<String> apply$default$1() {
        return NodeList$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Main algorithm\n    *\n    * Default implementation returns the graph unchanged.\n    * This should be overridden by subclasses to define the actual\n    * algorithm steps unless the algorithm only outputs existing state or properties.\n    *\n    * @param graph graph to run function upon\n    */")
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return Generic.apply$(this, graph);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    public NodeList(Seq<String> properties, Map<String, Object> defaults) {
        super(properties, defaults);
        Generic.$init$(this);
    }
}

