/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

@Scaladoc(value="/**\n  * {s}`NeighbourNames()`\n  *  : Get name of all neighbours and store the map from vertexID to name in state \"neighbourNames\".\n  *\n  *  This is mainly useful as part of algorithms or chains that return neighbourhood or edge information.\n  *\n  * ## States\n  *\n  *  {s}`neighbourNames: Map[Long, String]`\n  *    : map of vertex ID to name for all neighbours of vertex\n  *\n  * ## Returns\n  *\n  *  This algorithm does not return anything.\n  *\n  *  ```{seealso}\n  *  [](com.raphtory.algorithms.generic.EdgeList)\n  *  [](com.raphtory.algorithms.temporal.TemporalEdgeList)\n  *  ```\n  */")
public final class NeighbourNames$
implements Generic {
    public static final NeighbourNames$ MODULE$ = new NeighbourNames$();
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private static Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    static {
        BaseAlgorithm.$init$(MODULE$);
        Generic.$init$(MODULE$);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Write out results to a table (this method is only called after `apply`)\n    *\n    * The default implementation returns an empty table\n    *\n    * @param graph Graph that results from the call to `apply`\n    */")
    public Table tabularise(GraphPerspective graph) {
        return BaseAlgorithm.tabularise$(this, graph);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            vertex.messageAllNeighbours(new Tuple2(vertex.ID(), (Object)vertex.name(vertex.name$default$1())), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)vertex -> {
            NeighbourNames$.$anonfun$apply$2(vertex);
            return BoxedUnit.UNIT;
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NeighbourNames$.class);
    }

    public static final /* synthetic */ void $anonfun$apply$2(Vertex vertex) {
        ((EntityVisitor)((Object)vertex)).setState("neighbourNames", vertex.messageQueue().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private NeighbourNames$() {
    }
}

