/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.Coreness$;
import com.raphtory.algorithms.generic.KCore$;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import java.io.Serializable;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Scaladoc(value="/**\n* {s}`Coreness(1, 6)`\n* : Identify the maximal k for each vertex (the coreness, or k-core number) for which the vertex is in a k-core, here trying values of k from 1 to 6.\n*\n* https://en.wikipedia.org/wiki/Degeneracy_(graph_theory)\n*\n* ## Parameters\n*\n*  {s}`start: Int`\n*    : The value of k to start trying values from (inclusive).\n*\n*  {s}`end: Int`\n*    : The value of k to end at (inclusive).\n*\n* ## States\n*\n* {s}`CORENESS: Int`\n* : Stores the k value of maximum k-core the vertex is in out of the k values that have been tried.\n*\n* ## Returns\n*\n* | vertex name       | coreness           |\n* | ----------------- | ------------------ |\n* | {s}`name: String` | {s}`CORENESS: Int` |\n*\n* ## Implementation\n*\n* The algorithm repeats KCore for start to end values of k, using the resetStates = false flag on KCore so it only runs on the nodes in the previous (as the KCores with k = 3 is a subgraph of the KCores with k = 2 etc).\n* It updates the CORENESS state for all the nodes still alive in that KCore run, so the CORENESS state contains the highest value of k run of which that vertex was in the k-cores.\n*/")
@ScalaSignature(bytes="\u0006\u0005]4AAD\b\u00011!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001f\u0011\u0015)\u0003\u0001\"\u0001'\u0011\u001dQ\u0003A1A\u0005\u0006-BaA\f\u0001!\u0002\u001ba\u0003\"B\u0018\u0001\t\u0003\u0002t!\u0002)\u0010\u0011\u0003\tf!\u0002\b\u0010\u0011\u0003\u0011\u0006\"B\u0013\t\t\u0003q\u0006\"B\u0018\t\t\u0003y\u0006b\u00022\t#\u0003%\ta\u0019\u0005\b]\"\t\n\u0011\"\u0001d\u0011\u001dy\u0007\"!A\u0005\nA\u0014\u0001bQ8sK:,7o\u001d\u0006\u0003!E\tqaZ3oKJL7M\u0003\u0002\u0013'\u0005Q\u0011\r\\4pe&$\b.\\:\u000b\u0005Q)\u0012\u0001\u0003:ba\"$xN]=\u000b\u0003Y\t1aY8n\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iYR\"A\b\n\u0005qy!\u0001\u0003(pI\u0016d\u0015n\u001d;\u0002\u000bM$\u0018M\u001d;\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\u0007%sG/A\u0002f]\u0012\fa\u0001P5oSRtDcA\u0014)SA\u0011!\u0004\u0001\u0005\u0006;\r\u0001\rA\b\u0005\u0006I\r\u0001\rAH\u0001\t\u0007>\u0013VIT#T'V\tAfD\u0001.C\u0005Q\u0013!C\"P%\u0016sUiU*!\u0003\u0015\t\u0007\u000f\u001d7z)\t\tD\u0007\u0005\u00023\u0001:\u00111\u0007\u000e\u0007\u0001\u0011\u0015)d\u00011\u00017\u0003\u00159'/\u00199i!\t9d(D\u00019\u0015\tI$(A\u0005he\u0006\u0004\bN^5fo*\u00111\bP\u0001\tC:\fG._:jg*\u0011QhE\u0001\u0004CBL\u0017BA 9\u0005A9%/\u00199i!\u0016\u00148\u000f]3di&4X-\u0003\u0002B}\t)qI]1qQ\"\"\u0001aQ'O!\t!5*D\u0001F\u0015\t1u)\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\tA\u0015*A\u0004uC.,'p\\3\u000b\u0005)+\u0012AB4ji\",(-\u0003\u0002M\u000b\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001P\u0003!mvF\u000b\u0016\u000bU\u0001Z8/ 1D_J,g.Z:tQEb\u0003EN\u0015a\u0015)\u0002#\bI%eK:$\u0018NZ=!i\",\u0007%\\1yS6\fG\u000eI6!M>\u0014\b%Z1dQ\u00022XM\u001d;fq\u0002BC\u000f[3!G>\u0014XM\\3tg2\u0002sN\u001d\u0011l[\r|'/\u001a\u0011ok6\u0014WM]\u0015!M>\u0014\be\u001e5jG\"\u0004C\u000f[3!m\u0016\u0014H/\u001a=!SN\u0004\u0013N\u001c\u0011bA-l3m\u001c:fY\u0001BWM]3!iJL\u0018N\\4!m\u0006dW/Z:!_\u001a\u00043\u000e\t4s_6\u0004\u0013\u0007\t;pAYr#B\u000b\u0006+A!$H\u000f]:;_=*gNL<jW&\u0004X\rZ5b]=\u0014xmL<jW&|C)Z4f]\u0016\u0014\u0018mY=`Q\u001d\u0014\u0018\r\u001d5`i\",wN]=*\u0015)R!\u0006I\u0012$AA\u000b'/Y7fi\u0016\u00148O\u0003\u0016\u000bU\u0001\u00023p]?agR\f'\u000f\u001e\u001e!\u0013:$\bM\u0003\u0016!A\u0001\u0002#\b\t+iK\u00022\u0018\r\\;fA=4\u0007e\u001b\u0011u_\u0002\u001aH/\u0019:uAQ\u0014\u00180\u001b8hAY\fG.^3tA\u0019\u0014x.\u001c\u0011)S:\u001cG.^:jm\u0016LcF\u0003\u0016\u000bU\u0001\u00023p]?aK:$'\bI%oi\u0002T!\u0006\t\u0011!Ai\u0002C\u000b[3!m\u0006dW/\u001a\u0011pM\u0002Z\u0007\u0005^8!K:$\u0007%\u0019;!Q%t7\r\\;tSZ,\u0017F\f\u0006+\u0015)\u00023e\t\u0011Ti\u0006$Xm\u001d\u0006+\u0015)\u00023p]?a\u0007>\u0013VIT#T'j\u0002\u0013J\u001c;a\u0015)\u0002#\bI*u_J,7\u000f\t;iK\u0002Z\u0007E^1mk\u0016\u0004sN\u001a\u0011nCbLW.^7!W6\u001awN]3!i\",\u0007E^3si\u0016D\b%[:!S:\u0004s.\u001e;!_\u001a\u0004C\u000f[3!W\u00022\u0018\r\\;fg\u0002\"\b.\u0019;!Q\u00064X\r\t2fK:\u0004CO]5fI:R!F\u0003\u0016!G\r\u0002#+\u001a;ve:\u001c(B\u000b\u0006+Aq\u0004c/\u001a:uKb\u0004c.Y7fA\u0001\u0002\u0003\u0005\t\u0011!y\u0002\u001awN]3oKN\u001c\b\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!y*Q\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[5\u0002CP\u0003\u0016!y\u0002Z8/ 1oC6,'\bI*ue&tw\r\u0019\u0011}Am\u001cX\u0010Y\"P%\u0016sUiU*;A%sG\u000f\u0019\u0011}\u0015)R!\u0006I\u0012$A%k\u0007\u000f\\3nK:$\u0018\r^5p]*Q#B\u000b\u0011UQ\u0016\u0004\u0013\r\\4pe&$\b.\u001c\u0011sKB,\u0017\r^:!\u0017\u000e{'/\u001a\u0011g_J\u00043\u000f^1si\u0002\"x\u000eI3oI\u00022\u0018\r\\;fg\u0002zg\rI6-AU\u001c\u0018N\\4!i\",\u0007E]3tKR\u001cF/\u0019;fg\u0002j\u0004EZ1mg\u0016\u0004c\r\\1hA=t\u0007eS\"pe\u0016\u00043o\u001c\u0011ji\u0002zg\u000e\\=!eVt7\u000fI8oAQDW\r\t8pI\u0016\u001c\b%\u001b8!i\",\u0007\u0005\u001d:fm&|Wo\u001d\u0011)CN\u0004C\u000f[3!\u0017\u000e{'/Z:!o&$\b\u000eI6!{\u0001\u001a\u0004%[:!C\u0002\u001aXOY4sCBD\u0007e\u001c4!i\",\u0007eS\"pe\u0016\u001c\be^5uQ\u0002Z\u0007%\u0010\u00113A\u0015$8-\u000b\u0018\u000bU\u0001JE\u000fI;qI\u0006$Xm\u001d\u0011uQ\u0016\u00043i\u0014*F\u001d\u0016\u001b6\u000bI:uCR,\u0007EZ8sA\u0005dG\u000e\t;iK\u0002rw\u000eZ3tAM$\u0018\u000e\u001c7!C2Lg/\u001a\u0011j]\u0002\"\b.\u0019;!\u0017\u000e{'/\u001a\u0011sk:d\u0003e]8!i\",\u0007eQ(S\u000b:+5k\u0015\u0011ti\u0006$X\rI2p]R\f\u0017N\\:!i\",\u0007\u0005[5hQ\u0016\u001cH\u000f\t<bYV,\u0007e\u001c4!W\u0002\u0012XO\u001c\u0011pM\u0002:\b.[2iAQD\u0017\r\u001e\u0011wKJ$X\r\u001f\u0011xCN\u0004\u0013N\u001c\u0011uQ\u0016\u00043.L2pe\u0016\u001chF\u0003\u00160\u0003!\u0019uN]3oKN\u001c\bC\u0001\u000e\t'\rA1K\u0016\t\u0003?QK!!\u0016\u0011\u0003\r\u0005s\u0017PU3g!\t9F,D\u0001Y\u0015\tI&,\u0001\u0002j_*\t1,\u0001\u0003kCZ\f\u0017BA/Y\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005\tFcA\u0014aC\"9QD\u0003I\u0001\u0002\u0004q\u0002b\u0002\u0013\u000b!\u0003\u0005\rAH\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tAM\u000b\u0002\u001fK.\na\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003W\u0002\n!\"\u00198o_R\fG/[8o\u0013\ti\u0007NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002cB\u0011!/^\u0007\u0002g*\u0011AOW\u0001\u0005Y\u0006tw-\u0003\u0002wg\n1qJ\u00196fGR\u0004")
public class Coreness
extends NodeList {
    private final int start;
    private final int end;

    public static int apply$default$2() {
        return Coreness$.MODULE$.apply$default$2();
    }

    public static int apply$default$1() {
        return Coreness$.MODULE$.apply$default$1();
    }

    public final String CORENESS() {
        return "CORENESS";
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        ObjectRef g = ObjectRef.create((Object)graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            Coreness.$anonfun$apply$1(vertex);
            return BoxedUnit.UNIT;
        }));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(this.start), this.end).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)k -> {
            g$1.elem = KCore$.MODULE$.apply(k, false).apply((ConcreteGraphPerspective)g$1.elem).clearMessages().step((Function1 & Serializable)vertex -> {
                Coreness.$anonfun$apply$3(k, vertex);
                return BoxedUnit.UNIT;
            });
        });
        return (ConcreteGraphPerspective)g.elem;
    }

    public static final /* synthetic */ void $anonfun$apply$1(Vertex vertex) {
        ((EntityVisitor)((Object)vertex)).setState("CORENESS", BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ void $anonfun$apply$3(int k$1, Vertex vertex) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("effectiveDegree", ((EntityVisitor)((Object)vertex)).getState$default$2())) < k$1) break block0;
            ((EntityVisitor)((Object)vertex)).setState("CORENESS", BoxesRunTime.boxToInteger((int)k$1));
        }
    }

    public Coreness(int start, int end) {
        this.start = start;
        this.end = end;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CORENESS"}))), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CORENESS"), (Object)BoxesRunTime.boxToInteger((int)-1))}))));
        if (start > end | start < 0) {
            throw new IllegalArgumentException(new StringBuilder(90).append("start and end parameters must be non-negative and start <= end. You inputted start=").append(start).append(", end=").append(end).append(".").toString());
        }
    }
}

