/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.AdjPlus$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`AdjPlus()`\n  * : AdjPlus transform of the graph\n  *\n  *  This transforms the graph using the AdjPlus projection, which treats the input graph as undirected and returns a\n  *  directed graph where all edges point from low to high degree.\n  *  For each vertex, the algorithm finds the set of neighbours that have a larger degree than the current vertex\n  *  or the same degree and a larger ID and store it as state \"adjPlus\". This algorithm treats the network as undirected.\n  *  Further, the vertex IDs in \"adjPlus\" are ordered by increasing degree. This projection is particularly useful to\n  *  make certain motif-counting algorithms more efficient.\n  *\n  * ## States\n  *\n  *  {s}`adjPlus: Array[Long]`\n  *  : List of neighbour IDs that have a larger degree than the current vertex\n  *    or the same degree and a larger ID, ordered by increasing degree\n  *\n  * ## Returns\n  *  edge list for the AdjPlus projection\n  *\n  *  | source name          | destination name     |\n  *  | -------------------- | -------------------- |\n  *  | {s}`srcName: String` | {s}`dstName: String` |\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.motif.SquareCount)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u001d<Q\u0001C\u0005\t\u0002I1Q\u0001F\u0005\t\u0002UAQAJ\u0001\u0005\u0002\u001dBq\u0001K\u0001C\u0002\u0013%\u0011\u0006\u0003\u0004;\u0003\u0001\u0006IA\u000b\u0005\u0006w\u0005!\t\u0005\u0010\u0005\u0006\u0015\u0006!\te\u0013\u0005\b'\u0006\t\t\u0011\"\u0003U\u0003\u001d\tEM\u001b)mkNT!AC\u0006\u0002\u000f\u001d,g.\u001a:jG*\u0011A\"D\u0001\u000bC2<wN]5uQ6\u001c(B\u0001\b\u0010\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\t\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005M\tQ\"A\u0005\u0003\u000f\u0005#'\u000e\u00157vgN\u0019\u0011A\u0006\u000f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g!\tiB%D\u0001\u001f\u0015\ty\u0002%A\u0005bY\u001e|'/\u001b;i[*\u0011\u0011EI\u0001\tC:\fG._:jg*\u00111%D\u0001\u0004CBL\u0017BA\u0013\u001f\u0005\u001d9UM\\3sS\u000e\fa\u0001P5oSRtD#\u0001\n\u0002\u000f\r|G.^7ogV\t!\u0006E\u0002,aIj\u0011\u0001\f\u0006\u0003[9\n\u0011\"[7nkR\f'\r\\3\u000b\u0005=B\u0012AC2pY2,7\r^5p]&\u0011\u0011\u0007\f\u0002\u0005\u0019&\u001cH\u000f\u0005\u00024q5\tAG\u0003\u00026m\u0005!A.\u00198h\u0015\u00059\u0014\u0001\u00026bm\u0006L!!\u000f\u001b\u0003\rM#(/\u001b8h\u0003!\u0019w\u000e\\;n]N\u0004\u0013!B1qa2LHCA\u001fA!\tq\u0004J\u0004\u0002@\u00012\u0001\u0001\"B!\u0006\u0001\u0004\u0011\u0015!B4sCBD\u0007CA\"G\u001b\u0005!%BA#!\u0003%9'/\u00199im&,w/\u0003\u0002H\t\n\u0001rI]1qQB+'o\u001d9fGRLg/Z\u0005\u0003\u0013\u001a\u0013Qa\u0012:ba\"\f!\u0002^1ck2\f'/[:f)\ta%\u000b\u0005\u0002N!6\taJ\u0003\u0002PA\u0005)A/\u00192mK&\u0011\u0011K\u0014\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0006\u0003\u001a\u0001\rAQ\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002+B\u00111GV\u0005\u0003/R\u0012aa\u00142kK\u000e$\b\u0006B\u0001ZG\u0012\u0004\"AW1\u000e\u0003mS!\u0001X/\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!AX0\u0002\u000fQ\f7.\u001a>pK*\u0011\u0001mD\u0001\u0007O&$\b.\u001e2\n\u0005\t\\&\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003\u0015\f\u0011RH\u0018+U)\u0001\u0003E\u000b\u0011|gv\u0004\u0017\t\u001a6QYV\u001c\b&\u000b1\u000bA\u0001R\u0003E\u000f\u0011BI*\u0004F.^:!iJ\fgn\u001d4pe6\u0004sN\u001a\u0011uQ\u0016\u0004sM]1qQ*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005\u00165jg\u0002\"(/\u00198tM>\u0014Xn\u001d\u0011uQ\u0016\u0004sM]1qQ\u0002*8/\u001b8hAQDW\rI!eUBcWo\u001d\u0011qe>TWm\u0019;j_:d\u0003e\u001e5jG\"\u0004CO]3biN\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011he\u0006\u0004\b\u000eI1tAUtG-\u001b:fGR,G\rI1oI\u0002\u0012X\r^;s]N\u0004\u0013M\u0003\u0011!U\u0001\u0002C-\u001b:fGR,G\rI4sCBD\u0007e\u001e5fe\u0016\u0004\u0013\r\u001c7!K\u0012<Wm\u001d\u0011q_&tG\u000f\t4s_6\u0004Cn\\<!i>\u0004\u0003.[4iA\u0011,wM]3f])\u0001\u0003E\u000b\u0011!\r>\u0014\b%Z1dQ\u00022XM\u001d;fq2\u0002C\u000f[3!C2<wN]5uQ6\u0004c-\u001b8eg\u0002\"\b.\u001a\u0011tKR\u0004sN\u001a\u0011oK&<\u0007NY8veN\u0004C\u000f[1uA!\fg/\u001a\u0011bA1\f'oZ3sA\u0011,wM]3fAQD\u0017M\u001c\u0011uQ\u0016\u00043-\u001e:sK:$\bE^3si\u0016D(\u0002\t\u0011+A\u0001z'\u000f\t;iK\u0002\u001a\u0018-\\3!I\u0016<'/Z3!C:$\u0007%\u0019\u0011mCJ<WM\u001d\u0011J\t\u0002\ng\u000e\u001a\u0011ti>\u0014X\rI5uA\u0005\u001c\be\u001d;bi\u0016\u0004#%\u00193k!2,8O\t\u0018!)\"L7\u000fI1mO>\u0014\u0018\u000e\u001e5nAQ\u0014X-\u0019;tAQDW\r\t8fi^|'o\u001b\u0011bg\u0002*h\u000eZ5sK\u000e$X\r\u001a\u0018\u000bA\u0001R\u0003\u0005\t$veRDWM\u001d\u0017!i\",\u0007E^3si\u0016D\b%\u0013#tA%t\u0007EI1eUBcWo\u001d\u0012!CJ,\u0007e\u001c:eKJ,G\r\t2zA%t7M]3bg&tw\r\t3fOJ,WM\f\u0011UQ&\u001c\b\u0005\u001d:pU\u0016\u001cG/[8oA%\u001c\b\u0005]1si&\u001cW\u000f\\1sYf\u0004So]3gk2\u0004Co\u001c\u0006!A)\u0002\u0003%\\1lK\u0002\u001aWM\u001d;bS:\u0004Sn\u001c;jM6\u001aw.\u001e8uS:<\u0007%\u00197h_JLG\u000f[7tA5|'/\u001a\u0011fM\u001aL7-[3oi:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!'R\fG/Z:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1bI*\u0004F.^:;A\u0005\u0013(/Y=\\\u0019>tw-\u00181\u000bA\u0001R\u0003\u0005\t\u001e!\u0019&\u001cH\u000fI8gA9,\u0017n\u001a5c_V\u0014\b%\u0013#tAQD\u0017\r\u001e\u0011iCZ,\u0007%\u0019\u0011mCJ<WM\u001d\u0011eK\u001e\u0014X-\u001a\u0011uQ\u0006t\u0007\u0005\u001e5fA\r,(O]3oi\u00022XM\u001d;fq*\u0001\u0003E\u000b\u0011!A\u0001z'\u000f\t;iK\u0002\u001a\u0018-\\3!I\u0016<'/Z3!C:$\u0007%\u0019\u0011mCJ<WM\u001d\u0011J\t2\u0002sN\u001d3fe\u0016$\u0007EY=!S:\u001c'/Z1tS:<\u0007\u0005Z3he\u0016,'\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AI+G/\u001e:og*\u0001\u0003E\u000b\u0011!K\u0012<W\r\t7jgR\u0004cm\u001c:!i\",\u0007%\u00113k!2,8\u000f\t9s_*,7\r^5p]*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005 \u0011t_V\u00148-\u001a\u0011oC6,\u0007\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011}A\u0011,7\u000f^5oCRLwN\u001c\u0011oC6,\u0007\u0005\t\u0011!AqT\u0001\u0005\t\u0016!Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?\u000bA\u0001R\u0003\u0005\t?!wNl\bm\u001d:d\u001d\u0006lWM\u000f\u0011TiJLgn\u001a1!y\u0002Z8/ 1egRt\u0015-\\3;AM#(/\u001b8hA\u0002b(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t1aAn\u001cX-Z1mg>l(\u0002\t\u0011+Amk\u0006fY8n]I\f\u0007\u000f\u001b;peft\u0013\r\\4pe&$\b.\\:/O\u0016tWM]5d]5|G/\u001b4/'F,\u0018M]3D_VtG/\u000b\u0006!A)\u0002\u0003\r\u00191\u000bA\u0001Rs\u0006\u000b\u0003\u00013\u000e$\u0007")
public final class AdjPlus {
    public static Table tabularise(GraphPerspective graph) {
        return AdjPlus$.MODULE$.tabularise(graph);
    }

    public static ConcreteGraphPerspective apply(GraphPerspective graph) {
        return AdjPlus$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return AdjPlus$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return AdjPlus$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static Generic $minus$greater(Generic other) {
        return AdjPlus$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return AdjPlus$.MODULE$.name();
    }

    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public static Table run(GraphPerspective graph) {
        return AdjPlus$.MODULE$.run(graph);
    }
}

