/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.filters;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.Vertex;
import scala.Function1;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`VertexFilter(f: Vertex => Boolean)`\n  *   : Filtered view of the graph achieved by retaining vertices according to a predicate function {s}`f`\n  *\n  *   This transforms the graph by keeping only vertices for which {s}`f` returns true. This fits well within a chain of\n  *   algorithms as a way of pruning the graph: for example, one could first filter out vertices below a certain degree\n  *   before running a chosen algorithm.\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.filters.VertexFilterGraphState)\n  * [](com.raphtory.algorithms.filters.VertexQuantileFilter)\n  * [](com.raphtory.algorithms.filters.EdgeFilter)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005%4A!\u0003\u0006\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003/\u0001\u0011\u0005q\u0006C\u00034\u0001\u0011\u0005CgB\u0003Q\u0015!\u0005\u0011KB\u0003\n\u0015!\u0005!\u000bC\u0003/\u000b\u0011\u0005a\fC\u00034\u000b\u0011\u0005q\fC\u0004b\u000b\u0005\u0005I\u0011\u00022\u0003\u0019Y+'\u000f^3y\r&dG/\u001a:\u000b\u0005-a\u0011a\u00024jYR,'o\u001d\u0006\u0003\u001b9\t!\"\u00197h_JLG\u000f[7t\u0015\ty\u0001#\u0001\u0005sCBDGo\u001c:z\u0015\u0005\t\u0012aA2p[\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9B\"A\u0004hK:,'/[2\n\u0005e1\"\u0001\u0003(pI\u0016d\u0015n\u001d;\u0002\u0003\u0019\u0004B\u0001H\u0010\"W5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SDA\u0005Gk:\u001cG/[8ocA\u0011!%K\u0007\u0002G)\u0011A%J\u0001\bm&\u001c\u0018\u000e^8s\u0015\t1s%\u0001\u0005b]\u0006d\u0017p]5t\u0015\tAc\"A\u0002ba&L!AK\u0012\u0003\rY+'\u000f^3y!\taB&\u0003\u0002.;\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u00021eA\u0011\u0011\u0007A\u0007\u0002\u0015!)!D\u0001a\u00017\u0005)\u0011\r\u001d9msR\u0011Q\u0007\u000f\t\u0003m\u0001s!a\u000e\u001d\r\u0001!)\u0011h\u0001a\u0001u\u0005)qM]1qQB\u00111HP\u0007\u0002y)\u0011Q(J\u0001\nOJ\f\u0007\u000f\u001b<jK^L!a\u0010\u001f\u0003!\u001d\u0013\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0017BA!?\u0005\u00159%/\u00199iQ\u0011\u00011)\u0014(\u0011\u0005\u0011[U\"A#\u000b\u0005\u0019;\u0015\u0001C:dC2\fGm\\2\u000b\u0005!K\u0015a\u0002;bW\u0016Tx.\u001a\u0006\u0003\u0015B\taaZ5uQV\u0014\u0017B\u0001'F\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017%A(\u0002\u000b'y#F\u000b\u0006!A)\u00023p]?a-\u0016\u0014H/\u001a=GS2$XM\u001d\u0015gu\u00012VM\u001d;fq\u0002jd\b\t\"p_2,\u0017M\\\u0015a\u0015\u0001\u0002#\u0006\t\u0011!u\u00012\u0015\u000e\u001c;fe\u0016$\u0007E^5fo\u0002zg\r\t;iK\u0002:'/\u00199iA\u0005\u001c\u0007.[3wK\u0012\u0004#-\u001f\u0011sKR\f\u0017N\\5oO\u00022XM\u001d;jG\u0016\u001c\b%Y2d_J$\u0017N\\4!i>\u0004\u0013\r\t9sK\u0012L7-\u0019;fA\u0019,hn\u0019;j_:\u00043p]?aM\u0002T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t\u0011UQ&\u001c\b\u0005\u001e:b]N4wN]7tAQDW\rI4sCBD\u0007EY=!W\u0016,\u0007/\u001b8hA=tG.\u001f\u0011wKJ$\u0018nY3tA\u0019|'\u000fI<iS\u000eD\u0007e_:~A\u001a\u0004\u0007E]3ukJt7\u000f\t;sk\u0016t\u0003\u0005\u00165jg\u00022\u0017\u000e^:!o\u0016dG\u000eI<ji\"Lg\u000eI1!G\"\f\u0017N\u001c\u0011pM*\u0001\u0003E\u000b\u0011!A\u0005dwm\u001c:ji\"l7\u000fI1tA\u0005\u0004s/Y=!_\u001a\u0004\u0003O];oS:<\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5;A\u0019|'\u000fI3yC6\u0004H.\u001a\u0017!_:,\u0007eY8vY\u0012\u0004c-\u001b:ti\u00022\u0017\u000e\u001c;fe\u0002zW\u000f\u001e\u0011wKJ$\u0018nY3tA\t,Gn\\<!C\u0002\u001aWM\u001d;bS:\u0004C-Z4sK\u0016T\u0001\u0005\t\u0016!A\u0001\u0012WMZ8sK\u0002\u0012XO\u001c8j]\u001e\u0004\u0013\rI2i_N,g\u000eI1mO>\u0014\u0018\u000e\u001e5n])\u0001\u0003E\u000b\u0006!A)\u0002\u0003\r\u00191|g\u0016,\u0017\r\\:p{*\u0001\u0003E\u000b\u0011\\;\"\u001aw.\u001c\u0018sCBDGo\u001c:z]\u0005dwm\u001c:ji\"l7O\f4jYR,'o\u001d\u0018WKJ$X\r\u001f$jYR,'o\u0012:ba\"\u001cF/\u0019;fS)\u0001\u0003E\u000b\u0011\\;\"\u001aw.\u001c\u0018sCBDGo\u001c:z]\u0005dwm\u001c:ji\"l7O\f4jYR,'o\u001d\u0018WKJ$X\r_)vC:$\u0018\u000e\\3GS2$XM]\u0015\u000bA\u0001R\u0003eW/)G>lgF]1qQR|'/\u001f\u0018bY\u001e|'/\u001b;i[Ntc-\u001b7uKJ\u001ch&\u00123hK\u001aKG\u000e^3sS)\u0001\u0003E\u000b\u0011aA\u0002T\u0001\u0005\t\u00160\u000311VM\u001d;fq\u001aKG\u000e^3s!\t\tTaE\u0002\u0006'Z\u0003\"\u0001\b+\n\u0005Uk\"AB!osJ+g\r\u0005\u0002X96\t\u0001L\u0003\u0002Z5\u0006\u0011\u0011n\u001c\u0006\u00027\u0006!!.\u0019<b\u0013\ti\u0006L\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001R)\t\u0001\u0004\rC\u0003\u001b\u000f\u0001\u00071$\u0001\u0007xe&$XMU3qY\u0006\u001cW\rF\u0001d!\t!w-D\u0001f\u0015\t1',\u0001\u0003mC:<\u0017B\u00015f\u0005\u0019y%M[3di\u0002")
public class VertexFilter
extends NodeList {
    private final Function1<Vertex, Object> f;

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.vertexFilter(this.f);
    }

    public VertexFilter(Function1<Vertex, Object> f) {
        this.f = f;
        super(NodeList$.MODULE$.$lessinit$greater$default$1(), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

