/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.filters;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.filters.EdgeQuantileFilter$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.Accumulator;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphstate.Histogram;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.ConcreteEdge;
import com.raphtory.api.analysis.visitor.Edge;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.utils.Bounded;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Scaladoc(value="/**\n  * {s}`EdqeQuantileFilter()`\n  * : Filtered view of the graph based on edge weight\n  *\n  *  This creates a filtered view of the graph where edges are removed based on where their weight value lays in the global\n  *  distribution of edge weights, understood in this algorithm as percentiles. For example, one can create a view of the\n  *  graph including only the top 50% of edges. This algorithm does not return any output and is best used in composition\n  *  with other algorithms, using the Chain API. The algorithm treats the network as directed.\n  *\n  * ## Parameters\n  *\n  *  {s}`lower: Float = 0.0f`\n  *  : The lower cutoff percentile below which edges will be removed, a float with 0 <= lower <= upper <=1.0 with default value 0.0f\n  *\n  *  {s}`upper: Float = 1.0f`\n  *  : The upper cutoff percentile above which edges will be removed, a float with 0 <= lower <= upper <=1.0 with default value 1.0f\n  *\n  *  {s}`weightString: String = \"weight\"`\n  *  : String name of the weight property, defaulting to \"weight\". As with other weighted algorithms in Raphtory, if no weight property\n  *  is there but multi-edges are present, the number of occurrences of each edge is treated as the weight.\n  *\n  *  {s}`lowerExclusive: Boolean = \"false\"`\n  *  : whether the inequality on the edge weight threshold is strict or not at the lower end\n  *\n  *  {s}`upperExclusive: Boolean = \"false\"`\n  *  : whether the inequality on the edge weight threshold is strict or not at the upper end\n  *\n  *  {s}`noBins: Int = 1000`\n  *  : Number of bins to be used in the histogram. The more the bins, the more precise the thresholds can be (depending on the underlying\n  *  distribution of the edge weight data) but the bigger the array being broadcast.\n  *\n  *  {s}`pruneNodes: Boolean = true`\n  *  : if set to true, nodes which are left without any incoming or outgoing edges by the end of this filtering are also pruned from the graph.\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.filters.EdgeFilter)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\tUa\u0001\u0002\u0011\"\u0001)B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005{!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!\t\u0006A!A!\u0002\u0013q\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011Y\u0003!\u0011!Q\u0001\n9C\u0001b\u0016\u0001\u0003\u0004\u0003\u0006Y\u0001\u0017\u0005\tY\u0002\u0011\u0019\u0011)A\u0006[\"A1\u000f\u0001B\u0002B\u0003-A\u000fC\u0003{\u0001\u0011\u00051\u0010C\u0004\u0002\u0014\u0001!\t%!\u0006\b\u000f\u0005-\u0013\u0005#\u0001\u0002N\u00191\u0001%\tE\u0001\u0003\u001fBaA\u001f\b\u0005\u0002\u0005\u0005\u0004bBA\n\u001d\u0011\u0005\u00111\r\u0005\n\u0003\u001fs\u0011\u0013!C\u0001\u0003#C\u0011\"a+\u000f#\u0003%\t!!,\t\u0013\u0005Ef\"%A\u0005\u0002\u0005M\u0006\"CA^\u001dE\u0005I\u0011AA_\u0011%\t)MDI\u0001\n\u0003\t9\rC\u0005\u0002L:\t\n\u0011\"\u0001\u0002N\"I\u0011Q\u001b\b\u0012\u0002\u0013\u0005\u0011q\u001b\u0005\n\u00037t\u0011\u0013!C\u0001\u0003;D\u0011\"!9\u000f#\u0003%\t!a9\t\u0013\u0005\u001dh\"%A\u0005\u0002\u0005%\b\"CAw\u001dE\u0005I\u0011AAx\u0011%\t\u0019PDI\u0001\n\u0003\t)\u0010C\u0005\u0002z:\t\n\u0011\"\u0001\u0002|\"I\u0011q \b\u0012\u0002\u0013\u0005!\u0011\u0001\u0005\n\u0005\u000bq\u0011\u0011!C\u0005\u0005\u000f\u0011!#\u00123hKF+\u0018M\u001c;jY\u00164\u0015\u000e\u001c;fe*\u0011!eI\u0001\bM&dG/\u001a:t\u0015\t!S%\u0001\u0006bY\u001e|'/\u001b;i[NT!AJ\u0014\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011\u0001K\u0001\u0004G>l7\u0001A\u000b\u0003W\r\u001c2\u0001\u0001\u00173!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fMB\u00111GO\u0007\u0002i)\u0011QGN\u0001\nC2<wN]5uQ6T!a\u000e\u001d\u0002\u0011\u0005t\u0017\r\\=tSNT!!O\u0013\u0002\u0007\u0005\u0004\u0018.\u0003\u0002<i\t9q)\u001a8fe&\u001c\u0017!\u00027po\u0016\u0014\bCA\u0017?\u0013\tydFA\u0003GY>\fG/A\u0003vaB,'/\u0001\u0007xK&<\u0007\u000e^*ue&tw\r\u0005\u0002D\u0015:\u0011A\t\u0013\t\u0003\u000b:j\u0011A\u0012\u0006\u0003\u000f&\na\u0001\u0010:p_Rt\u0014BA%/\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%s\u0013A\u00047po\u0016\u0014X\t_2mkNLg/\u001a\t\u0003[=K!\u0001\u0015\u0018\u0003\u000f\t{w\u000e\\3b]\u0006qQ\u000f\u001d9fe\u0016C8\r\\;tSZ,\u0017A\u00028p\u0005&t7\u000f\u0005\u0002.)&\u0011QK\f\u0002\u0004\u0013:$\u0018A\u00039sk:,gj\u001c3fg\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007es\u0016M\u0004\u0002[9:\u0011QiW\u0005\u0002_%\u0011QLL\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0006MA\u0004Ok6,'/[2\u000b\u0005us\u0003C\u00012d\u0019\u0001!Q\u0001\u001a\u0001C\u0002\u0015\u0014\u0011\u0001V\t\u0003M&\u0004\"!L4\n\u0005!t#a\u0002(pi\"Lgn\u001a\t\u0003[)L!a\u001b\u0018\u0003\u0007\u0005s\u00170\u0001\u0006fm&$WM\\2fII\u00022A\\9b\u001b\u0005y'B\u00019&\u0003\u0015)H/\u001b7t\u0013\t\u0011xNA\u0004C_VtG-\u001a3\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007E\u0002vq\u0006l\u0011A\u001e\u0006\u0003o:\nqA]3gY\u0016\u001cG/\u0003\u0002zm\nA1\t\\1tgR\u000bw-\u0001\u0004=S:LGO\u0010\u000b\u0010y\u0006\u0015\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0002\u0012Q1Qp`A\u0001\u0003\u0007\u00012A \u0001b\u001b\u0005\t\u0003\"B,\f\u0001\bA\u0006\"\u00027\f\u0001\bi\u0007\"B:\f\u0001\b!\bb\u0002\u001f\f!\u0003\u0005\r!\u0010\u0005\b\u0001.\u0001\n\u00111\u0001>\u0011\u001d\t5\u0002%AA\u0002\tCq!T\u0006\u0011\u0002\u0003\u0007a\nC\u0004R\u0017A\u0005\t\u0019\u0001(\t\u000fI[\u0001\u0013!a\u0001'\"9ak\u0003I\u0001\u0002\u0004q\u0015!B1qa2LH\u0003BA\f\u00037\u0001B!!\u0007\u0002,9\u0019!-a\u0007\t\u000f\u0005uA\u00021\u0001\u0002 \u0005)qM]1qQB!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&Y\n\u0011b\u001a:ba\"4\u0018.Z<\n\t\u0005%\u00121\u0005\u0002\u0011\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016LA!!\f\u0002(\t)qI]1qQ\":\u0001!!\r\u0002F\u0005\u001d\u0003\u0003BA\u001a\u0003\u0003j!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\tg\u000e\fG.\u00193pG*!\u00111HA\u001f\u0003\u001d!\u0018m[3{_\u0016T1!a\u0010(\u0003\u00199\u0017\u000e\u001e5vE&!\u00111IA\u001b\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017EAA%\u0003=EvF\u000b\u0016\u000bA\u0001R\u0003e_:~A\u0016#\u0017/Z)vC:$\u0018\u000e\\3GS2$XM\u001d\u0015*A*\u0001\u0003E\u000b\u0011;A\u0019KG\u000e^3sK\u0012\u0004c/[3xA=4\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5!E\u0006\u001cX\r\u001a\u0011p]\u0002*GmZ3!o\u0016Lw\r\u001b;\u000bA\u0001R#\u0002\t\u0011+A\u0001\"\u0006.[:!GJ,\u0017\r^3tA\u0005\u0004c-\u001b7uKJ,G\r\t<jK^\u0004sN\u001a\u0011uQ\u0016\u0004sM]1qQ\u0002:\b.\u001a:fA\u0015$w-Z:!CJ,\u0007E]3n_Z,G\r\t2bg\u0016$\u0007e\u001c8!o\",'/\u001a\u0011uQ\u0016L'\u000fI<fS\u001eDG\u000f\t<bYV,\u0007\u0005\\1zg\u0002Jg\u000e\t;iK\u0002:Gn\u001c2bY*\u0001\u0003E\u000b\u0011!I&\u001cHO]5ckRLwN\u001c\u0011pM\u0002*GmZ3!o\u0016Lw\r\u001b;tY\u0001*h\u000eZ3sgR|w\u000e\u001a\u0011j]\u0002\"\b.[:!C2<wN]5uQ6\u0004\u0013m\u001d\u0011qKJ\u001cWM\u001c;jY\u0016\u001ch\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003e\u001c8fA\r\fg\u000eI2sK\u0006$X\rI1!m&,w\u000fI8gAQDWM\u0003\u0011!U\u0001\u0002sM]1qQ\u0002Jgn\u00197vI&tw\rI8oYf\u0004C\u000f[3!i>\u0004\b%\u000e\u0019&A=4\u0007%\u001a3hKNt\u0003\u0005\u00165jg\u0002\nGnZ8sSRDW\u000e\t3pKN\u0004cn\u001c;!e\u0016$XO\u001d8!C:L\be\\;uaV$\b%\u00198eA%\u001c\bEY3ti\u0002*8/\u001a3!S:\u00043m\\7q_NLG/[8o\u0015\u0001\u0002#\u0006\t\u0011xSRD\u0007e\u001c;iKJ\u0004\u0013\r\\4pe&$\b.\\:-AU\u001c\u0018N\\4!i\",\u0007e\u00115bS:\u0004\u0013\tU%/AQCW\rI1mO>\u0014\u0018\u000e\u001e5nAQ\u0014X-\u0019;tAQDW\r\t8fi^|'o\u001b\u0011bg\u0002\"\u0017N]3di\u0016$gF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0002\u0016M]1nKR,'o\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u00197po\u0016\u0014(\b\t$m_\u0006$\b%\u0010\u00111]A2\u0007M\u0003\u0011!U\u0001\u0002#\b\t+iK\u0002bwn^3sA\r,Ho\u001c4gAA,'oY3oi&dW\r\t2fY><\be\u001e5jG\"\u0004S\rZ4fg\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/Z7pm\u0016$G\u0006I1!M2|\u0017\r\u001e\u0011xSRD\u0007\u0005\r\u0011={\u0001bwn^3sAqj\u0004%\u001e9qKJ\u0004C(P\u0019/a\u0001:\u0018\u000e\u001e5!I\u00164\u0017-\u001e7uAY\fG.^3!a9\u0002dM\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b-\u001e9qKJT\u0004E\u00127pCR\u0004S\bI\u0019/a\u0019\u0004'\u0002\t\u0011+A\u0001R\u0004\u0005\u00165fAU\u0004\b/\u001a:!GV$xN\u001a4!a\u0016\u00148-\u001a8uS2,\u0007%\u00192pm\u0016\u0004s\u000f[5dQ\u0002*GmZ3tA]LG\u000e\u001c\u0011cK\u0002\u0012X-\\8wK\u0012d\u0003%\u0019\u0011gY>\fG\u000fI<ji\"\u0004\u0003\u0007\t\u001f>A1|w/\u001a:!yu\u0002S\u000f\u001d9fe\u0002bT(\r\u00181A]LG\u000f\u001b\u0011eK\u001a\fW\u000f\u001c;!m\u0006dW/\u001a\u00112]A2'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004w/Z5hQR\u001cFO]5oOj\u00023\u000b\u001e:j]\u001e\u0004S\b\t\u0012xK&<\u0007\u000e\u001e\u0012a\u0015\u0001\u0002#\u0006\t\u0011;AM#(/\u001b8hA9\fW.\u001a\u0011pM\u0002\"\b.\u001a\u0011xK&<\u0007\u000e\u001e\u0011qe>\u0004XM\u001d;zY\u0001\"WMZ1vYRLgn\u001a\u0011u_\u0002\u0012s/Z5hQR\u0014c\u0006I!tA]LG\u000f\u001b\u0011pi\",'\u000fI<fS\u001eDG/\u001a3!C2<wN]5uQ6\u001c\b%\u001b8!%\u0006\u0004\b\u000e^8ss2\u0002\u0013N\u001a\u0011o_\u0002:X-[4ii\u0002\u0002(o\u001c9feRL(\u0002\t\u0011+A\u0001J7\u000f\t;iKJ,\u0007EY;uA5,H\u000e^5.K\u0012<Wm\u001d\u0011be\u0016\u0004\u0003O]3tK:$H\u0006\t;iK\u0002rW/\u001c2fe\u0002zg\rI8dGV\u0014(/\u001a8dKN\u0004sN\u001a\u0011fC\u000eD\u0007%\u001a3hK\u0002J7\u000f\t;sK\u0006$X\r\u001a\u0011bg\u0002\"\b.\u001a\u0011xK&<\u0007\u000e\u001e\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1m_^,'/\u0012=dYV\u001c\u0018N^3;A\t{w\u000e\\3b]\u0002j\u0004E\t4bYN,'\u0005\u0019\u0006!A)\u0002\u0003E\u000f\u0011xQ\u0016$\b.\u001a:!i\",\u0007%\u001b8fcV\fG.\u001b;zA=t\u0007\u0005\u001e5fA\u0015$w-\u001a\u0011xK&<\u0007\u000e\u001e\u0011uQJ,7\u000f[8mI\u0002J7\u000fI:ue&\u001cG\u000fI8sA9|G\u000fI1uAQDW\r\t7po\u0016\u0014\b%\u001a8e\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?akB\u0004XM]#yG2,8/\u001b<fu\u0001\u0012un\u001c7fC:\u0004S\b\t\u0012gC2\u001cXM\t1\u000bA\u0001R\u0003\u0005\t\u001e!o\",G\u000f[3sAQDW\rI5oKF,\u0018\r\\5us\u0002zg\u000e\t;iK\u0002*GmZ3!o\u0016Lw\r\u001b;!i\"\u0014Xm\u001d5pY\u0012\u0004\u0013n\u001d\u0011tiJL7\r\u001e\u0011pe\u0002rw\u000e\u001e\u0011bi\u0002\"\b.\u001a\u0011vaB,'\u000fI3oI*\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~A:|')\u001b8tu\u0001Je\u000e\u001e\u0011>AE\u0002\u0004\u0007\r1\u000bA\u0001R\u0003\u0005\t\u001e!\u001dVl'-\u001a:!_\u001a\u0004#-\u001b8tAQ|\u0007EY3!kN,G\rI5oAQDW\r\t5jgR|wM]1n]\u0001\"\u0006.\u001a\u0011n_J,\u0007\u0005\u001e5fA\tLgn\u001d\u0017!i\",\u0007%\\8sK\u0002\u0002(/Z2jg\u0016\u0004C\u000f[3!i\"\u0014Xm\u001d5pY\u0012\u001c\beY1oA\t,\u0007\u0005\u000b3fa\u0016tG-\u001b8hA=t\u0007\u0005\u001e5fAUtG-\u001a:ms&twM\u0003\u0011!U\u0001\u0002C-[:ue&\u0014W\u000f^5p]\u0002zg\r\t;iK\u0002*GmZ3!o\u0016Lw\r\u001b;!I\u0006$\u0018-\u000b\u0011ckR\u0004C\u000f[3!E&<w-\u001a:!i\",\u0007%\u0019:sCf\u0004#-Z5oO\u0002\u0012'o\\1eG\u0006\u001cHO\f\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u00199sk:,gj\u001c3fgj\u0002#i\\8mK\u0006t\u0007%\u0010\u0011ueV,\u0007M\u0003\u0011!U\u0001\u0002#\bI5gAM,G\u000f\t;pAQ\u0014X/\u001a\u0017!]>$Wm\u001d\u0011xQ&\u001c\u0007\u000eI1sK\u0002bWM\u001a;!o&$\bn\\;uA\u0005t\u0017\u0010I5oG>l\u0017N\\4!_J\u0004s.\u001e;h_&tw\rI3eO\u0016\u001c\bEY=!i\",\u0007%\u001a8eA=4\u0007\u0005\u001e5jg\u00022\u0017\u000e\u001c;fe&tw\rI1sK\u0002\nGn]8!aJ,h.\u001a3!MJ|W\u000e\t;iK\u0002:'/\u00199i])\u0001\u0003E\u000b\u0006!A)\u0002\u0003\r\u00191|g\u0016,\u0017\r\\:p{*\u0001\u0003E\u000b\u0011\\;\"\u001aw.\u001c\u0018sCBDGo\u001c:z]\u0005dwm\u001c:ji\"l7O\f4jYR,'o\u001d\u0018FI\u001e,g)\u001b7uKJL#\u0002\t\u0011+A\u0001\u0004\u0007M\u0003\u0011!U=\n!#\u00123hKF+\u0018M\u001c;jY\u00164\u0015\u000e\u001c;feB\u0011aPD\n\u0005\u001d1\n\t\u0006\u0005\u0003\u0002T\u0005uSBAA+\u0015\u0011\t9&!\u0017\u0002\u0005%|'BAA.\u0003\u0011Q\u0017M^1\n\t\u0005}\u0013Q\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003\u001b*B!!\u001a\u0002nQ\u0001\u0012qMAA\u0003\u0007\u000b))a\"\u0002\n\u0006-\u0015Q\u0012\u000b\t\u0003S\ny'!\u001e\u0002|A!a\u0010AA6!\r\u0011\u0017Q\u000e\u0003\u0006IB\u0011\r!\u001a\u0005\n\u0003c\u0002\u0012\u0011!a\u0002\u0003g\n!\"\u001a<jI\u0016t7-\u001a\u00135!\u0011If,a\u001b\t\u0013\u0005]\u0004#!AA\u0004\u0005e\u0014AC3wS\u0012,gnY3%kA!a.]A6\u0011%\ti\bEA\u0001\u0002\b\ty(\u0001\u0006fm&$WM\\2fIY\u0002B!\u001e=\u0002l!9A\b\u0005I\u0001\u0002\u0004i\u0004b\u0002!\u0011!\u0003\u0005\r!\u0010\u0005\b\u0003B\u0001\n\u00111\u0001C\u0011\u001di\u0005\u0003%AA\u00029Cq!\u0015\t\u0011\u0002\u0003\u0007a\nC\u0004S!A\u0005\t\u0019A*\t\u000fY\u0003\u0002\u0013!a\u0001\u001d\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0002\u0014\u0006%VCAAKU\ri\u0014qS\u0016\u0003\u00033\u0003B!a'\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0015\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002(\u0006u%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)A-\u0005b\u0001K\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'\u0006\u0003\u0002\u0014\u0006=F!\u00023\u0013\u0005\u0004)\u0017aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005U\u0016\u0011X\u000b\u0003\u0003oS3AQAL\t\u0015!7C1\u0001f\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"T\u0003BA`\u0003\u0007,\"!!1+\u00079\u000b9\nB\u0003e)\t\u0007Q-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136+\u0011\ty,!3\u0005\u000b\u0011,\"\u0019A3\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIY*B!a4\u0002TV\u0011\u0011\u0011\u001b\u0016\u0004'\u0006]E!\u00023\u0017\u0005\u0004)\u0017aD1qa2LH\u0005Z3gCVdG\u000fJ\u001c\u0016\t\u0005}\u0016\u0011\u001c\u0003\u0006I^\u0011\r!Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\t\u0005M\u0015q\u001c\u0003\u0006Ib\u0011\r!Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\t\u0005M\u0015Q\u001d\u0003\u0006If\u0011\r!Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005U\u00161\u001e\u0003\u0006Ij\u0011\r!Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\t\u0005}\u0016\u0011\u001f\u0003\u0006In\u0011\r!Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\t\u0005}\u0016q\u001f\u0003\u0006Ir\u0011\r!Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\t\u0005=\u0017Q \u0003\u0006Iv\u0011\r!Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\t\u0005}&1\u0001\u0003\u0006Iz\u0011\r!Z\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0013\u0001BAa\u0003\u0003\u00125\u0011!Q\u0002\u0006\u0005\u0005\u001f\tI&\u0001\u0003mC:<\u0017\u0002\u0002B\n\u0005\u001b\u0011aa\u00142kK\u000e$\b")
public class EdgeQuantileFilter<T>
implements Generic {
    private final float lower;
    private final float upper;
    private final String weightString;
    private final boolean lowerExclusive;
    private final boolean upperExclusive;
    private final int noBins;
    private final boolean pruneNodes;
    private final Numeric<T> evidence$1;
    private final Bounded<T> evidence$2;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static <T> boolean $lessinit$greater$default$7() {
        return EdgeQuantileFilter$.MODULE$.$lessinit$greater$default$7();
    }

    public static <T> int $lessinit$greater$default$6() {
        return EdgeQuantileFilter$.MODULE$.$lessinit$greater$default$6();
    }

    public static <T> boolean $lessinit$greater$default$5() {
        return EdgeQuantileFilter$.MODULE$.$lessinit$greater$default$5();
    }

    public static <T> boolean $lessinit$greater$default$4() {
        return EdgeQuantileFilter$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> String $lessinit$greater$default$3() {
        return EdgeQuantileFilter$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> float $lessinit$greater$default$2() {
        return EdgeQuantileFilter$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> float $lessinit$greater$default$1() {
        return EdgeQuantileFilter$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> boolean apply$default$7() {
        return EdgeQuantileFilter$.MODULE$.apply$default$7();
    }

    public static <T> int apply$default$6() {
        return EdgeQuantileFilter$.MODULE$.apply$default$6();
    }

    public static <T> boolean apply$default$5() {
        return EdgeQuantileFilter$.MODULE$.apply$default$5();
    }

    public static <T> boolean apply$default$4() {
        return EdgeQuantileFilter$.MODULE$.apply$default$4();
    }

    public static <T> String apply$default$3() {
        return EdgeQuantileFilter$.MODULE$.apply$default$3();
    }

    public static <T> float apply$default$2() {
        return EdgeQuantileFilter$.MODULE$.apply$default$2();
    }

    public static <T> float apply$default$1() {
        return EdgeQuantileFilter$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Write out results to a table (this method is only called after `apply`)\n    *\n    * The default implementation returns an empty table\n    *\n    * @param graph Graph that results from the call to `apply`\n    */")
    public Table tabularise(GraphPerspective graph) {
        return BaseAlgorithm.tabularise$(this, graph);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        if (this.lower < 0.0f || this.upper > 1.0f || this.lower > this.upper) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Lower and upper quantiles must be a floats with 0 <= lower < upper <= 1.0");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return graph.identity();
        }
        return graph.setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            EdgeQuantileFilter.$anonfun$apply$1(this, state);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            EdgeQuantileFilter.$anonfun$apply$2(this, vertex, state);
            return BoxedUnit.UNIT;
        }).setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            EdgeQuantileFilter.$anonfun$apply$4(this, state);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            EdgeQuantileFilter.$anonfun$apply$5(this, vertex, state);
            return BoxedUnit.UNIT;
        }).setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            EdgeQuantileFilter.$anonfun$apply$7(this, state);
            return BoxedUnit.UNIT;
        }).edgeFilter((Function2<Edge, GraphState, Object>)(Function2 & Serializable)(edge, state) -> BoxesRunTime.boxToBoolean((boolean)EdgeQuantileFilter.$anonfun$apply$8(this, edge, state)), this.pruneNodes);
    }

    public static final /* synthetic */ void $anonfun$apply$1(EdgeQuantileFilter $this, GraphState state) {
        state.newMin("weightMin", true, $this.evidence$1, $this.evidence$2);
        state.newMax("weightMax", true, $this.evidence$1, $this.evidence$2);
    }

    public static final /* synthetic */ void $anonfun$apply$3(EdgeQuantileFilter $this, GraphState state$1, ConcreteEdge edge) {
        state$1.apply("weightMin").$plus$eq(edge.weight($this.weightString, $this.evidence$1));
        state$1.apply("weightMax").$plus$eq(edge.weight($this.weightString, $this.evidence$1));
    }

    public static final /* synthetic */ void $anonfun$apply$2(EdgeQuantileFilter $this, Vertex vertex, GraphState state) {
        vertex.outEdges().foreach((Function1 & Serializable)edge -> {
            EdgeQuantileFilter.$anonfun$apply$3($this, state, edge);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$4(EdgeQuantileFilter $this, GraphState state) {
        Object minWeight = state.apply("weightMin").value();
        Object maxWeight = state.apply("weightMax").value();
        state.newHistogram("weightDist", $this.noBins, minWeight, maxWeight, state.newHistogram$default$5(), $this.evidence$1);
    }

    public static final /* synthetic */ void $anonfun$apply$5(EdgeQuantileFilter $this, Vertex vertex, GraphState state) {
        Accumulator histogram = state.apply("weightDist");
        vertex.outEdges().foreach((Function1 & Serializable)edge -> {
            histogram.$plus$eq(edge.weight($this.weightString, $this.evidence$1));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$7(EdgeQuantileFilter $this, GraphState state) {
        Histogram histogram = (Histogram)state.apply("weightDist").value();
        state.newConstant("upperQuantile", BoxesRunTime.boxToFloat((float)histogram.quantile($this.upper)));
        state.newConstant("lowerQuantile", BoxesRunTime.boxToFloat((float)histogram.quantile($this.lower)));
    }

    public static final /* synthetic */ boolean $anonfun$apply$8(EdgeQuantileFilter $this, Edge edge, GraphState state) {
        boolean lowerExclusiveTest;
        float edgeWeight = Numeric.Implicits$.MODULE$.infixNumericOps(edge.weight($this.weightString, $this.evidence$1), $this.evidence$1).toFloat();
        float upperQuantile = BoxesRunTime.unboxToFloat(state.apply("upperQuantile").value());
        float lowerQuantile = BoxesRunTime.unboxToFloat(state.apply("lowerQuantile").value());
        boolean bl = $this.lowerExclusive ? edgeWeight > lowerQuantile : (lowerExclusiveTest = edgeWeight >= lowerQuantile);
        boolean upperExclusiveTest = $this.upperExclusive ? edgeWeight < upperQuantile : edgeWeight <= upperQuantile;
        return lowerExclusiveTest && upperExclusiveTest;
    }

    public EdgeQuantileFilter(float lower, float upper, String weightString, boolean lowerExclusive, boolean upperExclusive, int noBins, boolean pruneNodes, Numeric<T> evidence$1, Bounded<T> evidence$2, ClassTag<T> evidence$3) {
        this.lower = lower;
        this.upper = upper;
        this.weightString = weightString;
        this.lowerExclusive = lowerExclusive;
        this.upperExclusive = upperExclusive;
        this.noBins = noBins;
        this.pruneNodes = pruneNodes;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

