/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.util;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;

public final class DisruptorPauser {
    private volatile boolean _paused = false;

    public void suspend() {
        this._paused = true;
    }

    public synchronized void resume() {
        this._paused = false;
        this.notifyAll();
    }

    public boolean isSuspended() {
        return this._paused;
    }

    public WaitStrategy getWaitStrategy() {
        return new PauseableYieldingWaitStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseIfRequired() {
        if (this._paused) {
            DisruptorPauser disruptorPauser = this;
            synchronized (disruptorPauser) {
                while (this._paused) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private final class PauseableYieldingWaitStrategy
    implements WaitStrategy {
        private static final int SPIN_TRIES = 100;

        private PauseableYieldingWaitStrategy() {
        }

        public long waitFor(long l, Sequence sequence, Sequence sequence2, SequenceBarrier sequenceBarrier) throws AlertException {
            long l2;
            int n = 100;
            while ((l2 = sequence2.get()) < l) {
                n = this.applyWaitMethod(sequenceBarrier, n);
            }
            return l2;
        }

        public void signalAllWhenBlocking() {
        }

        private int applyWaitMethod(SequenceBarrier sequenceBarrier, int n) throws AlertException {
            sequenceBarrier.checkAlert();
            if (n != 0) {
                return n - 1;
            }
            Thread.yield();
            DisruptorPauser.this.pauseIfRequired();
            return n;
        }
    }
}

