/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.ArrowPropertyIterator;
import com.raphtory.arrowcore.implementation.CachedMutatingEdgeMap;
import com.raphtory.arrowcore.implementation.EdgeIterator;
import com.raphtory.arrowcore.implementation.EntityFieldAccessor;
import com.raphtory.arrowcore.implementation.RaphtoryArrowPartition;
import com.raphtory.arrowcore.implementation.RaphtoryThreadPool;
import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import com.raphtory.arrowcore.implementation.VertexHistoryIterator;
import com.raphtory.arrowcore.implementation.VertexHistoryPartition;
import com.raphtory.arrowcore.implementation.VertexPartition;
import com.raphtory.arrowcore.implementation.VertexPartitionManager;
import com.raphtory.arrowcore.model.Vertex;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.concurrent.Future;

public abstract class VertexIterator {
    private static final ThreadLocal<WindowedVertexIterator> _wvsTL = ThreadLocal.withInitial(() -> new WindowedVertexIterator());
    private static final ThreadLocal<AllVerticesIterator> _aviTL = ThreadLocal.withInitial(() -> new AllVerticesIterator());
    private boolean _hasNext = false;
    private boolean _getNext = true;
    protected VertexPartitionManager _avpm;
    protected VertexPartition _p;
    protected int _partitionId = -1;
    protected int _vertexRowId = -1;
    protected long _vertexId = -1L;
    protected EntityFieldAccessor[] _efa = null;
    protected VersionedEntityPropertyAccessor[] _vefa = null;
    protected ArrowPropertyIterator[] _propertyIterators = null;
    protected VersionedEntityPropertyAccessor[] _propertyIteratorAccessors = null;
    protected EdgeIterator.MatchingEdgesIterator _matchingEdgesIterator = null;
    protected VertexHistoryIterator.WindowedVertexHistoryIterator _vertexHistoryIterator = null;
    protected CachedMutatingEdgeMap.OutgoingMatchingEdgeCachedIterator _outgoingScanner = null;
    protected CachedMutatingEdgeMap.IncomingMatchingEdgeCachedIterator _incomingScanner = null;
    protected VertexHistoryPartition.BoundedVertexEdgeTimeWindowComparator _isAliveSearcher = null;

    protected void init(VertexPartitionManager vertexPartitionManager) {
        this._avpm = vertexPartitionManager;
        this._p = null;
        this._partitionId = -1;
        this._vertexRowId = -1;
        this._vertexId = -1L;
        this._hasNext = false;
        this._getNext = true;
    }

    protected void init(VertexPartitionManager vertexPartitionManager, VertexPartition vertexPartition) {
        this._avpm = vertexPartitionManager;
        this._p = vertexPartition;
        this._partitionId = this._p.getPartitionId();
        this._vertexRowId = -1;
        this._vertexId = -1L;
        this._hasNext = false;
        this._getNext = true;
    }

    public RaphtoryArrowPartition getRaphtory() {
        return this._avpm._raphtoryPartition;
    }

    public VertexPartition getPartition() {
        return this._p;
    }

    public EntityFieldAccessor getField(int n) {
        if (this._efa == null) {
            this._efa = this._avpm._raphtoryPartition.createVertexEntityFieldAccessors();
        }
        return this._p.getFieldByVertexRow(n, this._vertexRowId, this._efa[n]);
    }

    public VersionedEntityPropertyAccessor getProperty(int n) {
        if (this._vefa == null) {
            this._vefa = this._avpm._raphtoryPartition.createVertexEntityPropertyAccessors();
        }
        int n2 = this._p.getPropertyPrevPtrByRow(n, this._vertexRowId);
        return this._p.getPropertyByPropertyRow(n, n2, this._vefa[n]);
    }

    public boolean reset(long l) {
        this._vertexId = l;
        this._vertexRowId = this._avpm.getRowId(l);
        this._p = this._avpm.getPartition(this._avpm.getPartitionId(l));
        this._hasNext = this._vertexId != -1L && this._p != null && this._p.isValidRow(this._vertexRowId);
        this._getNext = false;
        return this._hasNext;
    }

    public long getVertexId() {
        return this._vertexId;
    }

    public final long next() {
        if (this._getNext) {
            this.moveToNext();
        }
        this._getNext = true;
        return this._vertexId;
    }

    public final boolean hasNext() {
        if (this._getNext) {
            this._hasNext = this.moveToNext();
            this._getNext = false;
        }
        return this._hasNext;
    }

    protected abstract boolean moveToNext();

    public Vertex getVertex() {
        return this._p.getVertex(this._vertexId);
    }

    public boolean isAliveAt(long l, long l2) {
        if (this._isAliveSearcher == null) {
            this._isAliveSearcher = new VertexHistoryPartition.BoundedVertexEdgeTimeWindowComparator();
        }
        return this._p.isAliveAt(this._vertexId, l, l2, this._isAliveSearcher);
    }

    public long getCreationTime() {
        return this._p.getCreationTimeByRow(this._vertexRowId);
    }

    public long getGlobalVertexId() {
        return this._p._getGlobalVertexIdByRow(this._vertexRowId);
    }

    public int getNIncomingEdges() {
        return this._p._getNIncomingEdgesByRow(this._vertexRowId);
    }

    public int getNOutgoingEdges() {
        return this._p._getNOutgoingEdgesByRow(this._vertexRowId);
    }

    public abstract EdgeIterator getOutgoingEdges();

    public abstract EdgeIterator getIncomingEdges();

    public abstract EdgeIterator getAllEdges();

    public boolean isValid() {
        return this._p != null && this._p.isValidRow(this._vertexRowId);
    }

    public EdgeIterator findAllOutgoingEdges(long l, boolean bl) {
        if (this._outgoingScanner == null) {
            this._outgoingScanner = new CachedMutatingEdgeMap.OutgoingMatchingEdgeCachedIterator();
        }
        return this._p.findMatchingOutgoingEdges(this._vertexId, l, bl, this._outgoingScanner);
    }

    public EdgeIterator findAllIncomingEdges(long l, boolean bl) {
        if (this._incomingScanner == null) {
            this._incomingScanner = new CachedMutatingEdgeMap.IncomingMatchingEdgeCachedIterator();
        }
        return this._p.findMatchingIncomingEdges(l, this._vertexId, bl, this._incomingScanner);
    }

    public ArrowPropertyIterator getPropertyHistory(int n) {
        if (this._propertyIterators == null) {
            this._propertyIteratorAccessors = this._p._apm._raphtoryPartition.createVertexEntityPropertyAccessors();
            this._propertyIterators = new ArrowPropertyIterator[this._propertyIteratorAccessors.length];
            for (int i = 0; i < this._propertyIterators.length; ++i) {
                this._propertyIterators[i] = new ArrowPropertyIterator.AllPropertiesIterator();
                this._propertyIterators[i].init(this._p._propertyStores[n]._store, this._p._propertyStores[n]._accessor, this._propertyIteratorAccessors[i], -1);
            }
        }
        this._propertyIterators[n].init(this._p._propertyStores[n]._store, this._p._propertyStores[n]._accessor, this._propertyIteratorAccessors[n], this._p.getPropertyPrevPtrByRow(n, this._vertexRowId));
        return this._propertyIterators[n];
    }

    public VertexHistoryIterator.WindowedVertexHistoryIterator getVertexHistory() {
        if (this._vertexHistoryIterator == null) {
            this._vertexHistoryIterator = new VertexHistoryIterator.WindowedVertexHistoryIterator();
        }
        this._vertexHistoryIterator.init(this._avpm, this._vertexId, Long.MIN_VALUE, Long.MAX_VALUE);
        return this._vertexHistoryIterator;
    }

    protected static AllVerticesIterator getCachedAllVerticesIterator(VertexPartitionManager vertexPartitionManager, VertexPartition vertexPartition) {
        AllVerticesIterator allVerticesIterator = _aviTL.get();
        allVerticesIterator.init(vertexPartitionManager, vertexPartition);
        return allVerticesIterator;
    }

    private static WindowedVertexIterator getCachedWindowedVertexIterator(VertexPartitionManager vertexPartitionManager, VertexPartition vertexPartition, long l, long l2) {
        WindowedVertexIterator windowedVertexIterator = _wvsTL.get();
        windowedVertexIterator.init(vertexPartitionManager, vertexPartition, l, l2);
        return windowedVertexIterator;
    }

    public static class WindowedVertexIterator
    extends VertexIterator {
        private boolean _doAll;
        protected EdgeIterator.AllWindowedEdgeIteratorFromVertex _allEdges = new EdgeIterator.AllWindowedEdgeIteratorFromVertex();
        protected EdgeIterator.WindowedEdgeIteratorFromVertex _incomingEdges = new EdgeIterator.WindowedEdgeIteratorFromVertex();
        protected EdgeIterator.WindowedEdgeIteratorFromVertex _outgoingEdges = new EdgeIterator.WindowedEdgeIteratorFromVertex();
        protected VertexHistoryPartition.BoundedVertexEdgeTimeWindowComparator _searcher = new VertexHistoryPartition.BoundedVertexEdgeTimeWindowComparator();
        protected long _start;
        protected long _end;

        private WindowedVertexIterator() {
        }

        protected WindowedVertexIterator(VertexPartitionManager vertexPartitionManager, long l, long l2) {
            this.init(vertexPartitionManager, l, l2);
        }

        protected void init(VertexPartitionManager vertexPartitionManager, long l, long l2) {
            super.init(vertexPartitionManager);
            this._doAll = true;
            this._start = l;
            this._end = l2;
        }

        protected void init(VertexPartitionManager vertexPartitionManager, VertexPartition vertexPartition, long l, long l2) {
            super.init(vertexPartitionManager, vertexPartition);
            this._doAll = false;
            this._start = l;
            this._end = l2;
        }

        @Override
        protected void init(VertexPartitionManager vertexPartitionManager, VertexPartition vertexPartition) {
            super.init(vertexPartitionManager, vertexPartition);
            this._doAll = false;
        }

        @Override
        protected boolean moveToNext() {
            while (true) {
                if (this._doAll && this._p == null) {
                    this._p = this._avpm.getPartition(++this._partitionId);
                    if (this._p == null) {
                        this._vertexRowId = -1;
                        this._vertexId = -1L;
                        return false;
                    }
                    this._vertexRowId = -1;
                    this._vertexId = -1L;
                }
                if (this._p == null) {
                    this._vertexRowId = -1;
                    this._vertexId = -1L;
                    return false;
                }
                do {
                    ++this._vertexRowId;
                } while (this._p.isValidRow(this._vertexRowId) && !this._p.isAliveAtByRow(this._vertexRowId, this._start, this._end, this._searcher));
                if (this._p.isValidRow(this._vertexRowId)) {
                    this._vertexId = this._p._getLocalVertexIdByRow(this._vertexRowId);
                    return true;
                }
                this._p = null;
                this._vertexRowId = -1;
                this._vertexId = -1L;
            }
        }

        @Override
        public EdgeIterator getOutgoingEdges() {
            this._outgoingEdges.init(this._avpm._aepm, this._p._getOutgoingEdgePtrByRow(this._vertexRowId), false, this._start, this._end);
            return this._outgoingEdges;
        }

        @Override
        public EdgeIterator getIncomingEdges() {
            this._incomingEdges.init(this._avpm._aepm, this._p._getIncomingEdgePtrByRow(this._vertexRowId), true, this._start, this._end);
            return this._incomingEdges;
        }

        @Override
        public EdgeIterator getAllEdges() {
            this._allEdges.init(this._avpm._aepm, this._p._getIncomingEdgePtrByRow(this._vertexRowId), this._p._getOutgoingEdgePtrByRow(this._vertexRowId), this._start, this._end);
            return this._allEdges;
        }
    }

    public static class AllVerticesIterator
    extends VertexIterator {
        private boolean _doAll;
        private final EdgeIterator.EdgeIteratorFromVertex _incoming = new EdgeIterator.EdgeIteratorFromVertex();
        private final EdgeIterator.EdgeIteratorFromVertex _outgoing = new EdgeIterator.EdgeIteratorFromVertex();
        private final EdgeIterator.AllEdgesIteratorFromVertex _allEdges = new EdgeIterator.AllEdgesIteratorFromVertex();

        private AllVerticesIterator() {
        }

        protected AllVerticesIterator(VertexPartitionManager vertexPartitionManager) {
            this.init(vertexPartitionManager);
        }

        @Override
        protected void init(VertexPartitionManager vertexPartitionManager) {
            super.init(vertexPartitionManager);
            this._doAll = true;
        }

        @Override
        protected void init(VertexPartitionManager vertexPartitionManager, VertexPartition vertexPartition) {
            super.init(vertexPartitionManager, vertexPartition);
            this._doAll = false;
        }

        @Override
        protected boolean moveToNext() {
            while (true) {
                if (this._doAll && this._p == null) {
                    this._p = this._avpm.getPartition(++this._partitionId);
                    if (this._p == null) {
                        this._vertexRowId = -1;
                        this._vertexId = -1L;
                        return false;
                    }
                    this._vertexRowId = -1;
                    this._vertexId = -1L;
                }
                if (this._p == null) {
                    this._vertexRowId = -1;
                    this._vertexId = -1L;
                    return false;
                }
                if (this._p.isValidRow(++this._vertexRowId)) {
                    this._vertexId = this._p._getLocalVertexIdByRow(this._vertexRowId);
                    return true;
                }
                this._p = null;
                this._vertexRowId = -1;
                this._vertexId = -1L;
            }
        }

        @Override
        public EdgeIterator getOutgoingEdges() {
            this._outgoing.init(this._avpm._aepm, this._p._getOutgoingEdgePtrByRow(this._vertexRowId), false);
            return this._outgoing;
        }

        @Override
        public EdgeIterator getIncomingEdges() {
            this._incoming.init(this._avpm._aepm, this._p._getIncomingEdgePtrByRow(this._vertexRowId), true);
            return this._incoming;
        }

        @Override
        public EdgeIterator getAllEdges() {
            this._allEdges.init(this._avpm._aepm, this._p._getIncomingEdgePtrByRow(this._vertexRowId), this._p._getOutgoingEdgePtrByRow(this._vertexRowId));
            return this._allEdges;
        }
    }

    public static class MTAllVerticesManager {
        private final ArrayList<Future<?>> _tasks = new ArrayList();
        protected VertexPartitionManager _avpm;
        protected RaphtoryThreadPool _pool;

        protected MTAllVerticesManager() {
        }

        protected void init(VertexPartitionManager vertexPartitionManager, RaphtoryThreadPool raphtoryThreadPool) {
            this._avpm = vertexPartitionManager;
            this._pool = raphtoryThreadPool;
        }

        public synchronized void start(MTVertexIteratorConsumer mTVertexIteratorConsumer) {
            VertexPartition vertexPartition;
            int n = 0;
            this._tasks.clear();
            while ((vertexPartition = this._avpm.getPartition(n++)) != null) {
                IterTask iterTask = new IterTask(vertexPartition, mTVertexIteratorConsumer);
                Future<?> future = this._pool.submitTask(iterTask);
                this._tasks.add(future);
            }
        }

        public synchronized void waitTilComplete() {
            this._pool.waitTilComplete(this._tasks);
        }

        public synchronized void cancel() {
            this._pool.cancel(this._tasks);
        }

        private class IterTask
        implements Runnable {
            protected final VertexPartition _pp;
            protected final MTVertexIteratorConsumer _consumer;

            private IterTask(VertexPartition vertexPartition, MTVertexIteratorConsumer mTVertexIteratorConsumer) {
                this._pp = vertexPartition;
                this._consumer = mTVertexIteratorConsumer;
            }

            @Override
            public void run() {
                AllVerticesIterator allVerticesIterator = VertexIterator.getCachedAllVerticesIterator(MTAllVerticesManager.this._avpm, this._pp);
                this._consumer.accept(this._pp.getPartitionId(), allVerticesIterator);
            }
        }
    }

    public static class MTWindowedVertexManager {
        private final ArrayList<Future<?>> _tasks = new ArrayList();
        protected VertexPartitionManager _avpm;
        protected VertexPartition _p;
        protected long _minTime;
        protected long _maxTime;
        protected RaphtoryThreadPool _pool;

        public void init(VertexPartitionManager vertexPartitionManager, RaphtoryThreadPool raphtoryThreadPool, long l, long l2) {
            this._avpm = vertexPartitionManager;
            this._pool = raphtoryThreadPool;
            this._minTime = l;
            this._maxTime = l2;
            this._p = null;
            this._tasks.clear();
        }

        public void waitTilComplete() {
            this._pool.waitTilComplete(this._tasks);
        }

        public synchronized void cancel() {
            this._pool.cancel(this._tasks);
        }

        public synchronized void start(MTVertexIteratorConsumer mTVertexIteratorConsumer) {
            int n = 0;
            this._tasks.clear();
            while (true) {
                this._p = this._avpm.getPartition(n++);
                if (this._p == null) break;
                IterTask iterTask = new IterTask(this._p, mTVertexIteratorConsumer);
                Future<?> future = this._pool.submitTask(iterTask);
                this._tasks.add(future);
            }
        }

        private class IterTask
        implements Runnable {
            protected final VertexPartition _pp;
            protected final MTVertexIteratorConsumer _consumer;

            private IterTask(VertexPartition vertexPartition, MTVertexIteratorConsumer mTVertexIteratorConsumer) {
                this._pp = vertexPartition;
                this._consumer = mTVertexIteratorConsumer;
            }

            @Override
            public void run() {
                WindowedVertexIterator windowedVertexIterator = VertexIterator.getCachedWindowedVertexIterator(MTWindowedVertexManager.this._avpm, this._pp, MTWindowedVertexManager.this._minTime, MTWindowedVertexManager.this._maxTime);
                this._consumer.accept(this._pp.getPartitionId(), windowedVertexIterator);
            }
        }
    }

    public static final class AllWindowedVertexEdgeHistoryIterator
    extends WindowedVertexEdgeHistoryIterator {
        @Override
        protected boolean isInteresting(int n) {
            return true;
        }

        @Override
        public int getMaxEdges(int n) {
            return this._vertexPartition._getNIncomingEdgesByRow(this._vertexRowId) + this._vertexPartition._getNOutgoingEdgesByRow(this._vertexRowId);
        }
    }

    public static final class OutgoingWindowedVertexEdgeHistoryIterator
    extends WindowedVertexEdgeHistoryIterator {
        @Override
        protected boolean isInteresting(int n) {
            return this._vertexPartition._history.getIsOutgoingByHistoryRowId(n);
        }

        @Override
        public int getMaxEdges(int n) {
            return this._vertexPartition._getNOutgoingEdgesByRow(this._vertexRowId);
        }
    }

    public static final class IncomingWindowedVertexEdgeHistoryIterator
    extends WindowedVertexEdgeHistoryIterator {
        @Override
        protected boolean isInteresting(int n) {
            return !this._vertexPartition._history.getIsOutgoingByHistoryRowId(n);
        }

        @Override
        public int getMaxEdges(int n) {
            return this._vertexPartition._getNIncomingEdgesByRow(this._vertexRowId);
        }
    }

    public static abstract class WindowedVertexEdgeHistoryIterator
    extends EdgeIterator {
        protected LongOpenHashSet _processedEdges = new LongOpenHashSet(1024);
        protected int _vertexRowId;
        protected VertexPartition _vertexPartition;
        protected long _minTime;
        protected long _maxTime;
        protected int _maxEdges;
        protected int _firstIndex;
        protected int _lastIndex;
        protected int _index;
        protected boolean _firstTime = true;
        protected int _nEdgesFound = 0;

        protected void init(WindowedVertexHistoryIterator windowedVertexHistoryIterator) {
            super.init(windowedVertexHistoryIterator._avpm._aepm);
            this._vertexRowId = windowedVertexHistoryIterator._vertexRowId;
            this._vertexPartition = windowedVertexHistoryIterator._p;
            this._minTime = windowedVertexHistoryIterator._minTime;
            this._maxTime = windowedVertexHistoryIterator._maxTime;
            this._firstIndex = -1;
            this._lastIndex = -1;
            this._index = -1;
            this._firstTime = true;
            this._processedEdges.clear();
            this._maxEdges = this.getMaxEdges(this._vertexRowId);
            this._nEdgesFound = 0;
        }

        protected void init(VertexIterator vertexIterator, long l, long l2) {
            super.init(vertexIterator._avpm._aepm);
            this._vertexRowId = vertexIterator._vertexRowId;
            this._vertexPartition = vertexIterator._p;
            this._minTime = l;
            this._maxTime = l2;
            this._firstIndex = -1;
            this._lastIndex = -1;
            this._index = -1;
            this._firstTime = true;
            this._processedEdges.clear();
            this._maxEdges = this.getMaxEdges(this._vertexRowId);
            this._nEdgesFound = 0;
        }

        private long getNext() {
            while (this._vertexPartition != null && this._nEdgesFound < this._maxEdges) {
                if (this._lastIndex != -1) {
                    if (this._index >= this._firstIndex) {
                        int n = this._vertexPartition._history.getEdgeHistoryRowIdBySortedIndex(this._index);
                        long l = this._vertexPartition._history.getEdgeIdByHistoryRowId(n);
                        if (l != -1L && !this._processedEdges.contains(l)) {
                            boolean bl = this._vertexPartition._history.getIsAliveByHistoryRowId(n);
                            boolean bl2 = this.isInteresting(n);
                            if (bl2) {
                                ++this._nEdgesFound;
                                this._processedEdges.add(l);
                            }
                            if (bl && bl2) {
                                return l;
                            }
                        }
                        --this._index;
                        continue;
                    }
                    this._firstIndex = -1;
                    this._lastIndex = -1;
                    this._index = -1;
                    this._vertexPartition = null;
                    continue;
                }
                this._vertexPartition._history.isAliveAtWithWindowVector(this);
                if (this._lastIndex == -1) {
                    this._vertexPartition = null;
                    continue;
                }
                this._index = this._lastIndex;
            }
            return -1L;
        }

        @Override
        protected boolean moveToNext() {
            if (!this._firstTime) {
                --this._index;
            } else {
                this._firstTime = false;
            }
            this._edgeId = this.getNext();
            if (this._edgeId != -1L) {
                this._edgeRowId = this._aepm.getRowId(this._edgeId);
                this._edgePartition = this._aepm.getPartition(this._aepm.getPartitionId(this._edgeId));
                return true;
            }
            this._edgeRowId = -1;
            this._edgePartition = null;
            return false;
        }

        protected abstract boolean isInteresting(int var1);

        protected abstract int getMaxEdges(int var1);
    }

    public static class WindowedVertexHistoryIterator
    extends VertexIterator {
        protected LongOpenHashSet _processedVertices = new LongOpenHashSet(1024);
        protected long _minTime;
        protected long _maxTime;
        protected int _firstIndex;
        protected int _lastIndex;
        protected int _index;
        protected boolean _firstTime = true;
        protected boolean _getNextPartition = false;
        protected long _modifiedTime = -1L;
        protected EdgeIterator.AllWindowedEdgeIteratorFromVertex _allEdges = new EdgeIterator.AllWindowedEdgeIteratorFromVertex();
        protected EdgeIterator.WindowedEdgeIteratorFromVertex _incomingEdges = new EdgeIterator.WindowedEdgeIteratorFromVertex();
        protected EdgeIterator.WindowedEdgeIteratorFromVertex _outgoingEdges = new EdgeIterator.WindowedEdgeIteratorFromVertex();

        private WindowedVertexHistoryIterator() {
        }

        protected WindowedVertexHistoryIterator(VertexPartitionManager vertexPartitionManager, long l, long l2) {
            this.init(vertexPartitionManager, l, l2);
        }

        protected void init(VertexPartitionManager vertexPartitionManager, long l, long l2) {
            super.init(vertexPartitionManager);
            this._minTime = l;
            this._maxTime = l2;
            this._firstTime = true;
            this._index = -1;
            this._getNextPartition = true;
        }

        protected void init(VertexPartitionManager vertexPartitionManager, VertexPartition vertexPartition, long l, long l2) {
            super.init(vertexPartitionManager, vertexPartition);
            this._minTime = l;
            this._maxTime = l2;
            this._firstTime = true;
            this._firstIndex = -1;
            this._lastIndex = -1;
            this._index = -1;
            this._processedVertices.clear();
            this._getNextPartition = false;
        }

        private long getNext() {
            while (true) {
                if (this._p == null && this._getNextPartition) {
                    this._p = this._avpm.getPartition(++this._partitionId);
                    this._firstIndex = -1;
                    this._lastIndex = -1;
                    this._index = -1;
                    this._processedVertices.clear();
                    this._vertexRowId = -1;
                    this._vertexId = -1L;
                }
                if (this._p == null) {
                    this._vertexRowId = -1;
                    this._vertexId = -1L;
                    return -1L;
                }
                if (this._lastIndex != -1) {
                    if (this._index >= this._firstIndex) {
                        int n = this._p._history.getHistoryRowIdBySortedIndex(this._index);
                        boolean bl = this._p._history.getIsAliveByHistoryRowId(n);
                        this._vertexRowId = this._p._history.getVertexLocalRowIdByHistoryRowId(n);
                        if (!this._processedVertices.contains((long)this._vertexRowId)) {
                            this._processedVertices.add((long)this._vertexRowId);
                            this._modifiedTime = this._p._history.getModificationTimeByHistoryRowId(n);
                            if (bl) {
                                return this._p._getLocalVertexIdByRow(this._vertexRowId);
                            }
                        } else {
                            --this._index;
                            continue;
                        }
                    }
                    this._firstIndex = -1;
                    this._lastIndex = -1;
                    this._index = -1;
                    this._p = null;
                    this._vertexRowId = -1;
                    this._vertexId = -1L;
                    continue;
                }
                this._p._history.isAliveAtWithWindowVector(this);
                if (this._lastIndex == -1) {
                    this._p = null;
                    this._vertexRowId = -1;
                    this._vertexId = -1L;
                    continue;
                }
                this._index = this._lastIndex;
            }
        }

        public long getModificationTime() {
            return this._modifiedTime;
        }

        @Override
        protected boolean moveToNext() {
            if (!this._firstTime) {
                --this._index;
            } else {
                this._firstTime = false;
            }
            this._vertexId = this.getNext();
            return this._vertexId != -1L;
        }

        @Override
        public EdgeIterator getOutgoingEdges() {
            this._outgoingEdges.init(this._avpm._aepm, this._p._getOutgoingEdgePtrByRow(this._vertexRowId), false, this._minTime, this._maxTime);
            return this._outgoingEdges;
        }

        @Override
        public EdgeIterator getIncomingEdges() {
            this._incomingEdges.init(this._avpm._aepm, this._p._getIncomingEdgePtrByRow(this._vertexRowId), true, this._minTime, this._maxTime);
            return this._incomingEdges;
        }

        @Override
        public EdgeIterator getAllEdges() {
            this._allEdges.init(this._avpm._aepm, this._p._getIncomingEdgePtrByRow(this._vertexRowId), this._p._getOutgoingEdgePtrByRow(this._vertexRowId), this._minTime, this._maxTime);
            return this._allEdges;
        }

        @Override
        public VertexHistoryIterator.WindowedVertexHistoryIterator getVertexHistory() {
            if (this._vertexHistoryIterator == null) {
                this._vertexHistoryIterator = new VertexHistoryIterator.WindowedVertexHistoryIterator();
            }
            this._vertexHistoryIterator.init(this._avpm, this._vertexId, this._minTime, this._maxTime);
            return this._vertexHistoryIterator;
        }
    }

    public static interface MTVertexIteratorConsumer {
        public void accept(int var1, VertexIterator var2);
    }
}

