/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.RaphtoryStringUtils;
import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.holders.NullableVarCharHolder;

public abstract class VersionedPropertyStore {
    protected BigIntVector _localId;
    protected BitVector _initialValue;
    protected BigIntVector _creationTime;
    protected IntVector _prevPtr;

    protected void initialise(VectorSchemaRoot vectorSchemaRoot) {
        if (vectorSchemaRoot != null) {
            this._localId = (BigIntVector)vectorSchemaRoot.getVector(0);
            this._initialValue = (BitVector)vectorSchemaRoot.getVector(1);
            this._creationTime = (BigIntVector)vectorSchemaRoot.getVector(2);
            this._prevPtr = (IntVector)vectorSchemaRoot.getVector(3);
        } else {
            this._localId = null;
            this._initialValue = null;
            this._creationTime = null;
            this._prevPtr = null;
        }
    }

    public abstract void store(VersionedEntityPropertyAccessor var1, int var2);

    public void load(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
        if (n == -1 || this._localId.isSet(n) == 0) {
            versionedEntityPropertyAccessor.reset();
            return;
        }
        versionedEntityPropertyAccessor.set(this._localId.get(n), this._initialValue.get(n) != 0, this._creationTime.get(n), this._prevPtr.get(n));
    }

    public static final class StringPropertyAccessor
    extends VersionedPropertyStore {
        private VarCharVector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot) {
            super.initialise(vectorSchemaRoot);
            if (vectorSchemaRoot != null) {
                FieldVector fieldVector = vectorSchemaRoot.getVector(4);
                if (fieldVector == null || !(fieldVector instanceof VarCharVector)) {
                    throw new IllegalArgumentException();
                }
                this._vector = (VarCharVector)fieldVector;
            } else {
                this._vector = null;
            }
        }

        @Override
        public void store(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
            if (versionedEntityPropertyAccessor.isSet()) {
                NullableVarCharHolder nullableVarCharHolder = RaphtoryStringUtils.getTmpVarCharHolder();
                byte[] byArray = RaphtoryStringUtils.copy(versionedEntityPropertyAccessor.getString(), nullableVarCharHolder);
                this._vector.setSafe(n, byArray, nullableVarCharHolder.start, nullableVarCharHolder.end - nullableVarCharHolder.start);
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
            super.load(versionedEntityPropertyAccessor, n);
            NullableVarCharHolder nullableVarCharHolder = RaphtoryStringUtils.getTmpVarCharHolder();
            this._vector.get(n, nullableVarCharHolder);
            if (nullableVarCharHolder.isSet != 0) {
                StringBuilder stringBuilder = versionedEntityPropertyAccessor.getString();
                stringBuilder.setLength(0);
                RaphtoryStringUtils.copy(nullableVarCharHolder, stringBuilder);
            } else {
                versionedEntityPropertyAccessor.reset();
            }
        }
    }

    public static final class BooleanPropertyAccessor
    extends VersionedPropertyStore {
        private BitVector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot) {
            super.initialise(vectorSchemaRoot);
            if (vectorSchemaRoot != null) {
                FieldVector fieldVector = vectorSchemaRoot.getVector(4);
                if (fieldVector == null || !(fieldVector instanceof BitVector)) {
                    throw new IllegalArgumentException();
                }
                this._vector = (BitVector)fieldVector;
            } else {
                this._vector = null;
            }
        }

        @Override
        public void store(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
            if (versionedEntityPropertyAccessor.isSet()) {
                this._vector.setSafe(n, versionedEntityPropertyAccessor.getBoolean() ? 1 : 0);
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
            super.load(versionedEntityPropertyAccessor, n);
            if (!this._vector.isNull(n)) {
                versionedEntityPropertyAccessor.set(this._vector.get(n) != 0);
            } else {
                versionedEntityPropertyAccessor.reset();
            }
        }
    }

    public static final class DoublePropertyAccessor
    extends VersionedPropertyStore {
        private Float8Vector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot) {
            super.initialise(vectorSchemaRoot);
            if (vectorSchemaRoot != null) {
                FieldVector fieldVector = vectorSchemaRoot.getVector(4);
                if (fieldVector == null || !(fieldVector instanceof Float8Vector)) {
                    throw new IllegalArgumentException();
                }
                this._vector = (Float8Vector)fieldVector;
            } else {
                this._vector = null;
            }
        }

        @Override
        public void store(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
            if (versionedEntityPropertyAccessor.isSet()) {
                this._vector.setSafe(n, versionedEntityPropertyAccessor.getDouble());
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
            super.load(versionedEntityPropertyAccessor, n);
            if (!this._vector.isNull(n)) {
                versionedEntityPropertyAccessor.set(this._vector.get(n));
            } else {
                versionedEntityPropertyAccessor.reset();
            }
        }
    }

    public static final class FloatPropertyAccessor
    extends VersionedPropertyStore {
        private Float4Vector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot) {
            super.initialise(vectorSchemaRoot);
            if (vectorSchemaRoot != null) {
                FieldVector fieldVector = vectorSchemaRoot.getVector(4);
                if (fieldVector == null || !(fieldVector instanceof Float4Vector)) {
                    throw new IllegalArgumentException();
                }
                this._vector = (Float4Vector)fieldVector;
            } else {
                this._vector = null;
            }
        }

        @Override
        public void store(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
            if (versionedEntityPropertyAccessor.isSet()) {
                this._vector.setSafe(n, versionedEntityPropertyAccessor.getFloat());
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
            super.load(versionedEntityPropertyAccessor, n);
            if (!this._vector.isNull(n)) {
                versionedEntityPropertyAccessor.set(this._vector.get(n));
            } else {
                versionedEntityPropertyAccessor.reset();
            }
        }
    }

    public static final class LongPropertyAccessor
    extends VersionedPropertyStore {
        private BigIntVector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot) {
            super.initialise(vectorSchemaRoot);
            if (vectorSchemaRoot != null) {
                FieldVector fieldVector = vectorSchemaRoot.getVector(4);
                if (fieldVector == null || !(fieldVector instanceof BigIntVector)) {
                    throw new IllegalArgumentException();
                }
                this._vector = (BigIntVector)fieldVector;
            } else {
                this._vector = null;
            }
        }

        @Override
        public void store(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
            if (versionedEntityPropertyAccessor.isSet()) {
                this._vector.setSafe(n, versionedEntityPropertyAccessor.getLong());
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
            super.load(versionedEntityPropertyAccessor, n);
            if (!this._vector.isNull(n)) {
                versionedEntityPropertyAccessor.set(this._vector.get(n));
            } else {
                versionedEntityPropertyAccessor.reset();
            }
        }
    }

    public static final class IntPropertyAccessor
    extends VersionedPropertyStore {
        private IntVector _vector;

        @Override
        public void initialise(VectorSchemaRoot vectorSchemaRoot) {
            super.initialise(vectorSchemaRoot);
            if (vectorSchemaRoot != null) {
                FieldVector fieldVector = vectorSchemaRoot.getVector(4);
                if (fieldVector == null || !(fieldVector instanceof IntVector)) {
                    throw new IllegalArgumentException();
                }
                this._vector = (IntVector)fieldVector;
            } else {
                this._vector = null;
            }
        }

        @Override
        public void store(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
            if (versionedEntityPropertyAccessor.isSet()) {
                this._vector.setSafe(n, versionedEntityPropertyAccessor.getInt());
            } else {
                this._vector.setNull(n);
            }
        }

        @Override
        public void load(VersionedEntityPropertyAccessor versionedEntityPropertyAccessor, int n) {
            super.load(versionedEntityPropertyAccessor, n);
            if (!this._vector.isNull(n)) {
                versionedEntityPropertyAccessor.set(this._vector.get(n));
            } else {
                versionedEntityPropertyAccessor.reset();
            }
        }
    }
}

