/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EdgePartition;
import com.raphtory.arrowcore.implementation.EdgePartitionManager;
import com.raphtory.arrowcore.implementation.RaphtoryArrowPartition;
import com.raphtory.arrowcore.implementation.VertexPartition;
import com.raphtory.arrowcore.implementation.VertexPartitionManager;

public class RaphtoryStatistics {
    private final RaphtoryArrowPartition _rap;
    private final VertexPartitionManager _vmgr;
    private final EdgePartitionManager _emgr;

    public RaphtoryStatistics(RaphtoryArrowPartition raphtoryArrowPartition) {
        this._rap = raphtoryArrowPartition;
        this._vmgr = raphtoryArrowPartition.getVertexMgr();
        this._emgr = raphtoryArrowPartition.getEdgeMgr();
    }

    public String toString() {
        return "nVertices: " + this.getNVertices() + ", nEdges: " + this.getNEdges() + ", nHistory: " + this.getNHistoryPoints();
    }

    public long getNVertices() {
        int n = this._vmgr.nPartitions();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            VertexPartition vertexPartition = this._vmgr.getPartition(i);
            l += (long)vertexPartition.getVerticesCount();
        }
        return l;
    }

    public long getNEdges() {
        int n = this._emgr.nPartitions();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            EdgePartition edgePartition = this._emgr.getPartition(i);
            l += (long)edgePartition.getEdgesCount();
        }
        return l;
    }

    public long getMinHistoryTime() {
        int n = this._vmgr.nPartitions();
        long l = Long.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            VertexPartition vertexPartition = this._vmgr.getPartition(i);
            long l2 = vertexPartition._history.getLowestTime();
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    public long getMaxHistoryTime() {
        int n = this._vmgr.nPartitions();
        long l = Long.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            VertexPartition vertexPartition = this._vmgr.getPartition(i);
            long l2 = vertexPartition._history.getHighestTime();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public long getNHistoryPoints() {
        int n = this._vmgr.nPartitions();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            VertexPartition vertexPartition = this._vmgr.getPartition(i);
            l += vertexPartition._history.getNHistoryItems();
        }
        return l;
    }
}

