/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EdgeHistoryStore;
import com.raphtory.arrowcore.implementation.EdgePartition;
import com.raphtory.arrowcore.implementation.EdgePartitionManager;

public abstract class EdgeHistoryIterator {
    private boolean _hasNext = false;
    private boolean _getNext = true;
    protected EdgePartitionManager _aepm;
    protected EdgePartition _edgePartition;
    protected EdgeHistoryStore _historyStore;
    protected int _partitionId = -1;
    protected long _edgeId;
    protected int _historyRow;

    protected void init(EdgePartitionManager edgePartitionManager) {
        this._aepm = edgePartitionManager;
        this._edgePartition = null;
        this._partitionId = -1;
        this._edgeId = -1L;
        this._historyStore = null;
        this._historyRow = -1;
        this._hasNext = false;
        this._getNext = true;
    }

    protected void init(EdgePartitionManager edgePartitionManager, long l) {
        this._aepm = edgePartitionManager;
        this._edgeId = l;
        this._partitionId = this._aepm.getPartitionId(l);
        this._edgePartition = this._aepm.getPartition(this._partitionId);
        this._historyStore = this._edgePartition._history.getHistoryStore();
        this._historyRow = -1;
        this._hasNext = false;
        this._getNext = true;
    }

    public final long next() {
        if (this._getNext) {
            this.moveToNext();
        }
        this._getNext = true;
        return this._edgeId;
    }

    public final boolean hasNext() {
        if (this._getNext) {
            this._hasNext = this.moveToNext();
            this._getNext = false;
        }
        return this._hasNext;
    }

    protected abstract boolean moveToNext();

    public long getEdgeId() {
        return this._edgeId;
    }

    public long getModificationTime() {
        return this._historyStore._times.get(this._historyRow);
    }

    public boolean wasActive() {
        return this._historyStore._states.get(this._historyRow) != 0;
    }

    public boolean wasUpdated() {
        return this._historyStore._updates.get(this._historyRow) != 0;
    }

    public static class WindowedEdgeHistoryIterator
    extends EdgeHistoryIterator {
        protected long _minTime;
        protected long _maxTime;
        protected int _firstIndex;
        protected int _lastIndex;
        protected int _index;
        protected boolean _firstTime = true;
        protected boolean _getNextPartition = false;
        protected boolean _edgeIdSupplied = false;

        private WindowedEdgeHistoryIterator() {
        }

        protected WindowedEdgeHistoryIterator(EdgePartitionManager edgePartitionManager, long l, long l2) {
            this.init(edgePartitionManager, l, l2);
        }

        protected WindowedEdgeHistoryIterator(EdgePartitionManager edgePartitionManager, long l, long l2, long l3) {
            this.init(edgePartitionManager, l, l2, l3);
        }

        protected void init(EdgePartitionManager edgePartitionManager, long l, long l2) {
            super.init(edgePartitionManager);
            this._minTime = l;
            this._maxTime = l2;
            this._firstTime = true;
            this._index = -1;
            this._getNextPartition = true;
            this._edgeIdSupplied = false;
        }

        protected void init(EdgePartitionManager edgePartitionManager, long l, long l2, long l3) {
            super.init(edgePartitionManager, l);
            this._minTime = l2;
            this._maxTime = l3;
            this._firstTime = true;
            this._firstIndex = -1;
            this._lastIndex = -1;
            this._index = -1;
            this._historyRow = -1;
            this._getNextPartition = false;
            this._edgeIdSupplied = true;
        }

        private long getNext() {
            while (true) {
                if (this._edgePartition == null && this._getNextPartition) {
                    this._edgePartition = this._aepm.getPartition(++this._partitionId);
                    this._firstIndex = -1;
                    this._lastIndex = -1;
                    this._index = -1;
                    this._edgeId = -1L;
                    this._historyRow = -1;
                    this._historyStore = null;
                }
                if (this._edgePartition == null) {
                    this._edgeId = -1L;
                    this._historyRow = -1;
                    this._historyStore = null;
                    return -1L;
                }
                if (this._lastIndex != -1) {
                    if (this._index >= this._firstIndex) {
                        this._historyRow = this._edgeIdSupplied ? this._edgePartition._history.getHistoryRowIdBySortedEdgeIndex(this._index) : this._edgePartition._history.getHistoryRowIdBySortedIndex(this._index);
                        int n = this._edgePartition._history.getEdgeLocalRowIdByHistoryRowId(this._historyRow);
                        return this._edgePartition._getLocalEdgeIdByRow(n);
                    }
                    this._firstIndex = -1;
                    this._lastIndex = -1;
                    this._index = -1;
                    this._edgePartition = null;
                    this._edgeId = -1L;
                    this._historyRow = -1;
                    this._historyStore = null;
                    continue;
                }
                this._edgePartition._history.findHistory(this);
                if (this._lastIndex == -1) {
                    this._edgePartition = null;
                    this._edgeId = -1L;
                    this._historyRow = -1;
                    this._historyStore = null;
                    continue;
                }
                this._index = this._lastIndex;
                this._historyStore = this._edgePartition._history.getHistoryStore();
            }
        }

        @Override
        protected boolean moveToNext() {
            if (!this._firstTime) {
                --this._index;
            } else {
                this._firstTime = false;
            }
            this._edgeId = this.getNext();
            return this._edgeId != -1L;
        }
    }
}

