/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EdgeIterator;
import com.raphtory.arrowcore.implementation.EdgePartition;
import com.raphtory.arrowcore.implementation.EdgePartitionManager;
import com.raphtory.arrowcore.implementation.VertexPartition;
import com.raphtory.arrowcore.implementation.VertexPartitionManager;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class CachedMutatingEdgeMap {
    public static final int N_EDGES_FOR_MAP = 64;
    protected final VertexPartition _p;
    protected final EdgePartitionManager _aepm;
    protected final VertexPartitionManager _avpm;
    protected final Long2ObjectOpenHashMap<Long2LongOpenHashMap> _vertexToEdgeMapMap = new Long2ObjectOpenHashMap();
    protected final ObjectArrayList<LongArrayList> _edgeLists = new ObjectArrayList();

    public CachedMutatingEdgeMap(VertexPartition vertexPartition, VertexPartitionManager vertexPartitionManager, EdgePartitionManager edgePartitionManager) {
        this._p = vertexPartition;
        this._avpm = vertexPartitionManager;
        this._aepm = edgePartitionManager;
    }

    protected void addEdge(long l, long l2, long l3, long l4, int n) {
        boolean bl;
        if (n < 64) {
            return;
        }
        Long2LongOpenHashMap long2LongOpenHashMap = (Long2LongOpenHashMap)this._vertexToEdgeMapMap.get(l);
        boolean bl2 = bl = long2LongOpenHashMap == null;
        if (bl) {
            long2LongOpenHashMap = new Long2LongOpenHashMap();
            long2LongOpenHashMap.defaultReturnValue(Long.MAX_VALUE);
            this._vertexToEdgeMapMap.put(l, (Object)long2LongOpenHashMap);
            this.addAllEdges(long2LongOpenHashMap, l2, l3, l4);
        } else {
            this.addEdge(long2LongOpenHashMap, l3, l2);
        }
    }

    private void addAllEdges(Long2LongOpenHashMap long2LongOpenHashMap, long l, long l2, long l3) {
        this.addEdge(long2LongOpenHashMap, l2, l);
        this.addAllEdges(long2LongOpenHashMap, l3);
    }

    protected abstract void addAllEdges(Long2LongOpenHashMap var1, long var2);

    protected abstract void addAllEdgesFromOriginatingVertex(Long2LongOpenHashMap var1, long var2);

    protected void addEdge(Long2LongOpenHashMap long2LongOpenHashMap, long l, long l2) {
        long l3 = long2LongOpenHashMap.get(l2);
        if (l3 >= 0L) {
            if (l3 == Long.MAX_VALUE) {
                long2LongOpenHashMap.put(l2, l);
            } else {
                long l4 = l3;
                LongArrayList longArrayList = new LongArrayList();
                longArrayList.add(l4);
                longArrayList.add(l);
                this._edgeLists.add((Object)longArrayList);
                int n = -this._edgeLists.size();
                long2LongOpenHashMap.put(l2, (long)n);
            }
        } else {
            int n = (int)(-l3 - 1L);
            LongArrayList longArrayList = (LongArrayList)this._edgeLists.get(n);
            longArrayList.add(l);
        }
    }

    public EdgeIterator findMatchingEdges(long l, long l2, boolean bl, int n, MatchingEdgeCachedIterator matchingEdgeCachedIterator) {
        matchingEdgeCachedIterator.init(this._aepm);
        Long2LongOpenHashMap long2LongOpenHashMap = (Long2LongOpenHashMap)this._vertexToEdgeMapMap.get(l);
        if (long2LongOpenHashMap != null) {
            long l3 = long2LongOpenHashMap.get(l2);
            if (l3 >= 0L) {
                matchingEdgeCachedIterator.init(l3);
            } else {
                int n2 = (int)(-l3 - 1L);
                matchingEdgeCachedIterator.init((LongArrayList)this._edgeLists.get(n2), bl);
            }
        } else if (n >= 64) {
            long2LongOpenHashMap = new Long2LongOpenHashMap();
            long2LongOpenHashMap.defaultReturnValue(Long.MAX_VALUE);
            this._vertexToEdgeMapMap.put(l, (Object)long2LongOpenHashMap);
            this.addAllEdgesFromOriginatingVertex(long2LongOpenHashMap, l);
            long l4 = long2LongOpenHashMap.get(l2);
            if (l4 >= 0L) {
                matchingEdgeCachedIterator.init(l4);
            } else {
                int n3 = (int)(-l4 - 1L);
                matchingEdgeCachedIterator.init((LongArrayList)this._edgeLists.get(n3), bl);
            }
        } else {
            matchingEdgeCachedIterator.init(this._avpm, l, l2, bl);
        }
        return matchingEdgeCachedIterator;
    }

    public static class IncomingMatchingEdgeCachedIterator
    extends MatchingEdgeCachedIterator {
        @Override
        protected long getHeadEdgePtr(VertexPartition vertexPartition, int n) {
            return vertexPartition._getIncomingEdgePtrByRow(n);
        }

        @Override
        protected boolean localFlagMatches() {
            return this.isSrcVertexGlobal() == this._isGlobal;
        }

        @Override
        protected boolean vertexAndLocalFlagMatches() {
            return this.getSrcVertexId() == this._vertexId && this.isSrcVertexGlobal() == this._isGlobal;
        }

        @Override
        protected long goToNextEdge() {
            return this._edgePartition._getPrevIncomingPtrByRow(this._edgeRowId);
        }
    }

    public static class OutgoingMatchingEdgeCachedIterator
    extends MatchingEdgeCachedIterator {
        @Override
        protected long getHeadEdgePtr(VertexPartition vertexPartition, int n) {
            return vertexPartition._getOutgoingEdgePtrByRow(n);
        }

        @Override
        protected boolean localFlagMatches() {
            return this.isDstVertexGlobal() == this._isGlobal;
        }

        @Override
        protected boolean vertexAndLocalFlagMatches() {
            return this.getDstVertexId() == this._vertexId && this.isDstVertexGlobal() == this._isGlobal;
        }

        @Override
        protected long goToNextEdge() {
            return this._edgePartition._getPrevOutgoingPtrByRow(this._edgeRowId);
        }
    }

    public static abstract class MatchingEdgeCachedIterator
    extends EdgeIterator {
        protected boolean _isGlobal;
        protected long _vertexId;
        protected long _nextEdgeId;
        protected int _index = 0;
        protected boolean _useEdgeArrayList;
        protected long[] _edges;
        protected int _nEdges;

        protected void init(long l) {
            if (l == Long.MAX_VALUE) {
                this._edgeId = -1L;
                this._edgeRowId = -1;
                this._edgePartition = null;
                this._hasNext = false;
                this._getNext = false;
            } else {
                this.reset(l);
            }
            this._useEdgeArrayList = false;
            this._nEdges = 0;
        }

        protected void init(LongArrayList longArrayList, boolean bl) {
            this._useEdgeArrayList = true;
            this._index = 0;
            if (longArrayList == null || longArrayList.size() == 0) {
                this._edges = null;
                this._nEdges = 0;
            } else {
                this._nEdges = longArrayList.size();
                this._edges = longArrayList.elements();
            }
            this._isGlobal = bl;
        }

        protected void init(VertexPartitionManager vertexPartitionManager, long l, long l2, boolean bl) {
            this._useEdgeArrayList = false;
            this._vertexId = l2;
            this._isGlobal = bl;
            int n = vertexPartitionManager.getPartitionId(l);
            int n2 = vertexPartitionManager.getRowId(l);
            this._nextEdgeId = this.getHeadEdgePtr(vertexPartitionManager.getPartition(n), n2);
        }

        @Override
        protected boolean moveToNext() {
            if (this._useEdgeArrayList) {
                if (this._nEdges == 0) {
                    return false;
                }
                while (this._index < this._nEdges) {
                    boolean bl;
                    if (!(bl = this.reset(this._edges[this._index++]))) {
                        return false;
                    }
                    if (!this.localFlagMatches()) continue;
                    return true;
                }
                return false;
            }
            while (this._nextEdgeId != -1L) {
                if (!this.reset(this._nextEdgeId)) {
                    return false;
                }
                this._nextEdgeId = this.goToNextEdge();
                if (!this.vertexAndLocalFlagMatches()) continue;
                return true;
            }
            return false;
        }

        protected abstract long getHeadEdgePtr(VertexPartition var1, int var2);

        protected abstract boolean localFlagMatches();

        protected abstract boolean vertexAndLocalFlagMatches();

        protected abstract long goToNextEdge();
    }

    public static class IncomingCachedMutatingEdgeMap
    extends CachedMutatingEdgeMap {
        public IncomingCachedMutatingEdgeMap(VertexPartition vertexPartition, VertexPartitionManager vertexPartitionManager, EdgePartitionManager edgePartitionManager) {
            super(vertexPartition, vertexPartitionManager, edgePartitionManager);
        }

        @Override
        protected void addAllEdges(Long2LongOpenHashMap long2LongOpenHashMap, long l) {
            while (l != -1L) {
                int n = this._aepm.getPartitionId(l);
                int n2 = this._aepm.getRowId(l);
                EdgePartition edgePartition = this._aepm.getPartition(n);
                this.addEdge(long2LongOpenHashMap, l, edgePartition.getSrcVertexId(n2));
                l = edgePartition._getPrevIncomingPtrByRow(n2);
            }
        }

        @Override
        protected void addAllEdgesFromOriginatingVertex(Long2LongOpenHashMap long2LongOpenHashMap, long l) {
            int n = this._avpm.getRowId(l);
            this.addAllEdges(long2LongOpenHashMap, this._p._getIncomingEdgePtrByRow(n));
        }
    }

    public static class OutgoingCachedMutatingEdgeMap
    extends CachedMutatingEdgeMap {
        public OutgoingCachedMutatingEdgeMap(VertexPartition vertexPartition, VertexPartitionManager vertexPartitionManager, EdgePartitionManager edgePartitionManager) {
            super(vertexPartition, vertexPartitionManager, edgePartitionManager);
        }

        @Override
        protected void addAllEdges(Long2LongOpenHashMap long2LongOpenHashMap, long l) {
            while (l != -1L) {
                int n = this._aepm.getPartitionId(l);
                int n2 = this._aepm.getRowId(l);
                EdgePartition edgePartition = this._aepm.getPartition(n);
                this.addEdge(long2LongOpenHashMap, l, edgePartition.getDstVertexId(n2));
                l = edgePartition._getPrevOutgoingPtrByRow(n2);
            }
        }

        @Override
        protected void addAllEdgesFromOriginatingVertex(Long2LongOpenHashMap long2LongOpenHashMap, long l) {
            int n = this._avpm.getRowId(l);
            this.addAllEdges(long2LongOpenHashMap, this._p._getOutgoingEdgePtrByRow(n));
        }
    }
}

