from setuptools import setup, find_namespace_packages


def _read(f):
    """
    Reads in the content of the file.
    :param f: the file to read
    :type f: str
    :return: the content
    :rtype: str
    """
    return open(f, 'rb').read()


setup(
    name="audio_dataset_converter_faster_whisper",
    description="Python3 library that adds audio transcription support (.wav, .mp3) to the audio-dataset-converter library.",
    long_description=(
            _read('DESCRIPTION.rst') + b'\n' +
            _read('CHANGES.rst')).decode('utf-8'),
    url="https://github.com/waikato-llm/audio-dataset-converter-faster-whisper",
    classifiers=[
        'Development Status :: 4 - Beta',
        'License :: OSI Approved :: MIT License',
        'Topic :: Scientific/Engineering :: Artificial Intelligence',
        'Programming Language :: Python :: 3',
    ],
    license='MIT License',
    package_dir={
        '': 'src'
    },
    packages=find_namespace_packages(where='src'),
    install_requires=[
        "audio_dataset_converter>=0.0.1",
        "faster_whisper",
    ],
    version="0.1.0",
    author='Peter Reutemann',
    author_email='fracpete@waikato.ac.nz',
    entry_points={
        "console_scripts": [
            "adc-srt=adc_faster_whisper.tool.srt:sys_main",
        ],
        "class_lister": [
            "adc_faster_whisper=adc_faster_whisper.class_lister",
        ],
    },
)
