"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cdk8sTypeScriptApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const component_1 = require("./component");
const tasks_1 = require("./tasks");
const typescript_1 = require("./typescript");
/**
 * (experimental) CDK8s app in TypeScript.
 *
 * @experimental
 * @pjid cdk8s-app-ts
 */
class Cdk8sTypeScriptApp extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c;
        super({
            ...options,
            sampleCode: false,
        });
        // encode a hidden assumption further down the chain
        if (this.srcdir !== 'src') {
            throw new Error('sources are expected under the "src" directory');
        }
        // encode a hidden assumption further down the chain
        if (this.testdir !== 'test') {
            throw new Error('test sources are expected under the "test" directory');
        }
        this.appEntrypoint = (_b = options.appEntrypoint) !== null && _b !== void 0 ? _b : 'main.ts';
        this.cdk8sVersion = options.cdk8sVersionPinning ? options.cdk8sVersion : `^${options.cdk8sVersion}`;
        // CLI
        this.addDeps(`cdk8s@${this.cdk8sVersion}`, 'constructs@^3.2.34', `cdk8s-plus-17@${this.cdk8sVersion}`);
        this.addDevDeps('ts-node');
        const synth = this.addTask('synth', {
            description: 'Synthesizes your cdk8s app into dist (part of "yarn build")',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'cdk8s synth',
        });
        this.addTask('import', {
            description: 'Imports API objects to your app by generating constructs.',
            category: tasks_1.TaskCategory.MISC,
            exec: 'cdk8s import',
        });
        this.gitignore.include('imports/');
        this.gitignore.include('cdk8s.yaml');
        // add synth to the build
        this.buildTask.spawn(synth);
        if ((_c = options.sampleCode) !== null && _c !== void 0 ? _c : true) {
            new SampleCode(this);
        }
    }
}
exports.Cdk8sTypeScriptApp = Cdk8sTypeScriptApp;
_a = JSII_RTTI_SYMBOL_1;
Cdk8sTypeScriptApp[_a] = { fqn: "projen.Cdk8sTypeScriptApp", version: "0.17.49" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        this.appProject = project;
    }
    synthesize() {
        const outdir = this.project.outdir;
        const srcdir = path.join(outdir, this.appProject.srcdir);
        if (fs.pathExistsSync(srcdir) && fs.readdirSync(srcdir).filter(x => x.endsWith('.ts'))) {
            return;
        }
        const srcCode = `import { Construct } from 'constructs';
import { App, Chart, ChartProps, ApiObject } from 'cdk8s';

export class MyChart extends Chart {
  constructor(scope: Construct, id: string, props: ChartProps = { }) {
    super(scope, id, props);

    const label = { app: 'hello-k8s' };



    new ApiObject(this, 'deployment', {
      apiVersion: "v1",
      kind: "Pod",
      metadata: {
          namespace: "frontend",
          name: "nginx",
          labels: label,
      },
      spec: {
          containers: [{
              name: "nginx",
              image: "nginx:1.14-alpine",
              resources: {
                  limits: {
                      memory: "20Mi",
                      cpu: 0.2,
                  },
              },
          }],
      },
    });
  }
}

const app = new App();
new MyChart(app, 'hello');
app.synth();`;
        fs.mkdirpSync(srcdir);
        fs.writeFileSync(path.join(srcdir, this.appProject.appEntrypoint), srcCode);
        const appEntrypointName = path.basename(this.appProject.appEntrypoint, '.ts');
        const cdk8sYaml = `language: typescript
app: node src/${appEntrypointName}.js
imports:
  - k8s
    `;
        fs.writeFileSync(path.join(outdir, 'cdk8s.yaml'), cdk8sYaml);
    }
}
//# sourceMappingURL=data:application/json;base64,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