# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class SubResource(Model):
    """Reference to another subresource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AgentPool(SubResource):
    """Agent Pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param count: Number of agents (VMs) to host docker containers. Allowed
     values must be in the range of 0 to 100 (inclusive) for user pools and in
     the range of 1 to 100 (inclusive) for system pools. The default value is
     1.
    :type count: int
    :param vm_size: Size of agent VMs. Possible values include: 'Standard_A1',
     'Standard_A10', 'Standard_A11', 'Standard_A1_v2', 'Standard_A2',
     'Standard_A2_v2', 'Standard_A2m_v2', 'Standard_A3', 'Standard_A4',
     'Standard_A4_v2', 'Standard_A4m_v2', 'Standard_A5', 'Standard_A6',
     'Standard_A7', 'Standard_A8', 'Standard_A8_v2', 'Standard_A8m_v2',
     'Standard_A9', 'Standard_B2ms', 'Standard_B2s', 'Standard_B4ms',
     'Standard_B8ms', 'Standard_D1', 'Standard_D11', 'Standard_D11_v2',
     'Standard_D11_v2_Promo', 'Standard_D12', 'Standard_D12_v2',
     'Standard_D12_v2_Promo', 'Standard_D13', 'Standard_D13_v2',
     'Standard_D13_v2_Promo', 'Standard_D14', 'Standard_D14_v2',
     'Standard_D14_v2_Promo', 'Standard_D15_v2', 'Standard_D16_v3',
     'Standard_D16s_v3', 'Standard_D1_v2', 'Standard_D2', 'Standard_D2_v2',
     'Standard_D2_v2_Promo', 'Standard_D2_v3', 'Standard_D2s_v3',
     'Standard_D3', 'Standard_D32_v3', 'Standard_D32s_v3', 'Standard_D3_v2',
     'Standard_D3_v2_Promo', 'Standard_D4', 'Standard_D4_v2',
     'Standard_D4_v2_Promo', 'Standard_D4_v3', 'Standard_D4s_v3',
     'Standard_D5_v2', 'Standard_D5_v2_Promo', 'Standard_D64_v3',
     'Standard_D64s_v3', 'Standard_D8_v3', 'Standard_D8s_v3', 'Standard_DS1',
     'Standard_DS11', 'Standard_DS11_v2', 'Standard_DS11_v2_Promo',
     'Standard_DS12', 'Standard_DS12_v2', 'Standard_DS12_v2_Promo',
     'Standard_DS13', 'Standard_DS13-2_v2', 'Standard_DS13-4_v2',
     'Standard_DS13_v2', 'Standard_DS13_v2_Promo', 'Standard_DS14',
     'Standard_DS14-4_v2', 'Standard_DS14-8_v2', 'Standard_DS14_v2',
     'Standard_DS14_v2_Promo', 'Standard_DS15_v2', 'Standard_DS1_v2',
     'Standard_DS2', 'Standard_DS2_v2', 'Standard_DS2_v2_Promo',
     'Standard_DS3', 'Standard_DS3_v2', 'Standard_DS3_v2_Promo',
     'Standard_DS4', 'Standard_DS4_v2', 'Standard_DS4_v2_Promo',
     'Standard_DS5_v2', 'Standard_DS5_v2_Promo', 'Standard_E16_v3',
     'Standard_E16s_v3', 'Standard_E2_v3', 'Standard_E2s_v3',
     'Standard_E32-16s_v3', 'Standard_E32-8s_v3', 'Standard_E32_v3',
     'Standard_E32s_v3', 'Standard_E4_v3', 'Standard_E4s_v3',
     'Standard_E64-16s_v3', 'Standard_E64-32s_v3', 'Standard_E64_v3',
     'Standard_E64s_v3', 'Standard_E8_v3', 'Standard_E8s_v3', 'Standard_F1',
     'Standard_F16', 'Standard_F16s', 'Standard_F16s_v2', 'Standard_F1s',
     'Standard_F2', 'Standard_F2s', 'Standard_F2s_v2', 'Standard_F32s_v2',
     'Standard_F4', 'Standard_F4s', 'Standard_F4s_v2', 'Standard_F64s_v2',
     'Standard_F72s_v2', 'Standard_F8', 'Standard_F8s', 'Standard_F8s_v2',
     'Standard_G1', 'Standard_G2', 'Standard_G3', 'Standard_G4', 'Standard_G5',
     'Standard_GS1', 'Standard_GS2', 'Standard_GS3', 'Standard_GS4',
     'Standard_GS4-4', 'Standard_GS4-8', 'Standard_GS5', 'Standard_GS5-16',
     'Standard_GS5-8', 'Standard_H16', 'Standard_H16m', 'Standard_H16mr',
     'Standard_H16r', 'Standard_H8', 'Standard_H8m', 'Standard_L16s',
     'Standard_L32s', 'Standard_L4s', 'Standard_L8s', 'Standard_M128-32ms',
     'Standard_M128-64ms', 'Standard_M128ms', 'Standard_M128s',
     'Standard_M64-16ms', 'Standard_M64-32ms', 'Standard_M64ms',
     'Standard_M64s', 'Standard_NC12', 'Standard_NC12s_v2',
     'Standard_NC12s_v3', 'Standard_NC24', 'Standard_NC24r',
     'Standard_NC24rs_v2', 'Standard_NC24rs_v3', 'Standard_NC24s_v2',
     'Standard_NC24s_v3', 'Standard_NC6', 'Standard_NC6s_v2',
     'Standard_NC6s_v3', 'Standard_ND12s', 'Standard_ND24rs', 'Standard_ND24s',
     'Standard_ND6s', 'Standard_NV12', 'Standard_NV24', 'Standard_NV6'
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk
     size for every machine in this master/agent pool. If you specify 0, it
     will apply the default osDisk size according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet
     identifier.
    :type vnet_subnet_id: str
    :param max_pods: Maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: OsType to be used to specify os type. Choose from Linux
     and Windows. Default to Linux. Possible values include: 'Linux',
     'Windows'. Default value: "Linux" .
    :type os_type: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.OSType
    :param max_count: Maximum number of nodes for auto-scaling
    :type max_count: int
    :param min_count: Minimum number of nodes for auto-scaling
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler
    :type enable_auto_scaling: bool
    :param agent_pool_type: AgentPoolType represents types of an agent pool.
     Possible values include: 'VirtualMachineScaleSets', 'AvailabilitySet'
    :type agent_pool_type: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.AgentPoolType
    :param mode: AgentPoolMode represents mode of an agent pool. Possible
     values include: 'System', 'User'
    :type mode: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.AgentPoolMode
    :param orchestrator_version: Version of orchestrator specified when
     creating the managed cluster.
    :type orchestrator_version: str
    :ivar provisioning_state: The current deployment or provisioning state,
     which only appears in the response.
    :vartype provisioning_state: str
    :param availability_zones: Availability zones for nodes. Must use
     VirtualMachineScaleSets AgentPoolType.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Enable public IP for nodes
    :type enable_node_public_ip: bool
    :param scale_set_priority: ScaleSetPriority to be used to specify virtual
     machine scale set priority. Default to regular. Possible values include:
     'Spot', 'Low', 'Regular'. Default value: "Regular" .
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to
     specify eviction policy for Spot or low priority virtual machine scale
     set. Default to Delete. Possible values include: 'Delete', 'Deallocate'.
     Default value: "Delete" .
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ScaleSetEvictionPolicy
    :param spot_max_price: SpotMaxPrice to be used to specify the maximum
     price you are willing to pay in US Dollars. Possible values are any
     decimal value greater than zero or -1 which indicates default price to be
     up-to on-demand.
    :type spot_max_price: float
    :param tags: Agent pool tags to be persisted on the agent pool virtual
     machine scale set.
    :type tags: dict[str, str]
    :param node_labels: Agent pool node labels to be persisted across all
     nodes in agent pool.
    :type node_labels: dict[str, str]
    :param node_taints: Taints added to new nodes during node pool create and
     scale. For example, key=value:NoSchedule.
    :type node_taints: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'count': {'key': 'properties.count', 'type': 'int'},
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'properties.osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'properties.vnetSubnetID', 'type': 'str'},
        'max_pods': {'key': 'properties.maxPods', 'type': 'int'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'max_count': {'key': 'properties.maxCount', 'type': 'int'},
        'min_count': {'key': 'properties.minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'properties.enableAutoScaling', 'type': 'bool'},
        'agent_pool_type': {'key': 'properties.type', 'type': 'str'},
        'mode': {'key': 'properties.mode', 'type': 'str'},
        'orchestrator_version': {'key': 'properties.orchestratorVersion', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'availability_zones': {'key': 'properties.availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'properties.enableNodePublicIP', 'type': 'bool'},
        'scale_set_priority': {'key': 'properties.scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'properties.scaleSetEvictionPolicy', 'type': 'str'},
        'spot_max_price': {'key': 'properties.spotMaxPrice', 'type': 'float'},
        'tags': {'key': 'properties.tags', 'type': '{str}'},
        'node_labels': {'key': 'properties.nodeLabels', 'type': '{str}'},
        'node_taints': {'key': 'properties.nodeTaints', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(AgentPool, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.os_disk_size_gb = kwargs.get('os_disk_size_gb', None)
        self.vnet_subnet_id = kwargs.get('vnet_subnet_id', None)
        self.max_pods = kwargs.get('max_pods', None)
        self.os_type = kwargs.get('os_type', "Linux")
        self.max_count = kwargs.get('max_count', None)
        self.min_count = kwargs.get('min_count', None)
        self.enable_auto_scaling = kwargs.get('enable_auto_scaling', None)
        self.agent_pool_type = kwargs.get('agent_pool_type', None)
        self.mode = kwargs.get('mode', None)
        self.orchestrator_version = kwargs.get('orchestrator_version', None)
        self.provisioning_state = None
        self.availability_zones = kwargs.get('availability_zones', None)
        self.enable_node_public_ip = kwargs.get('enable_node_public_ip', None)
        self.scale_set_priority = kwargs.get('scale_set_priority', "Regular")
        self.scale_set_eviction_policy = kwargs.get('scale_set_eviction_policy', "Delete")
        self.spot_max_price = kwargs.get('spot_max_price', None)
        self.tags = kwargs.get('tags', None)
        self.node_labels = kwargs.get('node_labels', None)
        self.node_taints = kwargs.get('node_taints', None)


class AgentPoolAvailableVersions(Model):
    """The list of available versions for an agent pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Id of the agent pool available versions.
    :vartype id: str
    :ivar name: Name of the agent pool available versions.
    :vartype name: str
    :ivar type: Type of the agent pool  available versions.
    :vartype type: str
    :param agent_pool_versions: List of versions available for agent pool.
    :type agent_pool_versions:
     list[~azure.mgmt.containerservice.v2020_03_01.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'agent_pool_versions': {'key': 'properties.agentPoolVersions', 'type': '[AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]'},
    }

    def __init__(self, **kwargs):
        super(AgentPoolAvailableVersions, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.agent_pool_versions = kwargs.get('agent_pool_versions', None)


class AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem(Model):
    """AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.

    :param default: Whether this version is the default agent pool version.
    :type default: bool
    :param kubernetes_version: Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'default': {'key': 'default', 'type': 'bool'},
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem, self).__init__(**kwargs)
        self.default = kwargs.get('default', None)
        self.kubernetes_version = kwargs.get('kubernetes_version', None)
        self.is_preview = kwargs.get('is_preview', None)


class AgentPoolUpgradeProfile(Model):
    """The list of available upgrades for an agent pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Id of the agent pool upgrade profile.
    :vartype id: str
    :ivar name: Name of the agent pool upgrade profile.
    :vartype name: str
    :ivar type: Type of the agent pool upgrade profile.
    :vartype type: str
    :param kubernetes_version: Required. Kubernetes version (major, minor,
     patch).
    :type kubernetes_version: str
    :param os_type: Required. OsType to be used to specify os type. Choose
     from Linux and Windows. Default to Linux. Possible values include:
     'Linux', 'Windows'. Default value: "Linux" .
    :type os_type: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.OSType
    :param upgrades: List of orchestrator types and versions available for
     upgrade.
    :type upgrades:
     list[~azure.mgmt.containerservice.v2020_03_01.models.AgentPoolUpgradeProfilePropertiesUpgradesItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kubernetes_version': {'required': True},
        'os_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'upgrades': {'key': 'properties.upgrades', 'type': '[AgentPoolUpgradeProfilePropertiesUpgradesItem]'},
    }

    def __init__(self, **kwargs):
        super(AgentPoolUpgradeProfile, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kubernetes_version = kwargs.get('kubernetes_version', None)
        self.os_type = kwargs.get('os_type', "Linux")
        self.upgrades = kwargs.get('upgrades', None)


class AgentPoolUpgradeProfilePropertiesUpgradesItem(Model):
    """AgentPoolUpgradeProfilePropertiesUpgradesItem.

    :param kubernetes_version: Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(AgentPoolUpgradeProfilePropertiesUpgradesItem, self).__init__(**kwargs)
        self.kubernetes_version = kwargs.get('kubernetes_version', None)
        self.is_preview = kwargs.get('is_preview', None)


class CloudError(Model):
    """An error response from the Container service.

    :param error: Details about the error.
    :type error:
     ~azure.mgmt.containerservice.v2020_03_01.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, **kwargs):
        super(CloudError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response from the Container service.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name
     of the property in error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details:
     list[~azure.mgmt.containerservice.v2020_03_01.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(self, **kwargs):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class ContainerServiceDiagnosticsProfile(Model):
    """Profile for diagnostics on the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param vm_diagnostics: Required. Profile for diagnostics on the container
     service VMs.
    :type vm_diagnostics:
     ~azure.mgmt.containerservice.v2020_03_01.models.ContainerServiceVMDiagnostics
    """

    _validation = {
        'vm_diagnostics': {'required': True},
    }

    _attribute_map = {
        'vm_diagnostics': {'key': 'vmDiagnostics', 'type': 'ContainerServiceVMDiagnostics'},
    }

    def __init__(self, **kwargs):
        super(ContainerServiceDiagnosticsProfile, self).__init__(**kwargs)
        self.vm_diagnostics = kwargs.get('vm_diagnostics', None)


class ContainerServiceLinuxProfile(Model):
    """Profile for Linux VMs in the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param admin_username: Required. The administrator username to use for
     Linux VMs.
    :type admin_username: str
    :param ssh: Required. SSH configuration for Linux-based VMs running on
     Azure.
    :type ssh:
     ~azure.mgmt.containerservice.v2020_03_01.models.ContainerServiceSshConfiguration
    """

    _validation = {
        'admin_username': {'required': True, 'pattern': r'^[A-Za-z][-A-Za-z0-9_]*$'},
        'ssh': {'required': True},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'ssh': {'key': 'ssh', 'type': 'ContainerServiceSshConfiguration'},
    }

    def __init__(self, **kwargs):
        super(ContainerServiceLinuxProfile, self).__init__(**kwargs)
        self.admin_username = kwargs.get('admin_username', None)
        self.ssh = kwargs.get('ssh', None)


class ContainerServiceMasterProfile(Model):
    """Profile for the container service master.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param count: Number of masters (VMs) in the container service cluster.
     Allowed values are 1, 3, and 5. The default value is 1. Default value: 1 .
    :type count: int
    :param dns_prefix: Required. DNS prefix to be used to create the FQDN for
     the master pool.
    :type dns_prefix: str
    :param vm_size: Required. Size of agent VMs. Possible values include:
     'Standard_A1', 'Standard_A10', 'Standard_A11', 'Standard_A1_v2',
     'Standard_A2', 'Standard_A2_v2', 'Standard_A2m_v2', 'Standard_A3',
     'Standard_A4', 'Standard_A4_v2', 'Standard_A4m_v2', 'Standard_A5',
     'Standard_A6', 'Standard_A7', 'Standard_A8', 'Standard_A8_v2',
     'Standard_A8m_v2', 'Standard_A9', 'Standard_B2ms', 'Standard_B2s',
     'Standard_B4ms', 'Standard_B8ms', 'Standard_D1', 'Standard_D11',
     'Standard_D11_v2', 'Standard_D11_v2_Promo', 'Standard_D12',
     'Standard_D12_v2', 'Standard_D12_v2_Promo', 'Standard_D13',
     'Standard_D13_v2', 'Standard_D13_v2_Promo', 'Standard_D14',
     'Standard_D14_v2', 'Standard_D14_v2_Promo', 'Standard_D15_v2',
     'Standard_D16_v3', 'Standard_D16s_v3', 'Standard_D1_v2', 'Standard_D2',
     'Standard_D2_v2', 'Standard_D2_v2_Promo', 'Standard_D2_v3',
     'Standard_D2s_v3', 'Standard_D3', 'Standard_D32_v3', 'Standard_D32s_v3',
     'Standard_D3_v2', 'Standard_D3_v2_Promo', 'Standard_D4', 'Standard_D4_v2',
     'Standard_D4_v2_Promo', 'Standard_D4_v3', 'Standard_D4s_v3',
     'Standard_D5_v2', 'Standard_D5_v2_Promo', 'Standard_D64_v3',
     'Standard_D64s_v3', 'Standard_D8_v3', 'Standard_D8s_v3', 'Standard_DS1',
     'Standard_DS11', 'Standard_DS11_v2', 'Standard_DS11_v2_Promo',
     'Standard_DS12', 'Standard_DS12_v2', 'Standard_DS12_v2_Promo',
     'Standard_DS13', 'Standard_DS13-2_v2', 'Standard_DS13-4_v2',
     'Standard_DS13_v2', 'Standard_DS13_v2_Promo', 'Standard_DS14',
     'Standard_DS14-4_v2', 'Standard_DS14-8_v2', 'Standard_DS14_v2',
     'Standard_DS14_v2_Promo', 'Standard_DS15_v2', 'Standard_DS1_v2',
     'Standard_DS2', 'Standard_DS2_v2', 'Standard_DS2_v2_Promo',
     'Standard_DS3', 'Standard_DS3_v2', 'Standard_DS3_v2_Promo',
     'Standard_DS4', 'Standard_DS4_v2', 'Standard_DS4_v2_Promo',
     'Standard_DS5_v2', 'Standard_DS5_v2_Promo', 'Standard_E16_v3',
     'Standard_E16s_v3', 'Standard_E2_v3', 'Standard_E2s_v3',
     'Standard_E32-16s_v3', 'Standard_E32-8s_v3', 'Standard_E32_v3',
     'Standard_E32s_v3', 'Standard_E4_v3', 'Standard_E4s_v3',
     'Standard_E64-16s_v3', 'Standard_E64-32s_v3', 'Standard_E64_v3',
     'Standard_E64s_v3', 'Standard_E8_v3', 'Standard_E8s_v3', 'Standard_F1',
     'Standard_F16', 'Standard_F16s', 'Standard_F16s_v2', 'Standard_F1s',
     'Standard_F2', 'Standard_F2s', 'Standard_F2s_v2', 'Standard_F32s_v2',
     'Standard_F4', 'Standard_F4s', 'Standard_F4s_v2', 'Standard_F64s_v2',
     'Standard_F72s_v2', 'Standard_F8', 'Standard_F8s', 'Standard_F8s_v2',
     'Standard_G1', 'Standard_G2', 'Standard_G3', 'Standard_G4', 'Standard_G5',
     'Standard_GS1', 'Standard_GS2', 'Standard_GS3', 'Standard_GS4',
     'Standard_GS4-4', 'Standard_GS4-8', 'Standard_GS5', 'Standard_GS5-16',
     'Standard_GS5-8', 'Standard_H16', 'Standard_H16m', 'Standard_H16mr',
     'Standard_H16r', 'Standard_H8', 'Standard_H8m', 'Standard_L16s',
     'Standard_L32s', 'Standard_L4s', 'Standard_L8s', 'Standard_M128-32ms',
     'Standard_M128-64ms', 'Standard_M128ms', 'Standard_M128s',
     'Standard_M64-16ms', 'Standard_M64-32ms', 'Standard_M64ms',
     'Standard_M64s', 'Standard_NC12', 'Standard_NC12s_v2',
     'Standard_NC12s_v3', 'Standard_NC24', 'Standard_NC24r',
     'Standard_NC24rs_v2', 'Standard_NC24rs_v3', 'Standard_NC24s_v2',
     'Standard_NC24s_v3', 'Standard_NC6', 'Standard_NC6s_v2',
     'Standard_NC6s_v3', 'Standard_ND12s', 'Standard_ND24rs', 'Standard_ND24s',
     'Standard_ND6s', 'Standard_NV12', 'Standard_NV24', 'Standard_NV6'
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk
     size for every machine in this master/agent pool. If you specify 0, it
     will apply the default osDisk size according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet
     identifier.
    :type vnet_subnet_id: str
    :param first_consecutive_static_ip: FirstConsecutiveStaticIP used to
     specify the first static ip of masters. Default value: "10.240.255.5" .
    :type first_consecutive_static_ip: str
    :param storage_profile: Storage profile specifies what kind of storage
     used. Choose from StorageAccount and ManagedDisks. Leave it empty, we will
     choose for you based on the orchestrator choice. Possible values include:
     'StorageAccount', 'ManagedDisks'
    :type storage_profile: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ContainerServiceStorageProfileTypes
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    """

    _validation = {
        'dns_prefix': {'required': True},
        'vm_size': {'required': True},
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'dns_prefix': {'key': 'dnsPrefix', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'first_consecutive_static_ip': {'key': 'firstConsecutiveStaticIP', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerServiceMasterProfile, self).__init__(**kwargs)
        self.count = kwargs.get('count', 1)
        self.dns_prefix = kwargs.get('dns_prefix', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.os_disk_size_gb = kwargs.get('os_disk_size_gb', None)
        self.vnet_subnet_id = kwargs.get('vnet_subnet_id', None)
        self.first_consecutive_static_ip = kwargs.get('first_consecutive_static_ip', "10.240.255.5")
        self.storage_profile = kwargs.get('storage_profile', None)
        self.fqdn = None


class ContainerServiceNetworkProfile(Model):
    """Profile of network configuration.

    :param network_plugin: Network plugin used for building Kubernetes
     network. Possible values include: 'azure', 'kubenet'. Default value:
     "kubenet" .
    :type network_plugin: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.NetworkPlugin
    :param network_policy: Network policy used for building Kubernetes
     network. Possible values include: 'calico', 'azure'
    :type network_policy: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.NetworkPolicy
    :param network_mode: Network mode used for building Kubernetes network.
     Possible values include: 'transparent', 'bridge'
    :type network_mode: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.NetworkMode
    :param pod_cidr: A CIDR notation IP range from which to assign pod IPs
     when kubenet is used. Default value: "10.244.0.0/16" .
    :type pod_cidr: str
    :param service_cidr: A CIDR notation IP range from which to assign service
     cluster IPs. It must not overlap with any Subnet IP ranges. Default value:
     "10.0.0.0/16" .
    :type service_cidr: str
    :param dns_service_ip: An IP address assigned to the Kubernetes DNS
     service. It must be within the Kubernetes service address range specified
     in serviceCidr. Default value: "10.0.0.10" .
    :type dns_service_ip: str
    :param docker_bridge_cidr: A CIDR notation IP range assigned to the Docker
     bridge network. It must not overlap with any Subnet IP ranges or the
     Kubernetes service address range. Default value: "172.17.0.1/16" .
    :type docker_bridge_cidr: str
    :param outbound_type: The outbound (egress) routing method. Possible
     values include: 'loadBalancer', 'userDefinedRouting'. Default value:
     "loadBalancer" .
    :type outbound_type: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.OutboundType
    :param load_balancer_sku: The load balancer sku for the managed cluster.
     Possible values include: 'standard', 'basic'
    :type load_balancer_sku: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.LoadBalancerSku
    :param load_balancer_profile: Profile of the cluster load balancer.
    :type load_balancer_profile:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterLoadBalancerProfile
    """

    _validation = {
        'pod_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'service_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'dns_service_ip': {'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'},
        'docker_bridge_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
    }

    _attribute_map = {
        'network_plugin': {'key': 'networkPlugin', 'type': 'str'},
        'network_policy': {'key': 'networkPolicy', 'type': 'str'},
        'network_mode': {'key': 'networkMode', 'type': 'str'},
        'pod_cidr': {'key': 'podCidr', 'type': 'str'},
        'service_cidr': {'key': 'serviceCidr', 'type': 'str'},
        'dns_service_ip': {'key': 'dnsServiceIP', 'type': 'str'},
        'docker_bridge_cidr': {'key': 'dockerBridgeCidr', 'type': 'str'},
        'outbound_type': {'key': 'outboundType', 'type': 'str'},
        'load_balancer_sku': {'key': 'loadBalancerSku', 'type': 'str'},
        'load_balancer_profile': {'key': 'loadBalancerProfile', 'type': 'ManagedClusterLoadBalancerProfile'},
    }

    def __init__(self, **kwargs):
        super(ContainerServiceNetworkProfile, self).__init__(**kwargs)
        self.network_plugin = kwargs.get('network_plugin', "kubenet")
        self.network_policy = kwargs.get('network_policy', None)
        self.network_mode = kwargs.get('network_mode', None)
        self.pod_cidr = kwargs.get('pod_cidr', "10.244.0.0/16")
        self.service_cidr = kwargs.get('service_cidr', "10.0.0.0/16")
        self.dns_service_ip = kwargs.get('dns_service_ip', "10.0.0.10")
        self.docker_bridge_cidr = kwargs.get('docker_bridge_cidr', "172.17.0.1/16")
        self.outbound_type = kwargs.get('outbound_type', "loadBalancer")
        self.load_balancer_sku = kwargs.get('load_balancer_sku', None)
        self.load_balancer_profile = kwargs.get('load_balancer_profile', None)


class ContainerServiceSshConfiguration(Model):
    """SSH configuration for Linux-based VMs running on Azure.

    All required parameters must be populated in order to send to Azure.

    :param public_keys: Required. The list of SSH public keys used to
     authenticate with Linux-based VMs. Only expect one key specified.
    :type public_keys:
     list[~azure.mgmt.containerservice.v2020_03_01.models.ContainerServiceSshPublicKey]
    """

    _validation = {
        'public_keys': {'required': True},
    }

    _attribute_map = {
        'public_keys': {'key': 'publicKeys', 'type': '[ContainerServiceSshPublicKey]'},
    }

    def __init__(self, **kwargs):
        super(ContainerServiceSshConfiguration, self).__init__(**kwargs)
        self.public_keys = kwargs.get('public_keys', None)


class ContainerServiceSshPublicKey(Model):
    """Contains information about SSH certificate public key data.

    All required parameters must be populated in order to send to Azure.

    :param key_data: Required. Certificate public key used to authenticate
     with VMs through SSH. The certificate must be in PEM format with or
     without headers.
    :type key_data: str
    """

    _validation = {
        'key_data': {'required': True},
    }

    _attribute_map = {
        'key_data': {'key': 'keyData', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerServiceSshPublicKey, self).__init__(**kwargs)
        self.key_data = kwargs.get('key_data', None)


class ContainerServiceVMDiagnostics(Model):
    """Profile for diagnostics on the container service VMs.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the VM diagnostic agent is provisioned
     on the VM.
    :type enabled: bool
    :ivar storage_uri: The URI of the storage account where diagnostics are
     stored.
    :vartype storage_uri: str
    """

    _validation = {
        'enabled': {'required': True},
        'storage_uri': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerServiceVMDiagnostics, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.storage_uri = None


class CredentialResult(Model):
    """The credential result response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytearray
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'bytearray'},
    }

    def __init__(self, **kwargs):
        super(CredentialResult, self).__init__(**kwargs)
        self.name = None
        self.value = None


class CredentialResults(Model):
    """The list of credential result response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar kubeconfigs: Base64-encoded Kubernetes configuration file.
    :vartype kubeconfigs:
     list[~azure.mgmt.containerservice.v2020_03_01.models.CredentialResult]
    """

    _validation = {
        'kubeconfigs': {'readonly': True},
    }

    _attribute_map = {
        'kubeconfigs': {'key': 'kubeconfigs', 'type': '[CredentialResult]'},
    }

    def __init__(self, **kwargs):
        super(CredentialResults, self).__init__(**kwargs)
        self.kubeconfigs = None


class Resource(Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class ManagedCluster(Resource):
    """Managed cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar provisioning_state: The current deployment or provisioning state,
     which only appears in the response.
    :vartype provisioning_state: str
    :ivar max_agent_pools: The max number of agent pools for the managed
     cluster.
    :vartype max_agent_pools: int
    :param kubernetes_version: Version of Kubernetes specified when creating
     the managed cluster.
    :type kubernetes_version: str
    :param dns_prefix: DNS prefix specified when creating the managed cluster.
    :type dns_prefix: str
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    :ivar private_fqdn: FQDN of private cluster.
    :vartype private_fqdn: str
    :param agent_pool_profiles: Properties of the agent pool.
    :type agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterAgentPoolProfile]
    :param linux_profile: Profile for Linux VMs in the container service
     cluster.
    :type linux_profile:
     ~azure.mgmt.containerservice.v2020_03_01.models.ContainerServiceLinuxProfile
    :param windows_profile: Profile for Windows VMs in the container service
     cluster.
    :type windows_profile:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterWindowsProfile
    :param service_principal_profile: Information about a service principal
     identity for the cluster to use for manipulating Azure APIs.
    :type service_principal_profile:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterServicePrincipalProfile
    :param addon_profiles: Profile of managed cluster add-on.
    :type addon_profiles: dict[str,
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterAddonProfile]
    :param node_resource_group: Name of the resource group containing agent
     pool nodes.
    :type node_resource_group: str
    :param enable_rbac: Whether to enable Kubernetes Role-Based Access
     Control.
    :type enable_rbac: bool
    :param enable_pod_security_policy: (DEPRECATING) Whether to enable
     Kubernetes pod security policy (preview). This feature is set for removal
     on October 15th, 2020. Learn more at aka.ms/aks/azpodpolicy.
    :type enable_pod_security_policy: bool
    :param network_profile: Profile of network configuration.
    :type network_profile:
     ~azure.mgmt.containerservice.v2020_03_01.models.ContainerServiceNetworkProfile
    :param aad_profile: Profile of Azure Active Directory configuration.
    :type aad_profile:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterAADProfile
    :param auto_scaler_profile: Parameters to be applied to the
     cluster-autoscaler when enabled
    :type auto_scaler_profile:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterPropertiesAutoScalerProfile
    :param api_server_access_profile: Access profile for managed cluster API
     server.
    :type api_server_access_profile:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterAPIServerAccessProfile
    :param disk_encryption_set_id: ResourceId of the disk encryption set to
     use for enabling encryption at rest.
    :type disk_encryption_set_id: str
    :param identity_profile: Identities associated with the cluster.
    :type identity_profile: dict[str,
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterPropertiesIdentityProfileValue]
    :param identity: The identity of the managed cluster, if configured.
    :type identity:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterIdentity
    :param sku: The managed cluster SKU.
    :type sku:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterSKU
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'max_agent_pools': {'readonly': True},
        'fqdn': {'readonly': True},
        'private_fqdn': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'max_agent_pools': {'key': 'properties.maxAgentPools', 'type': 'int'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'dns_prefix': {'key': 'properties.dnsPrefix', 'type': 'str'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'private_fqdn': {'key': 'properties.privateFQDN', 'type': 'str'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ManagedClusterAgentPoolProfile]'},
        'linux_profile': {'key': 'properties.linuxProfile', 'type': 'ContainerServiceLinuxProfile'},
        'windows_profile': {'key': 'properties.windowsProfile', 'type': 'ManagedClusterWindowsProfile'},
        'service_principal_profile': {'key': 'properties.servicePrincipalProfile', 'type': 'ManagedClusterServicePrincipalProfile'},
        'addon_profiles': {'key': 'properties.addonProfiles', 'type': '{ManagedClusterAddonProfile}'},
        'node_resource_group': {'key': 'properties.nodeResourceGroup', 'type': 'str'},
        'enable_rbac': {'key': 'properties.enableRBAC', 'type': 'bool'},
        'enable_pod_security_policy': {'key': 'properties.enablePodSecurityPolicy', 'type': 'bool'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'ContainerServiceNetworkProfile'},
        'aad_profile': {'key': 'properties.aadProfile', 'type': 'ManagedClusterAADProfile'},
        'auto_scaler_profile': {'key': 'properties.autoScalerProfile', 'type': 'ManagedClusterPropertiesAutoScalerProfile'},
        'api_server_access_profile': {'key': 'properties.apiServerAccessProfile', 'type': 'ManagedClusterAPIServerAccessProfile'},
        'disk_encryption_set_id': {'key': 'properties.diskEncryptionSetID', 'type': 'str'},
        'identity_profile': {'key': 'properties.identityProfile', 'type': '{ManagedClusterPropertiesIdentityProfileValue}'},
        'identity': {'key': 'identity', 'type': 'ManagedClusterIdentity'},
        'sku': {'key': 'sku', 'type': 'ManagedClusterSKU'},
    }

    def __init__(self, **kwargs):
        super(ManagedCluster, self).__init__(**kwargs)
        self.provisioning_state = None
        self.max_agent_pools = None
        self.kubernetes_version = kwargs.get('kubernetes_version', None)
        self.dns_prefix = kwargs.get('dns_prefix', None)
        self.fqdn = None
        self.private_fqdn = None
        self.agent_pool_profiles = kwargs.get('agent_pool_profiles', None)
        self.linux_profile = kwargs.get('linux_profile', None)
        self.windows_profile = kwargs.get('windows_profile', None)
        self.service_principal_profile = kwargs.get('service_principal_profile', None)
        self.addon_profiles = kwargs.get('addon_profiles', None)
        self.node_resource_group = kwargs.get('node_resource_group', None)
        self.enable_rbac = kwargs.get('enable_rbac', None)
        self.enable_pod_security_policy = kwargs.get('enable_pod_security_policy', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.aad_profile = kwargs.get('aad_profile', None)
        self.auto_scaler_profile = kwargs.get('auto_scaler_profile', None)
        self.api_server_access_profile = kwargs.get('api_server_access_profile', None)
        self.disk_encryption_set_id = kwargs.get('disk_encryption_set_id', None)
        self.identity_profile = kwargs.get('identity_profile', None)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)


class ManagedClusterAADProfile(Model):
    """AADProfile specifies attributes for Azure Active Directory integration.

    :param managed: Whether to enable managed AAD.
    :type managed: bool
    :param admin_group_object_ids: AAD group object IDs that will have admin
     role of the cluster.
    :type admin_group_object_ids: list[str]
    :param client_app_id: The client AAD application ID.
    :type client_app_id: str
    :param server_app_id: The server AAD application ID.
    :type server_app_id: str
    :param server_app_secret: The server AAD application secret.
    :type server_app_secret: str
    :param tenant_id: The AAD tenant ID to use for authentication. If not
     specified, will use the tenant of the deployment subscription.
    :type tenant_id: str
    """

    _attribute_map = {
        'managed': {'key': 'managed', 'type': 'bool'},
        'admin_group_object_ids': {'key': 'adminGroupObjectIDs', 'type': '[str]'},
        'client_app_id': {'key': 'clientAppID', 'type': 'str'},
        'server_app_id': {'key': 'serverAppID', 'type': 'str'},
        'server_app_secret': {'key': 'serverAppSecret', 'type': 'str'},
        'tenant_id': {'key': 'tenantID', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterAADProfile, self).__init__(**kwargs)
        self.managed = kwargs.get('managed', None)
        self.admin_group_object_ids = kwargs.get('admin_group_object_ids', None)
        self.client_app_id = kwargs.get('client_app_id', None)
        self.server_app_id = kwargs.get('server_app_id', None)
        self.server_app_secret = kwargs.get('server_app_secret', None)
        self.tenant_id = kwargs.get('tenant_id', None)


class ManagedClusterAccessProfile(Resource):
    """Managed cluster Access Profile.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param kube_config: Base64-encoded Kubernetes configuration file.
    :type kube_config: bytearray
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kube_config': {'key': 'properties.kubeConfig', 'type': 'bytearray'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterAccessProfile, self).__init__(**kwargs)
        self.kube_config = kwargs.get('kube_config', None)


class ManagedClusterAddonProfile(Model):
    """A Kubernetes add-on profile for a managed cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the add-on is enabled or not.
    :type enabled: bool
    :param config: Key-value pairs for configuring an add-on.
    :type config: dict[str, str]
    :ivar identity: Information of user assigned identity used by this add-on.
    :vartype identity:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterAddonProfileIdentity
    """

    _validation = {
        'enabled': {'required': True},
        'identity': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'config': {'key': 'config', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedClusterAddonProfileIdentity'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterAddonProfile, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.config = kwargs.get('config', None)
        self.identity = None


class UserAssignedIdentity(Model):
    """UserAssignedIdentity.

    :param resource_id: The resource id of the user assigned identity.
    :type resource_id: str
    :param client_id: The client id of the user assigned identity.
    :type client_id: str
    :param object_id: The object id of the user assigned identity.
    :type object_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.client_id = kwargs.get('client_id', None)
        self.object_id = kwargs.get('object_id', None)


class ManagedClusterAddonProfileIdentity(UserAssignedIdentity):
    """Information of user assigned identity used by this add-on.

    :param resource_id: The resource id of the user assigned identity.
    :type resource_id: str
    :param client_id: The client id of the user assigned identity.
    :type client_id: str
    :param object_id: The object id of the user assigned identity.
    :type object_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterAddonProfileIdentity, self).__init__(**kwargs)


class ManagedClusterAgentPoolProfileProperties(Model):
    """Properties for the container service agent pool profile.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param count: Number of agents (VMs) to host docker containers. Allowed
     values must be in the range of 0 to 100 (inclusive) for user pools and in
     the range of 1 to 100 (inclusive) for system pools. The default value is
     1.
    :type count: int
    :param vm_size: Size of agent VMs. Possible values include: 'Standard_A1',
     'Standard_A10', 'Standard_A11', 'Standard_A1_v2', 'Standard_A2',
     'Standard_A2_v2', 'Standard_A2m_v2', 'Standard_A3', 'Standard_A4',
     'Standard_A4_v2', 'Standard_A4m_v2', 'Standard_A5', 'Standard_A6',
     'Standard_A7', 'Standard_A8', 'Standard_A8_v2', 'Standard_A8m_v2',
     'Standard_A9', 'Standard_B2ms', 'Standard_B2s', 'Standard_B4ms',
     'Standard_B8ms', 'Standard_D1', 'Standard_D11', 'Standard_D11_v2',
     'Standard_D11_v2_Promo', 'Standard_D12', 'Standard_D12_v2',
     'Standard_D12_v2_Promo', 'Standard_D13', 'Standard_D13_v2',
     'Standard_D13_v2_Promo', 'Standard_D14', 'Standard_D14_v2',
     'Standard_D14_v2_Promo', 'Standard_D15_v2', 'Standard_D16_v3',
     'Standard_D16s_v3', 'Standard_D1_v2', 'Standard_D2', 'Standard_D2_v2',
     'Standard_D2_v2_Promo', 'Standard_D2_v3', 'Standard_D2s_v3',
     'Standard_D3', 'Standard_D32_v3', 'Standard_D32s_v3', 'Standard_D3_v2',
     'Standard_D3_v2_Promo', 'Standard_D4', 'Standard_D4_v2',
     'Standard_D4_v2_Promo', 'Standard_D4_v3', 'Standard_D4s_v3',
     'Standard_D5_v2', 'Standard_D5_v2_Promo', 'Standard_D64_v3',
     'Standard_D64s_v3', 'Standard_D8_v3', 'Standard_D8s_v3', 'Standard_DS1',
     'Standard_DS11', 'Standard_DS11_v2', 'Standard_DS11_v2_Promo',
     'Standard_DS12', 'Standard_DS12_v2', 'Standard_DS12_v2_Promo',
     'Standard_DS13', 'Standard_DS13-2_v2', 'Standard_DS13-4_v2',
     'Standard_DS13_v2', 'Standard_DS13_v2_Promo', 'Standard_DS14',
     'Standard_DS14-4_v2', 'Standard_DS14-8_v2', 'Standard_DS14_v2',
     'Standard_DS14_v2_Promo', 'Standard_DS15_v2', 'Standard_DS1_v2',
     'Standard_DS2', 'Standard_DS2_v2', 'Standard_DS2_v2_Promo',
     'Standard_DS3', 'Standard_DS3_v2', 'Standard_DS3_v2_Promo',
     'Standard_DS4', 'Standard_DS4_v2', 'Standard_DS4_v2_Promo',
     'Standard_DS5_v2', 'Standard_DS5_v2_Promo', 'Standard_E16_v3',
     'Standard_E16s_v3', 'Standard_E2_v3', 'Standard_E2s_v3',
     'Standard_E32-16s_v3', 'Standard_E32-8s_v3', 'Standard_E32_v3',
     'Standard_E32s_v3', 'Standard_E4_v3', 'Standard_E4s_v3',
     'Standard_E64-16s_v3', 'Standard_E64-32s_v3', 'Standard_E64_v3',
     'Standard_E64s_v3', 'Standard_E8_v3', 'Standard_E8s_v3', 'Standard_F1',
     'Standard_F16', 'Standard_F16s', 'Standard_F16s_v2', 'Standard_F1s',
     'Standard_F2', 'Standard_F2s', 'Standard_F2s_v2', 'Standard_F32s_v2',
     'Standard_F4', 'Standard_F4s', 'Standard_F4s_v2', 'Standard_F64s_v2',
     'Standard_F72s_v2', 'Standard_F8', 'Standard_F8s', 'Standard_F8s_v2',
     'Standard_G1', 'Standard_G2', 'Standard_G3', 'Standard_G4', 'Standard_G5',
     'Standard_GS1', 'Standard_GS2', 'Standard_GS3', 'Standard_GS4',
     'Standard_GS4-4', 'Standard_GS4-8', 'Standard_GS5', 'Standard_GS5-16',
     'Standard_GS5-8', 'Standard_H16', 'Standard_H16m', 'Standard_H16mr',
     'Standard_H16r', 'Standard_H8', 'Standard_H8m', 'Standard_L16s',
     'Standard_L32s', 'Standard_L4s', 'Standard_L8s', 'Standard_M128-32ms',
     'Standard_M128-64ms', 'Standard_M128ms', 'Standard_M128s',
     'Standard_M64-16ms', 'Standard_M64-32ms', 'Standard_M64ms',
     'Standard_M64s', 'Standard_NC12', 'Standard_NC12s_v2',
     'Standard_NC12s_v3', 'Standard_NC24', 'Standard_NC24r',
     'Standard_NC24rs_v2', 'Standard_NC24rs_v3', 'Standard_NC24s_v2',
     'Standard_NC24s_v3', 'Standard_NC6', 'Standard_NC6s_v2',
     'Standard_NC6s_v3', 'Standard_ND12s', 'Standard_ND24rs', 'Standard_ND24s',
     'Standard_ND6s', 'Standard_NV12', 'Standard_NV24', 'Standard_NV6'
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk
     size for every machine in this master/agent pool. If you specify 0, it
     will apply the default osDisk size according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet
     identifier.
    :type vnet_subnet_id: str
    :param max_pods: Maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: OsType to be used to specify os type. Choose from Linux
     and Windows. Default to Linux. Possible values include: 'Linux',
     'Windows'. Default value: "Linux" .
    :type os_type: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.OSType
    :param max_count: Maximum number of nodes for auto-scaling
    :type max_count: int
    :param min_count: Minimum number of nodes for auto-scaling
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler
    :type enable_auto_scaling: bool
    :param type: AgentPoolType represents types of an agent pool. Possible
     values include: 'VirtualMachineScaleSets', 'AvailabilitySet'
    :type type: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.AgentPoolType
    :param mode: AgentPoolMode represents mode of an agent pool. Possible
     values include: 'System', 'User'
    :type mode: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.AgentPoolMode
    :param orchestrator_version: Version of orchestrator specified when
     creating the managed cluster.
    :type orchestrator_version: str
    :ivar provisioning_state: The current deployment or provisioning state,
     which only appears in the response.
    :vartype provisioning_state: str
    :param availability_zones: Availability zones for nodes. Must use
     VirtualMachineScaleSets AgentPoolType.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Enable public IP for nodes
    :type enable_node_public_ip: bool
    :param scale_set_priority: ScaleSetPriority to be used to specify virtual
     machine scale set priority. Default to regular. Possible values include:
     'Spot', 'Low', 'Regular'. Default value: "Regular" .
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to
     specify eviction policy for Spot or low priority virtual machine scale
     set. Default to Delete. Possible values include: 'Delete', 'Deallocate'.
     Default value: "Delete" .
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ScaleSetEvictionPolicy
    :param spot_max_price: SpotMaxPrice to be used to specify the maximum
     price you are willing to pay in US Dollars. Possible values are any
     decimal value greater than zero or -1 which indicates default price to be
     up-to on-demand.
    :type spot_max_price: float
    :param tags: Agent pool tags to be persisted on the agent pool virtual
     machine scale set.
    :type tags: dict[str, str]
    :param node_labels: Agent pool node labels to be persisted across all
     nodes in agent pool.
    :type node_labels: dict[str, str]
    :param node_taints: Taints added to new nodes during node pool create and
     scale. For example, key=value:NoSchedule.
    :type node_taints: list[str]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'max_pods': {'key': 'maxPods', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'min_count': {'key': 'minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'enableAutoScaling', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'availability_zones': {'key': 'availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'enableNodePublicIP', 'type': 'bool'},
        'scale_set_priority': {'key': 'scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'scaleSetEvictionPolicy', 'type': 'str'},
        'spot_max_price': {'key': 'spotMaxPrice', 'type': 'float'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'node_labels': {'key': 'nodeLabels', 'type': '{str}'},
        'node_taints': {'key': 'nodeTaints', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterAgentPoolProfileProperties, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.os_disk_size_gb = kwargs.get('os_disk_size_gb', None)
        self.vnet_subnet_id = kwargs.get('vnet_subnet_id', None)
        self.max_pods = kwargs.get('max_pods', None)
        self.os_type = kwargs.get('os_type', "Linux")
        self.max_count = kwargs.get('max_count', None)
        self.min_count = kwargs.get('min_count', None)
        self.enable_auto_scaling = kwargs.get('enable_auto_scaling', None)
        self.type = kwargs.get('type', None)
        self.mode = kwargs.get('mode', None)
        self.orchestrator_version = kwargs.get('orchestrator_version', None)
        self.provisioning_state = None
        self.availability_zones = kwargs.get('availability_zones', None)
        self.enable_node_public_ip = kwargs.get('enable_node_public_ip', None)
        self.scale_set_priority = kwargs.get('scale_set_priority', "Regular")
        self.scale_set_eviction_policy = kwargs.get('scale_set_eviction_policy', "Delete")
        self.spot_max_price = kwargs.get('spot_max_price', None)
        self.tags = kwargs.get('tags', None)
        self.node_labels = kwargs.get('node_labels', None)
        self.node_taints = kwargs.get('node_taints', None)


class ManagedClusterAgentPoolProfile(ManagedClusterAgentPoolProfileProperties):
    """Profile for the container service agent pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param count: Number of agents (VMs) to host docker containers. Allowed
     values must be in the range of 0 to 100 (inclusive) for user pools and in
     the range of 1 to 100 (inclusive) for system pools. The default value is
     1.
    :type count: int
    :param vm_size: Size of agent VMs. Possible values include: 'Standard_A1',
     'Standard_A10', 'Standard_A11', 'Standard_A1_v2', 'Standard_A2',
     'Standard_A2_v2', 'Standard_A2m_v2', 'Standard_A3', 'Standard_A4',
     'Standard_A4_v2', 'Standard_A4m_v2', 'Standard_A5', 'Standard_A6',
     'Standard_A7', 'Standard_A8', 'Standard_A8_v2', 'Standard_A8m_v2',
     'Standard_A9', 'Standard_B2ms', 'Standard_B2s', 'Standard_B4ms',
     'Standard_B8ms', 'Standard_D1', 'Standard_D11', 'Standard_D11_v2',
     'Standard_D11_v2_Promo', 'Standard_D12', 'Standard_D12_v2',
     'Standard_D12_v2_Promo', 'Standard_D13', 'Standard_D13_v2',
     'Standard_D13_v2_Promo', 'Standard_D14', 'Standard_D14_v2',
     'Standard_D14_v2_Promo', 'Standard_D15_v2', 'Standard_D16_v3',
     'Standard_D16s_v3', 'Standard_D1_v2', 'Standard_D2', 'Standard_D2_v2',
     'Standard_D2_v2_Promo', 'Standard_D2_v3', 'Standard_D2s_v3',
     'Standard_D3', 'Standard_D32_v3', 'Standard_D32s_v3', 'Standard_D3_v2',
     'Standard_D3_v2_Promo', 'Standard_D4', 'Standard_D4_v2',
     'Standard_D4_v2_Promo', 'Standard_D4_v3', 'Standard_D4s_v3',
     'Standard_D5_v2', 'Standard_D5_v2_Promo', 'Standard_D64_v3',
     'Standard_D64s_v3', 'Standard_D8_v3', 'Standard_D8s_v3', 'Standard_DS1',
     'Standard_DS11', 'Standard_DS11_v2', 'Standard_DS11_v2_Promo',
     'Standard_DS12', 'Standard_DS12_v2', 'Standard_DS12_v2_Promo',
     'Standard_DS13', 'Standard_DS13-2_v2', 'Standard_DS13-4_v2',
     'Standard_DS13_v2', 'Standard_DS13_v2_Promo', 'Standard_DS14',
     'Standard_DS14-4_v2', 'Standard_DS14-8_v2', 'Standard_DS14_v2',
     'Standard_DS14_v2_Promo', 'Standard_DS15_v2', 'Standard_DS1_v2',
     'Standard_DS2', 'Standard_DS2_v2', 'Standard_DS2_v2_Promo',
     'Standard_DS3', 'Standard_DS3_v2', 'Standard_DS3_v2_Promo',
     'Standard_DS4', 'Standard_DS4_v2', 'Standard_DS4_v2_Promo',
     'Standard_DS5_v2', 'Standard_DS5_v2_Promo', 'Standard_E16_v3',
     'Standard_E16s_v3', 'Standard_E2_v3', 'Standard_E2s_v3',
     'Standard_E32-16s_v3', 'Standard_E32-8s_v3', 'Standard_E32_v3',
     'Standard_E32s_v3', 'Standard_E4_v3', 'Standard_E4s_v3',
     'Standard_E64-16s_v3', 'Standard_E64-32s_v3', 'Standard_E64_v3',
     'Standard_E64s_v3', 'Standard_E8_v3', 'Standard_E8s_v3', 'Standard_F1',
     'Standard_F16', 'Standard_F16s', 'Standard_F16s_v2', 'Standard_F1s',
     'Standard_F2', 'Standard_F2s', 'Standard_F2s_v2', 'Standard_F32s_v2',
     'Standard_F4', 'Standard_F4s', 'Standard_F4s_v2', 'Standard_F64s_v2',
     'Standard_F72s_v2', 'Standard_F8', 'Standard_F8s', 'Standard_F8s_v2',
     'Standard_G1', 'Standard_G2', 'Standard_G3', 'Standard_G4', 'Standard_G5',
     'Standard_GS1', 'Standard_GS2', 'Standard_GS3', 'Standard_GS4',
     'Standard_GS4-4', 'Standard_GS4-8', 'Standard_GS5', 'Standard_GS5-16',
     'Standard_GS5-8', 'Standard_H16', 'Standard_H16m', 'Standard_H16mr',
     'Standard_H16r', 'Standard_H8', 'Standard_H8m', 'Standard_L16s',
     'Standard_L32s', 'Standard_L4s', 'Standard_L8s', 'Standard_M128-32ms',
     'Standard_M128-64ms', 'Standard_M128ms', 'Standard_M128s',
     'Standard_M64-16ms', 'Standard_M64-32ms', 'Standard_M64ms',
     'Standard_M64s', 'Standard_NC12', 'Standard_NC12s_v2',
     'Standard_NC12s_v3', 'Standard_NC24', 'Standard_NC24r',
     'Standard_NC24rs_v2', 'Standard_NC24rs_v3', 'Standard_NC24s_v2',
     'Standard_NC24s_v3', 'Standard_NC6', 'Standard_NC6s_v2',
     'Standard_NC6s_v3', 'Standard_ND12s', 'Standard_ND24rs', 'Standard_ND24s',
     'Standard_ND6s', 'Standard_NV12', 'Standard_NV24', 'Standard_NV6'
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk
     size for every machine in this master/agent pool. If you specify 0, it
     will apply the default osDisk size according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet
     identifier.
    :type vnet_subnet_id: str
    :param max_pods: Maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: OsType to be used to specify os type. Choose from Linux
     and Windows. Default to Linux. Possible values include: 'Linux',
     'Windows'. Default value: "Linux" .
    :type os_type: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.OSType
    :param max_count: Maximum number of nodes for auto-scaling
    :type max_count: int
    :param min_count: Minimum number of nodes for auto-scaling
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler
    :type enable_auto_scaling: bool
    :param type: AgentPoolType represents types of an agent pool. Possible
     values include: 'VirtualMachineScaleSets', 'AvailabilitySet'
    :type type: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.AgentPoolType
    :param mode: AgentPoolMode represents mode of an agent pool. Possible
     values include: 'System', 'User'
    :type mode: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.AgentPoolMode
    :param orchestrator_version: Version of orchestrator specified when
     creating the managed cluster.
    :type orchestrator_version: str
    :ivar provisioning_state: The current deployment or provisioning state,
     which only appears in the response.
    :vartype provisioning_state: str
    :param availability_zones: Availability zones for nodes. Must use
     VirtualMachineScaleSets AgentPoolType.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Enable public IP for nodes
    :type enable_node_public_ip: bool
    :param scale_set_priority: ScaleSetPriority to be used to specify virtual
     machine scale set priority. Default to regular. Possible values include:
     'Spot', 'Low', 'Regular'. Default value: "Regular" .
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to
     specify eviction policy for Spot or low priority virtual machine scale
     set. Default to Delete. Possible values include: 'Delete', 'Deallocate'.
     Default value: "Delete" .
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ScaleSetEvictionPolicy
    :param spot_max_price: SpotMaxPrice to be used to specify the maximum
     price you are willing to pay in US Dollars. Possible values are any
     decimal value greater than zero or -1 which indicates default price to be
     up-to on-demand.
    :type spot_max_price: float
    :param tags: Agent pool tags to be persisted on the agent pool virtual
     machine scale set.
    :type tags: dict[str, str]
    :param node_labels: Agent pool node labels to be persisted across all
     nodes in agent pool.
    :type node_labels: dict[str, str]
    :param node_taints: Taints added to new nodes during node pool create and
     scale. For example, key=value:NoSchedule.
    :type node_taints: list[str]
    :param name: Required. Unique name of the agent pool profile in the
     context of the subscription and resource group.
    :type name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'name': {'required': True, 'pattern': r'^[a-z][a-z0-9]{0,11}$'},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'max_pods': {'key': 'maxPods', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'min_count': {'key': 'minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'enableAutoScaling', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'availability_zones': {'key': 'availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'enableNodePublicIP', 'type': 'bool'},
        'scale_set_priority': {'key': 'scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'scaleSetEvictionPolicy', 'type': 'str'},
        'spot_max_price': {'key': 'spotMaxPrice', 'type': 'float'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'node_labels': {'key': 'nodeLabels', 'type': '{str}'},
        'node_taints': {'key': 'nodeTaints', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterAgentPoolProfile, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class ManagedClusterAPIServerAccessProfile(Model):
    """Access profile for managed cluster API server.

    :param authorized_ip_ranges: Authorized IP Ranges to kubernetes API
     server.
    :type authorized_ip_ranges: list[str]
    :param enable_private_cluster: Whether to create the cluster as a private
     cluster or not.
    :type enable_private_cluster: bool
    """

    _attribute_map = {
        'authorized_ip_ranges': {'key': 'authorizedIPRanges', 'type': '[str]'},
        'enable_private_cluster': {'key': 'enablePrivateCluster', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterAPIServerAccessProfile, self).__init__(**kwargs)
        self.authorized_ip_ranges = kwargs.get('authorized_ip_ranges', None)
        self.enable_private_cluster = kwargs.get('enable_private_cluster', None)


class ManagedClusterIdentity(Model):
    """Identity for the managed cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal id of the system assigned identity which
     is used by master components.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity which is
     used by master components.
    :vartype tenant_id: str
    :param type: The type of identity used for the managed cluster. Type
     'SystemAssigned' will use an implicitly created identity in master
     components and an auto-created user assigned identity in MC_ resource
     group in agent nodes. Type 'None' will not use MSI for the managed
     cluster, service principal will be used instead. Possible values include:
     'SystemAssigned', 'None'
    :type type: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ResourceIdentityType'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)


class ManagedClusterLoadBalancerProfile(Model):
    """Profile of the managed cluster load balancer.

    :param managed_outbound_ips: Desired managed outbound IPs for the cluster
     load balancer.
    :type managed_outbound_ips:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterLoadBalancerProfileManagedOutboundIPs
    :param outbound_ip_prefixes: Desired outbound IP Prefix resources for the
     cluster load balancer.
    :type outbound_ip_prefixes:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes
    :param outbound_ips: Desired outbound IP resources for the cluster load
     balancer.
    :type outbound_ips:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterLoadBalancerProfileOutboundIPs
    :param effective_outbound_ips: The effective outbound IP resources of the
     cluster load balancer.
    :type effective_outbound_ips:
     list[~azure.mgmt.containerservice.v2020_03_01.models.ResourceReference]
    :param allocated_outbound_ports: Desired number of allocated SNAT ports
     per VM. Allowed values must be in the range of 0 to 64000 (inclusive). The
     default value is 0 which results in Azure dynamically allocating ports.
     Default value: 0 .
    :type allocated_outbound_ports: int
    :param idle_timeout_in_minutes: Desired outbound flow idle timeout in
     minutes. Allowed values must be in the range of 4 to 120 (inclusive). The
     default value is 30 minutes. Default value: 30 .
    :type idle_timeout_in_minutes: int
    """

    _validation = {
        'allocated_outbound_ports': {'maximum': 64000, 'minimum': 0},
        'idle_timeout_in_minutes': {'maximum': 120, 'minimum': 4},
    }

    _attribute_map = {
        'managed_outbound_ips': {'key': 'managedOutboundIPs', 'type': 'ManagedClusterLoadBalancerProfileManagedOutboundIPs'},
        'outbound_ip_prefixes': {'key': 'outboundIPPrefixes', 'type': 'ManagedClusterLoadBalancerProfileOutboundIPPrefixes'},
        'outbound_ips': {'key': 'outboundIPs', 'type': 'ManagedClusterLoadBalancerProfileOutboundIPs'},
        'effective_outbound_ips': {'key': 'effectiveOutboundIPs', 'type': '[ResourceReference]'},
        'allocated_outbound_ports': {'key': 'allocatedOutboundPorts', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'idleTimeoutInMinutes', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterLoadBalancerProfile, self).__init__(**kwargs)
        self.managed_outbound_ips = kwargs.get('managed_outbound_ips', None)
        self.outbound_ip_prefixes = kwargs.get('outbound_ip_prefixes', None)
        self.outbound_ips = kwargs.get('outbound_ips', None)
        self.effective_outbound_ips = kwargs.get('effective_outbound_ips', None)
        self.allocated_outbound_ports = kwargs.get('allocated_outbound_ports', 0)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', 30)


class ManagedClusterLoadBalancerProfileManagedOutboundIPs(Model):
    """Desired managed outbound IPs for the cluster load balancer.

    :param count: Desired number of outbound IP created/managed by Azure for
     the cluster load balancer. Allowed values must be in the range of 1 to 100
     (inclusive). The default value is 1. . Default value: 1 .
    :type count: int
    """

    _validation = {
        'count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterLoadBalancerProfileManagedOutboundIPs, self).__init__(**kwargs)
        self.count = kwargs.get('count', 1)


class ManagedClusterLoadBalancerProfileOutboundIPPrefixes(Model):
    """Desired outbound IP Prefix resources for the cluster load balancer.

    :param public_ip_prefixes: A list of public IP prefix resources.
    :type public_ip_prefixes:
     list[~azure.mgmt.containerservice.v2020_03_01.models.ResourceReference]
    """

    _attribute_map = {
        'public_ip_prefixes': {'key': 'publicIPPrefixes', 'type': '[ResourceReference]'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterLoadBalancerProfileOutboundIPPrefixes, self).__init__(**kwargs)
        self.public_ip_prefixes = kwargs.get('public_ip_prefixes', None)


class ManagedClusterLoadBalancerProfileOutboundIPs(Model):
    """Desired outbound IP resources for the cluster load balancer.

    :param public_ips: A list of public IP resources.
    :type public_ips:
     list[~azure.mgmt.containerservice.v2020_03_01.models.ResourceReference]
    """

    _attribute_map = {
        'public_ips': {'key': 'publicIPs', 'type': '[ResourceReference]'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterLoadBalancerProfileOutboundIPs, self).__init__(**kwargs)
        self.public_ips = kwargs.get('public_ips', None)


class ManagedClusterPoolUpgradeProfile(Model):
    """The list of available upgrade versions.

    All required parameters must be populated in order to send to Azure.

    :param kubernetes_version: Required. Kubernetes version (major, minor,
     patch).
    :type kubernetes_version: str
    :param name: Pool name.
    :type name: str
    :param os_type: Required. OsType to be used to specify os type. Choose
     from Linux and Windows. Default to Linux. Possible values include:
     'Linux', 'Windows'. Default value: "Linux" .
    :type os_type: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.OSType
    :param upgrades: List of orchestrator types and versions available for
     upgrade.
    :type upgrades:
     list[~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterPoolUpgradeProfileUpgradesItem]
    """

    _validation = {
        'kubernetes_version': {'required': True},
        'os_type': {'required': True},
    }

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'upgrades': {'key': 'upgrades', 'type': '[ManagedClusterPoolUpgradeProfileUpgradesItem]'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterPoolUpgradeProfile, self).__init__(**kwargs)
        self.kubernetes_version = kwargs.get('kubernetes_version', None)
        self.name = kwargs.get('name', None)
        self.os_type = kwargs.get('os_type', "Linux")
        self.upgrades = kwargs.get('upgrades', None)


class ManagedClusterPoolUpgradeProfileUpgradesItem(Model):
    """ManagedClusterPoolUpgradeProfileUpgradesItem.

    :param kubernetes_version: Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterPoolUpgradeProfileUpgradesItem, self).__init__(**kwargs)
        self.kubernetes_version = kwargs.get('kubernetes_version', None)
        self.is_preview = kwargs.get('is_preview', None)


class ManagedClusterPropertiesAutoScalerProfile(Model):
    """Parameters to be applied to the cluster-autoscaler when enabled.

    :param balance_similar_node_groups:
    :type balance_similar_node_groups: str
    :param scan_interval:
    :type scan_interval: str
    :param scale_down_delay_after_add:
    :type scale_down_delay_after_add: str
    :param scale_down_delay_after_delete:
    :type scale_down_delay_after_delete: str
    :param scale_down_delay_after_failure:
    :type scale_down_delay_after_failure: str
    :param scale_down_unneeded_time:
    :type scale_down_unneeded_time: str
    :param scale_down_unready_time:
    :type scale_down_unready_time: str
    :param scale_down_utilization_threshold:
    :type scale_down_utilization_threshold: str
    :param max_graceful_termination_sec:
    :type max_graceful_termination_sec: str
    """

    _attribute_map = {
        'balance_similar_node_groups': {'key': 'balance-similar-node-groups', 'type': 'str'},
        'scan_interval': {'key': 'scan-interval', 'type': 'str'},
        'scale_down_delay_after_add': {'key': 'scale-down-delay-after-add', 'type': 'str'},
        'scale_down_delay_after_delete': {'key': 'scale-down-delay-after-delete', 'type': 'str'},
        'scale_down_delay_after_failure': {'key': 'scale-down-delay-after-failure', 'type': 'str'},
        'scale_down_unneeded_time': {'key': 'scale-down-unneeded-time', 'type': 'str'},
        'scale_down_unready_time': {'key': 'scale-down-unready-time', 'type': 'str'},
        'scale_down_utilization_threshold': {'key': 'scale-down-utilization-threshold', 'type': 'str'},
        'max_graceful_termination_sec': {'key': 'max-graceful-termination-sec', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterPropertiesAutoScalerProfile, self).__init__(**kwargs)
        self.balance_similar_node_groups = kwargs.get('balance_similar_node_groups', None)
        self.scan_interval = kwargs.get('scan_interval', None)
        self.scale_down_delay_after_add = kwargs.get('scale_down_delay_after_add', None)
        self.scale_down_delay_after_delete = kwargs.get('scale_down_delay_after_delete', None)
        self.scale_down_delay_after_failure = kwargs.get('scale_down_delay_after_failure', None)
        self.scale_down_unneeded_time = kwargs.get('scale_down_unneeded_time', None)
        self.scale_down_unready_time = kwargs.get('scale_down_unready_time', None)
        self.scale_down_utilization_threshold = kwargs.get('scale_down_utilization_threshold', None)
        self.max_graceful_termination_sec = kwargs.get('max_graceful_termination_sec', None)


class ManagedClusterPropertiesIdentityProfileValue(UserAssignedIdentity):
    """ManagedClusterPropertiesIdentityProfileValue.

    :param resource_id: The resource id of the user assigned identity.
    :type resource_id: str
    :param client_id: The client id of the user assigned identity.
    :type client_id: str
    :param object_id: The object id of the user assigned identity.
    :type object_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterPropertiesIdentityProfileValue, self).__init__(**kwargs)


class ManagedClusterServicePrincipalProfile(Model):
    """Information about a service principal identity for the cluster to use for
    manipulating Azure APIs.

    All required parameters must be populated in order to send to Azure.

    :param client_id: Required. The ID for the service principal.
    :type client_id: str
    :param secret: The secret password associated with the service principal
     in plain text.
    :type secret: str
    """

    _validation = {
        'client_id': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterServicePrincipalProfile, self).__init__(**kwargs)
        self.client_id = kwargs.get('client_id', None)
        self.secret = kwargs.get('secret', None)


class ManagedClusterSKU(Model):
    """ManagedClusterSKU.

    :param name: Name of a managed cluster SKU. Possible values include:
     'Basic'
    :type name: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterSKUName
    :param tier: Tier of a managed cluster SKU. Possible values include:
     'Paid', 'Free'
    :type tier: str or
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterSKUTier
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterSKU, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)


class ManagedClusterUpgradeProfile(Model):
    """The list of available upgrades for compute pools.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Id of upgrade profile.
    :vartype id: str
    :ivar name: Name of upgrade profile.
    :vartype name: str
    :ivar type: Type of upgrade profile.
    :vartype type: str
    :param control_plane_profile: Required. The list of available upgrade
     versions for the control plane.
    :type control_plane_profile:
     ~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterPoolUpgradeProfile
    :param agent_pool_profiles: Required. The list of available upgrade
     versions for agent pools.
    :type agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2020_03_01.models.ManagedClusterPoolUpgradeProfile]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'control_plane_profile': {'required': True},
        'agent_pool_profiles': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'control_plane_profile': {'key': 'properties.controlPlaneProfile', 'type': 'ManagedClusterPoolUpgradeProfile'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ManagedClusterPoolUpgradeProfile]'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterUpgradeProfile, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.control_plane_profile = kwargs.get('control_plane_profile', None)
        self.agent_pool_profiles = kwargs.get('agent_pool_profiles', None)


class ManagedClusterWindowsProfile(Model):
    """Profile for Windows VMs in the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param admin_username: Required. The administrator username to use for
     Windows VMs.
    :type admin_username: str
    :param admin_password: The administrator password to use for Windows VMs.
    :type admin_password: str
    """

    _validation = {
        'admin_username': {'required': True, 'pattern': r'^[a-zA-Z0-9]+([._]?[a-zA-Z0-9]+)*$'},
        'admin_password': {'pattern': r'^(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#$%\^&\*\(\)])[a-zA-Z\d!@#$%\^&\*\(\)]{12,123}$'},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterWindowsProfile, self).__init__(**kwargs)
        self.admin_username = kwargs.get('admin_username', None)
        self.admin_password = kwargs.get('admin_password', None)


class OperationValue(Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        'origin': {'readonly': True},
        'name': {'readonly': True},
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'operation': {'key': 'display.operation', 'type': 'str'},
        'resource': {'key': 'display.resource', 'type': 'str'},
        'description': {'key': 'display.description', 'type': 'str'},
        'provider': {'key': 'display.provider', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationValue, self).__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class ResourceReference(Model):
    """A reference to an Azure resource.

    :param id: The fully qualified Azure resource id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceReference, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class TagsObject(Model):
    """Tags object for patch operations.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TagsObject, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
