from typing import Any, Callable, Dict, List, MutableMapping, Optional, Tuple

from rest_framework.request import Request
from rest_framework.views import APIView
from django.core.cache.backends.base import BaseCache

class BaseThrottle:
    def allow_request(self, request: Request, view: APIView) -> bool: ...
    def get_ident(self, request: Request) -> str: ...
    def wait(self) -> Optional[float]: ...

class SimpleRateThrottle(BaseThrottle):
    cache: BaseCache = ...
    cache_format: str = ...
    history: List[Any]
    key: Optional[str] = ...
    now: float
    rate: Optional[str]
    scope: Optional[str] = ...
    THROTTLE_RATES: Dict[str, Optional[str]] = ...
    timer: Callable[..., float] = ...
    def __init__(self) -> None: ...
    def get_cache_key(self, request: Request, view: APIView) -> Optional[str]: ...
    def get_rate(self) -> Optional[str]: ...
    def parse_rate(self, rate) -> Tuple[Optional[int], Optional[int]]: ...
    def throttle_failure(self) -> bool: ...
    def throttle_success(self) -> bool: ...

class AnonRateThrottle(SimpleRateThrottle): ...
class UserRateThrottle(SimpleRateThrottle): ...

class ScopedRateThrottle(SimpleRateThrottle):
    scope_attr: str = ...
