"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dynamodb_1 = require("aws-sdk/clients/dynamodb");
if (!process.env.TABLE_NAME) {
    throw new Error('TABLE_NAME is not set');
}
const db = new dynamodb_1.DocumentClient();
const get = async (key) => {
    const item = (await db
        .get({
        TableName: process.env.TABLE_NAME,
        Key: {
            Key: key,
        },
    })
        .promise()).Item;
    if (!item) {
        return undefined;
    }
    return {
        Key: item.Key,
        Active: item.Active,
        Name: item.Name,
    };
};
const response = (statusCode, body) => {
    return {
        statusCode,
        body: body ? JSON.stringify(body) : ""
    };
};
exports.handler = async (event) => {
    if (event.pathParameters && event.pathParameters.key) {
        const feature = get(event.pathParameters.key);
        if (feature) {
            if (event.httpMethod === "GET") {
                return response(200, feature);
            }
        }
    }
    return response(400);
};
//# sourceMappingURL=data:application/json;base64,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