from tesseract_olap.common import BaseError


class SetupError(BaseError):
    """Base class for exceptions in this module."""
    pass


class UnknownBackendError(SetupError):
    """This error occurs when the user attempts to initialize the Server with
    a connection string that doesn't match any known compatible Backend.

    The user must be informed to ensure they're using a compatible database.
    """

    def __init__(self, connection_str: str) -> None:
        message = (
            "Couldn't find a matching Backend for connection string: {}"
        ).format(connection_str)
        super().__init__(message)


class UnknownSchemaError(SetupError):
    """This error occurs when the user attempts to point the location of the
    Schema to a file in an unknown format.

    The user must be informed that by default, only XML and JSON files are
    allowed.
    """

    def __init__(self, kind: str) -> None:
        message = "Couldn't interpret a Schema with format: {}".format(kind)
        super().__init__(message)
