# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class ListAnalyticsDataRequestCondition(TeaModel):
    def __init__(
        self,
        field_name: str = None,
        operate: str = None,
        value: str = None,
        between_start: str = None,
        between_end: str = None,
    ):
        self.field_name = field_name
        self.operate = operate
        self.value = value
        self.between_start = between_start
        self.between_end = between_end

    def validate(self):
        self.validate_required(self.field_name, 'field_name')
        self.validate_required(self.operate, 'operate')

    def to_map(self):
        result = dict()
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.operate is not None:
            result['Operate'] = self.operate
        if self.value is not None:
            result['Value'] = self.value
        if self.between_start is not None:
            result['BetweenStart'] = self.between_start
        if self.between_end is not None:
            result['BetweenEnd'] = self.between_end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('Operate') is not None:
            self.operate = m.get('Operate')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('BetweenStart') is not None:
            self.between_start = m.get('BetweenStart')
        if m.get('BetweenEnd') is not None:
            self.between_end = m.get('BetweenEnd')
        return self


class ListAnalyticsDataRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        iso_id: str = None,
        api_path: str = None,
        page_size: int = None,
        condition: List[ListAnalyticsDataRequestCondition] = None,
        page_num: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.iso_id = iso_id
        self.api_path = api_path
        self.page_size = page_size
        self.condition = condition
        self.page_num = page_num

    def validate(self):
        self.validate_required(self.iot_instance_id, 'iot_instance_id')
        self.validate_required(self.api_path, 'api_path')
        if self.condition:
            for k in self.condition:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iso_id is not None:
            result['IsoId'] = self.iso_id
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Condition'] = []
        if self.condition is not None:
            for k in self.condition:
                result['Condition'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IsoId') is not None:
            self.iso_id = m.get('IsoId')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.condition = []
        if m.get('Condition') is not None:
            for k in m.get('Condition'):
                temp_model = ListAnalyticsDataRequestCondition()
                self.condition.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        return self


class ListAnalyticsDataResponseData(TeaModel):
    def __init__(
        self,
        has_next: bool = None,
        result_json: str = None,
        count: int = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.has_next = has_next
        self.result_json = result_json
        self.count = count
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.has_next, 'has_next')
        self.validate_required(self.result_json, 'result_json')
        self.validate_required(self.count, 'count')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.has_next is not None:
            result['HasNext'] = self.has_next
        if self.result_json is not None:
            result['ResultJson'] = self.result_json
        if self.count is not None:
            result['Count'] = self.count
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HasNext') is not None:
            self.has_next = m.get('HasNext')
        if m.get('ResultJson') is not None:
            self.result_json = m.get('ResultJson')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListAnalyticsDataResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: ListAnalyticsDataResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListAnalyticsDataResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchBindDevicesIntoProjectRequestDevices(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchBindDevicesIntoProjectRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        devices: List[BatchBindDevicesIntoProjectRequestDevices] = None,
        project_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.devices = devices
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.devices, 'devices')
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = BatchBindDevicesIntoProjectRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchBindDevicesIntoProjectResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchBindProductsIntoProjectRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_keys: List[str] = None,
        project_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_keys = product_keys
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.product_keys, 'product_keys')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_keys is not None:
            result['ProductKeys'] = self.product_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKeys') is not None:
            self.product_keys = m.get('ProductKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchBindProductsIntoProjectResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchUnbindProjectDevicesRequestDevices(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchUnbindProjectDevicesRequest(TeaModel):
    def __init__(
        self,
        devices: List[BatchUnbindProjectDevicesRequestDevices] = None,
        iot_instance_id: str = None,
        project_id: str = None,
    ):
        self.devices = devices
        self.iot_instance_id = iot_instance_id
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.devices, 'devices')
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = BatchUnbindProjectDevicesRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchUnbindProjectDevicesResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchUnbindProjectProductsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_keys: List[str] = None,
        project_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_keys = product_keys
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.product_keys, 'product_keys')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_keys is not None:
            result['ProductKeys'] = self.product_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKeys') is not None:
            self.product_keys = m.get('ProductKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchUnbindProjectProductsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class SyncSpeechByCombinationRequest(TeaModel):
    def __init__(
        self,
        combination_list: List[str] = None,
        iot_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_instance_id: str = None,
    ):
        self.combination_list = combination_list
        self.iot_id = iot_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_instance_id = iot_instance_id

    def validate(self):
        self.validate_required(self.combination_list, 'combination_list')

    def to_map(self):
        result = dict()
        if self.combination_list is not None:
            result['CombinationList'] = self.combination_list
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CombinationList') is not None:
            self.combination_list = m.get('CombinationList')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class SyncSpeechByCombinationResponseData(TeaModel):
    def __init__(
        self,
        id: str = None,
        retry_count: int = None,
    ):
        self.id = id
        self.retry_count = retry_count

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.retry_count, 'retry_count')

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        return self


class SyncSpeechByCombinationResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: SyncSpeechByCombinationResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = SyncSpeechByCombinationResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class OpenIotServiceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
    ):
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class OpenIotServiceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        order_id: str = None,
    ):
        self.request_id = request_id
        self.order_id = order_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CreateRulengDistributeJobRequest(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        source_instance_id: str = None,
        target_instance_id: str = None,
    ):
        self.product_key = product_key
        self.source_instance_id = source_instance_id
        self.target_instance_id = target_instance_id

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class CreateRulengDistributeJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ListTaskByPageRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: str = None,
        page_no: str = None,
        job_id: str = None,
        device: Dict[str, Any] = None,
        status: str = None,
        device_name: str = None,
        job_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.page_no = page_no
        self.job_id = job_id
        self.device = device
        self.status = status
        self.device_name = device_name
        self.job_name = job_name

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_no, 'page_no')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.device is not None:
            result['Device'] = self.device
        if self.status is not None:
            result['Status'] = self.status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.job_name is not None:
            result['JobName'] = self.job_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        return self


class ListTaskByPageShrinkRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: str = None,
        page_no: str = None,
        job_id: str = None,
        device_shrink: str = None,
        status: str = None,
        device_name: str = None,
        job_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.page_no = page_no
        self.job_id = job_id
        self.device_shrink = device_shrink
        self.status = status
        self.device_name = device_name
        self.job_name = job_name

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_no, 'page_no')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.device_shrink is not None:
            result['Device'] = self.device_shrink
        if self.status is not None:
            result['Status'] = self.status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.job_name is not None:
            result['JobName'] = self.job_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Device') is not None:
            self.device_shrink = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        return self


class ListTaskByPageResponseDataData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        job_name: str = None,
        task_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        progress: int = None,
        utc_queue_time: str = None,
        utc_modified: str = None,
        status_detail: str = None,
        status: str = None,
        product_name: str = None,
    ):
        self.job_id = job_id
        self.job_name = job_name
        self.task_id = task_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.progress = progress
        self.utc_queue_time = utc_queue_time
        self.utc_modified = utc_modified
        self.status_detail = status_detail
        self.status = status
        self.product_name = product_name

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.utc_queue_time, 'utc_queue_time')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.status_detail, 'status_detail')
        self.validate_required(self.status, 'status')
        self.validate_required(self.product_name, 'product_name')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status_detail is not None:
            result['StatusDetail'] = self.status_detail
        if self.status is not None:
            result['Status'] = self.status
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('StatusDetail') is not None:
            self.status_detail = m.get('StatusDetail')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        return self


class ListTaskByPageResponseData(TeaModel):
    def __init__(
        self,
        data: List[ListTaskByPageResponseDataData] = None,
    ):
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListTaskByPageResponseDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTaskByPageResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        page: int = None,
        data: ListTaskByPageResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.page = page
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.page, 'page')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = ListTaskByPageResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListTaskRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        limit: int = None,
        job_id: str = None,
        next_token: str = None,
        device: Dict[str, Any] = None,
        status: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.limit = limit
        self.job_id = job_id
        self.next_token = next_token
        self.device = device
        self.status = status

    def validate(self):
        self.validate_required(self.limit, 'limit')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.device is not None:
            result['Device'] = self.device
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        limit: int = None,
        job_id: str = None,
        next_token: str = None,
        device_shrink: str = None,
        status: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.limit = limit
        self.job_id = job_id
        self.next_token = next_token
        self.device_shrink = device_shrink
        self.status = status

    def validate(self):
        self.validate_required(self.limit, 'limit')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.device_shrink is not None:
            result['Device'] = self.device_shrink
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Device') is not None:
            self.device_shrink = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskResponseDataData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        job_name: str = None,
        task_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        progress: str = None,
        utc_queue_time: str = None,
        utc_modified: str = None,
        status: str = None,
    ):
        self.job_id = job_id
        self.job_name = job_name
        self.task_id = task_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.progress = progress
        self.utc_queue_time = utc_queue_time
        self.utc_modified = utc_modified
        self.status = status

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.utc_queue_time, 'utc_queue_time')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskResponseData(TeaModel):
    def __init__(
        self,
        data: List[ListTaskResponseDataData] = None,
    ):
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListTaskResponseDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTaskResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        next_token: str = None,
        data: ListTaskResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.next_token = next_token
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Data') is not None:
            temp_model = ListTaskResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryJobStatisticsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryJobStatisticsResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        queued: int = None,
        sent: int = None,
        in_progress: int = None,
        succeeded: int = None,
        failed: int = None,
        rejected: int = None,
        time_out: int = None,
        cancelled: int = None,
    ):
        self.total = total
        self.queued = queued
        self.sent = sent
        self.in_progress = in_progress
        self.succeeded = succeeded
        self.failed = failed
        self.rejected = rejected
        self.time_out = time_out
        self.cancelled = cancelled

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.queued, 'queued')
        self.validate_required(self.sent, 'sent')
        self.validate_required(self.in_progress, 'in_progress')
        self.validate_required(self.succeeded, 'succeeded')
        self.validate_required(self.failed, 'failed')
        self.validate_required(self.rejected, 'rejected')
        self.validate_required(self.time_out, 'time_out')
        self.validate_required(self.cancelled, 'cancelled')

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.queued is not None:
            result['Queued'] = self.queued
        if self.sent is not None:
            result['Sent'] = self.sent
        if self.in_progress is not None:
            result['InProgress'] = self.in_progress
        if self.succeeded is not None:
            result['Succeeded'] = self.succeeded
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.rejected is not None:
            result['Rejected'] = self.rejected
        if self.time_out is not None:
            result['TimeOut'] = self.time_out
        if self.cancelled is not None:
            result['Cancelled'] = self.cancelled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Queued') is not None:
            self.queued = m.get('Queued')
        if m.get('Sent') is not None:
            self.sent = m.get('Sent')
        if m.get('InProgress') is not None:
            self.in_progress = m.get('InProgress')
        if m.get('Succeeded') is not None:
            self.succeeded = m.get('Succeeded')
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Rejected') is not None:
            self.rejected = m.get('Rejected')
        if m.get('TimeOut') is not None:
            self.time_out = m.get('TimeOut')
        if m.get('Cancelled') is not None:
            self.cancelled = m.get('Cancelled')
        return self


class QueryJobStatisticsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryJobStatisticsResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryJobStatisticsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CancelJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ListJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        status: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.status = status
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListJobResponseDataData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        job_name: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        status: str = None,
        description: str = None,
        type: str = None,
    ):
        self.job_id = job_id
        self.job_name = job_name
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.status = status
        self.description = description
        self.type = type

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.status, 'status')
        self.validate_required(self.description, 'description')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListJobResponseData(TeaModel):
    def __init__(
        self,
        data: List[ListJobResponseDataData] = None,
    ):
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListJobResponseDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page: int = None,
        data: ListJobResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page = page
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page, 'page')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = ListJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryJobResponseDataRolloutConfig(TeaModel):
    def __init__(
        self,
        maximum_per_minute: int = None,
    ):
        self.maximum_per_minute = maximum_per_minute

    def validate(self):
        self.validate_required(self.maximum_per_minute, 'maximum_per_minute')

    def to_map(self):
        result = dict()
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        return self


class QueryJobResponseDataTimeoutConfig(TeaModel):
    def __init__(
        self,
        in_progress_timeout_in_minutes: int = None,
    ):
        self.in_progress_timeout_in_minutes = in_progress_timeout_in_minutes

    def validate(self):
        self.validate_required(self.in_progress_timeout_in_minutes, 'in_progress_timeout_in_minutes')

    def to_map(self):
        result = dict()
        if self.in_progress_timeout_in_minutes is not None:
            result['InProgressTimeoutInMinutes'] = self.in_progress_timeout_in_minutes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InProgressTimeoutInMinutes') is not None:
            self.in_progress_timeout_in_minutes = m.get('InProgressTimeoutInMinutes')
        return self


class QueryJobResponseDataJobFile(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        sign_method: str = None,
        sign: str = None,
    ):
        self.file_url = file_url
        self.sign_method = sign_method
        self.sign = sign

    def validate(self):
        self.validate_required(self.file_url, 'file_url')
        self.validate_required(self.sign_method, 'sign_method')
        self.validate_required(self.sign, 'sign')

    def to_map(self):
        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.sign is not None:
            result['Sign'] = self.sign
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        return self


class QueryJobResponseDataTargetConfigTargetDevicesTargetDevices(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class QueryJobResponseDataTargetConfigTargetDevices(TeaModel):
    def __init__(
        self,
        target_devices: List[QueryJobResponseDataTargetConfigTargetDevicesTargetDevices] = None,
    ):
        self.target_devices = target_devices

    def validate(self):
        self.validate_required(self.target_devices, 'target_devices')
        if self.target_devices:
            for k in self.target_devices:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['targetDevices'] = []
        if self.target_devices is not None:
            for k in self.target_devices:
                result['targetDevices'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.target_devices = []
        if m.get('targetDevices') is not None:
            for k in m.get('targetDevices'):
                temp_model = QueryJobResponseDataTargetConfigTargetDevicesTargetDevices()
                self.target_devices.append(temp_model.from_map(k))
        return self


class QueryJobResponseDataTargetConfig(TeaModel):
    def __init__(
        self,
        target_group: str = None,
        target_product: str = None,
        target_type: str = None,
        target_devices: QueryJobResponseDataTargetConfigTargetDevices = None,
    ):
        self.target_group = target_group
        self.target_product = target_product
        self.target_type = target_type
        self.target_devices = target_devices

    def validate(self):
        self.validate_required(self.target_group, 'target_group')
        self.validate_required(self.target_product, 'target_product')
        self.validate_required(self.target_type, 'target_type')
        self.validate_required(self.target_devices, 'target_devices')
        if self.target_devices:
            self.target_devices.validate()

    def to_map(self):
        result = dict()
        if self.target_group is not None:
            result['TargetGroup'] = self.target_group
        if self.target_product is not None:
            result['TargetProduct'] = self.target_product
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.target_devices is not None:
            result['TargetDevices'] = self.target_devices.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetGroup') is not None:
            self.target_group = m.get('TargetGroup')
        if m.get('TargetProduct') is not None:
            self.target_product = m.get('TargetProduct')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TargetDevices') is not None:
            temp_model = QueryJobResponseDataTargetConfigTargetDevices()
            self.target_devices = temp_model.from_map(m['TargetDevices'])
        return self


class QueryJobResponseData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        job_name: str = None,
        utc_create: str = None,
        status: str = None,
        description: str = None,
        type: str = None,
        job_document: str = None,
        utc_modified: str = None,
        rollout_config: QueryJobResponseDataRolloutConfig = None,
        timeout_config: QueryJobResponseDataTimeoutConfig = None,
        job_file: QueryJobResponseDataJobFile = None,
        target_config: QueryJobResponseDataTargetConfig = None,
    ):
        self.job_id = job_id
        self.job_name = job_name
        self.utc_create = utc_create
        self.status = status
        self.description = description
        self.type = type
        self.job_document = job_document
        self.utc_modified = utc_modified
        self.rollout_config = rollout_config
        self.timeout_config = timeout_config
        self.job_file = job_file
        self.target_config = target_config

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.status, 'status')
        self.validate_required(self.description, 'description')
        self.validate_required(self.type, 'type')
        self.validate_required(self.job_document, 'job_document')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.rollout_config, 'rollout_config')
        if self.rollout_config:
            self.rollout_config.validate()
        self.validate_required(self.timeout_config, 'timeout_config')
        if self.timeout_config:
            self.timeout_config.validate()
        self.validate_required(self.job_file, 'job_file')
        if self.job_file:
            self.job_file.validate()
        self.validate_required(self.target_config, 'target_config')
        if self.target_config:
            self.target_config.validate()

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.rollout_config is not None:
            result['RolloutConfig'] = self.rollout_config.to_map()
        if self.timeout_config is not None:
            result['TimeoutConfig'] = self.timeout_config.to_map()
        if self.job_file is not None:
            result['JobFile'] = self.job_file.to_map()
        if self.target_config is not None:
            result['TargetConfig'] = self.target_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('RolloutConfig') is not None:
            temp_model = QueryJobResponseDataRolloutConfig()
            self.rollout_config = temp_model.from_map(m['RolloutConfig'])
        if m.get('TimeoutConfig') is not None:
            temp_model = QueryJobResponseDataTimeoutConfig()
            self.timeout_config = temp_model.from_map(m['TimeoutConfig'])
        if m.get('JobFile') is not None:
            temp_model = QueryJobResponseDataJobFile()
            self.job_file = temp_model.from_map(m['JobFile'])
        if m.get('TargetConfig') is not None:
            temp_model = QueryJobResponseDataTargetConfig()
            self.target_config = temp_model.from_map(m['TargetConfig'])
        return self


class QueryJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryJobResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        description: str = None,
        timeout_config: Dict[str, Any] = None,
        rollout_config: Dict[str, Any] = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.description = description
        self.timeout_config = timeout_config
        self.rollout_config = rollout_config
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.timeout_config is not None:
            result['TimeoutConfig'] = self.timeout_config
        if self.rollout_config is not None:
            result['RolloutConfig'] = self.rollout_config
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config = m.get('RolloutConfig')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class UpdateJobShrinkRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        description: str = None,
        timeout_config_shrink: str = None,
        rollout_config_shrink: str = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.description = description
        self.timeout_config_shrink = timeout_config_shrink
        self.rollout_config_shrink = rollout_config_shrink
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.timeout_config_shrink is not None:
            result['TimeoutConfig'] = self.timeout_config_shrink
        if self.rollout_config_shrink is not None:
            result['RolloutConfig'] = self.rollout_config_shrink
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config_shrink = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config_shrink = m.get('RolloutConfig')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class UpdateJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        description: str = None,
        job_document: str = None,
        type: str = None,
        job_file: Dict[str, Any] = None,
        job_name: str = None,
        timeout_config: Dict[str, Any] = None,
        rollout_config: Dict[str, Any] = None,
        target_config: Dict[str, Any] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.description = description
        self.job_document = job_document
        self.type = type
        self.job_file = job_file
        self.job_name = job_name
        self.timeout_config = timeout_config
        self.rollout_config = rollout_config
        self.target_config = target_config

    def validate(self):
        self.validate_required(self.job_document, 'job_document')
        self.validate_required(self.type, 'type')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.target_config, 'target_config')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.type is not None:
            result['Type'] = self.type
        if self.job_file is not None:
            result['JobFile'] = self.job_file
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.timeout_config is not None:
            result['TimeoutConfig'] = self.timeout_config
        if self.rollout_config is not None:
            result['RolloutConfig'] = self.rollout_config
        if self.target_config is not None:
            result['TargetConfig'] = self.target_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('JobFile') is not None:
            self.job_file = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config = m.get('RolloutConfig')
        if m.get('TargetConfig') is not None:
            self.target_config = m.get('TargetConfig')
        return self


class CreateJobShrinkRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        description: str = None,
        job_document: str = None,
        type: str = None,
        job_file_shrink: str = None,
        job_name: str = None,
        timeout_config_shrink: str = None,
        rollout_config_shrink: str = None,
        target_config_shrink: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.description = description
        self.job_document = job_document
        self.type = type
        self.job_file_shrink = job_file_shrink
        self.job_name = job_name
        self.timeout_config_shrink = timeout_config_shrink
        self.rollout_config_shrink = rollout_config_shrink
        self.target_config_shrink = target_config_shrink

    def validate(self):
        self.validate_required(self.job_document, 'job_document')
        self.validate_required(self.type, 'type')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.target_config_shrink, 'target_config_shrink')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.type is not None:
            result['Type'] = self.type
        if self.job_file_shrink is not None:
            result['JobFile'] = self.job_file_shrink
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.timeout_config_shrink is not None:
            result['TimeoutConfig'] = self.timeout_config_shrink
        if self.rollout_config_shrink is not None:
            result['RolloutConfig'] = self.rollout_config_shrink
        if self.target_config_shrink is not None:
            result['TargetConfig'] = self.target_config_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('JobFile') is not None:
            self.job_file_shrink = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config_shrink = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config_shrink = m.get('RolloutConfig')
        if m.get('TargetConfig') is not None:
            self.target_config_shrink = m.get('TargetConfig')
        return self


class CreateJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GenerateFileUploadURLRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        file_suffix: str = None,
        biz_code: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.file_suffix = file_suffix
        self.biz_code = biz_code

    def validate(self):
        self.validate_required(self.file_suffix, 'file_suffix')
        self.validate_required(self.biz_code, 'biz_code')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        return self


class GenerateFileUploadURLResponseData(TeaModel):
    def __init__(
        self,
        key: str = None,
        host: str = None,
        policy: str = None,
        oss_access_key_id: str = None,
        signature: str = None,
        object_storage: str = None,
    ):
        self.key = key
        self.host = host
        self.policy = policy
        self.oss_access_key_id = oss_access_key_id
        self.signature = signature
        self.object_storage = object_storage

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.host, 'host')
        self.validate_required(self.policy, 'policy')
        self.validate_required(self.oss_access_key_id, 'oss_access_key_id')
        self.validate_required(self.signature, 'signature')
        self.validate_required(self.object_storage, 'object_storage')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.oss_access_key_id is not None:
            result['OssAccessKeyId'] = self.oss_access_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('OssAccessKeyId') is not None:
            self.oss_access_key_id = m.get('OssAccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateFileUploadURLResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GenerateFileUploadURLResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GenerateFileUploadURLResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateProductDistributeJobRequest(TeaModel):
    def __init__(
        self,
        source_instance_id: str = None,
        product_key: str = None,
        target_instance_id: str = None,
        target_uid: str = None,
        target_aliyun_id: str = None,
    ):
        self.source_instance_id = source_instance_id
        self.product_key = product_key
        self.target_instance_id = target_instance_id
        self.target_uid = target_uid
        self.target_aliyun_id = target_aliyun_id

    def validate(self):
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        result = dict()
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        return self


class CreateProductDistributeJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryDeviceOriginalPropertyDataRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        next_page_token: str = None,
        start_time: int = None,
        identifier: str = None,
        asc: int = None,
        iot_id: str = None,
        end_time: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.next_page_token = next_page_token
        self.start_time = start_time
        self.identifier = identifier
        self.asc = asc
        self.iot_id = iot_id
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.asc, 'asc')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryDeviceOriginalPropertyDataResponseDataListPropertyInfo(TeaModel):
    def __init__(
        self,
        time: str = None,
        value: str = None,
    ):
        self.time = time
        self.value = value

    def validate(self):
        self.validate_required(self.time, 'time')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class QueryDeviceOriginalPropertyDataResponseDataList(TeaModel):
    def __init__(
        self,
        property_info: List[QueryDeviceOriginalPropertyDataResponseDataListPropertyInfo] = None,
    ):
        self.property_info = property_info

    def validate(self):
        self.validate_required(self.property_info, 'property_info')
        if self.property_info:
            for k in self.property_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PropertyInfo'] = []
        if self.property_info is not None:
            for k in self.property_info:
                result['PropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.property_info = []
        if m.get('PropertyInfo') is not None:
            for k in m.get('PropertyInfo'):
                temp_model = QueryDeviceOriginalPropertyDataResponseDataListPropertyInfo()
                self.property_info.append(temp_model.from_map(k))
        return self


class QueryDeviceOriginalPropertyDataResponseData(TeaModel):
    def __init__(
        self,
        next_valid: bool = None,
        next_page_token: str = None,
        list: QueryDeviceOriginalPropertyDataResponseDataList = None,
    ):
        self.next_valid = next_valid
        self.next_page_token = next_page_token
        self.list = list

    def validate(self):
        self.validate_required(self.next_valid, 'next_valid')
        self.validate_required(self.next_page_token, 'next_page_token')
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.next_page_token is not None:
            result['nextPageToken'] = self.next_page_token
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('nextPageToken') is not None:
            self.next_page_token = m.get('nextPageToken')
        if m.get('List') is not None:
            temp_model = QueryDeviceOriginalPropertyDataResponseDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceOriginalPropertyDataResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceOriginalPropertyDataResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceOriginalPropertyDataResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceOriginalEventDataRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        next_page_token: str = None,
        start_time: int = None,
        identifier: str = None,
        asc: int = None,
        iot_id: str = None,
        end_time: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.next_page_token = next_page_token
        self.start_time = start_time
        self.identifier = identifier
        self.asc = asc
        self.iot_id = iot_id
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.asc, 'asc')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryDeviceOriginalEventDataResponseDataListEventInfo(TeaModel):
    def __init__(
        self,
        time: str = None,
        identifier: str = None,
        name: str = None,
        event_type: str = None,
        output_data: str = None,
    ):
        self.time = time
        self.identifier = identifier
        self.name = name
        self.event_type = event_type
        self.output_data = output_data

    def validate(self):
        self.validate_required(self.time, 'time')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.name, 'name')
        self.validate_required(self.event_type, 'event_type')
        self.validate_required(self.output_data, 'output_data')

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.name is not None:
            result['Name'] = self.name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.output_data is not None:
            result['OutputData'] = self.output_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('OutputData') is not None:
            self.output_data = m.get('OutputData')
        return self


class QueryDeviceOriginalEventDataResponseDataList(TeaModel):
    def __init__(
        self,
        event_info: List[QueryDeviceOriginalEventDataResponseDataListEventInfo] = None,
    ):
        self.event_info = event_info

    def validate(self):
        self.validate_required(self.event_info, 'event_info')
        if self.event_info:
            for k in self.event_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EventInfo'] = []
        if self.event_info is not None:
            for k in self.event_info:
                result['EventInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_info = []
        if m.get('EventInfo') is not None:
            for k in m.get('EventInfo'):
                temp_model = QueryDeviceOriginalEventDataResponseDataListEventInfo()
                self.event_info.append(temp_model.from_map(k))
        return self


class QueryDeviceOriginalEventDataResponseData(TeaModel):
    def __init__(
        self,
        next_page_token: str = None,
        next_valid: bool = None,
        list: QueryDeviceOriginalEventDataResponseDataList = None,
    ):
        self.next_page_token = next_page_token
        self.next_valid = next_valid
        self.list = list

    def validate(self):
        self.validate_required(self.next_page_token, 'next_page_token')
        self.validate_required(self.next_valid, 'next_valid')
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('List') is not None:
            temp_model = QueryDeviceOriginalEventDataResponseDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceOriginalEventDataResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceOriginalEventDataResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceOriginalEventDataResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceOriginalPropertyStatusRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        next_page_token: str = None,
        iot_id: str = None,
        asc: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.next_page_token = next_page_token
        self.iot_id = iot_id
        self.asc = asc

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.asc, 'asc')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.asc is not None:
            result['Asc'] = self.asc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        return self


class QueryDeviceOriginalPropertyStatusResponseDataListPropertyStatusDataInfo(TeaModel):
    def __init__(
        self,
        identifier: str = None,
        value: str = None,
        time: int = None,
    ):
        self.identifier = identifier
        self.value = value
        self.time = time

    def validate(self):
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.value, 'value')
        self.validate_required(self.time, 'time')

    def to_map(self):
        result = dict()
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.value is not None:
            result['Value'] = self.value
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class QueryDeviceOriginalPropertyStatusResponseDataList(TeaModel):
    def __init__(
        self,
        property_status_data_info: List[QueryDeviceOriginalPropertyStatusResponseDataListPropertyStatusDataInfo] = None,
    ):
        self.property_status_data_info = property_status_data_info

    def validate(self):
        self.validate_required(self.property_status_data_info, 'property_status_data_info')
        if self.property_status_data_info:
            for k in self.property_status_data_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PropertyStatusDataInfo'] = []
        if self.property_status_data_info is not None:
            for k in self.property_status_data_info:
                result['PropertyStatusDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.property_status_data_info = []
        if m.get('PropertyStatusDataInfo') is not None:
            for k in m.get('PropertyStatusDataInfo'):
                temp_model = QueryDeviceOriginalPropertyStatusResponseDataListPropertyStatusDataInfo()
                self.property_status_data_info.append(temp_model.from_map(k))
        return self


class QueryDeviceOriginalPropertyStatusResponseData(TeaModel):
    def __init__(
        self,
        next_valid: bool = None,
        next_page_token: str = None,
        list: QueryDeviceOriginalPropertyStatusResponseDataList = None,
    ):
        self.next_valid = next_valid
        self.next_page_token = next_page_token
        self.list = list

    def validate(self):
        self.validate_required(self.next_valid, 'next_valid')
        self.validate_required(self.next_page_token, 'next_page_token')
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('List') is not None:
            temp_model = QueryDeviceOriginalPropertyStatusResponseDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceOriginalPropertyStatusResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceOriginalPropertyStatusResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceOriginalPropertyStatusResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceOriginalServiceDataRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        next_page_token: str = None,
        start_time: int = None,
        identifier: str = None,
        asc: int = None,
        iot_id: str = None,
        end_time: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.next_page_token = next_page_token
        self.start_time = start_time
        self.identifier = identifier
        self.asc = asc
        self.iot_id = iot_id
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.asc, 'asc')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryDeviceOriginalServiceDataResponseDataListServiceInfo(TeaModel):
    def __init__(
        self,
        time: str = None,
        identifier: str = None,
        name: str = None,
        input_data: str = None,
        output_data: str = None,
    ):
        self.time = time
        self.identifier = identifier
        self.name = name
        self.input_data = input_data
        self.output_data = output_data

    def validate(self):
        self.validate_required(self.time, 'time')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.name, 'name')
        self.validate_required(self.input_data, 'input_data')
        self.validate_required(self.output_data, 'output_data')

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.name is not None:
            result['Name'] = self.name
        if self.input_data is not None:
            result['InputData'] = self.input_data
        if self.output_data is not None:
            result['OutputData'] = self.output_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('InputData') is not None:
            self.input_data = m.get('InputData')
        if m.get('OutputData') is not None:
            self.output_data = m.get('OutputData')
        return self


class QueryDeviceOriginalServiceDataResponseDataList(TeaModel):
    def __init__(
        self,
        service_info: List[QueryDeviceOriginalServiceDataResponseDataListServiceInfo] = None,
    ):
        self.service_info = service_info

    def validate(self):
        self.validate_required(self.service_info, 'service_info')
        if self.service_info:
            for k in self.service_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ServiceInfo'] = []
        if self.service_info is not None:
            for k in self.service_info:
                result['ServiceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.service_info = []
        if m.get('ServiceInfo') is not None:
            for k in m.get('ServiceInfo'):
                temp_model = QueryDeviceOriginalServiceDataResponseDataListServiceInfo()
                self.service_info.append(temp_model.from_map(k))
        return self


class QueryDeviceOriginalServiceDataResponseData(TeaModel):
    def __init__(
        self,
        next_page_token: str = None,
        next_valid: bool = None,
        list: QueryDeviceOriginalServiceDataResponseDataList = None,
    ):
        self.next_page_token = next_page_token
        self.next_valid = next_valid
        self.list = list

    def validate(self):
        self.validate_required(self.next_page_token, 'next_page_token')
        self.validate_required(self.next_valid, 'next_valid')
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('List') is not None:
            temp_model = QueryDeviceOriginalServiceDataResponseDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceOriginalServiceDataResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceOriginalServiceDataResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceOriginalServiceDataResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateThingScriptRequest(TeaModel):
    def __init__(
        self,
        script_content: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        script_type: str = None,
    ):
        self.script_content = script_content
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.script_type = script_type

    def validate(self):
        self.validate_required(self.script_content, 'script_content')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.script_type, 'script_type')

    def to_map(self):
        result = dict()
        if self.script_content is not None:
            result['ScriptContent'] = self.script_content
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScriptContent') is not None:
            self.script_content = m.get('ScriptContent')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        return self


class CreateThingScriptResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class UpdateThingScriptRequest(TeaModel):
    def __init__(
        self,
        script_content: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        script_type: str = None,
    ):
        self.script_content = script_content
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.script_type = script_type

    def validate(self):
        self.validate_required(self.script_content, 'script_content')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.script_type, 'script_type')

    def to_map(self):
        result = dict()
        if self.script_content is not None:
            result['ScriptContent'] = self.script_content
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScriptContent') is not None:
            self.script_content = m.get('ScriptContent')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        return self


class UpdateThingScriptResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class GetThingScriptRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetThingScriptResponseData(TeaModel):
    def __init__(
        self,
        script_type: str = None,
        script_url: str = None,
    ):
        self.script_type = script_type
        self.script_url = script_url

    def validate(self):
        self.validate_required(self.script_type, 'script_type')
        self.validate_required(self.script_url, 'script_url')

    def to_map(self):
        result = dict()
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        if self.script_url is not None:
            result['ScriptUrl'] = self.script_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        if m.get('ScriptUrl') is not None:
            self.script_url = m.get('ScriptUrl')
        return self


class GetThingScriptResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetThingScriptResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingScriptResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAModuleVersionsByDeviceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.current_page = current_page

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAModuleVersionsByDeviceResponseDataSimpleOTAModuleInfo(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        module_version: str = None,
        module_name: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.module_version = module_version
        self.module_name = module_name

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.module_version, 'module_version')
        self.validate_required(self.module_name, 'module_name')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.module_version is not None:
            result['ModuleVersion'] = self.module_version
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ModuleVersion') is not None:
            self.module_version = m.get('ModuleVersion')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class ListOTAModuleVersionsByDeviceResponseData(TeaModel):
    def __init__(
        self,
        simple_otamodule_info: List[ListOTAModuleVersionsByDeviceResponseDataSimpleOTAModuleInfo] = None,
    ):
        self.simple_otamodule_info = simple_otamodule_info

    def validate(self):
        self.validate_required(self.simple_otamodule_info, 'simple_otamodule_info')
        if self.simple_otamodule_info:
            for k in self.simple_otamodule_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTAModuleInfo'] = []
        if self.simple_otamodule_info is not None:
            for k in self.simple_otamodule_info:
                result['SimpleOTAModuleInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otamodule_info = []
        if m.get('SimpleOTAModuleInfo') is not None:
            for k in m.get('SimpleOTAModuleInfo'):
                temp_model = ListOTAModuleVersionsByDeviceResponseDataSimpleOTAModuleInfo()
                self.simple_otamodule_info.append(temp_model.from_map(k))
        return self


class ListOTAModuleVersionsByDeviceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        data: ListOTAModuleVersionsByDeviceResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAModuleVersionsByDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchPubRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        device_name: List[str] = None,
        product_key: str = None,
        qos: int = None,
        topic_short_name: str = None,
        message_content: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.device_name = device_name
        self.product_key = product_key
        self.qos = qos
        self.topic_short_name = topic_short_name
        self.message_content = message_content

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.topic_short_name, 'topic_short_name')
        self.validate_required(self.message_content, 'message_content')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        return self


class BatchPubResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class SpeechByCombinationRequest(TeaModel):
    def __init__(
        self,
        combination_list: List[str] = None,
        iot_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_instance_id: str = None,
    ):
        self.combination_list = combination_list
        self.iot_id = iot_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_instance_id = iot_instance_id

    def validate(self):
        self.validate_required(self.combination_list, 'combination_list')

    def to_map(self):
        result = dict()
        if self.combination_list is not None:
            result['CombinationList'] = self.combination_list
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CombinationList') is not None:
            self.combination_list = m.get('CombinationList')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class SpeechByCombinationResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class UpdateThingModelValidationConfigRequest(TeaModel):
    def __init__(
        self,
        validate_type: int = None,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.validate_type = validate_type
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        self.validate_required(self.validate_type, 'validate_type')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.validate_type is not None:
            result['ValidateType'] = self.validate_type
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ValidateType') is not None:
            self.validate_type = m.get('ValidateType')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class UpdateThingModelValidationConfigResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryDeviceBySQLRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        sql: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.sql = sql

    def validate(self):
        self.validate_required(self.iot_instance_id, 'iot_instance_id')
        self.validate_required(self.sql, 'sql')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.sql is not None:
            result['SQL'] = self.sql
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SQL') is not None:
            self.sql = m.get('SQL')
        return self


class QueryDeviceBySQLResponseDataGroups(TeaModel):
    def __init__(
        self,
        group_id: str = None,
    ):
        self.group_id = group_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryDeviceBySQLResponseDataTags(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        tag_value: str = None,
    ):
        self.tag_name = tag_name
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_name, 'tag_name')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceBySQLResponseDataOTAModules(TeaModel):
    def __init__(
        self,
        module_name: str = None,
        firmware_version: str = None,
    ):
        self.module_name = module_name
        self.firmware_version = firmware_version

    def validate(self):
        self.validate_required(self.module_name, 'module_name')
        self.validate_required(self.firmware_version, 'firmware_version')

    def to_map(self):
        result = dict()
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        return self


class QueryDeviceBySQLResponseData(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        nickname: str = None,
        status: str = None,
        active_time: str = None,
        iot_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        groups: List[QueryDeviceBySQLResponseDataGroups] = None,
        tags: List[QueryDeviceBySQLResponseDataTags] = None,
        otamodules: List[QueryDeviceBySQLResponseDataOTAModules] = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.nickname = nickname
        self.status = status
        self.active_time = active_time
        self.iot_id = iot_id
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.groups = groups
        self.tags = tags
        self.otamodules = otamodules

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.nickname, 'nickname')
        self.validate_required(self.status, 'status')
        self.validate_required(self.active_time, 'active_time')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.groups, 'groups')
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()
        self.validate_required(self.otamodules, 'otamodules')
        if self.otamodules:
            for k in self.otamodules:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.status is not None:
            result['Status'] = self.status
        if self.active_time is not None:
            result['ActiveTime'] = self.active_time
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        result['OTAModules'] = []
        if self.otamodules is not None:
            for k in self.otamodules:
                result['OTAModules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ActiveTime') is not None:
            self.active_time = m.get('ActiveTime')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = QueryDeviceBySQLResponseDataGroups()
                self.groups.append(temp_model.from_map(k))
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = QueryDeviceBySQLResponseDataTags()
                self.tags.append(temp_model.from_map(k))
        self.otamodules = []
        if m.get('OTAModules') is not None:
            for k in m.get('OTAModules'):
                temp_model = QueryDeviceBySQLResponseDataOTAModules()
                self.otamodules.append(temp_model.from_map(k))
        return self


class QueryDeviceBySQLResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total_count: int = None,
        data: List[QueryDeviceBySQLResponseData] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total_count = total_count
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryDeviceBySQLResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class ListOTAModuleByProductRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListOTAModuleByProductResponseData(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        module_name: str = None,
        alias_name: str = None,
        desc: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        self.product_key = product_key
        self.module_name = module_name
        self.alias_name = alias_name
        self.desc = desc
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.module_name, 'module_name')
        self.validate_required(self.alias_name, 'alias_name')
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class ListOTAModuleByProductResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: List[ListOTAModuleByProductResponseData] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListOTAModuleByProductResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class DeleteOTAModuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        module_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.module_name = module_name

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.module_name, 'module_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class DeleteOTAModuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class GenerateDeviceNameListURLRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GenerateDeviceNameListURLResponseData(TeaModel):
    def __init__(
        self,
        key: str = None,
        host: str = None,
        policy: str = None,
        access_key_id: str = None,
        signature: str = None,
        file_url: str = None,
        utc_create: str = None,
        object_storage: str = None,
    ):
        self.key = key
        self.host = host
        self.policy = policy
        self.access_key_id = access_key_id
        self.signature = signature
        self.file_url = file_url
        self.utc_create = utc_create
        self.object_storage = object_storage

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.host, 'host')
        self.validate_required(self.policy, 'policy')
        self.validate_required(self.access_key_id, 'access_key_id')
        self.validate_required(self.signature, 'signature')
        self.validate_required(self.file_url, 'file_url')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.object_storage, 'object_storage')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.access_key_id is not None:
            result['AccessKeyId'] = self.access_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('AccessKeyId') is not None:
            self.access_key_id = m.get('AccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateDeviceNameListURLResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GenerateDeviceNameListURLResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GenerateDeviceNameListURLResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateOTAModuleRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        iot_instance_id: str = None,
        module_name: str = None,
        desc: str = None,
        product_key: str = None,
    ):
        self.alias_name = alias_name
        self.iot_instance_id = iot_instance_id
        self.module_name = module_name
        self.desc = desc
        self.product_key = product_key

    def validate(self):
        self.validate_required(self.module_name, 'module_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class UpdateOTAModuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateOTAModuleRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        iot_instance_id: str = None,
        module_name: str = None,
        desc: str = None,
        product_key: str = None,
    ):
        self.alias_name = alias_name
        self.iot_instance_id = iot_instance_id
        self.module_name = module_name
        self.desc = desc
        self.product_key = product_key

    def validate(self):
        self.validate_required(self.module_name, 'module_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateOTAModuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryThingModelExtendConfigPublishedRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        model_version: str = None,
        function_block_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.model_version = model_version
        self.function_block_id = function_block_id

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class QueryThingModelExtendConfigPublishedResponseData(TeaModel):
    def __init__(
        self,
        configuration: str = None,
    ):
        self.configuration = configuration

    def validate(self):
        self.validate_required(self.configuration, 'configuration')

    def to_map(self):
        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        return self


class QueryThingModelExtendConfigPublishedResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryThingModelExtendConfigPublishedResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryThingModelExtendConfigPublishedResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingModelTslPublishedRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        resource_group_id: str = None,
        simple: bool = None,
        model_version: str = None,
        function_block_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.resource_group_id = resource_group_id
        self.simple = simple
        self.model_version = model_version
        self.function_block_id = function_block_id

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.simple is not None:
            result['Simple'] = self.simple
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class GetThingModelTslPublishedResponseData(TeaModel):
    def __init__(
        self,
        tsl_str: str = None,
        tsl_uri: str = None,
    ):
        self.tsl_str = tsl_str
        self.tsl_uri = tsl_uri

    def validate(self):
        self.validate_required(self.tsl_str, 'tsl_str')
        self.validate_required(self.tsl_uri, 'tsl_uri')

    def to_map(self):
        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslPublishedResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetThingModelTslPublishedResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslPublishedResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryThingModelPublishedRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        resource_group_id: str = None,
        model_version: str = None,
        function_block_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.resource_group_id = resource_group_id
        self.model_version = model_version
        self.function_block_id = function_block_id

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class QueryThingModelPublishedResponseData(TeaModel):
    def __init__(
        self,
        thing_model_json: str = None,
    ):
        self.thing_model_json = thing_model_json

    def validate(self):
        self.validate_required(self.thing_model_json, 'thing_model_json')

    def to_map(self):
        result = dict()
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        return self


class QueryThingModelPublishedResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        product_key: str = None,
        data: QueryThingModelPublishedResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.product_key = product_key
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Data') is not None:
            temp_model = QueryThingModelPublishedResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryThingModelExtendConfigRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        resource_group_id: str = None,
        model_version: str = None,
        function_block_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.resource_group_id = resource_group_id
        self.model_version = model_version
        self.function_block_id = function_block_id

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class QueryThingModelExtendConfigResponseData(TeaModel):
    def __init__(
        self,
        configuration: str = None,
    ):
        self.configuration = configuration

    def validate(self):
        self.validate_required(self.configuration, 'configuration')

    def to_map(self):
        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        return self


class QueryThingModelExtendConfigResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryThingModelExtendConfigResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryThingModelExtendConfigResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDistributedDeviceRequest(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        current_page: int = None,
        target_uid: str = None,
        source_instance_id: str = None,
    ):
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.current_page = current_page
        self.target_uid = target_uid
        self.source_instance_id = source_instance_id

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        return self


class ListDistributedDeviceResponseDataInfoItems(TeaModel):
    def __init__(
        self,
        source_uid: str = None,
        target_uid: str = None,
        product_key: str = None,
        device_name: str = None,
        source_instance_id: str = None,
        target_instance_id: str = None,
        gmt_create: int = None,
        target_aliyun_id: str = None,
        source_region: str = None,
        target_region: str = None,
        source_instance_name: str = None,
        target_instance_name: str = None,
        gmt_modified: int = None,
    ):
        self.source_uid = source_uid
        self.target_uid = target_uid
        self.product_key = product_key
        self.device_name = device_name
        self.source_instance_id = source_instance_id
        self.target_instance_id = target_instance_id
        self.gmt_create = gmt_create
        self.target_aliyun_id = target_aliyun_id
        self.source_region = source_region
        self.target_region = target_region
        self.source_instance_name = source_instance_name
        self.target_instance_name = target_instance_name
        self.gmt_modified = gmt_modified

    def validate(self):
        self.validate_required(self.source_uid, 'source_uid')
        self.validate_required(self.target_uid, 'target_uid')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.target_instance_id, 'target_instance_id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.target_aliyun_id, 'target_aliyun_id')
        self.validate_required(self.source_region, 'source_region')
        self.validate_required(self.target_region, 'target_region')
        self.validate_required(self.source_instance_name, 'source_instance_name')
        self.validate_required(self.target_instance_name, 'target_instance_name')
        self.validate_required(self.gmt_modified, 'gmt_modified')

    def to_map(self):
        result = dict()
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.target_region is not None:
            result['TargetRegion'] = self.target_region
        if self.source_instance_name is not None:
            result['SourceInstanceName'] = self.source_instance_name
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('TargetRegion') is not None:
            self.target_region = m.get('TargetRegion')
        if m.get('SourceInstanceName') is not None:
            self.source_instance_name = m.get('SourceInstanceName')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class ListDistributedDeviceResponseDataInfo(TeaModel):
    def __init__(
        self,
        items: List[ListDistributedDeviceResponseDataInfoItems] = None,
    ):
        self.items = items

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDistributedDeviceResponseDataInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDistributedDeviceResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        info: ListDistributedDeviceResponseDataInfo = None,
    ):
        self.total = total
        self.info = info

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.info, 'info')
        if self.info:
            self.info.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.info is not None:
            result['Info'] = self.info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Info') is not None:
            temp_model = ListDistributedDeviceResponseDataInfo()
            self.info = temp_model.from_map(m['Info'])
        return self


class ListDistributedDeviceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: ListDistributedDeviceResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListDistributedDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDistributedProductRequest(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        source_instance_id: str = None,
        product_key: str = None,
        target_instance_id: str = None,
        target_uid: str = None,
        current_page: int = None,
    ):
        self.page_size = page_size
        self.source_instance_id = source_instance_id
        self.product_key = product_key
        self.target_instance_id = target_instance_id
        self.target_uid = target_uid
        self.current_page = current_page

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListDistributedProductResponseDataInfoItems(TeaModel):
    def __init__(
        self,
        source_uid: str = None,
        target_uid: str = None,
        product_key: str = None,
        source_instance_id: str = None,
        target_instance_id: str = None,
        gmt_create: int = None,
        target_aliyun_id: str = None,
        source_region: str = None,
        target_region: str = None,
        source_instance_name: str = None,
        target_instance_name: str = None,
    ):
        self.source_uid = source_uid
        self.target_uid = target_uid
        self.product_key = product_key
        self.source_instance_id = source_instance_id
        self.target_instance_id = target_instance_id
        self.gmt_create = gmt_create
        self.target_aliyun_id = target_aliyun_id
        self.source_region = source_region
        self.target_region = target_region
        self.source_instance_name = source_instance_name
        self.target_instance_name = target_instance_name

    def validate(self):
        self.validate_required(self.source_uid, 'source_uid')
        self.validate_required(self.target_uid, 'target_uid')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.target_instance_id, 'target_instance_id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.target_aliyun_id, 'target_aliyun_id')
        self.validate_required(self.source_region, 'source_region')
        self.validate_required(self.target_region, 'target_region')
        self.validate_required(self.source_instance_name, 'source_instance_name')
        self.validate_required(self.target_instance_name, 'target_instance_name')

    def to_map(self):
        result = dict()
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.target_region is not None:
            result['TargetRegion'] = self.target_region
        if self.source_instance_name is not None:
            result['SourceInstanceName'] = self.source_instance_name
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('TargetRegion') is not None:
            self.target_region = m.get('TargetRegion')
        if m.get('SourceInstanceName') is not None:
            self.source_instance_name = m.get('SourceInstanceName')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        return self


class ListDistributedProductResponseDataInfo(TeaModel):
    def __init__(
        self,
        items: List[ListDistributedProductResponseDataInfoItems] = None,
    ):
        self.items = items

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDistributedProductResponseDataInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDistributedProductResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        info: ListDistributedProductResponseDataInfo = None,
    ):
        self.total = total
        self.info = info

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.info, 'info')
        if self.info:
            self.info.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.info is not None:
            result['Info'] = self.info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Info') is not None:
            temp_model = ListDistributedProductResponseDataInfo()
            self.info = temp_model.from_map(m['Info'])
        return self


class ListDistributedProductResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: ListDistributedProductResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListDistributedProductResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QuerySubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        type: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.type = type

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QuerySubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        product_key: str = None,
        type: str = None,
        device_data_flag: bool = None,
        device_life_cycle_flag: bool = None,
        device_status_change_flag: bool = None,
        device_topo_life_cycle_flag: bool = None,
        found_device_list_flag: bool = None,
        ota_event_flag: bool = None,
        thing_history_flag: bool = None,
        mns_configuration: str = None,
        device_tag_flag: bool = None,
        ota_version_flag: bool = None,
        ota_job_flag: bool = None,
        consumer_group_ids: List[str] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.product_key = product_key
        self.type = type
        self.device_data_flag = device_data_flag
        self.device_life_cycle_flag = device_life_cycle_flag
        self.device_status_change_flag = device_status_change_flag
        self.device_topo_life_cycle_flag = device_topo_life_cycle_flag
        self.found_device_list_flag = found_device_list_flag
        self.ota_event_flag = ota_event_flag
        self.thing_history_flag = thing_history_flag
        self.mns_configuration = mns_configuration
        self.device_tag_flag = device_tag_flag
        self.ota_version_flag = ota_version_flag
        self.ota_job_flag = ota_job_flag
        self.consumer_group_ids = consumer_group_ids

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.type, 'type')
        self.validate_required(self.device_data_flag, 'device_data_flag')
        self.validate_required(self.device_life_cycle_flag, 'device_life_cycle_flag')
        self.validate_required(self.device_status_change_flag, 'device_status_change_flag')
        self.validate_required(self.device_topo_life_cycle_flag, 'device_topo_life_cycle_flag')
        self.validate_required(self.found_device_list_flag, 'found_device_list_flag')
        self.validate_required(self.ota_event_flag, 'ota_event_flag')
        self.validate_required(self.thing_history_flag, 'thing_history_flag')
        self.validate_required(self.mns_configuration, 'mns_configuration')
        self.validate_required(self.device_tag_flag, 'device_tag_flag')
        self.validate_required(self.ota_version_flag, 'ota_version_flag')
        self.validate_required(self.ota_job_flag, 'ota_job_flag')
        self.validate_required(self.consumer_group_ids, 'consumer_group_ids')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        if self.device_data_flag is not None:
            result['DeviceDataFlag'] = self.device_data_flag
        if self.device_life_cycle_flag is not None:
            result['DeviceLifeCycleFlag'] = self.device_life_cycle_flag
        if self.device_status_change_flag is not None:
            result['DeviceStatusChangeFlag'] = self.device_status_change_flag
        if self.device_topo_life_cycle_flag is not None:
            result['DeviceTopoLifeCycleFlag'] = self.device_topo_life_cycle_flag
        if self.found_device_list_flag is not None:
            result['FoundDeviceListFlag'] = self.found_device_list_flag
        if self.ota_event_flag is not None:
            result['OtaEventFlag'] = self.ota_event_flag
        if self.thing_history_flag is not None:
            result['ThingHistoryFlag'] = self.thing_history_flag
        if self.mns_configuration is not None:
            result['MnsConfiguration'] = self.mns_configuration
        if self.device_tag_flag is not None:
            result['DeviceTagFlag'] = self.device_tag_flag
        if self.ota_version_flag is not None:
            result['OtaVersionFlag'] = self.ota_version_flag
        if self.ota_job_flag is not None:
            result['OtaJobFlag'] = self.ota_job_flag
        if self.consumer_group_ids is not None:
            result['ConsumerGroupIds'] = self.consumer_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DeviceDataFlag') is not None:
            self.device_data_flag = m.get('DeviceDataFlag')
        if m.get('DeviceLifeCycleFlag') is not None:
            self.device_life_cycle_flag = m.get('DeviceLifeCycleFlag')
        if m.get('DeviceStatusChangeFlag') is not None:
            self.device_status_change_flag = m.get('DeviceStatusChangeFlag')
        if m.get('DeviceTopoLifeCycleFlag') is not None:
            self.device_topo_life_cycle_flag = m.get('DeviceTopoLifeCycleFlag')
        if m.get('FoundDeviceListFlag') is not None:
            self.found_device_list_flag = m.get('FoundDeviceListFlag')
        if m.get('OtaEventFlag') is not None:
            self.ota_event_flag = m.get('OtaEventFlag')
        if m.get('ThingHistoryFlag') is not None:
            self.thing_history_flag = m.get('ThingHistoryFlag')
        if m.get('MnsConfiguration') is not None:
            self.mns_configuration = m.get('MnsConfiguration')
        if m.get('DeviceTagFlag') is not None:
            self.device_tag_flag = m.get('DeviceTagFlag')
        if m.get('OtaVersionFlag') is not None:
            self.ota_version_flag = m.get('OtaVersionFlag')
        if m.get('OtaJobFlag') is not None:
            self.ota_job_flag = m.get('OtaJobFlag')
        if m.get('ConsumerGroupIds') is not None:
            self.consumer_group_ids = m.get('ConsumerGroupIds')
        return self


class CreateConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        consumer_group_id: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.consumer_group_id = consumer_group_id
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        self.validate_required(self.consumer_group_id, 'consumer_group_id')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class UpdateSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        device_status_change_flag: bool = None,
        iot_instance_id: str = None,
        thing_history_flag: bool = None,
        product_key: str = None,
        type: str = None,
        device_data_flag: bool = None,
        consumer_group_ids: List[str] = None,
        device_topo_life_cycle_flag: bool = None,
        found_device_list_flag: bool = None,
        ota_event_flag: bool = None,
        device_life_cycle_flag: bool = None,
        mns_configuration: str = None,
        device_tag_flag: bool = None,
        ota_version_flag: bool = None,
        ota_job_flag: bool = None,
    ):
        self.device_status_change_flag = device_status_change_flag
        self.iot_instance_id = iot_instance_id
        self.thing_history_flag = thing_history_flag
        self.product_key = product_key
        self.type = type
        self.device_data_flag = device_data_flag
        self.consumer_group_ids = consumer_group_ids
        self.device_topo_life_cycle_flag = device_topo_life_cycle_flag
        self.found_device_list_flag = found_device_list_flag
        self.ota_event_flag = ota_event_flag
        self.device_life_cycle_flag = device_life_cycle_flag
        self.mns_configuration = mns_configuration
        self.device_tag_flag = device_tag_flag
        self.ota_version_flag = ota_version_flag
        self.ota_job_flag = ota_job_flag

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.device_status_change_flag is not None:
            result['DeviceStatusChangeFlag'] = self.device_status_change_flag
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.thing_history_flag is not None:
            result['ThingHistoryFlag'] = self.thing_history_flag
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        if self.device_data_flag is not None:
            result['DeviceDataFlag'] = self.device_data_flag
        if self.consumer_group_ids is not None:
            result['ConsumerGroupIds'] = self.consumer_group_ids
        if self.device_topo_life_cycle_flag is not None:
            result['DeviceTopoLifeCycleFlag'] = self.device_topo_life_cycle_flag
        if self.found_device_list_flag is not None:
            result['FoundDeviceListFlag'] = self.found_device_list_flag
        if self.ota_event_flag is not None:
            result['OtaEventFlag'] = self.ota_event_flag
        if self.device_life_cycle_flag is not None:
            result['DeviceLifeCycleFlag'] = self.device_life_cycle_flag
        if self.mns_configuration is not None:
            result['MnsConfiguration'] = self.mns_configuration
        if self.device_tag_flag is not None:
            result['DeviceTagFlag'] = self.device_tag_flag
        if self.ota_version_flag is not None:
            result['OtaVersionFlag'] = self.ota_version_flag
        if self.ota_job_flag is not None:
            result['OtaJobFlag'] = self.ota_job_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceStatusChangeFlag') is not None:
            self.device_status_change_flag = m.get('DeviceStatusChangeFlag')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ThingHistoryFlag') is not None:
            self.thing_history_flag = m.get('ThingHistoryFlag')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DeviceDataFlag') is not None:
            self.device_data_flag = m.get('DeviceDataFlag')
        if m.get('ConsumerGroupIds') is not None:
            self.consumer_group_ids = m.get('ConsumerGroupIds')
        if m.get('DeviceTopoLifeCycleFlag') is not None:
            self.device_topo_life_cycle_flag = m.get('DeviceTopoLifeCycleFlag')
        if m.get('FoundDeviceListFlag') is not None:
            self.found_device_list_flag = m.get('FoundDeviceListFlag')
        if m.get('OtaEventFlag') is not None:
            self.ota_event_flag = m.get('OtaEventFlag')
        if m.get('DeviceLifeCycleFlag') is not None:
            self.device_life_cycle_flag = m.get('DeviceLifeCycleFlag')
        if m.get('MnsConfiguration') is not None:
            self.mns_configuration = m.get('MnsConfiguration')
        if m.get('DeviceTagFlag') is not None:
            self.device_tag_flag = m.get('DeviceTagFlag')
        if m.get('OtaVersionFlag') is not None:
            self.ota_version_flag = m.get('OtaVersionFlag')
        if m.get('OtaJobFlag') is not None:
            self.ota_job_flag = m.get('OtaJobFlag')
        return self


class UpdateSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        consumer_group_id: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.consumer_group_id = consumer_group_id
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        self.validate_required(self.consumer_group_id, 'consumer_group_id')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ResetConsumerGroupPositionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class ResetConsumerGroupPositionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class UpdateConsumerGroupRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        new_group_name: str = None,
        group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.new_group_name = new_group_name
        self.group_id = group_id

    def validate(self):
        self.validate_required(self.new_group_name, 'new_group_name')
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.new_group_name is not None:
            result['NewGroupName'] = self.new_group_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('NewGroupName') is not None:
            self.new_group_name = m.get('NewGroupName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class UpdateConsumerGroupResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class BatchDeleteEdgeInstanceChannelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_ids = channel_ids

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.channel_ids, 'channel_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class BatchDeleteEdgeInstanceChannelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchSetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_id = channel_id
        self.iot_ids = iot_ids

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchSetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchGetEdgeInstanceDeviceDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.iot_ids = iot_ids

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseDeviceDriverList(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        iot_id: str = None,
    ):
        self.driver_id = driver_id
        self.iot_id = iot_id

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceDriverResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        device_driver_list: List[BatchGetEdgeInstanceDeviceDriverResponseDeviceDriverList] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.device_driver_list = device_driver_list

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.device_driver_list, 'device_driver_list')
        if self.device_driver_list:
            for k in self.device_driver_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceDriverList'] = []
        if self.device_driver_list is not None:
            for k in self.device_driver_list:
                result['DeviceDriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_driver_list = []
        if m.get('DeviceDriverList') is not None:
            for k in m.get('DeviceDriverList'):
                temp_model = BatchGetEdgeInstanceDeviceDriverResponseDeviceDriverList()
                self.device_driver_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.iot_ids = iot_ids

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseDeviceChannelList(TeaModel):
    def __init__(
        self,
        channel_id: str = None,
        channel_name: str = None,
        iot_id: str = None,
    ):
        self.channel_id = channel_id
        self.channel_name = channel_name
        self.iot_id = iot_id

    def validate(self):
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        device_channel_list: List[BatchGetEdgeInstanceDeviceChannelResponseDeviceChannelList] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.device_channel_list = device_channel_list

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.device_channel_list, 'device_channel_list')
        if self.device_channel_list:
            for k in self.device_channel_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceChannelList'] = []
        if self.device_channel_list is not None:
            for k in self.device_channel_list:
                result['DeviceChannelList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_channel_list = []
        if m.get('DeviceChannelList') is not None:
            for k in m.get('DeviceChannelList'):
                temp_model = BatchGetEdgeInstanceDeviceChannelResponseDeviceChannelList()
                self.device_channel_list.append(temp_model.from_map(k))
        return self


class ReleaseEdgeDriverVersionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class ReleaseEdgeDriverVersionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryEdgeInstanceDeviceByDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        instance_id: str = None,
        channel_id: str = None,
        driver_id: str = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.instance_id = instance_id
        self.channel_id = channel_id
        self.driver_id = driver_id
        self.current_page = current_page

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryEdgeInstanceDeviceByDriverResponseDataDeviceList(TeaModel):
    def __init__(
        self,
        iot_id: str = None,
    ):
        self.iot_id = iot_id

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class QueryEdgeInstanceDeviceByDriverResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        device_list: List[QueryEdgeInstanceDeviceByDriverResponseDataDeviceList] = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.device_list = device_list

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.device_list, 'device_list')
        if self.device_list:
            for k in self.device_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['DeviceList'] = []
        if self.device_list is not None:
            for k in self.device_list:
                result['DeviceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.device_list = []
        if m.get('DeviceList') is not None:
            for k in m.get('DeviceList'):
                temp_model = QueryEdgeInstanceDeviceByDriverResponseDataDeviceList()
                self.device_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceDeviceByDriverResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryEdgeInstanceDeviceByDriverResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceDeviceByDriverResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DisableSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DisableSceneRuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class TriggerSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
        instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class TriggerSceneRuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class UnbindSceneRuleFromEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        rule_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class UnbindSceneRuleFromEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryEdgeInstanceSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryEdgeInstanceSceneRuleResponseDataRuleList(TeaModel):
    def __init__(
        self,
        rule_id: str = None,
        rule_name: str = None,
        gmt_create: int = None,
        status: int = None,
        is_existed: int = None,
    ):
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.gmt_create = gmt_create
        self.status = status
        self.is_existed = is_existed

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.status, 'status')
        self.validate_required(self.is_existed, 'is_existed')

    def to_map(self):
        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.status is not None:
            result['Status'] = self.status
        if self.is_existed is not None:
            result['IsExisted'] = self.is_existed
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IsExisted') is not None:
            self.is_existed = m.get('IsExisted')
        return self


class QueryEdgeInstanceSceneRuleResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        rule_list: List[QueryEdgeInstanceSceneRuleResponseDataRuleList] = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.rule_list = rule_list

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.rule_list, 'rule_list')
        if self.rule_list:
            for k in self.rule_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['RuleList'] = []
        if self.rule_list is not None:
            for k in self.rule_list:
                result['RuleList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.rule_list = []
        if m.get('RuleList') is not None:
            for k in m.get('RuleList'):
                temp_model = QueryEdgeInstanceSceneRuleResponseDataRuleList()
                self.rule_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceSceneRuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryEdgeInstanceSceneRuleResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceSceneRuleResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_name: str = None,
        rule_content: str = None,
        rule_description: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_name = rule_name
        self.rule_content = rule_content
        self.rule_description = rule_description

    def validate(self):
        self.validate_required(self.rule_name, 'rule_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        return self


class CreateSceneRuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        rule_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class QueryDetailSceneRuleLogRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
        start_time: int = None,
        end_time: int = None,
        trace_id: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id
        self.start_time = start_time
        self.end_time = end_time
        self.trace_id = trace_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.trace_id, 'trace_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDetailSceneRuleLogResponseDataLogList(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        pk_dn: str = None,
    ):
        self.code = code
        self.message = message
        self.pk_dn = pk_dn

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.pk_dn, 'pk_dn')

    def to_map(self):
        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.pk_dn is not None:
            result['PkDn'] = self.pk_dn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PkDn') is not None:
            self.pk_dn = m.get('PkDn')
        return self


class QueryDetailSceneRuleLogResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        log_list: List[QueryDetailSceneRuleLogResponseDataLogList] = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.log_list = log_list

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.log_list, 'log_list')
        if self.log_list:
            for k in self.log_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['LogList'] = []
        if self.log_list is not None:
            for k in self.log_list:
                result['LogList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.log_list = []
        if m.get('LogList') is not None:
            for k in m.get('LogList'):
                temp_model = QueryDetailSceneRuleLogResponseDataLogList()
                self.log_list.append(temp_model.from_map(k))
        return self


class QueryDetailSceneRuleLogResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: QueryDetailSceneRuleLogResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryDetailSceneRuleLogResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class EnableSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class EnableSceneRuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class UpdateSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
        rule_name: str = None,
        rule_content: str = None,
        rule_description: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.rule_content = rule_content
        self.rule_description = rule_description

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        return self


class UpdateSceneRuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QuerySceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_name: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_name = rule_name
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QuerySceneRuleResponseDataRuleList(TeaModel):
    def __init__(
        self,
        rule_id: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        rule_name: str = None,
        rule_description: str = None,
        rule_status: int = None,
    ):
        self.rule_id = rule_id
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.rule_name = rule_name
        self.rule_description = rule_description
        self.rule_status = rule_status

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.rule_description, 'rule_description')
        self.validate_required(self.rule_status, 'rule_status')

    def to_map(self):
        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        return self


class QuerySceneRuleResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        rule_list: List[QuerySceneRuleResponseDataRuleList] = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.rule_list = rule_list

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.rule_list, 'rule_list')
        if self.rule_list:
            for k in self.rule_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['RuleList'] = []
        if self.rule_list is not None:
            for k in self.rule_list:
                result['RuleList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.rule_list = []
        if m.get('RuleList') is not None:
            for k in m.get('RuleList'):
                temp_model = QuerySceneRuleResponseDataRuleList()
                self.rule_list.append(temp_model.from_map(k))
        return self


class QuerySceneRuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QuerySceneRuleResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QuerySceneRuleResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QuerySummarySceneRuleLogRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
        start_time: int = None,
        end_time: int = None,
        status: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id
        self.start_time = start_time
        self.end_time = end_time
        self.status = status
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.status, 'status')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.status is not None:
            result['Status'] = self.status
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QuerySummarySceneRuleLogResponseDataLogListLogInfo(TeaModel):
    def __init__(
        self,
        log_time: int = None,
        result: str = None,
        trace_id: str = None,
    ):
        self.log_time = log_time
        self.result = result
        self.trace_id = trace_id

    def validate(self):
        self.validate_required(self.log_time, 'log_time')
        self.validate_required(self.result, 'result')
        self.validate_required(self.trace_id, 'trace_id')

    def to_map(self):
        result = dict()
        if self.log_time is not None:
            result['LogTime'] = self.log_time
        if self.result is not None:
            result['Result'] = self.result
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogTime') is not None:
            self.log_time = m.get('LogTime')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class QuerySummarySceneRuleLogResponseDataLogList(TeaModel):
    def __init__(
        self,
        log_info: List[QuerySummarySceneRuleLogResponseDataLogListLogInfo] = None,
    ):
        self.log_info = log_info

    def validate(self):
        self.validate_required(self.log_info, 'log_info')
        if self.log_info:
            for k in self.log_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LogInfo'] = []
        if self.log_info is not None:
            for k in self.log_info:
                result['LogInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.log_info = []
        if m.get('LogInfo') is not None:
            for k in m.get('LogInfo'):
                temp_model = QuerySummarySceneRuleLogResponseDataLogListLogInfo()
                self.log_info.append(temp_model.from_map(k))
        return self


class QuerySummarySceneRuleLogResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        log_list: QuerySummarySceneRuleLogResponseDataLogList = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.log_list = log_list

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.log_list, 'log_list')
        if self.log_list:
            self.log_list.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.log_list is not None:
            result['LogList'] = self.log_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('LogList') is not None:
            temp_model = QuerySummarySceneRuleLogResponseDataLogList()
            self.log_list = temp_model.from_map(m['LogList'])
        return self


class QuerySummarySceneRuleLogResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: QuerySummarySceneRuleLogResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QuerySummarySceneRuleLogResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetSceneRuleResponseData(TeaModel):
    def __init__(
        self,
        gmt_create: int = None,
        gmt_modified: int = None,
        rule_name: str = None,
        rule_content: str = None,
        rule_description: str = None,
        rule_status: int = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.rule_name = rule_name
        self.rule_content = rule_content
        self.rule_description = rule_description
        self.rule_status = rule_status

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.rule_content, 'rule_content')
        self.validate_required(self.rule_description, 'rule_description')
        self.validate_required(self.rule_status, 'rule_status')

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        return self


class GetSceneRuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: GetSceneRuleResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSceneRuleResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteSceneRuleRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        rule_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteSceneRuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class BindSceneRuleToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        rule_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class BindSceneRuleToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class CreateEdgeOssPreSignedAddressRequest(TeaModel):
    def __init__(
        self,
        resource_id: str = None,
        file_name: str = None,
        iot_instance_id: str = None,
        type: str = None,
        instance_id: str = None,
        resource_version: str = None,
    ):
        self.resource_id = resource_id
        self.file_name = file_name
        self.iot_instance_id = iot_instance_id
        self.type = type
        self.instance_id = instance_id
        self.resource_version = resource_version

    def validate(self):
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.resource_version, 'resource_version')

    def to_map(self):
        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.type is not None:
            result['Type'] = self.type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_version is not None:
            result['ResourceVersion'] = self.resource_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceVersion') is not None:
            self.resource_version = m.get('ResourceVersion')
        return self


class CreateEdgeOssPreSignedAddressResponseData(TeaModel):
    def __init__(
        self,
        oss_pre_signed_address: str = None,
        oss_address: str = None,
    ):
        self.oss_pre_signed_address = oss_pre_signed_address
        self.oss_address = oss_address

    def validate(self):
        self.validate_required(self.oss_pre_signed_address, 'oss_pre_signed_address')
        self.validate_required(self.oss_address, 'oss_address')

    def to_map(self):
        result = dict()
        if self.oss_pre_signed_address is not None:
            result['OssPreSignedAddress'] = self.oss_pre_signed_address
        if self.oss_address is not None:
            result['OssAddress'] = self.oss_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OssPreSignedAddress') is not None:
            self.oss_pre_signed_address = m.get('OssPreSignedAddress')
        if m.get('OssAddress') is not None:
            self.oss_address = m.get('OssAddress')
        return self


class CreateEdgeOssPreSignedAddressResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateEdgeOssPreSignedAddressResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateEdgeDriverVersionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
        edge_version: str = None,
        description: str = None,
        source_config: str = None,
        driver_config: str = None,
        container_config: str = None,
        config_check_rule: str = None,
        argument: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version
        self.edge_version = edge_version
        self.description = description
        self.source_config = source_config
        self.driver_config = driver_config
        self.container_config = container_config
        self.config_check_rule = config_check_rule
        self.argument = argument

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')
        self.validate_required(self.edge_version, 'edge_version')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class UpdateEdgeDriverVersionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteEdgeDriverVersionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class DeleteEdgeDriverVersionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateEdgeDriverVersionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
        edge_version: str = None,
        description: str = None,
        source_config: str = None,
        driver_config: str = None,
        container_config: str = None,
        config_check_rule: str = None,
        argument: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version
        self.edge_version = edge_version
        self.description = description
        self.source_config = source_config
        self.driver_config = driver_config
        self.container_config = container_config
        self.config_check_rule = config_check_rule
        self.argument = argument

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')
        self.validate_required(self.edge_version, 'edge_version')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class CreateEdgeDriverVersionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteEdgeDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class DeleteEdgeDriverResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryEdgeDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        current_page: int = None,
        type: int = None,
        driver_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.current_page = current_page
        self.type = type
        self.driver_name = driver_name

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.type is not None:
            result['Type'] = self.type
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        return self


class QueryEdgeDriverResponseDataDriverList(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        driver_name: str = None,
        driver_protocol: str = None,
        runtime: str = None,
        cpu_arch: str = None,
        type: int = None,
        is_built_in: bool = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
    ):
        self.driver_id = driver_id
        self.driver_name = driver_name
        self.driver_protocol = driver_protocol
        self.runtime = runtime
        self.cpu_arch = cpu_arch
        self.type = type
        self.is_built_in = is_built_in
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_name, 'driver_name')
        self.validate_required(self.driver_protocol, 'driver_protocol')
        self.validate_required(self.runtime, 'runtime')
        self.validate_required(self.cpu_arch, 'cpu_arch')
        self.validate_required(self.type, 'type')
        self.validate_required(self.is_built_in, 'is_built_in')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.type is not None:
            result['Type'] = self.type
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        return self


class QueryEdgeDriverResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        driver_list: List[QueryEdgeDriverResponseDataDriverList] = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.driver_list = driver_list

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.driver_list, 'driver_list')
        if self.driver_list:
            for k in self.driver_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['DriverList'] = []
        if self.driver_list is not None:
            for k in self.driver_list:
                result['DriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.driver_list = []
        if m.get('DriverList') is not None:
            for k in m.get('DriverList'):
                temp_model = QueryEdgeDriverResponseDataDriverList()
                self.driver_list.append(temp_model.from_map(k))
        return self


class QueryEdgeDriverResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryEdgeDriverResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeDriverResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchGetEdgeDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_ids = driver_ids

    def validate(self):
        self.validate_required(self.driver_ids, 'driver_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        return self


class BatchGetEdgeDriverResponseDriverList(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        driver_name: str = None,
        driver_protocol: str = None,
        runtime: str = None,
        cpu_arch: str = None,
        type: int = None,
        is_built_in: bool = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
    ):
        self.driver_id = driver_id
        self.driver_name = driver_name
        self.driver_protocol = driver_protocol
        self.runtime = runtime
        self.cpu_arch = cpu_arch
        self.type = type
        self.is_built_in = is_built_in
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_name, 'driver_name')
        self.validate_required(self.driver_protocol, 'driver_protocol')
        self.validate_required(self.runtime, 'runtime')
        self.validate_required(self.cpu_arch, 'cpu_arch')
        self.validate_required(self.type, 'type')
        self.validate_required(self.is_built_in, 'is_built_in')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.type is not None:
            result['Type'] = self.type
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        return self


class BatchGetEdgeDriverResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        driver_list: List[BatchGetEdgeDriverResponseDriverList] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.driver_list = driver_list

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.driver_list, 'driver_list')
        if self.driver_list:
            for k in self.driver_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DriverList'] = []
        if self.driver_list is not None:
            for k in self.driver_list:
                result['DriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.driver_list = []
        if m.get('DriverList') is not None:
            for k in m.get('DriverList'):
                temp_model = BatchGetEdgeDriverResponseDriverList()
                self.driver_list.append(temp_model.from_map(k))
        return self


class CreateEdgeDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_name: str = None,
        driver_protocol: str = None,
        runtime: str = None,
        cpu_arch: str = None,
        is_built_in: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_name = driver_name
        self.driver_protocol = driver_protocol
        self.runtime = runtime
        self.cpu_arch = cpu_arch
        self.is_built_in = is_built_in

    def validate(self):
        self.validate_required(self.driver_name, 'driver_name')
        self.validate_required(self.driver_protocol, 'driver_protocol')
        self.validate_required(self.runtime, 'runtime')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        return self


class CreateEdgeDriverResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        driver_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.driver_id = driver_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class GetEdgeDriverVersionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class GetEdgeDriverVersionResponseData(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        driver_version: str = None,
        version_state: str = None,
        edge_version: str = None,
        description: str = None,
        source_config: str = None,
        driver_config: str = None,
        container_config: str = None,
        config_check_rule: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        argument: str = None,
    ):
        self.driver_id = driver_id
        self.driver_version = driver_version
        self.version_state = version_state
        self.edge_version = edge_version
        self.description = description
        self.source_config = source_config
        self.driver_config = driver_config
        self.container_config = container_config
        self.config_check_rule = config_check_rule
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.argument = argument

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')
        self.validate_required(self.version_state, 'version_state')
        self.validate_required(self.edge_version, 'edge_version')
        self.validate_required(self.description, 'description')
        self.validate_required(self.source_config, 'source_config')
        self.validate_required(self.driver_config, 'driver_config')
        self.validate_required(self.container_config, 'container_config')
        self.validate_required(self.config_check_rule, 'config_check_rule')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.argument, 'argument')

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.version_state is not None:
            result['VersionState'] = self.version_state
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('VersionState') is not None:
            self.version_state = m.get('VersionState')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class GetEdgeDriverVersionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetEdgeDriverVersionResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeDriverVersionResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryEdgeDriverVersionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        current_page: int = None,
        driver_id: str = None,
        driver_version: str = None,
        version_state: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.current_page = current_page
        self.driver_id = driver_id
        self.driver_version = driver_version
        self.version_state = version_state

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.version_state is not None:
            result['VersionState'] = self.version_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('VersionState') is not None:
            self.version_state = m.get('VersionState')
        return self


class QueryEdgeDriverVersionResponseDataDriverVersionList(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        driver_version: str = None,
        version_state: str = None,
        edge_version: str = None,
        description: str = None,
        source_config: str = None,
        driver_config: str = None,
        container_config: str = None,
        config_check_rule: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        argument: str = None,
    ):
        self.driver_id = driver_id
        self.driver_version = driver_version
        self.version_state = version_state
        self.edge_version = edge_version
        self.description = description
        self.source_config = source_config
        self.driver_config = driver_config
        self.container_config = container_config
        self.config_check_rule = config_check_rule
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.argument = argument

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')
        self.validate_required(self.version_state, 'version_state')
        self.validate_required(self.edge_version, 'edge_version')
        self.validate_required(self.description, 'description')
        self.validate_required(self.source_config, 'source_config')
        self.validate_required(self.driver_config, 'driver_config')
        self.validate_required(self.container_config, 'container_config')
        self.validate_required(self.config_check_rule, 'config_check_rule')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.argument, 'argument')

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.version_state is not None:
            result['VersionState'] = self.version_state
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('VersionState') is not None:
            self.version_state = m.get('VersionState')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class QueryEdgeDriverVersionResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        driver_version_list: List[QueryEdgeDriverVersionResponseDataDriverVersionList] = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.driver_version_list = driver_version_list

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.driver_version_list, 'driver_version_list')
        if self.driver_version_list:
            for k in self.driver_version_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['DriverVersionList'] = []
        if self.driver_version_list is not None:
            for k in self.driver_version_list:
                result['DriverVersionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.driver_version_list = []
        if m.get('DriverVersionList') is not None:
            for k in m.get('DriverVersionList'):
                temp_model = QueryEdgeDriverVersionResponseDataDriverVersionList()
                self.driver_version_list.append(temp_model.from_map(k))
        return self


class QueryEdgeDriverVersionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryEdgeDriverVersionResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeDriverVersionResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchGetDeviceBindStatusRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.iot_ids = iot_ids

    def validate(self):
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetDeviceBindStatusResponseData(TeaModel):
    def __init__(
        self,
        iot_id: str = None,
        bind_status: int = None,
    ):
        self.iot_id = iot_id
        self.bind_status = bind_status

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.bind_status, 'bind_status')

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.bind_status is not None:
            result['BindStatus'] = self.bind_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('BindStatus') is not None:
            self.bind_status = m.get('BindStatus')
        return self


class BatchGetDeviceBindStatusResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: List[BatchGetDeviceBindStatusResponseData] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchGetDeviceBindStatusResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.current_page = current_page

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(
        self,
        ota_tag_dto: List[ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTagsOtaTagDTO] = None,
    ):
        self.ota_tag_dto = ota_tag_dto

    def validate(self):
        self.validate_required(self.ota_tag_dto, 'ota_tag_dto')
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponseDataSimpleOTAJobInfo(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        product_key: str = None,
        firmware_id: str = None,
        utc_start_time: str = None,
        utc_end_time: str = None,
        job_status: str = None,
        job_type: str = None,
        target_selection: str = None,
        selection_type: str = None,
        tags: ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTags = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.product_key = product_key
        self.firmware_id = firmware_id
        self.utc_start_time = utc_start_time
        self.utc_end_time = utc_end_time
        self.job_status = job_status
        self.job_type = job_type
        self.target_selection = target_selection
        self.selection_type = selection_type
        self.tags = tags

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.utc_start_time, 'utc_start_time')
        self.validate_required(self.utc_end_time, 'utc_end_time')
        self.validate_required(self.job_status, 'job_status')
        self.validate_required(self.job_type, 'job_type')
        self.validate_required(self.target_selection, 'target_selection')
        self.validate_required(self.selection_type, 'selection_type')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByDeviceResponseData(TeaModel):
    def __init__(
        self,
        simple_otajob_info: List[ListOTAJobByDeviceResponseDataSimpleOTAJobInfo] = None,
    ):
        self.simple_otajob_info = simple_otajob_info

    def validate(self):
        self.validate_required(self.simple_otajob_info, 'simple_otajob_info')
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByDeviceResponseDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        data: ListOTAJobByDeviceResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateThingModelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        identifier: str = None,
        thing_model_json: str = None,
        function_block_id: str = None,
        function_block_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.identifier = identifier
        self.thing_model_json = thing_model_json
        self.function_block_id = function_block_id
        self.function_block_name = function_block_name

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        return self


class UpdateThingModelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateThingModelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        thing_model_json: str = None,
        function_block_id: str = None,
        function_block_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.thing_model_json = thing_model_json
        self.function_block_id = function_block_id
        self.function_block_name = function_block_name

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        return self


class CreateThingModelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ListOTATaskByJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        task_status: str = None,
        job_id: str = None,
        current_page: int = None,
        device_names: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.task_status = task_status
        self.job_id = job_id
        self.current_page = current_page
        self.device_names = device_names

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.device_names is not None:
            result['DeviceNames'] = self.device_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DeviceNames') is not None:
            self.device_names = m.get('DeviceNames')
        return self


class ListOTATaskByJobResponseDataSimpleOTATaskInfo(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        utc_modified: str = None,
        product_key: str = None,
        firmware_id: str = None,
        task_status: str = None,
        job_id: str = None,
        product_name: str = None,
        device_name: str = None,
        src_version: str = None,
        dest_version: str = None,
        task_desc: str = None,
        progress: str = None,
        iot_id: str = None,
        utc_create: str = None,
    ):
        self.task_id = task_id
        self.utc_modified = utc_modified
        self.product_key = product_key
        self.firmware_id = firmware_id
        self.task_status = task_status
        self.job_id = job_id
        self.product_name = product_name
        self.device_name = device_name
        self.src_version = src_version
        self.dest_version = dest_version
        self.task_desc = task_desc
        self.progress = progress
        self.iot_id = iot_id
        self.utc_create = utc_create

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.task_status, 'task_status')
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.src_version, 'src_version')
        self.validate_required(self.dest_version, 'dest_version')
        self.validate_required(self.task_desc, 'task_desc')
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.task_desc is not None:
            result['TaskDesc'] = self.task_desc
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('TaskDesc') is not None:
            self.task_desc = m.get('TaskDesc')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class ListOTATaskByJobResponseData(TeaModel):
    def __init__(
        self,
        simple_otatask_info: List[ListOTATaskByJobResponseDataSimpleOTATaskInfo] = None,
    ):
        self.simple_otatask_info = simple_otatask_info

    def validate(self):
        self.validate_required(self.simple_otatask_info, 'simple_otatask_info')
        if self.simple_otatask_info:
            for k in self.simple_otatask_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTATaskInfo'] = []
        if self.simple_otatask_info is not None:
            for k in self.simple_otatask_info:
                result['SimpleOTATaskInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otatask_info = []
        if m.get('SimpleOTATaskInfo') is not None:
            for k in m.get('SimpleOTATaskInfo'):
                temp_model = ListOTATaskByJobResponseDataSimpleOTATaskInfo()
                self.simple_otatask_info.append(temp_model.from_map(k))
        return self


class ListOTATaskByJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        data: ListOTATaskByJobResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTATaskByJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListThingTemplatesRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListThingTemplatesResponseData(TeaModel):
    def __init__(
        self,
        category_key: str = None,
        category_name: str = None,
    ):
        self.category_key = category_key
        self.category_name = category_name

    def validate(self):
        self.validate_required(self.category_key, 'category_key')
        self.validate_required(self.category_name, 'category_name')

    def to_map(self):
        result = dict()
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        return self


class ListThingTemplatesResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: List[ListThingTemplatesResponseData] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListThingTemplatesResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class GetThingTemplateRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        category_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.category_key = category_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        return self


class GetThingTemplateResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        thing_model_json: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.thing_model_json = thing_model_json

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.thing_model_json, 'thing_model_json')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.thing_model_json is not None:
            result['ThingModelJSON'] = self.thing_model_json
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ThingModelJSON') is not None:
            self.thing_model_json = m.get('ThingModelJSON')
        return self


class ListThingModelVersionRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListThingModelVersionResponseDataModelVersions(TeaModel):
    def __init__(
        self,
        model_version: str = None,
        description: str = None,
        gmt_create: int = None,
    ):
        self.model_version = model_version
        self.description = description
        self.gmt_create = gmt_create

    def validate(self):
        self.validate_required(self.model_version, 'model_version')
        self.validate_required(self.description, 'description')
        self.validate_required(self.gmt_create, 'gmt_create')

    def to_map(self):
        result = dict()
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        return self


class ListThingModelVersionResponseData(TeaModel):
    def __init__(
        self,
        model_versions: List[ListThingModelVersionResponseDataModelVersions] = None,
    ):
        self.model_versions = model_versions

    def validate(self):
        self.validate_required(self.model_versions, 'model_versions')
        if self.model_versions:
            for k in self.model_versions:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ModelVersions'] = []
        if self.model_versions is not None:
            for k in self.model_versions:
                result['ModelVersions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.model_versions = []
        if m.get('ModelVersions') is not None:
            for k in m.get('ModelVersions'):
                temp_model = ListThingModelVersionResponseDataModelVersions()
                self.model_versions.append(temp_model.from_map(k))
        return self


class ListThingModelVersionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: ListThingModelVersionResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListThingModelVersionResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ImportThingModelTslRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
        tsl_str: str = None,
        tsl_url: str = None,
        function_block_id: str = None,
        function_block_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key
        self.tsl_str = tsl_str
        self.tsl_url = tsl_url
        self.function_block_id = function_block_id
        self.function_block_name = function_block_name

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_url is not None:
            result['TslUrl'] = self.tsl_url
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUrl') is not None:
            self.tsl_url = m.get('TslUrl')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        return self


class ImportThingModelTslResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class PublishThingModelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
        model_version: str = None,
        description: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key
        self.model_version = model_version
        self.description = description

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class PublishThingModelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CopyThingModelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        source_product_key: str = None,
        target_product_key: str = None,
        source_model_version: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.source_product_key = source_product_key
        self.target_product_key = target_product_key
        self.source_model_version = source_model_version

    def validate(self):
        self.validate_required(self.source_product_key, 'source_product_key')
        self.validate_required(self.target_product_key, 'target_product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.source_product_key is not None:
            result['SourceProductKey'] = self.source_product_key
        if self.target_product_key is not None:
            result['TargetProductKey'] = self.target_product_key
        if self.source_model_version is not None:
            result['SourceModelVersion'] = self.source_model_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SourceProductKey') is not None:
            self.source_product_key = m.get('SourceProductKey')
        if m.get('TargetProductKey') is not None:
            self.target_product_key = m.get('TargetProductKey')
        if m.get('SourceModelVersion') is not None:
            self.source_model_version = m.get('SourceModelVersion')
        return self


class CopyThingModelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class GetThingModelTslRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
        model_version: str = None,
        simple: bool = None,
        function_block_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key
        self.model_version = model_version
        self.simple = simple
        self.function_block_id = function_block_id

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.simple is not None:
            result['Simple'] = self.simple
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class GetThingModelTslResponseData(TeaModel):
    def __init__(
        self,
        tsl_str: str = None,
        tsl_uri: str = None,
    ):
        self.tsl_str = tsl_str
        self.tsl_uri = tsl_uri

    def validate(self):
        self.validate_required(self.tsl_str, 'tsl_str')
        self.validate_required(self.tsl_uri, 'tsl_uri')

    def to_map(self):
        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetThingModelTslResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryThingModelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
        model_version: str = None,
        function_block_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key
        self.model_version = model_version
        self.function_block_id = function_block_id

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class QueryThingModelResponseData(TeaModel):
    def __init__(
        self,
        thing_model_json: str = None,
    ):
        self.thing_model_json = thing_model_json

    def validate(self):
        self.validate_required(self.thing_model_json, 'thing_model_json')

    def to_map(self):
        result = dict()
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        return self


class QueryThingModelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        product_key: str = None,
        data: QueryThingModelResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.product_key = product_key
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Data') is not None:
            temp_model = QueryThingModelResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteThingModelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
        property_identifier: List[str] = None,
        service_identifier: List[str] = None,
        event_identifier: List[str] = None,
        function_block_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key
        self.property_identifier = property_identifier
        self.service_identifier = service_identifier
        self.event_identifier = event_identifier
        self.function_block_id = function_block_id

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.property_identifier is not None:
            result['PropertyIdentifier'] = self.property_identifier
        if self.service_identifier is not None:
            result['ServiceIdentifier'] = self.service_identifier
        if self.event_identifier is not None:
            result['EventIdentifier'] = self.event_identifier
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PropertyIdentifier') is not None:
            self.property_identifier = m.get('PropertyIdentifier')
        if m.get('ServiceIdentifier') is not None:
            self.service_identifier = m.get('ServiceIdentifier')
        if m.get('EventIdentifier') is not None:
            self.event_identifier = m.get('EventIdentifier')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class DeleteThingModelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class UpdateProductFilterConfigRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        property_timestamp_filter: bool = None,
        property_value_filter: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.property_timestamp_filter = property_timestamp_filter
        self.property_value_filter = property_value_filter

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.property_timestamp_filter, 'property_timestamp_filter')
        self.validate_required(self.property_value_filter, 'property_value_filter')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.property_timestamp_filter is not None:
            result['PropertyTimestampFilter'] = self.property_timestamp_filter
        if self.property_value_filter is not None:
            result['PropertyValueFilter'] = self.property_value_filter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PropertyTimestampFilter') is not None:
            self.property_timestamp_filter = m.get('PropertyTimestampFilter')
        if m.get('PropertyValueFilter') is not None:
            self.property_value_filter = m.get('PropertyValueFilter')
        return self


class UpdateProductFilterConfigResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CancelOTAStrategyByJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTAStrategyByJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ListOTAJobByFirmwareRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(
        self,
        ota_tag_dto: List[ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTagsOtaTagDTO] = None,
    ):
        self.ota_tag_dto = ota_tag_dto

    def validate(self):
        self.validate_required(self.ota_tag_dto, 'ota_tag_dto')
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByFirmwareResponseDataSimpleOTAJobInfo(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        product_key: str = None,
        firmware_id: str = None,
        utc_start_time: str = None,
        utc_end_time: str = None,
        job_status: str = None,
        job_type: str = None,
        target_selection: str = None,
        selection_type: str = None,
        tags: ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTags = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.product_key = product_key
        self.firmware_id = firmware_id
        self.utc_start_time = utc_start_time
        self.utc_end_time = utc_end_time
        self.job_status = job_status
        self.job_type = job_type
        self.target_selection = target_selection
        self.selection_type = selection_type
        self.tags = tags

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.utc_start_time, 'utc_start_time')
        self.validate_required(self.utc_end_time, 'utc_end_time')
        self.validate_required(self.job_status, 'job_status')
        self.validate_required(self.job_type, 'job_type')
        self.validate_required(self.target_selection, 'target_selection')
        self.validate_required(self.selection_type, 'selection_type')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByFirmwareResponseData(TeaModel):
    def __init__(
        self,
        simple_otajob_info: List[ListOTAJobByFirmwareResponseDataSimpleOTAJobInfo] = None,
    ):
        self.simple_otajob_info = simple_otajob_info

    def validate(self):
        self.validate_required(self.simple_otajob_info, 'simple_otajob_info')
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByFirmwareResponseDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByFirmwareResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        data: ListOTAJobByFirmwareResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByFirmwareResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAFirmwareRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        page_size: int = None,
        current_page: int = None,
        dest_version: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.page_size = page_size
        self.current_page = current_page
        self.dest_version = dest_version

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        return self


class ListOTAFirmwareResponseFirmwareInfoSimpleFirmwareInfo(TeaModel):
    def __init__(
        self,
        firmware_name: str = None,
        firmware_id: str = None,
        src_version: str = None,
        dest_version: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        status: int = None,
        firmware_desc: str = None,
        firmware_sign: str = None,
        firmware_size: int = None,
        firmware_url: str = None,
        product_key: str = None,
        sign_method: str = None,
        product_name: str = None,
        type: int = None,
        module_name: str = None,
    ):
        self.firmware_name = firmware_name
        self.firmware_id = firmware_id
        self.src_version = src_version
        self.dest_version = dest_version
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.status = status
        self.firmware_desc = firmware_desc
        self.firmware_sign = firmware_sign
        self.firmware_size = firmware_size
        self.firmware_url = firmware_url
        self.product_key = product_key
        self.sign_method = sign_method
        self.product_name = product_name
        self.type = type
        self.module_name = module_name

    def validate(self):
        self.validate_required(self.firmware_name, 'firmware_name')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.src_version, 'src_version')
        self.validate_required(self.dest_version, 'dest_version')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.status, 'status')
        self.validate_required(self.firmware_desc, 'firmware_desc')
        self.validate_required(self.firmware_sign, 'firmware_sign')
        self.validate_required(self.firmware_size, 'firmware_size')
        self.validate_required(self.firmware_url, 'firmware_url')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.sign_method, 'sign_method')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.module_name, 'module_name')

    def to_map(self):
        result = dict()
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.type is not None:
            result['Type'] = self.type
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class ListOTAFirmwareResponseFirmwareInfo(TeaModel):
    def __init__(
        self,
        simple_firmware_info: List[ListOTAFirmwareResponseFirmwareInfoSimpleFirmwareInfo] = None,
    ):
        self.simple_firmware_info = simple_firmware_info

    def validate(self):
        self.validate_required(self.simple_firmware_info, 'simple_firmware_info')
        if self.simple_firmware_info:
            for k in self.simple_firmware_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleFirmwareInfo'] = []
        if self.simple_firmware_info is not None:
            for k in self.simple_firmware_info:
                result['SimpleFirmwareInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_firmware_info = []
        if m.get('SimpleFirmwareInfo') is not None:
            for k in m.get('SimpleFirmwareInfo'):
                temp_model = ListOTAFirmwareResponseFirmwareInfoSimpleFirmwareInfo()
                self.simple_firmware_info.append(temp_model.from_map(k))
        return self


class ListOTAFirmwareResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        firmware_info: ListOTAFirmwareResponseFirmwareInfo = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.firmware_info = firmware_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.firmware_info, 'firmware_info')
        if self.firmware_info:
            self.firmware_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.firmware_info is not None:
            result['FirmwareInfo'] = self.firmware_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FirmwareInfo') is not None:
            temp_model = ListOTAFirmwareResponseFirmwareInfo()
            self.firmware_info = temp_model.from_map(m['FirmwareInfo'])
        return self


class CancelOTATaskByJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        job_id: str = None,
        cancel_scheduled_task: bool = None,
        cancel_queued_task: bool = None,
        cancel_in_progress_task: bool = None,
        cancel_notified_task: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id
        self.cancel_scheduled_task = cancel_scheduled_task
        self.cancel_queued_task = cancel_queued_task
        self.cancel_in_progress_task = cancel_in_progress_task
        self.cancel_notified_task = cancel_notified_task

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.cancel_scheduled_task is not None:
            result['CancelScheduledTask'] = self.cancel_scheduled_task
        if self.cancel_queued_task is not None:
            result['CancelQueuedTask'] = self.cancel_queued_task
        if self.cancel_in_progress_task is not None:
            result['CancelInProgressTask'] = self.cancel_in_progress_task
        if self.cancel_notified_task is not None:
            result['CancelNotifiedTask'] = self.cancel_notified_task
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CancelScheduledTask') is not None:
            self.cancel_scheduled_task = m.get('CancelScheduledTask')
        if m.get('CancelQueuedTask') is not None:
            self.cancel_queued_task = m.get('CancelQueuedTask')
        if m.get('CancelInProgressTask') is not None:
            self.cancel_in_progress_task = m.get('CancelInProgressTask')
        if m.get('CancelNotifiedTask') is not None:
            self.cancel_notified_task = m.get('CancelNotifiedTask')
        return self


class CancelOTATaskByJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateDeviceDistributeJobRequestTargetInstanceConfig(TeaModel):
    def __init__(
        self,
        target_instance_id: str = None,
    ):
        self.target_instance_id = target_instance_id

    def validate(self):
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class CreateDeviceDistributeJobRequest(TeaModel):
    def __init__(
        self,
        device_name: List[str] = None,
        source_instance_id: str = None,
        product_key: str = None,
        target_uid: str = None,
        target_aliyun_id: str = None,
        target_instance_config: List[CreateDeviceDistributeJobRequestTargetInstanceConfig] = None,
        strategy: int = None,
    ):
        self.device_name = device_name
        self.source_instance_id = source_instance_id
        self.product_key = product_key
        self.target_uid = target_uid
        self.target_aliyun_id = target_aliyun_id
        self.target_instance_config = target_instance_config
        self.strategy = strategy

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.target_instance_config, 'target_instance_config')
        if self.target_instance_config:
            for k in self.target_instance_config:
                if k:
                    k.validate()
        self.validate_required(self.strategy, 'strategy')

    def to_map(self):
        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        result['TargetInstanceConfig'] = []
        if self.target_instance_config is not None:
            for k in self.target_instance_config:
                result['TargetInstanceConfig'].append(k.to_map() if k else None)
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        self.target_instance_config = []
        if m.get('TargetInstanceConfig') is not None:
            for k in m.get('TargetInstanceConfig'):
                temp_model = CreateDeviceDistributeJobRequestTargetInstanceConfig()
                self.target_instance_config.append(temp_model.from_map(k))
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        return self


class CreateDeviceDistributeJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryDeviceDistributeDetailRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryDeviceDistributeDetailResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        file: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.file = file

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.file, 'file')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.file is not None:
            result['File'] = self.file
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('File') is not None:
            self.file = m.get('File')
        return self


class ListDeviceDistributeJobRequest(TeaModel):
    def __init__(
        self,
        target_uid: str = None,
        current_page: int = None,
        page_size: int = None,
        status: int = None,
    ):
        self.target_uid = target_uid
        self.current_page = current_page
        self.page_size = page_size
        self.status = status

    def validate(self):
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs(TeaModel):
    def __init__(
        self,
        target_instance_id: str = None,
    ):
        self.target_instance_id = target_instance_id

    def validate(self):
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigs(TeaModel):
    def __init__(
        self,
        target_instance_configs: List[ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs] = None,
    ):
        self.target_instance_configs = target_instance_configs

    def validate(self):
        self.validate_required(self.target_instance_configs, 'target_instance_configs')
        if self.target_instance_configs:
            for k in self.target_instance_configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['targetInstanceConfigs'] = []
        if self.target_instance_configs is not None:
            for k in self.target_instance_configs:
                result['targetInstanceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.target_instance_configs = []
        if m.get('targetInstanceConfigs') is not None:
            for k in m.get('targetInstanceConfigs'):
                temp_model = ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs()
                self.target_instance_configs.append(temp_model.from_map(k))
        return self


class ListDeviceDistributeJobResponseDataJobInfoItems(TeaModel):
    def __init__(
        self,
        gmt_create: int = None,
        source_uid: str = None,
        target_uid: str = None,
        job_id: str = None,
        source_instance_id: str = None,
        product_key: str = None,
        total: int = None,
        status: int = None,
        strategy: int = None,
        target_instance_configs: ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigs = None,
    ):
        self.gmt_create = gmt_create
        self.source_uid = source_uid
        self.target_uid = target_uid
        self.job_id = job_id
        self.source_instance_id = source_instance_id
        self.product_key = product_key
        self.total = total
        self.status = status
        self.strategy = strategy
        self.target_instance_configs = target_instance_configs

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.source_uid, 'source_uid')
        self.validate_required(self.target_uid, 'target_uid')
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.total, 'total')
        self.validate_required(self.status, 'status')
        self.validate_required(self.strategy, 'strategy')
        self.validate_required(self.target_instance_configs, 'target_instance_configs')
        if self.target_instance_configs:
            self.target_instance_configs.validate()

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.total is not None:
            result['Total'] = self.total
        if self.status is not None:
            result['Status'] = self.status
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.target_instance_configs is not None:
            result['TargetInstanceConfigs'] = self.target_instance_configs.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('TargetInstanceConfigs') is not None:
            temp_model = ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigs()
            self.target_instance_configs = temp_model.from_map(m['TargetInstanceConfigs'])
        return self


class ListDeviceDistributeJobResponseDataJobInfo(TeaModel):
    def __init__(
        self,
        items: List[ListDeviceDistributeJobResponseDataJobInfoItems] = None,
    ):
        self.items = items

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDeviceDistributeJobResponseDataJobInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDeviceDistributeJobResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        job_info: ListDeviceDistributeJobResponseDataJobInfo = None,
    ):
        self.total = total
        self.job_info = job_info

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.job_info, 'job_info')
        if self.job_info:
            self.job_info.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.job_info is not None:
            result['JobInfo'] = self.job_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('JobInfo') is not None:
            temp_model = ListDeviceDistributeJobResponseDataJobInfo()
            self.job_info = temp_model.from_map(m['JobInfo'])
        return self


class ListDeviceDistributeJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: ListDeviceDistributeJobResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListDeviceDistributeJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceDistributeJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryDeviceDistributeJobResponseDataTargetInstanceConfigsTargetInstanceConfigs(TeaModel):
    def __init__(
        self,
        target_instance_id: str = None,
    ):
        self.target_instance_id = target_instance_id

    def validate(self):
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class QueryDeviceDistributeJobResponseDataTargetInstanceConfigs(TeaModel):
    def __init__(
        self,
        target_instance_configs: List[QueryDeviceDistributeJobResponseDataTargetInstanceConfigsTargetInstanceConfigs] = None,
    ):
        self.target_instance_configs = target_instance_configs

    def validate(self):
        self.validate_required(self.target_instance_configs, 'target_instance_configs')
        if self.target_instance_configs:
            for k in self.target_instance_configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['targetInstanceConfigs'] = []
        if self.target_instance_configs is not None:
            for k in self.target_instance_configs:
                result['targetInstanceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.target_instance_configs = []
        if m.get('targetInstanceConfigs') is not None:
            for k in m.get('targetInstanceConfigs'):
                temp_model = QueryDeviceDistributeJobResponseDataTargetInstanceConfigsTargetInstanceConfigs()
                self.target_instance_configs.append(temp_model.from_map(k))
        return self


class QueryDeviceDistributeJobResponseData(TeaModel):
    def __init__(
        self,
        source_uid: str = None,
        target_uid: str = None,
        source_instance_id: str = None,
        job_id: str = None,
        product_key: str = None,
        total: int = None,
        status: int = None,
        gmt_create: int = None,
        strategy: int = None,
        target_instance_configs: QueryDeviceDistributeJobResponseDataTargetInstanceConfigs = None,
    ):
        self.source_uid = source_uid
        self.target_uid = target_uid
        self.source_instance_id = source_instance_id
        self.job_id = job_id
        self.product_key = product_key
        self.total = total
        self.status = status
        self.gmt_create = gmt_create
        self.strategy = strategy
        self.target_instance_configs = target_instance_configs

    def validate(self):
        self.validate_required(self.source_uid, 'source_uid')
        self.validate_required(self.target_uid, 'target_uid')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.total, 'total')
        self.validate_required(self.status, 'status')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.strategy, 'strategy')
        self.validate_required(self.target_instance_configs, 'target_instance_configs')
        if self.target_instance_configs:
            self.target_instance_configs.validate()

    def to_map(self):
        result = dict()
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.total is not None:
            result['Total'] = self.total
        if self.status is not None:
            result['Status'] = self.status
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.target_instance_configs is not None:
            result['TargetInstanceConfigs'] = self.target_instance_configs.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('TargetInstanceConfigs') is not None:
            temp_model = QueryDeviceDistributeJobResponseDataTargetInstanceConfigs()
            self.target_instance_configs = temp_model.from_map(m['TargetInstanceConfigs'])
        return self


class QueryDeviceDistributeJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceDistributeJobResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceDistributeJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteDeviceDistributeJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteDeviceDistributeJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryDeviceByStatusRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        status: int = None,
        current_page: int = None,
        page_size: int = None,
        resource_group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.status = status
        self.current_page = current_page
        self.page_size = page_size
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.status is not None:
            result['Status'] = self.status
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class QueryDeviceByStatusResponseDataSimpleDeviceInfo(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        status: str = None,
        iot_id: str = None,
        nickname: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        device_secret: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.status = status
        self.iot_id = iot_id
        self.nickname = nickname
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.device_secret = device_secret

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.status, 'status')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.nickname, 'nickname')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.device_secret, 'device_secret')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.status is not None:
            result['Status'] = self.status
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        return self


class QueryDeviceByStatusResponseData(TeaModel):
    def __init__(
        self,
        simple_device_info: List[QueryDeviceByStatusResponseDataSimpleDeviceInfo] = None,
    ):
        self.simple_device_info = simple_device_info

    def validate(self):
        self.validate_required(self.simple_device_info, 'simple_device_info')
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceByStatusResponseDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceByStatusResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        page: int = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        data: QueryDeviceByStatusResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.page = page
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceByStatusResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GenerateOTAUploadURLRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        file_suffix: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.file_suffix = file_suffix

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        return self


class GenerateOTAUploadURLResponseData(TeaModel):
    def __init__(
        self,
        key: str = None,
        host: str = None,
        policy: str = None,
        ossaccess_key_id: str = None,
        signature: str = None,
        firmware_url: str = None,
        utc_create: str = None,
        object_storage: str = None,
    ):
        self.key = key
        self.host = host
        self.policy = policy
        self.ossaccess_key_id = ossaccess_key_id
        self.signature = signature
        self.firmware_url = firmware_url
        self.utc_create = utc_create
        self.object_storage = object_storage

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.host, 'host')
        self.validate_required(self.policy, 'policy')
        self.validate_required(self.ossaccess_key_id, 'ossaccess_key_id')
        self.validate_required(self.signature, 'signature')
        self.validate_required(self.firmware_url, 'firmware_url')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.object_storage, 'object_storage')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.ossaccess_key_id is not None:
            result['OSSAccessKeyId'] = self.ossaccess_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('OSSAccessKeyId') is not None:
            self.ossaccess_key_id = m.get('OSSAccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateOTAUploadURLResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GenerateOTAUploadURLResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GenerateOTAUploadURLResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryProductCertInfoRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class QueryProductCertInfoResponseProductCertInfo(TeaModel):
    def __init__(
        self,
        issue_model: int = None,
    ):
        self.issue_model = issue_model

    def validate(self):
        self.validate_required(self.issue_model, 'issue_model')

    def to_map(self):
        result = dict()
        if self.issue_model is not None:
            result['IssueModel'] = self.issue_model
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IssueModel') is not None:
            self.issue_model = m.get('IssueModel')
        return self


class QueryProductCertInfoResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        product_cert_info: QueryProductCertInfoResponseProductCertInfo = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.product_cert_info = product_cert_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.product_cert_info, 'product_cert_info')
        if self.product_cert_info:
            self.product_cert_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_cert_info is not None:
            result['ProductCertInfo'] = self.product_cert_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductCertInfo') is not None:
            temp_model = QueryProductCertInfoResponseProductCertInfo()
            self.product_cert_info = temp_model.from_map(m['ProductCertInfo'])
        return self


class SetProductCertInfoRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        issue_model: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.issue_model = issue_model

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.issue_model, 'issue_model')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.issue_model is not None:
            result['IssueModel'] = self.issue_model
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('IssueModel') is not None:
            self.issue_model = m.get('IssueModel')
        return self


class SetProductCertInfoResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_data_flag: bool = None,
        device_life_cycle_flag: bool = None,
        device_status_change_flag: bool = None,
        device_topo_life_cycle_flag: bool = None,
        found_device_list_flag: bool = None,
        mns_configuration: str = None,
        type: str = None,
        consumer_group_ids: List[str] = None,
        ota_event_flag: bool = None,
        thing_history_flag: bool = None,
        device_tag_flag: bool = None,
        ota_version_flag: bool = None,
        ota_job_flag: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_data_flag = device_data_flag
        self.device_life_cycle_flag = device_life_cycle_flag
        self.device_status_change_flag = device_status_change_flag
        self.device_topo_life_cycle_flag = device_topo_life_cycle_flag
        self.found_device_list_flag = found_device_list_flag
        self.mns_configuration = mns_configuration
        self.type = type
        self.consumer_group_ids = consumer_group_ids
        self.ota_event_flag = ota_event_flag
        self.thing_history_flag = thing_history_flag
        self.device_tag_flag = device_tag_flag
        self.ota_version_flag = ota_version_flag
        self.ota_job_flag = ota_job_flag

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_data_flag is not None:
            result['DeviceDataFlag'] = self.device_data_flag
        if self.device_life_cycle_flag is not None:
            result['DeviceLifeCycleFlag'] = self.device_life_cycle_flag
        if self.device_status_change_flag is not None:
            result['DeviceStatusChangeFlag'] = self.device_status_change_flag
        if self.device_topo_life_cycle_flag is not None:
            result['DeviceTopoLifeCycleFlag'] = self.device_topo_life_cycle_flag
        if self.found_device_list_flag is not None:
            result['FoundDeviceListFlag'] = self.found_device_list_flag
        if self.mns_configuration is not None:
            result['MnsConfiguration'] = self.mns_configuration
        if self.type is not None:
            result['Type'] = self.type
        if self.consumer_group_ids is not None:
            result['ConsumerGroupIds'] = self.consumer_group_ids
        if self.ota_event_flag is not None:
            result['OtaEventFlag'] = self.ota_event_flag
        if self.thing_history_flag is not None:
            result['ThingHistoryFlag'] = self.thing_history_flag
        if self.device_tag_flag is not None:
            result['DeviceTagFlag'] = self.device_tag_flag
        if self.ota_version_flag is not None:
            result['OtaVersionFlag'] = self.ota_version_flag
        if self.ota_job_flag is not None:
            result['OtaJobFlag'] = self.ota_job_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceDataFlag') is not None:
            self.device_data_flag = m.get('DeviceDataFlag')
        if m.get('DeviceLifeCycleFlag') is not None:
            self.device_life_cycle_flag = m.get('DeviceLifeCycleFlag')
        if m.get('DeviceStatusChangeFlag') is not None:
            self.device_status_change_flag = m.get('DeviceStatusChangeFlag')
        if m.get('DeviceTopoLifeCycleFlag') is not None:
            self.device_topo_life_cycle_flag = m.get('DeviceTopoLifeCycleFlag')
        if m.get('FoundDeviceListFlag') is not None:
            self.found_device_list_flag = m.get('FoundDeviceListFlag')
        if m.get('MnsConfiguration') is not None:
            self.mns_configuration = m.get('MnsConfiguration')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ConsumerGroupIds') is not None:
            self.consumer_group_ids = m.get('ConsumerGroupIds')
        if m.get('OtaEventFlag') is not None:
            self.ota_event_flag = m.get('OtaEventFlag')
        if m.get('ThingHistoryFlag') is not None:
            self.thing_history_flag = m.get('ThingHistoryFlag')
        if m.get('DeviceTagFlag') is not None:
            self.device_tag_flag = m.get('DeviceTagFlag')
        if m.get('OtaVersionFlag') is not None:
            self.ota_version_flag = m.get('OtaVersionFlag')
        if m.get('OtaJobFlag') is not None:
            self.ota_job_flag = m.get('OtaJobFlag')
        return self


class CreateSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        type: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.type = type

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryConsumerGroupStatusRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryConsumerGroupStatusResponseClientConnectionStatusListConsumerGroupClientConnectionInfo(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        client_ip_port: str = None,
        online_time: int = None,
    ):
        self.client_id = client_id
        self.client_ip_port = client_ip_port
        self.online_time = online_time

    def validate(self):
        self.validate_required(self.client_id, 'client_id')
        self.validate_required(self.client_ip_port, 'client_ip_port')
        self.validate_required(self.online_time, 'online_time')

    def to_map(self):
        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_ip_port is not None:
            result['ClientIpPort'] = self.client_ip_port
        if self.online_time is not None:
            result['OnlineTime'] = self.online_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientIpPort') is not None:
            self.client_ip_port = m.get('ClientIpPort')
        if m.get('OnlineTime') is not None:
            self.online_time = m.get('OnlineTime')
        return self


class QueryConsumerGroupStatusResponseClientConnectionStatusList(TeaModel):
    def __init__(
        self,
        consumer_group_client_connection_info: List[QueryConsumerGroupStatusResponseClientConnectionStatusListConsumerGroupClientConnectionInfo] = None,
    ):
        self.consumer_group_client_connection_info = consumer_group_client_connection_info

    def validate(self):
        self.validate_required(self.consumer_group_client_connection_info, 'consumer_group_client_connection_info')
        if self.consumer_group_client_connection_info:
            for k in self.consumer_group_client_connection_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ConsumerGroupClientConnectionInfo'] = []
        if self.consumer_group_client_connection_info is not None:
            for k in self.consumer_group_client_connection_info:
                result['ConsumerGroupClientConnectionInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.consumer_group_client_connection_info = []
        if m.get('ConsumerGroupClientConnectionInfo') is not None:
            for k in m.get('ConsumerGroupClientConnectionInfo'):
                temp_model = QueryConsumerGroupStatusResponseClientConnectionStatusListConsumerGroupClientConnectionInfo()
                self.consumer_group_client_connection_info.append(temp_model.from_map(k))
        return self


class QueryConsumerGroupStatusResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        accumulation_count: int = None,
        consumer_speed: int = None,
        last_consumer_time: str = None,
        code: str = None,
        client_connection_status_list: QueryConsumerGroupStatusResponseClientConnectionStatusList = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.accumulation_count = accumulation_count
        self.consumer_speed = consumer_speed
        self.last_consumer_time = last_consumer_time
        self.code = code
        self.client_connection_status_list = client_connection_status_list

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.accumulation_count, 'accumulation_count')
        self.validate_required(self.consumer_speed, 'consumer_speed')
        self.validate_required(self.last_consumer_time, 'last_consumer_time')
        self.validate_required(self.code, 'code')
        self.validate_required(self.client_connection_status_list, 'client_connection_status_list')
        if self.client_connection_status_list:
            self.client_connection_status_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.accumulation_count is not None:
            result['AccumulationCount'] = self.accumulation_count
        if self.consumer_speed is not None:
            result['ConsumerSpeed'] = self.consumer_speed
        if self.last_consumer_time is not None:
            result['LastConsumerTime'] = self.last_consumer_time
        if self.code is not None:
            result['Code'] = self.code
        if self.client_connection_status_list is not None:
            result['ClientConnectionStatusList'] = self.client_connection_status_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('AccumulationCount') is not None:
            self.accumulation_count = m.get('AccumulationCount')
        if m.get('ConsumerSpeed') is not None:
            self.consumer_speed = m.get('ConsumerSpeed')
        if m.get('LastConsumerTime') is not None:
            self.last_consumer_time = m.get('LastConsumerTime')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ClientConnectionStatusList') is not None:
            temp_model = QueryConsumerGroupStatusResponseClientConnectionStatusList()
            self.client_connection_status_list = temp_model.from_map(m['ClientConnectionStatusList'])
        return self


class DeleteConsumerGroupRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class DeleteConsumerGroupResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class QueryConsumerGroupListRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        current_page: int = None,
        fuzzy: bool = None,
        group_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.current_page = current_page
        self.fuzzy = fuzzy
        self.group_name = group_name

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.fuzzy is not None:
            result['Fuzzy'] = self.fuzzy
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Fuzzy') is not None:
            self.fuzzy = m.get('Fuzzy')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class QueryConsumerGroupListResponseDataConsumerGroupDTO(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
        create_time: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name
        self.create_time = create_time

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.create_time, 'create_time')

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryConsumerGroupListResponseData(TeaModel):
    def __init__(
        self,
        consumer_group_dto: List[QueryConsumerGroupListResponseDataConsumerGroupDTO] = None,
    ):
        self.consumer_group_dto = consumer_group_dto

    def validate(self):
        self.validate_required(self.consumer_group_dto, 'consumer_group_dto')
        if self.consumer_group_dto:
            for k in self.consumer_group_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ConsumerGroupDTO'] = []
        if self.consumer_group_dto is not None:
            for k in self.consumer_group_dto:
                result['ConsumerGroupDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.consumer_group_dto = []
        if m.get('ConsumerGroupDTO') is not None:
            for k in m.get('ConsumerGroupDTO'):
                temp_model = QueryConsumerGroupListResponseDataConsumerGroupDTO()
                self.consumer_group_dto.append(temp_model.from_map(k))
        return self


class QueryConsumerGroupListResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        current_page: int = None,
        code: str = None,
        data: QueryConsumerGroupListResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.current_page = current_page
        self.code = code
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.total, 'total')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryConsumerGroupListResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryConsumerGroupByGroupIdRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryConsumerGroupByGroupIdResponseData(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
        create_time: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name
        self.create_time = create_time

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.create_time, 'create_time')

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryConsumerGroupByGroupIdResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: QueryConsumerGroupByGroupIdResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryConsumerGroupByGroupIdResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateConsumerGroupRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_name = group_name

    def validate(self):
        self.validate_required(self.group_name, 'group_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateConsumerGroupResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        group_id: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.group_id = group_id
        self.code = code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class CreateOTADynamicUpgradeJobRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTADynamicUpgradeJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
        product_key: str = None,
        src_version: List[str] = None,
        retry_interval: int = None,
        retry_count: int = None,
        timeout_in_minutes: int = None,
        maximum_per_minute: int = None,
        overwrite_mode: int = None,
        dynamic_mode: int = None,
        tag: List[CreateOTADynamicUpgradeJobRequestTag] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.product_key = product_key
        self.src_version = src_version
        self.retry_interval = retry_interval
        self.retry_count = retry_count
        self.timeout_in_minutes = timeout_in_minutes
        self.maximum_per_minute = maximum_per_minute
        self.overwrite_mode = overwrite_mode
        self.dynamic_mode = dynamic_mode
        self.tag = tag

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.product_key, 'product_key')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.dynamic_mode is not None:
            result['DynamicMode'] = self.dynamic_mode
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('DynamicMode') is not None:
            self.dynamic_mode = m.get('DynamicMode')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTADynamicUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateOTADynamicUpgradeJobResponseData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTADynamicUpgradeJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateOTADynamicUpgradeJobResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAStaticUpgradeJobRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTAStaticUpgradeJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
        product_key: str = None,
        target_selection: str = None,
        src_version: List[str] = None,
        schedule_time: int = None,
        retry_interval: int = None,
        retry_count: int = None,
        timeout_in_minutes: int = None,
        maximum_per_minute: int = None,
        gray_percent: str = None,
        target_device_name: List[str] = None,
        schedule_finish_time: int = None,
        overwrite_mode: int = None,
        tag: List[CreateOTAStaticUpgradeJobRequestTag] = None,
        dn_list_file_url: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.product_key = product_key
        self.target_selection = target_selection
        self.src_version = src_version
        self.schedule_time = schedule_time
        self.retry_interval = retry_interval
        self.retry_count = retry_count
        self.timeout_in_minutes = timeout_in_minutes
        self.maximum_per_minute = maximum_per_minute
        self.gray_percent = gray_percent
        self.target_device_name = target_device_name
        self.schedule_finish_time = schedule_finish_time
        self.overwrite_mode = overwrite_mode
        self.tag = tag
        self.dn_list_file_url = dn_list_file_url

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.target_selection, 'target_selection')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.gray_percent is not None:
            result['GrayPercent'] = self.gray_percent
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        if self.schedule_finish_time is not None:
            result['ScheduleFinishTime'] = self.schedule_finish_time
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.dn_list_file_url is not None:
            result['DnListFileUrl'] = self.dn_list_file_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('GrayPercent') is not None:
            self.gray_percent = m.get('GrayPercent')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        if m.get('ScheduleFinishTime') is not None:
            self.schedule_finish_time = m.get('ScheduleFinishTime')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTAStaticUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('DnListFileUrl') is not None:
            self.dn_list_file_url = m.get('DnListFileUrl')
        return self


class CreateOTAStaticUpgradeJobResponseData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAStaticUpgradeJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateOTAStaticUpgradeJobResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAFirmwareRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_name: str = None,
        dest_version: str = None,
        firmware_url: str = None,
        firmware_sign: str = None,
        sign_method: str = None,
        firmware_size: int = None,
        product_key: str = None,
        firmware_desc: str = None,
        type: int = None,
        src_version: str = None,
        module_name: str = None,
        need_to_verify: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_name = firmware_name
        self.dest_version = dest_version
        self.firmware_url = firmware_url
        self.firmware_sign = firmware_sign
        self.sign_method = sign_method
        self.firmware_size = firmware_size
        self.product_key = product_key
        self.firmware_desc = firmware_desc
        self.type = type
        self.src_version = src_version
        self.module_name = module_name
        self.need_to_verify = need_to_verify

    def validate(self):
        self.validate_required(self.firmware_name, 'firmware_name')
        self.validate_required(self.dest_version, 'dest_version')
        self.validate_required(self.firmware_url, 'firmware_url')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.type is not None:
            result['Type'] = self.type
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.need_to_verify is not None:
            result['NeedToVerify'] = self.need_to_verify
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('NeedToVerify') is not None:
            self.need_to_verify = m.get('NeedToVerify')
        return self


class CreateOTAFirmwareResponseData(TeaModel):
    def __init__(
        self,
        firmware_id: str = None,
        utc_create: str = None,
    ):
        self.firmware_id = firmware_id
        self.utc_create = utc_create

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        result = dict()
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAFirmwareResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateOTAFirmwareResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTAFirmwareResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAVerifyJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
        timeout_in_minutes: int = None,
        product_key: str = None,
        target_device_name: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.timeout_in_minutes = timeout_in_minutes
        self.product_key = product_key
        self.target_device_name = target_device_name

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.target_device_name, 'target_device_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        return self


class CreateOTAVerifyJobResponseData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAVerifyJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateOTAVerifyJobResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTAVerifyJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryOTAJobRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryOTAJobResponseDataTagsOtaTagDTO(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class QueryOTAJobResponseDataTags(TeaModel):
    def __init__(
        self,
        ota_tag_dto: List[QueryOTAJobResponseDataTagsOtaTagDTO] = None,
    ):
        self.ota_tag_dto = ota_tag_dto

    def validate(self):
        self.validate_required(self.ota_tag_dto, 'ota_tag_dto')
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = QueryOTAJobResponseDataTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class QueryOTAJobResponseDataSrcVersions(TeaModel):
    def __init__(
        self,
        src_version: List[str] = None,
    ):
        # SrcVersion
        self.src_version = src_version

    def validate(self):
        self.validate_required(self.src_version, 'src_version')

    def to_map(self):
        result = dict()
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        return self


class QueryOTAJobResponseData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        product_key: str = None,
        firmware_id: str = None,
        utc_start_time: str = None,
        utc_end_time: str = None,
        job_status: str = None,
        job_type: str = None,
        job_desc: str = None,
        name: str = None,
        utc_schedule_time: str = None,
        retry_interval: int = None,
        retry_count: int = None,
        timeout_in_minutes: int = None,
        target_selection: str = None,
        selection_type: str = None,
        gray_percent: str = None,
        maximum_per_minute: int = None,
        dest_version: str = None,
        utc_schedule_finish_time: str = None,
        overwrite_mode: int = None,
        dynamic_mode: int = None,
        tags: QueryOTAJobResponseDataTags = None,
        src_versions: QueryOTAJobResponseDataSrcVersions = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.product_key = product_key
        self.firmware_id = firmware_id
        self.utc_start_time = utc_start_time
        self.utc_end_time = utc_end_time
        self.job_status = job_status
        self.job_type = job_type
        self.job_desc = job_desc
        self.name = name
        self.utc_schedule_time = utc_schedule_time
        self.retry_interval = retry_interval
        self.retry_count = retry_count
        self.timeout_in_minutes = timeout_in_minutes
        self.target_selection = target_selection
        self.selection_type = selection_type
        self.gray_percent = gray_percent
        self.maximum_per_minute = maximum_per_minute
        self.dest_version = dest_version
        self.utc_schedule_finish_time = utc_schedule_finish_time
        self.overwrite_mode = overwrite_mode
        self.dynamic_mode = dynamic_mode
        self.tags = tags
        self.src_versions = src_versions

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.utc_start_time, 'utc_start_time')
        self.validate_required(self.utc_end_time, 'utc_end_time')
        self.validate_required(self.job_status, 'job_status')
        self.validate_required(self.job_type, 'job_type')
        self.validate_required(self.job_desc, 'job_desc')
        self.validate_required(self.name, 'name')
        self.validate_required(self.utc_schedule_time, 'utc_schedule_time')
        self.validate_required(self.retry_interval, 'retry_interval')
        self.validate_required(self.retry_count, 'retry_count')
        self.validate_required(self.timeout_in_minutes, 'timeout_in_minutes')
        self.validate_required(self.target_selection, 'target_selection')
        self.validate_required(self.selection_type, 'selection_type')
        self.validate_required(self.gray_percent, 'gray_percent')
        self.validate_required(self.maximum_per_minute, 'maximum_per_minute')
        self.validate_required(self.dest_version, 'dest_version')
        self.validate_required(self.utc_schedule_finish_time, 'utc_schedule_finish_time')
        self.validate_required(self.overwrite_mode, 'overwrite_mode')
        self.validate_required(self.dynamic_mode, 'dynamic_mode')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.src_versions, 'src_versions')
        if self.src_versions:
            self.src_versions.validate()

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.job_desc is not None:
            result['JobDesc'] = self.job_desc
        if self.name is not None:
            result['Name'] = self.name
        if self.utc_schedule_time is not None:
            result['UtcScheduleTime'] = self.utc_schedule_time
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.gray_percent is not None:
            result['GrayPercent'] = self.gray_percent
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.utc_schedule_finish_time is not None:
            result['UtcScheduleFinishTime'] = self.utc_schedule_finish_time
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.dynamic_mode is not None:
            result['DynamicMode'] = self.dynamic_mode
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.src_versions is not None:
            result['SrcVersions'] = self.src_versions.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('JobDesc') is not None:
            self.job_desc = m.get('JobDesc')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UtcScheduleTime') is not None:
            self.utc_schedule_time = m.get('UtcScheduleTime')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('GrayPercent') is not None:
            self.gray_percent = m.get('GrayPercent')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('UtcScheduleFinishTime') is not None:
            self.utc_schedule_finish_time = m.get('UtcScheduleFinishTime')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('DynamicMode') is not None:
            self.dynamic_mode = m.get('DynamicMode')
        if m.get('Tags') is not None:
            temp_model = QueryOTAJobResponseDataTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('SrcVersions') is not None:
            temp_model = QueryOTAJobResponseDataSrcVersions()
            self.src_versions = temp_model.from_map(m['SrcVersions'])
        return self


class QueryOTAJobResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryOTAJobResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryOTAJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CancelOTATaskByDeviceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
        product_key: str = None,
        device_name: List[str] = None,
        job_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.product_key = product_key
        self.device_name = device_name
        self.job_id = job_id

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTATaskByDeviceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteOTAFirmwareRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        return self


class DeleteOTAFirmwareResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryOTAFirmwareRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        firmware_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        return self


class QueryOTAFirmwareResponseFirmwareInfo(TeaModel):
    def __init__(
        self,
        firmware_name: str = None,
        firmware_id: str = None,
        src_version: str = None,
        dest_version: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        status: int = None,
        firmware_desc: str = None,
        firmware_sign: str = None,
        firmware_size: int = None,
        firmware_url: str = None,
        product_key: str = None,
        sign_method: str = None,
        product_name: str = None,
        type: int = None,
        verify_progress: int = None,
        module_name: str = None,
    ):
        self.firmware_name = firmware_name
        self.firmware_id = firmware_id
        self.src_version = src_version
        self.dest_version = dest_version
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.status = status
        self.firmware_desc = firmware_desc
        self.firmware_sign = firmware_sign
        self.firmware_size = firmware_size
        self.firmware_url = firmware_url
        self.product_key = product_key
        self.sign_method = sign_method
        self.product_name = product_name
        self.type = type
        self.verify_progress = verify_progress
        self.module_name = module_name

    def validate(self):
        self.validate_required(self.firmware_name, 'firmware_name')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.src_version, 'src_version')
        self.validate_required(self.dest_version, 'dest_version')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.status, 'status')
        self.validate_required(self.firmware_desc, 'firmware_desc')
        self.validate_required(self.firmware_sign, 'firmware_sign')
        self.validate_required(self.firmware_size, 'firmware_size')
        self.validate_required(self.firmware_url, 'firmware_url')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.sign_method, 'sign_method')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.verify_progress, 'verify_progress')
        self.validate_required(self.module_name, 'module_name')

    def to_map(self):
        result = dict()
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.type is not None:
            result['Type'] = self.type
        if self.verify_progress is not None:
            result['VerifyProgress'] = self.verify_progress
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VerifyProgress') is not None:
            self.verify_progress = m.get('VerifyProgress')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class QueryOTAFirmwareResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        firmware_info: QueryOTAFirmwareResponseFirmwareInfo = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.firmware_info = firmware_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.firmware_info, 'firmware_info')
        if self.firmware_info:
            self.firmware_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.firmware_info is not None:
            result['FirmwareInfo'] = self.firmware_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FirmwareInfo') is not None:
            temp_model = QueryOTAFirmwareResponseFirmwareInfo()
            self.firmware_info = temp_model.from_map(m['FirmwareInfo'])
        return self


class UnbindApplicationFromEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        application_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.application_id = application_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.application_id, 'application_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class UnbindApplicationFromEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BindApplicationToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        application_id: str = None,
        application_version: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.application_id = application_id
        self.application_version = application_version

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.application_id, 'application_id')
        self.validate_required(self.application_version, 'application_version')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_version is not None:
            result['ApplicationVersion'] = self.application_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationVersion') is not None:
            self.application_version = m.get('ApplicationVersion')
        return self


class BindApplicationToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryCertUrlByApplyIdRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        apply_id: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.apply_id = apply_id

    def validate(self):
        self.validate_required(self.apply_id, 'apply_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class QueryCertUrlByApplyIdResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        cert_url: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.cert_url = cert_url

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.cert_url, 'cert_url')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.cert_url is not None:
            result['CertUrl'] = self.cert_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('CertUrl') is not None:
            self.cert_url = m.get('CertUrl')
        return self


class QueryDeviceCertRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class QueryDeviceCertResponseDeviceCertInfo(TeaModel):
    def __init__(
        self,
        status: int = None,
        certificate: str = None,
        private_key: str = None,
        cert_sn: str = None,
    ):
        self.status = status
        self.certificate = certificate
        self.private_key = private_key
        self.cert_sn = cert_sn

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.certificate, 'certificate')
        self.validate_required(self.private_key, 'private_key')
        self.validate_required(self.cert_sn, 'cert_sn')

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.private_key is not None:
            result['PrivateKey'] = self.private_key
        if self.cert_sn is not None:
            result['CertSN'] = self.cert_sn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('PrivateKey') is not None:
            self.private_key = m.get('PrivateKey')
        if m.get('CertSN') is not None:
            self.cert_sn = m.get('CertSN')
        return self


class QueryDeviceCertResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        device_cert_info: QueryDeviceCertResponseDeviceCertInfo = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.device_cert_info = device_cert_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.device_cert_info, 'device_cert_info')
        if self.device_cert_info:
            self.device_cert_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.device_cert_info is not None:
            result['DeviceCertInfo'] = self.device_cert_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DeviceCertInfo') is not None:
            temp_model = QueryDeviceCertResponseDeviceCertInfo()
            self.device_cert_info = temp_model.from_map(m['DeviceCertInfo'])
        return self


class CloseEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CloseEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class UnbindDriverFromEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class UnbindDriverFromEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ReplaceEdgeInstanceGatewayRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        current_gateway_id: str = None,
        new_gateway_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.current_gateway_id = current_gateway_id
        self.new_gateway_id = new_gateway_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.current_gateway_id, 'current_gateway_id')
        self.validate_required(self.new_gateway_id, 'new_gateway_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_gateway_id is not None:
            result['CurrentGatewayId'] = self.current_gateway_id
        if self.new_gateway_id is not None:
            result['NewGatewayId'] = self.new_gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CurrentGatewayId') is not None:
            self.current_gateway_id = m.get('CurrentGatewayId')
        if m.get('NewGatewayId') is not None:
            self.new_gateway_id = m.get('NewGatewayId')
        return self


class ReplaceEdgeInstanceGatewayResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BindDriverToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
        order_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version
        self.order_id = order_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class BindDriverToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchQueryDeviceDetailRequest(TeaModel):
    def __init__(
        self,
        device_name: List[str] = None,
        product_key: str = None,
        iot_instance_id: str = None,
    ):
        self.device_name = device_name
        self.product_key = product_key
        self.iot_instance_id = iot_instance_id

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchQueryDeviceDetailResponseDataData(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        product_name: str = None,
        device_name: str = None,
        nickname: str = None,
        device_secret: str = None,
        iot_id: str = None,
        utc_create: str = None,
        gmt_create: str = None,
        utc_active: str = None,
        gmt_active: str = None,
        status: str = None,
        firmware_version: str = None,
        node_type: int = None,
        region: str = None,
    ):
        self.product_key = product_key
        self.product_name = product_name
        self.device_name = device_name
        self.nickname = nickname
        self.device_secret = device_secret
        self.iot_id = iot_id
        self.utc_create = utc_create
        self.gmt_create = gmt_create
        self.utc_active = utc_active
        self.gmt_active = gmt_active
        self.status = status
        self.firmware_version = firmware_version
        self.node_type = node_type
        self.region = region

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.nickname, 'nickname')
        self.validate_required(self.device_secret, 'device_secret')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.utc_active, 'utc_active')
        self.validate_required(self.gmt_active, 'gmt_active')
        self.validate_required(self.status, 'status')
        self.validate_required(self.firmware_version, 'firmware_version')
        self.validate_required(self.node_type, 'node_type')
        self.validate_required(self.region, 'region')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.status is not None:
            result['Status'] = self.status
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class BatchQueryDeviceDetailResponseData(TeaModel):
    def __init__(
        self,
        data: List[BatchQueryDeviceDetailResponseDataData] = None,
    ):
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchQueryDeviceDetailResponseDataData()
                self.data.append(temp_model.from_map(k))
        return self


class BatchQueryDeviceDetailResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: BatchQueryDeviceDetailResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchQueryDeviceDetailResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        deployment_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.deployment_id = deployment_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.deployment_id, 'deployment_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        return self


class GetEdgeInstanceDeploymentResponseDataTaskListResourceSnapshotList(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        gmt_completed: str = None,
        snapshot_id: str = None,
        resource_type: str = None,
        resource_id: str = None,
        resource_name: str = None,
        operate_type: int = None,
        stage: int = None,
        status: int = None,
        log: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        gmt_completed_timestamp: int = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.gmt_completed = gmt_completed
        self.snapshot_id = snapshot_id
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.resource_name = resource_name
        self.operate_type = operate_type
        self.stage = stage
        self.status = status
        self.log = log
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.gmt_completed_timestamp = gmt_completed_timestamp

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_completed, 'gmt_completed')
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.resource_type, 'resource_type')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.resource_name, 'resource_name')
        self.validate_required(self.operate_type, 'operate_type')
        self.validate_required(self.stage, 'stage')
        self.validate_required(self.status, 'status')
        self.validate_required(self.log, 'log')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.gmt_completed_timestamp, 'gmt_completed_timestamp')

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.log is not None:
            result['Log'] = self.log
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Log') is not None:
            self.log = m.get('Log')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        return self


class GetEdgeInstanceDeploymentResponseDataTaskList(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        gmt_completed: str = None,
        gateway_id: str = None,
        task_id: str = None,
        stage: int = None,
        status: int = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        gmt_completed_timestamp: int = None,
        resource_snapshot_list: List[GetEdgeInstanceDeploymentResponseDataTaskListResourceSnapshotList] = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.gmt_completed = gmt_completed
        self.gateway_id = gateway_id
        self.task_id = task_id
        self.stage = stage
        self.status = status
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.gmt_completed_timestamp = gmt_completed_timestamp
        self.resource_snapshot_list = resource_snapshot_list

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_completed, 'gmt_completed')
        self.validate_required(self.gateway_id, 'gateway_id')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.stage, 'stage')
        self.validate_required(self.status, 'status')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.gmt_completed_timestamp, 'gmt_completed_timestamp')
        self.validate_required(self.resource_snapshot_list, 'resource_snapshot_list')
        if self.resource_snapshot_list:
            for k in self.resource_snapshot_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        result['ResourceSnapshotList'] = []
        if self.resource_snapshot_list is not None:
            for k in self.resource_snapshot_list:
                result['ResourceSnapshotList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        self.resource_snapshot_list = []
        if m.get('ResourceSnapshotList') is not None:
            for k in m.get('ResourceSnapshotList'):
                temp_model = GetEdgeInstanceDeploymentResponseDataTaskListResourceSnapshotList()
                self.resource_snapshot_list.append(temp_model.from_map(k))
        return self


class GetEdgeInstanceDeploymentResponseData(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        gmt_completed: str = None,
        deployment_id: str = None,
        description: str = None,
        status: int = None,
        type: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        gmt_completed_timestamp: int = None,
        task_list: List[GetEdgeInstanceDeploymentResponseDataTaskList] = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.gmt_completed = gmt_completed
        self.deployment_id = deployment_id
        self.description = description
        self.status = status
        self.type = type
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.gmt_completed_timestamp = gmt_completed_timestamp
        self.task_list = task_list

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_completed, 'gmt_completed')
        self.validate_required(self.deployment_id, 'deployment_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.gmt_completed_timestamp, 'gmt_completed_timestamp')
        self.validate_required(self.task_list, 'task_list')
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.description is not None:
            result['Description'] = self.description
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = GetEdgeInstanceDeploymentResponseDataTaskList()
                self.task_list.append(temp_model.from_map(k))
        return self


class GetEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetEdgeInstanceDeploymentResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryTaskRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        task_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class QueryTaskResponseData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        job_name: str = None,
        task_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        progress: str = None,
        utc_queue_time: str = None,
        utc_modified: str = None,
        status_detail: str = None,
        status: str = None,
        message: str = None,
    ):
        self.job_id = job_id
        self.job_name = job_name
        self.task_id = task_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.progress = progress
        self.utc_queue_time = utc_queue_time
        self.utc_modified = utc_modified
        self.status_detail = status_detail
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.utc_queue_time, 'utc_queue_time')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.status_detail, 'status_detail')
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status_detail is not None:
            result['StatusDetail'] = self.status_detail
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('StatusDetail') is not None:
            self.status_detail = m.get('StatusDetail')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class QueryTaskResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryTaskResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryTaskResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDataAPIServiceRequestRequestParam(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        desc: str = None,
        example: str = None,
        required: bool = None,
    ):
        self.name = name
        self.type = type
        self.desc = desc
        self.example = example
        self.required = required

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class CreateDataAPIServiceRequestResponseParam(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        desc: str = None,
        example: str = None,
        required: bool = None,
    ):
        self.name = name
        self.type = type
        self.desc = desc
        self.example = example
        self.required = required

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class CreateDataAPIServiceRequest(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        origin_sql: str = None,
        request_param: List[CreateDataAPIServiceRequestRequestParam] = None,
        desc: str = None,
        response_param: List[CreateDataAPIServiceRequestResponseParam] = None,
        template_sql: str = None,
        api_path: str = None,
        iot_instance_id: str = None,
    ):
        self.display_name = display_name
        self.origin_sql = origin_sql
        self.request_param = request_param
        self.desc = desc
        self.response_param = response_param
        self.template_sql = template_sql
        self.api_path = api_path
        self.iot_instance_id = iot_instance_id

    def validate(self):
        self.validate_required(self.display_name, 'display_name')
        self.validate_required(self.origin_sql, 'origin_sql')
        if self.request_param:
            for k in self.request_param:
                if k:
                    k.validate()
        if self.response_param:
            for k in self.response_param:
                if k:
                    k.validate()
        self.validate_required(self.template_sql, 'template_sql')
        self.validate_required(self.api_path, 'api_path')

    def to_map(self):
        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        result['RequestParam'] = []
        if self.request_param is not None:
            for k in self.request_param:
                result['RequestParam'].append(k.to_map() if k else None)
        if self.desc is not None:
            result['Desc'] = self.desc
        result['ResponseParam'] = []
        if self.response_param is not None:
            for k in self.response_param:
                result['ResponseParam'].append(k.to_map() if k else None)
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        self.request_param = []
        if m.get('RequestParam') is not None:
            for k in m.get('RequestParam'):
                temp_model = CreateDataAPIServiceRequestRequestParam()
                self.request_param.append(temp_model.from_map(k))
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        self.response_param = []
        if m.get('ResponseParam') is not None:
            for k in m.get('ResponseParam'):
                temp_model = CreateDataAPIServiceRequestResponseParam()
                self.response_param.append(temp_model.from_map(k))
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateDataAPIServiceResponseData(TeaModel):
    def __init__(
        self,
        api_srn: str = None,
        create_time: int = None,
        last_update_time: int = None,
    ):
        self.api_srn = api_srn
        self.create_time = create_time
        self.last_update_time = last_update_time

    def validate(self):
        self.validate_required(self.api_srn, 'api_srn')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.last_update_time, 'last_update_time')

    def to_map(self):
        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        return self


class CreateDataAPIServiceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: CreateDataAPIServiceResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateDataAPIServiceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataAPIServiceDetailRequest(TeaModel):
    def __init__(
        self,
        api_srn: str = None,
        iot_instance_id: str = None,
    ):
        self.api_srn = api_srn
        self.iot_instance_id = iot_instance_id

    def validate(self):
        self.validate_required(self.api_srn, 'api_srn')

    def to_map(self):
        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParamsRequestParams(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        desc: str = None,
        example: str = None,
        required: bool = None,
    ):
        self.name = name
        self.type = type
        self.desc = desc
        self.example = example
        self.required = required

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.example, 'example')
        self.validate_required(self.required, 'required')

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParams(TeaModel):
    def __init__(
        self,
        request_params: List[GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParamsRequestParams] = None,
    ):
        self.request_params = request_params

    def validate(self):
        self.validate_required(self.request_params, 'request_params')
        if self.request_params:
            for k in self.request_params:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RequestParams'] = []
        if self.request_params is not None:
            for k in self.request_params:
                result['RequestParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.request_params = []
        if m.get('RequestParams') is not None:
            for k in m.get('RequestParams'):
                temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParamsRequestParams()
                self.request_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParamsResponseParams(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        desc: str = None,
        example: str = None,
        required: bool = None,
    ):
        self.name = name
        self.type = type
        self.desc = desc
        self.example = example
        self.required = required

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.example, 'example')
        self.validate_required(self.required, 'required')

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParams(TeaModel):
    def __init__(
        self,
        response_params: List[GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParamsResponseParams] = None,
    ):
        self.response_params = response_params

    def validate(self):
        self.validate_required(self.response_params, 'response_params')
        if self.response_params:
            for k in self.response_params:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ResponseParams'] = []
        if self.response_params is not None:
            for k in self.response_params:
                result['ResponseParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.response_params = []
        if m.get('ResponseParams') is not None:
            for k in m.get('ResponseParams'):
                temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParamsResponseParams()
                self.response_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTO(TeaModel):
    def __init__(
        self,
        origin_sql: str = None,
        template_sql: str = None,
        request_params: GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParams = None,
        response_params: GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParams = None,
    ):
        self.origin_sql = origin_sql
        self.template_sql = template_sql
        self.request_params = request_params
        self.response_params = response_params

    def validate(self):
        self.validate_required(self.origin_sql, 'origin_sql')
        self.validate_required(self.template_sql, 'template_sql')
        self.validate_required(self.request_params, 'request_params')
        if self.request_params:
            self.request_params.validate()
        self.validate_required(self.response_params, 'response_params')
        if self.response_params:
            self.response_params.validate()

    def to_map(self):
        result = dict()
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        if self.request_params is not None:
            result['RequestParams'] = self.request_params.to_map()
        if self.response_params is not None:
            result['ResponseParams'] = self.response_params.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        if m.get('RequestParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParams()
            self.request_params = temp_model.from_map(m['RequestParams'])
        if m.get('ResponseParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParams()
            self.response_params = temp_model.from_map(m['ResponseParams'])
        return self


class GetDataAPIServiceDetailResponseData(TeaModel):
    def __init__(
        self,
        api_srn: str = None,
        status: int = None,
        display_name: str = None,
        api_path: str = None,
        create_time: int = None,
        last_update_time: int = None,
        date_format: str = None,
        request_method: str = None,
        request_protocol: str = None,
        description: str = None,
        sql_template_dto: GetDataAPIServiceDetailResponseDataSqlTemplateDTO = None,
    ):
        self.api_srn = api_srn
        self.status = status
        self.display_name = display_name
        self.api_path = api_path
        self.create_time = create_time
        self.last_update_time = last_update_time
        self.date_format = date_format
        self.request_method = request_method
        self.request_protocol = request_protocol
        self.description = description
        self.sql_template_dto = sql_template_dto

    def validate(self):
        self.validate_required(self.api_srn, 'api_srn')
        self.validate_required(self.status, 'status')
        self.validate_required(self.display_name, 'display_name')
        self.validate_required(self.api_path, 'api_path')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.last_update_time, 'last_update_time')
        self.validate_required(self.date_format, 'date_format')
        self.validate_required(self.request_method, 'request_method')
        self.validate_required(self.request_protocol, 'request_protocol')
        self.validate_required(self.description, 'description')
        self.validate_required(self.sql_template_dto, 'sql_template_dto')
        if self.sql_template_dto:
            self.sql_template_dto.validate()

    def to_map(self):
        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.status is not None:
            result['Status'] = self.status
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        if self.date_format is not None:
            result['DateFormat'] = self.date_format
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.request_protocol is not None:
            result['RequestProtocol'] = self.request_protocol
        if self.description is not None:
            result['Description'] = self.description
        if self.sql_template_dto is not None:
            result['SqlTemplateDTO'] = self.sql_template_dto.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        if m.get('DateFormat') is not None:
            self.date_format = m.get('DateFormat')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('RequestProtocol') is not None:
            self.request_protocol = m.get('RequestProtocol')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SqlTemplateDTO') is not None:
            temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTO()
            self.sql_template_dto = temp_model.from_map(m['SqlTemplateDTO'])
        return self


class GetDataAPIServiceDetailResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetDataAPIServiceDetailResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetDataAPIServiceDetailResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class InvokeDataAPIServiceRequestParam(TeaModel):
    def __init__(
        self,
        param_type: str = None,
        list_param_value: List[str] = None,
        list_param_type: str = None,
        param_name: str = None,
        param_value: str = None,
    ):
        self.param_type = param_type
        self.list_param_value = list_param_value
        self.list_param_type = list_param_type
        self.param_name = param_name
        self.param_value = param_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.param_type is not None:
            result['ParamType'] = self.param_type
        if self.list_param_value is not None:
            result['ListParamValue'] = self.list_param_value
        if self.list_param_type is not None:
            result['ListParamType'] = self.list_param_type
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        if self.param_value is not None:
            result['ParamValue'] = self.param_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParamType') is not None:
            self.param_type = m.get('ParamType')
        if m.get('ListParamValue') is not None:
            self.list_param_value = m.get('ListParamValue')
        if m.get('ListParamType') is not None:
            self.list_param_type = m.get('ListParamType')
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        if m.get('ParamValue') is not None:
            self.param_value = m.get('ParamValue')
        return self


class InvokeDataAPIServiceRequest(TeaModel):
    def __init__(
        self,
        api_srn: str = None,
        param: List[InvokeDataAPIServiceRequestParam] = None,
        iot_instance_id: str = None,
    ):
        self.api_srn = api_srn
        self.param = param
        self.iot_instance_id = iot_instance_id

    def validate(self):
        self.validate_required(self.api_srn, 'api_srn')
        if self.param:
            for k in self.param:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        result['Param'] = []
        if self.param is not None:
            for k in self.param:
                result['Param'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        self.param = []
        if m.get('Param') is not None:
            for k in m.get('Param'):
                temp_model = InvokeDataAPIServiceRequestParam()
                self.param.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class InvokeDataAPIServiceResponseDataFieldNameList(TeaModel):
    def __init__(
        self,
        field_name_list: List[str] = None,
    ):
        # FieldNameList
        self.field_name_list = field_name_list

    def validate(self):
        self.validate_required(self.field_name_list, 'field_name_list')

    def to_map(self):
        result = dict()
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldNameList') is not None:
            self.field_name_list = m.get('FieldNameList')
        return self


class InvokeDataAPIServiceResponseDataResultList(TeaModel):
    def __init__(
        self,
        result_list: List[Dict[str, Any]] = None,
    ):
        # ResultList
        self.result_list = result_list

    def validate(self):
        self.validate_required(self.result_list, 'result_list')

    def to_map(self):
        result = dict()
        if self.result_list is not None:
            result['ResultList'] = self.result_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResultList') is not None:
            self.result_list = m.get('ResultList')
        return self


class InvokeDataAPIServiceResponseData(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        api_srn: str = None,
        field_name_list: InvokeDataAPIServiceResponseDataFieldNameList = None,
        result_list: InvokeDataAPIServiceResponseDataResultList = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.api_srn = api_srn
        self.field_name_list = field_name_list
        self.result_list = result_list

    def validate(self):
        self.validate_required(self.page_no, 'page_no')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.api_srn, 'api_srn')
        self.validate_required(self.field_name_list, 'field_name_list')
        if self.field_name_list:
            self.field_name_list.validate()
        self.validate_required(self.result_list, 'result_list')
        if self.result_list:
            self.result_list.validate()

    def to_map(self):
        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list.to_map()
        if self.result_list is not None:
            result['ResultList'] = self.result_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('FieldNameList') is not None:
            temp_model = InvokeDataAPIServiceResponseDataFieldNameList()
            self.field_name_list = temp_model.from_map(m['FieldNameList'])
        if m.get('ResultList') is not None:
            temp_model = InvokeDataAPIServiceResponseDataResultList()
            self.result_list = temp_model.from_map(m['ResultList'])
        return self


class InvokeDataAPIServiceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: InvokeDataAPIServiceResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = InvokeDataAPIServiceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateEdgeInstanceChannelRequestConfigs(TeaModel):
    def __init__(
        self,
        format: str = None,
        content: str = None,
        key: str = None,
    ):
        self.format = format
        self.content = content
        self.key = key

    def validate(self):
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class UpdateEdgeInstanceChannelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_id: str = None,
        channel_name: str = None,
        configs: List[UpdateEdgeInstanceChannelRequestConfigs] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_id = channel_id
        self.channel_name = channel_name
        self.configs = configs

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.configs, 'configs')
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = UpdateEdgeInstanceChannelRequestConfigs()
                self.configs.append(temp_model.from_map(k))
        return self


class UpdateEdgeInstanceChannelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryEdgeInstanceChannelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_name: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_name = channel_name
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryEdgeInstanceChannelResponseDataChannelListChannelConfigListConfig(TeaModel):
    def __init__(
        self,
        config_id: str = None,
        format: str = None,
        content: str = None,
        key: str = None,
    ):
        self.config_id = config_id
        self.format = format
        self.content = content
        self.key = key

    def validate(self):
        self.validate_required(self.config_id, 'config_id')
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')
        self.validate_required(self.key, 'key')

    def to_map(self):
        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class QueryEdgeInstanceChannelResponseDataChannelListChannelConfigList(TeaModel):
    def __init__(
        self,
        config: List[QueryEdgeInstanceChannelResponseDataChannelListChannelConfigListConfig] = None,
    ):
        self.config = config

    def validate(self):
        self.validate_required(self.config, 'config')
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = QueryEdgeInstanceChannelResponseDataChannelListChannelConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceChannelResponseDataChannelListChannel(TeaModel):
    def __init__(
        self,
        channel_id: str = None,
        channel_name: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        config_list: QueryEdgeInstanceChannelResponseDataChannelListChannelConfigList = None,
    ):
        self.channel_id = channel_id
        self.channel_name = channel_name
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.config_list = config_list

    def validate(self):
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.config_list, 'config_list')
        if self.config_list:
            self.config_list.validate()

    def to_map(self):
        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('ConfigList') is not None:
            temp_model = QueryEdgeInstanceChannelResponseDataChannelListChannelConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        return self


class QueryEdgeInstanceChannelResponseDataChannelList(TeaModel):
    def __init__(
        self,
        channel: List[QueryEdgeInstanceChannelResponseDataChannelListChannel] = None,
    ):
        self.channel = channel

    def validate(self):
        self.validate_required(self.channel, 'channel')
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = QueryEdgeInstanceChannelResponseDataChannelListChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceChannelResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        channel_list: QueryEdgeInstanceChannelResponseDataChannelList = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.channel_list = channel_list

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.channel_list, 'channel_list')
        if self.channel_list:
            self.channel_list.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.channel_list is not None:
            result['ChannelList'] = self.channel_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ChannelList') is not None:
            temp_model = QueryEdgeInstanceChannelResponseDataChannelList()
            self.channel_list = temp_model.from_map(m['ChannelList'])
        return self


class QueryEdgeInstanceChannelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryEdgeInstanceChannelResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceChannelResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchUnbindDeviceFromEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.iot_ids = iot_ids

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class SetEdgeInstanceDriverConfigsRequestConfigs(TeaModel):
    def __init__(
        self,
        format: str = None,
        content: str = None,
        key: str = None,
    ):
        self.format = format
        self.content = content
        self.key = key

    def validate(self):
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class SetEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        configs: List[SetEdgeInstanceDriverConfigsRequestConfigs] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.configs = configs

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.configs, 'configs')
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = SetEdgeInstanceDriverConfigsRequestConfigs()
                self.configs.append(temp_model.from_map(k))
        return self


class SetEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateEdgeInstanceChannelRequestConfigs(TeaModel):
    def __init__(
        self,
        format: str = None,
        content: str = None,
        key: str = None,
    ):
        self.format = format
        self.content = content
        self.key = key

    def validate(self):
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class CreateEdgeInstanceChannelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_name: str = None,
        configs: List[CreateEdgeInstanceChannelRequestConfigs] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_name = channel_name
        self.configs = configs

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.configs, 'configs')
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = CreateEdgeInstanceChannelRequestConfigs()
                self.configs.append(temp_model.from_map(k))
        return self


class CreateEdgeInstanceChannelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.iot_ids = iot_ids

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchGetEdgeInstanceChannelRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_ids = channel_ids

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.channel_ids, 'channel_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class BatchGetEdgeInstanceChannelResponseDataChannelConfigListConfig(TeaModel):
    def __init__(
        self,
        config_id: str = None,
        format: str = None,
        content: str = None,
        key: str = None,
    ):
        self.config_id = config_id
        self.format = format
        self.content = content
        self.key = key

    def validate(self):
        self.validate_required(self.config_id, 'config_id')
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')
        self.validate_required(self.key, 'key')

    def to_map(self):
        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class BatchGetEdgeInstanceChannelResponseDataChannelConfigList(TeaModel):
    def __init__(
        self,
        config: List[BatchGetEdgeInstanceChannelResponseDataChannelConfigListConfig] = None,
    ):
        self.config = config

    def validate(self):
        self.validate_required(self.config, 'config')
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = BatchGetEdgeInstanceChannelResponseDataChannelConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseDataChannel(TeaModel):
    def __init__(
        self,
        channel_id: str = None,
        channel_name: str = None,
        config_list: BatchGetEdgeInstanceChannelResponseDataChannelConfigList = None,
    ):
        self.channel_id = channel_id
        self.channel_name = channel_name
        self.config_list = config_list

    def validate(self):
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.config_list, 'config_list')
        if self.config_list:
            self.config_list.validate()

    def to_map(self):
        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ConfigList') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseDataChannelConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        return self


class BatchGetEdgeInstanceChannelResponseData(TeaModel):
    def __init__(
        self,
        channel: List[BatchGetEdgeInstanceChannelResponseDataChannel] = None,
    ):
        self.channel = channel

    def validate(self):
        self.validate_required(self.channel, 'channel')
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = BatchGetEdgeInstanceChannelResponseDataChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: BatchGetEdgeInstanceChannelResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs(TeaModel):
    def __init__(
        self,
        iot_id: str = None,
        content: str = None,
    ):
        self.iot_id = iot_id
        self.content = content

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class BatchSetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        device_configs: List[BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.device_configs = device_configs

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.device_configs, 'device_configs')
        if self.device_configs:
            for k in self.device_configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['DeviceConfigs'] = []
        if self.device_configs is not None:
            for k in self.device_configs:
                result['DeviceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.device_configs = []
        if m.get('DeviceConfigs') is not None:
            for k in m.get('DeviceConfigs'):
                temp_model = BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs()
                self.device_configs.append(temp_model.from_map(k))
        return self


class BatchSetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchClearEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.iot_ids = iot_ids

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchClearEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchGetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.iot_ids = iot_ids

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigListConfig(TeaModel):
    def __init__(
        self,
        format: str = None,
        content: str = None,
    ):
        self.format = format
        self.content = content

    def validate(self):
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigList(TeaModel):
    def __init__(
        self,
        iot_id: str = None,
        config: BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigListConfig = None,
    ):
        self.iot_id = iot_id
        self.config = config

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.config, 'config')
        if self.config:
            self.config.validate()

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.config is not None:
            result['Config'] = self.config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Config') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigListConfig()
            self.config = temp_model.from_map(m['Config'])
        return self


class BatchGetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        device_config_list: List[BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigList] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.device_config_list = device_config_list

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.device_config_list, 'device_config_list')
        if self.device_config_list:
            for k in self.device_config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceConfigList'] = []
        if self.device_config_list is not None:
            for k in self.device_config_list:
                result['DeviceConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_config_list = []
        if m.get('DeviceConfigList') is not None:
            for k in m.get('DeviceConfigList'):
                temp_model = BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigList()
                self.device_config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_ids: List[str] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_ids = driver_ids

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_ids, 'driver_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseDriverConfigListConfigList(TeaModel):
    def __init__(
        self,
        config_id: str = None,
        format: str = None,
        content: str = None,
        key: str = None,
    ):
        self.config_id = config_id
        self.format = format
        self.content = content
        self.key = key

    def validate(self):
        self.validate_required(self.config_id, 'config_id')
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')
        self.validate_required(self.key, 'key')

    def to_map(self):
        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseDriverConfigList(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        config_list: List[BatchGetEdgeInstanceDriverConfigsResponseDriverConfigListConfigList] = None,
    ):
        self.driver_id = driver_id
        self.config_list = config_list

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.config_list, 'config_list')
        if self.config_list:
            for k in self.config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        result['ConfigList'] = []
        if self.config_list is not None:
            for k in self.config_list:
                result['ConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        self.config_list = []
        if m.get('ConfigList') is not None:
            for k in m.get('ConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseDriverConfigListConfigList()
                self.config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        driver_config_list: List[BatchGetEdgeInstanceDriverConfigsResponseDriverConfigList] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.driver_config_list = driver_config_list

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.driver_config_list, 'driver_config_list')
        if self.driver_config_list:
            for k in self.driver_config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DriverConfigList'] = []
        if self.driver_config_list is not None:
            for k in self.driver_config_list:
                result['DriverConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.driver_config_list = []
        if m.get('DriverConfigList') is not None:
            for k in m.get('DriverConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseDriverConfigList()
                self.driver_config_list.append(temp_model.from_map(k))
        return self


class ClearEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class ClearEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateLoRaNodesTaskRequestDeviceInfo(TeaModel):
    def __init__(
        self,
        dev_eui: str = None,
        pin_code: str = None,
    ):
        self.dev_eui = dev_eui
        self.pin_code = pin_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.dev_eui is not None:
            result['DevEui'] = self.dev_eui
        if self.pin_code is not None:
            result['PinCode'] = self.pin_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevEui') is not None:
            self.dev_eui = m.get('DevEui')
        if m.get('PinCode') is not None:
            self.pin_code = m.get('PinCode')
        return self


class CreateLoRaNodesTaskRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_info: List[CreateLoRaNodesTaskRequestDeviceInfo] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_info = device_info

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_info, 'device_info')
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['DeviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['DeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.device_info = []
        if m.get('DeviceInfo') is not None:
            for k in m.get('DeviceInfo'):
                temp_model = CreateLoRaNodesTaskRequestDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class CreateLoRaNodesTaskResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        task_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetLoraNodesTaskRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        task_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetLoraNodesTaskResponseSuccessDevEuis(TeaModel):
    def __init__(
        self,
        success_dev_eui: List[str] = None,
    ):
        self.success_dev_eui = success_dev_eui

    def validate(self):
        self.validate_required(self.success_dev_eui, 'success_dev_eui')

    def to_map(self):
        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetLoraNodesTaskResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        task_id: str = None,
        task_state: str = None,
        total_count: int = None,
        success_count: int = None,
        success_dev_euis: GetLoraNodesTaskResponseSuccessDevEuis = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.task_id = task_id
        self.task_state = task_state
        self.total_count = total_count
        self.success_count = success_count
        self.success_dev_euis = success_dev_euis

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.task_state, 'task_state')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.success_count, 'success_count')
        self.validate_required(self.success_dev_euis, 'success_dev_euis')
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetLoraNodesTaskResponseSuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        return self


class QueryLoRaJoinPermissionsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class QueryLoRaJoinPermissionsResponseJoinPermissionsJoinPermission(TeaModel):
    def __init__(
        self,
        join_permission_id: str = None,
        join_permission_name: str = None,
        join_permission_type: str = None,
        owner_aliyun_pk: str = None,
        enabled: bool = None,
        class_mode: str = None,
    ):
        self.join_permission_id = join_permission_id
        self.join_permission_name = join_permission_name
        self.join_permission_type = join_permission_type
        self.owner_aliyun_pk = owner_aliyun_pk
        self.enabled = enabled
        self.class_mode = class_mode

    def validate(self):
        self.validate_required(self.join_permission_id, 'join_permission_id')
        self.validate_required(self.join_permission_name, 'join_permission_name')
        self.validate_required(self.join_permission_type, 'join_permission_type')
        self.validate_required(self.owner_aliyun_pk, 'owner_aliyun_pk')
        self.validate_required(self.enabled, 'enabled')
        self.validate_required(self.class_mode, 'class_mode')

    def to_map(self):
        result = dict()
        if self.join_permission_id is not None:
            result['JoinPermissionId'] = self.join_permission_id
        if self.join_permission_name is not None:
            result['JoinPermissionName'] = self.join_permission_name
        if self.join_permission_type is not None:
            result['JoinPermissionType'] = self.join_permission_type
        if self.owner_aliyun_pk is not None:
            result['OwnerAliyunPk'] = self.owner_aliyun_pk
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.class_mode is not None:
            result['ClassMode'] = self.class_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JoinPermissionId') is not None:
            self.join_permission_id = m.get('JoinPermissionId')
        if m.get('JoinPermissionName') is not None:
            self.join_permission_name = m.get('JoinPermissionName')
        if m.get('JoinPermissionType') is not None:
            self.join_permission_type = m.get('JoinPermissionType')
        if m.get('OwnerAliyunPk') is not None:
            self.owner_aliyun_pk = m.get('OwnerAliyunPk')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('ClassMode') is not None:
            self.class_mode = m.get('ClassMode')
        return self


class QueryLoRaJoinPermissionsResponseJoinPermissions(TeaModel):
    def __init__(
        self,
        join_permission: List[QueryLoRaJoinPermissionsResponseJoinPermissionsJoinPermission] = None,
    ):
        self.join_permission = join_permission

    def validate(self):
        self.validate_required(self.join_permission, 'join_permission')
        if self.join_permission:
            for k in self.join_permission:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['JoinPermission'] = []
        if self.join_permission is not None:
            for k in self.join_permission:
                result['JoinPermission'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.join_permission = []
        if m.get('JoinPermission') is not None:
            for k in m.get('JoinPermission'):
                temp_model = QueryLoRaJoinPermissionsResponseJoinPermissionsJoinPermission()
                self.join_permission.append(temp_model.from_map(k))
        return self


class QueryLoRaJoinPermissionsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        product_key: str = None,
        join_permissions: QueryLoRaJoinPermissionsResponseJoinPermissions = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.product_key = product_key
        self.join_permissions = join_permissions

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.join_permissions, 'join_permissions')
        if self.join_permissions:
            self.join_permissions.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.join_permissions is not None:
            result['JoinPermissions'] = self.join_permissions.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('JoinPermissions') is not None:
            temp_model = QueryLoRaJoinPermissionsResponseJoinPermissions()
            self.join_permissions = temp_model.from_map(m['JoinPermissions'])
        return self


class QueryEdgeInstanceDriverRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryEdgeInstanceDriverResponseDataDriverList(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        driver_version: str = None,
        order_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        self.driver_id = driver_id
        self.driver_version = driver_version
        self.order_id = order_id
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class QueryEdgeInstanceDriverResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        driver_list: List[QueryEdgeInstanceDriverResponseDataDriverList] = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.driver_list = driver_list

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.driver_list, 'driver_list')
        if self.driver_list:
            for k in self.driver_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['DriverList'] = []
        if self.driver_list is not None:
            for k in self.driver_list:
                result['DriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.driver_list = []
        if m.get('DriverList') is not None:
            for k in m.get('DriverList'):
                temp_model = QueryEdgeInstanceDriverResponseDataDriverList()
                self.driver_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceDriverResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryEdgeInstanceDriverResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceDriverResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchUpdateDeviceNicknameRequestDeviceNicknameInfo(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        nickname: str = None,
        iot_id: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.nickname = nickname
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchUpdateDeviceNicknameRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        device_nickname_info: List[BatchUpdateDeviceNicknameRequestDeviceNicknameInfo] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.device_nickname_info = device_nickname_info

    def validate(self):
        self.validate_required(self.device_nickname_info, 'device_nickname_info')
        if self.device_nickname_info:
            for k in self.device_nickname_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['DeviceNicknameInfo'] = []
        if self.device_nickname_info is not None:
            for k in self.device_nickname_info:
                result['DeviceNicknameInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.device_nickname_info = []
        if m.get('DeviceNicknameInfo') is not None:
            for k in m.get('DeviceNicknameInfo'):
                temp_model = BatchUpdateDeviceNicknameRequestDeviceNicknameInfo()
                self.device_nickname_info.append(temp_model.from_map(k))
        return self


class BatchUpdateDeviceNicknameResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryDeviceFileRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        file_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class QueryDeviceFileResponseData(TeaModel):
    def __init__(
        self,
        file_id: str = None,
        name: str = None,
        size: str = None,
        utc_created_on: str = None,
        download_url: str = None,
    ):
        self.file_id = file_id
        self.name = name
        self.size = size
        self.utc_created_on = utc_created_on
        self.download_url = download_url

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.size, 'size')
        self.validate_required(self.utc_created_on, 'utc_created_on')
        self.validate_required(self.download_url, 'download_url')

    def to_map(self):
        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.name is not None:
            result['Name'] = self.name
        if self.size is not None:
            result['Size'] = self.size
        if self.utc_created_on is not None:
            result['UtcCreatedOn'] = self.utc_created_on
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('UtcCreatedOn') is not None:
            self.utc_created_on = m.get('UtcCreatedOn')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        return self


class QueryDeviceFileResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceFileResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceFileResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceFileListRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceFileListResponseDataFileSummary(TeaModel):
    def __init__(
        self,
        file_id: str = None,
        name: str = None,
        size: str = None,
        utc_created_on: str = None,
    ):
        self.file_id = file_id
        self.name = name
        self.size = size
        self.utc_created_on = utc_created_on

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.size, 'size')
        self.validate_required(self.utc_created_on, 'utc_created_on')

    def to_map(self):
        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.name is not None:
            result['Name'] = self.name
        if self.size is not None:
            result['Size'] = self.size
        if self.utc_created_on is not None:
            result['UtcCreatedOn'] = self.utc_created_on
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('UtcCreatedOn') is not None:
            self.utc_created_on = m.get('UtcCreatedOn')
        return self


class QueryDeviceFileListResponseData(TeaModel):
    def __init__(
        self,
        file_summary: List[QueryDeviceFileListResponseDataFileSummary] = None,
    ):
        self.file_summary = file_summary

    def validate(self):
        self.validate_required(self.file_summary, 'file_summary')
        if self.file_summary:
            for k in self.file_summary:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['FileSummary'] = []
        if self.file_summary is not None:
            for k in self.file_summary:
                result['FileSummary'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_summary = []
        if m.get('FileSummary') is not None:
            for k in m.get('FileSummary'):
                temp_model = QueryDeviceFileListResponseDataFileSummary()
                self.file_summary.append(temp_model.from_map(k))
        return self


class QueryDeviceFileListResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        current_page: int = None,
        page_count: int = None,
        page_size: int = None,
        total: int = None,
        data: QueryDeviceFileListResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.current_page = current_page
        self.page_count = page_count
        self.page_size = page_size
        self.total = total
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceFileListResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteDeviceFileRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        file_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeleteDeviceFileResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class GetNodesAddingTaskRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        task_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetNodesAddingTaskResponseSuccessDevEuis(TeaModel):
    def __init__(
        self,
        success_dev_eui: List[str] = None,
    ):
        self.success_dev_eui = success_dev_eui

    def validate(self):
        self.validate_required(self.success_dev_eui, 'success_dev_eui')

    def to_map(self):
        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetNodesAddingTaskResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        task_id: str = None,
        task_state: str = None,
        total_count: int = None,
        success_count: int = None,
        success_dev_euis: GetNodesAddingTaskResponseSuccessDevEuis = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.task_id = task_id
        self.task_state = task_state
        self.total_count = total_count
        self.success_count = success_count
        self.success_dev_euis = success_dev_euis

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.task_state, 'task_state')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.success_count, 'success_count')
        self.validate_required(self.success_dev_euis, 'success_dev_euis')
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetNodesAddingTaskResponseSuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        return self


class SetDeviceDesiredPropertyRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        iot_id: str = None,
        device_name: str = None,
        product_key: str = None,
        items: str = None,
        versions: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.iot_id = iot_id
        self.device_name = device_name
        self.product_key = product_key
        self.items = items
        self.versions = versions

    def validate(self):
        self.validate_required(self.items, 'items')
        self.validate_required(self.versions, 'versions')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.items is not None:
            result['Items'] = self.items
        if self.versions is not None:
            result['Versions'] = self.versions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Items') is not None:
            self.items = m.get('Items')
        if m.get('Versions') is not None:
            self.versions = m.get('Versions')
        return self


class SetDeviceDesiredPropertyResponseData(TeaModel):
    def __init__(
        self,
        message_id: str = None,
        versions: str = None,
    ):
        self.message_id = message_id
        self.versions = versions

    def validate(self):
        self.validate_required(self.message_id, 'message_id')
        self.validate_required(self.versions, 'versions')

    def to_map(self):
        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.versions is not None:
            result['Versions'] = self.versions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('Versions') is not None:
            self.versions = m.get('Versions')
        return self


class SetDeviceDesiredPropertyResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: SetDeviceDesiredPropertyResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = SetDeviceDesiredPropertyResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceDesiredPropertyRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        identifier: List[str] = None,
        iot_id: str = None,
        function_block_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.identifier = identifier
        self.iot_id = iot_id
        self.function_block_id = function_block_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class QueryDeviceDesiredPropertyResponseDataListDesiredPropertyInfo(TeaModel):
    def __init__(
        self,
        unit: str = None,
        identifier: str = None,
        data_type: str = None,
        time: str = None,
        value: str = None,
        name: str = None,
        version: int = None,
    ):
        self.unit = unit
        self.identifier = identifier
        self.data_type = data_type
        self.time = time
        self.value = value
        self.name = name
        self.version = version

    def validate(self):
        self.validate_required(self.unit, 'unit')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.data_type, 'data_type')
        self.validate_required(self.time, 'time')
        self.validate_required(self.value, 'value')
        self.validate_required(self.name, 'name')
        self.validate_required(self.version, 'version')

    def to_map(self):
        result = dict()
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.time is not None:
            result['Time'] = self.time
        if self.value is not None:
            result['Value'] = self.value
        if self.name is not None:
            result['Name'] = self.name
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class QueryDeviceDesiredPropertyResponseDataList(TeaModel):
    def __init__(
        self,
        desired_property_info: List[QueryDeviceDesiredPropertyResponseDataListDesiredPropertyInfo] = None,
    ):
        self.desired_property_info = desired_property_info

    def validate(self):
        self.validate_required(self.desired_property_info, 'desired_property_info')
        if self.desired_property_info:
            for k in self.desired_property_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DesiredPropertyInfo'] = []
        if self.desired_property_info is not None:
            for k in self.desired_property_info:
                result['DesiredPropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.desired_property_info = []
        if m.get('DesiredPropertyInfo') is not None:
            for k in m.get('DesiredPropertyInfo'):
                temp_model = QueryDeviceDesiredPropertyResponseDataListDesiredPropertyInfo()
                self.desired_property_info.append(temp_model.from_map(k))
        return self


class QueryDeviceDesiredPropertyResponseData(TeaModel):
    def __init__(
        self,
        list: QueryDeviceDesiredPropertyResponseDataList = None,
    ):
        self.list = list

    def validate(self):
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceDesiredPropertyResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceDesiredPropertyResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryEdgeInstanceHistoricDeploymentRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        current_page: int = None,
        page_size: int = None,
        start_time: int = None,
        end_time: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.current_page = current_page
        self.page_size = page_size
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryEdgeInstanceHistoricDeploymentResponseDataDeploymentList(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        gmt_completed: str = None,
        deployment_id: str = None,
        description: str = None,
        status: int = None,
        type: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        gmt_completed_timestamp: int = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.gmt_completed = gmt_completed
        self.deployment_id = deployment_id
        self.description = description
        self.status = status
        self.type = type
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.gmt_completed_timestamp = gmt_completed_timestamp

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_completed, 'gmt_completed')
        self.validate_required(self.deployment_id, 'deployment_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.gmt_completed_timestamp, 'gmt_completed_timestamp')

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.description is not None:
            result['Description'] = self.description
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        return self


class QueryEdgeInstanceHistoricDeploymentResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        deployment_list: List[QueryEdgeInstanceHistoricDeploymentResponseDataDeploymentList] = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.deployment_list = deployment_list

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.deployment_list, 'deployment_list')
        if self.deployment_list:
            for k in self.deployment_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['DeploymentList'] = []
        if self.deployment_list is not None:
            for k in self.deployment_list:
                result['DeploymentList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.deployment_list = []
        if m.get('DeploymentList') is not None:
            for k in m.get('DeploymentList'):
                temp_model = QueryEdgeInstanceHistoricDeploymentResponseDataDeploymentList()
                self.deployment_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceHistoricDeploymentResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryEdgeInstanceHistoricDeploymentResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceHistoricDeploymentResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateProductTagsRequestProductTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateProductTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        product_tag: List[CreateProductTagsRequestProductTag] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.product_tag = product_tag

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseInvalidProductTagsProductTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateProductTagsResponseInvalidProductTags(TeaModel):
    def __init__(
        self,
        product_tag: List[CreateProductTagsResponseInvalidProductTagsProductTag] = None,
    ):
        self.product_tag = product_tag

    def validate(self):
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsResponseInvalidProductTagsProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        invalid_product_tags: CreateProductTagsResponseInvalidProductTags = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.invalid_product_tags = invalid_product_tags

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.invalid_product_tags, 'invalid_product_tags')
        if self.invalid_product_tags:
            self.invalid_product_tags.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.invalid_product_tags is not None:
            result['InvalidProductTags'] = self.invalid_product_tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InvalidProductTags') is not None:
            temp_model = CreateProductTagsResponseInvalidProductTags()
            self.invalid_product_tags = temp_model.from_map(m['InvalidProductTags'])
        return self


class UpdateProductTagsRequestProductTag(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_key: str = None,
    ):
        self.tag_value = tag_value
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class UpdateProductTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
        product_tag: List[UpdateProductTagsRequestProductTag] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.product_tag = product_tag

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = UpdateProductTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class UpdateProductTagsResponseInvalidProductTagsProductTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class UpdateProductTagsResponseInvalidProductTags(TeaModel):
    def __init__(
        self,
        product_tag: List[UpdateProductTagsResponseInvalidProductTagsProductTag] = None,
    ):
        self.product_tag = product_tag

    def validate(self):
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = UpdateProductTagsResponseInvalidProductTagsProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class UpdateProductTagsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        invalid_product_tags: UpdateProductTagsResponseInvalidProductTags = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.invalid_product_tags = invalid_product_tags

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.invalid_product_tags, 'invalid_product_tags')
        if self.invalid_product_tags:
            self.invalid_product_tags.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.invalid_product_tags is not None:
            result['InvalidProductTags'] = self.invalid_product_tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InvalidProductTags') is not None:
            temp_model = UpdateProductTagsResponseInvalidProductTags()
            self.invalid_product_tags = temp_model.from_map(m['InvalidProductTags'])
        return self


class DeleteProductTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_tag_key: List[str] = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_tag_key = product_tag_key
        self.product_key = product_key

    def validate(self):
        self.validate_required(self.product_tag_key, 'product_tag_key')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_tag_key is not None:
            result['ProductTagKey'] = self.product_tag_key
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductTagKey') is not None:
            self.product_tag_key = m.get('ProductTagKey')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteProductTagsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class ListProductTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListProductTagsResponseDataProductTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListProductTagsResponseData(TeaModel):
    def __init__(
        self,
        product_tag: List[ListProductTagsResponseDataProductTag] = None,
    ):
        self.product_tag = product_tag

    def validate(self):
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = ListProductTagsResponseDataProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class ListProductTagsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: ListProductTagsResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListProductTagsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListProductByTagsRequestProductTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListProductByTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        current_page: int = None,
        page_size: int = None,
        product_tag: List[ListProductByTagsRequestProductTag] = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.current_page = current_page
        self.page_size = page_size
        self.product_tag = product_tag

    def validate(self):
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = ListProductByTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class ListProductByTagsResponseProductInfosProductInfo(TeaModel):
    def __init__(
        self,
        product_name: str = None,
        product_key: str = None,
        create_time: int = None,
        description: str = None,
        node_type: int = None,
    ):
        self.product_name = product_name
        self.product_key = product_key
        self.create_time = create_time
        self.description = description
        self.node_type = node_type

    def validate(self):
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.description, 'description')
        self.validate_required(self.node_type, 'node_type')

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        return self


class ListProductByTagsResponseProductInfos(TeaModel):
    def __init__(
        self,
        product_info: List[ListProductByTagsResponseProductInfosProductInfo] = None,
    ):
        self.product_info = product_info

    def validate(self):
        self.validate_required(self.product_info, 'product_info')
        if self.product_info:
            for k in self.product_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductInfo'] = []
        if self.product_info is not None:
            for k in self.product_info:
                result['ProductInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.product_info = []
        if m.get('ProductInfo') is not None:
            for k in m.get('ProductInfo'):
                temp_model = ListProductByTagsResponseProductInfosProductInfo()
                self.product_info.append(temp_model.from_map(k))
        return self


class ListProductByTagsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        product_infos: ListProductByTagsResponseProductInfos = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.product_infos = product_infos

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.product_infos, 'product_infos')
        if self.product_infos:
            self.product_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.product_infos is not None:
            result['ProductInfos'] = self.product_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ProductInfos') is not None:
            temp_model = ListProductByTagsResponseProductInfos()
            self.product_infos = temp_model.from_map(m['ProductInfos'])
        return self


class QueryDeviceGroupByTagsRequestTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceGroupByTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        tag: List[QueryDeviceGroupByTagsRequestTag] = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.tag = tag
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = QueryDeviceGroupByTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryDeviceGroupByTagsResponseDataDeviceGroup(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class QueryDeviceGroupByTagsResponseData(TeaModel):
    def __init__(
        self,
        device_group: List[QueryDeviceGroupByTagsResponseDataDeviceGroup] = None,
    ):
        self.device_group = device_group

    def validate(self):
        self.validate_required(self.device_group, 'device_group')
        if self.device_group:
            for k in self.device_group:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DeviceGroup'] = []
        if self.device_group is not None:
            for k in self.device_group:
                result['DeviceGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_group = []
        if m.get('DeviceGroup') is not None:
            for k in m.get('DeviceGroup'):
                temp_model = QueryDeviceGroupByTagsResponseDataDeviceGroup()
                self.device_group.append(temp_model.from_map(k))
        return self


class QueryDeviceGroupByTagsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        page: int = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        data: QueryDeviceGroupByTagsResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.page = page
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceGroupByTagsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchAddThingTopoRequestTopoAddItem(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        sign: str = None,
        sign_method: str = None,
        timestamp: str = None,
        client_id: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.sign = sign
        self.sign_method = sign_method
        self.timestamp = timestamp
        self.client_id = client_id

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.sign, 'sign')
        self.validate_required(self.sign_method, 'sign_method')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.sign is not None:
            result['Sign'] = self.sign
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        return self


class BatchAddThingTopoRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        topo_add_item: List[BatchAddThingTopoRequestTopoAddItem] = None,
        gw_product_key: str = None,
        gw_device_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.topo_add_item = topo_add_item
        self.gw_product_key = gw_product_key
        self.gw_device_name = gw_device_name

    def validate(self):
        self.validate_required(self.topo_add_item, 'topo_add_item')
        if self.topo_add_item:
            for k in self.topo_add_item:
                if k:
                    k.validate()
        self.validate_required(self.gw_product_key, 'gw_product_key')
        self.validate_required(self.gw_device_name, 'gw_device_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['TopoAddItem'] = []
        if self.topo_add_item is not None:
            for k in self.topo_add_item:
                result['TopoAddItem'].append(k.to_map() if k else None)
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.topo_add_item = []
        if m.get('TopoAddItem') is not None:
            for k in m.get('TopoAddItem'):
                temp_model = BatchAddThingTopoRequestTopoAddItem()
                self.topo_add_item.append(temp_model.from_map(k))
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        return self


class BatchAddThingTopoResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryDeviceListByDeviceGroupRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceListByDeviceGroupResponseDataSimpleDeviceInfo(TeaModel):
    def __init__(
        self,
        product_name: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.product_name = product_name
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class QueryDeviceListByDeviceGroupResponseData(TeaModel):
    def __init__(
        self,
        simple_device_info: List[QueryDeviceListByDeviceGroupResponseDataSimpleDeviceInfo] = None,
    ):
        self.simple_device_info = simple_device_info

    def validate(self):
        self.validate_required(self.simple_device_info, 'simple_device_info')
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceListByDeviceGroupResponseDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceListByDeviceGroupResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        page: int = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        data: QueryDeviceListByDeviceGroupResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.page = page
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceListByDeviceGroupResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDevicePropertiesDataRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        start_time: int = None,
        identifier: List[str] = None,
        asc: int = None,
        iot_id: str = None,
        end_time: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.start_time = start_time
        self.identifier = identifier
        self.asc = asc
        self.iot_id = iot_id
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.asc, 'asc')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfoListPropertyInfo(TeaModel):
    def __init__(
        self,
        time: int = None,
        value: str = None,
    ):
        self.time = time
        self.value = value

    def validate(self):
        self.validate_required(self.time, 'time')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfoList(TeaModel):
    def __init__(
        self,
        property_info: List[QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfoListPropertyInfo] = None,
    ):
        self.property_info = property_info

    def validate(self):
        self.validate_required(self.property_info, 'property_info')
        if self.property_info:
            for k in self.property_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PropertyInfo'] = []
        if self.property_info is not None:
            for k in self.property_info:
                result['PropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.property_info = []
        if m.get('PropertyInfo') is not None:
            for k in m.get('PropertyInfo'):
                temp_model = QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfoListPropertyInfo()
                self.property_info.append(temp_model.from_map(k))
        return self


class QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfo(TeaModel):
    def __init__(
        self,
        identifier: str = None,
        list: QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfoList = None,
    ):
        self.identifier = identifier
        self.list = list

    def validate(self):
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('List') is not None:
            temp_model = QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfoList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDevicePropertiesDataResponsePropertyDataInfos(TeaModel):
    def __init__(
        self,
        property_data_info: List[QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfo] = None,
    ):
        self.property_data_info = property_data_info

    def validate(self):
        self.validate_required(self.property_data_info, 'property_data_info')
        if self.property_data_info:
            for k in self.property_data_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PropertyDataInfo'] = []
        if self.property_data_info is not None:
            for k in self.property_data_info:
                result['PropertyDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.property_data_info = []
        if m.get('PropertyDataInfo') is not None:
            for k in m.get('PropertyDataInfo'):
                temp_model = QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfo()
                self.property_data_info.append(temp_model.from_map(k))
        return self


class QueryDevicePropertiesDataResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        next_valid: bool = None,
        next_time: int = None,
        property_data_infos: QueryDevicePropertiesDataResponsePropertyDataInfos = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.next_valid = next_valid
        self.next_time = next_time
        self.property_data_infos = property_data_infos

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.next_valid, 'next_valid')
        self.validate_required(self.next_time, 'next_time')
        self.validate_required(self.property_data_infos, 'property_data_infos')
        if self.property_data_infos:
            self.property_data_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.next_time is not None:
            result['NextTime'] = self.next_time
        if self.property_data_infos is not None:
            result['PropertyDataInfos'] = self.property_data_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('NextTime') is not None:
            self.next_time = m.get('NextTime')
        if m.get('PropertyDataInfos') is not None:
            temp_model = QueryDevicePropertiesDataResponsePropertyDataInfos()
            self.property_data_infos = temp_model.from_map(m['PropertyDataInfos'])
        return self


class UnbindRoleFromEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UnbindRoleFromEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class UpdateEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
        tags: str = None,
        spec: int = None,
        biz_enable: bool = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.name = name
        self.tags = tags
        self.spec = spec
        self.biz_enable = biz_enable

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.biz_enable is not None:
            result['BizEnable'] = self.biz_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('BizEnable') is not None:
            self.biz_enable = m.get('BizEnable')
        return self


class UpdateEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class GetEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetEdgeInstanceResponseData(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        name: str = None,
        tags: str = None,
        type: str = None,
        spec: int = None,
        biz_enable: bool = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        role_arn: str = None,
        role_name: str = None,
        role_attach_time: str = None,
        latest_deployment_status: int = None,
        latest_deployment_type: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        role_attach_timestamp: int = None,
    ):
        self.instance_id = instance_id
        self.name = name
        self.tags = tags
        self.type = type
        self.spec = spec
        self.biz_enable = biz_enable
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.role_arn = role_arn
        self.role_name = role_name
        self.role_attach_time = role_attach_time
        self.latest_deployment_status = latest_deployment_status
        self.latest_deployment_type = latest_deployment_type
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.role_attach_timestamp = role_attach_timestamp

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.tags, 'tags')
        self.validate_required(self.type, 'type')
        self.validate_required(self.spec, 'spec')
        self.validate_required(self.biz_enable, 'biz_enable')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.role_arn, 'role_arn')
        self.validate_required(self.role_name, 'role_name')
        self.validate_required(self.role_attach_time, 'role_attach_time')
        self.validate_required(self.latest_deployment_status, 'latest_deployment_status')
        self.validate_required(self.latest_deployment_type, 'latest_deployment_type')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.role_attach_timestamp, 'role_attach_timestamp')

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.biz_enable is not None:
            result['BizEnable'] = self.biz_enable
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.role_attach_time is not None:
            result['RoleAttachTime'] = self.role_attach_time
        if self.latest_deployment_status is not None:
            result['LatestDeploymentStatus'] = self.latest_deployment_status
        if self.latest_deployment_type is not None:
            result['LatestDeploymentType'] = self.latest_deployment_type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.role_attach_timestamp is not None:
            result['RoleAttachTimestamp'] = self.role_attach_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('BizEnable') is not None:
            self.biz_enable = m.get('BizEnable')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('RoleAttachTime') is not None:
            self.role_attach_time = m.get('RoleAttachTime')
        if m.get('LatestDeploymentStatus') is not None:
            self.latest_deployment_status = m.get('LatestDeploymentStatus')
        if m.get('LatestDeploymentType') is not None:
            self.latest_deployment_type = m.get('LatestDeploymentType')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('RoleAttachTimestamp') is not None:
            self.role_attach_timestamp = m.get('RoleAttachTimestamp')
        return self


class GetEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: GetEdgeInstanceResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        name: str = None,
        tags: str = None,
        spec: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.name = name
        self.tags = tags
        self.spec = spec

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class CreateEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        instance_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class QueryEdgeInstanceGatewayRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class QueryEdgeInstanceGatewayResponseGatewayList(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        edge_version: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.edge_version = edge_version

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.edge_version, 'edge_version')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        return self


class QueryEdgeInstanceGatewayResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        gateway_list: List[QueryEdgeInstanceGatewayResponseGatewayList] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.gateway_list = gateway_list

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.gateway_list, 'gateway_list')
        if self.gateway_list:
            for k in self.gateway_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['GatewayList'] = []
        if self.gateway_list is not None:
            for k in self.gateway_list:
                result['GatewayList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.gateway_list = []
        if m.get('GatewayList') is not None:
            for k in m.get('GatewayList'):
                temp_model = QueryEdgeInstanceGatewayResponseGatewayList()
                self.gateway_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceDeviceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryEdgeInstanceDeviceResponseDataDeviceList(TeaModel):
    def __init__(
        self,
        iot_id: str = None,
        product_key: str = None,
        device_name: str = None,
        driver_id: str = None,
    ):
        self.iot_id = iot_id
        self.product_key = product_key
        self.device_name = device_name
        self.driver_id = driver_id

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class QueryEdgeInstanceDeviceResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        device_list: List[QueryEdgeInstanceDeviceResponseDataDeviceList] = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.device_list = device_list

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.device_list, 'device_list')
        if self.device_list:
            for k in self.device_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['DeviceList'] = []
        if self.device_list is not None:
            for k in self.device_list:
                result['DeviceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.device_list = []
        if m.get('DeviceList') is not None:
            for k in m.get('DeviceList'):
                temp_model = QueryEdgeInstanceDeviceResponseDataDeviceList()
                self.device_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceDeviceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryEdgeInstanceDeviceResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BindGatewayToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BindGatewayToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        current_page: int = None,
        name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.current_page = current_page
        self.name = name

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class QueryEdgeInstanceResponseDataInstanceList(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        name: str = None,
        tags: str = None,
        type: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        role_arn: str = None,
        role_name: str = None,
        role_attach_time: str = None,
        spec: int = None,
        biz_enable: bool = None,
        latest_deployment_status: int = None,
        latest_deployment_type: str = None,
        gmt_create_timestamp: int = None,
        gmt_modified_timestamp: int = None,
        role_attach_timestamp: int = None,
    ):
        self.instance_id = instance_id
        self.name = name
        self.tags = tags
        self.type = type
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.role_arn = role_arn
        self.role_name = role_name
        self.role_attach_time = role_attach_time
        self.spec = spec
        self.biz_enable = biz_enable
        self.latest_deployment_status = latest_deployment_status
        self.latest_deployment_type = latest_deployment_type
        self.gmt_create_timestamp = gmt_create_timestamp
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.role_attach_timestamp = role_attach_timestamp

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.tags, 'tags')
        self.validate_required(self.type, 'type')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.role_arn, 'role_arn')
        self.validate_required(self.role_name, 'role_name')
        self.validate_required(self.role_attach_time, 'role_attach_time')
        self.validate_required(self.spec, 'spec')
        self.validate_required(self.biz_enable, 'biz_enable')
        self.validate_required(self.latest_deployment_status, 'latest_deployment_status')
        self.validate_required(self.latest_deployment_type, 'latest_deployment_type')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.role_attach_timestamp, 'role_attach_timestamp')

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.role_attach_time is not None:
            result['RoleAttachTime'] = self.role_attach_time
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.biz_enable is not None:
            result['BizEnable'] = self.biz_enable
        if self.latest_deployment_status is not None:
            result['LatestDeploymentStatus'] = self.latest_deployment_status
        if self.latest_deployment_type is not None:
            result['LatestDeploymentType'] = self.latest_deployment_type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.role_attach_timestamp is not None:
            result['RoleAttachTimestamp'] = self.role_attach_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('RoleAttachTime') is not None:
            self.role_attach_time = m.get('RoleAttachTime')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('BizEnable') is not None:
            self.biz_enable = m.get('BizEnable')
        if m.get('LatestDeploymentStatus') is not None:
            self.latest_deployment_status = m.get('LatestDeploymentStatus')
        if m.get('LatestDeploymentType') is not None:
            self.latest_deployment_type = m.get('LatestDeploymentType')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('RoleAttachTimestamp') is not None:
            self.role_attach_timestamp = m.get('RoleAttachTimestamp')
        return self


class QueryEdgeInstanceResponseData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        instance_list: List[QueryEdgeInstanceResponseDataInstanceList] = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.instance_list = instance_list

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.instance_list, 'instance_list')
        if self.instance_list:
            for k in self.instance_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['InstanceList'] = []
        if self.instance_list is not None:
            for k in self.instance_list:
                result['InstanceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.instance_list = []
        if m.get('InstanceList') is not None:
            for k in m.get('InstanceList'):
                temp_model = QueryEdgeInstanceResponseDataInstanceList()
                self.instance_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryEdgeInstanceResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        type: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.type = type

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        deployment_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.deployment_id = deployment_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.deployment_id, 'deployment_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        return self


class BindRoleToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        instance_id: str = None,
        role_arn: str = None,
        role_name: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.role_arn = role_arn
        self.role_name = role_name

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.role_arn, 'role_arn')
        self.validate_required(self.role_name, 'role_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        return self


class BindRoleToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QuerySuperDeviceGroupRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QuerySuperDeviceGroupResponseDataGroupInfo(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
        group_desc: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name
        self.group_desc = group_desc

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.group_desc, 'group_desc')

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        return self


class QuerySuperDeviceGroupResponseData(TeaModel):
    def __init__(
        self,
        group_info: List[QuerySuperDeviceGroupResponseDataGroupInfo] = None,
    ):
        self.group_info = group_info

    def validate(self):
        self.validate_required(self.group_info, 'group_info')
        if self.group_info:
            for k in self.group_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['GroupInfo'] = []
        if self.group_info is not None:
            for k in self.group_info:
                result['GroupInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.group_info = []
        if m.get('GroupInfo') is not None:
            for k in m.get('GroupInfo'):
                temp_model = QuerySuperDeviceGroupResponseDataGroupInfo()
                self.group_info.append(temp_model.from_map(k))
        return self


class QuerySuperDeviceGroupResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QuerySuperDeviceGroupResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QuerySuperDeviceGroupResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceByTagsRequestTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceByTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        tag: List[QueryDeviceByTagsRequestTag] = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.tag = tag
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = QueryDeviceByTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryDeviceByTagsResponseDataSimpleDeviceInfo(TeaModel):
    def __init__(
        self,
        product_name: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.product_name = product_name
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class QueryDeviceByTagsResponseData(TeaModel):
    def __init__(
        self,
        simple_device_info: List[QueryDeviceByTagsResponseDataSimpleDeviceInfo] = None,
    ):
        self.simple_device_info = simple_device_info

    def validate(self):
        self.validate_required(self.simple_device_info, 'simple_device_info')
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceByTagsResponseDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceByTagsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        page: int = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        data: QueryDeviceByTagsResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.page = page
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceByTagsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class SetDevicesPropertyRequest(TeaModel):
    def __init__(
        self,
        device_name: List[str] = None,
        iot_instance_id: str = None,
        product_key: str = None,
        items: str = None,
    ):
        self.device_name = device_name
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.items = items

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.items, 'items')

    def to_map(self):
        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.items is not None:
            result['Items'] = self.items
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Items') is not None:
            self.items = m.get('Items')
        return self


class SetDevicesPropertyResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class InvokeThingsServiceRequest(TeaModel):
    def __init__(
        self,
        device_name: List[str] = None,
        iot_instance_id: str = None,
        product_key: str = None,
        identifier: str = None,
        args: str = None,
    ):
        self.device_name = device_name
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.identifier = identifier
        self.args = args

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.args, 'args')

    def to_map(self):
        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.args is not None:
            result['Args'] = self.args
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Args') is not None:
            self.args = m.get('Args')
        return self


class InvokeThingsServiceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class SetDeviceGroupTagsRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
        tag_string: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id
        self.tag_string = tag_string

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.tag_string is not None:
            result['TagString'] = self.tag_string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('TagString') is not None:
            self.tag_string = m.get('TagString')
        return self


class SetDeviceGroupTagsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryAppDeviceListRequestTagList(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        tag_value: str = None,
    ):
        self.tag_name = tag_name
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryAppDeviceListRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key_list: List[str] = None,
        category_key_list: List[str] = None,
        app_key: str = None,
        tag_list: List[QueryAppDeviceListRequestTagList] = None,
        current_page: int = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key_list = product_key_list
        self.category_key_list = category_key_list
        self.app_key = app_key
        self.tag_list = tag_list
        self.current_page = current_page

    def validate(self):
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key_list is not None:
            result['ProductKeyList'] = self.product_key_list
        if self.category_key_list is not None:
            result['CategoryKeyList'] = self.category_key_list
        if self.app_key is not None:
            result['AppKey'] = self.app_key
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKeyList') is not None:
            self.product_key_list = m.get('ProductKeyList')
        if m.get('CategoryKeyList') is not None:
            self.category_key_list = m.get('CategoryKeyList')
        if m.get('AppKey') is not None:
            self.app_key = m.get('AppKey')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = QueryAppDeviceListRequestTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryAppDeviceListResponseDataData(TeaModel):
    def __init__(
        self,
        product_name: str = None,
        product_key: str = None,
        device_name: str = None,
        node_type: int = None,
        status: str = None,
        active_time: str = None,
        last_online_time: str = None,
        create_time: str = None,
        child_device_count: int = None,
        utc_active_time: str = None,
        utc_last_online_time: str = None,
        utc_create_time: str = None,
    ):
        self.product_name = product_name
        self.product_key = product_key
        self.device_name = device_name
        self.node_type = node_type
        self.status = status
        self.active_time = active_time
        self.last_online_time = last_online_time
        self.create_time = create_time
        self.child_device_count = child_device_count
        self.utc_active_time = utc_active_time
        self.utc_last_online_time = utc_last_online_time
        self.utc_create_time = utc_create_time

    def validate(self):
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.node_type, 'node_type')
        self.validate_required(self.status, 'status')
        self.validate_required(self.active_time, 'active_time')
        self.validate_required(self.last_online_time, 'last_online_time')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.child_device_count, 'child_device_count')
        self.validate_required(self.utc_active_time, 'utc_active_time')
        self.validate_required(self.utc_last_online_time, 'utc_last_online_time')
        self.validate_required(self.utc_create_time, 'utc_create_time')

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.status is not None:
            result['Status'] = self.status
        if self.active_time is not None:
            result['ActiveTime'] = self.active_time
        if self.last_online_time is not None:
            result['LastOnlineTime'] = self.last_online_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.child_device_count is not None:
            result['ChildDeviceCount'] = self.child_device_count
        if self.utc_active_time is not None:
            result['UtcActiveTime'] = self.utc_active_time
        if self.utc_last_online_time is not None:
            result['UtcLastOnlineTime'] = self.utc_last_online_time
        if self.utc_create_time is not None:
            result['UtcCreateTime'] = self.utc_create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ActiveTime') is not None:
            self.active_time = m.get('ActiveTime')
        if m.get('LastOnlineTime') is not None:
            self.last_online_time = m.get('LastOnlineTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChildDeviceCount') is not None:
            self.child_device_count = m.get('ChildDeviceCount')
        if m.get('UtcActiveTime') is not None:
            self.utc_active_time = m.get('UtcActiveTime')
        if m.get('UtcLastOnlineTime') is not None:
            self.utc_last_online_time = m.get('UtcLastOnlineTime')
        if m.get('UtcCreateTime') is not None:
            self.utc_create_time = m.get('UtcCreateTime')
        return self


class QueryAppDeviceListResponseData(TeaModel):
    def __init__(
        self,
        data: List[QueryAppDeviceListResponseDataData] = None,
    ):
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryAppDeviceListResponseDataData()
                self.data.append(temp_model.from_map(k))
        return self


class QueryAppDeviceListResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        page: int = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        data: QueryAppDeviceListResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.page = page
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryAppDeviceListResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateDeviceGroupRequest(TeaModel):
    def __init__(
        self,
        iot_instance_id: str = None,
        group_id: str = None,
        group_desc: str = None,
    ):
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id
        self.group_desc = group_desc

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['I