(globalThis["webpackChunkunblock"] = globalThis["webpackChunkunblock"] || []).push([[8135],{

/***/ 2768:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports["default"] = void 0;

var _propTypes = _interopRequireDefault(__webpack_require__(45697));

var _react = _interopRequireDefault(__webpack_require__(67294));

var _lodash = __webpack_require__(96486);

var _core = __webpack_require__(67017);

var _Tooltip = _interopRequireDefault(__webpack_require__(29379));

var _react2 = __webpack_require__(11965);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const StyledDiv = _core.styled.div`
  margin-bottom: ${({
  theme
}) => theme.gridUnit * 2}px;
`;

function CertifiedIconWithTooltip({
  certifiedBy,
  details,
  metricName
}) {
  const theme = (0, _core.useTheme)();
  return (0, _react2.jsx)(_Tooltip.default, {
    id: `${(0, _lodash.kebabCase)(metricName)}-tooltip`,
    title: (0, _react2.jsx)("div", null, certifiedBy && (0, _react2.jsx)(StyledDiv, null, (0, _core.t)('Certified by %s', certifiedBy)), (0, _react2.jsx)("div", null, details))
  }, (0, _react2.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    enableBackground: "new 0 0 24 24",
    height: "16",
    viewBox: "0 0 24 24",
    width: "16"
  }, (0, _react2.jsx)("g", null, (0, _react2.jsx)("path", {
    fill: theme.colors.primary.base,
    d: "M23,12l-2.44-2.79l0.34-3.69l-3.61-0.82L15.4,1.5L12,2.96L8.6,1.5L6.71,4.69L3.1,5.5L3.44,9.2L1,12l2.44,2.79l-0.34,3.7 l3.61,0.82L8.6,22.5l3.4-1.47l3.4,1.46l1.89-3.19l3.61-0.82l-0.34-3.69L23,12z M9.38,16.01L7,13.61c-0.39-0.39-0.39-1.02,0-1.41 l0.07-0.07c0.39-0.39,1.03-0.39,1.42,0l1.61,1.62l5.15-5.16c0.39-0.39,1.03-0.39,1.42,0l0.07,0.07c0.39,0.39,0.39,1.02,0,1.41 l-5.92,5.94C10.41,16.4,9.78,16.4,9.38,16.01z"
  }))));
}

CertifiedIconWithTooltip.propTypes = {
  certifiedBy: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.oneOf([null])]),
  details: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.oneOf([null])]),
  metricName: _propTypes.default.string.isRequired
};
var _default = CertifiedIconWithTooltip;
exports["default"] = _default;

/***/ }),

/***/ 30027:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.ColumnOption = ColumnOption;
exports["default"] = void 0;

var _propTypes = _interopRequireDefault(__webpack_require__(45697));

var _react = _interopRequireDefault(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _Tooltip = __webpack_require__(29379);

var _ColumnTypeLabel = __webpack_require__(81984);

var _InfoTooltipWithTrigger = _interopRequireDefault(__webpack_require__(24481));

var _CertifiedIconWithTooltip = _interopRequireDefault(__webpack_require__(2768));

var _react2 = __webpack_require__(11965);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const StyleOverrides = _core.styled.span`
  svg {
    margin-right: ${({
  theme
}) => theme.gridUnit}px;
  }
`;

function ColumnOption({
  column,
  labelRef,
  showType = false,
  showTooltip = true
}) {
  const {
    expression,
    column_name,
    type_generic
  } = column;
  const hasExpression = expression && expression !== column_name;
  const type = hasExpression ? 'expression' : type_generic;
  return (0, _react2.jsx)(StyleOverrides, null, showType && type !== undefined && (0, _react2.jsx)(_ColumnTypeLabel.ColumnTypeLabel, {
    type: type
  }), column.is_certified && (0, _react2.jsx)(_CertifiedIconWithTooltip.default, {
    metricName: column.metric_name,
    certifiedBy: column.certified_by,
    details: column.certification_details
  }), showTooltip ? (0, _react2.jsx)(_Tooltip.Tooltip, {
    id: "metric-name-tooltip",
    title: column.verbose_name || column.column_name,
    trigger: ['hover'],
    placement: "top"
  }, (0, _react2.jsx)("span", {
    className: "m-r-5 option-label column-option-label",
    ref: labelRef
  }, column.verbose_name || column.column_name)) : (0, _react2.jsx)("span", {
    className: "m-r-5 option-label column-option-label",
    ref: labelRef
  }, column.verbose_name || column.column_name), column.description && (0, _react2.jsx)(_InfoTooltipWithTrigger.default, {
    className: "m-r-5 text-muted",
    icon: "info",
    tooltip: column.description,
    label: `descr-${column.column_name}`,
    placement: "top"
  }), hasExpression && (0, _react2.jsx)(_InfoTooltipWithTrigger.default, {
    className: "m-r-5 text-muted",
    icon: "question-circle-o",
    tooltip: column.expression,
    label: `expr-${column.column_name}`,
    placement: "top"
  }));
}

ColumnOption.propTypes = {
  showType: _propTypes.default.bool,
  showTooltip: _propTypes.default.bool
};
var _default = ColumnOption;
exports["default"] = _default;

/***/ }),

/***/ 81984:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.ColumnTypeLabel = ColumnTypeLabel;
exports["default"] = void 0;

var _propTypes = _interopRequireDefault(__webpack_require__(45697));

var _core = __webpack_require__(67017);

var _react = _interopRequireDefault(__webpack_require__(67294));

var _react2 = __webpack_require__(11965);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable no-nested-ternary */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function ColumnTypeLabel({
  type
}) {
  let stringIcon = '?';

  if (type === '' || type === 'expression') {
    stringIcon = 'ƒ';
  } else if (type === 'aggregate') {
    stringIcon = 'AGG';
  } else if (type === _core.GenericDataType.STRING) {
    stringIcon = 'ABC';
  } else if (type === _core.GenericDataType.NUMERIC) {
    stringIcon = '#';
  } else if (type === _core.GenericDataType.BOOLEAN) {
    stringIcon = 'T/F';
  } else if (type === _core.GenericDataType.TEMPORAL) {
    stringIcon = 'time';
  }

  const typeIcon = stringIcon === 'time' ? (0, _react2.jsx)("i", {
    className: "fa fa-clock-o type-label"
  }) : (0, _react2.jsx)("div", {
    className: "type-label"
  }, stringIcon);
  return (0, _react2.jsx)("span", null, typeIcon);
}

var _default = ColumnTypeLabel;
exports["default"] = _default;

/***/ }),

/***/ 72906:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
var _exportNames = {
  ControlFormItem: true
};
exports.ControlFormItem = ControlFormItem;
exports["default"] = void 0;

var _react = __webpack_require__(11965);

var _propTypes = _interopRequireDefault(__webpack_require__(45697));

var _react2 = _interopRequireWildcard(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _ControlHeader = _interopRequireDefault(__webpack_require__(85961));

var _InfoTooltipWithTrigger = _interopRequireDefault(__webpack_require__(24481));

var _controls = __webpack_require__(63657);

Object.keys(_controls).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _controls[key]) return;
  exports[key] = _controls[key];
});

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Accept `false` or `0`, but not empty string.
 */
function isEmptyValue(value) {
  return value == null || value === '';
}

function ControlFormItem({
  name,
  label,
  description,
  width,
  validators,
  required,
  onChange,
  value: initialValue,
  defaultValue,
  controlType,
  ...props
}) {
  const {
    gridUnit
  } = (0, _core.useTheme)();
  const [hovered, setHovered] = (0, _react2.useState)(false);
  const [value, setValue] = (0, _react2.useState)(initialValue === undefined ? defaultValue : initialValue);
  const [validationErrors, setValidationErrors] = (0, _react2.useState)();

  const handleChange = e => {
    const fieldValue = e && typeof e === 'object' && 'target' in e ? e.target.type === 'checkbox' || e.target.type === 'radio' ? e.target.checked : e.target.value : e;
    const errors = (validators == null ? void 0 : validators.map(validator => !required && isEmptyValue(fieldValue) ? false : validator(fieldValue)).filter(x => !!x)) || [];
    setValidationErrors(errors);
    setValue(fieldValue);

    if (errors.length === 0 && onChange) {
      onChange(fieldValue);
    }
  };

  const Control = _controls.ControlFormItemComponents[controlType];
  return (0, _react.jsx)("div", {
    css: /*#__PURE__*/(0, _react.css)({
      margin: 2 * gridUnit,
      width
    },  true ? "" : 0,  true ? "" : 0),
    onMouseEnter: () => setHovered(true),
    onMouseLeave: () => setHovered(false)
  }, controlType === 'Checkbox' ? (0, _react.jsx)(_controls.ControlFormItemComponents.Checkbox, {
    checked: value,
    onChange: handleChange
  }, label, " ", hovered && description && (0, _react.jsx)(_InfoTooltipWithTrigger.default, {
    tooltip: description
  })) : (0, _react.jsx)(_react2.default.Fragment, null, label && (0, _react.jsx)(_ControlHeader.default, {
    name: name,
    label: label,
    description: description,
    validationErrors: validationErrors,
    hovered: hovered,
    required: required
  }), (0, _react.jsx)(Control, _extends({}, props, {
    value: value,
    onChange: handleChange
  }))));
}

ControlFormItem.propTypes = {
  name: _propTypes.default.string.isRequired,
  onChange: _propTypes.default.func
};
var _default = ControlFormItem;
exports["default"] = _default;

/***/ }),

/***/ 63657:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.ControlFormItemComponents = void 0;

var _antd = __webpack_require__(76951);

var _checkbox = _interopRequireDefault(__webpack_require__(31059));

var _Select = _interopRequireDefault(__webpack_require__(76732));

var _RadioButtonControl = _interopRequireDefault(__webpack_require__(66666));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const ControlFormItemComponents = {
  Slider: _antd.Slider,
  InputNumber: _antd.InputNumber,
  Input: _antd.Input,
  Select: _Select.default,
  // Directly export Checkbox will result in "using name from external module" error
  // ref: https://stackoverflow.com/questions/43900035/ts4023-exported-variable-x-has-or-is-using-name-y-from-external-module-but
  Checkbox: _checkbox.default,
  RadioButtonControl: _RadioButtonControl.default
};
exports.ControlFormItemComponents = ControlFormItemComponents;

/***/ }),

/***/ 5537:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
var _exportNames = {
  ControlFormRow: true
};
exports.ControlFormRow = ControlFormRow;
exports["default"] = ControlForm;

var _react = __webpack_require__(11965);

var _propTypes = _interopRequireDefault(__webpack_require__(45697));

var _react2 = _interopRequireWildcard(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _lodash = __webpack_require__(96486);

var _ControlFormItem = __webpack_require__(72906);

Object.keys(_ControlFormItem).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _ControlFormItem[key]) return;
  exports[key] = _ControlFormItem[key];
});

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function ControlFormRow({
  children
}) {
  const {
    gridUnit
  } = (0, _core.useTheme)();
  return (0, _react.jsx)("div", {
    css: /*#__PURE__*/(0, _react.css)({
      display: 'flex',
      flexWrap: 'nowrap',
      margin: -2 * gridUnit,
      marginBottom: gridUnit
    },  true ? "" : 0,  true ? "" : 0)
  }, children);
}

/**
 * Light weight form for control panel.
 */
function ControlForm({
  onChange,
  value,
  children
}) {
  const theme = (0, _core.useTheme)();
  const debouncedOnChange = (0, _react2.useMemo)(() => ({
    0: onChange,
    [_core.FAST_DEBOUNCE]: (0, _lodash.debounce)(onChange, _core.FAST_DEBOUNCE)
  }), [onChange]);

  const updatedChildren = _react2.default.Children.map(children, row => {
    if ('children' in row.props) {
      const defaultWidth = Array.isArray(row.props.children) ? `${100 / row.props.children.length}%` : undefined;
      return /*#__PURE__*/_react2.default.cloneElement(row, {
        children: _react2.default.Children.map(row.props.children, item => {
          const {
            name,
            width,
            debounceDelay = _core.FAST_DEBOUNCE,
            onChange: onItemValueChange
          } = item.props;
          return /*#__PURE__*/_react2.default.cloneElement(item, {
            width: width || defaultWidth,
            value: value == null ? void 0 : value[name],
            // remove `debounceDelay` from rendered control item props
            // so React DevTools don't throw a `invalid prop` warning.
            debounceDelay: undefined,

            onChange(fieldValue) {
              // call `onChange` on each FormItem
              if (onItemValueChange) {
                onItemValueChange(fieldValue);
              } // propagate to the form


              if (!(debounceDelay in debouncedOnChange)) {
                debouncedOnChange[debounceDelay] = (0, _lodash.debounce)(onChange, debounceDelay);
              }

              debouncedOnChange[debounceDelay]({ ...value,
                [name]: fieldValue
              });
            }

          });
        })
      });
    }

    return row;
  });

  return (0, _react.jsx)("div", {
    css: /*#__PURE__*/(0, _react.css)({
      label: {
        textTransform: 'uppercase',
        color: theme.colors.text.label,
        fontSize: theme.typography.sizes.s
      }
    },  true ? "" : 0,  true ? "" : 0)
  }, updatedChildren);
}

ControlForm.propTypes = {
  onChange: _propTypes.default.func.isRequired,
  children: _propTypes.default.oneOfType([_propTypes.default.element, _propTypes.default.arrayOf(_propTypes.default.element)]).isRequired
};

/***/ }),

/***/ 85961:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports["default"] = ControlHeader;

var _propTypes = _interopRequireDefault(__webpack_require__(45697));

var _react = _interopRequireDefault(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _InfoTooltipWithTrigger = __webpack_require__(24481);

var _Tooltip = __webpack_require__(29379);

var _react2 = __webpack_require__(11965);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function ControlHeader({
  name,
  description,
  label,
  tooltipOnClick,
  onClick,
  warning,
  danger,
  leftNode,
  rightNode,
  validationErrors = [],
  renderTrigger = false,
  hovered = false,
  required = false
}) {
  const renderOptionalIcons = () => {
    if (hovered) {
      return (0, _react2.jsx)("span", null, description && (0, _react2.jsx)("span", null, (0, _react2.jsx)(_InfoTooltipWithTrigger.InfoTooltipWithTrigger, {
        label: (0, _core.t)('description'),
        tooltip: description,
        placement: "top",
        onClick: tooltipOnClick
      }), ' '), renderTrigger && (0, _react2.jsx)("span", null, (0, _react2.jsx)(_InfoTooltipWithTrigger.InfoTooltipWithTrigger, {
        label: (0, _core.t)('bolt'),
        tooltip: (0, _core.t)('Changing this control takes effect instantly'),
        placement: "top",
        icon: "bolt"
      }), ' '));
    }

    return null;
  };

  if (!label) {
    return null;
  }

  const labelClass = validationErrors.length > 0 ? 'text-danger' : '';
  return (0, _react2.jsx)("div", {
    className: "ControlHeader",
    "data-test": `${name}-header`
  }, (0, _react2.jsx)("div", {
    className: "pull-left"
  }, (0, _react2.jsx)("label", {
    className: "control-label",
    htmlFor: name
  }, leftNode && (0, _react2.jsx)("span", null, leftNode), (0, _react2.jsx)("span", {
    role: "button",
    tabIndex: 0,
    onClick: onClick,
    className: labelClass,
    style: {
      cursor: onClick ? 'pointer' : ''
    }
  }, label), ' ', warning && (0, _react2.jsx)("span", null, (0, _react2.jsx)(_Tooltip.Tooltip, {
    id: "error-tooltip",
    placement: "top",
    title: warning
  }, (0, _react2.jsx)("i", {
    className: "fa fa-exclamation-circle text-warning"
  })), ' '), danger && (0, _react2.jsx)("span", null, (0, _react2.jsx)(_Tooltip.Tooltip, {
    id: "error-tooltip",
    placement: "top",
    title: danger
  }, (0, _react2.jsx)("i", {
    className: "fa fa-exclamation-circle text-danger"
  })), ' '), validationErrors.length > 0 && (0, _react2.jsx)("span", null, (0, _react2.jsx)(_Tooltip.Tooltip, {
    id: "error-tooltip",
    placement: "top",
    title: validationErrors.join(' ')
  }, (0, _react2.jsx)("i", {
    className: "fa fa-exclamation-circle text-danger"
  })), ' '), renderOptionalIcons(), required && (0, _react2.jsx)("span", {
    className: "text-danger m-l-4"
  }, (0, _react2.jsx)("strong", null, "*")))), rightNode && (0, _react2.jsx)("div", {
    className: "pull-right"
  }, rightNode), (0, _react2.jsx)("div", {
    className: "clearfix"
  }));
}

ControlHeader.propTypes = {
  name: _propTypes.default.string,
  label: _propTypes.default.node,
  description: _propTypes.default.node,
  validationErrors: _propTypes.default.arrayOf(_propTypes.default.string),
  renderTrigger: _propTypes.default.bool,
  rightNode: _propTypes.default.node,
  leftNode: _propTypes.default.node,
  hovered: _propTypes.default.bool,
  required: _propTypes.default.bool,
  warning: _propTypes.default.string,
  danger: _propTypes.default.string,
  onClick: _propTypes.default.func,
  tooltipOnClick: _propTypes.default.func
};

/***/ }),

/***/ 24481:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.InfoTooltipWithTrigger = InfoTooltipWithTrigger;
exports["default"] = void 0;

var _propTypes = _interopRequireDefault(__webpack_require__(45697));

var _react = _interopRequireDefault(__webpack_require__(67294));

var _lodash = __webpack_require__(96486);

var _core = __webpack_require__(67017);

var _Tooltip = __webpack_require__(29379);

var _react2 = __webpack_require__(11965);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function InfoTooltipWithTrigger({
  label,
  tooltip,
  bsStyle,
  onClick,
  icon = 'info-circle',
  className = 'text-muted',
  placement = 'right'
}) {
  const iconClass = `fa fa-${icon} ${className} ${bsStyle ? `text-${bsStyle}` : ''}`;
  const iconEl = (0, _react2.jsx)("i", {
    role: "button",
    "aria-label": (0, _core.t)('Show info tooltip'),
    tabIndex: 0,
    className: iconClass,
    style: {
      cursor: onClick ? 'pointer' : undefined
    },
    onClick: onClick,
    onKeyPress: onClick && (event => {
      if (event.key === 'Enter' || event.key === ' ') {
        onClick();
      }
    })
  });

  if (!tooltip) {
    return iconEl;
  }

  return (0, _react2.jsx)(_Tooltip.Tooltip, {
    id: `${(0, _lodash.kebabCase)(label)}-tooltip`,
    title: tooltip,
    placement: placement
  }, iconEl);
}

InfoTooltipWithTrigger.propTypes = {
  label: _propTypes.default.string,
  icon: _propTypes.default.string,
  onClick: _propTypes.default.func,
  bsStyle: _propTypes.default.string,
  className: _propTypes.default.string
};
var _default = InfoTooltipWithTrigger;
exports["default"] = _default;

/***/ }),

/***/ 90875:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.MetricOption = MetricOption;

var _propTypes = _interopRequireDefault(__webpack_require__(45697));

var _react = _interopRequireDefault(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _InfoTooltipWithTrigger = _interopRequireDefault(__webpack_require__(24481));

var _ColumnTypeLabel = __webpack_require__(81984);

var _CertifiedIconWithTooltip = _interopRequireDefault(__webpack_require__(2768));

var _Tooltip = _interopRequireDefault(__webpack_require__(29379));

var _react2 = __webpack_require__(11965);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const FlexRowContainer = _core.styled.div`
  align-items: center;
  display: flex;

  > svg {
    margin-right: ${({
  theme
}) => theme.gridUnit}px;
  }
`;

function MetricOption({
  metric,
  labelRef,
  openInNewWindow = false,
  showFormula = true,
  showType = false,
  showTooltip = true,
  url = ''
}) {
  const verbose = metric.verbose_name || metric.metric_name || metric.label;
  const link = url ? (0, _react2.jsx)("a", {
    href: url,
    target: openInNewWindow ? '_blank' : '',
    rel: "noreferrer"
  }, verbose) : verbose;
  const warningMarkdown = metric.warning_markdown || metric.warning_text;
  return (0, _react2.jsx)(FlexRowContainer, {
    className: "metric-option"
  }, showType && (0, _react2.jsx)(_ColumnTypeLabel.ColumnTypeLabel, {
    type: "expression"
  }), metric.is_certified && (0, _react2.jsx)(_CertifiedIconWithTooltip.default, {
    metricName: metric.metric_name,
    certifiedBy: metric.certified_by,
    details: metric.certification_details
  }), showTooltip ? (0, _react2.jsx)(_Tooltip.default, {
    id: "metric-name-tooltip",
    title: verbose,
    trigger: ['hover'],
    placement: "top"
  }, (0, _react2.jsx)("span", {
    className: "option-label metric-option-label",
    ref: labelRef
  }, link)) : (0, _react2.jsx)("span", {
    className: "option-label metric-option-label",
    ref: labelRef
  }, link), metric.description && (0, _react2.jsx)(_InfoTooltipWithTrigger.default, {
    className: "text-muted",
    icon: "info",
    tooltip: metric.description,
    label: `descr-${metric.metric_name}`
  }), showFormula && (0, _react2.jsx)(_InfoTooltipWithTrigger.default, {
    className: "text-muted",
    icon: "question-circle-o",
    tooltip: metric.expression,
    label: `expr-${metric.metric_name}`
  }), warningMarkdown && (0, _react2.jsx)(_InfoTooltipWithTrigger.default, {
    className: "text-warning",
    icon: "warning",
    tooltip: (0, _react2.jsx)(_core.SafeMarkdown, {
      source: warningMarkdown
    }),
    label: `warn-${metric.metric_name}`
  }));
}

MetricOption.propTypes = {
  openInNewWindow: _propTypes.default.bool,
  showFormula: _propTypes.default.bool,
  showType: _propTypes.default.bool,
  showTooltip: _propTypes.default.bool,
  url: _propTypes.default.string
};

/***/ }),

/***/ 76732:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.Option = void 0;
exports["default"] = Select;

var _react = __webpack_require__(11965);

var _propTypes = _interopRequireDefault(__webpack_require__(45697));

var _react2 = _interopRequireWildcard(__webpack_require__(67294));

var _select = _interopRequireDefault(__webpack_require__(64749));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const {
  Option
} = _select.default;
exports.Option = Option;

/**
 * AntD select with creatable options.
 */
function Select({
  creatable,
  onSearch,
  dropdownMatchSelectWidth = false,
  minWidth = '100%',
  showSearch: showSearch_ = true,
  onChange,
  options,
  children,
  value,
  ...props
}) {
  const [searchValue, setSearchValue] = (0, _react2.useState)(); // force show search if creatable

  const showSearch = showSearch_ || creatable;
  const handleSearch = showSearch ? input => {
    if (creatable) {
      setSearchValue(input);
    }

    if (onSearch) {
      onSearch(input);
    }
  } : undefined;
  const optionsHasSearchValue = options == null ? void 0 : options.some(([val]) => val === searchValue);
  const optionsHasValue = options == null ? void 0 : options.some(([val]) => val === value);
  const handleChange = showSearch ? (val, opt) => {
    // reset input value once selected
    setSearchValue('');

    if (onChange) {
      onChange(val, opt);
    }
  } : onChange;
  return (0, _react.jsx)(_select.default, _extends({
    dropdownMatchSelectWidth: dropdownMatchSelectWidth,
    showSearch: showSearch,
    onSearch: handleSearch,
    onChange: handleChange,
    value: value
  }, props, {
    css: /*#__PURE__*/(0, _react.css)({
      minWidth
    },  true ? "" : 0,  true ? "" : 0)
  }), options == null ? void 0 : options.map(([val, label]) => (0, _react.jsx)(Option, {
    value: val
  }, label)), children, value && !optionsHasValue && (0, _react.jsx)(Option, {
    key: value,
    value: value
  }, value), searchValue && !optionsHasSearchValue && (0, _react.jsx)(Option, {
    key: searchValue,
    value: searchValue
  }, searchValue));
}

Select.propTypes = {
  creatable: _propTypes.default.bool,
  minWidth: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  options: _propTypes.default.array
};
Select.Option = Option;

/***/ }),

/***/ 29379:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports["default"] = exports.TooltipProps = exports.Tooltip = void 0;

var _react = _interopRequireDefault(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _antd = __webpack_require__(76951);

var _react2 = __webpack_require__(11965);

var _tooltip = __webpack_require__(94055);

exports.TooltipProps = _tooltip.TooltipProps;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const Tooltip = ({
  overlayStyle,
  color,
  ...props
}) => {
  const theme = (0, _core.useTheme)();
  const defaultColor = `${theme.colors.grayscale.dark2}e6`;
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_react2.Global, {
    styles: (0, _core.css)`
          .ant-tooltip-open {
            display: inline-block;
            &::after {
              content: '';
              display: block;
            }
          }
        `
  }), (0, _react2.jsx)(_antd.Tooltip, _extends({
    overlayStyle: {
      fontSize: theme.typography.sizes.s,
      lineHeight: '1.6',
      ...overlayStyle
    },
    color: defaultColor || color
  }, props)));
};

exports.Tooltip = Tooltip;
var _default = Tooltip;
exports["default"] = _default;

/***/ }),

/***/ 22320:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.TIME_FILTER_LABELS = exports.TIME_COLUMN_OPTION = exports.QueryModeLabel = exports.COLUMN_NAME_ALIASES = void 0;

var _core = __webpack_require__(67017);

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// eslint-disable-next-line import/prefer-default-export
const TIME_FILTER_LABELS = {
  time_range: (0, _core.t)('Time Range'),
  granularity_sqla: (0, _core.t)('Time Column'),
  time_grain_sqla: (0, _core.t)('Time Grain'),
  druid_time_origin: (0, _core.t)('Origin'),
  granularity: (0, _core.t)('Time Granularity')
};
exports.TIME_FILTER_LABELS = TIME_FILTER_LABELS;
const COLUMN_NAME_ALIASES = {
  [_core.DTTM_ALIAS]: (0, _core.t)('Time')
};
exports.COLUMN_NAME_ALIASES = COLUMN_NAME_ALIASES;
const TIME_COLUMN_OPTION = {
  verbose_name: COLUMN_NAME_ALIASES[_core.DTTM_ALIAS],
  column_name: _core.DTTM_ALIAS,
  type_generic: _core.GenericDataType.TEMPORAL,
  description: (0, _core.t)('A reference to the [Time] configuration, taking granularity into account')
};
exports.TIME_COLUMN_OPTION = TIME_COLUMN_OPTION;
const QueryModeLabel = {
  [_core.QueryMode.aggregate]: (0, _core.t)('Aggregate'),
  [_core.QueryMode.raw]: (0, _core.t)('Raw records')
};
exports.QueryModeLabel = QueryModeLabel;

/***/ }),

/***/ 27524:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
var _exportNames = {
  sections: true,
  sharedControls: true,
  dndEntity: true,
  dndColumnsControl: true,
  sharedControlComponents: true,
  legacySortBy: true
};
exports.sharedControls = exports.sharedControlComponents = exports.sections = exports.legacySortBy = exports.dndEntity = exports.dndColumnsControl = void 0;

var sectionsModule = _interopRequireWildcard(__webpack_require__(76539));

var _utils = __webpack_require__(57639);

Object.keys(_utils).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _utils[key]) return;
  exports[key] = _utils[key];
});

var _constants = __webpack_require__(22320);

Object.keys(_constants).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _constants[key]) return;
  exports[key] = _constants[key];
});

var _operators = __webpack_require__(17656);

Object.keys(_operators).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _operators[key]) return;
  exports[key] = _operators[key];
});

var _InfoTooltipWithTrigger = __webpack_require__(24481);

Object.keys(_InfoTooltipWithTrigger).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _InfoTooltipWithTrigger[key]) return;
  exports[key] = _InfoTooltipWithTrigger[key];
});

var _ColumnOption = __webpack_require__(30027);

Object.keys(_ColumnOption).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _ColumnOption[key]) return;
  exports[key] = _ColumnOption[key];
});

var _ColumnTypeLabel = __webpack_require__(81984);

Object.keys(_ColumnTypeLabel).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _ColumnTypeLabel[key]) return;
  exports[key] = _ColumnTypeLabel[key];
});

var _MetricOption = __webpack_require__(90875);

Object.keys(_MetricOption).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _MetricOption[key]) return;
  exports[key] = _MetricOption[key];
});

var _sharedControls = __webpack_require__(25987);

exports.sharedControls = _sharedControls.sharedControls;
exports.dndEntity = _sharedControls.dndEntity;
exports.dndColumnsControl = _sharedControls.dndColumnsControl;

var _components = _interopRequireWildcard(__webpack_require__(12330));

exports.sharedControlComponents = _components.default;
Object.keys(_components).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _components[key]) return;
  exports[key] = _components[key];
});

var _legacySortBy = __webpack_require__(36602);

exports.legacySortBy = _legacySortBy.legacySortBy;

var _emitFilterControl = __webpack_require__(17592);

Object.keys(_emitFilterControl).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _emitFilterControl[key]) return;
  exports[key] = _emitFilterControl[key];
});

var _types = __webpack_require__(95424);

Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  exports[key] = _types[key];
});

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// can't do `export * as sections from './sections'`, babel-transformer will fail
const sections = sectionsModule;
exports.sections = sections;

/***/ }),

/***/ 44008:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.boxplotOperator = void 0;

var _core = __webpack_require__(67017);

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitationsxw
 * under the License.
 */
const PERCENTILE_REGEX = /(\d+)\/(\d+) percentiles/;

const boxplotOperator = (formData, queryObject) => {
  const {
    groupby,
    whiskerOptions
  } = formData;

  if (whiskerOptions) {
    let whiskerType;
    let percentiles;
    const percentileMatch = PERCENTILE_REGEX.exec(whiskerOptions);

    if (whiskerOptions === 'Tukey' || !whiskerOptions) {
      whiskerType = 'tukey';
    } else if (whiskerOptions === 'Min/max (no outliers)') {
      whiskerType = 'min/max';
    } else if (percentileMatch) {
      whiskerType = 'percentile';
      percentiles = [parseInt(percentileMatch[1], 10), parseInt(percentileMatch[2], 10)];
    } else {
      throw new Error(`Unsupported whisker type: ${whiskerOptions}`);
    }

    return {
      operation: 'boxplot',
      options: {
        whisker_type: whiskerType,
        percentiles,
        groupby: (0, _core.ensureIsArray)(groupby),
        metrics: (0, _core.ensureIsArray)(queryObject.metrics).map(_core.getMetricLabel)
      }
    };
  }

  return undefined;
};

exports.boxplotOperator = boxplotOperator;

/***/ }),

/***/ 22938:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.__esModule = true;
exports.contributionOperator = void 0;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitationsxw
 * under the License.
 */
const contributionOperator = (formData, queryObject) => {
  if (formData.contributionMode) {
    return {
      operation: 'contribution',
      options: {
        orientation: formData.contributionMode
      }
    };
  }

  return undefined;
};

exports.contributionOperator = contributionOperator;

/***/ }),

/***/ 17656:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
var _exportNames = {
  rollingWindowOperator: true,
  timeCompareOperator: true,
  timeComparePivotOperator: true,
  sortOperator: true,
  pivotOperator: true,
  resampleOperator: true,
  contributionOperator: true,
  prophetOperator: true,
  boxplotOperator: true
};
exports.timeComparePivotOperator = exports.timeCompareOperator = exports.sortOperator = exports.rollingWindowOperator = exports.resampleOperator = exports.prophetOperator = exports.pivotOperator = exports.contributionOperator = exports.boxplotOperator = void 0;

var _rollingWindowOperator = __webpack_require__(79768);

exports.rollingWindowOperator = _rollingWindowOperator.rollingWindowOperator;

var _timeCompareOperator = __webpack_require__(53917);

exports.timeCompareOperator = _timeCompareOperator.timeCompareOperator;

var _timeComparePivotOperator = __webpack_require__(62335);

exports.timeComparePivotOperator = _timeComparePivotOperator.timeComparePivotOperator;

var _sortOperator = __webpack_require__(16505);

exports.sortOperator = _sortOperator.sortOperator;

var _pivotOperator = __webpack_require__(95218);

exports.pivotOperator = _pivotOperator.pivotOperator;

var _resampleOperator = __webpack_require__(2558);

exports.resampleOperator = _resampleOperator.resampleOperator;

var _contributionOperator = __webpack_require__(22938);

exports.contributionOperator = _contributionOperator.contributionOperator;

var _prophetOperator = __webpack_require__(83899);

exports.prophetOperator = _prophetOperator.prophetOperator;

var _boxplotOperator = __webpack_require__(44008);

exports.boxplotOperator = _boxplotOperator.boxplotOperator;

var _utils = __webpack_require__(93425);

Object.keys(_utils).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _utils[key]) return;
  exports[key] = _utils[key];
});

/***/ }),

/***/ 95218:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.pivotOperator = void 0;

var _core = __webpack_require__(67017);

var _utils = __webpack_require__(93425);

var _timeComparePivotOperator = __webpack_require__(62335);

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitationsxw
 * under the License.
 */
const pivotOperator = (formData, queryObject) => {
  const metricLabels = (0, _core.ensureIsArray)(queryObject.metrics).map(_core.getMetricLabel);

  if (queryObject.is_timeseries && metricLabels.length) {
    if ((0, _utils.isValidTimeCompare)(formData, queryObject)) {
      return (0, _timeComparePivotOperator.timeComparePivotOperator)(formData, queryObject);
    }

    return {
      operation: 'pivot',
      options: {
        index: [_utils.TIME_COLUMN],
        columns: queryObject.columns || [],
        // Create 'dummy' mean aggregates to assign cell values in pivot table
        // use the 'mean' aggregates to avoid drop NaN. PR: https://github.com/apache-superset/superset-ui/pull/1231
        aggregates: Object.fromEntries(metricLabels.map(metric => [metric, {
          operator: 'mean'
        }])),
        drop_missing_columns: false
      }
    };
  }

  return undefined;
};

exports.pivotOperator = pivotOperator;

/***/ }),

/***/ 83899:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.__esModule = true;
exports.prophetOperator = void 0;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitationsxw
 * under the License.
 */
const prophetOperator = (formData, queryObject) => {
  if (formData.forecastEnabled) {
    return {
      operation: 'prophet',
      options: {
        time_grain: formData.time_grain_sqla,
        periods: parseInt(formData.forecastPeriods, 10),
        confidence_interval: parseFloat(formData.forecastInterval),
        yearly_seasonality: formData.forecastSeasonalityYearly,
        weekly_seasonality: formData.forecastSeasonalityWeekly,
        daily_seasonality: formData.forecastSeasonalityDaily
      }
    };
  }

  return undefined;
};

exports.prophetOperator = prophetOperator;

/***/ }),

/***/ 2558:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.resampleOperator = void 0;

var _utils = __webpack_require__(93425);

/* eslint-disable camelcase */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitationsxw
 * under the License.
 */
const resampleOperator = (formData, queryObject) => {
  const resampleZeroFill = formData.resample_method === 'zerofill';
  const resampleMethod = resampleZeroFill ? 'asfreq' : formData.resample_method;
  const resampleRule = formData.resample_rule;

  if (resampleMethod && resampleRule) {
    return {
      operation: 'resample',
      options: {
        method: resampleMethod,
        rule: resampleRule,
        fill_value: resampleZeroFill ? 0 : null,
        time_column: _utils.TIME_COLUMN
      }
    };
  }

  return undefined;
};

exports.resampleOperator = resampleOperator;

/***/ }),

/***/ 79768:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.rollingWindowOperator = void 0;

var _core = __webpack_require__(67017);

var _utils = __webpack_require__(93425);

/* eslint-disable camelcase */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitationsxw
 * under the License.
 */
const rollingWindowOperator = (formData, queryObject) => {
  let columns;

  if ((0, _utils.isValidTimeCompare)(formData, queryObject)) {
    const metricsMap = (0, _utils.getMetricOffsetsMap)(formData, queryObject);
    const comparisonType = formData.comparison_type;

    if (comparisonType === _core.ComparisionType.Values) {
      // time compare type: actual values
      columns = [...Array.from(metricsMap.values()), ...Array.from(metricsMap.keys())];
    } else {
      // time compare type: difference / percentage / ratio
      columns = Array.from(metricsMap.entries()).map(([offset, metric]) => [comparisonType, metric, offset].join(_utils.TIME_COMPARISON_SEPARATOR));
    }
  } else {
    columns = (0, _core.ensureIsArray)(queryObject.metrics).map(metric => {
      if (typeof metric === 'string') {
        return metric;
      }

      return metric.label;
    });
  }

  const columnsMap = Object.fromEntries(columns.map(col => [col, col]));

  if (formData.rolling_type === _core.RollingType.Cumsum) {
    return {
      operation: 'cum',
      options: {
        operator: 'sum',
        columns: columnsMap,
        is_pivot_df: true
      }
    };
  }

  if ([_core.RollingType.Sum, _core.RollingType.Mean, _core.RollingType.Std].includes(formData.rolling_type)) {
    return {
      operation: 'rolling',
      options: {
        rolling_type: formData.rolling_type,
        window: (0, _core.ensureIsInt)(formData.rolling_periods, 1),
        min_periods: (0, _core.ensureIsInt)(formData.min_periods, 0),
        columns: columnsMap,
        is_pivot_df: true
      }
    };
  }

  return undefined;
};

exports.rollingWindowOperator = rollingWindowOperator;

/***/ }),

/***/ 16505:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.sortOperator = void 0;

var _core = __webpack_require__(67017);

var _utils = __webpack_require__(93425);

/* eslint-disable camelcase */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitationsxw
 * under the License.
 */
const sortOperator = (formData, queryObject) => {
  if (queryObject.is_timeseries && Object.values(_core.RollingType).includes(formData.rolling_type)) {
    return {
      operation: 'sort',
      options: {
        columns: {
          [_utils.TIME_COLUMN]: true
        }
      }
    };
  }

  return undefined;
};

exports.sortOperator = sortOperator;

/***/ }),

/***/ 53917:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.timeCompareOperator = void 0;

var _core = __webpack_require__(67017);

var _utils = __webpack_require__(93425);

/* eslint-disable camelcase */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitationsxw
 * under the License.
 */
const timeCompareOperator = (formData, queryObject) => {
  const comparisonType = formData.comparison_type;
  const metricOffsetMap = (0, _utils.getMetricOffsetsMap)(formData, queryObject);

  if ((0, _utils.isValidTimeCompare)(formData, queryObject) && comparisonType !== _core.ComparisionType.Values) {
    return {
      operation: 'compare',
      options: {
        source_columns: Array.from(metricOffsetMap.values()),
        compare_columns: Array.from(metricOffsetMap.keys()),
        compare_type: comparisonType,
        drop_original_columns: true
      }
    };
  }

  return undefined;
};

exports.timeCompareOperator = timeCompareOperator;

/***/ }),

/***/ 62335:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.timeComparePivotOperator = void 0;

var _core = __webpack_require__(67017);

var _utils = __webpack_require__(93425);

/* eslint-disable camelcase */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitationsxw
 * under the License.
 */
const timeComparePivotOperator = (formData, queryObject) => {
  const comparisonType = formData.comparison_type;
  const metricOffsetMap = (0, _utils.getMetricOffsetsMap)(formData, queryObject);

  if ((0, _utils.isValidTimeCompare)(formData, queryObject)) {
    const valuesAgg = Object.fromEntries([...metricOffsetMap.values(), ...metricOffsetMap.keys()].map(metric => [metric, // use the 'mean' aggregates to avoid drop NaN
    {
      operator: 'mean'
    }]));
    const changeAgg = Object.fromEntries([...metricOffsetMap.entries()].map(([offset, metric]) => [comparisonType, metric, offset].join(_utils.TIME_COMPARISON_SEPARATOR)) // use the 'mean' aggregates to avoid drop NaN
    .map(metric => [metric, {
      operator: 'mean'
    }]));
    return {
      operation: 'pivot',
      options: {
        index: ['__timestamp'],
        columns: queryObject.columns || [],
        aggregates: comparisonType === _core.ComparisionType.Values ? valuesAgg : changeAgg,
        drop_missing_columns: false
      }
    };
  }

  return undefined;
};

exports.timeComparePivotOperator = timeComparePivotOperator;

/***/ }),

/***/ 85858:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.__esModule = true;
exports.TIME_COMPARISON_SEPARATOR = exports.TIME_COLUMN = void 0;

/* eslint-disable camelcase */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitationsxw
 * under the License.
 */
const TIME_COMPARISON_SEPARATOR = '__';
exports.TIME_COMPARISON_SEPARATOR = TIME_COMPARISON_SEPARATOR;
const TIME_COLUMN = '__timestamp';
exports.TIME_COLUMN = TIME_COLUMN;

/***/ }),

/***/ 65738:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.getMetricOffsetsMap = void 0;

var _core = __webpack_require__(67017);

var _constants = __webpack_require__(85858);

/* eslint-disable camelcase */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitationsxw
 * under the License.
 */
const getMetricOffsetsMap = (formData, queryObject) => {
  /*
    return metric offset-label and metric-label hashmap, for instance:
    {
      "SUM(value)__1 year ago": "SUM(value)",
      "SUM(value)__2 year ago": "SUM(value)"
    }
  */
  const queryMetrics = (0, _core.ensureIsArray)(queryObject.metrics);
  const timeOffsets = (0, _core.ensureIsArray)(formData.time_compare);
  const metricLabels = queryMetrics.map(_core.getMetricLabel);
  const metricOffsetMap = new Map();
  metricLabels.forEach(metric => {
    timeOffsets.forEach(offset => {
      metricOffsetMap.set([metric, offset].join(_constants.TIME_COMPARISON_SEPARATOR), metric);
    });
  });
  return metricOffsetMap;
};

exports.getMetricOffsetsMap = getMetricOffsetsMap;

/***/ }),

/***/ 93425:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.isValidTimeCompare = exports.getMetricOffsetsMap = exports.TIME_COMPARISON_SEPARATOR = exports.TIME_COLUMN = void 0;

var _getMetricOffsetsMap = __webpack_require__(65738);

exports.getMetricOffsetsMap = _getMetricOffsetsMap.getMetricOffsetsMap;

var _isValidTimeCompare = __webpack_require__(428);

exports.isValidTimeCompare = _isValidTimeCompare.isValidTimeCompare;

var _constants = __webpack_require__(85858);

exports.TIME_COMPARISON_SEPARATOR = _constants.TIME_COMPARISON_SEPARATOR;
exports.TIME_COLUMN = _constants.TIME_COLUMN;

/***/ }),

/***/ 428:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.isValidTimeCompare = void 0;

var _core = __webpack_require__(67017);

var _getMetricOffsetsMap = __webpack_require__(65738);

/* eslint-disable camelcase */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitationsxw
 * under the License.
 */
const isValidTimeCompare = (formData, queryObject) => {
  const comparisonType = formData.comparison_type;
  const metricOffsetMap = (0, _getMetricOffsetsMap.getMetricOffsetsMap)(formData, queryObject);
  return Object.values(_core.ComparisionType).includes(comparisonType) && metricOffsetMap.size > 0;
};

exports.isValidTimeCompare = isValidTimeCompare;

/***/ }),

/***/ 33474:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.advancedAnalyticsControls = void 0;

var _react = _interopRequireDefault(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _utils = __webpack_require__(57639);

var _react2 = __webpack_require__(11965);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const advancedAnalyticsControls = {
  label: (0, _core.t)('Advanced analytics'),
  tabOverride: 'data',
  description: (0, _core.t)('This section contains options ' + 'that allow for advanced analytical post processing ' + 'of query results'),
  controlSetRows: [[(0, _react2.jsx)("h1", {
    className: "section-header"
  }, (0, _core.t)('Rolling window'))], [{
    name: 'rolling_type',
    config: {
      type: 'SelectControl',
      label: (0, _core.t)('Rolling function'),
      default: null,
      choices: [[null, (0, _core.t)('None')]].concat((0, _utils.formatSelectOptions)(Object.values(_core.RollingType))),
      description: (0, _core.t)('Defines a rolling window function to apply, works along ' + 'with the [Periods] text box')
    }
  }], [{
    name: 'rolling_periods',
    config: {
      type: 'TextControl',
      label: (0, _core.t)('Periods'),
      isInt: true,
      description: (0, _core.t)('Defines the size of the rolling window function, ' + 'relative to the time granularity selected'),
      visibility: ({
        controls
      }) => {
        var _controls$rolling_typ;

        return Boolean(controls == null ? void 0 : (_controls$rolling_typ = controls.rolling_type) == null ? void 0 : _controls$rolling_typ.value) && controls.rolling_type.value !== _core.RollingType.Cumsum;
      }
    }
  }], [{
    name: 'min_periods',
    config: {
      type: 'TextControl',
      label: (0, _core.t)('Min periods'),
      isInt: true,
      description: (0, _core.t)('The minimum number of rolling periods required to show ' + 'a value. For instance if you do a cumulative sum on 7 days ' + 'you may want your "Min Period" to be 7, so that all data points ' + 'shown are the total of 7 periods. This will hide the "ramp up" ' + 'taking place over the first 7 periods'),
      visibility: ({
        controls
      }) => {
        var _controls$rolling_typ2;

        return Boolean(controls == null ? void 0 : (_controls$rolling_typ2 = controls.rolling_type) == null ? void 0 : _controls$rolling_typ2.value) && controls.rolling_type.value !== _core.RollingType.Cumsum;
      }
    }
  }], [(0, _react2.jsx)("h1", {
    className: "section-header"
  }, (0, _core.t)('Time comparison'))], [{
    name: 'time_compare',
    config: {
      type: 'SelectControl',
      multi: true,
      freeForm: true,
      label: (0, _core.t)('Time shift'),
      choices: (0, _utils.formatSelectOptions)(['1 day ago', '1 week ago', '28 days ago', '30 days ago', '52 weeks ago', '1 year ago', '104 weeks ago', '2 years ago']),
      description: (0, _core.t)('Overlay one or more timeseries from a ' + 'relative time period. Expects relative time deltas ' + 'in natural language (example:  24 hours, 7 days, ' + '52 weeks, 365 days). Free text is supported.')
    }
  }], [{
    name: 'comparison_type',
    config: {
      type: 'SelectControl',
      label: (0, _core.t)('Calculation type'),
      default: 'values',
      choices: [[_core.ComparisionType.Values, 'Actual values'], [_core.ComparisionType.Difference, 'Difference'], [_core.ComparisionType.Percentage, 'Percentage change'], [_core.ComparisionType.Ratio, 'Ratio']],
      description: (0, _core.t)('How to display time shifts: as individual lines; as the ' + 'difference between the main time series and each time shift; ' + 'as the percentage change; or as the ratio between series and time shifts.')
    }
  }], [(0, _react2.jsx)("h1", {
    className: "section-header"
  }, (0, _core.t)('Resample'))], [{
    name: 'resample_rule',
    config: {
      type: 'SelectControl',
      freeForm: true,
      label: (0, _core.t)('Rule'),
      default: null,
      choices: [['1T', '1 minutely frequency'], ['1H', '1 hourly frequency'], ['1D', '1 calendar day frequency'], ['7D', '7 calendar day frequency'], ['1MS', '1 month start frequency'], ['1M', '1 month end frequency'], ['1AS', '1 year start frequency'], ['1A', '1 year end frequency']],
      description: (0, _core.t)('Pandas resample rule')
    }
  }], [{
    name: 'resample_method',
    config: {
      type: 'SelectControl',
      freeForm: true,
      label: (0, _core.t)('Fill method'),
      default: null,
      choices: [['asfreq', 'Null imputation'], ['zerofill', 'Zero imputation'], ['ffill', 'Forward values'], ['bfill', 'Backward values'], ['median', 'Median values'], ['mean', 'Mean values'], ['sum', 'Sum values']],
      description: (0, _core.t)('Pandas resample method')
    }
  }]]
};
exports.advancedAnalyticsControls = advancedAnalyticsControls;

/***/ }),

/***/ 71315:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.annotationsAndLayersControls = exports.annotationLayers = void 0;

var _core = __webpack_require__(67017);

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const annotationLayers = [];
exports.annotationLayers = annotationLayers;
const annotationsAndLayersControls = {
  label: (0, _core.t)('Annotations and Layers'),
  expanded: false,
  controlSetRows: [[{
    name: 'annotation_layers',
    config: {
      type: 'AnnotationLayerControl',
      label: '',
      default: annotationLayers,
      description: (0, _core.t)('Annotation Layers')
    }
  }]]
};
exports.annotationsAndLayersControls = annotationsAndLayersControls;

/***/ }),

/***/ 32994:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.titleControls = void 0;

var _react = _interopRequireDefault(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _utils = __webpack_require__(57639);

var _react2 = __webpack_require__(11965);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const TITLE_MARGIN_OPTIONS = [15, 30, 50, 75, 100, 125, 150, 200];
const TITLE_POSITION_OPTIONS = ['Left', 'Top'];
const titleControls = {
  label: (0, _core.t)('Chart Title'),
  tabOverride: 'customize',
  expanded: true,
  controlSetRows: [[(0, _react2.jsx)("h1", {
    className: "section-header"
  }, (0, _core.t)('X Axis'))], [{
    name: 'x_axis_title',
    config: {
      type: 'TextControl',
      label: (0, _core.t)('X Axis Title'),
      renderTrigger: true,
      default: '',
      description: (0, _core.t)('Changing this control takes effect instantly')
    }
  }], [{
    name: 'x_axis_title_margin',
    config: {
      type: 'SelectControl',
      freeForm: true,
      clearable: true,
      label: (0, _core.t)('X AXIS TITLE BOTTOM MARGIN'),
      renderTrigger: true,
      default: TITLE_MARGIN_OPTIONS[0],
      choices: (0, _utils.formatSelectOptions)(TITLE_MARGIN_OPTIONS),
      description: (0, _core.t)('Changing this control takes effect instantly')
    }
  }], [(0, _react2.jsx)("h1", {
    className: "section-header"
  }, (0, _core.t)('Y Axis'))], [{
    name: 'y_axis_title',
    config: {
      type: 'TextControl',
      label: (0, _core.t)('Y Axis Title'),
      renderTrigger: true,
      default: '',
      description: (0, _core.t)('Changing this control takes effect instantly')
    }
  }], [{
    name: 'y_axis_title_margin',
    config: {
      type: 'SelectControl',
      freeForm: true,
      clearable: true,
      label: (0, _core.t)('Y AXIS TITLE MARGIN'),
      renderTrigger: true,
      default: TITLE_MARGIN_OPTIONS[0],
      choices: (0, _utils.formatSelectOptions)(TITLE_MARGIN_OPTIONS),
      description: (0, _core.t)('Changing this control takes effect instantly')
    }
  }], [{
    name: 'y_axis_title_position',
    config: {
      type: 'SelectControl',
      freeForm: true,
      clearable: false,
      label: (0, _core.t)('Y AXIS TITLE POSITION'),
      renderTrigger: true,
      default: TITLE_POSITION_OPTIONS[0],
      choices: (0, _utils.formatSelectOptions)(TITLE_POSITION_OPTIONS),
      description: (0, _core.t)('Changing this control takes effect instantly')
    }
  }]]
};
exports.titleControls = titleControls;

/***/ }),

/***/ 17003:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.forecastIntervalControls = exports.FORECAST_DEFAULT_DATA = void 0;

var _core = __webpack_require__(67017);

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const FORECAST_DEFAULT_DATA = {
  forecastEnabled: false,
  forecastInterval: 0.8,
  forecastPeriods: 10,
  forecastSeasonalityDaily: null,
  forecastSeasonalityWeekly: null,
  forecastSeasonalityYearly: null
};
exports.FORECAST_DEFAULT_DATA = FORECAST_DEFAULT_DATA;
const forecastIntervalControls = {
  label: (0, _core.t)('Predictive Analytics'),
  expanded: false,
  controlSetRows: [[{
    name: 'forecastEnabled',
    config: {
      type: 'CheckboxControl',
      label: (0, _core.t)('Enable forecast'),
      renderTrigger: false,
      default: FORECAST_DEFAULT_DATA.forecastEnabled,
      description: (0, _core.t)('Enable forecasting')
    }
  }], [{
    name: 'forecastPeriods',
    config: {
      type: 'TextControl',
      label: (0, _core.t)('Forecast periods'),
      validators: [_core.legacyValidateInteger],
      default: FORECAST_DEFAULT_DATA.forecastPeriods,
      description: (0, _core.t)('How many periods into the future do we want to predict')
    }
  }], [{
    name: 'forecastInterval',
    config: {
      type: 'TextControl',
      label: (0, _core.t)('Confidence interval'),
      validators: [_core.legacyValidateNumber],
      default: FORECAST_DEFAULT_DATA.forecastInterval,
      description: (0, _core.t)('Width of the confidence interval. Should be between 0 and 1')
    }
  }, {
    name: 'forecastSeasonalityYearly',
    config: {
      type: 'SelectControl',
      freeForm: true,
      label: 'Yearly seasonality',
      choices: [[null, 'default'], [true, 'Yes'], [false, 'No']],
      default: FORECAST_DEFAULT_DATA.forecastSeasonalityYearly,
      description: (0, _core.t)('Should yearly seasonality be applied. An integer value will specify Fourier order of seasonality.')
    }
  }], [{
    name: 'forecastSeasonalityWeekly',
    config: {
      type: 'SelectControl',
      freeForm: true,
      label: 'Weekly seasonality',
      choices: [[null, 'default'], [true, 'Yes'], [false, 'No']],
      default: FORECAST_DEFAULT_DATA.forecastSeasonalityWeekly,
      description: (0, _core.t)('Should weekly seasonality be applied. An integer value will specify Fourier order of seasonality.')
    }
  }, {
    name: 'forecastSeasonalityDaily',
    config: {
      type: 'SelectControl',
      freeForm: true,
      label: 'Daily seasonality',
      choices: [[null, 'default'], [true, 'Yes'], [false, 'No']],
      default: FORECAST_DEFAULT_DATA.forecastSeasonalityDaily,
      description: (0, _core.t)('Should daily seasonality be applied. An integer value will specify Fourier order of seasonality.')
    }
  }]]
};
exports.forecastIntervalControls = forecastIntervalControls;

/***/ }),

/***/ 76539:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;

var _sections = __webpack_require__(95715);

Object.keys(_sections).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _sections[key]) return;
  exports[key] = _sections[key];
});

var _advancedAnalytics = __webpack_require__(33474);

Object.keys(_advancedAnalytics).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _advancedAnalytics[key]) return;
  exports[key] = _advancedAnalytics[key];
});

var _annotationsAndLayers = __webpack_require__(71315);

Object.keys(_annotationsAndLayers).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _annotationsAndLayers[key]) return;
  exports[key] = _annotationsAndLayers[key];
});

var _forecastInterval = __webpack_require__(17003);

Object.keys(_forecastInterval).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _forecastInterval[key]) return;
  exports[key] = _forecastInterval[key];
});

var _chartTitle = __webpack_require__(32994);

Object.keys(_chartTitle).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _chartTitle[key]) return;
  exports[key] = _chartTitle[key];
});

/***/ }),

/***/ 95715:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.legacyTimeseriesTime = exports.legacyRegularTime = exports.datasourceAndVizType = exports.colorScheme = exports.annotations = void 0;

var _core = __webpack_require__(67017);

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// A few standard controls sections that are used internally.
// Not recommended for use in third-party plugins.
const baseTimeSection = {
  label: (0, _core.t)('Time'),
  expanded: true,
  description: (0, _core.t)('Time related form attributes')
};
const legacyTimeseriesTime = { ...baseTimeSection,
  controlSetRows: [['granularity'], ['druid_time_origin'], ['granularity_sqla'], ['time_grain_sqla'], ['time_range']]
};
exports.legacyTimeseriesTime = legacyTimeseriesTime;
const legacyRegularTime = { ...baseTimeSection,
  controlSetRows: [['granularity_sqla'], ['time_range']]
};
exports.legacyRegularTime = legacyRegularTime;
const datasourceAndVizType = {
  label: (0, _core.t)('Datasource & Chart Type'),
  expanded: true,
  controlSetRows: [['datasource'], ['viz_type'], [{
    name: 'slice_id',
    config: {
      type: 'HiddenControl',
      label: (0, _core.t)('Chart ID'),
      hidden: true,
      description: (0, _core.t)('The id of the active chart')
    }
  }, {
    name: 'cache_timeout',
    config: {
      type: 'HiddenControl',
      label: (0, _core.t)('Cache Timeout (seconds)'),
      hidden: true,
      description: (0, _core.t)('The number of seconds before expiring the cache')
    }
  }, {
    name: 'url_params',
    config: {
      type: 'HiddenControl',
      label: (0, _core.t)('URL Parameters'),
      hidden: true,
      description: (0, _core.t)('Extra url parameters for use in Jinja templated queries')
    }
  }, {
    name: 'custom_params',
    config: {
      type: 'HiddenControl',
      label: (0, _core.t)('Extra Parameters'),
      hidden: true,
      description: (0, _core.t)('Extra parameters that any plugins can choose to set for use in Jinja templated queries')
    }
  }, {
    name: 'time_range_endpoints',
    config: {
      type: 'HiddenControl',
      label: (0, _core.t)('Time range endpoints'),
      hidden: true,
      description: (0, _core.t)('Time range endpoints (SIP-15)')
    }
  }]]
};
exports.datasourceAndVizType = datasourceAndVizType;
const colorScheme = {
  label: (0, _core.t)('Color Scheme'),
  controlSetRows: [['color_scheme']]
};
exports.colorScheme = colorScheme;
const annotations = {
  label: (0, _core.t)('Annotations and Layers'),
  tabOverride: 'data',
  expanded: true,
  controlSetRows: [[{
    name: 'annotation_layers',
    config: {
      type: 'AnnotationLayerControl',
      label: '',
      default: [],
      description: (0, _core.t)('Annotation Layers'),
      renderTrigger: true
    }
  }]]
};
exports.annotations = annotations;

/***/ }),

/***/ 43261:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports["default"] = ColumnConfigControl;

var _react = __webpack_require__(11965);

var _propTypes = _interopRequireDefault(__webpack_require__(45697));

var _react2 = _interopRequireWildcard(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _ControlHeader = _interopRequireDefault(__webpack_require__(85961));

var _ColumnConfigItem = _interopRequireDefault(__webpack_require__(49581));

var _constants = __webpack_require__(17439);

var _constants2 = __webpack_require__(22320);

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Max number of columns to show by default.
 */
const MAX_NUM_COLS = 10;
/**
 * Add per-column config to queried results.
 */

function ColumnConfigControl({
  queryResponse,
  appliedColumnNames = [],
  value,
  onChange,
  configFormLayout = _constants.DEFAULT_CONFIG_FORM_LAYOUT,
  emitFilter,
  ...props
}) {
  if (emitFilter) {
    Object.values(configFormLayout).forEach(array_of_array => {
      if (!array_of_array.some(arr => arr.includes('emitTarget'))) {
        array_of_array.push(['emitTarget']);
      }
    });
  } else {
    Object.values(configFormLayout).forEach(array_of_array => {
      const index = array_of_array.findIndex(arr => arr.includes('emitTarget'));

      if (index > -1) {
        array_of_array.splice(index, 1);
      }
    });
  }

  const {
    colnames: _colnames,
    coltypes: _coltypes
  } = queryResponse || {};
  let colnames = [];
  let coltypes = [];

  if (appliedColumnNames.length === 0) {
    colnames = _colnames || [];
    coltypes = _coltypes || [];
  } else {
    const appliedCol = new Set(appliedColumnNames);
    _colnames == null ? void 0 : _colnames.forEach((col, idx) => {
      if (appliedCol.has(col)) {
        colnames.push(col);
        coltypes.push(_coltypes == null ? void 0 : _coltypes[idx]);
      }
    });
  }

  const theme = (0, _core.useTheme)();
  const columnConfigs = (0, _react2.useMemo)(() => {
    var _colnames2;

    const configs = {};
    (_colnames2 = colnames) == null ? void 0 : _colnames2.forEach((col, idx) => {
      var _coltypes2;

      configs[col] = {
        name: _constants2.COLUMN_NAME_ALIASES[col] || col,
        type: (_coltypes2 = coltypes) == null ? void 0 : _coltypes2[idx],
        config: (value == null ? void 0 : value[col]) || {}
      };
    });
    return configs;
  }, [value, colnames, coltypes]);
  const [showAllColumns, setShowAllColumns] = (0, _react2.useState)(false);

  const getColumnInfo = col => columnConfigs[col] || {};

  const setColumnConfig = (col, config) => {
    if (onChange) {
      // Only keep configs for known columns
      const validConfigs = colnames && value ? Object.fromEntries(Object.entries(value).filter(([key]) => colnames.includes(key))) : { ...value
      };
      onChange({ ...validConfigs,
        [col]: config
      });
    }
  };

  if (!colnames || colnames.length === 0) return null;
  const needShowMoreButton = colnames.length > MAX_NUM_COLS + 2;
  const cols = needShowMoreButton && !showAllColumns ? colnames.slice(0, MAX_NUM_COLS) : colnames;
  return (0, _react.jsx)(_react2.default.Fragment, null, (0, _react.jsx)(_ControlHeader.default, props), (0, _react.jsx)("div", {
    css: /*#__PURE__*/(0, _react.css)({
      border: `1px solid ${theme.colors.grayscale.light2}`,
      borderRadius: theme.gridUnit
    },  true ? "" : 0,  true ? "" : 0)
  }, cols.map(col => (0, _react.jsx)(_ColumnConfigItem.default, {
    key: col,
    column: getColumnInfo(col),
    onChange: config => setColumnConfig(col, config),
    configFormLayout: configFormLayout
  })), needShowMoreButton && (0, _react.jsx)("div", {
    role: "button",
    tabIndex: -1,
    css: /*#__PURE__*/(0, _react.css)({
      padding: theme.gridUnit * 2,
      textAlign: 'center',
      cursor: 'pointer',
      textTransform: 'uppercase',
      fontSize: theme.typography.sizes.xs,
      color: theme.colors.text.label,
      ':hover': {
        backgroundColor: theme.colors.grayscale.light4
      }
    },  true ? "" : 0,  true ? "" : 0),
    onClick: () => setShowAllColumns(!showAllColumns)
  }, showAllColumns ? (0, _react.jsx)(_react2.default.Fragment, null, (0, _react.jsx)("i", {
    className: "fa fa-angle-up"
  }), " \xA0 ", (0, _core.t)('Show less columns')) : (0, _react.jsx)(_react2.default.Fragment, null, (0, _react.jsx)("i", {
    className: "fa fa-angle-down"
  }), " \xA0", (0, _core.t)('Show all columns')))));
}

ColumnConfigControl.propTypes = {
  appliedColumnNames: _propTypes.default.arrayOf(_propTypes.default.string),
  emitFilter: _propTypes.default.bool.isRequired
};

/***/ }),

/***/ 49581:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports["default"] = void 0;

var _react = __webpack_require__(11965);

var _react2 = _interopRequireDefault(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _antd = __webpack_require__(76951);

var _ColumnTypeLabel = _interopRequireDefault(__webpack_require__(81984));

var _ColumnConfigPopover = _interopRequireDefault(__webpack_require__(61578));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var _default = /*#__PURE__*/_react2.default.memo(function ColumnConfigItem({
  column,
  onChange,
  configFormLayout
}) {
  const {
    colors,
    gridUnit
  } = (0, _core.useTheme)();
  const caretWidth = gridUnit * 6;
  return (0, _react.jsx)(_antd.Popover, {
    title: column.name,
    content: () => (0, _react.jsx)(_ColumnConfigPopover.default, {
      column: column,
      onChange: onChange,
      configFormLayout: configFormLayout
    }),
    trigger: "click",
    placement: "right"
  }, (0, _react.jsx)("div", {
    css: /*#__PURE__*/(0, _react.css)({
      cursor: 'pointer',
      padding: `${1.5 * gridUnit}px ${2 * gridUnit}px`,
      borderBottom: `1px solid ${colors.grayscale.light2}`,
      position: 'relative',
      paddingRight: caretWidth,
      '&:last-child': {
        borderBottom: 'none'
      },
      '&:hover': {
        background: colors.grayscale.light4
      },
      '> .fa': {
        color: colors.grayscale.light2
      },
      '&:hover > .fa': {
        color: colors.grayscale.light1
      }
    },  true ? "" : 0)
  }, (0, _react.jsx)(_ColumnTypeLabel.default, {
    type: column.type
  }), column.name, (0, _react.jsx)("i", {
    className: "fa fa-caret-right",
    css: /*#__PURE__*/(0, _react.css)({
      position: 'absolute',
      right: 3 * gridUnit,
      top: 3 * gridUnit
    },  true ? "" : 0)
  })));
});

exports["default"] = _default;

/***/ }),

/***/ 61578:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports["default"] = ColumnConfigPopover;

var _propTypes = _interopRequireDefault(__webpack_require__(45697));

var _react = _interopRequireDefault(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _ControlForm = _interopRequireWildcard(__webpack_require__(5537));

var _constants = __webpack_require__(17439);

var _react2 = __webpack_require__(11965);

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ColumnConfigPopover({
  column,
  configFormLayout,
  onChange
}) {
  return (0, _react2.jsx)(_ControlForm.default, {
    onChange: onChange,
    value: column.config
  }, configFormLayout[column.type === undefined ? _core.GenericDataType.STRING : column.type].map((row, i) => (0, _react2.jsx)(_ControlForm.ControlFormRow, {
    key: i
  }, row.map(meta => {
    const key = typeof meta === 'string' ? meta : meta.name;
    const override = typeof meta === 'string' ? {} : 'override' in meta ? meta.override : meta.config;
    const props = { ...(key in _constants.SHARED_COLUMN_CONFIG_PROPS ? _constants.SHARED_COLUMN_CONFIG_PROPS[key] : undefined),
      ...override
    };
    return (0, _react2.jsx)(_ControlForm.ControlFormItem, _extends({
      key: key,
      name: key
    }, props));
  }))));
}

ColumnConfigPopover.propTypes = {
  onChange: _propTypes.default.func.isRequired
};

/***/ }),

/***/ 17439:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.SHARED_COLUMN_CONFIG_PROPS = exports.DEFAULT_CONFIG_FORM_LAYOUT = void 0;

var _react = _interopRequireDefault(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _FaAlignLeft = __webpack_require__(61437);

var _FaAlignRight = __webpack_require__(38798);

var _FaAlignCenter = __webpack_require__(14031);

var _utils = __webpack_require__(57639);

var _react2 = __webpack_require__(11965);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const emitTarget = {
  controlType: 'Input',
  label: (0, _core.t)('Emit Target'),
  description: (0, _core.t)('If you wish to specify a different target column than the original column, it can be entered here'),
  defaultValue: '',
  debounceDelay: 500,
  validators: undefined
};
const d3NumberFormat = {
  controlType: 'Select',
  label: (0, _core.t)('D3 format'),
  description: _utils.D3_FORMAT_DOCS,
  options: _utils.D3_FORMAT_OPTIONS,
  defaultValue: _utils.D3_FORMAT_OPTIONS[0][0],
  creatable: true,
  minWidth: '14em',
  debounceDelay: 500
};
const d3TimeFormat = {
  controlType: 'Select',
  label: (0, _core.t)('D3 format'),
  description: _utils.D3_TIME_FORMAT_DOCS,
  options: _utils.D3_TIME_FORMAT_OPTIONS,
  defaultValue: _utils.D3_TIME_FORMAT_OPTIONS[0][0],
  creatable: true,
  minWidth: '10em',
  debounceDelay: 500
};
const fractionDigits = {
  controlType: 'Slider',
  label: (0, _core.t)('Fraction digits'),
  description: (0, _core.t)('Number of decimal digits to round numbers to'),
  min: 0,
  step: 1,
  max: 100,
  defaultValue: 100
};
const columnWidth = {
  controlType: 'InputNumber',
  label: (0, _core.t)('Min Width'),
  description: (0, _core.t)("Default minimal column width in pixels, actual width may still be larger than this if other columns don't need much space"),
  width: 120,
  placeholder: 'auto',
  debounceDelay: 400,
  validators: [_core.validateNumber]
};
const horizontalAlign = {
  controlType: 'RadioButtonControl',
  label: (0, _core.t)('Text align'),
  description: (0, _core.t)('Horizontal alignment'),
  width: 130,
  debounceDelay: 50,
  defaultValue: 'left',
  options: [['left', (0, _react2.jsx)(_FaAlignLeft.FaAlignLeft, {
    title: (0, _core.t)('Left')
  })], ['center', (0, _react2.jsx)(_FaAlignCenter.FaAlignCenter, {
    title: (0, _core.t)('Center')
  })], ['right', (0, _react2.jsx)(_FaAlignRight.FaAlignRight, {
    title: (0, _core.t)('Right')
  })]]
};
const showCellBars = {
  controlType: 'Checkbox',
  label: (0, _core.t)('Show cell bars'),
  description: (0, _core.t)('Whether to display a bar chart background in table columns'),
  defaultValue: true,
  debounceDelay: 200
};
const alignPositiveNegative = {
  controlType: 'Checkbox',
  label: (0, _core.t)('Align +/-'),
  description: (0, _core.t)('Whether to align positive and negative values in cell bar chart at 0'),
  defaultValue: false,
  debounceDelay: 200
};
const colorPositiveNegative = {
  controlType: 'Checkbox',
  label: (0, _core.t)('Color +/-'),
  description: (0, _core.t)('Whether to colorize numeric values by if they are positive or negative'),
  defaultValue: false,
  debounceDelay: 200
};
/**
 * All configurable column formatting properties.
 */

const SHARED_COLUMN_CONFIG_PROPS = {
  d3NumberFormat,
  emitTarget,
  d3SmallNumberFormat: { ...d3NumberFormat,
    label: (0, _core.t)('Small number format'),
    description: (0, _core.t)('D3 number format for numbers between -1.0 and 1.0, ' + 'useful when you want to have different siginificant digits for small and large numbers')
  },
  d3TimeFormat,
  fractionDigits,
  columnWidth,
  horizontalAlign,
  showCellBars,
  alignPositiveNegative,
  colorPositiveNegative
};
exports.SHARED_COLUMN_CONFIG_PROPS = SHARED_COLUMN_CONFIG_PROPS;
const DEFAULT_CONFIG_FORM_LAYOUT = {
  [_core.GenericDataType.STRING]: [['columnWidth', {
    name: 'horizontalAlign',
    override: {
      defaultValue: 'left'
    }
  }]],
  [_core.GenericDataType.NUMERIC]: [['columnWidth', {
    name: 'horizontalAlign',
    override: {
      defaultValue: 'right'
    }
  }], ['d3NumberFormat'], ['d3SmallNumberFormat'], ['alignPositiveNegative', 'colorPositiveNegative'], ['showCellBars']],
  [_core.GenericDataType.TEMPORAL]: [['columnWidth', {
    name: 'horizontalAlign',
    override: {
      defaultValue: 'left'
    }
  }], ['d3TimeFormat']],
  [_core.GenericDataType.BOOLEAN]: [['columnWidth', {
    name: 'horizontalAlign',
    override: {
      defaultValue: 'left'
    }
  }]]
};
exports.DEFAULT_CONFIG_FORM_LAYOUT = DEFAULT_CONFIG_FORM_LAYOUT;

/***/ }),

/***/ 78959:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
var _exportNames = {
  __hack__reexport__: true
};
exports["default"] = exports.__hack__reexport__ = void 0;

var _ColumnConfigControl = _interopRequireDefault(__webpack_require__(43261));

var _types = _interopRequireWildcard(__webpack_require__(78217));

exports.__hack__reexport__ = _types.default;
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  exports[key] = _types[key];
});

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var _default = _ColumnConfigControl.default;
exports["default"] = _default;

/***/ }),

/***/ 78217:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = void 0;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Column formatting configs.
 */

/**
 * All required info about a column to render the
 * formatting.
 */
var _default = {};
exports["default"] = _default;

/***/ }),

/***/ 66666:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports["default"] = RadioButtonControl;

var _react = __webpack_require__(11965);

var _propTypes = _interopRequireDefault(__webpack_require__(45697));

var _react2 = _interopRequireDefault(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _ControlHeader = _interopRequireDefault(__webpack_require__(85961));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function RadioButtonControl({
  value: initialValue,
  options,
  onChange,
  ...props
}) {
  const currentValue = initialValue || options[0][0];
  const theme = (0, _core.useTheme)();
  return (0, _react.jsx)("div", {
    css: /*#__PURE__*/(0, _react.css)({
      '.btn svg': {
        position: 'relative',
        top: '0.2em'
      },
      '.btn:focus': {
        outline: 'none'
      },
      '.control-label + .btn-group': {
        marginTop: 1
      },
      '.btn-group .btn.active': {
        background: theme.colors.secondary.light5,
        fontWeight: theme.typography.weights.bold,
        boxShadow: 'none'
      }
    },  true ? "" : 0,  true ? "" : 0)
  }, (0, _react.jsx)(_ControlHeader.default, props), (0, _react.jsx)("div", {
    className: "btn-group btn-group-sm"
  }, options.map(([val, label]) => (0, _react.jsx)("button", {
    key: JSON.stringify(val),
    type: "button",
    className: `btn btn-default ${val === currentValue ? 'active' : ''}`,
    onClick: () => {
      onChange(val);
    }
  }, label))));
}

RadioButtonControl.propTypes = {
  label: _propTypes.default.node,
  description: _propTypes.default.string,
  options: _propTypes.default.array.isRequired,
  hovered: _propTypes.default.bool,
  value: _propTypes.default.string,
  onChange: _propTypes.default.func.isRequired
};

/***/ }),

/***/ 12330:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
var _exportNames = {};
exports["default"] = void 0;

var _RadioButtonControl = _interopRequireWildcard(__webpack_require__(66666));

Object.keys(_RadioButtonControl).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _RadioButtonControl[key]) return;
  exports[key] = _RadioButtonControl[key];
});

var _ColumnConfigControl = _interopRequireWildcard(__webpack_require__(78959));

Object.keys(_ColumnConfigControl).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _ColumnConfigControl[key]) return;
  exports[key] = _ColumnConfigControl[key];
});

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Shared chart controls. Can be referred via string shortcuts in chart control
 * configs.
 */
var _default = {
  RadioButtonControl: _RadioButtonControl.default,
  ColumnConfigControl: _ColumnConfigControl.default
};
exports["default"] = _default;

/***/ }),

/***/ 2441:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _react = _interopRequireDefault(__webpack_require__(67294));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/***/ }),

/***/ 59195:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.dnd_y = exports.dnd_x = exports.dnd_sort_by = exports.dnd_size = exports.dnd_secondary_metric = exports.dnd_granularity_sqla = exports.dnd_adhoc_metrics = exports.dnd_adhoc_metric_2 = exports.dnd_adhoc_metric = exports.dnd_adhoc_filters = exports.dndSeries = exports.dndGroupByControl = exports.dndEntity = exports.dndColumnsControl = void 0;

var _core = __webpack_require__(67017);

var _constants = __webpack_require__(22320);

/* eslint-disable camelcase */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const dndGroupByControl = {
  type: 'DndColumnSelect',
  label: (0, _core.t)('Group by'),
  default: [],
  description: (0, _core.t)('One or many columns to group by. High cardinality groupings should include a sort by metric ' + 'and series limit to limit the number of fetched and rendered series.'),

  mapStateToProps(state, {
    includeTime
  }) {
    const newState = {};

    if (state.datasource) {
      const options = state.datasource.columns.filter(c => c.groupby);

      if (includeTime) {
        options.unshift(_constants.TIME_COLUMN_OPTION);
      }

      newState.options = Object.fromEntries(options.map(option => [option.column_name, option]));
      newState.savedMetrics = state.datasource.metrics || [];
    }

    return newState;
  }

};
exports.dndGroupByControl = dndGroupByControl;
const dndColumnsControl = { ...dndGroupByControl,
  label: (0, _core.t)('Columns'),
  description: (0, _core.t)('One or many columns to pivot as columns')
};
exports.dndColumnsControl = dndColumnsControl;
const dndSeries = { ...dndGroupByControl,
  label: (0, _core.t)('Series'),
  multi: false,
  default: null,
  description: (0, _core.t)('Defines the grouping of entities. ' + 'Each series is shown as a specific color on the chart and ' + 'has a legend toggle')
};
exports.dndSeries = dndSeries;
const dndEntity = { ...dndGroupByControl,
  label: (0, _core.t)('Entity'),
  default: null,
  multi: false,
  validators: [_core.validateNonEmpty],
  description: (0, _core.t)('This defines the element to be plotted on the chart')
};
exports.dndEntity = dndEntity;
const dnd_adhoc_filters = {
  type: 'DndFilterSelect',
  label: (0, _core.t)('Filters'),
  default: null,
  description: '',
  mapStateToProps: ({
    datasource,
    form_data
  }) => ({
    columns: (datasource == null ? void 0 : datasource.columns.filter(c => c.filterable)) || [],
    savedMetrics: (datasource == null ? void 0 : datasource.metrics) || [],
    // current active adhoc metrics
    selectedMetrics: form_data.metrics || (form_data.metric ? [form_data.metric] : []),
    datasource
  }),
  provideFormDataToProps: true
};
exports.dnd_adhoc_filters = dnd_adhoc_filters;
const dnd_adhoc_metrics = {
  type: 'DndMetricSelect',
  multi: true,
  label: (0, _core.t)('Metrics'),
  validators: [_core.validateNonEmpty],
  mapStateToProps: ({
    datasource
  }) => ({
    columns: datasource ? datasource.columns : [],
    savedMetrics: datasource ? datasource.metrics : [],
    datasource,
    datasourceType: datasource == null ? void 0 : datasource.type
  }),
  description: (0, _core.t)('One or many metrics to display')
};
exports.dnd_adhoc_metrics = dnd_adhoc_metrics;
const dnd_adhoc_metric = { ...dnd_adhoc_metrics,
  multi: false,
  label: (0, _core.t)('Metric'),
  description: (0, _core.t)('Metric')
};
exports.dnd_adhoc_metric = dnd_adhoc_metric;
const dnd_adhoc_metric_2 = { ...dnd_adhoc_metric,
  label: (0, _core.t)('Right Axis Metric'),
  description: (0, _core.t)('Choose a metric for right axis')
};
exports.dnd_adhoc_metric_2 = dnd_adhoc_metric_2;
const dnd_sort_by = {
  type: 'DndMetricSelect',
  label: (0, _core.t)('Sort by'),
  default: null,
  description: (0, _core.t)('Metric used to define the top series. Should be used in conjunction with the series or row ' + 'limit.'),
  mapStateToProps: ({
    datasource
  }) => ({
    columns: (datasource == null ? void 0 : datasource.columns) || [],
    savedMetrics: (datasource == null ? void 0 : datasource.metrics) || [],
    datasource,
    datasourceType: datasource == null ? void 0 : datasource.type
  })
};
exports.dnd_sort_by = dnd_sort_by;
const dnd_size = { ...dnd_adhoc_metric,
  label: (0, _core.t)('Bubble Size'),
  description: (0, _core.t)('Metric used to calculate bubble size')
};
exports.dnd_size = dnd_size;
const dnd_x = { ...dnd_adhoc_metric,
  label: (0, _core.t)('X Axis'),
  description: (0, _core.t)('Metric assigned to the [X] axis')
};
exports.dnd_x = dnd_x;
const dnd_y = { ...dnd_adhoc_metric,
  label: (0, _core.t)('Y Axis'),
  description: (0, _core.t)('Metric assigned to the [Y] axis')
};
exports.dnd_y = dnd_y;
const dnd_secondary_metric = { ...dnd_adhoc_metric,
  label: (0, _core.t)('Color Metric'),
  validators: [],
  description: (0, _core.t)('A metric to use for color')
};
exports.dnd_secondary_metric = dnd_secondary_metric;
const dnd_granularity_sqla = { ...dndSeries,
  label: _constants.TIME_FILTER_LABELS.granularity_sqla,
  description: (0, _core.t)('The time column for the visualization. Note that you ' + 'can define arbitrary expression that return a DATETIME ' + 'column in the table. Also note that the ' + 'filter below is applied against this column or ' + 'expression'),
  canDelete: false,
  ghostButtonText: (0, _core.t)((0, _core.isFeatureEnabled)(_core.FeatureFlag.ENABLE_DND_WITH_CLICK_UX) ? 'Drop a temporal column here or click' : 'Drop temporal column here'),
  mapStateToProps: ({
    datasource
  }) => {
    var _temporalColumns$;

    const temporalColumns = (datasource == null ? void 0 : datasource.columns.filter(c => c.is_dttm)) ?? [];
    const options = Object.fromEntries(temporalColumns.map(option => [option.column_name, option]));
    return {
      options,
      default: (datasource == null ? void 0 : datasource.main_dttm_col) || ((_temporalColumns$ = temporalColumns[0]) == null ? void 0 : _temporalColumns$.column_name) || null
    };
  }
};
exports.dnd_granularity_sqla = dnd_granularity_sqla;

/***/ }),

/***/ 17592:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.emitFilterControl = void 0;

var _core = __webpack_require__(67017);

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const enableCrossFilter = (0, _core.isFeatureEnabled)(_core.FeatureFlag.DASHBOARD_CROSS_FILTERS);
const emitFilterControl = enableCrossFilter ? [{
  name: 'emit_filter',
  config: {
    type: 'CheckboxControl',
    label: (0, _core.t)('Emit dashboard cross filters'),
    default: false,
    renderTrigger: true,
    description: (0, _core.t)('Emit dashboard cross filters.')
  }
}] : [];
exports.emitFilterControl = emitFilterControl;

/***/ }),

/***/ 25987:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.sharedControls = exports.PRIMARY_COLOR = void 0;

var _react = _interopRequireDefault(__webpack_require__(67294));

var _core = __webpack_require__(67017);

var _utils = __webpack_require__(57639);

var _constants = __webpack_require__(22320);

var _ColumnOption = __webpack_require__(30027);

var _dndControls = __webpack_require__(59195);

exports.dndColumnsControl = _dndControls.dndColumnsControl;
exports.dndEntity = _dndControls.dndEntity;

var _react2 = __webpack_require__(11965);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable camelcase */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * This file exports all controls available for use in chart plugins internal to Superset.
 * It is not recommended to use the controls here for any third-party plugins.
 *
 * While the React components located in `controls/components` represent different
 * types of controls (CheckboxControl, SelectControl, TextControl, ...), the controls here
 * represent instances of control types, that can be reused across visualization types.
 *
 * When controls are reused across viz types, their values are carried over as a user
 * changes the chart types.
 *
 * While the keys defined in the control itself get passed to the controlType as props,
 * here's a list of the keys that are common to all controls, and as a result define the
 * control interface.
 */
const categoricalSchemeRegistry = (0, _core.getCategoricalSchemeRegistry)();
const sequentialSchemeRegistry = (0, _core.getSequentialSchemeRegistry)();
const PRIMARY_COLOR = {
  r: 0,
  g: 122,
  b: 135,
  a: 1
};
exports.PRIMARY_COLOR = PRIMARY_COLOR;
const ROW_LIMIT_OPTIONS = [10, 50, 100, 250, 500, 1000, 5000, 10000, 50000];
const SERIES_LIMITS = [5, 10, 25, 50, 100, 500];
const groupByControl = {
  type: 'SelectControl',
  label: (0, _core.t)('Group by'),
  multi: true,
  freeForm: true,
  clearable: true,
  default: [],
  includeTime: false,
  description: (0, _core.t)('One or many columns to group by. High cardinality groupings should include a sort by metric ' + 'and series limit to limit the number of fetched and rendered series.'),
  optionRenderer: c => (0, _react2.jsx)(_ColumnOption.ColumnOption, {
    showType: true,
    column: c
  }),
  valueRenderer: c => (0, _react2.jsx)(_ColumnOption.ColumnOption, {
    column: c
  }),
  valueKey: 'column_name',
  allowAll: true,
  filterOption: ({
    data: opt
  }, text) => opt.column_name && opt.column_name.toLowerCase().includes(text.toLowerCase()) || opt.verbose_name && opt.verbose_name.toLowerCase().includes(text.toLowerCase()) || false,
  promptTextCreator: label => label,

  mapStateToProps(state, {
    includeTime
  }) {
    const newState = {};

    if (state.datasource) {
      const options = state.datasource.columns.filter(c => c.groupby);

      if (includeTime) {
        options.unshift(_constants.TIME_COLUMN_OPTION);
      }

      newState.options = options;
    }

    return newState;
  },

  commaChoosesOption: false
};
const metrics = {
  type: 'MetricsControl',
  multi: true,
  label: (0, _core.t)('Metrics'),
  validators: [_core.validateNonEmpty],
  mapStateToProps: ({
    datasource
  }) => ({
    columns: datasource ? datasource.columns : [],
    savedMetrics: datasource ? datasource.metrics : [],
    datasource,
    datasourceType: datasource == null ? void 0 : datasource.type
  }),
  description: (0, _core.t)('One or many metrics to display')
};
const metric = { ...metrics,
  multi: false,
  label: (0, _core.t)('Metric'),
  description: (0, _core.t)('Metric')
};
const datasourceControl = {
  type: 'DatasourceControl',
  label: (0, _core.t)('Datasource'),
  default: null,
  description: null,
  mapStateToProps: ({
    datasource,
    form_data
  }) => ({
    datasource,
    form_data
  })
};
const viz_type = {
  type: 'VizTypeControl',
  label: (0, _core.t)('Visualization Type'),
  default: 'table',
  description: (0, _core.t)('The type of visualization to display')
};
const color_picker = {
  type: 'ColorPickerControl',
  label: (0, _core.t)('Fixed Color'),
  description: (0, _core.t)('Use this to define a static color for all circles'),
  default: PRIMARY_COLOR,
  renderTrigger: true
};
const metric_2 = { ...metric,
  label: (0, _core.t)('Right Axis Metric'),
  clearable: true,
  description: (0, _core.t)('Choose a metric for right axis')
};
const linear_color_scheme = {
  type: 'ColorSchemeControl',
  label: (0, _core.t)('Linear Color Scheme'),
  choices: () => sequentialSchemeRegistry.values().map(value => [value.id, value.label]),
  default: sequentialSchemeRegistry.getDefaultKey(),
  clearable: false,
  description: '',
  renderTrigger: true,
  schemes: () => sequentialSchemeRegistry.getMap(),
  isLinear: true
};
const secondary_metric = { ...metric,
  label: (0, _core.t)('Color Metric'),
  default: null,
  validators: [],
  description: (0, _core.t)('A metric to use for color')
};
const columnsControl = { ...groupByControl,
  label: (0, _core.t)('Columns'),
  description: (0, _core.t)('One or many columns to pivot as columns')
};
const druid_time_origin = {
  type: 'SelectControl',
  freeForm: true,
  label: _constants.TIME_FILTER_LABELS.druid_time_origin,
  choices: [['', 'default'], ['now', 'now']],
  default: null,
  description: (0, _core.t)('Defines the origin where time buckets start, ' + 'accepts natural dates as in `now`, `sunday` or `1970-01-01`')
};
const granularity = {
  type: 'SelectControl',
  freeForm: true,
  label: _constants.TIME_FILTER_LABELS.granularity,
  default: 'one day',
  choices: [[null, 'all'], ['PT5S', '5 seconds'], ['PT30S', '30 seconds'], ['PT1M', '1 minute'], ['PT5M', '5 minutes'], ['PT30M', '30 minutes'], ['PT1H', '1 hour'], ['PT6H', '6 hour'], ['P1D', '1 day'], ['P7D', '7 days'], ['P1W', 'week'], ['week_starting_sunday', 'week starting Sunday'], ['week_ending_saturday', 'week ending Saturday'], ['P1M', 'month'], ['P3M', 'quarter'], ['P1Y', 'year']],
  description: (0, _core.t)('The time granularity for the visualization. Note that you ' + 'can type and use simple natural language as in `10 seconds`, ' + '`1 day` or `56 weeks`')
};
const granularity_sqla = {
  type: 'SelectControl',
  label: _constants.TIME_FILTER_LABELS.granularity_sqla,
  description: (0, _core.t)('The time column for the visualization. Note that you ' + 'can define arbitrary expression that return a DATETIME ' + 'column in the table. Also note that the ' + 'filter below is applied against this column or ' + 'expression'),
  default: c => c.default,
  clearable: false,
  optionRenderer: c => (0, _react2.jsx)(_ColumnOption.ColumnOption, {
    showType: true,
    column: c
  }),
  valueRenderer: c => (0, _react2.jsx)(_ColumnOption.ColumnOption, {
    column: c
  }),
  valueKey: 'column_name',
  mapStateToProps: state => {
    const props = {};

    if (state.datasource) {
      props.options = state.datasource.columns.filter(c => c.is_dttm);
      props.default = null;

      if (state.datasource.main_dttm_col) {
        props.default = state.datasource.main_dttm_col;
      } else if (props.options && props.options.length > 0) {
        props.default = props.options[0].column_name;
      }
    }

    return props;
  }
};
const time_grain_sqla = {
  type: 'SelectControl',
  label: _constants.TIME_FILTER_LABELS.time_grain_sqla,
  default: 'P1D',
  description: (0, _core.t)('The time granularity for the visualization. This ' + 'applies a date transformation to alter ' + 'your time column and defines a new time granularity. ' + 'The options here are defined on a per database ' + 'engine basis in the Superset source code.'),
  mapStateToProps: ({
    datasource
  }) => ({
    choices: (datasource == null ? void 0 : datasource.time_grain_sqla) || null
  })
};
const time_range = {
  type: 'DateFilterControl',
  freeForm: true,
  label: _constants.TIME_FILTER_LABELS.time_range,
  default: (0, _core.t)('No filter'),
  // this value is translated, but the backend wouldn't understand a translated value?
  description: (0, _core.t)('The time range for the visualization. All relative times, e.g. "Last month", ' + '"Last 7 days", "now", etc. are evaluated on the server using the server\'s ' + 'local time (sans timezone). All tooltips and placeholder times are expressed ' + 'in UTC (sans timezone). The timestamps are then evaluated by the database ' + "using the engine's local timezone. Note one can explicitly set the timezone " + 'per the ISO 8601 format if specifying either the start and/or end time.'),
  mapStateToProps: ({
    datasource,
    form_data
  }) => ({
    datasource,
    endpoints: (form_data == null ? void 0 : form_data.time_range_endpoints) || null
  })
};
const row_limit = {
  type: 'SelectControl',
  freeForm: true,
  label: (0, _core.t)('Row limit'),
  validators: [_core.legacyValidateInteger],
  default: 10000,
  choices: (0, _utils.formatSelectOptions)(ROW_LIMIT_OPTIONS),
  description: (0, _core.t)('Limits the number of rows that get displayed. Should be used in conjunction with a sort ' + 'by metric.')
};
const limit = {
  type: 'SelectControl',
  freeForm: true,
  label: (0, _core.t)('Series limit'),
  validators: [_core.legacyValidateInteger],
  choices: (0, _utils.formatSelectOptions)(SERIES_LIMITS),
  clearable: true,
  description: (0, _core.t)('Limits the number of series that get displayed. Should be used in conjunction with a sort ' + 'by metric. A joined subquery (or an extra phase where subqueries are not supported) is ' + 'applied to limit the number of series that get fetched and rendered. This feature is ' + 'useful when grouping by high cardinality column(s) though does increase the query ' + 'complexity and cost.')
};
const series_limit = {
  type: 'SelectControl',
  freeForm: true,
  label: (0, _core.t)('Series limit'),
  validators: [_core.legacyValidateInteger],
  choices: (0, _utils.formatSelectOptions)(SERIES_LIMITS),
  description: (0, _core.t)('Limits the number of series that get displayed. Should be used in conjunction with a sort ' + 'by metric. A joined subquery (or an extra phase where subqueries are not supported) is ' + 'applied to limit the number of series that get fetched and rendered. This feature is ' + 'useful when grouping by high cardinality column(s) though does increase the query ' + 'complexity and cost.')
};
const sort_by = {
  type: 'MetricsControl',
  label: (0, _core.t)('Sort by'),
  default: null,
  description: (0, _core.t)('Metric used to define the top series. Should be used in conjunction with the series or row ' + 'limit'),
  mapStateToProps: ({
    datasource
  }) => ({
    columns: (datasource == null ? void 0 : datasource.columns) || [],
    savedMetrics: (datasource == null ? void 0 : datasource.metrics) || [],
    datasource,
    datasourceType: datasource == null ? void 0 : datasource.type
  })
};
const series = { ...groupByControl,
  label: (0, _core.t)('Series'),
  multi: false,
  default: null,
  description: (0, _core.t)('Defines the grouping of entities. ' + 'Each series is shown as a specific color on the chart and ' + 'has a legend toggle')
};
const entity = { ...groupByControl,
  label: (0, _core.t)('Entity'),
  default: null,
  multi: false,
  validators: [_core.validateNonEmpty],
  description: (0, _core.t)('This defines the element to be plotted on the chart')
};
const x = { ...metric,
  label: (0, _core.t)('X Axis'),
  description: (0, _core.t)('Metric assigned to the [X] axis'),
  default: null
};
const y = { ...metric,
  label: (0, _core.t)('Y Axis'),
  default: null,
  description: (0, _core.t)('Metric assigned to the [Y] axis')
};
const size = { ...metric,
  label: (0, _core.t)('Bubble Size'),
  description: (0, _core.t)('Metric used to calculate bubble size'),
  default: null
};
const y_axis_format = {
  type: 'SelectControl',
  freeForm: true,
  label: (0, _core.t)('Y Axis Format'),
  renderTrigger: true,
  default: _utils.DEFAULT_NUMBER_FORMAT,
  choices: _utils.D3_FORMAT_OPTIONS,
  description: _utils.D3_FORMAT_DOCS,
  mapStateToProps: state => {
    var _state$controls, _state$controls$compa;

    const showWarning = ((_state$controls = state.controls) == null ? void 0 : (_state$controls$compa = _state$controls.comparison_type) == null ? void 0 : _state$controls$compa.value) === 'percentage';
    return {
      warning: showWarning ? (0, _core.t)('When `Calculation type` is set to "Percentage change", the Y ' + 'Axis Format is forced to `.1%`') : null,
      disabled: showWarning
    };
  }
};
const x_axis_time_format = {
  type: 'SelectControl',
  freeForm: true,
  label: (0, _core.t)('Time format'),
  renderTrigger: true,
  default: _utils.DEFAULT_TIME_FORMAT,
  choices: _utils.D3_TIME_FORMAT_OPTIONS,
  description: _utils.D3_TIME_FORMAT_DOCS
};
const adhoc_filters = {
  type: 'AdhocFilterControl',
  label: (0, _core.t)('Filters'),
  default: null,
  description: '',
  mapStateToProps: ({
    datasource,
    form_data
  }) => ({
    columns: (datasource == null ? void 0 : datasource.columns.filter(c => c.filterable)) || [],
    savedMetrics: (datasource == null ? void 0 : datasource.metrics) || [],
    // current active adhoc metrics
    selectedMetrics: form_data.metrics || (form_data.metric ? [form_data.metric] : []),
    datasource
  })
};
const color_scheme = {
  type: 'ColorSchemeControl',
  label: (0, _core.t)('Color Scheme'),
  default: categoricalSchemeRegistry.getDefaultKey(),
  renderTrigger: true,
  choices: () => categoricalSchemeRegistry.keys().map(s => [s, s]),
  description: (0, _core.t)('The color scheme for rendering chart'),
  schemes: () => categoricalSchemeRegistry.getMap()
};
const enableExploreDnd = (0, _core.isFeatureEnabled)(_core.FeatureFlag.ENABLE_EXPLORE_DRAG_AND_DROP);
const sharedControls = {
  metrics: enableExploreDnd ? _dndControls.dnd_adhoc_metrics : metrics,
  metric: enableExploreDnd ? _dndControls.dnd_adhoc_metric : metric,
  datasource: datasourceControl,
  viz_type,
  color_picker,
  metric_2: enableExploreDnd ? _dndControls.dnd_adhoc_metric_2 : metric_2,
  linear_color_scheme,
  secondary_metric: enableExploreDnd ? _dndControls.dnd_secondary_metric : secondary_metric,
  groupby: enableExploreDnd ? _dndControls.dndGroupByControl : groupByControl,
  columns: enableExploreDnd ? _dndControls.dndColumnsControl : columnsControl,
  druid_time_origin,
  granularity,
  granularity_sqla: enableExploreDnd ? _dndControls.dnd_granularity_sqla : granularity_sqla,
  time_grain_sqla,
  time_range,
  row_limit,
  limit,
  timeseries_limit_metric: enableExploreDnd ? _dndControls.dnd_sort_by : sort_by,
  orderby: enableExploreDnd ? _dndControls.dnd_sort_by : sort_by,
  series: enableExploreDnd ? _dndControls.dndSeries : series,
  entity: enableExploreDnd ? _dndControls.dndEntity : entity,
  x: enableExploreDnd ? _dndControls.dnd_x : x,
  y: enableExploreDnd ? _dndControls.dnd_y : y,
  size: enableExploreDnd ? _dndControls.dnd_size : size,
  y_axis_format,
  x_axis_time_format,
  adhoc_filters: enableExploreDnd ? _dndControls.dnd_adhoc_filters : adhoc_filters,
  color_scheme,
  series_columns: enableExploreDnd ? _dndControls.dndColumnsControl : columnsControl,
  series_limit,
  series_limit_metric: enableExploreDnd ? _dndControls.dnd_sort_by : sort_by,
  legacy_order_by: enableExploreDnd ? _dndControls.dnd_sort_by : sort_by
};
exports.sharedControls = sharedControls;

/***/ }),

/***/ 36602:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.legacySortBy = void 0;

var _core = __webpack_require__(67017);

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const legacySortBy = [['legacy_order_by'], [{
  name: 'order_desc',
  config: {
    type: 'CheckboxControl',
    label: (0, _core.t)('Sort descending'),
    default: true,
    description: (0, _core.t)('Whether to sort descending or ascending. Takes effect only when "Sort by" is set')
  }
}]];
exports.legacySortBy = legacySortBy;

/***/ }),

/***/ 95424:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports["default"] = exports.Metric = exports.MULTIPLE_VALUE_COMPARATORS = exports.ControlFormItemSpec = exports.ControlComponentProps = exports.COMPARATOR = void 0;

var _core = __webpack_require__(67017);

exports.Metric = _core.Metric;

var _ControlForm = __webpack_require__(5537);

exports.ControlFormItemSpec = _ControlForm.ControlFormItemSpec;

var _types = __webpack_require__(2441);

exports.ControlComponentProps = _types.ControlComponentProps;
// Ref:
//  - superset-frontend/src/explore/components/ConditionalFormattingControl.tsx
let COMPARATOR;
exports.COMPARATOR = COMPARATOR;

(function (COMPARATOR) {
  COMPARATOR["NONE"] = "None";
  COMPARATOR["GREATER_THAN"] = ">";
  COMPARATOR["LESS_THAN"] = "<";
  COMPARATOR["GREATER_OR_EQUAL"] = "\u2265";
  COMPARATOR["LESS_OR_EQUAL"] = "\u2264";
  COMPARATOR["EQUAL"] = "=";
  COMPARATOR["NOT_EQUAL"] = "\u2260";
  COMPARATOR["BETWEEN"] = "< x <";
  COMPARATOR["BETWEEN_OR_EQUAL"] = "\u2264 x \u2264";
  COMPARATOR["BETWEEN_OR_LEFT_EQUAL"] = "\u2264 x <";
  COMPARATOR["BETWEEN_OR_RIGHT_EQUAL"] = "< x \u2264";
})(COMPARATOR || (exports.COMPARATOR = COMPARATOR = {}));

const MULTIPLE_VALUE_COMPARATORS = [COMPARATOR.BETWEEN, COMPARATOR.BETWEEN_OR_EQUAL, COMPARATOR.BETWEEN_OR_LEFT_EQUAL, COMPARATOR.BETWEEN_OR_RIGHT_EQUAL];
exports.MULTIPLE_VALUE_COMPARATORS = MULTIPLE_VALUE_COMPARATORS;
var _default = {};
exports["default"] = _default;

/***/ }),

/***/ 54745:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.DEFAULT_TIME_FORMAT = exports.DEFAULT_NUMBER_FORMAT = exports.D3_TIME_FORMAT_OPTIONS = exports.D3_TIME_FORMAT_DOCS = exports.D3_FORMAT_OPTIONS = exports.D3_FORMAT_DOCS = void 0;

var _core = __webpack_require__(67017);

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// D3 specific formatting config
const D3_FORMAT_DOCS = (0, _core.t)('D3 format syntax: https://github.com/d3/d3-format'); // input choices & options

exports.D3_FORMAT_DOCS = D3_FORMAT_DOCS;
const D3_FORMAT_OPTIONS = [[_core.NumberFormats.SMART_NUMBER, (0, _core.t)('Adaptative formating')], ['~g', (0, _core.t)('Original value')], [',d', ',d (12345.432 => 12,345)'], ['.1s', '.1s (12345.432 => 10k)'], ['.3s', '.3s (12345.432 => 12.3k)'], [',.1%', ',.1% (12345.432 => 1,234,543.2%)'], ['.2%', '.2% (12345.432 => 1234543.20%)'], ['.3%', '.3% (12345.432 => 1234543.200%)'], ['.4r', '.4r (12345.432 => 12350)'], [',.3f', ',.3f (12345.432 => 12,345.432)'], ['+,', '+, (12345.432 => +12,345.432)'], ['$,.2f', '$,.2f (12345.432 => $12,345.43)'], ['DURATION', (0, _core.t)('Duration in ms (66000 => 1m 6s)')], ['DURATION_SUB', (0, _core.t)('Duration in ms (1.40008 => 1ms 400µs 80ns)')]];
exports.D3_FORMAT_OPTIONS = D3_FORMAT_OPTIONS;
const D3_TIME_FORMAT_DOCS = (0, _core.t)('D3 time format syntax: https://github.com/d3/d3-time-format');
exports.D3_TIME_FORMAT_DOCS = D3_TIME_FORMAT_DOCS;
const D3_TIME_FORMAT_OPTIONS = [[_core.smartDateFormatter.id, (0, _core.t)('Adaptative formating')], ['%d/%m/%Y', '%d/%m/%Y | 14/01/2019'], ['%m/%d/%Y', '%m/%d/%Y | 01/14/2019'], ['%Y-%m-%d', '%Y-%m-%d | 2019-01-14'], ['%Y-%m-%d %H:%M:%S', '%Y-%m-%d %H:%M:%S | 2019-01-14 01:32:10'], ['%d-%m-%Y %H:%M:%S', '%d-%m-%Y %H:%M:%S | 14-01-2019 01:32:10'], ['%H:%M:%S', '%H:%M:%S | 01:32:10']];
exports.D3_TIME_FORMAT_OPTIONS = D3_TIME_FORMAT_OPTIONS;
const DEFAULT_NUMBER_FORMAT = D3_FORMAT_OPTIONS[0][0];
exports.DEFAULT_NUMBER_FORMAT = DEFAULT_NUMBER_FORMAT;
const DEFAULT_TIME_FORMAT = D3_TIME_FORMAT_OPTIONS[0][0];
exports.DEFAULT_TIME_FORMAT = DEFAULT_TIME_FORMAT;

/***/ }),

/***/ 22621:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = columnChoices;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Convert Datasource columns to column choices
 */
function columnChoices(datasource) {
  return (datasource == null ? void 0 : datasource.columns.map(col => [col.column_name, col.verbose_name || col.column_name]).sort((opt1, opt2) => opt1[1].toLowerCase() > opt2[1].toLowerCase() ? 1 : -1)) || [];
}

/***/ }),

/***/ 98711:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.expandControlConfig = expandControlConfig;
exports.expandControlType = expandControlType;

var _react = _interopRequireDefault(__webpack_require__(67294));

var _sharedControls = __webpack_require__(25987);

var _components = _interopRequireDefault(__webpack_require__(12330));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function expandControlType(controlType) {
  if (typeof controlType === 'string' && controlType in _components.default) {
    return _components.default[controlType];
  }

  return controlType;
}
/**
 * Expand a shorthand control config item to full config in the format of
 *   {
 *     name: ...,
 *     config: {
 *        type: ...,
 *        ...
 *     }
 *   }
 */


function expandControlConfig(control, controlOverrides = {}) {
  // one of the named shared controls
  if (typeof control === 'string' && control in _sharedControls.sharedControls) {
    const name = control;
    return {
      name,
      config: { ..._sharedControls.sharedControls[name],
        ...controlOverrides[name]
      }
    };
  } // JSX/React element or NULL


  if (!control || typeof control === 'string' || /*#__PURE__*/_react.default.isValidElement(control)) {
    return control;
  } // already fully expanded control config, e.g.
  // {
  //   name: 'metric',
  //   config: {
  //     type: 'SelectControl' | SelectComonent
  //   }
  // }


  if ('name' in control && 'config' in control) {
    return { ...control,
      config: { ...control.config,
        type: expandControlType(control.config.type)
      }
    };
  } // apply overrides with shared controls


  if ('override' in control && control.name in _sharedControls.sharedControls) {
    const {
      name,
      override
    } = control;
    return {
      name,
      config: { ..._sharedControls.sharedControls[name],
        ...override
      }
    };
  }

  return null;
}

/***/ }),

/***/ 81733:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
exports.round = exports.rgbToRgba = exports.getOpacity = exports.getColorFunction = exports.getColorFormatters = void 0;

var _types = __webpack_require__(95424);

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const round = (num, precision = 0) => Number(`${Math.round(Number(`${num}e+${precision}`))}e-${precision}`);

exports.round = round;

const rgbToRgba = (rgb, alpha) => rgb.replace(/rgb/i, 'rgba').replace(/\)/i, `,${alpha})`);

exports.rgbToRgba = rgbToRgba;
const MIN_OPACITY_BOUNDED = 0.05;
const MIN_OPACITY_UNBOUNDED = 0;
const MAX_OPACITY = 1;

const getOpacity = (value, cutoffPoint, extremeValue, minOpacity = MIN_OPACITY_BOUNDED, maxOpacity = MAX_OPACITY) => extremeValue === cutoffPoint ? maxOpacity : round(Math.abs((maxOpacity - minOpacity) / (extremeValue - cutoffPoint) * (value - cutoffPoint)) + minOpacity, 2);

exports.getOpacity = getOpacity;

const getColorFunction = ({
  operator,
  targetValue,
  targetValueLeft,
  targetValueRight,
  colorScheme
}, columnValues) => {
  let minOpacity = MIN_OPACITY_BOUNDED;
  const maxOpacity = MAX_OPACITY;
  let comparatorFunction;

  if (operator === undefined || colorScheme === undefined) {
    return () => undefined;
  }

  if (_types.MULTIPLE_VALUE_COMPARATORS.includes(operator) && (targetValueLeft === undefined || targetValueRight === undefined)) {
    return () => undefined;
  }

  if (operator !== _types.COMPARATOR.NONE && !_types.MULTIPLE_VALUE_COMPARATORS.includes(operator) && targetValue === undefined) {
    return () => undefined;
  }

  switch (operator) {
    case _types.COMPARATOR.NONE:
      minOpacity = MIN_OPACITY_UNBOUNDED;

      comparatorFunction = (value, allValues) => {
        const cutoffValue = Math.min(...allValues);
        const extremeValue = Math.max(...allValues);
        return value >= cutoffValue && value <= extremeValue ? {
          cutoffValue,
          extremeValue
        } : false;
      };

      break;

    case _types.COMPARATOR.GREATER_THAN:
      comparatorFunction = (value, allValues) => value > targetValue ? {
        cutoffValue: targetValue,
        extremeValue: Math.max(...allValues)
      } : false;

      break;

    case _types.COMPARATOR.LESS_THAN:
      comparatorFunction = (value, allValues) => value < targetValue ? {
        cutoffValue: targetValue,
        extremeValue: Math.min(...allValues)
      } : false;

      break;

    case _types.COMPARATOR.GREATER_OR_EQUAL:
      comparatorFunction = (value, allValues) => value >= targetValue ? {
        cutoffValue: targetValue,
        extremeValue: Math.max(...allValues)
      } : false;

      break;

    case _types.COMPARATOR.LESS_OR_EQUAL:
      comparatorFunction = (value, allValues) => value <= targetValue ? {
        cutoffValue: targetValue,
        extremeValue: Math.min(...allValues)
      } : false;

      break;

    case _types.COMPARATOR.EQUAL:
      comparatorFunction = value => value === targetValue ? {
        cutoffValue: targetValue,
        extremeValue: targetValue
      } : false;

      break;

    case _types.COMPARATOR.NOT_EQUAL:
      comparatorFunction = (value, allValues) => {
        if (value === targetValue) {
          return false;
        }

        const max = Math.max(...allValues);
        const min = Math.min(...allValues);
        return {
          cutoffValue: targetValue,
          extremeValue: Math.abs(targetValue - min) > Math.abs(max - targetValue) ? min : max
        };
      };

      break;

    case _types.COMPARATOR.BETWEEN:
      comparatorFunction = value => value > targetValueLeft && value < targetValueRight ? {
        cutoffValue: targetValueLeft,
        extremeValue: targetValueRight
      } : false;

      break;

    case _types.COMPARATOR.BETWEEN_OR_EQUAL:
      comparatorFunction = value => value >= targetValueLeft && value <= targetValueRight ? {
        cutoffValue: targetValueLeft,
        extremeValue: targetValueRight
      } : false;

      break;

    case _types.COMPARATOR.BETWEEN_OR_LEFT_EQUAL:
      comparatorFunction = value => value >= targetValueLeft && value < targetValueRight ? {
        cutoffValue: targetValueLeft,
        extremeValue: targetValueRight
      } : false;

      break;

    case _types.COMPARATOR.BETWEEN_OR_RIGHT_EQUAL:
      comparatorFunction = value => value > targetValueLeft && value <= targetValueRight ? {
        cutoffValue: targetValueLeft,
        extremeValue: targetValueRight
      } : false;

      break;

    default:
      comparatorFunction = () => false;

      break;
  }

  return value => {
    const compareResult = comparatorFunction(value, columnValues);
    if (compareResult === false) return undefined;
    const {
      cutoffValue,
      extremeValue
    } = compareResult;
    return rgbToRgba(colorScheme, getOpacity(value, cutoffValue, extremeValue, minOpacity, maxOpacity));
  };
};

exports.getColorFunction = getColorFunction;

const getColorFormatters = (columnConfig, data) => (columnConfig == null ? void 0 : columnConfig.reduce((acc, config) => {
  if ((config == null ? void 0 : config.column) !== undefined && ((config == null ? void 0 : config.operator) === _types.COMPARATOR.NONE || (config == null ? void 0 : config.operator) !== undefined && (_types.MULTIPLE_VALUE_COMPARATORS.includes(config == null ? void 0 : config.operator) ? (config == null ? void 0 : config.targetValueLeft) !== undefined && (config == null ? void 0 : config.targetValueRight) !== undefined : (config == null ? void 0 : config.targetValue) !== undefined))) {
    acc.push({
      column: config == null ? void 0 : config.column,
      getColorFromValue: getColorFunction(config, data.map(row => row[config.column]))
    });
  }

  return acc;
}, [])) ?? [];

exports.getColorFormatters = getColorFormatters;

/***/ }),

/***/ 57639:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;
var _exportNames = {
  mainMetric: true,
  columnChoices: true
};
exports.mainMetric = exports.columnChoices = void 0;

var _selectOptions = __webpack_require__(96272);

Object.keys(_selectOptions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectOptions[key]) return;
  exports[key] = _selectOptions[key];
});

var _D3Formatting = __webpack_require__(54745);

Object.keys(_D3Formatting).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _D3Formatting[key]) return;
  exports[key] = _D3Formatting[key];
});

var _expandControlConfig = __webpack_require__(98711);

Object.keys(_expandControlConfig).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _expandControlConfig[key]) return;
  exports[key] = _expandControlConfig[key];
});

var _getColorFormatters = __webpack_require__(81733);

Object.keys(_getColorFormatters).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _getColorFormatters[key]) return;
  exports[key] = _getColorFormatters[key];
});

var _mainMetric = _interopRequireDefault(__webpack_require__(57094));

exports.mainMetric = _mainMetric.default;

var _columnChoices = _interopRequireDefault(__webpack_require__(22621));

exports.columnChoices = _columnChoices.default;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/***/ }),

/***/ 57094:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = mainMetric;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function mainMetric(savedMetrics) {
  // Using 'count' as default metric if it exists, otherwise using whatever one shows up first
  let metric;

  if (savedMetrics && savedMetrics.length > 0) {
    savedMetrics.forEach(m => {
      if (m.metric_name === 'count') {
        metric = 'count';
      }
    });

    if (!metric) {
      metric = savedMetrics[0].metric_name;
    }
  }

  return metric;
}

/***/ }),

/***/ 96272:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.__esModule = true;
exports.formatSelectOptions = formatSelectOptions;
exports.formatSelectOptionsForRange = formatSelectOptionsForRange;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// helper functions for select controls

/** Turns an array of string/number options into options for a select input */
function formatSelectOptions(options) {
  return options.map(opt => Array.isArray(opt) ? opt : [opt, opt.toString()]);
}
/**
 * Outputs array of arrays
 *   >> formatSelectOptionsForRange(1, 5)
 *   >> [[1,'1'], [2,'2'], [3,'3'], [4,'4'], [5,'5']]
 */


function formatSelectOptionsForRange(start, end) {
  const options = [];

  for (let i = start; i <= end; i += 1) {
    options.push([i, i.toString()]);
  }

  return options;
}

/***/ }),

/***/ 73699:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ CalendarChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-calendar/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function transformProps(chartProps) {
  const {
    height,
    formData,
    queriesData,
    datasource
  } = chartProps;
  const {
    cellPadding,
    cellRadius,
    cellSize,
    domainGranularity,
    linearColorScheme,
    showLegend,
    showMetricName,
    showValues,
    steps,
    subdomainGranularity,
    xAxisTimeFormat,
    yAxisFormat
  } = formData;
  const {
    verboseMap
  } = datasource;
  return {
    height,
    data: queriesData[0].data,
    cellPadding,
    cellRadius,
    cellSize,
    domainGranularity,
    linearColorScheme,
    showLegend,
    showMetricName,
    showValues,
    steps,
    subdomainGranularity,
    timeFormat: xAxisTimeFormat,
    valueFormat: yAxisFormat,
    verboseMap
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/legacyValidateInteger.js
var legacyValidateInteger = __webpack_require__(12788);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-calendar/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[{
      name: 'domain_granularity',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Domain'),
        default: 'month',
        choices: (0,selectOptions/* formatSelectOptions */.m)(['hour', 'day', 'week', 'month', 'year']),
        description: (0,TranslatorSingleton.t)('The time unit used for the grouping of blocks')
      }
    }, {
      name: 'subdomain_granularity',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Subdomain'),
        default: 'day',
        choices: (0,selectOptions/* formatSelectOptions */.m)(['min', 'hour', 'day', 'week', 'month']),
        description: (0,TranslatorSingleton.t)('The time unit for each block. Should be a smaller unit than ' + 'domain_granularity. Should be larger or equal to Time Grain')
      }
    }], ['metrics'], ['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    tabOverride: 'customize',
    controlSetRows: [['linear_color_scheme'], [{
      name: 'cell_size',
      config: {
        type: 'TextControl',
        isInt: true,
        default: 10,
        validators: [legacyValidateInteger/* default */.Z],
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Cell Size'),
        description: (0,TranslatorSingleton.t)('The size of the square cell, in pixels')
      }
    }, {
      name: 'cell_padding',
      config: {
        type: 'TextControl',
        isInt: true,
        validators: [legacyValidateInteger/* default */.Z],
        renderTrigger: true,
        default: 2,
        label: (0,TranslatorSingleton.t)('Cell Padding'),
        description: (0,TranslatorSingleton.t)('The distance between cells, in pixels')
      }
    }], [{
      name: 'cell_radius',
      config: {
        type: 'TextControl',
        isInt: true,
        validators: [legacyValidateInteger/* default */.Z],
        renderTrigger: true,
        default: 0,
        label: (0,TranslatorSingleton.t)('Cell Radius'),
        description: (0,TranslatorSingleton.t)('The pixel radius')
      }
    }, {
      name: 'steps',
      config: {
        type: 'TextControl',
        isInt: true,
        validators: [legacyValidateInteger/* default */.Z],
        renderTrigger: true,
        default: 10,
        label: (0,TranslatorSingleton.t)('Color Steps'),
        description: (0,TranslatorSingleton.t)('The number color "steps"')
      }
    }], ['y_axis_format', {
      name: 'x_axis_time_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Time Format'),
        renderTrigger: true,
        default: 'smart_date',
        choices: D3Formatting/* D3_TIME_FORMAT_OPTIONS */.HC,
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }], [{
      name: 'show_legend',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Legend'),
        renderTrigger: true,
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to display the legend (toggles)')
      }
    }, {
      name: 'show_values',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show Values'),
        renderTrigger: true,
        default: false,
        description: (0,TranslatorSingleton.t)('Whether to display the numerical values within the cells')
      }
    }], [{
      name: 'show_metric_name',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show Metric Names'),
        renderTrigger: true,
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to display the metric name as a title')
      }
    }, null]]
  }],
  controlOverrides: {
    y_axis_format: {
      label: (0,TranslatorSingleton.t)('Number Format')
    }
  }
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-calendar/esm/images/thumbnail.png
var thumbnail = __webpack_require__(2790);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-calendar/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Correlation'),
  credits: ['https://github.com/wa0x6e/cal-heatmap'],
  description: (0,TranslatorSingleton.t)("Visualizes how a metric has changed over a time using a color scale and a calendar view. Gray values are used to indicate missing values and the linear color scheme is used to encode the magnitude of each day's value."),
  name: (0,TranslatorSingleton.t)('Calendar Heatmap'),
  tags: [(0,TranslatorSingleton.t)('Business'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Intensity'), (0,TranslatorSingleton.t)('Pattern'), (0,TranslatorSingleton.t)('Report'), (0,TranslatorSingleton.t)('Trend')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class CalendarChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 3609).then(__webpack_require__.bind(__webpack_require__, 33609)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 40758:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ ChordChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-chord/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData
  } = chartProps;
  const {
    yAxisFormat,
    colorScheme
  } = formData;
  return {
    colorScheme,
    data: queriesData[0].data,
    height,
    numberFormat: yAxisFormat,
    width
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-chord/esm/images/chord.jpg
var chord = __webpack_require__(40791);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-chord/esm/images/thumbnail.png
var thumbnail = __webpack_require__(16629);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-chord/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['groupby'], ['columns'], ['metric'], ['adhoc_filters'], ['row_limit'], [{
      name: 'sort_by_metric',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort by metric'),
        description: (0,TranslatorSingleton.t)('Whether to sort results by the selected metric in descending order.')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['y_axis_format', null], ['color_scheme']]
  }],
  controlOverrides: {
    y_axis_format: {
      label: (0,TranslatorSingleton.t)('Number format'),
      description: (0,TranslatorSingleton.t)('Choose a number format')
    },
    groupby: {
      label: (0,TranslatorSingleton.t)('Source'),
      multi: false,
      validators: [validateNonEmpty/* default */.Z],
      description: (0,TranslatorSingleton.t)('Choose a source')
    },
    columns: {
      label: (0,TranslatorSingleton.t)('Target'),
      multi: false,
      validators: [validateNonEmpty/* default */.Z],
      description: (0,TranslatorSingleton.t)('Choose a target')
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-chord/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Flow'),
  credits: ['https://github.com/d3/d3-chord'],
  description: (0,TranslatorSingleton.t)('Showcases the flow or link between categories using thickness of chords. The value and corresponding thickness can be different for each side.'),
  exampleGallery: [{
    url: chord,
    caption: (0,TranslatorSingleton.t)('Relationships between community channels')
  }],
  name: (0,TranslatorSingleton.t)('Chord Diagram'),
  tags: [(0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Circular'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Proportional'), (0,TranslatorSingleton.t)('Relational')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class ChordChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 4214).then(__webpack_require__.bind(__webpack_require__, 84214)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 84145:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "O$": () => (/* binding */ countryOptions),
  "ZP": () => (/* binding */ esm_countries)
});

// UNUSED EXPORTS: countries

;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/austria.geojson
/* harmony default export */ const austria_geojson = (__webpack_require__.p + "51e63353157d161b3daaa16b6212900b.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/australia.geojson
/* harmony default export */ const australia_geojson = (__webpack_require__.p + "f22e1a272f3fe479735dfe59e6b62be5.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/belgium.geojson
/* harmony default export */ const belgium_geojson = (__webpack_require__.p + "507b50ca0abcdd1807f0f1502ad9b018.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/brazil.geojson
/* harmony default export */ const brazil_geojson = (__webpack_require__.p + "29cdc026a93aac8ebc6896d63d789619.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/bulgaria.geojson
/* harmony default export */ const bulgaria_geojson = (__webpack_require__.p + "6c09551ba203db8194920c504b147b87.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/canada.geojson
/* harmony default export */ const canada_geojson = (__webpack_require__.p + "2d1c2274addbaa120c98cb8c5fc63225.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/china.geojson
/* harmony default export */ const china_geojson = (__webpack_require__.p + "65d35076af8ab2eac6355ea6f4932f54.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/denmark.geojson
/* harmony default export */ const denmark_geojson = (__webpack_require__.p + "07f8fe00a15a06001e187960a164f81d.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/egypt.geojson
/* harmony default export */ const egypt_geojson = (__webpack_require__.p + "482604fd26aec8555b554193fe299daf.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/estonia.geojson
/* harmony default export */ const estonia_geojson = (__webpack_require__.p + "fb36ce6173f349ecb7c3926c51312bb5.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/france.geojson
/* harmony default export */ const france_geojson = (__webpack_require__.p + "db73cdf9382082bd64568fb3c3c1d19a.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/finland.geojson
/* harmony default export */ const finland_geojson = (__webpack_require__.p + "69f69acfefa35cee80dc3d1169076547.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/germany.geojson
/* harmony default export */ const germany_geojson = (__webpack_require__.p + "0b0930870fc825c4179f3db209287ddf.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/iceland.geojson
/* harmony default export */ const iceland_geojson = (__webpack_require__.p + "c9a7cf9c53c4e29579fe2a0b85374b31.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/india.geojson
/* harmony default export */ const india_geojson = (__webpack_require__.p + "b8b3db767e72bb14109895773b449218.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/indonesia.geojson
/* harmony default export */ const indonesia_geojson = (__webpack_require__.p + "7899d5faef2cd49f3caee8b4fe426c00.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/iran.geojson
/* harmony default export */ const iran_geojson = (__webpack_require__.p + "ecef1f8d559e4cfaf81ca75766a01c08.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/italy.geojson
/* harmony default export */ const italy_geojson = (__webpack_require__.p + "fae8345f42e5b7fdfa835389686aa69a.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/italy_regions.geojson
/* harmony default export */ const italy_regions_geojson = (__webpack_require__.p + "4da2a0e333431499fbdf956b72eb57c1.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/japan.geojson
/* harmony default export */ const japan_geojson = (__webpack_require__.p + "abdb2ac2a293dba71885bd1b04ba997f.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/korea.geojson
/* harmony default export */ const korea_geojson = (__webpack_require__.p + "4c9e70c517f4ce686a356b497f1d4450.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/liechtenstein.geojson
/* harmony default export */ const liechtenstein_geojson = (__webpack_require__.p + "abcdc85f5630a561d0043adf1cb66806.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/norway.geojson
/* harmony default export */ const norway_geojson = (__webpack_require__.p + "b5284f22f5b1d7e143a7c8dc1b2db6de.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/malaysia.geojson
/* harmony default export */ const malaysia_geojson = (__webpack_require__.p + "7ceab90dfd56e87a7cc25947d5af4b30.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/morocco.geojson
/* harmony default export */ const morocco_geojson = (__webpack_require__.p + "b6a5c6e2250371805425362004735d5e.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/myanmar.geojson
/* harmony default export */ const myanmar_geojson = (__webpack_require__.p + "b08814fae94db61986c78d1f83c4e811.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/netherlands.geojson
/* harmony default export */ const netherlands_geojson = (__webpack_require__.p + "02ee1f901f37edc930b2bb240bad8b1c.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/peru.geojson
/* harmony default export */ const peru_geojson = (__webpack_require__.p + "93fc6c5af29fb7674df597bb2dc4d8d9.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/poland.geojson
/* harmony default export */ const poland_geojson = (__webpack_require__.p + "729bbc338676d796a6a3146d8dce7912.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/portugal.geojson
/* harmony default export */ const portugal_geojson = (__webpack_require__.p + "222e541cf444b429fc49e79247edfa2a.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/russia.geojson
/* harmony default export */ const russia_geojson = (__webpack_require__.p + "b1c651abda39a10be6661b03da9c2b68.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/saudi_arabia.geojson
/* harmony default export */ const saudi_arabia_geojson = (__webpack_require__.p + "784baa8ed3278d8e42596b731c90ad76.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/singapore.geojson
/* harmony default export */ const singapore_geojson = (__webpack_require__.p + "18441afa379e8c4066d1c3b77605d422.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/slovenia.geojson
/* harmony default export */ const slovenia_geojson = (__webpack_require__.p + "f380027a31e4f5f699c86824a1b1f2c1.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/sweden.geojson
/* harmony default export */ const sweden_geojson = (__webpack_require__.p + "25c74aff85fd0fbce4858fc5378fe9d9.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/spain.geojson
/* harmony default export */ const spain_geojson = (__webpack_require__.p + "9b1864d5cd1eb0b3c5ef62eea07c2218.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/switzerland.geojson
/* harmony default export */ const switzerland_geojson = (__webpack_require__.p + "e3c1deb71bf3cf4a463f6353d698a74d.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/syria.geojson
/* harmony default export */ const syria_geojson = (__webpack_require__.p + "8577532d35419a7c77996cc630362414.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/thailand.geojson
/* harmony default export */ const thailand_geojson = (__webpack_require__.p + "bcdbcfcc198f9892967e1906165c45a7.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/timorleste.geojson
/* harmony default export */ const timorleste_geojson = (__webpack_require__.p + "76143256c3726a97195b29b677d0c7bf.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/uk.geojson
/* harmony default export */ const uk_geojson = (__webpack_require__.p + "fa0ce46ef52d0cfa98bb8aec878b1d82.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/ukraine.geojson
/* harmony default export */ const ukraine_geojson = (__webpack_require__.p + "439b764f12d2a5d2d9f4227c0273e476.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/uruguay.geojson
/* harmony default export */ const uruguay_geojson = (__webpack_require__.p + "1d205b6aa1ba61dc6a5b9126e5054892.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/usa.geojson
/* harmony default export */ const usa_geojson = (__webpack_require__.p + "55ec61228b7c4faf90f576f20a8f695a.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/zambia.geojson
/* harmony default export */ const zambia_geojson = (__webpack_require__.p + "fb49fc0b552ea2e6abaa9fdfe6e80f69.geojson");
;// CONCATENATED MODULE: ./node_modules/file-loader/dist/cjs.js!./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries/vietnam.geojson
/* harmony default export */ const vietnam_geojson = (__webpack_require__.p + "7b00a05b6aaeb68413300b0ba6eb45b3.geojson");
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries.js
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/* eslint-disable import/no-webpack-loader-syntax, import/no-unresolved */














































const countries = {
  austria: austria_geojson,
  australia: australia_geojson,
  belgium: belgium_geojson,
  brazil: brazil_geojson,
  bulgaria: bulgaria_geojson,
  canada: canada_geojson,
  china: china_geojson,
  denmark: denmark_geojson,
  egypt: egypt_geojson,
  estonia: estonia_geojson,
  france: france_geojson,
  finland: finland_geojson,
  germany: germany_geojson,
  iceland: iceland_geojson,
  india: india_geojson,
  indonesia: indonesia_geojson,
  iran: iran_geojson,
  italy: italy_geojson,
  italy_regions: italy_regions_geojson,
  japan: japan_geojson,
  korea: korea_geojson,
  liechtenstein: liechtenstein_geojson,
  malaysia: malaysia_geojson,
  morocco: morocco_geojson,
  myanmar: myanmar_geojson,
  netherlands: netherlands_geojson,
  norway: norway_geojson,
  peru: peru_geojson,
  poland: poland_geojson,
  portugal: portugal_geojson,
  russia: russia_geojson,
  saudi_arabia: saudi_arabia_geojson,
  singapore: singapore_geojson,
  slovenia: slovenia_geojson,
  spain: spain_geojson,
  sweden: sweden_geojson,
  switzerland: switzerland_geojson,
  syria: syria_geojson,
  thailand: thailand_geojson,
  timorleste: timorleste_geojson,
  uk: uk_geojson,
  ukraine: ukraine_geojson,
  uruguay: uruguay_geojson,
  usa: usa_geojson,
  zambia: zambia_geojson,
  vietnam: vietnam_geojson
};
const countryOptions = Object.keys(countries).map(x => {
  if (x === 'uk' || x === 'usa') {
    return [x, x.toUpperCase()];
  }

  if (x === 'italy_regions') {
    return [x, 'Italy (regions)'];
  }

  return [x, x[0].toUpperCase() + x.slice(1)];
});
/* harmony default export */ const esm_countries = (countries);

/***/ }),

/***/ 90022:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ CountryMapChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData
  } = chartProps;
  const {
    linearColorScheme,
    numberFormat,
    selectCountry
  } = formData;
  return {
    width,
    height,
    data: queriesData[0].data,
    country: selectCountry ? String(selectCountry).toLowerCase() : null,
    linearColorScheme,
    numberFormat
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/images/thumbnail.png
var thumbnail = __webpack_require__(39823);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/countries.js + 46 modules
var countries = __webpack_require__(84145);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[{
      name: 'select_country',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Country'),
        default: null,
        choices: countries/* countryOptions */.O$,
        description: (0,TranslatorSingleton.t)('Which country to plot the map for?'),
        validators: [validateNonEmpty/* default */.Z]
      }
    }], ['entity'], ['metric'], ['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    tabOverride: 'customize',
    controlSetRows: [[{
      name: 'number_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Number format'),
        renderTrigger: true,
        default: 'SMART_NUMBER',
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6,
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }], ['linear_color_scheme']]
  }],
  controlOverrides: {
    entity: {
      label: (0,TranslatorSingleton.t)('ISO 3166-2 Codes'),
      description: (0,TranslatorSingleton.t)('Column containing ISO 3166-2 codes of region/province/department in your table.')
    },
    metric: {
      label: (0,TranslatorSingleton.t)('Metric'),
      description: (0,TranslatorSingleton.t)('Metric to display bottom title')
    },
    linear_color_scheme: {
      renderTrigger: false
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-country-map/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Map'),
  credits: ['https://bl.ocks.org/john-guerra'],
  description: (0,TranslatorSingleton.t)("Visualizes how a single metric varies across a country's principal subdivisions (states, provinces, etc) on a chloropleth map. Each subdivision's value is elevated when you hover over the corresponding geographic boundary."),
  name: (0,TranslatorSingleton.t)('Country Map'),
  tags: [(0,TranslatorSingleton.t)('2D'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Geo'), (0,TranslatorSingleton.t)('Range'), (0,TranslatorSingleton.t)('Report'), (0,TranslatorSingleton.t)('Stacked')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class CountryMapChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 9885).then(__webpack_require__.bind(__webpack_require__, 79885)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 42575:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EventFlowChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-event-flow/esm/images/thumbnail.png
var thumbnail = __webpack_require__(90657);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/columnChoices.js
var columnChoices = __webpack_require__(87581);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/components/ColumnOption.js
var ColumnOption = __webpack_require__(82204);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-event-flow/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Event definition'),
    controlSetRows: [['entity'], [{
      name: 'all_columns_x',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Event Names'),
        description: (0,TranslatorSingleton.t)('Columns to display'),
        mapStateToProps: state => ({
          choices: (0,columnChoices/* default */.Z)(state == null ? void 0 : state.datasource)
        }),
        // choices is from `mapStateToProps`
        default: control => control.choices && control.choices.length > 0 ? control.choices[0][0] : null,
        validators: [validateNonEmpty/* default */.Z]
      }
    }], ['row_limit'], [{
      name: 'order_by_entity',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Order by entity id'),
        description: (0,TranslatorSingleton.t)('Important! Select this if the table is not already sorted by entity id, ' + 'else there is no guarantee that all events for each entity are returned.'),
        default: true
      }
    }], [{
      name: 'min_leaf_node_event_count',
      config: {
        type: 'SelectControl',
        freeForm: false,
        label: (0,TranslatorSingleton.t)('Minimum leaf node event count'),
        default: 1,
        choices: (0,selectOptions/* formatSelectOptionsForRange */.B)(1, 10),
        description: (0,TranslatorSingleton.t)('Leaf nodes that represent fewer than this number of events will be initially ' + 'hidden in the visualization')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Additional metadata'),
    controlSetRows: [[{
      name: 'all_columns',
      // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
      config: {
        type: 'SelectControl',
        multi: true,
        label: (0,TranslatorSingleton.t)('Metadata'),
        default: [],
        description: (0,TranslatorSingleton.t)('Select any columns for metadata inspection'),
        optionRenderer: c => (0,emotion_react_browser_esm.jsx)(ColumnOption/* ColumnOption */.E, {
          showType: true,
          column: c
        }),
        valueRenderer: c => (0,emotion_react_browser_esm.jsx)(ColumnOption/* ColumnOption */.E, {
          column: c
        }),
        valueKey: 'column_name',
        allowAll: true,
        mapStateToProps: state => ({
          options: state.datasource ? state.datasource.columns : []
        }),
        commaChoosesOption: false,
        freeForm: true
      }
    }]]
  }],
  controlOverrides: {
    entity: {
      label: (0,TranslatorSingleton.t)('Entity ID'),
      description: (0,TranslatorSingleton.t)('e.g., a "user id" column')
    },
    row_limit: {
      label: (0,TranslatorSingleton.t)('Max Events'),
      description: (0,TranslatorSingleton.t)('The maximum number of events to return, equivalent to the number of rows')
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-event-flow/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Flow'),
  credits: ['https://github.com/williaster/data-ui'],
  description: (0,TranslatorSingleton.t)('Compares the lengths of time different activities take in a shared timeline view.'),
  name: (0,TranslatorSingleton.t)('Event Flow'),
  tags: [(0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Progressive')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class EventFlowChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(9857), __webpack_require__.e(9938)]).then(__webpack_require__.bind(__webpack_require__, 79938)),
      loadTransformProps: () => Promise.all(/* import() */[__webpack_require__.e(9857), __webpack_require__.e(6740)]).then(__webpack_require__.bind(__webpack_require__, 86740)),
      metadata,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 77512:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ HeatmapChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-heatmap/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData
  } = chartProps;
  const {
    bottomMargin,
    canvasImageRendering,
    allColumnsX,
    allColumnsY,
    linearColorScheme,
    leftMargin,
    metric,
    normalized,
    showLegend,
    showPerc,
    showValues,
    sortXAxis,
    sortYAxis,
    xscaleInterval,
    yscaleInterval,
    yAxisBounds,
    yAxisFormat
  } = formData;
  return {
    width,
    height,
    data: queriesData[0].data,
    bottomMargin,
    canvasImageRendering,
    colorScheme: linearColorScheme,
    columnX: allColumnsX,
    columnY: allColumnsY,
    leftMargin,
    metric,
    normalized,
    numberFormat: yAxisFormat,
    showLegend,
    showPercentage: showPerc,
    showValues,
    sortXAxis,
    sortYAxis,
    xScaleInterval: parseInt(xscaleInterval, 10),
    yScaleInterval: parseInt(yscaleInterval, 10),
    yAxisBounds
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-heatmap/esm/images/transportation.jpg
var transportation = __webpack_require__(72968);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-heatmap/esm/images/channels.jpg
var channels = __webpack_require__(98618);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-heatmap/esm/images/employment.jpg
var employment = __webpack_require__(89467);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-heatmap/esm/images/thumbnail.png
var thumbnail = __webpack_require__(10776);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/utils/featureFlags.js
var featureFlags = __webpack_require__(46415);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/columnChoices.js
var columnChoices = __webpack_require__(87581);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/dndControls.js
var dndControls = __webpack_require__(91479);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-heatmap/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const sortAxisChoices = [['alpha_asc', (0,TranslatorSingleton.t)('Axis ascending')], ['alpha_desc', (0,TranslatorSingleton.t)('Axis descending')], ['value_asc', (0,TranslatorSingleton.t)('Metric ascending')], ['value_desc', (0,TranslatorSingleton.t)('Metric descending')]];
const allColumns = {
  type: 'SelectControl',
  default: null,
  description: (0,TranslatorSingleton.t)('Columns to display'),
  mapStateToProps: state => ({
    choices: (0,columnChoices/* default */.Z)(state.datasource)
  }),
  validators: [validateNonEmpty/* default */.Z]
};
const dndAllColumns = { ...dndControls/* dndEntity */.zo,
  description: (0,TranslatorSingleton.t)('Columns to display')
};
const columnsConfig = (0,featureFlags/* isFeatureEnabled */.c)(featureFlags/* FeatureFlag.ENABLE_EXPLORE_DRAG_AND_DROP */.T.ENABLE_EXPLORE_DRAG_AND_DROP) ? dndAllColumns : allColumns;
const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[{
      name: 'all_columns_x',
      config: { ...columnsConfig,
        label: 'X Axis'
      }
    }], [{
      name: 'all_columns_y',
      config: { ...columnsConfig,
        label: 'Y Axis'
      }
    }], ['metric'], ['adhoc_filters'], ['row_limit'], [{
      name: 'sort_by_metric',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort by metric'),
        description: (0,TranslatorSingleton.t)('Whether to sort results by the selected metric in descending order.')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Heatmap Options'),
    expanded: true,
    tabOverride: 'customize',
    controlSetRows: [['linear_color_scheme'], [{
      name: 'xscale_interval',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('XScale Interval'),
        renderTrigger: true,
        choices: (0,selectOptions/* formatSelectOptionsForRange */.B)(1, 50),
        default: '1',
        clearable: false,
        description: (0,TranslatorSingleton.t)('Number of steps to take between ticks when displaying the X scale')
      }
    }], [{
      name: 'yscale_interval',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('YScale Interval'),
        choices: (0,selectOptions/* formatSelectOptionsForRange */.B)(1, 50),
        default: '1',
        clearable: false,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Number of steps to take between ticks when displaying the Y scale')
      }
    }], [{
      name: 'canvas_image_rendering',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Rendering'),
        renderTrigger: true,
        choices: [['pixelated', 'pixelated (Sharp)'], ['auto', 'auto (Smooth)']],
        default: 'pixelated',
        description: (0,TranslatorSingleton.t)('image-rendering CSS attribute of the canvas object that ' + 'defines how the browser scales up the image')
      }
    }], [{
      name: 'normalize_across',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Normalize Across'),
        choices: [['heatmap', 'heatmap'], ['x', 'x'], ['y', 'y']],
        default: 'heatmap',
        description: (0,TranslatorSingleton.t)('Color will be rendered based on a ratio ' + 'of the cell against the sum of across this ' + 'criteria')
      }
    }], [{
      name: 'left_margin',
      config: {
        type: 'SelectControl',
        freeForm: true,
        clearable: false,
        label: (0,TranslatorSingleton.t)('Left Margin'),
        choices: (0,selectOptions/* formatSelectOptions */.m)(['auto', 50, 75, 100, 125, 150, 200]),
        default: 'auto',
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Left margin, in pixels, allowing for more room for axis labels')
      }
    }], [{
      name: 'bottom_margin',
      config: {
        type: 'SelectControl',
        clearable: false,
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Bottom Margin'),
        choices: (0,selectOptions/* formatSelectOptions */.m)(['auto', 50, 75, 100, 125, 150, 200]),
        default: 'auto',
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Bottom margin, in pixels, allowing for more room for axis labels')
      }
    }], [{
      name: 'y_axis_bounds',
      config: {
        type: 'BoundsControl',
        label: (0,TranslatorSingleton.t)('Value bounds'),
        renderTrigger: true,
        default: [null, null],
        description: (0,TranslatorSingleton.t)('Hard value bounds applied for color coding. Is only relevant ' + 'and applied when the normalization is applied against the whole heatmap.')
      }
    }], ['y_axis_format'], [{
      name: 'sort_x_axis',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Sort X Axis'),
        choices: sortAxisChoices,
        clearable: false,
        default: 'alpha_asc'
      }
    }], [{
      name: 'sort_y_axis',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Sort Y Axis'),
        choices: sortAxisChoices,
        clearable: false,
        default: 'alpha_asc'
      }
    }], [{
      name: 'show_legend',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Legend'),
        renderTrigger: true,
        default: false,
        description: (0,TranslatorSingleton.t)('Whether to display the legend (toggles)')
      }
    }], [{
      name: 'show_perc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show percentage'),
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Whether to include the percentage in the tooltip'),
        default: true
      }
    }], [{
      name: 'show_values',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show Values'),
        renderTrigger: true,
        default: false,
        description: (0,TranslatorSingleton.t)('Whether to display the numerical values within the cells')
      }
    }], [{
      name: 'normalized',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Normalized'),
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Whether to apply a normal distribution based on rank on the color scale'),
        default: false
      }
    }]]
  }],
  controlOverrides: {
    y_axis_format: {
      label: (0,TranslatorSingleton.t)('Value Format')
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-heatmap/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */







const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Correlation'),
  credits: ['http://bl.ocks.org/mbostock/3074470'],
  description: (0,TranslatorSingleton.t)('Visualize a related metric across pairs of groups. Heatmaps excel at showcasing the correlation or strength between two groups. Color is used to emphasize the strength of the link between each pair of groups.'),
  exampleGallery: [{
    url: transportation,
    caption: (0,TranslatorSingleton.t)('Sizes of vehicles')
  }, {
    url: channels,
    caption: (0,TranslatorSingleton.t)('Relationships between community channels')
  }, {
    url: employment,
    caption: (0,TranslatorSingleton.t)('Employment and education')
  }],
  name: (0,TranslatorSingleton.t)('Heatmap'),
  tags: [(0,TranslatorSingleton.t)('Business'), (0,TranslatorSingleton.t)('Intensity'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Density'), (0,TranslatorSingleton.t)('Predictive'), (0,TranslatorSingleton.t)('Single Metric')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class HeatmapChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 1066).then(__webpack_require__.bind(__webpack_require__, 81066)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 48143:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ HistogramChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-histogram/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData
  } = chartProps;
  const {
    colorScheme,
    linkLength,
    normalized,
    cumulative,
    globalOpacity,
    xAxisLabel,
    yAxisLabel,
    showLegend
  } = formData;
  return {
    width,
    height,
    data: queriesData[0].data,
    binCount: parseInt(linkLength, 10),
    colorScheme,
    normalized,
    cumulative,
    opacity: globalOpacity,
    xAxisLabel,
    yAxisLabel,
    showLegend
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-histogram/esm/images/example1.jpg
var example1 = __webpack_require__(43240);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-histogram/esm/images/example2.jpg
var example2 = __webpack_require__(83683);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-histogram/esm/images/example3.jpg
var example3 = __webpack_require__(15963);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-histogram/esm/images/thumbnail.png
var thumbnail = __webpack_require__(56201);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/utils/featureFlags.js
var featureFlags = __webpack_require__(46415);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/columnChoices.js
var columnChoices = __webpack_require__(87581);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/dndControls.js
var dndControls = __webpack_require__(91479);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-histogram/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const allColumns = {
  type: 'SelectControl',
  label: (0,TranslatorSingleton.t)('Columns'),
  default: null,
  description: (0,TranslatorSingleton.t)('Select the numeric columns to draw the histogram'),
  mapStateToProps: state => ({
    choices: (0,columnChoices/* default */.Z)(state.datasource)
  }),
  multi: true,
  validators: [validateNonEmpty/* default */.Z]
};
const dndAllColumns = { ...dndControls/* dndColumnsControl */.lC,
  description: (0,TranslatorSingleton.t)('Select the numeric columns to draw the histogram'),
  validators: [validateNonEmpty/* default */.Z]
};
const columnsConfig = (0,featureFlags/* isFeatureEnabled */.c)(featureFlags/* FeatureFlag.ENABLE_EXPLORE_DRAG_AND_DROP */.T.ENABLE_EXPLORE_DRAG_AND_DROP) ? dndAllColumns : allColumns;
const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[{
      name: 'all_columns_x',
      config: columnsConfig
    }], ['adhoc_filters'], ['row_limit'], ['groupby']]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], [{
      name: 'link_length',
      config: {
        type: 'SelectControl',
        renderTrigger: true,
        freeForm: true,
        label: (0,TranslatorSingleton.t)('No of Bins'),
        default: 5,
        choices: (0,selectOptions/* formatSelectOptions */.m)(['10', '25', '50', '75', '100', '150', '200', '250']),
        description: (0,TranslatorSingleton.t)('Select the number of bins for the histogram')
      }
    }], [{
      name: 'x_axis_label',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('X Axis Label'),
        renderTrigger: true,
        default: ''
      }
    }], [{
      name: 'y_axis_label',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Y Axis Label'),
        renderTrigger: true,
        default: ''
      }
    }], [{
      name: 'show_legend',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Legend'),
        renderTrigger: true,
        default: false,
        description: (0,TranslatorSingleton.t)('Whether to display the legend (toggles)')
      }
    }], [{
      name: 'normalized',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Normalized'),
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Whether to normalize the histogram'),
        default: false
      }
    }], [{
      name: 'cumulative',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Cumulative'),
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Whether to make the histogram cumulative'),
        default: false
      }
    }]]
  }]
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-histogram/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */







const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Distribution'),
  description: (0,TranslatorSingleton.t)('Take your data points, and group them into "bins" to see where the densest areas of information lie'),
  exampleGallery: [{
    url: example1,
    caption: (0,TranslatorSingleton.t)('Population age data')
  }, {
    url: example2
  }, {
    url: example3
  }],
  name: (0,TranslatorSingleton.t)('Histogram'),
  tags: [(0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Pattern'), (0,TranslatorSingleton.t)('Range')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class HistogramChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(1095), __webpack_require__.e(3118)]).then(__webpack_require__.bind(__webpack_require__, 33118)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 28801:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ HorizonChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-horizon/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function transformProps(chartProps) {
  const {
    height,
    width,
    formData,
    queriesData
  } = chartProps;
  const {
    horizonColorScale,
    seriesHeight
  } = formData;
  return {
    colorScale: horizonColorScale,
    data: queriesData[0].data,
    height,
    seriesHeight: parseInt(seriesHeight, 10),
    width
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-horizon/esm/images/Horizon_Chart.jpg
var Horizon_Chart = __webpack_require__(94246);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-horizon/esm/images/thumbnail.png
var thumbnail = __webpack_require__(12546);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-horizon/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['adhoc_filters'], ['groupby'], ['limit', 'timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }, {
      name: 'contribution',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Contribution'),
        default: false,
        description: (0,TranslatorSingleton.t)('Compute the contribution to the total')
      }
    }], ['row_limit', null]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [[{
      name: 'series_height',
      config: {
        type: 'SelectControl',
        renderTrigger: true,
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Series Height'),
        default: '25',
        choices: (0,selectOptions/* formatSelectOptions */.m)(['10', '25', '40', '50', '75', '100', '150', '200']),
        description: (0,TranslatorSingleton.t)('Pixel height of each series')
      }
    }, {
      name: 'horizon_color_scale',
      config: {
        type: 'SelectControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Value Domain'),
        choices: [['series', 'series'], ['overall', 'overall'], ['change', 'change']],
        default: 'series',
        description: (0,TranslatorSingleton.t)('series: Treat each series independently; overall: All series use the same scale; change: Show changes compared to the first data point in each series')
      }
    }]]
  }]
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-horizon/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Distribution'),
  credits: ['http://kmandov.github.io/d3-horizon-chart/'],
  description: (0,TranslatorSingleton.t)('Compares how a metric changes over time between different groups. Each group is mapped to a row and change over time is visualized bar lengths and color.'),
  exampleGallery: [{
    url: Horizon_Chart
  }],
  name: (0,TranslatorSingleton.t)('Horizon Chart'),
  tags: [(0,TranslatorSingleton.t)('Legacy')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class HorizonChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 8903).then(__webpack_require__.bind(__webpack_require__, 48903)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 93775:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ MapBoxChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-map-box/esm/images/thumbnail.png
var thumbnail = __webpack_require__(88824);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-map-box/esm/images/MapBox.jpg
var MapBox = __webpack_require__(648);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-map-box/esm/images/MapBox2.jpg
var MapBox2 = __webpack_require__(13854);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/utils/featureFlags.js
var featureFlags = __webpack_require__(46415);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/columnChoices.js
var columnChoices = __webpack_require__(87581);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/dndControls.js
var dndControls = __webpack_require__(91479);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-map-box/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const allColumns = {
  type: 'SelectControl',
  default: null,
  mapStateToProps: state => ({
    choices: (0,columnChoices/* default */.Z)(state.datasource)
  })
};
const columnsConfig = (0,featureFlags/* isFeatureEnabled */.c)(featureFlags/* FeatureFlag.ENABLE_EXPLORE_DRAG_AND_DROP */.T.ENABLE_EXPLORE_DRAG_AND_DROP) ? dndControls/* dndEntity */.zo : allColumns;
const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[{
      name: 'all_columns_x',
      config: { ...columnsConfig,
        label: (0,TranslatorSingleton.t)('Longitude'),
        description: (0,TranslatorSingleton.t)('Column containing longitude data')
      }
    }], [{
      name: 'all_columns_y',
      config: { ...columnsConfig,
        label: (0,TranslatorSingleton.t)('Latitude'),
        description: (0,TranslatorSingleton.t)('Column containing latitude data')
      }
    }], [{
      name: 'clustering_radius',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Clustering Radius'),
        default: '60',
        choices: (0,selectOptions/* formatSelectOptions */.m)(['0', '20', '40', '60', '80', '100', '200', '500', '1000']),
        description: (0,TranslatorSingleton.t)('The radius (in pixels) the algorithm uses to define a cluster. ' + 'Choose 0 to turn off clustering, but beware that a large ' + 'number of points (>1000) will cause lag.')
      }
    }], ['row_limit'], ['adhoc_filters'], ['groupby']]
  }, {
    label: (0,TranslatorSingleton.t)('Points'),
    controlSetRows: [[{
      name: 'point_radius',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Point Radius'),
        default: 'Auto',
        description: (0,TranslatorSingleton.t)('The radius of individual points (ones that are not in a cluster). ' + 'Either a numerical column or `Auto`, which scales the point based ' + 'on the largest cluster'),
        mapStateToProps: state => {
          const datasourceChoices = (0,columnChoices/* default */.Z)(state.datasource);
          const choices = (0,selectOptions/* formatSelectOptions */.m)(['Auto']);
          return {
            choices: choices.concat(datasourceChoices)
          };
        }
      }
    }], [{
      name: 'point_radius_unit',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Point Radius Unit'),
        default: 'Pixels',
        choices: (0,selectOptions/* formatSelectOptions */.m)(['Pixels', 'Miles', 'Kilometers']),
        description: (0,TranslatorSingleton.t)('The unit of measure for the specified point radius')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Labelling'),
    controlSetRows: [[{
      name: 'mapbox_label',
      config: {
        type: 'SelectControl',
        multi: true,
        label: (0,TranslatorSingleton.t)('label'),
        default: [],
        description: (0,TranslatorSingleton.t)('`count` is COUNT(*) if a group by is used. ' + 'Numerical columns will be aggregated with the aggregator. ' + 'Non-numerical columns will be used to label points. ' + 'Leave empty to get a count of points in each cluster.'),
        mapStateToProps: state => ({
          choices: (0,columnChoices/* default */.Z)(state.datasource)
        })
      }
    }], [{
      name: 'pandas_aggfunc',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Cluster label aggregator'),
        clearable: false,
        choices: (0,selectOptions/* formatSelectOptions */.m)(['sum', 'mean', 'min', 'max', 'std', 'var']),
        default: 'sum',
        description: (0,TranslatorSingleton.t)('Aggregate function applied to the list of points ' + 'in each cluster to produce the cluster label.')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Visual Tweaks'),
    controlSetRows: [[{
      name: 'render_while_dragging',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Live render'),
        default: true,
        description: (0,TranslatorSingleton.t)('Points and clusters will update as the viewport is being changed')
      }
    }], [{
      name: 'mapbox_style',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Map Style'),
        clearable: false,
        renderTrigger: true,
        choices: [['mapbox://styles/mapbox/streets-v9', 'Streets'], ['mapbox://styles/mapbox/dark-v9', 'Dark'], ['mapbox://styles/mapbox/light-v9', 'Light'], ['mapbox://styles/mapbox/satellite-streets-v9', 'Satellite Streets'], ['mapbox://styles/mapbox/satellite-v9', 'Satellite'], ['mapbox://styles/mapbox/outdoors-v9', 'Outdoors']],
        default: 'mapbox://styles/mapbox/light-v9',
        description: (0,TranslatorSingleton.t)('Base layer map style')
      }
    }], [{
      name: 'global_opacity',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Opacity'),
        default: 1,
        isFloat: true,
        description: (0,TranslatorSingleton.t)('Opacity of all clusters, points, and labels. Between 0 and 1.')
      }
    }], [{
      name: 'mapbox_color',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('RGB Color'),
        default: 'rgb(0, 122, 135)',
        choices: [['rgb(0, 139, 139)', 'Dark Cyan'], ['rgb(128, 0, 128)', 'Purple'], ['rgb(255, 215, 0)', 'Gold'], ['rgb(69, 69, 69)', 'Dim Gray'], ['rgb(220, 20, 60)', 'Crimson'], ['rgb(34, 139, 34)', 'Forest Green']],
        description: (0,TranslatorSingleton.t)('The color for points and clusters in RGB')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Viewport'),
    expanded: true,
    controlSetRows: [[{
      name: 'viewport_longitude',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Default longitude'),
        renderTrigger: true,
        default: -122.405293,
        isFloat: true,
        description: (0,TranslatorSingleton.t)('Longitude of default viewport'),
        places: 8,
        // Viewport longitude changes shouldn't prompt user to re-run query
        dontRefreshOnChange: true
      }
    }, {
      name: 'viewport_latitude',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Default latitude'),
        renderTrigger: true,
        default: 37.772123,
        isFloat: true,
        description: (0,TranslatorSingleton.t)('Latitude of default viewport'),
        places: 8,
        // Viewport latitude changes shouldn't prompt user to re-run query
        dontRefreshOnChange: true
      }
    }], [{
      name: 'viewport_zoom',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Zoom'),
        renderTrigger: true,
        isFloat: true,
        default: 11,
        description: (0,TranslatorSingleton.t)('Zoom level of the map'),
        places: 8,
        // Viewport zoom shouldn't prompt user to re-run query
        dontRefreshOnChange: true
      }
    }, null]]
  }],
  controlOverrides: {
    groupby: {
      description: (0,TranslatorSingleton.t)('One or many controls to group by. If grouping, latitude ' + 'and longitude columns must be present.')
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-map-box/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Map'),
  credits: ['https://www.mapbox.com/mapbox-gl-js/api/'],
  description: '',
  exampleGallery: [{
    url: MapBox,
    description: (0,TranslatorSingleton.t)('Light mode')
  }, {
    url: MapBox2,
    description: (0,TranslatorSingleton.t)('Dark mode')
  }],
  name: (0,TranslatorSingleton.t)('MapBox'),
  tags: [(0,TranslatorSingleton.t)('Business'), (0,TranslatorSingleton.t)('Intensity'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Density'), (0,TranslatorSingleton.t)('Scatter'), (0,TranslatorSingleton.t)('Transformable')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class MapBoxChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(9131), __webpack_require__.e(7219)]).then(__webpack_require__.bind(__webpack_require__, 97219)),
      loadTransformProps: () => Promise.all(/* import() */[__webpack_require__.e(9131), __webpack_require__.e(7219), __webpack_require__.e(547)]).then(__webpack_require__.bind(__webpack_require__, 70547)),
      metadata,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 92565:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ PairedTTestChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-paired-t-test/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function transformProps(chartProps) {
  const {
    formData,
    queriesData
  } = chartProps;
  const {
    groupby,
    liftvaluePrecision,
    metrics,
    pvaluePrecision,
    significanceLevel
  } = formData;
  return {
    alpha: significanceLevel,
    data: queriesData[0].data,
    groups: groupby,
    liftValPrec: parseInt(liftvaluePrecision, 10),
    metrics: metrics.map(metric => typeof metric === 'string' ? metric : metric.label),
    pValPrec: parseInt(pvaluePrecision, 10)
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-paired-t-test/esm/images/thumbnail.png
var thumbnail = __webpack_require__(76376);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-paired-t-test/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['adhoc_filters'], [{
      name: 'groupby',
      override: {
        validators: [validateNonEmpty/* default */.Z]
      }
    }], ['limit', 'timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }, {
      name: 'contribution',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Contribution'),
        default: false,
        description: (0,TranslatorSingleton.t)('Compute the contribution to the total')
      }
    }], ['row_limit', null]]
  }, {
    label: (0,TranslatorSingleton.t)('Parameters'),
    expanded: false,
    controlSetRows: [[{
      name: 'significance_level',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Significance Level'),
        default: 0.05,
        description: (0,TranslatorSingleton.t)('Threshold alpha level for determining significance')
      }
    }], [{
      name: 'pvalue_precision',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('p-value precision'),
        default: 6,
        description: (0,TranslatorSingleton.t)('Number of decimal places with which to display p-values')
      }
    }], [{
      name: 'liftvalue_precision',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Lift percent precision'),
        default: 4,
        description: (0,TranslatorSingleton.t)('Number of decimal places with which to display lift values')
      }
    }]]
  }]
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-paired-t-test/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Correlation'),
  description: (0,TranslatorSingleton.t)('Table that visualizes paired t-tests, which are used to understand statistical differences between groups.'),
  name: (0,TranslatorSingleton.t)('Paired t-test Table'),
  tags: [(0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Statistical'), (0,TranslatorSingleton.t)('Tabular')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class PairedTTestChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 1193).then(__webpack_require__.bind(__webpack_require__, 63048)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 8795:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ ParallelCoordinatesChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-parallel-coordinates/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData
  } = chartProps;
  const {
    includeSeries,
    linearColorScheme,
    metrics,
    secondaryMetric,
    series,
    showDatatable
  } = formData;
  return {
    width,
    height,
    data: queriesData[0].data,
    includeSeries,
    linearColorScheme,
    metrics: metrics.map(m => m.label || m),
    colorMetric: secondaryMetric && secondaryMetric.label ? secondaryMetric.label : secondaryMetric,
    series,
    showDatatable
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-parallel-coordinates/esm/images/thumbnail.png
var thumbnail = __webpack_require__(25505);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-parallel-coordinates/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['series'], ['metrics'], ['secondary_metric'], ['adhoc_filters'], ['limit', 'row_limit'], ['timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Options'),
    expanded: true,
    controlSetRows: [[{
      name: 'show_datatable',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Data Table'),
        default: false,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Whether to display the interactive data table')
      }
    }, {
      name: 'include_series',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Include Series'),
        renderTrigger: true,
        default: false,
        description: (0,TranslatorSingleton.t)('Include series name as an axis')
      }
    }], ['linear_color_scheme']]
  }]
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-parallel-coordinates/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Ranking'),
  credits: ['https://syntagmatic.github.io/parallel-coordinates'],
  description: (0,TranslatorSingleton.t)('Plots the individual metrics for each row in the data vertically and links them together as a line. This chart is useful for comparing multiple metrics across all of the samples or rows in the data.'),
  name: (0,TranslatorSingleton.t)('Parallel Coordinates'),
  tags: [(0,TranslatorSingleton.t)('Coordinates'), (0,TranslatorSingleton.t)('Directional'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Relational')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class ParallelCoordinatesChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 1243).then(__webpack_require__.bind(__webpack_require__, 31243)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 79909:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ PartitionChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-partition/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function transformProps(chartProps) {
  const {
    width,
    height,
    datasource,
    formData,
    queriesData
  } = chartProps;
  const {
    colorScheme,
    dateTimeFormat,
    equalDateSize,
    groupby,
    logScale,
    metrics,
    numberFormat,
    partitionLimit,
    partitionThreshold,
    richTooltip,
    timeSeriesOption
  } = formData;
  const {
    verboseMap
  } = datasource;
  return {
    width,
    height,
    data: queriesData[0].data,
    colorScheme,
    dateTimeFormat,
    equalDateSize,
    levels: groupby.map(g => verboseMap[g] || g),
    metrics,
    numberFormat,
    partitionLimit: partitionLimit && parseInt(partitionLimit, 10),
    partitionThreshold: partitionThreshold && parseInt(partitionThreshold, 10),
    timeSeriesOption,
    useLogScale: logScale,
    useRichTooltip: richTooltip
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-partition/esm/images/thumbnail.png
var thumbnail = __webpack_require__(60915);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(45697);
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/components/InfoTooltipWithTrigger.js
var InfoTooltipWithTrigger = __webpack_require__(88186);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-partition/esm/OptionDescription.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const propTypes = {
  option: (prop_types_default()).object.isRequired
}; // This component provides a general tooltip for options
// in a SelectControl

function OptionDescription({
  option
}) {
  return (0,emotion_react_browser_esm.jsx)("span", null, (0,emotion_react_browser_esm.jsx)("span", {
    className: "m-r-5 option-label"
  }, option.label), option.description && (0,emotion_react_browser_esm.jsx)(InfoTooltipWithTrigger/* InfoTooltipWithTrigger */.V, {
    className: "m-r-5 text-muted",
    icon: "question-circle-o",
    tooltip: option.description,
    label: `descr-${option.label}`
  }));
}
OptionDescription.propTypes = propTypes;
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-partition/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['adhoc_filters'], ['groupby'], ['limit', 'timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }, {
      name: 'contribution',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Contribution'),
        default: false,
        description: (0,TranslatorSingleton.t)('Compute the contribution to the total')
      }
    }], ['row_limit', null]]
  }, {
    label: (0,TranslatorSingleton.t)('Time Series Options'),
    expanded: true,
    controlSetRows: [[{
      name: 'time_series_option',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Options'),
        validators: [validateNonEmpty/* default */.Z],
        default: 'not_time',
        valueKey: 'value',
        options: [{
          label: (0,TranslatorSingleton.t)('Not Time Series'),
          value: 'not_time',
          description: (0,TranslatorSingleton.t)('Ignore time')
        }, {
          label: (0,TranslatorSingleton.t)('Time Series'),
          value: 'time_series',
          description: (0,TranslatorSingleton.t)('Standard time series')
        }, {
          label: (0,TranslatorSingleton.t)('Aggregate Mean'),
          value: 'agg_mean',
          description: (0,TranslatorSingleton.t)('Mean of values over specified period')
        }, {
          label: (0,TranslatorSingleton.t)('Aggregate Sum'),
          value: 'agg_sum',
          description: (0,TranslatorSingleton.t)('Sum of values over specified period')
        }, {
          label: (0,TranslatorSingleton.t)('Difference'),
          value: 'point_diff',
          description: (0,TranslatorSingleton.t)('Metric change in value from `since` to `until`')
        }, {
          label: (0,TranslatorSingleton.t)('Percent Change'),
          value: 'point_percent',
          description: (0,TranslatorSingleton.t)('Metric percent change in value from `since` to `until`')
        }, {
          label: (0,TranslatorSingleton.t)('Factor'),
          value: 'point_factor',
          description: (0,TranslatorSingleton.t)('Metric factor change from `since` to `until`')
        }, {
          label: (0,TranslatorSingleton.t)('Advanced Analytics'),
          value: 'adv_anal',
          description: (0,TranslatorSingleton.t)('Use the Advanced Analytics options below')
        }],
        optionRenderer: op => (0,emotion_react_browser_esm.jsx)(OptionDescription, {
          option: op
        }),
        valueRenderer: op => (0,emotion_react_browser_esm.jsx)(OptionDescription, {
          option: op
        }),
        description: (0,TranslatorSingleton.t)('Settings for time series')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    tabOverride: 'customize',
    controlSetRows: [['color_scheme'], [{
      name: 'number_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Number format'),
        renderTrigger: true,
        default: 'SMART_NUMBER',
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6,
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }, {
      name: 'date_time_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Date Time Format'),
        renderTrigger: true,
        default: 'smart_date',
        choices: D3Formatting/* D3_TIME_FORMAT_OPTIONS */.HC,
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }], [{
      name: 'partition_limit',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Partition Limit'),
        isInt: true,
        default: '5',
        description: (0,TranslatorSingleton.t)('The maximum number of subdivisions of each group; ' + 'lower values are pruned first')
      }
    }, {
      name: 'partition_threshold',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Partition Threshold'),
        isFloat: true,
        default: '0.05',
        description: (0,TranslatorSingleton.t)('Partitions whose height to parent height proportions are ' + 'below this value are pruned')
      }
    }], [{
      name: 'log_scale',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Log Scale'),
        default: false,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Use a log scale')
      }
    }], [{
      name: 'equal_date_size',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Equal Date Sizes'),
        default: true,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Check to force date partitions to have the same height')
      }
    }], [{
      name: 'rich_tooltip',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Rich Tooltip'),
        renderTrigger: true,
        default: true,
        description: (0,TranslatorSingleton.t)('The rich tooltip shows a list of all series for that point in time')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Advanced Analytics'),
    tabOverride: 'data',
    description: (0,TranslatorSingleton.t)('This section contains options ' + 'that allow for advanced analytical post processing ' + 'of query results'),
    controlSetRows: [// eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Rolling Window'))], [{
      name: 'rolling_type',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Rolling Function'),
        default: 'None',
        choices: (0,selectOptions/* formatSelectOptions */.m)(['None', 'mean', 'sum', 'std', 'cumsum']),
        description: (0,TranslatorSingleton.t)('Defines a rolling window function to apply, works along ' + 'with the [Periods] text box')
      }
    }], [{
      name: 'rolling_periods',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Periods'),
        isInt: true,
        description: (0,TranslatorSingleton.t)('Defines the size of the rolling window function, ' + 'relative to the time granularity selected')
      }
    }, {
      name: 'min_periods',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Min Periods'),
        isInt: true,
        description: (0,TranslatorSingleton.t)('The minimum number of rolling periods required to show ' + 'a value. For instance if you do a cumulative sum on 7 days ' + 'you may want your "Min Period" to be 7, so that all data points ' + 'shown are the total of 7 periods. This will hide the "ramp up" ' + 'taking place over the first 7 periods')
      }
    }], // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Time Comparison'))], [{
      name: 'time_compare',
      config: {
        type: 'SelectControl',
        multi: true,
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Time Shift'),
        choices: (0,selectOptions/* formatSelectOptions */.m)(['1 day', '1 week', '28 days', '30 days', '52 weeks', '1 year', '104 weeks', '2 years']),
        description: (0,TranslatorSingleton.t)('Overlay one or more timeseries from a ' + 'relative time period. Expects relative time deltas ' + 'in natural language (example:  24 hours, 7 days, ' + '52 weeks, 365 days). Free text is supported.')
      }
    }, {
      name: 'comparison_type',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Calculation type'),
        default: 'values',
        choices: [['values', 'Actual Values'], ['absolute', 'Difference'], ['percentage', 'Percentage change'], ['ratio', 'Ratio']],
        description: (0,TranslatorSingleton.t)('How to display time shifts: as individual lines; as the ' + 'difference between the main time series and each time shift; ' + 'as the percentage change; or as the ratio between series and time shifts.')
      }
    }], // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Python Functions'))], // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h2", {
      className: "section-header"
    }, "pandas.resample")], [{
      name: 'resample_rule',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Rule'),
        default: null,
        choices: (0,selectOptions/* formatSelectOptions */.m)(['1T', '1H', '1D', '7D', '1M', '1AS']),
        description: (0,TranslatorSingleton.t)('Pandas resample rule')
      }
    }, {
      name: 'resample_method',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Method'),
        default: null,
        choices: (0,selectOptions/* formatSelectOptions */.m)(['asfreq', 'bfill', 'ffill', 'median', 'mean', 'sum']),
        description: (0,TranslatorSingleton.t)('Pandas resample method')
      }
    }]]
  }]
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-partition/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Part of a Whole'),
  description: (0,TranslatorSingleton.t)('Compare the same summarized metric across multiple groups.'),
  name: (0,TranslatorSingleton.t)('Partition Chart'),
  tags: [(0,TranslatorSingleton.t)('Categorical'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Proportional')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class PartitionChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 4473).then(__webpack_require__.bind(__webpack_require__, 4473)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 93273:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ PivotTableChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/extractTimegrain.js
var extractTimegrain = __webpack_require__(54441);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-pivot-table/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function transformProps(chartProps) {
  const {
    height,
    datasource,
    formData,
    queriesData,
    rawFormData
  } = chartProps;
  const {
    groupby,
    numberFormat,
    dateFormat
  } = formData;
  const {
    columnFormats,
    verboseMap
  } = datasource;
  const granularity = (0,extractTimegrain/* default */.Z)(rawFormData);
  return {
    columnFormats,
    data: queriesData[0].data,
    dateFormat,
    granularity,
    height,
    numberFormat,
    numGroups: groupby.length,
    verboseMap
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-pivot-table/esm/images/thumbnail.png
var thumbnail = __webpack_require__(22671);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-pivot-table/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['adhoc_filters'], ['groupby'], ['columns'], ['row_limit', null], ['timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Pivot Options'),
    controlSetRows: [[{
      name: 'pandas_aggfunc',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Aggregation function'),
        clearable: false,
        choices: (0,selectOptions/* formatSelectOptions */.m)(['sum', 'mean', 'min', 'max', 'std', 'var']),
        default: 'sum',
        description: (0,TranslatorSingleton.t)('Aggregate function to apply when pivoting and ' + 'computing the total rows and columns')
      }
    }, null], [{
      name: 'pivot_margins',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show totals'),
        default: true,
        description: (0,TranslatorSingleton.t)('Display total row/column')
      }
    }, {
      name: 'combine_metric',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Combine Metrics'),
        default: false,
        description: (0,TranslatorSingleton.t)('Display metrics side by side within each column, as ' + 'opposed to each column being displayed side by side for each metric.')
      }
    }], [{
      name: 'transpose_pivot',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Transpose Pivot'),
        default: false,
        description: (0,TranslatorSingleton.t)('Swap Groups and Columns')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Options'),
    expanded: true,
    controlSetRows: [[{
      name: 'number_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Number format'),
        renderTrigger: true,
        default: 'SMART_NUMBER',
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6,
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }], [{
      name: 'date_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Date format'),
        renderTrigger: true,
        choices: D3Formatting/* D3_TIME_FORMAT_OPTIONS */.HC,
        default: 'smart_date',
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }]]
  }],
  controlOverrides: {
    groupby: {
      includeTime: true
    },
    columns: {
      includeTime: true
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-pivot-table/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Table'),
  description: (0,TranslatorSingleton.t)(`Used to summarize a set of data by grouping together multiple statistics along two axes. Examples: Sales numbers by region and month, tasks by status and assignee, active users by age and location.

  This chart is being deprecated and we recommend checking out Pivot Table V2 instead!`),
  name: (0,TranslatorSingleton.t)('Pivot Table'),
  tags: [(0,TranslatorSingleton.t)('Legacy')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class PivotTableChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 7828).then(__webpack_require__.bind(__webpack_require__, 27828)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 79954:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ RoseChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-rose/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData
  } = chartProps;
  const {
    colorScheme,
    dateTimeFormat,
    numberFormat,
    richTooltip,
    roseAreaProportion
  } = formData;
  return {
    width,
    height,
    data: queriesData[0].data,
    colorScheme,
    dateTimeFormat,
    numberFormat,
    useAreaProportions: roseAreaProportion,
    useRichTooltip: richTooltip
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-rose/esm/images/thumbnail.png
var thumbnail = __webpack_require__(10069);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-rose/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['adhoc_filters'], ['groupby'], ['limit', 'timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }, {
      name: 'contribution',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Contribution'),
        default: false,
        description: (0,TranslatorSingleton.t)('Compute the contribution to the total')
      }
    }], ['row_limit', null]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], [{
      name: 'number_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Number format'),
        renderTrigger: true,
        default: 'SMART_NUMBER',
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6,
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }, {
      name: 'date_time_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Date Time Format'),
        renderTrigger: true,
        default: 'smart_date',
        choices: D3Formatting/* D3_TIME_FORMAT_OPTIONS */.HC,
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }], [{
      name: 'rich_tooltip',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Rich Tooltip'),
        renderTrigger: true,
        default: true,
        description: (0,TranslatorSingleton.t)('The rich tooltip shows a list of all series for that point in time')
      }
    }, {
      name: 'rose_area_proportion',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Use Area Proportions'),
        description: (0,TranslatorSingleton.t)('Check if the Rose Chart should use segment area instead of ' + 'segment radius for proportioning'),
        default: false,
        renderTrigger: true
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Advanced Analytics'),
    tabOverride: 'data',
    description: (0,TranslatorSingleton.t)('This section contains options ' + 'that allow for advanced analytical post processing ' + 'of query results'),
    controlSetRows: [// eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Rolling Window'))], [{
      name: 'rolling_type',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Rolling Function'),
        default: 'None',
        choices: (0,selectOptions/* formatSelectOptions */.m)(['None', 'mean', 'sum', 'std', 'cumsum']),
        description: (0,TranslatorSingleton.t)('Defines a rolling window function to apply, works along ' + 'with the [Periods] text box')
      }
    }], [{
      name: 'rolling_periods',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Periods'),
        isInt: true,
        description: (0,TranslatorSingleton.t)('Defines the size of the rolling window function, ' + 'relative to the time granularity selected')
      }
    }, {
      name: 'min_periods',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Min Periods'),
        isInt: true,
        description: (0,TranslatorSingleton.t)('The minimum number of rolling periods required to show ' + 'a value. For instance if you do a cumulative sum on 7 days ' + 'you may want your "Min Period" to be 7, so that all data points ' + 'shown are the total of 7 periods. This will hide the "ramp up" ' + 'taking place over the first 7 periods')
      }
    }], // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Time Comparison'))], [{
      name: 'time_compare',
      config: {
        type: 'SelectControl',
        multi: true,
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Time Shift'),
        choices: (0,selectOptions/* formatSelectOptions */.m)(['1 day', '1 week', '28 days', '30 days', '52 weeks', '1 year', '104 weeks', '2 years']),
        description: (0,TranslatorSingleton.t)('Overlay one or more timeseries from a ' + 'relative time period. Expects relative time deltas ' + 'in natural language (example:  24 hours, 7 days, ' + '52 weeks, 365 days). Free text is supported.')
      }
    }, {
      name: 'comparison_type',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Calculation type'),
        default: 'values',
        choices: [['values', 'Actual Values'], ['absolute', 'Difference'], ['percentage', 'Percentage change'], ['ratio', 'Ratio']],
        description: (0,TranslatorSingleton.t)('How to display time shifts: as individual lines; as the ' + 'difference between the main time series and each time shift; ' + 'as the percentage change; or as the ratio between series and time shifts.')
      }
    }], // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Python Functions'))], // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h2", {
      className: "section-header"
    }, "pandas.resample")], [{
      name: 'resample_rule',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Rule'),
        default: null,
        choices: (0,selectOptions/* formatSelectOptions */.m)(['1T', '1H', '1D', '7D', '1M', '1AS']),
        description: (0,TranslatorSingleton.t)('Pandas resample rule')
      }
    }, {
      name: 'resample_method',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Method'),
        default: null,
        choices: (0,selectOptions/* formatSelectOptions */.m)(['asfreq', 'bfill', 'ffill', 'median', 'mean', 'sum']),
        description: (0,TranslatorSingleton.t)('Pandas resample method')
      }
    }]]
  }]
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-rose/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Ranking'),
  description: (0,TranslatorSingleton.t)('A polar coordinate chart where the circle is broken into wedges of equal angle, and the value represented by any wedge is illustrated by its area, rather than its radius or sweep angle.'),
  name: (0,TranslatorSingleton.t)('Nightingale Rose Chart'),
  tags: [(0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Advanced-Analytics'), (0,TranslatorSingleton.t)('Circular'), (0,TranslatorSingleton.t)('Multi-Layers'), (0,TranslatorSingleton.t)('Pattern'), (0,TranslatorSingleton.t)('Time'), (0,TranslatorSingleton.t)('Trend')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class RoseChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 823).then(__webpack_require__.bind(__webpack_require__, 30823)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 16915:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ SankeyChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-sankey/esm/utils.js
var utils = __webpack_require__(84874);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-sankey/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData
  } = chartProps;
  const {
    colorScheme
  } = formData;
  return {
    width,
    height,
    data: queriesData[0].data,
    colorScheme,
    fontSize: (0,utils/* getLabelFontSize */.Py)(width)
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-sankey/esm/images/thumbnail.png
var thumbnail = __webpack_require__(66362);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-sankey/esm/images/Sankey.jpg
var Sankey = __webpack_require__(64481);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-sankey/esm/images/Sankey2.jpg
var Sankey2 = __webpack_require__(15347);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-sankey/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[{
      name: 'groupby',
      override: {
        label: (0,TranslatorSingleton.t)('Source / Target'),
        description: (0,TranslatorSingleton.t)('Choose a source and a target')
      }
    }], ['metric'], ['adhoc_filters'], [{
      name: 'row_limit',
      override: {
        description: (0,TranslatorSingleton.t)('Limiting rows may result in incomplete data and misleading charts. Consider filtering or grouping source/target names instead.')
      }
    }], [{
      name: 'sort_by_metric',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort by metric'),
        description: (0,TranslatorSingleton.t)('Whether to sort results by the selected metric in descending order.')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme']]
  }]
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-sankey/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Flow'),
  credits: ['https://github.com/d3/d3-sankey'],
  description: (0,TranslatorSingleton.t)("Visualizes the flow of different group's values through different stages of a system. New stages in the pipeline are visualized as nodes or layers. The thickness of the bars or edges represent the metric being visualized."),
  exampleGallery: [{
    url: Sankey,
    description: (0,TranslatorSingleton.t)('Demographics')
  }, {
    url: Sankey2,
    description: (0,TranslatorSingleton.t)('Survey Responses')
  }],
  name: (0,TranslatorSingleton.t)('Sankey Diagram'),
  tags: [(0,TranslatorSingleton.t)('Categorical'), (0,TranslatorSingleton.t)('Directional'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Percentages'), (0,TranslatorSingleton.t)('Proportional'), (0,TranslatorSingleton.t)('Relational')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class SankeyChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 5859).then(__webpack_require__.bind(__webpack_require__, 65859)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 84874:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Py": () => (/* binding */ getLabelFontSize),
/* harmony export */   "Ce": () => (/* binding */ getOverlappingElements)
/* harmony export */ });
/* unused harmony exports isOverlapping, getRectangle */
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function getLabelFontSize(width) {
  if (width > 550) {
    return 0.8;
  }

  if (width > 400 && width <= 550) {
    return 0.55;
  }

  return 0.45;
}
const isOverlapping = (rect1, rect2) => {
  const {
    x: x1,
    y: y1,
    width: width1,
    height: height1
  } = rect1;
  const {
    x: x2,
    y: y2,
    width: width2,
    height: height2
  } = rect2;
  return !(x1 > x2 + width2 || x1 + width1 < x2 || y1 > y2 + height2 || y1 + height1 < y2);
};
const getRectangle = (element, offset = 0) => {
  const {
    x,
    y,
    width,
    height
  } = element.getBoundingClientRect();
  return {
    x,
    y: y + offset,
    width,
    height: height - offset * 2
  };
};
const getOverlappingElements = elements => {
  const overlappingElements = [];
  elements.forEach((e1, index1) => {
    const rect1 = getRectangle(e1, 1);
    elements.forEach((e2, index2) => {
      if (index2 <= index1) return;
      const rect2 = getRectangle(e2, 1);

      if (isOverlapping(rect1, rect2)) {
        overlappingElements.push(elements[index2]);
        overlappingElements.push(elements[index1]);
      }
    });
  });
  return overlappingElements;
};

/***/ }),

/***/ 65314:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ SunburstChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-sunburst/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData,
    datasource
  } = chartProps;
  const {
    colorScheme,
    linearColorScheme,
    metric,
    secondaryMetric
  } = formData;
  const returnProps = {
    width,
    height,
    data: queriesData[0].data,
    colorScheme,
    linearColorScheme,
    metrics: [metric, secondaryMetric]
  };

  if (datasource && datasource.metrics) {
    const metricWithFormat = datasource.metrics.find(({
      metric_name: metricName,
      d3format
    }) => metricName === formData.metric && d3format);

    if (metricWithFormat) {
      Object.assign(returnProps, {
        numberFormat: metricWithFormat.d3format
      });
    }
  }

  return returnProps;
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-sunburst/esm/images/thumbnail.png
var thumbnail = __webpack_require__(56538);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-sunburst/esm/images/example.png
var example = __webpack_require__(98972);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-sunburst/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['groupby'], ['metric'], ['secondary_metric'], ['adhoc_filters'], ['row_limit'], [{
      name: 'sort_by_metric',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort by metric'),
        description: (0,TranslatorSingleton.t)('Whether to sort results by the selected metric in descending order.')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], ['linear_color_scheme']]
  }],
  controlOverrides: {
    metric: {
      label: (0,TranslatorSingleton.t)('Primary Metric'),
      description: (0,TranslatorSingleton.t)('The primary metric is used to define the arc segment sizes')
    },
    secondary_metric: {
      label: (0,TranslatorSingleton.t)('Secondary Metric'),
      default: null,
      description: (0,TranslatorSingleton.t)('[optional] this secondary metric is used to ' + 'define the color as a ratio against the primary metric. ' + 'When omitted, the color is categorical and based on labels')
    },
    color_scheme: {
      description: (0,TranslatorSingleton.t)('When only a primary metric is provided, a categorical color scale is used.')
    },
    linear_color_scheme: {
      description: (0,TranslatorSingleton.t)('When a secondary metric is provided, a linear color scale is used.')
    },
    groupby: {
      label: (0,TranslatorSingleton.t)('Hierarchy'),
      description: (0,TranslatorSingleton.t)('This defines the level of the hierarchy')
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-sunburst/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Part of a Whole'),
  credits: ['https://bl.ocks.org/kerryrodden/7090426'],
  description: (0,TranslatorSingleton.t)('Uses circles to visualize the flow of data through different stages of a system. Hover over individual paths in the visualization to understand the stages a value took. Useful for multi-stage, multi-group visualizing funnels and pipelines.'),
  exampleGallery: [{
    url: example
  }],
  name: (0,TranslatorSingleton.t)('Sunburst Chart'),
  tags: [(0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Multi-Levels'), (0,TranslatorSingleton.t)('Proportional')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class SunburstChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 6259).then(__webpack_require__.bind(__webpack_require__, 76259)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 10773:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ TreemapChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-treemap/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData
  } = chartProps;
  const {
    colorScheme,
    treemapRatio
  } = formData;
  let {
    numberFormat
  } = formData;

  if (!numberFormat && chartProps.datasource && chartProps.datasource.metrics) {
    chartProps.datasource.metrics.forEach(metric => {
      if (metric.metric_name === chartProps.formData.metrics[0] && metric.d3format) {
        numberFormat = metric.d3format;
      }
    });
  }

  return {
    width,
    height,
    data: queriesData[0].data,
    colorScheme,
    numberFormat,
    treemapRatio
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-treemap/esm/images/thumbnail.png
var thumbnail = __webpack_require__(83382);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-treemap/esm/images/Treemap.jpg
var Treemap = __webpack_require__(61213);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-treemap/esm/images/Treemap2.jpg
var Treemap2 = __webpack_require__(66417);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-treemap/esm/images/Treemap3.jpg
var Treemap3 = __webpack_require__(85892);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-treemap/esm/images/Treemap4.jpg
var Treemap4 = __webpack_require__(59371);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-treemap/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['adhoc_filters'], ['groupby'], ['row_limit'], ['timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    tabOverride: 'customize',
    controlSetRows: [['color_scheme'], [{
      name: 'treemap_ratio',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Ratio'),
        renderTrigger: true,
        isFloat: true,
        default: 0.5 * (1 + Math.sqrt(5)),
        // d3 default, golden ratio
        description: (0,TranslatorSingleton.t)('Target aspect ratio for treemap tiles.')
      }
    }], [{
      name: 'number_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Number format'),
        renderTrigger: true,
        default: 'SMART_NUMBER',
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6,
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }]]
  }],
  controlOverrides: {
    color_scheme: {
      renderTrigger: false
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-treemap/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */








const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Part of a Whole'),
  credits: ['https://bl.ocks.org/mbostock/911ad09bdead40ec0061'],
  description: (0,TranslatorSingleton.t)('Shows the composition of a dataset by segmenting a given rectangle as smaller rectangles with areas proportional to their value or contribution to the whole. Those rectangles may also, in turn, be further segmented hierarchically.'),
  exampleGallery: [{
    url: Treemap
  }, {
    url: Treemap2
  }, {
    url: Treemap3
  }, {
    url: Treemap4
  }],
  name: (0,TranslatorSingleton.t)('Treemap'),
  tags: [(0,TranslatorSingleton.t)('Categorical'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Multi-Levels'), (0,TranslatorSingleton.t)('Percentages'), (0,TranslatorSingleton.t)('Proportional')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class TreemapChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 128).then(__webpack_require__.bind(__webpack_require__, 10128)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 83009:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ WorldMapChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/d3-color/src/color.js
var color = __webpack_require__(16372);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-world-map/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData
  } = chartProps;
  const {
    maxBubbleSize,
    showBubbles,
    linearColorScheme,
    colorPicker
  } = formData;
  const {
    r,
    g,
    b
  } = colorPicker;
  return {
    data: queriesData[0].data,
    width,
    height,
    maxBubbleSize: parseInt(maxBubbleSize, 10),
    showBubbles,
    linearColorScheme,
    color: (0,color/* rgb */.B8)(r, g, b).hex()
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-world-map/esm/images/thumbnail.png
var thumbnail = __webpack_require__(39841);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-world-map/esm/images/WorldMap1.jpg
var WorldMap1 = __webpack_require__(18049);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-world-map/esm/images/WorldMap2.jpg
var WorldMap2 = __webpack_require__(48027);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-world-map/esm/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['entity'], [{
      name: 'country_fieldtype',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Country Field Type'),
        default: 'cca2',
        choices: [['name', 'Full name'], ['cioc', 'code International Olympic Committee (cioc)'], ['cca2', 'code ISO 3166-1 alpha-2 (cca2)'], ['cca3', 'code ISO 3166-1 alpha-3 (cca3)']],
        description: (0,TranslatorSingleton.t)('The country code standard that Superset should expect ' + 'to find in the [country] column')
      }
    }], ['metric'], ['adhoc_filters'], ['row_limit'], [{
      name: 'sort_by_metric',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort by metric'),
        description: (0,TranslatorSingleton.t)('Whether to sort results by the selected metric in descending order.')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Options'),
    expanded: true,
    controlSetRows: [[{
      name: 'show_bubbles',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show Bubbles'),
        default: false,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Whether to display bubbles on top of countries')
      }
    }], ['secondary_metric'], [{
      name: 'max_bubble_size',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Max Bubble Size'),
        default: '25',
        choices: (0,selectOptions/* formatSelectOptions */.m)(['5', '10', '15', '25', '50', '75', '100'])
      }
    }], ['color_picker'], ['linear_color_scheme']]
  }],
  controlOverrides: {
    entity: {
      label: (0,TranslatorSingleton.t)('Country Column'),
      description: (0,TranslatorSingleton.t)('3 letter code of the country')
    },
    metric: {
      label: (0,TranslatorSingleton.t)('Metric for Color'),
      description: (0,TranslatorSingleton.t)('Metric that defines the color of the country')
    },
    secondary_metric: {
      label: (0,TranslatorSingleton.t)('Bubble Size'),
      description: (0,TranslatorSingleton.t)('Metric that defines the size of the bubble')
    },
    color_picker: {
      label: (0,TranslatorSingleton.t)('Bubble Color')
    },
    linear_color_scheme: {
      label: (0,TranslatorSingleton.t)('Country Color Scheme')
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-plugin-chart-world-map/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Map'),
  credits: ['http://datamaps.github.io/'],
  description: (0,TranslatorSingleton.t)('A map of the world, that can indicate values in different countries.'),
  exampleGallery: [{
    url: WorldMap1
  }, {
    url: WorldMap2
  }],
  name: (0,TranslatorSingleton.t)('World Map'),
  tags: [(0,TranslatorSingleton.t)('2D'), (0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Intensity'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Multi-Dimensions'), (0,TranslatorSingleton.t)('Multi-Layers'), (0,TranslatorSingleton.t)('Multi-Variables'), (0,TranslatorSingleton.t)('Scatter'), (0,TranslatorSingleton.t)('Popular')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class WorldMapChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 7068).then(__webpack_require__.bind(__webpack_require__, 17068)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 74779:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ BigNumberChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/sharedControls.js
var sharedControls = __webpack_require__(55716);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/BigNumber/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metric'], ['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Options'),
    tabOverride: 'data',
    expanded: true,
    controlSetRows: [[{
      name: 'compare_lag',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Comparison Period Lag'),
        isInt: true,
        description: (0,TranslatorSingleton.t)('Based on granularity, number of time periods to compare against')
      }
    }], [{
      name: 'compare_suffix',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Comparison suffix'),
        description: (0,TranslatorSingleton.t)('Suffix to apply after the percentage display')
      }
    }], ['y_axis_format'], [{
      name: 'time_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Timestamp format'),
        renderTrigger: true,
        choices: D3Formatting/* D3_TIME_FORMAT_OPTIONS */.HC,
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }], [{
      name: 'show_timestamp',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show Timestamp'),
        renderTrigger: true,
        default: false,
        description: (0,TranslatorSingleton.t)('Whether to display the timestamp')
      }
    }], [{
      name: 'show_trend_line',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show Trend Line'),
        renderTrigger: true,
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to display the trend line')
      }
    }], [{
      name: 'start_y_axis_at_zero',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Start y-axis at 0'),
        renderTrigger: true,
        default: true,
        description: (0,TranslatorSingleton.t)('Start y-axis at zero. Uncheck to start y-axis at minimum value in the data.')
      }
    }], [{
      name: 'time_range_fixed',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Fix to selected Time Range'),
        description: (0,TranslatorSingleton.t)('Fix the trend line to the full time range specified in case filtered results do not include the start or end dates'),
        renderTrigger: true,

        visibility(props) {
          const {
            time_range: timeRange
          } = props.form_data; // only display this option when a time range is selected

          return !!timeRange && timeRange !== 'No filter';
        }

      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_picker', null], [sharedControls/* headerFontSize */.y], [sharedControls/* subheaderFontSize */.Q]]
  }, {
    label: (0,TranslatorSingleton.t)('Advanced Analytics'),
    expanded: false,
    controlSetRows: [// eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Rolling Window'))], [{
      name: 'rolling_type',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Rolling Function'),
        default: 'None',
        choices: (0,selectOptions/* formatSelectOptions */.m)(['None', 'mean', 'sum', 'std', 'cumsum']),
        description: (0,TranslatorSingleton.t)('Defines a rolling window function to apply, works along ' + 'with the [Periods] text box')
      }
    }], [{
      name: 'rolling_periods',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Periods'),
        isInt: true,
        description: (0,TranslatorSingleton.t)('Defines the size of the rolling window function, ' + 'relative to the time granularity selected')
      }
    }], [{
      name: 'min_periods',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Min Periods'),
        isInt: true,
        description: (0,TranslatorSingleton.t)('The minimum number of rolling periods required to show ' + 'a value. For instance if you do a cumulative sum on 7 days ' + 'you may want your "Min Period" to be 7, so that all data points ' + 'shown are the total of 7 periods. This will hide the "ramp up" ' + 'taking place over the first 7 periods')
      }
    }]]
  }],
  controlOverrides: {
    y_axis_format: {
      label: (0,TranslatorSingleton.t)('Number format')
    }
  }
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/BigNumber/transformProps.js
var transformProps = __webpack_require__(84188);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/BigNumber/images/Big_Number_Trendline.jpg
var Big_Number_Trendline = __webpack_require__(74888);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/BigNumber/images/thumbnail.png
var thumbnail = __webpack_require__(48784);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/BigNumber/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('KPI'),
  description: (0,TranslatorSingleton.t)('Showcases a single number accompanied by a simple line chart, to call attention to an important metric along with its change over time or other dimension.'),
  exampleGallery: [{
    url: Big_Number_Trendline
  }],
  name: (0,TranslatorSingleton.t)('Big Number with Trendline'),
  tags: [(0,TranslatorSingleton.t)('Advanced-Analytics'), (0,TranslatorSingleton.t)('Formattable'), (0,TranslatorSingleton.t)('Line'), (0,TranslatorSingleton.t)('Percentages'), (0,TranslatorSingleton.t)('Popular'), (0,TranslatorSingleton.t)('Report'), (0,TranslatorSingleton.t)('Description'), (0,TranslatorSingleton.t)('Trend')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class BigNumberChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(1095), __webpack_require__.e(3720)]).then(__webpack_require__.bind(__webpack_require__, 53720)),
      metadata,
      transformProps: transformProps/* default */.Z,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 84188:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ transformProps)
/* harmony export */ });
/* harmony import */ var d3_color__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16372);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(50855);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63758);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(54441);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(14826);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11304);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const TIME_COLUMN = '__timestamp';
const formatPercentChange = (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__/* .getNumberFormatter */ .JB)(_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__/* ["default"].PERCENT_SIGNED_1_POINT */ .Z.PERCENT_SIGNED_1_POINT); // we trust both the x (time) and y (big number) to be numeric

function transformProps(chartProps) {
  const {
    width,
    height,
    queriesData,
    formData,
    rawFormData
  } = chartProps;
  const {
    colorPicker,
    compareLag: compareLag_,
    compareSuffix = '',
    timeFormat,
    headerFontSize,
    metric = 'value',
    showTimestamp,
    showTrendLine,
    startYAxisAtZero,
    subheader = '',
    subheaderFontSize,
    vizType,
    timeRangeFixed = false
  } = formData;
  const granularity = (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(rawFormData);
  let {
    yAxisFormat
  } = formData;
  const {
    headerFormatSelector,
    headerTimestampFormat
  } = formData;
  const {
    data = [],
    from_dttm: fromDatetime,
    to_dttm: toDatetime
  } = queriesData[0];
  const metricName = typeof metric === 'string' ? metric : metric.label;
  const compareLag = Number(compareLag_) || 0;
  const supportTrendLine = vizType === 'big_number';
  const supportAndShowTrendLine = supportTrendLine && showTrendLine;
  let formattedSubheader = subheader;
  let mainColor;

  if (colorPicker) {
    const {
      r,
      g,
      b
    } = colorPicker;
    mainColor = d3_color__WEBPACK_IMPORTED_MODULE_3__/* .rgb */ .B8(r, g, b).hex();
  }

  let trendLineData;
  let percentChange = 0;
  let bigNumber = data.length === 0 ? null : data[0][metricName];
  let timestamp = data.length === 0 ? null : data[0][TIME_COLUMN];
  let bigNumberFallback;

  if (data.length > 0) {
    const sortedData = data.map(d => ({
      x: d[TIME_COLUMN],
      y: d[metricName]
    })) // sort in time descending order
    .sort((a, b) => a.x !== null && b.x !== null ? b.x - a.x : 0);
    bigNumber = sortedData[0].y;
    timestamp = sortedData[0].x;

    if (bigNumber === null) {
      bigNumberFallback = sortedData.find(d => d.y !== null);
      bigNumber = bigNumberFallback ? bigNumberFallback.y : null;
      timestamp = bigNumberFallback ? bigNumberFallback.x : null;
    }

    if (compareLag > 0) {
      const compareIndex = compareLag;

      if (compareIndex < sortedData.length) {
        const compareValue = sortedData[compareIndex].y; // compare values must both be non-nulls

        if (bigNumber !== null && compareValue !== null && compareValue !== 0) {
          percentChange = (bigNumber - compareValue) / Math.abs(compareValue);
          formattedSubheader = `${formatPercentChange(percentChange)} ${compareSuffix}`;
        }
      }
    }

    if (supportTrendLine) {
      // must reverse to ascending order otherwise it confuses tooltip triggers
      sortedData.reverse();
      trendLineData = supportAndShowTrendLine ? sortedData : undefined;
    }
  }

  let className = '';

  if (percentChange > 0) {
    className = 'positive';
  } else if (percentChange < 0) {
    className = 'negative';
  }

  if (!yAxisFormat && chartProps.datasource && chartProps.datasource.metrics) {
    chartProps.datasource.metrics.forEach(metricEntry => {
      if (metricEntry.metric_name === metric && metricEntry.d3format) {
        yAxisFormat = metricEntry.d3format;
      }
    });
  }

  const headerFormatter = headerFormatSelector ? (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_4__/* .getTimeFormatter */ .bt)(headerTimestampFormat) : (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__/* .getNumberFormatter */ .JB)(yAxisFormat);
  const formatTime = timeFormat === _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__/* ["default"].id */ .Z.id ? (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_4__/* .getTimeFormatterForGranularity */ .uh)(granularity) : (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_4__/* .getTimeFormatter */ .bt)(timeFormat);
  return {
    width,
    height,
    bigNumber,
    bigNumberFallback,
    className,
    headerFormatter,
    formatTime,
    headerFontSize,
    subheaderFontSize,
    mainColor,
    showTimestamp,
    showTrendLine: supportAndShowTrendLine,
    startYAxisAtZero,
    subheader: formattedSubheader,
    timestamp,
    trendLineData,
    fromDatetime,
    toDatetime,
    timeRangeFixed
  };
}

/***/ }),

/***/ 48243:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ BigNumberTotalChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/sharedControls.js
var sharedControls = __webpack_require__(55716);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/BigNumberTotal/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



/* harmony default export */ const controlPanel = ({
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metric'], ['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Options'),
    expanded: true,
    tabOverride: 'data',
    controlSetRows: [[{
      name: 'subheader',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Subheader'),
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Description text that shows up below your Big Number')
      }
    }], ['y_axis_format'], [{
      name: 'header_format_selector',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Timestamp Format'),
        renderTrigger: true,
        default: false,
        description: (0,TranslatorSingleton.t)('Whether to format the timestamp')
      }
    }], [{
      name: 'header_timestamp_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Date format'),
        renderTrigger: true,
        choices: D3Formatting/* D3_TIME_FORMAT_OPTIONS */.HC,
        default: '%d-%m-%Y %H:%M:%S',
        description: D3Formatting/* D3_FORMAT_DOCS */.YD,

        visibility(props) {
          const {
            header_format_selector
          } = props.form_data;
          return !!header_format_selector;
        }

      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [[sharedControls/* headerFontSize */.y], [sharedControls/* subheaderFontSize */.Q]]
  }],
  controlOverrides: {
    y_axis_format: {
      label: (0,TranslatorSingleton.t)('Number format')
    }
  }
});
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/BigNumber/transformProps.js
var transformProps = __webpack_require__(84188);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/BigNumberTotal/images/BigNumber.jpg
var BigNumber = __webpack_require__(69164);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/BigNumberTotal/images/BigNumber2.jpg
var BigNumber2 = __webpack_require__(18072);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/BigNumberTotal/images/thumbnail.png
var thumbnail = __webpack_require__(67752);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-big-number/esm/BigNumberTotal/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('KPI'),
  description: (0,TranslatorSingleton.t)('Showcases a single metric front-and-center. Big number is best used to call attention to a KPI or the one thing you want your audience to focus on.'),
  exampleGallery: [{
    url: BigNumber,
    caption: (0,TranslatorSingleton.t)('A Big Number')
  }, {
    url: BigNumber2,
    caption: (0,TranslatorSingleton.t)('With a subheader')
  }],
  name: (0,TranslatorSingleton.t)('Big Number'),
  tags: [(0,TranslatorSingleton.t)('Additive'), (0,TranslatorSingleton.t)('Business'), (0,TranslatorSingleton.t)('Formattable'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Percentages'), (0,TranslatorSingleton.t)('Popular'), (0,TranslatorSingleton.t)('Report'), (0,TranslatorSingleton.t)('Description')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class BigNumberTotalChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(1095), __webpack_require__.e(3720)]).then(__webpack_require__.bind(__webpack_require__, 53720)),
      metadata,
      transformProps: transformProps/* default */.Z,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 55716:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "y": () => (/* binding */ headerFontSize),
/* harmony export */   "Q": () => (/* binding */ subheaderFontSize)
/* harmony export */ });
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(60650);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// These are control configurations that are shared ONLY within the BigNumber viz plugin repo.

const headerFontSize = {
  name: 'header_font_size',
  config: {
    type: 'SelectControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('Big Number Font Size'),
    renderTrigger: true,
    clearable: false,
    default: 0.4,
    // Values represent the percentage of space a header should take
    options: [{
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('Tiny'),
      value: 0.2
    }, {
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('Small'),
      value: 0.3
    }, {
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('Normal'),
      value: 0.4
    }, {
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('Large'),
      value: 0.5
    }, {
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('Huge'),
      value: 0.6
    }]
  }
};
const subheaderFontSize = {
  name: 'subheader_font_size',
  config: {
    type: 'SelectControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('Subheader Font Size'),
    renderTrigger: true,
    clearable: false,
    default: 0.15,
    // Values represent the percentage of space a subheader should take
    options: [{
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('Tiny'),
      value: 0.125
    }, {
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('Small'),
      value: 0.15
    }, {
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('Normal'),
      value: 0.2
    }, {
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('Large'),
      value: 0.3
    }, {
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('Huge'),
      value: 0.4
    }]
  }
};

/***/ }),

/***/ 66306:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "kA": () => (/* reexport */ DeckGLChartPreset)
});

// UNUSED EXPORTS: ArcChartPlugin, GeoJsonChartPlugin, GridChartPlugin, HexChartPlugin, MultiChartPlugin, PathChartPlugin, PolygonChartPlugin, ScatterChartPlugin, ScreengridChartPlugin

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/models/Preset.js
var Preset = __webpack_require__(26474);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Arc/images/thumbnail.png
var thumbnail = __webpack_require__(78916);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/transformProps.js
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const NOOP = () => {};

function transformProps(chartProps) {
  const {
    datasource,
    height,
    hooks,
    queriesData,
    rawFormData,
    width
  } = chartProps;
  const {
    onAddFilter = NOOP,
    setControlValue = NOOP
  } = hooks;
  return {
    datasource,
    formData: rawFormData,
    height,
    onAddFilter,
    payload: queriesData[0],
    setControlValue,
    viewport: _extends({}, rawFormData.viewport, {
      height,
      width
    }),
    width
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/legacyValidateInteger.js
var legacyValidateInteger = __webpack_require__(12788);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utilities/controls.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function columnChoices(datasource) {
  if (datasource && datasource.columns) {
    return datasource.columns.map(col => [col.column_name, col.verbose_name || col.column_name]).sort((opt1, opt2) => opt1[1].toLowerCase() > opt2[1].toLowerCase() ? 1 : -1);
  }

  return [];
} // input choices & options

const D3_FORMAT_OPTIONS = [['SMART_NUMBER', 'Adaptative formating'], ['~g', 'Original value'], [',d', ',d (12345.432 => 12,345)'], ['.1s', '.1s (12345.432 => 10k)'], ['.3s', '.3s (12345.432 => 12.3k)'], [',.1%', ',.1% (12345.432 => 1,234,543.2%)'], ['.3%', '.3% (12345.432 => 1234543.200%)'], ['.4r', '.4r (12345.432 => 12350)'], [',.3f', ',.3f (12345.432 => 12,345.432)'], ['+,', '+, (12345.432 => +12,345.432)'], ['$,.2f', '$,.2f (12345.432 => $12,345.43)'], ['DURATION', 'Duration in ms (66000 => 1m 6s)'], ['DURATION_SUB', 'Duration in ms (100.40008 => 100ms 400µs 80ns)']];
const PRIMARY_COLOR = {
  r: 0,
  g: 122,
  b: 135,
  a: 1
};
/* harmony default export */ const controls = ({
  default: null,
  mapStateToProps: state => ({
    choices: state.datasource ? state.datasource.time_grain_sqla.filter(o => o[0] !== null) : null
  })
});
// EXTERNAL MODULE: ./node_modules/jquery/dist/jquery.js
var jquery = __webpack_require__(19755);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utilities/utils.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/* eslint camelcase: 0 */

/**
 * Sets the body and title content of a modal, and shows it. Assumes HTML for modal exists and that
 * it handles closing (i.e., works with bootstrap)
 *
 * @param {object} options object of the form
 *  {
 *    title: {string},
 *    body: {string},
 *    modalSelector: {string, default: '.misc-modal' },
 *    titleSelector: {string, default: '.misc-modal .modal-title' },
 *    bodySelector:  {string, default: '.misc-modal .modal-body' },
 *   }
 */

function showModal(options) {
  /* eslint no-param-reassign: 0 */
  options.modalSelector = options.modalSelector || '.misc-modal';
  options.titleSelector = options.titleSelector || '.misc-modal .modal-title';
  options.bodySelector = options.bodySelector || '.misc-modal .modal-body';
  $(options.titleSelector).html(options.title || '');
  $(options.bodySelector).html(options.body || '');
  $(options.modalSelector).modal('show');
}
function formatSelectOptionsForRange(start, end) {
  // outputs array of arrays
  // formatSelectOptionsForRange(1, 5)
  // returns [[1,1], [2,2], [3,3], [4,4], [5,5]]
  const options = []; // eslint-disable-next-line no-plusplus

  for (let i = start; i <= end; i++) {
    options.push([i, i.toString()]);
  }

  return options;
}
function formatSelectOptions(options) {
  return options.map(opt => [opt, opt.toString()]);
}
function getDatasourceParameter(datasourceId, datasourceType) {
  return datasourceId + "__" + datasourceType;
}
function getParam(name) {
  /* eslint no-useless-escape: 0 */
  const formattedName = name.replace(/\[/, '\\[').replace(/]/, '\\]');
  const regex = new RegExp("[\\?&]" + formattedName + "=([^&#]*)"); // eslint-disable-next-line no-restricted-globals

  const results = regex.exec(location.search);
  return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
}
function mainMetric(savedMetrics) {
  // Using 'count' as default metric if it exists, otherwise using whatever one shows up first
  let metric;

  if (savedMetrics && savedMetrics.length > 0) {
    savedMetrics.forEach(m => {
      if (m.metric_name === 'count') {
        metric = 'count';
      }
    });

    if (!metric) {
      metric = savedMetrics[0].metric_name;
    }
  }

  return metric;
}
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utilities/Shared_DeckGL.js
function Shared_DeckGL_extends() { Shared_DeckGL_extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return Shared_DeckGL_extends.apply(this, arguments); }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// These are control configurations that are shared ONLY within the DeckGL viz plugin repo.




const DEFAULT_VIEWPORT = {
  longitude: 6.85236157047845,
  latitude: 31.222656842808707,
  zoom: 1,
  bearing: 0,
  pitch: 0
};
const sandboxUrl = 'https://github.com/apache/incubator-superset/' + 'blob/master/superset-frontend/src/modules/sandbox.js';
const jsFunctionInfo = react.createElement("div", null, (0,TranslatorSingleton.t)('For more information about objects are in context in the scope of this function, refer to the'), react.createElement("a", {
  href: sandboxUrl
}, (0,TranslatorSingleton.t)(" source code of Superset's sandboxed parser"), "."), ".");

function jsFunctionControl(label, description, extraDescr, height, defaultText) {
  if (extraDescr === void 0) {
    extraDescr = null;
  }

  if (height === void 0) {
    height = 100;
  }

  if (defaultText === void 0) {
    defaultText = '';
  }

  return {
    type: 'TextAreaControl',
    language: 'javascript',
    label,
    description,
    height,
    default: defaultText,
    aboveEditorSection: react.createElement("div", null, react.createElement("p", null, description), react.createElement("p", null, jsFunctionInfo), extraDescr),
    mapStateToProps: state => ({
      // eslint-disable-next-line no-negated-condition
      warning: !state.common.conf.ENABLE_JAVASCRIPT_CONTROLS ? (0,TranslatorSingleton.t)('This functionality is disabled in your environment for security reasons.') : null,
      readOnly: !state.common.conf.ENABLE_JAVASCRIPT_CONTROLS
    })
  };
}

const filterNulls = {
  name: 'filter_nulls',
  config: {
    type: 'CheckboxControl',
    label: (0,TranslatorSingleton.t)('Ignore null locations'),
    default: true,
    description: (0,TranslatorSingleton.t)('Whether to ignore locations that are null')
  }
};
const autozoom = {
  name: 'autozoom',
  config: {
    type: 'CheckboxControl',
    label: (0,TranslatorSingleton.t)('Auto Zoom'),
    default: true,
    renderTrigger: true,
    description: (0,TranslatorSingleton.t)('When checked, the map will zoom to your data after each query')
  }
};
const dimension = {
  name: 'dimension',
  config: Shared_DeckGL_extends({}, shared_controls/* sharedControls.groupby */.Hq.groupby, {
    label: (0,TranslatorSingleton.t)('Dimension'),
    description: (0,TranslatorSingleton.t)('Select a dimension'),
    multi: false,
    default: null
  })
};
const jsColumns = {
  name: 'js_columns',
  config: Shared_DeckGL_extends({}, shared_controls/* sharedControls.groupby */.Hq.groupby, {
    label: (0,TranslatorSingleton.t)('Extra data for JS'),
    default: [],
    description: (0,TranslatorSingleton.t)('List of extra columns made available in Javascript functions')
  })
};
const jsDataMutator = {
  name: 'js_data_mutator',
  config: jsFunctionControl((0,TranslatorSingleton.t)('Javascript data interceptor'), (0,TranslatorSingleton.t)('Define a javascript function that receives the data array used in the visualization ' + 'and is expected to return a modified version of that array. This can be used ' + 'to alter properties of the data, filter, or enrich the array.'))
};
const jsTooltip = {
  name: 'js_tooltip',
  config: jsFunctionControl((0,TranslatorSingleton.t)('Javascript tooltip generator'), (0,TranslatorSingleton.t)('Define a function that receives the input and outputs the content for a tooltip'))
};
const jsOnclickHref = {
  name: 'js_onclick_href',
  config: jsFunctionControl((0,TranslatorSingleton.t)('Javascript onClick href'), (0,TranslatorSingleton.t)('Define a function that returns a URL to navigate to when user clicks'))
};
const legendFormat = {
  name: 'legend_format',
  config: {
    label: (0,TranslatorSingleton.t)('Legend Format'),
    description: (0,TranslatorSingleton.t)('Choose the format for legend values'),
    type: 'SelectControl',
    clearable: false,
    default: D3_FORMAT_OPTIONS[0],
    choices: D3_FORMAT_OPTIONS,
    renderTrigger: true
  }
};
const legendPosition = {
  name: 'legend_position',
  config: {
    label: (0,TranslatorSingleton.t)('Legend Position'),
    description: (0,TranslatorSingleton.t)('Choose the position of the legend'),
    type: 'SelectControl',
    clearable: false,
    default: 'tr',
    choices: [[null, 'None'], ['tl', 'Top left'], ['tr', 'Top right'], ['bl', 'Bottom left'], ['br', 'Bottom right']],
    renderTrigger: true
  }
};
const lineColumn = {
  name: 'line_column',
  config: {
    type: 'SelectControl',
    label: (0,TranslatorSingleton.t)('Lines column'),
    default: null,
    description: (0,TranslatorSingleton.t)('The database columns that contains lines information'),
    mapStateToProps: state => ({
      choices: columnChoices(state.datasource)
    }),
    validators: [validateNonEmpty/* default */.Z]
  }
};
const lineWidth = {
  name: 'line_width',
  config: {
    type: 'TextControl',
    label: (0,TranslatorSingleton.t)('Line width'),
    renderTrigger: true,
    isInt: true,
    default: 10,
    description: (0,TranslatorSingleton.t)('The width of the lines')
  }
};
const fillColorPicker = {
  name: 'fill_color_picker',
  config: {
    label: (0,TranslatorSingleton.t)('Fill Color'),
    description: (0,TranslatorSingleton.t)(' Set the opacity to 0 if you do not want to override the color specified in the GeoJSON'),
    type: 'ColorPickerControl',
    default: PRIMARY_COLOR,
    renderTrigger: true
  }
};
const strokeColorPicker = {
  name: 'stroke_color_picker',
  config: {
    label: (0,TranslatorSingleton.t)('Stroke Color'),
    description: (0,TranslatorSingleton.t)(' Set the opacity to 0 if you do not want to override the color specified in the GeoJSON'),
    type: 'ColorPickerControl',
    default: PRIMARY_COLOR,
    renderTrigger: true
  }
};
const filled = {
  name: 'filled',
  config: {
    type: 'CheckboxControl',
    label: (0,TranslatorSingleton.t)('Filled'),
    renderTrigger: true,
    description: (0,TranslatorSingleton.t)('Whether to fill the objects'),
    default: true
  }
};
const stroked = {
  name: 'stroked',
  config: {
    type: 'CheckboxControl',
    label: (0,TranslatorSingleton.t)('Stroked'),
    renderTrigger: true,
    description: (0,TranslatorSingleton.t)('Whether to display the stroke'),
    default: false
  }
};
const extruded = {
  name: 'extruded',
  config: {
    type: 'CheckboxControl',
    label: (0,TranslatorSingleton.t)('Extruded'),
    renderTrigger: true,
    default: true,
    description: 'Whether to make the grid 3D'
  }
};
const gridSize = {
  name: 'grid_size',
  config: {
    type: 'TextControl',
    label: (0,TranslatorSingleton.t)('Grid Size'),
    renderTrigger: true,
    default: 20,
    isInt: true,
    description: (0,TranslatorSingleton.t)('Defines the grid size in pixels')
  }
};
const viewport = {
  name: 'viewport',
  config: {
    type: 'ViewportControl',
    label: (0,TranslatorSingleton.t)('Viewport'),
    renderTrigger: false,
    description: (0,TranslatorSingleton.t)('Parameters related to the view and perspective on the map'),
    // default is whole world mostly centered
    default: DEFAULT_VIEWPORT,
    // Viewport changes shouldn't prompt user to re-run query
    dontRefreshOnChange: true
  }
};
const spatial = {
  name: 'spatial',
  config: {
    type: 'SpatialControl',
    label: (0,TranslatorSingleton.t)('Longitude & Latitude'),
    validators: [validateNonEmpty/* default */.Z],
    description: (0,TranslatorSingleton.t)('Point to your spatial columns'),
    mapStateToProps: state => ({
      choices: columnChoices(state.datasource)
    })
  }
};
const pointRadiusFixed = {
  name: 'point_radius_fixed',
  config: {
    type: 'FixedOrMetricControl',
    label: (0,TranslatorSingleton.t)('Point Size'),
    default: {
      type: 'fix',
      value: 1000
    },
    description: (0,TranslatorSingleton.t)('Fixed point radius'),
    mapStateToProps: state => ({
      datasource: state.datasource
    })
  }
};
const multiplier = {
  name: 'multiplier',
  config: {
    type: 'TextControl',
    label: (0,TranslatorSingleton.t)('Multiplier'),
    isFloat: true,
    renderTrigger: true,
    default: 1,
    description: (0,TranslatorSingleton.t)('Factor to multiply the metric by')
  }
};
const lineType = {
  name: 'line_type',
  config: {
    type: 'SelectControl',
    label: (0,TranslatorSingleton.t)('Lines encoding'),
    clearable: false,
    default: 'json',
    description: (0,TranslatorSingleton.t)('The encoding format of the lines'),
    choices: [['polyline', 'Polyline'], ['json', 'JSON'], ['geohash', 'geohash (square)']]
  }
};
const reverseLongLat = {
  name: 'reverse_long_lat',
  config: {
    type: 'CheckboxControl',
    label: (0,TranslatorSingleton.t)('Reverse Lat & Long'),
    default: false
  }
};
const mapboxStyle = {
  name: 'mapbox_style',
  config: {
    type: 'SelectControl',
    label: (0,TranslatorSingleton.t)('Map Style'),
    clearable: false,
    renderTrigger: true,
    choices: [['mapbox://styles/mapbox/streets-v9', 'Streets'], ['mapbox://styles/mapbox/dark-v9', 'Dark'], ['mapbox://styles/mapbox/light-v9', 'Light'], ['mapbox://styles/mapbox/satellite-streets-v9', 'Satellite Streets'], ['mapbox://styles/mapbox/satellite-v9', 'Satellite'], ['mapbox://styles/mapbox/outdoors-v9', 'Outdoors']],
    default: 'mapbox://styles/mapbox/light-v9',
    description: (0,TranslatorSingleton.t)('Base layer map style')
  }
};
const geojsonColumn = {
  name: 'geojson',
  config: {
    type: 'SelectControl',
    label: (0,TranslatorSingleton.t)('GeoJson Column'),
    validators: [validateNonEmpty/* default */.Z],
    description: (0,TranslatorSingleton.t)('Select the geojson column'),
    mapStateToProps: state => ({
      choices: columnChoices(state.datasource)
    })
  }
};
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Arc/controlPanel.js
function controlPanel_extends() { controlPanel_extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return controlPanel_extends.apply(this, arguments); }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





/* harmony default export */ const controlPanel = ({
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[{
      name: 'start_spatial',
      config: {
        type: 'SpatialControl',
        label: (0,TranslatorSingleton.t)('Start Longitude & Latitude'),
        validators: [validateNonEmpty/* default */.Z],
        description: (0,TranslatorSingleton.t)('Point to your spatial columns'),
        mapStateToProps: state => ({
          choices: columnChoices(state.datasource)
        })
      }
    }, {
      name: 'end_spatial',
      config: {
        type: 'SpatialControl',
        label: (0,TranslatorSingleton.t)('End Longitude & Latitude'),
        validators: [validateNonEmpty/* default */.Z],
        description: (0,TranslatorSingleton.t)('Point to your spatial columns'),
        mapStateToProps: state => ({
          choices: columnChoices(state.datasource)
        })
      }
    }], ['row_limit', filterNulls], ['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Map'),
    controlSetRows: [[mapboxStyle, viewport], [autozoom, null]]
  }, {
    label: (0,TranslatorSingleton.t)('Arc'),
    controlSetRows: [['color_picker', {
      name: 'target_color_picker',
      config: {
        label: (0,TranslatorSingleton.t)('Target Color'),
        description: (0,TranslatorSingleton.t)('Color of the target location'),
        type: 'ColorPickerControl',
        default: PRIMARY_COLOR,
        renderTrigger: true
      }
    }], [controlPanel_extends({}, dimension, {
      label: (0,TranslatorSingleton.t)('Categorical Color'),
      description: (0,TranslatorSingleton.t)('Pick a dimension from which categorical colors are defined')
    }), 'color_scheme', 'label_colors'], [{
      name: 'stroke_width',
      color: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Stroke Width'),
        validators: [legacyValidateInteger/* default */.Z],
        default: null,
        renderTrigger: true,
        choices: formatSelectOptions([1, 2, 3, 4, 5])
      }
    }, legendPosition], [legendFormat, null]]
  }, {
    label: (0,TranslatorSingleton.t)('Advanced'),
    controlSetRows: [[jsColumns], [jsDataMutator], [jsTooltip], [jsOnclickHref]]
  }],
  controlOverrides: {
    size: {
      validators: []
    },
    time_grain_sqla: controls
  }
});
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Arc/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Map'),
  credits: ['https://uber.github.io/deck.gl'],
  description: (0,TranslatorSingleton.t)('Plot the distance (like flight paths) between origin and destination.'),
  name: (0,TranslatorSingleton.t)('deck.gl Arc'),
  thumbnail: thumbnail,
  useLegacyApi: true,
  tags: [(0,TranslatorSingleton.t)('deckGL'), (0,TranslatorSingleton.t)('Geo'), (0,TranslatorSingleton.t)('3D'), (0,TranslatorSingleton.t)('Relational'), (0,TranslatorSingleton.t)('Web')]
});
class ArcChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(9131), __webpack_require__.e(8924), __webpack_require__.e(1921), __webpack_require__.e(2441), __webpack_require__.e(5019), __webpack_require__.e(5322)]).then(__webpack_require__.bind(__webpack_require__, 66585)),
      controlPanel: controlPanel,
      metadata,
      transformProps: transformProps
    });
  }

}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Geojson/images/thumbnail.png
var images_thumbnail = __webpack_require__(13316);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/utils/featureFlags.js
var featureFlags = __webpack_require__(46415);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/dndControls.js
var dndControls = __webpack_require__(91479);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utilities/sharedDndControls.js
function sharedDndControls_extends() { sharedDndControls_extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return sharedDndControls_extends.apply(this, arguments); }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const dndLineColumn = {
  name: 'line_column',
  config: sharedDndControls_extends({}, dndControls/* dndEntity */.zo, {
    label: (0,TranslatorSingleton.t)('Lines column'),
    description: (0,TranslatorSingleton.t)('The database columns that contains lines information')
  })
};
const dndGeojsonColumn = {
  name: 'geojson',
  config: sharedDndControls_extends({}, dndControls/* dndEntity */.zo, {
    label: (0,TranslatorSingleton.t)('GeoJson Column'),
    description: (0,TranslatorSingleton.t)('Select the geojson column')
  })
};
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Geojson/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const geojson = (0,featureFlags/* isFeatureEnabled */.c)(featureFlags/* FeatureFlag.ENABLE_EXPLORE_DRAG_AND_DROP */.T.ENABLE_EXPLORE_DRAG_AND_DROP) ? dndGeojsonColumn : geojsonColumn;
/* harmony default export */ const Geojson_controlPanel = ({
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[geojson], ['row_limit'], [filterNulls], ['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Map'),
    controlSetRows: [[mapboxStyle, viewport] // TODO [autozoom, null], // import { autozoom } from './Shared_DeckGL'
    ]
  }, {
    label: (0,TranslatorSingleton.t)('GeoJson Settings'),
    controlSetRows: [[fillColorPicker, strokeColorPicker], [filled, stroked], [extruded, null], [{
      name: 'point_radius_scale',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Point Radius Scale'),
        validators: [legacyValidateInteger/* default */.Z],
        default: null,
        choices: formatSelectOptions([0, 100, 200, 300, 500])
      }
    }, null]]
  }, {
    label: (0,TranslatorSingleton.t)('Advanced'),
    controlSetRows: [[jsColumns], [jsDataMutator], [jsTooltip], [jsOnclickHref]]
  }]
});
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Geojson/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const Geojson_metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Map'),
  credits: ['https://uber.github.io/deck.gl'],
  description: (0,TranslatorSingleton.t)('The GeoJsonLayer takes in GeoJSON formatted data and renders it as interactive polygons, lines and points (circles, icons and/or texts).'),
  name: (0,TranslatorSingleton.t)('deck.gl Geojson'),
  thumbnail: images_thumbnail,
  useLegacyApi: true,
  tags: [(0,TranslatorSingleton.t)('deckGL'), (0,TranslatorSingleton.t)('2D'), (0,TranslatorSingleton.t)('Aesthetic')]
});
class GeojsonChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(9131), __webpack_require__.e(8924), __webpack_require__.e(1921), __webpack_require__.e(5215), __webpack_require__.e(2112), __webpack_require__.e(1573), __webpack_require__.e(4022), __webpack_require__.e(71)]).then(__webpack_require__.bind(__webpack_require__, 24022)),
      controlPanel: Geojson_controlPanel,
      metadata: Geojson_metadata,
      transformProps: transformProps
    });
  }

}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Grid/images/thumbnail.png
var Grid_images_thumbnail = __webpack_require__(39072);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Grid/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



/* harmony default export */ const Grid_controlPanel = ({
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[spatial], ['size'], ['row_limit'], [filterNulls], ['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Map'),
    controlSetRows: [[mapboxStyle, viewport], ['color_picker', autozoom], [gridSize, extruded]]
  }, {
    label: (0,TranslatorSingleton.t)('Advanced'),
    controlSetRows: [[jsColumns], [jsDataMutator], [jsTooltip], [jsOnclickHref]]
  }],
  controlOverrides: {
    size: {
      label: (0,TranslatorSingleton.t)('Height'),
      description: (0,TranslatorSingleton.t)('Metric used to control height'),
      validators: [validateNonEmpty/* default */.Z]
    }
  }
});
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Grid/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const Grid_metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Map'),
  credits: ['https://uber.github.io/deck.gl'],
  description: (0,TranslatorSingleton.t)('Visualize geospatial data like 3D buildings, landscapes, or objects in grid view.'),
  name: (0,TranslatorSingleton.t)('deck.gl Grid'),
  thumbnail: Grid_images_thumbnail,
  useLegacyApi: true,
  tags: [(0,TranslatorSingleton.t)('deckGL'), (0,TranslatorSingleton.t)('3D'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Experimental')]
});
class GridChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(9131), __webpack_require__.e(8924), __webpack_require__.e(1921), __webpack_require__.e(2441), __webpack_require__.e(5019), __webpack_require__.e(5215), __webpack_require__.e(347), __webpack_require__.e(3208), __webpack_require__.e(666), __webpack_require__.e(4486), __webpack_require__.e(7040)]).then(__webpack_require__.bind(__webpack_require__, 54486)),
      controlPanel: Grid_controlPanel,
      metadata: Grid_metadata,
      transformProps: transformProps
    });
  }

}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Hex/images/thumbnail.png
var Hex_images_thumbnail = __webpack_require__(73518);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Hex/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




/* harmony default export */ const Hex_controlPanel = ({
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[spatial], ['size'], ['row_limit'], [filterNulls], ['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Map'),
    controlSetRows: [[mapboxStyle, viewport], ['color_picker'], [autozoom], [gridSize], [extruded], [{
      name: 'js_agg_function',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Dynamic Aggregation Function'),
        description: (0,TranslatorSingleton.t)('The function to use when aggregating points into groups'),
        default: 'sum',
        clearable: false,
        renderTrigger: true,
        choices: formatSelectOptions(['sum', 'min', 'max', 'mean', 'median', 'count', 'variance', 'deviation', 'p1', 'p5', 'p95', 'p99'])
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Advanced'),
    controlSetRows: [[jsColumns], [jsDataMutator], [jsTooltip], [jsOnclickHref]]
  }]
});
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Hex/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const Hex_metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Map'),
  credits: ['https://uber.github.io/deck.gl'],
  description: (0,TranslatorSingleton.t)('Overlays a hexagonal grid on a map, and aggregates data within the boundary of each cell.'),
  name: (0,TranslatorSingleton.t)('deck.gl 3D Hexagon'),
  thumbnail: Hex_images_thumbnail,
  useLegacyApi: true,
  tags: [(0,TranslatorSingleton.t)('deckGL'), (0,TranslatorSingleton.t)('3D'), (0,TranslatorSingleton.t)('Geo'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Experimental')]
});
class HexChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(9131), __webpack_require__.e(8924), __webpack_require__.e(1921), __webpack_require__.e(2441), __webpack_require__.e(5019), __webpack_require__.e(5215), __webpack_require__.e(347), __webpack_require__.e(666), __webpack_require__.e(2862)]).then(__webpack_require__.bind(__webpack_require__, 1186)),
      controlPanel: Hex_controlPanel,
      metadata: Hex_metadata,
      transformProps: transformProps
    });
  }

}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/Multi/images/thumbnail.png
var Multi_images_thumbnail = __webpack_require__(61567);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/Multi/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



/* harmony default export */ const Multi_controlPanel = ({
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Map'),
    expanded: true,
    controlSetRows: [[mapboxStyle, viewport], [{
      name: 'deck_slices',
      config: {
        type: 'SelectAsyncControl',
        multi: true,
        label: (0,TranslatorSingleton.t)('deck.gl charts'),
        validators: [validateNonEmpty/* default */.Z],
        default: [],
        description: (0,TranslatorSingleton.t)('Pick a set of deck.gl charts to layer on top of one another'),
        dataEndpoint: '/sliceasync/api/read?_flt_0_viz_type=deck_&_flt_7_viz_type=deck_multi',
        placeholder: (0,TranslatorSingleton.t)('Select charts'),
        onAsyncErrorMessage: (0,TranslatorSingleton.t)('Error while fetching charts'),
        mutator: data => {
          if (!data || !data.result) {
            return [];
          }

          return data.result.map(o => ({
            value: o.id,
            label: o.slice_name
          }));
        }
      }
    }, null]]
  }, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['adhoc_filters']]
  }]
});
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/Multi/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const Multi_metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Map'),
  credits: ['https://uber.github.io/deck.gl'],
  description: (0,TranslatorSingleton.t)('Compose multiple layers together to form complex visuals.'),
  name: (0,TranslatorSingleton.t)('deck.gl Multiple Layers'),
  thumbnail: Multi_images_thumbnail,
  useLegacyApi: true,
  tags: [(0,TranslatorSingleton.t)('deckGL'), (0,TranslatorSingleton.t)('Multi-Layers')]
});
class MultiChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(9131), __webpack_require__.e(8924), __webpack_require__.e(1921), __webpack_require__.e(2441), __webpack_require__.e(5019), __webpack_require__.e(4998), __webpack_require__.e(5215), __webpack_require__.e(2112), __webpack_require__.e(347), __webpack_require__.e(3208), __webpack_require__.e(1573), __webpack_require__.e(666), __webpack_require__.e(4022), __webpack_require__.e(4486), __webpack_require__.e(8230), __webpack_require__.e(3037), __webpack_require__.e(3776)]).then(__webpack_require__.bind(__webpack_require__, 46811)),
      controlPanel: Multi_controlPanel,
      metadata: Multi_metadata,
      transformProps: transformProps
    });
  }

}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Path/images/thumbnail.png
var Path_images_thumbnail = __webpack_require__(37642);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Path/controlPanel.js
function Path_controlPanel_extends() { Path_controlPanel_extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return Path_controlPanel_extends.apply(this, arguments); }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




/* harmony default export */ const Path_controlPanel = ({
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[(0,featureFlags/* isFeatureEnabled */.c)(featureFlags/* FeatureFlag.ENABLE_EXPLORE_DRAG_AND_DROP */.T.ENABLE_EXPLORE_DRAG_AND_DROP) ? dndLineColumn : lineColumn], [Path_controlPanel_extends({}, lineType, {
      config: Path_controlPanel_extends({}, lineType.config, {
        choices: [['polyline', 'Polyline'], ['json', 'JSON']]
      })
    })], ['row_limit'], [filterNulls], ['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Map'),
    expanded: true,
    controlSetRows: [[mapboxStyle, viewport], ['color_picker', lineWidth], [reverseLongLat, autozoom]]
  }, {
    label: (0,TranslatorSingleton.t)('Advanced'),
    controlSetRows: [[jsColumns], [jsDataMutator], [jsTooltip], [jsOnclickHref]]
  }]
});
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Path/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const Path_metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Map'),
  credits: ['https://uber.github.io/deck.gl'],
  description: (0,TranslatorSingleton.t)('Visualizes connected points, which form a path, on a map.'),
  name: (0,TranslatorSingleton.t)('deck.gl Path'),
  thumbnail: Path_images_thumbnail,
  useLegacyApi: true,
  tags: [(0,TranslatorSingleton.t)('deckGL'), (0,TranslatorSingleton.t)('Web')]
});
class PathChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(9131), __webpack_require__.e(8924), __webpack_require__.e(1921), __webpack_require__.e(2441), __webpack_require__.e(5019), __webpack_require__.e(5215), __webpack_require__.e(2112), __webpack_require__.e(1391)]).then(__webpack_require__.bind(__webpack_require__, 97492)),
      controlPanel: Path_controlPanel,
      metadata: Path_metadata,
      transformProps: transformProps
    });
  }

}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Polygon/images/thumbnail.png
var Polygon_images_thumbnail = __webpack_require__(31866);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Polygon/controlPanel.js
function Polygon_controlPanel_extends() { Polygon_controlPanel_extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return Polygon_controlPanel_extends.apply(this, arguments); }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const lines = (0,featureFlags/* isFeatureEnabled */.c)(featureFlags/* FeatureFlag.ENABLE_EXPLORE_DRAG_AND_DROP */.T.ENABLE_EXPLORE_DRAG_AND_DROP) ? dndLineColumn : lineColumn;
/* harmony default export */ const Polygon_controlPanel = ({
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[Polygon_controlPanel_extends({}, lines, {
      config: Polygon_controlPanel_extends({}, lines.config, {
        label: (0,TranslatorSingleton.t)('Polygon Column')
      })
    })], [Polygon_controlPanel_extends({}, lineType, {
      config: Polygon_controlPanel_extends({}, lineType.config, {
        label: (0,TranslatorSingleton.t)('Polygon Encoding')
      })
    })], ['adhoc_filters'], ['metric'], [Polygon_controlPanel_extends({}, pointRadiusFixed, {
      config: Polygon_controlPanel_extends({}, pointRadiusFixed.config, {
        label: (0,TranslatorSingleton.t)('Elevation')
      })
    })], ['row_limit'], [reverseLongLat], [filterNulls]]
  }, {
    label: (0,TranslatorSingleton.t)('Map'),
    expanded: true,
    controlSetRows: [[mapboxStyle, viewport], [autozoom, null]]
  }, {
    label: (0,TranslatorSingleton.t)('Polygon Settings'),
    expanded: true,
    controlSetRows: [[fillColorPicker, strokeColorPicker], [filled, stroked], [extruded, multiplier], [lineWidth, null], ['linear_color_scheme', {
      name: 'opacity',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Opacity'),
        default: 80,
        step: 1,
        min: 0,
        max: 100,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Opacity, expects values between 0 and 100')
      }
    }], [{
      name: 'num_buckets',
      config: {
        type: 'SelectControl',
        multi: false,
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Number of buckets to group data'),
        default: 5,
        choices: formatSelectOptions([2, 3, 5, 10]),
        description: (0,TranslatorSingleton.t)('How many buckets should the data be grouped in.'),
        renderTrigger: true
      }
    }, {
      name: 'break_points',
      config: {
        type: 'SelectControl',
        multi: true,
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Bucket break points'),
        choices: formatSelectOptions([]),
        description: (0,TranslatorSingleton.t)('List of n+1 values for bucketing metric into n buckets.'),
        renderTrigger: true
      }
    }], [{
      name: 'table_filter',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Emit Filter Events'),
        renderTrigger: true,
        default: false,
        description: (0,TranslatorSingleton.t)('Whether to apply filter when items are clicked')
      }
    }, {
      name: 'toggle_polygons',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Multiple filtering'),
        renderTrigger: true,
        default: true,
        description: (0,TranslatorSingleton.t)('Allow sending multiple polygons as a filter event')
      }
    }], [legendPosition, legendFormat]]
  }, {
    label: (0,TranslatorSingleton.t)('Advanced'),
    controlSetRows: [[jsColumns], [jsDataMutator], [jsTooltip], [jsOnclickHref]]
  }],
  controlOverrides: {
    metric: {
      validators: []
    },
    time_grain_sqla: controls
  }
});
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Polygon/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const Polygon_metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Map'),
  credits: ['https://uber.github.io/deck.gl'],
  description: (0,TranslatorSingleton.t)('Visualizes geographic areas from your data as polygons on a Mapbox rendered map. Polygons can be colored using a metric.'),
  name: (0,TranslatorSingleton.t)('deck.gl Polygon'),
  thumbnail: Polygon_images_thumbnail,
  useLegacyApi: true,
  tags: [(0,TranslatorSingleton.t)('deckGL'), (0,TranslatorSingleton.t)('3D'), (0,TranslatorSingleton.t)('Multi-Dimensions'), (0,TranslatorSingleton.t)('Geo'), (0,TranslatorSingleton.t)('Experimental')]
});
class PolygonChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(9131), __webpack_require__.e(8924), __webpack_require__.e(1921), __webpack_require__.e(2441), __webpack_require__.e(5019), __webpack_require__.e(5215), __webpack_require__.e(2112), __webpack_require__.e(1573), __webpack_require__.e(3037), __webpack_require__.e(5965)]).then(__webpack_require__.bind(__webpack_require__, 83265)),
      controlPanel: Polygon_controlPanel,
      metadata: Polygon_metadata,
      transformProps: transformProps
    });
  }

}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Scatter/images/thumbnail.png
var Scatter_images_thumbnail = __webpack_require__(50252);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Scatter/controlPanel.js
function Scatter_controlPanel_extends() { Scatter_controlPanel_extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return Scatter_controlPanel_extends.apply(this, arguments); }

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




/* harmony default export */ const Scatter_controlPanel = ({
  onInit: controlState => Scatter_controlPanel_extends({}, controlState, {
    time_grain_sqla: Scatter_controlPanel_extends({}, controlState.time_grain_sqla, {
      value: null
    }),
    granularity: Scatter_controlPanel_extends({}, controlState.granularity, {
      value: null
    })
  }),
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[spatial, null], ['row_limit', filterNulls], ['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Map'),
    expanded: true,
    controlSetRows: [[mapboxStyle, viewport], [autozoom, null]]
  }, {
    label: (0,TranslatorSingleton.t)('Point Size'),
    controlSetRows: [[pointRadiusFixed], [{
      name: 'point_unit',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Point Unit'),
        default: 'square_m',
        clearable: false,
        choices: [['square_m', 'Square meters'], ['square_km', 'Square kilometers'], ['square_miles', 'Square miles'], ['radius_m', 'Radius in meters'], ['radius_km', 'Radius in kilometers'], ['radius_miles', 'Radius in miles']],
        description: (0,TranslatorSingleton.t)('The unit of measure for the specified point radius')
      }
    }], [{
      name: 'min_radius',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Minimum Radius'),
        isFloat: true,
        validators: [validateNonEmpty/* default */.Z],
        renderTrigger: true,
        default: 2,
        description: (0,TranslatorSingleton.t)('Minimum radius size of the circle, in pixels. As the zoom level changes, this ' + 'insures that the circle respects this minimum radius.')
      }
    }, {
      name: 'max_radius',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Maximum Radius'),
        isFloat: true,
        validators: [validateNonEmpty/* default */.Z],
        renderTrigger: true,
        default: 250,
        description: (0,TranslatorSingleton.t)('Maxium radius size of the circle, in pixels. As the zoom level changes, this ' + 'insures that the circle respects this maximum radius.')
      }
    }], [multiplier, null]]
  }, {
    label: (0,TranslatorSingleton.t)('Point Color'),
    controlSetRows: [['color_picker'], [legendPosition], [legendFormat], [Scatter_controlPanel_extends({}, dimension, {
      label: (0,TranslatorSingleton.t)('Categorical Color'),
      description: (0,TranslatorSingleton.t)('Pick a dimension from which categorical colors are defined')
    })], ['color_scheme']]
  }, {
    label: (0,TranslatorSingleton.t)('Advanced'),
    controlSetRows: [[jsColumns], [jsDataMutator], [jsTooltip], [jsOnclickHref]]
  }],
  controlOverrides: {
    size: {
      validators: []
    },
    time_grain_sqla: controls
  }
});
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Scatter/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const Scatter_metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Map'),
  credits: ['https://uber.github.io/deck.gl'],
  description: (0,TranslatorSingleton.t)('A map that takes rendering circles with a variable radius at latitude/longitude coordinates'),
  name: (0,TranslatorSingleton.t)('deck.gl Scatterplot'),
  thumbnail: Scatter_images_thumbnail,
  useLegacyApi: true,
  tags: [(0,TranslatorSingleton.t)('deckGL'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Scatter'), (0,TranslatorSingleton.t)('2D'), (0,TranslatorSingleton.t)('Geo'), (0,TranslatorSingleton.t)('Intensity'), (0,TranslatorSingleton.t)('Density')]
});
class ScatterChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(9131), __webpack_require__.e(8924), __webpack_require__.e(1921), __webpack_require__.e(2441), __webpack_require__.e(5019), __webpack_require__.e(4192)]).then(__webpack_require__.bind(__webpack_require__, 4598)),
      controlPanel: Scatter_controlPanel,
      metadata: Scatter_metadata,
      transformProps: transformProps
    });
  }

}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Screengrid/images/thumbnail.png
var Screengrid_images_thumbnail = __webpack_require__(50295);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Screengrid/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




/* harmony default export */ const Screengrid_controlPanel = ({
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[spatial], ['size'], ['row_limit'], [filterNulls], ['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Map'),
    controlSetRows: [[mapboxStyle, viewport], [autozoom, null]]
  }, {
    label: (0,TranslatorSingleton.t)('Grid'),
    expanded: true,
    controlSetRows: [[gridSize, 'color_picker']]
  }, {
    label: (0,TranslatorSingleton.t)('Advanced'),
    controlSetRows: [[jsColumns], [jsDataMutator], [jsTooltip], [jsOnclickHref]]
  }],
  controlOverrides: {
    size: {
      label: (0,TranslatorSingleton.t)('Weight'),
      description: (0,TranslatorSingleton.t)("Metric used as a weight for the grid's coloring"),
      validators: [validateNonEmpty/* default */.Z]
    },
    time_grain_sqla: controls
  }
});
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Screengrid/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const Screengrid_metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Map'),
  credits: ['https://uber.github.io/deck.gl'],
  description: (0,TranslatorSingleton.t)('Aggregates data within the boundary of grid cells and maps the aggregated values to a dynamic color scale'),
  name: (0,TranslatorSingleton.t)('deck.gl Screen Grid'),
  thumbnail: Screengrid_images_thumbnail,
  useLegacyApi: true,
  tags: [(0,TranslatorSingleton.t)('deckGL'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Intensity'), (0,TranslatorSingleton.t)('Experimental'), (0,TranslatorSingleton.t)('Density')]
});
class ScreengridChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(9131), __webpack_require__.e(8924), __webpack_require__.e(1921), __webpack_require__.e(2441), __webpack_require__.e(5019), __webpack_require__.e(347), __webpack_require__.e(3208), __webpack_require__.e(8230), __webpack_require__.e(7893)]).then(__webpack_require__.bind(__webpack_require__, 28230)),
      controlPanel: Screengrid_controlPanel,
      metadata: Screengrid_metadata,
      transformProps: transformProps
    });
  }

}
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/preset.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */










class DeckGLChartPreset extends Preset/* default */.Z {
  constructor() {
    super({
      name: 'deck.gl charts',
      plugins: [new ArcChartPlugin().configure({
        key: 'deck_arc'
      }), new GeojsonChartPlugin().configure({
        key: 'deck_geojson'
      }), new GridChartPlugin().configure({
        key: 'deck_grid'
      }), new HexChartPlugin().configure({
        key: 'deck_hex'
      }), new MultiChartPlugin().configure({
        key: 'deck_multi'
      }), new PathChartPlugin().configure({
        key: 'deck_path'
      }), new PolygonChartPlugin().configure({
        key: 'deck_polygon'
      }), new ScatterChartPlugin().configure({
        key: 'deck_scatter'
      }), new ScreengridChartPlugin().configure({
        key: 'deck_screengrid'
      })]
    });
  }

}
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/index.js











/***/ }),

/***/ 90081:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ AreaChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/transformProps.js + 1 modules
var transformProps = __webpack_require__(5474);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Area/images/example1.jpg
var example1 = __webpack_require__(77596);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Area/images/example2.jpg
var example2 = __webpack_require__(8100);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Area/images/example3.jpg
var example3 = __webpack_require__(18398);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Area/images/example4.jpg
var example4 = __webpack_require__(11104);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Area/images/thumbnail.png
var thumbnail = __webpack_require__(11482);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/vendor/superset/AnnotationTypes.js
var AnnotationTypes = __webpack_require__(37723);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/NVD3Controls.js
var NVD3Controls = __webpack_require__(34400);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Area/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, NVD3Controls/* timeSeriesSection.0 */.Ht[0], {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [[NVD3Controls/* showBrush */.bJ, NVD3Controls/* showLegend */.lI], [NVD3Controls/* lineInterpolation */.QX, {
      name: 'stacked_style',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Stacked Style'),
        renderTrigger: true,
        choices: [['stack', 'stack'], ['stream', 'stream'], ['expand', 'expand']],
        default: 'stack',
        description: ''
      }
    }], ['color_scheme'], [NVD3Controls/* richTooltip */.Qj, NVD3Controls/* showControls */.cW]]
  }, {
    label: (0,TranslatorSingleton.t)('X Axis'),
    tabOverride: 'customize',
    expanded: true,
    controlSetRows: [[NVD3Controls/* xAxisLabel */.GX, NVD3Controls/* bottomMargin */.hF], [NVD3Controls/* xTicksLayout */.uP, NVD3Controls/* xAxisFormat */.Nl], [NVD3Controls/* xAxisShowMinmax */.i9, null]]
  }, {
    label: (0,TranslatorSingleton.t)('Y Axis'),
    tabOverride: 'customize',
    expanded: true,
    controlSetRows: [['y_axis_format', NVD3Controls/* yAxisBounds */._4], [NVD3Controls/* yLogScale */.q1, null]]
  }, NVD3Controls/* timeSeriesSection.1 */.Ht[1], esm.sections.annotations]
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Area/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */









const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Evolution'),
  credits: ['http://nvd3.org'],
  description: (0,TranslatorSingleton.t)('A time series chart that visualizes how a related metric from multiple groups vary over time. Each group is visualized using a different color.'),
  exampleGallery: [{
    url: example1,
    caption: (0,TranslatorSingleton.t)('Stretched style')
  }, {
    url: example2,
    caption: (0,TranslatorSingleton.t)('Stacked style')
  }, {
    url: example3,
    caption: (0,TranslatorSingleton.t)('Video game consoles')
  }, {
    url: example4,
    caption: (0,TranslatorSingleton.t)('Vehicle Types')
  }],
  name: (0,TranslatorSingleton.t)('Area Chart'),
  supportedAnnotationTypes: [AnnotationTypes/* ANNOTATION_TYPES.INTERVAL */.DT.INTERVAL, AnnotationTypes/* ANNOTATION_TYPES.EVENT */.DT.EVENT],
  tags: [(0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Continuous'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Line'), (0,TranslatorSingleton.t)('Percentages'), (0,TranslatorSingleton.t)('Proportional'), (0,TranslatorSingleton.t)('Stacked'), (0,TranslatorSingleton.t)('Time'), (0,TranslatorSingleton.t)('Trend'), (0,TranslatorSingleton.t)('nvd3'), (0,TranslatorSingleton.t)('Deprecated')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class AreaChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 5278).then(__webpack_require__.bind(__webpack_require__, 65278)),
      metadata,
      transformProps: transformProps/* default */.Z,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 93661:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ BarChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/transformProps.js + 1 modules
var transformProps = __webpack_require__(5474);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Bar/images/thumbnail.png
var thumbnail = __webpack_require__(99646);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Bar/images/Time_Series_Bar_Chart.jpg
var Time_Series_Bar_Chart = __webpack_require__(46905);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Bar/images/Time_Series_Bar_Chart2.jpg
var Time_Series_Bar_Chart2 = __webpack_require__(26507);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Bar/images/Time_Series_Bar_Chart3.jpg
var Time_Series_Bar_Chart3 = __webpack_require__(67346);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/vendor/superset/AnnotationTypes.js
var AnnotationTypes = __webpack_require__(37723);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/NVD3Controls.js
var NVD3Controls = __webpack_require__(34400);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Bar/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, NVD3Controls/* timeSeriesSection.0 */.Ht[0], {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], [NVD3Controls/* showBrush */.bJ], [NVD3Controls/* showLegend */.lI], [NVD3Controls/* showBarValue */.Xo], [NVD3Controls/* richTooltip */.Qj], [NVD3Controls/* barStacked */.Wv], [NVD3Controls/* lineInterpolation */.QX], [NVD3Controls/* showControls */.cW], [NVD3Controls/* bottomMargin */.hF]]
  }, {
    label: (0,TranslatorSingleton.t)('X Axis'),
    expanded: true,
    controlSetRows: [[NVD3Controls/* xAxisLabel */.GX], [NVD3Controls/* bottomMargin */.hF], [NVD3Controls/* xTicksLayout */.uP], [NVD3Controls/* xAxisFormat */.Nl], [NVD3Controls/* xAxisShowMinmax */.i9], [NVD3Controls/* reduceXTicks */.Il]]
  }, {
    label: (0,TranslatorSingleton.t)('Y Axis'),
    expanded: true,
    controlSetRows: [[NVD3Controls/* yAxisLabel */.Pi], [NVD3Controls/* leftMargin */.nI], [NVD3Controls/* yAxisShowMinmax */.VT], [NVD3Controls/* yLogScale */.q1], ['y_axis_format'], [NVD3Controls/* yAxisBounds */._4]]
  }, NVD3Controls/* timeSeriesSection.1 */.Ht[1], esm.sections.annotations]
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Bar/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */








const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Evolution'),
  credits: ['http://nvd3.org'],
  description: (0,TranslatorSingleton.t)('Visualize how a metric changes over time using bars. Add a group by column to visualize group level metrics and how they change over time.'),
  exampleGallery: [{
    url: Time_Series_Bar_Chart
  }, {
    url: Time_Series_Bar_Chart2
  }, {
    url: Time_Series_Bar_Chart3
  }],
  name: (0,TranslatorSingleton.t)('Time-series Bar Chart'),
  supportedAnnotationTypes: [AnnotationTypes/* ANNOTATION_TYPES.INTERVAL */.DT.INTERVAL, AnnotationTypes/* ANNOTATION_TYPES.EVENT */.DT.EVENT],
  tags: [(0,TranslatorSingleton.t)('Time'), (0,TranslatorSingleton.t)('Trend'), (0,TranslatorSingleton.t)('Stacked'), (0,TranslatorSingleton.t)('Vertical'), (0,TranslatorSingleton.t)('Percentages'), (0,TranslatorSingleton.t)('Proportional'), (0,TranslatorSingleton.t)('Advanced-Analytics')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class BarChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 5278).then(__webpack_require__.bind(__webpack_require__, 65278)),
      metadata,
      transformProps: transformProps/* default */.Z,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 96082:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ BubbleChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/transformProps.js + 1 modules
var transformProps = __webpack_require__(5474);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Bubble/images/thumbnail.png
var thumbnail = __webpack_require__(67993);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/NVD3Controls.js
var NVD3Controls = __webpack_require__(34400);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Bubble/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['series'], ['entity'], ['x'], ['y'], ['adhoc_filters'], ['size'], [{
      name: 'max_bubble_size',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Max Bubble Size'),
        default: '25',
        choices: (0,selectOptions/* formatSelectOptions */.m)(['5', '10', '15', '25', '50', '75', '100'])
      }
    }], ['limit', null]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    tabOverride: 'customize',
    controlSetRows: [['color_scheme'], [NVD3Controls/* showLegend */.lI, null]]
  }, {
    label: (0,TranslatorSingleton.t)('X Axis'),
    expanded: true,
    tabOverride: 'customize',
    controlSetRows: [[NVD3Controls/* xAxisLabel */.GX, NVD3Controls/* leftMargin */.nI], [{
      name: NVD3Controls/* xAxisFormat.name */.Nl.name,
      config: { ...NVD3Controls/* xAxisFormat.config */.Nl.config,
        default: 'SMART_NUMBER',
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6
      }
    }, NVD3Controls/* xTicksLayout */.uP], [{
      name: 'x_log_scale',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('X Log Scale'),
        default: false,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Use a log scale for the X-axis')
      }
    }, NVD3Controls/* xAxisShowMinmax */.i9]]
  }, {
    label: (0,TranslatorSingleton.t)('Y Axis'),
    expanded: true,
    tabOverride: 'customize',
    controlSetRows: [[NVD3Controls/* yAxisLabel */.Pi, NVD3Controls/* bottomMargin */.hF], ['y_axis_format', null], [NVD3Controls/* yLogScale */.q1, NVD3Controls/* yAxisShowMinmax */.VT], [NVD3Controls/* yAxisBounds */._4]]
  }],
  controlOverrides: {
    color_scheme: {
      renderTrigger: false
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Bubble/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Correlation'),
  credits: ['http://nvd3.org'],
  description: (0,TranslatorSingleton.t)('Visualizes a metric across three dimensions of data in a single chart (X axis, Y axis, and bubble size). Bubbles from the same group can be showcased using bubble color.'),
  name: (0,TranslatorSingleton.t)('Bubble Chart'),
  tags: [(0,TranslatorSingleton.t)('Multi-Dimensions'), (0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Scatter'), (0,TranslatorSingleton.t)('Time'), (0,TranslatorSingleton.t)('Trend'), (0,TranslatorSingleton.t)('nvd3')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class BubbleChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 5278).then(__webpack_require__.bind(__webpack_require__, 65278)),
      metadata,
      transformProps: transformProps/* default */.Z,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 82622:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ BulletChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/transformProps.js + 1 modules
var transformProps = __webpack_require__(5474);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Bullet/images/thumbnail.png
var thumbnail = __webpack_require__(90344);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Bullet/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metric'], ['adhoc_filters']]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [[{
      name: 'ranges',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Ranges'),
        default: '',
        description: (0,TranslatorSingleton.t)('Ranges to highlight with shading')
      }
    }, {
      name: 'range_labels',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Range labels'),
        default: '',
        description: (0,TranslatorSingleton.t)('Labels for the ranges')
      }
    }], [{
      name: 'markers',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Markers'),
        default: '',
        description: (0,TranslatorSingleton.t)('List of values to mark with triangles')
      }
    }, {
      name: 'marker_labels',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Marker labels'),
        default: '',
        description: (0,TranslatorSingleton.t)('Labels for the markers')
      }
    }], [{
      name: 'marker_lines',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Marker lines'),
        default: '',
        description: (0,TranslatorSingleton.t)('List of values to mark with lines')
      }
    }, {
      name: 'marker_line_labels',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Marker line labels'),
        default: '',
        description: (0,TranslatorSingleton.t)('Labels for the marker lines')
      }
    }]]
  }]
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Bullet/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('KPI'),
  credits: ['http://nvd3.org'],
  description: (0,TranslatorSingleton.t)('Showcases the progress of a single metric against a given target. The higher the fill, the closer the metric is to the target.'),
  name: (0,TranslatorSingleton.t)('Bullet Chart'),
  tags: [(0,TranslatorSingleton.t)('Business'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Report'), (0,TranslatorSingleton.t)('nvd3')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class BulletChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 5278).then(__webpack_require__.bind(__webpack_require__, 65278)),
      metadata,
      transformProps: transformProps/* default */.Z,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 40676:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ CompareChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/transformProps.js + 1 modules
var transformProps = __webpack_require__(5474);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Compare/images/thumbnail.png
var thumbnail = __webpack_require__(45090);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/NVD3Controls.js
var NVD3Controls = __webpack_require__(34400);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Compare/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, NVD3Controls/* timeSeriesSection.0 */.Ht[0], {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme']]
  }, {
    label: (0,TranslatorSingleton.t)('X Axis'),
    expanded: true,
    controlSetRows: [[NVD3Controls/* xAxisLabel */.GX, NVD3Controls/* bottomMargin */.hF], [NVD3Controls/* xTicksLayout */.uP, NVD3Controls/* xAxisFormat */.Nl], [NVD3Controls/* xAxisShowMinmax */.i9, null]]
  }, {
    label: (0,TranslatorSingleton.t)('Y Axis'),
    expanded: true,
    controlSetRows: [[NVD3Controls/* yAxisLabel */.Pi, NVD3Controls/* leftMargin */.nI], [NVD3Controls/* yAxisShowMinmax */.VT, NVD3Controls/* yLogScale */.q1], ['y_axis_format', NVD3Controls/* yAxisBounds */._4]]
  }, NVD3Controls/* timeSeriesSection.1 */.Ht[1], esm.sections.annotations]
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Compare/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Evolution'),
  credits: ['http://nvd3.org'],
  description: (0,TranslatorSingleton.t)('Visualizes many different time-series objects in a single chart. This chart is being deprecated and we recommend using the Time-series Chart instead.'),
  name: (0,TranslatorSingleton.t)('Time-series Percent Change'),
  tags: [(0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Time'), (0,TranslatorSingleton.t)('nvd3'), (0,TranslatorSingleton.t)('Advanced-Analytics'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Line'), (0,TranslatorSingleton.t)('Percentages'), (0,TranslatorSingleton.t)('Predictive'), (0,TranslatorSingleton.t)('Trend')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class CompareChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 5278).then(__webpack_require__.bind(__webpack_require__, 65278)),
      metadata,
      transformProps: transformProps/* default */.Z,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 66121:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ DistBarChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/transformProps.js + 1 modules
var transformProps = __webpack_require__(5474);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/DistBar/images/thumbnail.png
var thumbnail = __webpack_require__(21996);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/DistBar/images/Bar_Chart.jpg
var Bar_Chart = __webpack_require__(18169);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/DistBar/images/Bar_Chart_2.jpg
var Bar_Chart_2 = __webpack_require__(28563);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/DistBar/images/BarChart3.jpg
var BarChart3 = __webpack_require__(25596);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/utils/ensureIsArray.js
var ensureIsArray = __webpack_require__(86852);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/NVD3Controls.js
var NVD3Controls = __webpack_require__(34400);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/DistBar/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['adhoc_filters'], ['groupby'], ['columns'], ['row_limit'], ['timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }], [{
      name: 'contribution',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Contribution'),
        default: false,
        description: (0,TranslatorSingleton.t)('Compute the contribution to the total')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], [NVD3Controls/* showLegend */.lI], [NVD3Controls/* showBarValue */.Xo], [NVD3Controls/* barStacked */.Wv], [{
      name: 'order_bars',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Bars'),
        default: false,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Sort bars by x labels.')
      }
    }], ['y_axis_format'], [NVD3Controls/* yAxisLabel */.Pi], [NVD3Controls/* showControls */.cW, null], [NVD3Controls/* yAxisShowMinmax */.VT], [NVD3Controls/* yAxisBounds */._4]]
  }, {
    label: (0,TranslatorSingleton.t)('X Axis'),
    expanded: true,
    controlSetRows: [[NVD3Controls/* xAxisLabel */.GX], [NVD3Controls/* bottomMargin */.hF], [NVD3Controls/* xTicksLayout */.uP], [NVD3Controls/* reduceXTicks */.Il]]
  }],
  controlOverrides: {
    groupby: {
      label: (0,TranslatorSingleton.t)('Series'),
      validators: [validateNonEmpty/* default */.Z],
      mapStateToProps: (state, controlState) => {
        const groupbyProps = (shared_controls/* sharedControls.groupby.mapStateToProps */.Hq.groupby.mapStateToProps == null ? void 0 : shared_controls/* sharedControls.groupby.mapStateToProps */.Hq.groupby.mapStateToProps(state, controlState)) || {};

        groupbyProps.canDropValue = column => {
          var _state$controls, _state$controls$colum;

          return !(0,ensureIsArray/* default */.Z)((_state$controls = state.controls) == null ? void 0 : (_state$controls$colum = _state$controls.columns) == null ? void 0 : _state$controls$colum.value).includes(column.column_name);
        };

        return groupbyProps;
      },
      rerender: ['columns']
    },
    columns: {
      label: (0,TranslatorSingleton.t)('Breakdowns'),
      description: (0,TranslatorSingleton.t)('Defines how each series is broken down'),
      mapStateToProps: (state, controlState) => {
        const columnsProps = (shared_controls/* sharedControls.columns.mapStateToProps */.Hq.columns.mapStateToProps == null ? void 0 : shared_controls/* sharedControls.columns.mapStateToProps */.Hq.columns.mapStateToProps(state, controlState)) || {};

        columnsProps.canDropValue = column => {
          var _state$controls2, _state$controls2$grou;

          return !(0,ensureIsArray/* default */.Z)((_state$controls2 = state.controls) == null ? void 0 : (_state$controls2$grou = _state$controls2.groupby) == null ? void 0 : _state$controls2$grou.value).includes(column.column_name);
        };

        return columnsProps;
      },
      rerender: ['groupby']
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/DistBar/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */







const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Ranking'),
  credits: ['http://nvd3.org'],
  description: (0,TranslatorSingleton.t)('Compares metrics from different categories using bars. Bar lengths are used to indicate the magnitude of each value and color is used to differentiate groups.'),
  exampleGallery: [{
    url: Bar_Chart,
    caption: 'Stacked style'
  }, {
    url: Bar_Chart_2,
    caption: 'Grouped style'
  }, {
    url: BarChart3
  }],
  name: (0,TranslatorSingleton.t)('Bar Chart'),
  tags: [(0,TranslatorSingleton.t)('Additive'), (0,TranslatorSingleton.t)('Categorical'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Discrete'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Percentages'), (0,TranslatorSingleton.t)('Popular'), (0,TranslatorSingleton.t)('Stacked'), (0,TranslatorSingleton.t)('Vertical'), (0,TranslatorSingleton.t)('nvd3')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class DistBarChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 5278).then(__webpack_require__.bind(__webpack_require__, 65278)),
      metadata,
      transformProps: transformProps/* default */.Z,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 63955:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ DualLineChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/transformProps.js + 1 modules
var transformProps = __webpack_require__(5474);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/DualLine/images/thumbnail.png
var thumbnail = __webpack_require__(2610);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/NVD3Controls.js
var NVD3Controls = __webpack_require__(34400);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/DualLine/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], [NVD3Controls/* showLegend */.lI], [NVD3Controls/* xAxisFormat */.Nl]]
  }, {
    label: (0,TranslatorSingleton.t)('Y Axis 1'),
    expanded: true,
    controlSetRows: [['metric'], ['y_axis_format'], [NVD3Controls/* yAxisShowMinmax */.VT], [NVD3Controls/* yAxisBounds */._4]]
  }, {
    label: (0,TranslatorSingleton.t)('Y Axis 2'),
    expanded: true,
    controlSetRows: [['metric_2'], [NVD3Controls/* yAxis2Format */.rt], [NVD3Controls/* yAxis2ShowMinmax */.op], [NVD3Controls/* yAxis2Bounds */.wj]]
  }, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['adhoc_filters']]
  }, esm.sections.annotations],
  controlOverrides: {
    metric: {
      label: (0,TranslatorSingleton.t)('Left Axis Metric'),
      description: (0,TranslatorSingleton.t)('Choose a metric for left axis')
    },
    y_axis_format: {
      label: (0,TranslatorSingleton.t)('Left Axis Format')
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/DualLine/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Evolution'),
  credits: ['http://nvd3.org'],
  description: (0,TranslatorSingleton.t)('Visualizes 2 metrics as line plots using the same x-axis. This chart is useful for comparing metrics across the same time range.'),
  name: (0,TranslatorSingleton.t)('Dual Line Chart'),
  tags: [(0,TranslatorSingleton.t)('Legacy')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class DualLineChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 5278).then(__webpack_require__.bind(__webpack_require__, 65278)),
      metadata,
      transformProps: transformProps/* default */.Z,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 99483:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ LineChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/transformProps.js + 1 modules
var transformProps = __webpack_require__(5474);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Line/images/LineChart.jpg
var LineChart = __webpack_require__(45367);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Line/images/LineChart2.jpg
var LineChart2 = __webpack_require__(70062);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Line/images/battery.jpg
var battery = __webpack_require__(20985);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Line/images/thumbnail.png
var thumbnail = __webpack_require__(63792);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/vendor/superset/AnnotationTypes.js
var AnnotationTypes = __webpack_require__(37723);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/NVD3Controls.js
var NVD3Controls = __webpack_require__(34400);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Line/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, NVD3Controls/* timeSeriesSection.0 */.Ht[0], {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], [NVD3Controls/* showBrush */.bJ], [{
      name: 'send_time_range',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Propagate'),
        renderTrigger: true,
        default: false,
        description: (0,TranslatorSingleton.t)('Send range filter events to other charts')
      }
    }], [NVD3Controls/* showLegend */.lI], [NVD3Controls/* richTooltip */.Qj], [NVD3Controls/* showMarkers */.Rk], [NVD3Controls/* lineInterpolation */.QX]]
  }, {
    label: (0,TranslatorSingleton.t)('X Axis'),
    expanded: true,
    controlSetRows: [[NVD3Controls/* xAxisLabel */.GX], [NVD3Controls/* bottomMargin */.hF], [NVD3Controls/* xTicksLayout */.uP], [NVD3Controls/* xAxisFormat */.Nl], [NVD3Controls/* xAxisShowMinmax */.i9, null]]
  }, {
    label: (0,TranslatorSingleton.t)('Y Axis'),
    expanded: true,
    controlSetRows: [[NVD3Controls/* yAxisLabel */.Pi], [NVD3Controls/* leftMargin */.nI], [NVD3Controls/* yAxisShowMinmax */.VT], [NVD3Controls/* yLogScale */.q1], ['y_axis_format'], [NVD3Controls/* yAxisBounds */._4]]
  }, NVD3Controls/* timeSeriesSection.1 */.Ht[1], esm.sections.annotations],
  controlOverrides: {
    row_limit: {
      default: 50000
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/Line/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */








const metadata = new ChartMetadata/* default */.Z({
  canBeAnnotationTypes: [AnnotationTypes/* ANNOTATION_TYPES.TIME_SERIES */.DT.TIME_SERIES],
  category: (0,TranslatorSingleton.t)('Evolution'),
  credits: ['http://nvd3.org'],
  description: (0,TranslatorSingleton.t)('Classic chart that visualizes how metrics change over time.'),
  exampleGallery: [{
    url: LineChart
  }, {
    url: LineChart2
  }, {
    url: battery,
    caption: (0,TranslatorSingleton.t)('Battery level over time')
  }],
  name: (0,TranslatorSingleton.t)('Line Chart'),
  supportedAnnotationTypes: [AnnotationTypes/* ANNOTATION_TYPES.TIME_SERIES */.DT.TIME_SERIES, AnnotationTypes/* ANNOTATION_TYPES.INTERVAL */.DT.INTERVAL, AnnotationTypes/* ANNOTATION_TYPES.EVENT */.DT.EVENT, AnnotationTypes/* ANNOTATION_TYPES.FORMULA */.DT.FORMULA],
  tags: [(0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('nvd3'), (0,TranslatorSingleton.t)('Deprecated')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class LineChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 5278).then(__webpack_require__.bind(__webpack_require__, 65278)),
      metadata,
      transformProps: transformProps/* default */.Z,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 80772:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ LineChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/transformProps.js + 1 modules
var transformProps = __webpack_require__(5474);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/LineMulti/images/thumbnail.png
var thumbnail = __webpack_require__(47950);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/NVD3Controls.js
var NVD3Controls = __webpack_require__(34400);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/LineMulti/controlPanel.js
/* eslint-disable camelcase */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const config = {
  controlPanelSections: [{ ...esm.sections.legacyRegularTime,
    controlSetRows: [['time_range']]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    tabOverride: 'customize',
    expanded: true,
    controlSetRows: [['color_scheme'], [{
      name: 'prefix_metric_with_slice_name',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Prefix metric name with slice name'),
        default: false,
        renderTrigger: true
      }
    }, null], [NVD3Controls/* showLegend */.lI], [NVD3Controls/* showMarkers */.Rk], [NVD3Controls/* lineInterpolation */.QX, null]]
  }, {
    label: (0,TranslatorSingleton.t)('X Axis'),
    expanded: true,
    controlSetRows: [[NVD3Controls/* xAxisLabel */.GX], [NVD3Controls/* bottomMargin */.hF], [NVD3Controls/* xTicksLayout */.uP], [NVD3Controls/* xAxisFormat */.Nl], [NVD3Controls/* xAxisShowMinmax */.i9, null]]
  }, {
    label: (0,TranslatorSingleton.t)('Y Axis Left'),
    expanded: true,
    controlSetRows: [[{
      name: 'line_charts',
      config: {
        type: 'SelectAsyncControl',
        multi: true,
        label: (0,TranslatorSingleton.t)('Left Axis chart(s)'),
        validators: [validateNonEmpty/* default */.Z],
        default: [],
        description: (0,TranslatorSingleton.t)('Choose one or more charts for left axis'),
        dataEndpoint: '/sliceasync/api/read?_flt_0_viz_type=line&_flt_7_viz_type=line_multi',
        placeholder: (0,TranslatorSingleton.t)('Select charts'),
        onAsyncErrorMessage: (0,TranslatorSingleton.t)('Error while fetching charts'),
        mutator: data => {
          if (!data || !data.result) {
            return [];
          }

          return data.result.map(o => ({
            value: o.id,
            label: o.slice_name
          }));
        }
      }
    }], ['y_axis_format'], [NVD3Controls/* yAxisShowMinmax */.VT], [NVD3Controls/* yAxisBounds */._4]]
  }, {
    label: (0,TranslatorSingleton.t)('Y Axis Right'),
    expanded: false,
    controlSetRows: [[{
      name: 'line_charts_2',
      config: {
        type: 'SelectAsyncControl',
        multi: true,
        label: (0,TranslatorSingleton.t)('Right Axis chart(s)'),
        validators: [],
        default: [],
        description: (0,TranslatorSingleton.t)('Choose one or more charts for right axis'),
        dataEndpoint: '/sliceasync/api/read?_flt_0_viz_type=line&_flt_7_viz_type=line_multi',
        placeholder: (0,TranslatorSingleton.t)('Select charts'),
        onAsyncErrorMessage: (0,TranslatorSingleton.t)('Error while fetching charts'),
        mutator: data => {
          if (!data || !data.result) {
            return [];
          }

          return data.result.map(o => ({
            value: o.id,
            label: o.slice_name
          }));
        }
      }
    }], [NVD3Controls/* yAxis2Format */.rt], [NVD3Controls/* yAxis2ShowMinmax */.op], [NVD3Controls/* yAxis2Bounds */.wj]]
  }, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['adhoc_filters']]
  }, esm.sections.annotations],
  controlOverrides: {
    y_axis_format: {
      label: (0,TranslatorSingleton.t)('Left Axis Format')
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/LineMulti/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Evolution'),
  credits: ['http://nvd3.org'],
  description: (0,TranslatorSingleton.t)('Visualize two different time series using the same x-axis time range. This chart is being deprecated and we recommend using the Mixed Timeseries Chart instead!'),
  name: (0,TranslatorSingleton.t)('Multiple Line Charts'),
  tags: [(0,TranslatorSingleton.t)('Multi-Variables'), (0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('nvd3'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Time'), (0,TranslatorSingleton.t)('Multi-Layers'), (0,TranslatorSingleton.t)('Deprecated')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class LineChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 5278).then(__webpack_require__.bind(__webpack_require__, 65278)),
      metadata,
      transformProps: transformProps/* default */.Z,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 34400:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "rt": () => (/* binding */ yAxis2Format),
/* harmony export */   "Rk": () => (/* binding */ showMarkers),
/* harmony export */   "nI": () => (/* binding */ leftMargin),
/* harmony export */   "VT": () => (/* binding */ yAxisShowMinmax),
/* harmony export */   "op": () => (/* binding */ yAxis2ShowMinmax),
/* harmony export */   "QX": () => (/* binding */ lineInterpolation),
/* harmony export */   "bJ": () => (/* binding */ showBrush),
/* harmony export */   "lI": () => (/* binding */ showLegend),
/* harmony export */   "cW": () => (/* binding */ showControls),
/* harmony export */   "GX": () => (/* binding */ xAxisLabel),
/* harmony export */   "hF": () => (/* binding */ bottomMargin),
/* harmony export */   "uP": () => (/* binding */ xTicksLayout),
/* harmony export */   "Nl": () => (/* binding */ xAxisFormat),
/* harmony export */   "q1": () => (/* binding */ yLogScale),
/* harmony export */   "_4": () => (/* binding */ yAxisBounds),
/* harmony export */   "wj": () => (/* binding */ yAxis2Bounds),
/* harmony export */   "i9": () => (/* binding */ xAxisShowMinmax),
/* harmony export */   "Qj": () => (/* binding */ richTooltip),
/* harmony export */   "Xo": () => (/* binding */ showBarValue),
/* harmony export */   "Wv": () => (/* binding */ barStacked),
/* harmony export */   "Il": () => (/* binding */ reduceXTicks),
/* harmony export */   "Pi": () => (/* binding */ yAxisLabel),
/* harmony export */   "Ht": () => (/* binding */ timeSeriesSection)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67294);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(60650);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67774);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24610);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11965);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/* eslint-disable react/jsx-key */



/*
  Plugins in question:

  AreaChartPlugin,
  BarChartPlugin,
  BubbleChartPlugin,
  BulletChartPlugin,
  CompareChartPlugin,
  DistBarChartPlugin,
  DualLineChartPlugin,
  LineChartPlugin,
  LineMultiChartPlugin,
  PieChartPlugin,
  TimePivotChartPlugin,
*/


const yAxis2Format = {
  name: 'y_axis_2_format',
  config: {
    type: 'SelectControl',
    freeForm: true,
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Right Axis Format'),
    default: 'SMART_NUMBER',
    choices: _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__/* .D3_FORMAT_OPTIONS */ .F6,
    description: _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__/* .D3_FORMAT_DOCS */ .YD
  }
};
const showMarkers = {
  name: 'show_markers',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Show Markers'),
    renderTrigger: true,
    default: false,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Show data points as circle markers on the lines')
  }
};
const leftMargin = {
  name: 'left_margin',
  config: {
    type: 'SelectControl',
    freeForm: true,
    clearable: false,
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Left Margin'),
    choices: (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_3__/* .formatSelectOptions */ .m)(['auto', 50, 75, 100, 125, 150, 200]),
    default: 'auto',
    renderTrigger: true,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Left margin, in pixels, allowing for more room for axis labels')
  }
};
const yAxisShowMinmax = {
  name: 'y_axis_showminmax',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Y bounds'),
    renderTrigger: true,
    default: false,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Whether to display the min and max values of the Y-axis')
  }
};
const yAxis2ShowMinmax = {
  name: 'y_axis_2_showminmax',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Y 2 bounds'),
    renderTrigger: true,
    default: false,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Whether to display the min and max values of the Y-axis')
  }
};
const lineInterpolation = {
  name: 'line_interpolation',
  config: {
    type: 'SelectControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Line Style'),
    renderTrigger: true,
    choices: (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_3__/* .formatSelectOptions */ .m)(['linear', 'basis', 'cardinal', 'monotone', 'step-before', 'step-after']),
    default: 'linear',
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Line interpolation as defined by d3.js')
  }
};
const showBrush = {
  name: 'show_brush',
  config: {
    type: 'SelectControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Show Range Filter'),
    renderTrigger: true,
    clearable: false,
    default: 'auto',
    choices: [['yes', 'Yes'], ['no', 'No'], ['auto', 'Auto']],
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Whether to display the time range interactive selector')
  }
};
const showLegend = {
  name: 'show_legend',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Legend'),
    renderTrigger: true,
    default: false,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Whether to display the legend (toggles)')
  }
};
const showControls = {
  name: 'show_controls',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Extra Controls'),
    renderTrigger: true,
    default: false,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Whether to show extra controls or not. Extra controls ' + 'include things like making mulitBar charts stacked ' + 'or side by side.')
  }
};
const xAxisLabel = {
  name: 'x_axis_label',
  config: {
    type: 'TextControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('X Axis Label'),
    renderTrigger: true,
    default: ''
  }
};
const bottomMargin = {
  name: 'bottom_margin',
  config: {
    type: 'SelectControl',
    clearable: false,
    freeForm: true,
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Bottom Margin'),
    choices: (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_3__/* .formatSelectOptions */ .m)(['auto', 50, 75, 100, 125, 150, 200]),
    default: 'auto',
    renderTrigger: true,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Bottom margin, in pixels, allowing for more room for axis labels')
  }
};
const xTicksLayout = {
  name: 'x_ticks_layout',
  config: {
    type: 'SelectControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('X Tick Layout'),
    choices: (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_3__/* .formatSelectOptions */ .m)(['auto', 'flat', '45°', 'staggered']),
    default: 'auto',
    clearable: false,
    renderTrigger: true,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('The way the ticks are laid out on the X-axis')
  }
};
const xAxisFormat = {
  name: 'x_axis_format',
  config: {
    type: 'SelectControl',
    freeForm: true,
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('X Axis Format'),
    renderTrigger: true,
    choices: _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__/* .D3_TIME_FORMAT_OPTIONS */ .HC,
    default: 'smart_date',
    description: _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__/* .D3_FORMAT_DOCS */ .YD
  }
};
const yLogScale = {
  name: 'y_log_scale',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Y Log Scale'),
    default: false,
    renderTrigger: true,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Use a log scale for the Y-axis')
  }
};
const yAxisBounds = {
  name: 'y_axis_bounds',
  config: {
    type: 'BoundsControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Y Axis Bounds'),
    renderTrigger: true,
    default: [null, null],
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Bounds for the Y-axis. When left empty, the bounds are ' + 'dynamically defined based on the min/max of the data. Note that ' + "this feature will only expand the axis range. It won't " + "narrow the data's extent.")
  }
};
const yAxis2Bounds = {
  name: 'y_axis_2_bounds',
  config: {
    type: 'BoundsControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Y Axis 2 Bounds'),
    renderTrigger: true,
    default: [null, null],
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Bounds for the Y-axis. When left empty, the bounds are ' + 'dynamically defined based on the min/max of the data. Note that ' + "this feature will only expand the axis range. It won't " + "narrow the data's extent.")
  }
};
const xAxisShowMinmax = {
  name: 'x_axis_showminmax',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('X bounds'),
    renderTrigger: true,
    default: false,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Whether to display the min and max values of the X-axis')
  }
};
const richTooltip = {
  name: 'rich_tooltip',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Rich Tooltip'),
    renderTrigger: true,
    default: true,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('The rich tooltip shows a list of all series for that point in time')
  }
};
const showBarValue = {
  name: 'show_bar_value',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Bar Values'),
    default: false,
    renderTrigger: true,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Show the value on top of the bar')
  }
};
const barStacked = {
  name: 'bar_stacked',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Stacked Bars'),
    renderTrigger: true,
    default: false,
    description: null
  }
};
const reduceXTicks = {
  name: 'reduce_x_ticks',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Reduce X ticks'),
    renderTrigger: true,
    default: false,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Reduces the number of X-axis ticks to be rendered. ' + 'If true, the x-axis will not overflow and labels may be ' + 'missing. If false, a minimum width will be applied ' + 'to columns and the width may overflow into an ' + 'horizontal scroll.')
  }
};
const yAxisLabel = {
  name: 'y_axis_label',
  config: {
    type: 'TextControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Y Axis Label'),
    renderTrigger: true,
    default: ''
  }
};
const timeSeriesSection = [{
  label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Query'),
  expanded: true,
  controlSetRows: [['metrics'], ['adhoc_filters'], ['groupby'], ['limit'], ['timeseries_limit_metric'], [{
    name: 'order_desc',
    config: {
      type: 'CheckboxControl',
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Sort Descending'),
      default: true,
      description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Whether to sort descending or ascending')
    }
  }], [{
    name: 'contribution',
    config: {
      type: 'CheckboxControl',
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Contribution'),
      default: false,
      description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Compute the contribution to the total')
    }
  }], ['row_limit', null]]
}, {
  label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Advanced Analytics'),
  tabOverride: 'data',
  description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('This section contains options ' + 'that allow for advanced analytical post processing ' + 'of query results'),
  controlSetRows: [[(0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)("h1", {
    className: "section-header"
  }, (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Rolling Window'))], [{
    name: 'rolling_type',
    config: {
      type: 'SelectControl',
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Rolling Function'),
      default: 'None',
      choices: (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_3__/* .formatSelectOptions */ .m)(['None', 'mean', 'sum', 'std', 'cumsum']),
      description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Defines a rolling window function to apply, works along ' + 'with the [Periods] text box')
    }
  }], [{
    name: 'rolling_periods',
    config: {
      type: 'TextControl',
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Periods'),
      isInt: true,
      description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Defines the size of the rolling window function, ' + 'relative to the time granularity selected')
    }
  }], [{
    name: 'min_periods',
    config: {
      type: 'TextControl',
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Min Periods'),
      isInt: true,
      description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('The minimum number of rolling periods required to show ' + 'a value. For instance if you do a cumulative sum on 7 days ' + 'you may want your "Min Period" to be 7, so that all data points ' + 'shown are the total of 7 periods. This will hide the "ramp up" ' + 'taking place over the first 7 periods')
    }
  }], [(0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)("h1", {
    className: "section-header"
  }, (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Time Comparison'))], [{
    name: 'time_compare',
    config: {
      type: 'SelectControl',
      multi: true,
      freeForm: true,
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Time Shift'),
      choices: (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_3__/* .formatSelectOptions */ .m)(['1 day', '1 week', '28 days', '30 days', '52 weeks', '1 year', '104 weeks', '2 years']),
      description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Overlay one or more timeseries from a ' + 'relative time period. Expects relative time deltas ' + 'in natural language (example:  24 hours, 7 days, ' + '52 weeks, 365 days). Free text is supported.')
    }
  }], [{
    name: 'comparison_type',
    config: {
      type: 'SelectControl',
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Calculation type'),
      default: 'values',
      choices: [['values', 'Actual Values'], ['absolute', 'Difference'], ['percentage', 'Percentage change'], ['ratio', 'Ratio']],
      description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('How to display time shifts: as individual lines; as the ' + 'difference between the main time series and each time shift; ' + 'as the percentage change; or as the ratio between series and time shifts.')
    }
  }], [(0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)("h1", {
    className: "section-header"
  }, (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Python Functions'))], [(0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)("h2", {
    className: "section-header"
  }, "pandas.resample")], [{
    name: 'resample_rule',
    config: {
      type: 'SelectControl',
      freeForm: true,
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Rule'),
      default: null,
      choices: (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_3__/* .formatSelectOptions */ .m)(['1T', '1H', '1D', '7D', '1M', '1AS']),
      description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Pandas resample rule')
    }
  }], [{
    name: 'resample_method',
    config: {
      type: 'SelectControl',
      freeForm: true,
      label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Method'),
      default: null,
      choices: (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_3__/* .formatSelectOptions */ .m)(['asfreq', 'bfill', 'ffill', 'median', 'mean', 'sum']),
      description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.t)('Pandas resample method')
    }
  }]]
}];

/***/ }),

/***/ 28733:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ TimePivotChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/transformProps.js + 1 modules
var transformProps = __webpack_require__(5474);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/TimePivot/images/thumbnail.png
var thumbnail = __webpack_require__(76468);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/NVD3Controls.js
var NVD3Controls = __webpack_require__(34400);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/TimePivot/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metric'], ['adhoc_filters'], [{
      name: 'freq',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Frequency'),
        default: 'W-MON',
        freeForm: true,
        clearable: false,
        choices: [['AS', 'Year (freq=AS)'], ['52W-MON', '52 weeks starting Monday (freq=52W-MON)'], ['W-SUN', '1 week starting Sunday (freq=W-SUN)'], ['W-MON', '1 week starting Monday (freq=W-MON)'], ['D', 'Day (freq=D)'], ['4W-MON', '4 weeks (freq=4W-MON)']],
        description: (0,TranslatorSingleton.t)(`The periodicity over which to pivot time. Users can provide
            "Pandas" offset alias.
            Click on the info bubble for more details on accepted "freq" expressions.`),
        tooltipOnClick: () => {
          window.open('https://pandas.pydata.org/pandas-docs/stable/timeseries.html#offset-aliases');
        }
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [[NVD3Controls/* showLegend */.lI], [NVD3Controls/* lineInterpolation */.QX], ['color_picker', null]]
  }, {
    label: (0,TranslatorSingleton.t)('X Axis'),
    expanded: true,
    controlSetRows: [[NVD3Controls/* xAxisLabel */.GX], [NVD3Controls/* bottomMargin */.hF], [NVD3Controls/* xAxisShowMinmax */.i9], [{
      name: NVD3Controls/* xAxisFormat.name */.Nl.name,
      config: { ...NVD3Controls/* xAxisFormat.config */.Nl.config,
        default: 'SMART_NUMBER',
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Y Axis'),
    expanded: true,
    controlSetRows: [[NVD3Controls/* yAxisLabel */.Pi], [NVD3Controls/* leftMargin */.nI], [NVD3Controls/* yAxisShowMinmax */.VT], [NVD3Controls/* yLogScale */.q1], ['y_axis_format'], [NVD3Controls/* yAxisBounds */._4]]
  }],
  controlOverrides: {
    metric: {
      clearable: false
    }
  }
};
/* harmony default export */ const controlPanel = (config);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/TimePivot/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Evolution'),
  credits: ['http://nvd3.org'],
  description: '',
  name: (0,TranslatorSingleton.t)('Time-series Period Pivot'),
  tags: [(0,TranslatorSingleton.t)('Legacy'), (0,TranslatorSingleton.t)('Time'), (0,TranslatorSingleton.t)('nvd3')],
  thumbnail: thumbnail,
  useLegacyApi: true
});
class TimePivotChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => __webpack_require__.e(/* import() */ 5278).then(__webpack_require__.bind(__webpack_require__, 65278)),
      metadata,
      transformProps: transformProps/* default */.Z,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 5474:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ transformProps)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/utils/isTruthy.js
var isTruthy = __webpack_require__(34365);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNumber.js
var validateNumber = __webpack_require__(67181);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/utils/tokenize.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function tokenizeToNumericArray(value) {
  if (!(value != null && value.trim())) return null;
  const tokens = value.split(',');
  if (tokens.some(token => (0,validateNumber/* default */.Z)(token))) throw new Error('All values should be numeric');
  return tokens.map(token => parseFloat(token));
}
function tokenizeToStringArray(value) {
  if (!(value != null && value.trim())) return null;
  const tokens = value.split(',');
  return tokens.map(token => token.trim());
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/utils.js
var utils = __webpack_require__(35524);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-nvd3/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const NOOP = () => {};

const grabD3Format = (datasource, targetMetric) => {
  let foundFormatter;
  const {
    metrics = []
  } = datasource || {};
  metrics.forEach(metric => {
    if (metric.d3format && metric.metric_name === targetMetric) {
      foundFormatter = metric.d3format;
    }
  });
  return foundFormatter;
};

function transformProps(chartProps) {
  const {
    width,
    height,
    annotationData,
    datasource,
    formData,
    hooks,
    queriesData
  } = chartProps;
  const {
    onAddFilter = NOOP,
    onError = NOOP
  } = hooks;
  const {
    annotationLayers,
    barStacked,
    bottomMargin,
    colorPicker,
    colorScheme,
    comparisonType,
    contribution,
    donut,
    entity,
    labelsOutside,
    leftMargin,
    lineInterpolation,
    maxBubbleSize,
    metric,
    metric2,
    metrics = [],
    orderBars,
    pieLabelType,
    reduceXTicks,
    richTooltip,
    sendTimeRange,
    showBarValue,
    showBrush,
    showControls,
    showLabels,
    showLegend,
    showMarkers,
    size,
    stackedStyle,
    vizType,
    x,
    xAxisFormat,
    xAxisLabel,
    xAxisShowminmax,
    xLogScale,
    xTicksLayout,
    y,
    yAxisBounds,
    yAxis2Bounds,
    yAxisLabel,
    yAxisShowminmax,
    yAxis2Showminmax,
    yLogScale
  } = formData;
  let {
    markerLabels,
    markerLines,
    markerLineLabels,
    markers,
    numberFormat,
    rangeLabels,
    ranges,
    yAxisFormat,
    yAxis2Format
  } = formData;
  const rawData = queriesData[0].data || [];
  const data = Array.isArray(rawData) ? rawData.map(row => ({ ...row,
    key: (0,utils/* formatLabel */.N4)(row.key, datasource.verboseMap)
  })) : rawData;

  if (vizType === 'pie') {
    numberFormat = numberFormat || grabD3Format(datasource, metric);
  } else if (vizType === 'dual_line') {
    yAxisFormat = yAxisFormat || grabD3Format(datasource, metric);
    yAxis2Format = yAxis2Format || grabD3Format(datasource, metric2);
  } else if (['line', 'dist_bar', 'bar', 'area'].includes(chartProps.formData.vizType)) {
    yAxisFormat = yAxisFormat || grabD3Format(datasource, metrics.length > 0 ? metrics[0] : undefined);
  } else if (vizType === 'bullet') {
    ranges = tokenizeToNumericArray(ranges) || [0, data.measures * 1.1];
    rangeLabels = tokenizeToStringArray(rangeLabels);
    markerLabels = tokenizeToStringArray(markerLabels);
    markerLines = tokenizeToNumericArray(markerLines);
    markerLineLabels = tokenizeToStringArray(markerLineLabels);
    markers = tokenizeToNumericArray(markers);
  }

  return {
    width,
    height,
    data,
    annotationData,
    annotationLayers,
    areaStackedStyle: stackedStyle,
    baseColor: colorPicker,
    bottomMargin,
    colorScheme,
    comparisonType,
    contribution,
    entity,
    isBarStacked: barStacked,
    isDonut: donut,
    isPieLabelOutside: labelsOutside,
    leftMargin,
    lineInterpolation,
    markerLabels,
    markerLines,
    markerLineLabels,
    markers,
    maxBubbleSize: parseInt(maxBubbleSize, 10),
    numberFormat,
    onBrushEnd: (0,isTruthy/* default */.Z)(sendTimeRange) ? timeRange => {
      onAddFilter('__time_range', timeRange, false, true);
    } : undefined,
    onError,
    orderBars,
    pieLabelType,
    rangeLabels,
    ranges,
    reduceXTicks,
    showBarValue,
    showBrush,
    showControls,
    showLabels,
    showLegend,
    showMarkers,
    sizeField: size,
    useRichTooltip: richTooltip,
    vizType,
    xAxisFormat,
    xAxisLabel,
    xAxisShowMinMax: xAxisShowminmax,
    xField: x,
    xIsLogScale: xLogScale,
    xTicksLayout,
    yAxisFormat,
    yAxis2Format,
    yAxisBounds,
    yAxis2Bounds,
    yAxisLabel,
    yAxisShowMinMax: yAxisShowminmax,
    yAxis2ShowMinMax: yAxis2Showminmax,
    yField: y,
    yIsLogScale: yLogScale
  };
}

/***/ }),

/***/ 35524:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "gO": () => (/* binding */ cleanColorInput),
/* harmony export */   "fF": () => (/* binding */ getTimeOrNumberFormatter),
/* harmony export */   "Ad": () => (/* binding */ drawBarValues),
/* harmony export */   "Gx": () => (/* binding */ generateRichLineTooltipContent),
/* harmony export */   "yy": () => (/* binding */ generateCompareTooltipContent),
/* harmony export */   "n4": () => (/* binding */ generateAreaChartTooltipContent),
/* harmony export */   "HO": () => (/* binding */ generateMultiLineTooltipContent),
/* harmony export */   "RO": () => (/* binding */ generateTimePivotTooltip),
/* harmony export */   "zK": () => (/* binding */ generateBubbleTooltipContent),
/* harmony export */   "Vl": () => (/* binding */ hideTooltips),
/* harmony export */   "T7": () => (/* binding */ generateTooltipClassName),
/* harmony export */   "o2": () => (/* binding */ removeTooltip),
/* harmony export */   "Aw": () => (/* binding */ wrapTooltip),
/* harmony export */   "Gr": () => (/* binding */ tipFactory),
/* harmony export */   "GF": () => (/* binding */ getMaxLabelSize),
/* harmony export */   "N4": () => (/* binding */ formatLabel),
/* harmony export */   "UG": () => (/* binding */ computeBarChartWidth),
/* harmony export */   "Hy": () => (/* binding */ tryNumify),
/* harmony export */   "z_": () => (/* binding */ stringifyTimeRange),
/* harmony export */   "Ml": () => (/* binding */ setAxisShowMaxMin),
/* harmony export */   "tH": () => (/* binding */ computeYDomain),
/* harmony export */   "po": () => (/* binding */ computeStackedYDomain)
/* harmony export */ });
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(15078);
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var d3_tip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32383);
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27856);
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(dompurify__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11304);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(50855);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



 // Regexp for the label added to time shifted series
// (1 hour offset, 2 days offset, etc.)

const TIME_SHIFT_PATTERN = /\d+ \w+ offset/;
const ANIMATION_TIME = 1000;
function cleanColorInput(value) {
  // for superset series that should have the same color
  return String(value).trim().replace(' (right axis)', '').split(', ').filter(k => !TIME_SHIFT_PATTERN.test(k)).join(', ');
}
/**
 * If format is smart_date, format date
 * Otherwise, format number with the given format name
 * @param {*} format
 */

function getTimeOrNumberFormatter(format) {
  return format === 'smart_date' ? _superset_ui_core__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z : (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_4__/* .getNumberFormatter */ .JB)(format);
}
function drawBarValues(svg, data, stacked, axisFormat) {
  const format = (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_4__/* .getNumberFormatter */ .JB)(axisFormat);
  const countSeriesDisplayed = data.filter(d => !d.disabled).length;
  const totalStackedValues = stacked && data.length !== 0 ? data[0].values.map((bar, iBar) => {
    const bars = data.filter(series => !series.disabled).map(series => series.values[iBar]);
    return d3__WEBPACK_IMPORTED_MODULE_0___default().sum(bars, d => d.y);
  }) : [];
  svg.selectAll('.bar-chart-label-group').remove();
  setTimeout(() => {
    svg.selectAll('.bar-chart-label-group').remove();
    const groupLabels = svg.select('g.nv-barsWrap').append('g').attr('class', 'bar-chart-label-group');
    svg.selectAll('g.nv-group').filter((d, i) => !stacked || i === countSeriesDisplayed - 1).selectAll('rect').each(function each(d, index) {
      const rectObj = d3__WEBPACK_IMPORTED_MODULE_0___default().select(this);
      const transformAttr = rectObj.attr('transform');
      const xPos = parseFloat(rectObj.attr('x'));
      const yPos = parseFloat(rectObj.attr('y'));
      const rectWidth = parseFloat(rectObj.attr('width'));
      const rectHeight = parseFloat(rectObj.attr('height'));
      const textEls = groupLabels.append('text').text(format(stacked ? totalStackedValues[index] : d.y)).attr('transform', transformAttr).attr('class', 'bar-chart-label'); // fine tune text position

      const bbox = textEls.node().getBBox();
      const labelWidth = bbox.width;
      const labelHeight = bbox.height;
      textEls.attr('x', xPos + rectWidth / 2 - labelWidth / 2);

      if (rectObj.attr('class').includes('positive')) {
        textEls.attr('y', yPos - 5);
      } else {
        textEls.attr('y', yPos + rectHeight + labelHeight);
      }
    });
  }, ANIMATION_TIME);
} // Formats the series key to account for a possible NULL value

function getFormattedKey(seriesKey, shouldDompurify) {
  if (seriesKey === '<NULL>') {
    return `&lt;${seriesKey.slice(1, -1)}&gt;`;
  }

  return shouldDompurify ? dompurify__WEBPACK_IMPORTED_MODULE_2___default().sanitize(seriesKey) : seriesKey;
} // Custom sorted tooltip
// use a verbose formatter for times


function generateRichLineTooltipContent(d, timeFormatter, valueFormatter) {
  let tooltip = '';
  tooltip += "<table><thead><tr><td colspan='3'>" + `<strong class='x-value'>${timeFormatter(d.value)}</strong>` + '</td></tr></thead><tbody>';
  d.series.sort((a, b) => a.value >= b.value ? -1 : 1);
  d.series.forEach(series => {
    const key = getFormattedKey(series.key, true);
    tooltip += `<tr class="${series.highlight ? 'emph' : ''}">` + `<td class='legend-color-guide' style="opacity: ${series.highlight ? '1' : '0.75'};"">` + '<div ' + `style="border: 2px solid ${series.highlight ? 'black' : 'transparent'}; background-color: ${series.color};"` + '></div>' + '</td>' + `<td>${key}</td>` + `<td>${valueFormatter(series.value)}</td>` + '</tr>';
  });
  tooltip += '</tbody></table>';
  return dompurify__WEBPACK_IMPORTED_MODULE_2___default().sanitize(tooltip);
}
function generateCompareTooltipContent(d, valueFormatter) {
  let tooltip = '';
  tooltip += "<table><thead><tr><td colspan='3'>" + `<strong class='x-value'>${d.value}</strong>` + '</td></tr></thead><tbody>';
  d.series.sort((a, b) => a.value >= b.value ? -1 : 1);
  d.series.forEach(series => {
    const key = getFormattedKey(series.key, true);
    tooltip += `<tr class="${series.highlight ? 'emph' : ''}">` + `<td class='legend-color-guide' style="opacity: ${series.highlight ? '1' : '0.75'};"">` + '<div ' + `style="border: 2px solid ${series.highlight ? 'black' : 'transparent'}; background-color: ${series.color};"` + '></div>' + '</td>' + `<td>${key}</td>` + `<td>${valueFormatter(series.value)}</td>` + '</tr>';
  });
  tooltip += '</tbody></table>';
  return dompurify__WEBPACK_IMPORTED_MODULE_2___default().sanitize(tooltip);
}
function generateAreaChartTooltipContent(d, timeFormatter, valueFormatter, chart) {
  const total = chart.style() === 'expand' ? // expand mode does not include total row
  d3__WEBPACK_IMPORTED_MODULE_0___default().sum(d.series, s => s.value) : // other modes include total row at the end
  d.series[d.series.length - 1].value;
  let tooltip = '';
  tooltip += "<table><thead><tr><td colspan='4'>" + `<strong class='x-value'>${timeFormatter(d.value)}</strong>` + '</td></tr></thead><tbody>' + '<tr class="tooltip-header"><td></td><td>Category</td><td>Value</td><td>% to total</td></tr>';
  d.series.forEach(series => {
    const key = getFormattedKey(series.key, true);
    let trClass = '';

    if (series.highlight) {
      trClass = 'superset-legacy-chart-nvd3-tr-highlight';
    } else if (series.key === 'TOTAL') {
      trClass = 'superset-legacy-chart-nvd3-tr-total';
    }

    tooltip += `<tr class="${trClass}" style="border-color: ${series.color}">` + `<td style="color: ${series.color}">${series.key === 'TOTAL' ? '' : '&#9724;'}</td>` + `<td>${key}</td>` + `<td>${valueFormatter(series.value)}</td>` + `<td>${(100 * series.value / total).toFixed(2)}%</td>` + '</tr>';
  });
  tooltip += '</tbody></table>';
  return dompurify__WEBPACK_IMPORTED_MODULE_2___default().sanitize(tooltip);
}
function generateMultiLineTooltipContent(d, xFormatter, yFormatters) {
  const tooltipTitle = xFormatter(d.value);
  let tooltip = '';
  tooltip += "<table><thead><tr><td colspan='3'>" + `<strong class='x-value'>${tooltipTitle}</strong>` + '</td></tr></thead><tbody>';
  d.series.forEach((series, i) => {
    const yFormatter = yFormatters[i];
    const key = getFormattedKey(series.key, false);
    tooltip += "<tr><td class='legend-color-guide'>" + `<div style="background-color: ${series.color};"></div></td>` + `<td class='key'>${key}</td>` + `<td class='value'>${yFormatter(series.value)}</td></tr>`;
  });
  tooltip += '</tbody></table>';
  return tooltip;
}
function generateTimePivotTooltip(d, xFormatter, yFormatter) {
  const tooltipTitle = xFormatter(d.value);
  let tooltip = '';
  tooltip += "<table><thead><tr><td colspan='3'>" + `<strong class='x-value'>${tooltipTitle}</strong>` + '</td></tr></thead><tbody>';
  d.series.forEach(series => {
    if (series.highlight) {
      let label = '';

      if (series.key === 'current') {
        label = series.key;
      } else {
        label = `${series.key} of the selected frequency:`;
      }

      tooltip += "<tr><td class='legend-color-guide'>" + `<div style="background-color: ${series.color};"></div></td>` + `<td class='key'>${label}</td>` + `<td class='value'>${yFormatter(series.value)}</td></tr>`;
    }
  });
  tooltip += '</tbody></table>';
  return dompurify__WEBPACK_IMPORTED_MODULE_2___default().sanitize(tooltip);
}

function getLabel(stringOrObjectWithLabel) {
  return stringOrObjectWithLabel.label || stringOrObjectWithLabel;
}

function createHTMLRow(col1, col2) {
  return `<tr><td>${col1}</td><td>${col2}</td></tr>`;
}

function generateBubbleTooltipContent({
  point,
  entity,
  xField,
  yField,
  sizeField,
  xFormatter,
  yFormatter,
  sizeFormatter
}) {
  let s = '<table>';
  s += `<tr><td style="color: ${point.color};">` + `<strong>${point[entity]}</strong> (${point.group})` + '</td></tr>';
  s += createHTMLRow(getLabel(xField), xFormatter(point.x));
  s += createHTMLRow(getLabel(yField), yFormatter(point.y));
  s += createHTMLRow(getLabel(sizeField), sizeFormatter(point.size));
  s += '</table>';
  return s;
} // shouldRemove indicates whether the nvtooltips should be removed from the DOM

function hideTooltips(shouldRemove) {
  const targets = document.querySelectorAll('.nvtooltip');

  if (targets.length > 0) {
    // Only set opacity to 0 when hiding tooltips so they would reappear
    // on hover, which sets the opacity to 1
    targets.forEach(t => {
      if (shouldRemove) {
        t.remove();
      } else {
        // eslint-disable-next-line no-param-reassign
        t.style.opacity = 0;
      }
    });
  }
}
function generateTooltipClassName(uuid) {
  return `tooltip-${uuid}`;
}
function removeTooltip(uuid) {
  const classSelector = `.${generateTooltipClassName(uuid)}`;
  const target = document.querySelector(classSelector);

  if (target) {
    target.remove();
  }
}
function wrapTooltip(chart) {
  const tooltipLayer = chart.useInteractiveGuideline && chart.useInteractiveGuideline() ? chart.interactiveLayer : chart;
  const tooltipGeneratorFunc = tooltipLayer.tooltip.contentGenerator();
  tooltipLayer.tooltip.contentGenerator(d => {
    let tooltip = `<div>`;
    tooltip += tooltipGeneratorFunc(d);
    tooltip += '</div>';
    return tooltip;
  });
}
function tipFactory(layer) {
  return (0,d3_tip__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)().attr('class', `d3-tip ${layer.annotationTipClass || ''}`).direction('n').offset([-5, 0]).html(d => {
    if (!d) {
      return '';
    }

    const title = d[layer.titleColumn] && d[layer.titleColumn].length > 0 ? `${d[layer.titleColumn]} - ${layer.name}` : layer.name;
    const body = Array.isArray(layer.descriptionColumns) ? layer.descriptionColumns.map(c => d[c]) : Object.values(d);
    return `<div><strong>${title}</strong></div><br/><div>${body.join(', ')}</div>`;
  });
}
function getMaxLabelSize(svg, axisClass) {
  // axis class = .nv-y2  // second y axis on dual line chart
  // axis class = .nv-x  // x axis on time series line chart
  const tickTexts = svg.selectAll(`.${axisClass} g.tick text`);

  if (tickTexts.length > 0) {
    const lengths = tickTexts[0].map(text => text.getComputedTextLength());
    return Math.ceil(Math.max(0, ...lengths));
  }

  return 0;
}
function formatLabel(input, verboseMap = {}) {
  // The input for label may be a string or an array of string
  // When using the time shift feature, the label contains a '---' in the array
  const verboseLookup = s => verboseMap[s] || s;

  return Array.isArray(input) && input.length > 0 ? input.map(l => TIME_SHIFT_PATTERN.test(l) ? l : verboseLookup(l)).join(', ') : verboseLookup(input);
}
const MIN_BAR_WIDTH = 18;
function computeBarChartWidth(data, stacked, maxWidth) {
  const barCount = stacked ? d3__WEBPACK_IMPORTED_MODULE_0___default().max(data, d => d.values.length) : d3__WEBPACK_IMPORTED_MODULE_0___default().sum(data, d => d.values.length);
  const barWidth = barCount * MIN_BAR_WIDTH;
  return Math.max(barWidth, maxWidth);
}
function tryNumify(s) {
  // Attempts casting to Number, returns string when failing
  const n = Number(s);
  return Number.isNaN(n) ? s : n;
}
function stringifyTimeRange(extent) {
  if (extent.some(d => d.toISOString === undefined)) {
    return null;
  }

  return extent.map(d => d.toISOString().slice(0, -1)).join(' : ');
}
function setAxisShowMaxMin(axis, showminmax) {
  if (axis && axis.showMaxMin && showminmax !== undefined) {
    axis.showMaxMin(showminmax);
  }
}
function computeYDomain(data) {
  if (Array.isArray(data) && data.length > 0 && Array.isArray(data[0].values)) {
    const extents = data.filter(d => !d.disabled).map(row => d3__WEBPACK_IMPORTED_MODULE_0___default().extent(row.values, v => v.y));
    const minOfMin = d3__WEBPACK_IMPORTED_MODULE_0___default().min(extents, ([min]) => min);
    const maxOfMax = d3__WEBPACK_IMPORTED_MODULE_0___default().max(extents, ([, max]) => max);
    return [minOfMin, maxOfMax];
  }

  return [0, 1];
}
function computeStackedYDomain(data) {
  if (Array.isArray(data) && data.length > 0 && Array.isArray(data[0].values)) {
    const series = data.filter(d => !d.disabled).map(d => d.values.map(v => v.y));
    const stackedValues = series[0].map((_, i) => series.reduce((acc, cur) => acc + cur[i], 0));
    return [Math.min(0, ...stackedValues), Math.max(0, ...stackedValues)];
  }

  return [0, 1];
}

/***/ }),

/***/ 34365:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ isTruthy)
/* harmony export */ });
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function isTruthy(obj) {
  if (typeof obj === 'boolean') {
    return obj;
  }

  if (typeof obj === 'string') {
    return ['yes', 'y', 'true', 't', '1'].includes(obj.toLowerCase());
  }

  return !!obj;
}

/***/ }),

/***/ 37723:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DT": () => (/* binding */ ANNOTATION_TYPES),
/* harmony export */   "yb": () => (/* binding */ applyNativeColumns),
/* harmony export */   "ZP": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony exports ANNOTATION_TYPES_METADATA, DEFAULT_ANNOTATION_TYPE, ANNOTATION_SOURCE_TYPES_METADATA, ANNOTATION_SOURCE_TYPES, requiresQuery */
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function extractTypes(metadata) {
  return Object.keys(metadata).reduce((prev, key) => {
    const result = prev;
    result[key] = key;
    return result;
  }, {});
}

const ANNOTATION_TYPES_METADATA = {
  FORMULA: {
    value: 'FORMULA',
    label: 'Formula'
  },
  EVENT: {
    value: 'EVENT',
    label: 'Event',
    supportNativeSource: true
  },
  INTERVAL: {
    value: 'INTERVAL',
    label: 'Interval',
    supportNativeSource: true
  },
  TIME_SERIES: {
    value: 'TIME_SERIES',
    label: 'Time Series'
  }
};
const ANNOTATION_TYPES = extractTypes(ANNOTATION_TYPES_METADATA);
const DEFAULT_ANNOTATION_TYPE = ANNOTATION_TYPES.FORMULA;
const ANNOTATION_SOURCE_TYPES_METADATA = {
  NATIVE: {
    value: 'NATIVE',
    label: 'Superset annotation'
  }
};
const ANNOTATION_SOURCE_TYPES = extractTypes(ANNOTATION_SOURCE_TYPES_METADATA);
function requiresQuery(annotationSourceType) {
  return !!annotationSourceType;
}
const NATIVE_COLUMN_NAMES = {
  descriptionColumns: ['long_descr'],
  intervalEndColumn: 'end_dttm',
  timeColumn: 'start_dttm',
  titleColumn: 'short_descr'
};
function applyNativeColumns(annotation) {
  if (annotation.sourceType === ANNOTATION_SOURCE_TYPES.NATIVE) {
    return { ...annotation,
      ...NATIVE_COLUMN_NAMES
    };
  }

  return annotation;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ANNOTATION_TYPES);

/***/ }),

/***/ 55778:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsBoxPlotChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/buildQueryContext.js
var buildQueryContext = __webpack_require__(69205);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/operators/boxplotOperator.js
var boxplotOperator = __webpack_require__(54994);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/BoxPlot/buildQuery.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


function buildQuery(formData) {
  const {
    columns = [],
    granularity_sqla,
    groupby = []
  } = formData;
  return (0,buildQueryContext/* default */.Z)(formData, baseQueryObject => {
    const distributionColumns = []; // For now default to using the temporal column as distribution column.
    // In the future this control should be made mandatory.

    if (!columns.length && granularity_sqla) {
      distributionColumns.push(granularity_sqla);
    }

    return [{ ...baseQueryObject,
      columns: [...distributionColumns, ...columns, ...groupby],
      series_columns: groupby,
      post_processing: [(0,boxplotOperator/* boxplotOperator */.F)(formData, baseQueryObject)]
    }];
  });
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/BoxPlot/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['adhoc_filters'], emitFilterControl/* emitFilterControl */.a, ['groupby'], ['columns'], // TODO: this should be migrated to `series_columns`
    ['series_limit'], ['series_limit_metric'], [{
      name: 'whiskerOptions',
      config: {
        clearable: false,
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Whisker/outlier options'),
        default: 'Tukey',
        description: (0,TranslatorSingleton.t)('Determines how whiskers and outliers are calculated.'),
        choices: (0,selectOptions/* formatSelectOptions */.m)(['Tukey', 'Min/max (no outliers)', '2/98 percentiles', '9/91 percentiles'])
      }
    }]]
  }, esm.sections.titleControls, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], [{
      name: 'x_ticks_layout',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('X Tick Layout'),
        choices: (0,selectOptions/* formatSelectOptions */.m)(['auto', 'flat', '45°', '90°', 'staggered']),
        default: 'auto',
        clearable: false,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('The way the ticks are laid out on the X-axis')
      }
    }], [{
      name: 'number_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Number format'),
        renderTrigger: true,
        default: 'SMART_NUMBER',
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6,
        description: `${(0,TranslatorSingleton.t)('D3 format syntax: https://github.com/d3/d3-format')} ${(0,TranslatorSingleton.t)('Only applies when "Label Type" is set to show values.')}`
      }
    }], [{
      name: 'date_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Date format'),
        renderTrigger: true,
        choices: D3Formatting/* D3_TIME_FORMAT_OPTIONS */.HC,
        default: 'smart_date',
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }]]
  }],
  controlOverrides: {
    groupby: {
      label: (0,TranslatorSingleton.t)('Series'),
      description: (0,TranslatorSingleton.t)('Categories to group by on the x-axis.')
    },
    columns: {
      label: (0,TranslatorSingleton.t)('Distribute across'),
      multi: true,
      description: (0,TranslatorSingleton.t)('Columns to calculate distribution across. Defaults to temporal column if left empty.')
    }
  }
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/color/CategoricalColorNamespace.js
var CategoricalColorNamespace = __webpack_require__(83527);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormatterRegistrySingleton.js
var NumberFormatterRegistrySingleton = __webpack_require__(50855);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/getMetricLabel.js
var getMetricLabel = __webpack_require__(95669);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/time-format/TimeFormatterRegistrySingleton.js + 5 modules
var TimeFormatterRegistrySingleton = __webpack_require__(14826);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/utils/series.js
var utils_series = __webpack_require__(66978);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/defaults.js
var defaults = __webpack_require__(97711);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/transformers.js
var transformers = __webpack_require__(72585);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/constants.js
var constants = __webpack_require__(23788);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/BoxPlot/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    hooks,
    filterState,
    queriesData
  } = chartProps;
  const {
    data = []
  } = queriesData[0];
  const {
    setDataMask = () => {}
  } = hooks;
  const coltypeMapping = (0,utils_series/* getColtypesMapping */.IW)(queriesData[0]);
  const {
    colorScheme,
    groupby = [],
    metrics: formdataMetrics = [],
    numberFormat,
    dateFormat,
    xTicksLayout,
    emitFilter,
    legendOrientation = 'top',
    xAxisTitle,
    yAxisTitle,
    xAxisTitleMargin,
    yAxisTitleMargin,
    yAxisTitlePosition
  } = formData;
  const colorFn = CategoricalColorNamespace.getScale(colorScheme);
  const numberFormatter = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(numberFormat);
  const metricLabels = formdataMetrics.map(getMetricLabel/* default */.Z);
  const transformedData = data.map(datum => {
    const groupbyLabel = (0,utils_series/* extractGroupbyLabel */.iw)({
      datum,
      groupby,
      coltypeMapping,
      timeFormatter: (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(dateFormat)
    });
    return metricLabels.map(metric => {
      const name = metricLabels.length === 1 ? groupbyLabel : `${groupbyLabel}, ${metric}`;
      const isFiltered = filterState.selectedValues && !filterState.selectedValues.includes(name);
      return {
        name,
        value: [datum[`${metric}__min`], datum[`${metric}__q1`], datum[`${metric}__median`], datum[`${metric}__q3`], datum[`${metric}__max`], datum[`${metric}__mean`], datum[`${metric}__count`], datum[`${metric}__outliers`]],
        itemStyle: {
          color: colorFn(groupbyLabel),
          opacity: isFiltered ? constants/* OpacityEnum.SemiTransparent */.ZV.SemiTransparent : 0.6,
          borderColor: colorFn(groupbyLabel)
        }
      };
    });
  }).flatMap(row => row);
  const outlierData = data.map(datum => metricLabels.map(metric => {
    const groupbyLabel = (0,utils_series/* extractGroupbyLabel */.iw)({
      datum,
      groupby,
      coltypeMapping,
      timeFormatter: (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(dateFormat)
    });
    const name = metricLabels.length === 1 ? groupbyLabel : `${groupbyLabel}, ${metric}`; // Outlier data is a nested array of numbers (uncommon, therefore no need to add to DataRecordValue)

    const outlierDatum = datum[`${metric}__outliers`] || [];
    const isFiltered = filterState.selectedValues && !filterState.selectedValues.includes(name);
    return {
      name: 'outlier',
      type: 'scatter',
      data: outlierDatum.map(val => [name, val]),
      tooltip: {
        formatter: param => {
          const [outlierName, stats] = param.data;
          const headline = groupby ? `<p><strong>${(0,utils_series/* sanitizeHtml */.Z6)(outlierName)}</strong></p>` : '';
          return `${headline}${numberFormatter(stats)}`;
        }
      },
      itemStyle: {
        color: colorFn(groupbyLabel),
        opacity: isFiltered ? constants/* OpacityEnum.SemiTransparent */.ZV.SemiTransparent : constants/* OpacityEnum.NonTransparent */.ZV.NonTransparent
      }
    };
  })).flat(2);
  const labelMap = data.reduce((acc, datum) => {
    const label = (0,utils_series/* extractGroupbyLabel */.iw)({
      datum,
      groupby,
      coltypeMapping,
      timeFormatter: (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(dateFormat)
    });
    return { ...acc,
      [label]: groupby.map(col => datum[col])
    };
  }, {});
  const selectedValues = (filterState.selectedValues || []).reduce((acc, selectedValue) => {
    const index = transformedData.findIndex(({
      name
    }) => name === selectedValue);
    return { ...acc,
      [index]: selectedValue
    };
  }, {});
  let axisLabel;
  if (xTicksLayout === '45°') axisLabel = {
    rotate: -45
  };else if (xTicksLayout === '90°') axisLabel = {
    rotate: -90
  };else if (xTicksLayout === 'flat') axisLabel = {
    rotate: 0
  };else if (xTicksLayout === 'staggered') axisLabel = {
    rotate: -45
  };else axisLabel = {
    show: true
  };
  const series = [{
    name: 'boxplot',
    type: 'boxplot',
    data: transformedData,
    tooltip: {
      formatter: param => {
        // @ts-ignore
        const {
          value,
          name
        } = param;
        const headline = name ? `<p><strong>${(0,utils_series/* sanitizeHtml */.Z6)(name)}</strong></p>` : '';
        const stats = [`Max: ${numberFormatter(value[5])}`, `3rd Quartile: ${numberFormatter(value[4])}`, `Mean: ${numberFormatter(value[6])}`, `Median: ${numberFormatter(value[3])}`, `1st Quartile: ${numberFormatter(value[2])}`, `Min: ${numberFormatter(value[1])}`, `# Observations: ${numberFormatter(value[7])}`];

        if (value[8].length > 0) {
          stats.push(`# Outliers: ${numberFormatter(value[8].length)}`);
        }

        return headline + stats.join('<br/>');
      }
    }
  }, // @ts-ignore
  ...outlierData];
  const addYAxisTitleOffset = !!yAxisTitle;
  const addXAxisTitleOffset = !!xAxisTitle;
  const chartPadding = (0,transformers/* getPadding */.tQ)(true, legendOrientation, addYAxisTitleOffset, false, null, addXAxisTitleOffset, yAxisTitlePosition, yAxisTitleMargin, xAxisTitleMargin);
  const echartOptions = {
    grid: { ...defaults/* defaultGrid */.oe,
      ...chartPadding
    },
    xAxis: {
      type: 'category',
      data: transformedData.map(row => row.name),
      axisLabel,
      name: xAxisTitle,
      nameGap: xAxisTitleMargin,
      nameLocation: 'middle'
    },
    yAxis: { ...defaults/* defaultYAxis */.C0,
      type: 'value',
      axisLabel: {
        formatter: numberFormatter
      },
      name: yAxisTitle,
      nameGap: yAxisTitleMargin,
      nameLocation: yAxisTitlePosition === 'Left' ? 'middle' : 'end'
    },
    tooltip: { ...defaults/* defaultTooltip */.Ku,
      trigger: 'item',
      axisPointer: {
        type: 'shadow'
      }
    },
    series
  };
  return {
    formData,
    width,
    height,
    echartOptions,
    setDataMask,
    emitFilter,
    labelMap,
    groupby,
    selectedValues
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/BoxPlot/images/BoxPlot.jpg
var BoxPlot = __webpack_require__(57934);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/BoxPlot/images/thumbnail.png
var thumbnail = __webpack_require__(54270);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/BoxPlot/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






class EchartsBoxPlotChartPlugin extends ChartPlugin/* default */.Z {
  /**
   * The constructor is used to pass relevant metadata and callbacks that get
   * registered in respective registries that are used throughout the library
   * and application. A more thorough description of each property is given in
   * the respective imported file.
   *
   * It is worth noting that `buildQuery` and is optional, and only needed for
   * advanced visualizations that require either post processing operations
   * (pivoting, rolling aggregations, sorting etc) or submitting multiple queries.
   */
  constructor() {
    super({
      buildQuery: buildQuery,
      controlPanel: controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 9242).then(__webpack_require__.bind(__webpack_require__, 89242)),
      metadata: new ChartMetadata/* default */.Z({
        behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
        category: (0,TranslatorSingleton.t)('Distribution'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)('Also known as a box and whisker plot, this visualization compares the distributions of a related metric across multiple groups. The box in the middle emphasizes the mean, median, and inner 2 quartiles. The whiskers around each box visualize the min, max, range, and outer 2 quartiles.'),
        exampleGallery: [{
          url: BoxPlot
        }],
        name: (0,TranslatorSingleton.t)('Box Plot'),
        tags: [(0,TranslatorSingleton.t)('ECharts'), (0,TranslatorSingleton.t)('Range'), (0,TranslatorSingleton.t)('Statistical')],
        thumbnail: thumbnail
      }),
      transformProps: transformProps
    });
  }

}

/***/ }),

/***/ 47285:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsFunnelChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/buildQueryContext.js
var buildQueryContext = __webpack_require__(69205);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Funnel/buildQuery.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function buildQuery(formData) {
  const {
    metric,
    sort_by_metric
  } = formData;
  return (0,buildQueryContext/* default */.Z)(formData, baseQueryObject => [{ ...baseQueryObject,
    ...(sort_by_metric && {
      orderby: [[metric, false]]
    })
  }]);
}
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/types.js
var types = __webpack_require__(94980);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Funnel/types.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

let EchartsFunnelLabelTypeType;

(function (EchartsFunnelLabelTypeType) {
  EchartsFunnelLabelTypeType[EchartsFunnelLabelTypeType["Key"] = 0] = "Key";
  EchartsFunnelLabelTypeType[EchartsFunnelLabelTypeType["Value"] = 1] = "Value";
  EchartsFunnelLabelTypeType[EchartsFunnelLabelTypeType["Percent"] = 2] = "Percent";
  EchartsFunnelLabelTypeType[EchartsFunnelLabelTypeType["KeyValue"] = 3] = "KeyValue";
  EchartsFunnelLabelTypeType[EchartsFunnelLabelTypeType["KeyPercent"] = 4] = "KeyPercent";
  EchartsFunnelLabelTypeType[EchartsFunnelLabelTypeType["KeyValuePercent"] = 5] = "KeyValuePercent";
})(EchartsFunnelLabelTypeType || (EchartsFunnelLabelTypeType = {}));

// @ts-ignore
const DEFAULT_FORM_DATA = { ...types/* DEFAULT_LEGEND_FORM_DATA */.xo,
  groupby: [],
  labelLine: false,
  labelType: EchartsFunnelLabelTypeType.Key,
  legendOrientation: types/* LegendOrientation.Top */.IY.Top,
  legendType: types/* LegendType.Scroll */.HJ.Scroll,
  numberFormat: 'SMART_NUMBER',
  showLabels: true,
  sort: 'descending',
  orient: 'vertical',
  gap: 0,
  emitFilter: false
};
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/controls.js
var controls = __webpack_require__(22297);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Funnel/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const {
  labelType,
  numberFormat,
  showLabels
} = DEFAULT_FORM_DATA;
const funnelLegendSection = [...controls/* legendSection */.q_];
funnelLegendSection.splice(2, 1);
const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['groupby'], ['metric'], ['adhoc_filters'], emitFilterControl/* emitFilterControl */.a, [{
      name: 'row_limit',
      config: { ...shared_controls/* sharedControls.row_limit */.Hq.row_limit,
        default: 10
      }
    }], [{
      name: 'sort_by_metric',
      config: {
        default: true,
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort by metric'),
        description: (0,TranslatorSingleton.t)('Whether to sort results by the selected metric in descending order.')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], ...funnelLegendSection, // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Labels'))], [{
      name: 'label_type',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Label Type'),
        default: labelType,
        renderTrigger: true,
        choices: [[EchartsFunnelLabelTypeType.Key, 'Category Name'], [EchartsFunnelLabelTypeType.Value, 'Value'], [EchartsFunnelLabelTypeType.Percent, 'Percentage'], [EchartsFunnelLabelTypeType.KeyValue, 'Category and Value'], [EchartsFunnelLabelTypeType.KeyPercent, 'Category and Percentage'], [EchartsFunnelLabelTypeType.KeyValuePercent, 'Category, Value and Percentage']],
        description: (0,TranslatorSingleton.t)('What should be shown on the label?')
      }
    }], [{
      name: 'number_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Number format'),
        renderTrigger: true,
        default: numberFormat,
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6,
        description: `${(0,TranslatorSingleton.t)('D3 format syntax: https://github.com/d3/d3-format')} ${(0,TranslatorSingleton.t)('Only applies when "Label Type" is set to show values.')}`
      }
    }], [{
      name: 'show_labels',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show Labels'),
        renderTrigger: true,
        default: showLabels,
        description: (0,TranslatorSingleton.t)('Whether to display the labels.')
      }
    }]]
  }],

  onInit(state) {
    return { ...state,
      row_limit: { ...state.row_limit,
        value: state.row_limit.default
      }
    };
  }

};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormatterRegistrySingleton.js
var NumberFormatterRegistrySingleton = __webpack_require__(50855);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormats.js
var NumberFormats = __webpack_require__(63758);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/getMetricLabel.js
var getMetricLabel = __webpack_require__(95669);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/color/CategoricalColorNamespace.js
var CategoricalColorNamespace = __webpack_require__(83527);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/utils/series.js
var utils_series = __webpack_require__(66978);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/defaults.js
var defaults = __webpack_require__(97711);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/constants.js
var constants = __webpack_require__(23788);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Funnel/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const percentFormatter = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(NumberFormats/* default.PERCENT_2_POINT */.Z.PERCENT_2_POINT);
function formatFunnelLabel({
  params,
  labelType,
  numberFormatter,
  sanitizeName = false
}) {
  const {
    name: rawName = '',
    value,
    percent
  } = params;
  const name = sanitizeName ? (0,utils_series/* sanitizeHtml */.Z6)(rawName) : rawName;
  const formattedValue = numberFormatter(value);
  const formattedPercent = percentFormatter(percent / 100);

  switch (labelType) {
    case EchartsFunnelLabelTypeType.Key:
      return name;

    case EchartsFunnelLabelTypeType.Value:
      return formattedValue;

    case EchartsFunnelLabelTypeType.Percent:
      return formattedPercent;

    case EchartsFunnelLabelTypeType.KeyValue:
      return `${name}: ${formattedValue}`;

    case EchartsFunnelLabelTypeType.KeyValuePercent:
      return `${name}: ${formattedValue} (${formattedPercent})`;

    case EchartsFunnelLabelTypeType.KeyPercent:
      return `${name}: ${formattedPercent}`;

    default:
      return name;
  }
}
function transformProps(chartProps) {
  const {
    formData,
    height,
    hooks,
    filterState,
    queriesData,
    width
  } = chartProps;
  const data = queriesData[0].data || [];
  const {
    colorScheme,
    groupby,
    orient,
    sort,
    gap,
    labelLine,
    labelType,
    legendMargin,
    legendOrientation,
    legendType,
    metric = '',
    numberFormat,
    showLabels,
    showLegend,
    emitFilter
  } = { ...types/* DEFAULT_LEGEND_FORM_DATA */.xo,
    ...DEFAULT_FORM_DATA,
    ...formData
  };
  const metricLabel = (0,getMetricLabel/* default */.Z)(metric);
  const keys = data.map(datum => (0,utils_series/* extractGroupbyLabel */.iw)({
    datum,
    groupby,
    coltypeMapping: {}
  }));
  const labelMap = data.reduce((acc, datum) => {
    const label = (0,utils_series/* extractGroupbyLabel */.iw)({
      datum,
      groupby,
      coltypeMapping: {}
    });
    return { ...acc,
      [label]: groupby.map(col => datum[col])
    };
  }, {});
  const {
    setDataMask = () => {}
  } = hooks;
  const colorFn = CategoricalColorNamespace.getScale(colorScheme);
  const numberFormatter = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(numberFormat);
  const transformedData = data.map(datum => {
    const name = (0,utils_series/* extractGroupbyLabel */.iw)({
      datum,
      groupby,
      coltypeMapping: {}
    });
    const isFiltered = filterState.selectedValues && !filterState.selectedValues.includes(name);
    return {
      value: datum[metricLabel],
      name,
      itemStyle: {
        color: colorFn(name),
        opacity: isFiltered ? constants/* OpacityEnum.SemiTransparent */.ZV.SemiTransparent : constants/* OpacityEnum.NonTransparent */.ZV.NonTransparent
      }
    };
  });
  const selectedValues = (filterState.selectedValues || []).reduce((acc, selectedValue) => {
    const index = transformedData.findIndex(({
      name
    }) => name === selectedValue);
    return { ...acc,
      [index]: selectedValue
    };
  }, {});

  const formatter = params => formatFunnelLabel({
    params,
    numberFormatter,
    labelType
  });

  const defaultLabel = {
    formatter,
    show: showLabels,
    color: '#000000'
  };
  const series = [{
    type: 'funnel',
    ...(0,utils_series/* getChartPadding */.G_)(showLegend, legendOrientation, legendMargin),
    animation: true,
    minSize: '0%',
    maxSize: '100%',
    sort,
    orient,
    gap,
    funnelAlign: 'center',
    labelLine: {
      show: !!labelLine
    },
    label: { ...defaultLabel,
      position: labelLine ? 'outer' : 'inner',
      textBorderColor: 'transparent'
    },
    emphasis: {
      label: {
        show: true,
        fontWeight: 'bold'
      }
    },
    // @ts-ignore
    data: transformedData
  }];
  const echartOptions = {
    grid: { ...defaults/* defaultGrid */.oe
    },
    tooltip: { ...defaults/* defaultTooltip */.Ku,
      trigger: 'item',
      formatter: params => formatFunnelLabel({
        params,
        numberFormatter,
        labelType: EchartsFunnelLabelTypeType.KeyValuePercent
      })
    },
    legend: { ...(0,utils_series/* getLegendProps */.zp)(legendType, legendOrientation, showLegend),
      data: keys
    },
    series
  };
  return {
    formData,
    width,
    height,
    echartOptions,
    setDataMask,
    emitFilter,
    labelMap,
    groupby,
    selectedValues
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Funnel/images/thumbnail.png
var thumbnail = __webpack_require__(47890);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Funnel/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





class EchartsFunnelChartPlugin extends ChartPlugin/* default */.Z {
  /**
   * The constructor is used to pass relevant metadata and callbacks that get
   * registered in respective registries that are used throughout the library
   * and application. A more thorough description of each property is given in
   * the respective imported file.
   *
   * It is worth noting that `buildQuery` and is optional, and only needed for
   * advanced visualizations that require either post processing operations
   * (pivoting, rolling aggregations, sorting etc) or submitting multiple queries.
   */
  constructor() {
    super({
      buildQuery: buildQuery,
      controlPanel: controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 8130).then(__webpack_require__.bind(__webpack_require__, 98130)),
      metadata: new ChartMetadata/* default */.Z({
        behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
        category: (0,TranslatorSingleton.t)('KPI'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)('Showcases how a metric changes as the funnel progresses. This classic chart is useful for visualizing drop-off between stages in a pipeline or lifecycle.'),
        name: (0,TranslatorSingleton.t)('Funnel Chart'),
        tags: [(0,TranslatorSingleton.t)('Business'), (0,TranslatorSingleton.t)('ECharts'), (0,TranslatorSingleton.t)('Progressive'), (0,TranslatorSingleton.t)('Report'), (0,TranslatorSingleton.t)('Sequential'), (0,TranslatorSingleton.t)('Trend')],
        thumbnail: thumbnail
      }),
      transformProps: transformProps
    });
  }

}

/***/ }),

/***/ 26425:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsGaugeChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateInteger.js
var validateInteger = __webpack_require__(12971);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/types.js
var types = __webpack_require__(94980);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Gauge/types.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

const DEFAULT_FORM_DATA = { ...types/* DEFAULT_LEGEND_FORM_DATA */.xo,
  groupby: [],
  rowLimit: 10,
  minVal: 0,
  maxVal: 100,
  fontSize: 15,
  numberFormat: 'SMART_NUMBER',
  animation: true,
  showProgress: true,
  overlap: true,
  roundCap: false,
  showAxisTick: false,
  showSplitLine: false,
  splitNumber: 10,
  startAngle: 225,
  endAngle: -45,
  showPointer: true,
  intervals: '',
  intervalColorIndices: '',
  valueFormatter: '{value}',
  emitFilter: false
};
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Gauge/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[{
      name: 'groupby',
      config: { ...shared_controls/* sharedControls.groupby */.Hq.groupby,
        label: (0,TranslatorSingleton.t)('Group by'),
        description: (0,TranslatorSingleton.t)('Columns to group by')
      }
    }], ['metric'], ['adhoc_filters'], emitFilterControl/* emitFilterControl */.a, [{
      name: 'row_limit',
      config: { ...shared_controls/* sharedControls.row_limit */.Hq.row_limit,
        choices: [...Array(10).keys()].map(n => n + 1),
        default: DEFAULT_FORM_DATA.rowLimit
      }
    }], [{
      name: 'sort_by_metric',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort by metric'),
        description: (0,TranslatorSingleton.t)('Whether to sort results by the selected metric in descending order.')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [[(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('General'))], [{
      name: 'min_val',
      config: {
        type: 'TextControl',
        isInt: true,
        default: String(DEFAULT_FORM_DATA.minVal),
        validators: [validateNonEmpty/* default */.Z, validateInteger/* default */.Z],
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Min'),
        description: (0,TranslatorSingleton.t)('Minimum value on the gauge axis')
      }
    }, {
      name: 'max_val',
      config: {
        type: 'TextControl',
        isInt: true,
        default: DEFAULT_FORM_DATA.maxVal,
        validators: [validateNonEmpty/* default */.Z, validateInteger/* default */.Z],
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Max'),
        description: (0,TranslatorSingleton.t)('Maximum value on the gauge axis')
      }
    }], [{
      name: 'start_angle',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Start angle'),
        description: (0,TranslatorSingleton.t)('Angle at which to start progress axis'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.startAngle
      }
    }, {
      name: 'end_angle',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('End angle'),
        description: (0,TranslatorSingleton.t)('Angle at which to end progress axis'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.endAngle
      }
    }], ['color_scheme'], [{
      name: 'font_size',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Font size'),
        description: (0,TranslatorSingleton.t)('Font size for axis labels, detail value and other text elements'),
        renderTrigger: true,
        min: 10,
        max: 20,
        default: DEFAULT_FORM_DATA.fontSize
      }
    }], [{
      name: 'number_format',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Number format'),
        description: (0,TranslatorSingleton.t)('D3 format syntax: https://github.com/d3/d3-format'),
        freeForm: true,
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.numberFormat,
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6
      }
    }], [{
      name: 'value_formatter',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Value format'),
        description: (0,TranslatorSingleton.t)('Additional text to add before or after the value, e.g. unit'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.valueFormatter
      }
    }], [{
      name: 'show_pointer',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show pointer'),
        description: (0,TranslatorSingleton.t)('Whether to show the pointer'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.showPointer
      }
    }], [{
      name: 'animation',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Animation'),
        description: (0,TranslatorSingleton.t)('Whether to animate the progress and the value or just display them'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.animation
      }
    }], [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Axis'))], [{
      name: 'show_axis_tick',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show axis line ticks'),
        description: (0,TranslatorSingleton.t)('Whether to show minor ticks on the axis'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.showAxisTick
      }
    }], [{
      name: 'show_split_line',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show split lines'),
        description: (0,TranslatorSingleton.t)('Whether to show the split lines on the axis'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.showSplitLine
      }
    }], [{
      name: 'split_number',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Split number'),
        description: (0,TranslatorSingleton.t)('Number of split segments on the axis'),
        renderTrigger: true,
        min: 3,
        max: 30,
        default: DEFAULT_FORM_DATA.splitNumber
      }
    }], [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Progress'))], [{
      name: 'show_progress',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show progress'),
        description: (0,TranslatorSingleton.t)('Whether to show the progress of gauge chart'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.showProgress
      }
    }], [{
      name: 'overlap',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Overlap'),
        description: (0,TranslatorSingleton.t)('Whether the progress bar overlaps when there are multiple groups of data'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.overlap
      }
    }], [{
      name: 'round_cap',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Round cap'),
        description: (0,TranslatorSingleton.t)('Style the ends of the progress bar with a round cap'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.roundCap
      }
    }], [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Intervals'))], [{
      name: 'intervals',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Interval bounds'),
        description: (0,TranslatorSingleton.t)('Comma-separated interval bounds, e.g. 2,4,5 for intervals 0-2, 2-4 and 4-5. Last number should match the value provided for MAX.'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.intervals
      }
    }], [{
      name: 'interval_color_indices',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Interval colors'),
        description: (0,TranslatorSingleton.t)('Comma-separated color picks for the intervals, e.g. 1,2,4. Integers denote colors from the chosen color scheme and are 1-indexed. Length must be matching that of interval bounds.'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.intervalColorIndices
      }
    }]]
  }]
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormatterRegistrySingleton.js
var NumberFormatterRegistrySingleton = __webpack_require__(50855);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/color/CategoricalColorNamespace.js
var CategoricalColorNamespace = __webpack_require__(83527);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/getMetricLabel.js
var getMetricLabel = __webpack_require__(95669);
// EXTERNAL MODULE: ./node_modules/lodash/range.js
var range = __webpack_require__(96026);
var range_default = /*#__PURE__*/__webpack_require__.n(range);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/utils/controls.js
var controls = __webpack_require__(26091);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Gauge/constants.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const DEFAULT_GAUGE_SERIES_OPTION = {
  splitLine: {
    lineStyle: {
      color: '#63677A'
    }
  },
  axisLine: {
    lineStyle: {
      color: [[1, '#E6EBF8']]
    }
  },
  axisLabel: {
    color: '#464646'
  },
  axisTick: {
    lineStyle: {
      width: 2,
      color: '#63677A'
    }
  },
  detail: {
    color: 'auto'
  }
};
const INTERVAL_GAUGE_SERIES_OPTION = {
  splitLine: {
    lineStyle: {
      color: 'auto'
    }
  },
  axisTick: {
    lineStyle: {
      color: 'auto'
    }
  },
  axisLabel: {
    color: 'auto'
  },
  pointer: {
    itemStyle: {
      color: 'auto'
    }
  }
};
const OFFSETS = {
  ticksFromLine: 10,
  titleFromCenter: 20
};
const FONT_SIZE_MULTIPLIERS = {
  axisTickLength: 0.25,
  axisLabelDistance: 1.5,
  axisLabelLength: 0.35,
  splitLineLength: 1,
  splitLineWidth: 0.25,
  titleOffsetFromTitle: 2,
  detailOffsetFromTitle: 0.9,
  detailFontSize: 1.2
};
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/constants.js
var constants = __webpack_require__(23788);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Gauge/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */







const setIntervalBoundsAndColors = (intervals, intervalColorIndices, colorFn, normalizer) => {
  let intervalBoundsNonNormalized;
  let intervalColorIndicesArray;

  try {
    intervalBoundsNonNormalized = (0,controls/* parseNumbersList */.N)(intervals, ',');
    intervalColorIndicesArray = (0,controls/* parseNumbersList */.N)(intervalColorIndices, ',');
  } catch (error) {
    intervalBoundsNonNormalized = [];
    intervalColorIndicesArray = [];
  }

  const intervalBounds = intervalBoundsNonNormalized.map(bound => bound / normalizer);
  const intervalColors = intervalColorIndicesArray.map(ind => colorFn.colors[(ind - 1) % colorFn.colors.length]);
  return intervalBounds.map((val, idx) => {
    const color = intervalColors[idx];
    return [val, color || colorFn.colors[idx]];
  });
};

const calculateAxisLineWidth = (data, fontSize, overlap) => overlap ? fontSize : data.length * fontSize;

function transformProps(chartProps) {
  var _queriesData$, _DEFAULT_GAUGE_SERIES, _DEFAULT_GAUGE_SERIES2, _DEFAULT_GAUGE_SERIES3, _DEFAULT_GAUGE_SERIES4, _DEFAULT_GAUGE_SERIES5, _DEFAULT_GAUGE_SERIES6, _DEFAULT_GAUGE_SERIES7;

  const {
    width,
    height,
    formData,
    queriesData,
    hooks,
    filterState
  } = chartProps;
  const {
    groupby,
    metric,
    minVal,
    maxVal,
    colorScheme,
    fontSize,
    numberFormat,
    animation,
    showProgress,
    overlap,
    roundCap,
    showAxisTick,
    showSplitLine,
    splitNumber,
    startAngle,
    endAngle,
    showPointer,
    intervals,
    intervalColorIndices,
    valueFormatter,
    emitFilter
  } = { ...DEFAULT_FORM_DATA,
    ...formData
  };
  const data = ((_queriesData$ = queriesData[0]) == null ? void 0 : _queriesData$.data) || [];
  const numberFormatter = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(numberFormat);
  const colorFn = CategoricalColorNamespace.getScale(colorScheme);
  const normalizer = maxVal;
  const axisLineWidth = calculateAxisLineWidth(data, fontSize, overlap);
  const axisLabels = range_default()(minVal, maxVal, (maxVal - minVal) / splitNumber);
  const axisLabelLength = Math.max(...axisLabels.map(label => numberFormatter(label).length).concat([1]));

  const formatValue = value => valueFormatter.replace('{value}', numberFormatter(value));

  const axisTickLength = FONT_SIZE_MULTIPLIERS.axisTickLength * fontSize;
  const splitLineLength = FONT_SIZE_MULTIPLIERS.splitLineLength * fontSize;
  const titleOffsetFromTitle = FONT_SIZE_MULTIPLIERS.titleOffsetFromTitle * fontSize;
  const detailOffsetFromTitle = FONT_SIZE_MULTIPLIERS.detailOffsetFromTitle * fontSize;
  const intervalBoundsAndColors = setIntervalBoundsAndColors(intervals, intervalColorIndices, colorFn, normalizer);
  const columnsLabelMap = new Map();
  const transformedData = data.map((data_point, index) => {
    const name = groupby.map(column => `${column}: ${data_point[column]}`).join(', ');
    columnsLabelMap.set(name, groupby.map(col => data_point[col]));
    let item = {
      value: data_point[(0,getMetricLabel/* default */.Z)(metric)],
      name,
      itemStyle: {
        color: colorFn(index)
      },
      title: {
        offsetCenter: ['0%', `${index * titleOffsetFromTitle + OFFSETS.titleFromCenter}%`],
        fontSize
      },
      detail: {
        offsetCenter: ['0%', `${index * titleOffsetFromTitle + OFFSETS.titleFromCenter + detailOffsetFromTitle}%`],
        fontSize: FONT_SIZE_MULTIPLIERS.detailFontSize * fontSize
      }
    };

    if (filterState.selectedValues && !filterState.selectedValues.includes(name)) {
      item = { ...item,
        itemStyle: {
          color: colorFn(index),
          opacity: constants/* OpacityEnum.SemiTransparent */.ZV.SemiTransparent
        },
        detail: {
          show: false
        },
        title: {
          show: false
        }
      };
    }

    return item;
  });
  const {
    setDataMask = () => {}
  } = hooks;
  const progress = {
    show: showProgress,
    overlap,
    roundCap,
    width: fontSize
  };
  const splitLine = {
    show: showSplitLine,
    distance: -axisLineWidth - splitLineLength - OFFSETS.ticksFromLine,
    length: splitLineLength,
    lineStyle: {
      width: FONT_SIZE_MULTIPLIERS.splitLineWidth * fontSize,
      color: (_DEFAULT_GAUGE_SERIES = DEFAULT_GAUGE_SERIES_OPTION.splitLine) == null ? void 0 : (_DEFAULT_GAUGE_SERIES2 = _DEFAULT_GAUGE_SERIES.lineStyle) == null ? void 0 : _DEFAULT_GAUGE_SERIES2.color
    }
  };
  const axisLine = {
    roundCap,
    lineStyle: {
      width: axisLineWidth,
      color: (_DEFAULT_GAUGE_SERIES3 = DEFAULT_GAUGE_SERIES_OPTION.axisLine) == null ? void 0 : (_DEFAULT_GAUGE_SERIES4 = _DEFAULT_GAUGE_SERIES3.lineStyle) == null ? void 0 : _DEFAULT_GAUGE_SERIES4.color
    }
  };
  const axisLabel = {
    distance: axisLineWidth - FONT_SIZE_MULTIPLIERS.axisLabelDistance * fontSize * FONT_SIZE_MULTIPLIERS.axisLabelLength * axisLabelLength - (showSplitLine ? splitLineLength : 0) - (showAxisTick ? axisTickLength : 0) - OFFSETS.ticksFromLine,
    fontSize,
    formatter: numberFormatter,
    color: (_DEFAULT_GAUGE_SERIES5 = DEFAULT_GAUGE_SERIES_OPTION.axisLabel) == null ? void 0 : _DEFAULT_GAUGE_SERIES5.color
  };
  const axisTick = {
    show: showAxisTick,
    distance: -axisLineWidth - axisTickLength - OFFSETS.ticksFromLine,
    length: axisTickLength,
    lineStyle: (_DEFAULT_GAUGE_SERIES6 = DEFAULT_GAUGE_SERIES_OPTION.axisTick) == null ? void 0 : _DEFAULT_GAUGE_SERIES6.lineStyle
  };
  const detail = {
    valueAnimation: animation,
    formatter: value => formatValue(value),
    color: (_DEFAULT_GAUGE_SERIES7 = DEFAULT_GAUGE_SERIES_OPTION.detail) == null ? void 0 : _DEFAULT_GAUGE_SERIES7.color
  };
  let pointer;

  if (intervalBoundsAndColors.length) {
    var _INTERVAL_GAUGE_SERIE, _INTERVAL_GAUGE_SERIE2, _INTERVAL_GAUGE_SERIE3, _INTERVAL_GAUGE_SERIE4, _INTERVAL_GAUGE_SERIE5, _INTERVAL_GAUGE_SERIE6;

    splitLine.lineStyle.color = (_INTERVAL_GAUGE_SERIE = INTERVAL_GAUGE_SERIES_OPTION.splitLine) == null ? void 0 : (_INTERVAL_GAUGE_SERIE2 = _INTERVAL_GAUGE_SERIE.lineStyle) == null ? void 0 : _INTERVAL_GAUGE_SERIE2.color;
    axisTick.lineStyle.color = INTERVAL_GAUGE_SERIES_OPTION == null ? void 0 : (_INTERVAL_GAUGE_SERIE3 = INTERVAL_GAUGE_SERIES_OPTION.axisTick) == null ? void 0 : (_INTERVAL_GAUGE_SERIE4 = _INTERVAL_GAUGE_SERIE3.lineStyle) == null ? void 0 : _INTERVAL_GAUGE_SERIE4.color;
    axisLabel.color = (_INTERVAL_GAUGE_SERIE5 = INTERVAL_GAUGE_SERIES_OPTION.axisLabel) == null ? void 0 : _INTERVAL_GAUGE_SERIE5.color;
    axisLine.lineStyle.color = intervalBoundsAndColors;
    pointer = {
      show: showPointer,
      showAbove: false,
      itemStyle: (_INTERVAL_GAUGE_SERIE6 = INTERVAL_GAUGE_SERIES_OPTION.pointer) == null ? void 0 : _INTERVAL_GAUGE_SERIE6.itemStyle
    };
  } else {
    pointer = {
      show: showPointer,
      showAbove: false
    };
  }

  const series = [{
    type: 'gauge',
    startAngle,
    endAngle,
    min: minVal,
    max: maxVal,
    progress,
    animation,
    axisLine: axisLine,
    splitLine,
    splitNumber,
    axisLabel,
    axisTick,
    pointer,
    detail,
    data: transformedData
  }];
  const echartOptions = {
    series
  };
  return {
    formData,
    width,
    height,
    echartOptions,
    setDataMask,
    emitFilter,
    labelMap: Object.fromEntries(columnsLabelMap),
    groupby,
    selectedValues: filterState.selectedValues || []
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Gauge/images/thumbnail.png
var thumbnail = __webpack_require__(17973);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/buildQueryContext.js
var buildQueryContext = __webpack_require__(69205);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Gauge/buildQuery.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function buildQuery(formData) {
  const {
    metric,
    sort_by_metric
  } = formData;
  return (0,buildQueryContext/* default */.Z)(formData, baseQueryObject => [{ ...baseQueryObject,
    groupby: formData.groupby || [],
    ...(sort_by_metric && {
      orderby: [[metric, false]]
    })
  }]);
}
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Gauge/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





class EchartsGaugeChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      buildQuery: buildQuery,
      controlPanel: controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 5660).then(__webpack_require__.bind(__webpack_require__, 35660)),
      metadata: new ChartMetadata/* default */.Z({
        behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
        category: (0,TranslatorSingleton.t)('KPI'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)('Uses a gauge to showcase progress of a metric towards a target. The position of the dial represents the progress and the terminal value in the gauge represents the target value.'),
        name: (0,TranslatorSingleton.t)('Gauge Chart'),
        tags: [(0,TranslatorSingleton.t)('Multi-Variables'), (0,TranslatorSingleton.t)('Business'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('ECharts'), (0,TranslatorSingleton.t)('Report')],
        thumbnail: thumbnail
      }),
      transformProps: transformProps
    });
  }

}

/***/ }),

/***/ 62110:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsGraphChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/types.js
var types = __webpack_require__(94980);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Graph/types.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

const DEFAULT_FORM_DATA = { ...types/* DEFAULT_LEGEND_FORM_DATA */.xo,
  source: '',
  target: '',
  layout: 'force',
  roam: true,
  draggable: false,
  selectedMode: 'single',
  showSymbolThreshold: 0,
  repulsion: 1000,
  gravity: 0.3,
  edgeSymbol: 'none,arrow',
  edgeLength: 400,
  baseEdgeWidth: 3,
  baseNodeSize: 20,
  friction: 0.2,
  legendOrientation: types/* LegendOrientation.Top */.IY.Top,
  legendType: types/* LegendType.Scroll */.HJ.Scroll
};
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/controls.js
var controls = __webpack_require__(22297);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Graph/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const requiredEntity = { ...shared_controls/* sharedControls.entity */.Hq.entity,
  clearable: false
};
const optionalEntity = { ...shared_controls/* sharedControls.entity */.Hq.entity,
  clearable: true,
  validators: []
};
const controlPanel = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[{
      name: 'source',
      config: { ...requiredEntity,
        label: (0,TranslatorSingleton.t)('Source'),
        description: (0,TranslatorSingleton.t)('Name of the source nodes')
      }
    }], [{
      name: 'target',
      config: { ...requiredEntity,
        label: (0,TranslatorSingleton.t)('Target'),
        description: (0,TranslatorSingleton.t)('Name of the target nodes')
      }
    }], ['metric'], [{
      name: 'source_category',
      config: { ...optionalEntity,
        label: (0,TranslatorSingleton.t)('Source category'),
        description: (0,TranslatorSingleton.t)('The category of source nodes used to assign colors. ' + 'If a node is associated with more than one category, only the first will be used.')
      }
    }], [{
      name: 'target_category',
      config: { ...optionalEntity,
        label: (0,TranslatorSingleton.t)('Target category'),
        description: (0,TranslatorSingleton.t)('Category of target nodes')
      }
    }], ['adhoc_filters'], ['row_limit']]
  }, {
    label: (0,TranslatorSingleton.t)('Chart options'),
    expanded: true,
    controlSetRows: [['color_scheme'], ...controls/* legendSection */.q_, [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Layout'))], [{
      name: 'layout',
      config: {
        type: 'RadioButtonControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Graph layout'),
        default: DEFAULT_FORM_DATA.layout,
        options: [['force', (0,TranslatorSingleton.t)('Force')], ['circular', (0,TranslatorSingleton.t)('Circular')]],
        description: (0,TranslatorSingleton.t)('Layout type of graph')
      }
    }], [{
      name: 'edgeSymbol',
      config: {
        type: 'SelectControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Edge symbols'),
        description: (0,TranslatorSingleton.t)('Symbol of two ends of edge line'),
        default: DEFAULT_FORM_DATA.edgeSymbol,
        choices: [['none,none', (0,TranslatorSingleton.t)('None -> None')], ['none,arrow', (0,TranslatorSingleton.t)('None -> Arrow')], ['circle,arrow', (0,TranslatorSingleton.t)('Circle -> Arrow')], ['circle,circle', (0,TranslatorSingleton.t)('Circle -> Circle')]]
      }
    }], [{
      name: 'draggable',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Enable node dragging'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.draggable,
        description: (0,TranslatorSingleton.t)('Whether to enable node dragging in force layout mode.'),

        visibility({
          form_data: {
            layout
          }
        }) {
          return layout === 'force' || !layout && DEFAULT_FORM_DATA.layout === 'force';
        }

      }
    }], [{
      name: 'roam',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Enable graph roaming'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.roam,
        choices: [[false, (0,TranslatorSingleton.t)('Disabled')], ['scale', (0,TranslatorSingleton.t)('Scale only')], ['move', (0,TranslatorSingleton.t)('Move only')], [true, (0,TranslatorSingleton.t)('Scale and Move')]],
        description: (0,TranslatorSingleton.t)('Whether to enable changing graph position and scaling.')
      }
    }], [{
      name: 'selectedMode',
      config: {
        type: 'SelectControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Node select mode'),
        default: DEFAULT_FORM_DATA.selectedMode,
        choices: [[false, (0,TranslatorSingleton.t)('Disabled')], ['single', (0,TranslatorSingleton.t)('Single')], ['multiple', (0,TranslatorSingleton.t)('Multiple')]],
        description: (0,TranslatorSingleton.t)('Allow node selections')
      }
    }], [{
      name: 'showSymbolThreshold',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Label threshold'),
        renderTrigger: true,
        isInt: true,
        default: DEFAULT_FORM_DATA.showSymbolThreshold,
        description: (0,TranslatorSingleton.t)('Minimum value for label to be displayed on graph.')
      }
    }], [{
      name: 'baseNodeSize',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Node size'),
        renderTrigger: true,
        isFloat: true,
        default: DEFAULT_FORM_DATA.baseNodeSize,
        description: (0,TranslatorSingleton.t)('Median node size, the largest node will be 4 times larger than the smallest')
      }
    }, {
      name: 'baseEdgeWidth',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Edge width'),
        renderTrigger: true,
        isFloat: true,
        default: DEFAULT_FORM_DATA.baseEdgeWidth,
        description: (0,TranslatorSingleton.t)('Median edge width, the thickest edge will be 4 times thicker than the thinnest.')
      }
    }], [{
      name: 'edgeLength',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Edge length'),
        renderTrigger: true,
        min: 100,
        max: 1000,
        step: 50,
        default: DEFAULT_FORM_DATA.edgeLength,
        description: (0,TranslatorSingleton.t)('Edge length between nodes'),

        visibility({
          form_data: {
            layout
          }
        }) {
          return layout === 'force' || !layout && DEFAULT_FORM_DATA.layout === 'force';
        }

      }
    }], [{
      name: 'gravity',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Gravity'),
        renderTrigger: true,
        min: 0.1,
        max: 1,
        step: 0.1,
        default: DEFAULT_FORM_DATA.gravity,
        description: (0,TranslatorSingleton.t)('Strength to pull the graph toward center'),

        visibility({
          form_data: {
            layout
          }
        }) {
          return layout === 'force' || !layout && DEFAULT_FORM_DATA.layout === 'force';
        }

      }
    }], [{
      name: 'repulsion',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Repulsion'),
        renderTrigger: true,
        min: 100,
        max: 3000,
        step: 50,
        default: DEFAULT_FORM_DATA.repulsion,
        description: (0,TranslatorSingleton.t)('Repulsion strength between nodes'),

        visibility({
          form_data: {
            layout
          }
        }) {
          return layout === 'force' || !layout && DEFAULT_FORM_DATA.layout === 'force';
        }

      }
    }], [{
      name: 'friction',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Friction'),
        renderTrigger: true,
        min: 0.1,
        max: 1,
        step: 0.1,
        default: DEFAULT_FORM_DATA.friction,
        description: (0,TranslatorSingleton.t)('Friction between nodes'),

        visibility({
          form_data: {
            layout
          }
        }) {
          return layout === 'force' || !layout && DEFAULT_FORM_DATA.layout === 'force';
        }

      }
    }]]
  }]
};
/* harmony default export */ const Graph_controlPanel = (controlPanel);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/getMetricLabel.js
var getMetricLabel = __webpack_require__(95669);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/color/CategoricalColorNamespace.js
var CategoricalColorNamespace = __webpack_require__(83527);
// EXTERNAL MODULE: ./node_modules/d3-array/src/index.js + 31 modules
var src = __webpack_require__(4065);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Graph/constants.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const DEFAULT_GRAPH_SERIES_OPTION = {
  zoom: 0.7,
  circular: {
    rotateLabel: true
  },
  force: {
    initLayout: 'circular',
    layoutAnimation: true
  },
  label: {
    show: true,
    position: 'right',
    distance: 5,
    rotate: 0,
    offset: [0, 0],
    fontStyle: 'normal',
    fontWeight: 'normal',
    fontFamily: 'sans-serif',
    fontSize: 12,
    padding: [0, 0, 0, 0],
    overflow: 'truncate',
    formatter: '{b}'
  },
  emphasis: {
    focus: 'adjacency'
  },
  animation: true,
  animationDuration: 500,
  animationEasing: 'cubicOut',
  lineStyle: {
    color: 'source',
    curveness: 0.1
  },
  select: {
    itemStyle: {
      borderWidth: 3,
      opacity: 1
    },
    label: {
      fontWeight: 'bolder'
    }
  },
  // Ref: https://echarts.apache.org/en/option.html#series-graph.data.tooltip.formatter
  //   - b: data name
  //   - c: data value
  tooltip: {
    formatter: '{b}: {c}'
  }
};
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/utils/series.js
var utils_series = __webpack_require__(66978);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Graph/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






function verifyEdgeSymbol(symbol) {
  if (symbol === 'none' || symbol === 'circle' || symbol === 'arrow') {
    return symbol;
  }

  return 'none';
}

function parseEdgeSymbol(symbols) {
  const [start, end] = (symbols || '').split(',');
  return [verifyEdgeSymbol(start), verifyEdgeSymbol(end)];
}
/**
 * Emphasized edge width with a min and max.
 */


function getEmphasizedEdgeWidth(width) {
  return Math.max(5, Math.min(width * 2, 20));
}
/**
 * Normalize node size, edge width, and apply label visibility thresholds.
 */


function normalizeStyles(nodes, links, {
  baseNodeSize,
  baseEdgeWidth,
  showSymbolThreshold
}) {
  const minNodeSize = baseNodeSize * 0.5;
  const maxNodeSize = baseNodeSize * 2;
  const minEdgeWidth = baseEdgeWidth * 0.5;
  const maxEdgeWidth = baseEdgeWidth * 2;
  const [nodeMinValue, nodeMaxValue] = (0,src.extent)(nodes, x => x.value);
  const nodeSpread = nodeMaxValue - nodeMinValue;
  nodes.forEach(node => {
    // eslint-disable-next-line no-param-reassign
    node.symbolSize = ((node.value - nodeMinValue) / nodeSpread * maxNodeSize || 0) + minNodeSize; // eslint-disable-next-line no-param-reassign

    node.label = { ...node.label,
      show: showSymbolThreshold ? node.value > showSymbolThreshold : true
    };
  });
  const [linkMinValue, linkMaxValue] = (0,src.extent)(links, x => x.value);
  const linkSpread = linkMaxValue - linkMinValue;
  links.forEach(link => {
    const lineWidth = (link.value - linkMinValue) / linkSpread * maxEdgeWidth || 0 + minEdgeWidth; // eslint-disable-next-line no-param-reassign

    link.lineStyle.width = lineWidth; // eslint-disable-next-line no-param-reassign

    link.emphasis.lineStyle = { ...link.emphasis.lineStyle,
      width: getEmphasizedEdgeWidth(lineWidth)
    }; // eslint-disable-next-line no-param-reassign

    link.select.lineStyle = { ...link.select.lineStyle,
      width: getEmphasizedEdgeWidth(lineWidth * 0.8),
      opacity: 1
    };
  });
}

function getKeyByValue(object, value) {
  return Object.keys(object).find(key => object[key] === value);
}

function edgeFormatter(sourceIndex, targetIndex, value, nodes) {
  const source = Number(sourceIndex);
  const target = Number(targetIndex);
  return `${(0,utils_series/* sanitizeHtml */.Z6)(getKeyByValue(nodes, source))} > ${(0,utils_series/* sanitizeHtml */.Z6)(getKeyByValue(nodes, target))} : ${value}`;
}

function getCategoryName(columnName, name) {
  if (name === false) {
    return `${columnName}: false`;
  }

  if (name === true) {
    return `${columnName}: true`;
  }

  if (name == null) {
    return 'N/A';
  }

  return String(name);
}

function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData
  } = chartProps;
  const data = queriesData[0].data || [];
  const {
    source,
    target,
    sourceCategory,
    targetCategory,
    colorScheme,
    metric = '',
    layout,
    roam,
    draggable,
    selectedMode,
    showSymbolThreshold,
    edgeLength,
    gravity,
    repulsion,
    friction,
    legendMargin,
    legendOrientation,
    legendType,
    showLegend,
    baseEdgeWidth,
    baseNodeSize,
    edgeSymbol
  } = { ...DEFAULT_FORM_DATA,
    ...formData
  };
  const metricLabel = (0,getMetricLabel/* default */.Z)(metric);
  const colorFn = CategoricalColorNamespace.getScale(colorScheme);
  const nodes = {};
  const categories = new Set();
  const echartNodes = [];
  const echartLinks = [];
  /**
   * Get the node id of an existing node,
   * or create a new node if it doesn't exist.
   */

  function getOrCreateNode(name, category) {
    if (!(name in nodes)) {
      nodes[name] = echartNodes.length;
      echartNodes.push({
        id: String(nodes[name]),
        name,
        value: 0,
        category,
        select: DEFAULT_GRAPH_SERIES_OPTION.select,
        tooltip: DEFAULT_GRAPH_SERIES_OPTION.tooltip
      });
    }

    const node = echartNodes[nodes[name]];

    if (category) {
      categories.add(category); // category may be empty when one of `sourceCategory`
      // or `targetCategory` is not set.

      if (!node.category) {
        node.category = category;
      }
    }

    return node;
  }

  data.forEach(link => {
    const value = link[metricLabel];

    if (!value) {
      return;
    }

    const sourceName = link[source];
    const targetName = link[target];
    const sourceCategoryName = sourceCategory ? getCategoryName(sourceCategory, link[sourceCategory]) : undefined;
    const targetCategoryName = targetCategory ? getCategoryName(targetCategory, link[targetCategory]) : undefined;
    const sourceNode = getOrCreateNode(sourceName, sourceCategoryName);
    const targetNode = getOrCreateNode(targetName, targetCategoryName);
    sourceNode.value += value;
    targetNode.value += value;
    echartLinks.push({
      source: sourceNode.id,
      target: targetNode.id,
      value,
      lineStyle: {},
      emphasis: {},
      select: {}
    });
  });
  normalizeStyles(echartNodes, echartLinks, {
    showSymbolThreshold,
    baseEdgeWidth,
    baseNodeSize
  });
  const categoryList = [...categories];
  const series = [{
    zoom: DEFAULT_GRAPH_SERIES_OPTION.zoom,
    type: 'graph',
    categories: categoryList.map(c => ({
      name: c,
      itemStyle: {
        color: colorFn(c)
      }
    })),
    layout,
    force: { ...DEFAULT_GRAPH_SERIES_OPTION.force,
      edgeLength,
      gravity,
      repulsion,
      friction
    },
    circular: DEFAULT_GRAPH_SERIES_OPTION.circular,
    data: echartNodes,
    links: echartLinks,
    roam,
    draggable,
    edgeSymbol: parseEdgeSymbol(edgeSymbol),
    edgeSymbolSize: baseEdgeWidth * 2,
    selectedMode,
    ...(0,utils_series/* getChartPadding */.G_)(showLegend, legendOrientation, legendMargin),
    animation: DEFAULT_GRAPH_SERIES_OPTION.animation,
    label: DEFAULT_GRAPH_SERIES_OPTION.label,
    lineStyle: DEFAULT_GRAPH_SERIES_OPTION.lineStyle,
    emphasis: DEFAULT_GRAPH_SERIES_OPTION.emphasis
  }];
  const echartOptions = {
    animationDuration: DEFAULT_GRAPH_SERIES_OPTION.animationDuration,
    animationEasing: DEFAULT_GRAPH_SERIES_OPTION.animationEasing,
    tooltip: {
      formatter: params => edgeFormatter(params.data.source, params.data.target, params.value, nodes)
    },
    legend: { ...(0,utils_series/* getLegendProps */.zp)(legendType, legendOrientation, showLegend),
      data: categoryList
    },
    series
  };
  return {
    width,
    height,
    echartOptions
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Graph/images/thumbnail.png
var thumbnail = __webpack_require__(16546);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/buildQueryContext.js
var buildQueryContext = __webpack_require__(69205);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Graph/buildQuery.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function buildQuery(formData) {
  return (0,buildQueryContext/* default */.Z)(formData, {
    queryFields: {
      source: 'columns',
      target: 'columns',
      source_category: 'columns',
      target_category: 'columns'
    }
  });
}
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Graph/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





class EchartsGraphChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      buildQuery: buildQuery,
      controlPanel: Graph_controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 4295).then(__webpack_require__.bind(__webpack_require__, 24295)),
      metadata: new ChartMetadata/* default */.Z({
        category: (0,TranslatorSingleton.t)('Flow'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)('Displays connections between entities in a graph structure. Useful for mapping relationships and showing which nodes are important in a network. Graph charts can be configured to be force-directed or circulate. If your data has a geospatial component, try the deck.gl Arc chart.'),
        name: (0,TranslatorSingleton.t)('Graph Chart'),
        tags: [(0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Circular'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Directional'), (0,TranslatorSingleton.t)('ECharts'), (0,TranslatorSingleton.t)('Relational'), (0,TranslatorSingleton.t)('Structural'), (0,TranslatorSingleton.t)('Transformable')],
        thumbnail: thumbnail
      }),
      transformProps: transformProps
    });
  }

}

/***/ }),

/***/ 84946:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsTimeseriesChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/types/AnnotationLayer.js
var AnnotationLayer = __webpack_require__(33484);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/buildQueryContext.js
var buildQueryContext = __webpack_require__(69205);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/normalizeOrderBy.js
var normalizeOrderBy = __webpack_require__(77249);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/operators/pivotOperator.js
var pivotOperator = __webpack_require__(19751);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/MixedTimeseries/buildQuery.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


function buildQuery(formData) {
  const {
    adhoc_filters,
    adhoc_filters_b,
    groupby,
    groupby_b,
    limit,
    limit_b,
    timeseries_limit_metric,
    timeseries_limit_metric_b,
    metrics,
    metrics_b,
    order_desc,
    order_desc_b,
    ...baseFormData
  } = formData;
  baseFormData.is_timeseries = true;
  const formData1 = { ...baseFormData,
    adhoc_filters,
    columns: groupby,
    limit,
    timeseries_limit_metric,
    metrics,
    order_desc
  };
  const formData2 = { ...baseFormData,
    adhoc_filters: adhoc_filters_b,
    columns: groupby_b,
    limit: limit_b,
    timeseries_limit_metric: timeseries_limit_metric_b,
    metrics: metrics_b,
    order_desc: order_desc_b
  };
  const queryContextA = (0,buildQueryContext/* default */.Z)(formData1, baseQueryObject => {
    const queryObjectA = { ...baseQueryObject,
      is_timeseries: true,
      post_processing: [(0,pivotOperator/* pivotOperator */.H)(formData1, { ...baseQueryObject,
        is_timeseries: true
      })]
    };
    return [(0,normalizeOrderBy/* default */.Z)(queryObjectA)];
  });
  const queryContextB = (0,buildQueryContext/* default */.Z)(formData2, baseQueryObject => {
    const queryObjectB = { ...baseQueryObject,
      is_timeseries: true,
      post_processing: [(0,pivotOperator/* pivotOperator */.H)(formData2, { ...baseQueryObject,
        is_timeseries: true
      })]
    };
    return [(0,normalizeOrderBy/* default */.Z)(queryObjectB)];
  });
  return { ...queryContextA,
    queries: [...queryContextA.queries, ...queryContextB.queries]
  };
}
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/types.js
var types = __webpack_require__(94980);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/types.js
var Timeseries_types = __webpack_require__(36913);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/MixedTimeseries/types.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


// @ts-ignore
const DEFAULT_FORM_DATA = { ...types/* DEFAULT_LEGEND_FORM_DATA */.xo,
  annotationLayers: [],
  minorSplitLine: Timeseries_types/* DEFAULT_FORM_DATA.minorSplitLine */.En.minorSplitLine,
  truncateYAxis: Timeseries_types/* DEFAULT_FORM_DATA.truncateYAxis */.En.truncateYAxis,
  truncateYAxisSecondary: Timeseries_types/* DEFAULT_FORM_DATA.truncateYAxis */.En.truncateYAxis,
  logAxis: Timeseries_types/* DEFAULT_FORM_DATA.logAxis */.En.logAxis,
  logAxisSecondary: Timeseries_types/* DEFAULT_FORM_DATA.logAxis */.En.logAxis,
  yAxisBounds: Timeseries_types/* DEFAULT_FORM_DATA.yAxisBounds */.En.yAxisBounds,
  yAxisBoundsSecondary: Timeseries_types/* DEFAULT_FORM_DATA.yAxisBounds */.En.yAxisBounds,
  yAxisFormat: Timeseries_types/* DEFAULT_FORM_DATA.yAxisFormat */.En.yAxisFormat,
  yAxisFormatSecondary: Timeseries_types/* DEFAULT_FORM_DATA.yAxisFormat */.En.yAxisFormat,
  yAxisTitleSecondary: types/* DEFAULT_TITLE_FORM_DATA.yAxisTitle */.f6.yAxisTitle,
  tooltipTimeFormat: Timeseries_types/* DEFAULT_FORM_DATA.tooltipTimeFormat */.En.tooltipTimeFormat,
  xAxisTimeFormat: Timeseries_types/* DEFAULT_FORM_DATA.xAxisTimeFormat */.En.xAxisTimeFormat,
  area: Timeseries_types/* DEFAULT_FORM_DATA.area */.En.area,
  areaB: Timeseries_types/* DEFAULT_FORM_DATA.area */.En.area,
  markerEnabled: Timeseries_types/* DEFAULT_FORM_DATA.markerEnabled */.En.markerEnabled,
  markerEnabledB: Timeseries_types/* DEFAULT_FORM_DATA.markerEnabled */.En.markerEnabled,
  markerSize: Timeseries_types/* DEFAULT_FORM_DATA.markerSize */.En.markerSize,
  markerSizeB: Timeseries_types/* DEFAULT_FORM_DATA.markerSize */.En.markerSize,
  opacity: Timeseries_types/* DEFAULT_FORM_DATA.opacity */.En.opacity,
  opacityB: Timeseries_types/* DEFAULT_FORM_DATA.opacity */.En.opacity,
  orderDesc: Timeseries_types/* DEFAULT_FORM_DATA.orderDesc */.En.orderDesc,
  orderDescB: Timeseries_types/* DEFAULT_FORM_DATA.orderDesc */.En.orderDesc,
  rowLimit: Timeseries_types/* DEFAULT_FORM_DATA.rowLimit */.En.rowLimit,
  rowLimitB: Timeseries_types/* DEFAULT_FORM_DATA.rowLimit */.En.rowLimit,
  seriesType: Timeseries_types/* DEFAULT_FORM_DATA.seriesType */.En.seriesType,
  seriesTypeB: Timeseries_types/* DEFAULT_FORM_DATA.seriesType */.En.seriesType,
  showValue: Timeseries_types/* DEFAULT_FORM_DATA.showValue */.En.showValue,
  showValueB: Timeseries_types/* DEFAULT_FORM_DATA.showValue */.En.showValue,
  stack: Timeseries_types/* DEFAULT_FORM_DATA.stack */.En.stack,
  stackB: Timeseries_types/* DEFAULT_FORM_DATA.stack */.En.stack,
  yAxisIndex: 0,
  yAxisIndexB: 0,
  groupby: [],
  groupbyB: [],
  zoomable: Timeseries_types/* DEFAULT_FORM_DATA.zoomable */.En.zoomable,
  richTooltip: Timeseries_types/* DEFAULT_FORM_DATA.richTooltip */.En.richTooltip,
  xAxisLabelRotation: Timeseries_types/* DEFAULT_FORM_DATA.xAxisLabelRotation */.En.xAxisLabelRotation,
  ...types/* DEFAULT_TITLE_FORM_DATA */.f6
};
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/controls.js
var controls = __webpack_require__(22297);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/MixedTimeseries/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */







const {
  area: controlPanel_area,
  annotationLayers,
  logAxis,
  markerEnabled,
  markerSize,
  minorSplitLine,
  opacity,
  orderDesc,
  rowLimit,
  seriesType,
  showValues,
  stack,
  truncateYAxis,
  yAxisBounds,
  zoomable,
  xAxisLabelRotation,
  yAxisIndex
} = DEFAULT_FORM_DATA;

function createQuerySection(label, controlSuffix) {
  return {
    label,
    expanded: true,
    controlSetRows: [[{
      name: `metrics${controlSuffix}`,
      config: shared_controls/* sharedControls.metrics */.Hq.metrics
    }], [{
      name: `groupby${controlSuffix}`,
      config: shared_controls/* sharedControls.groupby */.Hq.groupby
    }], [{
      name: `adhoc_filters${controlSuffix}`,
      config: shared_controls/* sharedControls.adhoc_filters */.Hq.adhoc_filters
    }], emitFilterControl/* emitFilterControl.length */.a.length > 0 ? [{ ...emitFilterControl/* emitFilterControl.0 */.a[0],
      name: `emit_filter${controlSuffix}`
    }] : [], [{
      name: `limit${controlSuffix}`,
      config: shared_controls/* sharedControls.limit */.Hq.limit
    }], [{
      name: `timeseries_limit_metric${controlSuffix}`,
      config: shared_controls/* sharedControls.timeseries_limit_metric */.Hq.timeseries_limit_metric
    }], [{
      name: `order_desc${controlSuffix}`,
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: orderDesc,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }], [{
      name: `row_limit${controlSuffix}`,
      config: { ...shared_controls/* sharedControls.row_limit */.Hq.row_limit,
        default: rowLimit
      }
    }]]
  };
}

function createCustomizeSection(label, controlSuffix) {
  return [[(0,emotion_react_browser_esm.jsx)("h1", {
    className: "section-header"
  }, label)], [{
    name: `seriesType${controlSuffix}`,
    config: {
      type: 'SelectControl',
      label: (0,TranslatorSingleton.t)('Series type'),
      renderTrigger: true,
      default: seriesType,
      choices: [[Timeseries_types/* EchartsTimeseriesSeriesType.Line */.mD.Line, 'Line'], [Timeseries_types/* EchartsTimeseriesSeriesType.Scatter */.mD.Scatter, 'Scatter'], [Timeseries_types/* EchartsTimeseriesSeriesType.Smooth */.mD.Smooth, 'Smooth Line'], [Timeseries_types/* EchartsTimeseriesSeriesType.Bar */.mD.Bar, 'Bar'], [Timeseries_types/* EchartsTimeseriesSeriesType.Start */.mD.Start, 'Step - start'], [Timeseries_types/* EchartsTimeseriesSeriesType.Middle */.mD.Middle, 'Step - middle'], [Timeseries_types/* EchartsTimeseriesSeriesType.End */.mD.End, 'Step - end']],
      description: (0,TranslatorSingleton.t)('Series chart type (line, bar etc)')
    }
  }], [{
    name: `stack${controlSuffix}`,
    config: {
      type: 'CheckboxControl',
      label: (0,TranslatorSingleton.t)('Stack series'),
      renderTrigger: true,
      default: stack,
      description: (0,TranslatorSingleton.t)('Stack series on top of each other')
    }
  }], [{
    name: `area${controlSuffix}`,
    config: {
      type: 'CheckboxControl',
      label: (0,TranslatorSingleton.t)('Area chart'),
      renderTrigger: true,
      default: controlPanel_area,
      description: (0,TranslatorSingleton.t)('Draw area under curves. Only applicable for line types.')
    }
  }], [{
    name: `show_value${controlSuffix}`,
    config: {
      type: 'CheckboxControl',
      label: (0,TranslatorSingleton.t)('Show Values'),
      renderTrigger: true,
      default: showValues,
      description: (0,TranslatorSingleton.t)('Whether to display the numerical values within the cells')
    }
  }], [{
    name: `opacity${controlSuffix}`,
    config: {
      type: 'SliderControl',
      label: (0,TranslatorSingleton.t)('Opacity'),
      renderTrigger: true,
      min: 0,
      max: 1,
      step: 0.1,
      default: opacity,
      description: (0,TranslatorSingleton.t)('Opacity of area chart.')
    }
  }], [{
    name: `markerEnabled${controlSuffix}`,
    config: {
      type: 'CheckboxControl',
      label: (0,TranslatorSingleton.t)('Marker'),
      renderTrigger: true,
      default: markerEnabled,
      description: (0,TranslatorSingleton.t)('Draw a marker on data points. Only applicable for line types.')
    }
  }], [{
    name: `markerSize${controlSuffix}`,
    config: {
      type: 'SliderControl',
      label: (0,TranslatorSingleton.t)('Marker size'),
      renderTrigger: true,
      min: 0,
      max: 100,
      default: markerSize,
      description: (0,TranslatorSingleton.t)('Size of marker. Also applies to forecast observations.')
    }
  }], [{
    name: `yAxisIndex${controlSuffix}`,
    config: {
      type: 'SelectControl',
      label: (0,TranslatorSingleton.t)('Y Axis'),
      choices: [[0, (0,TranslatorSingleton.t)('Primary')], [1, (0,TranslatorSingleton.t)('Secondary')]],
      default: yAxisIndex,
      renderTrigger: true,
      description: (0,TranslatorSingleton.t)('Primary or secondary y-axis')
    }
  }]];
}

const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, createQuerySection((0,TranslatorSingleton.t)('Query A'), ''), createQuerySection((0,TranslatorSingleton.t)('Query B'), '_b'), {
    label: (0,TranslatorSingleton.t)('Annotations and Layers'),
    expanded: false,
    controlSetRows: [[{
      name: 'annotation_layers',
      config: {
        type: 'AnnotationLayerControl',
        label: '',
        default: annotationLayers,
        description: (0,TranslatorSingleton.t)('Annotation Layers')
      }
    }]]
  }, esm.sections.titleControls, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], ...createCustomizeSection((0,TranslatorSingleton.t)('Query A'), ''), ...createCustomizeSection((0,TranslatorSingleton.t)('Query B'), 'B'), [{
      name: 'zoomable',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Data Zoom'),
        default: zoomable,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Enable data zooming controls')
      }
    }], ...controls/* legendSection */.q_, [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('X Axis'))], ['x_axis_time_format'], [{
      name: 'xAxisLabelRotation',
      config: {
        type: 'SelectControl',
        freeForm: true,
        clearable: false,
        label: (0,TranslatorSingleton.t)('Rotate x axis label'),
        choices: [[0, '0°'], [45, '45°']],
        default: xAxisLabelRotation,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Input field supports custom rotation. e.g. 30 for 30°')
      }
    }], ...controls/* richTooltipSection */.oA, // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Y Axis'))], [{
      name: 'minorSplitLine',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Minor Split Line'),
        renderTrigger: true,
        default: minorSplitLine,
        description: (0,TranslatorSingleton.t)('Draw split lines for minor y-axis ticks')
      }
    }], [{
      name: 'truncateYAxis',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Truncate Y Axis'),
        default: truncateYAxis,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Truncate Y Axis. Can be overridden by specifying a min or max bound.')
      }
    }], [{
      name: 'y_axis_bounds',
      config: {
        type: 'BoundsControl',
        label: (0,TranslatorSingleton.t)('Y Axis Bounds'),
        renderTrigger: true,
        default: yAxisBounds,
        description: (0,TranslatorSingleton.t)('Bounds for the Y-axis. When left empty, the bounds are ' + 'dynamically defined based on the min/max of the data. Note that ' + "this feature will only expand the axis range. It won't " + "narrow the data's extent.")
      }
    }], [{
      name: `y_axis_format`,
      config: { ...shared_controls/* sharedControls.y_axis_format */.Hq.y_axis_format,
        label: (0,TranslatorSingleton.t)('Primary y-axis format')
      }
    }], [{
      name: 'logAxis',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Logarithmic y-axis'),
        renderTrigger: true,
        default: logAxis,
        description: (0,TranslatorSingleton.t)('Logarithmic scale on primary y-axis')
      }
    }], [{
      name: `y_axis_format_secondary`,
      config: { ...shared_controls/* sharedControls.y_axis_format */.Hq.y_axis_format,
        label: (0,TranslatorSingleton.t)('Secondary y-axis format')
      }
    }], [{
      name: 'yAxisTitleSecondary',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Secondary y-axis title'),
        renderTrigger: true,
        default: '',
        description: (0,TranslatorSingleton.t)('Logarithmic y-axis')
      }
    }], [{
      name: 'logAxisSecondary',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Logarithmic y-axis'),
        renderTrigger: true,
        default: logAxis,
        description: (0,TranslatorSingleton.t)('Logarithmic scale on secondary y-axis')
      }
    }]]
  }]
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/color/CategoricalColorNamespace.js
var CategoricalColorNamespace = __webpack_require__(83527);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormatterRegistrySingleton.js
var NumberFormatterRegistrySingleton = __webpack_require__(50855);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/utils/controls.js
var utils_controls = __webpack_require__(26091);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/utils/series.js
var utils_series = __webpack_require__(66978);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/utils/annotation.js
var annotation = __webpack_require__(56008);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/utils/prophet.js
var prophet = __webpack_require__(50327);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/defaults.js
var defaults = __webpack_require__(97711);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/transformers.js
var transformers = __webpack_require__(72585);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/constants.js
var constants = __webpack_require__(23788);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/MixedTimeseries/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/* eslint-disable camelcase */










function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData,
    hooks,
    filterState
  } = chartProps;
  const {
    annotation_data: annotationData_
  } = queriesData[0];
  const annotationData = annotationData_ || {};
  const data1 = queriesData[0].data || [];
  const data2 = queriesData[1].data || [];
  const {
    area,
    areaB,
    annotationLayers,
    colorScheme,
    contributionMode,
    legendOrientation,
    legendType,
    logAxis,
    logAxisSecondary,
    markerEnabled,
    markerEnabledB,
    markerSize,
    markerSizeB,
    opacity,
    opacityB,
    minorSplitLine,
    seriesType,
    seriesTypeB,
    showLegend,
    showValue,
    showValueB,
    stack,
    stackB,
    truncateYAxis,
    tooltipTimeFormat,
    yAxisFormat,
    yAxisFormatSecondary,
    xAxisTimeFormat,
    yAxisBounds,
    yAxisIndex,
    yAxisIndexB,
    yAxisTitleSecondary,
    zoomable,
    richTooltip,
    tooltipSortByMetric,
    xAxisLabelRotation,
    groupby,
    groupbyB,
    emitFilter,
    emitFilterB,
    xAxisTitle,
    yAxisTitle,
    xAxisTitleMargin,
    yAxisTitleMargin,
    yAxisTitlePosition
  } = { ...DEFAULT_FORM_DATA,
    ...formData
  };
  const colorScale = CategoricalColorNamespace.getScale(colorScheme);
  const rawSeriesA = (0,utils_series/* extractTimeseriesSeries */.vT)((0,prophet/* rebaseTimeseriesDatum */.Hc)(data1), {
    fillNeighborValue: stack ? 0 : undefined
  });
  const rawSeriesB = (0,utils_series/* extractTimeseriesSeries */.vT)((0,prophet/* rebaseTimeseriesDatum */.Hc)(data2), {
    fillNeighborValue: stackB ? 0 : undefined
  });
  const series = [];
  const formatter = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(contributionMode ? ',.0%' : yAxisFormat);
  const formatterSecondary = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(contributionMode ? ',.0%' : yAxisFormatSecondary);
  const primarySeries = new Set();
  const secondarySeries = new Set();

  const mapSeriesIdToAxis = (seriesOption, index) => {
    if (index === 1) {
      secondarySeries.add(seriesOption.id);
    } else {
      primarySeries.add(seriesOption.id);
    }
  };

  rawSeriesA.forEach(seriesOption => mapSeriesIdToAxis(seriesOption, yAxisIndex));
  rawSeriesB.forEach(seriesOption => mapSeriesIdToAxis(seriesOption, yAxisIndexB));
  rawSeriesA.forEach(entry => {
    const transformedSeries = (0,transformers/* transformSeries */.FN)(entry, colorScale, {
      area,
      markerEnabled,
      markerSize,
      areaOpacity: opacity,
      seriesType,
      showValue,
      stack,
      yAxisIndex,
      filterState
    });
    if (transformedSeries) series.push(transformedSeries);
  });
  rawSeriesB.forEach(entry => {
    const transformedSeries = (0,transformers/* transformSeries */.FN)(entry, colorScale, {
      area: areaB,
      markerEnabled: markerEnabledB,
      markerSize: markerSizeB,
      areaOpacity: opacityB,
      seriesType: seriesTypeB,
      showValue: showValueB,
      stack: stackB,
      yAxisIndex: yAxisIndexB,
      filterState
    });
    if (transformedSeries) series.push(transformedSeries);
  });
  annotationLayers.filter(layer => layer.show).forEach(layer => {
    if ((0,AnnotationLayer/* isFormulaAnnotationLayer */.x5)(layer)) series.push((0,transformers/* transformFormulaAnnotation */._d)(layer, data1, colorScale));else if ((0,AnnotationLayer/* isIntervalAnnotationLayer */.Ry)(layer)) {
      series.push(...(0,transformers/* transformIntervalAnnotation */.kK)(layer, data1, annotationData, colorScale));
    } else if ((0,AnnotationLayer/* isEventAnnotationLayer */.pD)(layer)) {
      series.push(...(0,transformers/* transformEventAnnotation */.r)(layer, data1, annotationData, colorScale));
    } else if ((0,AnnotationLayer/* isTimeseriesAnnotationLayer */.nl)(layer)) {
      series.push(...(0,transformers/* transformTimeseriesAnnotation */.rR)(layer, markerSize, data1, annotationData));
    }
  }); // yAxisBounds need to be parsed to replace incompatible values with undefined

  let [min, max] = (yAxisBounds || []).map(utils_controls/* parseYAxisBound */.p); // default to 0-100% range when doing row-level contribution chart

  if (contributionMode === 'row' && stack) {
    if (min === undefined) min = 0;
    if (max === undefined) max = 1;
  }

  const tooltipTimeFormatter = (0,transformers/* getTooltipTimeFormatter */.hq)(tooltipTimeFormat);
  const xAxisFormatter = (0,transformers/* getXAxisFormatter */.pc)(xAxisTimeFormat);
  const addYAxisTitleOffset = !!(yAxisTitle || yAxisTitleSecondary);
  const addXAxisTitleOffset = !!xAxisTitle;
  const chartPadding = (0,transformers/* getPadding */.tQ)(showLegend, legendOrientation, addYAxisTitleOffset, zoomable, null, addXAxisTitleOffset, yAxisTitlePosition, yAxisTitleMargin, xAxisTitleMargin);
  const labelMap = rawSeriesA.reduce((acc, datum) => {
    const label = datum.name;
    return { ...acc,
      [label]: label.split(', ')
    };
  }, {});
  const labelMapB = rawSeriesB.reduce((acc, datum) => {
    const label = datum.name;
    return { ...acc,
      [label]: label.split(', ')
    };
  }, {});
  const {
    setDataMask = () => {}
  } = hooks;
  const echartOptions = {
    useUTC: true,
    grid: { ...defaults/* defaultGrid */.oe,
      ...chartPadding
    },
    xAxis: {
      type: 'time',
      name: xAxisTitle,
      nameGap: xAxisTitleMargin,
      nameLocation: 'middle',
      axisLabel: {
        formatter: xAxisFormatter,
        rotate: xAxisLabelRotation
      }
    },
    yAxis: [{ ...defaults/* defaultYAxis */.C0,
      type: logAxis ? 'log' : 'value',
      min,
      max,
      minorTick: {
        show: true
      },
      minorSplitLine: {
        show: minorSplitLine
      },
      axisLabel: {
        formatter
      },
      scale: truncateYAxis,
      name: yAxisTitle,
      nameGap: yAxisTitleMargin,
      nameLocation: yAxisTitlePosition === 'Left' ? 'middle' : 'end'
    }, { ...defaults/* defaultYAxis */.C0,
      type: logAxisSecondary ? 'log' : 'value',
      min,
      max,
      minorTick: {
        show: true
      },
      splitLine: {
        show: false
      },
      minorSplitLine: {
        show: minorSplitLine
      },
      axisLabel: {
        formatter: formatterSecondary
      },
      scale: truncateYAxis,
      name: yAxisTitleSecondary
    }],
    tooltip: { ...defaults/* defaultTooltip */.Ku,
      appendToBody: true,
      trigger: richTooltip ? 'axis' : 'item',
      formatter: params => {
        const xValue = richTooltip ? params[0].value[0] : params.value[0];
        const prophetValue = richTooltip ? params : [params];

        if (richTooltip && tooltipSortByMetric) {
          prophetValue.sort((a, b) => b.data[1] - a.data[1]);
        }

        const rows = [`${tooltipTimeFormatter(xValue)}`];
        const prophetValues = (0,prophet/* extractProphetValuesFromTooltipParams */.LQ)(prophetValue);
        Object.keys(prophetValues).forEach(key => {
          const value = prophetValues[key];
          const content = (0,prophet/* formatProphetTooltipSeries */.Ft)({ ...value,
            seriesName: key,
            formatter: primarySeries.has(key) ? formatter : formatterSecondary
          });

          if (utils_series/* currentSeries.name */.aI.name === key) {
            rows.push(`<span style="font-weight: 700">${content}</span>`);
          } else {
            rows.push(`<span style="opacity: 0.7">${content}</span>`);
          }
        });
        return rows.join('<br />');
      }
    },
    legend: { ...(0,utils_series/* getLegendProps */.zp)(legendType, legendOrientation, showLegend, zoomable),
      // @ts-ignore
      data: rawSeriesA.concat(rawSeriesB).filter(entry => (0,prophet/* extractForecastSeriesContext */.Nr)(entry.name || '').type === types/* ForecastSeriesEnum.Observation */.i1.Observation).map(entry => entry.name || '').concat((0,annotation/* extractAnnotationLabels */.Ky)(annotationLayers, annotationData))
    },
    series: (0,utils_series/* dedupSeries */.IE)(series),
    toolbox: {
      show: zoomable,
      top: constants/* TIMESERIES_CONSTANTS.toolboxTop */.SM.toolboxTop,
      right: constants/* TIMESERIES_CONSTANTS.toolboxRight */.SM.toolboxRight,
      feature: {
        dataZoom: {
          yAxisIndex: false,
          title: {
            zoom: 'zoom area',
            back: 'restore zoom'
          }
        }
      }
    },
    dataZoom: zoomable ? [{
      type: 'slider',
      start: constants/* TIMESERIES_CONSTANTS.dataZoomStart */.SM.dataZoomStart,
      end: constants/* TIMESERIES_CONSTANTS.dataZoomEnd */.SM.dataZoomEnd,
      bottom: constants/* TIMESERIES_CONSTANTS.zoomBottom */.SM.zoomBottom
    }] : []
  };
  return {
    formData,
    width,
    height,
    echartOptions,
    setDataMask,
    emitFilter,
    emitFilterB,
    labelMap,
    labelMapB,
    groupby,
    groupbyB,
    seriesBreakdown: rawSeriesA.length,
    selectedValues: filterState.selectedValues || []
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/MixedTimeseries/images/thumbnail.png
var thumbnail = __webpack_require__(77622);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/MixedTimeseries/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





class EchartsTimeseriesChartPlugin extends ChartPlugin/* default */.Z {
  /**
   * The constructor is used to pass relevant metadata and callbacks that get
   * registered in respective registries that are used throughout the library
   * and application. A more thorough description of each property is given in
   * the respective imported file.
   *
   * It is worth noting that `buildQuery` and is optional, and only needed for
   * advanced visualizations that require either post processing operations
   * (pivoting, rolling aggregations, sorting etc) or submitting multiple queries.
   */
  constructor() {
    super({
      buildQuery: buildQuery,
      controlPanel: controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 2085).then(__webpack_require__.bind(__webpack_require__, 72085)),
      metadata: new ChartMetadata/* default */.Z({
        behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
        category: (0,TranslatorSingleton.t)('Evolution'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)('Visualize two different time series using the same x-axis time range. Note that each time series can be visualized differently (e.g. 1 using bars and 1 using a line).'),
        supportedAnnotationTypes: [AnnotationLayer/* AnnotationType.Event */.JJ.Event, AnnotationLayer/* AnnotationType.Formula */.JJ.Formula, AnnotationLayer/* AnnotationType.Interval */.JJ.Interval, AnnotationLayer/* AnnotationType.Timeseries */.JJ.Timeseries],
        name: (0,TranslatorSingleton.t)('Mixed Time-Series'),
        thumbnail: thumbnail,
        tags: [(0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('ECharts'), (0,TranslatorSingleton.t)('Experimental'), (0,TranslatorSingleton.t)('Line'), (0,TranslatorSingleton.t)('Multi-Variables'), (0,TranslatorSingleton.t)('Predictive'), (0,TranslatorSingleton.t)('Time'), (0,TranslatorSingleton.t)('Transformable')]
      }),
      // @ts-ignore
      transformProps: transformProps
    });
  }

}

/***/ }),

/***/ 36325:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsPieChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/buildQueryContext.js
var buildQueryContext = __webpack_require__(69205);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Pie/buildQuery.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function buildQuery(formData) {
  const {
    metric,
    sort_by_metric
  } = formData;
  return (0,buildQueryContext/* default */.Z)(formData, baseQueryObject => [{ ...baseQueryObject,
    ...(sort_by_metric && {
      orderby: [[metric, false]]
    })
  }]);
}
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/types.js
var types = __webpack_require__(94980);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Pie/types.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

let EchartsPieLabelType;

(function (EchartsPieLabelType) {
  EchartsPieLabelType["Key"] = "key";
  EchartsPieLabelType["Value"] = "value";
  EchartsPieLabelType["Percent"] = "percent";
  EchartsPieLabelType["KeyValue"] = "key_value";
  EchartsPieLabelType["KeyPercent"] = "key_percent";
  EchartsPieLabelType["KeyValuePercent"] = "key_value_percent";
})(EchartsPieLabelType || (EchartsPieLabelType = {}));

// @ts-ignore
const DEFAULT_FORM_DATA = { ...types/* DEFAULT_LEGEND_FORM_DATA */.xo,
  donut: false,
  groupby: [],
  innerRadius: 30,
  labelLine: false,
  labelType: EchartsPieLabelType.Key,
  legendOrientation: types/* LegendOrientation.Top */.IY.Top,
  legendType: types/* LegendType.Scroll */.HJ.Scroll,
  numberFormat: 'SMART_NUMBER',
  outerRadius: 70,
  showLabels: true,
  labelsOutside: true,
  showLabelsThreshold: 5,
  emitFilter: false,
  dateFormat: 'smart_date'
};
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/controls.js
var controls = __webpack_require__(22297);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Pie/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const {
  donut,
  innerRadius,
  labelsOutside,
  labelType,
  labelLine,
  outerRadius,
  numberFormat,
  showLabels
} = DEFAULT_FORM_DATA;
const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['groupby'], ['metric'], ['adhoc_filters'], emitFilterControl/* emitFilterControl */.a, ['row_limit'], [{
      name: 'sort_by_metric',
      config: {
        default: true,
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort by metric'),
        description: (0,TranslatorSingleton.t)('Whether to sort results by the selected metric in descending order.')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], [{
      name: 'show_labels_threshold',
      config: {
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Percentage threshold'),
        renderTrigger: true,
        isFloat: true,
        default: 5,
        description: (0,TranslatorSingleton.t)('Minimum threshold in percentage points for showing labels.')
      }
    }], ...controls/* legendSection */.q_, // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Labels'))], [{
      name: 'label_type',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Label Type'),
        default: labelType,
        renderTrigger: true,
        choices: [['key', 'Category Name'], ['value', 'Value'], ['percent', 'Percentage'], ['key_value', 'Category and Value'], ['key_percent', 'Category and Percentage'], ['key_value_percent', 'Category, Value and Percentage']],
        description: (0,TranslatorSingleton.t)('What should be shown on the label?')
      }
    }], [{
      name: 'number_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Number format'),
        renderTrigger: true,
        default: numberFormat,
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6,
        description: `${(0,TranslatorSingleton.t)('D3 format syntax: https://github.com/d3/d3-format')} ${(0,TranslatorSingleton.t)('Only applies when "Label Type" is set to show values.')}`
      }
    }], [{
      name: 'date_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Date format'),
        renderTrigger: true,
        choices: D3Formatting/* D3_TIME_FORMAT_OPTIONS */.HC,
        default: 'smart_date',
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }], [{
      name: 'show_labels',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show Labels'),
        renderTrigger: true,
        default: showLabels,
        description: (0,TranslatorSingleton.t)('Whether to display the labels.')
      }
    }], [{
      name: 'labels_outside',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Put labels outside'),
        default: labelsOutside,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Put the labels outside of the pie?'),
        visibility: ({
          controls
        }) => {
          var _controls$show_labels;

          return Boolean(controls == null ? void 0 : (_controls$show_labels = controls.show_labels) == null ? void 0 : _controls$show_labels.value);
        }
      }
    }], [{
      name: 'label_line',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Label Line'),
        default: labelLine,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Draw line from Pie to label when labels outside?'),
        visibility: ({
          controls
        }) => {
          var _controls$show_labels2;

          return Boolean(controls == null ? void 0 : (_controls$show_labels2 = controls.show_labels) == null ? void 0 : _controls$show_labels2.value);
        }
      }
    }], // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Pie shape'))], [{
      name: 'outerRadius',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Outer Radius'),
        renderTrigger: true,
        min: 10,
        max: 100,
        step: 1,
        default: outerRadius,
        description: (0,TranslatorSingleton.t)('Outer edge of Pie chart')
      }
    }], [{
      name: 'donut',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Donut'),
        default: donut,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Do you want a donut or a pie?')
      }
    }], [{
      name: 'innerRadius',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Inner Radius'),
        renderTrigger: true,
        min: 0,
        max: 100,
        step: 1,
        default: innerRadius,
        description: (0,TranslatorSingleton.t)('Inner radius of donut hole'),
        visibility: ({
          controls
        }) => {
          var _controls$donut;

          return Boolean(controls == null ? void 0 : (_controls$donut = controls.donut) == null ? void 0 : _controls$donut.value);
        }
      }
    }]]
  }],
  controlOverrides: {
    series: {
      validators: [validateNonEmpty/* default */.Z],
      clearable: false
    },
    row_limit: {
      default: 100
    }
  }
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormatterRegistrySingleton.js
var NumberFormatterRegistrySingleton = __webpack_require__(50855);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormats.js
var NumberFormats = __webpack_require__(63758);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/getMetricLabel.js
var getMetricLabel = __webpack_require__(95669);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/time-format/TimeFormatterRegistrySingleton.js + 5 modules
var TimeFormatterRegistrySingleton = __webpack_require__(14826);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/color/CategoricalColorNamespace.js
var CategoricalColorNamespace = __webpack_require__(83527);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/utils/series.js
var utils_series = __webpack_require__(66978);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/defaults.js
var defaults = __webpack_require__(97711);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/constants.js
var constants = __webpack_require__(23788);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Pie/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const percentFormatter = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(NumberFormats/* default.PERCENT_2_POINT */.Z.PERCENT_2_POINT);
function formatPieLabel({
  params,
  labelType,
  numberFormatter,
  sanitizeName = false
}) {
  const {
    name: rawName = '',
    value,
    percent
  } = params;
  const name = sanitizeName ? (0,utils_series/* sanitizeHtml */.Z6)(rawName) : rawName;
  const formattedValue = numberFormatter(value);
  const formattedPercent = percentFormatter(percent / 100);

  switch (labelType) {
    case EchartsPieLabelType.Key:
      return name;

    case EchartsPieLabelType.Value:
      return formattedValue;

    case EchartsPieLabelType.Percent:
      return formattedPercent;

    case EchartsPieLabelType.KeyValue:
      return `${name}: ${formattedValue}`;

    case EchartsPieLabelType.KeyValuePercent:
      return `${name}: ${formattedValue} (${formattedPercent})`;

    case EchartsPieLabelType.KeyPercent:
      return `${name}: ${formattedPercent}`;

    default:
      return name;
  }
}
function transformProps(chartProps) {
  const {
    formData,
    height,
    hooks,
    filterState,
    queriesData,
    width
  } = chartProps;
  const {
    data = []
  } = queriesData[0];
  const coltypeMapping = (0,utils_series/* getColtypesMapping */.IW)(queriesData[0]);
  const {
    colorScheme,
    donut,
    groupby,
    innerRadius,
    labelsOutside,
    labelLine,
    labelType,
    legendMargin,
    legendOrientation,
    legendType,
    metric = '',
    numberFormat,
    dateFormat,
    outerRadius,
    showLabels,
    showLegend,
    showLabelsThreshold,
    emitFilter
  } = { ...types/* DEFAULT_LEGEND_FORM_DATA */.xo,
    ...DEFAULT_FORM_DATA,
    ...formData
  };
  const metricLabel = (0,getMetricLabel/* default */.Z)(metric);
  const minShowLabelAngle = (showLabelsThreshold || 0) * 3.6;
  const keys = data.map(datum => (0,utils_series/* extractGroupbyLabel */.iw)({
    datum,
    groupby,
    coltypeMapping,
    timeFormatter: (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(dateFormat)
  }));
  const labelMap = data.reduce((acc, datum) => {
    const label = (0,utils_series/* extractGroupbyLabel */.iw)({
      datum,
      groupby,
      coltypeMapping,
      timeFormatter: (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(dateFormat)
    });
    return { ...acc,
      [label]: groupby.map(col => datum[col])
    };
  }, {});
  const {
    setDataMask = () => {}
  } = hooks;
  const colorFn = CategoricalColorNamespace.getScale(colorScheme);
  const numberFormatter = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(numberFormat);
  const transformedData = data.map(datum => {
    const name = (0,utils_series/* extractGroupbyLabel */.iw)({
      datum,
      groupby,
      coltypeMapping,
      timeFormatter: (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(dateFormat)
    });
    const isFiltered = filterState.selectedValues && !filterState.selectedValues.includes(name);
    return {
      value: datum[metricLabel],
      name,
      itemStyle: {
        color: colorFn(name),
        opacity: isFiltered ? constants/* OpacityEnum.SemiTransparent */.ZV.SemiTransparent : constants/* OpacityEnum.NonTransparent */.ZV.NonTransparent
      }
    };
  });
  const selectedValues = (filterState.selectedValues || []).reduce((acc, selectedValue) => {
    const index = transformedData.findIndex(({
      name
    }) => name === selectedValue);
    return { ...acc,
      [index]: selectedValue
    };
  }, {});

  const formatter = params => formatPieLabel({
    params,
    numberFormatter,
    labelType
  });

  const defaultLabel = {
    formatter,
    show: showLabels,
    color: '#000000'
  };
  const series = [{
    type: 'pie',
    ...(0,utils_series/* getChartPadding */.G_)(showLegend, legendOrientation, legendMargin),
    animation: false,
    radius: [`${donut ? innerRadius : 0}%`, `${outerRadius}%`],
    center: ['50%', '50%'],
    avoidLabelOverlap: true,
    labelLine: labelsOutside && labelLine ? {
      show: true
    } : {
      show: false
    },
    minShowLabelAngle,
    label: labelsOutside ? { ...defaultLabel,
      position: 'outer',
      alignTo: 'none',
      bleedMargin: 5
    } : { ...defaultLabel,
      position: 'inner'
    },
    emphasis: {
      label: {
        show: true,
        fontWeight: 'bold',
        backgroundColor: 'white'
      }
    },
    data: transformedData
  }];
  const echartOptions = {
    grid: { ...defaults/* defaultGrid */.oe
    },
    tooltip: { ...defaults/* defaultTooltip */.Ku,
      trigger: 'item',
      formatter: params => formatPieLabel({
        params,
        numberFormatter,
        labelType: EchartsPieLabelType.KeyValuePercent,
        sanitizeName: true
      })
    },
    legend: { ...(0,utils_series/* getLegendProps */.zp)(legendType, legendOrientation, showLegend),
      data: keys
    },
    series
  };
  return {
    formData,
    width,
    height,
    echartOptions,
    setDataMask,
    emitFilter,
    labelMap,
    groupby,
    selectedValues
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Pie/images/thumbnail.png
var thumbnail = __webpack_require__(70718);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Pie/images/Pie1.jpg
var Pie1 = __webpack_require__(25581);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Pie/images/Pie2.jpg
var Pie2 = __webpack_require__(27517);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Pie/images/Pie3.jpg
var Pie3 = __webpack_require__(99270);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Pie/images/Pie4.jpg
var Pie4 = __webpack_require__(1394);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Pie/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */









class EchartsPieChartPlugin extends ChartPlugin/* default */.Z {
  /**
   * The constructor is used to pass relevant metadata and callbacks that get
   * registered in respective registries that are used throughout the library
   * and application. A more thorough description of each property is given in
   * the respective imported file.
   *
   * It is worth noting that `buildQuery` and is optional, and only needed for
   * advanced visualizations that require either post processing operations
   * (pivoting, rolling aggregations, sorting etc) or submitting multiple queries.
   */
  constructor() {
    super({
      buildQuery: buildQuery,
      controlPanel: controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 2306).then(__webpack_require__.bind(__webpack_require__, 22306)),
      metadata: new ChartMetadata/* default */.Z({
        behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
        category: (0,TranslatorSingleton.t)('Part of a Whole'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)(`The classic. Great for showing how much of a company each investor gets, what demographics follow your blog, or what portion of the budget goes to the military industrial complex.

        Pie charts can be difficult to interpret precisely. If clarity of relative proportion is important, consider using a bar or other chart type instead.`),
        exampleGallery: [{
          url: Pie1
        }, {
          url: Pie2
        }, {
          url: Pie3
        }, {
          url: Pie4
        }],
        name: (0,TranslatorSingleton.t)('Pie Chart'),
        tags: [(0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Categorical'), (0,TranslatorSingleton.t)('Circular'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Percentages'), (0,TranslatorSingleton.t)('Popular'), (0,TranslatorSingleton.t)('Proportional'), (0,TranslatorSingleton.t)('ECharts')],
        thumbnail: thumbnail
      }),
      transformProps: transformProps
    });
  }

}

/***/ }),

/***/ 51873:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsRadarChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/utils/ensureIsArray.js
var ensureIsArray = __webpack_require__(86852);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/buildQueryContext.js
var buildQueryContext = __webpack_require__(69205);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Radar/buildQuery.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function buildQuery(formData) {
  const {
    timeseries_limit_metric
  } = formData;
  const sortByMetric = (0,ensureIsArray/* default */.Z)(timeseries_limit_metric)[0];
  return (0,buildQueryContext/* default */.Z)(formData, baseQueryObject => {
    var _metrics;

    let {
      metrics,
      orderby = []
    } = baseQueryObject;
    metrics = metrics || []; // orverride orderby with timeseries metric

    if (sortByMetric) {
      orderby = [[sortByMetric, false]];
    } else if (((_metrics = metrics) == null ? void 0 : _metrics.length) > 0) {
      // default to ordering by first metric in descending order
      // when no "sort by" metric is set (regargless if "SORT DESC" is set to true)
      orderby = [[metrics[0], false]];
    }

    return [{ ...baseQueryObject,
      orderby
    }];
  });
}
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNumber.js
var validateNumber = __webpack_require__(67181);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/types/QueryResponse.js
var QueryResponse = __webpack_require__(23274);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/types.js
var types = __webpack_require__(94980);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Radar/types.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

let EchartsRadarLabelType;

(function (EchartsRadarLabelType) {
  EchartsRadarLabelType["Value"] = "value";
  EchartsRadarLabelType["KeyValue"] = "key_value";
})(EchartsRadarLabelType || (EchartsRadarLabelType = {}));

// @ts-ignore
const DEFAULT_FORM_DATA = { ...types/* DEFAULT_LEGEND_FORM_DATA */.xo,
  groupby: [],
  labelType: EchartsRadarLabelType.Value,
  labelPosition: types/* LabelPositionEnum.Top */.Pl.Top,
  legendOrientation: types/* LegendOrientation.Top */.IY.Top,
  legendType: types/* LegendType.Scroll */.HJ.Scroll,
  numberFormat: 'SMART_NUMBER',
  showLabels: true,
  emitFilter: false,
  dateFormat: 'smart_date',
  isCircle: false
};
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/constants.js
var constants = __webpack_require__(23788);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/controls.js
var controls = __webpack_require__(22297);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Radar/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */







const {
  labelType,
  labelPosition,
  numberFormat,
  showLabels,
  isCircle
} = DEFAULT_FORM_DATA;
const radarMetricMaxValue = {
  name: 'radarMetricMaxValue',
  config: {
    controlType: 'InputNumber',
    label: (0,TranslatorSingleton.t)('Max'),
    description: (0,TranslatorSingleton.t)('The maximum value of metrics. It is an optional configuration'),
    width: 120,
    placeholder: 'auto',
    debounceDelay: 400,
    validators: [validateNumber/* default */.Z]
  }
};
const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['groupby'], ['metrics'], ['timeseries_limit_metric'], ['adhoc_filters'], emitFilterControl/* emitFilterControl */.a, [{
      name: 'row_limit',
      config: { ...shared_controls/* sharedControls.row_limit */.Hq.row_limit,
        default: 10
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], ...controls/* legendSection */.q_, [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Labels'))], [{
      name: 'show_labels',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show Labels'),
        renderTrigger: true,
        default: showLabels,
        description: (0,TranslatorSingleton.t)('Whether to display the labels.')
      }
    }], [{
      name: 'label_type',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Label Type'),
        default: labelType,
        renderTrigger: true,
        choices: [['value', 'Value'], ['key_value', 'Category and Value']],
        description: (0,TranslatorSingleton.t)('What should be shown on the label?')
      }
    }], [{
      name: 'label_position',
      config: {
        type: 'SelectControl',
        freeForm: false,
        label: (0,TranslatorSingleton.t)('Label position'),
        renderTrigger: true,
        choices: constants/* LABEL_POSITION */.N4,
        default: labelPosition,
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }], [{
      name: 'number_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Number format'),
        renderTrigger: true,
        default: numberFormat,
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6,
        description: `${(0,TranslatorSingleton.t)('D3 format syntax: https://github.com/d3/d3-format. ')} ${(0,TranslatorSingleton.t)('Only applies when "Label Type" is set to show values.')}`
      }
    }], [{
      name: 'date_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Date format'),
        renderTrigger: true,
        choices: D3Formatting/* D3_TIME_FORMAT_OPTIONS */.HC,
        default: 'smart_date',
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }], [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Radar'))], [{
      name: 'column_config',
      config: {
        type: 'ColumnConfigControl',
        label: (0,TranslatorSingleton.t)('Customize Metrics'),
        description: (0,TranslatorSingleton.t)('Further customize how to display each metric'),
        renderTrigger: true,
        configFormLayout: {
          [QueryResponse/* GenericDataType.NUMERIC */.Z.NUMERIC]: [[radarMetricMaxValue]]
        },

        mapStateToProps(explore, control, chart) {
          var _explore$controls, _explore$controls$met, _chart$queriesRespons;

          const values = (explore == null ? void 0 : (_explore$controls = explore.controls) == null ? void 0 : (_explore$controls$met = _explore$controls.metrics) == null ? void 0 : _explore$controls$met.value) ?? [];
          const metricColumn = values.map(value => {
            if (typeof value === 'string') {
              return value;
            }

            return value.label;
          });
          return {
            queryResponse: chart == null ? void 0 : (_chart$queriesRespons = chart.queriesResponse) == null ? void 0 : _chart$queriesRespons[0],
            appliedColumnNames: metricColumn
          };
        }

      }
    }], [{
      name: 'is_circle',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Circle radar shape'),
        renderTrigger: true,
        default: isCircle,
        description: (0,TranslatorSingleton.t)("Radar render type, whether to display 'circle' shape.")
      }
    }]]
  }]
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/color/CategoricalColorNamespace.js
var CategoricalColorNamespace = __webpack_require__(83527);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormatterRegistrySingleton.js
var NumberFormatterRegistrySingleton = __webpack_require__(50855);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/getMetricLabel.js
var getMetricLabel = __webpack_require__(95669);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/time-format/TimeFormatterRegistrySingleton.js + 5 modules
var TimeFormatterRegistrySingleton = __webpack_require__(14826);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/utils/ensureIsInt.js
var ensureIsInt = __webpack_require__(56040);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/utils/series.js
var utils_series = __webpack_require__(66978);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/defaults.js
var defaults = __webpack_require__(97711);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Radar/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






function formatLabel({
  params,
  labelType,
  numberFormatter
}) {
  const {
    name = '',
    value
  } = params;
  const formattedValue = numberFormatter(value);

  switch (labelType) {
    case EchartsRadarLabelType.Value:
      return formattedValue;

    case EchartsRadarLabelType.KeyValue:
      return `${name}: ${formattedValue}`;

    default:
      return name;
  }
}
function transformProps(chartProps) {
  const {
    formData,
    height,
    hooks,
    filterState,
    queriesData,
    width
  } = chartProps;
  const {
    data = []
  } = queriesData[0];
  const coltypeMapping = (0,utils_series/* getColtypesMapping */.IW)(queriesData[0]);
  const {
    colorScheme,
    groupby,
    labelType,
    labelPosition,
    legendOrientation,
    legendType,
    metrics = [],
    numberFormat,
    dateFormat,
    showLabels,
    showLegend,
    isCircle,
    columnConfig
  } = { ...types/* DEFAULT_LEGEND_FORM_DATA */.xo,
    ...DEFAULT_FORM_DATA,
    ...formData
  };
  const {
    setDataMask = () => {}
  } = hooks;
  const colorFn = CategoricalColorNamespace.getScale(colorScheme);
  const numberFormatter = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(numberFormat);

  const formatter = params => formatLabel({
    params,
    numberFormatter,
    labelType
  });

  const metricsLabel = metrics.map(metric => (0,getMetricLabel/* default */.Z)(metric));
  const metricLabelAndMaxValueMap = new Map();
  const columnsLabelMap = new Map();
  const transformedData = [];
  data.forEach(datum => {
    const joinedName = (0,utils_series/* extractGroupbyLabel */.iw)({
      datum,
      groupby,
      coltypeMapping,
      timeFormatter: (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(dateFormat)
    }); // map(joined_name: [columnLabel_1, columnLabel_2, ...])

    columnsLabelMap.set(joinedName, groupby.map(col => datum[col])); // put max value of series into metricLabelAndMaxValueMap
    // eslint-disable-next-line no-restricted-syntax

    for (const [metricLabel, value] of Object.entries(datum)) {
      if (metricLabelAndMaxValueMap.has(metricLabel)) {
        metricLabelAndMaxValueMap.set(metricLabel, Math.max(value, (0,ensureIsInt/* default */.Z)(metricLabelAndMaxValueMap.get(metricLabel), Number.MIN_SAFE_INTEGER)));
      } else {
        metricLabelAndMaxValueMap.set(metricLabel, value);
      }
    }

    const isFiltered = filterState.selectedValues && !filterState.selectedValues.includes(joinedName); // generate transformedData

    transformedData.push({
      value: metricsLabel.map(metricLabel => datum[metricLabel]),
      name: joinedName,
      itemStyle: {
        color: colorFn(joinedName),
        opacity: isFiltered ? constants/* OpacityEnum.Transparent */.ZV.Transparent : constants/* OpacityEnum.NonTransparent */.ZV.NonTransparent
      },
      lineStyle: {
        opacity: isFiltered ? constants/* OpacityEnum.SemiTransparent */.ZV.SemiTransparent : constants/* OpacityEnum.NonTransparent */.ZV.NonTransparent
      },
      label: {
        show: showLabels,
        position: labelPosition,
        formatter
      }
    });
  });
  const selectedValues = (filterState.selectedValues || []).reduce((acc, selectedValue) => {
    const index = transformedData.findIndex(({
      name
    }) => name === selectedValue);
    return { ...acc,
      [index]: selectedValue
    };
  }, {});
  const indicator = metricsLabel.map(metricLabel => {
    var _columnConfig$metricL;

    const maxValueInControl = columnConfig == null ? void 0 : (_columnConfig$metricL = columnConfig[metricLabel]) == null ? void 0 : _columnConfig$metricL.radarMetricMaxValue; // Ensure that 0 is at the center of the polar coordinates

    const metricValueAsMax = metricLabelAndMaxValueMap.get(metricLabel) === 0 ? Number.MAX_SAFE_INTEGER : metricLabelAndMaxValueMap.get(metricLabel);
    const max = maxValueInControl === null ? metricValueAsMax : maxValueInControl;
    return {
      name: metricLabel,
      max
    };
  });
  const series = [{
    type: 'radar',
    animation: false,
    emphasis: {
      label: {
        show: true,
        fontWeight: 'bold',
        backgroundColor: 'white'
      }
    },
    data: transformedData
  }];
  const echartOptions = {
    grid: { ...defaults/* defaultGrid */.oe
    },
    tooltip: { ...defaults/* defaultTooltip */.Ku,
      trigger: 'item'
    },
    legend: { ...(0,utils_series/* getLegendProps */.zp)(legendType, legendOrientation, showLegend),
      data: Array.from(columnsLabelMap.keys())
    },
    series,
    radar: {
      shape: isCircle ? 'circle' : 'polygon',
      indicator
    }
  };
  return {
    formData,
    width,
    height,
    echartOptions,
    setDataMask,
    labelMap: Object.fromEntries(columnsLabelMap),
    groupby,
    selectedValues
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Radar/images/thumbnail.png
var thumbnail = __webpack_require__(60203);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Radar/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regardin
 * g copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





class EchartsRadarChartPlugin extends ChartPlugin/* default */.Z {
  /**
   * The constructor is used to pass relevant metadata and callbacks that get
   * registered in respective registries that are used throughout the library
   * and application. A more thorough description of each property is given in
   * the respective imported file.
   *
   * It is worth noting that `buildQuery` and is optional, and only needed for
   * advanced visualizations that require either post processing operations
   * (pivoting, rolling aggregations, sorting etc) or submitting multiple queries.
   */
  constructor() {
    super({
      buildQuery: buildQuery,
      controlPanel: controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 4980).then(__webpack_require__.bind(__webpack_require__, 34980)),
      metadata: new ChartMetadata/* default */.Z({
        behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
        category: (0,TranslatorSingleton.t)('Ranking'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)('Visualize a parallel set of metrics across multiple groups. Each group is visualized using its own line of points and each metric is represented as an edge in the chart.'),
        name: (0,TranslatorSingleton.t)('Radar Chart'),
        tags: [(0,TranslatorSingleton.t)('Business'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Coordinates'), (0,TranslatorSingleton.t)('Multi-Variables'), (0,TranslatorSingleton.t)('Report'), (0,TranslatorSingleton.t)('Web'), (0,TranslatorSingleton.t)('ECharts')],
        thumbnail: thumbnail
      }),
      transformProps: transformProps
    });
  }

}

/***/ }),

/***/ 69774:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsAreaChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/types/AnnotationLayer.js
var AnnotationLayer = __webpack_require__(33484);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/buildQuery.js
var buildQuery = __webpack_require__(14396);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/types.js
var types = __webpack_require__(36913);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/controls.js
var controls = __webpack_require__(22297);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Area/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const {
  contributionMode,
  logAxis,
  markerEnabled,
  markerSize,
  minorSplitLine,
  opacity,
  rowLimit,
  seriesType,
  truncateYAxis,
  yAxisBounds,
  zoomable,
  xAxisLabelRotation
} = types/* DEFAULT_FORM_DATA */.En;
const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['groupby'], [{
      name: 'contributionMode',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Contribution Mode'),
        default: contributionMode,
        choices: [[null, 'None'], [types/* EchartsTimeseriesContributionType.Row */.HE.Row, 'Total'], [types/* EchartsTimeseriesContributionType.Column */.HE.Column, 'Series']],
        description: (0,TranslatorSingleton.t)('Calculate contribution per series or total')
      }
    }], ['adhoc_filters'], emitFilterControl/* emitFilterControl */.a, ['limit'], ['timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }], ['row_limit']]
  }, esm.sections.advancedAnalyticsControls, esm.sections.annotationsAndLayersControls, esm.sections.forecastIntervalControls, esm.sections.titleControls, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], [{
      name: 'seriesType',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Series Style'),
        renderTrigger: true,
        default: seriesType,
        choices: [[types/* EchartsTimeseriesSeriesType.Line */.mD.Line, 'Line'], [types/* EchartsTimeseriesSeriesType.Smooth */.mD.Smooth, 'Smooth Line'], [types/* EchartsTimeseriesSeriesType.Start */.mD.Start, 'Step - start'], [types/* EchartsTimeseriesSeriesType.Middle */.mD.Middle, 'Step - middle'], [types/* EchartsTimeseriesSeriesType.End */.mD.End, 'Step - end']],
        description: (0,TranslatorSingleton.t)('Series chart type (line, bar etc)')
      }
    }], [{
      name: 'opacity',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Area chart opacity'),
        renderTrigger: true,
        min: 0,
        max: 1,
        step: 0.1,
        default: opacity,
        description: (0,TranslatorSingleton.t)('Opacity of Area Chart. Also applies to confidence band.')
      }
    }], ...controls/* showValueSection */.eQ, [{
      name: 'markerEnabled',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Marker'),
        renderTrigger: true,
        default: markerEnabled,
        description: (0,TranslatorSingleton.t)('Draw a marker on data points. Only applicable for line types.')
      }
    }], [{
      name: 'markerSize',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Marker Size'),
        renderTrigger: true,
        min: 0,
        max: 20,
        default: markerSize,
        description: (0,TranslatorSingleton.t)('Size of marker. Also applies to forecast observations.'),
        visibility: ({
          controls
        }) => {
          var _controls$markerEnabl;

          return Boolean(controls == null ? void 0 : (_controls$markerEnabl = controls.markerEnabled) == null ? void 0 : _controls$markerEnabl.value);
        }
      }
    }], [{
      name: 'zoomable',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Data Zoom'),
        default: zoomable,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Enable data zooming controls')
      }
    }], ...controls/* legendSection */.q_, [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('X Axis'))], [{
      name: 'x_axis_time_format',
      config: { ...shared_controls/* sharedControls.x_axis_time_format */.Hq.x_axis_time_format,
        default: 'smart_date',
        description: `${D3Formatting/* D3_TIME_FORMAT_DOCS */.oq}. ${(0,TranslatorSingleton.t)('When using other than adaptive formatting, labels may overlap.')}`
      }
    }], [{
      name: 'xAxisLabelRotation',
      config: {
        type: 'SelectControl',
        freeForm: true,
        clearable: false,
        label: (0,TranslatorSingleton.t)('Rotate x axis label'),
        choices: [[0, '0°'], [45, '45°']],
        default: xAxisLabelRotation,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Input field supports custom rotation. e.g. 30 for 30°')
      }
    }], ...controls/* richTooltipSection */.oA, // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Y Axis'))], ['y_axis_format'], [{
      name: 'logAxis',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Logarithmic y-axis'),
        renderTrigger: true,
        default: logAxis,
        description: (0,TranslatorSingleton.t)('Logarithmic y-axis')
      }
    }], [{
      name: 'minorSplitLine',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Minor Split Line'),
        renderTrigger: true,
        default: minorSplitLine,
        description: (0,TranslatorSingleton.t)('Draw split lines for minor y-axis ticks')
      }
    }], [{
      name: 'truncateYAxis',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Truncate Y Axis'),
        default: truncateYAxis,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Truncate Y Axis. Can be overridden by specifying a min or max bound.')
      }
    }], [{
      name: 'y_axis_bounds',
      config: {
        type: 'BoundsControl',
        label: (0,TranslatorSingleton.t)('Y Axis Bounds'),
        renderTrigger: true,
        default: yAxisBounds,
        description: (0,TranslatorSingleton.t)('Bounds for the Y-axis. When left empty, the bounds are ' + 'dynamically defined based on the min/max of the data. Note that ' + "this feature will only expand the axis range. It won't " + "narrow the data's extent."),
        visibility: ({
          controls
        }) => {
          var _controls$truncateYAx;

          return Boolean(controls == null ? void 0 : (_controls$truncateYAx = controls.truncateYAxis) == null ? void 0 : _controls$truncateYAx.value);
        }
      }
    }]]
  }],
  controlOverrides: {
    row_limit: {
      default: rowLimit
    }
  }
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/transformProps.js
var transformProps = __webpack_require__(76034);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Area/images/thumbnail.png
var thumbnail = __webpack_require__(50206);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Area/images/Area1.png
var Area1 = __webpack_require__(66445);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Area/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */







const areaTransformProps = chartProps => (0,transformProps/* default */.Z)({ ...chartProps,
  formData: { ...chartProps.formData,
    area: true
  }
});

class EchartsAreaChartPlugin extends ChartPlugin/* default */.Z {
  /**
   * The constructor is used to pass relevant metadata and callbacks that get
   * registered in respective registries that are used throughout the library
   * and application. A more thorough description of each property is given in
   * the respective imported file.
   *
   * It is worth noting that `buildQuery` and is optional, and only needed for
   * advanced visualizations that require either post processing operations
   * (pivoting, rolling aggregations, sorting etc) or submitting multiple queries.
   */
  constructor() {
    super({
      buildQuery: buildQuery/* default */.Z,
      controlPanel: controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 4441).then(__webpack_require__.bind(__webpack_require__, 34441)),
      metadata: new ChartMetadata/* default */.Z({
        behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
        category: (0,TranslatorSingleton.t)('Evolution'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)('Time-series Area chart are similar to line chart in that they represent variables with the same scale, but area charts stack the metrics on top of each other. An area chart in Superset can be stream, stack, or expand.'),
        exampleGallery: [{
          url: Area1
        }],
        supportedAnnotationTypes: [AnnotationLayer/* AnnotationType.Event */.JJ.Event, AnnotationLayer/* AnnotationType.Formula */.JJ.Formula, AnnotationLayer/* AnnotationType.Interval */.JJ.Interval, AnnotationLayer/* AnnotationType.Timeseries */.JJ.Timeseries],
        name: (0,TranslatorSingleton.t)('Time-series Area Chart'),
        tags: [(0,TranslatorSingleton.t)('ECharts'), (0,TranslatorSingleton.t)('Predictive'), (0,TranslatorSingleton.t)('Advanced-Analytics'), (0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Time'), (0,TranslatorSingleton.t)('Line'), (0,TranslatorSingleton.t)('Transformable'), (0,TranslatorSingleton.t)('Stacked'), (0,TranslatorSingleton.t)('Popular')],
        thumbnail: thumbnail
      }),
      transformProps: areaTransformProps
    });
  }

}

/***/ }),

/***/ 58662:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ EchartsTimeseriesBarChartPlugin)
/* harmony export */ });
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15179);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(40702);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(52686);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(60650);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(33484);
/* harmony import */ var _buildQuery__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14396);
/* harmony import */ var _controlPanel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3993);
/* harmony import */ var _transformProps__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(76034);
/* harmony import */ var _images_thumbnail_png__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(57409);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36913);
/* harmony import */ var _images_Bar1_png__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(73068);
/* harmony import */ var _images_Bar2_png__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(18480);
/* harmony import */ var _images_Bar3_png__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(61994);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */










const barTransformProps = chartProps => (0,_transformProps__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)({ ...chartProps,
  formData: { ...chartProps.formData,
    seriesType: _types__WEBPACK_IMPORTED_MODULE_1__/* .EchartsTimeseriesSeriesType.Bar */ .mD.Bar
  }
});

class EchartsTimeseriesBarChartPlugin extends _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z {
  constructor() {
    super({
      buildQuery: _buildQuery__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z,
      controlPanel: _controlPanel__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z,
      loadChart: () => __webpack_require__.e(/* import() */ 4441).then(__webpack_require__.bind(__webpack_require__, 34441)),
      metadata: new _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z({
        behaviors: [_superset_ui_core__WEBPACK_IMPORTED_MODULE_6__/* .Behavior.INTERACTIVE_CHART */ .cg.INTERACTIVE_CHART],
        category: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Evolution'),
        credits: ['https://echarts.apache.org'],
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Time-series Bar Charts are used to show the changes in a metric over time as a series of bars.'),
        exampleGallery: [{
          url: _images_Bar1_png__WEBPACK_IMPORTED_MODULE_8__
        }, {
          url: _images_Bar2_png__WEBPACK_IMPORTED_MODULE_9__
        }, {
          url: _images_Bar3_png__WEBPACK_IMPORTED_MODULE_10__
        }],
        supportedAnnotationTypes: [_superset_ui_core__WEBPACK_IMPORTED_MODULE_11__/* .AnnotationType.Event */ .JJ.Event, _superset_ui_core__WEBPACK_IMPORTED_MODULE_11__/* .AnnotationType.Formula */ .JJ.Formula, _superset_ui_core__WEBPACK_IMPORTED_MODULE_11__/* .AnnotationType.Interval */ .JJ.Interval, _superset_ui_core__WEBPACK_IMPORTED_MODULE_11__/* .AnnotationType.Timeseries */ .JJ.Timeseries],
        name: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Time-series Bar Chart v2'),
        tags: [(0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('ECharts'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Predictive'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Advanced-Analytics'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Aesthetic'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Time'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Transformable'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Stacked'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Vertical'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Bar'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Popular')],
        thumbnail: _images_thumbnail_png__WEBPACK_IMPORTED_MODULE_12__
      }),
      transformProps: barTransformProps
    });
  }

}

/***/ }),

/***/ 64405:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ EchartsTimeseriesLineChartPlugin)
/* harmony export */ });
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15179);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(40702);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(52686);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(60650);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(33484);
/* harmony import */ var _buildQuery__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14396);
/* harmony import */ var _controlPanel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3993);
/* harmony import */ var _transformProps__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(76034);
/* harmony import */ var _images_thumbnail_png__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(55811);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36913);
/* harmony import */ var _images_Line1_png__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(52551);
/* harmony import */ var _images_Line2_png__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(73103);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */









const lineTransformProps = chartProps => (0,_transformProps__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)({ ...chartProps,
  formData: { ...chartProps.formData,
    seriesType: _types__WEBPACK_IMPORTED_MODULE_1__/* .EchartsTimeseriesSeriesType.Line */ .mD.Line
  }
});

class EchartsTimeseriesLineChartPlugin extends _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z {
  constructor() {
    super({
      buildQuery: _buildQuery__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z,
      controlPanel: _controlPanel__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z,
      loadChart: () => __webpack_require__.e(/* import() */ 4441).then(__webpack_require__.bind(__webpack_require__, 34441)),
      metadata: new _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z({
        behaviors: [_superset_ui_core__WEBPACK_IMPORTED_MODULE_6__/* .Behavior.INTERACTIVE_CHART */ .cg.INTERACTIVE_CHART],
        category: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Evolution'),
        credits: ['https://echarts.apache.org'],
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Time-series line chart is used to visualize repeated measurements taken over regular time intervals. Line chart is a type of chart which displays information as a series of data points connected by straight line segments. It is a basic type of chart common in many fields.'),
        exampleGallery: [{
          url: _images_Line1_png__WEBPACK_IMPORTED_MODULE_8__
        }, {
          url: _images_Line2_png__WEBPACK_IMPORTED_MODULE_9__
        }],
        supportedAnnotationTypes: [_superset_ui_core__WEBPACK_IMPORTED_MODULE_10__/* .AnnotationType.Event */ .JJ.Event, _superset_ui_core__WEBPACK_IMPORTED_MODULE_10__/* .AnnotationType.Formula */ .JJ.Formula, _superset_ui_core__WEBPACK_IMPORTED_MODULE_10__/* .AnnotationType.Interval */ .JJ.Interval, _superset_ui_core__WEBPACK_IMPORTED_MODULE_10__/* .AnnotationType.Timeseries */ .JJ.Timeseries],
        name: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Time-series Line Chart'),
        tags: [(0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('ECharts'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Predictive'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Advanced-Analytics'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Aesthetic'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Line'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Popular')],
        thumbnail: _images_thumbnail_png__WEBPACK_IMPORTED_MODULE_11__
      }),
      transformProps: lineTransformProps
    });
  }

}

/***/ }),

/***/ 72812:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsTimeseriesScatterChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/types/AnnotationLayer.js
var AnnotationLayer = __webpack_require__(33484);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/buildQuery.js
var buildQuery = __webpack_require__(14396);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/types.js
var types = __webpack_require__(36913);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/controls.js
var controls = __webpack_require__(22297);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Regular/Scatter/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const {
  logAxis,
  markerEnabled,
  markerSize,
  minorSplitLine,
  rowLimit,
  truncateYAxis,
  yAxisBounds,
  zoomable,
  xAxisLabelRotation
} = types/* DEFAULT_FORM_DATA */.En;
const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['groupby'], ['adhoc_filters'], emitFilterControl/* emitFilterControl */.a, ['limit'], ['timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }], ['row_limit']]
  }, esm.sections.advancedAnalyticsControls, esm.sections.annotationsAndLayersControls, esm.sections.forecastIntervalControls, esm.sections.titleControls, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], ...controls/* showValueSection */.eQ, [{
      name: 'markerEnabled',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Marker'),
        renderTrigger: true,
        default: markerEnabled,
        description: (0,TranslatorSingleton.t)('Draw a marker on data points. Only applicable for line types.')
      }
    }], [{
      name: 'markerSize',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Marker Size'),
        renderTrigger: true,
        min: 0,
        max: 100,
        default: markerSize,
        description: (0,TranslatorSingleton.t)('Size of marker. Also applies to forecast observations.'),
        visibility: ({
          controls
        }) => {
          var _controls$markerEnabl;

          return Boolean(controls == null ? void 0 : (_controls$markerEnabl = controls.markerEnabled) == null ? void 0 : _controls$markerEnabl.value);
        }
      }
    }], [{
      name: 'zoomable',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Data Zoom'),
        default: zoomable,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Enable data zooming controls')
      }
    }], ...controls/* legendSection */.q_, [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('X Axis'))], [{
      name: 'x_axis_time_format',
      config: { ...shared_controls/* sharedControls.x_axis_time_format */.Hq.x_axis_time_format,
        default: 'smart_date',
        description: `${D3Formatting/* D3_TIME_FORMAT_DOCS */.oq}. ${(0,TranslatorSingleton.t)('When using other than adaptive formatting, labels may overlap.')}`
      }
    }], [{
      name: 'xAxisLabelRotation',
      config: {
        type: 'SelectControl',
        freeForm: true,
        clearable: false,
        label: (0,TranslatorSingleton.t)('Rotate x axis label'),
        choices: [[0, '0°'], [45, '45°']],
        default: xAxisLabelRotation,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Input field supports custom rotation. e.g. 30 for 30°')
      }
    }], // eslint-disable-next-line react/jsx-key
    ...controls/* richTooltipSection */.oA, // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Y Axis'))], ['y_axis_format'], [{
      name: 'logAxis',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Logarithmic y-axis'),
        renderTrigger: true,
        default: logAxis,
        description: (0,TranslatorSingleton.t)('Logarithmic y-axis')
      }
    }], [{
      name: 'minorSplitLine',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Minor Split Line'),
        renderTrigger: true,
        default: minorSplitLine,
        description: (0,TranslatorSingleton.t)('Draw split lines for minor y-axis ticks')
      }
    }], [{
      name: 'truncateYAxis',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Truncate Y Axis'),
        default: truncateYAxis,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Truncate Y Axis. Can be overridden by specifying a min or max bound.')
      }
    }], [{
      name: 'y_axis_bounds',
      config: {
        type: 'BoundsControl',
        label: (0,TranslatorSingleton.t)('Y Axis Bounds'),
        renderTrigger: true,
        default: yAxisBounds,
        description: (0,TranslatorSingleton.t)('Bounds for the Y-axis. When left empty, the bounds are ' + 'dynamically defined based on the min/max of the data. Note that ' + "this feature will only expand the axis range. It won't " + "narrow the data's extent."),
        visibility: ({
          controls
        }) => {
          var _controls$truncateYAx;

          return Boolean(controls == null ? void 0 : (_controls$truncateYAx = controls.truncateYAxis) == null ? void 0 : _controls$truncateYAx.value);
        }
      }
    }]]
  }],
  controlOverrides: {
    row_limit: {
      default: rowLimit
    }
  }
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/transformProps.js
var transformProps = __webpack_require__(76034);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Regular/Scatter/images/thumbnail.png
var thumbnail = __webpack_require__(73450);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Regular/Scatter/images/Scatter1.png
var Scatter1 = __webpack_require__(12455);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Regular/Scatter/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */








const scatterTransformProps = chartProps => (0,transformProps/* default */.Z)({ ...chartProps,
  formData: { ...chartProps.formData,
    seriesType: types/* EchartsTimeseriesSeriesType.Scatter */.mD.Scatter
  }
});

class EchartsTimeseriesScatterChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      buildQuery: buildQuery/* default */.Z,
      controlPanel: controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 4441).then(__webpack_require__.bind(__webpack_require__, 34441)),
      metadata: new ChartMetadata/* default */.Z({
        behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
        category: (0,TranslatorSingleton.t)('Evolution'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)('Time-series Scatter Plot has time on the horizontal axis in linear units, and the points are connected in order. It shows a statistical relationship between two variables.'),
        exampleGallery: [{
          url: Scatter1
        }],
        supportedAnnotationTypes: [AnnotationLayer/* AnnotationType.Event */.JJ.Event, AnnotationLayer/* AnnotationType.Formula */.JJ.Formula, AnnotationLayer/* AnnotationType.Interval */.JJ.Interval, AnnotationLayer/* AnnotationType.Timeseries */.JJ.Timeseries],
        name: (0,TranslatorSingleton.t)('Time-series Scatter Plot'),
        tags: [(0,TranslatorSingleton.t)('ECharts'), (0,TranslatorSingleton.t)('Predictive'), (0,TranslatorSingleton.t)('Advanced-Analytics'), (0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Time'), (0,TranslatorSingleton.t)('Transformable'), (0,TranslatorSingleton.t)('Scatter'), (0,TranslatorSingleton.t)('Popular')],
        thumbnail: thumbnail
      }),
      transformProps: scatterTransformProps
    });
  }

}

/***/ }),

/***/ 79917:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ EchartsTimeseriesSmoothLineChartPlugin)
/* harmony export */ });
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15179);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(40702);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(52686);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(60650);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(33484);
/* harmony import */ var _buildQuery__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14396);
/* harmony import */ var _controlPanel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3993);
/* harmony import */ var _transformProps__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(76034);
/* harmony import */ var _images_thumbnail_png__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(8250);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36913);
/* harmony import */ var _images_SmoothLine1_png__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(76083);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */








const smoothTransformProps = chartProps => (0,_transformProps__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)({ ...chartProps,
  formData: { ...chartProps.formData,
    seriesType: _types__WEBPACK_IMPORTED_MODULE_1__/* .EchartsTimeseriesSeriesType.Smooth */ .mD.Smooth
  }
});

class EchartsTimeseriesSmoothLineChartPlugin extends _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z {
  constructor() {
    super({
      buildQuery: _buildQuery__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z,
      controlPanel: _controlPanel__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z,
      loadChart: () => __webpack_require__.e(/* import() */ 4441).then(__webpack_require__.bind(__webpack_require__, 34441)),
      metadata: new _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z({
        behaviors: [_superset_ui_core__WEBPACK_IMPORTED_MODULE_6__/* .Behavior.INTERACTIVE_CHART */ .cg.INTERACTIVE_CHART],
        category: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Evolution'),
        credits: ['https://echarts.apache.org'],
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Time-series Smooth-line is a variation of line chart. Without angles and hard edges, Smooth-line looks more smarter and more professional.'),
        exampleGallery: [{
          url: _images_SmoothLine1_png__WEBPACK_IMPORTED_MODULE_8__
        }],
        supportedAnnotationTypes: [_superset_ui_core__WEBPACK_IMPORTED_MODULE_9__/* .AnnotationType.Event */ .JJ.Event, _superset_ui_core__WEBPACK_IMPORTED_MODULE_9__/* .AnnotationType.Formula */ .JJ.Formula, _superset_ui_core__WEBPACK_IMPORTED_MODULE_9__/* .AnnotationType.Interval */ .JJ.Interval, _superset_ui_core__WEBPACK_IMPORTED_MODULE_9__/* .AnnotationType.Timeseries */ .JJ.Timeseries],
        name: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Time-series Smooth Line'),
        tags: [(0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('ECharts'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Predictive'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Advanced-Analytics'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Aesthetic'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Time'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Line'), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_7__.t)('Transformable')],
        thumbnail: _images_thumbnail_png__WEBPACK_IMPORTED_MODULE_10__
      }),
      transformProps: smoothTransformProps
    });
  }

}

/***/ }),

/***/ 3993:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67294);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(60650);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(88483);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(36906);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(28500);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(67774);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36913);
/* harmony import */ var _controls__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22297);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11965);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const {
  contributionMode,
  logAxis,
  markerEnabled,
  markerSize,
  minorSplitLine,
  rowLimit,
  truncateYAxis,
  yAxisBounds,
  zoomable,
  xAxisLabelRotation
} = _types__WEBPACK_IMPORTED_MODULE_1__/* .DEFAULT_FORM_DATA */ .En;
const config = {
  controlPanelSections: [_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__.sections.legacyTimeseriesTime, {
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['groupby'], [{
      name: 'contributionMode',
      config: {
        type: 'SelectControl',
        label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Contribution Mode'),
        default: contributionMode,
        choices: [[null, 'None'], [_types__WEBPACK_IMPORTED_MODULE_1__/* .EchartsTimeseriesContributionType.Row */ .HE.Row, 'Total'], [_types__WEBPACK_IMPORTED_MODULE_1__/* .EchartsTimeseriesContributionType.Column */ .HE.Column, 'Series']],
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Calculate contribution per series or total')
      }
    }], ['adhoc_filters'], _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_4__/* .emitFilterControl */ .a, ['limit'], ['timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Sort Descending'),
        default: true,
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Whether to sort descending or ascending')
      }
    }], ['row_limit']]
  }, _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__.sections.advancedAnalyticsControls, _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__.sections.annotationsAndLayersControls, _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__.sections.forecastIntervalControls, _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__.sections.titleControls, {
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], ..._controls__WEBPACK_IMPORTED_MODULE_5__/* .showValueSection */ .eQ, [{
      name: 'markerEnabled',
      config: {
        type: 'CheckboxControl',
        label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Marker'),
        renderTrigger: true,
        default: markerEnabled,
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Draw a marker on data points. Only applicable for line types.')
      }
    }], [{
      name: 'markerSize',
      config: {
        type: 'SliderControl',
        label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Marker Size'),
        renderTrigger: true,
        min: 0,
        max: 20,
        default: markerSize,
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Size of marker. Also applies to forecast observations.'),
        visibility: ({
          controls
        }) => {
          var _controls$markerEnabl;

          return Boolean(controls == null ? void 0 : (_controls$markerEnabl = controls.markerEnabled) == null ? void 0 : _controls$markerEnabl.value);
        }
      }
    }], [{
      name: 'zoomable',
      config: {
        type: 'CheckboxControl',
        label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Data Zoom'),
        default: zoomable,
        renderTrigger: true,
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Enable data zooming controls')
      }
    }], ..._controls__WEBPACK_IMPORTED_MODULE_5__/* .legendSection */ .q_, [(0,_emotion_react__WEBPACK_IMPORTED_MODULE_6__.jsx)("h1", {
      className: "section-header"
    }, (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('X Axis'))], [{
      name: 'x_axis_time_format',
      config: { ..._superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_7__/* .sharedControls.x_axis_time_format */ .Hq.x_axis_time_format,
        default: 'smart_date',
        description: `${_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_8__/* .D3_TIME_FORMAT_DOCS */ .oq}. ${(0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('When using other than adaptive formatting, labels may overlap.')}`
      }
    }], [{
      name: 'xAxisLabelRotation',
      config: {
        type: 'SelectControl',
        freeForm: true,
        clearable: false,
        label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Rotate x axis label'),
        choices: [[0, '0°'], [45, '45°']],
        default: xAxisLabelRotation,
        renderTrigger: true,
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Input field supports custom rotation. e.g. 30 for 30°')
      }
    }], // eslint-disable-next-line react/jsx-key
    ..._controls__WEBPACK_IMPORTED_MODULE_5__/* .richTooltipSection */ .oA, // eslint-disable-next-line react/jsx-key
    [(0,_emotion_react__WEBPACK_IMPORTED_MODULE_6__.jsx)("h1", {
      className: "section-header"
    }, (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Y Axis'))], ['y_axis_format'], [{
      name: 'logAxis',
      config: {
        type: 'CheckboxControl',
        label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Logarithmic y-axis'),
        renderTrigger: true,
        default: logAxis,
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Logarithmic y-axis')
      }
    }], [{
      name: 'minorSplitLine',
      config: {
        type: 'CheckboxControl',
        label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Minor Split Line'),
        renderTrigger: true,
        default: minorSplitLine,
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Draw split lines for minor y-axis ticks')
      }
    }], [{
      name: 'truncateYAxis',
      config: {
        type: 'CheckboxControl',
        label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Truncate Y Axis'),
        default: truncateYAxis,
        renderTrigger: true,
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Truncate Y Axis. Can be overridden by specifying a min or max bound.')
      }
    }], [{
      name: 'y_axis_bounds',
      config: {
        type: 'BoundsControl',
        label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Y Axis Bounds'),
        renderTrigger: true,
        default: yAxisBounds,
        description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Bounds for the Y-axis. When left empty, the bounds are ' + 'dynamically defined based on the min/max of the data. Note that ' + "this feature will only expand the axis range. It won't " + "narrow the data's extent."),
        visibility: ({
          controls
        }) => {
          var _controls$truncateYAx;

          return Boolean(controls == null ? void 0 : (_controls$truncateYAx = controls.truncateYAxis) == null ? void 0 : _controls$truncateYAx.value);
        }
      }
    }]]
  }],
  controlOverrides: {
    row_limit: {
      default: rowLimit
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (config);

/***/ }),

/***/ 66116:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsTimeseriesStepChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/types/AnnotationLayer.js
var AnnotationLayer = __webpack_require__(33484);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/buildQuery.js
var buildQuery = __webpack_require__(14396);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/types.js
var types = __webpack_require__(36913);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/controls.js
var controls = __webpack_require__(22297);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Step/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const {
  area: controlPanel_area,
  contributionMode,
  logAxis,
  markerEnabled,
  markerSize,
  minorSplitLine,
  opacity,
  rowLimit,
  truncateYAxis,
  yAxisBounds,
  zoomable,
  xAxisLabelRotation
} = types/* DEFAULT_FORM_DATA */.En;
const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['groupby'], [{
      name: 'contributionMode',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Contribution Mode'),
        default: contributionMode,
        choices: [[null, 'None'], [types/* EchartsTimeseriesContributionType.Row */.HE.Row, 'Total'], [types/* EchartsTimeseriesContributionType.Column */.HE.Column, 'Series']],
        description: (0,TranslatorSingleton.t)('Calculate contribution per series or total')
      }
    }], ['adhoc_filters'], emitFilterControl/* emitFilterControl */.a, ['limit'], ['timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }], ['row_limit']]
  }, esm.sections.advancedAnalyticsControls, esm.sections.annotationsAndLayersControls, esm.sections.forecastIntervalControls, esm.sections.titleControls, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], [{
      name: 'seriesType',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Step type'),
        renderTrigger: true,
        default: types/* EchartsTimeseriesSeriesType.Start */.mD.Start,
        choices: [[types/* EchartsTimeseriesSeriesType.Start */.mD.Start, 'Start'], [types/* EchartsTimeseriesSeriesType.Middle */.mD.Middle, 'Middle'], [types/* EchartsTimeseriesSeriesType.End */.mD.End, 'End']],
        description: (0,TranslatorSingleton.t)('Defines whether the step should appear at the beginning, middle or end between two data points')
      }
    }], ...controls/* showValueSection */.eQ, [{
      name: 'area',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Area Chart'),
        renderTrigger: true,
        default: controlPanel_area,
        description: (0,TranslatorSingleton.t)('Draw area under curves. Only applicable for line types.')
      }
    }], [{
      name: 'opacity',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Area chart opacity'),
        renderTrigger: true,
        min: 0,
        max: 1,
        step: 0.1,
        default: opacity,
        description: (0,TranslatorSingleton.t)('Opacity of Area Chart. Also applies to confidence band.'),
        visibility: ({
          controls
        }) => {
          var _controls$area;

          return Boolean(controls == null ? void 0 : (_controls$area = controls.area) == null ? void 0 : _controls$area.value);
        }
      }
    }], [{
      name: 'markerEnabled',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Marker'),
        renderTrigger: true,
        default: markerEnabled,
        description: (0,TranslatorSingleton.t)('Draw a marker on data points. Only applicable for line types.')
      }
    }], [{
      name: 'markerSize',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Marker Size'),
        renderTrigger: true,
        min: 0,
        max: 20,
        default: markerSize,
        description: (0,TranslatorSingleton.t)('Size of marker. Also applies to forecast observations.'),
        visibility: ({
          controls
        }) => {
          var _controls$markerEnabl;

          return Boolean(controls == null ? void 0 : (_controls$markerEnabl = controls.markerEnabled) == null ? void 0 : _controls$markerEnabl.value);
        }
      }
    }], [{
      name: 'zoomable',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Data Zoom'),
        default: zoomable,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Enable data zooming controls')
      }
    }], ...controls/* legendSection */.q_, [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('X Axis'))], [{
      name: 'x_axis_time_format',
      config: { ...shared_controls/* sharedControls.x_axis_time_format */.Hq.x_axis_time_format,
        default: 'smart_date',
        description: `${D3Formatting/* D3_TIME_FORMAT_DOCS */.oq}. ${(0,TranslatorSingleton.t)('When using other than adaptive formatting, labels may overlap.')}`
      }
    }], [{
      name: 'xAxisLabelRotation',
      config: {
        type: 'SelectControl',
        freeForm: true,
        clearable: false,
        label: (0,TranslatorSingleton.t)('Rotate x axis label'),
        choices: [[0, '0°'], [45, '45°']],
        default: xAxisLabelRotation,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Input field supports custom rotation. e.g. 30 for 30°')
      }
    }], ...controls/* richTooltipSection */.oA, // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Y Axis'))], ['y_axis_format'], [{
      name: 'logAxis',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Logarithmic y-axis'),
        renderTrigger: true,
        default: logAxis,
        description: (0,TranslatorSingleton.t)('Logarithmic y-axis')
      }
    }], [{
      name: 'minorSplitLine',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Minor Split Line'),
        renderTrigger: true,
        default: minorSplitLine,
        description: (0,TranslatorSingleton.t)('Draw split lines for minor y-axis ticks')
      }
    }], [{
      name: 'truncateYAxis',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Truncate Y Axis'),
        default: truncateYAxis,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Truncate Y Axis. Can be overridden by specifying a min or max bound.')
      }
    }], [{
      name: 'y_axis_bounds',
      config: {
        type: 'BoundsControl',
        label: (0,TranslatorSingleton.t)('Y Axis Bounds'),
        renderTrigger: true,
        default: yAxisBounds,
        description: (0,TranslatorSingleton.t)('Bounds for the Y-axis. When left empty, the bounds are ' + 'dynamically defined based on the min/max of the data. Note that ' + "this feature will only expand the axis range. It won't " + "narrow the data's extent."),
        visibility: ({
          controls
        }) => {
          var _controls$truncateYAx;

          return Boolean(controls == null ? void 0 : (_controls$truncateYAx = controls.truncateYAxis) == null ? void 0 : _controls$truncateYAx.value);
        }
      }
    }]]
  }],
  controlOverrides: {
    row_limit: {
      default: rowLimit
    }
  }
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/transformProps.js
var transformProps = __webpack_require__(76034);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Step/images/thumbnail.png
var thumbnail = __webpack_require__(5438);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Step/images/Step1.png
var Step1 = __webpack_require__(8333);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Step/images/Step2.png
var Step2 = __webpack_require__(46171);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/Step/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */







class EchartsTimeseriesStepChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      buildQuery: buildQuery/* default */.Z,
      controlPanel: controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 4441).then(__webpack_require__.bind(__webpack_require__, 34441)),
      metadata: new ChartMetadata/* default */.Z({
        behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
        category: (0,TranslatorSingleton.t)('Evolution'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)('Time-series Stepped-line graph (also called step chart) is a variation of line chart but with the line forming a series of steps between data points. A step chart can be useful when you want to show the changes that occur at irregular intervals.'),
        exampleGallery: [{
          url: Step1
        }, {
          url: Step2
        }],
        supportedAnnotationTypes: [AnnotationLayer/* AnnotationType.Event */.JJ.Event, AnnotationLayer/* AnnotationType.Formula */.JJ.Formula, AnnotationLayer/* AnnotationType.Interval */.JJ.Interval, AnnotationLayer/* AnnotationType.Timeseries */.JJ.Timeseries],
        name: (0,TranslatorSingleton.t)('Time-series Stepped Line'),
        tags: [(0,TranslatorSingleton.t)('ECharts'), (0,TranslatorSingleton.t)('Predictive'), (0,TranslatorSingleton.t)('Advanced-Analytics'), (0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Time'), (0,TranslatorSingleton.t)('Transformable'), (0,TranslatorSingleton.t)('Stacked')],
        thumbnail: thumbnail
      }),
      transformProps: transformProps/* default */.Z
    });
  }

}

/***/ }),

/***/ 14396:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ buildQuery)
/* harmony export */ });
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69205);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(30005);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77249);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19751);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(67254);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(43806);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(87463);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(22535);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(11941);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(43276);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(43467);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


function buildQuery(formData) {
  return (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)(formData, baseQueryObject => {
    const pivotOperatorInRuntime = (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_1__/* .pivotOperator */ .H)(formData, { ...baseQueryObject,
      is_timeseries: true
    });

    if (pivotOperatorInRuntime && Object.values(_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__/* .RollingType */ .su).includes(formData.rolling_type)) {
      pivotOperatorInRuntime.options = { ...pivotOperatorInRuntime.options,
        ...{
          flatten_columns: false,
          reset_index: false
        }
      };
    }

    return [{ ...baseQueryObject,
      is_timeseries: true,
      // todo: move `normalizeOrderBy to extractQueryFields`
      orderby: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(baseQueryObject).orderby,
      time_offsets: (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_4__/* .isValidTimeCompare */ .A)(formData, baseQueryObject) ? formData.time_compare : [],
      post_processing: [(0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_5__/* .resampleOperator */ .X)(formData, baseQueryObject), (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_6__/* .timeCompareOperator */ .N)(formData, baseQueryObject), (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_7__/* .sortOperator */ .C)(formData, { ...baseQueryObject,
        is_timeseries: true
      }), // in order to be able to rolling in multiple series, must do pivot before rollingOperator
      pivotOperatorInRuntime, (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_8__/* .rollingWindowOperator */ .V)(formData, baseQueryObject), (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_9__/* .contributionOperator */ .I)(formData, baseQueryObject), (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_10__/* .prophetOperator */ .D)(formData, baseQueryObject)]
    }];
  });
}

/***/ }),

/***/ 54915:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsTimeseriesChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/types/AnnotationLayer.js
var AnnotationLayer = __webpack_require__(33484);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/buildQuery.js
var buildQuery = __webpack_require__(14396);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/types.js
var types = __webpack_require__(36913);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/controls.js
var controls = __webpack_require__(22297);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const {
  area: controlPanel_area,
  contributionMode,
  logAxis,
  markerEnabled,
  markerSize,
  minorSplitLine,
  opacity,
  rowLimit,
  seriesType,
  truncateYAxis,
  yAxisBounds,
  zoomable,
  xAxisLabelRotation
} = types/* DEFAULT_FORM_DATA */.En;
const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['metrics'], ['groupby'], [{
      name: 'contributionMode',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Contribution Mode'),
        default: contributionMode,
        choices: [[null, 'None'], [types/* EchartsTimeseriesContributionType.Row */.HE.Row, 'Total'], [types/* EchartsTimeseriesContributionType.Column */.HE.Column, 'Series']],
        description: (0,TranslatorSingleton.t)('Calculate contribution per series or total')
      }
    }], ['adhoc_filters'], emitFilterControl/* emitFilterControl */.a, ['limit'], ['timeseries_limit_metric'], [{
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort Descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending')
      }
    }], ['row_limit']]
  }, esm.sections.advancedAnalyticsControls, esm.sections.annotationsAndLayersControls, esm.sections.forecastIntervalControls, esm.sections.titleControls, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], [{
      name: 'seriesType',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Series Style'),
        renderTrigger: true,
        default: seriesType,
        choices: [[types/* EchartsTimeseriesSeriesType.Line */.mD.Line, 'Line'], [types/* EchartsTimeseriesSeriesType.Scatter */.mD.Scatter, 'Scatter'], [types/* EchartsTimeseriesSeriesType.Smooth */.mD.Smooth, 'Smooth Line'], [types/* EchartsTimeseriesSeriesType.Bar */.mD.Bar, 'Bar'], [types/* EchartsTimeseriesSeriesType.Start */.mD.Start, 'Step - start'], [types/* EchartsTimeseriesSeriesType.Middle */.mD.Middle, 'Step - middle'], [types/* EchartsTimeseriesSeriesType.End */.mD.End, 'Step - end']],
        description: (0,TranslatorSingleton.t)('Series chart type (line, bar etc)')
      }
    }], ...controls/* showValueSection */.eQ, [{
      name: 'area',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Area Chart'),
        renderTrigger: true,
        default: controlPanel_area,
        description: (0,TranslatorSingleton.t)('Draw area under curves. Only applicable for line types.')
      }
    }], [{
      name: 'opacity',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Area chart opacity'),
        renderTrigger: true,
        min: 0,
        max: 1,
        step: 0.1,
        default: opacity,
        description: (0,TranslatorSingleton.t)('Opacity of Area Chart. Also applies to confidence band.'),
        visibility: ({
          controls
        }) => {
          var _controls$area;

          return Boolean(controls == null ? void 0 : (_controls$area = controls.area) == null ? void 0 : _controls$area.value);
        }
      }
    }], [{
      name: 'markerEnabled',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Marker'),
        renderTrigger: true,
        default: markerEnabled,
        description: (0,TranslatorSingleton.t)('Draw a marker on data points. Only applicable for line types.')
      }
    }], [{
      name: 'markerSize',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Marker Size'),
        renderTrigger: true,
        min: 0,
        max: 20,
        default: markerSize,
        description: (0,TranslatorSingleton.t)('Size of marker. Also applies to forecast observations.'),
        visibility: ({
          controls
        }) => {
          var _controls$markerEnabl;

          return Boolean(controls == null ? void 0 : (_controls$markerEnabl = controls.markerEnabled) == null ? void 0 : _controls$markerEnabl.value);
        }
      }
    }], [{
      name: 'zoomable',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Data Zoom'),
        default: zoomable,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Enable data zooming controls')
      }
    }], ...controls/* legendSection */.q_, [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('X Axis'))], [{
      name: 'x_axis_time_format',
      config: { ...shared_controls/* sharedControls.x_axis_time_format */.Hq.x_axis_time_format,
        default: 'smart_date',
        description: `${D3Formatting/* D3_TIME_FORMAT_DOCS */.oq}. ${(0,TranslatorSingleton.t)('When using other than adaptive formatting, labels may overlap.')}`
      }
    }], [{
      name: 'xAxisLabelRotation',
      config: {
        type: 'SelectControl',
        freeForm: true,
        clearable: false,
        label: (0,TranslatorSingleton.t)('Rotate x axis label'),
        choices: [[0, '0°'], [45, '45°']],
        default: xAxisLabelRotation,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Input field supports custom rotation. e.g. 30 for 30°')
      }
    }], ...controls/* richTooltipSection */.oA, // eslint-disable-next-line react/jsx-key
    [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Y Axis'))], ['y_axis_format'], [{
      name: 'logAxis',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Logarithmic y-axis'),
        renderTrigger: true,
        default: logAxis,
        description: (0,TranslatorSingleton.t)('Logarithmic y-axis')
      }
    }], [{
      name: 'minorSplitLine',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Minor Split Line'),
        renderTrigger: true,
        default: minorSplitLine,
        description: (0,TranslatorSingleton.t)('Draw split lines for minor y-axis ticks')
      }
    }], [{
      name: 'truncateYAxis',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Truncate Y Axis'),
        default: truncateYAxis,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Truncate Y Axis. Can be overridden by specifying a min or max bound.')
      }
    }], [{
      name: 'y_axis_bounds',
      config: {
        type: 'BoundsControl',
        label: (0,TranslatorSingleton.t)('Y Axis Bounds'),
        renderTrigger: true,
        default: yAxisBounds,
        description: (0,TranslatorSingleton.t)('Bounds for the Y-axis. When left empty, the bounds are ' + 'dynamically defined based on the min/max of the data. Note that ' + "this feature will only expand the axis range. It won't " + "narrow the data's extent."),
        visibility: ({
          controls
        }) => {
          var _controls$truncateYAx;

          return Boolean(controls == null ? void 0 : (_controls$truncateYAx = controls.truncateYAxis) == null ? void 0 : _controls$truncateYAx.value);
        }
      }
    }]]
  }],
  controlOverrides: {
    row_limit: {
      default: rowLimit
    }
  }
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/transformProps.js
var transformProps = __webpack_require__(76034);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/images/thumbnail.png
var thumbnail = __webpack_require__(84345);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/images/Time-series_Chart.jpg
var Time_series_Chart = __webpack_require__(86596);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Timeseries/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






class EchartsTimeseriesChartPlugin extends ChartPlugin/* default */.Z {
  /**
   * The constructor is used to pass relevant metadata and callbacks that get
   * registered in respective registries that are used throughout the library
   * and application. A more thorough description of each property is given in
   * the respective imported file.
   *
   * It is worth noting that `buildQuery` and is optional, and only needed for
   * advanced visualizations that require either post processing operations
   * (pivoting, rolling aggregations, sorting etc) or submitting multiple queries.
   */
  constructor() {
    super({
      buildQuery: buildQuery/* default */.Z,
      controlPanel: controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 4441).then(__webpack_require__.bind(__webpack_require__, 34441)),
      metadata: new ChartMetadata/* default */.Z({
        behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
        category: (0,TranslatorSingleton.t)('Evolution'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)('Swiss army knife for visualizing time series data. Choose between  step, line, scatter, and bar charts. This viz type has many customization options as well.'),
        exampleGallery: [{
          url: Time_series_Chart
        }],
        supportedAnnotationTypes: [AnnotationLayer/* AnnotationType.Event */.JJ.Event, AnnotationLayer/* AnnotationType.Formula */.JJ.Formula, AnnotationLayer/* AnnotationType.Interval */.JJ.Interval, AnnotationLayer/* AnnotationType.Timeseries */.JJ.Timeseries],
        name: (0,TranslatorSingleton.t)('Time-series Chart'),
        tags: [(0,TranslatorSingleton.t)('Advanced-Analytics'), (0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Line'), (0,TranslatorSingleton.t)('Predictive'), (0,TranslatorSingleton.t)('Time'), (0,TranslatorSingleton.t)('Transformable')],
        thumbnail: thumbnail
      }),
      transformProps: transformProps/* default */.Z
    });
  }

}

/***/ }),

/***/ 76034:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ transformProps)
/* harmony export */ });
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83527);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(50855);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(33484);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36913);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(94980);
/* harmony import */ var _utils_controls__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(26091);
/* harmony import */ var _utils_series__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66978);
/* harmony import */ var _utils_annotation__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(56008);
/* harmony import */ var _utils_prophet__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(50327);
/* harmony import */ var _defaults__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(97711);
/* harmony import */ var _transformers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(72585);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(23788);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/* eslint-disable camelcase */










function transformProps(chartProps) {
  const {
    width,
    height,
    filterState,
    formData,
    hooks,
    queriesData,
    datasource
  } = chartProps;
  const {
    verboseMap = {}
  } = datasource;
  const {
    annotation_data: annotationData_,
    data = []
  } = queriesData[0];
  const annotationData = annotationData_ || {};
  const {
    area,
    annotationLayers,
    colorScheme,
    contributionMode,
    forecastEnabled,
    legendOrientation,
    legendType,
    logAxis,
    markerEnabled,
    markerSize,
    opacity,
    minorSplitLine,
    seriesType,
    showLegend,
    stack,
    truncateYAxis,
    yAxisFormat,
    xAxisTimeFormat,
    yAxisBounds,
    tooltipTimeFormat,
    tooltipSortByMetric,
    zoomable,
    richTooltip,
    xAxisLabelRotation,
    emitFilter,
    groupby,
    showValue,
    onlyTotal,
    xAxisTitle,
    yAxisTitle,
    xAxisTitleMargin,
    yAxisTitleMargin,
    yAxisTitlePosition
  } = { ..._types__WEBPACK_IMPORTED_MODULE_0__/* .DEFAULT_FORM_DATA */ .En,
    ...formData
  };
  const colorScale = _superset_ui_core__WEBPACK_IMPORTED_MODULE_1__.getScale(colorScheme);
  const rebasedData = (0,_utils_prophet__WEBPACK_IMPORTED_MODULE_2__/* .rebaseTimeseriesDatum */ .Hc)(data, verboseMap);
  const rawSeries = (0,_utils_series__WEBPACK_IMPORTED_MODULE_3__/* .extractTimeseriesSeries */ .vT)(rebasedData, {
    fillNeighborValue: stack && !forecastEnabled ? 0 : undefined
  });
  const seriesContexts = (0,_utils_prophet__WEBPACK_IMPORTED_MODULE_2__/* .extractForecastSeriesContexts */ .U_)(Object.values(rawSeries).map(series => series.name));
  const series = [];
  const formatter = (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_4__/* .getNumberFormatter */ .JB)(contributionMode ? ',.0%' : yAxisFormat);
  const totalStackedValues = [];
  const showValueIndexes = [];
  rebasedData.forEach(data => {
    const values = Object.keys(data).reduce((prev, curr) => {
      if (curr === '__timestamp') {
        return prev;
      }

      const value = data[curr] || 0;
      return prev + value;
    }, 0);
    totalStackedValues.push(values);
  });

  if (stack) {
    rawSeries.forEach((entry, seriesIndex) => {
      const {
        data = []
      } = entry;
      data.forEach((datum, dataIndex) => {
        if (datum[1] !== null) {
          showValueIndexes[dataIndex] = seriesIndex;
        }
      });
    });
  }

  rawSeries.forEach(entry => {
    const transformedSeries = (0,_transformers__WEBPACK_IMPORTED_MODULE_5__/* .transformSeries */ .FN)(entry, colorScale, {
      area,
      filterState,
      seriesContexts,
      markerEnabled,
      markerSize,
      areaOpacity: opacity,
      seriesType,
      stack,
      formatter,
      showValue,
      onlyTotal,
      totalStackedValues,
      showValueIndexes,
      richTooltip
    });
    if (transformedSeries) series.push(transformedSeries);
  });
  const selectedValues = (filterState.selectedValues || []).reduce((acc, selectedValue) => {
    const index = series.findIndex(({
      name
    }) => name === selectedValue);
    return { ...acc,
      [index]: selectedValue
    };
  }, {});
  annotationLayers.filter(layer => layer.show).forEach(layer => {
    if ((0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_6__/* .isFormulaAnnotationLayer */ .x5)(layer)) series.push((0,_transformers__WEBPACK_IMPORTED_MODULE_5__/* .transformFormulaAnnotation */ ._d)(layer, data, colorScale));else if ((0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_6__/* .isIntervalAnnotationLayer */ .Ry)(layer)) {
      series.push(...(0,_transformers__WEBPACK_IMPORTED_MODULE_5__/* .transformIntervalAnnotation */ .kK)(layer, data, annotationData, colorScale));
    } else if ((0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_6__/* .isEventAnnotationLayer */ .pD)(layer)) {
      series.push(...(0,_transformers__WEBPACK_IMPORTED_MODULE_5__/* .transformEventAnnotation */ .r)(layer, data, annotationData, colorScale));
    } else if ((0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_6__/* .isTimeseriesAnnotationLayer */ .nl)(layer)) {
      series.push(...(0,_transformers__WEBPACK_IMPORTED_MODULE_5__/* .transformTimeseriesAnnotation */ .rR)(layer, markerSize, data, annotationData));
    }
  }); // yAxisBounds need to be parsed to replace incompatible values with undefined

  let [min, max] = (yAxisBounds || []).map(_utils_controls__WEBPACK_IMPORTED_MODULE_7__/* .parseYAxisBound */ .p); // default to 0-100% range when doing row-level contribution chart

  if (contributionMode === 'row' && stack) {
    if (min === undefined) min = 0;
    if (max === undefined) max = 1;
  }

  const tooltipFormatter = (0,_transformers__WEBPACK_IMPORTED_MODULE_5__/* .getTooltipTimeFormatter */ .hq)(tooltipTimeFormat);
  const xAxisFormatter = (0,_transformers__WEBPACK_IMPORTED_MODULE_5__/* .getXAxisFormatter */ .pc)(xAxisTimeFormat);
  const labelMap = series.reduce((acc, datum) => {
    const name = datum.name;
    return { ...acc,
      [name]: [name]
    };
  }, {});
  const {
    setDataMask = () => {}
  } = hooks;
  const addYAxisLabelOffset = !!yAxisTitle;
  const addXAxisLabelOffset = !!xAxisTitle;
  const padding = (0,_transformers__WEBPACK_IMPORTED_MODULE_5__/* .getPadding */ .tQ)(showLegend, legendOrientation, addYAxisLabelOffset, zoomable, null, addXAxisLabelOffset, yAxisTitlePosition, yAxisTitleMargin, xAxisTitleMargin);
  const legendData = rawSeries.filter(entry => (0,_utils_prophet__WEBPACK_IMPORTED_MODULE_2__/* .extractForecastSeriesContext */ .Nr)(entry.name || '').type === _types__WEBPACK_IMPORTED_MODULE_8__/* .ForecastSeriesEnum.Observation */ .i1.Observation).map(entry => entry.name || '').concat((0,_utils_annotation__WEBPACK_IMPORTED_MODULE_9__/* .extractAnnotationLabels */ .Ky)(annotationLayers, annotationData));
  const echartOptions = {
    useUTC: true,
    grid: { ..._defaults__WEBPACK_IMPORTED_MODULE_10__/* .defaultGrid */ .oe,
      ...padding
    },
    xAxis: {
      type: 'time',
      name: xAxisTitle,
      nameGap: xAxisTitleMargin,
      nameLocation: 'middle',
      axisLabel: {
        hideOverlap: true,
        formatter: xAxisFormatter,
        rotate: xAxisLabelRotation
      }
    },
    yAxis: { ..._defaults__WEBPACK_IMPORTED_MODULE_10__/* .defaultYAxis */ .C0,
      type: logAxis ? 'log' : 'value',
      min,
      max,
      minorTick: {
        show: true
      },
      minorSplitLine: {
        show: minorSplitLine
      },
      axisLabel: {
        formatter
      },
      scale: truncateYAxis,
      name: yAxisTitle,
      nameGap: yAxisTitleMargin,
      nameLocation: yAxisTitlePosition === 'Left' ? 'middle' : 'end'
    },
    tooltip: { ..._defaults__WEBPACK_IMPORTED_MODULE_10__/* .defaultTooltip */ .Ku,
      appendToBody: true,
      trigger: richTooltip ? 'axis' : 'item',
      formatter: params => {
        const xValue = richTooltip ? params[0].value[0] : params.value[0];
        const prophetValue = richTooltip ? params : [params];

        if (richTooltip && tooltipSortByMetric) {
          prophetValue.sort((a, b) => b.data[1] - a.data[1]);
        }

        const rows = [`${tooltipFormatter(xValue)}`];
        const prophetValues = (0,_utils_prophet__WEBPACK_IMPORTED_MODULE_2__/* .extractProphetValuesFromTooltipParams */ .LQ)(prophetValue);
        Object.keys(prophetValues).forEach(key => {
          const value = prophetValues[key];
          const content = (0,_utils_prophet__WEBPACK_IMPORTED_MODULE_2__/* .formatProphetTooltipSeries */ .Ft)({ ...value,
            seriesName: key,
            formatter
          });

          if (_utils_series__WEBPACK_IMPORTED_MODULE_3__/* .currentSeries.name */ .aI.name === key) {
            rows.push(`<span style="font-weight: 700">${content}</span>`);
          } else {
            rows.push(`<span style="opacity: 0.7">${content}</span>`);
          }
        });
        return rows.join('<br />');
      }
    },
    legend: { ...(0,_utils_series__WEBPACK_IMPORTED_MODULE_3__/* .getLegendProps */ .zp)(legendType, legendOrientation, showLegend, zoomable),
      data: legendData
    },
    series: (0,_utils_series__WEBPACK_IMPORTED_MODULE_3__/* .dedupSeries */ .IE)(series),
    toolbox: {
      show: zoomable,
      top: _constants__WEBPACK_IMPORTED_MODULE_11__/* .TIMESERIES_CONSTANTS.toolboxTop */ .SM.toolboxTop,
      right: _constants__WEBPACK_IMPORTED_MODULE_11__/* .TIMESERIES_CONSTANTS.toolboxRight */ .SM.toolboxRight,
      feature: {
        dataZoom: {
          yAxisIndex: false,
          title: {
            zoom: 'zoom area',
            back: 'restore zoom'
          }
        }
      }
    },
    dataZoom: zoomable ? [{
      type: 'slider',
      start: _constants__WEBPACK_IMPORTED_MODULE_11__/* .TIMESERIES_CONSTANTS.dataZoomStart */ .SM.dataZoomStart,
      end: _constants__WEBPACK_IMPORTED_MODULE_11__/* .TIMESERIES_CONSTANTS.dataZoomEnd */ .SM.dataZoomEnd,
      bottom: _constants__WEBPACK_IMPORTED_MODULE_11__/* .TIMESERIES_CONSTANTS.zoomBottom */ .SM.zoomBottom
    }] : []
  };
  return {
    echartOptions,
    emitFilter,
    formData,
    groupby,
    height,
    labelMap,
    selectedValues,
    setDataMask,
    width,
    legendData
  };
}

/***/ }),

/***/ 72585:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FN": () => (/* binding */ transformSeries),
/* harmony export */   "_d": () => (/* binding */ transformFormulaAnnotation),
/* harmony export */   "kK": () => (/* binding */ transformIntervalAnnotation),
/* harmony export */   "r": () => (/* binding */ transformEventAnnotation),
/* harmony export */   "rR": () => (/* binding */ transformTimeseriesAnnotation),
/* harmony export */   "tQ": () => (/* binding */ getPadding),
/* harmony export */   "hq": () => (/* binding */ getTooltipTimeFormatter),
/* harmony export */   "pc": () => (/* binding */ getXAxisFormatter)
/* harmony export */ });
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33484);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11304);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(75497);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(14826);
/* harmony import */ var _utils_prophet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(50327);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(94980);
/* harmony import */ var _utils_annotation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(56008);
/* harmony import */ var _utils_series__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66978);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(23788);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






function transformSeries(series, colorScale, opts) {
  const {
    name
  } = series;
  const {
    area,
    filterState,
    seriesContexts = {},
    markerEnabled,
    markerSize,
    areaOpacity = 1,
    seriesType,
    stack,
    yAxisIndex = 0,
    showValue,
    onlyTotal,
    formatter,
    totalStackedValues = [],
    showValueIndexes = [],
    richTooltip
  } = opts;
  const contexts = seriesContexts[name || ''] || [];
  const hasForecast = contexts.includes(_types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastTrend */ .i1.ForecastTrend) || contexts.includes(_types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastLower */ .i1.ForecastLower) || contexts.includes(_types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastUpper */ .i1.ForecastUpper);
  const forecastSeries = (0,_utils_prophet__WEBPACK_IMPORTED_MODULE_1__/* .extractForecastSeriesContext */ .Nr)(name || '');
  const isConfidenceBand = forecastSeries.type === _types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastLower */ .i1.ForecastLower || forecastSeries.type === _types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastUpper */ .i1.ForecastUpper;
  const isFiltered = (filterState == null ? void 0 : filterState.selectedValues) && !(filterState != null && filterState.selectedValues.includes(name));
  const opacity = isFiltered ? _constants__WEBPACK_IMPORTED_MODULE_2__/* .OpacityEnum.SemiTransparent */ .ZV.SemiTransparent : _constants__WEBPACK_IMPORTED_MODULE_2__/* .OpacityEnum.NonTransparent */ .ZV.NonTransparent; // don't create a series if doing a stack or area chart and the result
  // is a confidence band

  if ((stack || area) && isConfidenceBand) return undefined;
  const isObservation = forecastSeries.type === _types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.Observation */ .i1.Observation;
  const isTrend = forecastSeries.type === _types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastTrend */ .i1.ForecastTrend;
  let stackId;

  if (isConfidenceBand) {
    stackId = forecastSeries.name;
  } else if (stack && isObservation) {
    // the suffix of the observation series is '' (falsy), which disables
    // stacking. Therefore we need to set something that is truthy.
    stackId = 'obs';
  } else if (stack && isTrend) {
    stackId = forecastSeries.type;
  }

  let plotType;

  if (!isConfidenceBand && (seriesType === 'scatter' || hasForecast && isObservation)) {
    plotType = 'scatter';
  } else if (isConfidenceBand) {
    plotType = 'line';
  } else {
    plotType = seriesType === 'bar' ? 'bar' : 'line';
  }

  const itemStyle = {
    color: colorScale(forecastSeries.name),
    opacity
  };
  let emphasis = {};
  let showSymbol = false;

  if (!isConfidenceBand) {
    if (plotType === 'scatter') {
      showSymbol = true;
    } else if (hasForecast && isObservation) {
      showSymbol = true;
    } else if (plotType === 'line' && showValue) {
      showSymbol = true;
    } else if (plotType === 'line' && !richTooltip && !markerEnabled) {
      // this is hack to make timeseries line chart clickable when tooltip trigger is 'item'
      // so that the chart can emit cross-filtering
      showSymbol = true;
      itemStyle.opacity = 0;
      emphasis = {
        itemStyle: {
          opacity: 1
        }
      };
    } else if (markerEnabled) {
      showSymbol = true;
    }
  }

  const lineStyle = isConfidenceBand ? {
    opacity: _constants__WEBPACK_IMPORTED_MODULE_2__/* .OpacityEnum.Transparent */ .ZV.Transparent
  } : {
    opacity
  };
  return { ...series,
    yAxisIndex,
    name: forecastSeries.name,
    itemStyle,
    // @ts-ignore
    type: plotType,
    smooth: seriesType === 'smooth',
    triggerLineEvent: true,
    // @ts-ignore
    step: ['start', 'middle', 'end'].includes(seriesType) ? seriesType : undefined,
    stack: stackId,
    lineStyle,
    areaStyle: area || forecastSeries.type === _types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastUpper */ .i1.ForecastUpper ? {
      opacity: opacity * areaOpacity
    } : undefined,
    emphasis,
    showSymbol,
    symbolSize: markerSize,
    label: {
      show: !!showValue,
      position: 'top',
      formatter: params => {
        const {
          value: [, numericValue],
          dataIndex,
          seriesIndex,
          seriesName
        } = params;
        const isSelectedLegend = _utils_series__WEBPACK_IMPORTED_MODULE_3__/* .currentSeries.legend */ .aI.legend === seriesName;
        if (!formatter) return numericValue;

        if (!stack || !onlyTotal || isSelectedLegend) {
          return formatter(numericValue);
        }

        if (seriesIndex === showValueIndexes[dataIndex]) {
          return formatter(totalStackedValues[dataIndex]);
        }

        return '';
      }
    }
  };
}
function transformFormulaAnnotation(layer, data, colorScale) {
  const {
    name,
    color,
    opacity,
    width,
    style
  } = layer;
  return {
    name,
    id: name,
    itemStyle: {
      color: color || colorScale(name)
    },
    lineStyle: {
      opacity: (0,_utils_annotation__WEBPACK_IMPORTED_MODULE_4__/* .parseAnnotationOpacity */ .lh)(opacity),
      type: style,
      width
    },
    type: 'line',
    smooth: true,
    data: (0,_utils_annotation__WEBPACK_IMPORTED_MODULE_4__/* .evalFormula */ .ns)(layer, data),
    symbolSize: 0
  };
}
function transformIntervalAnnotation(layer, data, annotationData, colorScale) {
  const series = [];
  const annotations = (0,_utils_annotation__WEBPACK_IMPORTED_MODULE_4__/* .extractRecordAnnotations */ .JB)(layer, annotationData);
  annotations.forEach(annotation => {
    const {
      name,
      color,
      opacity
    } = layer;
    const {
      descriptions,
      intervalEnd,
      time,
      title
    } = annotation;
    const label = (0,_utils_annotation__WEBPACK_IMPORTED_MODULE_4__/* .formatAnnotationLabel */ .Sk)(name, title, descriptions);
    const intervalData = [[{
      name: label,
      xAxis: time
    }, {
      xAxis: intervalEnd
    }]];
    series.push({
      id: `Interval - ${label}`,
      type: 'line',
      animation: false,
      markArea: {
        silent: false,
        itemStyle: {
          color: color || colorScale(name),
          opacity: (0,_utils_annotation__WEBPACK_IMPORTED_MODULE_4__/* .parseAnnotationOpacity */ .lh)(opacity || _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__/* .AnnotationOpacity.Medium */ .TJ.Medium),
          emphasis: {
            opacity: 0.8
          }
        },
        label: {
          show: false,
          color: '#000000',
          // @ts-ignore
          emphasis: {
            fontWeight: 'bold',
            show: true,
            position: 'insideTop',
            verticalAlign: 'top',
            backgroundColor: '#ffffff'
          }
        },
        data: intervalData
      }
    });
  });
  return series;
}
function transformEventAnnotation(layer, data, annotationData, colorScale) {
  const series = [];
  const annotations = (0,_utils_annotation__WEBPACK_IMPORTED_MODULE_4__/* .extractRecordAnnotations */ .JB)(layer, annotationData);
  annotations.forEach(annotation => {
    const {
      name,
      color,
      opacity,
      style,
      width
    } = layer;
    const {
      descriptions,
      time,
      title
    } = annotation;
    const label = (0,_utils_annotation__WEBPACK_IMPORTED_MODULE_4__/* .formatAnnotationLabel */ .Sk)(name, title, descriptions);
    const eventData = [{
      name: label,
      xAxis: time
    }];
    const lineStyle = {
      width,
      type: style,
      color: color || colorScale(name),
      opacity: (0,_utils_annotation__WEBPACK_IMPORTED_MODULE_4__/* .parseAnnotationOpacity */ .lh)(opacity),
      emphasis: {
        width: width ? width + 1 : width,
        opacity: 1
      }
    };
    series.push({
      id: `Event - ${label}`,
      type: 'line',
      animation: false,
      markLine: {
        silent: false,
        symbol: 'none',
        lineStyle,
        label: {
          show: false,
          color: '#000000',
          position: 'insideEndTop',
          // @ts-ignore
          emphasis: {
            formatter: params => params.name,
            fontWeight: 'bold',
            show: true,
            backgroundColor: '#ffffff'
          }
        },
        data: eventData
      }
    });
  });
  return series;
}
function transformTimeseriesAnnotation(layer, markerSize, data, annotationData) {
  const series = [];
  const {
    hideLine,
    name,
    opacity,
    showMarkers,
    style,
    width
  } = layer;
  const result = annotationData[name];

  if ((0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_5__/* .isTimeseriesAnnotationResult */ .b4)(result)) {
    result.forEach(annotation => {
      const {
        key,
        values
      } = annotation;
      series.push({
        type: 'line',
        id: key,
        name: key,
        data: values.map(row => [row.x, row.y]),
        symbolSize: showMarkers ? markerSize : 0,
        lineStyle: {
          opacity: (0,_utils_annotation__WEBPACK_IMPORTED_MODULE_4__/* .parseAnnotationOpacity */ .lh)(opacity),
          type: style,
          width: hideLine ? 0 : width
        }
      });
    });
  }

  return series;
}
function getPadding(showLegend, legendOrientation, addYAxisTitleOffset, zoomable, margin, addXAxisTitleOffset, yAxisTitlePosition, yAxisTitleMargin, xAxisTitleMargin) {
  const yAxisOffset = addYAxisTitleOffset ? _constants__WEBPACK_IMPORTED_MODULE_2__/* .TIMESERIES_CONSTANTS.yAxisLabelTopOffset */ .SM.yAxisLabelTopOffset : 0;
  const xAxisOffset = addXAxisTitleOffset ? xAxisTitleMargin || 0 : 0;
  return (0,_utils_series__WEBPACK_IMPORTED_MODULE_3__/* .getChartPadding */ .G_)(showLegend, legendOrientation, margin, {
    top: yAxisTitlePosition && yAxisTitlePosition === 'Top' ? _constants__WEBPACK_IMPORTED_MODULE_2__/* .TIMESERIES_CONSTANTS.gridOffsetTop */ .SM.gridOffsetTop + (yAxisTitleMargin || 0) : _constants__WEBPACK_IMPORTED_MODULE_2__/* .TIMESERIES_CONSTANTS.gridOffsetTop */ .SM.gridOffsetTop + yAxisOffset,
    bottom: zoomable ? _constants__WEBPACK_IMPORTED_MODULE_2__/* .TIMESERIES_CONSTANTS.gridOffsetBottomZoomable */ .SM.gridOffsetBottomZoomable + xAxisOffset : _constants__WEBPACK_IMPORTED_MODULE_2__/* .TIMESERIES_CONSTANTS.gridOffsetBottom */ .SM.gridOffsetBottom + xAxisOffset,
    left: yAxisTitlePosition === 'Left' ? _constants__WEBPACK_IMPORTED_MODULE_2__/* .TIMESERIES_CONSTANTS.gridOffsetLeft */ .SM.gridOffsetLeft + (yAxisTitleMargin || 0) : _constants__WEBPACK_IMPORTED_MODULE_2__/* .TIMESERIES_CONSTANTS.gridOffsetLeft */ .SM.gridOffsetLeft,
    right: showLegend && legendOrientation === _types__WEBPACK_IMPORTED_MODULE_0__/* .LegendOrientation.Right */ .IY.Right ? 0 : _constants__WEBPACK_IMPORTED_MODULE_2__/* .TIMESERIES_CONSTANTS.gridOffsetRight */ .SM.gridOffsetRight
  });
}
function getTooltipTimeFormatter(format) {
  if (format === _superset_ui_core__WEBPACK_IMPORTED_MODULE_6__/* ["default"].id */ .Z.id) {
    return _superset_ui_core__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z;
  }

  if (format) {
    return (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_8__/* .getTimeFormatter */ .bt)(format);
  }

  return String;
}
function getXAxisFormatter(format) {
  if (format === _superset_ui_core__WEBPACK_IMPORTED_MODULE_6__/* ["default"].id */ .Z.id || !format) {
    return undefined;
  }

  if (format) {
    return (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_8__/* .getTimeFormatter */ .bt)(format);
  }

  return String;
}

/***/ }),

/***/ 36913:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HE": () => (/* binding */ EchartsTimeseriesContributionType),
/* harmony export */   "mD": () => (/* binding */ EchartsTimeseriesSeriesType),
/* harmony export */   "En": () => (/* binding */ DEFAULT_FORM_DATA)
/* harmony export */ });
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88483);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(94980);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


let EchartsTimeseriesContributionType;

(function (EchartsTimeseriesContributionType) {
  EchartsTimeseriesContributionType["Row"] = "row";
  EchartsTimeseriesContributionType["Column"] = "column";
})(EchartsTimeseriesContributionType || (EchartsTimeseriesContributionType = {}));

let EchartsTimeseriesSeriesType;

(function (EchartsTimeseriesSeriesType) {
  EchartsTimeseriesSeriesType["Line"] = "line";
  EchartsTimeseriesSeriesType["Scatter"] = "scatter";
  EchartsTimeseriesSeriesType["Smooth"] = "smooth";
  EchartsTimeseriesSeriesType["Bar"] = "bar";
  EchartsTimeseriesSeriesType["Start"] = "start";
  EchartsTimeseriesSeriesType["Middle"] = "middle";
  EchartsTimeseriesSeriesType["End"] = "end";
})(EchartsTimeseriesSeriesType || (EchartsTimeseriesSeriesType = {}));

// @ts-ignore
const DEFAULT_FORM_DATA = { ..._types__WEBPACK_IMPORTED_MODULE_0__/* .DEFAULT_LEGEND_FORM_DATA */ .xo,
  annotationLayers: _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_1__.sections.annotationLayers,
  area: false,
  forecastEnabled: _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_1__.sections.FORECAST_DEFAULT_DATA.forecastEnabled,
  forecastInterval: _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_1__.sections.FORECAST_DEFAULT_DATA.forecastInterval,
  forecastPeriods: _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_1__.sections.FORECAST_DEFAULT_DATA.forecastPeriods,
  forecastSeasonalityDaily: _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_1__.sections.FORECAST_DEFAULT_DATA.forecastSeasonalityDaily,
  forecastSeasonalityWeekly: _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_1__.sections.FORECAST_DEFAULT_DATA.forecastSeasonalityWeekly,
  forecastSeasonalityYearly: _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_1__.sections.FORECAST_DEFAULT_DATA.forecastSeasonalityYearly,
  logAxis: false,
  markerEnabled: false,
  markerSize: 6,
  minorSplitLine: false,
  opacity: 0.2,
  orderDesc: true,
  rowLimit: 10000,
  seriesType: EchartsTimeseriesSeriesType.Line,
  stack: false,
  tooltipTimeFormat: 'smart_date',
  truncateYAxis: true,
  yAxisBounds: [null, null],
  zoomable: false,
  richTooltip: true,
  xAxisLabelRotation: 0,
  emitFilter: false,
  groupby: [],
  showValue: false,
  onlyTotal: false,
  ..._types__WEBPACK_IMPORTED_MODULE_0__/* .DEFAULT_TITLE_FORM_DATA */ .f6
};

/***/ }),

/***/ 52595:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsTreeChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/utils/featureFlags.js
var featureFlags = __webpack_require__(46415);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Tree/types.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const DEFAULT_FORM_DATA = {
  id: '',
  parent: '',
  name: '',
  rootNodeId: '',
  layout: 'orthogonal',
  orient: 'LR',
  symbol: 'emptyCircle',
  symbolSize: 7,
  roam: true,
  nodeLabelPosition: 'left',
  childLabelPosition: 'bottom',
  emphasis: 'descendant'
};
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Tree/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const requiredEntity = { ...shared_controls/* sharedControls.entity */.Hq.entity,
  clearable: false
};
const optionalEntity = { ...shared_controls/* sharedControls.entity */.Hq.entity,
  clearable: true,
  validators: []
};
const controlPanel = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[{
      name: 'id',
      config: { ...requiredEntity,
        label: (0,TranslatorSingleton.t)('Id'),
        description: (0,TranslatorSingleton.t)('Name of the id column')
      }
    }], [{
      name: 'parent',
      config: { ...requiredEntity,
        label: (0,TranslatorSingleton.t)('Parent'),
        description: (0,TranslatorSingleton.t)('Name of the column containing the id of the parent node')
      }
    }], [{
      name: 'name',
      config: { ...optionalEntity,
        label: (0,TranslatorSingleton.t)('Name'),
        description: (0,TranslatorSingleton.t)('Optional name of the data column.')
      }
    }], [{
      name: 'root_node_id',
      config: { ...optionalEntity,
        renderTrigger: true,
        type: 'TextControl',
        label: (0,TranslatorSingleton.t)('Root node id'),
        description: (0,TranslatorSingleton.t)('Id of root node of the tree.')
      }
    }], [{
      name: 'metric',
      config: { ...optionalEntity,
        type: (0,featureFlags/* isFeatureEnabled */.c)(featureFlags/* FeatureFlag.ENABLE_EXPLORE_DRAG_AND_DROP */.T.ENABLE_EXPLORE_DRAG_AND_DROP) ? 'DndMetricSelect' : 'MetricsControl',
        label: (0,TranslatorSingleton.t)('Metric'),
        description: (0,TranslatorSingleton.t)('Metric for node values')
      }
    }], ['adhoc_filters'], ['row_limit']]
  }, {
    label: (0,TranslatorSingleton.t)('Chart options'),
    expanded: true,
    controlSetRows: [[(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Layout'))], [{
      name: 'layout',
      config: {
        type: 'RadioButtonControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Tree layout'),
        default: DEFAULT_FORM_DATA.layout,
        options: [['orthogonal', (0,TranslatorSingleton.t)('Orthogonal')], ['radial', (0,TranslatorSingleton.t)('Radial')]],
        description: (0,TranslatorSingleton.t)('Layout type of tree')
      }
    }], [{
      name: 'orient',
      config: {
        type: 'RadioButtonControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Tree orientation'),
        default: DEFAULT_FORM_DATA.orient,
        options: [['LR', (0,TranslatorSingleton.t)('Left to Right')], ['RL', (0,TranslatorSingleton.t)('Right to Left')], ['TB', (0,TranslatorSingleton.t)('Top to Bottom')], ['BT', (0,TranslatorSingleton.t)('Bottom to Top')]],
        description: (0,TranslatorSingleton.t)('Orientation of tree'),

        visibility({
          form_data: {
            layout
          }
        }) {
          return (layout || DEFAULT_FORM_DATA.layout) === 'orthogonal';
        }

      }
    }], [{
      name: 'node_label_position',
      config: {
        type: 'RadioButtonControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Node label position'),
        default: DEFAULT_FORM_DATA.nodeLabelPosition,
        options: [['left', (0,TranslatorSingleton.t)('left')], ['top', (0,TranslatorSingleton.t)('top')], ['right', (0,TranslatorSingleton.t)('right')], ['bottom', (0,TranslatorSingleton.t)('bottom')]],
        description: (0,TranslatorSingleton.t)('Position of intermidiate node label on tree')
      }
    }], [{
      name: 'child_label_position',
      config: {
        type: 'RadioButtonControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Child label position'),
        default: DEFAULT_FORM_DATA.childLabelPosition,
        options: [['left', (0,TranslatorSingleton.t)('left')], ['top', (0,TranslatorSingleton.t)('top')], ['right', (0,TranslatorSingleton.t)('right')], ['bottom', (0,TranslatorSingleton.t)('bottom')]],
        description: (0,TranslatorSingleton.t)('Position of child node label on tree')
      }
    }], [{
      name: 'emphasis',
      config: {
        type: 'RadioButtonControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Emphasis'),
        default: DEFAULT_FORM_DATA.emphasis,
        options: [['ancestor', (0,TranslatorSingleton.t)('ancestor')], ['descendant', (0,TranslatorSingleton.t)('descendant')]],
        description: (0,TranslatorSingleton.t)('Which relatives to highlight on hover'),

        visibility({
          form_data: {
            layout
          }
        }) {
          return (layout || DEFAULT_FORM_DATA.layout) === 'orthogonal';
        }

      }
    }], [{
      name: 'symbol',
      config: {
        type: 'SelectControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Symbol'),
        default: DEFAULT_FORM_DATA.symbol,
        options: [{
          label: (0,TranslatorSingleton.t)('Empty circle'),
          value: 'emptyCircle'
        }, {
          label: (0,TranslatorSingleton.t)('Circle'),
          value: 'circle'
        }, {
          label: (0,TranslatorSingleton.t)('Rectangle'),
          value: 'rect'
        }, {
          label: (0,TranslatorSingleton.t)('Triangle'),
          value: 'triangle'
        }, {
          label: (0,TranslatorSingleton.t)('Diamond'),
          value: 'diamond'
        }, {
          label: (0,TranslatorSingleton.t)('Pin'),
          value: 'pin'
        }, {
          label: (0,TranslatorSingleton.t)('Arrow'),
          value: 'arrow'
        }, {
          label: (0,TranslatorSingleton.t)('None'),
          value: 'none'
        }],
        description: (0,TranslatorSingleton.t)('Layout type of tree')
      }
    }], [{
      name: 'symbolSize',
      config: {
        type: 'SliderControl',
        label: (0,TranslatorSingleton.t)('Symbol size'),
        renderTrigger: true,
        min: 5,
        max: 30,
        step: 2,
        default: DEFAULT_FORM_DATA.symbolSize,
        description: (0,TranslatorSingleton.t)('Size of edge symbols')
      }
    }], [{
      name: 'roam',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Enable graph roaming'),
        renderTrigger: true,
        default: DEFAULT_FORM_DATA.roam,
        choices: [[false, (0,TranslatorSingleton.t)('Disabled')], ['scale', (0,TranslatorSingleton.t)('Scale only')], ['move', (0,TranslatorSingleton.t)('Move only')], [true, (0,TranslatorSingleton.t)('Scale and Move')]],
        description: (0,TranslatorSingleton.t)('Whether to enable changing graph position and scaling.')
      }
    }]]
  }]
};
/* harmony default export */ const Tree_controlPanel = (controlPanel);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/getMetricLabel.js
var getMetricLabel = __webpack_require__(95669);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Tree/constants.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const DEFAULT_TREE_SERIES_OPTION = {
  label: {
    position: 'left',
    fontSize: 15
  },
  animation: true,
  animationDuration: 500,
  animationEasing: 'cubicOut',
  lineStyle: {
    color: 'source',
    width: 1.5
  }
};
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Tree/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



function formatTooltip({
  params,
  metricLabel
}) {
  const {
    value,
    treeAncestors
  } = params;
  const treePath = (treeAncestors ?? []).map(pathInfo => (pathInfo == null ? void 0 : pathInfo.name) || '').filter(path => path !== '');
  return [`<div>${treePath.join(' ▸ ')}</div>`, value ? `${metricLabel}: ${value}` : ''].join('');
}
function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData
  } = chartProps;
  const data = queriesData[0].data || [];
  const {
    id,
    parent,
    name,
    metric = '',
    rootNodeId,
    layout,
    orient,
    symbol,
    symbolSize,
    roam,
    nodeLabelPosition,
    childLabelPosition,
    emphasis
  } = { ...DEFAULT_FORM_DATA,
    ...formData
  };
  const metricLabel = (0,getMetricLabel/* default */.Z)(metric);
  const nameColumn = name || id;

  function findNodeName(rootNodeId) {
    let nodeName = '';
    data.some(node => {
      if (node[id].toString() === rootNodeId) {
        nodeName = node[nameColumn];
        return true;
      }

      return false;
    });
    return nodeName;
  }

  function getTotalChildren(tree) {
    let totalChildren = 0;

    function traverse(tree) {
      tree.children.forEach(node => {
        traverse(node);
      });
      totalChildren += 1;
    }

    traverse(tree);
    return totalChildren;
  }

  function createTree(rootNodeId) {
    const rootNodeName = findNodeName(rootNodeId);
    const tree = {
      name: rootNodeName,
      children: []
    };
    const children = [];
    const indexMap = {};

    if (!rootNodeName) {
      return tree;
    } // index indexMap with node ids


    for (let i = 0; i < data.length; i += 1) {
      const nodeId = data[i][id];
      indexMap[nodeId] = i;
      children[i] = [];
    } // generate tree


    for (let i = 0; i < data.length; i += 1) {
      var _node$parent;

      const node = data[i];

      if (((_node$parent = node[parent]) == null ? void 0 : _node$parent.toString()) === rootNodeId) {
        var _tree$children;

        (_tree$children = tree.children) == null ? void 0 : _tree$children.push({
          name: node[nameColumn],
          children: children[i],
          value: node[metricLabel]
        });
      } else {
        const parentId = node[parent];

        if (data[indexMap[parentId]]) {
          const parentIndex = indexMap[parentId];
          children[parentIndex].push({
            name: node[nameColumn],
            children: children[i],
            value: node[metricLabel]
          });
        }
      }
    }

    return tree;
  }

  let finalTree = {};

  if (rootNodeId) {
    finalTree = createTree(rootNodeId);
  } else {
    /*
      to select root node,
      1.find parent nodes with only 1 child.
      2.build tree for each such child nodes as root
      3.select tree with most children
    */
    // create map of parent:children
    const parentChildMap = {};
    data.forEach(node => {
      const parentId = node[parent];

      if (parentId in parentChildMap) {
        parentChildMap[parentId].push({
          id: node[id]
        });
      } else {
        parentChildMap[parentId] = [{
          id: node[id]
        }];
      }
    }); // for each parent node which has only 1 child,find tree and select node with max number of children.

    let maxChildren = 0;
    Object.keys(parentChildMap).forEach(key => {
      if (parentChildMap[key].length === 1) {
        const tree = createTree(parentChildMap[key][0].id);
        const totalChildren = getTotalChildren(tree);

        if (totalChildren > maxChildren) {
          maxChildren = totalChildren;
          finalTree = tree;
        }
      }
    });
  }

  const series = [{
    type: 'tree',
    data: [finalTree],
    label: { ...DEFAULT_TREE_SERIES_OPTION.label,
      position: nodeLabelPosition
    },
    emphasis: {
      focus: emphasis
    },
    animation: DEFAULT_TREE_SERIES_OPTION.animation,
    layout,
    orient,
    symbol,
    roam,
    symbolSize,
    lineStyle: DEFAULT_TREE_SERIES_OPTION.lineStyle,
    select: DEFAULT_TREE_SERIES_OPTION.select,
    leaves: {
      label: {
        position: childLabelPosition
      }
    }
  }];
  const echartOptions = {
    animationDuration: DEFAULT_TREE_SERIES_OPTION.animationDuration,
    animationEasing: DEFAULT_TREE_SERIES_OPTION.animationEasing,
    series,
    tooltip: {
      trigger: 'item',
      triggerOn: 'mousemove',
      formatter: params => formatTooltip({
        params,
        metricLabel
      })
    }
  };
  return {
    width,
    height,
    echartOptions
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Tree/images/thumbnail.png
var thumbnail = __webpack_require__(18261);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Tree/images/tree.png
var tree = __webpack_require__(16917);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/buildQueryContext.js
var buildQueryContext = __webpack_require__(69205);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Tree/buildQuery.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function buildQuery(formData) {
  return (0,buildQueryContext/* default */.Z)(formData, {
    queryFields: {
      id: 'columns',
      parent: 'columns',
      name: 'columns'
    }
  });
}
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Tree/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






class EchartsTreeChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      buildQuery: buildQuery,
      controlPanel: Tree_controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 4018).then(__webpack_require__.bind(__webpack_require__, 84018)),
      metadata: new ChartMetadata/* default */.Z({
        category: (0,TranslatorSingleton.t)('Part of a Whole'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)('Visualize multiple levels of hierarchy using a familiar tree-like structure.'),
        exampleGallery: [{
          url: tree
        }],
        name: (0,TranslatorSingleton.t)('Tree Chart'),
        tags: [(0,TranslatorSingleton.t)('Categorical'), (0,TranslatorSingleton.t)('ECharts'), (0,TranslatorSingleton.t)('Multi-Levels'), (0,TranslatorSingleton.t)('Relational'), (0,TranslatorSingleton.t)('Structural')],
        thumbnail: thumbnail
      }),
      transformProps: transformProps
    });
  }

}

/***/ }),

/***/ 10545:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "My": () => (/* binding */ COLOR_SATURATION),
/* harmony export */   "oO": () => (/* binding */ LABEL_FONTSIZE),
/* harmony export */   "YF": () => (/* binding */ BORDER_WIDTH),
/* harmony export */   "Lh": () => (/* binding */ GAP_WIDTH),
/* harmony export */   "dS": () => (/* binding */ BORDER_COLOR),
/* harmony export */   "Im": () => (/* binding */ extractTreePathInfo)
/* harmony export */ });
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const COLOR_SATURATION = [0.7, 0.4];
const LABEL_FONTSIZE = 11;
const BORDER_WIDTH = 2;
const GAP_WIDTH = 2;
const BORDER_COLOR = '#fff';
const extractTreePathInfo = treePathInfo => {
  const treePath = (treePathInfo ?? []).map(pathInfo => (pathInfo == null ? void 0 : pathInfo.name) || '').filter(path => path !== ''); // the 1st tree path is metric label

  const metricLabel = treePath.shift() || '';
  return {
    metricLabel,
    treePath
  };
};

/***/ }),

/***/ 95990:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ EchartsTreemapChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/buildQueryContext.js
var buildQueryContext = __webpack_require__(69205);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Treemap/buildQuery.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function buildQuery(formData) {
  const {
    metric,
    sort_by_metric
  } = formData;
  return (0,buildQueryContext/* default */.Z)(formData, baseQueryObject => [{ ...baseQueryObject,
    ...(sort_by_metric && {
      orderby: [[metric, false]]
    })
  }]);
}
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/types.js
var types = __webpack_require__(94980);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Treemap/types.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

let EchartsTreemapLabelType;

(function (EchartsTreemapLabelType) {
  EchartsTreemapLabelType["Key"] = "key";
  EchartsTreemapLabelType["Value"] = "value";
  EchartsTreemapLabelType["KeyValue"] = "key_value";
})(EchartsTreemapLabelType || (EchartsTreemapLabelType = {}));

const DEFAULT_FORM_DATA = {
  groupby: [],
  labelType: EchartsTreemapLabelType.KeyValue,
  labelPosition: types/* LabelPositionEnum.InsideTopLeft */.Pl.InsideTopLeft,
  numberFormat: 'SMART_NUMBER',
  showLabels: true,
  showUpperLabels: true,
  dateFormat: 'smart_date',
  emitFilter: false
};
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Treemap/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const {
  labelType,
  numberFormat,
  showLabels,
  showUpperLabels,
  dateFormat
} = DEFAULT_FORM_DATA;
const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['groupby'], ['metric'], ['row_limit'], [{
      name: 'sort_by_metric',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort by metric'),
        description: (0,TranslatorSingleton.t)('Whether to sort results by the selected metric in descending order.')
      }
    }], ['adhoc_filters'], emitFilterControl/* emitFilterControl */.a]
  }, {
    label: (0,TranslatorSingleton.t)('Chart Options'),
    expanded: true,
    controlSetRows: [['color_scheme'], [(0,emotion_react_browser_esm.jsx)("h1", {
      className: "section-header"
    }, (0,TranslatorSingleton.t)('Labels'))], [{
      name: 'show_labels',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show Labels'),
        renderTrigger: true,
        default: showLabels,
        description: (0,TranslatorSingleton.t)('Whether to display the labels.')
      }
    }], [{
      name: 'show_upper_labels',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show Upper Labels'),
        renderTrigger: true,
        default: showUpperLabels,
        description: (0,TranslatorSingleton.t)('Show labels when the node has children.')
      }
    }], [{
      name: 'label_type',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Label Type'),
        default: labelType,
        renderTrigger: true,
        choices: [['Key', 'Key'], ['value', 'Value'], ['key_value', 'Category and Value']],
        description: (0,TranslatorSingleton.t)('What should be shown on the label?')
      }
    }], [{
      name: 'number_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Number format'),
        renderTrigger: true,
        default: numberFormat,
        choices: D3Formatting/* D3_FORMAT_OPTIONS */.F6,
        description: `${(0,TranslatorSingleton.t)('D3 format syntax: https://github.com/d3/d3-format. ')} ${(0,TranslatorSingleton.t)('Only applies when "Label Type" is set to show values.')}`
      }
    }], [{
      name: 'date_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Date format'),
        renderTrigger: true,
        choices: D3Formatting/* D3_TIME_FORMAT_OPTIONS */.HC,
        default: dateFormat,
        description: D3Formatting/* D3_FORMAT_DOCS */.YD
      }
    }]]
  }]
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormatterRegistrySingleton.js
var NumberFormatterRegistrySingleton = __webpack_require__(50855);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormats.js
var NumberFormats = __webpack_require__(63758);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/color/CategoricalColorNamespace.js
var CategoricalColorNamespace = __webpack_require__(83527);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/time-format/TimeFormatterRegistrySingleton.js + 5 modules
var TimeFormatterRegistrySingleton = __webpack_require__(14826);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/getMetricLabel.js
var getMetricLabel = __webpack_require__(95669);
// EXTERNAL MODULE: ./node_modules/lodash/lodash.js
var lodash = __webpack_require__(96486);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/utils/series.js
var utils_series = __webpack_require__(66978);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/defaults.js
var defaults = __webpack_require__(97711);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Treemap/constants.js
var constants = __webpack_require__(10545);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/constants.js
var esm_constants = __webpack_require__(23788);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Treemap/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */







function formatLabel({
  params,
  labelType,
  numberFormatter
}) {
  const {
    name = '',
    value
  } = params;
  const formattedValue = numberFormatter(value);

  switch (labelType) {
    case EchartsTreemapLabelType.Key:
      return name;

    case EchartsTreemapLabelType.Value:
      return formattedValue;

    case EchartsTreemapLabelType.KeyValue:
      return `${name}: ${formattedValue}`;

    default:
      return name;
  }
}
function formatTooltip({
  params,
  numberFormatter
}) {
  const {
    value,
    treePathInfo = []
  } = params;
  const formattedValue = numberFormatter(value);
  const {
    metricLabel,
    treePath
  } = (0,constants/* extractTreePathInfo */.Im)(treePathInfo);
  const percentFormatter = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(NumberFormats/* default.PERCENT_2_POINT */.Z.PERCENT_2_POINT);
  let formattedPercent = ''; // the last item is current node, here we should find the parent node

  const currentNode = treePathInfo[treePathInfo.length - 1];
  const parentNode = treePathInfo[treePathInfo.length - 2];

  if (parentNode) {
    const percent = parentNode.value ? currentNode.value / parentNode.value : 0;
    formattedPercent = percentFormatter(percent);
  } // groupby1/groupby2/...
  // metric: value (percent of parent)


  return [`<div>${treePath.join(' ▸ ')}</div>`, `${metricLabel}: ${formattedValue}`, formattedPercent ? ` (${formattedPercent})` : ''].join('');
}
function transformProps(chartProps) {
  const {
    formData,
    height,
    queriesData,
    width,
    hooks,
    filterState
  } = chartProps;
  const {
    data = []
  } = queriesData[0];
  const {
    setDataMask = () => {}
  } = hooks;
  const coltypeMapping = (0,utils_series/* getColtypesMapping */.IW)(queriesData[0]);
  const {
    colorScheme,
    groupby = [],
    metric = '',
    labelType,
    labelPosition,
    numberFormat,
    dateFormat,
    showLabels,
    showUpperLabels,
    dashboardId,
    emitFilter
  } = { ...DEFAULT_FORM_DATA,
    ...formData
  };
  const colorFn = CategoricalColorNamespace.getScale(colorScheme);
  const numberFormatter = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(numberFormat);

  const formatter = params => formatLabel({
    params,
    numberFormatter,
    labelType
  });

  const columnsLabelMap = new Map();

  const transformer = (data, groupbyData, metric, depth, path) => {
    const [currGroupby, ...restGroupby] = groupbyData;
    const currGrouping = (0,lodash.groupBy)(data, currGroupby);

    if (!restGroupby.length) {
      return (0,lodash.transform)(currGrouping, (result, value, key) => {
        (value ?? []).forEach(datum => {
          const name = (0,utils_series/* formatSeriesName */.mj)(key, {
            numberFormatter,
            timeFormatter: (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(dateFormat),
            ...(coltypeMapping[currGroupby] && {
              coltype: coltypeMapping[currGroupby]
            })
          });
          const item = {
            name,
            value: (0,lodash.isNumber)(datum[metric]) ? datum[metric] : 0
          };
          const joinedName = path.concat(name).join(','); // map(joined_name: [columnLabel_1, columnLabel_2, ...])

          columnsLabelMap.set(joinedName, path.concat(name));

          if (filterState.selectedValues && !filterState.selectedValues.includes(joinedName)) {
            item.itemStyle = {
              colorAlpha: esm_constants/* OpacityEnum.SemiTransparent */.ZV.SemiTransparent
            };
            item.label = {
              color: `rgba(0, 0, 0, ${esm_constants/* OpacityEnum.SemiTransparent */.ZV.SemiTransparent})`
            };
          }

          result.push(item);
        });
      }, []);
    }

    const sortedData = (0,lodash.transform)(currGrouping, (result, value, key) => {
      const name = (0,utils_series/* formatSeriesName */.mj)(key, {
        numberFormatter,
        timeFormatter: (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(dateFormat),
        ...(coltypeMapping[currGroupby] && {
          coltype: coltypeMapping[currGroupby]
        })
      });
      const children = transformer(value, restGroupby, metric, depth + 1, path.concat(name));
      result.push({
        name,
        children,
        value: children.reduce((prev, cur) => prev + cur.value, 0)
      });
      result.sort((a, b) => b.value - a.value);
    }, []); // sort according to the area and then take the color value in order

    return sortedData.map(child => ({ ...child,
      colorSaturation: constants/* COLOR_SATURATION */.My,
      itemStyle: {
        borderColor: constants/* BORDER_COLOR */.dS,
        color: colorFn(`${child.name}`),
        borderWidth: constants/* BORDER_WIDTH */.YF,
        gapWidth: constants/* GAP_WIDTH */.Lh
      }
    }));
  };

  const metricLabel = (0,getMetricLabel/* default */.Z)(metric);
  const initialDepth = 1;
  const transformedData = [{
    name: metricLabel,
    colorSaturation: constants/* COLOR_SATURATION */.My,
    itemStyle: {
      borderColor: constants/* BORDER_COLOR */.dS,
      borderWidth: constants/* BORDER_WIDTH */.YF,
      gapWidth: constants/* GAP_WIDTH */.Lh
    },
    upperLabel: {
      show: false
    },
    children: transformer(data, groupby, metricLabel, initialDepth, [])
  }]; // set a default color when metric values are 0 over all.

  const levels = [{
    upperLabel: {
      show: false
    },
    label: {
      show: false
    },
    itemStyle: {
      color: CategoricalColorNamespace.getColor()
    }
  }];
  const series = [{
    type: 'treemap',
    width: '100%',
    height: '100%',
    nodeClick: undefined,
    roam: !dashboardId,
    breadcrumb: {
      show: false,
      emptyItemWidth: 25
    },
    emphasis: {
      label: {
        show: true
      }
    },
    levels,
    label: {
      show: showLabels,
      position: labelPosition,
      formatter,
      color: '#000',
      fontSize: constants/* LABEL_FONTSIZE */.oO
    },
    upperLabel: {
      show: showUpperLabels,
      formatter,
      textBorderColor: 'transparent',
      fontSize: constants/* LABEL_FONTSIZE */.oO
    },
    data: transformedData
  }];
  const echartOptions = {
    tooltip: { ...defaults/* defaultTooltip */.Ku,
      trigger: 'item',
      formatter: params => formatTooltip({
        params,
        numberFormatter
      })
    },
    series
  };
  return {
    formData,
    width,
    height,
    echartOptions,
    setDataMask,
    emitFilter,
    labelMap: Object.fromEntries(columnsLabelMap),
    groupby,
    selectedValues: filterState.selectedValues || []
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Treemap/images/thumbnail.png
var thumbnail = __webpack_require__(93230);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Treemap/images/treemap_v2_1.png
var treemap_v2_1 = __webpack_require__(54610);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Treemap/images/treemap_v2_2.jpg
var treemap_v2_2 = __webpack_require__(77281);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-echarts/esm/Treemap/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regardin
 * g copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */







class EchartsTreemapChartPlugin extends ChartPlugin/* default */.Z {
  /**
   * The constructor is used to pass relevant metadata and callbacks that get
   * registered in respective registries that are used throughout the library
   * and application. A more thorough description of each property is given in
   * the respective imported file.
   *
   * It is worth noting that `buildQuery` and is optional, and only needed for
   * advanced visualizations that require either post processing operations
   * (pivoting, rolling aggregations, sorting etc) or submitting multiple queries.
   */
  constructor() {
    super({
      buildQuery: buildQuery,
      controlPanel: controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 9034).then(__webpack_require__.bind(__webpack_require__, 79034)),
      metadata: new ChartMetadata/* default */.Z({
        behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
        category: (0,TranslatorSingleton.t)('Part of a Whole'),
        credits: ['https://echarts.apache.org'],
        description: (0,TranslatorSingleton.t)('Show hierarchical relationships of data, with with the value represented by area, showing proportion and contribution to the whole.'),
        exampleGallery: [{
          url: treemap_v2_1
        }, {
          url: treemap_v2_2
        }],
        name: (0,TranslatorSingleton.t)('Treemap v2'),
        tags: [(0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Categorical'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('ECharts'), (0,TranslatorSingleton.t)('Multi-Levels'), (0,TranslatorSingleton.t)('Percentages'), (0,TranslatorSingleton.t)('Proportional')],
        thumbnail: thumbnail
      }),
      transformProps: transformProps
    });
  }

}

/***/ }),

/***/ 23788:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "li": () => (/* binding */ NULL_STRING),
/* harmony export */   "SM": () => (/* binding */ TIMESERIES_CONSTANTS),
/* harmony export */   "N4": () => (/* binding */ LABEL_POSITION),
/* harmony export */   "ZV": () => (/* binding */ OpacityEnum)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(94980);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
 // eslint-disable-next-line import/prefer-default-export

const NULL_STRING = '<NULL>';
const TIMESERIES_CONSTANTS = {
  gridOffsetRight: 40,
  gridOffsetLeft: 20,
  gridOffsetTop: 20,
  gridOffsetBottom: 20,
  gridOffsetBottomZoomable: 80,
  legendRightTopOffset: 30,
  legendTopRightOffset: 55,
  zoomBottom: 30,
  toolboxTop: 0,
  toolboxRight: 5,
  dataZoomStart: 0,
  dataZoomEnd: 100,
  yAxisLabelTopOffset: 20
};
const LABEL_POSITION = [[_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.Top */ .Pl.Top, 'Top'], [_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.Left */ .Pl.Left, 'Left'], [_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.Right */ .Pl.Right, 'Right'], [_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.Bottom */ .Pl.Bottom, 'Bottom'], [_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.Inside */ .Pl.Inside, 'Inside'], [_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.InsideBottomLeft */ .Pl.InsideBottomLeft, 'Inside left'], [_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.InsideBottomRight */ .Pl.InsideBottomRight, 'Inside right'], [_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.InsideTop */ .Pl.InsideTop, 'Inside top'], [_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.InsideBottom */ .Pl.InsideBottom, 'Inside bottom'], [_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.InsideTopLeft */ .Pl.InsideTopLeft, 'Inside top left'], [_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.InsideBottomLeft */ .Pl.InsideBottomLeft, 'Inside bottom left'], [_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.InsideTopRight */ .Pl.InsideTopRight, 'Inside top right'], [_types__WEBPACK_IMPORTED_MODULE_0__/* .LabelPositionEnum.InsideBottomRight */ .Pl.InsideBottomRight, 'Inside bottom right']];
let OpacityEnum;

(function (OpacityEnum) {
  OpacityEnum[OpacityEnum["Transparent"] = 0] = "Transparent";
  OpacityEnum[OpacityEnum["SemiTransparent"] = 0.3] = "SemiTransparent";
  OpacityEnum[OpacityEnum["NonTransparent"] = 1] = "NonTransparent";
})(OpacityEnum || (OpacityEnum = {}));

/***/ }),

/***/ 22297:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "q_": () => (/* binding */ legendSection),
/* harmony export */   "eQ": () => (/* binding */ showValueSection),
/* harmony export */   "oA": () => (/* binding */ richTooltipSection)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67294);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60650);
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28500);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94980);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11965);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const {
  legendMargin,
  legendOrientation,
  legendType,
  showLegend
} = _types__WEBPACK_IMPORTED_MODULE_1__/* .DEFAULT_LEGEND_FORM_DATA */ .xo;
const showLegendControl = {
  name: 'show_legend',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Show legend'),
    renderTrigger: true,
    default: showLegend,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Whether to display a legend for the chart')
  }
};
const legendMarginControl = {
  name: 'legendMargin',
  config: {
    type: 'TextControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Margin'),
    renderTrigger: true,
    isInt: true,
    default: legendMargin,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Additional padding for legend.'),
    visibility: ({
      controls
    }) => {
      var _controls$show_legend;

      return Boolean(controls == null ? void 0 : (_controls$show_legend = controls.show_legend) == null ? void 0 : _controls$show_legend.value);
    }
  }
};
const legendTypeControl = {
  name: 'legendType',
  config: {
    type: 'SelectControl',
    freeForm: false,
    label: 'Type',
    choices: [['scroll', 'Scroll'], ['plain', 'Plain']],
    default: legendType,
    renderTrigger: true,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Legend type'),
    visibility: ({
      controls
    }) => {
      var _controls$show_legend2;

      return Boolean(controls == null ? void 0 : (_controls$show_legend2 = controls.show_legend) == null ? void 0 : _controls$show_legend2.value);
    }
  }
};
const legendOrientationControl = {
  name: 'legendOrientation',
  config: {
    type: 'SelectControl',
    freeForm: false,
    label: 'Orientation',
    choices: [['top', 'Top'], ['bottom', 'Bottom'], ['left', 'Left'], ['right', 'Right']],
    default: legendOrientation,
    renderTrigger: true,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Legend type'),
    visibility: ({
      controls
    }) => {
      var _controls$show_legend3;

      return Boolean(controls == null ? void 0 : (_controls$show_legend3 = controls.show_legend) == null ? void 0 : _controls$show_legend3.value);
    }
  }
};
const legendSection = [[(0,_emotion_react__WEBPACK_IMPORTED_MODULE_3__.jsx)("h1", {
  className: "section-header"
}, (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Legend'))], [showLegendControl], [legendTypeControl], [legendOrientationControl], [legendMarginControl]];
const showValueControl = {
  name: 'show_value',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Show Value'),
    default: false,
    renderTrigger: true,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Show series values on the chart')
  }
};
const stackControl = {
  name: 'stack',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Stack series'),
    renderTrigger: true,
    default: false,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Stack series on top of each other')
  }
};
const onlyTotalControl = {
  name: 'only_total',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Only Total'),
    default: true,
    renderTrigger: true,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Only show the total value on the stacked chart, and not show on the selected category'),
    visibility: ({
      controls
    }) => {
      var _controls$show_value, _controls$stack;

      return Boolean(controls == null ? void 0 : (_controls$show_value = controls.show_value) == null ? void 0 : _controls$show_value.value) && Boolean(controls == null ? void 0 : (_controls$stack = controls.stack) == null ? void 0 : _controls$stack.value);
    }
  }
};
const showValueSection = [[showValueControl], [stackControl], [onlyTotalControl]];
const richTooltipControl = {
  name: 'rich_tooltip',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Rich tooltip'),
    renderTrigger: true,
    default: true,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Shows a list of all series available at that point in time')
  }
};
const tooltipTimeFormatControl = {
  name: 'tooltipTimeFormat',
  config: { ..._superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_4__/* .sharedControls.x_axis_time_format */ .Hq.x_axis_time_format,
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Tooltip time format'),
    default: 'smart_date',
    clearable: false
  }
};
const tooltipSortByMetricControl = {
  name: 'tooltipSortByMetric',
  config: {
    type: 'CheckboxControl',
    label: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Tooltip sort by metric'),
    renderTrigger: true,
    default: false,
    description: (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Whether to sort tooltip by the selected metric in descending order.'),
    visibility: ({
      controls
    }) => {
      var _controls$rich_toolti;

      return Boolean(controls == null ? void 0 : (_controls$rich_toolti = controls.rich_tooltip) == null ? void 0 : _controls$rich_toolti.value);
    }
  }
};
const richTooltipSection = [[(0,_emotion_react__WEBPACK_IMPORTED_MODULE_3__.jsx)("h1", {
  className: "section-header"
}, (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__.t)('Tooltip'))], [richTooltipControl], [tooltipSortByMetricControl], [tooltipTimeFormatControl]];

/***/ }),

/***/ 97711:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "oe": () => (/* binding */ defaultGrid),
/* harmony export */   "Ku": () => (/* binding */ defaultTooltip),
/* harmony export */   "C0": () => (/* binding */ defaultYAxis),
/* harmony export */   "mW": () => (/* binding */ defaultLegendPadding)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(94980);

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

const defaultGrid = {
  containLabel: true
};
const defaultTooltip = {
  confine: true
};
const defaultYAxis = {
  scale: true
};
const defaultLegendPadding = {
  [_types__WEBPACK_IMPORTED_MODULE_0__/* .LegendOrientation.Top */ .IY.Top]: 20,
  [_types__WEBPACK_IMPORTED_MODULE_0__/* .LegendOrientation.Bottom */ .IY.Bottom]: 20,
  [_types__WEBPACK_IMPORTED_MODULE_0__/* .LegendOrientation.Left */ .IY.Left]: 170,
  [_types__WEBPACK_IMPORTED_MODULE_0__/* .LegendOrientation.Right */ .IY.Right]: 170
};

/***/ }),

/***/ 94980:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "i1": () => (/* binding */ ForecastSeriesEnum),
/* harmony export */   "IY": () => (/* binding */ LegendOrientation),
/* harmony export */   "HJ": () => (/* binding */ LegendType),
/* harmony export */   "xo": () => (/* binding */ DEFAULT_LEGEND_FORM_DATA),
/* harmony export */   "Pl": () => (/* binding */ LabelPositionEnum),
/* harmony export */   "f6": () => (/* binding */ DEFAULT_TITLE_FORM_DATA)
/* harmony export */ });
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
let ForecastSeriesEnum;

(function (ForecastSeriesEnum) {
  ForecastSeriesEnum["Observation"] = "";
  ForecastSeriesEnum["ForecastTrend"] = "__yhat";
  ForecastSeriesEnum["ForecastUpper"] = "__yhat_upper";
  ForecastSeriesEnum["ForecastLower"] = "__yhat_lower";
})(ForecastSeriesEnum || (ForecastSeriesEnum = {}));

let LegendOrientation;

(function (LegendOrientation) {
  LegendOrientation["Top"] = "top";
  LegendOrientation["Bottom"] = "bottom";
  LegendOrientation["Left"] = "left";
  LegendOrientation["Right"] = "right";
})(LegendOrientation || (LegendOrientation = {}));

let LegendType;

(function (LegendType) {
  LegendType["Scroll"] = "scroll";
  LegendType["Plain"] = "plain";
})(LegendType || (LegendType = {}));

const DEFAULT_LEGEND_FORM_DATA = {
  legendMargin: null,
  legendOrientation: LegendOrientation.Top,
  legendType: LegendType.Scroll,
  showLegend: false
};
let LabelPositionEnum;

(function (LabelPositionEnum) {
  LabelPositionEnum["Top"] = "top";
  LabelPositionEnum["Left"] = "left";
  LabelPositionEnum["Right"] = "right";
  LabelPositionEnum["Bottom"] = "bottom";
  LabelPositionEnum["Inside"] = "inside";
  LabelPositionEnum["InsideLeft"] = "insideLeft";
  LabelPositionEnum["InsideRight"] = "insideRight";
  LabelPositionEnum["InsideTop"] = "insideTop";
  LabelPositionEnum["InsideBottom"] = "insideBottom";
  LabelPositionEnum["InsideTopLeft"] = "insideTopLeft";
  LabelPositionEnum["InsideBottomLeft"] = "insideBottomLeft";
  LabelPositionEnum["InsideTopRight"] = "insideTopRight";
  LabelPositionEnum["InsideBottomRight"] = "insideBottomRight";
})(LabelPositionEnum || (LabelPositionEnum = {}));

const DEFAULT_TITLE_FORM_DATA = {
  xAxisTitle: '',
  xAxisTitleMargin: 0,
  yAxisTitle: '',
  yAxisTitleMargin: 0,
  yAxisTitlePosition: 'Top'
};

/***/ }),

/***/ 56008:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ns": () => (/* binding */ evalFormula),
/* harmony export */   "lh": () => (/* binding */ parseAnnotationOpacity),
/* harmony export */   "JB": () => (/* binding */ extractRecordAnnotations),
/* harmony export */   "Sk": () => (/* binding */ formatAnnotationLabel),
/* harmony export */   "Ky": () => (/* binding */ extractAnnotationLabels)
/* harmony export */ });
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27211);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33484);
/* eslint-disable no-underscore-dangle */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function evalFormula(formula, data) {
  const {
    value: expression
  } = formula;
  return data.map(row => [new Date(Number(row.__timestamp)), (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__/* .evalExpression */ .f)(expression, row.__timestamp)]);
}
function parseAnnotationOpacity(opacity) {
  switch (opacity) {
    case _superset_ui_core__WEBPACK_IMPORTED_MODULE_1__/* .AnnotationOpacity.Low */ .TJ.Low:
      return 0.2;

    case _superset_ui_core__WEBPACK_IMPORTED_MODULE_1__/* .AnnotationOpacity.Medium */ .TJ.Medium:
      return 0.5;

    case _superset_ui_core__WEBPACK_IMPORTED_MODULE_1__/* .AnnotationOpacity.High */ .TJ.High:
      return 0.8;

    default:
      return 1;
  }
}
const NATIVE_COLUMN_NAMES = {
  descriptionColumns: ['long_descr'],
  intervalEndColumn: 'end_dttm',
  timeColumn: 'start_dttm',
  titleColumn: 'short_descr'
};
function extractRecordAnnotations(annotationLayer, annotationData) {
  const {
    name
  } = annotationLayer;
  const result = annotationData[name];

  if ((0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__/* .isRecordAnnotationResult */ .$c)(result)) {
    const {
      records
    } = result;
    const {
      descriptionColumns = [],
      intervalEndColumn = '',
      timeColumn = '',
      titleColumn = ''
    } = (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__/* .isTableAnnotationLayer */ .mn)(annotationLayer) ? annotationLayer : NATIVE_COLUMN_NAMES;
    return records.map(record => ({
      descriptions: descriptionColumns.map(column => record[column] || ''),
      intervalEnd: record[intervalEndColumn] || '',
      time: record[timeColumn] || '',
      title: record[titleColumn] || ''
    }));
  }

  throw new Error('Please rerun the query.');
}
function formatAnnotationLabel(name, title, descriptions = []) {
  const labels = [];
  const titleLabels = [];
  const filteredDescriptions = descriptions.filter(description => !!description);
  if (name) titleLabels.push(name);
  if (title) titleLabels.push(title);
  if (titleLabels.length > 0) labels.push(titleLabels.join(' - '));
  if (filteredDescriptions.length > 0) labels.push(filteredDescriptions.join('\n'));
  return labels.join('\n\n');
}
function extractAnnotationLabels(layers, data) {
  const formulaAnnotationLabels = layers.filter(anno => anno.annotationType === _superset_ui_core__WEBPACK_IMPORTED_MODULE_1__/* .AnnotationType.Formula */ .JJ.Formula && anno.show).map(anno => anno.name);
  const timeseriesAnnotationLabels = layers.filter(anno => anno.annotationType === _superset_ui_core__WEBPACK_IMPORTED_MODULE_1__/* .AnnotationType.Timeseries */ .JJ.Timeseries && anno.show).flatMap(anno => {
    const result = data[anno.name];
    return (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__/* .isTimeseriesAnnotationResult */ .b4)(result) ? result.map(annoSeries => annoSeries.key) : [];
  });
  return formulaAnnotationLabels.concat(timeseriesAnnotationLabels);
}

/***/ }),

/***/ 26091:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "p": () => (/* binding */ parseYAxisBound),
/* harmony export */   "N": () => (/* binding */ parseNumbersList)
/* harmony export */ });
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67181);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
 // eslint-disable-next-line import/prefer-default-export

function parseYAxisBound(bound) {
  if (bound === undefined || bound === null || Number.isNaN(Number(bound))) {
    return undefined;
  }

  return Number(bound);
}
function parseNumbersList(value, delim = ';') {
  if (!value || !value.trim()) return [];
  return value.split(delim).map(num => {
    if ((0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)(num)) throw new Error('All values must be numeric');
    return Number(num);
  });
}

/***/ }),

/***/ 50327:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Nr": () => (/* binding */ extractForecastSeriesContext),
/* harmony export */   "U_": () => (/* binding */ extractForecastSeriesContexts),
/* harmony export */   "LQ": () => (/* binding */ extractProphetValuesFromTooltipParams),
/* harmony export */   "Ft": () => (/* binding */ formatProphetTooltipSeries),
/* harmony export */   "Hc": () => (/* binding */ rebaseTimeseriesDatum)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(94980);
/* harmony import */ var _series__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(66978);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const seriesTypeRegex = new RegExp(`(.+)(${_types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastLower */ .i1.ForecastLower}|${_types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastTrend */ .i1.ForecastTrend}|${_types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastUpper */ .i1.ForecastUpper})$`);
const extractForecastSeriesContext = seriesName => {
  const name = seriesName;
  const regexMatch = seriesTypeRegex.exec(name);
  if (!regexMatch) return {
    name,
    type: _types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.Observation */ .i1.Observation
  };
  return {
    name: regexMatch[1],
    type: regexMatch[2]
  };
};
const extractForecastSeriesContexts = seriesNames => seriesNames.reduce((agg, name) => {
  const context = extractForecastSeriesContext(name);
  const currentContexts = agg[context.name] || [];
  currentContexts.push(context.type);
  return { ...agg,
    [context.name]: currentContexts
  };
}, {});
const extractProphetValuesFromTooltipParams = params => {
  const values = {};
  params.forEach(param => {
    const {
      marker,
      seriesId,
      value
    } = param;
    const context = extractForecastSeriesContext(seriesId);
    const numericValue = value[1];

    if (numericValue) {
      if (!(context.name in values)) values[context.name] = {
        marker: marker || ''
      };
      const prophetValues = values[context.name];
      if (context.type === _types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.Observation */ .i1.Observation) prophetValues.observation = numericValue;
      if (context.type === _types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastTrend */ .i1.ForecastTrend) prophetValues.forecastTrend = numericValue;
      if (context.type === _types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastLower */ .i1.ForecastLower) prophetValues.forecastLower = numericValue;
      if (context.type === _types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastUpper */ .i1.ForecastUpper) prophetValues.forecastUpper = numericValue;
    }
  });
  return values;
};
const formatProphetTooltipSeries = ({
  seriesName,
  observation,
  forecastTrend,
  forecastLower,
  forecastUpper,
  marker,
  formatter
}) => {
  let row = `${marker}${(0,_series__WEBPACK_IMPORTED_MODULE_1__/* .sanitizeHtml */ .Z6)(seriesName)}: `;
  let isObservation = false;

  if (observation) {
    isObservation = true;
    row += `${formatter(observation)}`;
  }

  if (forecastTrend) {
    if (isObservation) row += ', ';
    row += `ŷ = ${formatter(forecastTrend)}`;
  }

  if (forecastLower && forecastUpper) // the lower bound needs to be added to the upper bound
    row = `${row.trim()} (${formatter(forecastLower)}, ${formatter(forecastLower + forecastUpper)})`;
  return `${row.trim()}`;
};
function rebaseTimeseriesDatum(data, verboseMap = {}) {
  const keys = data.length > 0 ? Object.keys(data[0]) : []; // eslint-disable-next-line @typescript-eslint/no-unsafe-return

  return data.map(row => {
    const newRow = {
      __timestamp: ''
    };
    keys.forEach(key => {
      const forecastContext = extractForecastSeriesContext(key);
      const lowerKey = `${forecastContext.name}${_types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastLower */ .i1.ForecastLower}`;
      let value = row[key];

      if (forecastContext.type === _types__WEBPACK_IMPORTED_MODULE_0__/* .ForecastSeriesEnum.ForecastUpper */ .i1.ForecastUpper && keys.includes(lowerKey) && value !== null && row[lowerKey] !== null) {
        value -= row[lowerKey];
      }

      const newKey = key !== '__timestamp' && verboseMap[key] ? verboseMap[key] : key;
      newRow[newKey] = value;
    }); // eslint-disable-next-line @typescript-eslint/no-unsafe-return

    return newRow;
  });
}

/***/ }),

/***/ 66978:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "vT": () => (/* binding */ extractTimeseriesSeries),
/* harmony export */   "mj": () => (/* binding */ formatSeriesName),
/* harmony export */   "IW": () => (/* binding */ getColtypesMapping),
/* harmony export */   "iw": () => (/* binding */ extractGroupbyLabel),
/* harmony export */   "zp": () => (/* binding */ getLegendProps),
/* harmony export */   "G_": () => (/* binding */ getChartPadding),
/* harmony export */   "IE": () => (/* binding */ dedupSeries),
/* harmony export */   "Z6": () => (/* binding */ sanitizeHtml),
/* harmony export */   "aI": () => (/* binding */ currentSeries)
/* harmony export */ });
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(23274);
/* harmony import */ var echarts__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32577);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23788);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(94980);
/* harmony import */ var _defaults__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97711);
/* eslint-disable no-underscore-dangle */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






function isDefined(value) {
  return value !== undefined && value !== null;
}

function extractTimeseriesSeries(data, opts = {}) {
  const {
    fillNeighborValue
  } = opts;
  if (data.length === 0) return [];
  const rows = data.map(datum => ({ ...datum,
    __timestamp: datum.__timestamp || datum.__timestamp === 0 ? new Date(datum.__timestamp) : null
  }));
  return Object.keys(rows[0]).filter(key => key !== '__timestamp').map(key => ({
    id: key,
    name: key,
    data: rows.map((row, idx) => {
      var _rows, _rows2;

      const isNextToDefinedValue = isDefined((_rows = rows[idx - 1]) == null ? void 0 : _rows[key]) || isDefined((_rows2 = rows[idx + 1]) == null ? void 0 : _rows2[key]);
      return [row.__timestamp, !isDefined(row[key]) && isNextToDefinedValue && fillNeighborValue !== undefined ? fillNeighborValue : row[key]];
    })
  }));
}
function formatSeriesName(name, {
  numberFormatter,
  timeFormatter,
  coltype
} = {}) {
  if (name === undefined || name === null) {
    return _constants__WEBPACK_IMPORTED_MODULE_1__/* .NULL_STRING */ .li;
  }

  if (typeof name === 'number') {
    return numberFormatter ? numberFormatter(name) : name.toString();
  }

  if (typeof name === 'boolean') {
    return name.toString();
  }

  if (name instanceof Date || coltype === _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__/* .GenericDataType.TEMPORAL */ .Z.TEMPORAL) {
    const d = name instanceof Date ? name : new Date(name);
    return timeFormatter ? timeFormatter(d) : d.toISOString();
  }

  return name;
}
const getColtypesMapping = ({
  coltypes = [],
  colnames = []
}) => colnames.reduce((accumulator, item, index) => ({ ...accumulator,
  [item]: coltypes[index]
}), {});
function extractGroupbyLabel({
  datum = {},
  groupby,
  numberFormatter,
  timeFormatter,
  coltypeMapping = {}
}) {
  return (groupby || []).map(val => formatSeriesName(datum[val], {
    numberFormatter,
    timeFormatter,
    ...(coltypeMapping[val] && {
      coltype: coltypeMapping[val]
    })
  })).join(', ');
}
function getLegendProps(type, orientation, show, zoomable = false) {
  const legend = {
    orient: [_types__WEBPACK_IMPORTED_MODULE_3__/* .LegendOrientation.Top */ .IY.Top, _types__WEBPACK_IMPORTED_MODULE_3__/* .LegendOrientation.Bottom */ .IY.Bottom].includes(orientation) ? 'horizontal' : 'vertical',
    show,
    type
  };

  switch (orientation) {
    case _types__WEBPACK_IMPORTED_MODULE_3__/* .LegendOrientation.Left */ .IY.Left:
      legend.left = 0;
      break;

    case _types__WEBPACK_IMPORTED_MODULE_3__/* .LegendOrientation.Right */ .IY.Right:
      legend.right = 0;
      legend.top = zoomable ? _constants__WEBPACK_IMPORTED_MODULE_1__/* .TIMESERIES_CONSTANTS.legendRightTopOffset */ .SM.legendRightTopOffset : 0;
      break;

    case _types__WEBPACK_IMPORTED_MODULE_3__/* .LegendOrientation.Bottom */ .IY.Bottom:
      legend.bottom = 0;
      break;

    case _types__WEBPACK_IMPORTED_MODULE_3__/* .LegendOrientation.Top */ .IY.Top:
    default:
      legend.top = 0;
      legend.right = zoomable ? _constants__WEBPACK_IMPORTED_MODULE_1__/* .TIMESERIES_CONSTANTS.legendTopRightOffset */ .SM.legendTopRightOffset : 0;
      break;
  }

  return legend;
}
function getChartPadding(show, orientation, margin, padding) {
  let legendMargin;

  if (!show) {
    legendMargin = 0;
  } else if (margin === null || margin === undefined || typeof margin === 'string') {
    legendMargin = _defaults__WEBPACK_IMPORTED_MODULE_4__/* .defaultLegendPadding */ .mW[orientation];
  } else {
    legendMargin = margin;
  }

  const {
    bottom = 0,
    left = 0,
    right = 0,
    top = 0
  } = padding || {};
  return {
    left: left + (orientation === _types__WEBPACK_IMPORTED_MODULE_3__/* .LegendOrientation.Left */ .IY.Left ? legendMargin : 0),
    right: right + (orientation === _types__WEBPACK_IMPORTED_MODULE_3__/* .LegendOrientation.Right */ .IY.Right ? legendMargin : 0),
    top: top + (orientation === _types__WEBPACK_IMPORTED_MODULE_3__/* .LegendOrientation.Top */ .IY.Top ? legendMargin : 0),
    bottom: bottom + (orientation === _types__WEBPACK_IMPORTED_MODULE_3__/* .LegendOrientation.Bottom */ .IY.Bottom ? legendMargin : 0)
  };
}
function dedupSeries(series) {
  const counter = new Map();
  return series.map(row => {
    let {
      id
    } = row;
    if (id === undefined) return row;
    id = String(id);
    const count = counter.get(id) || 0;
    const suffix = count > 0 ? ` (${count})` : '';
    counter.set(id, count + 1);
    return { ...row,
      id: `${id}${suffix}`
    };
  });
}
function sanitizeHtml(text) {
  return echarts__WEBPACK_IMPORTED_MODULE_0__/* .format.encodeHTML */ .WU.encodeHTML(text);
} // TODO: Better use other method to maintain this state

const currentSeries = {
  name: '',
  legend: ''
};

/***/ }),

/***/ 89253:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ PivotTableChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/utils/ensureIsArray.js
var ensureIsArray = __webpack_require__(86852);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/buildQueryContext.js
var buildQueryContext = __webpack_require__(69205);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/normalizeOrderBy.js
var normalizeOrderBy = __webpack_require__(77249);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/getMetricLabel.js
var getMetricLabel = __webpack_require__(95669);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-pivot-table/esm/plugin/buildQuery.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function buildQuery(formData) {
  const {
    groupbyColumns = [],
    groupbyRows = [],
    order_desc = true,
    legacy_order_by
  } = formData;
  const groupbySet = new Set([...(0,ensureIsArray/* default */.Z)(groupbyColumns), ...(0,ensureIsArray/* default */.Z)(groupbyRows)]);
  return (0,buildQueryContext/* default */.Z)(formData, baseQueryObject => {
    const queryObject = (0,normalizeOrderBy/* default */.Z)({ ...baseQueryObject,
      order_desc,
      legacy_order_by
    });
    const {
      metrics
    } = queryObject;
    const orderBy = (0,ensureIsArray/* default */.Z)(legacy_order_by);

    if (orderBy.length && !(metrics != null && metrics.find(metric => (0,getMetricLabel/* default */.Z)(metric) === (0,getMetricLabel/* default */.Z)(orderBy[0])))) {
      metrics == null ? void 0 : metrics.push(orderBy[0]);
    }

    return [{ ...queryObject,
      columns: [...groupbySet],
      metrics
    }];
  });
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/time-format/formatters/smartDate.js
var smartDate = __webpack_require__(11304);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/legacySortBy.js
var legacySortBy = __webpack_require__(34096);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/selectOptions.js
var selectOptions = __webpack_require__(24610);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-pivot-table/esm/types.js
var types = __webpack_require__(98164);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-pivot-table/esm/plugin/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const config = {
  controlPanelSections: [{ ...esm.sections.legacyTimeseriesTime,
    expanded: false
  }, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[{
      name: 'groupbyRows',
      config: { ...shared_controls/* sharedControls.groupby */.Hq.groupby,
        label: (0,TranslatorSingleton.t)('Rows'),
        description: (0,TranslatorSingleton.t)('Columns to group by on the rows')
      }
    }], [{
      name: 'groupbyColumns',
      config: { ...shared_controls/* sharedControls.groupby */.Hq.groupby,
        label: (0,TranslatorSingleton.t)('Columns'),
        description: (0,TranslatorSingleton.t)('Columns to group by on the columns')
      }
    }], [{
      name: 'metrics',
      config: { ...shared_controls/* sharedControls.metrics */.Hq.metrics,
        validators: [validateNonEmpty/* default */.Z]
      }
    }], [{
      name: 'metricsLayout',
      config: {
        type: 'RadioButtonControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Apply metrics on'),
        default: types/* MetricsLayoutEnum.COLUMNS */.Q.COLUMNS,
        options: [[types/* MetricsLayoutEnum.COLUMNS */.Q.COLUMNS, (0,TranslatorSingleton.t)('Columns')], [types/* MetricsLayoutEnum.ROWS */.Q.ROWS, (0,TranslatorSingleton.t)('Rows')]],
        description: (0,TranslatorSingleton.t)('Use metrics as a top level group for columns or for rows')
      }
    }], ['adhoc_filters'], emitFilterControl/* emitFilterControl */.a, [{
      name: 'row_limit',
      config: { ...shared_controls/* sharedControls.row_limit */.Hq.row_limit
      }
    }], ...legacySortBy/* legacySortBy */.A]
  }, {
    label: (0,TranslatorSingleton.t)('Options'),
    expanded: true,
    tabOverride: 'data',
    controlSetRows: [[{
      name: 'aggregateFunction',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Aggregation function'),
        clearable: false,
        choices: (0,selectOptions/* formatSelectOptions */.m)(['Count', 'Count Unique Values', 'List Unique Values', 'Sum', 'Average', 'Median', 'Sample Variance', 'Sample Standard Deviation', 'Minimum', 'Maximum', 'First', 'Last', 'Sum as Fraction of Total', 'Sum as Fraction of Rows', 'Sum as Fraction of Columns', 'Count as Fraction of Total', 'Count as Fraction of Rows', 'Count as Fraction of Columns']),
        default: 'Sum',
        description: (0,TranslatorSingleton.t)('Aggregate function to apply when pivoting and computing the total rows and columns'),
        renderTrigger: true
      }
    }], [{
      name: 'rowTotals',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show rows total'),
        default: false,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Display row level total')
      }
    }], [{
      name: 'colTotals',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show columns total'),
        default: false,
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Display column level total')
      }
    }], [{
      name: 'transposePivot',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Transpose pivot'),
        default: false,
        description: (0,TranslatorSingleton.t)('Swap rows and columns'),
        renderTrigger: true
      }
    }], [{
      name: 'combineMetric',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Combine metrics'),
        default: false,
        description: (0,TranslatorSingleton.t)('Display metrics side by side within each column, as ' + 'opposed to each column being displayed side by side for each metric.'),
        renderTrigger: true
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Options'),
    expanded: true,
    controlSetRows: [[{
      name: 'valueFormat',
      config: { ...shared_controls/* sharedControls.y_axis_format */.Hq.y_axis_format,
        label: (0,TranslatorSingleton.t)('Value format')
      }
    }], [{
      name: 'date_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Date format'),
        default: smartDate/* default.id */.Z.id,
        renderTrigger: true,
        choices: D3Formatting/* D3_TIME_FORMAT_OPTIONS */.HC,
        description: (0,TranslatorSingleton.t)('D3 time format for datetime columns')
      }
    }], [{
      name: 'rowOrder',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Rows sort by'),
        default: 'key_a_to_z',
        choices: [// [value, label]
        ['key_a_to_z', (0,TranslatorSingleton.t)('key a-z')], ['key_z_to_a', (0,TranslatorSingleton.t)('key z-a')], ['value_a_to_z', (0,TranslatorSingleton.t)('value ascending')], ['value_z_to_a', (0,TranslatorSingleton.t)('value descending')]],
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Order of rows')
      }
    }], [{
      name: 'colOrder',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Cols sort by'),
        default: 'key_a_to_z',
        choices: [// [value, label]
        ['key_a_to_z', (0,TranslatorSingleton.t)('key a-z')], ['key_z_to_a', (0,TranslatorSingleton.t)('key z-a')], ['value_a_to_z', (0,TranslatorSingleton.t)('value ascending')], ['value_z_to_a', (0,TranslatorSingleton.t)('value descending')]],
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Order of columns')
      }
    }], [{
      name: 'rowSubtotalPosition',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Rows subtotal position'),
        default: false,
        choices: [// [value, label]
        [true, (0,TranslatorSingleton.t)('Top')], [false, (0,TranslatorSingleton.t)('Bottom')]],
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Position of row level subtotal')
      }
    }], [{
      name: 'colSubtotalPosition',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Cols subtotal position'),
        default: false,
        choices: [// [value, label]
        [true, (0,TranslatorSingleton.t)('Left')], [false, (0,TranslatorSingleton.t)('Right')]],
        renderTrigger: true,
        description: (0,TranslatorSingleton.t)('Position of column level subtotal')
      }
    }], [{
      name: 'conditional_formatting',
      config: {
        type: 'ConditionalFormattingControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Conditional formatting'),
        description: (0,TranslatorSingleton.t)('Apply conditional color formatting to metrics'),

        mapStateToProps(explore) {
          var _explore$controls, _explore$controls$met, _explore$datasource;

          const values = (explore == null ? void 0 : (_explore$controls = explore.controls) == null ? void 0 : (_explore$controls$met = _explore$controls.metrics) == null ? void 0 : _explore$controls$met.value) ?? [];
          const verboseMap = (explore == null ? void 0 : (_explore$datasource = explore.datasource) == null ? void 0 : _explore$datasource.verbose_map) ?? {};
          const metricColumn = values.map(value => {
            if (typeof value === 'string') {
              return {
                value,
                label: verboseMap[value] ?? value
              };
            }

            return {
              value: value.label,
              label: value.label
            };
          });
          return {
            columnOptions: metricColumn,
            verboseMap
          };
        }

      }
    }]]
  }]
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/time-format/TimeFormats.js
var TimeFormats = __webpack_require__(76187);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/extractTimegrain.js
var extractTimegrain = __webpack_require__(54441);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/types/QueryResponse.js
var QueryResponse = __webpack_require__(23274);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/time-format/TimeFormatterRegistrySingleton.js + 5 modules
var TimeFormatterRegistrySingleton = __webpack_require__(14826);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/getColorFormatters.js
var getColorFormatters = __webpack_require__(31841);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-pivot-table/esm/plugin/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const {
  DATABASE_DATETIME
} = TimeFormats/* default */.Z;

function isNumeric(key, data = []) {
  return data.every(record => record[key] === null || record[key] === undefined || typeof record[key] === 'number');
}

function transformProps(chartProps) {
  /**
   * This function is called after a successful response has been
   * received from the chart data endpoint, and is used to transform
   * the incoming data prior to being sent to the Visualization.
   *
   * The transformProps function is also quite useful to return
   * additional/modified props to your data viz component. The formData
   * can also be accessed from your PivotTableChart.tsx file, but
   * doing supplying custom props here is often handy for integrating third
   * party libraries that rely on specific props.
   *
   * A description of properties in `chartProps`:
   * - `height`, `width`: the height/width of the DOM element in which
   *   the chart is located
   * - `formData`: the chart data request payload that was sent to the
   *   backend.
   * - `queriesData`: the chart data response payload that was received
   *   from the backend. Some notable properties of `queriesData`:
   *   - `data`: an array with data, each row with an object mapping
   *     the column/alias to its value. Example:
   *     `[{ col1: 'abc', metric1: 10 }, { col1: 'xyz', metric1: 20 }]`
   *   - `rowcount`: the number of rows in `data`
   *   - `query`: the query that was issued.
   *
   * Please note: the transformProps function gets cached when the
   * application loads. When making changes to the `transformProps`
   * function during development with hot reloading, changes won't
   * be seen until restarting the development server.
   */
  const {
    width,
    height,
    queriesData,
    formData,
    rawFormData,
    hooks: {
      setDataMask = () => {}
    },
    filterState,
    datasource: {
      verboseMap = {},
      columnFormats = {}
    }
  } = chartProps;
  const {
    data,
    colnames,
    coltypes
  } = queriesData[0];
  const {
    groupbyRows,
    groupbyColumns,
    metrics,
    tableRenderer,
    colOrder,
    rowOrder,
    aggregateFunction,
    transposePivot,
    combineMetric,
    rowSubtotalPosition,
    colSubtotalPosition,
    colTotals,
    rowTotals,
    valueFormat,
    dateFormat,
    emitFilter,
    metricsLayout,
    conditionalFormatting
  } = formData;
  const {
    selectedFilters
  } = filterState;
  const granularity = (0,extractTimegrain/* default */.Z)(rawFormData);
  const dateFormatters = colnames.filter((colname, index) => coltypes[index] === QueryResponse/* GenericDataType.TEMPORAL */.Z.TEMPORAL).reduce((acc, temporalColname) => {
    let formatter;

    if (dateFormat === smartDate/* default.id */.Z.id) {
      if (granularity) {
        // time column use formats based on granularity
        formatter = (0,TimeFormatterRegistrySingleton/* getTimeFormatterForGranularity */.uh)(granularity);
      } else if (isNumeric(temporalColname, data)) {
        formatter = (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(DATABASE_DATETIME);
      } else {
        // if no column-specific format, print cell as is
        formatter = String;
      }
    } else if (dateFormat) {
      formatter = (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(dateFormat);
    }

    if (formatter) {
      acc[temporalColname] = formatter;
    }

    return acc;
  }, {});
  const metricColorFormatters = (0,getColorFormatters/* getColorFormatters */.ni)(conditionalFormatting, data);
  return {
    width,
    height,
    data,
    groupbyRows,
    groupbyColumns,
    metrics,
    tableRenderer,
    colOrder,
    rowOrder,
    aggregateFunction,
    transposePivot,
    combineMetric,
    rowSubtotalPosition,
    colSubtotalPosition,
    colTotals,
    rowTotals,
    valueFormat,
    emitFilter,
    setDataMask,
    selectedFilters,
    verboseMap,
    columnFormats,
    metricsLayout,
    metricColorFormatters,
    dateFormatters
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-pivot-table/esm/images/thumbnail.png
var thumbnail = __webpack_require__(56407);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-pivot-table/esm/plugin/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





class PivotTableChartPlugin extends ChartPlugin/* default */.Z {
  /**
   * The constructor is used to pass relevant metadata and callbacks that get
   * registered in respective registries that are used throughout the library
   * and application. A more thorough description of each property is given in
   * the respective imported file.
   *
   * It is worth noting that `buildQuery` and is optional, and only needed for
   * advanced visualizations that require either post processing operations
   * (pivoting, rolling aggregations, sorting etc) or submitting multiple queries.
   */
  constructor() {
    const metadata = new ChartMetadata/* default */.Z({
      behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
      category: (0,TranslatorSingleton.t)('Table'),
      description: (0,TranslatorSingleton.t)('Used to summarize a set of data by grouping together multiple statistics along two axes. Examples: Sales numbers by region and month, tasks by status and assignee, active users by age and location. Not the most visually stunning visualization, but highly informative and versatile.'),
      name: (0,TranslatorSingleton.t)('Pivot Table v2'),
      tags: [(0,TranslatorSingleton.t)('Additive'), (0,TranslatorSingleton.t)('Report'), (0,TranslatorSingleton.t)('Tabular'), (0,TranslatorSingleton.t)('Popular')],
      thumbnail: thumbnail
    });
    super({
      buildQuery: buildQuery,
      controlPanel: controlPanel,
      loadChart: () => __webpack_require__.e(/* import() */ 9574).then(__webpack_require__.bind(__webpack_require__, 99574)),
      metadata,
      transformProps: transformProps
    });
  }

}

/***/ }),

/***/ 98164:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Q": () => (/* binding */ MetricsLayoutEnum)
/* harmony export */ });
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
let MetricsLayoutEnum;

(function (MetricsLayoutEnum) {
  MetricsLayoutEnum["ROWS"] = "ROWS";
  MetricsLayoutEnum["COLUMNS"] = "COLUMNS";
})(MetricsLayoutEnum || (MetricsLayoutEnum = {}));

/***/ }),

/***/ 17766:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "X": () => (/* binding */ updateExternalFormData)
/* harmony export */ });
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const updateExternalFormData = (setDataMask = () => {}, pageNumber, pageSize) => setDataMask({
  ownState: {
    currentPage: pageNumber,
    pageSize
  }
});

/***/ }),

/***/ 95928:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "T": () => (/* binding */ PAGE_SIZE_OPTIONS)
/* harmony export */ });
/* harmony import */ var _superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24610);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(60650);
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20633);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



(0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__/* .addLocaleData */ .oK)(_i18n__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z);
const PAGE_SIZE_OPTIONS = (0,_superset_ui_chart_controls__WEBPACK_IMPORTED_MODULE_2__/* .formatSelectOptions */ .m)([[0, (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_0__.t)('page_size.all')], 10, 20, 50, 100, 200]);

/***/ }),

/***/ 20633:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const en = {
  'Query Mode': [''],
  Aggregate: [''],
  'Raw Records': [''],
  'Emit Filter Events': [''],
  'Show Cell Bars': [''],
  'page_size.show': ['Show'],
  'page_size.all': ['All'],
  'page_size.entries': ['entries'],
  'table.previous_page': ['Previous'],
  'table.next_page': ['Next'],
  'search.num_records': ['%s record', '%s records...']
};
const translations = {
  en,
  fr: {
    'Query Mode': [''],
    Aggregate: [''],
    'Raw Records': [''],
    'Emit Filter Events': [''],
    'Show Cell Bars': [''],
    'page_size.show': ['Afficher'],
    'page_size.all': ['tous'],
    'page_size.entries': ['entrées'],
    'table.previous_page': ['Précédent'],
    'table.next_page': ['Suivante'],
    'search.num_records': ['%s enregistrement', '%s enregistrements...']
  },
  zh: {
    'Query Mode': ['查询模式'],
    Aggregate: ['分组聚合'],
    'Raw Records': ['原始数据'],
    'Emit Filter Events': ['关联看板过滤器'],
    'Show Cell Bars': ['为指标添加条状图背景'],
    'page_size.show': ['每页显示'],
    'page_size.all': ['全部'],
    'page_size.entries': ['条'],
    'table.previous_page': ['上一页'],
    'table.next_page': ['下一页'],
    'search.num_records': ['%s条记录...']
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (translations);

/***/ }),

/***/ 18917:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ TableChartPlugin)
});

// UNUSED EXPORTS: __hack__

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/types/Base.js
var Base = __webpack_require__(52686);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
// EXTERNAL MODULE: ./node_modules/memoize-one/dist/memoize-one.esm.js
var memoize_one_esm = __webpack_require__(30845);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormats.js
var NumberFormats = __webpack_require__(63758);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/time-format/TimeFormats.js
var TimeFormats = __webpack_require__(76187);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/types/QueryResponse.js
var QueryResponse = __webpack_require__(23274);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/extractTimegrain.js
var extractTimegrain = __webpack_require__(54441);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/getMetricLabel.js
var getMetricLabel = __webpack_require__(95669);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/time-format/formatters/smartDate.js
var smartDate = __webpack_require__(11304);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/time-format/TimeFormatterRegistrySingleton.js + 5 modules
var TimeFormatterRegistrySingleton = __webpack_require__(14826);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormatterRegistrySingleton.js
var NumberFormatterRegistrySingleton = __webpack_require__(50855);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/types/QueryFormData.js
var QueryFormData = __webpack_require__(41434);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/getColorFormatters.js
var getColorFormatters = __webpack_require__(31841);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/utils/isEqualArray.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function isEqualArray(arrA, arrB) {
  return arrA === arrB || !arrA && !arrB || arrA && arrB && arrA.length === arrB.length && arrA.every((x, i) => x === arrB[i]);
}
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/utils/isEqualColumns.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function isEqualColumns(propsA, propsB) {
  var _a$queriesData, _a$queriesData$, _b$queriesData, _b$queriesData$, _a$queriesData2, _a$queriesData2$, _b$queriesData2, _b$queriesData2$;

  const a = propsA[0];
  const b = propsB[0];
  return a.datasource.columnFormats === b.datasource.columnFormats && a.datasource.verboseMap === b.datasource.verboseMap && a.formData.tableTimestampFormat === b.formData.tableTimestampFormat && a.formData.timeGrainSqla === b.formData.timeGrainSqla && JSON.stringify(a.formData.columnConfig || null) === JSON.stringify(b.formData.columnConfig || null) && isEqualArray(a.formData.metrics, b.formData.metrics) && isEqualArray((_a$queriesData = a.queriesData) == null ? void 0 : (_a$queriesData$ = _a$queriesData[0]) == null ? void 0 : _a$queriesData$.colnames, (_b$queriesData = b.queriesData) == null ? void 0 : (_b$queriesData$ = _b$queriesData[0]) == null ? void 0 : _b$queriesData$.colnames) && isEqualArray((_a$queriesData2 = a.queriesData) == null ? void 0 : (_a$queriesData2$ = _a$queriesData2[0]) == null ? void 0 : _a$queriesData2$.coltypes, (_b$queriesData2 = b.queriesData) == null ? void 0 : (_b$queriesData2$ = _b$queriesData2[0]) == null ? void 0 : _b$queriesData2$.coltypes) && JSON.stringify(a.formData.extraFilters || null) === JSON.stringify(b.formData.extraFilters || null) && JSON.stringify(a.formData.extraFormData || null) === JSON.stringify(b.formData.extraFormData || null);
}
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/utils/DateWithFormatter.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const REGEXP_TIMESTAMP_NO_TIMEZONE = /T(\d{2}:){2}\d{2}$/;
/**
 * Extended Date object with a custom formatter, and retains the original input
 * when the formatter is simple `String(..)`.
 */

class DateWithFormatter extends Date {
  constructor(input, {
    formatter = String,
    forceUTC = true
  } = {}) {
    let value = input; // assuming timestamps without a timezone is in UTC time

    if (forceUTC && typeof value === 'string' && REGEXP_TIMESTAMP_NO_TIMEZONE.test(value)) {
      value = `${value}Z`;
    }

    super(value);
    this.formatter = void 0;
    this.input = void 0;
    this.input = input;
    this.formatter = formatter;

    this.toString = () => {
      if (this.formatter === String) {
        return String(this.input);
      }

      return this.formatter ? this.formatter(this) : Date.toString.call(this);
    };
  }

}
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/transformProps.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const {
  PERCENT_3_POINT
} = NumberFormats/* default */.Z;
const {
  DATABASE_DATETIME
} = TimeFormats/* default */.Z;

function isNumeric(key, data = []) {
  return data.every(x => x[key] === null || x[key] === undefined || typeof x[key] === 'number');
}

const processDataRecords = (0,memoize_one_esm/* default */.Z)(function processDataRecords(data, columns) {
  if (!data || !data[0]) {
    return data || [];
  }

  const timeColumns = columns.filter(column => column.dataType === QueryResponse/* GenericDataType.TEMPORAL */.Z.TEMPORAL);

  if (timeColumns.length > 0) {
    return data.map(x => {
      const datum = { ...x
      };
      timeColumns.forEach(({
        key,
        formatter
      }) => {
        // Convert datetime with a custom date class so we can use `String(...)`
        // formatted value for global search, and `date.getTime()` for sorting.
        datum[key] = new DateWithFormatter(x[key], {
          formatter: formatter
        });
      });
      return datum;
    });
  }

  return data;
});
const processColumns = (0,memoize_one_esm/* default */.Z)(function processColumns(props) {
  const {
    datasource: {
      columnFormats,
      verboseMap
    },
    rawFormData: {
      table_timestamp_format: tableTimestampFormat,
      metrics: metrics_,
      percent_metrics: percentMetrics_,
      column_config: columnConfig = {}
    },
    queriesData
  } = props;
  const granularity = (0,extractTimegrain/* default */.Z)(props.rawFormData);
  const {
    data: records,
    colnames,
    coltypes
  } = queriesData[0] || {}; // convert `metrics` and `percentMetrics` to the key names in `data.records`

  const metrics = (metrics_ ?? []).map(getMetricLabel/* default */.Z);
  const rawPercentMetrics = (percentMetrics_ ?? []).map(getMetricLabel/* default */.Z); // column names for percent metrics always starts with a '%' sign.

  const percentMetrics = rawPercentMetrics.map(x => `%${x}`);
  const metricsSet = new Set(metrics);
  const percentMetricsSet = new Set(percentMetrics);
  const rawPercentMetricsSet = new Set(rawPercentMetrics);
  const columns = (colnames || []).filter(key => // if a metric was only added to percent_metrics, they should not show up in the table.
  !(rawPercentMetricsSet.has(key) && !metricsSet.has(key))).map((key, i) => {
    const label = (verboseMap == null ? void 0 : verboseMap[key]) || key;
    const dataType = coltypes[i];
    const config = columnConfig[key] || {}; // for the purpose of presentation, only numeric values are treated as metrics
    // because users can also add things like `MAX(str_col)` as a metric.

    const isMetric = metricsSet.has(key) && isNumeric(key, records);
    const isPercentMetric = percentMetricsSet.has(key);
    const isTime = dataType === QueryResponse/* GenericDataType.TEMPORAL */.Z.TEMPORAL;
    const savedFormat = columnFormats == null ? void 0 : columnFormats[key];
    const numberFormat = config.d3NumberFormat || savedFormat;
    let formatter;

    if (isTime || config.d3TimeFormat) {
      // string types may also apply d3-time format
      // pick adhoc format first, fallback to column level formats defined in
      // datasource
      const customFormat = config.d3TimeFormat || savedFormat;
      const timeFormat = customFormat || tableTimestampFormat; // When format is "Adaptive Formatting" (smart_date)

      if (timeFormat === smartDate/* default.id */.Z.id) {
        if (granularity) {
          // time column use formats based on granularity
          formatter = (0,TimeFormatterRegistrySingleton/* getTimeFormatterForGranularity */.uh)(granularity);
        } else if (customFormat) {
          // other columns respect the column-specific format
          formatter = (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(customFormat);
        } else if (isNumeric(key, records)) {
          // if column is numeric values, it is considered a timestamp64
          formatter = (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(DATABASE_DATETIME);
        } else {
          // if no column-specific format, print cell as is
          formatter = String;
        }
      } else if (timeFormat) {
        formatter = (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(timeFormat);
      }
    } else if (isPercentMetric) {
      // percent metrics have a default format
      formatter = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(numberFormat || PERCENT_3_POINT);
    } else if (isMetric || numberFormat) {
      formatter = (0,NumberFormatterRegistrySingleton/* getNumberFormatter */.JB)(numberFormat);
    }

    return {
      key,
      label,
      dataType,
      isNumeric: dataType === QueryResponse/* GenericDataType.NUMERIC */.Z.NUMERIC,
      isMetric,
      isPercentMetric,
      formatter,
      config
    };
  });
  return [metrics, percentMetrics, columns];
}, isEqualColumns);
/**
 * Automatically set page size based on number of cells.
 */

const getPageSize = (pageSize, numRecords, numColumns) => {
  if (typeof pageSize === 'number') {
    // NaN is also has typeof === 'number'
    return pageSize || 0;
  }

  if (typeof pageSize === 'string') {
    return Number(pageSize) || 0;
  } // when pageSize not set, automatically add pagination if too many records


  return numRecords * numColumns > 5000 ? 200 : 0;
};

const transformProps = chartProps => {
  var _baseQuery2, _totalQuery;

  const {
    height,
    width,
    rawFormData: formData,
    queriesData = [],
    filterState,
    ownState: serverPaginationData = {},
    hooks: {
      onAddFilter: onChangeFilter,
      setDataMask = () => {}
    }
  } = chartProps;
  const {
    align_pn: alignPositiveNegative = true,
    color_pn: colorPositiveNegative = true,
    show_cell_bars: showCellBars = true,
    include_search: includeSearch = false,
    page_length: pageLength,
    emit_filter: emitFilter,
    server_pagination: serverPagination = false,
    server_page_length: serverPageLength = 10,
    order_desc: sortDesc = false,
    query_mode: queryMode,
    show_totals: showTotals,
    conditional_formatting: conditionalFormatting
  } = formData;
  const timeGrain = (0,extractTimegrain/* default */.Z)(formData);
  const [metrics, percentMetrics, columns] = processColumns(chartProps);
  let baseQuery;
  let countQuery;
  let totalQuery;
  let rowCount;

  if (serverPagination) {
    var _countQuery, _countQuery$data, _countQuery$data$;

    [baseQuery, countQuery, totalQuery] = queriesData;
    rowCount = ((_countQuery = countQuery) == null ? void 0 : (_countQuery$data = _countQuery.data) == null ? void 0 : (_countQuery$data$ = _countQuery$data[0]) == null ? void 0 : _countQuery$data$.rowcount) ?? 0;
  } else {
    var _baseQuery;

    [baseQuery, totalQuery] = queriesData;
    rowCount = ((_baseQuery = baseQuery) == null ? void 0 : _baseQuery.rowcount) ?? 0;
  }

  const data = processDataRecords((_baseQuery2 = baseQuery) == null ? void 0 : _baseQuery2.data, columns);
  const totals = showTotals && queryMode === QueryFormData/* QueryMode.aggregate */.nJ.aggregate ? (_totalQuery = totalQuery) == null ? void 0 : _totalQuery.data[0] : undefined;
  const columnColorFormatters = (0,getColorFormatters/* getColorFormatters */.ni)(conditionalFormatting, data) ?? [];
  return {
    height,
    width,
    isRawRecords: queryMode === QueryFormData/* QueryMode.raw */.nJ.raw,
    data,
    totals,
    columns,
    serverPagination,
    metrics,
    percentMetrics,
    serverPaginationData,
    setDataMask,
    alignPositiveNegative,
    colorPositiveNegative,
    showCellBars,
    sortDesc,
    includeSearch,
    rowCount,
    pageSize: serverPagination ? serverPageLength : getPageSize(pageLength, data.length, columns.length),
    filters: filterState.filters,
    emitFilter,
    onChangeFilter,
    columnColorFormatters,
    timeGrain
  };
};

/* harmony default export */ const esm_transformProps = (transformProps);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/images/thumbnail.png
var thumbnail = __webpack_require__(9129);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/images/Table.jpg
var Table = __webpack_require__(3037);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/images/Table2.jpg
var Table2 = __webpack_require__(32801);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/images/Table3.jpg
var Table3 = __webpack_require__(22669);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/utils/ensureIsArray.js
var ensureIsArray = __webpack_require__(86852);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/utils/featureFlags.js
var featureFlags = __webpack_require__(46415);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/constants.js
var constants = __webpack_require__(14785);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/components/ColumnOption.js
var ColumnOption = __webpack_require__(82204);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/index.js
var shared_controls = __webpack_require__(28500);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/shared-controls/emitFilterControl.js
var emitFilterControl = __webpack_require__(36906);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/utils/D3Formatting.js
var D3Formatting = __webpack_require__(67774);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/i18n.js
var i18n = __webpack_require__(20633);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/consts.js
var consts = __webpack_require__(95928);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/controlPanel.js
/* eslint-disable camelcase */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






(0,TranslatorSingleton/* addLocaleData */.oK)(i18n/* default */.Z);

function getQueryMode(controls) {
  var _controls$query_mode, _controls$all_columns;

  const mode = controls == null ? void 0 : (_controls$query_mode = controls.query_mode) == null ? void 0 : _controls$query_mode.value;

  if (mode === QueryFormData/* QueryMode.aggregate */.nJ.aggregate || mode === QueryFormData/* QueryMode.raw */.nJ.raw) {
    return mode;
  }

  const rawColumns = controls == null ? void 0 : (_controls$all_columns = controls.all_columns) == null ? void 0 : _controls$all_columns.value;
  const hasRawColumns = rawColumns && rawColumns.length > 0;
  return hasRawColumns ? QueryFormData/* QueryMode.raw */.nJ.raw : QueryFormData/* QueryMode.aggregate */.nJ.aggregate;
}
/**
 * Visibility check
 */


function isQueryMode(mode) {
  return ({
    controls
  }) => getQueryMode(controls) === mode;
}

const isAggMode = isQueryMode(QueryFormData/* QueryMode.aggregate */.nJ.aggregate);
const isRawMode = isQueryMode(QueryFormData/* QueryMode.raw */.nJ.raw);

const validateAggControlValues = (controls, values) => {
  const areControlsEmpty = values.every(val => (0,ensureIsArray/* default */.Z)(val).length === 0);
  return areControlsEmpty && isAggMode({
    controls
  }) ? [(0,TranslatorSingleton.t)('Group By, Metrics or Percentage Metrics must have a value')] : [];
};

const queryMode = {
  type: 'RadioButtonControl',
  label: (0,TranslatorSingleton.t)('Query mode'),
  default: null,
  options: [[QueryFormData/* QueryMode.aggregate */.nJ.aggregate, constants/* QueryModeLabel */.cm[QueryFormData/* QueryMode.aggregate */.nJ.aggregate]], [QueryFormData/* QueryMode.raw */.nJ.raw, constants/* QueryModeLabel */.cm[QueryFormData/* QueryMode.raw */.nJ.raw]]],
  mapStateToProps: ({
    controls
  }) => ({
    value: getQueryMode(controls)
  }),
  rerender: ['all_columns', 'groupby', 'metrics', 'percent_metrics']
};
const all_columns = {
  type: 'SelectControl',
  label: (0,TranslatorSingleton.t)('Columns'),
  description: (0,TranslatorSingleton.t)('Columns to display'),
  multi: true,
  freeForm: true,
  allowAll: true,
  commaChoosesOption: false,
  default: [],
  optionRenderer: c => (0,emotion_react_browser_esm.jsx)(ColumnOption/* ColumnOption */.E, {
    showType: true,
    column: c
  }),
  valueRenderer: c => (0,emotion_react_browser_esm.jsx)(ColumnOption/* ColumnOption */.E, {
    column: c
  }),
  valueKey: 'column_name',
  mapStateToProps: ({
    datasource,
    controls
  }, controlState) => ({
    options: (datasource == null ? void 0 : datasource.columns) || [],
    queryMode: getQueryMode(controls),
    externalValidationErrors: isRawMode({
      controls
    }) && (0,ensureIsArray/* default */.Z)(controlState.value).length === 0 ? [(0,TranslatorSingleton.t)('must have a value')] : []
  }),
  visibility: isRawMode
};
const dnd_all_columns = {
  type: 'DndColumnSelect',
  label: (0,TranslatorSingleton.t)('Columns'),
  description: (0,TranslatorSingleton.t)('Columns to display'),
  default: [],

  mapStateToProps({
    datasource,
    controls
  }, controlState) {
    const newState = {};

    if (datasource) {
      const options = datasource.columns;
      newState.options = Object.fromEntries(options.map(option => [option.column_name, option]));
    }

    newState.queryMode = getQueryMode(controls);
    newState.externalValidationErrors = isRawMode({
      controls
    }) && (0,ensureIsArray/* default */.Z)(controlState.value).length === 0 ? [(0,TranslatorSingleton.t)('must have a value')] : [];
    return newState;
  },

  visibility: isRawMode
};
const percent_metrics = {
  type: 'MetricsControl',
  label: (0,TranslatorSingleton.t)('Percentage metrics'),
  description: (0,TranslatorSingleton.t)('Metrics for which percentage of total are to be displayed. Calculated from only data within the row limit.'),
  multi: true,
  visibility: isAggMode,
  mapStateToProps: ({
    datasource,
    controls
  }, controlState) => {
    var _controls$groupby, _controls$metrics;

    return {
      columns: (datasource == null ? void 0 : datasource.columns) || [],
      savedMetrics: (datasource == null ? void 0 : datasource.metrics) || [],
      datasource,
      datasourceType: datasource == null ? void 0 : datasource.type,
      queryMode: getQueryMode(controls),
      externalValidationErrors: validateAggControlValues(controls, [(_controls$groupby = controls.groupby) == null ? void 0 : _controls$groupby.value, (_controls$metrics = controls.metrics) == null ? void 0 : _controls$metrics.value, controlState.value])
    };
  },
  rerender: ['groupby', 'metrics'],
  default: [],
  validators: []
};
const dnd_percent_metrics = { ...percent_metrics,
  type: 'DndMetricSelect'
};
const config = {
  controlPanelSections: [esm.sections.legacyTimeseriesTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [[{
      name: 'query_mode',
      config: queryMode
    }], [{
      name: 'groupby',
      override: {
        visibility: isAggMode,
        mapStateToProps: (state, controlState) => {
          var _sharedControls$group, _controls$metrics2, _controls$percent_met;

          const {
            controls
          } = state;
          const originalMapStateToProps = shared_controls/* sharedControls */.Hq == null ? void 0 : (_sharedControls$group = shared_controls/* sharedControls.groupby */.Hq.groupby) == null ? void 0 : _sharedControls$group.mapStateToProps;
          const newState = (originalMapStateToProps == null ? void 0 : originalMapStateToProps(state, controlState)) ?? {};
          newState.externalValidationErrors = validateAggControlValues(controls, [(_controls$metrics2 = controls.metrics) == null ? void 0 : _controls$metrics2.value, (_controls$percent_met = controls.percent_metrics) == null ? void 0 : _controls$percent_met.value, controlState.value]);
          return newState;
        },
        rerender: ['metrics', 'percent_metrics']
      }
    }], [{
      name: 'metrics',
      override: {
        validators: [],
        visibility: isAggMode,
        mapStateToProps: ({
          controls,
          datasource,
          form_data
        }, controlState) => {
          var _controls$groupby2, _controls$percent_met2;

          return {
            columns: (datasource == null ? void 0 : datasource.columns.filter(c => c.filterable)) || [],
            savedMetrics: (datasource == null ? void 0 : datasource.metrics) || [],
            // current active adhoc metrics
            selectedMetrics: form_data.metrics || (form_data.metric ? [form_data.metric] : []),
            datasource,
            externalValidationErrors: validateAggControlValues(controls, [(_controls$groupby2 = controls.groupby) == null ? void 0 : _controls$groupby2.value, (_controls$percent_met2 = controls.percent_metrics) == null ? void 0 : _controls$percent_met2.value, controlState.value])
          };
        },
        rerender: ['groupby', 'percent_metrics']
      }
    }, {
      name: 'all_columns',
      config: (0,featureFlags/* isFeatureEnabled */.c)(featureFlags/* FeatureFlag.ENABLE_EXPLORE_DRAG_AND_DROP */.T.ENABLE_EXPLORE_DRAG_AND_DROP) ? dnd_all_columns : all_columns
    }], [{
      name: 'percent_metrics',
      config: { ...((0,featureFlags/* isFeatureEnabled */.c)(featureFlags/* FeatureFlag.ENABLE_EXPLORE_DRAG_AND_DROP */.T.ENABLE_EXPLORE_DRAG_AND_DROP) ? dnd_percent_metrics : percent_metrics)
      }
    }], [{
      name: 'timeseries_limit_metric',
      override: {
        visibility: isAggMode
      }
    }, {
      name: 'order_by_cols',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Ordering'),
        description: (0,TranslatorSingleton.t)('Order results by selected columns'),
        multi: true,
        default: [],
        mapStateToProps: ({
          datasource
        }) => ({
          choices: (datasource == null ? void 0 : datasource.order_by_choices) || []
        }),
        visibility: isRawMode
      }
    }], (0,featureFlags/* isFeatureEnabled */.c)(featureFlags/* FeatureFlag.DASHBOARD_CROSS_FILTERS */.T.DASHBOARD_CROSS_FILTERS) || (0,featureFlags/* isFeatureEnabled */.c)(featureFlags/* FeatureFlag.DASHBOARD_NATIVE_FILTERS */.T.DASHBOARD_NATIVE_FILTERS) ? [{
      name: 'server_pagination',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Server pagination'),
        description: (0,TranslatorSingleton.t)('Enable server side pagination of results (experimental feature)'),
        default: false
      }
    }] : [], [{
      name: 'row_limit',
      override: {
        visibility: ({
          controls
        }) => {
          var _controls$server_pagi;

          return !(controls != null && (_controls$server_pagi = controls.server_pagination) != null && _controls$server_pagi.value);
        }
      }
    }, {
      name: 'server_page_length',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Server Page Length'),
        default: 10,
        choices: consts/* PAGE_SIZE_OPTIONS */.T,
        description: (0,TranslatorSingleton.t)('Rows per page, 0 means no pagination'),
        visibility: ({
          controls
        }) => {
          var _controls$server_pagi2;

          return Boolean(controls == null ? void 0 : (_controls$server_pagi2 = controls.server_pagination) == null ? void 0 : _controls$server_pagi2.value);
        }
      }
    }], [{
      name: 'include_time',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Include time'),
        description: (0,TranslatorSingleton.t)('Whether to include the time granularity as defined in the time section'),
        default: false,
        visibility: isAggMode
      }
    }, {
      name: 'order_desc',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort descending'),
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to sort descending or ascending'),
        visibility: isAggMode
      }
    }], [{
      name: 'show_totals',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Show totals'),
        default: false,
        description: (0,TranslatorSingleton.t)('Show total aggregations of selected metrics. Note that row limit does not apply to the result.'),
        visibility: isAggMode
      }
    }], ['adhoc_filters'], emitFilterControl/* emitFilterControl */.a]
  }, {
    label: (0,TranslatorSingleton.t)('Options'),
    expanded: true,
    controlSetRows: [[{
      name: 'table_timestamp_format',
      config: {
        type: 'SelectControl',
        freeForm: true,
        label: (0,TranslatorSingleton.t)('Timestamp format'),
        default: smartDate/* default.id */.Z.id,
        renderTrigger: true,
        clearable: false,
        choices: D3Formatting/* D3_TIME_FORMAT_OPTIONS */.HC,
        description: (0,TranslatorSingleton.t)('D3 time format for datetime columns')
      }
    }], [{
      name: 'page_length',
      config: {
        type: 'SelectControl',
        freeForm: true,
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Page length'),
        default: null,
        choices: consts/* PAGE_SIZE_OPTIONS */.T,
        description: (0,TranslatorSingleton.t)('Rows per page, 0 means no pagination'),
        visibility: ({
          controls
        }) => {
          var _controls$server_pagi3;

          return !(controls != null && (_controls$server_pagi3 = controls.server_pagination) != null && _controls$server_pagi3.value);
        }
      }
    }, null], [{
      name: 'include_search',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Search box'),
        renderTrigger: true,
        default: false,
        description: (0,TranslatorSingleton.t)('Whether to include a client-side search box')
      }
    }, {
      name: 'show_cell_bars',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Cell bars'),
        renderTrigger: true,
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to display a bar chart background in table columns')
      }
    }], [{
      name: 'align_pn',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Align +/-'),
        renderTrigger: true,
        default: false,
        description: (0,TranslatorSingleton.t)('Whether to align background charts with both positive and negative values at 0')
      }
    }, {
      name: 'color_pn',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Color +/-'),
        renderTrigger: true,
        default: true,
        description: (0,TranslatorSingleton.t)('Whether to colorize numeric values by if they are positive or negative')
      }
    }], [{
      name: 'column_config',
      config: {
        type: 'ColumnConfigControl',
        label: (0,TranslatorSingleton.t)('Customize columns'),
        description: (0,TranslatorSingleton.t)('Further customize how to display each column'),
        renderTrigger: true,

        mapStateToProps(explore, control, chart) {
          var _chart$queriesRespons, _explore$controls, _explore$controls$tab;

          return {
            queryResponse: chart == null ? void 0 : (_chart$queriesRespons = chart.queriesResponse) == null ? void 0 : _chart$queriesRespons[0],
            emitFilter: explore == null ? void 0 : (_explore$controls = explore.controls) == null ? void 0 : (_explore$controls$tab = _explore$controls.table_filter) == null ? void 0 : _explore$controls$tab.value
          };
        }

      }
    }], [{
      name: 'conditional_formatting',
      config: {
        type: 'ConditionalFormattingControl',
        renderTrigger: true,
        label: (0,TranslatorSingleton.t)('Conditional formatting'),
        description: (0,TranslatorSingleton.t)('Apply conditional color formatting to numeric columns'),

        mapStateToProps(explore, control, chart) {
          var _explore$datasource, _chart$queriesRespons2;

          const verboseMap = (explore == null ? void 0 : (_explore$datasource = explore.datasource) == null ? void 0 : _explore$datasource.verbose_map) ?? {};
          const {
            colnames,
            coltypes
          } = (chart == null ? void 0 : (_chart$queriesRespons2 = chart.queriesResponse) == null ? void 0 : _chart$queriesRespons2[0]) ?? {};
          const numericColumns = Array.isArray(colnames) && Array.isArray(coltypes) ? colnames.filter((colname, index) => coltypes[index] === QueryResponse/* GenericDataType.NUMERIC */.Z.NUMERIC).map(colname => ({
            value: colname,
            label: verboseMap[colname] ?? colname
          })) : [];
          return {
            columnOptions: numericColumns,
            verboseMap
          };
        }

      }
    }]]
  }]
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/buildQueryContext.js
var buildQueryContext = __webpack_require__(69205);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/utils/removeDuplicates.js
var removeDuplicates = __webpack_require__(12349);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/DataTable/utils/externalAPIs.js
var externalAPIs = __webpack_require__(17766);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/buildQuery.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


/**
 * Infer query mode from form data. If `all_columns` is set, then raw records mode,
 * otherwise defaults to aggregation mode.
 *
 * The same logic is used in `controlPanel` with control values as well.
 */

function buildQuery_getQueryMode(formData) {
  const {
    query_mode: mode
  } = formData;

  if (mode === QueryFormData/* QueryMode.aggregate */.nJ.aggregate || mode === QueryFormData/* QueryMode.raw */.nJ.raw) {
    return mode;
  }

  const rawColumns = formData == null ? void 0 : formData.all_columns;
  const hasRawColumns = rawColumns && rawColumns.length > 0;
  return hasRawColumns ? QueryFormData/* QueryMode.raw */.nJ.raw : QueryFormData/* QueryMode.aggregate */.nJ.aggregate;
}

const buildQuery = (formData, options) => {
  const {
    percent_metrics: percentMetrics,
    order_desc: orderDesc = false
  } = formData;
  const queryMode = buildQuery_getQueryMode(formData);
  const sortByMetric = (0,ensureIsArray/* default */.Z)(formData.timeseries_limit_metric)[0];
  let formDataCopy = formData; // never include time in raw records mode

  if (queryMode === QueryFormData/* QueryMode.raw */.nJ.raw) {
    formDataCopy = { ...formData,
      include_time: false
    };
  }

  return (0,buildQueryContext/* default */.Z)(formDataCopy, baseQueryObject => {
    var _options$extras, _options$extras$cache, _options$extras2, _options$extras2$cach, _options$hooks2, _metrics2, _formData$extra_form_;

    let {
      metrics,
      orderby = []
    } = baseQueryObject;
    let postProcessing = [];

    if (queryMode === QueryFormData/* QueryMode.aggregate */.nJ.aggregate) {
      var _metrics;

      metrics = metrics || []; // orverride orderby with timeseries metric when in aggregation mode

      if (sortByMetric) {
        orderby = [[sortByMetric, !orderDesc]];
      } else if (((_metrics = metrics) == null ? void 0 : _metrics.length) > 0) {
        // default to ordering by first metric in descending order
        // when no "sort by" metric is set (regargless if "SORT DESC" is set to true)
        orderby = [[metrics[0], false]];
      } // add postprocessing for percent metrics only when in aggregation mode


      if (percentMetrics && percentMetrics.length > 0) {
        const percentMetricLabels = (0,removeDuplicates/* default */.Z)(percentMetrics.map(getMetricLabel/* default */.Z));
        metrics = (0,removeDuplicates/* default */.Z)(metrics.concat(percentMetrics), getMetricLabel/* default */.Z);
        postProcessing = [{
          operation: 'contribution',
          options: {
            columns: percentMetricLabels,
            rename_columns: percentMetricLabels.map(x => `%${x}`)
          }
        }];
      }
    }

    const moreProps = {};
    const ownState = (options == null ? void 0 : options.ownState) ?? {};

    if (formDataCopy.server_pagination) {
      moreProps.row_limit = ownState.pageSize ?? formDataCopy.server_page_length;
      moreProps.row_offset = (ownState.currentPage ?? 0) * (ownState.pageSize ?? 0);
    }

    let queryObject = { ...baseQueryObject,
      orderby,
      metrics,
      post_processing: postProcessing,
      ...moreProps
    };

    if (formData.server_pagination && options != null && (_options$extras = options.extras) != null && (_options$extras$cache = _options$extras.cachedChanges) != null && _options$extras$cache[formData.slice_id] && JSON.stringify(options == null ? void 0 : (_options$extras2 = options.extras) == null ? void 0 : (_options$extras2$cach = _options$extras2.cachedChanges) == null ? void 0 : _options$extras2$cach[formData.slice_id]) !== JSON.stringify(queryObject.filters)) {
      var _options$hooks;

      queryObject = { ...queryObject,
        row_offset: 0
      };
      (0,externalAPIs/* updateExternalFormData */.X)(options == null ? void 0 : (_options$hooks = options.hooks) == null ? void 0 : _options$hooks.setDataMask, 0, queryObject.row_limit ?? 0);
    } // Because we use same buildQuery for all table on the page we need split them by id


    options == null ? void 0 : (_options$hooks2 = options.hooks) == null ? void 0 : _options$hooks2.setCachedChanges({
      [formData.slice_id]: queryObject.filters
    });
    const extraQueries = [];

    if ((_metrics2 = metrics) != null && _metrics2.length && formData.show_totals && queryMode === QueryFormData/* QueryMode.aggregate */.nJ.aggregate) {
      extraQueries.push({ ...queryObject,
        columns: [],
        row_limit: 0,
        row_offset: 0,
        post_processing: []
      });
    }

    const interactiveGroupBy = (_formData$extra_form_ = formData.extra_form_data) == null ? void 0 : _formData$extra_form_.interactive_groupby;

    if (interactiveGroupBy && queryObject.columns) {
      queryObject.columns = [...new Set([...queryObject.columns, ...interactiveGroupBy])];
    }

    if (formData.server_pagination) {
      return [{ ...queryObject
      }, { ...queryObject,
        row_limit: 0,
        row_offset: 0,
        post_processing: [],
        is_rowcount: true
      }, ...extraQueries];
    }

    return [queryObject, ...extraQueries];
  });
}; // Use this closure to cache changing of external filters, if we have server pagination we need reset page to 0, after
// external filter changed


const cachedBuildQuery = () => {
  let cachedChanges = {};

  const setCachedChanges = newChanges => {
    cachedChanges = { ...cachedChanges,
      ...newChanges
    };
  };

  return (formData, options) => buildQuery({ ...formData
  }, {
    extras: {
      cachedChanges
    },
    ownState: (options == null ? void 0 : options.ownState) ?? {},
    hooks: { ...(options == null ? void 0 : options.hooks),
      setDataMask: () => {},
      setCachedChanges
    }
  });
};
/* harmony default export */ const esm_buildQuery = (cachedBuildQuery());
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-table/esm/index.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */








// must export something for the module to be exist in dev mode


const metadata = new ChartMetadata/* default */.Z({
  behaviors: [Base/* Behavior.INTERACTIVE_CHART */.cg.INTERACTIVE_CHART],
  category: (0,TranslatorSingleton.t)('Table'),
  canBeAnnotationTypes: ['EVENT', 'INTERVAL'],
  description: (0,TranslatorSingleton.t)('Classic row-by-column spreadsheet like view of a dataset. Use tables to showcase a view into the underlying data or to show aggregated metrics.'),
  exampleGallery: [{
    url: Table
  }, {
    url: Table2
  }, {
    url: Table3
  }],
  name: (0,TranslatorSingleton.t)('Table'),
  tags: [(0,TranslatorSingleton.t)('Additive'), (0,TranslatorSingleton.t)('Business'), (0,TranslatorSingleton.t)('Formattable'), (0,TranslatorSingleton.t)('Pattern'), (0,TranslatorSingleton.t)('Popular'), (0,TranslatorSingleton.t)('Report'), (0,TranslatorSingleton.t)('Sequential'), (0,TranslatorSingleton.t)('Tabular'), (0,TranslatorSingleton.t)('Description')],
  thumbnail: thumbnail
});
class TableChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(8924), __webpack_require__.e(6060)]).then(__webpack_require__.bind(__webpack_require__, 26060)),
      metadata,
      transformProps: esm_transformProps,
      controlPanel: controlPanel,
      buildQuery: esm_buildQuery
    });
  }

}

/***/ }),

/***/ 97235:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ WordCloudChartPlugin)
});

// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartMetadata.js
var ChartMetadata = __webpack_require__(40702);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js + 1 modules
var TranslatorSingleton = __webpack_require__(60650);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/chart/models/ChartPlugin.js
var ChartPlugin = __webpack_require__(15179);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-word-cloud/esm/legacyPlugin/transformProps.js
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function getMetricLabel(metric) {
  if (typeof metric === 'string' || typeof metric === 'undefined') {
    return metric;
  }

  if (Array.isArray(metric)) {
    return metric.length > 0 ? getMetricLabel(metric[0]) : undefined;
  }

  return metric.label;
}

function transformProps(chartProps) {
  const {
    width,
    height,
    formData,
    queriesData
  } = chartProps;
  const {
    colorScheme,
    metric,
    rotation,
    series,
    sizeFrom = 0,
    sizeTo
  } = formData;
  const metricLabel = getMetricLabel(metric);
  const encoding = {
    color: {
      field: series,
      scale: {
        scheme: colorScheme
      },
      type: 'nominal'
    },
    fontSize: typeof metricLabel === 'undefined' ? undefined : {
      field: metricLabel,
      scale: {
        range: [sizeFrom, sizeTo],
        zero: true
      },
      type: 'quantitative'
    },
    text: {
      field: series
    }
  };
  return {
    data: queriesData[0].data,
    encoding,
    height,
    rotation,
    width
  };
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/query/buildQueryContext.js
var buildQueryContext = __webpack_require__(69205);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-word-cloud/esm/plugin/buildQuery.js
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function buildQuery(formData) {
  // Set the single QueryObject's groupby field with series in formData
  const {
    metric,
    sort_by_metric
  } = formData;
  return (0,buildQueryContext/* default */.Z)(formData, baseQueryObject => [{ ...baseQueryObject,
    ...(sort_by_metric && {
      orderby: [[metric, false]]
    })
  }]);
}
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-word-cloud/esm/images/thumbnail.png
var thumbnail = __webpack_require__(4523);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-word-cloud/esm/images/Word_Cloud.jpg
var Word_Cloud = __webpack_require__(54803);
// EXTERNAL MODULE: ./node_modules/@superset-ui/plugin-chart-word-cloud/esm/images/Word_Cloud_2.jpg
var Word_Cloud_2 = __webpack_require__(69996);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/validator/validateNonEmpty.js
var validateNonEmpty = __webpack_require__(42621);
// EXTERNAL MODULE: ./node_modules/@superset-ui/chart-controls/esm/index.js + 10 modules
var esm = __webpack_require__(88483);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-word-cloud/esm/plugin/controlPanel.js
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const config = {
  controlPanelSections: [esm.sections.legacyRegularTime, {
    label: (0,TranslatorSingleton.t)('Query'),
    expanded: true,
    controlSetRows: [['series'], ['metric'], ['adhoc_filters'], ['row_limit'], [{
      name: 'sort_by_metric',
      config: {
        type: 'CheckboxControl',
        label: (0,TranslatorSingleton.t)('Sort by metric'),
        description: (0,TranslatorSingleton.t)('Whether to sort results by the selected metric in descending order.')
      }
    }]]
  }, {
    label: (0,TranslatorSingleton.t)('Options'),
    expanded: true,
    controlSetRows: [[{
      name: 'size_from',
      config: {
        type: 'TextControl',
        isInt: true,
        label: (0,TranslatorSingleton.t)('Minimum Font Size'),
        renderTrigger: true,
        default: 10,
        description: (0,TranslatorSingleton.t)('Font size for the smallest value in the list')
      }
    }, {
      name: 'size_to',
      config: {
        type: 'TextControl',
        isInt: true,
        label: (0,TranslatorSingleton.t)('Maximum Font Size'),
        renderTrigger: true,
        default: 70,
        description: (0,TranslatorSingleton.t)('Font size for the biggest value in the list')
      }
    }], [{
      name: 'rotation',
      config: {
        type: 'SelectControl',
        label: (0,TranslatorSingleton.t)('Word Rotation'),
        choices: [['random', 'random'], ['flat', 'flat'], ['square', 'square']],
        renderTrigger: true,
        default: 'square',
        clearable: false,
        description: (0,TranslatorSingleton.t)('Rotation to apply to words in the cloud')
      }
    }], ['color_scheme']]
  }],
  controlOverrides: {
    series: {
      validators: [validateNonEmpty/* default */.Z],
      clearable: false
    },
    row_limit: {
      default: 100
    }
  }
};
/* harmony default export */ const controlPanel = (config);
// EXTERNAL MODULE: ./node_modules/encodable/esm/index.js
var encodable_esm = __webpack_require__(44994);
// EXTERNAL MODULE: ./node_modules/encodable/esm/options/resolvers.js + 73 modules
var resolvers = __webpack_require__(43897);
// EXTERNAL MODULE: ./node_modules/encodable/esm/options/Encodable.js
var Encodable = __webpack_require__(13663);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/time-format/TimeFormats.js
var TimeFormats = __webpack_require__(76187);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/time-format/TimeFormatterRegistrySingleton.js + 5 modules
var TimeFormatterRegistrySingleton = __webpack_require__(14826);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/color/SequentialSchemeRegistrySingleton.js
var SequentialSchemeRegistrySingleton = __webpack_require__(67542);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/color/CategoricalSchemeRegistrySingleton.js
var CategoricalSchemeRegistrySingleton = __webpack_require__(34042);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/color/CategoricalColorNamespace.js
var CategoricalColorNamespace = __webpack_require__(83527);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/number-format/NumberFormatterRegistrySingleton.js
var NumberFormatterRegistrySingleton = __webpack_require__(50855);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-word-cloud/esm/configureEncodable.js
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const timeFormat = ({
  format,
  formatInLocalTime = false
} = {}) => {
  const formatString = formatInLocalTime ? (0,encodable_esm.addPrefix)(TimeFormats/* LOCAL_PREFIX */.D, format ?? (0,TimeFormatterRegistrySingleton/* default */.ZP)().getDefaultKey()) : format;
  return (0,TimeFormatterRegistrySingleton/* getTimeFormatter */.bt)(formatString);
};

const colorSchemeResolver = ({
  name,
  type = 'categorical'
} = {}) => {
  if (type === 'sequential') {
    const scheme = (0,SequentialSchemeRegistrySingleton/* default */.Z)().get(name);
    return typeof scheme === 'undefined' ? scheme : {
      type: 'sequential',
      ...scheme
    };
  }

  if (type === 'categorical') {
    const scheme = (0,CategoricalSchemeRegistrySingleton/* default */.Z)().get(name);
    return typeof scheme === 'undefined' ? scheme : {
      type: 'categorical',
      ...scheme
    };
  }

  return (0,resolvers/* defaultColorSchemeResolver */.kt)({
    name,
    type
  });
};

const colorScaleResolver = ({
  name,
  namespace
} = {}) => CategoricalColorNamespace.getScale(name, namespace);

function configureEncodable() {
  Encodable/* default.setNumberFormatResolver */.Z.setNumberFormatResolver(NumberFormatterRegistrySingleton/* getNumberFormatter */.JB).setTimeFormatResolver(timeFormat).setColorSchemeResolver(colorSchemeResolver).setCategoricalColorScaleResolver(colorScaleResolver);
}
;// CONCATENATED MODULE: ./node_modules/@superset-ui/plugin-chart-word-cloud/esm/plugin/index.js
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */








configureEncodable();
const metadata = new ChartMetadata/* default */.Z({
  category: (0,TranslatorSingleton.t)('Ranking'),
  credits: ['https://github.com/jasondavies/d3-cloud'],
  description: (0,TranslatorSingleton.t)('Visualizes the words in a column that appear the most often. Bigger font corresponds to higher frequency.'),
  exampleGallery: [{
    url: Word_Cloud
  }, {
    url: Word_Cloud_2
  }],
  name: (0,TranslatorSingleton.t)('Word Cloud'),
  tags: [(0,TranslatorSingleton.t)('Aesthetic'), (0,TranslatorSingleton.t)('Categorical'), (0,TranslatorSingleton.t)('Comparison'), (0,TranslatorSingleton.t)('Description'), (0,TranslatorSingleton.t)('Density'), (0,TranslatorSingleton.t)('Single Metric')],
  thumbnail: thumbnail
});
class WordCloudChartPlugin extends ChartPlugin/* default */.Z {
  constructor() {
    super({
      buildQuery: buildQuery,
      loadChart: () => Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(4319)]).then(__webpack_require__.bind(__webpack_require__, 24319)),
      metadata,
      transformProps: transformProps,
      controlPanel: controlPanel
    });
  }

}

/***/ }),

/***/ 67071:
/***/ (function(module) {

(function (global, factory) {
	 true ? module.exports = factory() :
	0;
}(this, (function () { 'use strict';

function arrayTreeFilter(data, filterFn, options) {
    options = options || {};
    options.childrenKeyName = options.childrenKeyName || "children";
    var children = data || [];
    var result = [];
    var level = 0;
    do {
        var foundItem = children.filter(function (item) {
            return filterFn(item, level);
        })[0];
        if (!foundItem) {
            break;
        }
        result.push(foundItem);
        children = foundItem[options.childrenKeyName] || [];
        level += 1;
    } while (children.length > 0);
    return result;
}

return arrayTreeFilter;

})));


/***/ }),

/***/ 6765:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ wrappers_wrapColorScheme)
});

// EXTERNAL MODULE: ./node_modules/@encodable/color/node_modules/d3-scale/src/ordinal.js
var ordinal = __webpack_require__(49914);
;// CONCATENATED MODULE: ./node_modules/@encodable/color/esm/scheme/wrappers/SchemeWrapper.js
function _defineProperty(obj, key, value) {if (key in obj) {Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });} else {obj[key] = value;}return obj;}

class SchemeWrapper {
  constructor(scheme) {
    _defineProperty(this, "scheme", void 0);

    this.scheme = scheme;
  }
  /** scheme type */


  get type() {
    return this.scheme.type;
  }
  /** id of this scheme */


  get id() {
    return this.scheme.id;
  }
  /** human-friendly name to refer to */


  get label() {
    return this.scheme.label;
  }
  /** more description (if any) */


  get description() {
    return this.scheme.description;
  }}
;// CONCATENATED MODULE: ./node_modules/@encodable/color/esm/scheme/wrappers/CategoricalSchemeWrapper.js


class CategoricalSchemeWrapper extends SchemeWrapper {
  get colors() {
    return this.scheme.colors;
  }

  getColors(numColors) {
    const {
      length } =
    this.scheme.colors;

    if (typeof numColors === 'undefined' || numColors === length) {
      return this.scheme.colors;
    }

    if (numColors < length) {
      return this.scheme.colors.slice(0, numColors);
    }

    const times = Math.ceil(numColors / length);
    let output = this.scheme.colors.slice();

    for (let i = 0; i < times; i += 1) {
      output = output.concat(this.scheme.colors);
    }

    return output.slice(0, numColors);
  }

  createScaleOrdinal() {
    return (0,ordinal/* default */.Z)(this.scheme.colors);
  }}
// EXTERNAL MODULE: ./node_modules/@encodable/color/node_modules/d3-interpolate/src/piecewise.js
var piecewise = __webpack_require__(73757);
// EXTERNAL MODULE: ./node_modules/@encodable/color/node_modules/d3-interpolate/src/rgb.js + 3 modules
var rgb = __webpack_require__(82741);
// EXTERNAL MODULE: ./node_modules/@encodable/color/node_modules/d3-interpolate/src/quantize.js
var quantize = __webpack_require__(90888);
// EXTERNAL MODULE: ./node_modules/@encodable/color/node_modules/d3-scale/src/linear.js + 2 modules
var linear = __webpack_require__(68884);
// EXTERNAL MODULE: ./node_modules/@encodable/color/node_modules/d3-scale/src/sequential.js
var sequential = __webpack_require__(71275);
;// CONCATENATED MODULE: ./node_modules/@encodable/color/esm/scheme/wrappers/ContinuousSchemeWrapper.js




function isArrayOfArray(x) {
  return Array.isArray(x[x.length - 1]);
}

class ContinuousSchemeWrapper extends SchemeWrapper {
  get colors() {
    if ('colors' in this.scheme && typeof this.scheme.colors !== 'undefined') {
      return this.scheme.colors;
    }

    return this.getColors();
  }

  get interpolator() {
    if ('interpolator' in this.scheme && typeof this.scheme.interpolator !== 'undefined') {
      return this.scheme.interpolator;
    }

    const colors = this.scheme.colors;
    return (0,piecewise/* default */.Z)(rgb/* default */.ZP, (isArrayOfArray(colors) ? colors[colors.length - 1] : colors).slice());
  }
  /**
   * Get colors from this scheme
   * @param numColors number of colors to return.
   * Will interpolate the current scheme to match the number of colors requested
   * @param extent The extent of the color range to use.
   * For example [0.2, 1] will rescale the color scheme
   * such that color values in the range [0, 0.2) are excluded from the scheme.
   */


  getColors(numColors = 2, extent = [0, 1]) {
    if ('colors' in this.scheme && typeof this.scheme.colors !== 'undefined' && extent[0] === 0 && extent[1] === 1) {
      const {
        colors } =
      this.scheme;

      if (isArrayOfArray(colors)) {
        if (typeof colors[numColors] !== 'undefined') {
          return colors[numColors].slice();
        }
      } else if (numColors === colors.length) {
        return colors.slice();
      }
    }

    const {
      interpolator } =
    this;
    const adjustExtent = (0,linear/* default */.Z)().range(extent).clamp(true);
    return (0,quantize/* default */.Z)((t) => interpolator(adjustExtent(t)), numColors);
  }

  createScaleLinear() {
    // The manual casting is necessary until @types/d3-scale is corrected
    // In recent version of d3-scale the output from scaleSequential is compatible with linear scale
    // (It has .range(),  ...)
    return (0,sequential/* default */.ZP)(this.interpolator);
  }}
;// CONCATENATED MODULE: ./node_modules/@encodable/color/esm/scheme/wrappers/SequentialSchemeWrapper.js

class SequentialSchemeWrapper extends ContinuousSchemeWrapper {}
// EXTERNAL MODULE: ./node_modules/@encodable/color/node_modules/d3-scale/src/diverging.js
var diverging = __webpack_require__(90252);
;// CONCATENATED MODULE: ./node_modules/@encodable/color/esm/scheme/wrappers/DivergingSchemeWrapper.js


class DivergingSchemeWrapper extends ContinuousSchemeWrapper {
  getColors(numColors = 3, extent = [0, 1]) {
    return super.getColors(numColors, extent);
  }

  createScaleLinear() {
    return (0,diverging/* default */.ZP)(this.interpolator);
  }}
;// CONCATENATED MODULE: ./node_modules/@encodable/color/esm/scheme/wrappers/wrapColorScheme.js




function wrapColorScheme(scheme) {
  switch (scheme.type) {
    case 'categorical':
      return scheme instanceof CategoricalSchemeWrapper ? scheme : new CategoricalSchemeWrapper(scheme);

    case 'sequential':
      return scheme instanceof SequentialSchemeWrapper ? scheme : new SequentialSchemeWrapper(scheme);

    case 'diverging':
      return scheme instanceof DivergingSchemeWrapper ? scheme : new DivergingSchemeWrapper(scheme);

    default:
      throw new Error(`Unknown scheme type: ${scheme.type}`);}

}

/* harmony default export */ const wrappers_wrapColorScheme = (wrapColorScheme);

/***/ }),

/***/ 89878:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "addPrefix": () => (/* reexport safe */ _utils_prefix__WEBPACK_IMPORTED_MODULE_1__.U9)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(66676);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_types__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (checked) */ if(__webpack_require__.o(_types__WEBPACK_IMPORTED_MODULE_0__, "addPrefix")) __webpack_require__.d(__webpack_exports__, { "addPrefix": function() { return _types__WEBPACK_IMPORTED_MODULE_0__.addPrefix; } });
/* harmony import */ var _utils_prefix__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(82878);


 // Types

 // Utils




/***/ }),

/***/ 66676:
/***/ (() => {



/***/ }),

/***/ 82878:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "U9": () => (/* binding */ addPrefix),
/* harmony export */   "Qm": () => (/* binding */ removePrefix),
/* harmony export */   "nA": () => (/* binding */ addSign)
/* harmony export */ });
function addPrefix(prefix, value) {
  return value.startsWith(prefix) ? value : prefix + value;
}
function removePrefix(prefix, value) {
  return value.startsWith(prefix) ? value.slice(prefix.length, value.length) : value;
}
function addSign(formatString) {
  return addPrefix('+', formatString);
}

/***/ }),

/***/ 32383:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_collection__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31654);
/* harmony import */ var d3_selection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44059);
/* harmony import */ var d3_selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(94017);
/**
 * d3.tip
 * Copyright (c) 2013-2017 Justin Palmer
 *
 * Tooltips for d3.js SVG visualizations
 */
// eslint-disable-next-line no-extra-semi


// Public - constructs a new tooltip
//
// Returns a tip
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var direction   = d3TipDirection,
      offset      = d3TipOffset,
      html        = d3TipHTML,
      rootElement = document.body,
      node        = initNode(),
      svg         = null,
      point       = null,
      target      = null

  function tip(vis) {
    svg = getSVGNode(vis)
    if (!svg) return
    point = svg.createSVGPoint()
    rootElement.appendChild(node)
  }

  // Public - show the tooltip on the screen
  //
  // Returns a tip
  tip.show = function() {
    var args = Array.prototype.slice.call(arguments)
    if (args[args.length - 1] instanceof SVGElement) target = args.pop()

    var content = html.apply(this, args),
        poffset = offset.apply(this, args),
        dir     = direction.apply(this, args),
        nodel   = getNodeEl(),
        i       = directions.length,
        coords,
        scrollTop  = document.documentElement.scrollTop ||
      rootElement.scrollTop,
        scrollLeft = document.documentElement.scrollLeft ||
      rootElement.scrollLeft

    nodel.html(content)
      .style('opacity', 1).style('pointer-events', 'all')

    while (i--) nodel.classed(directions[i], false)
    coords = directionCallbacks.get(dir).apply(this)
    nodel.classed(dir, true)
      .style('top', (coords.top + poffset[0]) + scrollTop + 'px')
      .style('left', (coords.left + poffset[1]) + scrollLeft + 'px')

    return tip
  }

  // Public - hide the tooltip
  //
  // Returns a tip
  tip.hide = function() {
    var nodel = getNodeEl()
    nodel.style('opacity', 0).style('pointer-events', 'none')
    return tip
  }

  // Public: Proxy attr calls to the d3 tip container.
  // Sets or gets attribute value.
  //
  // n - name of the attribute
  // v - value of the attribute
  //
  // Returns tip or attribute value
  // eslint-disable-next-line no-unused-vars
  tip.attr = function(n, v) {
    if (arguments.length < 2 && typeof n === 'string') {
      return getNodeEl().attr(n)
    }

    var args =  Array.prototype.slice.call(arguments)
    d3_selection__WEBPACK_IMPORTED_MODULE_1__/* ["default"].prototype.attr.apply */ .ZP.prototype.attr.apply(getNodeEl(), args)
    return tip
  }

  // Public: Proxy style calls to the d3 tip container.
  // Sets or gets a style value.
  //
  // n - name of the property
  // v - value of the property
  //
  // Returns tip or style property value
  // eslint-disable-next-line no-unused-vars
  tip.style = function(n, v) {
    if (arguments.length < 2 && typeof n === 'string') {
      return getNodeEl().style(n)
    }

    var args = Array.prototype.slice.call(arguments)
    d3_selection__WEBPACK_IMPORTED_MODULE_1__/* ["default"].prototype.style.apply */ .ZP.prototype.style.apply(getNodeEl(), args)
    return tip
  }

  // Public: Set or get the direction of the tooltip
  //
  // v - One of n(north), s(south), e(east), or w(west), nw(northwest),
  //     sw(southwest), ne(northeast) or se(southeast)
  //
  // Returns tip or direction
  tip.direction = function(v) {
    if (!arguments.length) return direction
    direction = v == null ? v : functor(v)

    return tip
  }

  // Public: Sets or gets the offset of the tip
  //
  // v - Array of [x, y] offset
  //
  // Returns offset or
  tip.offset = function(v) {
    if (!arguments.length) return offset
    offset = v == null ? v : functor(v)

    return tip
  }

  // Public: sets or gets the html value of the tooltip
  //
  // v - String value of the tip
  //
  // Returns html value or tip
  tip.html = function(v) {
    if (!arguments.length) return html
    html = v == null ? v : functor(v)

    return tip
  }

  // Public: sets or gets the root element anchor of the tooltip
  //
  // v - root element of the tooltip
  //
  // Returns root node of tip
  tip.rootElement = function(v) {
    if (!arguments.length) return rootElement
    rootElement = v == null ? v : functor(v)

    return tip
  }

  // Public: destroys the tooltip and removes it from the DOM
  //
  // Returns a tip
  tip.destroy = function() {
    if (node) {
      getNodeEl().remove()
      node = null
    }
    return tip
  }

  function d3TipDirection() { return 'n' }
  function d3TipOffset() { return [0, 0] }
  function d3TipHTML() { return ' ' }

  var directionCallbacks = (0,d3_collection__WEBPACK_IMPORTED_MODULE_0__/* .map */ .UI)({
        n:  directionNorth,
        s:  directionSouth,
        e:  directionEast,
        w:  directionWest,
        nw: directionNorthWest,
        ne: directionNorthEast,
        sw: directionSouthWest,
        se: directionSouthEast
      }),
      directions = directionCallbacks.keys()

  function directionNorth() {
    var bbox = getScreenBBox(this)
    return {
      top:  bbox.n.y - node.offsetHeight,
      left: bbox.n.x - node.offsetWidth / 2
    }
  }

  function directionSouth() {
    var bbox = getScreenBBox(this)
    return {
      top:  bbox.s.y,
      left: bbox.s.x - node.offsetWidth / 2
    }
  }

  function directionEast() {
    var bbox = getScreenBBox(this)
    return {
      top:  bbox.e.y - node.offsetHeight / 2,
      left: bbox.e.x
    }
  }

  function directionWest() {
    var bbox = getScreenBBox(this)
    return {
      top:  bbox.w.y - node.offsetHeight / 2,
      left: bbox.w.x - node.offsetWidth
    }
  }

  function directionNorthWest() {
    var bbox = getScreenBBox(this)
    return {
      top:  bbox.nw.y - node.offsetHeight,
      left: bbox.nw.x - node.offsetWidth
    }
  }

  function directionNorthEast() {
    var bbox = getScreenBBox(this)
    return {
      top:  bbox.ne.y - node.offsetHeight,
      left: bbox.ne.x
    }
  }

  function directionSouthWest() {
    var bbox = getScreenBBox(this)
    return {
      top:  bbox.sw.y,
      left: bbox.sw.x - node.offsetWidth
    }
  }

  function directionSouthEast() {
    var bbox = getScreenBBox(this)
    return {
      top:  bbox.se.y,
      left: bbox.se.x
    }
  }

  function initNode() {
    var div = (0,d3_selection__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(document.createElement('div'))
    div
      .style('position', 'absolute')
      .style('top', 0)
      .style('opacity', 0)
      .style('pointer-events', 'none')
      .style('box-sizing', 'border-box')

    return div.node()
  }

  function getSVGNode(element) {
    var svgNode = element.node()
    if (!svgNode) return null
    if (svgNode.tagName.toLowerCase() === 'svg') return svgNode
    return svgNode.ownerSVGElement
  }

  function getNodeEl() {
    if (node == null) {
      node = initNode()
      // re-add node to DOM
      rootElement.appendChild(node)
    }
    return (0,d3_selection__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(node)
  }

  // Private - gets the screen coordinates of a shape
  //
  // Given a shape on the screen, will return an SVGPoint for the directions
  // n(north), s(south), e(east), w(west), ne(northeast), se(southeast),
  // nw(northwest), sw(southwest).
  //
  //    +-+-+
  //    |   |
  //    +   +
  //    |   |
  //    +-+-+
  //
  // Returns an Object {n, s, e, w, nw, sw, ne, se}
  function getScreenBBox(targetShape) {
    var targetel   = target || targetShape

    while (targetel.getScreenCTM == null && targetel.parentNode != null) {
      targetel = targetel.parentNode
    }

    var bbox       = {},
        matrix     = targetel.getScreenCTM(),
        tbbox      = targetel.getBBox(),
        width      = tbbox.width,
        height     = tbbox.height,
        x          = tbbox.x,
        y          = tbbox.y

    point.x = x
    point.y = y
    bbox.nw = point.matrixTransform(matrix)
    point.x += width
    bbox.ne = point.matrixTransform(matrix)
    point.y += height
    bbox.se = point.matrixTransform(matrix)
    point.x -= width
    bbox.sw = point.matrixTransform(matrix)
    point.y -= height / 2
    bbox.w = point.matrixTransform(matrix)
    point.x += width
    bbox.e = point.matrixTransform(matrix)
    point.x -= width / 2
    point.y -= height / 2
    bbox.n = point.matrixTransform(matrix)
    point.y += height
    bbox.s = point.matrixTransform(matrix)

    return bbox
  }

  // Private - replace D3JS 3.X d3.functor() function
  function functor(v) {
    return typeof v === 'function' ? v : function() {
      return v
    }
  }

  return tip
}


/***/ }),

/***/ 27856:
/***/ (function(module) {

/*! @license DOMPurify 2.3.3 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/2.3.3/LICENSE */

(function (global, factory) {
   true ? module.exports = factory() :
  0;
}(this, function () { 'use strict';

  function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

  var hasOwnProperty = Object.hasOwnProperty,
      setPrototypeOf = Object.setPrototypeOf,
      isFrozen = Object.isFrozen,
      getPrototypeOf = Object.getPrototypeOf,
      getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
  var freeze = Object.freeze,
      seal = Object.seal,
      create = Object.create; // eslint-disable-line import/no-mutable-exports

  var _ref = typeof Reflect !== 'undefined' && Reflect,
      apply = _ref.apply,
      construct = _ref.construct;

  if (!apply) {
    apply = function apply(fun, thisValue, args) {
      return fun.apply(thisValue, args);
    };
  }

  if (!freeze) {
    freeze = function freeze(x) {
      return x;
    };
  }

  if (!seal) {
    seal = function seal(x) {
      return x;
    };
  }

  if (!construct) {
    construct = function construct(Func, args) {
      return new (Function.prototype.bind.apply(Func, [null].concat(_toConsumableArray(args))))();
    };
  }

  var arrayForEach = unapply(Array.prototype.forEach);
  var arrayPop = unapply(Array.prototype.pop);
  var arrayPush = unapply(Array.prototype.push);

  var stringToLowerCase = unapply(String.prototype.toLowerCase);
  var stringMatch = unapply(String.prototype.match);
  var stringReplace = unapply(String.prototype.replace);
  var stringIndexOf = unapply(String.prototype.indexOf);
  var stringTrim = unapply(String.prototype.trim);

  var regExpTest = unapply(RegExp.prototype.test);

  var typeErrorCreate = unconstruct(TypeError);

  function unapply(func) {
    return function (thisArg) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      return apply(func, thisArg, args);
    };
  }

  function unconstruct(func) {
    return function () {
      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return construct(func, args);
    };
  }

  /* Add properties to a lookup table */
  function addToSet(set, array) {
    if (setPrototypeOf) {
      // Make 'in' and truthy checks like Boolean(set.constructor)
      // independent of any properties defined on Object.prototype.
      // Prevent prototype setters from intercepting set as a this value.
      setPrototypeOf(set, null);
    }

    var l = array.length;
    while (l--) {
      var element = array[l];
      if (typeof element === 'string') {
        var lcElement = stringToLowerCase(element);
        if (lcElement !== element) {
          // Config presets (e.g. tags.js, attrs.js) are immutable.
          if (!isFrozen(array)) {
            array[l] = lcElement;
          }

          element = lcElement;
        }
      }

      set[element] = true;
    }

    return set;
  }

  /* Shallow clone an object */
  function clone(object) {
    var newObject = create(null);

    var property = void 0;
    for (property in object) {
      if (apply(hasOwnProperty, object, [property])) {
        newObject[property] = object[property];
      }
    }

    return newObject;
  }

  /* IE10 doesn't support __lookupGetter__ so lets'
   * simulate it. It also automatically checks
   * if the prop is function or getter and behaves
   * accordingly. */
  function lookupGetter(object, prop) {
    while (object !== null) {
      var desc = getOwnPropertyDescriptor(object, prop);
      if (desc) {
        if (desc.get) {
          return unapply(desc.get);
        }

        if (typeof desc.value === 'function') {
          return unapply(desc.value);
        }
      }

      object = getPrototypeOf(object);
    }

    function fallbackValue(element) {
      console.warn('fallback value for', element);
      return null;
    }

    return fallbackValue;
  }

  var html = freeze(['a', 'abbr', 'acronym', 'address', 'area', 'article', 'aside', 'audio', 'b', 'bdi', 'bdo', 'big', 'blink', 'blockquote', 'body', 'br', 'button', 'canvas', 'caption', 'center', 'cite', 'code', 'col', 'colgroup', 'content', 'data', 'datalist', 'dd', 'decorator', 'del', 'details', 'dfn', 'dialog', 'dir', 'div', 'dl', 'dt', 'element', 'em', 'fieldset', 'figcaption', 'figure', 'font', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'header', 'hgroup', 'hr', 'html', 'i', 'img', 'input', 'ins', 'kbd', 'label', 'legend', 'li', 'main', 'map', 'mark', 'marquee', 'menu', 'menuitem', 'meter', 'nav', 'nobr', 'ol', 'optgroup', 'option', 'output', 'p', 'picture', 'pre', 'progress', 'q', 'rp', 'rt', 'ruby', 's', 'samp', 'section', 'select', 'shadow', 'small', 'source', 'spacer', 'span', 'strike', 'strong', 'style', 'sub', 'summary', 'sup', 'table', 'tbody', 'td', 'template', 'textarea', 'tfoot', 'th', 'thead', 'time', 'tr', 'track', 'tt', 'u', 'ul', 'var', 'video', 'wbr']);

  // SVG
  var svg = freeze(['svg', 'a', 'altglyph', 'altglyphdef', 'altglyphitem', 'animatecolor', 'animatemotion', 'animatetransform', 'circle', 'clippath', 'defs', 'desc', 'ellipse', 'filter', 'font', 'g', 'glyph', 'glyphref', 'hkern', 'image', 'line', 'lineargradient', 'marker', 'mask', 'metadata', 'mpath', 'path', 'pattern', 'polygon', 'polyline', 'radialgradient', 'rect', 'stop', 'style', 'switch', 'symbol', 'text', 'textpath', 'title', 'tref', 'tspan', 'view', 'vkern']);

  var svgFilters = freeze(['feBlend', 'feColorMatrix', 'feComponentTransfer', 'feComposite', 'feConvolveMatrix', 'feDiffuseLighting', 'feDisplacementMap', 'feDistantLight', 'feFlood', 'feFuncA', 'feFuncB', 'feFuncG', 'feFuncR', 'feGaussianBlur', 'feMerge', 'feMergeNode', 'feMorphology', 'feOffset', 'fePointLight', 'feSpecularLighting', 'feSpotLight', 'feTile', 'feTurbulence']);

  // List of SVG elements that are disallowed by default.
  // We still need to know them so that we can do namespace
  // checks pro