(globalThis["webpackChunkunblock"] = globalThis["webpackChunkunblock"] || []).push([[1921],{

/***/ 63803:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "z": () => (/* binding */ register),
/* harmony export */   "Z": () => (/* binding */ debug)
/* harmony export */ });
/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(80744);


let loggers = {};

if (false) {}

function register(handlers) {
  loggers = handlers;
}
function debug(eventType) {
  if (_utils_log__WEBPACK_IMPORTED_MODULE_0__/* ["default"].level */ .Z.level > 0 && loggers[eventType]) {
    loggers[eventType].call(...arguments);
  }
}
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 83518:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ AttributeManager)
});

// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/features/features.js
var features = __webpack_require__(44211);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/features/webgl-features-table.js
var webgl_features_table = __webpack_require__(6948);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/buffer.js
var buffer = __webpack_require__(53478);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/attribute/shader-attribute.js
class ShaderAttribute {
  constructor(dataColumn, opts) {
    this.opts = opts;
    this.source = dataColumn;
  }

  get value() {
    return this.source.value;
  }

  getValue() {
    const buffer = this.source.getBuffer();
    const accessor = this.getAccessor();

    if (buffer) {
      return [buffer, accessor];
    }

    const {
      value
    } = this.source;
    const {
      size
    } = accessor;
    let constantValue = value;

    if (value && value.length !== size) {
      constantValue = new Float32Array(size);
      const index = accessor.elementOffset || 0;

      for (let i = 0; i < size; ++i) {
        constantValue[i] = value[index + i];
      }
    }

    return constantValue;
  }

  getAccessor() {
    return { ...this.source.getAccessor(),
      ...this.opts
    };
  }

}
//# sourceMappingURL=shader-attribute.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/attribute/gl-utils.js
function glArrayFromType(glType) {
  switch (glType) {
    case 5126:
      return Float32Array;

    case 5130:
      return Float64Array;

    case 5123:
    case 33635:
    case 32819:
    case 32820:
      return Uint16Array;

    case 5125:
      return Uint32Array;

    case 5121:
      return Uint8ClampedArray;

    case 5120:
      return Int8Array;

    case 5122:
      return Int16Array;

    case 5124:
      return Int32Array;

    default:
      throw new Error('Unknown GL type');
  }
}
//# sourceMappingURL=gl-utils.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/typed-array-manager.js
var typed_array_manager = __webpack_require__(36610);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/math-utils.js
var math_utils = __webpack_require__(75126);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/log.js
var log = __webpack_require__(80744);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/attribute/data-column.js







function getStride(accessor) {
  return accessor.stride || accessor.size * accessor.bytesPerElement;
}

function resolveShaderAttribute(baseAccessor, shaderAttributeOptions) {
  if (shaderAttributeOptions.offset) {
    log/* default.removed */.Z.removed('shaderAttribute.offset', 'vertexOffset, elementOffset')();
  }

  const stride = getStride(baseAccessor);
  const vertexOffset = 'vertexOffset' in shaderAttributeOptions ? shaderAttributeOptions.vertexOffset : baseAccessor.vertexOffset || 0;
  const elementOffset = shaderAttributeOptions.elementOffset || 0;
  const offset = vertexOffset * stride + elementOffset * baseAccessor.bytesPerElement + (baseAccessor.offset || 0);
  return { ...shaderAttributeOptions,
    offset,
    stride
  };
}

function resolveDoublePrecisionShaderAttributes(baseAccessor, shaderAttributeOptions) {
  const resolvedOptions = resolveShaderAttribute(baseAccessor, shaderAttributeOptions);
  return {
    high: resolvedOptions,
    low: { ...resolvedOptions,
      offset: resolvedOptions.offset + baseAccessor.size * 4
    }
  };
}

class DataColumn {
  constructor(gl, opts) {
    this.gl = gl;
    this.id = opts.id;
    this.size = opts.size;
    const logicalType = opts.logicalType || opts.type;
    const doublePrecision = logicalType === 5130;
    let {
      defaultValue
    } = opts;
    defaultValue = Number.isFinite(defaultValue) ? [defaultValue] : defaultValue || new Array(this.size).fill(0);
    opts.defaultValue = defaultValue;
    let bufferType = logicalType;

    if (doublePrecision) {
      bufferType = 5126;
    } else if (!bufferType && opts.isIndexed) {
      bufferType = gl && (0,features/* hasFeature */.U6)(gl, webgl_features_table/* FEATURES.ELEMENT_INDEX_UINT32 */.h.ELEMENT_INDEX_UINT32) ? 5125 : 5123;
    } else if (!bufferType) {
      bufferType = 5126;
    }

    opts.logicalType = logicalType;
    opts.type = bufferType;
    let defaultType = glArrayFromType(logicalType || bufferType || 5126);
    this.shaderAttributes = {};
    this.doublePrecision = doublePrecision;

    if (doublePrecision && opts.fp64 === false) {
      defaultType = Float32Array;
    }

    opts.bytesPerElement = defaultType.BYTES_PER_ELEMENT;
    this.defaultType = defaultType;
    this.value = null;
    this.settings = opts;
    this.state = {
      externalBuffer: null,
      bufferAccessor: opts,
      allocatedValue: null,
      constant: false
    };
    this._buffer = null;
    this.setData(opts);
  }

  get buffer() {
    if (!this._buffer) {
      const {
        isIndexed,
        type
      } = this.settings;
      this._buffer = new buffer/* default */.Z(this.gl, {
        id: this.id,
        target: isIndexed ? 34963 : 34962,
        accessor: {
          type
        }
      });
    }

    return this._buffer;
  }

  get byteOffset() {
    const accessor = this.getAccessor();

    if (accessor.vertexOffset) {
      return accessor.vertexOffset * getStride(accessor);
    }

    return 0;
  }

  delete() {
    if (this._buffer) {
      this._buffer.delete();

      this._buffer = null;
    }

    typed_array_manager/* default.release */.Z.release(this.state.allocatedValue);
  }

  getShaderAttributes(id, options) {
    if (this.doublePrecision) {
      const shaderAttributes = {};
      const isBuffer64Bit = this.value instanceof Float64Array;
      const doubleShaderAttributeDefs = resolveDoublePrecisionShaderAttributes(this.getAccessor(), options || {});
      shaderAttributes[id] = new ShaderAttribute(this, doubleShaderAttributeDefs.high);
      shaderAttributes["".concat(id, "64Low")] = isBuffer64Bit ? new ShaderAttribute(this, doubleShaderAttributeDefs.low) : new Float32Array(this.size);
      return shaderAttributes;
    }

    if (options) {
      const shaderAttributeDef = resolveShaderAttribute(this.getAccessor(), options);
      return {
        [id]: new ShaderAttribute(this, shaderAttributeDef)
      };
    }

    return {
      [id]: this
    };
  }

  getBuffer() {
    if (this.state.constant) {
      return null;
    }

    return this.state.externalBuffer || this._buffer;
  }

  getValue() {
    if (this.state.constant) {
      return this.value;
    }

    return [this.getBuffer(), this.getAccessor()];
  }

  getAccessor() {
    return this.state.bufferAccessor;
  }

  setData(opts) {
    const {
      state
    } = this;

    if (ArrayBuffer.isView(opts)) {
      opts = {
        value: opts
      };
    } else if (opts instanceof buffer/* default */.Z) {
      opts = {
        buffer: opts
      };
    }

    const accessor = { ...this.settings,
      ...opts
    };
    state.bufferAccessor = accessor;

    if (opts.constant) {
      let value = opts.value;
      value = this._normalizeValue(value, [], 0);

      if (this.settings.normalized) {
        value = this._normalizeConstant(value);
      }

      const hasChanged = !state.constant || !this._areValuesEqual(value, this.value);

      if (!hasChanged) {
        return false;
      }

      state.externalBuffer = null;
      state.constant = true;
      this.value = value;
    } else if (opts.buffer) {
      const buffer = opts.buffer;
      state.externalBuffer = buffer;
      state.constant = false;
      this.value = opts.value;
      const isBuffer64Bit = opts.value instanceof Float64Array;
      accessor.type = opts.type || buffer.accessor.type;
      accessor.bytesPerElement = buffer.accessor.BYTES_PER_ELEMENT * (isBuffer64Bit ? 2 : 1);
      accessor.stride = getStride(accessor);
    } else if (opts.value) {
      this._checkExternalBuffer(opts);

      let value = opts.value;
      state.externalBuffer = null;
      state.constant = false;
      this.value = value;
      accessor.bytesPerElement = value.BYTES_PER_ELEMENT;
      accessor.stride = getStride(accessor);
      const {
        buffer,
        byteOffset
      } = this;

      if (this.doublePrecision && value instanceof Float64Array) {
        value = (0,math_utils/* toDoublePrecisionArray */.TK)(value, accessor);
      }

      const requiredBufferSize = value.byteLength + byteOffset + accessor.stride * 2;

      if (buffer.byteLength < requiredBufferSize) {
        buffer.reallocate(requiredBufferSize);
      }

      buffer.setAccessor(null);
      buffer.subData({
        data: value,
        offset: byteOffset
      });
      accessor.type = opts.type || buffer.accessor.type;
    }

    return true;
  }

  updateSubBuffer(opts = {}) {
    const {
      value
    } = this;
    const {
      startOffset = 0,
      endOffset
    } = opts;
    this.buffer.subData({
      data: this.doublePrecision && value instanceof Float64Array ? (0,math_utils/* toDoublePrecisionArray */.TK)(value, {
        size: this.size,
        startIndex: startOffset,
        endIndex: endOffset
      }) : value.subarray(startOffset, endOffset),
      offset: startOffset * value.BYTES_PER_ELEMENT + this.byteOffset
    });
  }

  allocate({
    numInstances,
    copy = false
  }) {
    const {
      state
    } = this;
    const oldValue = state.allocatedValue;
    const value = typed_array_manager/* default.allocate */.Z.allocate(oldValue, numInstances + 1, {
      size: this.size,
      type: this.defaultType,
      copy
    });
    this.value = value;
    const {
      buffer,
      byteOffset
    } = this;

    if (buffer.byteLength < value.byteLength + byteOffset) {
      buffer.reallocate(value.byteLength + byteOffset);

      if (copy && oldValue) {
        buffer.subData({
          data: oldValue instanceof Float64Array ? (0,math_utils/* toDoublePrecisionArray */.TK)(oldValue, this) : oldValue,
          offset: byteOffset
        });
      }
    }

    state.allocatedValue = value;
    state.constant = false;
    state.externalBuffer = null;
    state.bufferAccessor = this.settings;
    return true;
  }

  _checkExternalBuffer(opts) {
    const {
      value
    } = opts;

    if (!opts.constant && value) {
      const ArrayType = this.defaultType;
      let illegalArrayType = false;

      if (this.doublePrecision) {
        illegalArrayType = value.BYTES_PER_ELEMENT < 4;
      }

      if (illegalArrayType) {
        throw new Error("Attribute ".concat(this.id, " does not support ").concat(value.constructor.name));
      }

      if (!(value instanceof ArrayType) && this.settings.normalized && !('normalized' in opts)) {
        log/* default.warn */.Z.warn("Attribute ".concat(this.id, " is normalized"))();
      }
    }
  }

  _normalizeConstant(value) {
    switch (this.settings.type) {
      case 5120:
        return new Float32Array(value).map(x => (x + 128) / 255 * 2 - 1);

      case 5122:
        return new Float32Array(value).map(x => (x + 32768) / 65535 * 2 - 1);

      case 5121:
        return new Float32Array(value).map(x => x / 255);

      case 5123:
        return new Float32Array(value).map(x => x / 65535);

      default:
        return value;
    }
  }

  _normalizeValue(value, out, start) {
    const {
      defaultValue,
      size
    } = this.settings;

    if (Number.isFinite(value)) {
      out[start] = value;
      return out;
    }

    if (!value) {
      out[start] = defaultValue[0];
      return out;
    }

    switch (size) {
      case 4:
        out[start + 3] = Number.isFinite(value[3]) ? value[3] : defaultValue[3];

      case 3:
        out[start + 2] = Number.isFinite(value[2]) ? value[2] : defaultValue[2];

      case 2:
        out[start + 1] = Number.isFinite(value[1]) ? value[1] : defaultValue[1];

      case 1:
        out[start + 0] = Number.isFinite(value[0]) ? value[0] : defaultValue[0];
        break;

      default:
        let i = size;

        while (--i >= 0) {
          out[start + i] = Number.isFinite(value[i]) ? value[i] : defaultValue[i];
        }

    }

    return out;
  }

  _areValuesEqual(value1, value2) {
    if (!value1 || !value2) {
      return false;
    }

    const {
      size
    } = this;

    for (let i = 0; i < size; i++) {
      if (value1[i] !== value2[i]) {
        return false;
      }
    }

    return true;
  }

}
//# sourceMappingURL=data-column.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/assert.js
var assert = __webpack_require__(75304);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/iterable-utils.js
var iterable_utils = __webpack_require__(38550);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/flatten.js
var flatten = __webpack_require__(61855);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/range.js
const EMPTY = [];
const FULL = [[0, Infinity]];
function add(rangeList, range) {
  if (rangeList === FULL) {
    return rangeList;
  }

  if (range[0] < 0) {
    range[0] = 0;
  }

  if (range[0] >= range[1]) {
    return rangeList;
  }

  const newRangeList = [];
  const len = rangeList.length;
  let insertPosition = 0;

  for (let i = 0; i < len; i++) {
    const range0 = rangeList[i];

    if (range0[1] < range[0]) {
      newRangeList.push(range0);
      insertPosition = i + 1;
    } else if (range0[0] > range[1]) {
      newRangeList.push(range0);
    } else {
      range = [Math.min(range0[0], range[0]), Math.max(range0[1], range[1])];
    }
  }

  newRangeList.splice(insertPosition, 0, range);
  return newRangeList;
}
//# sourceMappingURL=range.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-utils.js + 1 modules
var attribute_transition_utils = __webpack_require__(69006);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute.js






class Attribute extends DataColumn {
  constructor(gl, opts = {}) {
    super(gl, opts);
    const {
      transition = false,
      noAlloc = false,
      update = null,
      accessor = null,
      transform = null,
      startIndices = null
    } = opts;
    Object.assign(this.settings, {
      transition,
      noAlloc,
      update: update || accessor && this._autoUpdater,
      accessor,
      transform
    });
    Object.assign(this.state, {
      lastExternalBuffer: null,
      binaryValue: null,
      binaryAccessor: null,
      needsUpdate: true,
      needsRedraw: false,
      updateRanges: FULL,
      startIndices
    });
    Object.seal(this.settings);
    Object.seal(this.state);

    this._validateAttributeUpdaters();
  }

  get startIndices() {
    return this.state.startIndices;
  }

  set startIndices(layout) {
    this.state.startIndices = layout;
  }

  needsUpdate() {
    return this.state.needsUpdate;
  }

  needsRedraw({
    clearChangedFlags = false
  } = {}) {
    const needsRedraw = this.state.needsRedraw;
    this.state.needsRedraw = needsRedraw && !clearChangedFlags;
    return needsRedraw;
  }

  getUpdateTriggers() {
    const {
      accessor
    } = this.settings;
    return [this.id].concat(typeof accessor !== 'function' && accessor || []);
  }

  supportsTransition() {
    return Boolean(this.settings.transition);
  }

  getTransitionSetting(opts) {
    if (!opts || !this.supportsTransition()) {
      return null;
    }

    const {
      accessor
    } = this.settings;
    const layerSettings = this.settings.transition;
    const userSettings = Array.isArray(accessor) ? opts[accessor.find(a => opts[a])] : opts[accessor];
    return (0,attribute_transition_utils/* normalizeTransitionSettings */.M0)(userSettings, layerSettings);
  }

  setNeedsUpdate(reason = this.id, dataRange) {
    this.state.needsUpdate = this.state.needsUpdate || reason;
    this.setNeedsRedraw(reason);

    if (dataRange) {
      const {
        startRow = 0,
        endRow = Infinity
      } = dataRange;
      this.state.updateRanges = add(this.state.updateRanges, [startRow, endRow]);
    } else {
      this.state.updateRanges = FULL;
    }
  }

  clearNeedsUpdate() {
    this.state.needsUpdate = false;
    this.state.updateRanges = EMPTY;
  }

  setNeedsRedraw(reason = this.id) {
    this.state.needsRedraw = this.state.needsRedraw || reason;
  }

  update(opts) {
    this.setData(opts);
  }

  allocate(numInstances) {
    const {
      state,
      settings
    } = this;

    if (settings.noAlloc) {
      return false;
    }

    if (settings.update) {
      super.allocate({
        numInstances,
        copy: state.updateRanges !== FULL
      });
      return true;
    }

    return false;
  }

  updateBuffer({
    numInstances,
    data,
    props,
    context
  }) {
    if (!this.needsUpdate()) {
      return false;
    }

    const {
      state: {
        updateRanges
      },
      settings: {
        update,
        noAlloc
      }
    } = this;
    let updated = true;

    if (update) {
      for (const [startRow, endRow] of updateRanges) {
        update.call(context, this, {
          data,
          startRow,
          endRow,
          props,
          numInstances
        });
      }

      if (!this.value) {} else if (this.constant || this.buffer.byteLength < this.value.byteLength + this.byteOffset) {
        this.setData({
          value: this.value,
          constant: this.constant
        });
      } else {
        for (const [startRow, endRow] of updateRanges) {
          const startOffset = Number.isFinite(startRow) ? this.getVertexOffset(startRow) : 0;
          const endOffset = Number.isFinite(endRow) ? this.getVertexOffset(endRow) : noAlloc || !Number.isFinite(numInstances) ? this.value.length : numInstances * this.size;
          super.updateSubBuffer({
            startOffset,
            endOffset
          });
        }
      }

      this._checkAttributeArray();
    } else {
      updated = false;
    }

    this.clearNeedsUpdate();
    this.setNeedsRedraw();
    return updated;
  }

  setConstantValue(value) {
    if (value === undefined || typeof value === 'function') {
      return false;
    }

    const hasChanged = this.setData({
      constant: true,
      value
    });

    if (hasChanged) {
      this.setNeedsRedraw();
    }

    this.clearNeedsUpdate();
    return true;
  }

  setExternalBuffer(buffer) {
    const {
      state
    } = this;

    if (!buffer) {
      state.lastExternalBuffer = null;
      return false;
    }

    this.clearNeedsUpdate();

    if (state.lastExternalBuffer === buffer) {
      return true;
    }

    state.lastExternalBuffer = buffer;
    this.setNeedsRedraw();
    this.setData(buffer);
    return true;
  }

  setBinaryValue(buffer, startIndices = null) {
    const {
      state,
      settings
    } = this;

    if (!buffer) {
      state.binaryValue = null;
      state.binaryAccessor = null;
      return false;
    }

    if (settings.noAlloc) {
      return false;
    }

    if (state.binaryValue === buffer) {
      this.clearNeedsUpdate();
      return true;
    }

    state.binaryValue = buffer;
    this.setNeedsRedraw();

    if (ArrayBuffer.isView(buffer)) {
      buffer = {
        value: buffer
      };
    }

    const needsUpdate = settings.transform || startIndices !== this.startIndices;

    if (needsUpdate) {
      (0,assert/* default */.Z)(ArrayBuffer.isView(buffer.value), "invalid ".concat(settings.accessor));
      const needsNormalize = buffer.size && buffer.size !== this.size;
      state.binaryAccessor = (0,iterable_utils/* getAccessorFromBuffer */.jr)(buffer.value, {
        size: buffer.size || this.size,
        stride: buffer.stride,
        offset: buffer.offset,
        startIndices,
        nested: needsNormalize
      });
      return false;
    }

    this.clearNeedsUpdate();
    this.setData(buffer);
    return true;
  }

  getVertexOffset(row) {
    const {
      startIndices
    } = this;
    const vertexIndex = startIndices ? startIndices[row] : row;
    return vertexIndex * this.size;
  }

  getShaderAttributes() {
    const shaderAttributeDefs = this.settings.shaderAttributes || {
      [this.id]: null
    };
    const shaderAttributes = {};

    for (const shaderAttributeName in shaderAttributeDefs) {
      Object.assign(shaderAttributes, super.getShaderAttributes(shaderAttributeName, shaderAttributeDefs[shaderAttributeName]));
    }

    return shaderAttributes;
  }

  _autoUpdater(attribute, {
    data,
    startRow,
    endRow,
    props,
    numInstances
  }) {
    if (attribute.constant) {
      return;
    }

    const {
      settings,
      state,
      value,
      size,
      startIndices
    } = attribute;
    const {
      accessor,
      transform
    } = settings;
    const accessorFunc = state.binaryAccessor || (typeof accessor === 'function' ? accessor : props[accessor]);
    (0,assert/* default */.Z)(typeof accessorFunc === 'function', "accessor \"".concat(accessor, "\" is not a function"));
    let i = attribute.getVertexOffset(startRow);
    const {
      iterable,
      objectInfo
    } = (0,iterable_utils/* createIterable */.jB)(data, startRow, endRow);

    for (const object of iterable) {
      objectInfo.index++;
      let objectValue = accessorFunc(object, objectInfo);

      if (transform) {
        objectValue = transform.call(this, objectValue);
      }

      if (startIndices) {
        const numVertices = (objectInfo.index < startIndices.length - 1 ? startIndices[objectInfo.index + 1] : numInstances) - startIndices[objectInfo.index];

        if (objectValue && Array.isArray(objectValue[0])) {
          let startIndex = i;

          for (const item of objectValue) {
            attribute._normalizeValue(item, value, startIndex);

            startIndex += size;
          }
        } else if (objectValue && objectValue.length > size) {
          value.set(objectValue, i);
        } else {
          attribute._normalizeValue(objectValue, objectInfo.target, 0);

          (0,flatten/* fillArray */.k)({
            target: value,
            source: objectInfo.target,
            start: i,
            count: numVertices
          });
        }

        i += numVertices * size;
      } else {
        attribute._normalizeValue(objectValue, value, i);

        i += size;
      }
    }
  }

  _validateAttributeUpdaters() {
    const {
      settings
    } = this;
    const hasUpdater = settings.noAlloc || typeof settings.update === 'function';

    if (!hasUpdater) {
      throw new Error("Attribute ".concat(this.id, " missing update or accessor"));
    }
  }

  _checkAttributeArray() {
    const {
      value
    } = this;
    const limit = Math.min(4, this.size);

    if (value && value.length >= limit) {
      let valid = true;

      switch (limit) {
        case 4:
          valid = valid && Number.isFinite(value[3]);

        case 3:
          valid = valid && Number.isFinite(value[2]);

        case 2:
          valid = valid && Number.isFinite(value[1]);

        case 1:
          valid = valid && Number.isFinite(value[0]);
          break;

        default:
          valid = false;
      }

      if (!valid) {
        throw new Error("Illegal attribute generated for ".concat(this.id));
      }
    }
  }

}
//# sourceMappingURL=attribute.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/debug/index.js
var debug = __webpack_require__(63803);
// EXTERNAL MODULE: ./node_modules/@luma.gl/engine/dist/esm/transform/transform.js + 6 modules
var transform = __webpack_require__(63346);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/transitions/transition.js
var transition = __webpack_require__(26395);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/transitions/gpu-interpolation-transition.js




class GPUInterpolationTransition {
  constructor({
    gl,
    attribute,
    timeline
  }) {
    this.gl = gl;
    this.type = 'interpolation';
    this.transition = new transition/* default */.Z(timeline);
    this.attribute = attribute;
    this.attributeInTransition = new Attribute(gl, attribute.settings);
    this.currentStartIndices = attribute.startIndices;
    this.currentLength = 0;
    this.transform = getTransform(gl, attribute);
    const bufferOpts = {
      byteLength: 0,
      usage: 35050
    };
    this.buffers = [new buffer/* default */.Z(gl, bufferOpts), new buffer/* default */.Z(gl, bufferOpts)];
  }

  get inProgress() {
    return this.transition.inProgress;
  }

  start(transitionSettings, numInstances) {
    if (transitionSettings.duration <= 0) {
      this.transition.cancel();
      return;
    }

    const {
      gl,
      buffers,
      attribute
    } = this;
    (0,attribute_transition_utils/* cycleBuffers */.DY)(buffers);
    const padBufferOpts = {
      numInstances,
      attribute,
      fromLength: this.currentLength,
      fromStartIndices: this.currentStartIndices,
      getData: transitionSettings.enter
    };

    for (const buffer of buffers) {
      (0,attribute_transition_utils/* padBuffer */.IV)({
        buffer,
        ...padBufferOpts
      });
    }

    this.currentStartIndices = attribute.startIndices;
    this.currentLength = (0,attribute_transition_utils/* getAttributeBufferLength */.pi)(attribute, numInstances);
    this.attributeInTransition.update({
      buffer: buffers[1],
      value: attribute.value
    });
    this.transition.start(transitionSettings);
    this.transform.update({
      elementCount: Math.floor(this.currentLength / attribute.size),
      sourceBuffers: {
        aFrom: buffers[0],
        aTo: (0,attribute_transition_utils/* getSourceBufferAttribute */.AQ)(gl, attribute)
      },
      feedbackBuffers: {
        vCurrent: buffers[1]
      }
    });
  }

  update() {
    const updated = this.transition.update();

    if (updated) {
      const {
        time,
        settings: {
          duration,
          easing
        }
      } = this.transition;
      const t = easing(time / duration);
      this.transform.run({
        uniforms: {
          time: t
        }
      });
    }

    return updated;
  }

  cancel() {
    this.transition.cancel();
    this.transform.delete();

    while (this.buffers.length) {
      this.buffers.pop().delete();
    }
  }

}
const vs = "\n#define SHADER_NAME interpolation-transition-vertex-shader\n\nuniform float time;\nattribute ATTRIBUTE_TYPE aFrom;\nattribute ATTRIBUTE_TYPE aTo;\nvarying ATTRIBUTE_TYPE vCurrent;\n\nvoid main(void) {\n  vCurrent = mix(aFrom, aTo, time);\n  gl_Position = vec4(0.0);\n}\n";

function getTransform(gl, attribute) {
  const attributeType = (0,attribute_transition_utils/* getAttributeTypeFromSize */.w)(attribute.size);
  return new transform/* default */.Z(gl, {
    vs,
    defines: {
      ATTRIBUTE_TYPE: attributeType
    },
    varyings: ['vCurrent']
  });
}
//# sourceMappingURL=gpu-interpolation-transition.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/copy-and-blit.js + 1 modules
var copy_and_blit = __webpack_require__(1953);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture-2d.js + 1 modules
var texture_2d = __webpack_require__(4912);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/framebuffer.js
var framebuffer = __webpack_require__(53849);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/transitions/gpu-spring-transition.js




class GPUSpringTransition {
  constructor({
    gl,
    attribute,
    timeline
  }) {
    this.gl = gl;
    this.type = 'spring';
    this.transition = new transition/* default */.Z(timeline);
    this.attribute = attribute;
    this.attributeInTransition = new Attribute(gl, { ...attribute.settings,
      normalized: false
    });
    this.currentStartIndices = attribute.startIndices;
    this.currentLength = 0;
    this.texture = getTexture(gl);
    this.framebuffer = getFramebuffer(gl, this.texture);
    this.transform = gpu_spring_transition_getTransform(gl, attribute, this.framebuffer);
    const bufferOpts = {
      byteLength: 0,
      usage: 35050
    };
    this.buffers = [new buffer/* default */.Z(gl, bufferOpts), new buffer/* default */.Z(gl, bufferOpts), new buffer/* default */.Z(gl, bufferOpts)];
  }

  get inProgress() {
    return this.transition.inProgress;
  }

  start(transitionSettings, numInstances) {
    const {
      gl,
      buffers,
      attribute
    } = this;
    const padBufferOpts = {
      numInstances,
      attribute,
      fromLength: this.currentLength,
      fromStartIndices: this.currentStartIndices,
      getData: transitionSettings.enter
    };

    for (const buffer of buffers) {
      (0,attribute_transition_utils/* padBuffer */.IV)({
        buffer,
        ...padBufferOpts
      });
    }

    this.currentStartIndices = attribute.startIndices;
    this.currentLength = (0,attribute_transition_utils/* getAttributeBufferLength */.pi)(attribute, numInstances);
    this.attributeInTransition.update({
      buffer: buffers[1],
      value: attribute.value
    });
    this.transition.start(transitionSettings);
    this.transform.update({
      elementCount: Math.floor(this.currentLength / attribute.size),
      sourceBuffers: {
        aTo: (0,attribute_transition_utils/* getSourceBufferAttribute */.AQ)(gl, attribute)
      }
    });
  }

  update() {
    const {
      buffers,
      transform,
      framebuffer,
      transition
    } = this;
    const updated = transition.update();

    if (!updated) {
      return false;
    }

    transform.update({
      sourceBuffers: {
        aPrev: buffers[0],
        aCur: buffers[1]
      },
      feedbackBuffers: {
        vNext: buffers[2]
      }
    });
    transform.run({
      framebuffer,
      discard: false,
      clearRenderTarget: true,
      uniforms: {
        stiffness: transition.settings.stiffness,
        damping: transition.settings.damping
      },
      parameters: {
        depthTest: false,
        blend: true,
        viewport: [0, 0, 1, 1],
        blendFunc: [1, 1],
        blendEquation: [32776, 32776]
      }
    });
    (0,attribute_transition_utils/* cycleBuffers */.DY)(buffers);
    this.attributeInTransition.update({
      buffer: buffers[1],
      value: this.attribute.value
    });
    const isTransitioning = (0,copy_and_blit/* readPixelsToArray */.z6)(framebuffer)[0] > 0;

    if (!isTransitioning) {
      transition.end();
    }

    return true;
  }

  cancel() {
    this.transition.cancel();
    this.transform.delete();

    while (this.buffers.length) {
      this.buffers.pop().delete();
    }

    this.texture.delete();
    this.texture = null;
    this.framebuffer.delete();
    this.framebuffer = null;
  }

}

function gpu_spring_transition_getTransform(gl, attribute, framebuffer) {
  const attributeType = (0,attribute_transition_utils/* getAttributeTypeFromSize */.w)(attribute.size);
  return new transform/* default */.Z(gl, {
    framebuffer,
    vs: "\n#define SHADER_NAME spring-transition-vertex-shader\n\n#define EPSILON 0.00001\n\nuniform float stiffness;\nuniform float damping;\nattribute ATTRIBUTE_TYPE aPrev;\nattribute ATTRIBUTE_TYPE aCur;\nattribute ATTRIBUTE_TYPE aTo;\nvarying ATTRIBUTE_TYPE vNext;\nvarying float vIsTransitioningFlag;\n\nATTRIBUTE_TYPE getNextValue(ATTRIBUTE_TYPE cur, ATTRIBUTE_TYPE prev, ATTRIBUTE_TYPE dest) {\n  ATTRIBUTE_TYPE velocity = cur - prev;\n  ATTRIBUTE_TYPE delta = dest - cur;\n  ATTRIBUTE_TYPE spring = delta * stiffness;\n  ATTRIBUTE_TYPE damper = velocity * -1.0 * damping;\n  return spring + damper + velocity + cur;\n}\n\nvoid main(void) {\n  bool isTransitioning = length(aCur - aPrev) > EPSILON || length(aTo - aCur) > EPSILON;\n  vIsTransitioningFlag = isTransitioning ? 1.0 : 0.0;\n\n  vNext = getNextValue(aCur, aPrev, aTo);\n  gl_Position = vec4(0, 0, 0, 1);\n  gl_PointSize = 100.0;\n}\n",
    fs: "\n#define SHADER_NAME spring-transition-is-transitioning-fragment-shader\n\nvarying float vIsTransitioningFlag;\n\nvoid main(void) {\n  if (vIsTransitioningFlag == 0.0) {\n    discard;\n  }\n  gl_FragColor = vec4(1.0);\n}",
    defines: {
      ATTRIBUTE_TYPE: attributeType
    },
    varyings: ['vNext']
  });
}

function getTexture(gl) {
  return new texture_2d/* default */.Z(gl, {
    data: new Uint8Array(4),
    format: 6408,
    type: 5121,
    border: 0,
    mipmaps: false,
    dataFormat: 6408,
    width: 1,
    height: 1
  });
}

function getFramebuffer(gl, texture) {
  return new framebuffer/* default */.Z(gl, {
    id: 'spring-transition-is-transitioning-framebuffer',
    width: 1,
    height: 1,
    attachments: {
      [36064]: texture
    }
  });
}
//# sourceMappingURL=gpu-spring-transition.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-manager.js




const TRANSITION_TYPES = {
  interpolation: GPUInterpolationTransition,
  spring: GPUSpringTransition
};
class AttributeTransitionManager {
  constructor(gl, {
    id,
    timeline
  }) {
    this.id = id;
    this.gl = gl;
    this.timeline = timeline;
    this.transitions = {};
    this.needsRedraw = false;
    this.numInstances = 1;
    this.isSupported = transform/* default.isSupported */.Z.isSupported(gl);
  }

  finalize() {
    for (const attributeName in this.transitions) {
      this._removeTransition(attributeName);
    }
  }

  update({
    attributes,
    transitions,
    numInstances
  }) {
    this.numInstances = numInstances || 1;

    for (const attributeName in attributes) {
      const attribute = attributes[attributeName];
      const settings = attribute.getTransitionSetting(transitions);
      if (!settings) continue;

      this._updateAttribute(attributeName, attribute, settings);
    }

    for (const attributeName in this.transitions) {
      const attribute = attributes[attributeName];

      if (!attribute || !attribute.getTransitionSetting(transitions)) {
        this._removeTransition(attributeName);
      }
    }
  }

  hasAttribute(attributeName) {
    const transition = this.transitions[attributeName];
    return transition && transition.inProgress;
  }

  getAttributes() {
    const animatedAttributes = {};

    for (const attributeName in this.transitions) {
      const transition = this.transitions[attributeName];

      if (transition.inProgress) {
        animatedAttributes[attributeName] = transition.attributeInTransition;
      }
    }

    return animatedAttributes;
  }

  run() {
    if (!this.isSupported || this.numInstances === 0) {
      return false;
    }

    for (const attributeName in this.transitions) {
      const updated = this.transitions[attributeName].update();

      if (updated) {
        this.needsRedraw = true;
      }
    }

    const needsRedraw = this.needsRedraw;
    this.needsRedraw = false;
    return needsRedraw;
  }

  _removeTransition(attributeName) {
    this.transitions[attributeName].cancel();
    delete this.transitions[attributeName];
  }

  _updateAttribute(attributeName, attribute, settings) {
    const transition = this.transitions[attributeName];
    let isNew = !transition || transition.type !== settings.type;

    if (isNew) {
      if (!this.isSupported) {
        log/* default.warn */.Z.warn("WebGL2 not supported by this browser. Transition for ".concat(attributeName, " is disabled."))();
        return;
      }

      if (transition) {
        this._removeTransition(attributeName);
      }

      const TransitionType = TRANSITION_TYPES[settings.type];

      if (TransitionType) {
        this.transitions[attributeName] = new TransitionType({
          attribute,
          timeline: this.timeline,
          gl: this.gl
        });
      } else {
        log/* default.error */.Z.error("unsupported transition type '".concat(settings.type, "'"))();
        isNew = false;
      }
    }

    if (isNew || attribute.needsRedraw()) {
      this.needsRedraw = true;
      this.transitions[attributeName].start(settings, this.numInstances);
    }
  }

}
//# sourceMappingURL=attribute-transition-manager.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-manager.js




const TRACE_INVALIDATE = 'attributeManager.invalidate';
const TRACE_UPDATE_START = 'attributeManager.updateStart';
const TRACE_UPDATE_END = 'attributeManager.updateEnd';
const TRACE_ATTRIBUTE_UPDATE_START = 'attribute.updateStart';
const TRACE_ATTRIBUTE_ALLOCATE = 'attribute.allocate';
const TRACE_ATTRIBUTE_UPDATE_END = 'attribute.updateEnd';
class AttributeManager {
  constructor(gl, {
    id = 'attribute-manager',
    stats,
    timeline
  } = {}) {
    this.id = id;
    this.gl = gl;
    this.attributes = {};
    this.updateTriggers = {};
    this.accessors = {};
    this.needsRedraw = true;
    this.userData = {};
    this.stats = stats;
    this.attributeTransitionManager = new AttributeTransitionManager(gl, {
      id: "".concat(id, "-transitions"),
      timeline
    });
    Object.seal(this);
  }

  finalize() {
    for (const attributeName in this.attributes) {
      this.attributes[attributeName].delete();
    }

    this.attributeTransitionManager.finalize();
  }

  getNeedsRedraw(opts = {
    clearRedrawFlags: false
  }) {
    const redraw = this.needsRedraw;
    this.needsRedraw = this.needsRedraw && !opts.clearRedrawFlags;
    return redraw && this.id;
  }

  setNeedsRedraw(redraw = true) {
    this.needsRedraw = true;
    return this;
  }

  add(attributes, updaters) {
    this._add(attributes, updaters);
  }

  addInstanced(attributes, updaters) {
    this._add(attributes, updaters, {
      instanced: 1
    });
  }

  remove(attributeNameArray) {
    for (let i = 0; i < attributeNameArray.length; i++) {
      const name = attributeNameArray[i];

      if (this.attributes[name] !== undefined) {
        this.attributes[name].delete();
        delete this.attributes[name];
      }
    }
  }

  invalidate(triggerName, dataRange) {
    const invalidatedAttributes = this._invalidateTrigger(triggerName, dataRange);

    (0,debug/* default */.Z)(TRACE_INVALIDATE, this, triggerName, invalidatedAttributes);
  }

  invalidateAll(dataRange) {
    for (const attributeName in this.attributes) {
      this.attributes[attributeName].setNeedsUpdate(attributeName, dataRange);
    }

    (0,debug/* default */.Z)(TRACE_INVALIDATE, this, 'all');
  }

  update({
    data,
    numInstances,
    startIndices = null,
    transitions,
    props = {},
    buffers = {},
    context = {}
  } = {}) {
    let updated = false;
    (0,debug/* default */.Z)(TRACE_UPDATE_START, this);

    if (this.stats) {
      this.stats.get('Update Attributes').timeStart();
    }

    for (const attributeName in this.attributes) {
      const attribute = this.attributes[attributeName];
      const accessorName = attribute.settings.accessor;
      attribute.startIndices = startIndices;

      if (props[attributeName]) {
        log/* default.removed */.Z.removed("props.".concat(attributeName), "data.attributes.".concat(attributeName))();
      }

      if (attribute.setExternalBuffer(buffers[attributeName])) {} else if (attribute.setBinaryValue(buffers[accessorName], data.startIndices)) {} else if (!buffers[accessorName] && attribute.setConstantValue(props[accessorName])) {} else if (attribute.needsUpdate()) {
        updated = true;

        this._updateAttribute({
          attribute,
          numInstances,
          data,
          props,
          context
        });
      }

      this.needsRedraw |= attribute.needsRedraw();
    }

    if (updated) {
      (0,debug/* default */.Z)(TRACE_UPDATE_END, this, numInstances);
    }

    if (this.stats) {
      this.stats.get('Update Attributes').timeEnd();
    }

    this.attributeTransitionManager.update({
      attributes: this.attributes,
      numInstances,
      transitions
    });
  }

  updateTransition() {
    const {
      attributeTransitionManager
    } = this;
    const transitionUpdated = attributeTransitionManager.run();
    this.needsRedraw = this.needsRedraw || transitionUpdated;
    return transitionUpdated;
  }

  getAttributes() {
    return this.attributes;
  }

  getChangedAttributes(opts = {
    clearChangedFlags: false
  }) {
    const {
      attributes,
      attributeTransitionManager
    } = this;
    const changedAttributes = { ...attributeTransitionManager.getAttributes()
    };

    for (const attributeName in attributes) {
      const attribute = attributes[attributeName];

      if (attribute.needsRedraw(opts) && !attributeTransitionManager.hasAttribute(attributeName)) {
        changedAttributes[attributeName] = attribute;
      }
    }

    return changedAttributes;
  }

  getShaderAttributes(attributes, excludeAttributes = {}) {
    if (!attributes) {
      attributes = this.getAttributes();
    }

    const shaderAttributes = {};

    for (const attributeName in attributes) {
      if (!excludeAttributes[attributeName]) {
        Object.assign(shaderAttributes, attributes[attributeName].getShaderAttributes());
      }
    }

    return shaderAttributes;
  }

  getAccessors() {
    return this.updateTriggers;
  }

  _add(attributes, updaters, extraProps = {}) {
    if (updaters) {
      log/* default.warn */.Z.warn('AttributeManager.add({updaters}) - updater map no longer supported')();
    }

    for (const attributeName in attributes) {
      const attribute = attributes[attributeName];
      this.attributes[attributeName] = this._createAttribute(attributeName, attribute, extraProps);
    }

    this._mapUpdateTriggersToAttributes();
  }

  _createAttribute(name, attribute, extraProps) {
    const props = { ...attribute,
      id: name,
      constant: attribute.constant || false,
      isIndexed: attribute.isIndexed || attribute.elements,
      size: attribute.elements && 1 || attribute.size,
      value: attribute.value || null,
      divisor: attribute.instanced || extraProps.instanced ? 1 : attribute.divisor
    };
    return new Attribute(this.gl, props);
  }

  _mapUpdateTriggersToAttributes() {
    const triggers = {};

    for (const attributeName in this.attributes) {
      const attribute = this.attributes[attributeName];
      attribute.getUpdateTriggers().forEach(triggerName => {
        if (!triggers[triggerName]) {
          triggers[triggerName] = [];
        }

        triggers[triggerName].push(attributeName);
      });
    }

    this.updateTriggers = triggers;
  }

  _invalidateTrigger(triggerName, dataRange) {
    const {
      attributes,
      updateTriggers
    } = this;
    const invalidatedAttributes = updateTriggers[triggerName];

    if (invalidatedAttributes) {
      invalidatedAttributes.forEach(name => {
        const attribute = attributes[name];

        if (attribute) {
          attribute.setNeedsUpdate(attribute.id, dataRange);
        }
      });
    }

    return invalidatedAttributes;
  }

  _updateAttribute(opts) {
    const {
      attribute,
      numInstances
    } = opts;
    (0,debug/* default */.Z)(TRACE_ATTRIBUTE_UPDATE_START, attribute);

    if (attribute.allocate(numInstances)) {
      (0,debug/* default */.Z)(TRACE_ATTRIBUTE_ALLOCATE, attribute, numInstances);
    }

    const updated = attribute.updateBuffer(opts);

    if (updated) {
      this.needsRedraw = true;
      (0,debug/* default */.Z)(TRACE_ATTRIBUTE_UPDATE_END, attribute, numInstances);
    }
  }

}
//# sourceMappingURL=attribute-manager.js.map

/***/ }),

/***/ 69006:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "DY": () => (/* binding */ cycleBuffers),
  "pi": () => (/* binding */ getAttributeBufferLength),
  "w": () => (/* binding */ getAttributeTypeFromSize),
  "AQ": () => (/* binding */ getSourceBufferAttribute),
  "M0": () => (/* binding */ normalizeTransitionSettings),
  "IV": () => (/* binding */ padBuffer)
});

;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/array-utils.js
function padArrayChunk({
  source,
  target,
  start = 0,
  end,
  size,
  getData
}) {
  end = end || target.length;
  const sourceLength = source.length;
  const targetLength = end - start;

  if (sourceLength > targetLength) {
    target.set(source.subarray(0, targetLength), start);
    return;
  }

  target.set(source, start);

  if (!getData) {
    return;
  }

  let i = sourceLength;

  while (i < targetLength) {
    const datum = getData(i, source);

    for (let j = 0; j < size; j++) {
      target[start + i] = datum[j] || 0;
      i++;
    }
  }
}

function padArray({
  source,
  target,
  size,
  getData,
  sourceStartIndices,
  targetStartIndices
}) {
  if (!Array.isArray(targetStartIndices)) {
    padArrayChunk({
      source,
      target,
      size,
      getData
    });
    return target;
  }

  let sourceIndex = 0;
  let targetIndex = 0;

  const getChunkData = getData && ((i, chunk) => getData(i + targetIndex, chunk));

  const n = Math.min(sourceStartIndices.length, targetStartIndices.length);

  for (let i = 1; i < n; i++) {
    const nextSourceIndex = sourceStartIndices[i] * size;
    const nextTargetIndex = targetStartIndices[i] * size;
    padArrayChunk({
      source: source.subarray(sourceIndex, nextSourceIndex),
      target,
      start: targetIndex,
      end: nextTargetIndex,
      size,
      getData: getChunkData
    });
    sourceIndex = nextSourceIndex;
    targetIndex = nextTargetIndex;
  }

  if (targetIndex < target.length) {
    padArrayChunk({
      source: [],
      target,
      start: targetIndex,
      size,
      getData: getChunkData
    });
  }

  return target;
}
//# sourceMappingURL=array-utils.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-utils.js

const DEFAULT_TRANSITION_SETTINGS = {
  interpolation: {
    duration: 0,
    easing: t => t
  },
  spring: {
    stiffness: 0.05,
    damping: 0.5
  }
};
function normalizeTransitionSettings(userSettings, layerSettings) {
  if (!userSettings) {
    return null;
  }

  if (Number.isFinite(userSettings)) {
    userSettings = {
      duration: userSettings
    };
  }

  userSettings.type = userSettings.type || 'interpolation';
  return { ...DEFAULT_TRANSITION_SETTINGS[userSettings.type],
    ...layerSettings,
    ...userSettings
  };
}
function getSourceBufferAttribute(gl, attribute) {
  const buffer = attribute.getBuffer();

  if (buffer) {
    return [attribute.getBuffer(), {
      divisor: 0,
      size: attribute.size,
      normalized: attribute.settings.normalized
    }];
  }

  return attribute.value;
}
function getAttributeTypeFromSize(size) {
  switch (size) {
    case 1:
      return 'float';

    case 2:
      return 'vec2';

    case 3:
      return 'vec3';

    case 4:
      return 'vec4';

    default:
      throw new Error("No defined attribute type for size \"".concat(size, "\""));
  }
}
function cycleBuffers(buffers) {
  buffers.push(buffers.shift());
}
function getAttributeBufferLength(attribute, numInstances) {
  const {
    doublePrecision,
    settings,
    value,
    size
  } = attribute;
  const multiplier = doublePrecision && value instanceof Float64Array ? 2 : 1;
  return (settings.noAlloc ? value.length : numInstances * size) * multiplier;
}
function padBuffer({
  buffer,
  numInstances,
  attribute,
  fromLength,
  fromStartIndices,
  getData = x => x
}) {
  const precisionMultiplier = attribute.doublePrecision && attribute.value instanceof Float64Array ? 2 : 1;
  const size = attribute.size * precisionMultiplier;
  const byteOffset = attribute.byteOffset;
  const toStartIndices = attribute.startIndices;
  const hasStartIndices = fromStartIndices && toStartIndices;
  const toLength = getAttributeBufferLength(attribute, numInstances);
  const isConstant = attribute.state.constant;

  if (!hasStartIndices && fromLength >= toLength) {
    return;
  }

  const toData = isConstant ? attribute.value : attribute.getBuffer().getData({
    srcByteOffset: byteOffset
  });

  if (attribute.settings.normalized && !isConstant) {
    const getter = getData;

    getData = (value, chunk) => attribute._normalizeConstant(getter(value, chunk));
  }

  const getMissingData = isConstant ? (i, chunk) => getData(toData, chunk) : (i, chunk) => getData(toData.subarray(i, i + size), chunk);
  const source = buffer.getData({
    length: fromLength
  });
  const data = new Float32Array(toLength);
  padArray({
    source,
    target: data,
    sourceStartIndices: fromStartIndices,
    targetStartIndices: toStartIndices,
    size,
    getData: getMissingData
  });

  if (buffer.byteLength < data.byteLength + byteOffset) {
    buffer.reallocate(data.byteLength + byteOffset);
  }

  buffer.subData({
    data,
    offset: byteOffset
  });
}
//# sourceMappingURL=attribute-transition-utils.js.map

/***/ }),

/***/ 24088:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Df": () => (/* binding */ COORDINATE_SYSTEM),
/* harmony export */   "zG": () => (/* binding */ PROJECTION_MODE),
/* harmony export */   "FP": () => (/* binding */ EVENTS)
/* harmony export */ });
/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(80744);

const COORDINATE_SYSTEM = {
  DEFAULT: -1,
  LNGLAT: 1,
  METER_OFFSETS: 2,
  LNGLAT_OFFSETS: 3,
  CARTESIAN: 0
};
Object.defineProperty(COORDINATE_SYSTEM, 'IDENTITY', {
  get: () => _utils_log__WEBPACK_IMPORTED_MODULE_0__/* ["default"].deprecated */ .Z.deprecated('COORDINATE_SYSTEM.IDENTITY', 'COORDINATE_SYSTEM.CARTESIAN')() || 0
});
const PROJECTION_MODE = {
  WEB_MERCATOR: 1,
  GLOBE: 2,
  WEB_MERCATOR_AUTO_OFFSET: 4,
  IDENTITY: 0
};
const EVENTS = {
  click: {
    handler: 'onClick'
  },
  panstart: {
    handler: 'onDragStart'
  },
  panmove: {
    handler: 'onDrag'
  },
  panend: {
    handler: 'onDragEnd'
  }
};
//# sourceMappingURL=constants.js.map

/***/ }),

/***/ 95772:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Layer)
});

// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/constants.js
var constants = __webpack_require__(24088);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-manager.js + 8 modules
var attribute_manager = __webpack_require__(83518);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-utils.js + 1 modules
var attribute_transition_utils = __webpack_require__(69006);
// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/lib/common.js
var common = __webpack_require__(14034);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/transitions/transition.js
var transition = __webpack_require__(26395);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/transitions/cpu-interpolation-transition.js


class CPUInterpolationTransition extends transition/* default */.Z {
  get value() {
    return this._value;
  }

  _onUpdate() {
    const {
      time,
      settings: {
        fromValue,
        toValue,
        duration,
        easing
      }
    } = this;
    const t = easing(time / duration);
    this._value = (0,common/* lerp */.t7)(fromValue, toValue, t);
  }

}
//# sourceMappingURL=cpu-interpolation-transition.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/transitions/cpu-spring-transition.js

const EPSILON = 1e-5;

function updateSpringElement(prev, cur, dest, damping, stiffness) {
  const velocity = cur - prev;
  const delta = dest - cur;
  const spring = delta * stiffness;
  const damper = -velocity * damping;
  return spring + damper + velocity + cur;
}

function updateSpring(prev, cur, dest, damping, stiffness) {
  if (Array.isArray(dest)) {
    const next = [];

    for (let i = 0; i < dest.length; i++) {
      next[i] = updateSpringElement(prev[i], cur[i], dest[i], damping, stiffness);
    }

    return next;
  }

  return updateSpringElement(prev, cur, dest, damping, stiffness);
}

function distance(value1, value2) {
  if (Array.isArray(value1)) {
    let distanceSquare = 0;

    for (let i = 0; i < value1.length; i++) {
      const d = value1[i] - value2[i];
      distanceSquare += d * d;
    }

    return Math.sqrt(distanceSquare);
  }

  return Math.abs(value1 - value2);
}

class CPUSpringTransition extends transition/* default */.Z {
  get value() {
    return this._currValue;
  }

  _onUpdate() {
    const {
      fromValue,
      toValue,
      damping,
      stiffness
    } = this.settings;
    const {
      _prevValue = fromValue,
      _currValue = fromValue
    } = this;
    let nextValue = updateSpring(_prevValue, _currValue, toValue, damping, stiffness);
    const delta = distance(nextValue, toValue);
    const velocity = distance(nextValue, _currValue);

    if (delta < EPSILON && velocity < EPSILON) {
      nextValue = toValue;
      this.end();
    }

    this._prevValue = _currValue;
    this._currValue = nextValue;
  }

}
//# sourceMappingURL=cpu-spring-transition.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/log.js
var log = __webpack_require__(80744);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/uniform-transition-manager.js




const TRANSITION_TYPES = {
  interpolation: CPUInterpolationTransition,
  spring: CPUSpringTransition
};
class UniformTransitionManager {
  constructor(timeline) {
    this.transitions = new Map();
    this.timeline = timeline;
  }

  get active() {
    return this.transitions.size > 0;
  }

  add(key, fromValue, toValue, settings) {
    const {
      transitions
    } = this;

    if (transitions.has(key)) {
      const transition = transitions.get(key);
      const {
        value = transition.settings.fromValue
      } = transition;
      fromValue = value;
      this.remove(key);
    }

    settings = (0,attribute_transition_utils/* normalizeTransitionSettings */.M0)(settings);

    if (!settings) {
      return;
    }

    const TransitionType = TRANSITION_TYPES[settings.type];

    if (!TransitionType) {
      log/* default.error */.Z.error("unsupported transition type '".concat(settings.type, "'"))();
      return;
    }

    const transition = new TransitionType(this.timeline);
    transition.start({ ...settings,
      fromValue,
      toValue
    });
    transitions.set(key, transition);
  }

  remove(key) {
    const {
      transitions
    } = this;

    if (transitions.has(key)) {
      transitions.get(key).cancel();
      transitions.delete(key);
    }
  }

  update() {
    const propsInTransition = {};

    for (const [key, transition] of this.transitions) {
      transition.update();
      propsInTransition[key] = transition.value;

      if (!transition.inProgress) {
        this.remove(key);
      }
    }

    return propsInTransition;
  }

  clear() {
    for (const key of this.transitions.keys()) {
      this.remove(key);
    }
  }

}
//# sourceMappingURL=uniform-transition-manager.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/lifecycle/props.js
var props = __webpack_require__(71761);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/count.js
const ERR_NOT_OBJECT = 'count(): argument not an object';
const ERR_NOT_CONTAINER = 'count(): argument not a container';
function count(container) {
  if (!isObject(container)) {
    throw new Error(ERR_NOT_OBJECT);
  }

  if (typeof container.count === 'function') {
    return container.count();
  }

  if (Number.isFinite(container.size)) {
    return container.size;
  }

  if (Number.isFinite(container.length)) {
    return container.length;
  }

  if (isPlainObject(container)) {
    return Object.keys(container).length;
  }

  throw new Error(ERR_NOT_CONTAINER);
}

function isPlainObject(value) {
  return value !== null && typeof value === 'object' && value.constructor === Object;
}

function isObject(value) {
  return value !== null && typeof value === 'object';
}
//# sourceMappingURL=count.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/debug/index.js
var debug = __webpack_require__(63803);
// EXTERNAL MODULE: ./node_modules/@luma.gl/gltools/dist/esm/index.js + 13 modules
var esm = __webpack_require__(39450);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/assert.js
var assert = __webpack_require__(75304);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/memoize.js
var memoize = __webpack_require__(88177);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/shader.js
var shader = __webpack_require__(27870);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/shaderlib/project/viewport-uniforms.js
var viewport_uniforms = __webpack_require__(8771);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/viewports/web-mercator-viewport.js
var web_mercator_viewport = __webpack_require__(96935);
// EXTERNAL MODULE: ./node_modules/gl-matrix/esm/vec4.js
var vec4 = __webpack_require__(7778);
// EXTERNAL MODULE: ./node_modules/gl-matrix/esm/vec3.js
var vec3 = __webpack_require__(77160);
// EXTERNAL MODULE: ./node_modules/@math.gl/web-mercator/dist/esm/index.js + 8 modules
var dist_esm = __webpack_require__(17013);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project-functions.js







function lngLatZToWorldPosition(lngLatZ, viewport, offsetMode = false) {
  const p = viewport.projectPosition(lngLatZ);

  if (offsetMode && viewport instanceof web_mercator_viewport/* default */.Z) {
    const [longitude, latitude, z = 0] = lngLatZ;
    const distanceScales = viewport.getDistanceScales([longitude, latitude]);
    p[2] = z * distanceScales.unitsPerMeter[2];
  }

  return p;
}

function normalizeParameters(opts) {
  const normalizedParams = { ...opts
  };
  let {
    coordinateSystem
  } = opts;
  const {
    viewport,
    coordinateOrigin,
    fromCoordinateSystem,
    fromCoordinateOrigin
  } = opts;

  if (coordinateSystem === constants/* COORDINATE_SYSTEM.DEFAULT */.Df.DEFAULT) {
    coordinateSystem = viewport.isGeospatial ? constants/* COORDINATE_SYSTEM.LNGLAT */.Df.LNGLAT : constants/* COORDINATE_SYSTEM.CARTESIAN */.Df.CARTESIAN;
  }

  if (fromCoordinateSystem === undefined) {
    normalizedParams.fromCoordinateSystem = coordinateSystem;
  }

  if (fromCoordinateOrigin === undefined) {
    normalizedParams.fromCoordinateOrigin = coordinateOrigin;
  }

  normalizedParams.coordinateSystem = coordinateSystem;
  return normalizedParams;
}

function getWorldPosition(position, {
  viewport,
  modelMatrix,
  coordinateSystem,
  coordinateOrigin,
  offsetMode
}) {
  let [x, y, z = 0] = position;

  if (modelMatrix) {
    [x, y, z] = vec4/* transformMat4 */.fF([], [x, y, z, 1.0], modelMatrix);
  }

  switch (coordinateSystem) {
    case constants/* COORDINATE_SYSTEM.LNGLAT */.Df.LNGLAT:
      return lngLatZToWorldPosition([x, y, z], viewport, offsetMode);

    case constants/* COORDINATE_SYSTEM.LNGLAT_OFFSETS */.Df.LNGLAT_OFFSETS:
      return lngLatZToWorldPosition([x + coordinateOrigin[0], y + coordinateOrigin[1], z + (coordinateOrigin[2] || 0)], viewport, offsetMode);

    case constants/* COORDINATE_SYSTEM.METER_OFFSETS */.Df.METER_OFFSETS:
      return lngLatZToWorldPosition((0,dist_esm/* addMetersToLngLat */.eG)(coordinateOrigin, [x, y, z]), viewport, offsetMode);

    case constants/* COORDINATE_SYSTEM.CARTESIAN */.Df.CARTESIAN:
    default:
      return viewport.isGeospatial ? [x + coordinateOrigin[0], y + coordinateOrigin[1], z + coordinateOrigin[2]] : viewport.projectPosition([x, y, z]);
  }
}
function projectPosition(position, params) {
  const {
    viewport,
    coordinateSystem,
    coordinateOrigin,
    modelMatrix,
    fromCoordinateSystem,
    fromCoordinateOrigin
  } = normalizeParameters(params);
  const {
    geospatialOrigin,
    shaderCoordinateOrigin,
    offsetMode
  } = (0,viewport_uniforms/* getOffsetOrigin */.v)(viewport, coordinateSystem, coordinateOrigin);
  const worldPosition = getWorldPosition(position, {
    viewport,
    modelMatrix,
    coordinateSystem: fromCoordinateSystem,
    coordinateOrigin: fromCoordinateOrigin,
    offsetMode
  });

  if (offsetMode) {
    const positionCommonSpace = viewport.projectPosition(geospatialOrigin || shaderCoordinateOrigin);
    vec3/* sub */.lu(worldPosition, worldPosition, positionCommonSpace);
  }

  return worldPosition;
}
//# sourceMappingURL=project-functions.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/typed-array-manager.js
var typed_array_manager = __webpack_require__(36610);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/lifecycle/constants.js
var lifecycle_constants = __webpack_require__(85409);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/iterable-utils.js
var iterable_utils = __webpack_require__(38550);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture-2d.js + 1 modules
var texture_2d = __webpack_require__(4912);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/texture.js

const DEFAULT_TEXTURE_PARAMETERS = {
  [10241]: 9987,
  [10240]: 9729,
  [10242]: 33071,
  [10243]: 33071
};
const internalTextures = {};
function createTexture(layer, image) {
  const gl = layer.context && layer.context.gl;

  if (!gl || !image) {
    return null;
  }

  if (image instanceof texture_2d/* default */.Z) {
    return image;
  } else if (image.constructor && image.constructor.name !== 'Object') {
    image = {
      data: image
    };
  }

  let specialTextureParameters = null;

  if (image.compressed) {
    specialTextureParameters = {
      [10241]: image.data.length > 1 ? 9985 : 9729
    };
  }

  const texture = new texture_2d/* default */.Z(gl, { ...image,
    parameters: { ...DEFAULT_TEXTURE_PARAMETERS,
      ...specialTextureParameters,
      ...layer.props.textureParameters
    }
  });
  internalTextures[texture.id] = true;
  return texture;
}
function destroyTexture(texture) {
  if (!texture || !(texture instanceof texture_2d/* default */.Z)) {
    return;
  }

  if (internalTextures[texture.id]) {
    texture.delete();
    delete internalTextures[texture.id];
  }
}
//# sourceMappingURL=texture.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lifecycle/prop-types.js

const TYPE_DEFINITIONS = {
  boolean: {
    validate(value, propType) {
      return true;
    },

    equal(value1, value2, propType) {
      return Boolean(value1) === Boolean(value2);
    }

  },
  number: {
    validate(value, propType) {
      return Number.isFinite(value) && (!('max' in propType) || value <= propType.max) && (!('min' in propType) || value >= propType.min);
    }

  },
  color: {
    validate(value, propType) {
      return propType.optional && !value || isArray(value) && (value.length === 3 || value.length === 4);
    },

    equal(value1, value2, propType) {
      return arrayEqual(value1, value2);
    }

  },
  accessor: {
    validate(value, propType) {
      const valueType = getTypeOf(value);
      return valueType === 'function' || valueType === getTypeOf(propType.value);
    },

    equal(value1, value2, propType) {
      if (typeof value2 === 'function') {
        return true;
      }

      return arrayEqual(value1, value2);
    }

  },
  array: {
    validate(value, propType) {
      return propType.optional && !value || isArray(value);
    },

    equal(value1, value2, propType) {
      return propType.compare ? arrayEqual(value1, value2) : value1 === value2;
    }

  },
  function: {
    validate(value, propType) {
      return propType.optional && !value || typeof value === 'function';
    },

    equal(value1, value2, propType) {
      return !propType.compare || value1 === value2;
    }

  },
  data: {
    transform: (value, propType, component) => {
      const {
        dataTransform
      } = component ? component.props : {};
      return dataTransform && value ? dataTransform(value) : value;
    }
  },
  image: {
    transform: (value, propType, component) => {
      return createTexture(component, value);
    },
    release: value => {
      destroyTexture(value);
    }
  }
};

function arrayEqual(array1, array2) {
  if (array1 === array2) {
    return true;
  }

  if (!isArray(array1) || !isArray(array2)) {
    return false;
  }

  const len = array1.length;

  if (len !== array2.length) {
    return false;
  }

  for (let i = 0; i < len; i++) {
    if (array1[i] !== array2[i]) {
      return false;
    }
  }

  return true;
}

function parsePropTypes(propDefs) {
  const propTypes = {};
  const defaultProps = {};
  const deprecatedProps = {};

  for (const [propName, propDef] of Object.entries(propDefs)) {
    if (propDef && propDef.deprecatedFor) {
      deprecatedProps[propName] = Array.isArray(propDef.deprecatedFor) ? propDef.deprecatedFor : [propDef.deprecatedFor];
    } else {
      const propType = parsePropType(propName, propDef);
      propTypes[propName] = propType;
      defaultProps[propName] = propType.value;
    }
  }

  return {
    propTypes,
    defaultProps,
    deprecatedProps
  };
}

function parsePropType(name, propDef) {
  switch (getTypeOf(propDef)) {
    case 'object':
      return normalizePropDefinition(name, propDef);

    case 'array':
      return normalizePropDefinition(name, {
        type: 'array',
        value: propDef,
        compare: false
      });

    case 'boolean':
      return normalizePropDefinition(name, {
        type: 'boolean',
        value: propDef
      });

    case 'number':
      return normalizePropDefinition(name, {
        type: 'number',
        value: propDef
      });

    case 'function':
      return normalizePropDefinition(name, {
        type: 'function',
        value: propDef,
        compare: true
      });

    default:
      return {
        name,
        type: 'unknown',
        value: propDef
      };
  }
}

function normalizePropDefinition(name, propDef) {
  if (!('type' in propDef)) {
    if (!('value' in propDef)) {
      return {
        name,
        type: 'object',
        value: propDef
      };
    }

    return {
      name,
      type: getTypeOf(propDef.value),
      ...propDef
    };
  }

  return {
    name,
    ...TYPE_DEFINITIONS[propDef.type],
    ...propDef
  };
}

function isArray(value) {
  return Array.isArray(value) || ArrayBuffer.isView(value);
}

function getTypeOf(value) {
  if (isArray(value)) {
    return 'array';
  }

  if (value === null) {
    return 'null';
  }

  return typeof value;
}
//# sourceMappingURL=prop-types.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lifecycle/create-props.js




const {
  COMPONENT,
  ASYNC_ORIGINAL,
  ASYNC_RESOLVED,
  ASYNC_DEFAULTS
} = lifecycle_constants/* PROP_SYMBOLS */.A;
function createProps() {
  const component = this;
  const propsPrototype = getPropsPrototype(component.constructor);
  const propsInstance = Object.create(propsPrototype);
  propsInstance[COMPONENT] = component;
  propsInstance[ASYNC_ORIGINAL] = {};
  propsInstance[ASYNC_RESOLVED] = {};

  for (let i = 0; i < arguments.length; ++i) {
    const props = arguments[i];

    for (const key in props) {
      propsInstance[key] = props[key];
    }
  }

  Object.freeze(propsInstance);
  return propsInstance;
}

function getPropsPrototype(componentClass) {
  const defaultProps = getOwnProperty(componentClass, '_mergedDefaultProps');

  if (!defaultProps) {
    createPropsPrototypeAndTypes(componentClass);
    return componentClass._mergedDefaultProps;
  }

  return defaultProps;
}

function createPropsPrototypeAndTypes(componentClass) {
  const parent = componentClass.prototype;

  if (!parent) {
    return;
  }

  const parentClass = Object.getPrototypeOf(componentClass);
  const parentDefaultProps = getPropsPrototype(parentClass);
  const componentDefaultProps = getOwnProperty(componentClass, 'defaultProps') || {};
  const componentPropDefs = parsePropTypes(componentDefaultProps);
  const defaultProps = createPropsPrototype(componentPropDefs.defaultProps, parentDefaultProps, componentClass);
  const propTypes = { ...parentClass._propTypes,
    ...componentPropDefs.propTypes
  };
  addAsyncPropsToPropPrototype(defaultProps, propTypes);
  const deprecatedProps = { ...parentClass._deprecatedProps,
    ...componentPropDefs.deprecatedProps
  };
  addDeprecatedPropsToPropPrototype(defaultProps, deprecatedProps);
  componentClass._mergedDefaultProps = defaultProps;
  componentClass._propTypes = propTypes;
  componentClass._deprecatedProps = deprecatedProps;
}

function createPropsPrototype(props, parentProps, componentClass) {
  const defaultProps = Object.create(null);
  Object.assign(defaultProps, parentProps, props);
  const id = getComponentName(componentClass);
  delete props.id;
  Object.defineProperties(defaultProps, {
    id: {
      writable: true,
      value: id
    }
  });
  return defaultProps;
}

function addDeprecatedPropsToPropPrototype(defaultProps, deprecatedProps) {
  for (const propName in deprecatedProps) {
    Object.defineProperty(defaultProps, propName, {
      enumerable: false,

      set(newValue) {
        const nameStr = "".concat(this.id, ": ").concat(propName);

        for (const newPropName of deprecatedProps[propName]) {
          if (!create_props_hasOwnProperty(this, newPropName)) {
            this[newPropName] = newValue;
          }
        }

        log/* default.deprecated */.Z.deprecated(nameStr, deprecatedProps[propName].join('/'))();
      }

    });
  }
}

function addAsyncPropsToPropPrototype(defaultProps, propTypes) {
  const defaultValues = {};
  const descriptors = {};

  for (const propName in propTypes) {
    const propType = propTypes[propName];
    const {
      name,
      value
    } = propType;

    if (propType.async) {
      defaultValues[name] = value;
      descriptors[name] = getDescriptorForAsyncProp(name, value);
    }
  }

  defaultProps[ASYNC_DEFAULTS] = defaultValues;
  defaultProps[ASYNC_ORIGINAL] = {};
  Object.defineProperties(defaultProps, descriptors);
}

function getDescriptorForAsyncProp(name) {
  return {
    enumerable: true,

    set(newValue) {
      if (typeof newValue === 'string' || newValue instanceof Promise || (0,iterable_utils/* isAsyncIterable */.D0)(newValue)) {
        this[ASYNC_ORIGINAL][name] = newValue;
      } else {
        this[ASYNC_RESOLVED][name] = newValue;
      }
    },

    get() {
      if (this[ASYNC_RESOLVED]) {
        if (name in this[ASYNC_RESOLVED]) {
          const value = this[ASYNC_RESOLVED][name];
          return value || this[ASYNC_DEFAULTS][name];
        }

        if (name in this[ASYNC_ORIGINAL]) {
          const state = this[COMPONENT] && this[COMPONENT].internalState;

          if (state && state.hasAsyncProp(name)) {
            return state.getAsyncProp(name) || this[ASYNC_DEFAULTS][name];
          }
        }
      }

      return this[ASYNC_DEFAULTS][name];
    }

  };
}

function create_props_hasOwnProperty(object, prop) {
  return Object.prototype.hasOwnProperty.call(object, prop);
}

function getOwnProperty(object, prop) {
  return create_props_hasOwnProperty(object, prop) && object[prop];
}

function getComponentName(componentClass) {
  const componentName = getOwnProperty(componentClass, 'layerName') || getOwnProperty(componentClass, 'componentName');

  if (!componentName) {
    log/* default.once */.Z.once(0, "".concat(componentClass.name, ".componentName not specified"))();
  }

  return componentName || componentClass.name;
}
//# sourceMappingURL=create-props.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lifecycle/component-state.js


const {
  ASYNC_ORIGINAL: component_state_ASYNC_ORIGINAL,
  ASYNC_RESOLVED: component_state_ASYNC_RESOLVED,
  ASYNC_DEFAULTS: component_state_ASYNC_DEFAULTS
} = lifecycle_constants/* PROP_SYMBOLS */.A;
const EMPTY_PROPS = Object.freeze({});
class ComponentState {
  constructor(component = null) {
    this.component = component;
    this.asyncProps = {};

    this.onAsyncPropUpdated = () => {};

    this.oldProps = EMPTY_PROPS;
    this.oldAsyncProps = null;
  }

  finalize() {
    for (const propName in this.asyncProps) {
      const asyncProp = this.asyncProps[propName];

      if (asyncProp.type && asyncProp.type.release) {
        asyncProp.type.release(asyncProp.resolvedValue, asyncProp.type, this.component);
      }
    }
  }

  getOldProps() {
    return this.oldAsyncProps || this.oldProps;
  }

  resetOldProps() {
    this.oldAsyncProps = null;
    this.oldProps = this.component.props;
  }

  freezeAsyncOldProps() {
    if (!this.oldAsyncProps) {
      this.oldProps = this.oldProps || this.component.props;
      this.oldAsyncProps = Object.create(this.oldProps);

      for (const propName in this.asyncProps) {
        Object.defineProperty(this.oldAsyncProps, propName, {
          enumerable: true,
          value: this.oldProps[propName]
        });
      }
    }
  }

  hasAsyncProp(propName) {
    return propName in this.asyncProps;
  }

  getAsyncProp(propName) {
    const asyncProp = this.asyncProps[propName];
    return asyncProp && asyncProp.resolvedValue;
  }

  isAsyncPropLoading(propName) {
    if (propName) {
      const asyncProp = this.asyncProps[propName];
      return Boolean(asyncProp && asyncProp.pendingLoadCount > 0 && asyncProp.pendingLoadCount !== asyncProp.resolvedLoadCount);
    }

    for (const key in this.asyncProps) {
      if (this.isAsyncPropLoading(key)) {
        return true;
      }
    }

    return false;
  }

  reloadAsyncProp(propName, value) {
    this._watchPromise(propName, Promise.resolve(value));
  }

  setAsyncProps(props) {
    const resolvedValues = props[component_state_ASYNC_RESOLVED] || {};
    const originalValues = props[component_state_ASYNC_ORIGINAL] || props;
    const defaultValues = props[component_state_ASYNC_DEFAULTS] || {};

    for (const propName in resolvedValues) {
      const value = resolvedValues[propName];

      this._createAsyncPropData(propName, defaultValues[propName]);

      this._updateAsyncProp(propName, value);

      resolvedValues[propName] = this.getAsyncProp(propName);
    }

    for (const propName in originalValues) {
      const value = originalValues[propName];

      this._createAsyncPropData(propName, defaultValues[propName]);

      this._updateAsyncProp(propName, value);
    }
  }

  _updateAsyncProp(propName, value) {
    if (!this._didAsyncInputValueChange(propName, value)) {
      return;
    }

    if (typeof value === 'string') {
      var _this$layer;

      const fetch = (_this$layer = this.layer) === null || _this$layer === void 0 ? void 0 : _this$layer.props.fetch;
      const url = value;

      if (fetch) {
        value = fetch(url, {
          propName,
          layer: this.layer
        });
      }
    }

    if (value instanceof Promise) {
      this._watchPromise(propName, value);

      return;
    }

    if ((0,iterable_utils/* isAsyncIterable */.D0)(value)) {
      this._resolveAsyncIterable(propName, value);

      return;
    }

    this._setPropValue(propName, value);
  }

  _didAsyncInputValueChange(propName, value) {
    const asyncProp = this.asyncProps[propName];

    if (value === asyncProp.resolvedValue || value === asyncProp.lastValue) {
      return false;
    }

    asyncProp.lastValue = value;
    return true;
  }

  _setPropValue(propName, value) {
    const asyncProp = this.asyncProps[propName];
    value = this._postProcessValue(asyncProp, value);
    asyncProp.resolvedValue = value;
    asyncProp.pendingLoadCount++;
    asyncProp.resolvedLoadCount = asyncProp.pendingLoadCount;
  }

  _setAsyncPropValue(propName, value, loadCount) {
    const asyncProp = this.asyncProps[propName];

    if (asyncProp && loadCount >= asyncProp.resolvedLoadCount && value !== undefined) {
      this.freezeAsyncOldProps();
      asyncProp.resolvedValue = value;
      asyncProp.resolvedLoadCount = loadCount;
      this.onAsyncPropUpdated(propName, value);
    }
  }

  _watchPromise(propName, promise) {
    const asyncProp = this.asyncProps[propName];
    asyncProp.pendingLoadCount++;
    const loadCount = asyncProp.pendingLoadCount;
    promise.then(data => {
      var _this$layer2;

      data = this._postProcessValue(asyncProp, data);

      this._setAsyncPropValue(propName, data, loadCount);

      const onDataLoad = (_this$layer2 = this.layer) === null || _this$layer2 === void 0 ? void 0 : _this$layer2.props.onDataLoad;

      if (propName === 'data' && onDataLoad) {
        onDataLoad(data, {
          propName,
          layer: this.layer
        });
      }
    }).catch(error => {
      var _this$layer3;

      (_this$layer3 = this.layer) === null || _this$layer3 === void 0 ? void 0 : _this$layer3.raiseError(error, "loading ".concat(propName, " of ").concat(this.layer));
    });
  }

  async _resolveAsyncIterable(propName, iterable) {
    var _this$layer4;

    if (propName !== 'data') {
      this._setPropValue(propName, iterable);
    }

    const asyncProp = this.asyncProps[propName];
    asyncProp.pendingLoadCount++;
    const loadCount = asyncProp.pendingLoadCount;
    let data = [];
    let count = 0;

    for await (const chunk of iterable) {
      const {
        dataTransform
      } = this.component ? this.component.props : {};

      if (dataTransform) {
        data = dataTransform(chunk, data);
      } else {
        data = data.concat(chunk);
      }

      Object.defineProperty(data, '__diff', {
        enumerable: false,
        value: [{
          startRow: count,
          endRow: data.length
        }]
      });
      count = data.length;

      this._setAsyncPropValue(propName, data, loadCount);
    }

    const onDataLoad = (_this$layer4 = this.layer) === null || _this$layer4 === void 0 ? void 0 : _this$layer4.props.onDataLoad;

    if (onDataLoad) {
      onDataLoad(data, {
        propName,
        layer: this.layer
      });
    }
  }

  _postProcessValue(asyncProp, value) {
    const propType = asyncProp.type;

    if (propType) {
      if (propType.release) {
        propType.release(asyncProp.resolvedValue, propType, this.component);
      }

      if (propType.transform) {
        return propType.transform(value, propType, this.component);
      }
    }

    return value;
  }

  _createAsyncPropData(propName, defaultValue) {
    const asyncProp = this.asyncProps[propName];

    if (!asyncProp) {
      const propTypes = this.component && this.component.constructor._propTypes;
      this.asyncProps[propName] = {
        type: propTypes && propTypes[propName],
        lastValue: null,
        resolvedValue: defaultValue,
        pendingLoadCount: 0,
        resolvedLoadCount: 0
      };
    }
  }

}
//# sourceMappingURL=component-state.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lifecycle/component.js



const {
  ASYNC_ORIGINAL: component_ASYNC_ORIGINAL,
  ASYNC_RESOLVED: component_ASYNC_RESOLVED,
  ASYNC_DEFAULTS: component_ASYNC_DEFAULTS
} = lifecycle_constants/* PROP_SYMBOLS */.A;

const defaultProps = {};
let counter = 0;
class Component {
  constructor() {
    this.props = createProps.apply(this, arguments);
    this.id = this.props.id;
    this.count = counter++;
    this.lifecycle = lifecycle_constants/* LIFECYCLE.NO_STATE */.d.NO_STATE;
    this.parent = null;
    this.context = null;
    this.state = null;
    this.internalState = null;
    Object.seal(this);
  }

  clone(newProps) {
    const {
      props
    } = this;
    const asyncProps = {};

    for (const key in props[component_ASYNC_DEFAULTS]) {
      if (key in props[component_ASYNC_RESOLVED]) {
        asyncProps[key] = props[component_ASYNC_RESOLVED][key];
      } else if (key in props[component_ASYNC_ORIGINAL]) {
        asyncProps[key] = props[component_ASYNC_ORIGINAL][key];
      }
    }

    return new this.constructor({ ...props,
      ...asyncProps,
      ...newProps
    });
  }

  get stats() {
    return this.internalState.stats;
  }

  _initState() {
    this.internalState = new ComponentState({});
  }

}
Component.componentName = 'Component';
Component.defaultProps = defaultProps;
//# sourceMappingURL=component.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/layer-state.js

class LayerState extends ComponentState {
  constructor({
    attributeManager,
    layer
  }) {
    super(layer);
    this.attributeManager = attributeManager;
    this.model = null;
    this.needsRedraw = true;
    this.subLayers = null;
    this.usesPickingColorCache = false;
  }

  get layer() {
    return this.component;
  }

  set layer(layer) {
    this.component = layer;
  }

}
//# sourceMappingURL=layer-state.js.map
// EXTERNAL MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/api/load.js + 23 modules
var load = __webpack_require__(73838);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/layer.js

















const TRACE_CHANGE_FLAG = 'layer.changeFlag';
const TRACE_INITIALIZE = 'layer.initialize';
const TRACE_UPDATE = 'layer.update';
const TRACE_FINALIZE = 'layer.finalize';
const TRACE_MATCHED = 'layer.matched';
const MAX_PICKING_COLOR_CACHE_SIZE = 2 ** 24 - 1;
const EMPTY_ARRAY = Object.freeze([]);
const areViewportsEqual = (0,memoize/* default */.Z)(({
  oldViewport,
  viewport
}) => {
  return oldViewport.equals(viewport);
});
let pickingColorCache = new Uint8ClampedArray(0);
const layer_defaultProps = {
  data: {
    type: 'data',
    value: EMPTY_ARRAY,
    async: true
  },
  dataComparator: null,
  _dataDiff: {
    type: 'function',
    value: data => data && data.__diff,
    compare: false,
    optional: true
  },
  dataTransform: {
    type: 'function',
    value: null,
    compare: false,
    optional: true
  },
  onDataLoad: {
    type: 'function',
    value: null,
    compare: false,
    optional: true
  },
  onError: {
    type: 'function',
    value: null,
    compare: false,
    optional: true
  },
  fetch: {
    type: 'function',
    value: (url, {
      propName,
      layer,
      loaders,
      loadOptions,
      signal
    }) => {
      const {
        resourceManager
      } = layer.context;
      loadOptions = loadOptions || layer.getLoadOptions();
      loaders = loaders || layer.props.loaders;

      if (signal) {
        var _loadOptions;

        loadOptions = { ...loadOptions,
          fetch: { ...((_loadOptions = loadOptions) === null || _loadOptions === void 0 ? void 0 : _loadOptions.fetch),
            signal
          }
        };
      }

      let inResourceManager = resourceManager.contains(url);

      if (!inResourceManager && !loadOptions) {
        resourceManager.add({
          resourceId: url,
          data: (0,load/* load */.z)(url, loaders),
          persistent: false
        });
        inResourceManager = true;
      }

      if (inResourceManager) {
        return resourceManager.subscribe({
          resourceId: url,
          onChange: data => layer.internalState.reloadAsyncProp(propName, data),
          consumerId: layer.id,
          requestId: propName
        });
      }

      return (0,load/* load */.z)(url, loaders, loadOptions);
    },
    compare: false
  },
  updateTriggers: {},
  visible: true,
  pickable: false,
  opacity: {
    type: 'number',
    min: 0,
    max: 1,
    value: 1
  },
  onHover: {
    type: 'function',
    value: null,
    compare: false,
    optional: true
  },
  onClick: {
    type: 'function',
    value: null,
    compare: false,
    optional: true
  },
  onDragStart: {
    type: 'function',
    value: null,
    compare: false,
    optional: true
  },
  onDrag: {
    type: 'function',
    value: null,
    compare: false,
    optional: true
  },
  onDragEnd: {
    type: 'function',
    value: null,
    compare: false,
    optional: true
  },
  coordinateSystem: constants/* COORDINATE_SYSTEM.DEFAULT */.Df.DEFAULT,
  coordinateOrigin: {
    type: 'array',
    value: [0, 0, 0],
    compare: true
  },
  modelMatrix: {
    type: 'array',
    value: null,
    compare: true,
    optional: true
  },
  wrapLongitude: false,
  positionFormat: 'XYZ',
  colorFormat: 'RGBA',
  parameters: {},
  transitions: null,
  extensions: [],
  loaders: {
    type: 'array',
    value: [],
    optional: true,
    compare: true
  },
  getPolygonOffset: {
    type: 'function',
    value: ({
      layerIndex
    }) => [0, -layerIndex * 100],
    compare: false
  },
  highlightedObjectIndex: -1,
  autoHighlight: false,
  highlightColor: {
    type: 'accessor',
    value: [0, 0, 128, 128]
  }
};
class Layer extends Component {
  toString() {
    const className = this.constructor.layerName || this.constructor.name;
    return "".concat(className, "({id: '").concat(this.props.id, "'})");
  }

  raiseError(error, message) {
    var _this$props$onError, _this$props;

    if (message) {
      error.message = "".concat(message, ": ").concat(error.message);
    }

    if (!((_this$props$onError = (_this$props = this.props).onError) === null || _this$props$onError === void 0 ? void 0 : _this$props$onError.call(_this$props, error))) {
      var _this$context, _this$context$onError;

      (_this$context = this.context) === null || _this$context === void 0 ? void 0 : (_this$context$onError = _this$context.onError) === null || _this$context$onError === void 0 ? void 0 : _this$context$onError.call(_this$context, error, this);
    }
  }

  setState(updateObject) {
    this.setChangeFlags({
      stateChanged: true
    });
    Object.assign(this.state, updateObject);
    this.setNeedsRedraw();
  }

  setNeedsRedraw(redraw = true) {
    if (this.internalState) {
      this.internalState.needsRedraw = redraw;
    }
  }

  setNeedsUpdate() {
    this.context.layerManager.setNeedsUpdate(String(this));
    this.internalState.needsUpdate = true;
  }

  getNeedsRedraw(opts = {
    clearRedrawFlags: false
  }) {
    return this._getNeedsRedraw(opts);
  }

  needsUpdate() {
    return this.internalState.needsUpdate || this.hasUniformTransition() || this.shouldUpdateState(this._getUpdateParams());
  }

  hasUniformTransition() {
    return this.internalState.uniformTransitions.active;
  }

  get isLoaded() {
    return this.internalState && !this.internalState.isAsyncPropLoading();
  }

  get wrapLongitude() {
    return this.props.wrapLongitude;
  }

  isPickable() {
    return this.props.pickable && this.props.visible;
  }

  getModels() {
    return this.state && (this.state.models || (this.state.model ? [this.state.model] : []));
  }

  getAttributeManager() {
    return this.internalState && this.internalState.attributeManager;
  }

  getCurrentLayer() {
    return this.internalState && this.internalState.layer;
  }

  getLoadOptions() {
    return this.props.loadOptions;
  }

  project(xyz) {
    const {
      viewport
    } = this.context;
    const worldPosition = getWorldPosition(xyz, {
      viewport,
      modelMatrix: this.props.modelMatrix,
      coordinateOrigin: this.props.coordinateOrigin,
      coordinateSystem: this.props.coordinateSystem
    });
    const [x, y, z] = (0,dist_esm/* worldToPixels */.aW)(worldPosition, viewport.pixelProjectionMatrix);
    return xyz.length === 2 ? [x, y] : [x, y, z];
  }

  unproject(xy) {
    const {
      viewport
    } = this.context;
    return viewport.unproject(xy);
  }

  projectPosition(xyz) {
    return projectPosition(xyz, {
      viewport: this.context.viewport,
      modelMatrix: this.props.modelMatrix,
      coordinateOrigin: this.props.coordinateOrigin,
      coordinateSystem: this.props.coordinateSystem
    });
  }

  use64bitPositions() {
    const {
      coordinateSystem
    } = this.props;
    return coordinateSystem === constants/* COORDINATE_SYSTEM.DEFAULT */.Df.DEFAULT || coordinateSystem === constants/* COORDINATE_SYSTEM.LNGLAT */.Df.LNGLAT || coordinateSystem === constants/* COORDINATE_SYSTEM.CARTESIAN */.Df.CARTESIAN;
  }

  onHover(info, pickingEvent) {
    if (this.props.onHover) {
      return this.props.onHover(info, pickingEvent);
    }

    return false;
  }

  onClick(info, pickingEvent) {
    if (this.props.onClick) {
      return this.props.onClick(info, pickingEvent);
    }

    return false;
  }

  nullPickingColor() {
    return [0, 0, 0];
  }

  encodePickingColor(i, target = []) {
    target[0] = i + 1 & 255;
    target[1] = i + 1 >> 8 & 255;
    target[2] = i + 1 >> 8 >> 8 & 255;
    return target;
  }

  decodePickingColor(color) {
    (0,assert/* default */.Z)(color instanceof Uint8Array);
    const [i1, i2, i3] = color;
    const index = i1 + i2 * 256 + i3 * 65536 - 1;
    return index;
  }

  initializeState() {
    throw new Error("Layer ".concat(this, " has not defined initializeState"));
  }

  getShaders(shaders) {
    for (const extension of this.props.extensions) {
      shaders = (0,shader/* mergeShaders */.l)(shaders, extension.getShaders.call(this, extension));
    }

    return shaders;
  }

  shouldUpdateState({
    oldProps,
    props,
    context,
    changeFlags
  }) {
    return changeFlags.propsOrDataChanged;
  }

  updateState({
    oldProps,
    props,
    context,
    changeFlags
  }) {
    const attributeManager = this.getAttributeManager();

    if (changeFlags.dataChanged && attributeManager) {
      const {
        dataChanged
      } = changeFlags;

      if (Array.isArray(dataChanged)) {
        for (const dataRange of dataChanged) {
          attributeManager.invalidateAll(dataRange);
        }
      } else {
        attributeManager.invalidateAll();
      }
    }

    const neededPickingBuffer = oldProps.highlightedObjectIndex >= 0 || oldProps.pickable;
    const needPickingBuffer = props.highlightedObjectIndex >= 0 || props.pickable;

    if (neededPickingBuffer !== needPickingBuffer && attributeManager) {
      const {
        pickingColors,
        instancePickingColors
      } = attributeManager.attributes;
      const pickingColorsAttribute = pickingColors || instancePickingColors;

      if (pickingColorsAttribute) {
        if (needPickingBuffer && pickingColorsAttribute.constant) {
          pickingColorsAttribute.constant = false;
          attributeManager.invalidate(pickingColorsAttribute.id);
        }

        if (!pickingColorsAttribute.value && !needPickingBuffer) {
          pickingColorsAttribute.constant = true;
          pickingColorsAttribute.value = [0, 0, 0];
        }
      }
    }
  }

  finalizeState() {
    for (const model of this.getModels()) {
      model.delete();
    }

    const attributeManager = this.getAttributeManager();

    if (attributeManager) {
      attributeManager.finalize();
    }

    this.context.resourceManager.unsubscribe({
      consumerId: this.id
    });
    this.internalState.uniformTransitions.clear();
    this.internalState.finalize();
  }

  draw(opts) {
    for (const model of this.getModels()) {
      model.draw(opts);
    }
  }

  getPickingInfo({
    info,
    mode
  }) {
    const {
      index
    } = info;

    if (index >= 0) {
      if (Array.isArray(this.props.data)) {
        info.object = this.props.data[index];
      }
    }

    return info;
  }

  activateViewport(viewport) {
    const oldViewport = this.internalState.viewport;
    this.internalState.viewport = viewport;

    if (!oldViewport || !areViewportsEqual({
      oldViewport,
      viewport
    })) {
      this.setChangeFlags({
        viewportChanged: true
      });

      if (this.isComposite) {
        if (this.needsUpdate()) {
          this.setNeedsUpdate();
        }
      } else {
        this._update();
      }
    }
  }

  invalidateAttribute(name = 'all', diffReason = '') {
    const attributeManager = this.getAttributeManager();

    if (!attributeManager) {
      return;
    }

    if (name === 'all') {
      attributeManager.invalidateAll();
    } else {
      attributeManager.invalidate(name);
    }
  }

  updateAttributes(changedAttributes) {
    for (const model of this.getModels()) {
      this._setModelAttributes(model, changedAttributes);
    }
  }

  _updateAttributes(props) {
    const attributeManager = this.getAttributeManager();

    if (!attributeManager) {
      return;
    }

    const numInstances = this.getNumInstances(props);
    const startIndices = this.getStartIndices(props);
    attributeManager.update({
      data: props.data,
      numInstances,
      startIndices,
      props,
      transitions: props.transitions,
      buffers: props.data.attributes,
      context: this,
      ignoreUnknownAttributes: true
    });
    const changedAttributes = attributeManager.getChangedAttributes({
      clearChangedFlags: true
    });
    this.updateAttributes(changedAttributes);
  }

  _updateAttributeTransition() {
    const attributeManager = this.getAttributeManager();

    if (attributeManager) {
      attributeManager.updateTransition();
    }
  }

  _updateUniformTransition() {
    const {
      uniformTransitions
    } = this.internalState;

    if (uniformTransitions.active) {
      const propsInTransition = uniformTransitions.update();
      const props = Object.create(this.props);

      for (const key in propsInTransition) {
        Object.defineProperty(props, key, {
          value: propsInTransition[key]
        });
      }

      return props;
    }

    return this.props;
  }

  calculateInstancePickingColors(attribute, {
    numInstances
  }) {
    if (attribute.constant) {
      return;
    }

    const cacheSize = Math.floor(pickingColorCache.length / 3);
    this.internalState.usesPickingColorCache = true;

    if (cacheSize < numInstances) {
      if (numInstances > MAX_PICKING_COLOR_CACHE_SIZE) {
        log/* default.warn */.Z.warn('Layer has too many data objects. Picking might not be able to distinguish all objects.')();
      }

      pickingColorCache = typed_array_manager/* default.allocate */.Z.allocate(pickingColorCache, numInstances, {
        size: 3,
        copy: true,
        maxCount: Math.max(numInstances, MAX_PICKING_COLOR_CACHE_SIZE)
      });
      const newCacheSize = Math.floor(pickingColorCache.length / 3);
      const pickingColor = [];

      for (let i = cacheSize; i < newCacheSize; i++) {
        this.encodePickingColor(i, pickingColor);
        pickingColorCache[i * 3 + 0] = pickingColor[0];
        pickingColorCache[i * 3 + 1] = pickingColor[1];
        pickingColorCache[i * 3 + 2] = pickingColor[2];
      }
    }

    attribute.value = pickingColorCache.subarray(0, numInstances * 3);
  }

  _setModelAttributes(model, changedAttributes) {
    const attributeManager = this.getAttributeManager();
    const excludeAttributes = model.userData.excludeAttributes || {};
    const shaderAttributes = attributeManager.getShaderAttributes(changedAttributes, excludeAttributes);
    model.setAttributes(shaderAttributes);
  }

  disablePickingIndex(objectIndex) {
    this._disablePickingIndex(objectIndex);
  }

  _disablePickingIndex(objectIndex) {
    const {
      pickingColors,
      instancePickingColors
    } = this.getAttributeManager().attributes;
    const colors = pickingColors || instancePickingColors;
    const start = colors.getVertexOffset(objectIndex);
    const end = colors.getVertexOffset(objectIndex + 1);
    colors.buffer.subData({
      data: new Uint8Array(end - start),
      offset: start
    });
  }

  restorePickingColors() {
    const {
      pickingColors,
      instancePickingColors
    } = this.getAttributeManager().attributes;
    const colors = pickingColors || instancePickingColors;

    if (this.internalState.usesPickingColorCache && colors.value.buffer !== pickingColorCache.buffer) {
      colors.value = pickingColorCache.subarray(0, colors.value.length);
    }

    colors.updateSubBuffer({
      startOffset: 0
    });
  }

  getNumInstances(props) {
    props = props || this.props;

    if (props.numInstances !== undefined) {
      return props.numInstances;
    }

    if (this.state && this.state.numInstances !== undefined) {
      return this.state.numInstances;
    }

    return count(props.data);
  }

  getStartIndices(props) {
    props = props || this.props;

    if (props.startIndices !== undefined) {
      return props.startIndices;
    }

    if (this.state && this.state.startIndices) {
      return this.state.startIndices;
    }

    return null;
  }

  _initialize() {
    (0,debug/* default */.Z)(TRACE_INITIALIZE, this);

    this._initState();

    this.initializeState(this.context);

    for (const extension of this.props.extensions) {
      extension.initializeState.call(this, this.context, extension);
    }

    this.setChangeFlags({
      dataChanged: true,
      propsChanged: true,
      viewportChanged: true,
      extensionsChanged: true
    });

    this._updateState();
  }

  _update() {
    const stateNeedsUpdate = this.needsUpdate();
    (0,debug/* default */.Z)(TRACE_UPDATE, this, stateNeedsUpdate);

    if (stateNeedsUpdate) {
      this._updateState();
    }
  }

  _updateState() {
    const currentProps = this.props;
    const currentViewport = this.context.viewport;

    const propsInTransition = this._updateUniformTransition();

    this.internalState.propsInTransition = propsInTransition;
    this.context.viewport = this.internalState.viewport || currentViewport;
    this.props = propsInTransition;

    try {
      const updateParams = this._getUpdateParams();

      const oldModels = this.getModels();

      if (this.context.gl) {
        this.updateState(updateParams);
      } else {
        try {
          this.updateState(updateParams);
        } catch (error) {}
      }

      for (const extension of this.props.extensions) {
        extension.updateState.call(this, updateParams, extension);
      }

      const modelChanged = this.getModels()[0] !== oldModels[0];

      this._updateModules(updateParams, modelChanged);

      if (this.isComposite) {
        this._renderLayers(updateParams);
      } else {
        this.setNeedsRedraw();

        this._updateAttributes(this.props);

        if (this.state.model) {
          this.state.model.setInstanceCount(this.getNumInstances());
        }
      }
    } finally {
      this.context.viewport = currentViewport;
      this.props = currentProps;
      this.clearChangeFlags();
      this.internalState.needsUpdate = false;
      this.internalState.resetOldProps();
    }
  }

  _finalize() {
    (0,debug/* default */.Z)(TRACE_FINALIZE, this);
    this.finalizeState(this.context);

    for (const extension of this.props.extensions) {
      extension.finalizeState.call(this, extension);
    }
  }

  drawLayer({
    moduleParameters = null,
    uniforms = {},
    parameters = {}
  }) {
    this._updateAttributeTransition();

    const currentProps = this.props;
    this.props = this.internalState.propsInTransition || currentProps;
    const {
      opacity
    } = this.props;
    uniforms.opacity = Math.pow(opacity, 1 / 2.2);

    try {
      if (moduleParameters) {
        this.setModuleParameters(moduleParameters);
      }

      const {
        getPolygonOffset
      } = this.props;
      const offsets = getPolygonOffset && getPolygonOffset(uniforms) || [0, 0];
      (0,esm/* setParameters */.dR)(this.context.gl, {
        polygonOffset: offsets
      });
      (0,esm/* withParameters */.s8)(this.context.gl, parameters, () => {
        const opts = {
          moduleParameters,
          uniforms,
          parameters,
          context: this.context
        };

        for (const extension of this.props.extensions) {
          extension.draw.call(this, opts, extension);
        }

        this.draw(opts);
      });
    } finally {
      this.props = currentProps;
    }
  }

  getChangeFlags() {
    return this.internalState.changeFlags;
  }

  setChangeFlags(flags) {
    const {
      changeFlags
    } = this.internalState;

    for (const key in flags) {
      if (flags[key]) {
        let flagChanged = false;

        switch (key) {
          case 'dataChanged':
            if (Array.isArray(changeFlags[key])) {
              changeFlags[key] = Array.isArray(flags[key]) ? changeFlags[key].concat(flags[key]) : flags[key];
              flagChanged = true;
            }

          default:
            if (!changeFlags[key]) {
              changeFlags[key] = flags[key];
              flagChanged = true;
            }

        }

        if (flagChanged) {
          (0,debug/* default */.Z)(TRACE_CHANGE_FLAG, this, key, flags);
        }
      }
    }

    const propsOrDataChanged = changeFlags.dataChanged || changeFlags.updateTriggersChanged || changeFlags.propsChanged || changeFlags.extensionsChanged;
    changeFlags.propsOrDataChanged = propsOrDataChanged;
    changeFlags.somethingChanged = propsOrDataChanged || flags.viewportChanged || flags.stateChanged;
  }

  clearChangeFlags() {
    this.internalState.changeFlags = {
      dataChanged: false,
      propsChanged: false,
      updateTriggersChanged: false,
      viewportChanged: false,
      stateChanged: false,
      extensionsChanged: false,
      propsOrDataChanged: false,
      somethingChanged: false
    };
  }

  diffProps(newProps, oldProps) {
    const changeFlags = (0,props/* diffProps */.Yt)(newProps, oldProps);

    if (changeFlags.updateTriggersChanged) {
      for (const key in changeFlags.updateTriggersChanged) {
        if (changeFlags.updateTriggersChanged[key]) {
          this.invalidateAttribute(key);
        }
      }
    }

    if (changeFlags.transitionsChanged) {
      for (const key in changeFlags.transitionsChanged) {
        this.internalState.uniformTransitions.add(key, oldProps[key], newProps[key], newProps.transitions[key]);
      }
    }

    return this.setChangeFlags(changeFlags);
  }

  validateProps() {
    (0,props/* validateProps */.eQ)(this.props);
  }

  setModuleParameters(moduleParameters) {
    for (const model of this.getModels()) {
      model.updateModuleSettings(moduleParameters);
    }
  }

  updateAutoHighlight(info) {
    if (this.props.autoHighlight) {
      this._updateAutoHighlight(info);
    }
  }

  _updateAutoHighlight(info) {
    const pickingModuleParameters = {
      pickingSelectedColor: info.picked ? info.color : null
    };
    const {
      highlightColor
    } = this.props;

    if (info.picked && typeof highlightColor === 'function') {
      pickingModuleParameters.pickingHighlightColor = highlightColor(info);
    }

    this.setModuleParameters(pickingModuleParameters);
    this.setNeedsRedraw();
  }

  _updateModules({
    props,
    oldProps
  }, forceUpdate) {
    const {
      autoHighlight,
      highlightedObjectIndex,
      highlightColor
    } = props;

    if (forceUpdate || oldProps.autoHighlight !== autoHighlight || oldProps.highlightedObjectIndex !== highlightedObjectIndex || oldProps.highlightColor !== highlightColor) {
      const parameters = {};

      if (!autoHighlight) {
        parameters.pickingSelectedColor = null;
      }

      if (Array.isArray(highlightColor)) {
        parameters.pickingHighlightColor = highlightColor;
      }

      if (Number.isInteger(highlightedObjectIndex)) {
        parameters.pickingSelectedColor = highlightedObjectIndex >= 0 ? this.encodePickingColor(highlightedObjectIndex) : null;
      }

      this.setModuleParameters(parameters);
    }
  }

  _getUpdateParams() {
    return {
      props: this.props,
      oldProps: this.internalState.getOldProps(),
      context: this.context,
      changeFlags: this.internalState.changeFlags
    };
  }

  _getNeedsRedraw(opts) {
    if (!this.internalState) {
      return false;
    }

    let redraw = false;
    redraw = redraw || this.internalState.needsRedraw && this.id;
    this.internalState.needsRedraw = this.internalState.needsRedraw && !opts.clearRedrawFlags;
    const attributeManager = this.getAttributeManager();
    const attributeManagerNeedsRedraw = attributeManager && attributeManager.getNeedsRedraw(opts);
    redraw = redraw || attributeManagerNeedsRedraw;
    return redraw;
  }

  _getAttributeManager() {
    return new attribute_manager/* default */.Z(this.context.gl, {
      id: this.props.id,
      stats: this.context.stats,
      timeline: this.context.timeline
    });
  }

  _initState() {
    (0,assert/* default */.Z)(!this.internalState && !this.state);
    (0,assert/* default */.Z)(isFinite(this.props.coordinateSystem));

    const attributeManager = this._getAttributeManager();

    if (attributeManager) {
      attributeManager.addInstanced({
        instancePickingColors: {
          type: 5121,
          size: 3,
          noAlloc: true,
          update: this.calculateInstancePickingColors
        }
      });
    }

    this.internalState = new LayerState({
      attributeManager,
      layer: this
    });
    this.clearChangeFlags();
    this.state = {};
    Object.defineProperty(this.state, 'attributeManager', {
      get: () => {
        log/* default.deprecated */.Z.deprecated('layer.state.attributeManager', 'layer.getAttributeManager()');
        return attributeManager;
      }
    });
    this.internalState.layer = this;
    this.internalState.uniformTransitions = new UniformTransitionManager(this.context.timeline);
    this.internalState.onAsyncPropUpdated = this._onAsyncPropUpdated.bind(this);
    this.internalState.setAsyncProps(this.props);
  }

  _transferState(oldLayer) {
    (0,debug/* default */.Z)(TRACE_MATCHED, this, this === oldLayer);
    const {
      state,
      internalState
    } = oldLayer;

    if (this === oldLayer) {
      return;
    }

    this.internalState = internalState;
    this.internalState.layer = this;
    this.state = state;
    this.internalState.setAsyncProps(this.props);
    this.diffProps(this.props, this.internalState.getOldProps());
  }

  _onAsyncPropUpdated() {
    this.diffProps(this.props, this.internalState.getOldProps());
    this.setNeedsUpdate();
  }

}
Layer.layerName = 'Layer';
Layer.defaultProps = layer_defaultProps;
//# sourceMappingURL=layer.js.map

/***/ }),

/***/ 85409:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "d": () => (/* binding */ LIFECYCLE),
/* harmony export */   "A": () => (/* binding */ PROP_SYMBOLS)
/* harmony export */ });
const LIFECYCLE = {
  NO_STATE: 'Awaiting state',
  MATCHED: 'Matched. State transferred from previous layer',
  INITIALIZED: 'Initialized',
  AWAITING_GC: 'Discarded. Awaiting garbage collection',
  AWAITING_FINALIZATION: 'No longer matched. Awaiting garbage collection',
  FINALIZED: 'Finalized! Awaiting garbage collection'
};
const PROP_SYMBOLS = {
  COMPONENT: Symbol.for('component'),
  ASYNC_DEFAULTS: Symbol.for('asyncPropDefaults'),
  ASYNC_ORIGINAL: Symbol.for('asyncPropOriginal'),
  ASYNC_RESOLVED: Symbol.for('asyncPropResolved')
};
//# sourceMappingURL=constants.js.map

/***/ }),

/***/ 71761:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "eQ": () => (/* binding */ validateProps),
/* harmony export */   "Yt": () => (/* binding */ diffProps),
/* harmony export */   "tg": () => (/* binding */ compareProps)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85409);

const {
  COMPONENT
} = _constants__WEBPACK_IMPORTED_MODULE_0__/* .PROP_SYMBOLS */ .A;
function validateProps(props) {
  const propTypes = getPropTypes(props);

  for (const propName in propTypes) {
    const propType = propTypes[propName];
    const {
      validate
    } = propType;

    if (validate && !validate(props[propName], propType)) {
      throw new Error("Invalid prop ".concat(propName, ": ").concat(props[propName]));
    }
  }
}
function diffProps(props, oldProps) {
  const propsChangedReason = compareProps({
    newProps: props,
    oldProps,
    propTypes: getPropTypes(props),
    ignoreProps: {
      data: null,
      updateTriggers: null,
      extensions: null,
      transitions: null
    }
  });
  const dataChangedReason = diffDataProps(props, oldProps);
  let updateTriggersChangedReason = false;

  if (!dataChangedReason) {
    updateTriggersChangedReason = diffUpdateTriggers(props, oldProps);
  }

  return {
    dataChanged: dataChangedReason,
    propsChanged: propsChangedReason,
    updateTriggersChanged: updateTriggersChangedReason,
    extensionsChanged: diffExtensions(props, oldProps),
    transitionsChanged: diffTransitions(props, oldProps)
  };
}

function diffTransitions(props, oldProps) {
  if (!props.transitions) {
    return null;
  }

  const result = {};
  const propTypes = getPropTypes(props);

  for (const key in props.transitions) {
    const propType = propTypes[key];
    const type = propType && propType.type;
    const isTransitionable = type === 'number' || type === 'color' || type === 'array';

    if (isTransitionable && comparePropValues(props[key], oldProps[key], propType)) {
      result[key] = true;
    }
  }

  return result;
}

function compareProps({
  newProps,
  oldProps,
  ignoreProps = {},
  propTypes = {},
  triggerName = 'props'
} = {}) {
  if (oldProps === newProps) {
    return null;
  }

  if (typeof newProps !== 'object' || newProps === null) {
    return "".concat(triggerName, " changed shallowly");
  }

  if (typeof oldProps !== 'object' || oldProps === null) {
    return "".concat(triggerName, " changed shallowly");
  }

  for (const key of Object.keys(newProps)) {
    if (!(key in ignoreProps)) {
      if (!(key in oldProps)) {
        return "".concat(triggerName, ".").concat(key, " added");
      }

      const changed = comparePropValues(newProps[key], oldProps[key], propTypes[key]);

      if (changed) {
        return "".concat(triggerName, ".").concat(key, " ").concat(changed);
      }
    }
  }

  for (const key of Object.keys(oldProps)) {
    if (!(key in ignoreProps)) {
      if (!(key in newProps)) {
        return "".concat(triggerName, ".").concat(key, " dropped");
      }

      if (!Object.hasOwnProperty.call(newProps, key)) {
        const changed = comparePropValues(newProps[key], oldProps[key], propTypes[key]);

        if (changed) {
          return "".concat(triggerName, ".").concat(key, " ").concat(changed);
        }
      }
    }
  }

  return null;
}

function comparePropValues(newProp, oldProp, propType) {
  let equal = propType && propType.equal;

  if (equal && !equal(newProp, oldProp, propType)) {
    return 'changed deeply';
  }

  if (!equal) {
    equal = newProp && oldProp && newProp.equals;

    if (equal && !equal.call(newProp, oldProp)) {
      return 'changed deeply';
    }
  }

  if (!equal && oldProp !== newProp) {
    return 'changed shallowly';
  }

  return null;
}

function diffDataProps(props, oldProps) {
  if (oldProps === null) {
    return 'oldProps is null, initial diff';
  }

  let dataChanged = null;
  const {
    dataComparator,
    _dataDiff
  } = props;

  if (dataComparator) {
    if (!dataComparator(props.data, oldProps.data)) {
      dataChanged = 'Data comparator detected a change';
    }
  } else if (props.data !== oldProps.data) {
    dataChanged = 'A new data container was supplied';
  }

  if (dataChanged && _dataDiff) {
    dataChanged = _dataDiff(props.data, oldProps.data) || dataChanged;
  }

  return dataChanged;
}

function diffUpdateTriggers(props, oldProps) {
  if (oldProps === null) {
    return 'oldProps is null, initial diff';
  }

  if ('all' in props.updateTriggers) {
    const diffReason = diffUpdateTrigger(props, oldProps, 'all');

    if (diffReason) {
      return {
        all: true
      };
    }
  }

  const triggerChanged = {};
  let reason = false;

  for (const triggerName in props.updateTriggers) {
    if (triggerName !== 'all') {
      const diffReason = diffUpdateTrigger(props, oldProps, triggerName);

      if (diffReason) {
        triggerChanged[triggerName] = true;
        reason = triggerChanged;
      }
    }
  }

  return reason;
}

function diffExtensions(props, oldProps) {
  if (oldProps === null) {
    return 'oldProps is null, initial diff';
  }

  const oldExtensions = oldProps.extensions;
  const {
    extensions
  } = props;

  if (extensions === oldExtensions) {
    return false;
  }

  if (extensions.length !== oldExtensions.length) {
    return true;
  }

  for (let i = 0; i < extensions.length; i++) {
    if (!extensions[i].equals(oldExtensions[i])) {
      return true;
    }
  }

  return false;
}

function diffUpdateTrigger(props, oldProps, triggerName) {
  let newTriggers = props.updateTriggers[triggerName];
  newTriggers = newTriggers === undefined || newTriggers === null ? {} : newTriggers;
  let oldTriggers = oldProps.updateTriggers[triggerName];
  oldTriggers = oldTriggers === undefined || oldTriggers === null ? {} : oldTriggers;
  const diffReason = compareProps({
    oldProps: oldTriggers,
    newProps: newTriggers,
    triggerName
  });
  return diffReason;
}

function getPropTypes(props) {
  const layer = props[COMPONENT];
  const LayerType = layer && layer.constructor;
  return LayerType ? LayerType._propTypes : {};
}
//# sourceMappingURL=props.js.map

/***/ }),

/***/ 51331:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ picking_picking)
});

;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/modules/picking/picking.js
const DEFAULT_HIGHLIGHT_COLOR = new Uint8Array([0, 255, 255, 255]);
const DEFAULT_MODULE_OPTIONS = {
  pickingSelectedColor: null,
  pickingHighlightColor: DEFAULT_HIGHLIGHT_COLOR,
  pickingActive: false,
  pickingAttribute: false
};

function getUniforms(opts = DEFAULT_MODULE_OPTIONS) {
  const uniforms = {};

  if (opts.pickingSelectedColor !== undefined) {
    if (!opts.pickingSelectedColor) {
      uniforms.picking_uSelectedColorValid = 0;
    } else {
      const selectedColor = opts.pickingSelectedColor.slice(0, 3);
      uniforms.picking_uSelectedColorValid = 1;
      uniforms.picking_uSelectedColor = selectedColor;
    }
  }

  if (opts.pickingHighlightColor) {
    const color = Array.from(opts.pickingHighlightColor, x => x / 255);

    if (!Number.isFinite(color[3])) {
      color[3] = 1;
    }

    uniforms.picking_uHighlightColor = color;
  }

  if (opts.pickingActive !== undefined) {
    uniforms.picking_uActive = Boolean(opts.pickingActive);
    uniforms.picking_uAttribute = Boolean(opts.pickingAttribute);
  }

  return uniforms;
}

const vs = "uniform bool picking_uActive;\nuniform bool picking_uAttribute;\nuniform vec3 picking_uSelectedColor;\nuniform bool picking_uSelectedColorValid;\n\nout vec4 picking_vRGBcolor_Avalid;\n\nconst float COLOR_SCALE = 1. / 255.;\n\nbool picking_isColorValid(vec3 color) {\n  return dot(color, vec3(1.0)) > 0.001;\n}\n\nbool isVertexPicked(vec3 vertexColor) {\n  return\n    picking_uSelectedColorValid &&\n    !picking_isColorValid(abs(vertexColor - picking_uSelectedColor));\n}\n\nvoid picking_setPickingColor(vec3 pickingColor) {\n  if (picking_uActive) {\n    picking_vRGBcolor_Avalid.a = float(picking_isColorValid(pickingColor));\n\n    if (!picking_uAttribute) {\n      picking_vRGBcolor_Avalid.rgb = pickingColor * COLOR_SCALE;\n    }\n  } else {\n    picking_vRGBcolor_Avalid.a = float(isVertexPicked(pickingColor));\n  }\n}\n\nvoid picking_setPickingAttribute(float value) {\n  if (picking_uAttribute) {\n    picking_vRGBcolor_Avalid.r = value;\n  }\n}\nvoid picking_setPickingAttribute(vec2 value) {\n  if (picking_uAttribute) {\n    picking_vRGBcolor_Avalid.rg = value;\n  }\n}\nvoid picking_setPickingAttribute(vec3 value) {\n  if (picking_uAttribute) {\n    picking_vRGBcolor_Avalid.rgb = value;\n  }\n}\n";
const fs = "uniform bool picking_uActive;\nuniform vec3 picking_uSelectedColor;\nuniform vec4 picking_uHighlightColor;\n\nin vec4 picking_vRGBcolor_Avalid;\nvec4 picking_filterHighlightColor(vec4 color) {\n  if (picking_uActive) {\n    return color;\n  }\n  bool selected = bool(picking_vRGBcolor_Avalid.a);\n\n  if (selected) {\n    float highLightAlpha = picking_uHighlightColor.a;\n    float blendedAlpha = highLightAlpha + color.a * (1.0 - highLightAlpha);\n    float highLightRatio = highLightAlpha / blendedAlpha;\n\n    vec3 blendedRGB = mix(color.rgb, picking_uHighlightColor.rgb, highLightRatio);\n    return vec4(blendedRGB, blendedAlpha);\n  } else {\n    return color;\n  }\n}\nvec4 picking_filterPickingColor(vec4 color) {\n  if (picking_uActive) {\n    if (picking_vRGBcolor_Avalid.a == 0.0) {\n      discard;\n    }\n    return picking_vRGBcolor_Avalid;\n  }\n  return color;\n}\nvec4 picking_filterColor(vec4 color) {\n  vec4 highightColor = picking_filterHighlightColor(color);\n  return picking_filterPickingColor(highightColor);\n}\n\n";
const picking = {
  name: 'picking',
  vs,
  fs,
  getUniforms
};
//# sourceMappingURL=picking.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/shaderlib/picking/picking.js

/* harmony default export */ const picking_picking = ({
  inject: {
    'vs:DECKGL_FILTER_COLOR': "\n  picking_setPickingColor(geometry.pickingColor);\n  // for picking depth values\n  picking_setPickingAttribute(geometry.position.z);\n  ",
    'fs:DECKGL_FILTER_COLOR': {
      order: 99,
      injection: "\n  // use highlight color if this fragment belongs to the selected object.\n  color = picking_filterHighlightColor(color);\n\n  // use picking color if rendering to picking FBO.\n  color = picking_filterPickingColor(color);\n    "
    }
  },
  ...picking
});
//# sourceMappingURL=picking.js.map

/***/ }),

/***/ 68020:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ project)
});

;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/modules/fp32/fp32.js
const fp32shader = "#ifdef LUMA_FP32_TAN_PRECISION_WORKAROUND\nconst float TWO_PI = 6.2831854820251465;\nconst float PI_2 = 1.5707963705062866;\nconst float PI_16 = 0.1963495463132858;\n\nconst float SIN_TABLE_0 = 0.19509032368659973;\nconst float SIN_TABLE_1 = 0.3826834261417389;\nconst float SIN_TABLE_2 = 0.5555702447891235;\nconst float SIN_TABLE_3 = 0.7071067690849304;\n\nconst float COS_TABLE_0 = 0.9807852506637573;\nconst float COS_TABLE_1 = 0.9238795042037964;\nconst float COS_TABLE_2 = 0.8314695954322815;\nconst float COS_TABLE_3 = 0.7071067690849304;\n\nconst float INVERSE_FACTORIAL_3 = 1.666666716337204e-01;\nconst float INVERSE_FACTORIAL_5 = 8.333333767950535e-03;\nconst float INVERSE_FACTORIAL_7 = 1.9841270113829523e-04;\nconst float INVERSE_FACTORIAL_9 = 2.75573188446287533e-06;\n\nfloat sin_taylor_fp32(float a) {\n  float r, s, t, x;\n\n  if (a == 0.0) {\n    return 0.0;\n  }\n\n  x = -a * a;\n  s = a;\n  r = a;\n\n  r = r * x;\n  t = r * INVERSE_FACTORIAL_3;\n  s = s + t;\n\n  r = r * x;\n  t = r * INVERSE_FACTORIAL_5;\n  s = s + t;\n\n  r = r * x;\n  t = r * INVERSE_FACTORIAL_7;\n  s = s + t;\n\n  r = r * x;\n  t = r * INVERSE_FACTORIAL_9;\n  s = s + t;\n\n  return s;\n}\n\nvoid sincos_taylor_fp32(float a, out float sin_t, out float cos_t) {\n  if (a == 0.0) {\n    sin_t = 0.0;\n    cos_t = 1.0;\n  }\n  sin_t = sin_taylor_fp32(a);\n  cos_t = sqrt(1.0 - sin_t * sin_t);\n}\n\nfloat tan_taylor_fp32(float a) {\n    float sin_a;\n    float cos_a;\n\n    if (a == 0.0) {\n        return 0.0;\n    }\n    float z = floor(a / TWO_PI);\n    float r = a - TWO_PI * z;\n\n    float t;\n    float q = floor(r / PI_2 + 0.5);\n    int j = int(q);\n\n    if (j < -2 || j > 2) {\n        return 0.0 / 0.0;\n    }\n\n    t = r - PI_2 * q;\n\n    q = floor(t / PI_16 + 0.5);\n    int k = int(q);\n    int abs_k = int(abs(float(k)));\n\n    if (abs_k > 4) {\n        return 0.0 / 0.0;\n    } else {\n        t = t - PI_16 * q;\n    }\n\n    float u = 0.0;\n    float v = 0.0;\n\n    float sin_t, cos_t;\n    float s, c;\n    sincos_taylor_fp32(t, sin_t, cos_t);\n\n    if (k == 0) {\n        s = sin_t;\n        c = cos_t;\n    } else {\n        if (abs(float(abs_k) - 1.0) < 0.5) {\n            u = COS_TABLE_0;\n            v = SIN_TABLE_0;\n        } else if (abs(float(abs_k) - 2.0) < 0.5) {\n            u = COS_TABLE_1;\n            v = SIN_TABLE_1;\n        } else if (abs(float(abs_k) - 3.0) < 0.5) {\n            u = COS_TABLE_2;\n            v = SIN_TABLE_2;\n        } else if (abs(float(abs_k) - 4.0) < 0.5) {\n            u = COS_TABLE_3;\n            v = SIN_TABLE_3;\n        }\n        if (k > 0) {\n            s = u * sin_t + v * cos_t;\n            c = u * cos_t - v * sin_t;\n        } else {\n            s = u * sin_t - v * cos_t;\n            c = u * cos_t + v * sin_t;\n        }\n    }\n\n    if (j == 0) {\n        sin_a = s;\n        cos_a = c;\n    } else if (j == 1) {\n        sin_a = c;\n        cos_a = -s;\n    } else if (j == -1) {\n        sin_a = -c;\n        cos_a = s;\n    } else {\n        sin_a = -s;\n        cos_a = -c;\n    }\n    return sin_a / cos_a;\n}\n#endif\n\nfloat tan_fp32(float a) {\n#ifdef LUMA_FP32_TAN_PRECISION_WORKAROUND\n  return tan_taylor_fp32(a);\n#else\n  return tan(a);\n#endif\n}\n";
const fp32 = {
  name: 'fp32',
  vs: fp32shader,
  fs: null
};
//# sourceMappingURL=fp32.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/constants.js
var constants = __webpack_require__(24088);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.glsl.js

const COORDINATE_SYSTEM_GLSL_CONSTANTS = Object.keys(constants/* COORDINATE_SYSTEM */.Df).map(key => "const int COORDINATE_SYSTEM_".concat(key, " = ").concat(constants/* COORDINATE_SYSTEM */.Df[key], ";")).join('');
const PROJECTION_MODE_GLSL_CONSTANTS = Object.keys(constants/* PROJECTION_MODE */.zG).map(key => "const int PROJECTION_MODE_".concat(key, " = ").concat(constants/* PROJECTION_MODE */.zG[key], ";")).join('');
/* harmony default export */ const project_glsl = ("".concat(COORDINATE_SYSTEM_GLSL_CONSTANTS, "\n").concat(PROJECTION_MODE_GLSL_CONSTANTS, "\n\nuniform int project_uCoordinateSystem;\nuniform int project_uProjectionMode;\nuniform float project_uScale;\nuniform bool project_uWrapLongitude;\nuniform vec3 project_uCommonUnitsPerMeter;\nuniform vec3 project_uCommonUnitsPerWorldUnit;\nuniform vec3 project_uCommonUnitsPerWorldUnit2;\nuniform vec4 project_uCenter;\nuniform mat4 project_uModelMatrix;\nuniform mat4 project_uViewProjectionMatrix;\nuniform vec2 project_uViewportSize;\nuniform float project_uDevicePixelRatio;\nuniform float project_uFocalDistance;\nuniform vec3 project_uCameraPosition;\nuniform vec3 project_uCoordinateOrigin;\n\nconst float TILE_SIZE = 512.0;\nconst float PI = 3.1415926536;\nconst float WORLD_SCALE = TILE_SIZE / (PI * 2.0);\nconst vec3 ZERO_64_LOW = vec3(0.0);\nconst float EARTH_RADIUS = 6370972.0;\nconst float GLOBE_RADIUS = 256.0;\nfloat project_size(float meters) {\n  return meters * project_uCommonUnitsPerMeter.z;\n}\n\nvec2 project_size(vec2 meters) {\n  return meters * project_uCommonUnitsPerMeter.xy;\n}\n\nvec3 project_size(vec3 meters) {\n  return meters * project_uCommonUnitsPerMeter;\n}\n\nvec4 project_size(vec4 meters) {\n  return vec4(meters.xyz * project_uCommonUnitsPerMeter, meters.w);\n}\nvec3 project_normal(vec3 vector) {\n  vec4 normal_modelspace = project_uModelMatrix * vec4(vector, 0.0);\n  return normalize(normal_modelspace.xyz * project_uCommonUnitsPerMeter);\n}\n\nvec4 project_offset_(vec4 offset) {\n  float dy = offset.y;\n  if (project_uCoordinateSystem == COORDINATE_SYSTEM_LNGLAT) {\n    dy = clamp(dy, -1., 1.);\n  }\n  vec3 commonUnitsPerWorldUnit = project_uCommonUnitsPerWorldUnit + project_uCommonUnitsPerWorldUnit2 * dy;\n  return vec4(offset.xyz * commonUnitsPerWorldUnit, offset.w);\n}\nvec2 project_mercator_(vec2 lnglat) {\n  float x = lnglat.x;\n  if (project_uWrapLongitude) {\n    x = mod(x + 180., 360.0) - 180.;\n  }\n  float y = clamp(lnglat.y, -89.9, 89.9);\n  return vec2(\n    radians(x) + PI,\n    PI + log(tan_fp32(PI * 0.25 + radians(y) * 0.5))\n  );\n}\n\nvec3 project_globe_(vec3 lnglatz) {\n  float lambda = radians(lnglatz.x);\n  float phi = radians(lnglatz.y);\n  float cosPhi = cos(phi);\n  float D = (lnglatz.z / EARTH_RADIUS + 1.0) * GLOBE_RADIUS;\n\n  return vec3(\n    sin(lambda) * cosPhi,\n    -cos(lambda) * cosPhi,\n    sin(phi)\n  ) * D;\n}\nvec4 project_position(vec4 position, vec3 position64Low) {\n  vec4 position_world = project_uModelMatrix * position;\n  if (project_uProjectionMode == PROJECTION_MODE_WEB_MERCATOR) {\n    if (project_uCoordinateSystem == COORDINATE_SYSTEM_LNGLAT) {\n      return vec4(\n        project_mercator_(position_world.xy) * WORLD_SCALE,\n        project_size(position_world.z),\n        position_world.w\n      );\n    }\n    if (project_uCoordinateSystem == COORDINATE_SYSTEM_CARTESIAN) {\n      position_world.xyz += project_uCoordinateOrigin;\n    }\n  }\n  if (project_uProjectionMode == PROJECTION_MODE_GLOBE) {\n    if (project_uCoordinateSystem == COORDINATE_SYSTEM_LNGLAT) {\n      return vec4(\n        project_globe_(position_world.xyz),\n        position_world.w\n      );\n    }\n  }\n  if (project_uProjectionMode == PROJECTION_MODE_IDENTITY ||\n    (project_uProjectionMode == PROJECTION_MODE_WEB_MERCATOR_AUTO_OFFSET &&\n    (project_uCoordinateSystem == COORDINATE_SYSTEM_LNGLAT ||\n     project_uCoordinateSystem == COORDINATE_SYSTEM_CARTESIAN))) {\n    position_world.xyz -= project_uCoordinateOrigin;\n  }\n  return project_offset_(position_world + project_uModelMatrix * vec4(position64Low, 0.0));\n}\n\nvec4 project_position(vec4 position) {\n  return project_position(position, ZERO_64_LOW);\n}\n\nvec3 project_position(vec3 position, vec3 position64Low) {\n  vec4 projected_position = project_position(vec4(position, 1.0), position64Low);\n  return projected_position.xyz;\n}\n\nvec3 project_position(vec3 position) {\n  vec4 projected_position = project_position(vec4(position, 1.0), ZERO_64_LOW);\n  return projected_position.xyz;\n}\n\nvec2 project_position(vec2 position) {\n  vec4 projected_position = project_position(vec4(position, 0.0, 1.0), ZERO_64_LOW);\n  return projected_position.xy;\n}\n\nvec4 project_common_position_to_clipspace(vec4 position, mat4 viewProjectionMatrix, vec4 center) {\n  return viewProjectionMatrix * position + center;\n}\nvec4 project_common_position_to_clipspace(vec4 position) {\n  return project_common_position_to_clipspace(position, project_uViewProjectionMatrix, project_uCenter);\n}\nvec2 project_pixel_size_to_clipspace(vec2 pixels) {\n  vec2 offset = pixels / project_uViewportSize * project_uDevicePixelRatio * 2.0;\n  return offset * project_uFocalDistance;\n}\n\nfloat project_size_to_pixel(float meters) {\n  return project_size(meters) * project_uScale;\n}\nfloat project_pixel_size(float pixels) {\n  return pixels / project_uScale;\n}\nvec2 project_pixel_size(vec2 pixels) {\n  return pixels / project_uScale;\n}\nmat3 project_get_orientation_matrix(vec3 up) {\n  vec3 uz = normalize(up);\n  vec3 ux = abs(uz.z) == 1.0 ? vec3(1.0, 0.0, 0.0) : normalize(vec3(uz.y, -uz.x, 0));\n  vec3 uy = cross(uz, ux);\n  return mat3(ux, uy, uz);\n}\n\nbool project_needs_rotation(vec3 commonPosition, out mat3 transform) {\n  if (project_uProjectionMode == PROJECTION_MODE_GLOBE) {\n    transform = project_get_orientation_matrix(commonPosition);\n    return true;\n  }\n  return false;\n}\n"));
//# sourceMappingURL=project.glsl.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/shaderlib/project/viewport-uniforms.js
var viewport_uniforms = __webpack_require__(8771);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.js



const INITIAL_MODULE_OPTIONS = {};

function getUniforms(opts = INITIAL_MODULE_OPTIONS) {
  if (opts.viewport) {
    return (0,viewport_uniforms/* getUniformsFromViewport */.C)(opts);
  }

  return {};
}

/* harmony default export */ const project = ({
  name: 'project',
  dependencies: [fp32],
  vs: project_glsl,
  getUniforms
});
//# sourceMappingURL=project.js.map

/***/ }),

/***/ 8771:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "v": () => (/* binding */ getOffsetOrigin),
/* harmony export */   "C": () => (/* binding */ getUniformsFromViewport)
/* harmony export */ });
/* harmony import */ var gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85975);
/* harmony import */ var gl_matrix_vec4__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7778);
/* harmony import */ var _lib_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(24088);
/* harmony import */ var _utils_memoize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(88177);




const ZERO_VECTOR = [0, 0, 0, 0];
const VECTOR_TO_POINT_MATRIX = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0];
const IDENTITY_MATRIX = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
const DEFAULT_PIXELS_PER_UNIT2 = [0, 0, 0];
const DEFAULT_COORDINATE_ORIGIN = [0, 0, 0];
const getMemoizedViewportUniforms = (0,_utils_memoize__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)(calculateViewportUniforms);
function getOffsetOrigin(viewport, coordinateSystem, coordinateOrigin = DEFAULT_COORDINATE_ORIGIN) {
  let shaderCoordinateOrigin = coordinateOrigin;
  let geospatialOrigin;
  let offsetMode = true;

  if (coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.LNGLAT_OFFSETS */ .Df.LNGLAT_OFFSETS || coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.METER_OFFSETS */ .Df.METER_OFFSETS) {
    geospatialOrigin = coordinateOrigin;
  } else {
    geospatialOrigin = viewport.isGeospatial ? [Math.fround(viewport.longitude), Math.fround(viewport.latitude), 0] : null;
  }

  switch (viewport.projectionMode) {
    case _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .PROJECTION_MODE.WEB_MERCATOR */ .zG.WEB_MERCATOR:
      if (coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.LNGLAT */ .Df.LNGLAT || coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.CARTESIAN */ .Df.CARTESIAN) {
        offsetMode = false;
      }

      break;

    case _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .PROJECTION_MODE.WEB_MERCATOR_AUTO_OFFSET */ .zG.WEB_MERCATOR_AUTO_OFFSET:
      if (coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.LNGLAT */ .Df.LNGLAT) {
        shaderCoordinateOrigin = geospatialOrigin;
      } else if (coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.CARTESIAN */ .Df.CARTESIAN) {
        shaderCoordinateOrigin = [Math.fround(viewport.center[0]), Math.fround(viewport.center[1]), 0];
        geospatialOrigin = viewport.unprojectPosition(shaderCoordinateOrigin);
        shaderCoordinateOrigin[0] -= coordinateOrigin[0];
        shaderCoordinateOrigin[1] -= coordinateOrigin[1];
        shaderCoordinateOrigin[2] -= coordinateOrigin[2];
      }

      break;

    case _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .PROJECTION_MODE.IDENTITY */ .zG.IDENTITY:
      shaderCoordinateOrigin = viewport.position.map(Math.fround);
      break;

    case _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .PROJECTION_MODE.GLOBE */ .zG.GLOBE:
      offsetMode = false;
      geospatialOrigin = null;
      break;

    default:
      offsetMode = false;
  }

  shaderCoordinateOrigin[2] = shaderCoordinateOrigin[2] || 0;
  return {
    geospatialOrigin,
    shaderCoordinateOrigin,
    offsetMode
  };
}

function calculateMatrixAndOffset(viewport, coordinateSystem, coordinateOrigin) {
  const {
    viewMatrixUncentered,
    projectionMatrix
  } = viewport;
  let {
    viewMatrix,
    viewProjectionMatrix
  } = viewport;
  let projectionCenter = ZERO_VECTOR;
  let cameraPosCommon = viewport.cameraPosition;
  const {
    geospatialOrigin,
    shaderCoordinateOrigin,
    offsetMode
  } = getOffsetOrigin(viewport, coordinateSystem, coordinateOrigin);

  if (offsetMode) {
    const positionCommonSpace = viewport.projectPosition(geospatialOrigin || shaderCoordinateOrigin);
    cameraPosCommon = [cameraPosCommon[0] - positionCommonSpace[0], cameraPosCommon[1] - positionCommonSpace[1], cameraPosCommon[2] - positionCommonSpace[2]];
    positionCommonSpace[3] = 1;
    projectionCenter = gl_matrix_vec4__WEBPACK_IMPORTED_MODULE_2__/* .transformMat4 */ .fF([], positionCommonSpace, viewProjectionMatrix);
    viewMatrix = viewMatrixUncentered || viewMatrix;
    viewProjectionMatrix = gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_3__/* .multiply */ .Jp([], projectionMatrix, viewMatrix);
    viewProjectionMatrix = gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_3__/* .multiply */ .Jp([], viewProjectionMatrix, VECTOR_TO_POINT_MATRIX);
  }

  return {
    viewMatrix,
    viewProjectionMatrix,
    projectionCenter,
    cameraPosCommon,
    shaderCoordinateOrigin,
    geospatialOrigin
  };
}

function getUniformsFromViewport({
  viewport,
  devicePixelRatio = 1,
  modelMatrix = null,
  coordinateSystem = _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.DEFAULT */ .Df.DEFAULT,
  coordinateOrigin,
  autoWrapLongitude = false
} = {}) {
  if (coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.DEFAULT */ .Df.DEFAULT) {
    coordinateSystem = viewport.isGeospatial ? _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.LNGLAT */ .Df.LNGLAT : _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.CARTESIAN */ .Df.CARTESIAN;
  }

  const uniforms = getMemoizedViewportUniforms({
    viewport,
    devicePixelRatio,
    coordinateSystem,
    coordinateOrigin
  });
  uniforms.project_uWrapLongitude = autoWrapLongitude;
  uniforms.project_uModelMatrix = modelMatrix || IDENTITY_MATRIX;
  return uniforms;
}

function calculateViewportUniforms({
  viewport,
  devicePixelRatio,
  coordinateSystem,
  coordinateOrigin
}) {
  const {
    projectionCenter,
    viewProjectionMatrix,
    cameraPosCommon,
    shaderCoordinateOrigin,
    geospatialOrigin
  } = calculateMatrixAndOffset(viewport, coordinateSystem, coordinateOrigin);
  const distanceScales = viewport.getDistanceScales();
  const viewportSize = [viewport.width * devicePixelRatio, viewport.height * devicePixelRatio];
  const focalDistance = viewport.projectionMatrix.transform([0, 0, -viewport.focalDistance, 1])[3] || 1;
  const uniforms = {
    project_uCoordinateSystem: coordinateSystem,
    project_uProjectionMode: viewport.projectionMode,
    project_uCoordinateOrigin: shaderCoordinateOrigin,
    project_uCenter: projectionCenter,
    project_uViewportSize: viewportSize,
    project_uDevicePixelRatio: devicePixelRatio,
    project_uFocalDistance: focalDistance,
    project_uCommonUnitsPerMeter: distanceScales.unitsPerMeter,
    project_uCommonUnitsPerWorldUnit: distanceScales.unitsPerMeter,
    project_uCommonUnitsPerWorldUnit2: DEFAULT_PIXELS_PER_UNIT2,
    project_uScale: viewport.scale,
    project_uViewProjectionMatrix: viewProjectionMatrix,
    project_uCameraPosition: cameraPosCommon
  };

  if (geospatialOrigin) {
    const distanceScalesAtOrigin = viewport.getDistanceScales(geospatialOrigin);

    switch (coordinateSystem) {
      case _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.METER_OFFSETS */ .Df.METER_OFFSETS:
        uniforms.project_uCommonUnitsPerWorldUnit = distanceScalesAtOrigin.unitsPerMeter;
        uniforms.project_uCommonUnitsPerWorldUnit2 = distanceScalesAtOrigin.unitsPerMeter2;
        break;

      case _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.LNGLAT */ .Df.LNGLAT:
      case _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.LNGLAT_OFFSETS */ .Df.LNGLAT_OFFSETS:
        uniforms.project_uCommonUnitsPerWorldUnit = distanceScalesAtOrigin.unitsPerDegree;
        uniforms.project_uCommonUnitsPerWorldUnit2 = distanceScalesAtOrigin.unitsPerDegree2;
        break;

      case _lib_constants__WEBPACK_IMPORTED_MODULE_1__/* .COORDINATE_SYSTEM.CARTESIAN */ .Df.CARTESIAN:
        uniforms.project_uCommonUnitsPerWorldUnit = [1, 1, distanceScalesAtOrigin.unitsPerMeter[2]];
        uniforms.project_uCommonUnitsPerWorldUnit2 = [0, 0, distanceScalesAtOrigin.unitsPerMeter2[2]];
        break;

      default:
        break;
    }
  }

  return uniforms;
}
//# sourceMappingURL=viewport-uniforms.js.map

/***/ }),

/***/ 93844:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _project_project__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(68020);

const vs = "\nvec4 project_position_to_clipspace(\n  vec3 position, vec3 position64Low, vec3 offset, out vec4 commonPosition\n) {\n  vec3 projectedPosition = project_position(position, position64Low);\n  if (project_uProjectionMode == PROJECTION_MODE_GLOBE) {\n    // offset is specified as ENU\n    // when in globe projection, rotate offset so that the ground alighs with the surface of the globe\n    mat3 rotation = project_get_orientation_matrix(projectedPosition);\n    offset = rotation * offset;\n  }\n  commonPosition = vec4(projectedPosition + offset, 1.0);\n  return project_common_position_to_clipspace(commonPosition);\n}\n\nvec4 project_position_to_clipspace(\n  vec3 position, vec3 position64Low, vec3 offset\n) {\n  vec4 commonPosition;\n  return project_position_to_clipspace(position, position64Low, offset, commonPosition);\n}\n";
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'project32',
  dependencies: [_project_project__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z],
  vs
});
//# sourceMappingURL=project32.js.map

/***/ }),

/***/ 26395:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Transition)
/* harmony export */ });
function noop() {}

const DEFAULT_SETTINGS = {
  onStart: noop,
  onUpdate: noop,
  onInterrupt: noop,
  onEnd: noop
};
class Transition {
  constructor(timeline) {
    this._inProgress = false;
    this._handle = null;
    this.timeline = timeline;
    this.settings = {};
  }

  get inProgress() {
    return this._inProgress;
  }

  start(props) {
    this.cancel();
    this.settings = { ...DEFAULT_SETTINGS,
      ...props
    };
    this._inProgress = true;
    this.settings.onStart(this);
  }

  end() {
    if (this._inProgress) {
      this.timeline.removeChannel(this._handle);
      this._handle = null;
      this._inProgress = false;
      this.settings.onEnd(this);
    }
  }

  cancel() {
    if (this._inProgress) {
      this.settings.onInterrupt(this);
      this.timeline.removeChannel(this._handle);
      this._handle = null;
      this._inProgress = false;
    }
  }

  update() {
    if (!this._inProgress) {
      return false;
    }

    if (this._handle === null) {
      const {
        timeline,
        settings
      } = this;
      this._handle = timeline.addChannel({
        delay: timeline.getTime(),
        duration: settings.duration
      });
    }

    this.time = this.timeline.getTime(this._handle);

    this._onUpdate();

    this.settings.onUpdate(this);

    if (this.timeline.isFinished(this._handle)) {
      this.end();
    }

    return true;
  }

  _onUpdate() {}

}
//# sourceMappingURL=transition.js.map

/***/ }),

/***/ 75304:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ assert)
/* harmony export */ });
function assert(condition, message) {
  if (!condition) {
    throw new Error(message || 'deck.gl: assertion failed.');
  }
}
//# sourceMappingURL=assert.js.map

/***/ }),

/***/ 61855:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "x": () => (/* binding */ flatten),
/* harmony export */   "k": () => (/* binding */ fillArray)
/* harmony export */ });
function flatten(array, filter = () => true) {
  if (!Array.isArray(array)) {
    return filter(array) ? [array] : [];
  }

  return flattenArray(array, filter, []);
}

function flattenArray(array, filter, result) {
  let index = -1;

  while (++index < array.length) {
    const value = array[index];

    if (Array.isArray(value)) {
      flattenArray(value, filter, result);
    } else if (filter(value)) {
      result.push(value);
    }
  }

  return result;
}

function fillArray({
  target,
  source,
  start = 0,
  count = 1
}) {
  const length = source.length;
  const total = count * length;
  let copied = 0;

  for (let i = start; copied < length; copied++) {
    target[i++] = source[copied];
  }

  while (copied < total) {
    if (copied < total - copied) {
      target.copyWithin(start + copied, start, start + copied);
      copied *= 2;
    } else {
      target.copyWithin(start + copied, start, start + total - copied);
      copied = total;
    }
  }

  return target;
}
//# sourceMappingURL=flatten.js.map

/***/ }),

/***/ 38550:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "jB": () => (/* binding */ createIterable),
/* harmony export */   "D0": () => (/* binding */ isAsyncIterable),
/* harmony export */   "jr": () => (/* binding */ getAccessorFromBuffer)
/* harmony export */ });
const EMPTY_ARRAY = [];
const placeholderArray = [];
function createIterable(data, startRow = 0, endRow = Infinity) {
  let iterable = EMPTY_ARRAY;
  const objectInfo = {
    index: -1,
    data,
    target: []
  };

  if (!data) {
    iterable = EMPTY_ARRAY;
  } else if (typeof data[Symbol.iterator] === 'function') {
    iterable = data;
  } else if (data.length > 0) {
    placeholderArray.length = data.length;
    iterable = placeholderArray;
  }

  if (startRow > 0 || Number.isFinite(endRow)) {
    iterable = (Array.isArray(iterable) ? iterable : Array.from(iterable)).slice(startRow, endRow);
    objectInfo.index = startRow - 1;
  }

  return {
    iterable,
    objectInfo
  };
}
function isAsyncIterable(data) {
  return data && data[Symbol.asyncIterator];
}
function getAccessorFromBuffer(typedArray, {
  size,
  stride,
  offset,
  startIndices,
  nested
}) {
  const bytesPerElement = typedArray.BYTES_PER_ELEMENT;
  const elementStride = stride ? stride / bytesPerElement : size;
  const elementOffset = offset ? offset / bytesPerElement : 0;
  const vertexCount = Math.floor((typedArray.length - elementOffset) / elementStride);
  return (_, {
    index,
    target
  }) => {
    if (!startIndices) {
      const sourceIndex = index * elementStride + elementOffset;

      for (let j = 0; j < size; j++) {
        target[j] = typedArray[sourceIndex + j];
      }

      return target;
    }

    const startIndex = startIndices[index];
    const endIndex = startIndices[index + 1] || vertexCount;
    let result;

    if (nested) {
      result = new Array(endIndex - startIndex);

      for (let i = startIndex; i < endIndex; i++) {
        const sourceIndex = i * elementStride + elementOffset;
        target = new Array(size);

        for (let j = 0; j < size; j++) {
          target[j] = typedArray[sourceIndex + j];
        }

        result[i - startIndex] = target;
      }
    } else if (elementStride === size) {
      result = typedArray.subarray(startIndex * size + elementOffset, endIndex * size + elementOffset);
    } else {
      result = new typedArray.constructor((endIndex - startIndex) * size);
      let targetIndex = 0;

      for (let i = startIndex; i < endIndex; i++) {
        const sourceIndex = i * elementStride + elementOffset;

        for (let j = 0; j < size; j++) {
          result[targetIndex++] = typedArray[sourceIndex + j];
        }
      }
    }

    return result;
  };
}
//# sourceMappingURL=iterable-utils.js.map

/***/ }),

/***/ 80744:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var probe_gl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44708);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (new probe_gl__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z({
  id: 'deck'
}));
//# sourceMappingURL=log.js.map

/***/ }),

/***/ 75126:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "bS": () => (/* binding */ createMat4),
/* harmony export */   "Xt": () => (/* binding */ getCameraPosition),
/* harmony export */   "Du": () => (/* binding */ getFrustumPlanes),
/* harmony export */   "Ks": () => (/* binding */ fp64LowPart),
/* harmony export */   "TK": () => (/* binding */ toDoublePrecisionArray)
/* harmony export */ });
/* unused harmony export mod */
/* harmony import */ var _typed_array_manager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36610);
/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(51681);


function createMat4() {
  return [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
}
function mod(value, divisor) {
  const modulus = value % divisor;
  return modulus < 0 ? divisor + modulus : modulus;
}
function getCameraPosition(viewMatrixInverse) {
  return [viewMatrixInverse[12], viewMatrixInverse[13], viewMatrixInverse[14]];
}
function getFrustumPlanes(viewProjectionMatrix) {
  const planes = {};
  planes.left = getFrustumPlane(viewProjectionMatrix[3] + viewProjectionMatrix[0], viewProjectionMatrix[7] + viewProjectionMatrix[4], viewProjectionMatrix[11] + viewProjectionMatrix[8], viewProjectionMatrix[15] + viewProjectionMatrix[12]);
  planes.right = getFrustumPlane(viewProjectionMatrix[3] - viewProjectionMatrix[0], viewProjectionMatrix[7] - viewProjectionMatrix[4], viewProjectionMatrix[11] - viewProjectionMatrix[8], viewProjectionMatrix[15] - viewProjectionMatrix[12]);
  planes.bottom = getFrustumPlane(viewProjectionMatrix[3] + viewProjectionMatrix[1], viewProjectionMatrix[7] + viewProjectionMatrix[5], viewProjectionMatrix[11] + viewProjectionMatrix[9], viewProjectionMatrix[15] + viewProjectionMatrix[13]);
  planes.top = getFrustumPlane(viewProjectionMatrix[3] - viewProjectionMatrix[1], viewProjectionMatrix[7] - viewProjectionMatrix[5], viewProjectionMatrix[11] - viewProjectionMatrix[9], viewProjectionMatrix[15] - viewProjectionMatrix[13]);
  planes.near = getFrustumPlane(viewProjectionMatrix[3] + viewProjectionMatrix[2], viewProjectionMatrix[7] + viewProjectionMatrix[6], viewProjectionMatrix[11] + viewProjectionMatrix[10], viewProjectionMatrix[15] + viewProjectionMatrix[14]);
  planes.far = getFrustumPlane(viewProjectionMatrix[3] - viewProjectionMatrix[2], viewProjectionMatrix[7] - viewProjectionMatrix[6], viewProjectionMatrix[11] - viewProjectionMatrix[10], viewProjectionMatrix[15] - viewProjectionMatrix[14]);
  return planes;
}
const scratchVector = new math_gl__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z();

function getFrustumPlane(a, b, c, d) {
  scratchVector.set(a, b, c);
  const L = scratchVector.len();
  return {
    distance: d / L,
    normal: new math_gl__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z(-a / L, -b / L, -c / L)
  };
}

function fp64LowPart(x) {
  return x - Math.fround(x);
}
let scratchArray;
function toDoublePrecisionArray(typedArray, {
  size = 1,
  startIndex = 0,
  endIndex
}) {
  if (!Number.isFinite(endIndex)) {
    endIndex = typedArray.length;
  }

  const count = (endIndex - startIndex) / size;
  scratchArray = _typed_array_manager__WEBPACK_IMPORTED_MODULE_1__/* ["default"].allocate */ .Z.allocate(scratchArray, count, {
    type: Float32Array,
    size: size * 2
  });
  let sourceIndex = startIndex;
  let targetIndex = 0;

  while (sourceIndex < endIndex) {
    for (let j = 0; j < size; j++) {
      const value = typedArray[sourceIndex++];
      scratchArray[targetIndex + j] = value;
      scratchArray[targetIndex + j + size] = fp64LowPart(value);
    }

    targetIndex += size * 2;
  }

  return scratchArray.subarray(0, count * size * 2);
}
//# sourceMappingURL=math-utils.js.map

/***/ }),

/***/ 88177:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ memoize)
/* harmony export */ });
function isEqual(a, b) {
  if (a === b) {
    return true;
  }

  if (Array.isArray(a)) {
    const len = a.length;

    if (!b || b.length !== len) {
      return false;
    }

    for (let i = 0; i < len; i++) {
      if (a[i] !== b[i]) {
        return false;
      }
    }

    return true;
  }

  return false;
}

function memoize(compute) {
  let cachedArgs = {};
  let cachedResult;
  return args => {
    for (const key in args) {
      if (!isEqual(args[key], cachedArgs[key])) {
        cachedResult = compute(args);
        cachedArgs = args;
        break;
      }
    }

    return cachedResult;
  };
}
//# sourceMappingURL=memoize.js.map

/***/ }),

/***/ 27870:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "l": () => (/* binding */ mergeShaders)
/* harmony export */ });
function mergeShaders(target, source) {
  if (!source) {
    return target;
  }

  const result = { ...target,
    ...source
  };

  if ('defines' in source) {
    result.defines = { ...target.defines,
      ...source.defines
    };
  }

  if ('modules' in source) {
    result.modules = (target.modules || []).concat(source.modules);

    if (source.modules.some(module => module.name === 'project64')) {
      const index = result.modules.findIndex(module => module.name === 'project32');

      if (index >= 0) {
        result.modules.splice(index, 1);
      }
    }
  }

  if ('inject' in source) {
    if (!target.inject) {
      result.inject = source.inject;
    } else {
      const mergedInjection = { ...target.inject
      };

      for (const key in source.inject) {
        mergedInjection[key] = (mergedInjection[key] || '') + source.inject[key];
      }

      result.inject = mergedInjection;
    }
  }

  return result;
}
//# sourceMappingURL=shader.js.map

/***/ }),

/***/ 36610:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export TypedArrayManager */
class TypedArrayManager {
  constructor(props) {
    this._pool = [];
    this.props = {
      overAlloc: 2,
      poolSize: 100
    };
    this.setProps(props);
  }

  setProps(props) {
    Object.assign(this.props, props);
  }

  allocate(typedArray, count, {
    size = 1,
    type,
    padding = 0,
    copy = false,
    initialize = false,
    maxCount
  }) {
    const Type = type || typedArray && typedArray.constructor || Float32Array;
    const newSize = count * size + padding;

    if (ArrayBuffer.isView(typedArray)) {
      if (newSize <= typedArray.length) {
        return typedArray;
      }

      if (newSize * typedArray.BYTES_PER_ELEMENT <= typedArray.buffer.byteLength) {
        return new Type(typedArray.buffer, 0, newSize);
      }
    }

    let maxSize;

    if (maxCount) {
      maxSize = maxCount * size + padding;
    }

    const newArray = this._allocate(Type, newSize, initialize, maxSize);

    if (typedArray && copy) {
      newArray.set(typedArray);
    } else if (!initialize) {
      newArray.fill(0, 0, 4);
    }

    this._release(typedArray);

    return newArray;
  }

  release(typedArray) {
    this._release(typedArray);
  }

  _allocate(Type, size, initialize, maxSize) {
    let sizeToAllocate = Math.max(Math.ceil(size * this.props.overAlloc), 1);

    if (sizeToAllocate > maxSize) {
      sizeToAllocate = maxSize;
    }

    const pool = this._pool;
    const byteLength = Type.BYTES_PER_ELEMENT * sizeToAllocate;
    const i = pool.findIndex(b => b.byteLength >= byteLength);

    if (i >= 0) {
      const array = new Type(pool.splice(i, 1)[0], 0, sizeToAllocate);

      if (initialize) {
        array.fill(0);
      }

      return array;
    }

    return new Type(sizeToAllocate);
  }

  _release(typedArray) {
    if (!ArrayBuffer.isView(typedArray)) {
      return;
    }

    const pool = this._pool;
    const {
      buffer
    } = typedArray;
    const {
      byteLength
    } = buffer;
    const i = pool.findIndex(b => b.byteLength >= byteLength);

    if (i < 0) {
      pool.push(buffer);
    } else if (i > 0 || pool.length < this.props.poolSize) {
      pool.splice(i, 0, buffer);
    }

    if (pool.length > this.props.poolSize) {
      pool.shift();
    }
  }

}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (new TypedArrayManager());
//# sourceMappingURL=typed-array-manager.js.map

/***/ }),

/***/ 7013:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Viewport)
/* harmony export */ });
/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80744);
/* harmony import */ var _utils_math_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75126);
/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14034);
/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(37293);
/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(51681);
/* harmony import */ var gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(85975);
/* harmony import */ var _math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17013);
/* harmony import */ var _lib_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24088);






const DEGREES_TO_RADIANS = Math.PI / 180;
const IDENTITY = (0,_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__/* .createMat4 */ .bS)();
const ZERO_VECTOR = [0, 0, 0];
const DEFAULT_ZOOM = 0;
const DEFAULT_DISTANCE_SCALES = {
  unitsPerMeter: [1, 1, 1],
  metersPerUnit: [1, 1, 1]
};
class Viewport {
  constructor(opts = {}) {
    const {
      id = null,
      x = 0,
      y = 0,
      width = 1,
      height = 1
    } = opts;
    this.id = id || this.constructor.displayName || 'viewport';
    this.x = x;
    this.y = y;
    this.width = width || 1;
    this.height = height || 1;
    this._frustumPlanes = {};

    this._initViewMatrix(opts);

    this._initProjectionMatrix(opts);

    this._initPixelMatrices();

    this.equals = this.equals.bind(this);
    this.project = this.project.bind(this);
    this.unproject = this.unproject.bind(this);
    this.projectPosition = this.projectPosition.bind(this);
    this.unprojectPosition = this.unprojectPosition.bind(this);
    this.projectFlat = this.projectFlat.bind(this);
    this.unprojectFlat = this.unprojectFlat.bind(this);
  }

  get metersPerPixel() {
    return this.distanceScales.metersPerUnit[2] / this.scale;
  }

  get projectionMode() {
    if (this.isGeospatial) {
      return this.zoom < 12 ? _lib_constants__WEBPACK_IMPORTED_MODULE_2__/* .PROJECTION_MODE.WEB_MERCATOR */ .zG.WEB_MERCATOR : _lib_constants__WEBPACK_IMPORTED_MODULE_2__/* .PROJECTION_MODE.WEB_MERCATOR_AUTO_OFFSET */ .zG.WEB_MERCATOR_AUTO_OFFSET;
    }

    return _lib_constants__WEBPACK_IMPORTED_MODULE_2__/* .PROJECTION_MODE.IDENTITY */ .zG.IDENTITY;
  }

  equals(viewport) {
    if (!(viewport instanceof Viewport)) {
      return false;
    }

    if (this === viewport) {
      return true;
    }

    return viewport.width === this.width && viewport.height === this.height && viewport.scale === this.scale && (0,math_gl__WEBPACK_IMPORTED_MODULE_3__/* .equals */ .fS)(viewport.projectionMatrix, this.projectionMatrix) && (0,math_gl__WEBPACK_IMPORTED_MODULE_3__/* .equals */ .fS)(viewport.viewMatrix, this.viewMatrix);
  }

  project(xyz, {
    topLeft = true
  } = {}) {
    const worldPosition = this.projectPosition(xyz);
    const coord = (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .worldToPixels */ .aW)(worldPosition, this.pixelProjectionMatrix);
    const [x, y] = coord;
    const y2 = topLeft ? y : this.height - y;
    return xyz.length === 2 ? [x, y2] : [x, y2, coord[2]];
  }

  unproject(xyz, {
    topLeft = true,
    targetZ
  } = {}) {
    const [x, y, z] = xyz;
    const y2 = topLeft ? y : this.height - y;
    const targetZWorld = targetZ && targetZ * this.distanceScales.unitsPerMeter[2];
    const coord = (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .pixelsToWorld */ .CT)([x, y2, z], this.pixelUnprojectionMatrix, targetZWorld);
    const [X, Y, Z] = this.unprojectPosition(coord);

    if (Number.isFinite(z)) {
      return [X, Y, Z];
    }

    return Number.isFinite(targetZ) ? [X, Y, targetZ] : [X, Y];
  }

  projectPosition(xyz) {
    const [X, Y] = this.projectFlat(xyz);
    const Z = (xyz[2] || 0) * this.distanceScales.unitsPerMeter[2];
    return [X, Y, Z];
  }

  unprojectPosition(xyz) {
    const [X, Y] = this.unprojectFlat(xyz);
    const Z = (xyz[2] || 0) * this.distanceScales.metersPerUnit[2];
    return [X, Y, Z];
  }

  projectFlat(xyz) {
    if (this.isGeospatial) {
      return (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .lngLatToWorld */ .w5)(xyz);
    }

    return xyz;
  }

  unprojectFlat(xyz) {
    if (this.isGeospatial) {
      return (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .worldToLngLat */ .es)(xyz);
    }

    return xyz;
  }

  getBounds(options = {}) {
    const unprojectOption = {
      targetZ: options.z || 0
    };
    const topLeft = this.unproject([0, 0], unprojectOption);
    const topRight = this.unproject([this.width, 0], unprojectOption);
    const bottomLeft = this.unproject([0, this.height], unprojectOption);
    const bottomRight = this.unproject([this.width, this.height], unprojectOption);
    return [Math.min(topLeft[0], topRight[0], bottomLeft[0], bottomRight[0]), Math.min(topLeft[1], topRight[1], bottomLeft[1], bottomRight[1]), Math.max(topLeft[0], topRight[0], bottomLeft[0], bottomRight[0]), Math.max(topLeft[1], topRight[1], bottomLeft[1], bottomRight[1])];
  }

  getDistanceScales(coordinateOrigin = null) {
    if (coordinateOrigin) {
      return (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .getDistanceScales */ .ro)({
        longitude: coordinateOrigin[0],
        latitude: coordinateOrigin[1],
        highPrecision: true
      });
    }

    return this.distanceScales;
  }

  containsPixel({
    x,
    y,
    width = 1,
    height = 1
  }) {
    return x < this.x + this.width && this.x < x + width && y < this.y + this.height && this.y < y + height;
  }

  getFrustumPlanes() {
    if (this._frustumPlanes.near) {
      return this._frustumPlanes;
    }

    Object.assign(this._frustumPlanes, (0,_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__/* .getFrustumPlanes */ .Du)(this.viewProjectionMatrix));
    return this._frustumPlanes;
  }

  panByPosition(coords, pixel) {
    return null;
  }

  getCameraPosition() {
    return this.cameraPosition;
  }

  getCameraDirection() {
    return this.cameraDirection;
  }

  getCameraUp() {
    return this.cameraUp;
  }

  _createProjectionMatrix({
    orthographic,
    fovyRadians,
    aspect,
    focalDistance,
    near,
    far
  }) {
    return orthographic ? new math_gl__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z().orthographic({
      fovy: fovyRadians,
      aspect,
      focalDistance,
      near,
      far
    }) : new math_gl__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z().perspective({
      fovy: fovyRadians,
      aspect,
      near,
      far
    });
  }

  _initViewMatrix(opts) {
    const {
      viewMatrix = IDENTITY,
      longitude = null,
      latitude = null,
      zoom = null,
      position = null,
      modelMatrix = null,
      focalDistance = 1,
      distanceScales = null
    } = opts;
    this.isGeospatial = Number.isFinite(latitude) && Number.isFinite(longitude);
    this.zoom = zoom;

    if (!Number.isFinite(this.zoom)) {
      this.zoom = this.isGeospatial ? (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .getMeterZoom */ .Bf)({
        latitude
      }) + Math.log2(focalDistance) : DEFAULT_ZOOM;
    }

    const scale = Math.pow(2, this.zoom);
    this.scale = scale;
    this.distanceScales = this.isGeospatial ? (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .getDistanceScales */ .ro)({
      latitude,
      longitude
    }) : distanceScales || DEFAULT_DISTANCE_SCALES;
    this.focalDistance = focalDistance;
    this.distanceScales.metersPerUnit = new math_gl__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z(this.distanceScales.metersPerUnit);
    this.distanceScales.unitsPerMeter = new math_gl__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z(this.distanceScales.unitsPerMeter);
    this.position = ZERO_VECTOR;
    this.meterOffset = ZERO_VECTOR;

    if (position) {
      this.position = position;
      this.modelMatrix = modelMatrix;
      this.meterOffset = modelMatrix ? modelMatrix.transformVector(position) : position;
    }

    if (this.isGeospatial) {
      this.longitude = longitude;
      this.latitude = latitude;
      this.center = this._getCenterInWorld({
        longitude,
        latitude
      });
    } else {
      this.center = position ? this.projectPosition(position) : [0, 0, 0];
    }

    this.viewMatrixUncentered = viewMatrix;
    this.viewMatrix = new math_gl__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z().multiplyRight(this.viewMatrixUncentered).translate(new math_gl__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z(this.center || ZERO_VECTOR).negate());
  }

  _getCenterInWorld({
    longitude,
    latitude
  }) {
    const {
      meterOffset,
      distanceScales
    } = this;
    const center = new math_gl__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z(this.projectPosition([longitude, latitude, 0]));

    if (meterOffset) {
      const commonPosition = new math_gl__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z(meterOffset).scale(distanceScales.unitsPerMeter);
      center.add(commonPosition);
    }

    return center;
  }

  _initProjectionMatrix(opts) {
    const {
      projectionMatrix = null,
      orthographic = false,
      fovyRadians,
      fovy = 75,
      near = 0.1,
      far = 1000,
      focalDistance = 1
    } = opts;
    this.projectionMatrix = projectionMatrix || this._createProjectionMatrix({
      orthographic,
      fovyRadians: fovyRadians || fovy * DEGREES_TO_RADIANS,
      aspect: this.width / this.height,
      focalDistance,
      near,
      far
    });
  }

  _initPixelMatrices() {
    const vpm = (0,_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__/* .createMat4 */ .bS)();
    gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_6__/* .multiply */ .Jp(vpm, vpm, this.projectionMatrix);
    gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_6__/* .multiply */ .Jp(vpm, vpm, this.viewMatrix);
    this.viewProjectionMatrix = vpm;
    this.viewMatrixInverse = gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_6__/* .invert */ .U_([], this.viewMatrix) || this.viewMatrix;
    this.cameraPosition = (0,_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__/* .getCameraPosition */ .Xt)(this.viewMatrixInverse);
    const viewportMatrix = (0,_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__/* .createMat4 */ .bS)();
    const pixelProjectionMatrix = (0,_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__/* .createMat4 */ .bS)();
    gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_6__/* .scale */ .bA(viewportMatrix, viewportMatrix, [this.width / 2, -this.height / 2, 1]);
    gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_6__/* .translate */ .Iu(viewportMatrix, viewportMatrix, [1, -1, 0]);
    gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_6__/* .multiply */ .Jp(pixelProjectionMatrix, viewportMatrix, this.viewProjectionMatrix);
    this.pixelProjectionMatrix = pixelProjectionMatrix;
    this.viewportMatrix = viewportMatrix;
    this.pixelUnprojectionMatrix = gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_6__/* .invert */ .U_((0,_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__/* .createMat4 */ .bS)(), this.pixelProjectionMatrix);

    if (!this.pixelUnprojectionMatrix) {
      _utils_log__WEBPACK_IMPORTED_MODULE_7__/* ["default"].warn */ .Z.warn('Pixel project matrix not invertible')();
    }
  }

}
Viewport.displayName = 'Viewport';
//# sourceMappingURL=viewport.js.map

/***/ }),

/***/ 96935:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ WebMercatorViewport)
/* harmony export */ });
/* harmony import */ var _viewport__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7013);
/* harmony import */ var _math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17013);
/* harmony import */ var gl_matrix_vec2__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31437);
/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(37293);




class WebMercatorViewport extends _viewport__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z {
  constructor(opts = {}) {
    const {
      latitude = 0,
      longitude = 0,
      zoom = 11,
      pitch = 0,
      bearing = 0,
      nearZMultiplier = 0.1,
      farZMultiplier = 1.01,
      orthographic = false,
      repeat = false,
      worldOffset = 0
    } = opts;
    let {
      width,
      height,
      altitude = 1.5
    } = opts;
    const scale = Math.pow(2, zoom);
    width = width || 1;
    height = height || 1;
    altitude = Math.max(0.75, altitude);
    const {
      fov,
      aspect,
      focalDistance,
      near,
      far
    } = (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .getProjectionParameters */ .wl)({
      width,
      height,
      pitch,
      altitude,
      nearZMultiplier,
      farZMultiplier
    });
    let viewMatrixUncentered = (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .getViewMatrix */ .lf)({
      height,
      pitch,
      bearing,
      scale,
      altitude
    });

    if (worldOffset) {
      const viewOffset = new math_gl__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z().translate([512 * worldOffset, 0, 0]);
      viewMatrixUncentered = viewOffset.multiplyLeft(viewMatrixUncentered);
    }

    super({ ...opts,
      width,
      height,
      viewMatrix: viewMatrixUncentered,
      longitude,
      latitude,
      zoom,
      orthographic,
      fovyRadians: fov,
      aspect,
      focalDistance,
      near,
      far
    });
    this.latitude = latitude;
    this.longitude = longitude;
    this.zoom = zoom;
    this.pitch = pitch;
    this.bearing = bearing;
    this.altitude = altitude;
    this.orthographic = orthographic;
    this._subViewports = repeat ? [] : null;
    Object.freeze(this);
  }

  get subViewports() {
    if (this._subViewports && !this._subViewports.length) {
      const bounds = this.getBounds();
      const minOffset = Math.floor((bounds[0] + 180) / 360);
      const maxOffset = Math.ceil((bounds[2] - 180) / 360);

      for (let x = minOffset; x <= maxOffset; x++) {
        const offsetViewport = x ? new WebMercatorViewport({ ...this,
          worldOffset: x
        }) : this;

        this._subViewports.push(offsetViewport);
      }
    }

    return this._subViewports;
  }

  addMetersToLngLat(lngLatZ, xyz) {
    return (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .addMetersToLngLat */ .eG)(lngLatZ, xyz);
  }

  panByPosition(coords, pixel) {
    const fromLocation = (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .pixelsToWorld */ .CT)(pixel, this.pixelUnprojectionMatrix);
    const toLocation = this.projectFlat(coords);
    const translate = gl_matrix_vec2__WEBPACK_IMPORTED_MODULE_3__/* .add */ .IH([], toLocation, gl_matrix_vec2__WEBPACK_IMPORTED_MODULE_3__/* .negate */ .tk([], fromLocation));
    const newCenter = gl_matrix_vec2__WEBPACK_IMPORTED_MODULE_3__/* .add */ .IH([], this.center, translate);
    const [longitude, latitude] = this.unprojectFlat(newCenter);
    return {
      longitude,
      latitude
    };
  }

  getBounds(options = {}) {
    const corners = (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .getBounds */ .zX)(this, options.z || 0);
    return [Math.min(corners[0][0], corners[1][0], corners[2][0], corners[3][0]), Math.min(corners[0][1], corners[1][1], corners[2][1], corners[3][1]), Math.max(corners[0][0], corners[1][0], corners[2][0], corners[3][0]), Math.max(corners[0][1], corners[1][1], corners[2][1], corners[3][1])];
  }

  fitBounds(bounds, options = {}) {
    const {
      width,
      height
    } = this;
    const {
      longitude,
      latitude,
      zoom
    } = (0,_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__/* .fitBounds */ .Xg)({
      width,
      height,
      bounds,
      ...options
    });
    return new WebMercatorViewport({
      width,
      height,
      longitude,
      latitude,
      zoom
    });
  }

}
WebMercatorViewport.displayName = 'WebMercatorViewport';
//# sourceMappingURL=web-mercator-viewport.js.map

/***/ }),

/***/ 36255:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Kn": () => (/* binding */ isObject),
/* harmony export */   "Ss": () => (/* binding */ isPureObject),
/* harmony export */   "TW": () => (/* binding */ isIterable),
/* harmony export */   "D0": () => (/* binding */ isAsyncIterable),
/* harmony export */   "Ew": () => (/* binding */ isResponse),
/* harmony export */   "Lj": () => (/* binding */ isBlob),
/* harmony export */   "zH": () => (/* binding */ isBuffer),
/* harmony export */   "Os": () => (/* binding */ isReadableStream)
/* harmony export */ });
/* unused harmony exports isPromise, isIterator, isFile, isWritableDOMStream, isReadableDOMStream, isWritableNodeStream, isReadableNodeStream, isWritableStream */
const isBoolean = x => typeof x === 'boolean';

const isFunction = x => typeof x === 'function';

const isObject = x => x !== null && typeof x === 'object';
const isPureObject = x => isObject(x) && x.constructor === {}.constructor;
const isPromise = x => isObject(x) && isFunction(x.then);
const isIterable = x => x && typeof x[Symbol.iterator] === 'function';
const isAsyncIterable = x => x && typeof x[Symbol.asyncIterator] === 'function';
const isIterator = x => x && isFunction(x.next);
const isResponse = x => typeof Response !== 'undefined' && x instanceof Response || x && x.arrayBuffer && x.text && x.json;
const isFile = x => typeof File !== 'undefined' && x instanceof File;
const isBlob = x => typeof Blob !== 'undefined' && x instanceof Blob;
const isWritableDOMStream = x => isObject(x) && isFunction(x.abort) && isFunction(x.getWriter);
const isReadableDOMStream = x => typeof ReadableStream !== 'undefined' && x instanceof ReadableStream || isObject(x) && isFunction(x.tee) && isFunction(x.cancel) && isFunction(x.getReader);
const isBuffer = x => x && typeof x === 'object' && x.isBuffer;
const isWritableNodeStream = x => isObject(x) && isFunction(x.end) && isFunction(x.write) && isBoolean(x.writable);
const isReadableNodeStream = x => isObject(x) && isFunction(x.read) && isFunction(x.pipe) && isBoolean(x.readable);
const isReadableStream = x => isReadableDOMStream(x) || isReadableNodeStream(x);
const isWritableStream = x => isWritableDOMStream(x) || isWritableNodeStream(x);
//# sourceMappingURL=is-type.js.map

/***/ }),

/***/ 73838:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "z": () => (/* binding */ load)
});

// EXTERNAL MODULE: ./node_modules/@loaders.gl/core/dist/esm/javascript-utils/is-type.js
var is_type = __webpack_require__(36255);
// EXTERNAL MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/normalize-loader.js + 1 modules
var normalize_loader = __webpack_require__(75596);
// EXTERNAL MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/option-utils.js + 4 modules
var option_utils = __webpack_require__(77504);
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/worker-utils/dist/esm/lib/env-utils/assert.js
function assert(condition, message) {
  if (!condition) {
    throw new Error(message || 'loaders.gl assertion failed.');
  }
}
//# sourceMappingURL=assert.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/worker-utils/dist/esm/lib/env-utils/version.js
const DEFAULT_VERSION = 'beta';
const VERSION =  true ? "3.0.8" : 0;

if (false) {}
//# sourceMappingURL=version.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/worker-utils/dist/esm/lib/worker-api/validate-worker-version.js


function validateWorkerVersion(worker, coreVersion = VERSION) {
  assert(worker, 'no worker provided');
  const workerVersion = worker.version;

  if (!coreVersion || !workerVersion) {
    return false;
  }

  return true;
}

function parseVersion(version) {
  const parts = version.split('.').map(Number);
  return {
    major: parts[0],
    minor: parts[1]
  };
}
//# sourceMappingURL=validate-worker-version.js.map
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/defineProperty.js
var defineProperty = __webpack_require__(4942);
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/worker-utils/dist/esm/lib/env-utils/globals.js
/* provided dependency */ var process = __webpack_require__(34155);
const globals = {
  self: typeof self !== 'undefined' && self,
  window: typeof window !== 'undefined' && window,
  global: typeof __webpack_require__.g !== 'undefined' && __webpack_require__.g,
  document: typeof document !== 'undefined' && document
};
const self_ = globals.self || globals.window || globals.global || {};
const window_ = globals.window || globals.self || globals.global || {};
const global_ = globals.global || globals.self || globals.window || {};
const document_ = globals.document || {};

const isBrowser = typeof process !== 'object' || String(process) !== '[object process]' || process.browser;
const isWorker = typeof importScripts === 'function';
const isMobile = typeof window !== 'undefined' && typeof window.orientation !== 'undefined';
const matches = typeof process !== 'undefined' && process.version && /v([0-9]*)/.exec(process.version);
const nodeVersion = matches && parseFloat(matches[1]) || 0;
//# sourceMappingURL=globals.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/worker-utils/dist/esm/lib/worker-utils/get-loadable-worker-url.js

const workerURLCache = new Map();
function getLoadableWorkerURL(props) {
  assert(props.source && !props.url || !props.source && props.url);
  let workerURL = workerURLCache.get(props.source || props.url);

  if (!workerURL) {
    if (props.url) {
      workerURL = getLoadableWorkerURLFromURL(props.url);
      workerURLCache.set(props.url, workerURL);
    }

    if (props.source) {
      workerURL = getLoadableWorkerURLFromSource(props.source);
      workerURLCache.set(props.source, workerURL);
    }
  }

  assert(workerURL);
  return workerURL;
}

function getLoadableWorkerURLFromURL(url) {
  if (!url.startsWith('http')) {
    return url;
  }

  const workerSource = buildScriptSource(url);
  return getLoadableWorkerURLFromSource(workerSource);
}

function getLoadableWorkerURLFromSource(workerSource) {
  const blob = new Blob([workerSource], {
    type: 'application/javascript'
  });
  return URL.createObjectURL(blob);
}

function buildScriptSource(workerUrl) {
  return `\
try {
  importScripts('${workerUrl}');
} catch (error) {
  console.error(error);
  throw error;
}`;
}
//# sourceMappingURL=get-loadable-worker-url.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/worker-utils/dist/esm/lib/worker-utils/get-transfer-list.js
function getTransferList(object, recursive = true, transfers) {
  const transfersSet = transfers || new Set();

  if (!object) {} else if (isTransferable(object)) {
    transfersSet.add(object);
  } else if (isTransferable(object.buffer)) {
    transfersSet.add(object.buffer);
  } else if (ArrayBuffer.isView(object)) {} else if (recursive && typeof object === 'object') {
    for (const key in object) {
      getTransferList(object[key], recursive, transfersSet);
    }
  }

  return transfers === undefined ? Array.from(transfersSet) : [];
}

function isTransferable(object) {
  if (!object) {
    return false;
  }

  if (object instanceof ArrayBuffer) {
    return true;
  }

  if (typeof MessagePort !== 'undefined' && object instanceof MessagePort) {
    return true;
  }

  if (typeof ImageBitmap !== 'undefined' && object instanceof ImageBitmap) {
    return true;
  }

  if (typeof OffscreenCanvas !== 'undefined' && object instanceof OffscreenCanvas) {
    return true;
  }

  return false;
}
//# sourceMappingURL=get-transfer-list.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/worker-utils/dist/esm/lib/worker-farm/worker-thread.js





const NOOP = () => {};

class WorkerThread {
  static isSupported() {
    return typeof Worker !== 'undefined';
  }

  constructor(props) {
    (0,defineProperty/* default */.Z)(this, "name", void 0);

    (0,defineProperty/* default */.Z)(this, "source", void 0);

    (0,defineProperty/* default */.Z)(this, "url", void 0);

    (0,defineProperty/* default */.Z)(this, "terminated", false);

    (0,defineProperty/* default */.Z)(this, "worker", void 0);

    (0,defineProperty/* default */.Z)(this, "onMessage", void 0);

    (0,defineProperty/* default */.Z)(this, "onError", void 0);

    (0,defineProperty/* default */.Z)(this, "_loadableURL", '');

    const {
      name,
      source,
      url
    } = props;
    assert(source || url);
    this.name = name;
    this.source = source;
    this.url = url;
    this.onMessage = NOOP;

    this.onError = error => console.log(error);

    this.worker = this._createBrowserWorker();
  }

  destroy() {
    this.onMessage = NOOP;
    this.onError = NOOP;
    this.worker.terminate();
    this.terminated = true;
  }

  get isRunning() {
    return Boolean(this.onMessage);
  }

  postMessage(data, transferList) {
    transferList = transferList || getTransferList(data);
    this.worker.postMessage(data, transferList);
  }

  _getErrorFromErrorEvent(event) {
    let message = 'Failed to load ';
    message += `worker ${this.name}. `;

    if (event.message) {
      message += `${event.message} in `;
    }

    if (event.lineno) {
      message += `:${event.lineno}:${event.colno}`;
    }

    return new Error(message);
  }

  _createBrowserWorker() {
    this._loadableURL = getLoadableWorkerURL({
      source: this.source,
      url: this.url
    });
    const worker = new Worker(this._loadableURL, {
      name: this.name
    });

    worker.onmessage = event => {
      if (!event.data) {
        this.onError(new Error('No data received'));
      } else {
        this.onMessage(event.data);
      }
    };

    worker.onerror = error => {
      this.onError(this._getErrorFromErrorEvent(error));
      this.terminated = true;
    };

    worker.onmessageerror = event => console.error(event);

    return worker;
  }

}
//# sourceMappingURL=worker-thread.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/worker-utils/dist/esm/lib/worker-farm/worker-job.js


class WorkerJob {
  constructor(jobName, workerThread) {
    (0,defineProperty/* default */.Z)(this, "name", void 0);

    (0,defineProperty/* default */.Z)(this, "workerThread", void 0);

    (0,defineProperty/* default */.Z)(this, "isRunning", void 0);

    (0,defineProperty/* default */.Z)(this, "result", void 0);

    (0,defineProperty/* default */.Z)(this, "_resolve", void 0);

    (0,defineProperty/* default */.Z)(this, "_reject", void 0);

    this.name = jobName;
    this.workerThread = workerThread;
    this.isRunning = true;

    this._resolve = () => {};

    this._reject = () => {};

    this.result = new Promise((resolve, reject) => {
      this._resolve = resolve;
      this._reject = reject;
    });
  }

  postMessage(type, payload) {
    this.workerThread.postMessage({
      source: 'loaders.gl',
      type,
      payload
    });
  }

  done(value) {
    assert(this.isRunning);
    this.isRunning = false;

    this._resolve(value);
  }

  error(error) {
    assert(this.isRunning);
    this.isRunning = false;

    this._reject(error);
  }

}
//# sourceMappingURL=worker-job.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/worker-utils/dist/esm/lib/worker-farm/worker-pool.js




class WorkerPool {
  constructor(props) {
    (0,defineProperty/* default */.Z)(this, "name", 'unnamed');

    (0,defineProperty/* default */.Z)(this, "source", void 0);

    (0,defineProperty/* default */.Z)(this, "url", void 0);

    (0,defineProperty/* default */.Z)(this, "maxConcurrency", 1);

    (0,defineProperty/* default */.Z)(this, "maxMobileConcurrency", 1);

    (0,defineProperty/* default */.Z)(this, "onDebug", () => {});

    (0,defineProperty/* default */.Z)(this, "reuseWorkers", true);

    (0,defineProperty/* default */.Z)(this, "props", {});

    (0,defineProperty/* default */.Z)(this, "jobQueue", []);

    (0,defineProperty/* default */.Z)(this, "idleQueue", []);

    (0,defineProperty/* default */.Z)(this, "count", 0);

    (0,defineProperty/* default */.Z)(this, "isDestroyed", false);

    this.source = props.source;
    this.url = props.url;
    this.setProps(props);
  }

  destroy() {
    this.idleQueue.forEach(worker => worker.destroy());
    this.isDestroyed = true;
  }

  setProps(props) {
    this.props = { ...this.props,
      ...props
    };

    if (props.name !== undefined) {
      this.name = props.name;
    }

    if (props.maxConcurrency !== undefined) {
      this.maxConcurrency = props.maxConcurrency;
    }

    if (props.maxMobileConcurrency !== undefined) {
      this.maxMobileConcurrency = props.maxMobileConcurrency;
    }

    if (props.reuseWorkers !== undefined) {
      this.reuseWorkers = props.reuseWorkers;
    }

    if (props.onDebug !== undefined) {
      this.onDebug = props.onDebug;
    }
  }

  async startJob(name, onMessage = (job, type, data) => job.done(data), onError = (job, error) => job.error(error)) {
    const startPromise = new Promise(onStart => {
      this.jobQueue.push({
        name,
        onMessage,
        onError,
        onStart
      });
      return this;
    });

    this._startQueuedJob();

    return await startPromise;
  }

  async _startQueuedJob() {
    if (!this.jobQueue.length) {
      return;
    }

    const workerThread = this._getAvailableWorker();

    if (!workerThread) {
      return;
    }

    const queuedJob = this.jobQueue.shift();

    if (queuedJob) {
      this.onDebug({
        message: 'Starting job',
        name: queuedJob.name,
        workerThread,
        backlog: this.jobQueue.length
      });
      const job = new WorkerJob(queuedJob.name, workerThread);

      workerThread.onMessage = data => queuedJob.onMessage(job, data.type, data.payload);

      workerThread.onError = error => queuedJob.onError(job, error);

      queuedJob.onStart(job);

      try {
        await job.result;
      } finally {
        this.returnWorkerToQueue(workerThread);
      }
    }
  }

  returnWorkerToQueue(worker) {
    const shouldDestroyWorker = this.isDestroyed || !this.reuseWorkers || this.count > this._getMaxConcurrency();

    if (shouldDestroyWorker) {
      worker.destroy();
      this.count--;
    } else {
      this.idleQueue.push(worker);
    }

    if (!this.isDestroyed) {
      this._startQueuedJob();
    }
  }

  _getAvailableWorker() {
    if (this.idleQueue.length > 0) {
      return this.idleQueue.shift() || null;
    }

    if (this.count < this._getMaxConcurrency()) {
      this.count++;
      const name = `${this.name.toLowerCase()} (#${this.count} of ${this.maxConcurrency})`;
      return new WorkerThread({
        name,
        source: this.source,
        url: this.url
      });
    }

    return null;
  }

  _getMaxConcurrency() {
    return isMobile ? this.maxMobileConcurrency : this.maxConcurrency;
  }

}
//# sourceMappingURL=worker-pool.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/worker-utils/dist/esm/lib/worker-farm/worker-farm.js



const DEFAULT_PROPS = {
  maxConcurrency: 3,
  maxMobileConcurrency: 1,
  onDebug: () => {},
  reuseWorkers: true
};
class WorkerFarm {
  static isSupported() {
    return WorkerThread.isSupported();
  }

  static getWorkerFarm(props = {}) {
    WorkerFarm._workerFarm = WorkerFarm._workerFarm || new WorkerFarm({});

    WorkerFarm._workerFarm.setProps(props);

    return WorkerFarm._workerFarm;
  }

  constructor(props) {
    (0,defineProperty/* default */.Z)(this, "props", void 0);

    (0,defineProperty/* default */.Z)(this, "workerPools", new Map());

    this.props = { ...DEFAULT_PROPS
    };
    this.setProps(props);
    this.workerPools = new Map();
  }

  destroy() {
    for (const workerPool of this.workerPools.values()) {
      workerPool.destroy();
    }
  }

  setProps(props) {
    this.props = { ...this.props,
      ...props
    };

    for (const workerPool of this.workerPools.values()) {
      workerPool.setProps(this._getWorkerPoolProps());
    }
  }

  getWorkerPool(options) {
    const {
      name,
      source,
      url
    } = options;
    let workerPool = this.workerPools.get(name);

    if (!workerPool) {
      workerPool = new WorkerPool({
        name,
        source,
        url
      });
      workerPool.setProps(this._getWorkerPoolProps());
      this.workerPools.set(name, workerPool);
    }

    return workerPool;
  }

  _getWorkerPoolProps() {
    return {
      maxConcurrency: this.props.maxConcurrency,
      maxMobileConcurrency: this.props.maxMobileConcurrency,
      reuseWorkers: this.props.reuseWorkers,
      onDebug: this.props.onDebug
    };
  }

}

(0,defineProperty/* default */.Z)(WorkerFarm, "_workerFarm", void 0);
//# sourceMappingURL=worker-farm.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/worker-utils/dist/esm/lib/worker-api/get-worker-url.js


const NPM_TAG = 'latest';
const get_worker_url_VERSION = (/* unused pure expression or super */ null && ( true ? "3.0.8" : 0));
function getWorkerName(worker) {
  const warning = worker.version !== get_worker_url_VERSION ? ` (worker-utils@${get_worker_url_VERSION})` : '';
  return `${worker.name}@${worker.version}${warning}`;
}
function getWorkerURL(worker, options = {}) {
  const workerOptions = options[worker.id] || {};
  const workerFile = `${worker.id}-worker.js`;
  let url = workerOptions.workerUrl;

  if (options._workerType === 'test') {
    url = `modules/${worker.module}/dist/${workerFile}`;
  }

  if (!url) {
    let version = worker.version;

    if (version === 'latest') {
      version = NPM_TAG;
    }

    const versionTag = version ? `@${version}` : '';
    url = `https://unpkg.com/@loaders.gl/${worker.module}${versionTag}/dist/${workerFile}`;
  }

  assert(url);
  return url;
}
//# sourceMappingURL=get-worker-url.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/loader-utils/dist/esm/lib/worker-loader-utils/parse-with-worker.js

function canParseWithWorker(loader, options) {
  if (!WorkerFarm.isSupported()) {
    return false;
  }

  return loader.worker && (options === null || options === void 0 ? void 0 : options.worker);
}
async function parseWithWorker(loader, data, options, context, parseOnMainThread) {
  const name = loader.id;
  const url = getWorkerURL(loader, options);
  const workerFarm = WorkerFarm.getWorkerFarm(options);
  const workerPool = workerFarm.getWorkerPool({
    name,
    url
  });
  options = JSON.parse(JSON.stringify(options));
  const job = await workerPool.startJob('process-on-worker', onMessage.bind(null, parseOnMainThread));
  job.postMessage('process', {
    input: data,
    options
  });
  const result = await job.result;
  return await result.result;
}

async function onMessage(parseOnMainThread, job, type, payload) {
  switch (type) {
    case 'done':
      job.done(payload);
      break;

    case 'error':
      job.error(payload.error);
      break;

    case 'process':
      const {
        id,
        input,
        options
      } = payload;

      try {
        const result = await parseOnMainThread(input, options);
        job.postMessage('done', {
          id,
          result
        });
      } catch (error) {
        const message = error instanceof Error ? error.message : 'unknown error';
        job.postMessage('error', {
          id,
          error: message
        });
      }

      break;

    default:
      console.warn(`parse-with-worker unknown message ${type}`);
  }
}
//# sourceMappingURL=parse-with-worker.js.map
// EXTERNAL MODULE: ../node/buffer-utils.node (ignored)
var buffer_utils_ignored_ = __webpack_require__(92540);
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/loader-utils/dist/esm/lib/binary-utils/array-buffer-utils.js

function toArrayBuffer(data) {
  if (buffer_utils_ignored_.toArrayBuffer) {
    data = buffer_utils_ignored_.toArrayBuffer(data);
  }

  if (data instanceof ArrayBuffer) {
    return data;
  }

  if (ArrayBuffer.isView(data)) {
    return data.buffer;
  }

  if (typeof data === 'string') {
    const text = data;
    const uint8Array = new TextEncoder().encode(text);
    return uint8Array.buffer;
  }

  if (data && typeof data === 'object' && data._toArrayBuffer) {
    return data._toArrayBuffer();
  }

  throw new Error('toArrayBuffer');
}
function compareArrayBuffers(arrayBuffer1, arrayBuffer2, byteLength) {
  byteLength = byteLength || arrayBuffer1.byteLength;

  if (arrayBuffer1.byteLength < byteLength || arrayBuffer2.byteLength < byteLength) {
    return false;
  }

  const array1 = new Uint8Array(arrayBuffer1);
  const array2 = new Uint8Array(arrayBuffer2);

  for (let i = 0; i < array1.length; ++i) {
    if (array1[i] !== array2[i]) {
      return false;
    }
  }

  return true;
}
function concatenateArrayBuffers(...sources) {
  const sourceArrays = sources.map(source2 => source2 instanceof ArrayBuffer ? new Uint8Array(source2) : source2);
  const byteLength = sourceArrays.reduce((length, typedArray) => length + typedArray.byteLength, 0);
  const result = new Uint8Array(byteLength);
  let offset = 0;

  for (const sourceArray of sourceArrays) {
    result.set(sourceArray, offset);
    offset += sourceArray.byteLength;
  }

  return result.buffer;
}
function concatenateTypedArrays(...typedArrays) {
  const arrays = typedArrays;
  const TypedArrayConstructor = arrays && arrays.length > 1 && arrays[0].constructor || null;

  if (!TypedArrayConstructor) {
    throw new Error('"concatenateTypedArrays" - incorrect quantity of arguments or arguments have incompatible data types');
  }

  const sumLength = arrays.reduce((acc, value) => acc + value.length, 0);
  const result = new TypedArrayConstructor(sumLength);
  let offset = 0;

  for (const array of arrays) {
    result.set(array, offset);
    offset += array.length;
  }

  return result;
}
function sliceArrayBuffer(arrayBuffer, byteOffset, byteLength) {
  const subArray = byteLength !== undefined ? new Uint8Array(arrayBuffer).subarray(byteOffset, byteOffset + byteLength) : new Uint8Array(arrayBuffer).subarray(byteOffset);
  const arrayCopy = new Uint8Array(subArray);
  return arrayCopy.buffer;
}
//# sourceMappingURL=array-buffer-utils.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/loader-utils/dist/esm/lib/iterators/async-iteration.js

async function forEach(iterator, visitor) {
  while (true) {
    const {
      done,
      value
    } = await iterator.next();

    if (done) {
      iterator.return();
      return;
    }

    const cancel = visitor(value);

    if (cancel) {
      return;
    }
  }
}
async function concatenateArrayBuffersAsync(asyncIterator) {
  const arrayBuffers = [];

  for await (const chunk of asyncIterator) {
    arrayBuffers.push(chunk);
  }

  return concatenateArrayBuffers(...arrayBuffers);
}
async function concatenateStringsAsync(asyncIterator) {
  const strings = [];

  for await (const chunk of asyncIterator) {
    strings.push(chunk);
  }

  return strings.join('');
}
//# sourceMappingURL=async-iteration.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-string-iterator.js
const DEFAULT_CHUNK_SIZE = 256 * 1024;
function* makeStringIterator(string, options) {
  const chunkSize = (options === null || options === void 0 ? void 0 : options.chunkSize) || DEFAULT_CHUNK_SIZE;
  let offset = 0;
  const textEncoder = new TextEncoder();

  while (offset < string.length) {
    const chunkLength = Math.min(string.length - offset, chunkSize);
    const chunk = string.slice(offset, offset + chunkLength);
    offset += chunkLength;
    yield textEncoder.encode(chunk);
  }
}
//# sourceMappingURL=make-string-iterator.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-array-buffer-iterator.js
const make_array_buffer_iterator_DEFAULT_CHUNK_SIZE = 256 * 1024;
function* makeArrayBufferIterator(arrayBuffer, options = {}) {
  const {
    chunkSize = make_array_buffer_iterator_DEFAULT_CHUNK_SIZE
  } = options;
  let byteOffset = 0;

  while (byteOffset < arrayBuffer.byteLength) {
    const chunkByteLength = Math.min(arrayBuffer.byteLength - byteOffset, chunkSize);
    const chunk = new ArrayBuffer(chunkByteLength);
    const sourceArray = new Uint8Array(arrayBuffer, byteOffset, chunkByteLength);
    const chunkArray = new Uint8Array(chunk);
    chunkArray.set(sourceArray);
    byteOffset += chunkByteLength;
    yield chunk;
  }
}
//# sourceMappingURL=make-array-buffer-iterator.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-blob-iterator.js
const make_blob_iterator_DEFAULT_CHUNK_SIZE = 1024 * 1024;
async function* makeBlobIterator(blob, options) {
  const chunkSize = (options === null || options === void 0 ? void 0 : options.chunkSize) || make_blob_iterator_DEFAULT_CHUNK_SIZE;
  let offset = 0;

  while (offset < blob.size) {
    const end = offset + chunkSize;
    const chunk = await blob.slice(offset, end).arrayBuffer();
    offset = end;
    yield chunk;
  }
}
//# sourceMappingURL=make-blob-iterator.js.map
// EXTERNAL MODULE: ./node_modules/@loaders.gl/loader-utils/dist/esm/lib/env-utils/globals.js
var env_utils_globals = __webpack_require__(84959);
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-stream-iterator.js

function makeStreamIterator(stream, options) {
  return env_utils_globals/* isBrowser */.jU ? makeBrowserStreamIterator(stream, options) : makeNodeStreamIterator(stream, options);
}

async function* makeBrowserStreamIterator(stream, options) {
  const reader = stream.getReader();
  let nextBatchPromise;

  try {
    while (true) {
      const currentBatchPromise = nextBatchPromise || reader.read();

      if (options !== null && options !== void 0 && options._streamReadAhead) {
        nextBatchPromise = reader.read();
      }

      const {
        done,
        value
      } = await currentBatchPromise;

      if (done) {
        return;
      }

      yield toArrayBuffer(value);
    }
  } catch (error) {
    reader.releaseLock();
  }
}

async function* makeNodeStreamIterator(stream, options) {
  for await (const chunk of stream) {
    yield toArrayBuffer(chunk);
  }
}
//# sourceMappingURL=make-stream-iterator.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-iterator.js





function make_iterator_makeIterator(data, options) {
  if (typeof data === 'string') {
    return makeStringIterator(data, options);
  }

  if (data instanceof ArrayBuffer) {
    return makeArrayBufferIterator(data, options);
  }

  if ((0,is_type/* isBlob */.Lj)(data)) {
    return makeBlobIterator(data, options);
  }

  if ((0,is_type/* isReadableStream */.Os)(data)) {
    return makeStreamIterator(data, options);
  }

  if ((0,is_type/* isResponse */.Ew)(data)) {
    const response = data;
    return makeStreamIterator(response.body, options);
  }

  throw new Error('makeIterator');
}
//# sourceMappingURL=make-iterator.js.map
// EXTERNAL MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/utils/response-utils.js
var response_utils = __webpack_require__(17927);
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/get-data.js




const ERR_DATA = 'Cannot convert supplied data type';
function getArrayBufferOrStringFromDataSync(data, loader, options) {
  if (loader.text && typeof data === 'string') {
    return data;
  }

  if ((0,is_type/* isBuffer */.zH)(data)) {
    data = data.buffer;
  }

  if (data instanceof ArrayBuffer) {
    const arrayBuffer = data;

    if (loader.text && !loader.binary) {
      const textDecoder = new TextDecoder('utf8');
      return textDecoder.decode(arrayBuffer);
    }

    return arrayBuffer;
  }

  if (ArrayBuffer.isView(data)) {
    if (loader.text && !loader.binary) {
      const textDecoder = new TextDecoder('utf8');
      return textDecoder.decode(data);
    }

    let arrayBuffer = data.buffer;
    const byteLength = data.byteLength || data.length;

    if (data.byteOffset !== 0 || byteLength !== arrayBuffer.byteLength) {
      arrayBuffer = arrayBuffer.slice(data.byteOffset, data.byteOffset + byteLength);
    }

    return arrayBuffer;
  }

  throw new Error(ERR_DATA);
}
async function getArrayBufferOrStringFromData(data, loader, options) {
  const isArrayBuffer = data instanceof ArrayBuffer || ArrayBuffer.isView(data);

  if (typeof data === 'string' || isArrayBuffer) {
    return getArrayBufferOrStringFromDataSync(data, loader, options);
  }

  if ((0,is_type/* isBlob */.Lj)(data)) {
    data = await (0,response_utils/* makeResponse */.L1)(data);
  }

  if ((0,is_type/* isResponse */.Ew)(data)) {
    const response = data;
    await (0,response_utils/* checkResponse */.mm)(response);
    return loader.binary ? await response.arrayBuffer() : await response.text();
  }

  if ((0,is_type/* isReadableStream */.Os)(data)) {
    data = make_iterator_makeIterator(data, options);
  }

  if ((0,is_type/* isIterable */.TW)(data) || (0,is_type/* isAsyncIterable */.D0)(data)) {
    return concatenateArrayBuffersAsync(data);
  }

  throw new Error(ERR_DATA);
}
async function getAsyncIterableFromData(data, options) {
  if (isIterator(data)) {
    return data;
  }

  if (isResponse(data)) {
    const response = data;
    await checkResponse(response);
    const body = await response.body;
    return makeIterator(body, options);
  }

  if (isBlob(data) || isReadableStream(data)) {
    return makeIterator(data, options);
  }

  if (isAsyncIterable(data)) {
    return data[Symbol.asyncIterator]();
  }

  return getIterableFromData(data);
}
async function getReadableStream(data) {
  if (isReadableStream(data)) {
    return data;
  }

  if (isResponse(data)) {
    return data.body;
  }

  const response = await makeResponse(data);
  return response.body;
}

function getIterableFromData(data) {
  if (ArrayBuffer.isView(data)) {
    return function* oneChunk() {
      yield data.buffer;
    }();
  }

  if (data instanceof ArrayBuffer) {
    return function* oneChunk() {
      yield data;
    }();
  }

  if (isIterator(data)) {
    return data;
  }

  if (isIterable(data)) {
    return data[Symbol.iterator]();
  }

  throw new Error(ERR_DATA);
}
//# sourceMappingURL=get-data.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/loader-context.js

function getLoaderContext(context, options, previousContext = null) {
  if (previousContext) {
    return previousContext;
  }

  const resolvedContext = {
    fetch: (0,option_utils/* getFetchFunction */.bV)(options, context),
    ...context
  };

  if (!Array.isArray(resolvedContext.loaders)) {
    resolvedContext.loaders = null;
  }

  return resolvedContext;
}
function getLoadersFromContext(loaders, context) {
  if (!context && loaders && !Array.isArray(loaders)) {
    return loaders;
  }

  let candidateLoaders;

  if (loaders) {
    candidateLoaders = Array.isArray(loaders) ? loaders : [loaders];
  }

  if (context && context.loaders) {
    const contextLoaders = Array.isArray(context.loaders) ? context.loaders : [context.loaders];
    candidateLoaders = candidateLoaders ? [...candidateLoaders, ...contextLoaders] : contextLoaders;
  }

  return candidateLoaders && candidateLoaders.length ? candidateLoaders : null;
}
//# sourceMappingURL=loader-context.js.map
// EXTERNAL MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/utils/resource-utils.js + 1 modules
var resource_utils = __webpack_require__(29752);
// EXTERNAL MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/api/register-loaders.js
var register_loaders = __webpack_require__(6228);
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/api/select-loader.js





const EXT_PATTERN = /\.([^.]+)$/;
async function selectLoader(data, loaders = [], options, context) {
  if (!validHTTPResponse(data)) {
    return null;
  }

  let loader = selectLoaderSync(data, loaders, { ...options,
    nothrow: true
  }, context);

  if (loader) {
    return loader;
  }

  if ((0,is_type/* isBlob */.Lj)(data)) {
    data = await data.slice(0, 10).arrayBuffer();
    loader = selectLoaderSync(data, loaders, options, context);
  }

  if (!loader && !(options !== null && options !== void 0 && options.nothrow)) {
    throw new Error(getNoValidLoaderMessage(data));
  }

  return loader;
}
function selectLoaderSync(data, loaders = [], options, context) {
  if (!validHTTPResponse(data)) {
    return null;
  }

  if (loaders && !Array.isArray(loaders)) {
    return (0,normalize_loader/* normalizeLoader */.T)(loaders);
  }

  let candidateLoaders = [];

  if (loaders) {
    candidateLoaders = candidateLoaders.concat(loaders);
  }

  if (!(options !== null && options !== void 0 && options.ignoreRegisteredLoaders)) {
    candidateLoaders.push(...(0,register_loaders/* getRegisteredLoaders */.kO)());
  }

  normalizeLoaders(candidateLoaders);
  const loader = selectLoaderInternal(data, candidateLoaders, options, context);

  if (!loader && !(options !== null && options !== void 0 && options.nothrow)) {
    throw new Error(getNoValidLoaderMessage(data));
  }

  return loader;
}

function selectLoaderInternal(data, loaders, options, context) {
  const {
    url,
    type
  } = (0,resource_utils/* getResourceUrlAndType */.l)(data);
  const testUrl = url || (context === null || context === void 0 ? void 0 : context.url);
  let loader = null;

  if (options !== null && options !== void 0 && options.mimeType) {
    loader = findLoaderByMIMEType(loaders, options === null || options === void 0 ? void 0 : options.mimeType);
  }

  loader = loader || findLoaderByUrl(loaders, testUrl);
  loader = loader || findLoaderByMIMEType(loaders, type);
  loader = loader || findLoaderByInitialBytes(loaders, data);
  loader = loader || findLoaderByMIMEType(loaders, options === null || options === void 0 ? void 0 : options.fallbackMimeType);
  return loader;
}

function validHTTPResponse(data) {
  if (data instanceof Response) {
    if (data.status === 204) {
      return false;
    }
  }

  return true;
}

function getNoValidLoaderMessage(data) {
  const {
    url,
    type
  } = (0,resource_utils/* getResourceUrlAndType */.l)(data);
  let message = 'No valid loader found';

  if (data) {
    message += ` data: "${getFirstCharacters(data)}", contentType: "${type}"`;
  }

  if (url) {
    message += ` url: ${url}`;
  }

  return message;
}

function normalizeLoaders(loaders) {
  for (const loader of loaders) {
    (0,normalize_loader/* normalizeLoader */.T)(loader);
  }
}

function findLoaderByUrl(loaders, url) {
  const match = url && EXT_PATTERN.exec(url);
  const extension = match && match[1];
  return extension ? findLoaderByExtension(loaders, extension) : null;
}

function findLoaderByExtension(loaders, extension) {
  extension = extension.toLowerCase();

  for (const loader of loaders) {
    for (const loaderExtension of loader.extensions) {
      if (loaderExtension.toLowerCase() === extension) {
        return loader;
      }
    }
  }

  return null;
}

function findLoaderByMIMEType(loaders, mimeType) {
  for (const loader of loaders) {
    if (loader.mimeTypes && loader.mimeTypes.includes(mimeType)) {
      return loader;
    }

    if (mimeType === `application/x.${loader.id}`) {
      return loader;
    }
  }

  return null;
}

function findLoaderByInitialBytes(loaders, data) {
  if (!data) {
    return null;
  }

  for (const loader of loaders) {
    if (typeof data === 'string') {
      if (testDataAgainstText(data, loader)) {
        return loader;
      }
    } else if (ArrayBuffer.isView(data)) {
      if (testDataAgainstBinary(data.buffer, data.byteOffset, loader)) {
        return loader;
      }
    } else if (data instanceof ArrayBuffer) {
      const byteOffset = 0;

      if (testDataAgainstBinary(data, byteOffset, loader)) {
        return loader;
      }
    }
  }

  return null;
}

function testDataAgainstText(data, loader) {
  if (loader.testText) {
    return loader.testText(data);
  }

  const tests = Array.isArray(loader.tests) ? loader.tests : [loader.tests];
  return tests.some(test => data.startsWith(test));
}

function testDataAgainstBinary(data, byteOffset, loader) {
  const tests = Array.isArray(loader.tests) ? loader.tests : [loader.tests];
  return tests.some(test => testBinary(data, byteOffset, loader, test));
}

function testBinary(data, byteOffset, loader, test) {
  if (test instanceof ArrayBuffer) {
    return compareArrayBuffers(test, data, test.byteLength);
  }

  switch (typeof test) {
    case 'function':
      return test(data, loader);

    case 'string':
      const magic = getMagicString(data, byteOffset, test.length);
      return test === magic;

    default:
      return false;
  }
}

function getFirstCharacters(data, length = 5) {
  if (typeof data === 'string') {
    return data.slice(0, length);
  } else if (ArrayBuffer.isView(data)) {
    return getMagicString(data.buffer, data.byteOffset, length);
  } else if (data instanceof ArrayBuffer) {
    const byteOffset = 0;
    return getMagicString(data, byteOffset, length);
  }

  return '';
}

function getMagicString(arrayBuffer, byteOffset, length) {
  if (arrayBuffer.byteLength < byteOffset + length) {
    return '';
  }

  const dataView = new DataView(arrayBuffer);
  let magic = '';

  for (let i = 0; i < length; i++) {
    magic += String.fromCharCode(dataView.getUint8(byteOffset + i));
  }

  return magic;
}
//# sourceMappingURL=select-loader.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/api/parse.js








async function parse(data, loaders, options, context) {
  assert(!context || typeof context === 'object');

  if (loaders && !Array.isArray(loaders) && !(0,normalize_loader/* isLoaderObject */.C)(loaders)) {
    context = undefined;
    options = loaders;
    loaders = undefined;
  }

  data = await data;
  options = options || {};
  const {
    url
  } = (0,resource_utils/* getResourceUrlAndType */.l)(data);
  const typedLoaders = loaders;
  const candidateLoaders = getLoadersFromContext(typedLoaders, context);
  const loader = await selectLoader(data, candidateLoaders, options);

  if (!loader) {
    return null;
  }

  options = (0,option_utils/* normalizeOptions */.GR)(options, loader, candidateLoaders, url);
  context = getLoaderContext({
    url,
    parse,
    loaders: candidateLoaders
  }, options, context);
  return await parseWithLoader(loader, data, options, context);
}

async function parseWithLoader(loader, data, options, context) {
  validateWorkerVersion(loader);
  data = await getArrayBufferOrStringFromData(data, loader, options);

  if (loader.parseTextSync && typeof data === 'string') {
    options.dataType = 'text';
    return loader.parseTextSync(data, options, context, loader);
  }

  if (canParseWithWorker(loader, options)) {
    return await parseWithWorker(loader, data, options, context, parse);
  }

  if (loader.parseText && typeof data === 'string') {
    return await loader.parseText(data, options, context, loader);
  }

  if (loader.parse) {
    return await loader.parse(data, options, context, loader);
  }

  assert(!loader.parseSync);
  throw new Error(`${loader.id} loader - no parser found and worker is disabled`);
}
//# sourceMappingURL=parse.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/api/load.js




async function load(url, loaders, options, context) {
  if (!Array.isArray(loaders) && !(0,normalize_loader/* isLoaderObject */.C)(loaders)) {
    context = undefined;
    options = loaders;
    loaders = undefined;
  }

  const fetch = (0,option_utils/* getFetchFunction */.bV)(options);
  let data = url;

  if (typeof url === 'string') {
    data = await fetch(url);
  }

  if ((0,is_type/* isBlob */.Lj)(url)) {
    data = await fetch(url);
  }

  return await parse(data, loaders, options);
}
//# sourceMappingURL=load.js.map

/***/ }),

/***/ 6228:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "fh": () => (/* binding */ registerLoaders),
/* harmony export */   "kO": () => (/* binding */ getRegisteredLoaders)
/* harmony export */ });
/* unused harmony export _unregisterLoaders */
/* harmony import */ var _loader_utils_normalize_loader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75596);
/* harmony import */ var _loader_utils_option_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77504);



const getGlobalLoaderRegistry = () => {
  const state = (0,_loader_utils_option_utils__WEBPACK_IMPORTED_MODULE_0__/* .getGlobalLoaderState */ .rx)();
  state.loaderRegistry = state.loaderRegistry || [];
  return state.loaderRegistry;
};

function registerLoaders(loaders) {
  const loaderRegistry = getGlobalLoaderRegistry();
  loaders = Array.isArray(loaders) ? loaders : [loaders];

  for (const loader of loaders) {
    const normalizedLoader = (0,_loader_utils_normalize_loader__WEBPACK_IMPORTED_MODULE_1__/* .normalizeLoader */ .T)(loader);

    if (!loaderRegistry.find(registeredLoader => normalizedLoader === registeredLoader)) {
      loaderRegistry.unshift(normalizedLoader);
    }
  }
}
function getRegisteredLoaders() {
  return getGlobalLoaderRegistry();
}
function _unregisterLoaders() {
  const state = getGlobalLoaderState();
  state.loaderRegistry = [];
}
//# sourceMappingURL=register-loaders.js.map

/***/ }),

/***/ 75596:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "C": () => (/* binding */ isLoaderObject),
  "T": () => (/* binding */ normalizeLoader)
});

;// CONCATENATED MODULE: ./node_modules/@loaders.gl/loader-utils/dist/esm/lib/env-utils/assert.js
function assert(condition, message) {
  if (!condition) {
    throw new Error(message || 'loader assertion failed.');
  }
}
//# sourceMappingURL=assert.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/normalize-loader.js

function isLoaderObject(loader) {
  var _loader;

  if (!loader) {
    return false;
  }

  if (Array.isArray(loader)) {
    loader = loader[0];
  }

  const hasExtensions = Array.isArray((_loader = loader) === null || _loader === void 0 ? void 0 : _loader.extensions);
  return hasExtensions;
}
function normalizeLoader(loader) {
  var _loader2, _loader3;

  assert(loader, 'null loader');
  assert(isLoaderObject(loader), 'invalid loader');
  let options;

  if (Array.isArray(loader)) {
    options = loader[1];
    loader = loader[0];
    loader = { ...loader,
      options: { ...loader.options,
        ...options
      }
    };
  }

  if ((_loader2 = loader) !== null && _loader2 !== void 0 && _loader2.parseTextSync || (_loader3 = loader) !== null && _loader3 !== void 0 && _loader3.parseText) {
    loader.text = true;
  }

  if (!loader.text) {
    loader.binary = true;
  }

  return loader;
}
//# sourceMappingURL=normalize-loader.js.map

/***/ }),

/***/ 77504:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "bV": () => (/* binding */ getFetchFunction),
  "rx": () => (/* binding */ getGlobalLoaderState),
  "GR": () => (/* binding */ normalizeOptions)
});

// UNUSED EXPORTS: setGlobalOptions

// EXTERNAL MODULE: ./node_modules/@loaders.gl/loader-utils/dist/esm/lib/env-utils/globals.js
var globals = __webpack_require__(84959);
// EXTERNAL MODULE: ./node_modules/@loaders.gl/core/dist/esm/javascript-utils/is-type.js
var is_type = __webpack_require__(36255);
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/loader-utils/dist/esm/lib/path-utils/file-aliases.js
let pathPrefix = '';
const fileAliases = {};
function setPathPrefix(prefix) {
  pathPrefix = prefix;
}
function getPathPrefix() {
  return pathPrefix;
}
function addAliases(aliases) {
  Object.assign(fileAliases, aliases);
}
function resolvePath(filename) {
  for (const alias in fileAliases) {
    if (filename.startsWith(alias)) {
      const replacement = fileAliases[alias];
      filename = filename.replace(alias, replacement);
    }
  }

  if (!filename.startsWith('http://') && !filename.startsWith('https://')) {
    filename = `${pathPrefix}${filename}`;
  }

  return filename;
}
//# sourceMappingURL=file-aliases.js.map
// EXTERNAL MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/utils/response-utils.js
var response_utils = __webpack_require__(17927);
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/fetch/fetch-file.js


async function fetchFile(url, options) {
  if (typeof url === 'string') {
    url = resolvePath(url);
    let fetchOptions = options;

    if (options !== null && options !== void 0 && options.fetch && typeof (options === null || options === void 0 ? void 0 : options.fetch) !== 'function') {
      fetchOptions = options.fetch;
    }

    return await fetch(url, fetchOptions);
  }

  return await (0,response_utils/* makeResponse */.L1)(url);
}
//# sourceMappingURL=fetch-file.js.map
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/defineProperty.js
var defineProperty = __webpack_require__(4942);
// EXTERNAL MODULE: ./node_modules/probe.gl/dist/esm/lib/log.js + 7 modules
var log = __webpack_require__(44708);
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/loggers.js


const probeLog = new log/* default */.Z({
  id: 'loaders.gl'
});
class NullLog {
  log() {
    return () => {};
  }

  info() {
    return () => {};
  }

  warn() {
    return () => {};
  }

  error() {
    return () => {};
  }

}
class ConsoleLog {
  constructor() {
    (0,defineProperty/* default */.Z)(this, "console", void 0);

    this.console = console;
  }

  log(...args) {
    return this.console.log.bind(this.console, ...args);
  }

  info(...args) {
    return this.console.info.bind(this.console, ...args);
  }

  warn(...args) {
    return this.console.warn.bind(this.console, ...args);
  }

  error(...args) {
    return this.console.error.bind(this.console, ...args);
  }

}
//# sourceMappingURL=loggers.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/option-defaults.js

const DEFAULT_LOADER_OPTIONS = {
  fetch: null,
  mimeType: undefined,
  nothrow: false,
  log: new ConsoleLog(),
  CDN: 'https://unpkg.com/@loaders.gl',
  worker: true,
  maxConcurrency: 3,
  maxMobileConcurrency: 1,
  reuseWorkers: true,
  _workerType: '',
  limit: 0,
  _limitMB: 0,
  batchSize: 'auto',
  batchDebounceMs: 0,
  metadata: false,
  transforms: []
};
const REMOVED_LOADER_OPTIONS = {
  throws: 'nothrow',
  dataType: '(no longer used)',
  uri: 'baseUri',
  method: 'fetch.method',
  headers: 'fetch.headers',
  body: 'fetch.body',
  mode: 'fetch.mode',
  credentials: 'fetch.credentials',
  cache: 'fetch.cache',
  redirect: 'fetch.redirect',
  referrer: 'fetch.referrer',
  referrerPolicy: 'fetch.referrerPolicy',
  integrity: 'fetch.integrity',
  keepalive: 'fetch.keepalive',
  signal: 'fetch.signal'
};
//# sourceMappingURL=option-defaults.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/option-utils.js





function getGlobalLoaderState() {
  globals/* global.loaders */.CO.loaders = globals/* global.loaders */.CO.loaders || {};
  const {
    loaders
  } = globals/* global */.CO;
  loaders._state = loaders._state || {};
  return loaders._state;
}

const getGlobalLoaderOptions = () => {
  const state = getGlobalLoaderState();
  state.globalOptions = state.globalOptions || { ...DEFAULT_LOADER_OPTIONS
  };
  return state.globalOptions;
};

function setGlobalOptions(options) {
  const state = getGlobalLoaderState();
  const globalOptions = getGlobalLoaderOptions();
  state.globalOptions = normalizeOptionsInternal(globalOptions, options);
}
function normalizeOptions(options, loader, loaders, url) {
  loaders = loaders || [];
  loaders = Array.isArray(loaders) ? loaders : [loaders];
  validateOptions(options, loaders);
  return normalizeOptionsInternal(loader, options, url);
}
function getFetchFunction(options, context) {
  const globalOptions = getGlobalLoaderOptions();
  const fetchOptions = options || globalOptions;

  if (typeof fetchOptions.fetch === 'function') {
    return fetchOptions.fetch;
  }

  if ((0,is_type/* isObject */.Kn)(fetchOptions.fetch)) {
    return url => fetchFile(url, fetchOptions);
  }

  if (context !== null && context !== void 0 && context.fetch) {
    return context === null || context === void 0 ? void 0 : context.fetch;
  }

  return fetchFile;
}

function validateOptions(options, loaders) {
  validateOptionsObject(options, null, DEFAULT_LOADER_OPTIONS, REMOVED_LOADER_OPTIONS, loaders);

  for (const loader of loaders) {
    const idOptions = options && options[loader.id] || {};
    const loaderOptions = loader.options && loader.options[loader.id] || {};
    const deprecatedOptions = loader.deprecatedOptions && loader.deprecatedOptions[loader.id] || {};
    validateOptionsObject(idOptions, loader.id, loaderOptions, deprecatedOptions, loaders);
  }
}

function validateOptionsObject(options, id, defaultOptions, deprecatedOptions, loaders) {
  const loaderName = id || 'Top level';
  const prefix = id ? `${id}.` : '';

  for (const key in options) {
    const isSubOptions = !id && (0,is_type/* isObject */.Kn)(options[key]);
    const isBaseUriOption = key === 'baseUri' && !id;
    const isWorkerUrlOption = key === 'workerUrl' && id;

    if (!(key in defaultOptions) && !isBaseUriOption && !isWorkerUrlOption) {
      if (key in deprecatedOptions) {
        probeLog.warn(`${loaderName} loader option \'${prefix}${key}\' no longer supported, use \'${deprecatedOptions[key]}\'`)();
      } else if (!isSubOptions) {
        const suggestion = findSimilarOption(key, loaders);
        probeLog.warn(`${loaderName} loader option \'${prefix}${key}\' not recognized. ${suggestion}`)();
      }
    }
  }
}

function findSimilarOption(optionKey, loaders) {
  const lowerCaseOptionKey = optionKey.toLowerCase();
  let bestSuggestion = '';

  for (const loader of loaders) {
    for (const key in loader.options) {
      if (optionKey === key) {
        return `Did you mean \'${loader.id}.${key}\'?`;
      }

      const lowerCaseKey = key.toLowerCase();
      const isPartialMatch = lowerCaseOptionKey.startsWith(lowerCaseKey) || lowerCaseKey.startsWith(lowerCaseOptionKey);

      if (isPartialMatch) {
        bestSuggestion = bestSuggestion || `Did you mean \'${loader.id}.${key}\'?`;
      }
    }
  }

  return bestSuggestion;
}

function normalizeOptionsInternal(loader, options, url) {
  const loaderDefaultOptions = loader.options || {};
  const mergedOptions = { ...loaderDefaultOptions
  };
  addUrlOptions(mergedOptions, url);

  if (mergedOptions.log === null) {
    mergedOptions.log = new NullLog();
  }

  mergeNestedFields(mergedOptions, getGlobalLoaderOptions());
  mergeNestedFields(mergedOptions, options);
  return mergedOptions;
}

function mergeNestedFields(mergedOptions, options) {
  for (const key in options) {
    if (key in options) {
      const value = options[key];

      if ((0,is_type/* isPureObject */.Ss)(value) && (0,is_type/* isPureObject */.Ss)(mergedOptions[key])) {
        mergedOptions[key] = { ...mergedOptions[key],
          ...options[key]
        };
      } else {
        mergedOptions[key] = options[key];
      }
    }
  }
}

function addUrlOptions(options, url) {
  if (url && !('baseUri' in options)) {
    options.baseUri = url;
  }
}
//# sourceMappingURL=option-utils.js.map

/***/ }),

/***/ 29752:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "C": () => (/* binding */ getResourceContentLength),
  "l": () => (/* binding */ getResourceUrlAndType)
});

// EXTERNAL MODULE: ./node_modules/@loaders.gl/core/dist/esm/javascript-utils/is-type.js
var is_type = __webpack_require__(36255);
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/utils/mime-type-utils.js
const DATA_URL_PATTERN = /^data:([-\w.]+\/[-\w.+]+)(;|,)/;
const MIME_TYPE_PATTERN = /^([-\w.]+\/[-\w.+]+)/;
function parseMIMEType(mimeString) {
  const matches = MIME_TYPE_PATTERN.exec(mimeString);

  if (matches) {
    return matches[1];
  }

  return mimeString;
}
function parseMIMETypeFromURL(url) {
  const matches = DATA_URL_PATTERN.exec(url);

  if (matches) {
    return matches[1];
  }

  return '';
}
//# sourceMappingURL=mime-type-utils.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/utils/resource-utils.js


const QUERY_STRING_PATTERN = /\?.*/;
function getResourceUrlAndType(resource) {
  if ((0,is_type/* isResponse */.Ew)(resource)) {
    const url = stripQueryString(resource.url || '');
    const contentTypeHeader = resource.headers.get('content-type') || '';
    return {
      url,
      type: parseMIMEType(contentTypeHeader) || parseMIMETypeFromURL(url)
    };
  }

  if ((0,is_type/* isBlob */.Lj)(resource)) {
    return {
      url: stripQueryString(resource.name || ''),
      type: resource.type || ''
    };
  }

  if (typeof resource === 'string') {
    return {
      url: stripQueryString(resource),
      type: parseMIMETypeFromURL(resource)
    };
  }

  return {
    url: '',
    type: ''
  };
}
function getResourceContentLength(resource) {
  if ((0,is_type/* isResponse */.Ew)(resource)) {
    return resource.headers['content-length'] || -1;
  }

  if ((0,is_type/* isBlob */.Lj)(resource)) {
    return resource.size;
  }

  if (typeof resource === 'string') {
    return resource.length;
  }

  if (resource instanceof ArrayBuffer) {
    return resource.byteLength;
  }

  if (ArrayBuffer.isView(resource)) {
    return resource.byteLength;
  }

  return -1;
}

function stripQueryString(url) {
  return url.replace(QUERY_STRING_PATTERN, '');
}
//# sourceMappingURL=resource-utils.js.map

/***/ }),

/***/ 17927:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "L1": () => (/* binding */ makeResponse),
/* harmony export */   "mm": () => (/* binding */ checkResponse)
/* harmony export */ });
/* unused harmony export checkResponseSync */
/* harmony import */ var _javascript_utils_is_type__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36255);
/* harmony import */ var _resource_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29752);


async function makeResponse(resource) {
  if ((0,_javascript_utils_is_type__WEBPACK_IMPORTED_MODULE_0__/* .isResponse */ .Ew)(resource)) {
    return resource;
  }

  const headers = {};
  const contentLength = (0,_resource_utils__WEBPACK_IMPORTED_MODULE_1__/* .getResourceContentLength */ .C)(resource);

  if (contentLength >= 0) {
    headers['content-length'] = String(contentLength);
  }

  const {
    url,
    type
  } = (0,_resource_utils__WEBPACK_IMPORTED_MODULE_1__/* .getResourceUrlAndType */ .l)(resource);

  if (type) {
    headers['content-type'] = type;
  }

  const initialDataUrl = await getInitialDataUrl(resource);

  if (initialDataUrl) {
    headers['x-first-bytes'] = initialDataUrl;
  }

  if (typeof resource === 'string') {
    resource = new TextEncoder().encode(resource);
  }

  const response = new Response(resource, {
    headers
  });
  Object.defineProperty(response, 'url', {
    value: url
  });
  return response;
}
async function checkResponse(response) {
  if (!response.ok) {
    const message = await getResponseError(response);
    throw new Error(message);
  }
}
function checkResponseSync(response) {
  if (!response.ok) {
    let message = `${response.status} ${response.statusText}`;
    message = message.length > 60 ? `${message.slice(60)}...` : message;
    throw new Error(message);
  }
}

async function getResponseError(response) {
  let message = `Failed to fetch resource ${response.url} (${response.status}): `;

  try {
    const contentType = response.headers.get('Content-Type');
    let text = response.statusText;

    if (contentType.includes('application/json')) {
      text += ` ${await response.text()}`;
    }

    message += text;
    message = message.length > 60 ? `${message.slice(60)}...` : message;
  } catch (error) {}

  return message;
}

async function getInitialDataUrl(resource) {
  const INITIAL_DATA_LENGTH = 5;

  if (typeof resource === 'string') {
    return `data:,${resource.slice(0, INITIAL_DATA_LENGTH)}`;
  }

  if (resource instanceof Blob) {
    const blobSlice = resource.slice(0, 5);
    return await new Promise(resolve => {
      const reader = new FileReader();

      reader.onload = event => {
        var _event$target;

        return resolve(event === null || event === void 0 ? void 0 : (_event$target = event.target) === null || _event$target === void 0 ? void 0 : _event$target.result);
      };

      reader.readAsDataURL(blobSlice);
    });
  }

  if (resource instanceof ArrayBuffer) {
    const slice = resource.slice(0, INITIAL_DATA_LENGTH);
    const base64 = arrayBufferToBase64(slice);
    return `data:base64,${base64}`;
  }

  return null;
}

function arrayBufferToBase64(buffer) {
  let binary = '';
  const bytes = new Uint8Array(buffer);

  for (let i = 0; i < bytes.byteLength; i++) {
    binary += String.fromCharCode(bytes[i]);
  }

  return btoa(binary);
}
//# sourceMappingURL=response-utils.js.map

/***/ }),

/***/ 98949:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "S": () => (/* binding */ ImageLoader)
});

// UNUSED EXPORTS: _typecheckImageLoader

;// CONCATENATED MODULE: ./node_modules/@loaders.gl/images/dist/esm/lib/utils/version.js
const VERSION =  true ? "3.0.8" : 0;
//# sourceMappingURL=version.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/images/dist/esm/lib/utils/assert.js
function assert(condition, message) {
  if (!condition) {
    throw new Error(message);
  }
}
//# sourceMappingURL=assert.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/images/dist/esm/lib/utils/globals.js
/* provided dependency */ var process = __webpack_require__(34155);
const globals = {
  self: typeof self !== 'undefined' && self,
  window: typeof window !== 'undefined' && window,
  global: typeof __webpack_require__.g !== 'undefined' && __webpack_require__.g,
  document: typeof document !== 'undefined' && document
};
const self_ = globals.self || globals.window || globals.global;
const window_ = globals.window || globals.self || globals.global;
const global_ = globals.global || globals.self || globals.window;
const document_ = globals.document || {};

const isBrowser = typeof process !== 'object' || String(process) !== '[object process]' || process.browser;
const isWorker = typeof importScripts === 'function';
const matches = typeof process !== 'undefined' && process.version && /v([0-9]*)/.exec(process.version);
const nodeVersion = matches && parseFloat(matches[1]) || 0;
//# sourceMappingURL=globals.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/images/dist/esm/lib/category-api/image-type.js

const {
  _parseImageNode
} = global_;
const IMAGE_SUPPORTED = typeof Image !== 'undefined';
const IMAGE_BITMAP_SUPPORTED = typeof ImageBitmap !== 'undefined';
const NODE_IMAGE_SUPPORTED = Boolean(_parseImageNode);
const DATA_SUPPORTED = isBrowser ? true : NODE_IMAGE_SUPPORTED;
function isImageTypeSupported(type) {
  switch (type) {
    case 'auto':
      return IMAGE_BITMAP_SUPPORTED || IMAGE_SUPPORTED || DATA_SUPPORTED;

    case 'imagebitmap':
      return IMAGE_BITMAP_SUPPORTED;

    case 'image':
      return IMAGE_SUPPORTED;

    case 'data':
      return DATA_SUPPORTED;

    default:
      throw new Error(`@loaders.gl/images: image ${type} not supported in this environment`);
  }
}
function getDefaultImageType() {
  if (IMAGE_BITMAP_SUPPORTED) {
    return 'imagebitmap';
  }

  if (IMAGE_SUPPORTED) {
    return 'image';
  }

  if (DATA_SUPPORTED) {
    return 'data';
  }

  throw new Error('Install \'@loaders.gl/polyfills\' to parse images under Node.js');
}
//# sourceMappingURL=image-type.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/images/dist/esm/lib/category-api/parsed-image-api.js
function isImage(image) {
  return Boolean(getImageTypeOrNull(image));
}
function deleteImage(image) {
  switch (getImageType(image)) {
    case 'imagebitmap':
      image.close();
      break;

    default:
  }
}
function getImageType(image) {
  const format = getImageTypeOrNull(image);

  if (!format) {
    throw new Error('Not an image');
  }

  return format;
}
function getImageSize(image) {
  return getImageData(image);
}
function getImageData(image) {
  switch (getImageType(image)) {
    case 'data':
      return image;

    case 'image':
    case 'imagebitmap':
      const canvas = document.createElement('canvas');
      const context = canvas.getContext('2d');

      if (!context) {
        throw new Error('getImageData');
      }

      canvas.width = image.width;
      canvas.height = image.height;
      context.drawImage(image, 0, 0);
      return context.getImageData(0, 0, image.width, image.height);

    default:
      throw new Error('getImageData');
  }
}

function getImageTypeOrNull(image) {
  if (typeof ImageBitmap !== 'undefined' && image instanceof ImageBitmap) {
    return 'imagebitmap';
  }

  if (typeof Image !== 'undefined' && image instanceof Image) {
    return 'image';
  }

  if (image && typeof image === 'object' && image.data && image.width && image.height) {
    return 'data';
  }

  return null;
}
//# sourceMappingURL=parsed-image-api.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/images/dist/esm/lib/parsers/svg-utils.js
const SVG_DATA_URL_PATTERN = /^data:image\/svg\+xml/;
const SVG_URL_PATTERN = /\.svg((\?|#).*)?$/;
function isSVG(url) {
  return url && (SVG_DATA_URL_PATTERN.test(url) || SVG_URL_PATTERN.test(url));
}
function getBlobOrSVGDataUrl(arrayBuffer, url) {
  if (isSVG(url)) {
    const textDecoder = new TextDecoder();
    const xmlText = textDecoder.decode(arrayBuffer);
    const src = `data:image/svg+xml;base64,${btoa(xmlText)}`;
    return src;
  }

  return getBlob(arrayBuffer, url);
}
function getBlob(arrayBuffer, url) {
  if (isSVG(url)) {
    throw new Error('SVG cannot be parsed directly to imagebitmap');
  }

  return new Blob([new Uint8Array(arrayBuffer)]);
}
//# sourceMappingURL=svg-utils.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/images/dist/esm/lib/parsers/parse-to-image.js

async function parseToImage(arrayBuffer, options, url) {
  const blobOrDataUrl = getBlobOrSVGDataUrl(arrayBuffer, url);
  const URL = self.URL || self.webkitURL;
  const objectUrl = typeof blobOrDataUrl !== 'string' && URL.createObjectURL(blobOrDataUrl);

  try {
    return await loadToImage(objectUrl || blobOrDataUrl, options);
  } finally {
    if (objectUrl) {
      URL.revokeObjectURL(objectUrl);
    }
  }
}
async function loadToImage(url, options) {
  const image = new Image();
  image.src = url;

  if (options.image && options.image.decode && image.decode) {
    await image.decode();
    return image;
  }

  return await new Promise((resolve, reject) => {
    try {
      image.onload = () => resolve(image);

      image.onerror = err => reject(new Error(`Could not load image ${url}: ${err}`));
    } catch (error) {
      reject(error);
    }
  });
}
//# sourceMappingURL=parse-to-image.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/images/dist/esm/lib/parsers/parse-to-image-bitmap.js


const EMPTY_OBJECT = {};
let imagebitmapOptionsSupported = true;
async function parseToImageBitmap(arrayBuffer, options, url) {
  let blob;

  if (isSVG(url)) {
    const image = await parseToImage(arrayBuffer, options, url);
    blob = image;
  } else {
    blob = getBlob(arrayBuffer, url);
  }

  const imagebitmapOptions = options && options.imagebitmap;
  return await safeCreateImageBitmap(blob, imagebitmapOptions);
}

async function safeCreateImageBitmap(blob, imagebitmapOptions = null) {
  if (isEmptyObject(imagebitmapOptions) || !imagebitmapOptionsSupported) {
    imagebitmapOptions = null;
  }

  if (imagebitmapOptions) {
    try {
      return await createImageBitmap(blob, imagebitmapOptions);
    } catch (error) {
      console.warn(error);
      imagebitmapOptionsSupported = false;
    }
  }

  return await createImageBitmap(blob);
}

function isEmptyObject(object) {
  for (const key in object || EMPTY_OBJECT) {
    return false;
  }

  return true;
}
//# sourceMappingURL=parse-to-image-bitmap.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/images/dist/esm/lib/category-api/binary-image-api.js
const BIG_ENDIAN = false;
const LITTLE_ENDIAN = true;
function getBinaryImageMetadata(binaryData) {
  const dataView = toDataView(binaryData);
  return getPngMetadata(dataView) || getJpegMetadata(dataView) || getGifMetadata(dataView) || getBmpMetadata(dataView);
}

function getPngMetadata(binaryData) {
  const dataView = toDataView(binaryData);
  const isPng = dataView.byteLength >= 24 && dataView.getUint32(0, BIG_ENDIAN) === 0x89504e47;

  if (!isPng) {
    return null;
  }

  return {
    mimeType: 'image/png',
    width: dataView.getUint32(16, BIG_ENDIAN),
    height: dataView.getUint32(20, BIG_ENDIAN)
  };
}

function getGifMetadata(binaryData) {
  const dataView = toDataView(binaryData);
  const isGif = dataView.byteLength >= 10 && dataView.getUint32(0, BIG_ENDIAN) === 0x47494638;

  if (!isGif) {
    return null;
  }

  return {
    mimeType: 'image/gif',
    width: dataView.getUint16(6, LITTLE_ENDIAN),
    height: dataView.getUint16(8, LITTLE_ENDIAN)
  };
}

function getBmpMetadata(binaryData) {
  const dataView = toDataView(binaryData);
  const isBmp = dataView.byteLength >= 14 && dataView.getUint16(0, BIG_ENDIAN) === 0x424d && dataView.getUint32(2, LITTLE_ENDIAN) === dataView.byteLength;

  if (!isBmp) {
    return null;
  }

  return {
    mimeType: 'image/bmp',
    width: dataView.getUint32(18, LITTLE_ENDIAN),
    height: dataView.getUint32(22, LITTLE_ENDIAN)
  };
}

function getJpegMetadata(binaryData) {
  const dataView = toDataView(binaryData);
  const isJpeg = dataView.byteLength >= 3 && dataView.getUint16(0, BIG_ENDIAN) === 0xffd8 && dataView.getUint8(2) === 0xff;

  if (!isJpeg) {
    return null;
  }

  const {
    tableMarkers,
    sofMarkers
  } = getJpegMarkers();
  let i = 2;

  while (i + 9 < dataView.byteLength) {
    const marker = dataView.getUint16(i, BIG_ENDIAN);

    if (sofMarkers.has(marker)) {
      return {
        mimeType: 'image/jpeg',
        height: dataView.getUint16(i + 5, BIG_ENDIAN),
        width: dataView.getUint16(i + 7, BIG_ENDIAN)
      };
    }

    if (!tableMarkers.has(marker)) {
      return null;
    }

    i += 2;
    i += dataView.getUint16(i, BIG_ENDIAN);
  }

  return null;
}

function getJpegMarkers() {
  const tableMarkers = new Set([0xffdb, 0xffc4, 0xffcc, 0xffdd, 0xfffe]);

  for (let i = 0xffe0; i < 0xfff0; ++i) {
    tableMarkers.add(i);
  }

  const sofMarkers = new Set([0xffc0, 0xffc1, 0xffc2, 0xffc3, 0xffc5, 0xffc6, 0xffc7, 0xffc9, 0xffca, 0xffcb, 0xffcd, 0xffce, 0xffcf, 0xffde]);
  return {
    tableMarkers,
    sofMarkers
  };
}

function toDataView(data) {
  if (data instanceof DataView) {
    return data;
  }

  if (ArrayBuffer.isView(data)) {
    return new DataView(data.buffer);
  }

  if (data instanceof ArrayBuffer) {
    return new DataView(data);
  }

  throw new Error('toDataView');
}
//# sourceMappingURL=binary-image-api.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/images/dist/esm/lib/parsers/parse-to-node-image.js



function parseToNodeImage(arrayBuffer, options) {
  const {
    mimeType
  } = getBinaryImageMetadata(arrayBuffer) || {};
  const {
    _parseImageNode
  } = global_;
  assert(_parseImageNode);
  return _parseImageNode(arrayBuffer, mimeType, options);
}
//# sourceMappingURL=parse-to-node-image.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/images/dist/esm/lib/parsers/parse-image.js






async function parseImage(arrayBuffer, options, context) {
  options = options || {};
  const imageOptions = options.image || {};
  const imageType = imageOptions.type || 'auto';
  const {
    url
  } = context || {};
  const loadType = getLoadableImageType(imageType);
  let image;

  switch (loadType) {
    case 'imagebitmap':
      image = await parseToImageBitmap(arrayBuffer, options, url);
      break;

    case 'image':
      image = await parseToImage(arrayBuffer, options, url);
      break;

    case 'data':
      image = await parseToNodeImage(arrayBuffer, options);
      break;

    default:
      assert(false);
  }

  if (imageType === 'data') {
    image = getImageData(image);
  }

  return image;
}

function getLoadableImageType(type) {
  switch (type) {
    case 'auto':
    case 'data':
      return getDefaultImageType();

    default:
      isImageTypeSupported(type);
      return type;
  }
}
//# sourceMappingURL=parse-image.js.map
;// CONCATENATED MODULE: ./node_modules/@loaders.gl/images/dist/esm/image-loader.js



const EXTENSIONS = ['png', 'jpg', 'jpeg', 'gif', 'webp', 'bmp', 'ico', 'svg'];
const MIME_TYPES = ['image/png', 'image/jpeg', 'image/gif', 'image/webp', 'image/bmp', 'image/vnd.microsoft.icon', 'image/svg+xml'];
const ImageLoader = {
  id: 'image',
  module: 'images',
  name: 'Images',
  version: VERSION,
  mimeTypes: MIME_TYPES,
  extensions: EXTENSIONS,
  parse: parseImage,
  tests: [arrayBuffer => Boolean(getBinaryImageMetadata(new DataView(arrayBuffer)))],
  options: {
    image: {
      type: 'auto',
      decode: true
    }
  }
};
const _typecheckImageLoader = (/* unused pure expression or super */ null && (ImageLoader));
//# sourceMappingURL=image-loader.js.map

/***/ }),

/***/ 84959:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CO": () => (/* binding */ global_),
/* harmony export */   "jU": () => (/* binding */ isBrowser)
/* harmony export */ });
/* unused harmony exports self, window, document, isWorker, nodeVersion */
/* provided dependency */ var process = __webpack_require__(34155);
const globals = {
  self: typeof self !== 'undefined' && self,
  window: typeof window !== 'undefined' && window,
  global: typeof __webpack_require__.g !== 'undefined' && __webpack_require__.g,
  document: typeof document !== 'undefined' && document
};
const self_ = globals.self || globals.window || globals.global || {};
const window_ = globals.window || globals.self || globals.global || {};
const global_ = globals.global || globals.self || globals.window || {};
const document_ = globals.document || {};

const isBrowser = typeof process !== 'object' || String(process) !== '[object process]' || process.browser;
const isWorker = typeof importScripts === 'function';
const matches = typeof process !== 'undefined' && process.version && /v([0-9]*)/.exec(process.version);
const nodeVersion = matches && parseFloat(matches[1]) || 0;
//# sourceMappingURL=globals.js.map

/***/ }),

/***/ 53982:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Geometry)
/* harmony export */ });
/* unused harmony export DRAW_MODE */
/* harmony import */ var _luma_gl_webgl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(74538);
/* harmony import */ var _luma_gl_webgl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22525);

const DRAW_MODE = {
  POINTS: 0x0000,
  LINES: 0x0001,
  LINE_LOOP: 0x0002,
  LINE_STRIP: 0x0003,
  TRIANGLES: 0x0004,
  TRIANGLE_STRIP: 0x0005,
  TRIANGLE_FAN: 0x0006
};
class Geometry {
  static get DRAW_MODE() {
    return DRAW_MODE;
  }

  constructor(props = {}) {
    const {
      id = (0,_luma_gl_webgl__WEBPACK_IMPORTED_MODULE_0__/* .uid */ .hQ)('geometry'),
      drawMode = DRAW_MODE.TRIANGLES,
      attributes = {},
      indices = null,
      vertexCount = null
    } = props;
    this.id = id;
    this.drawMode = drawMode | 0;
    this.attributes = {};
    this.userData = {};

    this._setAttributes(attributes, indices);

    this.vertexCount = vertexCount || this._calculateVertexCount(this.attributes, this.indices);
  }

  get mode() {
    return this.drawMode;
  }

  getVertexCount() {
    return this.vertexCount;
  }

  getAttributes() {
    return this.indices ? {
      indices: this.indices,
      ...this.attributes
    } : this.attributes;
  }

  _print(attributeName) {
    return "Geometry ".concat(this.id, " attribute ").concat(attributeName);
  }

  _setAttributes(attributes, indices) {
    if (indices) {
      this.indices = ArrayBuffer.isView(indices) ? {
        value: indices,
        size: 1
      } : indices;
    }

    for (const attributeName in attributes) {
      let attribute = attributes[attributeName];
      attribute = ArrayBuffer.isView(attribute) ? {
        value: attribute
      } : attribute;
      (0,_luma_gl_webgl__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(ArrayBuffer.isView(attribute.value), "".concat(this._print(attributeName), ": must be typed array or object with value as typed array"));

      if ((attributeName === 'POSITION' || attributeName === 'positions') && !attribute.size) {
        attribute.size = 3;
      }

      if (attributeName === 'indices') {
        (0,_luma_gl_webgl__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(!this.indices);
        this.indices = attribute;
      } else {
        this.attributes[attributeName] = attribute;
      }
    }

    if (this.indices && this.indices.isIndexed !== undefined) {
      this.indices = Object.assign({}, this.indices);
      delete this.indices.isIndexed;
    }

    return this;
  }

  _calculateVertexCount(attributes, indices) {
    if (indices) {
      return indices.value.length;
    }

    let vertexCount = Infinity;

    for (const attributeName in attributes) {
      const attribute = attributes[attributeName];
      const {
        value,
        size,
        constant
      } = attribute;

      if (!constant && value && size >= 1) {
        vertexCount = Math.min(vertexCount, value.length / size);
      }
    }

    (0,_luma_gl_webgl__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(Number.isFinite(vertexCount));
    return vertexCount;
  }

}
//# sourceMappingURL=geometry.js.map

/***/ }),

/***/ 281:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Model)
});

// EXTERNAL MODULE: ./node_modules/@luma.gl/gltools/dist/esm/index.js + 13 modules
var esm = __webpack_require__(39450);
// EXTERNAL MODULE: ./node_modules/@luma.gl/engine/dist/esm/lib/program-manager.js + 8 modules
var program_manager = __webpack_require__(68432);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/accessor.js
var classes_accessor = __webpack_require__(14072);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/buffer.js
var classes_buffer = __webpack_require__(53478);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/resource.js
var resource = __webpack_require__(87577);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/array-utils-flat.js
let arrayBuffer = null;
function getScratchArrayBuffer(byteLength) {
  if (!arrayBuffer || arrayBuffer.byteLength < byteLength) {
    arrayBuffer = new ArrayBuffer(byteLength);
  }

  return arrayBuffer;
}
function getScratchArray(Type, length) {
  const scratchArrayBuffer = getScratchArrayBuffer(Type.BYTES_PER_ELEMENT * length);
  return new Type(scratchArrayBuffer, 0, length);
}
function fillArray({
  target,
  source,
  start = 0,
  count = 1
}) {
  const length = source.length;
  const total = count * length;
  let copied = 0;

  for (let i = start; copied < length; copied++) {
    target[i++] = source[copied];
  }

  while (copied < total) {
    if (copied < total - copied) {
      target.copyWithin(start + copied, start, start + copied);
      copied *= 2;
    } else {
      target.copyWithin(start + copied, start, start + total - copied);
      copied = total;
    }
  }

  return target;
}
//# sourceMappingURL=array-utils-flat.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/assert.js
var assert = __webpack_require__(22525);
// EXTERNAL MODULE: ./node_modules/probe.gl/dist/esm/env/globals.js
var globals = __webpack_require__(26073);
// EXTERNAL MODULE: ./node_modules/probe.gl/dist/esm/env/is-browser.js
var is_browser = __webpack_require__(25989);
// EXTERNAL MODULE: ./node_modules/probe.gl/dist/esm/env/is-electron.js
var is_electron = __webpack_require__(71202);
;// CONCATENATED MODULE: ./node_modules/probe.gl/dist/esm/env/get-browser.js



function isMobile() {
  return typeof window.orientation !== 'undefined';
}
function getBrowser(mockUserAgent) {
  if (!mockUserAgent && !(0,is_browser/* default */.Z)()) {
    return 'Node';
  }

  if ((0,is_electron/* default */.Z)(mockUserAgent)) {
    return 'Electron';
  }

  const navigator_ = typeof navigator !== 'undefined' ? navigator : {};
  const userAgent = mockUserAgent || navigator_.userAgent || '';

  if (userAgent.indexOf('Edge') > -1) {
    return 'Edge';
  }

  const isMSIE = userAgent.indexOf('MSIE ') !== -1;
  const isTrident = userAgent.indexOf('Trident/') !== -1;

  if (isMSIE || isTrident) {
    return 'IE';
  }

  if (globals/* window.chrome */.u9.chrome) {
    return 'Chrome';
  }

  if (globals/* window.safari */.u9.safari) {
    return 'Safari';
  }

  if (globals/* window.mozInnerScreenX */.u9.mozInnerScreenX) {
    return 'Firefox';
  }

  return 'Unknown';
}
//# sourceMappingURL=get-browser.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/vertex-array-object.js






const ERR_ELEMENTS = 'elements must be GL.ELEMENT_ARRAY_BUFFER';
class VertexArrayObject extends resource/* default */.Z {
  static isSupported(gl, options = {}) {
    if (options.constantAttributeZero) {
      return (0,esm/* isWebGL2 */.D0)(gl) || getBrowser() === 'Chrome';
    }

    return true;
  }

  static getDefaultArray(gl) {
    gl.luma = gl.luma || {};

    if (!gl.luma.defaultVertexArray) {
      gl.luma.defaultVertexArray = new VertexArrayObject(gl, {
        handle: null,
        isDefaultArray: true
      });
    }

    return gl.luma.defaultVertexArray;
  }

  static getMaxAttributes(gl) {
    VertexArrayObject.MAX_ATTRIBUTES = VertexArrayObject.MAX_ATTRIBUTES || gl.getParameter(34921);
    return VertexArrayObject.MAX_ATTRIBUTES;
  }

  static setConstant(gl, location, array) {
    switch (array.constructor) {
      case Float32Array:
        VertexArrayObject._setConstantFloatArray(gl, location, array);

        break;

      case Int32Array:
        VertexArrayObject._setConstantIntArray(gl, location, array);

        break;

      case Uint32Array:
        VertexArrayObject._setConstantUintArray(gl, location, array);

        break;

      default:
        (0,assert/* default */.Z)(false);
    }
  }

  constructor(gl, opts = {}) {
    const id = opts.id || opts.program && opts.program.id;
    super(gl, Object.assign({}, opts, {
      id
    }));
    this.buffer = null;
    this.bufferValue = null;
    this.isDefaultArray = opts.isDefaultArray || false;
    this.gl2 = gl;
    this.initialize(opts);
    Object.seal(this);
  }

  delete() {
    super.delete();

    if (this.buffer) {
      this.buffer.delete();
    }

    return this;
  }

  get MAX_ATTRIBUTES() {
    return VertexArrayObject.getMaxAttributes(this.gl);
  }

  initialize(props = {}) {
    return this.setProps(props);
  }

  setProps(props) {
    return this;
  }

  setElementBuffer(elementBuffer = null, opts = {}) {
    (0,assert/* default */.Z)(!elementBuffer || elementBuffer.target === 34963, ERR_ELEMENTS);
    this.bind(() => {
      this.gl.bindBuffer(34963, elementBuffer ? elementBuffer.handle : null);
    });
    return this;
  }

  setBuffer(location, buffer, accessor) {
    if (buffer.target === 34963) {
      return this.setElementBuffer(buffer, accessor);
    }

    const {
      size,
      type,
      stride,
      offset,
      normalized,
      integer,
      divisor
    } = accessor;
    const {
      gl,
      gl2
    } = this;
    location = Number(location);
    this.bind(() => {
      gl.bindBuffer(34962, buffer.handle);

      if (integer) {
        (0,assert/* default */.Z)((0,esm/* isWebGL2 */.D0)(gl));
        gl2.vertexAttribIPointer(location, size, type, stride, offset);
      } else {
        gl.vertexAttribPointer(location, size, type, normalized, stride, offset);
      }

      gl.enableVertexAttribArray(location);
      gl2.vertexAttribDivisor(location, divisor || 0);
    });
    return this;
  }

  enable(location, enable = true) {
    const disablingAttributeZero = !enable && location === 0 && !VertexArrayObject.isSupported(this.gl, {
      constantAttributeZero: true
    });

    if (!disablingAttributeZero) {
      location = Number(location);
      this.bind(() => enable ? this.gl.enableVertexAttribArray(location) : this.gl.disableVertexAttribArray(location));
    }

    return this;
  }

  getConstantBuffer(elementCount, value) {
    const constantValue = this._normalizeConstantArrayValue(value);

    const byteLength = constantValue.byteLength * elementCount;
    const length = constantValue.length * elementCount;
    let updateNeeded = !this.buffer;
    this.buffer = this.buffer || new classes_buffer/* default */.Z(this.gl, byteLength);
    updateNeeded = updateNeeded || this.buffer.reallocate(byteLength);
    updateNeeded = updateNeeded || !this._compareConstantArrayValues(constantValue, this.bufferValue);

    if (updateNeeded) {
      const typedArray = getScratchArray(value.constructor, length);
      fillArray({
        target: typedArray,
        source: constantValue,
        start: 0,
        count: length
      });
      this.buffer.subData(typedArray);
      this.bufferValue = value;
    }

    return this.buffer;
  }

  _normalizeConstantArrayValue(arrayValue) {
    if (Array.isArray(arrayValue)) {
      return new Float32Array(arrayValue);
    }

    return arrayValue;
  }

  _compareConstantArrayValues(v1, v2) {
    if (!v1 || !v2 || v1.length !== v2.length || v1.constructor !== v2.constructor) {
      return false;
    }

    for (let i = 0; i < v1.length; ++i) {
      if (v1[i] !== v2[i]) {
        return false;
      }
    }

    return true;
  }

  static _setConstantFloatArray(gl, location, array) {
    switch (array.length) {
      case 1:
        gl.vertexAttrib1fv(location, array);
        break;

      case 2:
        gl.vertexAttrib2fv(location, array);
        break;

      case 3:
        gl.vertexAttrib3fv(location, array);
        break;

      case 4:
        gl.vertexAttrib4fv(location, array);
        break;

      default:
        (0,assert/* default */.Z)(false);
    }
  }

  static _setConstantIntArray(gl, location, array) {
    (0,assert/* default */.Z)((0,esm/* isWebGL2 */.D0)(gl));

    switch (array.length) {
      case 1:
        gl.vertexAttribI1iv(location, array);
        break;

      case 2:
        gl.vertexAttribI2iv(location, array);
        break;

      case 3:
        gl.vertexAttribI3iv(location, array);
        break;

      case 4:
        gl.vertexAttribI4iv(location, array);
        break;

      default:
        (0,assert/* default */.Z)(false);
    }
  }

  static _setConstantUintArray(gl, location, array) {
    (0,assert/* default */.Z)((0,esm/* isWebGL2 */.D0)(gl));

    switch (array.length) {
      case 1:
        gl.vertexAttribI1uiv(location, array);
        break;

      case 2:
        gl.vertexAttribI2uiv(location, array);
        break;

      case 3:
        gl.vertexAttribI3uiv(location, array);
        break;

      case 4:
        gl.vertexAttribI4uiv(location, array);
        break;

      default:
        (0,assert/* default */.Z)(false);
    }
  }

  _createHandle() {
    const gl2 = this.gl;
    return gl2.createVertexArray();
  }

  _deleteHandle(handle) {
    this.gl2.deleteVertexArray(handle);
    return [this.elements];
  }

  _bindHandle(handle) {
    this.gl2.bindVertexArray(handle);
  }

  _getParameter(pname, {
    location
  }) {
    (0,assert/* default */.Z)(Number.isFinite(location));
    return this.bind(() => {
      switch (pname) {
        case 34373:
          return this.gl.getVertexAttribOffset(location, pname);

        default:
          return this.gl.getVertexAttrib(location, pname);
      }
    });
  }

}
//# sourceMappingURL=vertex-array-object.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/stub-methods.js
var stub_methods = __webpack_require__(37469);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/vertex-array.js





const ERR_ATTRIBUTE_TYPE = 'VertexArray: attributes must be Buffers or constants (i.e. typed array)';
const MULTI_LOCATION_ATTRIBUTE_REGEXP = /^(.+)__LOCATION_([0-9]+)$/;
const DEPRECATIONS_V6 = ['setBuffers', 'setGeneric', 'clearBindings', 'setLocations', 'setGenericValues', 'setDivisor', 'enable', 'disable'];
class VertexArray {
  constructor(gl, opts = {}) {
    const id = opts.id || opts.program && opts.program.id;
    this.id = id;
    this.gl = gl;
    this.configuration = null;
    this.elements = null;
    this.elementsAccessor = null;
    this.values = null;
    this.accessors = null;
    this.unused = null;
    this.drawParams = null;
    this.buffer = null;
    this.attributes = {};
    this.vertexArrayObject = new VertexArrayObject(gl);
    (0,stub_methods/* stubRemovedMethods */.F)(this, 'VertexArray', 'v6.0', DEPRECATIONS_V6);
    this.initialize(opts);
    Object.seal(this);
  }

  delete() {
    if (this.buffer) {
      this.buffer.delete();
    }

    this.vertexArrayObject.delete();
  }

  initialize(props = {}) {
    this.reset();
    this.configuration = null;
    this.bindOnUse = false;
    return this.setProps(props);
  }

  reset() {
    this.elements = null;
    this.elementsAccessor = null;
    const {
      MAX_ATTRIBUTES
    } = this.vertexArrayObject;
    this.values = new Array(MAX_ATTRIBUTES).fill(null);
    this.accessors = new Array(MAX_ATTRIBUTES).fill(null);
    this.unused = {};
    this.drawParams = null;
    return this;
  }

  setProps(props) {
    if ('program' in props) {
      this.configuration = props.program && props.program.configuration;
    }

    if ('configuration' in props) {
      this.configuration = props.configuration;
    }

    if ('attributes' in props) {
      this.setAttributes(props.attributes);
    }

    if ('elements' in props) {
      this.setElementBuffer(props.elements);
    }

    if ('bindOnUse' in props) {
      props = props.bindOnUse;
    }

    return this;
  }

  clearDrawParams() {
    this.drawParams = null;
  }

  getDrawParams() {
    this.drawParams = this.drawParams || this._updateDrawParams();
    return this.drawParams;
  }

  setAttributes(attributes) {
    Object.assign(this.attributes, attributes);
    this.vertexArrayObject.bind(() => {
      for (const locationOrName in attributes) {
        const value = attributes[locationOrName];

        this._setAttribute(locationOrName, value);
      }

      this.gl.bindBuffer(34962, null);
    });
    return this;
  }

  setElementBuffer(elementBuffer = null, accessor = {}) {
    this.elements = elementBuffer;
    this.elementsAccessor = accessor;
    this.clearDrawParams();
    this.vertexArrayObject.setElementBuffer(elementBuffer, accessor);
    return this;
  }

  setBuffer(locationOrName, buffer, appAccessor = {}) {
    if (buffer.target === 34963) {
      return this.setElementBuffer(buffer, appAccessor);
    }

    const {
      location,
      accessor
    } = this._resolveLocationAndAccessor(locationOrName, buffer, buffer.accessor, appAccessor);

    if (location >= 0) {
      this.values[location] = buffer;
      this.accessors[location] = accessor;
      this.clearDrawParams();
      this.vertexArrayObject.setBuffer(location, buffer, accessor);
    }

    return this;
  }

  setConstant(locationOrName, arrayValue, appAccessor = {}) {
    const {
      location,
      accessor
    } = this._resolveLocationAndAccessor(locationOrName, arrayValue, Object.assign({
      size: arrayValue.length
    }, appAccessor));

    if (location >= 0) {
      arrayValue = this.vertexArrayObject._normalizeConstantArrayValue(arrayValue);
      this.values[location] = arrayValue;
      this.accessors[location] = accessor;
      this.clearDrawParams();
      this.vertexArrayObject.enable(location, false);
    }

    return this;
  }

  unbindBuffers() {
    this.vertexArrayObject.bind(() => {
      if (this.elements) {
        this.vertexArrayObject.setElementBuffer(null);
      }

      this.buffer = this.buffer || new classes_buffer/* default */.Z(this.gl, {
        accessor: {
          size: 4
        }
      });

      for (let location = 0; location < this.vertexArrayObject.MAX_ATTRIBUTES; location++) {
        if (this.values[location] instanceof classes_buffer/* default */.Z) {
          this.gl.disableVertexAttribArray(location);
          this.gl.bindBuffer(34962, this.buffer.handle);
          this.gl.vertexAttribPointer(location, 1, 5126, false, 0, 0);
        }
      }
    });
    return this;
  }

  bindBuffers() {
    this.vertexArrayObject.bind(() => {
      if (this.elements) {
        this.setElementBuffer(this.elements);
      }

      for (let location = 0; location < this.vertexArrayObject.MAX_ATTRIBUTES; location++) {
        const buffer = this.values[location];

        if (buffer instanceof classes_buffer/* default */.Z) {
          this.setBuffer(location, buffer);
        }
      }
    });
    return this;
  }

  bindForDraw(vertexCount, instanceCount, func) {
    let value;
    this.vertexArrayObject.bind(() => {
      this._setConstantAttributes(vertexCount, instanceCount);

      value = func();
    });
    return value;
  }

  _resolveLocationAndAccessor(locationOrName, value, valueAccessor, appAccessor) {
    const INVALID_RESULT = {
      location: -1,
      accessor: null
    };

    const {
      location,
      name
    } = this._getAttributeIndex(locationOrName);

    if (!Number.isFinite(location) || location < 0) {
      this.unused[locationOrName] = value;
      esm/* log.once */.cM.once(3, () => "unused value ".concat(locationOrName, " in ").concat(this.id))();
      return INVALID_RESULT;
    }

    const accessInfo = this._getAttributeInfo(name || location);

    if (!accessInfo) {
      return INVALID_RESULT;
    }

    const currentAccessor = this.accessors[location] || {};
    const accessor = classes_accessor/* default.resolve */.Z.resolve(accessInfo.accessor, currentAccessor, valueAccessor, appAccessor);
    const {
      size,
      type
    } = accessor;
    (0,assert/* default */.Z)(Number.isFinite(size) && Number.isFinite(type));
    return {
      location,
      accessor
    };
  }

  _getAttributeInfo(attributeName) {
    return this.configuration && this.configuration.getAttributeInfo(attributeName);
  }

  _getAttributeIndex(locationOrName) {
    const location = Number(locationOrName);

    if (Number.isFinite(location)) {
      return {
        location
      };
    }

    const multiLocation = MULTI_LOCATION_ATTRIBUTE_REGEXP.exec(locationOrName);
    const name = multiLocation ? multiLocation[1] : locationOrName;
    const locationOffset = multiLocation ? Number(multiLocation[2]) : 0;

    if (this.configuration) {
      return {
        location: this.configuration.getAttributeLocation(name) + locationOffset,
        name
      };
    }

    return {
      location: -1
    };
  }

  _setAttribute(locationOrName, value) {
    if (value instanceof classes_buffer/* default */.Z) {
      this.setBuffer(locationOrName, value);
    } else if (Array.isArray(value) && value.length && value[0] instanceof classes_buffer/* default */.Z) {
      const buffer = value[0];
      const accessor = value[1];
      this.setBuffer(locationOrName, buffer, accessor);
    } else if (ArrayBuffer.isView(value) || Array.isArray(value)) {
      const constant = value;
      this.setConstant(locationOrName, constant);
    } else if (value.buffer instanceof classes_buffer/* default */.Z) {
      const accessor = value;
      this.setBuffer(locationOrName, accessor.buffer, accessor);
    } else {
      throw new Error(ERR_ATTRIBUTE_TYPE);
    }
  }

  _setConstantAttributes(vertexCount, instanceCount) {
    const elementCount = Math.max(vertexCount | 0, instanceCount | 0);
    let constant = this.values[0];

    if (ArrayBuffer.isView(constant)) {
      this._setConstantAttributeZero(constant, elementCount);
    }

    for (let location = 1; location < this.vertexArrayObject.MAX_ATTRIBUTES; location++) {
      constant = this.values[location];

      if (ArrayBuffer.isView(constant)) {
        this._setConstantAttribute(location, constant);
      }
    }
  }

  _setConstantAttributeZero(constant, elementCount) {
    if (VertexArrayObject.isSupported(this.gl, {
      constantAttributeZero: true
    })) {
      this._setConstantAttribute(0, constant);

      return;
    }

    const buffer = this.vertexArrayObject.getConstantBuffer(elementCount, constant);
    this.vertexArrayObject.setBuffer(0, buffer, this.accessors[0]);
  }

  _setConstantAttribute(location, constant) {
    VertexArrayObject.setConstant(this.gl, location, constant);
  }

  _updateDrawParams() {
    const drawParams = {
      isIndexed: false,
      isInstanced: false,
      indexCount: Infinity,
      vertexCount: Infinity,
      instanceCount: Infinity
    };

    for (let location = 0; location < this.vertexArrayObject.MAX_ATTRIBUTES; location++) {
      this._updateDrawParamsForLocation(drawParams, location);
    }

    if (this.elements) {
      drawParams.elementCount = this.elements.getElementCount(this.elements.accessor);
      drawParams.isIndexed = true;
      drawParams.indexType = this.elementsAccessor.type || this.elements.accessor.type;
      drawParams.indexOffset = this.elementsAccessor.offset || 0;
    }

    if (drawParams.indexCount === Infinity) {
      drawParams.indexCount = 0;
    }

    if (drawParams.vertexCount === Infinity) {
      drawParams.vertexCount = 0;
    }

    if (drawParams.instanceCount === Infinity) {
      drawParams.instanceCount = 0;
    }

    return drawParams;
  }

  _updateDrawParamsForLocation(drawParams, location) {
    const value = this.values[location];
    const accessor = this.accessors[location];

    if (!value) {
      return;
    }

    const {
      divisor
    } = accessor;
    const isInstanced = divisor > 0;
    drawParams.isInstanced = drawParams.isInstanced || isInstanced;

    if (value instanceof classes_buffer/* default */.Z) {
      const buffer = value;

      if (isInstanced) {
        const instanceCount = buffer.getVertexCount(accessor);
        drawParams.instanceCount = Math.min(drawParams.instanceCount, instanceCount);
      } else {
        const vertexCount = buffer.getVertexCount(accessor);
        drawParams.vertexCount = Math.min(drawParams.vertexCount, vertexCount);
      }
    }
  }

  setElements(elementBuffer = null, accessor = {}) {
    esm/* log.deprecated */.cM.deprecated('setElements', 'setElementBuffer')();
    return this.setElementBuffer(elementBuffer, accessor);
  }

}
//# sourceMappingURL=vertex-array.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/utils.js
var utils = __webpack_require__(74538);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/clear.js
var clear = __webpack_require__(26047);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/program.js + 6 modules
var classes_program = __webpack_require__(7944);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/transform-feedback.js
var transform_feedback = __webpack_require__(51053);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/webgl-utils/constants-to-keys.js
var constants_to_keys = __webpack_require__(79579);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/webgl-utils/attribute-utils.js
var attribute_utils = __webpack_require__(38522);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/format-value.js
function formatArrayValue(v, opts) {
  const {
    maxElts = 16,
    size = 1
  } = opts;
  let string = '[';

  for (let i = 0; i < v.length && i < maxElts; ++i) {
    if (i > 0) {
      string += ",".concat(i % size === 0 ? ' ' : '');
    }

    string += formatValue(v[i], opts);
  }

  const terminator = v.length > maxElts ? '...' : ']';
  return "".concat(string).concat(terminator);
}

function formatValue(v, opts = {}) {
  const EPSILON = 1e-16;
  const {
    isInteger = false
  } = opts;

  if (Array.isArray(v) || ArrayBuffer.isView(v)) {
    return formatArrayValue(v, opts);
  }

  if (!Number.isFinite(v)) {
    return String(v);
  }

  if (Math.abs(v) < EPSILON) {
    return isInteger ? '0' : '0.';
  }

  if (isInteger) {
    return v.toFixed(0);
  }

  if (Math.abs(v) > 100 && Math.abs(v) < 10000) {
    return v.toFixed(0);
  }

  const string = v.toPrecision(2);
  const decimal = string.indexOf('.0');
  return decimal === string.length - 2 ? string.slice(0, -1) : string;
}
//# sourceMappingURL=format-value.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/debug/debug-vertex-array.js




function getDebugTableForVertexArray({
  vertexArray,
  header = 'Attributes'
}) {
  if (!vertexArray.configuration) {
    return {};
  }

  const table = {};

  if (vertexArray.elements) {
    table.ELEMENT_ARRAY_BUFFER = getDebugTableRow(vertexArray, vertexArray.elements, null, header);
  }

  const attributes = vertexArray.values;

  for (const attributeLocation in attributes) {
    const info = vertexArray._getAttributeInfo(attributeLocation);

    if (info) {
      let rowHeader = "".concat(attributeLocation, ": ").concat(info.name);
      const accessor = vertexArray.accessors[info.location];

      if (accessor) {
        rowHeader = "".concat(attributeLocation, ": ").concat(getGLSLDeclaration(info.name, accessor));
      }

      table[rowHeader] = getDebugTableRow(vertexArray, attributes[attributeLocation], accessor, header);
    }
  }

  return table;
}

function getDebugTableRow(vertexArray, attribute, accessor, header) {
  const {
    gl
  } = vertexArray;

  if (!attribute) {
    return {
      [header]: 'null',
      'Format ': 'N/A'
    };
  }

  let type = 'NOT PROVIDED';
  let size = 1;
  let verts = 0;
  let bytes = 0;
  let isInteger;
  let marker;
  let value;

  if (accessor) {
    type = accessor.type;
    size = accessor.size;
    type = String(type).replace('Array', '');
    isInteger = type.indexOf('nt') !== -1;
  }

  if (attribute instanceof classes_buffer/* default */.Z) {
    const buffer = attribute;
    const {
      data,
      changed
    } = buffer.getDebugData();
    marker = changed ? '*' : '';
    value = data;
    bytes = buffer.byteLength;
    verts = bytes / data.BYTES_PER_ELEMENT / size;
    let format;

    if (accessor) {
      const instanced = accessor.divisor > 0;
      format = "".concat(instanced ? 'I ' : 'P ', " ").concat(verts, " (x").concat(size, "=").concat(bytes, " bytes ").concat((0,constants_to_keys/* getKey */.km)(gl, type), ")");
    } else {
      isInteger = true;
      format = "".concat(bytes, " bytes");
    }

    return {
      [header]: "".concat(marker).concat(formatValue(value, {
        size,
        isInteger
      })),
      'Format ': format
    };
  }

  value = attribute;
  size = attribute.length;
  type = String(attribute.constructor.name).replace('Array', '');
  isInteger = type.indexOf('nt') !== -1;
  return {
    [header]: "".concat(formatValue(value, {
      size,
      isInteger
    }), " (constant)"),
    'Format ': "".concat(size, "x").concat(type, " (constant)")
  };
}

function getGLSLDeclaration(name, accessor) {
  const {
    type,
    size
  } = accessor;
  const typeAndName = (0,attribute_utils/* getCompositeGLType */.jG)(type, size);
  return typeAndName ? "".concat(name, " (").concat(typeAndName.name, ")") : name;
}
//# sourceMappingURL=debug-vertex-array.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/debug/debug-uniforms.js

function getDebugTableForUniforms({
  header = 'Uniforms',
  program,
  uniforms,
  undefinedOnly = false
}) {
  (0,assert/* default */.Z)(program);
  const SHADER_MODULE_UNIFORM_REGEXP = '.*_.*';
  const PROJECT_MODULE_UNIFORM_REGEXP = '.*Matrix';
  const uniformLocations = program._uniformSetters;
  const table = {};
  const uniformNames = Object.keys(uniformLocations).sort();
  let count = 0;

  for (const uniformName of uniformNames) {
    if (!uniformName.match(SHADER_MODULE_UNIFORM_REGEXP) && !uniformName.match(PROJECT_MODULE_UNIFORM_REGEXP)) {
      if (addUniformToTable({
        table,
        header,
        uniforms,
        uniformName,
        undefinedOnly
      })) {
        count++;
      }
    }
  }

  for (const uniformName of uniformNames) {
    if (uniformName.match(PROJECT_MODULE_UNIFORM_REGEXP)) {
      if (addUniformToTable({
        table,
        header,
        uniforms,
        uniformName,
        undefinedOnly
      })) {
        count++;
      }
    }
  }

  for (const uniformName of uniformNames) {
    if (!table[uniformName]) {
      if (addUniformToTable({
        table,
        header,
        uniforms,
        uniformName,
        undefinedOnly
      })) {
        count++;
      }
    }
  }

  let unusedCount = 0;
  const unusedTable = {};

  if (!undefinedOnly) {
    for (const uniformName in uniforms) {
      const uniform = uniforms[uniformName];

      if (!table[uniformName]) {
        unusedCount++;
        unusedTable[uniformName] = {
          Type: "NOT USED: ".concat(uniform),
          [header]: formatValue(uniform)
        };
      }
    }
  }

  return {
    table,
    count,
    unusedTable,
    unusedCount
  };
}

function addUniformToTable({
  table,
  header,
  uniforms,
  uniformName,
  undefinedOnly
}) {
  const value = uniforms[uniformName];
  const isDefined = isUniformDefined(value);

  if (!undefinedOnly || !isDefined) {
    table[uniformName] = {
      [header]: isDefined ? formatValue(value) : 'N/A',
      'Uniform Type': isDefined ? value : 'NOT PROVIDED'
    };
    return true;
  }

  return false;
}

function isUniformDefined(value) {
  return value !== undefined && value !== null;
}
//# sourceMappingURL=debug-uniforms.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/debug/debug-program-configuration.js

function getDebugTableForProgramConfiguration(config) {
  const table = {};
  const header = "Accessors for ".concat(config.id);

  for (const attributeInfo of config.attributeInfos) {
    if (attributeInfo) {
      const glslDeclaration = debug_program_configuration_getGLSLDeclaration(attributeInfo);
      table["in ".concat(glslDeclaration)] = {
        [header]: JSON.stringify(attributeInfo.accessor)
      };
    }
  }

  for (const varyingInfo of config.varyingInfos) {
    if (varyingInfo) {
      const glslDeclaration = debug_program_configuration_getGLSLDeclaration(varyingInfo);
      table["out ".concat(glslDeclaration)] = {
        [header]: JSON.stringify(varyingInfo.accessor)
      };
    }
  }

  return table;
}

function debug_program_configuration_getGLSLDeclaration(attributeInfo) {
  const {
    type,
    size
  } = attributeInfo.accessor;
  const typeAndName = (0,attribute_utils/* getCompositeGLType */.jG)(type, size);

  if (typeAndName) {
    return "".concat(typeAndName.name, " ").concat(attributeInfo.name);
  }

  return attributeInfo.name;
}
//# sourceMappingURL=debug-program-configuration.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/engine/dist/esm/lib/model-utils.js

const GLTF_TO_LUMA_ATTRIBUTE_MAP = {
  POSITION: 'positions',
  NORMAL: 'normals',
  COLOR_0: 'colors',
  TEXCOORD_0: 'texCoords',
  TEXCOORD_1: 'texCoords1',
  TEXCOORD_2: 'texCoords2'
};
function getBuffersFromGeometry(gl, geometry, options) {
  const buffers = {};
  let indices = geometry.indices;

  for (const name in geometry.attributes) {
    const attribute = geometry.attributes[name];
    const remappedName = mapAttributeName(name, options);

    if (name === 'indices') {
      indices = attribute;
    } else if (attribute.constant) {
      buffers[remappedName] = attribute.value;
    } else {
      const typedArray = attribute.value;
      const accessor = { ...attribute
      };
      delete accessor.value;
      buffers[remappedName] = [new classes_buffer/* default */.Z(gl, typedArray), accessor];
      inferAttributeAccessor(name, accessor);
    }
  }

  if (indices) {
    const data = indices.value || indices;
    (0,assert/* default */.Z)(data instanceof Uint16Array || data instanceof Uint32Array, 'attribute array for "indices" must be of integer type');
    const accessor = {
      size: 1,
      isIndexed: indices.isIndexed === undefined ? true : indices.isIndexed
    };
    buffers.indices = [new classes_buffer/* default */.Z(gl, {
      data,
      target: 34963
    }), accessor];
  }

  return buffers;
}

function mapAttributeName(name, options) {
  const {
    attributeMap = GLTF_TO_LUMA_ATTRIBUTE_MAP
  } = options || {};
  return attributeMap && attributeMap[name] || name;
}

function inferAttributeAccessor(attributeName, attribute) {
  let category;

  switch (attributeName) {
    case 'texCoords':
    case 'texCoord1':
    case 'texCoord2':
    case 'texCoord3':
      category = 'uvs';
      break;

    case 'vertices':
    case 'positions':
    case 'normals':
    case 'pickingColors':
      category = 'vectors';
      break;

    default:
  }

  switch (category) {
    case 'vectors':
      attribute.size = attribute.size || 3;
      break;

    case 'uvs':
      attribute.size = attribute.size || 2;
      break;

    default:
  }

  (0,assert/* default */.Z)(Number.isFinite(attribute.size), "attribute ".concat(attributeName, " needs size"));
}
//# sourceMappingURL=model-utils.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/engine/dist/esm/lib/model.js





const LOG_DRAW_PRIORITY = 2;
const LOG_DRAW_TIMEOUT = 10000;
const ERR_MODEL_PARAMS = 'Model needs drawMode and vertexCount';

const NOOP = () => {};

const DRAW_PARAMS = {};
class Model {
  constructor(gl, props = {}) {
    const {
      id = (0,utils/* uid */.hQ)('model')
    } = props;
    (0,assert/* default */.Z)((0,esm/* isWebGL */.UF)(gl));
    this.id = id;
    this.gl = gl;
    this.id = props.id || (0,utils/* uid */.hQ)('Model');
    this.lastLogTime = 0;
    this.animated = false;
    this.initialize(props);
  }

  initialize(props) {
    this.props = {};
    this.programManager = props.programManager || program_manager/* default.getDefaultProgramManager */.Z.getDefaultProgramManager(this.gl);
    this._programManagerState = -1;
    this._managedProgram = false;
    const {
      program = null,
      vs,
      fs,
      modules,
      defines,
      inject,
      varyings,
      bufferMode,
      transpileToGLSL100
    } = props;
    this.programProps = {
      program,
      vs,
      fs,
      modules,
      defines,
      inject,
      varyings,
      bufferMode,
      transpileToGLSL100
    };
    this.program = null;
    this.vertexArray = null;
    this._programDirty = true;
    this.userData = {};
    this.needsRedraw = true;
    this._attributes = {};
    this.attributes = {};
    this.uniforms = {};
    this.pickable = true;

    this._checkProgram();

    this.setUniforms(Object.assign({}, this.getModuleUniforms(props.moduleSettings)));
    this.drawMode = props.drawMode !== undefined ? props.drawMode : 4;
    this.vertexCount = props.vertexCount || 0;
    this.geometryBuffers = {};
    this.isInstanced = props.isInstanced || props.instanced || props.instanceCount > 0;

    this._setModelProps(props);

    this.geometry = {};
    (0,assert/* default */.Z)(this.drawMode !== undefined && Number.isFinite(this.vertexCount), ERR_MODEL_PARAMS);
  }

  setProps(props) {
    this._setModelProps(props);
  }

  delete() {
    for (const key in this._attributes) {
      if (this._attributes[key] !== this.attributes[key]) {
        this._attributes[key].delete();
      }
    }

    if (this._managedProgram) {
      this.programManager.release(this.program);
      this._managedProgram = false;
    }

    this.vertexArray.delete();

    this._deleteGeometryBuffers();
  }

  getDrawMode() {
    return this.drawMode;
  }

  getVertexCount() {
    return this.vertexCount;
  }

  getInstanceCount() {
    return this.instanceCount;
  }

  getAttributes() {
    return this.attributes;
  }

  getProgram() {
    return this.program;
  }

  setProgram(props) {
    const {
      program,
      vs,
      fs,
      modules,
      defines,
      inject,
      varyings,
      bufferMode,
      transpileToGLSL100
    } = props;
    this.programProps = {
      program,
      vs,
      fs,
      modules,
      defines,
      inject,
      varyings,
      bufferMode,
      transpileToGLSL100
    };
    this._programDirty = true;
  }

  getUniforms() {
    return this.uniforms;
  }

  setDrawMode(drawMode) {
    this.drawMode = drawMode;
    return this;
  }

  setVertexCount(vertexCount) {
    (0,assert/* default */.Z)(Number.isFinite(vertexCount));
    this.vertexCount = vertexCount;
    return this;
  }

  setInstanceCount(instanceCount) {
    (0,assert/* default */.Z)(Number.isFinite(instanceCount));
    this.instanceCount = instanceCount;
    return this;
  }

  setGeometry(geometry) {
    this.drawMode = geometry.drawMode;
    this.vertexCount = geometry.getVertexCount();

    this._deleteGeometryBuffers();

    this.geometryBuffers = getBuffersFromGeometry(this.gl, geometry);
    this.vertexArray.setAttributes(this.geometryBuffers);
    return this;
  }

  setAttributes(attributes = {}) {
    if ((0,utils/* isObjectEmpty */.nK)(attributes)) {
      return this;
    }

    const normalizedAttributes = {};

    for (const name in attributes) {
      const attribute = attributes[name];
      normalizedAttributes[name] = attribute.getValue ? attribute.getValue() : attribute;
    }

    this.vertexArray.setAttributes(normalizedAttributes);
    return this;
  }

  setUniforms(uniforms = {}) {
    Object.assign(this.uniforms, uniforms);
    return this;
  }

  getModuleUniforms(opts) {
    this._checkProgram();

    const getUniforms = this.programManager.getUniforms(this.program);

    if (getUniforms) {
      return getUniforms(opts);
    }

    return {};
  }

  updateModuleSettings(opts) {
    const uniforms = this.getModuleUniforms(opts || {});
    return this.setUniforms(uniforms);
  }

  clear(opts) {
    (0,clear/* clear */.Z)(this.program.gl, opts);
    return this;
  }

  draw(opts = {}) {
    this._checkProgram();

    const {
      moduleSettings = null,
      framebuffer,
      uniforms = {},
      attributes = {},
      transformFeedback = this.transformFeedback,
      parameters = {},
      vertexArray = this.vertexArray
    } = opts;
    this.setAttributes(attributes);
    this.updateModuleSettings(moduleSettings);
    this.setUniforms(uniforms);
    let logPriority;

    if (esm/* log.priority */.cM.priority >= LOG_DRAW_PRIORITY) {
      logPriority = this._logDrawCallStart(LOG_DRAW_PRIORITY);
    }

    const drawParams = this.vertexArray.getDrawParams();
    const {
      isIndexed = drawParams.isIndexed,
      indexType = drawParams.indexType,
      indexOffset = drawParams.indexOffset,
      vertexArrayInstanced = drawParams.isInstanced
    } = this.props;

    if (vertexArrayInstanced && !this.isInstanced) {
      esm/* log.warn */.cM.warn('Found instanced attributes on non-instanced model', this.id)();
    }

    const {
      isInstanced,
      instanceCount
    } = this;
    const {
      onBeforeRender = NOOP,
      onAfterRender = NOOP
    } = this.props;
    onBeforeRender();
    this.program.setUniforms(this.uniforms);
    const didDraw = this.program.draw(Object.assign(DRAW_PARAMS, opts, {
      logPriority,
      uniforms: null,
      framebuffer,
      parameters,
      drawMode: this.getDrawMode(),
      vertexCount: this.getVertexCount(),
      vertexArray,
      transformFeedback,
      isIndexed,
      indexType,
      isInstanced,
      instanceCount,
      offset: isIndexed ? indexOffset : 0
    }));
    onAfterRender();

    if (esm/* log.priority */.cM.priority >= LOG_DRAW_PRIORITY) {
      this._logDrawCallEnd(logPriority, vertexArray, framebuffer);
    }

    return didDraw;
  }

  transform(opts = {}) {
    const {
      discard = true,
      feedbackBuffers,
      unbindModels = []
    } = opts;
    let {
      parameters
    } = opts;

    if (feedbackBuffers) {
      this._setFeedbackBuffers(feedbackBuffers);
    }

    if (discard) {
      parameters = Object.assign({}, parameters, {
        [35977]: discard
      });
    }

    unbindModels.forEach(model => model.vertexArray.unbindBuffers());

    try {
      this.draw(Object.assign({}, opts, {
        parameters
      }));
    } finally {
      unbindModels.forEach(model => model.vertexArray.bindBuffers());
    }

    return this;
  }

  render(uniforms = {}) {
    esm/* log.warn */.cM.warn('Model.render() is deprecated. Use Model.setUniforms() and Model.draw()')();
    return this.setUniforms(uniforms).draw();
  }

  _setModelProps(props) {
    Object.assign(this.props, props);

    if ('uniforms' in props) {
      this.setUniforms(props.uniforms);
    }

    if ('pickable' in props) {
      this.pickable = props.pickable;
    }

    if ('instanceCount' in props) {
      this.instanceCount = props.instanceCount;
    }

    if ('geometry' in props) {
      this.setGeometry(props.geometry);
    }

    if ('attributes' in props) {
      this.setAttributes(props.attributes);
    }

    if ('_feedbackBuffers' in props) {
      this._setFeedbackBuffers(props._feedbackBuffers);
    }
  }

  _checkProgram() {
    const needsUpdate = this._programDirty || this.programManager.stateHash !== this._programManagerState;

    if (!needsUpdate) {
      return;
    }

    let {
      program
    } = this.programProps;

    if (program) {
      this._managedProgram = false;
    } else {
      const {
        vs,
        fs,
        modules,
        inject,
        defines,
        varyings,
        bufferMode,
        transpileToGLSL100
      } = this.programProps;
      program = this.programManager.get({
        vs,
        fs,
        modules,
        inject,
        defines,
        varyings,
        bufferMode,
        transpileToGLSL100
      });

      if (this.program && this._managedProgram) {
        this.programManager.release(this.program);
      }

      this._programManagerState = this.programManager.stateHash;
      this._managedProgram = true;
    }

    (0,assert/* default */.Z)(program instanceof classes_program/* default */.Z, 'Model needs a program');
    this._programDirty = false;

    if (program === this.program) {
      return;
    }

    this.program = program;

    if (this.vertexArray) {
      this.vertexArray.setProps({
        program: this.program,
        attributes: this.vertexArray.attributes
      });
    } else {
      this.vertexArray = new VertexArray(this.gl, {
        program: this.program
      });
    }

    this.setUniforms(Object.assign({}, this.getModuleUniforms()));
  }

  _deleteGeometryBuffers() {
    for (const name in this.geometryBuffers) {
      const buffer = this.geometryBuffers[name][0] || this.geometryBuffers[name];

      if (buffer instanceof classes_buffer/* default */.Z) {
        buffer.delete();
      }
    }
  }

  _setAnimationProps(animationProps) {
    if (this.animated) {
      (0,assert/* default */.Z)(animationProps, 'Model.draw(): animated uniforms but no animationProps');
    }
  }

  _setFeedbackBuffers(feedbackBuffers = {}) {
    if ((0,utils/* isObjectEmpty */.nK)(feedbackBuffers)) {
      return this;
    }

    const {
      gl
    } = this.program;
    this.transformFeedback = this.transformFeedback || new transform_feedback/* default */.Z(gl, {
      program: this.program
    });
    this.transformFeedback.setBuffers(feedbackBuffers);
    return this;
  }

  _logDrawCallStart(logLevel) {
    const logDrawTimeout = logLevel > 3 ? 0 : LOG_DRAW_TIMEOUT;

    if (Date.now() - this.lastLogTime < logDrawTimeout) {
      return undefined;
    }

    this.lastLogTime = Date.now();
    esm/* log.group */.cM.group(LOG_DRAW_PRIORITY, ">>> DRAWING MODEL ".concat(this.id), {
      collapsed: esm/* log.level */.cM.level <= 2
    })();
    return logLevel;
  }

  _logDrawCallEnd(logLevel, vertexArray, uniforms, framebuffer) {
    if (logLevel === undefined) {
      return;
    }

    const attributeTable = getDebugTableForVertexArray({
      vertexArray,
      header: "".concat(this.id, " attributes"),
      attributes: this._attributes
    });
    const {
      table: uniformTable,
      unusedTable,
      unusedCount
    } = getDebugTableForUniforms({
      header: "".concat(this.id, " uniforms"),
      program: this.program,
      uniforms: Object.assign({}, this.program.uniforms, uniforms)
    });
    const {
      table: missingTable,
      count: missingCount
    } = getDebugTableForUniforms({
      header: "".concat(this.id, " uniforms"),
      program: this.program,
      uniforms: Object.assign({}, this.program.uniforms, uniforms),
      undefinedOnly: true
    });

    if (missingCount > 0) {
      esm/* log.log */.cM.log('MISSING UNIFORMS', Object.keys(missingTable))();
    }

    if (unusedCount > 0) {
      esm/* log.log */.cM.log('UNUSED UNIFORMS', Object.keys(unusedTable))();
    }

    const configTable = getDebugTableForProgramConfiguration(this.vertexArray.configuration);
    esm/* log.table */.cM.table(logLevel, attributeTable)();
    esm/* log.table */.cM.table(logLevel, uniformTable)();
    esm/* log.table */.cM.table(logLevel + 1, configTable)();

    if (framebuffer) {
      framebuffer.log({
        logLevel: LOG_DRAW_PRIORITY,
        message: "Rendered to ".concat(framebuffer.id)
      });
    }

    esm/* log.groupEnd */.cM.groupEnd(LOG_DRAW_PRIORITY, ">>> DRAWING MODEL ".concat(this.id))();
  }

}
//# sourceMappingURL=model.js.map

/***/ }),

/***/ 68432:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ ProgramManager)
});

// EXTERNAL MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/lib/constants.js
var constants = __webpack_require__(75682);
// EXTERNAL MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/utils/assert.js
var assert = __webpack_require__(29047);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/lib/filters/prop-types.js
const TYPE_DEFINITIONS = {
  number: {
    validate(value, propType) {
      return Number.isFinite(value) && (!('max' in propType) || value <= propType.max) && (!('min' in propType) || value >= propType.min);
    }

  },
  array: {
    validate(value, propType) {
      return Array.isArray(value) || ArrayBuffer.isView(value);
    }

  }
};
function parsePropTypes(propDefs) {
  const propTypes = {};

  for (const propName in propDefs) {
    const propDef = propDefs[propName];
    const propType = parsePropType(propDef);
    propTypes[propName] = propType;
  }

  return propTypes;
}

function parsePropType(propDef) {
  let type = getTypeOf(propDef);

  if (type === 'object') {
    if (!propDef) {
      return {
        type: 'object',
        value: null
      };
    }

    if ('type' in propDef) {
      return Object.assign({}, propDef, TYPE_DEFINITIONS[propDef.type]);
    }

    if (!('value' in propDef)) {
      return {
        type: 'object',
        value: propDef
      };
    }

    type = getTypeOf(propDef.value);
    return Object.assign({
      type
    }, propDef, TYPE_DEFINITIONS[type]);
  }

  return Object.assign({
    type,
    value: propDef
  }, TYPE_DEFINITIONS[type]);
}

function getTypeOf(value) {
  if (Array.isArray(value) || ArrayBuffer.isView(value)) {
    return 'array';
  }

  return typeof value;
}
//# sourceMappingURL=prop-types.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/lib/shader-module.js


const VERTEX_SHADER = 'vs';
const FRAGMENT_SHADER = 'fs';
class ShaderModule {
  constructor({
    name,
    vs,
    fs,
    dependencies = [],
    uniforms,
    getUniforms,
    deprecations = [],
    defines = {},
    inject = {},
    vertexShader,
    fragmentShader
  }) {
    (0,assert/* default */.Z)(typeof name === 'string');
    this.name = name;
    this.vs = vs || vertexShader;
    this.fs = fs || fragmentShader;
    this.getModuleUniforms = getUniforms;
    this.dependencies = dependencies;
    this.deprecations = this._parseDeprecationDefinitions(deprecations);
    this.defines = defines;
    this.injections = normalizeInjections(inject);

    if (uniforms) {
      this.uniforms = parsePropTypes(uniforms);
    }
  }

  getModuleSource(type) {
    let moduleSource;

    switch (type) {
      case VERTEX_SHADER:
        moduleSource = this.vs || '';
        break;

      case FRAGMENT_SHADER:
        moduleSource = this.fs || '';
        break;

      default:
        (0,assert/* default */.Z)(false);
    }

    return "#define MODULE_".concat(this.name.toUpperCase().replace(/[^0-9a-z]/gi, '_'), "\n").concat(moduleSource, "// END MODULE_").concat(this.name, "\n\n");
  }

  getUniforms(opts, uniforms) {
    if (this.getModuleUniforms) {
      return this.getModuleUniforms(opts, uniforms);
    }

    if (this.uniforms) {
      return this._defaultGetUniforms(opts);
    }

    return {};
  }

  getDefines() {
    return this.defines;
  }

  checkDeprecations(shaderSource, log) {
    this.deprecations.forEach(def => {
      if (def.regex.test(shaderSource)) {
        if (def.deprecated) {
          log.deprecated(def.old, def.new)();
        } else {
          log.removed(def.old, def.new)();
        }
      }
    });
  }

  _parseDeprecationDefinitions(deprecations) {
    deprecations.forEach(def => {
      switch (def.type) {
        case 'function':
          def.regex = new RegExp("\\b".concat(def.old, "\\("));
          break;

        default:
          def.regex = new RegExp("".concat(def.type, " ").concat(def.old, ";"));
      }
    });
    return deprecations;
  }

  _defaultGetUniforms(opts = {}) {
    const uniforms = {};
    const propTypes = this.uniforms;

    for (const key in propTypes) {
      const propDef = propTypes[key];

      if (key in opts && !propDef.private) {
        if (propDef.validate) {
          (0,assert/* default */.Z)(propDef.validate(opts[key], propDef), "".concat(this.name, ": invalid ").concat(key));
        }

        uniforms[key] = opts[key];
      } else {
        uniforms[key] = propDef.value;
      }
    }

    return uniforms;
  }

}
function normalizeShaderModule(module) {
  if (!module.normalized) {
    module.normalized = true;

    if (module.uniforms && !module.getUniforms) {
      const shaderModule = new ShaderModule(module);
      module.getUniforms = shaderModule.getUniforms.bind(shaderModule);
    }
  }

  return module;
}

function normalizeInjections(injections) {
  const result = {
    vs: {},
    fs: {}
  };

  for (const hook in injections) {
    let injection = injections[hook];
    const stage = hook.slice(0, 2);

    if (typeof injection === 'string') {
      injection = {
        order: 0,
        injection
      };
    }

    result[stage][hook] = injection;
  }

  return result;
}
//# sourceMappingURL=shader-module.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/lib/resolve-modules.js


function resolveModules(modules) {
  return getShaderDependencies(instantiateModules(modules));
}

function getShaderDependencies(modules) {
  const moduleMap = {};
  const moduleDepth = {};
  getDependencyGraph({
    modules,
    level: 0,
    moduleMap,
    moduleDepth
  });
  return Object.keys(moduleDepth).sort((a, b) => moduleDepth[b] - moduleDepth[a]).map(name => moduleMap[name]);
}

function getDependencyGraph({
  modules,
  level,
  moduleMap,
  moduleDepth
}) {
  if (level >= 5) {
    throw new Error('Possible loop in shader dependency graph');
  }

  for (const module of modules) {
    moduleMap[module.name] = module;

    if (moduleDepth[module.name] === undefined || moduleDepth[module.name] < level) {
      moduleDepth[module.name] = level;
    }
  }

  for (const module of modules) {
    if (module.dependencies) {
      getDependencyGraph({
        modules: module.dependencies,
        level: level + 1,
        moduleMap,
        moduleDepth
      });
    }
  }
}

function instantiateModules(modules, seen) {
  return modules.map(module => {
    if (module instanceof ShaderModule) {
      return module;
    }

    (0,assert/* default */.Z)(typeof module !== 'string', "Shader module use by name is deprecated. Import shader module '".concat(module, "' and use it directly."));
    (0,assert/* default */.Z)(module.name, 'shader module has no name');
    module = new ShaderModule(module);
    module.dependencies = instantiateModules(module.dependencies);
    return module;
  });
}

const TEST_EXPORTS = {
  getShaderDependencies,
  getDependencyGraph
};
//# sourceMappingURL=resolve-modules.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/utils/is-old-ie.js
function isOldIE(opts = {}) {
  const navigator = typeof window !== 'undefined' ? window.navigator || {} : {};
  const userAgent = opts.userAgent || navigator.userAgent || '';
  const isMSIE = userAgent.indexOf('MSIE ') !== -1;
  const isTrident = userAgent.indexOf('Trident/') !== -1;
  return isMSIE || isTrident;
}
//# sourceMappingURL=is-old-ie.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/utils/webgl-info.js


const GL_VENDOR = 0x1f00;
const GL_RENDERER = 0x1f01;
const GL_VERSION = 0x1f02;
const GL_SHADING_LANGUAGE_VERSION = 0x8b8c;
const WEBGL_FEATURES = {
  GLSL_FRAG_DATA: ['WEBGL_draw_buffers', true],
  GLSL_FRAG_DEPTH: ['EXT_frag_depth', true],
  GLSL_DERIVATIVES: ['OES_standard_derivatives', true],
  GLSL_TEXTURE_LOD: ['EXT_shader_texture_lod', true]
};
const FEATURES = {};
Object.keys(WEBGL_FEATURES).forEach(key => {
  FEATURES[key] = key;
});


function isWebGL2(gl) {
  if (typeof WebGL2RenderingContext !== 'undefined' && gl instanceof WebGL2RenderingContext) {
    return true;
  }

  return Boolean(gl && gl._version === 2);
}

function getContextInfo(gl) {
  const info = gl.getExtension('WEBGL_debug_renderer_info');
  const vendor = gl.getParameter(info && info.UNMASKED_VENDOR_WEBGL || GL_VENDOR);
  const renderer = gl.getParameter(info && info.UNMASKED_RENDERER_WEBGL || GL_RENDERER);
  const gpuVendor = identifyGPUVendor(vendor, renderer);
  const gpuInfo = {
    gpuVendor,
    vendor,
    renderer,
    version: gl.getParameter(GL_VERSION),
    shadingLanguageVersion: gl.getParameter(GL_SHADING_LANGUAGE_VERSION)
  };
  return gpuInfo;
}

function identifyGPUVendor(vendor, renderer) {
  if (vendor.match(/NVIDIA/i) || renderer.match(/NVIDIA/i)) {
    return 'NVIDIA';
  }

  if (vendor.match(/INTEL/i) || renderer.match(/INTEL/i)) {
    return 'INTEL';
  }

  if (vendor.match(/AMD/i) || renderer.match(/AMD/i) || vendor.match(/ATI/i) || renderer.match(/ATI/i)) {
    return 'AMD';
  }

  return 'UNKNOWN GPU';
}

const compiledGlslExtensions = {};
function canCompileGLGSExtension(gl, cap, opts = {}) {
  const feature = WEBGL_FEATURES[cap];
  (0,assert/* default */.Z)(feature, cap);

  if (!isOldIE(opts)) {
    return true;
  }

  if (cap in compiledGlslExtensions) {
    return compiledGlslExtensions[cap];
  }

  const extensionName = feature[0];
  const behavior = opts.behavior || 'enable';
  const source = "#extension GL_".concat(extensionName, " : ").concat(behavior, "\nvoid main(void) {}");
  const shader = gl.createShader(35633);
  gl.shaderSource(shader, source);
  gl.compileShader(shader);
  const canCompile = gl.getShaderParameter(shader, 35713);
  gl.deleteShader(shader);
  compiledGlslExtensions[cap] = canCompile;
  return canCompile;
}

function getFeature(gl, cap) {
  const feature = WEBGL_FEATURES[cap];
  (0,assert/* default */.Z)(feature, cap);
  const extensionName = isWebGL2(gl) ? feature[1] || feature[0] : feature[0];
  const value = typeof extensionName === 'string' ? Boolean(gl.getExtension(extensionName)) : extensionName;
  (0,assert/* default */.Z)(value === false || value === true);
  return value;
}

function hasFeatures(gl, features) {
  features = Array.isArray(features) ? features : [features];
  return features.every(feature => getFeature(gl, feature));
}
//# sourceMappingURL=webgl-info.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/lib/platform-defines.js

function getPlatformShaderDefines(gl) {
  const debugInfo = getContextInfo(gl);

  switch (debugInfo.gpuVendor.toLowerCase()) {
    case 'nvidia':
      return "#define NVIDIA_GPU\n// Nvidia optimizes away the calculation necessary for emulated fp64\n#define LUMA_FP64_CODE_ELIMINATION_WORKAROUND 1\n";

    case 'intel':
      return "#define INTEL_GPU\n// Intel optimizes away the calculation necessary for emulated fp64\n#define LUMA_FP64_CODE_ELIMINATION_WORKAROUND 1\n// Intel's built-in 'tan' function doesn't have acceptable precision\n#define LUMA_FP32_TAN_PRECISION_WORKAROUND 1\n// Intel GPU doesn't have full 32 bits precision in same cases, causes overflow\n#define LUMA_FP64_HIGH_BITS_OVERFLOW_WORKAROUND 1\n";

    case 'amd':
      return "#define AMD_GPU\n";

    default:
      return "#define DEFAULT_GPU\n// Prevent driver from optimizing away the calculation necessary for emulated fp64\n#define LUMA_FP64_CODE_ELIMINATION_WORKAROUND 1\n// Intel's built-in 'tan' function doesn't have acceptable precision\n#define LUMA_FP32_TAN_PRECISION_WORKAROUND 1\n// Intel GPU doesn't have full 32 bits precision in same cases, causes overflow\n#define LUMA_FP64_HIGH_BITS_OVERFLOW_WORKAROUND 1\n";
  }
}
function getVersionDefines(gl, glslVersion, isFragment) {
  let versionDefines = "#if (__VERSION__ > 120)\n\n# define FEATURE_GLSL_DERIVATIVES\n# define FEATURE_GLSL_DRAW_BUFFERS\n# define FEATURE_GLSL_FRAG_DEPTH\n# define FEATURE_GLSL_TEXTURE_LOD\n\n// DEPRECATED FLAGS, remove in v9\n# define FRAG_DEPTH\n# define DERIVATIVES\n# define DRAW_BUFFERS\n# define TEXTURE_LOD\n\n#endif // __VERSION\n";

  if (hasFeatures(gl, FEATURES.GLSL_FRAG_DEPTH)) {
    versionDefines += "\n// FRAG_DEPTH => gl_FragDepth is available\n#ifdef GL_EXT_frag_depth\n#extension GL_EXT_frag_depth : enable\n# define FEATURE_GLSL_FRAG_DEPTH\n# define FRAG_DEPTH\n# define gl_FragDepth gl_FragDepthEXT\n#endif\n";
  }

  if (hasFeatures(gl, FEATURES.GLSL_DERIVATIVES) && canCompileGLGSExtension(gl, FEATURES.GLSL_DERIVATIVES)) {
    versionDefines += "\n// DERIVATIVES => dxdF, dxdY and fwidth are available\n#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n# define FEATURE_GLSL_DERIVATIVES\n# define DERIVATIVES\n#endif\n";
  }

  if (hasFeatures(gl, FEATURES.GLSL_FRAG_DATA) && canCompileGLGSExtension(gl, FEATURES.GLSL_FRAG_DATA, {
    behavior: 'require'
  })) {
    versionDefines += "\n// DRAW_BUFFERS => gl_FragData[] is available\n#ifdef GL_EXT_draw_buffers\n#extension GL_EXT_draw_buffers : require\n#define FEATURE_GLSL_DRAW_BUFFERS\n#define DRAW_BUFFERS\n#endif\n";
  }

  if (hasFeatures(gl, FEATURES.GLSL_TEXTURE_LOD)) {
    versionDefines += "// TEXTURE_LOD => texture2DLod etc are available\n#ifdef GL_EXT_shader_texture_lod\n#extension GL_EXT_shader_texture_lod : enable\n\n# define FEATURE_GLSL_TEXTURE_LOD\n# define TEXTURE_LOD\n\n#endif\n";
  }

  return versionDefines;
}
//# sourceMappingURL=platform-defines.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/lib/inject-shader.js + 1 modules
var inject_shader = __webpack_require__(86713);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/lib/transpile-shader.js
function testVariable(qualifier) {
  return new RegExp("\\b".concat(qualifier, "[ \\t]+(\\w+[ \\t]+\\w+(\\[\\w+\\])?;)"), 'g');
}

const ES300_REPLACEMENTS = [[/^(#version[ \t]+(100|300[ \t]+es))?[ \t]*\n/, '#version 300 es\n'], [/\btexture(2D|2DProj|Cube)Lod(EXT)?\(/g, 'textureLod('], [/\btexture(2D|2DProj|Cube)(EXT)?\(/g, 'texture(']];
const ES300_VERTEX_REPLACEMENTS = [...ES300_REPLACEMENTS, [testVariable('attribute'), 'in $1'], [testVariable('varying'), 'out $1']];
const ES300_FRAGMENT_REPLACEMENTS = [...ES300_REPLACEMENTS, [testVariable('varying'), 'in $1']];
const ES100_REPLACEMENTS = [[/^#version[ \t]+300[ \t]+es/, '#version 100'], [/\btexture(2D|2DProj|Cube)Lod\(/g, 'texture$1LodEXT('], [/\btexture\(/g, 'texture2D('], [/\btextureLod\(/g, 'texture2DLodEXT(']];
const ES100_VERTEX_REPLACEMENTS = [...ES100_REPLACEMENTS, [testVariable('in'), 'attribute $1'], [testVariable('out'), 'varying $1']];
const ES100_FRAGMENT_REPLACEMENTS = [...ES100_REPLACEMENTS, [testVariable('in'), 'varying $1']];
const ES100_FRAGMENT_OUTPUT_NAME = 'gl_FragColor';
const ES300_FRAGMENT_OUTPUT_REGEX = /\bout[ \t]+vec4[ \t]+(\w+)[ \t]*;\n?/;
const REGEX_START_OF_MAIN = /void\s+main\s*\([^)]*\)\s*\{\n?/;
function transpileShader(source, targetGLSLVersion, isVertex) {
  switch (targetGLSLVersion) {
    case 300:
      return isVertex ? convertShader(source, ES300_VERTEX_REPLACEMENTS) : convertFragmentShaderTo300(source);

    case 100:
      return isVertex ? convertShader(source, ES100_VERTEX_REPLACEMENTS) : convertFragmentShaderTo100(source);

    default:
      throw new Error("unknown GLSL version ".concat(targetGLSLVersion));
  }
}

function convertShader(source, replacements) {
  for (const [pattern, replacement] of replacements) {
    source = source.replace(pattern, replacement);
  }

  return source;
}

function convertFragmentShaderTo300(source) {
  source = convertShader(source, ES300_FRAGMENT_REPLACEMENTS);
  const outputMatch = source.match(ES300_FRAGMENT_OUTPUT_REGEX);

  if (outputMatch) {
    const outputName = outputMatch[1];
    source = source.replace(new RegExp("\\b".concat(ES100_FRAGMENT_OUTPUT_NAME, "\\b"), 'g'), outputName);
  } else {
    const outputName = 'fragmentColor';
    source = source.replace(REGEX_START_OF_MAIN, match => "out vec4 ".concat(outputName, ";\n").concat(match)).replace(new RegExp("\\b".concat(ES100_FRAGMENT_OUTPUT_NAME, "\\b"), 'g'), outputName);
  }

  return source;
}

function convertFragmentShaderTo100(source) {
  source = convertShader(source, ES100_FRAGMENT_REPLACEMENTS);
  const outputMatch = source.match(ES300_FRAGMENT_OUTPUT_REGEX);

  if (outputMatch) {
    const outputName = outputMatch[1];
    source = source.replace(ES300_FRAGMENT_OUTPUT_REGEX, '').replace(new RegExp("\\b".concat(outputName, "\\b"), 'g'), ES100_FRAGMENT_OUTPUT_NAME);
  }

  return source;
}
//# sourceMappingURL=transpile-shader.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/lib/assemble-shaders.js






const INJECT_SHADER_DECLARATIONS = "\n\n".concat(inject_shader/* DECLARATION_INJECT_MARKER */.O_, "\n\n");
const SHADER_TYPE = {
  [constants/* VERTEX_SHADER */.H]: 'vertex',
  [constants/* FRAGMENT_SHADER */.Y]: 'fragment'
};
const FRAGMENT_SHADER_PROLOGUE = "precision highp float;\n\n";
function assembleShaders(gl, opts) {
  const {
    vs,
    fs
  } = opts;
  const modules = resolveModules(opts.modules || []);
  return {
    gl,
    vs: assembleShader(gl, Object.assign({}, opts, {
      source: vs,
      type: constants/* VERTEX_SHADER */.H,
      modules
    })),
    fs: assembleShader(gl, Object.assign({}, opts, {
      source: fs,
      type: constants/* FRAGMENT_SHADER */.Y,
      modules
    })),
    getUniforms: assembleGetUniforms(modules)
  };
}

function assembleShader(gl, {
  id,
  source,
  type,
  modules,
  defines = {},
  hookFunctions = [],
  inject = {},
  transpileToGLSL100 = false,
  prologue = true,
  log
}) {
  (0,assert/* default */.Z)(typeof source === 'string', 'shader source must be a string');
  const isVertex = type === constants/* VERTEX_SHADER */.H;
  const sourceLines = source.split('\n');
  let glslVersion = 100;
  let versionLine = '';
  let coreSource = source;

  if (sourceLines[0].indexOf('#version ') === 0) {
    glslVersion = 300;
    versionLine = sourceLines[0];
    coreSource = sourceLines.slice(1).join('\n');
  } else {
    versionLine = "#version ".concat(glslVersion);
  }

  const allDefines = {};
  modules.forEach(module => {
    Object.assign(allDefines, module.getDefines());
  });
  Object.assign(allDefines, defines);
  let assembledSource = prologue ? "".concat(versionLine, "\n").concat(getShaderName({
    id,
    source,
    type
  }), "\n").concat(getShaderType({
    type
  }), "\n").concat(getPlatformShaderDefines(gl), "\n").concat(getVersionDefines(gl, glslVersion, !isVertex), "\n").concat(getApplicationDefines(allDefines), "\n").concat(isVertex ? '' : FRAGMENT_SHADER_PROLOGUE, "\n") : "".concat(versionLine, "\n");
  const hookFunctionMap = normalizeHookFunctions(hookFunctions);
  const hookInjections = {};
  const declInjections = {};
  const mainInjections = {};

  for (const key in inject) {
    const injection = typeof inject[key] === 'string' ? {
      injection: inject[key],
      order: 0
    } : inject[key];
    const match = key.match(/^(v|f)s:(#)?([\w-]+)$/);

    if (match) {
      const hash = match[2];
      const name = match[3];

      if (hash) {
        if (name === 'decl') {
          declInjections[key] = [injection];
        } else {
          mainInjections[key] = [injection];
        }
      } else {
        hookInjections[key] = [injection];
      }
    } else {
      mainInjections[key] = [injection];
    }
  }

  for (const module of modules) {
    if (log) {
      module.checkDeprecations(coreSource, log);
    }

    const moduleSource = module.getModuleSource(type, glslVersion);
    assembledSource += moduleSource;
    const injections = module.injections[type];

    for (const key in injections) {
      const match = key.match(/^(v|f)s:#([\w-]+)$/);

      if (match) {
        const name = match[2];
        const injectionType = name === 'decl' ? declInjections : mainInjections;
        injectionType[key] = injectionType[key] || [];
        injectionType[key].push(injections[key]);
      } else {
        hookInjections[key] = hookInjections[key] || [];
        hookInjections[key].push(injections[key]);
      }
    }
  }

  assembledSource += INJECT_SHADER_DECLARATIONS;
  assembledSource = (0,inject_shader/* default */.ZP)(assembledSource, type, declInjections);
  assembledSource += getHookFunctions(hookFunctionMap[type], hookInjections);
  assembledSource += coreSource;
  assembledSource = (0,inject_shader/* default */.ZP)(assembledSource, type, mainInjections);
  assembledSource = transpileShader(assembledSource, transpileToGLSL100 ? 100 : glslVersion, isVertex);
  return assembledSource;
}

function assembleGetUniforms(modules) {
  return function getUniforms(opts) {
    const uniforms = {};

    for (const module of modules) {
      const moduleUniforms = module.getUniforms(opts, uniforms);
      Object.assign(uniforms, moduleUniforms);
    }

    return uniforms;
  };
}

function getShaderType({
  type
}) {
  return "\n#define SHADER_TYPE_".concat(SHADER_TYPE[type].toUpperCase(), "\n");
}

function getShaderName({
  id,
  source,
  type
}) {
  const injectShaderName = id && typeof id === 'string' && source.indexOf('SHADER_NAME') === -1;
  return injectShaderName ? "\n#define SHADER_NAME ".concat(id, "_").concat(SHADER_TYPE[type], "\n\n") : '';
}

function getApplicationDefines(defines = {}) {
  let count = 0;
  let sourceText = '';

  for (const define in defines) {
    if (count === 0) {
      sourceText += '\n// APPLICATION DEFINES\n';
    }

    count++;
    const value = defines[define];

    if (value || Number.isFinite(value)) {
      sourceText += "#define ".concat(define.toUpperCase(), " ").concat(defines[define], "\n");
    }
  }

  if (count === 0) {
    sourceText += '\n';
  }

  return sourceText;
}

function getHookFunctions(hookFunctions, hookInjections) {
  let result = '';

  for (const hookName in hookFunctions) {
    const hookFunction = hookFunctions[hookName];
    result += "void ".concat(hookFunction.signature, " {\n");

    if (hookFunction.header) {
      result += "  ".concat(hookFunction.header);
    }

    if (hookInjections[hookName]) {
      const injections = hookInjections[hookName];
      injections.sort((a, b) => a.order - b.order);

      for (const injection of injections) {
        result += "  ".concat(injection.injection, "\n");
      }
    }

    if (hookFunction.footer) {
      result += "  ".concat(hookFunction.footer);
    }

    result += '}\n';
  }

  return result;
}

function normalizeHookFunctions(hookFunctions) {
  const result = {
    vs: {},
    fs: {}
  };
  hookFunctions.forEach(hook => {
    let opts;

    if (typeof hook !== 'string') {
      opts = hook;
      hook = opts.hook;
    } else {
      opts = {};
    }

    hook = hook.trim();
    const [stage, signature] = hook.split(':');
    const name = hook.replace(/\(.+/, '');
    result[stage][name] = Object.assign(opts, {
      signature
    });
  });
  return result;
}
//# sourceMappingURL=assemble-shaders.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/program.js + 6 modules
var program = __webpack_require__(7944);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/engine/dist/esm/lib/program-manager.js


class ProgramManager {
  static getDefaultProgramManager(gl) {
    gl.luma = gl.luma || {};
    gl.luma.defaultProgramManager = gl.luma.defaultProgramManager || new ProgramManager(gl);
    return gl.luma.defaultProgramManager;
  }

  constructor(gl) {
    this.gl = gl;
    this._programCache = {};
    this._getUniforms = {};
    this._registeredModules = {};
    this._hookFunctions = [];
    this._defaultModules = [];
    this._hashes = {};
    this._hashCounter = 0;
    this.stateHash = 0;
    this._useCounts = {};
  }

  addDefaultModule(module) {
    if (!this._defaultModules.find(m => m.name === module.name)) {
      this._defaultModules.push(module);
    }

    this.stateHash++;
  }

  removeDefaultModule(module) {
    const moduleName = typeof module === 'string' ? module : module.name;
    this._defaultModules = this._defaultModules.filter(m => m.name !== moduleName);
    this.stateHash++;
  }

  addShaderHook(hook, opts) {
    if (opts) {
      hook = Object.assign(opts, {
        hook
      });
    }

    this._hookFunctions.push(hook);

    this.stateHash++;
  }

  get(props = {}) {
    const {
      vs = '',
      fs = '',
      defines = {},
      inject = {},
      varyings = [],
      bufferMode = 0x8c8d,
      transpileToGLSL100 = false
    } = props;

    const modules = this._getModuleList(props.modules);

    const vsHash = this._getHash(vs);

    const fsHash = this._getHash(fs);

    const moduleHashes = modules.map(m => this._getHash(m.name)).sort();
    const varyingHashes = varyings.map(v => this._getHash(v));
    const defineKeys = Object.keys(defines).sort();
    const injectKeys = Object.keys(inject).sort();
    const defineHashes = [];
    const injectHashes = [];

    for (const key of defineKeys) {
      defineHashes.push(this._getHash(key));
      defineHashes.push(this._getHash(defines[key]));
    }

    for (const key of injectKeys) {
      injectHashes.push(this._getHash(key));
      injectHashes.push(this._getHash(inject[key]));
    }

    const hash = "".concat(vsHash, "/").concat(fsHash, "D").concat(defineHashes.join('/'), "M").concat(moduleHashes.join('/'), "I").concat(injectHashes.join('/'), "V").concat(varyingHashes.join('/'), "H").concat(this.stateHash, "B").concat(bufferMode).concat(transpileToGLSL100 ? 'T' : '');

    if (!this._programCache[hash]) {
      const assembled = assembleShaders(this.gl, {
        vs,
        fs,
        modules,
        inject,
        defines,
        hookFunctions: this._hookFunctions,
        transpileToGLSL100
      });
      this._programCache[hash] = new program/* default */.Z(this.gl, {
        hash,
        vs: assembled.vs,
        fs: assembled.fs,
        varyings,
        bufferMode
      });

      this._getUniforms[hash] = assembled.getUniforms || (x => {});

      this._useCounts[hash] = 0;
    }

    this._useCounts[hash]++;
    return this._programCache[hash];
  }

  getUniforms(program) {
    return this._getUniforms[program.hash] || null;
  }

  release(program) {
    const hash = program.hash;
    this._useCounts[hash]--;

    if (this._useCounts[hash] === 0) {
      this._programCache[hash].delete();

      delete this._programCache[hash];
      delete this._getUniforms[hash];
      delete this._useCounts[hash];
    }
  }

  _getHash(key) {
    if (this._hashes[key] === undefined) {
      this._hashes[key] = this._hashCounter++;
    }

    return this._hashes[key];
  }

  _getModuleList(appModules = []) {
    const modules = new Array(this._defaultModules.length + appModules.length);
    const seen = {};
    let count = 0;

    for (let i = 0, len = this._defaultModules.length; i < len; ++i) {
      const module = this._defaultModules[i];
      const name = module.name;
      modules[count++] = module;
      seen[name] = true;
    }

    for (let i = 0, len = appModules.length; i < len; ++i) {
      const module = appModules[i];
      const name = module.name;

      if (!seen[name]) {
        modules[count++] = module;
        seen[name] = true;
      }
    }

    modules.length = count;
    return modules;
  }

}
//# sourceMappingURL=program-manager.js.map

/***/ }),

/***/ 63346:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Transform)
});

// EXTERNAL MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/utils/assert.js
var assert = __webpack_require__(29047);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/utils/shader-utils.js

const FS100 = "void main() {gl_FragColor = vec4(0);}";
const FS_GLES = "out vec4 transform_output;\nvoid main() {\n  transform_output = vec4(0);\n}";
const FS300 = "#version 300 es\n".concat(FS_GLES);
function getQualifierDetails(line, qualifiers) {
  qualifiers = Array.isArray(qualifiers) ? qualifiers : [qualifiers];
  const words = line.replace(/^\s+/, '').split(/\s+/);
  const [qualifier, type, definition] = words;

  if (!qualifiers.includes(qualifier) || !type || !definition) {
    return null;
  }

  const name = definition.split(';')[0];
  return {
    qualifier,
    type,
    name
  };
}
function getPassthroughFS(options = {}) {
  const {
    version = 100,
    input,
    inputType,
    output
  } = options;

  if (!input) {
    if (version === 300) {
      return FS300;
    } else if (version > 300) {
      return "#version ".concat(version, "\n").concat(FS_GLES);
    }

    return FS100;
  }

  const outputValue = convertToVec4(input, inputType);

  if (version >= 300) {
    return "#version ".concat(version, " ").concat(version === 300 ? 'es' : '', "\nin ").concat(inputType, " ").concat(input, ";\nout vec4 ").concat(output, ";\nvoid main() {\n  ").concat(output, " = ").concat(outputValue, ";\n}");
  }

  return "varying ".concat(inputType, " ").concat(input, ";\nvoid main() {\n  gl_FragColor = ").concat(outputValue, ";\n}");
}
function typeToChannelSuffix(type) {
  switch (type) {
    case 'float':
      return 'x';

    case 'vec2':
      return 'xy';

    case 'vec3':
      return 'xyz';

    case 'vec4':
      return 'xyzw';

    default:
      (0,assert/* default */.Z)(false);
      return null;
  }
}
function typeToChannelCount(type) {
  switch (type) {
    case 'float':
      return 1;

    case 'vec2':
      return 2;

    case 'vec3':
      return 3;

    case 'vec4':
      return 4;

    default:
      (0,assert/* default */.Z)(false);
      return null;
  }
}
function convertToVec4(variable, type) {
  switch (type) {
    case 'float':
      return "vec4(".concat(variable, ", 0.0, 0.0, 1.0)");

    case 'vec2':
      return "vec4(".concat(variable, ", 0.0, 1.0)");

    case 'vec3':
      return "vec4(".concat(variable, ", 1.0)");

    case 'vec4':
      return variable;

    default:
      (0,assert/* default */.Z)(false);
      return null;
  }
}
//# sourceMappingURL=shader-utils.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/gltools/dist/esm/index.js + 13 modules
var esm = __webpack_require__(39450);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/buffer.js
var classes_buffer = __webpack_require__(53478);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/transform-feedback.js
var transform_feedback = __webpack_require__(51053);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/assert.js
var utils_assert = __webpack_require__(22525);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/engine/dist/esm/transform/buffer-transform.js



class BufferTransform {
  constructor(gl, props = {}) {
    this.gl = gl;
    this.currentIndex = 0;
    this.feedbackMap = {};
    this.varyings = null;
    this.bindings = [];
    this.resources = {};

    this._initialize(props);

    Object.seal(this);
  }

  setupResources(opts) {
    for (const binding of this.bindings) {
      this._setupTransformFeedback(binding, opts);
    }
  }

  updateModelProps(props = {}) {
    const {
      varyings
    } = this;

    if (varyings.length > 0) {
      props = Object.assign({}, props, {
        varyings
      });
    }

    return props;
  }

  getDrawOptions(opts = {}) {
    const binding = this.bindings[this.currentIndex];
    const {
      sourceBuffers,
      transformFeedback
    } = binding;
    const attributes = Object.assign({}, sourceBuffers, opts.attributes);
    return {
      attributes,
      transformFeedback
    };
  }

  swap() {
    if (this.feedbackMap) {
      this.currentIndex = this._getNextIndex();
      return true;
    }

    return false;
  }

  update(opts = {}) {
    this._setupBuffers(opts);
  }

  getBuffer(varyingName) {
    const {
      feedbackBuffers
    } = this.bindings[this.currentIndex];
    const bufferOrParams = varyingName ? feedbackBuffers[varyingName] : null;

    if (!bufferOrParams) {
      return null;
    }

    return bufferOrParams instanceof classes_buffer/* default */.Z ? bufferOrParams : bufferOrParams.buffer;
  }

  getData(options = {}) {
    const {
      varyingName
    } = options;
    const buffer = this.getBuffer(varyingName);

    if (buffer) {
      return buffer.getData();
    }

    return null;
  }

  delete() {
    for (const name in this.resources) {
      this.resources[name].delete();
    }
  }

  _initialize(props = {}) {
    this._setupBuffers(props);

    this.varyings = props.varyings || Object.keys(this.bindings[this.currentIndex].feedbackBuffers);

    if (this.varyings.length > 0) {
      (0,utils_assert/* default */.Z)((0,esm/* isWebGL2 */.D0)(this.gl));
    }
  }

  _getFeedbackBuffers(props) {
    const {
      sourceBuffers = {}
    } = props;
    const feedbackBuffers = {};

    if (this.bindings[this.currentIndex]) {
      Object.assign(feedbackBuffers, this.bindings[this.currentIndex].feedbackBuffers);
    }

    if (this.feedbackMap) {
      for (const sourceName in this.feedbackMap) {
        const feedbackName = this.feedbackMap[sourceName];

        if (sourceName in sourceBuffers) {
          feedbackBuffers[feedbackName] = sourceName;
        }
      }
    }

    Object.assign(feedbackBuffers, props.feedbackBuffers);

    for (const bufferName in feedbackBuffers) {
      const bufferOrRef = feedbackBuffers[bufferName];

      if (typeof bufferOrRef === 'string') {
        const sourceBuffer = sourceBuffers[bufferOrRef];
        const {
          byteLength,
          usage,
          accessor
        } = sourceBuffer;
        feedbackBuffers[bufferName] = this._createNewBuffer(bufferName, {
          byteLength,
          usage,
          accessor
        });
      }
    }

    return feedbackBuffers;
  }

  _setupBuffers(props = {}) {
    const {
      sourceBuffers = null
    } = props;
    Object.assign(this.feedbackMap, props.feedbackMap);

    const feedbackBuffers = this._getFeedbackBuffers(props);

    this._updateBindings({
      sourceBuffers,
      feedbackBuffers
    });
  }

  _setupTransformFeedback(binding, {
    model
  }) {
    const {
      program
    } = model;
    binding.transformFeedback = new transform_feedback/* default */.Z(this.gl, {
      program,
      buffers: binding.feedbackBuffers
    });
  }

  _updateBindings(opts) {
    this.bindings[this.currentIndex] = this._updateBinding(this.bindings[this.currentIndex], opts);

    if (this.feedbackMap) {
      const {
        sourceBuffers,
        feedbackBuffers
      } = this._swapBuffers(this.bindings[this.currentIndex]);

      const nextIndex = this._getNextIndex();

      this.bindings[nextIndex] = this._updateBinding(this.bindings[nextIndex], {
        sourceBuffers,
        feedbackBuffers
      });
    }
  }

  _updateBinding(binding, opts) {
    if (!binding) {
      return {
        sourceBuffers: Object.assign({}, opts.sourceBuffers),
        feedbackBuffers: Object.assign({}, opts.feedbackBuffers)
      };
    }

    Object.assign(binding.sourceBuffers, opts.sourceBuffers);
    Object.assign(binding.feedbackBuffers, opts.feedbackBuffers);

    if (binding.transformFeedback) {
      binding.transformFeedback.setBuffers(binding.feedbackBuffers);
    }

    return binding;
  }

  _swapBuffers(opts) {
    if (!this.feedbackMap) {
      return null;
    }

    const sourceBuffers = Object.assign({}, opts.sourceBuffers);
    const feedbackBuffers = Object.assign({}, opts.feedbackBuffers);

    for (const srcName in this.feedbackMap) {
      const dstName = this.feedbackMap[srcName];
      sourceBuffers[srcName] = opts.feedbackBuffers[dstName];
      feedbackBuffers[dstName] = opts.sourceBuffers[srcName];
      (0,utils_assert/* default */.Z)(feedbackBuffers[dstName] instanceof classes_buffer/* default */.Z);
    }

    return {
      sourceBuffers,
      feedbackBuffers
    };
  }

  _createNewBuffer(name, opts) {
    const buffer = new classes_buffer/* default */.Z(this.gl, opts);

    if (this.resources[name]) {
      this.resources[name].delete();
    }

    this.resources[name] = buffer;
    return buffer;
  }

  _getNextIndex() {
    return (this.currentIndex + 1) % 2;
  }

}
//# sourceMappingURL=buffer-transform.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/copy-and-blit.js + 1 modules
var copy_and_blit = __webpack_require__(1953);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture-2d.js + 1 modules
var texture_2d = __webpack_require__(4912);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/framebuffer.js
var classes_framebuffer = __webpack_require__(53849);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/webgl-utils/texture-utils.js + 2 modules
var texture_utils = __webpack_require__(95432);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/glsl-utils/get-shader-version.js
function getShaderVersion(source) {
  let version = 100;
  const words = source.match(/[^\s]+/g);

  if (words.length >= 2 && words[0] === '#version') {
    const v = parseInt(words[1], 10);

    if (Number.isFinite(v)) {
      version = v;
    }
  }

  return version;
}
//# sourceMappingURL=get-shader-version.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/lib/inject-shader.js + 1 modules
var inject_shader = __webpack_require__(86713);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/modules/transform/transform.js
const vs = "attribute float transform_elementID;\nvec2 transform_getPixelSizeHalf(vec2 size) {\n  return vec2(1.) / (2. * size);\n}\n\nvec2 transform_getPixelIndices(vec2 texSize, vec2 pixelSizeHalf) {\n  float yIndex = floor((transform_elementID / texSize[0]) + pixelSizeHalf[1]);\n  float xIndex = transform_elementID - (yIndex * texSize[0]);\n  return vec2(xIndex, yIndex);\n}\nvec2 transform_getTexCoord(vec2 size) {\n  vec2 pixelSizeHalf = transform_getPixelSizeHalf(size);\n  vec2 indices = transform_getPixelIndices(size, pixelSizeHalf);\n  vec2 coord = indices / size + pixelSizeHalf;\n  return coord;\n}\nvec2 transform_getPos(vec2 size) {\n  vec2 texCoord = transform_getTexCoord(size);\n  vec2 pos = (texCoord * (2.0, 2.0)) - (1., 1.);\n  return pos;\n}\nvec4 transform_getInput(sampler2D texSampler, vec2 size) {\n  vec2 texCoord = transform_getTexCoord(size);\n  vec4 textureColor = texture2D(texSampler, texCoord);\n  return textureColor;\n}\n";
const transform = {
  name: 'transform',
  vs,
  fs: null
};
//# sourceMappingURL=transform.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/engine/dist/esm/transform/transform-shader-utils.js


const SAMPLER_UNIFORM_PREFIX = 'transform_uSampler_';
const SIZE_UNIFORM_PREFIX = 'transform_uSize_';
const VS_POS_VARIABLE = 'transform_position';
function updateForTextures({
  vs,
  sourceTextureMap,
  targetTextureVarying,
  targetTexture
}) {
  const texAttributeNames = Object.keys(sourceTextureMap);
  let sourceCount = texAttributeNames.length;
  let targetTextureType = null;
  const samplerTextureMap = {};
  let updatedVs = vs;
  let finalInject = {};

  if (sourceCount > 0 || targetTextureVarying) {
    const vsLines = updatedVs.split('\n');
    const updateVsLines = vsLines.slice();
    vsLines.forEach((line, index, lines) => {
      if (sourceCount > 0) {
        const updated = processAttributeDefinition(line, sourceTextureMap);

        if (updated) {
          const {
            updatedLine,
            inject
          } = updated;
          updateVsLines[index] = updatedLine;
          finalInject = (0,inject_shader/* combineInjects */.Lm)([finalInject, inject]);
          Object.assign(samplerTextureMap, updated.samplerTextureMap);
          sourceCount--;
        }
      }

      if (targetTextureVarying && !targetTextureType) {
        targetTextureType = getVaryingType(line, targetTextureVarying);
      }
    });

    if (targetTextureVarying) {
      (0,utils_assert/* default */.Z)(targetTexture);
      const sizeName = "".concat(SIZE_UNIFORM_PREFIX).concat(targetTextureVarying);
      const uniformDeclaration = "uniform vec2 ".concat(sizeName, ";\n");
      const posInstructions = "     vec2 ".concat(VS_POS_VARIABLE, " = transform_getPos(").concat(sizeName, ");\n     gl_Position = vec4(").concat(VS_POS_VARIABLE, ", 0, 1.);\n");
      const inject = {
        'vs:#decl': uniformDeclaration,
        'vs:#main-start': posInstructions
      };
      finalInject = (0,inject_shader/* combineInjects */.Lm)([finalInject, inject]);
    }

    updatedVs = updateVsLines.join('\n');
  }

  return {
    vs: updatedVs,
    targetTextureType,
    inject: finalInject,
    samplerTextureMap
  };
}
function getSizeUniforms({
  sourceTextureMap,
  targetTextureVarying,
  targetTexture
}) {
  const uniforms = {};
  let width;
  let height;

  if (targetTextureVarying) {
    ({
      width,
      height
    } = targetTexture);
    uniforms["".concat(SIZE_UNIFORM_PREFIX).concat(targetTextureVarying)] = [width, height];
  }

  for (const textureName in sourceTextureMap) {
    ({
      width,
      height
    } = sourceTextureMap[textureName]);
    uniforms["".concat(SIZE_UNIFORM_PREFIX).concat(textureName)] = [width, height];
  }

  return uniforms;
}

function getAttributeDefinition(line) {
  return getQualifierDetails(line, ['attribute', 'in']);
}

function getSamplerDeclerations(textureName) {
  const samplerName = "".concat(SAMPLER_UNIFORM_PREFIX).concat(textureName);
  const sizeName = "".concat(SIZE_UNIFORM_PREFIX).concat(textureName);
  const uniformDeclerations = "  uniform sampler2D ".concat(samplerName, ";\n  uniform vec2 ").concat(sizeName, ";");
  return {
    samplerName,
    sizeName,
    uniformDeclerations
  };
}

function getVaryingType(line, varying) {
  const qualaiferDetails = getQualifierDetails(line, ['varying', 'out']);

  if (!qualaiferDetails) {
    return null;
  }

  return qualaiferDetails.name === varying ? qualaiferDetails.type : null;
}
function processAttributeDefinition(line, textureMap) {
  const samplerTextureMap = {};
  const attributeData = getAttributeDefinition(line);

  if (!attributeData) {
    return null;
  }

  const {
    type,
    name
  } = attributeData;

  if (name && textureMap[name]) {
    const updatedLine = "// ".concat(line, " => Replaced by Transform with a sampler");
    const {
      samplerName,
      sizeName,
      uniformDeclerations
    } = getSamplerDeclerations(name);
    const channels = typeToChannelSuffix(type);
    const sampleInstruction = "  ".concat(type, " ").concat(name, " = transform_getInput(").concat(samplerName, ", ").concat(sizeName, ").").concat(channels, ";\n");
    samplerTextureMap[samplerName] = name;
    const inject = {
      'vs:#decl': uniformDeclerations,
      'vs:#main-start': sampleInstruction
    };
    return {
      updatedLine,
      inject,
      samplerTextureMap
    };
  }

  return null;
}
//# sourceMappingURL=transform-shader-utils.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/engine/dist/esm/transform/texture-transform.js



const SRC_TEX_PARAMETER_OVERRIDES = {
  [10241]: 9728,
  [10240]: 9728,
  [10242]: 33071,
  [10243]: 33071
};
const FS_OUTPUT_VARIABLE = 'transform_output';
class TextureTransform {
  constructor(gl, props = {}) {
    this.gl = gl;
    this.id = this.currentIndex = 0;
    this._swapTexture = null;
    this.targetTextureVarying = null;
    this.targetTextureType = null;
    this.samplerTextureMap = null;
    this.bindings = [];
    this.resources = {};

    this._initialize(props);

    Object.seal(this);
  }

  updateModelProps(props = {}) {
    const updatedModelProps = this._processVertexShader(props);

    return Object.assign({}, props, updatedModelProps);
  }

  getDrawOptions(opts = {}) {
    const {
      sourceBuffers,
      sourceTextures,
      framebuffer,
      targetTexture
    } = this.bindings[this.currentIndex];
    const attributes = Object.assign({}, sourceBuffers, opts.attributes);
    const uniforms = Object.assign({}, opts.uniforms);
    const parameters = Object.assign({}, opts.parameters);
    let discard = opts.discard;

    if (this.hasSourceTextures || this.hasTargetTexture) {
      attributes.transform_elementID = this.elementIDBuffer;

      for (const sampler in this.samplerTextureMap) {
        const textureName = this.samplerTextureMap[sampler];
        uniforms[sampler] = sourceTextures[textureName];
      }

      this._setSourceTextureParameters();

      const sizeUniforms = getSizeUniforms({
        sourceTextureMap: sourceTextures,
        targetTextureVarying: this.targetTextureVarying,
        targetTexture
      });
      Object.assign(uniforms, sizeUniforms);
    }

    if (this.hasTargetTexture) {
      discard = false;
      parameters.viewport = [0, 0, framebuffer.width, framebuffer.height];
    }

    return {
      attributes,
      framebuffer,
      uniforms,
      discard,
      parameters
    };
  }

  swap() {
    if (this._swapTexture) {
      this.currentIndex = this._getNextIndex();
      return true;
    }

    return false;
  }

  update(opts = {}) {
    this._setupTextures(opts);
  }

  getTargetTexture() {
    const {
      targetTexture
    } = this.bindings[this.currentIndex];
    return targetTexture;
  }

  getData({
    packed = false
  } = {}) {
    const {
      framebuffer
    } = this.bindings[this.currentIndex];
    const pixels = (0,copy_and_blit/* readPixelsToArray */.z6)(framebuffer);

    if (!packed) {
      return pixels;
    }

    const ArrayType = pixels.constructor;
    const channelCount = typeToChannelCount(this.targetTextureType);
    const packedPixels = new ArrayType(pixels.length * channelCount / 4);
    let packCount = 0;

    for (let i = 0; i < pixels.length; i += 4) {
      for (let j = 0; j < channelCount; j++) {
        packedPixels[packCount++] = pixels[i + j];
      }
    }

    return packedPixels;
  }

  getFramebuffer() {
    const currentResources = this.bindings[this.currentIndex];
    return currentResources.framebuffer;
  }

  delete() {
    if (this.ownTexture) {
      this.ownTexture.delete();
    }

    if (this.elementIDBuffer) {
      this.elementIDBuffer.delete();
    }
  }

  _initialize(props = {}) {
    const {
      _targetTextureVarying,
      _swapTexture
    } = props;
    this._swapTexture = _swapTexture;
    this.targetTextureVarying = _targetTextureVarying;
    this.hasTargetTexture = _targetTextureVarying;

    this._setupTextures(props);
  }

  _createTargetTexture(props) {
    const {
      sourceTextures,
      textureOrReference
    } = props;

    if (textureOrReference instanceof texture_2d/* default */.Z) {
      return textureOrReference;
    }

    const refTexture = sourceTextures[textureOrReference];

    if (!refTexture) {
      return null;
    }

    this._targetRefTexName = textureOrReference;
    return this._createNewTexture(refTexture);
  }

  _setupTextures(props = {}) {
    const {
      sourceBuffers,
      _sourceTextures = {},
      _targetTexture
    } = props;

    const targetTexture = this._createTargetTexture({
      sourceTextures: _sourceTextures,
      textureOrReference: _targetTexture
    });

    this.hasSourceTextures = this.hasSourceTextures || _sourceTextures && Object.keys(_sourceTextures).length > 0;

    this._updateBindings({
      sourceBuffers,
      sourceTextures: _sourceTextures,
      targetTexture
    });

    if ('elementCount' in props) {
      this._updateElementIDBuffer(props.elementCount);
    }
  }

  _updateElementIDBuffer(elementCount) {
    if (typeof elementCount !== 'number' || this.elementCount >= elementCount) {
      return;
    }

    const elementIds = new Float32Array(elementCount);
    elementIds.forEach((_, index, array) => {
      array[index] = index;
    });

    if (!this.elementIDBuffer) {
      this.elementIDBuffer = new classes_buffer/* default */.Z(this.gl, {
        data: elementIds,
        accessor: {
          size: 1
        }
      });
    } else {
      this.elementIDBuffer.setData({
        data: elementIds
      });
    }

    this.elementCount = elementCount;
  }

  _updateBindings(opts) {
    this.bindings[this.currentIndex] = this._updateBinding(this.bindings[this.currentIndex], opts);

    if (this._swapTexture) {
      const {
        sourceTextures,
        targetTexture
      } = this._swapTextures(this.bindings[this.currentIndex]);

      const nextIndex = this._getNextIndex();

      this.bindings[nextIndex] = this._updateBinding(this.bindings[nextIndex], {
        sourceTextures,
        targetTexture
      });
    }
  }

  _updateBinding(binding, opts) {
    const {
      sourceBuffers,
      sourceTextures,
      targetTexture
    } = opts;

    if (!binding) {
      binding = {
        sourceBuffers: {},
        sourceTextures: {},
        targetTexture: null
      };
    }

    Object.assign(binding.sourceTextures, sourceTextures);
    Object.assign(binding.sourceBuffers, sourceBuffers);

    if (targetTexture) {
      binding.targetTexture = targetTexture;
      const {
        width,
        height
      } = targetTexture;
      const {
        framebuffer
      } = binding;

      if (framebuffer) {
        framebuffer.update({
          attachments: {
            [36064]: targetTexture
          },
          resizeAttachments: false
        });
        framebuffer.resize({
          width,
          height
        });
      } else {
        binding.framebuffer = new classes_framebuffer/* default */.Z(this.gl, {
          id: "transform-framebuffer",
          width,
          height,
          attachments: {
            [36064]: targetTexture
          }
        });
      }
    }

    return binding;
  }

  _setSourceTextureParameters() {
    const index = this.currentIndex;
    const {
      sourceTextures
    } = this.bindings[index];

    for (const name in sourceTextures) {
      sourceTextures[name].setParameters(SRC_TEX_PARAMETER_OVERRIDES);
    }
  }

  _swapTextures(opts) {
    if (!this._swapTexture) {
      return null;
    }

    const sourceTextures = Object.assign({}, opts.sourceTextures);
    sourceTextures[this._swapTexture] = opts.targetTexture;
    const targetTexture = opts.sourceTextures[this._swapTexture];
    return {
      sourceTextures,
      targetTexture
    };
  }

  _createNewTexture(refTexture) {
    const texture = (0,texture_utils/* cloneTextureFrom */.h)(refTexture, {
      parameters: {
        [10241]: 9728,
        [10240]: 9728,
        [10242]: 33071,
        [10243]: 33071
      },
      pixelStore: {
        [37440]: false
      }
    });

    if (this.ownTexture) {
      this.ownTexture.delete();
    }

    this.ownTexture = texture;
    return texture;
  }

  _getNextIndex() {
    return (this.currentIndex + 1) % 2;
  }

  _processVertexShader(props = {}) {
    const {
      sourceTextures,
      targetTexture
    } = this.bindings[this.currentIndex];
    const {
      vs,
      uniforms,
      targetTextureType,
      inject,
      samplerTextureMap
    } = updateForTextures({
      vs: props.vs,
      sourceTextureMap: sourceTextures,
      targetTextureVarying: this.targetTextureVarying,
      targetTexture
    });
    const combinedInject = (0,inject_shader/* combineInjects */.Lm)([props.inject || {}, inject]);
    this.targetTextureType = targetTextureType;
    this.samplerTextureMap = samplerTextureMap;
    const fs = props._fs || getPassthroughFS({
      version: getShaderVersion(vs),
      input: this.targetTextureVarying,
      inputType: targetTextureType,
      output: FS_OUTPUT_VARIABLE
    });
    const modules = this.hasSourceTextures || this.targetTextureVarying ? [transform].concat(props.modules || []) : props.modules;
    return {
      vs,
      fs,
      modules,
      uniforms,
      inject: combinedInject
    };
  }

}
//# sourceMappingURL=texture-transform.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/utils.js
var utils = __webpack_require__(74538);
// EXTERNAL MODULE: ./node_modules/@luma.gl/engine/dist/esm/lib/model.js + 9 modules
var model = __webpack_require__(281);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/engine/dist/esm/transform/transform.js






class Transform {
  static isSupported(gl) {
    return (0,esm/* isWebGL2 */.D0)(gl);
  }

  constructor(gl, props = {}) {
    this.gl = gl;
    this.model = null;
    this.elementCount = 0;
    this.bufferTransform = null;
    this.textureTransform = null;
    this.elementIDBuffer = null;

    this._initialize(props);

    Object.seal(this);
  }

  delete() {
    const {
      model,
      bufferTransform,
      textureTransform
    } = this;

    if (model) {
      model.delete();
    }

    if (bufferTransform) {
      bufferTransform.delete();
    }

    if (textureTransform) {
      textureTransform.delete();
    }
  }

  run(opts = {}) {
    const {
      clearRenderTarget = true
    } = opts;

    const updatedOpts = this._updateDrawOptions(opts);

    if (clearRenderTarget && updatedOpts.framebuffer) {
      updatedOpts.framebuffer.clear({
        color: true
      });
    }

    this.model.transform(updatedOpts);
  }

  swap() {
    let swapped = false;
    const resourceTransforms = [this.bufferTransform, this.textureTransform].filter(Boolean);

    for (const resourceTransform of resourceTransforms) {
      swapped = swapped || resourceTransform.swap();
    }

    (0,utils_assert/* default */.Z)(swapped, 'Nothing to swap');
  }

  getBuffer(varyingName = null) {
    return this.bufferTransform && this.bufferTransform.getBuffer(varyingName);
  }

  getData(opts = {}) {
    const resourceTransforms = [this.bufferTransform, this.textureTransform].filter(Boolean);

    for (const resourceTransform of resourceTransforms) {
      const data = resourceTransform.getData(opts);

      if (data) {
        return data;
      }
    }

    return null;
  }

  getFramebuffer() {
    return this.textureTransform && this.textureTransform.getFramebuffer();
  }

  update(opts = {}) {
    if ('elementCount' in opts) {
      this.model.setVertexCount(opts.elementCount);
    }

    const resourceTransforms = [this.bufferTransform, this.textureTransform].filter(Boolean);

    for (const resourceTransform of resourceTransforms) {
      resourceTransform.update(opts);
    }
  }

  _initialize(props = {}) {
    const {
      gl
    } = this;

    this._buildResourceTransforms(gl, props);

    props = this._updateModelProps(props);
    this.model = new model/* default */.Z(gl, Object.assign({}, props, {
      fs: props.fs || getPassthroughFS({
        version: getShaderVersion(props.vs)
      }),
      id: props.id || 'transform-model',
      drawMode: props.drawMode || 0,
      vertexCount: props.elementCount
    }));
    this.bufferTransform && this.bufferTransform.setupResources({
      model: this.model
    });
  }

  _updateModelProps(props) {
    let updatedProps = Object.assign({}, props);
    const resourceTransforms = [this.bufferTransform, this.textureTransform].filter(Boolean);

    for (const resourceTransform of resourceTransforms) {
      updatedProps = resourceTransform.updateModelProps(updatedProps);
    }

    return updatedProps;
  }

  _buildResourceTransforms(gl, props) {
    if (canCreateBufferTransform(props)) {
      this.bufferTransform = new BufferTransform(gl, props);
    }

    if (canCreateTextureTransform(props)) {
      this.textureTransform = new TextureTransform(gl, props);
    }

    (0,utils_assert/* default */.Z)(this.bufferTransform || this.textureTransform, 'must provide source/feedback buffers or source/target textures');
  }

  _updateDrawOptions(opts) {
    let updatedOpts = Object.assign({}, opts);
    const resourceTransforms = [this.bufferTransform, this.textureTransform].filter(Boolean);

    for (const resourceTransform of resourceTransforms) {
      updatedOpts = Object.assign(updatedOpts, resourceTransform.getDrawOptions(updatedOpts));
    }

    return updatedOpts;
  }

}

function canCreateBufferTransform(props) {
  if (!(0,utils/* isObjectEmpty */.nK)(props.feedbackBuffers) || !(0,utils/* isObjectEmpty */.nK)(props.feedbackMap) || props.varyings && props.varyings.length > 0) {
    return true;
  }

  return false;
}

function canCreateTextureTransform(props) {
  if (!(0,utils/* isObjectEmpty */.nK)(props._sourceTextures) || props._targetTexture || props._targetTextureVarying) {
    return true;
  }

  return false;
}
//# sourceMappingURL=transform.js.map

/***/ }),

/***/ 39450:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "KQ": () => (/* reexport */ assertWebGL2Context),
  "JD": () => (/* reexport */ assertWebGLContext),
  "s9": () => (/* reexport */ createGLContext),
  "JY": () => (/* reexport */ cssToDevicePixels),
  "w": () => (/* reexport */ cssToDeviceRatio),
  "vd": () => (/* reexport */ getWebGL2Context),
  "yW": () => (/* reexport */ instrumentGLContext),
  "UF": () => (/* reexport */ isWebGL),
  "D0": () => (/* reexport */ isWebGL2),
  "cM": () => (/* reexport */ log_log),
  "kL": () => (/* reexport */ resetParameters),
  "aQ": () => (/* reexport */ resizeGLContext),
  "dR": () => (/* reexport */ setParameters),
  "s8": () => (/* reexport */ withParameters)
});

// UNUSED EXPORTS: getContextDebugInfo, getParameters, polyfillContext, popContextState, pushContextState, trackContextState

// EXTERNAL MODULE: ./node_modules/probe.gl/dist/esm/lib/log.js + 7 modules
var log = __webpack_require__(44708);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/utils/log.js

const log_log = new log/* default */.Z({
  id: 'luma.gl'
});
//# sourceMappingURL=log.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/utils/assert.js
function assert(condition, message) {
  if (!condition) {
    throw new Error(message || 'luma.gl: assertion failed.');
  }
}
//# sourceMappingURL=assert.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/utils/webgl-checks.js

const ERR_CONTEXT = 'Invalid WebGLRenderingContext';
const ERR_WEBGL = (/* unused pure expression or super */ null && (ERR_CONTEXT));
const ERR_WEBGL2 = 'Requires WebGL2';
function isWebGL(gl) {
  if (typeof WebGLRenderingContext !== 'undefined' && gl instanceof WebGLRenderingContext) {
    return true;
  }

  if (typeof WebGL2RenderingContext !== 'undefined' && gl instanceof WebGL2RenderingContext) {
    return true;
  }

  return Boolean(gl && Number.isFinite(gl._version));
}
function isWebGL2(gl) {
  if (typeof WebGL2RenderingContext !== 'undefined' && gl instanceof WebGL2RenderingContext) {
    return true;
  }

  return Boolean(gl && gl._version === 2);
}
function getWebGL2Context(gl) {
  return isWebGL2(gl) ? gl : null;
}
function assertWebGLContext(gl) {
  assert(isWebGL(gl), ERR_CONTEXT);
  return gl;
}
function assertWebGL2Context(gl) {
  assert(isWebGL2(gl), ERR_WEBGL2);
  return gl;
}
//# sourceMappingURL=webgl-checks.js.map
// EXTERNAL MODULE: ./node_modules/probe.gl/dist/es5/env/index.js
var env = __webpack_require__(89718);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/polyfill/polyfill-vertex-array-object.js

const glErrorShadow = {};

function error(msg) {
  if (env/* global.console */.CO.console && env/* global.console.error */.CO.console.error) {
    env/* global.console.error */.CO.console.error(msg);
  }
}

function polyfill_vertex_array_object_log(msg) {
  if (env/* global.console */.CO.console && env/* global.console.log */.CO.console.log) {
    env/* global.console.log */.CO.console.log(msg);
  }
}

function synthesizeGLError(err, opt_msg) {
  glErrorShadow[err] = true;

  if (opt_msg !== undefined) {
    error(opt_msg);
  }
}

function wrapGLError(gl) {
  const f = gl.getError;

  gl.getError = function getError() {
    let err;

    do {
      err = f.apply(gl);

      if (err !== 0) {
        glErrorShadow[err] = true;
      }
    } while (err !== 0);

    for (err in glErrorShadow) {
      if (glErrorShadow[err]) {
        delete glErrorShadow[err];
        return parseInt(err, 10);
      }
    }

    return 0;
  };
}

const WebGLVertexArrayObjectOES = function WebGLVertexArrayObjectOES(ext) {
  const gl = ext.gl;
  this.ext = ext;
  this.isAlive = true;
  this.hasBeenBound = false;
  this.elementArrayBuffer = null;
  this.attribs = new Array(ext.maxVertexAttribs);

  for (let n = 0; n < this.attribs.length; n++) {
    const attrib = new WebGLVertexArrayObjectOES.VertexAttrib(gl);
    this.attribs[n] = attrib;
  }

  this.maxAttrib = 0;
};

WebGLVertexArrayObjectOES.VertexAttrib = function VertexAttrib(gl) {
  this.enabled = false;
  this.buffer = null;
  this.size = 4;
  this.type = 5126;
  this.normalized = false;
  this.stride = 16;
  this.offset = 0;
  this.cached = '';
  this.recache();
};

WebGLVertexArrayObjectOES.VertexAttrib.prototype.recache = function recache() {
  this.cached = [this.size, this.type, this.normalized, this.stride, this.offset].join(':');
};

const OESVertexArrayObject = function OESVertexArrayObject(gl) {
  const self = this;
  this.gl = gl;
  wrapGLError(gl);
  const original = this.original = {
    getParameter: gl.getParameter,
    enableVertexAttribArray: gl.enableVertexAttribArray,
    disableVertexAttribArray: gl.disableVertexAttribArray,
    bindBuffer: gl.bindBuffer,
    getVertexAttrib: gl.getVertexAttrib,
    vertexAttribPointer: gl.vertexAttribPointer
  };

  gl.getParameter = function getParameter(pname) {
    if (pname === self.VERTEX_ARRAY_BINDING_OES) {
      if (self.currentVertexArrayObject === self.defaultVertexArrayObject) {
        return null;
      }

      return self.currentVertexArrayObject;
    }

    return original.getParameter.apply(this, arguments);
  };

  gl.enableVertexAttribArray = function enableVertexAttribArray(index) {
    const vao = self.currentVertexArrayObject;
    vao.maxAttrib = Math.max(vao.maxAttrib, index);
    const attrib = vao.attribs[index];
    attrib.enabled = true;
    return original.enableVertexAttribArray.apply(this, arguments);
  };

  gl.disableVertexAttribArray = function disableVertexAttribArray(index) {
    const vao = self.currentVertexArrayObject;
    vao.maxAttrib = Math.max(vao.maxAttrib, index);
    const attrib = vao.attribs[index];
    attrib.enabled = false;
    return original.disableVertexAttribArray.apply(this, arguments);
  };

  gl.bindBuffer = function bindBuffer(target, buffer) {
    switch (target) {
      case 34962:
        self.currentArrayBuffer = buffer;
        break;

      case 34963:
        self.currentVertexArrayObject.elementArrayBuffer = buffer;
        break;

      default:
    }

    return original.bindBuffer.apply(this, arguments);
  };

  gl.getVertexAttrib = function getVertexAttrib(index, pname) {
    const vao = self.currentVertexArrayObject;
    const attrib = vao.attribs[index];

    switch (pname) {
      case 34975:
        return attrib.buffer;

      case 34338:
        return attrib.enabled;

      case 34339:
        return attrib.size;

      case 34340:
        return attrib.stride;

      case 34341:
        return attrib.type;

      case 34922:
        return attrib.normalized;

      default:
        return original.getVertexAttrib.apply(this, arguments);
    }
  };

  gl.vertexAttribPointer = function vertexAttribPointer(indx, size, type, normalized, stride, offset) {
    const vao = self.currentVertexArrayObject;
    vao.maxAttrib = Math.max(vao.maxAttrib, indx);
    const attrib = vao.attribs[indx];
    attrib.buffer = self.currentArrayBuffer;
    attrib.size = size;
    attrib.type = type;
    attrib.normalized = normalized;
    attrib.stride = stride;
    attrib.offset = offset;
    attrib.recache();
    return original.vertexAttribPointer.apply(this, arguments);
  };

  if (gl.instrumentExtension) {
    gl.instrumentExtension(this, 'OES_vertex_array_object');
  }

  if (gl.canvas) {
    gl.canvas.addEventListener('webglcontextrestored', () => {
      polyfill_vertex_array_object_log('OESVertexArrayObject emulation library context restored');
      self.reset_();
    }, true);
  }

  this.reset_();
};

OESVertexArrayObject.prototype.VERTEX_ARRAY_BINDING_OES = 0x85b5;

OESVertexArrayObject.prototype.reset_ = function reset_() {
  const contextWasLost = this.vertexArrayObjects !== undefined;

  if (contextWasLost) {
    for (let ii = 0; ii < this.vertexArrayObjects.length; ++ii) {
      this.vertexArrayObjects.isAlive = false;
    }
  }

  const gl = this.gl;
  this.maxVertexAttribs = gl.getParameter(34921);
  this.defaultVertexArrayObject = new WebGLVertexArrayObjectOES(this);
  this.currentVertexArrayObject = null;
  this.currentArrayBuffer = null;
  this.vertexArrayObjects = [this.defaultVertexArrayObject];
  this.bindVertexArrayOES(null);
};

OESVertexArrayObject.prototype.createVertexArrayOES = function createVertexArrayOES() {
  const arrayObject = new WebGLVertexArrayObjectOES(this);
  this.vertexArrayObjects.push(arrayObject);
  return arrayObject;
};

OESVertexArrayObject.prototype.deleteVertexArrayOES = function deleteVertexArrayOES(arrayObject) {
  arrayObject.isAlive = false;
  this.vertexArrayObjects.splice(this.vertexArrayObjects.indexOf(arrayObject), 1);

  if (this.currentVertexArrayObject === arrayObject) {
    this.bindVertexArrayOES(null);
  }
};

OESVertexArrayObject.prototype.isVertexArrayOES = function isVertexArrayOES(arrayObject) {
  if (arrayObject && arrayObject instanceof WebGLVertexArrayObjectOES) {
    if (arrayObject.hasBeenBound && arrayObject.ext === this) {
      return true;
    }
  }

  return false;
};

OESVertexArrayObject.prototype.bindVertexArrayOES = function bindVertexArrayOES(arrayObject) {
  const gl = this.gl;

  if (arrayObject && !arrayObject.isAlive) {
    synthesizeGLError(1282, 'bindVertexArrayOES: attempt to bind deleted arrayObject');
    return;
  }

  const original = this.original;
  const oldVAO = this.currentVertexArrayObject;
  this.currentVertexArrayObject = arrayObject || this.defaultVertexArrayObject;
  this.currentVertexArrayObject.hasBeenBound = true;
  const newVAO = this.currentVertexArrayObject;

  if (oldVAO === newVAO) {
    return;
  }

  if (!oldVAO || newVAO.elementArrayBuffer !== oldVAO.elementArrayBuffer) {
    original.bindBuffer.call(gl, 34963, newVAO.elementArrayBuffer);
  }

  let currentBinding = this.currentArrayBuffer;
  const maxAttrib = Math.max(oldVAO ? oldVAO.maxAttrib : 0, newVAO.maxAttrib);

  for (let n = 0; n <= maxAttrib; n++) {
    const attrib = newVAO.attribs[n];
    const oldAttrib = oldVAO ? oldVAO.attribs[n] : null;

    if (!oldVAO || attrib.enabled !== oldAttrib.enabled) {
      if (attrib.enabled) {
        original.enableVertexAttribArray.call(gl, n);
      } else {
        original.disableVertexAttribArray.call(gl, n);
      }
    }

    if (attrib.enabled) {
      let bufferChanged = false;

      if (!oldVAO || attrib.buffer !== oldAttrib.buffer) {
        if (currentBinding !== attrib.buffer) {
          original.bindBuffer.call(gl, 34962, attrib.buffer);
          currentBinding = attrib.buffer;
        }

        bufferChanged = true;
      }

      if (bufferChanged || attrib.cached !== oldAttrib.cached) {
        original.vertexAttribPointer.call(gl, n, attrib.size, attrib.type, attrib.normalized, attrib.stride, attrib.offset);
      }
    }
  }

  if (this.currentArrayBuffer !== currentBinding) {
    original.bindBuffer.call(gl, 34962, this.currentArrayBuffer);
  }
};

function polyfillVertexArrayObject(gl) {
  if (typeof gl.createVertexArray === 'function') {
    return;
  }

  const original_getSupportedExtensions = gl.getSupportedExtensions;

  gl.getSupportedExtensions = function getSupportedExtensions() {
    const list = original_getSupportedExtensions.call(this) || [];

    if (list.indexOf('OES_vertex_array_object') < 0) {
      list.push('OES_vertex_array_object');
    }

    return list;
  };

  const original_getExtension = gl.getExtension;

  gl.getExtension = function getExtension(name) {
    const ext = original_getExtension.call(this, name);

    if (ext) {
      return ext;
    }

    if (name !== 'OES_vertex_array_object') {
      return null;
    }

    if (!gl.__OESVertexArrayObject) {
      this.__OESVertexArrayObject = new OESVertexArrayObject(this);
    }

    return this.__OESVertexArrayObject;
  };
}
//# sourceMappingURL=polyfill-vertex-array-object.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/polyfill/get-parameter-polyfill.js

const OES_element_index = 'OES_element_index';
const WEBGL_draw_buffers = 'WEBGL_draw_buffers';
const EXT_disjoint_timer_query = 'EXT_disjoint_timer_query';
const EXT_disjoint_timer_query_webgl2 = 'EXT_disjoint_timer_query_webgl2';
const EXT_texture_filter_anisotropic = 'EXT_texture_filter_anisotropic';
const WEBGL_debug_renderer_info = 'WEBGL_debug_renderer_info';
const GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 0x8b8b;
const GL_DONT_CARE = 0x1100;
const GL_GPU_DISJOINT_EXT = 0x8fbb;
const GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = 0x84ff;
const GL_UNMASKED_VENDOR_WEBGL = 0x9245;
const GL_UNMASKED_RENDERER_WEBGL = 0x9246;

const getWebGL2ValueOrZero = gl => !isWebGL2(gl) ? 0 : undefined;

const WEBGL_PARAMETERS = {
  [3074]: gl => !isWebGL2(gl) ? 36064 : undefined,
  [GL_FRAGMENT_SHADER_DERIVATIVE_HINT]: gl => !isWebGL2(gl) ? GL_DONT_CARE : undefined,
  [35977]: getWebGL2ValueOrZero,
  [32937]: getWebGL2ValueOrZero,
  [GL_GPU_DISJOINT_EXT]: (gl, getParameter) => {
    const ext = isWebGL2(gl) ? gl.getExtension(EXT_disjoint_timer_query_webgl2) : gl.getExtension(EXT_disjoint_timer_query);
    return ext && ext.GPU_DISJOINT_EXT ? getParameter(ext.GPU_DISJOINT_EXT) : 0;
  },
  [GL_UNMASKED_VENDOR_WEBGL]: (gl, getParameter) => {
    const ext = gl.getExtension(WEBGL_debug_renderer_info);
    return getParameter(ext && ext.UNMASKED_VENDOR_WEBGL || 7936);
  },
  [GL_UNMASKED_RENDERER_WEBGL]: (gl, getParameter) => {
    const ext = gl.getExtension(WEBGL_debug_renderer_info);
    return getParameter(ext && ext.UNMASKED_RENDERER_WEBGL || 7937);
  },
  [GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT]: (gl, getParameter) => {
    const ext = gl.luma.extensions[EXT_texture_filter_anisotropic];
    return ext ? getParameter(ext.MAX_TEXTURE_MAX_ANISOTROPY_EXT) : 1.0;
  },
  [32883]: getWebGL2ValueOrZero,
  [35071]: getWebGL2ValueOrZero,
  [37447]: getWebGL2ValueOrZero,
  [36063]: (gl, getParameter) => {
    if (!isWebGL2(gl)) {
      const ext = gl.getExtension(WEBGL_draw_buffers);
      return ext ? getParameter(ext.MAX_COLOR_ATTACHMENTS_WEBGL) : 0;
    }

    return undefined;
  },
  [35379]: getWebGL2ValueOrZero,
  [35374]: getWebGL2ValueOrZero,
  [35377]: getWebGL2ValueOrZero,
  [34852]: gl => {
    if (!isWebGL2(gl)) {
      const ext = gl.getExtension(WEBGL_draw_buffers);
      return ext ? ext.MAX_DRAW_BUFFERS_WEBGL : 0;
    }

    return undefined;
  },
  [36203]: gl => gl.getExtension(OES_element_index) ? 2147483647 : 65535,
  [33001]: gl => gl.getExtension(OES_element_index) ? 16777216 : 65535,
  [33000]: gl => 16777216,
  [37157]: getWebGL2ValueOrZero,
  [35373]: getWebGL2ValueOrZero,
  [35657]: getWebGL2ValueOrZero,
  [36183]: getWebGL2ValueOrZero,
  [37137]: getWebGL2ValueOrZero,
  [34045]: getWebGL2ValueOrZero,
  [35978]: getWebGL2ValueOrZero,
  [35979]: getWebGL2ValueOrZero,
  [35968]: getWebGL2ValueOrZero,
  [35376]: getWebGL2ValueOrZero,
  [35375]: getWebGL2ValueOrZero,
  [35659]: getWebGL2ValueOrZero,
  [37154]: getWebGL2ValueOrZero,
  [35371]: getWebGL2ValueOrZero,
  [35658]: getWebGL2ValueOrZero,
  [35076]: getWebGL2ValueOrZero,
  [35077]: getWebGL2ValueOrZero,
  [35380]: getWebGL2ValueOrZero
};
function getParameterPolyfill(gl, originalGetParameter, pname) {
  const limit = WEBGL_PARAMETERS[pname];
  const value = typeof limit === 'function' ? limit(gl, originalGetParameter, pname) : limit;
  const result = value !== undefined ? value : originalGetParameter(pname);
  return result;
}
//# sourceMappingURL=get-parameter-polyfill.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/polyfill/polyfill-table.js



const OES_vertex_array_object = 'OES_vertex_array_object';
const ANGLE_instanced_arrays = 'ANGLE_instanced_arrays';
const polyfill_table_WEBGL_draw_buffers = 'WEBGL_draw_buffers';
const polyfill_table_EXT_disjoint_timer_query = 'EXT_disjoint_timer_query';
const polyfill_table_EXT_texture_filter_anisotropic = 'EXT_texture_filter_anisotropic';
const ERR_VAO_NOT_SUPPORTED = 'VertexArray requires WebGL2 or OES_vertex_array_object extension';

function getExtensionData(gl, extension) {
  return {
    webgl2: isWebGL2(gl),
    ext: gl.getExtension(extension)
  };
}

const WEBGL2_CONTEXT_POLYFILLS = {
  [OES_vertex_array_object]: {
    meta: {
      suffix: 'OES'
    },
    createVertexArray: () => {
      assert(false, ERR_VAO_NOT_SUPPORTED);
    },
    deleteVertexArray: () => {},
    bindVertexArray: () => {},
    isVertexArray: () => false
  },
  [ANGLE_instanced_arrays]: {
    meta: {
      suffix: 'ANGLE'
    },

    vertexAttribDivisor(location, divisor) {
      assert(divisor === 0, 'WebGL instanced rendering not supported');
    },

    drawElementsInstanced: () => {},
    drawArraysInstanced: () => {}
  },
  [polyfill_table_WEBGL_draw_buffers]: {
    meta: {
      suffix: 'WEBGL'
    },
    drawBuffers: () => {
      assert(false);
    }
  },
  [polyfill_table_EXT_disjoint_timer_query]: {
    meta: {
      suffix: 'EXT'
    },
    createQuery: () => {
      assert(false);
    },
    deleteQuery: () => {
      assert(false);
    },
    beginQuery: () => {
      assert(false);
    },
    endQuery: () => {},

    getQuery(handle, pname) {
      return this.getQueryObject(handle, pname);
    },

    getQueryParameter(handle, pname) {
      return this.getQueryObject(handle, pname);
    },

    getQueryObject: () => {}
  }
};
const WEBGL2_CONTEXT_OVERRIDES = {
  readBuffer: (gl, originalFunc, attachment) => {
    if (isWebGL2(gl)) {
      originalFunc(attachment);
    } else {}
  },
  getVertexAttrib: (gl, originalFunc, location, pname) => {
    const {
      webgl2,
      ext
    } = getExtensionData(gl, ANGLE_instanced_arrays);
    let result;

    switch (pname) {
      case 35069:
        result = !webgl2 ? false : undefined;
        break;

      case 35070:
        result = !webgl2 && !ext ? 0 : undefined;
        break;

      default:
    }

    return result !== undefined ? result : originalFunc(location, pname);
  },
  getProgramParameter: (gl, originalFunc, program, pname) => {
    if (!isWebGL2(gl)) {
      switch (pname) {
        case 35967:
          return 35981;

        case 35971:
          return 0;

        case 35382:
          return 0;

        default:
      }
    }

    return originalFunc(program, pname);
  },
  getInternalformatParameter: (gl, originalFunc, target, format, pname) => {
    if (!isWebGL2(gl)) {
      switch (pname) {
        case 32937:
          return new Int32Array([0]);

        default:
      }
    }

    return gl.getInternalformatParameter(target, format, pname);
  },

  getTexParameter(gl, originalFunc, target, pname) {
    switch (pname) {
      case 34046:
        const {
          extensions
        } = gl.luma;
        const ext = extensions[polyfill_table_EXT_texture_filter_anisotropic];
        pname = ext && ext.TEXTURE_MAX_ANISOTROPY_EXT || 34046;
        break;

      default:
    }

    return originalFunc(target, pname);
  },

  getParameter: getParameterPolyfill,

  hint(gl, originalFunc, pname, value) {
    return originalFunc(pname, value);
  }

};
//# sourceMappingURL=polyfill-table.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/polyfill/polyfill-context.js



function polyfillContext(gl) {
  gl.luma = gl.luma || {};
  const {
    luma
  } = gl;

  if (!luma.polyfilled) {
    polyfillVertexArrayObject(gl);
    initializeExtensions(gl);
    installPolyfills(gl, WEBGL2_CONTEXT_POLYFILLS);
    installOverrides(gl, {
      target: luma,
      target2: gl
    });
    luma.polyfilled = true;
  }

  return gl;
}
const global_ = typeof __webpack_require__.g !== 'undefined' ? __webpack_require__.g : window;
global_.polyfillContext = polyfillContext;

function initializeExtensions(gl) {
  gl.luma.extensions = {};
  const EXTENSIONS = gl.getSupportedExtensions() || [];

  for (const extension of EXTENSIONS) {
    gl.luma[extension] = gl.getExtension(extension);
  }
}

function installOverrides(gl, {
  target,
  target2
}) {
  Object.keys(WEBGL2_CONTEXT_OVERRIDES).forEach(key => {
    if (typeof WEBGL2_CONTEXT_OVERRIDES[key] === 'function') {
      const originalFunc = gl[key] ? gl[key].bind(gl) : () => {};
      const polyfill = WEBGL2_CONTEXT_OVERRIDES[key].bind(null, gl, originalFunc);
      target[key] = polyfill;
      target2[key] = polyfill;
    }
  });
}

function installPolyfills(gl, polyfills) {
  for (const extension of Object.getOwnPropertyNames(polyfills)) {
    if (extension !== 'overrides') {
      polyfillExtension(gl, {
        extension,
        target: gl.luma,
        target2: gl
      });
    }
  }
}

function polyfillExtension(gl, {
  extension,
  target,
  target2
}) {
  const defaults = WEBGL2_CONTEXT_POLYFILLS[extension];
  assert(defaults);
  const {
    meta = {}
  } = defaults;
  const {
    suffix = ''
  } = meta;
  const ext = gl.getExtension(extension);

  for (const key of Object.keys(defaults)) {
    const extKey = "".concat(key).concat(suffix);
    let polyfill = null;

    if (key === 'meta') {} else if (typeof gl[key] === 'function') {} else if (ext && typeof ext[extKey] === 'function') {
      polyfill = (...args) => ext[extKey](...args);
    } else if (typeof defaults[key] === 'function') {
      polyfill = defaults[key].bind(target);
    }

    if (polyfill) {
      target[key] = polyfill;
      target2[key] = polyfill;
    }
  }
}
//# sourceMappingURL=polyfill-context.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/state-tracker/webgl-parameter-tables.js

const GL_PARAMETER_DEFAULTS = {
  [3042]: false,
  [32773]: new Float32Array([0, 0, 0, 0]),
  [32777]: 32774,
  [34877]: 32774,
  [32969]: 1,
  [32968]: 0,
  [32971]: 1,
  [32970]: 0,
  [3106]: new Float32Array([0, 0, 0, 0]),
  [3107]: [true, true, true, true],
  [2884]: false,
  [2885]: 1029,
  [2929]: false,
  [2931]: 1,
  [2932]: 513,
  [2928]: new Float32Array([0, 1]),
  [2930]: true,
  [3024]: true,
  [36006]: null,
  [2886]: 2305,
  [33170]: 4352,
  [2849]: 1,
  [32823]: false,
  [32824]: 0,
  [10752]: 0,
  [32938]: 1.0,
  [32939]: false,
  [3089]: false,
  [3088]: new Int32Array([0, 0, 1024, 1024]),
  [2960]: false,
  [2961]: 0,
  [2968]: 0xffffffff,
  [36005]: 0xffffffff,
  [2962]: 519,
  [2967]: 0,
  [2963]: 0xffffffff,
  [34816]: 519,
  [36003]: 0,
  [36004]: 0xffffffff,
  [2964]: 7680,
  [2965]: 7680,
  [2966]: 7680,
  [34817]: 7680,
  [34818]: 7680,
  [34819]: 7680,
  [2978]: [0, 0, 1024, 1024],
  [3333]: 4,
  [3317]: 4,
  [37440]: false,
  [37441]: false,
  [37443]: 37444,
  [35723]: 4352,
  [36010]: null,
  [35977]: false,
  [3330]: 0,
  [3332]: 0,
  [3331]: 0,
  [3314]: 0,
  [32878]: 0,
  [3316]: 0,
  [3315]: 0,
  [32877]: 0
};

const enable = (gl, value, key) => value ? gl.enable(key) : gl.disable(key);

const hint = (gl, value, key) => gl.hint(key, value);

const pixelStorei = (gl, value, key) => gl.pixelStorei(key, value);

const drawFramebuffer = (gl, value) => {
  const target = isWebGL2(gl) ? 36009 : 36160;
  return gl.bindFramebuffer(target, value);
};

const readFramebuffer = (gl, value) => {
  return gl.bindFramebuffer(36008, value);
};

function isArray(array) {
  return Array.isArray(array) || ArrayBuffer.isView(array);
}

const GL_PARAMETER_SETTERS = {
  [3042]: enable,
  [32773]: (gl, value) => gl.blendColor(...value),
  [32777]: 'blendEquation',
  [34877]: 'blendEquation',
  [32969]: 'blendFunc',
  [32968]: 'blendFunc',
  [32971]: 'blendFunc',
  [32970]: 'blendFunc',
  [3106]: (gl, value) => gl.clearColor(...value),
  [3107]: (gl, value) => gl.colorMask(...value),
  [2884]: enable,
  [2885]: (gl, value) => gl.cullFace(value),
  [2929]: enable,
  [2931]: (gl, value) => gl.clearDepth(value),
  [2932]: (gl, value) => gl.depthFunc(value),
  [2928]: (gl, value) => gl.depthRange(...value),
  [2930]: (gl, value) => gl.depthMask(value),
  [3024]: enable,
  [35723]: hint,
  [36006]: drawFramebuffer,
  [2886]: (gl, value) => gl.frontFace(value),
  [33170]: hint,
  [2849]: (gl, value) => gl.lineWidth(value),
  [32823]: enable,
  [32824]: 'polygonOffset',
  [10752]: 'polygonOffset',
  [35977]: enable,
  [32938]: 'sampleCoverage',
  [32939]: 'sampleCoverage',
  [3089]: enable,
  [3088]: (gl, value) => gl.scissor(...value),
  [2960]: enable,
  [2961]: (gl, value) => gl.clearStencil(value),
  [2968]: (gl, value) => gl.stencilMaskSeparate(1028, value),
  [36005]: (gl, value) => gl.stencilMaskSeparate(1029, value),
  [2962]: 'stencilFuncFront',
  [2967]: 'stencilFuncFront',
  [2963]: 'stencilFuncFront',
  [34816]: 'stencilFuncBack',
  [36003]: 'stencilFuncBack',
  [36004]: 'stencilFuncBack',
  [2964]: 'stencilOpFront',
  [2965]: 'stencilOpFront',
  [2966]: 'stencilOpFront',
  [34817]: 'stencilOpBack',
  [34818]: 'stencilOpBack',
  [34819]: 'stencilOpBack',
  [2978]: (gl, value) => gl.viewport(...value),
  [3333]: pixelStorei,
  [3317]: pixelStorei,
  [37440]: pixelStorei,
  [37441]: pixelStorei,
  [37443]: pixelStorei,
  [3330]: pixelStorei,
  [3332]: pixelStorei,
  [3331]: pixelStorei,
  [36010]: readFramebuffer,
  [3314]: pixelStorei,
  [32878]: pixelStorei,
  [3316]: pixelStorei,
  [3315]: pixelStorei,
  [32877]: pixelStorei,
  framebuffer: (gl, framebuffer) => {
    const handle = framebuffer && 'handle' in framebuffer ? framebuffer.handle : framebuffer;
    return gl.bindFramebuffer(36160, handle);
  },
  blend: (gl, value) => value ? gl.enable(3042) : gl.disable(3042),
  blendColor: (gl, value) => gl.blendColor(...value),
  blendEquation: (gl, args) => {
    args = isArray(args) ? args : [args, args];
    gl.blendEquationSeparate(...args);
  },
  blendFunc: (gl, args) => {
    args = isArray(args) && args.length === 2 ? [...args, ...args] : args;
    gl.blendFuncSeparate(...args);
  },
  clearColor: (gl, value) => gl.clearColor(...value),
  clearDepth: (gl, value) => gl.clearDepth(value),
  clearStencil: (gl, value) => gl.clearStencil(value),
  colorMask: (gl, value) => gl.colorMask(...value),
  cull: (gl, value) => value ? gl.enable(2884) : gl.disable(2884),
  cullFace: (gl, value) => gl.cullFace(value),
  depthTest: (gl, value) => value ? gl.enable(2929) : gl.disable(2929),
  depthFunc: (gl, value) => gl.depthFunc(value),
  depthMask: (gl, value) => gl.depthMask(value),
  depthRange: (gl, value) => gl.depthRange(...value),
  dither: (gl, value) => value ? gl.enable(3024) : gl.disable(3024),
  derivativeHint: (gl, value) => {
    gl.hint(35723, value);
  },
  frontFace: (gl, value) => gl.frontFace(value),
  mipmapHint: (gl, value) => gl.hint(33170, value),
  lineWidth: (gl, value) => gl.lineWidth(value),
  polygonOffsetFill: (gl, value) => value ? gl.enable(32823) : gl.disable(32823),
  polygonOffset: (gl, value) => gl.polygonOffset(...value),
  sampleCoverage: (gl, value) => gl.sampleCoverage(...value),
  scissorTest: (gl, value) => value ? gl.enable(3089) : gl.disable(3089),
  scissor: (gl, value) => gl.scissor(...value),
  stencilTest: (gl, value) => value ? gl.enable(2960) : gl.disable(2960),
  stencilMask: (gl, value) => {
    value = isArray(value) ? value : [value, value];
    const [mask, backMask] = value;
    gl.stencilMaskSeparate(1028, mask);
    gl.stencilMaskSeparate(1029, backMask);
  },
  stencilFunc: (gl, args) => {
    args = isArray(args) && args.length === 3 ? [...args, ...args] : args;
    const [func, ref, mask, backFunc, backRef, backMask] = args;
    gl.stencilFuncSeparate(1028, func, ref, mask);
    gl.stencilFuncSeparate(1029, backFunc, backRef, backMask);
  },
  stencilOp: (gl, args) => {
    args = isArray(args) && args.length === 3 ? [...args, ...args] : args;
    const [sfail, dpfail, dppass, backSfail, backDpfail, backDppass] = args;
    gl.stencilOpSeparate(1028, sfail, dpfail, dppass);
    gl.stencilOpSeparate(1029, backSfail, backDpfail, backDppass);
  },
  viewport: (gl, value) => gl.viewport(...value)
};

function getValue(glEnum, values, cache) {
  return values[glEnum] !== undefined ? values[glEnum] : cache[glEnum];
}

const GL_COMPOSITE_PARAMETER_SETTERS = {
  blendEquation: (gl, values, cache) => gl.blendEquationSeparate(getValue(32777, values, cache), getValue(34877, values, cache)),
  blendFunc: (gl, values, cache) => gl.blendFuncSeparate(getValue(32969, values, cache), getValue(32968, values, cache), getValue(32971, values, cache), getValue(32970, values, cache)),
  polygonOffset: (gl, values, cache) => gl.polygonOffset(getValue(32824, values, cache), getValue(10752, values, cache)),
  sampleCoverage: (gl, values, cache) => gl.sampleCoverage(getValue(32938, values, cache), getValue(32939, values, cache)),
  stencilFuncFront: (gl, values, cache) => gl.stencilFuncSeparate(1028, getValue(2962, values, cache), getValue(2967, values, cache), getValue(2963, values, cache)),
  stencilFuncBack: (gl, values, cache) => gl.stencilFuncSeparate(1029, getValue(34816, values, cache), getValue(36003, values, cache), getValue(36004, values, cache)),
  stencilOpFront: (gl, values, cache) => gl.stencilOpSeparate(1028, getValue(2964, values, cache), getValue(2965, values, cache), getValue(2966, values, cache)),
  stencilOpBack: (gl, values, cache) => gl.stencilOpSeparate(1029, getValue(34817, values, cache), getValue(34818, values, cache), getValue(34819, values, cache))
};
const GL_HOOKED_SETTERS = {
  enable: (update, capability) => update({
    [capability]: true
  }),
  disable: (update, capability) => update({
    [capability]: false
  }),
  pixelStorei: (update, pname, value) => update({
    [pname]: value
  }),
  hint: (update, pname, hint) => update({
    [pname]: hint
  }),
  bindFramebuffer: (update, target, framebuffer) => {
    switch (target) {
      case 36160:
        return update({
          [36006]: framebuffer,
          [36010]: framebuffer
        });

      case 36009:
        return update({
          [36006]: framebuffer
        });

      case 36008:
        return update({
          [36010]: framebuffer
        });

      default:
        return null;
    }
  },
  blendColor: (update, r, g, b, a) => update({
    [32773]: new Float32Array([r, g, b, a])
  }),
  blendEquation: (update, mode) => update({
    [32777]: mode,
    [34877]: mode
  }),
  blendEquationSeparate: (update, modeRGB, modeAlpha) => update({
    [32777]: modeRGB,
    [34877]: modeAlpha
  }),
  blendFunc: (update, src, dst) => update({
    [32969]: src,
    [32968]: dst,
    [32971]: src,
    [32970]: dst
  }),
  blendFuncSeparate: (update, srcRGB, dstRGB, srcAlpha, dstAlpha) => update({
    [32969]: srcRGB,
    [32968]: dstRGB,
    [32971]: srcAlpha,
    [32970]: dstAlpha
  }),
  clearColor: (update, r, g, b, a) => update({
    [3106]: new Float32Array([r, g, b, a])
  }),
  clearDepth: (update, depth) => update({
    [2931]: depth
  }),
  clearStencil: (update, s) => update({
    [2961]: s
  }),
  colorMask: (update, r, g, b, a) => update({
    [3107]: [r, g, b, a]
  }),
  cullFace: (update, mode) => update({
    [2885]: mode
  }),
  depthFunc: (update, func) => update({
    [2932]: func
  }),
  depthRange: (update, zNear, zFar) => update({
    [2928]: new Float32Array([zNear, zFar])
  }),
  depthMask: (update, mask) => update({
    [2930]: mask
  }),
  frontFace: (update, face) => update({
    [2886]: face
  }),
  lineWidth: (update, width) => update({
    [2849]: width
  }),
  polygonOffset: (update, factor, units) => update({
    [32824]: factor,
    [10752]: units
  }),
  sampleCoverage: (update, value, invert) => update({
    [32938]: value,
    [32939]: invert
  }),
  scissor: (update, x, y, width, height) => update({
    [3088]: new Int32Array([x, y, width, height])
  }),
  stencilMask: (update, mask) => update({
    [2968]: mask,
    [36005]: mask
  }),
  stencilMaskSeparate: (update, face, mask) => update({
    [face === 1028 ? 2968 : 36005]: mask
  }),
  stencilFunc: (update, func, ref, mask) => update({
    [2962]: func,
    [2967]: ref,
    [2963]: mask,
    [34816]: func,
    [36003]: ref,
    [36004]: mask
  }),
  stencilFuncSeparate: (update, face, func, ref, mask) => update({
    [face === 1028 ? 2962 : 34816]: func,
    [face === 1028 ? 2967 : 36003]: ref,
    [face === 1028 ? 2963 : 36004]: mask
  }),
  stencilOp: (update, fail, zfail, zpass) => update({
    [2964]: fail,
    [2965]: zfail,
    [2966]: zpass,
    [34817]: fail,
    [34818]: zfail,
    [34819]: zpass
  }),
  stencilOpSeparate: (update, face, fail, zfail, zpass) => update({
    [face === 1028 ? 2964 : 34817]: fail,
    [face === 1028 ? 2965 : 34818]: zfail,
    [face === 1028 ? 2966 : 34819]: zpass
  }),
  viewport: (update, x, y, width, height) => update({
    [2978]: [x, y, width, height]
  })
};

const isEnabled = (gl, key) => gl.isEnabled(key);

const GL_PARAMETER_GETTERS = {
  [3042]: isEnabled,
  [2884]: isEnabled,
  [2929]: isEnabled,
  [3024]: isEnabled,
  [32823]: isEnabled,
  [32926]: isEnabled,
  [32928]: isEnabled,
  [3089]: isEnabled,
  [2960]: isEnabled,
  [35977]: isEnabled
};
//# sourceMappingURL=webgl-parameter-tables.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/utils/utils.js
function isObjectEmpty(object) {
  for (const key in object) {
    return false;
  }

  return true;
}
function deepArrayEqual(x, y) {
  if (x === y) {
    return true;
  }

  const isArrayX = Array.isArray(x) || ArrayBuffer.isView(x);
  const isArrayY = Array.isArray(y) || ArrayBuffer.isView(y);

  if (isArrayX && isArrayY && x.length === y.length) {
    for (let i = 0; i < x.length; ++i) {
      if (x[i] !== y[i]) {
        return false;
      }
    }

    return true;
  }

  return false;
}
//# sourceMappingURL=utils.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/state-tracker/track-context-state.js





function installGetterOverride(gl, functionName) {
  const originalGetterFunc = gl[functionName].bind(gl);

  gl[functionName] = function get(...params) {
    const pname = params[0];

    if (!(pname in gl.state.cache)) {
      gl.state.cache[pname] = originalGetterFunc(...params);
    }

    return gl.state.enable ? gl.state.cache[pname] : originalGetterFunc(...params);
  };

  Object.defineProperty(gl[functionName], 'name', {
    value: "".concat(functionName, "-from-cache"),
    configurable: false
  });
}

function installSetterSpy(gl, functionName, setter) {
  const originalSetterFunc = gl[functionName].bind(gl);

  gl[functionName] = function set(...params) {
    const {
      valueChanged,
      oldValue
    } = setter(gl.state._updateCache, ...params);

    if (valueChanged) {
      originalSetterFunc(...params);
    }

    return oldValue;
  };

  Object.defineProperty(gl[functionName], 'name', {
    value: "".concat(functionName, "-to-cache"),
    configurable: false
  });
}

function installProgramSpy(gl) {
  const originalUseProgram = gl.useProgram.bind(gl);

  gl.useProgram = function useProgramLuma(handle) {
    if (gl.state.program !== handle) {
      originalUseProgram(handle);
      gl.state.program = handle;
    }
  };
}

class GLState {
  constructor(gl, {
    copyState = false,
    log = () => {}
  } = {}) {
    this.gl = gl;
    this.program = null;
    this.stateStack = [];
    this.enable = true;
    this.cache = copyState ? getParameters(gl) : Object.assign({}, GL_PARAMETER_DEFAULTS);
    this.log = log;
    this._updateCache = this._updateCache.bind(this);
    Object.seal(this);
  }

  push(values = {}) {
    this.stateStack.push({});
  }

  pop() {
    assert(this.stateStack.length > 0);
    const oldValues = this.stateStack[this.stateStack.length - 1];
    setParameters(this.gl, oldValues);
    this.stateStack.pop();
  }

  _updateCache(values) {
    let valueChanged = false;
    let oldValue;
    const oldValues = this.stateStack.length > 0 && this.stateStack[this.stateStack.length - 1];

    for (const key in values) {
      assert(key !== undefined);
      const value = values[key];
      const cached = this.cache[key];

      if (!deepArrayEqual(value, cached)) {
        valueChanged = true;
        oldValue = cached;

        if (oldValues && !(key in oldValues)) {
          oldValues[key] = cached;
        }

        this.cache[key] = value;
      }
    }

    return {
      valueChanged,
      oldValue
    };
  }

}

function trackContextState(gl, options = {}) {
  const {
    enable = true,
    copyState
  } = options;
  assert(copyState !== undefined);

  if (!gl.state) {
    const global_ = typeof __webpack_require__.g !== 'undefined' ? __webpack_require__.g : window;
    const {
      polyfillContext
    } = global_;

    if (polyfillContext) {
      polyfillContext(gl);
    }

    gl.state = new GLState(gl, {
      copyState
    });
    installProgramSpy(gl);

    for (const key in GL_HOOKED_SETTERS) {
      const setter = GL_HOOKED_SETTERS[key];
      installSetterSpy(gl, key, setter);
    }

    installGetterOverride(gl, 'getParameter');
    installGetterOverride(gl, 'isEnabled');
  }

  gl.state.enable = enable;
  return gl;
}
function pushContextState(gl) {
  if (!gl.state) {
    trackContextState(gl, {
      copyState: false
    });
  }

  gl.state.push();
}
function popContextState(gl) {
  assert(gl.state);
  gl.state.pop();
}
//# sourceMappingURL=track-context-state.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/state-tracker/unified-parameter-api.js





function setParameters(gl, values) {
  assert(isWebGL(gl), 'setParameters requires a WebGL context');

  if (isObjectEmpty(values)) {
    return;
  }

  const compositeSetters = {};

  for (const key in values) {
    const glConstant = Number(key);
    const setter = GL_PARAMETER_SETTERS[key];

    if (setter) {
      if (typeof setter === 'string') {
        compositeSetters[setter] = true;
      } else {
        setter(gl, values[key], glConstant);
      }
    }
  }

  const cache = gl.state && gl.state.cache;

  if (cache) {
    for (const key in compositeSetters) {
      const compositeSetter = GL_COMPOSITE_PARAMETER_SETTERS[key];
      compositeSetter(gl, values, cache);
    }
  }
}
function getParameters(gl, parameters) {
  parameters = parameters || GL_PARAMETER_DEFAULTS;

  if (typeof parameters === 'number') {
    const key = parameters;
    const getter = GL_PARAMETER_GETTERS[key];
    return getter ? getter(gl, key) : gl.getParameter(key);
  }

  const parameterKeys = Array.isArray(parameters) ? parameters : Object.keys(parameters);
  const state = {};

  for (const key of parameterKeys) {
    const getter = GL_PARAMETER_GETTERS[key];
    state[key] = getter ? getter(gl, Number(key)) : gl.getParameter(Number(key));
  }

  return state;
}
function resetParameters(gl) {
  setParameters(gl, GL_PARAMETER_DEFAULTS);
}
function withParameters(gl, parameters, func) {
  if (isObjectEmpty(parameters)) {
    return func(gl);
  }

  const {
    nocatch = true
  } = parameters;
  pushContextState(gl);
  setParameters(gl, parameters);
  let value;

  if (nocatch) {
    value = func(gl);
    popContextState(gl);
  } else {
    try {
      value = func(gl);
    } finally {
      popContextState(gl);
    }
  }

  return value;
}
//# sourceMappingURL=unified-parameter-api.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/utils/device-pixels.js
function cssToDeviceRatio(gl) {
  const {
    luma
  } = gl;

  if (gl.canvas && luma) {
    const {
      clientWidth
    } = luma.canvasSizeInfo;
    return clientWidth ? gl.drawingBufferWidth / clientWidth : 1;
  }

  return 1;
}
function cssToDevicePixels(gl, cssPixel, yInvert = true) {
  const ratio = cssToDeviceRatio(gl);
  const width = gl.drawingBufferWidth;
  const height = gl.drawingBufferHeight;
  return scalePixels(cssPixel, ratio, width, height, yInvert);
}
function getDevicePixelRatio(useDevicePixels) {
  const windowRatio = typeof window === 'undefined' ? 1 : window.devicePixelRatio || 1;

  if (Number.isFinite(useDevicePixels)) {
    return useDevicePixels <= 0 ? 1 : useDevicePixels;
  }

  return useDevicePixels ? windowRatio : 1;
}

function scalePixels(pixel, ratio, width, height, yInvert) {
  const x = scaleX(pixel[0], ratio, width);
  let y = scaleY(pixel[1], ratio, height, yInvert);
  let t = scaleX(pixel[0] + 1, ratio, width);
  const xHigh = t === width - 1 ? t : t - 1;
  t = scaleY(pixel[1] + 1, ratio, height, yInvert);
  let yHigh;

  if (yInvert) {
    t = t === 0 ? t : t + 1;
    yHigh = y;
    y = t;
  } else {
    yHigh = t === height - 1 ? t : t - 1;
  }

  return {
    x,
    y,
    width: Math.max(xHigh - x + 1, 1),
    height: Math.max(yHigh - y + 1, 1)
  };
}

function scaleX(x, ratio, width) {
  const r = Math.min(Math.round(x * ratio), width - 1);
  return r;
}

function scaleY(y, ratio, height, yInvert) {
  return yInvert ? Math.max(0, height - 1 - Math.round(y * ratio)) : Math.min(Math.round(y * ratio), height - 1);
}
//# sourceMappingURL=device-pixels.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/context/context.js






const isBrowser = (0,env/* isBrowser */.jU)();
const isPage = isBrowser && typeof document !== 'undefined';
const CONTEXT_DEFAULTS = {
  webgl2: true,
  webgl1: true,
  throwOnError: true,
  manageState: true,
  canvas: null,
  debug: false,
  width: 800,
  height: 600
};
function createGLContext(options = {}) {
  assert(isBrowser, "createGLContext only available in the browser.\nCreate your own headless context or use 'createHeadlessContext' from @luma.gl/test-utils");
  options = Object.assign({}, CONTEXT_DEFAULTS, options);
  const {
    width,
    height
  } = options;

  function onError(message) {
    if (options.throwOnError) {
      throw new Error(message);
    }

    console.error(message);
    return null;
  }

  options.onError = onError;
  let gl;
  const {
    canvas
  } = options;
  const targetCanvas = getCanvas({
    canvas,
    width,
    height,
    onError
  });
  gl = createBrowserContext(targetCanvas, options);

  if (!gl) {
    return null;
  }

  gl = instrumentGLContext(gl, options);
  logInfo(gl);
  return gl;
}
function instrumentGLContext(gl, options = {}) {
  if (!gl || gl._instrumented) {
    return gl;
  }

  gl._version = gl._version || getVersion(gl);
  gl.luma = gl.luma || {};
  gl.luma.canvasSizeInfo = gl.luma.canvasSizeInfo || {};
  options = Object.assign({}, CONTEXT_DEFAULTS, options);
  const {
    manageState,
    debug
  } = options;

  if (manageState) {
    trackContextState(gl, {
      copyState: false,
      log: (...args) => log_log.log(1, ...args)()
    });
  }

  if (isBrowser && debug) {
    if (!env/* global.makeDebugContext */.CO.makeDebugContext) {
      log_log.warn('WebGL debug mode not activated. import "@luma.gl/debug" to enable.')();
    } else {
      gl = env/* global.makeDebugContext */.CO.makeDebugContext(gl, options);
      log_log.level = Math.max(log_log.level, 1);
    }
  }

  gl._instrumented = true;
  return gl;
}
function getContextDebugInfo(gl) {
  const vendorMasked = gl.getParameter(7936);
  const rendererMasked = gl.getParameter(7937);
  const ext = gl.getExtension('WEBGL_debug_renderer_info');
  const vendorUnmasked = ext && gl.getParameter(ext.UNMASKED_VENDOR_WEBGL || 7936);
  const rendererUnmasked = ext && gl.getParameter(ext.UNMASKED_RENDERER_WEBGL || 7937);
  return {
    vendor: vendorUnmasked || vendorMasked,
    renderer: rendererUnmasked || rendererMasked,
    vendorMasked,
    rendererMasked,
    version: gl.getParameter(7938),
    shadingLanguageVersion: gl.getParameter(35724)
  };
}
function resizeGLContext(gl, options = {}) {
  if (gl.canvas) {
    const devicePixelRatio = getDevicePixelRatio(options.useDevicePixels);
    setDevicePixelRatio(gl, devicePixelRatio, options);
    return;
  }

  const ext = gl.getExtension('STACKGL_resize_drawingbuffer');

  if (ext && "width" in options && "height" in options) {
    ext.resize(options.width, options.height);
  }
}

function createBrowserContext(canvas, options) {
  const {
    onError
  } = options;
  let errorMessage = null;

  const onCreateError = error => errorMessage = error.statusMessage || errorMessage;

  canvas.addEventListener('webglcontextcreationerror', onCreateError, false);
  const {
    webgl1 = true,
    webgl2 = true
  } = options;
  let gl = null;

  if (webgl2) {
    gl = gl || canvas.getContext('webgl2', options);
    gl = gl || canvas.getContext('experimental-webgl2', options);
  }

  if (webgl1) {
    gl = gl || canvas.getContext('webgl', options);
    gl = gl || canvas.getContext('experimental-webgl', options);
  }

  canvas.removeEventListener('webglcontextcreationerror', onCreateError, false);

  if (!gl) {
    return onError("Failed to create ".concat(webgl2 && !webgl1 ? 'WebGL2' : 'WebGL', " context: ").concat(errorMessage || 'Unknown error'));
  }

  if (options.onContextLost) {
    canvas.addEventListener('webglcontextlost', options.onContextLost, false);
  }

  if (options.onContextRestored) {
    canvas.addEventListener('webglcontextrestored', options.onContextRestored, false);
  }

  return gl;
}

function getCanvas({
  canvas,
  width = 800,
  height = 600,
  onError
}) {
  let targetCanvas;

  if (typeof canvas === 'string') {
    const isPageLoaded = isPage && document.readyState === 'complete';

    if (!isPageLoaded) {
      onError("createGLContext called on canvas '".concat(canvas, "' before page was loaded"));
    }

    targetCanvas = document.getElementById(canvas);
  } else if (canvas) {
    targetCanvas = canvas;
  } else {
    targetCanvas = document.createElement('canvas');
    targetCanvas.id = 'lumagl-canvas';
    targetCanvas.style.width = Number.isFinite(width) ? "".concat(width, "px") : '100%';
    targetCanvas.style.height = Number.isFinite(height) ? "".concat(height, "px") : '100%';
    document.body.insertBefore(targetCanvas, document.body.firstChild);
  }

  return targetCanvas;
}

function logInfo(gl) {
  const webGL = isWebGL2(gl) ? 'WebGL2' : 'WebGL1';
  const info = getContextDebugInfo(gl);
  const driver = info ? "(".concat(info.vendor, ",").concat(info.renderer, ")") : '';
  const debug = gl.debug ? ' debug' : '';
  log_log.info(1, "".concat(webGL).concat(debug, " context ").concat(driver))();
}

function getVersion(gl) {
  if (typeof WebGL2RenderingContext !== 'undefined' && gl instanceof WebGL2RenderingContext) {
    return 2;
  }

  return 1;
}

function setDevicePixelRatio(gl, devicePixelRatio, options) {
  let clientWidth = 'width' in options ? options.width : gl.canvas.clientWidth;
  let clientHeight = 'height' in options ? options.height : gl.canvas.clientHeight;

  if (!clientWidth || !clientHeight) {
    log_log.log(1, 'Canvas clientWidth/clientHeight is 0')();
    devicePixelRatio = 1;
    clientWidth = gl.canvas.width || 1;
    clientHeight = gl.canvas.height || 1;
  }

  gl.luma = gl.luma || {};
  gl.luma.canvasSizeInfo = gl.luma.canvasSizeInfo || {};
  const cachedSize = gl.luma.canvasSizeInfo;

  if (cachedSize.clientWidth !== clientWidth || cachedSize.clientHeight !== clientHeight || cachedSize.devicePixelRatio !== devicePixelRatio) {
    let clampedPixelRatio = devicePixelRatio;
    const canvasWidth = Math.floor(clientWidth * clampedPixelRatio);
    const canvasHeight = Math.floor(clientHeight * clampedPixelRatio);
    gl.canvas.width = canvasWidth;
    gl.canvas.height = canvasHeight;

    if (gl.drawingBufferWidth !== canvasWidth || gl.drawingBufferHeight !== canvasHeight) {
      log_log.warn("Device pixel ratio clamped")();
      clampedPixelRatio = Math.min(gl.drawingBufferWidth / clientWidth, gl.drawingBufferHeight / clientHeight);
      gl.canvas.width = Math.floor(clientWidth * clampedPixelRatio);
      gl.canvas.height = Math.floor(clientHeight * clampedPixelRatio);
    }

    Object.assign(gl.luma.canvasSizeInfo, {
      clientWidth,
      clientHeight,
      devicePixelRatio
    });
  }
}
//# sourceMappingURL=context.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/gltools/dist/esm/index.js







//# sourceMappingURL=index.js.map

/***/ }),

/***/ 75682:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "H": () => (/* binding */ VERTEX_SHADER),
/* harmony export */   "Y": () => (/* binding */ FRAGMENT_SHADER)
/* harmony export */ });
const VERTEX_SHADER = 'vs';
const FRAGMENT_SHADER = 'fs';
//# sourceMappingURL=constants.js.map

/***/ }),

/***/ 86713:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "O_": () => (/* binding */ DECLARATION_INJECT_MARKER),
  "Lm": () => (/* binding */ combineInjects),
  "ZP": () => (/* binding */ injectShader)
});

;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/modules/module-injectors.js
const MODULE_INJECTORS_VS = "#ifdef MODULE_LOGDEPTH\n  logdepth_adjustPosition(gl_Position);\n#endif\n";
const MODULE_INJECTORS_FS = "#ifdef MODULE_MATERIAL\n  gl_FragColor = material_filterColor(gl_FragColor);\n#endif\n\n#ifdef MODULE_LIGHTING\n  gl_FragColor = lighting_filterColor(gl_FragColor);\n#endif\n\n#ifdef MODULE_FOG\n  gl_FragColor = fog_filterColor(gl_FragColor);\n#endif\n\n#ifdef MODULE_PICKING\n  gl_FragColor = picking_filterHighlightColor(gl_FragColor);\n  gl_FragColor = picking_filterPickingColor(gl_FragColor);\n#endif\n\n#ifdef MODULE_LOGDEPTH\n  logdepth_setFragDepth();\n#endif\n";
//# sourceMappingURL=module-injectors.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/lib/constants.js
var constants = __webpack_require__(75682);
// EXTERNAL MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/utils/assert.js
var assert = __webpack_require__(29047);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/shadertools/dist/esm/lib/inject-shader.js



const MODULE_INJECTORS = {
  [constants/* VERTEX_SHADER */.H]: MODULE_INJECTORS_VS,
  [constants/* FRAGMENT_SHADER */.Y]: MODULE_INJECTORS_FS
};
const DECLARATION_INJECT_MARKER = '__LUMA_INJECT_DECLARATIONS__';
const REGEX_START_OF_MAIN = /void\s+main\s*\([^)]*\)\s*\{\n?/;
const REGEX_END_OF_MAIN = /}\n?[^{}]*$/;
const fragments = [];
function injectShader(source, type, inject, injectStandardStubs = false) {
  const isVertex = type === constants/* VERTEX_SHADER */.H;

  for (const key in inject) {
    const fragmentData = inject[key];
    fragmentData.sort((a, b) => a.order - b.order);
    fragments.length = fragmentData.length;

    for (let i = 0, len = fragmentData.length; i < len; ++i) {
      fragments[i] = fragmentData[i].injection;
    }

    const fragmentString = "".concat(fragments.join('\n'), "\n");

    switch (key) {
      case 'vs:#decl':
        if (isVertex) {
          source = source.replace(DECLARATION_INJECT_MARKER, fragmentString);
        }

        break;

      case 'vs:#main-start':
        if (isVertex) {
          source = source.replace(REGEX_START_OF_MAIN, match => match + fragmentString);
        }

        break;

      case 'vs:#main-end':
        if (isVertex) {
          source = source.replace(REGEX_END_OF_MAIN, match => fragmentString + match);
        }

        break;

      case 'fs:#decl':
        if (!isVertex) {
          source = source.replace(DECLARATION_INJECT_MARKER, fragmentString);
        }

        break;

      case 'fs:#main-start':
        if (!isVertex) {
          source = source.replace(REGEX_START_OF_MAIN, match => match + fragmentString);
        }

        break;

      case 'fs:#main-end':
        if (!isVertex) {
          source = source.replace(REGEX_END_OF_MAIN, match => fragmentString + match);
        }

        break;

      default:
        source = source.replace(key, match => match + fragmentString);
    }
  }

  source = source.replace(DECLARATION_INJECT_MARKER, '');

  if (injectStandardStubs) {
    source = source.replace(/\}\s*$/, match => match + MODULE_INJECTORS[type]);
  }

  return source;
}
function combineInjects(injects) {
  const result = {};
  (0,assert/* default */.Z)(Array.isArray(injects) && injects.length > 1);
  injects.forEach(inject => {
    for (const key in inject) {
      result[key] = result[key] ? "".concat(result[key], "\n").concat(inject[key]) : inject[key];
    }
  });
  return result;
}
//# sourceMappingURL=inject-shader.js.map

/***/ }),

/***/ 29047:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ assert)
/* harmony export */ });
function assert(condition, message) {
  if (!condition) {
    throw new Error(message || 'shadertools: assertion failed.');
  }
}
//# sourceMappingURL=assert.js.map

/***/ }),

/***/ 14072:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Accessor)
/* harmony export */ });
/* unused harmony export DEFAULT_ACCESSOR_VALUES */
/* harmony import */ var _webgl_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9335);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22525);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(82610);


const DEFAULT_ACCESSOR_VALUES = {
  offset: 0,
  stride: 0,
  type: 5126,
  size: 1,
  divisor: 0,
  normalized: false,
  integer: false
};
const PROP_CHECKS = {
  deprecatedProps: {
    instanced: 'divisor',
    isInstanced: 'divisor'
  }
};
class Accessor {
  static getBytesPerElement(accessor) {
    const ArrayType = (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_0__/* .getTypedArrayFromGLType */ .vN)(accessor.type || 5126);
    return ArrayType.BYTES_PER_ELEMENT;
  }

  static getBytesPerVertex(accessor) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(accessor.size);
    const ArrayType = (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_0__/* .getTypedArrayFromGLType */ .vN)(accessor.type || 5126);
    return ArrayType.BYTES_PER_ELEMENT * accessor.size;
  }

  static resolve(...accessors) {
    return new Accessor(...[DEFAULT_ACCESSOR_VALUES, ...accessors]);
  }

  constructor(...accessors) {
    accessors.forEach(accessor => this._assign(accessor));
    Object.freeze(this);
  }

  toString() {
    return JSON.stringify(this);
  }

  get BYTES_PER_ELEMENT() {
    return Accessor.getBytesPerElement(this);
  }

  get BYTES_PER_VERTEX() {
    return Accessor.getBytesPerVertex(this);
  }

  _assign(props = {}) {
    props = (0,_utils__WEBPACK_IMPORTED_MODULE_2__/* .checkProps */ .k)('Accessor', props, PROP_CHECKS);

    if (props.type !== undefined) {
      this.type = props.type;

      if (props.type === 5124 || props.type === 5125) {
        this.integer = true;
      }
    }

    if (props.size !== undefined) {
      this.size = props.size;
    }

    if (props.offset !== undefined) {
      this.offset = props.offset;
    }

    if (props.stride !== undefined) {
      this.stride = props.stride;
    }

    if (props.normalized !== undefined) {
      this.normalized = props.normalized;
    }

    if (props.integer !== undefined) {
      this.integer = props.integer;
    }

    if (props.divisor !== undefined) {
      this.divisor = props.divisor;
    }

    if (props.buffer !== undefined) {
      this.buffer = props.buffer;
    }

    if (props.index !== undefined) {
      if (typeof props.index === 'boolean') {
        this.index = props.index ? 1 : 0;
      } else {
        this.index = props.index;
      }
    }

    if (props.instanced !== undefined) {
      this.divisor = props.instanced ? 1 : 0;
    }

    if (props.isInstanced !== undefined) {
      this.divisor = props.isInstanced ? 1 : 0;
    }

    return this;
  }

}

//# sourceMappingURL=accessor.js.map

/***/ }),

/***/ 53478:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Buffer)
/* harmony export */ });
/* harmony import */ var _resource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87577);
/* harmony import */ var _accessor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14072);
/* harmony import */ var _webgl_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9335);
/* harmony import */ var _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39450);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(82610);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(22525);





const DEBUG_DATA_LENGTH = 10;
const DEPRECATED_PROPS = {
  offset: 'accessor.offset',
  stride: 'accessor.stride',
  type: 'accessor.type',
  size: 'accessor.size',
  divisor: 'accessor.divisor',
  normalized: 'accessor.normalized',
  integer: 'accessor.integer',
  instanced: 'accessor.divisor',
  isInstanced: 'accessor.divisor'
};
const PROP_CHECKS_INITIALIZE = {
  removedProps: {},
  replacedProps: {
    bytes: 'byteLength'
  },
  deprecatedProps: DEPRECATED_PROPS
};
const PROP_CHECKS_SET_PROPS = {
  removedProps: DEPRECATED_PROPS
};
class Buffer extends _resource__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z {
  constructor(gl, props = {}) {
    super(gl, props);
    this.stubRemovedMethods('Buffer', 'v6.0', ['layout', 'setLayout', 'getIndexedParameter']);
    this.target = props.target || (this.gl.webgl2 ? 36662 : 34962);
    this.initialize(props);
    Object.seal(this);
  }

  getElementCount(accessor = this.accessor) {
    return Math.round(this.byteLength / _accessor__WEBPACK_IMPORTED_MODULE_2__/* ["default"].getBytesPerElement */ .Z.getBytesPerElement(accessor));
  }

  getVertexCount(accessor = this.accessor) {
    return Math.round(this.byteLength / _accessor__WEBPACK_IMPORTED_MODULE_2__/* ["default"].getBytesPerVertex */ .Z.getBytesPerVertex(accessor));
  }

  initialize(props = {}) {
    if (ArrayBuffer.isView(props)) {
      props = {
        data: props
      };
    }

    if (Number.isFinite(props)) {
      props = {
        byteLength: props
      };
    }

    props = (0,_utils__WEBPACK_IMPORTED_MODULE_3__/* .checkProps */ .k)('Buffer', props, PROP_CHECKS_INITIALIZE);
    this.usage = props.usage || 35044;
    this.debugData = null;
    this.setAccessor(Object.assign({}, props, props.accessor));

    if (props.data) {
      this._setData(props.data, props.offset, props.byteLength);
    } else {
      this._setByteLength(props.byteLength || 0);
    }

    return this;
  }

  setProps(props) {
    props = (0,_utils__WEBPACK_IMPORTED_MODULE_3__/* .checkProps */ .k)('Buffer', props, PROP_CHECKS_SET_PROPS);

    if ('accessor' in props) {
      this.setAccessor(props.accessor);
    }

    return this;
  }

  setAccessor(accessor) {
    accessor = Object.assign({}, accessor);
    delete accessor.buffer;
    this.accessor = new _accessor__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z(accessor);
    return this;
  }

  reallocate(byteLength) {
    if (byteLength > this.byteLength) {
      this._setByteLength(byteLength);

      return true;
    }

    this.bytesUsed = byteLength;
    return false;
  }

  setData(props) {
    return this.initialize(props);
  }

  subData(props) {
    if (ArrayBuffer.isView(props)) {
      props = {
        data: props
      };
    }

    const {
      data,
      offset = 0,
      srcOffset = 0
    } = props;
    const byteLength = props.byteLength || props.length;
    (0,_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(data);
    const target = this.gl.webgl2 ? 36663 : this.target;
    this.gl.bindBuffer(target, this.handle);

    if (srcOffset !== 0 || byteLength !== undefined) {
      (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(this.gl);
      this.gl.bufferSubData(this.target, offset, data, srcOffset, byteLength);
    } else {
      this.gl.bufferSubData(target, offset, data);
    }

    this.gl.bindBuffer(target, null);
    this.debugData = null;

    this._inferType(data);

    return this;
  }

  copyData({
    sourceBuffer,
    readOffset = 0,
    writeOffset = 0,
    size
  }) {
    const {
      gl
    } = this;
    (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(gl);
    gl.bindBuffer(36662, sourceBuffer.handle);
    gl.bindBuffer(36663, this.handle);
    gl.copyBufferSubData(36662, 36663, readOffset, writeOffset, size);
    gl.bindBuffer(36662, null);
    gl.bindBuffer(36663, null);
    this.debugData = null;
    return this;
  }

  getData({
    dstData = null,
    srcByteOffset = 0,
    dstOffset = 0,
    length = 0
  } = {}) {
    (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(this.gl);
    const ArrayType = (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_5__/* .getTypedArrayFromGLType */ .vN)(this.accessor.type || 5126, {
      clamped: false
    });

    const sourceAvailableElementCount = this._getAvailableElementCount(srcByteOffset);

    const dstElementOffset = dstOffset;
    let dstAvailableElementCount;
    let dstElementCount;

    if (dstData) {
      dstElementCount = dstData.length;
      dstAvailableElementCount = dstElementCount - dstElementOffset;
    } else {
      dstAvailableElementCount = Math.min(sourceAvailableElementCount, length || sourceAvailableElementCount);
      dstElementCount = dstElementOffset + dstAvailableElementCount;
    }

    const copyElementCount = Math.min(sourceAvailableElementCount, dstAvailableElementCount);
    length = length || copyElementCount;
    (0,_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(length <= copyElementCount);
    dstData = dstData || new ArrayType(dstElementCount);
    this.gl.bindBuffer(36662, this.handle);
    this.gl.getBufferSubData(36662, srcByteOffset, dstData, dstOffset, length);
    this.gl.bindBuffer(36662, null);
    return dstData;
  }

  bind({
    target = this.target,
    index = this.accessor && this.accessor.index,
    offset = 0,
    size
  } = {}) {
    if (target === 35345 || target === 35982) {
      if (size !== undefined) {
        this.gl.bindBufferRange(target, index, this.handle, offset, size);
      } else {
        (0,_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(offset === 0);
        this.gl.bindBufferBase(target, index, this.handle);
      }
    } else {
      this.gl.bindBuffer(target, this.handle);
    }

    return this;
  }

  unbind({
    target = this.target,
    index = this.accessor && this.accessor.index
  } = {}) {
    const isIndexedBuffer = target === 35345 || target === 35982;

    if (isIndexedBuffer) {
      this.gl.bindBufferBase(target, index, null);
    } else {
      this.gl.bindBuffer(target, null);
    }

    return this;
  }

  getDebugData() {
    if (!this.debugData) {
      this.debugData = this.getData({
        length: Math.min(DEBUG_DATA_LENGTH, this.byteLength)
      });
      return {
        data: this.debugData,
        changed: true
      };
    }

    return {
      data: this.debugData,
      changed: false
    };
  }

  invalidateDebugData() {
    this.debugData = null;
  }

  _setData(data, offset = 0, byteLength = data.byteLength + offset) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(ArrayBuffer.isView(data));

    this._trackDeallocatedMemory();

    const target = this._getTarget();

    this.gl.bindBuffer(target, this.handle);
    this.gl.bufferData(target, byteLength, this.usage);
    this.gl.bufferSubData(target, offset, data);
    this.gl.bindBuffer(target, null);
    this.debugData = data.slice(0, DEBUG_DATA_LENGTH);
    this.bytesUsed = byteLength;

    this._trackAllocatedMemory(byteLength);

    const type = (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_5__/* .getGLTypeFromTypedArray */ .O)(data);
    (0,_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(type);
    this.setAccessor(new _accessor__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z(this.accessor, {
      type
    }));
    return this;
  }

  _setByteLength(byteLength, usage = this.usage) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(byteLength >= 0);

    this._trackDeallocatedMemory();

    let data = byteLength;

    if (byteLength === 0) {
      data = new Float32Array(0);
    }

    const target = this._getTarget();

    this.gl.bindBuffer(target, this.handle);
    this.gl.bufferData(target, data, usage);
    this.gl.bindBuffer(target, null);
    this.usage = usage;
    this.debugData = null;
    this.bytesUsed = byteLength;

    this._trackAllocatedMemory(byteLength);

    return this;
  }

  _getTarget() {
    return this.gl.webgl2 ? 36663 : this.target;
  }

  _getAvailableElementCount(srcByteOffset) {
    const ArrayType = (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_5__/* .getTypedArrayFromGLType */ .vN)(this.accessor.type || 5126, {
      clamped: false
    });
    const sourceElementOffset = srcByteOffset / ArrayType.BYTES_PER_ELEMENT;
    return this.getElementCount() - sourceElementOffset;
  }

  _inferType(data) {
    if (!this.accessor.type) {
      this.setAccessor(new _accessor__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z(this.accessor, {
        type: (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_5__/* .getGLTypeFromTypedArray */ .O)(data)
      }));
    }
  }

  _createHandle() {
    return this.gl.createBuffer();
  }

  _deleteHandle() {
    this.gl.deleteBuffer(this.handle);

    this._trackDeallocatedMemory();
  }

  _getParameter(pname) {
    this.gl.bindBuffer(this.target, this.handle);
    const value = this.gl.getBufferParameter(this.target, pname);
    this.gl.bindBuffer(this.target, null);
    return value;
  }

  get type() {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.deprecated */ .cM.deprecated('Buffer.type', 'Buffer.accessor.type')();
    return this.accessor.type;
  }

  get bytes() {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.deprecated */ .cM.deprecated('Buffer.bytes', 'Buffer.byteLength')();
    return this.byteLength;
  }

  setByteLength(byteLength) {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.deprecated */ .cM.deprecated('setByteLength', 'reallocate')();
    return this.reallocate(byteLength);
  }

  updateAccessor(opts) {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.deprecated */ .cM.deprecated('updateAccessor(...)', 'setAccessor(new Accessor(buffer.accessor, ...)')();
    this.accessor = new _accessor__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z(this.accessor, opts);
    return this;
  }

}
//# sourceMappingURL=buffer.js.map

/***/ }),

/***/ 26047:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ clear),
/* harmony export */   "$": () => (/* binding */ clearBuffer)
/* harmony export */ });
/* harmony import */ var _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39450);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22525);


const GL_DEPTH_BUFFER_BIT = 0x00000100;
const GL_STENCIL_BUFFER_BIT = 0x00000400;
const GL_COLOR_BUFFER_BIT = 0x00004000;
const GL_COLOR = 0x1800;
const GL_DEPTH = 0x1801;
const GL_STENCIL = 0x1802;
const GL_DEPTH_STENCIL = 0x84f9;
const ERR_ARGUMENTS = 'clear: bad arguments';
function clear(gl, {
  framebuffer = null,
  color = null,
  depth = null,
  stencil = null
} = {}) {
  const parameters = {};

  if (framebuffer) {
    parameters.framebuffer = framebuffer;
  }

  let clearFlags = 0;

  if (color) {
    clearFlags |= GL_COLOR_BUFFER_BIT;

    if (color !== true) {
      parameters.clearColor = color;
    }
  }

  if (depth) {
    clearFlags |= GL_DEPTH_BUFFER_BIT;

    if (depth !== true) {
      parameters.clearDepth = depth;
    }
  }

  if (stencil) {
    clearFlags |= GL_STENCIL_BUFFER_BIT;

    if (depth !== true) {
      parameters.clearStencil = depth;
    }
  }

  (0,_utils__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(clearFlags !== 0, ERR_ARGUMENTS);
  (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .withParameters */ .s8)(gl, parameters, () => {
    gl.clear(clearFlags);
  });
}
function clearBuffer(gl, {
  framebuffer = null,
  buffer = GL_COLOR,
  drawBuffer = 0,
  value = [0, 0, 0, 0]
} = {}) {
  (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(gl);
  (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .withParameters */ .s8)(gl, {
    framebuffer
  }, () => {
    switch (buffer) {
      case GL_COLOR:
        switch (value.constructor) {
          case Int32Array:
            gl.clearBufferiv(buffer, drawBuffer, value);
            break;

          case Uint32Array:
            gl.clearBufferuiv(buffer, drawBuffer, value);
            break;

          case Float32Array:
          default:
            gl.clearBufferfv(buffer, drawBuffer, value);
        }

        break;

      case GL_DEPTH:
        gl.clearBufferfv(GL_DEPTH, 0, [value]);
        break;

      case GL_STENCIL:
        gl.clearBufferiv(GL_STENCIL, 0, [value]);
        break;

      case GL_DEPTH_STENCIL:
        const [depth, stencil] = value;
        gl.clearBufferfi(GL_DEPTH_STENCIL, 0, depth, stencil);
        break;

      default:
        (0,_utils__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(false, ERR_ARGUMENTS);
    }
  });
}
//# sourceMappingURL=clear.js.map

/***/ }),

/***/ 1953:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Km": () => (/* binding */ copyToDataUrl),
  "Lv": () => (/* binding */ copyToTexture),
  "z6": () => (/* binding */ readPixelsToArray),
  "Jb": () => (/* binding */ readPixelsToBuffer)
});

// UNUSED EXPORTS: blit, copyToImage

// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/buffer.js
var buffer = __webpack_require__(53478);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/framebuffer.js
var framebuffer = __webpack_require__(53849);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture.js
var classes_texture = __webpack_require__(35008);
// EXTERNAL MODULE: ./node_modules/@luma.gl/gltools/dist/esm/index.js + 13 modules
var esm = __webpack_require__(39450);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/webgl-utils/typed-array-utils.js
var typed_array_utils = __webpack_require__(9335);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/assert.js
var utils_assert = __webpack_require__(22525);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/webgl-utils/format-utils.js

function glFormatToComponents(format) {
  switch (format) {
    case 6406:
    case 33326:
    case 6403:
      return 1;

    case 33328:
    case 33319:
      return 2;

    case 6407:
    case 34837:
      return 3;

    case 6408:
    case 34836:
      return 4;

    default:
      (0,utils_assert/* default */.Z)(false);
      return 0;
  }
}
function glTypeToBytes(type) {
  switch (type) {
    case 5121:
      return 1;

    case 33635:
    case 32819:
    case 32820:
      return 2;

    case 5126:
      return 4;

    default:
      (0,utils_assert/* default */.Z)(false);
      return 0;
  }
}
//# sourceMappingURL=format-utils.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/webgl-utils/texture-utils.js + 2 modules
var texture_utils = __webpack_require__(95432);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/copy-and-blit.js









function readPixelsToArray(source, options = {}) {
  const {
    sourceX = 0,
    sourceY = 0,
    sourceFormat = 6408
  } = options;
  let {
    sourceAttachment = 36064,
    target = null,
    sourceWidth,
    sourceHeight,
    sourceType
  } = options;
  const {
    framebuffer,
    deleteFramebuffer
  } = getFramebuffer(source);
  (0,utils_assert/* default */.Z)(framebuffer);
  const {
    gl,
    handle,
    attachments
  } = framebuffer;
  sourceWidth = sourceWidth || framebuffer.width;
  sourceHeight = sourceHeight || framebuffer.height;

  if (sourceAttachment === 36064 && handle === null) {
    sourceAttachment = 1028;
  }

  (0,utils_assert/* default */.Z)(attachments[sourceAttachment]);
  sourceType = sourceType || attachments[sourceAttachment].type;
  target = getPixelArray(target, sourceType, sourceFormat, sourceWidth, sourceHeight);
  sourceType = sourceType || (0,typed_array_utils/* getGLTypeFromTypedArray */.O)(target);
  const prevHandle = gl.bindFramebuffer(36160, handle);
  gl.readPixels(sourceX, sourceY, sourceWidth, sourceHeight, sourceFormat, sourceType, target);
  gl.bindFramebuffer(36160, prevHandle || null);

  if (deleteFramebuffer) {
    framebuffer.delete();
  }

  return target;
}
function readPixelsToBuffer(source, {
  sourceX = 0,
  sourceY = 0,
  sourceFormat = 6408,
  target = null,
  targetByteOffset = 0,
  sourceWidth,
  sourceHeight,
  sourceType
}) {
  const {
    framebuffer,
    deleteFramebuffer
  } = getFramebuffer(source);
  (0,utils_assert/* default */.Z)(framebuffer);
  sourceWidth = sourceWidth || framebuffer.width;
  sourceHeight = sourceHeight || framebuffer.height;
  const gl2 = (0,esm/* assertWebGL2Context */.KQ)(framebuffer.gl);
  sourceType = sourceType || (target ? target.type : 5121);

  if (!target) {
    const components = glFormatToComponents(sourceFormat);
    const byteCount = glTypeToBytes(sourceType);
    const byteLength = targetByteOffset + sourceWidth * sourceHeight * components * byteCount;
    target = new buffer/* default */.Z(gl2, {
      byteLength,
      accessor: {
        type: sourceType,
        size: components
      }
    });
  }

  target.bind({
    target: 35051
  });
  (0,esm/* withParameters */.s8)(gl2, {
    framebuffer
  }, () => {
    gl2.readPixels(sourceX, sourceY, sourceWidth, sourceHeight, sourceFormat, sourceType, targetByteOffset);
  });
  target.unbind({
    target: 35051
  });

  if (deleteFramebuffer) {
    framebuffer.delete();
  }

  return target;
}
function copyToDataUrl(source, {
  sourceAttachment = 36064,
  targetMaxHeight = Number.MAX_SAFE_INTEGER
} = {}) {
  let data = readPixelsToArray(source, {
    sourceAttachment
  });
  let {
    width,
    height
  } = source;

  while (height > targetMaxHeight) {
    ({
      data,
      width,
      height
    } = (0,typed_array_utils/* scalePixels */.KS)({
      data,
      width,
      height
    }));
  }

  (0,typed_array_utils/* flipRows */.c$)({
    data,
    width,
    height
  });
  const canvas = document.createElement('canvas');
  canvas.width = width;
  canvas.height = height;
  const context = canvas.getContext('2d');
  const imageData = context.createImageData(width, height);
  imageData.data.set(data);
  context.putImageData(imageData, 0, 0);
  return canvas.toDataURL();
}
function copyToImage(source, {
  sourceAttachment = 36064,
  targetImage = null
} = {}) {
  const dataUrl = copyToDataUrl(source, {
    sourceAttachment
  });
  targetImage = targetImage || new Image();
  targetImage.src = dataUrl;
  return targetImage;
}
function copyToTexture(source, target, options = {}) {
  const {
    sourceX = 0,
    sourceY = 0,
    targetMipmaplevel = 0,
    targetInternalFormat = 6408
  } = options;
  let {
    targetX,
    targetY,
    targetZ,
    width,
    height
  } = options;
  const {
    framebuffer,
    deleteFramebuffer
  } = getFramebuffer(source);
  (0,utils_assert/* default */.Z)(framebuffer);
  const {
    gl,
    handle
  } = framebuffer;
  const isSubCopy = typeof targetX !== 'undefined' || typeof targetY !== 'undefined' || typeof targetZ !== 'undefined';
  targetX = targetX || 0;
  targetY = targetY || 0;
  targetZ = targetZ || 0;
  const prevHandle = gl.bindFramebuffer(36160, handle);
  (0,utils_assert/* default */.Z)(target);
  let texture = null;

  if (target instanceof classes_texture/* default */.Z) {
    texture = target;
    width = Number.isFinite(width) ? width : texture.width;
    height = Number.isFinite(height) ? height : texture.height;
    texture.bind(0);
    target = texture.target;
  }

  if (!isSubCopy) {
    gl.copyTexImage2D(target, targetMipmaplevel, targetInternalFormat, sourceX, sourceY, width, height, 0);
  } else {
    switch (target) {
      case 3553:
      case 34067:
        gl.copyTexSubImage2D(target, targetMipmaplevel, targetX, targetY, sourceX, sourceY, width, height);
        break;

      case 35866:
      case 32879:
        const gl2 = (0,esm/* assertWebGL2Context */.KQ)(gl);
        gl2.copyTexSubImage3D(target, targetMipmaplevel, targetX, targetY, targetZ, sourceX, sourceY, width, height);
        break;

      default:
    }
  }

  if (texture) {
    texture.unbind();
  }

  gl.bindFramebuffer(36160, prevHandle || null);

  if (deleteFramebuffer) {
    framebuffer.delete();
  }

  return texture;
}
function blit(source, target, options = {}) {
  const {
    sourceX0 = 0,
    sourceY0 = 0,
    targetX0 = 0,
    targetY0 = 0,
    color = true,
    depth = false,
    stencil = false,
    filter = 9728
  } = options;
  let {
    sourceX1,
    sourceY1,
    targetX1,
    targetY1,
    sourceAttachment = 36064,
    mask = 0
  } = options;
  const {
    framebuffer: srcFramebuffer,
    deleteFramebuffer: deleteSrcFramebuffer
  } = getFramebuffer(source);
  const {
    framebuffer: dstFramebuffer,
    deleteFramebuffer: deleteDstFramebuffer
  } = getFramebuffer(target);
  assert(srcFramebuffer);
  assert(dstFramebuffer);
  const {
    gl,
    handle,
    width,
    height,
    readBuffer
  } = dstFramebuffer;
  const gl2 = assertWebGL2Context(gl);

  if (!srcFramebuffer.handle && sourceAttachment === 36064) {
    sourceAttachment = 1028;
  }

  if (color) {
    mask |= 16384;
  }

  if (depth) {
    mask |= 256;
  }

  if (stencil) {
    mask |= 1024;
  }

  if (deleteSrcFramebuffer || deleteDstFramebuffer) {
    if (mask & (256 | 1024)) {
      mask = 16384;
      log.warn('Blitting from or into a Texture object, forcing mask to GL.COLOR_BUFFER_BIT')();
    }
  }

  assert(mask);
  sourceX1 = sourceX1 === undefined ? srcFramebuffer.width : sourceX1;
  sourceY1 = sourceY1 === undefined ? srcFramebuffer.height : sourceY1;
  targetX1 = targetX1 === undefined ? width : targetX1;
  targetY1 = targetY1 === undefined ? height : targetY1;
  const prevDrawHandle = gl.bindFramebuffer(36009, handle);
  const prevReadHandle = gl.bindFramebuffer(36008, srcFramebuffer.handle);
  gl2.readBuffer(sourceAttachment);
  gl2.blitFramebuffer(sourceX0, sourceY0, sourceX1, sourceY1, targetX0, targetY0, targetX1, targetY1, mask, filter);
  gl2.readBuffer(readBuffer);
  gl2.bindFramebuffer(36008, prevReadHandle || null);
  gl2.bindFramebuffer(36009, prevDrawHandle || null);

  if (deleteSrcFramebuffer) {
    srcFramebuffer.delete();
  }

  if (deleteDstFramebuffer) {
    dstFramebuffer.delete();
  }

  return dstFramebuffer;
}

function getFramebuffer(source) {
  if (!(source instanceof framebuffer/* default */.Z)) {
    return {
      framebuffer: (0,texture_utils/* toFramebuffer */.Y)(source),
      deleteFramebuffer: true
    };
  }

  return {
    framebuffer: source,
    deleteFramebuffer: false
  };
}

function getPixelArray(pixelArray, type, format, width, height) {
  if (pixelArray) {
    return pixelArray;
  }

  type = type || 5121;
  const ArrayType = (0,typed_array_utils/* getTypedArrayFromGLType */.vN)(type, {
    clamped: false
  });
  const components = glFormatToComponents(format);
  return new ArrayType(width * height * components);
}
//# sourceMappingURL=copy-and-blit.js.map

/***/ }),

/***/ 53849:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Framebuffer)
/* harmony export */ });
/* unused harmony export FRAMEBUFFER_ATTACHMENT_PARAMETERS */
/* harmony import */ var _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39450);
/* harmony import */ var _resource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87577);
/* harmony import */ var _texture_2d__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(4912);
/* harmony import */ var _renderbuffer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(49830);
/* harmony import */ var _clear__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26047);
/* harmony import */ var _copy_and_blit_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1953);
/* harmony import */ var _features__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(44211);
/* harmony import */ var _webgl_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(79579);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22525);









const ERR_MULTIPLE_RENDERTARGETS = 'Multiple render targets not supported';
class Framebuffer extends _resource__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z {
  static isSupported(gl, options = {}) {
    const {
      colorBufferFloat,
      colorBufferHalfFloat
    } = options;
    let supported = true;

    if (colorBufferFloat) {
      supported = Boolean(gl.getExtension('EXT_color_buffer_float') || gl.getExtension('WEBGL_color_buffer_float') || gl.getExtension('OES_texture_float'));
    }

    if (colorBufferHalfFloat) {
      supported = supported && Boolean(gl.getExtension('EXT_color_buffer_float') || gl.getExtension('EXT_color_buffer_half_float'));
    }

    return supported;
  }

  static getDefaultFramebuffer(gl) {
    gl.luma = gl.luma || {};
    gl.luma.defaultFramebuffer = gl.luma.defaultFramebuffer || new Framebuffer(gl, {
      id: 'default-framebuffer',
      handle: null,
      attachments: {}
    });
    return gl.luma.defaultFramebuffer;
  }

  get MAX_COLOR_ATTACHMENTS() {
    const gl2 = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(this.gl);
    return gl2.getParameter(gl2.MAX_COLOR_ATTACHMENTS);
  }

  get MAX_DRAW_BUFFERS() {
    const gl2 = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(this.gl);
    return gl2.getParameter(gl2.MAX_DRAW_BUFFERS);
  }

  constructor(gl, opts = {}) {
    super(gl, opts);
    this.width = null;
    this.height = null;
    this.attachments = {};
    this.readBuffer = 36064;
    this.drawBuffers = [36064];
    this.ownResources = [];
    this.initialize(opts);
    Object.seal(this);
  }

  get color() {
    return this.attachments[36064] || null;
  }

  get texture() {
    return this.attachments[36064] || null;
  }

  get depth() {
    return this.attachments[36096] || this.attachments[33306] || null;
  }

  get stencil() {
    return this.attachments[36128] || this.attachments[33306] || null;
  }

  initialize({
    width = 1,
    height = 1,
    attachments = null,
    color = true,
    depth = true,
    stencil = false,
    check = true,
    readBuffer = undefined,
    drawBuffers = undefined
  }) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(width >= 0 && height >= 0, 'Width and height need to be integers');
    this.width = width;
    this.height = height;

    if (attachments) {
      for (const attachment in attachments) {
        const target = attachments[attachment];
        const object = Array.isArray(target) ? target[0] : target;
        object.resize({
          width,
          height
        });
      }
    } else {
      attachments = this._createDefaultAttachments(color, depth, stencil, width, height);
    }

    this.update({
      clearAttachments: true,
      attachments,
      readBuffer,
      drawBuffers
    });

    if (attachments && check) {
      this.checkStatus();
    }
  }

  delete() {
    for (const resource of this.ownResources) {
      resource.delete();
    }

    super.delete();
    return this;
  }

  update({
    attachments = {},
    readBuffer,
    drawBuffers,
    clearAttachments = false,
    resizeAttachments = true
  }) {
    this.attach(attachments, {
      clearAttachments,
      resizeAttachments
    });
    const {
      gl
    } = this;
    const prevHandle = gl.bindFramebuffer(36160, this.handle);

    if (readBuffer) {
      this._setReadBuffer(readBuffer);
    }

    if (drawBuffers) {
      this._setDrawBuffers(drawBuffers);
    }

    gl.bindFramebuffer(36160, prevHandle || null);
    return this;
  }

  resize(options = {}) {
    let {
      width,
      height
    } = options;

    if (this.handle === null) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(width === undefined && height === undefined);
      this.width = this.gl.drawingBufferWidth;
      this.height = this.gl.drawingBufferHeight;
      return this;
    }

    if (width === undefined) {
      width = this.gl.drawingBufferWidth;
    }

    if (height === undefined) {
      height = this.gl.drawingBufferHeight;
    }

    if (width !== this.width && height !== this.height) {
      _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.log */ .cM.log(2, "Resizing framebuffer ".concat(this.id, " to ").concat(width, "x").concat(height))();
    }

    for (const attachmentPoint in this.attachments) {
      this.attachments[attachmentPoint].resize({
        width,
        height
      });
    }

    this.width = width;
    this.height = height;
    return this;
  }

  attach(attachments, {
    clearAttachments = false,
    resizeAttachments = true
  } = {}) {
    const newAttachments = {};

    if (clearAttachments) {
      Object.keys(this.attachments).forEach(key => {
        newAttachments[key] = null;
      });
    }

    Object.assign(newAttachments, attachments);
    const prevHandle = this.gl.bindFramebuffer(36160, this.handle);

    for (const key in newAttachments) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(key !== undefined, 'Misspelled framebuffer binding point?');
      const attachment = Number(key);
      const descriptor = newAttachments[attachment];
      let object = descriptor;

      if (!object) {
        this._unattach(attachment);
      } else if (object instanceof _renderbuffer__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z) {
        this._attachRenderbuffer({
          attachment,
          renderbuffer: object
        });
      } else if (Array.isArray(descriptor)) {
        const [texture, layer = 0, level = 0] = descriptor;
        object = texture;

        this._attachTexture({
          attachment,
          texture,
          layer,
          level
        });
      } else {
        this._attachTexture({
          attachment,
          texture: object,
          layer: 0,
          level: 0
        });
      }

      if (resizeAttachments && object) {
        object.resize({
          width: this.width,
          height: this.height
        });
      }
    }

    this.gl.bindFramebuffer(36160, prevHandle || null);
    Object.assign(this.attachments, attachments);
    Object.keys(this.attachments).filter(key => !this.attachments[key]).forEach(key => {
      delete this.attachments[key];
    });
  }

  checkStatus() {
    const {
      gl
    } = this;
    const status = this.getStatus();

    if (status !== 36053) {
      throw new Error(_getFrameBufferStatus(status));
    }

    return this;
  }

  getStatus() {
    const {
      gl
    } = this;
    const prevHandle = gl.bindFramebuffer(36160, this.handle);
    const status = gl.checkFramebufferStatus(36160);
    gl.bindFramebuffer(36160, prevHandle || null);
    return status;
  }

  clear(options = {}) {
    const {
      color,
      depth,
      stencil,
      drawBuffers = []
    } = options;
    const prevHandle = this.gl.bindFramebuffer(36160, this.handle);

    if (color || depth || stencil) {
      (0,_clear__WEBPACK_IMPORTED_MODULE_4__/* .clear */ .Z)(this.gl, {
        color,
        depth,
        stencil
      });
    }

    drawBuffers.forEach((value, drawBuffer) => {
      (0,_clear__WEBPACK_IMPORTED_MODULE_4__/* .clearBuffer */ .$)(this.gl, {
        drawBuffer,
        value
      });
    });
    this.gl.bindFramebuffer(36160, prevHandle || null);
    return this;
  }

  readPixels(opts = {}) {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.error */ .cM.error('Framebuffer.readPixels() is no logner supported, use readPixelsToArray(framebuffer)')();
    return null;
  }

  readPixelsToBuffer(opts = {}) {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.error */ .cM.error('Framebuffer.readPixelsToBuffer()is no logner supported, use readPixelsToBuffer(framebuffer)')();
    return null;
  }

  copyToDataUrl(opts = {}) {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.error */ .cM.error('Framebuffer.copyToDataUrl() is no logner supported, use copyToDataUrl(framebuffer)')();
    return null;
  }

  copyToImage(opts = {}) {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.error */ .cM.error('Framebuffer.copyToImage() is no logner supported, use copyToImage(framebuffer)')();
    return null;
  }

  copyToTexture(opts = {}) {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.error */ .cM.error('Framebuffer.copyToTexture({...}) is no logner supported, use copyToTexture(source, target, opts})')();
    return null;
  }

  blit(opts = {}) {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.error */ .cM.error('Framebuffer.blit({...}) is no logner supported, use blit(source, target, opts)')();
    return null;
  }

  invalidate({
    attachments = [],
    x = 0,
    y = 0,
    width,
    height
  }) {
    const gl2 = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(this.gl);
    const prevHandle = gl2.bindFramebuffer(36008, this.handle);
    const invalidateAll = x === 0 && y === 0 && width === undefined && height === undefined;

    if (invalidateAll) {
      gl2.invalidateFramebuffer(36008, attachments);
    } else {
      gl2.invalidateFramebuffer(36008, attachments, x, y, width, height);
    }

    gl2.bindFramebuffer(36008, prevHandle);
    return this;
  }

  getAttachmentParameter(attachment, pname, keys) {
    let value = this._getAttachmentParameterFallback(pname);

    if (value === null) {
      this.gl.bindFramebuffer(36160, this.handle);
      value = this.gl.getFramebufferAttachmentParameter(36160, attachment, pname);
      this.gl.bindFramebuffer(36160, null);
    }

    if (keys && value > 1000) {
      value = (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_5__/* .getKey */ .km)(this.gl, value);
    }

    return value;
  }

  getAttachmentParameters(attachment = 36064, keys, parameters = this.constructor.ATTACHMENT_PARAMETERS || []) {
    const values = {};

    for (const pname of parameters) {
      const key = keys ? (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_5__/* .getKey */ .km)(this.gl, pname) : pname;
      values[key] = this.getAttachmentParameter(attachment, pname, keys);
    }

    return values;
  }

  getParameters(keys = true) {
    const attachments = Object.keys(this.attachments);
    const parameters = {};

    for (const attachmentName of attachments) {
      const attachment = Number(attachmentName);
      const key = keys ? (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_5__/* .getKey */ .km)(this.gl, attachment) : attachment;
      parameters[key] = this.getAttachmentParameters(attachment, keys);
    }

    return parameters;
  }

  show() {
    if (typeof window !== 'undefined') {
      window.open((0,_copy_and_blit_js__WEBPACK_IMPORTED_MODULE_6__/* .copyToDataUrl */ .Km)(this), 'luma-debug-texture');
    }

    return this;
  }

  log(logLevel = 0, message = '') {
    if (logLevel > _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.level */ .cM.level || typeof window === 'undefined') {
      return this;
    }

    message = message || "Framebuffer ".concat(this.id);
    const image = (0,_copy_and_blit_js__WEBPACK_IMPORTED_MODULE_6__/* .copyToDataUrl */ .Km)(this, {
      targetMaxHeight: 100
    });
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.image */ .cM.image({
      logLevel,
      message,
      image
    }, message)();
    return this;
  }

  bind({
    target = 36160
  } = {}) {
    this.gl.bindFramebuffer(target, this.handle);
    return this;
  }

  unbind({
    target = 36160
  } = {}) {
    this.gl.bindFramebuffer(target, null);
    return this;
  }

  _createDefaultAttachments(color, depth, stencil, width, height) {
    let defaultAttachments = null;

    if (color) {
      defaultAttachments = defaultAttachments || {};
      defaultAttachments[36064] = new _texture_2d__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z(this.gl, {
        id: "".concat(this.id, "-color0"),
        pixels: null,
        format: 6408,
        type: 5121,
        width,
        height,
        mipmaps: false,
        parameters: {
          [10241]: 9729,
          [10240]: 9729,
          [10242]: 33071,
          [10243]: 33071
        }
      });
      this.ownResources.push(defaultAttachments[36064]);
    }

    if (depth && stencil) {
      defaultAttachments = defaultAttachments || {};
      defaultAttachments[33306] = new _renderbuffer__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z(this.gl, {
        id: "".concat(this.id, "-depth-stencil"),
        format: 35056,
        width,
        height: 111
      });
      this.ownResources.push(defaultAttachments[33306]);
    } else if (depth) {
      defaultAttachments = defaultAttachments || {};
      defaultAttachments[36096] = new _renderbuffer__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z(this.gl, {
        id: "".concat(this.id, "-depth"),
        format: 33189,
        width,
        height
      });
      this.ownResources.push(defaultAttachments[36096]);
    } else if (stencil) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(false);
    }

    return defaultAttachments;
  }

  _unattach(attachment) {
    const oldAttachment = this.attachments[attachment];

    if (!oldAttachment) {
      return;
    }

    if (oldAttachment instanceof _renderbuffer__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z) {
      this.gl.framebufferRenderbuffer(36160, attachment, 36161, null);
    } else {
      this.gl.framebufferTexture2D(36160, attachment, 3553, null, 0);
    }

    delete this.attachments[attachment];
  }

  _attachRenderbuffer({
    attachment = 36064,
    renderbuffer
  }) {
    const {
      gl
    } = this;
    gl.framebufferRenderbuffer(36160, attachment, 36161, renderbuffer.handle);
    this.attachments[attachment] = renderbuffer;
  }

  _attachTexture({
    attachment = 36064,
    texture,
    layer,
    level
  }) {
    const {
      gl
    } = this;
    gl.bindTexture(texture.target, texture.handle);

    switch (texture.target) {
      case 35866:
      case 32879:
        const gl2 = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(gl);
        gl2.framebufferTextureLayer(36160, attachment, texture.target, level, layer);
        break;

      case 34067:
        const face = mapIndexToCubeMapFace(layer);
        gl.framebufferTexture2D(36160, attachment, face, texture.handle, level);
        break;

      case 3553:
        gl.framebufferTexture2D(36160, attachment, 3553, texture.handle, level);
        break;

      default:
        (0,_utils__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(false, 'Illegal texture type');
    }

    gl.bindTexture(texture.target, null);
    this.attachments[attachment] = texture;
  }

  _setReadBuffer(readBuffer) {
    const gl2 = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .getWebGL2Context */ .vd)(this.gl);

    if (gl2) {
      gl2.readBuffer(readBuffer);
    } else {
      (0,_utils__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(readBuffer === 36064 || readBuffer === 1029, ERR_MULTIPLE_RENDERTARGETS);
    }

    this.readBuffer = readBuffer;
  }

  _setDrawBuffers(drawBuffers) {
    const {
      gl
    } = this;
    const gl2 = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(gl);

    if (gl2) {
      gl2.drawBuffers(drawBuffers);
    } else {
      const ext = gl.getExtension('WEBGL_draw_buffers');

      if (ext) {
        ext.drawBuffersWEBGL(drawBuffers);
      } else {
        (0,_utils__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(drawBuffers.length === 1 && (drawBuffers[0] === 36064 || drawBuffers[0] === 1029), ERR_MULTIPLE_RENDERTARGETS);
      }
    }

    this.drawBuffers = drawBuffers;
  }

  _getAttachmentParameterFallback(pname) {
    const caps = (0,_features__WEBPACK_IMPORTED_MODULE_8__/* .getFeatures */ .N$)(this.gl);

    switch (pname) {
      case 36052:
        return !caps.WEBGL2 ? 0 : null;

      case 33298:
      case 33299:
      case 33300:
      case 33301:
      case 33302:
      case 33303:
        return !caps.WEBGL2 ? 8 : null;

      case 33297:
        return !caps.WEBGL2 ? 5125 : null;

      case 33296:
        return !caps.WEBGL2 && !caps.EXT_sRGB ? 9729 : null;

      default:
        return null;
    }
  }

  _createHandle() {
    return this.gl.createFramebuffer();
  }

  _deleteHandle() {
    this.gl.deleteFramebuffer(this.handle);
  }

  _bindHandle(handle) {
    return this.gl.bindFramebuffer(36160, handle);
  }

}

function mapIndexToCubeMapFace(layer) {
  return layer < 34069 ? layer + 34069 : layer;
}

function _getFrameBufferStatus(status) {
  const STATUS = Framebuffer.STATUS || {};
  return STATUS[status] || "Framebuffer error ".concat(status);
}

const FRAMEBUFFER_ATTACHMENT_PARAMETERS = [36049, 36048, 33296, 33298, 33299, 33300, 33301, 33302, 33303];
Framebuffer.ATTACHMENT_PARAMETERS = FRAMEBUFFER_ATTACHMENT_PARAMETERS;
//# sourceMappingURL=framebuffer.js.map

/***/ }),

/***/ 7944:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Program)
});

// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/resource.js
var resource = __webpack_require__(87577);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture.js
var texture = __webpack_require__(35008);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/framebuffer.js
var framebuffer = __webpack_require__(53849);
// EXTERNAL MODULE: ./node_modules/@luma.gl/gltools/dist/esm/index.js + 13 modules
var esm = __webpack_require__(39450);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/renderbuffer.js + 1 modules
var renderbuffer = __webpack_require__(49830);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/assert.js
var assert = __webpack_require__(22525);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/uniforms.js





const UNIFORM_SETTERS = {
  [5126]: getArraySetter.bind(null, 'uniform1fv', toFloatArray, 1, setVectorUniform),
  [35664]: getArraySetter.bind(null, 'uniform2fv', toFloatArray, 2, setVectorUniform),
  [35665]: getArraySetter.bind(null, 'uniform3fv', toFloatArray, 3, setVectorUniform),
  [35666]: getArraySetter.bind(null, 'uniform4fv', toFloatArray, 4, setVectorUniform),
  [5124]: getArraySetter.bind(null, 'uniform1iv', toIntArray, 1, setVectorUniform),
  [35667]: getArraySetter.bind(null, 'uniform2iv', toIntArray, 2, setVectorUniform),
  [35668]: getArraySetter.bind(null, 'uniform3iv', toIntArray, 3, setVectorUniform),
  [35669]: getArraySetter.bind(null, 'uniform4iv', toIntArray, 4, setVectorUniform),
  [35670]: getArraySetter.bind(null, 'uniform1iv', toIntArray, 1, setVectorUniform),
  [35671]: getArraySetter.bind(null, 'uniform2iv', toIntArray, 2, setVectorUniform),
  [35672]: getArraySetter.bind(null, 'uniform3iv', toIntArray, 3, setVectorUniform),
  [35673]: getArraySetter.bind(null, 'uniform4iv', toIntArray, 4, setVectorUniform),
  [35674]: getArraySetter.bind(null, 'uniformMatrix2fv', toFloatArray, 4, setMatrixUniform),
  [35675]: getArraySetter.bind(null, 'uniformMatrix3fv', toFloatArray, 9, setMatrixUniform),
  [35676]: getArraySetter.bind(null, 'uniformMatrix4fv', toFloatArray, 16, setMatrixUniform),
  [35678]: getSamplerSetter,
  [35680]: getSamplerSetter,
  [5125]: getArraySetter.bind(null, 'uniform1uiv', toUIntArray, 1, setVectorUniform),
  [36294]: getArraySetter.bind(null, 'uniform2uiv', toUIntArray, 2, setVectorUniform),
  [36295]: getArraySetter.bind(null, 'uniform3uiv', toUIntArray, 3, setVectorUniform),
  [36296]: getArraySetter.bind(null, 'uniform4uiv', toUIntArray, 4, setVectorUniform),
  [35685]: getArraySetter.bind(null, 'uniformMatrix2x3fv', toFloatArray, 6, setMatrixUniform),
  [35686]: getArraySetter.bind(null, 'uniformMatrix2x4fv', toFloatArray, 8, setMatrixUniform),
  [35687]: getArraySetter.bind(null, 'uniformMatrix3x2fv', toFloatArray, 6, setMatrixUniform),
  [35688]: getArraySetter.bind(null, 'uniformMatrix3x4fv', toFloatArray, 12, setMatrixUniform),
  [35689]: getArraySetter.bind(null, 'uniformMatrix4x2fv', toFloatArray, 8, setMatrixUniform),
  [35690]: getArraySetter.bind(null, 'uniformMatrix4x3fv', toFloatArray, 12, setMatrixUniform),
  [35678]: getSamplerSetter,
  [35680]: getSamplerSetter,
  [35679]: getSamplerSetter,
  [35682]: getSamplerSetter,
  [36289]: getSamplerSetter,
  [36292]: getSamplerSetter,
  [36293]: getSamplerSetter,
  [36298]: getSamplerSetter,
  [36299]: getSamplerSetter,
  [36300]: getSamplerSetter,
  [36303]: getSamplerSetter,
  [36306]: getSamplerSetter,
  [36307]: getSamplerSetter,
  [36308]: getSamplerSetter,
  [36311]: getSamplerSetter
};
const FLOAT_ARRAY = {};
const INT_ARRAY = {};
const UINT_ARRAY = {};
const array1 = [0];

function toTypedArray(value, uniformLength, Type, cache) {
  if (uniformLength === 1 && typeof value === 'boolean') {
    value = value ? 1 : 0;
  }

  if (Number.isFinite(value)) {
    array1[0] = value;
    value = array1;
  }

  const length = value.length;

  if (length % uniformLength) {
    esm/* log.warn */.cM.warn("Uniform size should be multiples of ".concat(uniformLength), value)();
  }

  if (value instanceof Type) {
    return value;
  }

  let result = cache[length];

  if (!result) {
    result = new Type(length);
    cache[length] = result;
  }

  for (let i = 0; i < length; i++) {
    result[i] = value[i];
  }

  return result;
}

function toFloatArray(value, uniformLength) {
  return toTypedArray(value, uniformLength, Float32Array, FLOAT_ARRAY);
}

function toIntArray(value, uniformLength) {
  return toTypedArray(value, uniformLength, Int32Array, INT_ARRAY);
}

function toUIntArray(value, uniformLength) {
  return toTypedArray(value, uniformLength, Uint32Array, UINT_ARRAY);
}

function getUniformSetter(gl, location, info) {
  const setter = UNIFORM_SETTERS[info.type];

  if (!setter) {
    throw new Error("Unknown GLSL uniform type ".concat(info.type));
  }

  return setter().bind(null, gl, location);
}
function parseUniformName(name) {
  if (name[name.length - 1] !== ']') {
    return {
      name,
      length: 1,
      isArray: false
    };
  }

  const UNIFORM_NAME_REGEXP = /([^[]*)(\[[0-9]+\])?/;
  const matches = name.match(UNIFORM_NAME_REGEXP);

  if (!matches || matches.length < 2) {
    throw new Error("Failed to parse GLSL uniform name ".concat(name));
  }

  return {
    name: matches[1],
    length: matches[2] || 1,
    isArray: Boolean(matches[2])
  };
}
function checkUniformValues(uniforms, source, uniformMap) {
  for (const uniformName in uniforms) {
    const value = uniforms[uniformName];
    const shouldCheck = !uniformMap || Boolean(uniformMap[uniformName]);

    if (shouldCheck && !checkUniformValue(value)) {
      source = source ? "".concat(source, " ") : '';
      console.error("".concat(source, " Bad uniform ").concat(uniformName), value);
      throw new Error("".concat(source, " Bad uniform ").concat(uniformName));
    }
  }

  return true;
}

function checkUniformValue(value) {
  if (Array.isArray(value) || ArrayBuffer.isView(value)) {
    return checkUniformArray(value);
  }

  if (isFinite(value)) {
    return true;
  } else if (value === true || value === false) {
    return true;
  } else if (value instanceof texture/* default */.Z) {
    return true;
  } else if (value instanceof renderbuffer/* default */.Z) {
    return true;
  } else if (value instanceof framebuffer/* default */.Z) {
    return Boolean(value.texture);
  }

  return false;
}

function copyUniform(uniforms, key, value) {
  if (Array.isArray(value) || ArrayBuffer.isView(value)) {
    if (uniforms[key]) {
      const dest = uniforms[key];

      for (let i = 0, len = value.length; i < len; ++i) {
        dest[i] = value[i];
      }
    } else {
      uniforms[key] = value.slice();
    }
  } else {
    uniforms[key] = value;
  }
}

function checkUniformArray(value) {
  if (value.length === 0) {
    return false;
  }

  const checkLength = Math.min(value.length, 16);

  for (let i = 0; i < checkLength; ++i) {
    if (!Number.isFinite(value[i])) {
      return false;
    }
  }

  return true;
}

function getSamplerSetter() {
  let cache = null;
  return (gl, location, value) => {
    const update = cache !== value;

    if (update) {
      gl.uniform1i(location, value);
      cache = value;
    }

    return update;
  };
}

function getArraySetter(functionName, toArray, size, uniformSetter) {
  let cache = null;
  let cacheLength = null;
  return (gl, location, value) => {
    const arrayValue = toArray(value, size);
    const length = arrayValue.length;
    let update = false;

    if (cache === null) {
      cache = new Float32Array(length);
      cacheLength = length;
      update = true;
    } else {
      (0,assert/* default */.Z)(cacheLength === length, 'Uniform length cannot change.');

      for (let i = 0; i < length; ++i) {
        if (arrayValue[i] !== cache[i]) {
          update = true;
          break;
        }
      }
    }

    if (update) {
      uniformSetter(gl, functionName, location, arrayValue);
      cache.set(arrayValue);
    }

    return update;
  };
}

function setVectorUniform(gl, functionName, location, value) {
  gl[functionName](location, value);
}

function setMatrixUniform(gl, functionName, location, value) {
  gl[functionName](location, false, value);
}
//# sourceMappingURL=uniforms.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/glsl-utils/get-shader-name.js
function getShaderName(shader, defaultName = 'unnamed') {
  const SHADER_NAME_REGEXP = /#define[\s*]SHADER_NAME[\s*]([A-Za-z0-9_-]+)[\s*]/;
  const match = shader.match(SHADER_NAME_REGEXP);
  return match ? match[1] : defaultName;
}
//# sourceMappingURL=get-shader-name.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/glsl-utils/get-shader-type-name.js
const GL_FRAGMENT_SHADER = 0x8b30;
const GL_VERTEX_SHADER = 0x8b31;
function getShaderTypeName(type) {
  switch (type) {
    case GL_FRAGMENT_SHADER:
      return 'fragment';

    case GL_VERTEX_SHADER:
      return 'vertex';

    default:
      return 'unknown type';
  }
}
//# sourceMappingURL=get-shader-type-name.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/glsl-utils/format-glsl-error.js


function formatGLSLCompilerError(errLog, src, shaderType) {
  const {
    shaderName,
    errors,
    warnings
  } = parseGLSLCompilerError(errLog, src, shaderType);
  return "GLSL compilation error in ".concat(shaderName, "\n\n").concat(errors, "\n").concat(warnings);
}
function parseGLSLCompilerError(errLog, src, shaderType, shaderName) {
  const errorStrings = errLog.split(/\r?\n/);
  const errors = {};
  const warnings = {};
  const name = shaderName || getShaderName(src) || '(unnamed)';
  const shaderDescription = "".concat(getShaderTypeName(shaderType), " shader ").concat(name);

  for (let i = 0; i < errorStrings.length; i++) {
    const errorString = errorStrings[i];

    if (errorString.length <= 1) {
      continue;
    }

    const segments = errorString.split(':');
    const type = segments[0];
    const line = parseInt(segments[2], 10);

    if (isNaN(line)) {
      throw new Error("GLSL compilation error in ".concat(shaderDescription, ": ").concat(errLog));
    }

    if (type !== 'WARNING') {
      errors[line] = errorString;
    } else {
      warnings[line] = errorString;
    }
  }

  const lines = addLineNumbers(src);
  return {
    shaderName: shaderDescription,
    errors: formatErrors(errors, lines),
    warnings: formatErrors(warnings, lines)
  };
}

function formatErrors(errors, lines) {
  let message = '';

  for (let i = 0; i < lines.length; i++) {
    const line = lines[i];

    if (!errors[i + 3] && !errors[i + 2] && !errors[i + 1]) {
      continue;
    }

    message += "".concat(line, "\n");

    if (errors[i + 1]) {
      const error = errors[i + 1];
      const segments = error.split(':', 3);
      const type = segments[0];
      const column = parseInt(segments[1], 10) || 0;
      const err = error.substring(segments.join(':').length + 1).trim();
      message += padLeft("^^^ ".concat(type, ": ").concat(err, "\n\n"), column);
    }
  }

  return message;
}

function addLineNumbers(string, start = 1, delim = ': ') {
  const lines = string.split(/\r?\n/);
  const maxDigits = String(lines.length + start - 1).length;
  return lines.map((line, i) => {
    const lineNumber = String(i + start);
    const digits = lineNumber.length;
    const prefix = padLeft(lineNumber, maxDigits - digits);
    return prefix + delim + line;
  });
}

function padLeft(string, digits) {
  let result = '';

  for (let i = 0; i < digits; ++i) {
    result += ' ';
  }

  return "".concat(result).concat(string);
}
//# sourceMappingURL=format-glsl-error.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/utils.js
var utils = __webpack_require__(74538);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/shader.js




const ERR_SOURCE = 'Shader: GLSL source code must be a JavaScript string';
class Shader extends resource/* default */.Z {
  static getTypeName(shaderType) {
    switch (shaderType) {
      case 35633:
        return 'vertex-shader';

      case 35632:
        return 'fragment-shader';

      default:
        (0,assert/* default */.Z)(false);
        return 'unknown';
    }
  }

  constructor(gl, props) {
    (0,esm/* assertWebGLContext */.JD)(gl);
    (0,assert/* default */.Z)(typeof props.source === 'string', ERR_SOURCE);
    const id = getShaderName(props.source, null) || props.id || (0,utils/* uid */.hQ)("unnamed ".concat(Shader.getTypeName(props.shaderType)));
    super(gl, {
      id
    });
    this.shaderType = props.shaderType;
    this.source = props.source;
    this.initialize(props);
  }

  initialize({
    source
  }) {
    const shaderName = getShaderName(source, null);

    if (shaderName) {
      this.id = (0,utils/* uid */.hQ)(shaderName);
    }

    this._compile(source);
  }

  getParameter(pname) {
    return this.gl.getShaderParameter(this.handle, pname);
  }

  toString() {
    return "".concat(Shader.getTypeName(this.shaderType), ":").concat(this.id);
  }

  getName() {
    return getShaderName(this.source) || 'unnamed-shader';
  }

  getSource() {
    return this.gl.getShaderSource(this.handle);
  }

  getTranslatedSource() {
    const extension = this.gl.getExtension('WEBGL_debug_shaders');
    return extension ? extension.getTranslatedShaderSource(this.handle) : 'No translated source available. WEBGL_debug_shaders not implemented';
  }

  _compile(source = this.source) {
    if (!source.startsWith('#version ')) {
      source = "#version 100\n".concat(source);
    }

    this.source = source;
    this.gl.shaderSource(this.handle, this.source);
    this.gl.compileShader(this.handle);
    const compileStatus = this.getParameter(35713);

    if (!compileStatus) {
      const infoLog = this.gl.getShaderInfoLog(this.handle);
      const {
        shaderName,
        errors,
        warnings
      } = parseGLSLCompilerError(infoLog, this.source, this.shaderType, this.id);
      esm/* log.error */.cM.error("GLSL compilation errors in ".concat(shaderName, "\n").concat(errors))();
      esm/* log.warn */.cM.warn("GLSL compilation warnings in ".concat(shaderName, "\n").concat(warnings))();
      throw new Error("GLSL compilation errors in ".concat(shaderName));
    }
  }

  _deleteHandle() {
    this.gl.deleteShader(this.handle);
  }

  _getOptsFromHandle() {
    return {
      type: this.getParameter(35663),
      source: this.getSource()
    };
  }

}
class VertexShader extends Shader {
  constructor(gl, props) {
    if (typeof props === 'string') {
      props = {
        source: props
      };
    }

    super(gl, Object.assign({}, props, {
      shaderType: 35633
    }));
  }

  _createHandle() {
    return this.gl.createShader(35633);
  }

}
class FragmentShader extends Shader {
  constructor(gl, props) {
    if (typeof props === 'string') {
      props = {
        source: props
      };
    }

    super(gl, Object.assign({}, props, {
      shaderType: 35632
    }));
  }

  _createHandle() {
    return this.gl.createShader(35632);
  }

}
//# sourceMappingURL=shader.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/accessor.js
var classes_accessor = __webpack_require__(14072);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/webgl-utils/attribute-utils.js
var attribute_utils = __webpack_require__(38522);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/program-configuration.js



class ProgramConfiguration {
  constructor(program) {
    this.id = program.id;
    this.attributeInfos = [];
    this.attributeInfosByName = {};
    this.attributeInfosByLocation = [];
    this.varyingInfos = [];
    this.varyingInfosByName = {};
    Object.seal(this);

    this._readAttributesFromProgram(program);

    this._readVaryingsFromProgram(program);
  }

  getAttributeInfo(locationOrName) {
    const location = Number(locationOrName);

    if (Number.isFinite(location)) {
      return this.attributeInfosByLocation[location];
    }

    return this.attributeInfosByName[locationOrName] || null;
  }

  getAttributeLocation(locationOrName) {
    const attributeInfo = this.getAttributeInfo(locationOrName);
    return attributeInfo ? attributeInfo.location : -1;
  }

  getAttributeAccessor(locationOrName) {
    const attributeInfo = this.getAttributeInfo(locationOrName);
    return attributeInfo ? attributeInfo.accessor : null;
  }

  getVaryingInfo(locationOrName) {
    const location = Number(locationOrName);

    if (Number.isFinite(location)) {
      return this.varyingInfos[location];
    }

    return this.varyingInfosByName[locationOrName] || null;
  }

  getVaryingIndex(locationOrName) {
    const varying = this.getVaryingInfo();
    return varying ? varying.location : -1;
  }

  getVaryingAccessor(locationOrName) {
    const varying = this.getVaryingInfo();
    return varying ? varying.accessor : null;
  }

  _readAttributesFromProgram(program) {
    const {
      gl
    } = program;
    const count = gl.getProgramParameter(program.handle, 35721);

    for (let index = 0; index < count; index++) {
      const {
        name,
        type,
        size
      } = gl.getActiveAttrib(program.handle, index);
      const location = gl.getAttribLocation(program.handle, name);

      if (location >= 0) {
        this._addAttribute(location, name, type, size);
      }
    }

    this.attributeInfos.sort((a, b) => a.location - b.location);
  }

  _readVaryingsFromProgram(program) {
    const {
      gl
    } = program;

    if (!(0,esm/* isWebGL2 */.D0)(gl)) {
      return;
    }

    const count = gl.getProgramParameter(program.handle, 35971);

    for (let location = 0; location < count; location++) {
      const {
        name,
        type,
        size
      } = gl.getTransformFeedbackVarying(program.handle, location);

      this._addVarying(location, name, type, size);
    }

    this.varyingInfos.sort((a, b) => a.location - b.location);
  }

  _addAttribute(location, name, compositeType, size) {
    const {
      type,
      components
    } = (0,attribute_utils/* decomposeCompositeGLType */.hJ)(compositeType);
    const accessor = {
      type,
      size: size * components
    };

    this._inferProperties(location, name, accessor);

    const attributeInfo = {
      location,
      name,
      accessor: new classes_accessor/* default */.Z(accessor)
    };
    this.attributeInfos.push(attributeInfo);
    this.attributeInfosByLocation[location] = attributeInfo;
    this.attributeInfosByName[attributeInfo.name] = attributeInfo;
  }

  _inferProperties(location, name, accessor) {
    if (/instance/i.test(name)) {
      accessor.divisor = 1;
    }
  }

  _addVarying(location, name, compositeType, size) {
    const {
      type,
      components
    } = (0,attribute_utils/* decomposeCompositeGLType */.hJ)(compositeType);
    const accessor = new classes_accessor/* default */.Z({
      type,
      size: size * components
    });
    const varying = {
      location,
      name,
      accessor
    };
    this.varyingInfos.push(varying);
    this.varyingInfosByName[varying.name] = varying;
  }

}
//# sourceMappingURL=program-configuration.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/webgl-utils/constants-to-keys.js
var constants_to_keys = __webpack_require__(79579);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/program.js











const LOG_PROGRAM_PERF_PRIORITY = 4;
const GL_SEPARATE_ATTRIBS = 0x8c8d;
const V6_DEPRECATED_METHODS = ['setVertexArray', 'setAttributes', 'setBuffers', 'unsetBuffers', 'use', 'getUniformCount', 'getUniformInfo', 'getUniformLocation', 'getUniformValue', 'getVarying', 'getFragDataLocation', 'getAttachedShaders', 'getAttributeCount', 'getAttributeLocation', 'getAttributeInfo'];
class Program extends resource/* default */.Z {
  constructor(gl, props = {}) {
    super(gl, props);
    this.stubRemovedMethods('Program', 'v6.0', V6_DEPRECATED_METHODS);
    this._isCached = false;
    this.initialize(props);
    Object.seal(this);

    this._setId(props.id);
  }

  initialize(props = {}) {
    const {
      hash,
      vs,
      fs,
      varyings,
      bufferMode = GL_SEPARATE_ATTRIBS
    } = props;
    this.hash = hash || '';
    this.vs = typeof vs === 'string' ? new VertexShader(this.gl, {
      id: "".concat(props.id, "-vs"),
      source: vs
    }) : vs;
    this.fs = typeof fs === 'string' ? new FragmentShader(this.gl, {
      id: "".concat(props.id, "-fs"),
      source: fs
    }) : fs;
    (0,assert/* default */.Z)(this.vs instanceof VertexShader);
    (0,assert/* default */.Z)(this.fs instanceof FragmentShader);
    this.uniforms = {};
    this._textureUniforms = {};

    if (varyings && varyings.length > 0) {
      (0,esm/* assertWebGL2Context */.KQ)(this.gl);
      this.varyings = varyings;
      this.gl2.transformFeedbackVaryings(this.handle, varyings, bufferMode);
    }

    this._compileAndLink();

    this._readUniformLocationsFromLinkedProgram();

    this.configuration = new ProgramConfiguration(this);
    return this.setProps(props);
  }

  delete(options = {}) {
    if (this._isCached) {
      return this;
    }

    return super.delete(options);
  }

  setProps(props) {
    if ('uniforms' in props) {
      this.setUniforms(props.uniforms);
    }

    return this;
  }

  draw({
    logPriority,
    drawMode = 4,
    vertexCount,
    offset = 0,
    start,
    end,
    isIndexed = false,
    indexType = 5123,
    instanceCount = 0,
    isInstanced = instanceCount > 0,
    vertexArray = null,
    transformFeedback,
    framebuffer,
    parameters = {},
    uniforms,
    samplers
  }) {
    if (uniforms || samplers) {
      esm/* log.deprecated */.cM.deprecated('Program.draw({uniforms})', 'Program.setUniforms(uniforms)')();
      this.setUniforms(uniforms || {});
    }

    if (esm/* log.priority */.cM.priority >= logPriority) {
      const fb = framebuffer ? framebuffer.id : 'default';
      const message = "mode=".concat((0,constants_to_keys/* getKey */.km)(this.gl, drawMode), " verts=").concat(vertexCount, " ") + "instances=".concat(instanceCount, " indexType=").concat((0,constants_to_keys/* getKey */.km)(this.gl, indexType), " ") + "isInstanced=".concat(isInstanced, " isIndexed=").concat(isIndexed, " ") + "Framebuffer=".concat(fb);
      esm/* log.log */.cM.log(logPriority, message)();
    }

    (0,assert/* default */.Z)(vertexArray);
    this.gl.useProgram(this.handle);

    if (!this._areTexturesRenderable() || vertexCount === 0 || isInstanced && instanceCount === 0) {
      return false;
    }

    vertexArray.bindForDraw(vertexCount, instanceCount, () => {
      if (framebuffer !== undefined) {
        parameters = Object.assign({}, parameters, {
          framebuffer
        });
      }

      if (transformFeedback) {
        const primitiveMode = (0,attribute_utils/* getPrimitiveDrawMode */.$Z)(drawMode);
        transformFeedback.begin(primitiveMode);
      }

      this._bindTextures();

      (0,esm/* withParameters */.s8)(this.gl, parameters, () => {
        if (isIndexed && isInstanced) {
          this.gl2.drawElementsInstanced(drawMode, vertexCount, indexType, offset, instanceCount);
        } else if (isIndexed && (0,esm/* isWebGL2 */.D0)(this.gl) && !isNaN(start) && !isNaN(end)) {
          this.gl2.drawRangeElements(drawMode, start, end, vertexCount, indexType, offset);
        } else if (isIndexed) {
          this.gl.drawElements(drawMode, vertexCount, indexType, offset);
        } else if (isInstanced) {
          this.gl2.drawArraysInstanced(drawMode, offset, vertexCount, instanceCount);
        } else {
          this.gl.drawArrays(drawMode, offset, vertexCount);
        }
      });

      if (transformFeedback) {
        transformFeedback.end();
      }
    });
    return true;
  }

  setUniforms(uniforms = {}) {
    if (esm/* log.priority */.cM.priority >= 2) {
      checkUniformValues(uniforms, this.id, this._uniformSetters);
    }

    this.gl.useProgram(this.handle);

    for (const uniformName in uniforms) {
      const uniform = uniforms[uniformName];
      const uniformSetter = this._uniformSetters[uniformName];

      if (uniformSetter) {
        let value = uniform;
        let textureUpdate = false;

        if (value instanceof framebuffer/* default */.Z) {
          value = value.texture;
        }

        if (value instanceof texture/* default */.Z) {
          textureUpdate = this.uniforms[uniformName] !== uniform;

          if (textureUpdate) {
            if (uniformSetter.textureIndex === undefined) {
              uniformSetter.textureIndex = this._textureIndexCounter++;
            }

            const texture = value;
            const {
              textureIndex
            } = uniformSetter;
            texture.bind(textureIndex);
            value = textureIndex;
            this._textureUniforms[uniformName] = texture;
          } else {
            value = uniformSetter.textureIndex;
          }
        } else if (this._textureUniforms[uniformName]) {
          delete this._textureUniforms[uniformName];
        }

        if (uniformSetter(value) || textureUpdate) {
          copyUniform(this.uniforms, uniformName, uniform);
        }
      }
    }

    return this;
  }

  _areTexturesRenderable() {
    let texturesRenderable = true;

    for (const uniformName in this._textureUniforms) {
      const texture = this._textureUniforms[uniformName];
      texture.update();
      texturesRenderable = texturesRenderable && texture.loaded;
    }

    return texturesRenderable;
  }

  _bindTextures() {
    for (const uniformName in this._textureUniforms) {
      const textureIndex = this._uniformSetters[uniformName].textureIndex;

      this._textureUniforms[uniformName].bind(textureIndex);
    }
  }

  _createHandle() {
    return this.gl.createProgram();
  }

  _deleteHandle() {
    this.gl.deleteProgram(this.handle);
  }

  _getOptionsFromHandle(handle) {
    const shaderHandles = this.gl.getAttachedShaders(handle);
    const opts = {};

    for (const shaderHandle of shaderHandles) {
      const type = this.gl.getShaderParameter(this.handle, 35663);

      switch (type) {
        case 35633:
          opts.vs = new VertexShader({
            handle: shaderHandle
          });
          break;

        case 35632:
          opts.fs = new FragmentShader({
            handle: shaderHandle
          });
          break;

        default:
      }
    }

    return opts;
  }

  _getParameter(pname) {
    return this.gl.getProgramParameter(this.handle, pname);
  }

  _setId(id) {
    if (!id) {
      const programName = this._getName();

      this.id = (0,utils/* uid */.hQ)(programName);
    }
  }

  _getName() {
    let programName = this.vs.getName() || this.fs.getName();
    programName = programName.replace(/shader/i, '');
    programName = programName ? "".concat(programName, "-program") : 'program';
    return programName;
  }

  _compileAndLink() {
    const {
      gl
    } = this;
    gl.attachShader(this.handle, this.vs.handle);
    gl.attachShader(this.handle, this.fs.handle);
    esm/* log.time */.cM.time(LOG_PROGRAM_PERF_PRIORITY, "linkProgram for ".concat(this._getName()))();
    gl.linkProgram(this.handle);
    esm/* log.timeEnd */.cM.timeEnd(LOG_PROGRAM_PERF_PRIORITY, "linkProgram for ".concat(this._getName()))();

    if (gl.debug || esm/* log.level */.cM.level > 0) {
      const linked = gl.getProgramParameter(this.handle, 35714);

      if (!linked) {
        throw new Error("Error linking: ".concat(gl.getProgramInfoLog(this.handle)));
      }

      gl.validateProgram(this.handle);
      const validated = gl.getProgramParameter(this.handle, 35715);

      if (!validated) {
        throw new Error("Error validating: ".concat(gl.getProgramInfoLog(this.handle)));
      }
    }
  }

  _readUniformLocationsFromLinkedProgram() {
    const {
      gl
    } = this;
    this._uniformSetters = {};
    this._uniformCount = this._getParameter(35718);

    for (let i = 0; i < this._uniformCount; i++) {
      const info = this.gl.getActiveUniform(this.handle, i);
      const {
        name
      } = parseUniformName(info.name);
      let location = gl.getUniformLocation(this.handle, name);
      this._uniformSetters[name] = getUniformSetter(gl, location, info);

      if (info.size > 1) {
        for (let l = 0; l < info.size; l++) {
          location = gl.getUniformLocation(this.handle, "".concat(name, "[").concat(l, "]"));
          this._uniformSetters["".concat(name, "[").concat(l, "]")] = getUniformSetter(gl, location, info);
        }
      }
    }

    this._textureIndexCounter = 0;
  }

  getActiveUniforms(uniformIndices, pname) {
    return this.gl2.getActiveUniforms(this.handle, uniformIndices, pname);
  }

  getUniformBlockIndex(blockName) {
    return this.gl2.getUniformBlockIndex(this.handle, blockName);
  }

  getActiveUniformBlockParameter(blockIndex, pname) {
    return this.gl2.getActiveUniformBlockParameter(this.handle, blockIndex, pname);
  }

  uniformBlockBinding(blockIndex, blockBinding) {
    this.gl2.uniformBlockBinding(this.handle, blockIndex, blockBinding);
  }

}
//# sourceMappingURL=program.js.map

/***/ }),

/***/ 49830:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Renderbuffer)
});

// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/resource.js
var resource = __webpack_require__(87577);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/renderbuffer-formats.js
const EXT_FLOAT_WEBGL2 = 'EXT_color_buffer_float';
/* harmony default export */ const renderbuffer_formats = ({
  [33189]: {
    bpp: 2
  },
  [33190]: {
    gl2: true,
    bpp: 3
  },
  [36012]: {
    gl2: true,
    bpp: 4
  },
  [36168]: {
    bpp: 1
  },
  [34041]: {
    bpp: 4
  },
  [35056]: {
    gl2: true,
    bpp: 4
  },
  [36013]: {
    gl2: true,
    bpp: 5
  },
  [32854]: {
    bpp: 2
  },
  [36194]: {
    bpp: 2
  },
  [32855]: {
    bpp: 2
  },
  [33321]: {
    gl2: true,
    bpp: 1
  },
  [33330]: {
    gl2: true,
    bpp: 1
  },
  [33329]: {
    gl2: true,
    bpp: 1
  },
  [33332]: {
    gl2: true,
    bpp: 2
  },
  [33331]: {
    gl2: true,
    bpp: 2
  },
  [33334]: {
    gl2: true,
    bpp: 4
  },
  [33333]: {
    gl2: true,
    bpp: 4
  },
  [33323]: {
    gl2: true,
    bpp: 2
  },
  [33336]: {
    gl2: true,
    bpp: 2
  },
  [33335]: {
    gl2: true,
    bpp: 2
  },
  [33338]: {
    gl2: true,
    bpp: 4
  },
  [33337]: {
    gl2: true,
    bpp: 4
  },
  [33340]: {
    gl2: true,
    bpp: 8
  },
  [33339]: {
    gl2: true,
    bpp: 8
  },
  [32849]: {
    gl2: true,
    bpp: 3
  },
  [32856]: {
    gl2: true,
    bpp: 4
  },
  [32857]: {
    gl2: true,
    bpp: 4
  },
  [36220]: {
    gl2: true,
    bpp: 4
  },
  [36238]: {
    gl2: true,
    bpp: 4
  },
  [36975]: {
    gl2: true,
    bpp: 4
  },
  [36214]: {
    gl2: true,
    bpp: 8
  },
  [36232]: {
    gl2: true,
    bpp: 8
  },
  [36226]: {
    gl2: true,
    bpp: 16
  },
  [36208]: {
    gl2: true,
    bpp: 16
  },
  [33325]: {
    gl2: EXT_FLOAT_WEBGL2,
    bpp: 2
  },
  [33327]: {
    gl2: EXT_FLOAT_WEBGL2,
    bpp: 4
  },
  [34842]: {
    gl2: EXT_FLOAT_WEBGL2,
    bpp: 8
  },
  [33326]: {
    gl2: EXT_FLOAT_WEBGL2,
    bpp: 4
  },
  [33328]: {
    gl2: EXT_FLOAT_WEBGL2,
    bpp: 8
  },
  [34836]: {
    gl2: EXT_FLOAT_WEBGL2,
    bpp: 16
  },
  [35898]: {
    gl2: EXT_FLOAT_WEBGL2,
    bpp: 4
  }
});
//# sourceMappingURL=renderbuffer-formats.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/gltools/dist/esm/index.js + 13 modules
var esm = __webpack_require__(39450);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/assert.js
var assert = __webpack_require__(22525);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/renderbuffer.js





function isFormatSupported(gl, format, formats) {
  const info = formats[format];

  if (!info) {
    return false;
  }

  const value = (0,esm/* isWebGL2 */.D0)(gl) ? info.gl2 || info.gl1 : info.gl1;

  if (typeof value === 'string') {
    return gl.getExtension(value);
  }

  return value;
}

class Renderbuffer extends resource/* default */.Z {
  static isSupported(gl, {
    format
  } = {
    format: null
  }) {
    return !format || isFormatSupported(gl, format, renderbuffer_formats);
  }

  static getSamplesForFormat(gl, {
    format
  }) {
    return gl.getInternalformatParameter(36161, format, 32937);
  }

  constructor(gl, opts = {}) {
    super(gl, opts);
    this.initialize(opts);
    Object.seal(this);
  }

  initialize({
    format,
    width = 1,
    height = 1,
    samples = 0
  }) {
    (0,assert/* default */.Z)(format, 'Needs format');

    this._trackDeallocatedMemory();

    this.gl.bindRenderbuffer(36161, this.handle);

    if (samples !== 0 && (0,esm/* isWebGL2 */.D0)(this.gl)) {
      this.gl.renderbufferStorageMultisample(36161, samples, format, width, height);
    } else {
      this.gl.renderbufferStorage(36161, format, width, height);
    }

    this.format = format;
    this.width = width;
    this.height = height;
    this.samples = samples;

    this._trackAllocatedMemory(this.width * this.height * (this.samples || 1) * renderbuffer_formats[this.format].bpp);

    return this;
  }

  resize({
    width,
    height
  }) {
    if (width !== this.width || height !== this.height) {
      return this.initialize({
        width,
        height,
        format: this.format,
        samples: this.samples
      });
    }

    return this;
  }

  _createHandle() {
    return this.gl.createRenderbuffer();
  }

  _deleteHandle() {
    this.gl.deleteRenderbuffer(this.handle);

    this._trackDeallocatedMemory();
  }

  _bindHandle(handle) {
    this.gl.bindRenderbuffer(36161, handle);
  }

  _syncHandle(handle) {
    this.format = this.getParameter(36164);
    this.width = this.getParameter(36162);
    this.height = this.getParameter(36163);
    this.samples = this.getParameter(36011);
  }

  _getParameter(pname) {
    this.gl.bindRenderbuffer(36161, this.handle);
    const value = this.gl.getRenderbufferParameter(36161, pname);
    return value;
  }

}
//# sourceMappingURL=renderbuffer.js.map

/***/ }),

/***/ 87577:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Resource)
/* harmony export */ });
/* harmony import */ var _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39450);
/* harmony import */ var _init__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(49835);
/* harmony import */ var _webgl_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(79579);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(74538);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22525);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(37469);




const ERR_RESOURCE_METHOD_UNDEFINED = 'Resource subclass must define virtual methods';
class Resource {
  constructor(gl, opts = {}) {
    (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGLContext */ .JD)(gl);
    const {
      id,
      userData = {}
    } = opts;
    this.gl = gl;
    this.gl2 = gl;
    this.id = id || (0,_utils__WEBPACK_IMPORTED_MODULE_1__/* .uid */ .hQ)(this.constructor.name);
    this.userData = userData;
    this._bound = false;
    this._handle = opts.handle;

    if (this._handle === undefined) {
      this._handle = this._createHandle();
    }

    this.byteLength = 0;

    this._addStats();
  }

  toString() {
    return "".concat(this.constructor.name, "(").concat(this.id, ")");
  }

  get handle() {
    return this._handle;
  }

  delete({
    deleteChildren = false
  } = {}) {
    const children = this._handle && this._deleteHandle(this._handle);

    if (this._handle) {
      this._removeStats();
    }

    this._handle = null;

    if (children && deleteChildren) {
      children.filter(Boolean).forEach(child => child.delete());
    }

    return this;
  }

  bind(funcOrHandle = this.handle) {
    if (typeof funcOrHandle !== 'function') {
      this._bindHandle(funcOrHandle);

      return this;
    }

    let value;

    if (!this._bound) {
      this._bindHandle(this.handle);

      this._bound = true;
      value = funcOrHandle();
      this._bound = false;

      this._bindHandle(null);
    } else {
      value = funcOrHandle();
    }

    return value;
  }

  unbind() {
    this.bind(null);
  }

  getParameter(pname, opts = {}) {
    pname = (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_2__/* .getKeyValue */ .sF)(this.gl, pname);
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(pname);
    const parameters = this.constructor.PARAMETERS || {};
    const parameter = parameters[pname];

    if (parameter) {
      const isWebgl2 = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .isWebGL2 */ .D0)(this.gl);
      const parameterAvailable = (!('webgl2' in parameter) || isWebgl2) && (!('extension' in parameter) || this.gl.getExtension(parameter.extension));

      if (!parameterAvailable) {
        const webgl1Default = parameter.webgl1;
        const webgl2Default = 'webgl2' in parameter ? parameter.webgl2 : parameter.webgl1;
        const defaultValue = isWebgl2 ? webgl2Default : webgl1Default;
        return defaultValue;
      }
    }

    return this._getParameter(pname, opts);
  }

  getParameters(options = {}) {
    const {
      parameters,
      keys
    } = options;
    const PARAMETERS = this.constructor.PARAMETERS || {};
    const isWebgl2 = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .isWebGL2 */ .D0)(this.gl);
    const values = {};
    const parameterKeys = parameters || Object.keys(PARAMETERS);

    for (const pname of parameterKeys) {
      const parameter = PARAMETERS[pname];
      const parameterAvailable = parameter && (!('webgl2' in parameter) || isWebgl2) && (!('extension' in parameter) || this.gl.getExtension(parameter.extension));

      if (parameterAvailable) {
        const key = keys ? (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_2__/* .getKey */ .km)(this.gl, pname) : pname;
        values[key] = this.getParameter(pname, options);

        if (keys && parameter.type === 'GLenum') {
          values[key] = (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_2__/* .getKey */ .km)(this.gl, values[key]);
        }
      }
    }

    return values;
  }

  setParameter(pname, value) {
    pname = (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_2__/* .getKeyValue */ .sF)(this.gl, pname);
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(pname);
    const parameters = this.constructor.PARAMETERS || {};
    const parameter = parameters[pname];

    if (parameter) {
      const isWebgl2 = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .isWebGL2 */ .D0)(this.gl);
      const parameterAvailable = (!('webgl2' in parameter) || isWebgl2) && (!('extension' in parameter) || this.gl.getExtension(parameter.extension));

      if (!parameterAvailable) {
        throw new Error('Parameter not available on this platform');
      }

      if (parameter.type === 'GLenum') {
        value = (0,_webgl_utils__WEBPACK_IMPORTED_MODULE_2__/* .getKeyValue */ .sF)(value);
      }
    }

    this._setParameter(pname, value);

    return this;
  }

  setParameters(parameters) {
    for (const pname in parameters) {
      this.setParameter(pname, parameters[pname]);
    }

    return this;
  }

  stubRemovedMethods(className, version, methodNames) {
    return (0,_utils__WEBPACK_IMPORTED_MODULE_4__/* .stubRemovedMethods */ .F)(this, className, version, methodNames);
  }

  initialize(opts) {}

  _createHandle() {
    throw new Error(ERR_RESOURCE_METHOD_UNDEFINED);
  }

  _deleteHandle() {
    throw new Error(ERR_RESOURCE_METHOD_UNDEFINED);
  }

  _bindHandle(handle) {
    throw new Error(ERR_RESOURCE_METHOD_UNDEFINED);
  }

  _getOptsFromHandle() {
    throw new Error(ERR_RESOURCE_METHOD_UNDEFINED);
  }

  _getParameter(pname, opts) {
    throw new Error(ERR_RESOURCE_METHOD_UNDEFINED);
  }

  _setParameter(pname, value) {
    throw new Error(ERR_RESOURCE_METHOD_UNDEFINED);
  }

  _context() {
    this.gl.luma = this.gl.luma || {};
    return this.gl.luma;
  }

  _addStats() {
    const name = this.constructor.name;
    const stats = _init__WEBPACK_IMPORTED_MODULE_5__/* .lumaStats.get */ .l.get('Resource Counts');
    stats.get('Resources Created').incrementCount();
    stats.get("".concat(name, "s Created")).incrementCount();
    stats.get("".concat(name, "s Active")).incrementCount();
  }

  _removeStats() {
    const name = this.constructor.name;
    const stats = _init__WEBPACK_IMPORTED_MODULE_5__/* .lumaStats.get */ .l.get('Resource Counts');
    stats.get("".concat(name, "s Active")).decrementCount();
  }

  _trackAllocatedMemory(bytes, name = this.constructor.name) {
    const stats = _init__WEBPACK_IMPORTED_MODULE_5__/* .lumaStats.get */ .l.get('Memory Usage');
    stats.get('GPU Memory').addCount(bytes);
    stats.get("".concat(name, " Memory")).addCount(bytes);
    this.byteLength = bytes;
  }

  _trackDeallocatedMemory(name = this.constructor.name) {
    const stats = _init__WEBPACK_IMPORTED_MODULE_5__/* .lumaStats.get */ .l.get('Memory Usage');
    stats.get('GPU Memory').subtractCount(this.byteLength);
    stats.get("".concat(name, " Memory")).subtractCount(this.byteLength);
    this.byteLength = 0;
  }

}
//# sourceMappingURL=resource.js.map

/***/ }),

/***/ 4912:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Texture2D)
});

// EXTERNAL MODULE: ./node_modules/@luma.gl/gltools/dist/esm/index.js + 13 modules
var esm = __webpack_require__(39450);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture.js
var texture = __webpack_require__(35008);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/assert.js
var utils_assert = __webpack_require__(22525);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/load-file.js

let pathPrefix = '';
function setPathPrefix(prefix) {
  pathPrefix = prefix;
}
function loadFile(url, options = {}) {
  assert(typeof url === 'string');
  url = pathPrefix + url;
  const dataType = options.dataType || 'text';
  return fetch(url, options).then(res => res[dataType]());
}
function loadImage(url, opts) {
  (0,utils_assert/* default */.Z)(typeof url === 'string');
  url = pathPrefix + url;
  return new Promise((resolve, reject) => {
    try {
      const image = new Image();

      image.onload = () => resolve(image);

      image.onerror = () => reject(new Error("Could not load image ".concat(url, ".")));

      image.crossOrigin = opts && opts.crossOrigin || 'anonymous';
      image.src = url;
    } catch (error) {
      reject(error);
    }
  });
}
//# sourceMappingURL=load-file.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture-2d.js



class Texture2D extends texture/* default */.Z {
  static isSupported(gl, opts) {
    return texture/* default.isSupported */.Z.isSupported(gl, opts);
  }

  constructor(gl, props = {}) {
    (0,esm/* assertWebGLContext */.JD)(gl);

    if (props instanceof Promise || typeof props === 'string') {
      props = {
        data: props
      };
    }

    if (typeof props.data === 'string') {
      props = Object.assign({}, props, {
        data: loadImage(props.data)
      });
    }

    super(gl, Object.assign({}, props, {
      target: 3553
    }));
    this.initialize(props);
    Object.seal(this);
  }

}
//# sourceMappingURL=texture-2d.js.map

/***/ }),

/***/ 33889:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ae": () => (/* binding */ TEXTURE_FORMATS),
/* harmony export */   "C": () => (/* binding */ DATA_FORMAT_CHANNELS),
/* harmony export */   "pH": () => (/* binding */ TYPE_SIZES),
/* harmony export */   "br": () => (/* binding */ isFormatSupported),
/* harmony export */   "KR": () => (/* binding */ isLinearFilteringSupported)
/* harmony export */ });
/* harmony import */ var _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39450);

const TEXTURE_FORMATS = {
  [6407]: {
    dataFormat: 6407,
    types: [5121, 33635]
  },
  [6408]: {
    dataFormat: 6408,
    types: [5121, 32819, 32820]
  },
  [6406]: {
    dataFormat: 6406,
    types: [5121]
  },
  [6409]: {
    dataFormat: 6409,
    types: [5121]
  },
  [6410]: {
    dataFormat: 6410,
    types: [5121]
  },
  [33326]: {
    dataFormat: 6403,
    types: [5126],
    gl2: true
  },
  [33328]: {
    dataFormat: 33319,
    types: [5126],
    gl2: true
  },
  [34837]: {
    dataFormat: 6407,
    types: [5126],
    gl2: true
  },
  [34836]: {
    dataFormat: 6408,
    types: [5126],
    gl2: true
  }
};
const DATA_FORMAT_CHANNELS = {
  [6403]: 1,
  [36244]: 1,
  [33319]: 2,
  [33320]: 2,
  [6407]: 3,
  [36248]: 3,
  [6408]: 4,
  [36249]: 4,
  [6402]: 1,
  [34041]: 1,
  [6406]: 1,
  [6409]: 1,
  [6410]: 2
};
const TYPE_SIZES = {
  [5126]: 4,
  [5125]: 4,
  [5124]: 4,
  [5123]: 2,
  [5122]: 2,
  [5131]: 2,
  [5120]: 1,
  [5121]: 1
};
function isFormatSupported(gl, format) {
  const info = TEXTURE_FORMATS[format];

  if (!info) {
    return false;
  }

  if (info.gl1 === undefined && info.gl2 === undefined) {
    return true;
  }

  const value = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .isWebGL2 */ .D0)(gl) ? info.gl2 || info.gl1 : info.gl1;
  return typeof value === 'string' ? gl.getExtension(value) : value;
}
function isLinearFilteringSupported(gl, format) {
  const info = TEXTURE_FORMATS[format];

  switch (info && info.types[0]) {
    case 5126:
      return gl.getExtension('OES_texture_float_linear');

    case 5131:
      return gl.getExtension('OES_texture_half_float_linear');

    default:
      return true;
  }
}
//# sourceMappingURL=texture-formats.js.map

/***/ }),

/***/ 35008:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Texture)
/* harmony export */ });
/* harmony import */ var _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39450);
/* harmony import */ var probe_gl_env__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(89718);
/* harmony import */ var _resource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87577);
/* harmony import */ var _buffer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53478);
/* harmony import */ var _texture_formats__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33889);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74538);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22525);






const NPOT_MIN_FILTERS = [9729, 9728];

const WebGLBuffer = probe_gl_env__WEBPACK_IMPORTED_MODULE_1__/* .global.WebGLBuffer */ .CO.WebGLBuffer || function WebGLBuffer() {};

class Texture extends _resource__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z {
  static isSupported(gl, opts = {}) {
    const {
      format,
      linearFiltering
    } = opts;
    let supported = true;

    if (format) {
      supported = supported && (0,_texture_formats__WEBPACK_IMPORTED_MODULE_3__/* .isFormatSupported */ .br)(gl, format);
      supported = supported && (!linearFiltering || (0,_texture_formats__WEBPACK_IMPORTED_MODULE_3__/* .isLinearFilteringSupported */ .KR)(gl, format));
    }

    return supported;
  }

  constructor(gl, props) {
    const {
      id = (0,_utils__WEBPACK_IMPORTED_MODULE_4__/* .uid */ .hQ)('texture'),
      handle,
      target
    } = props;
    super(gl, {
      id,
      handle
    });
    this.target = target;
    this.textureUnit = undefined;
    this.loaded = false;
    this.width = undefined;
    this.height = undefined;
    this.depth = undefined;
    this.format = undefined;
    this.type = undefined;
    this.dataFormat = undefined;
    this.border = undefined;
    this.textureUnit = undefined;
    this.mipmaps = undefined;
  }

  toString() {
    return "Texture(".concat(this.id, ",").concat(this.width, "x").concat(this.height, ")");
  }

  initialize(props = {}) {
    let data = props.data;

    if (data instanceof Promise) {
      data.then(resolvedImageData => this.initialize(Object.assign({}, props, {
        pixels: resolvedImageData,
        data: resolvedImageData
      })));
      return this;
    }

    const isVideo = typeof HTMLVideoElement !== 'undefined' && data instanceof HTMLVideoElement;

    if (isVideo && data.readyState < HTMLVideoElement.HAVE_METADATA) {
      this._video = null;
      data.addEventListener('loadeddata', () => this.initialize(props));
      return this;
    }

    const {
      pixels = null,
      format = 6408,
      border = 0,
      recreate = false,
      parameters = {},
      pixelStore = {},
      textureUnit = undefined
    } = props;

    if (!data) {
      data = pixels;
    }

    let {
      width,
      height,
      dataFormat,
      type,
      compressed = false,
      mipmaps = true
    } = props;
    const {
      depth = 0
    } = props;
    ({
      width,
      height,
      compressed,
      dataFormat,
      type
    } = this._deduceParameters({
      format,
      type,
      dataFormat,
      compressed,
      data,
      width,
      height
    }));
    this.width = width;
    this.height = height;
    this.depth = depth;
    this.format = format;
    this.type = type;
    this.dataFormat = dataFormat;
    this.border = border;
    this.textureUnit = textureUnit;

    if (Number.isFinite(this.textureUnit)) {
      this.gl.activeTexture(33984 + this.textureUnit);
      this.gl.bindTexture(this.target, this.handle);
    }

    if (mipmaps && this._isNPOT()) {
      _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.warn */ .cM.warn("texture: ".concat(this, " is Non-Power-Of-Two, disabling mipmaping"))();
      mipmaps = false;

      this._updateForNPOT(parameters);
    }

    this.mipmaps = mipmaps;
    this.setImageData({
      data,
      width,
      height,
      depth,
      format,
      type,
      dataFormat,
      border,
      mipmaps,
      parameters: pixelStore,
      compressed
    });

    if (mipmaps) {
      this.generateMipmap();
    }

    this.setParameters(parameters);

    if (recreate) {
      this.data = data;
    }

    if (isVideo) {
      this._video = {
        video: data,
        parameters,
        lastTime: data.readyState >= HTMLVideoElement.HAVE_CURRENT_DATA ? data.currentTime : -1
      };
    }

    return this;
  }

  update() {
    if (this._video) {
      const {
        video,
        parameters,
        lastTime
      } = this._video;

      if (lastTime === video.currentTime || video.readyState < HTMLVideoElement.HAVE_CURRENT_DATA) {
        return;
      }

      this.setSubImageData({
        data: video,
        parameters
      });

      if (this.mipmaps) {
        this.generateMipmap();
      }

      this._video.lastTime = video.currentTime;
    }
  }

  resize({
    height,
    width,
    mipmaps = false
  }) {
    if (width !== this.width || height !== this.height) {
      return this.initialize({
        width,
        height,
        format: this.format,
        type: this.type,
        dataFormat: this.dataFormat,
        border: this.border,
        mipmaps
      });
    }

    return this;
  }

  generateMipmap(params = {}) {
    if (this._isNPOT()) {
      _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.warn */ .cM.warn("texture: ".concat(this, " is Non-Power-Of-Two, disabling mipmaping"))();
      return this;
    }

    this.mipmaps = true;
    this.gl.bindTexture(this.target, this.handle);
    (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .withParameters */ .s8)(this.gl, params, () => {
      this.gl.generateMipmap(this.target);
    });
    this.gl.bindTexture(this.target, null);
    return this;
  }

  setImageData(options) {
    this._trackDeallocatedMemory('Texture');

    const {
      target = this.target,
      pixels = null,
      level = 0,
      format = this.format,
      border = this.border,
      offset = 0,
      parameters = {}
    } = options;
    let {
      data = null,
      type = this.type,
      width = this.width,
      height = this.height,
      dataFormat = this.dataFormat,
      compressed = false
    } = options;

    if (!data) {
      data = pixels;
    }

    ({
      type,
      dataFormat,
      compressed,
      width,
      height
    } = this._deduceParameters({
      format,
      type,
      dataFormat,
      compressed,
      data,
      width,
      height
    }));
    const {
      gl
    } = this;
    gl.bindTexture(this.target, this.handle);
    let dataType = null;
    ({
      data,
      dataType
    } = this._getDataType({
      data,
      compressed
    }));
    let gl2;
    (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .withParameters */ .s8)(this.gl, parameters, () => {
      switch (dataType) {
        case 'null':
          gl.texImage2D(target, level, format, width, height, border, dataFormat, type, data);
          break;

        case 'typed-array':
          gl.texImage2D(target, level, format, width, height, border, dataFormat, type, data, offset);
          break;

        case 'buffer':
          gl2 = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(gl);
          gl2.bindBuffer(35052, data.handle || data);
          gl2.texImage2D(target, level, format, width, height, border, dataFormat, type, offset);
          gl2.bindBuffer(35052, null);
          break;

        case 'browser-object':
          if ((0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .isWebGL2 */ .D0)(gl)) {
            gl.texImage2D(target, level, format, width, height, border, dataFormat, type, data);
          } else {
            gl.texImage2D(target, level, format, dataFormat, type, data);
          }

          break;

        case 'compressed':
          for (const [levelIndex, levelData] of data.entries()) {
            gl.compressedTexImage2D(target, levelIndex, levelData.format, levelData.width, levelData.height, border, levelData.data);
          }

          break;

        default:
          (0,_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(false, 'Unknown image data type');
      }
    });

    if (data && data.byteLength) {
      this._trackAllocatedMemory(data.byteLength, 'Texture');
    } else {
      const channels = _texture_formats__WEBPACK_IMPORTED_MODULE_3__/* .DATA_FORMAT_CHANNELS */ .C[this.dataFormat] || 4;
      const channelSize = _texture_formats__WEBPACK_IMPORTED_MODULE_3__/* .TYPE_SIZES */ .pH[this.type] || 1;

      this._trackAllocatedMemory(this.width * this.height * channels * channelSize, 'Texture');
    }

    this.loaded = true;
    return this;
  }

  setSubImageData({
    target = this.target,
    pixels = null,
    data = null,
    x = 0,
    y = 0,
    width = this.width,
    height = this.height,
    level = 0,
    format = this.format,
    type = this.type,
    dataFormat = this.dataFormat,
    compressed = false,
    offset = 0,
    border = this.border,
    parameters = {}
  }) {
    ({
      type,
      dataFormat,
      compressed,
      width,
      height
    } = this._deduceParameters({
      format,
      type,
      dataFormat,
      compressed,
      data,
      width,
      height
    }));
    (0,_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(this.depth === 0, 'texSubImage not supported for 3D textures');

    if (!data) {
      data = pixels;
    }

    if (data && data.data) {
      const ndarray = data;
      data = ndarray.data;
      width = ndarray.shape[0];
      height = ndarray.shape[1];
    }

    if (data instanceof _buffer__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z) {
      data = data.handle;
    }

    this.gl.bindTexture(this.target, this.handle);
    (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .withParameters */ .s8)(this.gl, parameters, () => {
      if (compressed) {
        this.gl.compressedTexSubImage2D(target, level, x, y, width, height, format, data);
      } else if (data === null) {
        this.gl.texSubImage2D(target, level, x, y, width, height, dataFormat, type, null);
      } else if (ArrayBuffer.isView(data)) {
        this.gl.texSubImage2D(target, level, x, y, width, height, dataFormat, type, data, offset);
      } else if (data instanceof WebGLBuffer) {
        const gl2 = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(this.gl);
        gl2.bindBuffer(35052, data);
        gl2.texSubImage2D(target, level, x, y, width, height, dataFormat, type, offset);
        gl2.bindBuffer(35052, null);
      } else if ((0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .isWebGL2 */ .D0)(this.gl)) {
        const gl2 = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(this.gl);
        gl2.texSubImage2D(target, level, x, y, width, height, dataFormat, type, data);
      } else {
        this.gl.texSubImage2D(target, level, x, y, dataFormat, type, data);
      }
    });
    this.gl.bindTexture(this.target, null);
  }

  copyFramebuffer(opts = {}) {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.error */ .cM.error('Texture.copyFramebuffer({...}) is no logner supported, use copyToTexture(source, target, opts})')();
    return null;
  }

  getActiveUnit() {
    return this.gl.getParameter(34016) - 33984;
  }

  bind(textureUnit = this.textureUnit) {
    const {
      gl
    } = this;

    if (textureUnit !== undefined) {
      this.textureUnit = textureUnit;
      gl.activeTexture(33984 + textureUnit);
    }

    gl.bindTexture(this.target, this.handle);
    return textureUnit;
  }

  unbind(textureUnit = this.textureUnit) {
    const {
      gl
    } = this;

    if (textureUnit !== undefined) {
      this.textureUnit = textureUnit;
      gl.activeTexture(33984 + textureUnit);
    }

    gl.bindTexture(this.target, null);
    return textureUnit;
  }

  _getDataType({
    data,
    compressed = false
  }) {
    if (compressed) {
      return {
        data,
        dataType: 'compressed'
      };
    }

    if (data === null) {
      return {
        data,
        dataType: 'null'
      };
    }

    if (ArrayBuffer.isView(data)) {
      return {
        data,
        dataType: 'typed-array'
      };
    }

    if (data instanceof _buffer__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z) {
      return {
        data: data.handle,
        dataType: 'buffer'
      };
    }

    if (data instanceof WebGLBuffer) {
      return {
        data,
        dataType: 'buffer'
      };
    }

    return {
      data,
      dataType: 'browser-object'
    };
  }

  _deduceParameters(opts) {
    const {
      format,
      data
    } = opts;
    let {
      width,
      height,
      dataFormat,
      type,
      compressed
    } = opts;
    const textureFormat = _texture_formats__WEBPACK_IMPORTED_MODULE_3__/* .TEXTURE_FORMATS */ .ae[format];
    dataFormat = dataFormat || textureFormat && textureFormat.dataFormat;
    type = type || textureFormat && textureFormat.types[0];
    compressed = compressed || textureFormat && textureFormat.compressed;
    ({
      width,
      height
    } = this._deduceImageSize(data, width, height));
    return {
      dataFormat,
      type,
      compressed,
      width,
      height,
      format,
      data
    };
  }

  _deduceImageSize(data, width, height) {
    let size;

    if (typeof ImageData !== 'undefined' && data instanceof ImageData) {
      size = {
        width: data.width,
        height: data.height
      };
    } else if (typeof HTMLImageElement !== 'undefined' && data instanceof HTMLImageElement) {
      size = {
        width: data.naturalWidth,
        height: data.naturalHeight
      };
    } else if (typeof HTMLCanvasElement !== 'undefined' && data instanceof HTMLCanvasElement) {
      size = {
        width: data.width,
        height: data.height
      };
    } else if (typeof ImageBitmap !== 'undefined' && data instanceof ImageBitmap) {
      size = {
        width: data.width,
        height: data.height
      };
    } else if (typeof HTMLVideoElement !== 'undefined' && data instanceof HTMLVideoElement) {
      size = {
        width: data.videoWidth,
        height: data.videoHeight
      };
    } else if (!data) {
      size = {
        width: width >= 0 ? width : 1,
        height: height >= 0 ? height : 1
      };
    } else {
      size = {
        width,
        height
      };
    }

    (0,_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(size, 'Could not deduced texture size');
    (0,_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(width === undefined || size.width === width, 'Deduced texture width does not match supplied width');
    (0,_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(height === undefined || size.height === height, 'Deduced texture height does not match supplied height');
    return size;
  }

  _createHandle() {
    return this.gl.createTexture();
  }

  _deleteHandle() {
    this.gl.deleteTexture(this.handle);

    this._trackDeallocatedMemory('Texture');
  }

  _getParameter(pname) {
    switch (pname) {
      case 4096:
        return this.width;

      case 4097:
        return this.height;

      default:
        this.gl.bindTexture(this.target, this.handle);
        const value = this.gl.getTexParameter(this.target, pname);
        this.gl.bindTexture(this.target, null);
        return value;
    }
  }

  _setParameter(pname, param) {
    this.gl.bindTexture(this.target, this.handle);
    param = this._getNPOTParam(pname, param);

    switch (pname) {
      case 33082:
      case 33083:
        this.gl.texParameterf(this.handle, pname, param);
        break;

      case 4096:
      case 4097:
        (0,_utils__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(false);
        break;

      default:
        this.gl.texParameteri(this.target, pname, param);
        break;
    }

    this.gl.bindTexture(this.target, null);
    return this;
  }

  _isNPOT() {
    if ((0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .isWebGL2 */ .D0)(this.gl)) {
      return false;
    }

    if (!this.width || !this.height) {
      return false;
    }

    return !(0,_utils__WEBPACK_IMPORTED_MODULE_4__/* .isPowerOfTwo */ .wt)(this.width) || !(0,_utils__WEBPACK_IMPORTED_MODULE_4__/* .isPowerOfTwo */ .wt)(this.height);
  }

  _updateForNPOT(parameters) {
    if (parameters[this.gl.TEXTURE_MIN_FILTER] === undefined) {
      parameters[this.gl.TEXTURE_MIN_FILTER] = this.gl.LINEAR;
    }

    if (parameters[this.gl.TEXTURE_WRAP_S] === undefined) {
      parameters[this.gl.TEXTURE_WRAP_S] = this.gl.CLAMP_TO_EDGE;
    }

    if (parameters[this.gl.TEXTURE_WRAP_T] === undefined) {
      parameters[this.gl.TEXTURE_WRAP_T] = this.gl.CLAMP_TO_EDGE;
    }
  }

  _getNPOTParam(pname, param) {
    if (this._isNPOT()) {
      switch (pname) {
        case 10241:
          if (NPOT_MIN_FILTERS.indexOf(param) === -1) {
            param = 9729;
          }

          break;

        case 10242:
        case 10243:
          if (param !== 33071) {
            param = 33071;
          }

          break;

        default:
          break;
      }
    }

    return param;
  }

}
//# sourceMappingURL=texture.js.map

/***/ }),

/***/ 51053:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ TransformFeedback)
/* harmony export */ });
/* harmony import */ var _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39450);
/* harmony import */ var _resource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87577);
/* harmony import */ var _buffer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53478);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(74538);




class TransformFeedback extends _resource__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z {
  static isSupported(gl) {
    return (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .isWebGL2 */ .D0)(gl);
  }

  constructor(gl, props = {}) {
    (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .assertWebGL2Context */ .KQ)(gl);
    super(gl, props);
    this.initialize(props);
    this.stubRemovedMethods('TransformFeedback', 'v6.0', ['pause', 'resume']);
    Object.seal(this);
  }

  initialize(props = {}) {
    this.buffers = {};
    this.unused = {};
    this.configuration = null;
    this.bindOnUse = true;

    if (!(0,_utils__WEBPACK_IMPORTED_MODULE_2__/* .isObjectEmpty */ .nK)(this.buffers)) {
      this.bind(() => this._unbindBuffers());
    }

    this.setProps(props);
    return this;
  }

  setProps(props) {
    if ('program' in props) {
      this.configuration = props.program && props.program.configuration;
    }

    if ('configuration' in props) {
      this.configuration = props.configuration;
    }

    if ('bindOnUse' in props) {
      props = props.bindOnUse;
    }

    if ('buffers' in props) {
      this.setBuffers(props.buffers);
    }
  }

  setBuffers(buffers = {}) {
    this.bind(() => {
      for (const bufferName in buffers) {
        this.setBuffer(bufferName, buffers[bufferName]);
      }
    });
    return this;
  }

  setBuffer(locationOrName, bufferOrParams) {
    const location = this._getVaryingIndex(locationOrName);

    const {
      buffer,
      byteSize,
      byteOffset
    } = this._getBufferParams(bufferOrParams);

    if (location < 0) {
      this.unused[locationOrName] = buffer;
      _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.warn */ .cM.warn(() => "".concat(this.id, " unused varying buffer ").concat(locationOrName))();
      return this;
    }

    this.buffers[location] = bufferOrParams;

    if (!this.bindOnUse) {
      this._bindBuffer(location, buffer, byteOffset, byteSize);
    }

    return this;
  }

  begin(primitiveMode = 0) {
    this.gl.bindTransformFeedback(36386, this.handle);

    this._bindBuffers();

    this.gl.beginTransformFeedback(primitiveMode);
    return this;
  }

  end() {
    this.gl.endTransformFeedback();

    this._unbindBuffers();

    this.gl.bindTransformFeedback(36386, null);
    return this;
  }

  _getBufferParams(bufferOrParams) {
    let byteOffset;
    let byteSize;
    let buffer;

    if (bufferOrParams instanceof _buffer__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z === false) {
      buffer = bufferOrParams.buffer;
      byteSize = bufferOrParams.byteSize;
      byteOffset = bufferOrParams.byteOffset;
    } else {
      buffer = bufferOrParams;
    }

    if (byteOffset !== undefined || byteSize !== undefined) {
      byteOffset = byteOffset || 0;
      byteSize = byteSize || buffer.byteLength - byteOffset;
    }

    return {
      buffer,
      byteOffset,
      byteSize
    };
  }

  _getVaryingInfo(locationOrName) {
    return this.configuration && this.configuration.getVaryingInfo(locationOrName);
  }

  _getVaryingIndex(locationOrName) {
    if (this.configuration) {
      return this.configuration.getVaryingInfo(locationOrName).location;
    }

    const location = Number(locationOrName);
    return Number.isFinite(location) ? location : -1;
  }

  _bindBuffers() {
    if (this.bindOnUse) {
      for (const bufferIndex in this.buffers) {
        const {
          buffer,
          byteSize,
          byteOffset
        } = this._getBufferParams(this.buffers[bufferIndex]);

        this._bindBuffer(bufferIndex, buffer, byteOffset, byteSize);
      }
    }
  }

  _unbindBuffers() {
    if (this.bindOnUse) {
      for (const bufferIndex in this.buffers) {
        this._bindBuffer(bufferIndex, null);
      }
    }
  }

  _bindBuffer(index, buffer, byteOffset = 0, byteSize) {
    const handle = buffer && buffer.handle;

    if (!handle || byteSize === undefined) {
      this.gl.bindBufferBase(35982, index, handle);
    } else {
      this.gl.bindBufferRange(35982, index, handle, byteOffset, byteSize);
    }

    return this;
  }

  _createHandle() {
    return this.gl.createTransformFeedback();
  }

  _deleteHandle() {
    this.gl.deleteTransformFeedback(this.handle);
  }

  _bindHandle(handle) {
    this.gl.bindTransformFeedback(36386, this.handle);
  }

}
//# sourceMappingURL=transform-feedback.js.map

/***/ }),

/***/ 44211:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "U6": () => (/* binding */ hasFeature),
/* harmony export */   "ag": () => (/* binding */ hasFeatures),
/* harmony export */   "N$": () => (/* binding */ getFeatures)
/* harmony export */ });
/* harmony import */ var _webgl_features_table__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6948);
/* harmony import */ var _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39450);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22525);



const LOG_UNSUPPORTED_FEATURE = 2;
function hasFeature(gl, feature) {
  return hasFeatures(gl, feature);
}
function hasFeatures(gl, features) {
  features = Array.isArray(features) ? features : [features];
  return features.every(feature => {
    return isFeatureSupported(gl, feature);
  });
}
function getFeatures(gl) {
  gl.luma = gl.luma || {};
  gl.luma.caps = gl.luma.caps || {};

  for (const cap in _webgl_features_table__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z) {
    if (gl.luma.caps[cap] === undefined) {
      gl.luma.caps[cap] = isFeatureSupported(gl, cap);
    }
  }

  return gl.luma.caps;
}

function isFeatureSupported(gl, cap) {
  gl.luma = gl.luma || {};
  gl.luma.caps = gl.luma.caps || {};

  if (gl.luma.caps[cap] === undefined) {
    gl.luma.caps[cap] = queryFeature(gl, cap);
  }

  if (!gl.luma.caps[cap]) {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.log */ .cM.log(LOG_UNSUPPORTED_FEATURE, "Feature: ".concat(cap, " not supported"))();
  }

  return gl.luma.caps[cap];
}

function queryFeature(gl, cap) {
  const feature = _webgl_features_table__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z[cap];
  (0,_utils__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(feature, cap);
  let isSupported;
  const featureDefinition = (0,_luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .isWebGL2 */ .D0)(gl) ? feature[1] || feature[0] : feature[0];

  if (typeof featureDefinition === 'function') {
    isSupported = featureDefinition(gl);
  } else if (Array.isArray(featureDefinition)) {
    isSupported = true;

    for (const extension of featureDefinition) {
      isSupported = isSupported && Boolean(gl.getExtension(extension));
    }
  } else if (typeof featureDefinition === 'string') {
    isSupported = Boolean(gl.getExtension(featureDefinition));
  } else if (typeof featureDefinition === 'boolean') {
    isSupported = featureDefinition;
  } else {
    (0,_utils__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(false);
  }

  return isSupported;
}
//# sourceMappingURL=features.js.map

/***/ }),

/***/ 6948:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "h": () => (/* binding */ FEATURES),
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _classes_framebuffer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53849);
/* harmony import */ var _classes_texture_2d__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4912);


const FEATURES = {
  WEBGL2: 'WEBGL2',
  VERTEX_ARRAY_OBJECT: 'VERTEX_ARRAY_OBJECT',
  TIMER_QUERY: 'TIMER_QUERY',
  INSTANCED_RENDERING: 'INSTANCED_RENDERING',
  MULTIPLE_RENDER_TARGETS: 'MULTIPLE_RENDER_TARGETS',
  ELEMENT_INDEX_UINT32: 'ELEMENT_INDEX_UINT32',
  BLEND_EQUATION_MINMAX: 'BLEND_EQUATION_MINMAX',
  FLOAT_BLEND: 'FLOAT_BLEND',
  COLOR_ENCODING_SRGB: 'COLOR_ENCODING_SRGB',
  TEXTURE_DEPTH: 'TEXTURE_DEPTH',
  TEXTURE_FLOAT: 'TEXTURE_FLOAT',
  TEXTURE_HALF_FLOAT: 'TEXTURE_HALF_FLOAT',
  TEXTURE_FILTER_LINEAR_FLOAT: 'TEXTURE_FILTER_LINEAR_FLOAT',
  TEXTURE_FILTER_LINEAR_HALF_FLOAT: 'TEXTURE_FILTER_LINEAR_HALF_FLOAT',
  TEXTURE_FILTER_ANISOTROPIC: 'TEXTURE_FILTER_ANISOTROPIC',
  COLOR_ATTACHMENT_RGBA32F: 'COLOR_ATTACHMENT_RGBA32F',
  COLOR_ATTACHMENT_FLOAT: 'COLOR_ATTACHMENT_FLOAT',
  COLOR_ATTACHMENT_HALF_FLOAT: 'COLOR_ATTACHMENT_HALF_FLOAT',
  GLSL_FRAG_DATA: 'GLSL_FRAG_DATA',
  GLSL_FRAG_DEPTH: 'GLSL_FRAG_DEPTH',
  GLSL_DERIVATIVES: 'GLSL_DERIVATIVES',
  GLSL_TEXTURE_LOD: 'GLSL_TEXTURE_LOD'
};

function checkFloat32ColorAttachment(gl) {
  const testTexture = new _classes_texture_2d__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z(gl, {
    format: 6408,
    type: 5126,
    dataFormat: 6408
  });
  const testFb = new _classes_framebuffer__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z(gl, {
    id: "test-framebuffer",
    check: false,
    attachments: {
      [36064]: testTexture
    }
  });
  const status = testFb.getStatus();
  testTexture.delete();
  testFb.delete();
  return status === 36053;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  [FEATURES.WEBGL2]: [false, true],
  [FEATURES.VERTEX_ARRAY_OBJECT]: ['OES_vertex_array_object', true],
  [FEATURES.TIMER_QUERY]: ['EXT_disjoint_timer_query', 'EXT_disjoint_timer_query_webgl2'],
  [FEATURES.INSTANCED_RENDERING]: ['ANGLE_instanced_arrays', true],
  [FEATURES.MULTIPLE_RENDER_TARGETS]: ['WEBGL_draw_buffers', true],
  [FEATURES.ELEMENT_INDEX_UINT32]: ['OES_element_index_uint', true],
  [FEATURES.BLEND_EQUATION_MINMAX]: ['EXT_blend_minmax', true],
  [FEATURES.FLOAT_BLEND]: ['EXT_float_blend'],
  [FEATURES.COLOR_ENCODING_SRGB]: ['EXT_sRGB', true],
  [FEATURES.TEXTURE_DEPTH]: ['WEBGL_depth_texture', true],
  [FEATURES.TEXTURE_FLOAT]: ['OES_texture_float', true],
  [FEATURES.TEXTURE_HALF_FLOAT]: ['OES_texture_half_float', true],
  [FEATURES.TEXTURE_FILTER_LINEAR_FLOAT]: ['OES_texture_float_linear'],
  [FEATURES.TEXTURE_FILTER_LINEAR_HALF_FLOAT]: ['OES_texture_half_float_linear'],
  [FEATURES.TEXTURE_FILTER_ANISOTROPIC]: ['EXT_texture_filter_anisotropic'],
  [FEATURES.COLOR_ATTACHMENT_RGBA32F]: [checkFloat32ColorAttachment, 'EXT_color_buffer_float'],
  [FEATURES.COLOR_ATTACHMENT_FLOAT]: [false, 'EXT_color_buffer_float'],
  [FEATURES.COLOR_ATTACHMENT_HALF_FLOAT]: ['EXT_color_buffer_half_float'],
  [FEATURES.GLSL_FRAG_DATA]: ['WEBGL_draw_buffers', true],
  [FEATURES.GLSL_FRAG_DEPTH]: ['EXT_frag_depth', true],
  [FEATURES.GLSL_DERIVATIVES]: ['OES_standard_derivatives', true],
  [FEATURES.GLSL_TEXTURE_LOD]: ['EXT_shader_texture_lod', true]
});
//# sourceMappingURL=webgl-features-table.js.map

/***/ }),

/***/ 49835:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "l": () => (/* binding */ lumaStats)
/* harmony export */ });
/* harmony import */ var _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39450);
/* harmony import */ var probe_gl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26203);
/* harmony import */ var probe_gl_env__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(89718);



const VERSION =  true ? "8.5.4" : 0;
const STARTUP_MESSAGE = 'set luma.log.level=1 (or higher) to trace rendering';

class StatsManager {
  constructor() {
    this.stats = new Map();
  }

  get(name) {
    if (!this.stats.has(name)) {
      this.stats.set(name, new probe_gl__WEBPACK_IMPORTED_MODULE_1__/* .Stats */ .jk({
        id: name
      }));
    }

    return this.stats.get(name);
  }

}

const lumaStats = new StatsManager();

if (probe_gl_env__WEBPACK_IMPORTED_MODULE_2__/* .global.luma */ .CO.luma && probe_gl_env__WEBPACK_IMPORTED_MODULE_2__/* .global.luma.VERSION */ .CO.luma.VERSION !== VERSION) {
  throw new Error("luma.gl - multiple VERSIONs detected: ".concat(probe_gl_env__WEBPACK_IMPORTED_MODULE_2__/* .global.luma.VERSION */ .CO.luma.VERSION, " vs ").concat(VERSION));
}

if (!probe_gl_env__WEBPACK_IMPORTED_MODULE_2__/* .global.luma */ .CO.luma) {
  if ((0,probe_gl_env__WEBPACK_IMPORTED_MODULE_2__/* .isBrowser */ .jU)()) {
    _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.log */ .cM.log(1, "luma.gl ".concat(VERSION, " - ").concat(STARTUP_MESSAGE))();
  }

  probe_gl_env__WEBPACK_IMPORTED_MODULE_2__/* .global.luma */ .CO.luma = probe_gl_env__WEBPACK_IMPORTED_MODULE_2__/* .global.luma */ .CO.luma || {
    VERSION,
    version: VERSION,
    log: _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log */ .cM,
    stats: lumaStats,
    globals: {
      modules: {},
      nodeIO: {}
    }
  };
}


/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = (probe_gl_env__WEBPACK_IMPORTED_MODULE_2__/* .global.luma */ .CO.luma);
//# sourceMappingURL=init.js.map

/***/ }),

/***/ 22525:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ assert)
/* harmony export */ });
function assert(condition, message) {
  if (!condition) {
    throw new Error(message || 'luma.gl: assertion failed.');
  }
}
//# sourceMappingURL=assert.js.map

/***/ }),

/***/ 82610:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "k": () => (/* binding */ checkProps)
/* harmony export */ });
/* harmony import */ var _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39450);

function checkProps(className, props, propChecks) {
  const {
    removedProps = {},
    deprecatedProps = {},
    replacedProps = {}
  } = propChecks;

  for (const propName in removedProps) {
    if (propName in props) {
      const replacementProp = removedProps[propName];
      const replacement = replacementProp ? "".concat(className, ".").concat(removedProps[propName]) : 'N/A';
      _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.removed */ .cM.removed("".concat(className, ".").concat(propName), replacement)();
    }
  }

  for (const propName in deprecatedProps) {
    if (propName in props) {
      const replacementProp = deprecatedProps[propName];
      _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.deprecated */ .cM.deprecated("".concat(className, ".").concat(propName), "".concat(className, ".").concat(replacementProp))();
    }
  }

  let newProps = null;

  for (const propName in replacedProps) {
    if (propName in props) {
      const replacementProp = replacedProps[propName];
      _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.deprecated */ .cM.deprecated("".concat(className, ".").concat(propName), "".concat(className, ".").concat(replacementProp))();
      newProps = newProps || Object.assign({}, props);
      newProps[replacementProp] = props[propName];
      delete newProps[propName];
    }
  }

  return newProps || props;
}
//# sourceMappingURL=check-props.js.map

/***/ }),

/***/ 37469:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "F": () => (/* binding */ stubRemovedMethods)
/* harmony export */ });
/* harmony import */ var _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39450);

function stubRemovedMethods(instance, className, version, methodNames) {
  const upgradeMessage = "See luma.gl ".concat(version, " Upgrade Guide at https://luma.gl/docs/upgrade-guide");
  const prototype = Object.getPrototypeOf(instance);
  methodNames.forEach(methodName => {
    if (prototype.methodName) {
      return;
    }

    prototype[methodName] = () => {
      _luma_gl_gltools__WEBPACK_IMPORTED_MODULE_0__/* .log.removed */ .cM.removed("Calling removed method ".concat(className, ".").concat(methodName, ": "), upgradeMessage)();
      throw new Error(methodName);
    };
  });
}
//# sourceMappingURL=stub-methods.js.map

/***/ }),

/***/ 74538:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "hQ": () => (/* binding */ uid),
/* harmony export */   "wt": () => (/* binding */ isPowerOfTwo),
/* harmony export */   "nK": () => (/* binding */ isObjectEmpty)
/* harmony export */ });
/* harmony import */ var _assert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22525);

const uidCounters = {};
function uid(id = 'id') {
  uidCounters[id] = uidCounters[id] || 1;
  const count = uidCounters[id]++;
  return "".concat(id, "-").concat(count);
}
function isPowerOfTwo(n) {
  (0,_assert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)(typeof n === 'number', 'Input must be a number');
  return n && (n & n - 1) === 0;
}
function isObjectEmpty(obj) {
  let isEmpty = true;

  for (const key in obj) {
    isEmpty = false;
    break;
  }

  return isEmpty;
}
//# sourceMappingURL=utils.js.map

/***/ }),

/***/ 38522:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "$Z": () => (/* binding */ getPrimitiveDrawMode),
/* harmony export */   "hJ": () => (/* binding */ decomposeCompositeGLType),
/* harmony export */   "jG": () => (/* binding */ getCompositeGLType)
/* harmony export */ });
/* unused harmony exports getPrimitiveCount, getVertexCount */
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22525);

const GL_BYTE = 0x1400;
const GL_UNSIGNED_BYTE = 0x1401;
const GL_SHORT = 0x1402;
const GL_UNSIGNED_SHORT = 0x1403;
const GL_POINTS = 0x0;
const GL_LINES = 0x1;
const GL_LINE_LOOP = 0x2;
const GL_LINE_STRIP = 0x3;
const GL_TRIANGLES = 0x4;
const GL_TRIANGLE_STRIP = 0x5;
const GL_TRIANGLE_FAN = 0x6;
const GL_FLOAT = 0x1406;
const GL_FLOAT_VEC2 = 0x8b50;
const GL_FLOAT_VEC3 = 0x8b51;
const GL_FLOAT_VEC4 = 0x8b52;
const GL_INT = 0x1404;
const GL_INT_VEC2 = 0x8b53;
const GL_INT_VEC3 = 0x8b54;
const GL_INT_VEC4 = 0x8b55;
const GL_UNSIGNED_INT = 0x1405;
const GL_UNSIGNED_INT_VEC2 = 0x8dc6;
const GL_UNSIGNED_INT_VEC3 = 0x8dc7;
const GL_UNSIGNED_INT_VEC4 = 0x8dc8;
const GL_BOOL = 0x8b56;
const GL_BOOL_VEC2 = 0x8b57;
const GL_BOOL_VEC3 = 0x8b58;
const GL_BOOL_VEC4 = 0x8b59;
const GL_FLOAT_MAT2 = 0x8b5a;
const GL_FLOAT_MAT3 = 0x8b5b;
const GL_FLOAT_MAT4 = 0x8b5c;
const GL_FLOAT_MAT2x3 = 0x8b65;
const GL_FLOAT_MAT2x4 = 0x8b66;
const GL_FLOAT_MAT3x2 = 0x8b67;
const GL_FLOAT_MAT3x4 = 0x8b68;
const GL_FLOAT_MAT4x2 = 0x8b69;
const GL_FLOAT_MAT4x3 = 0x8b6a;
const COMPOSITE_GL_TYPES = {
  [GL_FLOAT]: [GL_FLOAT, 1, 'float'],
  [GL_FLOAT_VEC2]: [GL_FLOAT, 2, 'vec2'],
  [GL_FLOAT_VEC3]: [GL_FLOAT, 3, 'vec3'],
  [GL_FLOAT_VEC4]: [GL_FLOAT, 4, 'vec4'],
  [GL_INT]: [GL_INT, 1, 'int'],
  [GL_INT_VEC2]: [GL_INT, 2, 'ivec2'],
  [GL_INT_VEC3]: [GL_INT, 3, 'ivec3'],
  [GL_INT_VEC4]: [GL_INT, 4, 'ivec4'],
  [GL_UNSIGNED_INT]: [GL_UNSIGNED_INT, 1, 'uint'],
  [GL_UNSIGNED_INT_VEC2]: [GL_UNSIGNED_INT, 2, 'uvec2'],
  [GL_UNSIGNED_INT_VEC3]: [GL_UNSIGNED_INT, 3, 'uvec3'],
  [GL_UNSIGNED_INT_VEC4]: [GL_UNSIGNED_INT, 4, 'uvec4'],
  [GL_BOOL]: [GL_FLOAT, 1, 'bool'],
  [GL_BOOL_VEC2]: [GL_FLOAT, 2, 'bvec2'],
  [GL_BOOL_VEC3]: [GL_FLOAT, 3, 'bvec3'],
  [GL_BOOL_VEC4]: [GL_FLOAT, 4, 'bvec4'],
  [GL_FLOAT_MAT2]: [GL_FLOAT, 8, 'mat2'],
  [GL_FLOAT_MAT2x3]: [GL_FLOAT, 8, 'mat2x3'],
  [GL_FLOAT_MAT2x4]: [GL_FLOAT, 8, 'mat2x4'],
  [GL_FLOAT_MAT3]: [GL_FLOAT, 12, 'mat3'],
  [GL_FLOAT_MAT3x2]: [GL_FLOAT, 12, 'mat3x2'],
  [GL_FLOAT_MAT3x4]: [GL_FLOAT, 12, 'mat3x4'],
  [GL_FLOAT_MAT4]: [GL_FLOAT, 16, 'mat4'],
  [GL_FLOAT_MAT4x2]: [GL_FLOAT, 16, 'mat4x2'],
  [GL_FLOAT_MAT4x3]: [GL_FLOAT, 16, 'mat4x3']
};
function getPrimitiveDrawMode(drawMode) {
  switch (drawMode) {
    case GL_POINTS:
      return GL_POINTS;

    case GL_LINES:
      return GL_LINES;

    case GL_LINE_STRIP:
      return GL_LINES;

    case GL_LINE_LOOP:
      return GL_LINES;

    case GL_TRIANGLES:
      return GL_TRIANGLES;

    case GL_TRIANGLE_STRIP:
      return GL_TRIANGLES;

    case GL_TRIANGLE_FAN:
      return GL_TRIANGLES;

    default:
      (0,_utils__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)(false);
      return 0;
  }
}
function getPrimitiveCount({
  drawMode,
  vertexCount
}) {
  switch (drawMode) {
    case GL_POINTS:
    case GL_LINE_LOOP:
      return vertexCount;

    case GL_LINES:
      return vertexCount / 2;

    case GL_LINE_STRIP:
      return vertexCount - 1;

    case GL_TRIANGLES:
      return vertexCount / 3;

    case GL_TRIANGLE_STRIP:
    case GL_TRIANGLE_FAN:
      return vertexCount - 2;

    default:
      assert(false);
      return 0;
  }
}
function getVertexCount({
  drawMode,
  vertexCount
}) {
  const primitiveCount = getPrimitiveCount({
    drawMode,
    vertexCount
  });

  switch (getPrimitiveDrawMode(drawMode)) {
    case GL_POINTS:
      return primitiveCount;

    case GL_LINES:
      return primitiveCount * 2;

    case GL_TRIANGLES:
      return primitiveCount * 3;

    default:
      assert(false);
      return 0;
  }
}
function decomposeCompositeGLType(compositeGLType) {
  const typeAndSize = COMPOSITE_GL_TYPES[compositeGLType];

  if (!typeAndSize) {
    return null;
  }

  const [type, components] = typeAndSize;
  return {
    type,
    components
  };
}
function getCompositeGLType(type, components) {
  switch (type) {
    case GL_BYTE:
    case GL_UNSIGNED_BYTE:
    case GL_SHORT:
    case GL_UNSIGNED_SHORT:
      type = GL_FLOAT;
      break;

    default:
  }

  for (const glType in COMPOSITE_GL_TYPES) {
    const [compType, compComponents, name] = COMPOSITE_GL_TYPES[glType];

    if (compType === type && compComponents === components) {
      return {
        glType,
        name
      };
    }
  }

  return null;
}
//# sourceMappingURL=attribute-utils.js.map

/***/ }),

/***/ 79579:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "sF": () => (/* binding */ getKeyValue),
/* harmony export */   "km": () => (/* binding */ getKey)
/* harmony export */ });
/* unused harmony export getKeyType */
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22525);

function getKeyValue(gl, name) {
  if (typeof name !== 'string') {
    return name;
  }

  const number = Number(name);

  if (!isNaN(number)) {
    return number;
  }

  name = name.replace(/^.*\./, '');
  const value = gl[name];
  (0,_utils__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)(value !== undefined, "Accessing undefined constant GL.".concat(name));
  return value;
}
function getKey(gl, value) {
  value = Number(value);

  for (const key in gl) {
    if (gl[key] === value) {
      return "GL.".concat(key);
    }
  }

  return String(value);
}
function getKeyType(gl, value) {
  assert(value !== undefined, 'undefined key');
  value = Number(value);

  for (const key in gl) {
    if (gl[key] === value) {
      return "GL.".concat(key);
    }
  }

  return String(value);
}
//# sourceMappingURL=constants-to-keys.js.map

/***/ }),

/***/ 95432:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "h": () => (/* binding */ cloneTextureFrom),
  "Y": () => (/* binding */ toFramebuffer)
});

// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture-2d.js + 1 modules
var texture_2d = __webpack_require__(4912);
// EXTERNAL MODULE: ./node_modules/@luma.gl/gltools/dist/esm/index.js + 13 modules
var esm = __webpack_require__(39450);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture.js
var texture = __webpack_require__(35008);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture-cube.js


const FACES = [34069, 34070, 34071, 34072, 34073, 34074];
class TextureCube extends texture/* default */.Z {
  constructor(gl, props = {}) {
    (0,esm/* assertWebGLContext */.JD)(gl);
    super(gl, Object.assign({}, props, {
      target: 34067
    }));
    this.initialize(props);
    Object.seal(this);
  }

  initialize(props = {}) {
    const {
      mipmaps = true,
      parameters = {}
    } = props;
    this.opts = props;
    this.setCubeMapImageData(props).then(() => {
      this.loaded = true;

      if (mipmaps) {
        this.generateMipmap(props);
      }

      this.setParameters(parameters);
    });
    return this;
  }

  subImage({
    face,
    data,
    x = 0,
    y = 0,
    mipmapLevel = 0
  }) {
    return this._subImage({
      target: face,
      data,
      x,
      y,
      mipmapLevel
    });
  }

  async setCubeMapImageData({
    width,
    height,
    pixels,
    data,
    border = 0,
    format = 6408,
    type = 5121
  }) {
    const {
      gl
    } = this;
    const imageDataMap = pixels || data;
    const resolvedFaces = await Promise.all(FACES.map(face => {
      const facePixels = imageDataMap[face];
      return Promise.all(Array.isArray(facePixels) ? facePixels : [facePixels]);
    }));
    this.bind();
    FACES.forEach((face, index) => {
      if (resolvedFaces[index].length > 1 && this.opts.mipmaps !== false) {
        esm/* log.warn */.cM.warn("".concat(this.id, " has mipmap and multiple LODs."))();
      }

      resolvedFaces[index].forEach((image, lodLevel) => {
        if (width && height) {
          gl.texImage2D(face, lodLevel, format, width, height, border, format, type, image);
        } else {
          gl.texImage2D(face, lodLevel, format, format, type, image);
        }
      });
    });
    this.unbind();
  }

  setImageDataForFace(options) {
    const {
      face,
      width,
      height,
      pixels,
      data,
      border = 0,
      format = 6408,
      type = 5121
    } = options;
    const {
      gl
    } = this;
    const imageData = pixels || data;
    this.bind();

    if (imageData instanceof Promise) {
      imageData.then(resolvedImageData => this.setImageDataForFace(Object.assign({}, options, {
        face,
        data: resolvedImageData,
        pixels: resolvedImageData
      })));
    } else if (this.width || this.height) {
      gl.texImage2D(face, 0, format, width, height, border, format, type, imageData);
    } else {
      gl.texImage2D(face, 0, format, format, type, imageData);
    }

    return this;
  }

}
TextureCube.FACES = FACES;
//# sourceMappingURL=texture-cube.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture-formats.js
var texture_formats = __webpack_require__(33889);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/buffer.js
var buffer = __webpack_require__(53478);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture-3d.js




class Texture3D extends texture/* default */.Z {
  static isSupported(gl) {
    return (0,esm/* isWebGL2 */.D0)(gl);
  }

  constructor(gl, props = {}) {
    (0,esm/* assertWebGL2Context */.KQ)(gl);
    props = Object.assign({
      depth: 1
    }, props, {
      target: 32879,
      unpackFlipY: false
    });
    super(gl, props);
    this.initialize(props);
    Object.seal(this);
  }

  setImageData({
    level = 0,
    dataFormat = 6408,
    width,
    height,
    depth = 1,
    border = 0,
    format,
    type = 5121,
    offset = 0,
    data,
    parameters = {}
  }) {
    this._trackDeallocatedMemory('Texture');

    this.gl.bindTexture(this.target, this.handle);
    (0,esm/* withParameters */.s8)(this.gl, parameters, () => {
      if (ArrayBuffer.isView(data)) {
        this.gl.texImage3D(this.target, level, dataFormat, width, height, depth, border, format, type, data);
      }

      if (data instanceof buffer/* default */.Z) {
        this.gl.bindBuffer(35052, data.handle);
        this.gl.texImage3D(this.target, level, dataFormat, width, height, depth, border, format, type, offset);
      }
    });

    if (data && data.byteLength) {
      this._trackAllocatedMemory(data.byteLength, 'Texture');
    } else {
      const channels = texture_formats/* DATA_FORMAT_CHANNELS */.C[this.dataFormat] || 4;
      const channelSize = texture_formats/* TYPE_SIZES */.pH[this.type] || 1;

      this._trackAllocatedMemory(this.width * this.height * this.depth * channels * channelSize, 'Texture');
    }

    this.loaded = true;
    return this;
  }

}
//# sourceMappingURL=texture-3d.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/framebuffer.js
var classes_framebuffer = __webpack_require__(53849);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/assert.js
var assert = __webpack_require__(22525);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/webgl-utils/texture-utils.js





function cloneTextureFrom(refTexture, overrides) {
  (0,assert/* default */.Z)(refTexture instanceof texture_2d/* default */.Z || refTexture instanceof TextureCube || refTexture instanceof Texture3D);
  const TextureType = refTexture.constructor;
  const {
    gl,
    width,
    height,
    format,
    type,
    dataFormat,
    border,
    mipmaps
  } = refTexture;
  const textureOptions = Object.assign({
    width,
    height,
    format,
    type,
    dataFormat,
    border,
    mipmaps
  }, overrides);
  return new TextureType(gl, textureOptions);
}
function toFramebuffer(texture, opts) {
  const {
    gl,
    width,
    height,
    id
  } = texture;
  const framebuffer = new classes_framebuffer/* default */.Z(gl, Object.assign({}, opts, {
    id: "framebuffer-for-".concat(id),
    width,
    height,
    attachments: {
      [36064]: texture
    }
  }));
  return framebuffer;
}
//# sourceMappingURL=texture-utils.js.map

/***/ }),

/***/ 9335:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "O": () => (/* binding */ getGLTypeFromTypedArray),
/* harmony export */   "vN": () => (/* binding */ getTypedArrayFromGLType),
/* harmony export */   "c$": () => (/* binding */ flipRows),
/* harmony export */   "KS": () => (/* binding */ scalePixels)
/* harmony export */ });
const ERR_TYPE_DEDUCTION = 'Failed to deduce GL constant from typed array';
function getGLTypeFromTypedArray(arrayOrType) {
  const type = ArrayBuffer.isView(arrayOrType) ? arrayOrType.constructor : arrayOrType;

  switch (type) {
    case Float32Array:
      return 5126;

    case Uint16Array:
      return 5123;

    case Uint32Array:
      return 5125;

    case Uint8Array:
      return 5121;

    case Uint8ClampedArray:
      return 5121;

    case Int8Array:
      return 5120;

    case Int16Array:
      return 5122;

    case Int32Array:
      return 5124;

    default:
      throw new Error(ERR_TYPE_DEDUCTION);
  }
}
function getTypedArrayFromGLType(glType, {
  clamped = true
} = {}) {
  switch (glType) {
    case 5126:
      return Float32Array;

    case 5123:
    case 33635:
    case 32819:
    case 32820:
      return Uint16Array;

    case 5125:
      return Uint32Array;

    case 5121:
      return clamped ? Uint8ClampedArray : Uint8Array;

    case 5120:
      return Int8Array;

    case 5122:
      return Int16Array;

    case 5124:
      return Int32Array;

    default:
      throw new Error('Failed to deduce typed array type from GL constant');
  }
}
function flipRows({
  data,
  width,
  height,
  bytesPerPixel = 4,
  temp
}) {
  const bytesPerRow = width * bytesPerPixel;
  temp = temp || new Uint8Array(bytesPerRow);

  for (let y = 0; y < height / 2; ++y) {
    const topOffset = y * bytesPerRow;
    const bottomOffset = (height - y - 1) * bytesPerRow;
    temp.set(data.subarray(topOffset, topOffset + bytesPerRow));
    data.copyWithin(topOffset, bottomOffset, bottomOffset + bytesPerRow);
    data.set(temp, bottomOffset);
  }
}
function scalePixels({
  data,
  width,
  height
}) {
  const newWidth = Math.round(width / 2);
  const newHeight = Math.round(height / 2);
  const newData = new Uint8Array(newWidth * newHeight * 4);

  for (let y = 0; y < newHeight; y++) {
    for (let x = 0; x < newWidth; x++) {
      for (let c = 0; c < 4; c++) {
        newData[(y * newWidth + x) * 4 + c] = data[(y * 2 * width + x * 2) * 4 + c];
      }
    }
  }

  return {
    data: newData,
    width: newWidth,
    height: newHeight
  };
}
//# sourceMappingURL=typed-array-utils.js.map

/***/ }),

/***/ 6357:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ MathArray)
/* harmony export */ });
/* harmony import */ var _lib_common__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14034);
/* harmony import */ var _lib_assert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(50394);
function _extendableBuiltin(cls) {
  function ExtendableBuiltin() {
    var instance = Reflect.construct(cls, Array.from(arguments));
    Object.setPrototypeOf(instance, Object.getPrototypeOf(this));
    return instance;
  }

  ExtendableBuiltin.prototype = Object.create(cls.prototype, {
    constructor: {
      value: cls,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });

  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(ExtendableBuiltin, cls);
  } else {
    ExtendableBuiltin.__proto__ = cls;
  }

  return ExtendableBuiltin;
}



class MathArray extends _extendableBuiltin(Array) {
  get ELEMENTS() {
    (0,_lib_assert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)(false);
    return 0;
  }

  clone() {
    return new this.constructor().copy(this);
  }

  from(arrayOrObject) {
    return Array.isArray(arrayOrObject) ? this.copy(arrayOrObject) : this.fromObject(arrayOrObject);
  }

  fromArray(array, offset = 0) {
    for (let i = 0; i < this.ELEMENTS; ++i) {
      this[i] = array[i + offset];
    }

    return this.check();
  }

  to(arrayOrObject) {
    if (arrayOrObject === this) {
      return this;
    }

    return (0,_lib_common__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .kJ)(arrayOrObject) ? this.toArray(arrayOrObject) : this.toObject(arrayOrObject);
  }

  toTarget(target) {
    return target ? this.to(target) : this;
  }

  toArray(array = [], offset = 0) {
    for (let i = 0; i < this.ELEMENTS; ++i) {
      array[offset + i] = this[i];
    }

    return array;
  }

  toFloat32Array() {
    return new Float32Array(this);
  }

  toString() {
    return this.formatString(_lib_common__WEBPACK_IMPORTED_MODULE_1__/* .config */ .vc);
  }

  formatString(opts) {
    let string = '';

    for (let i = 0; i < this.ELEMENTS; ++i) {
      string += (i > 0 ? ', ' : '') + (0,_lib_common__WEBPACK_IMPORTED_MODULE_1__/* .formatValue */ .Bw)(this[i], opts);
    }

    return "".concat(opts.printTypes ? this.constructor.name : '', "[").concat(string, "]");
  }

  equals(array) {
    if (!array || this.length !== array.length) {
      return false;
    }

    for (let i = 0; i < this.ELEMENTS; ++i) {
      if (!(0,_lib_common__WEBPACK_IMPORTED_MODULE_1__/* .equals */ .fS)(this[i], array[i])) {
        return false;
      }
    }

    return true;
  }

  exactEquals(array) {
    if (!array || this.length !== array.length) {
      return false;
    }

    for (let i = 0; i < this.ELEMENTS; ++i) {
      if (this[i] !== array[i]) {
        return false;
      }
    }

    return true;
  }

  negate() {
    for (let i = 0; i < this.ELEMENTS; ++i) {
      this[i] = -this[i];
    }

    return this.check();
  }

  lerp(a, b, t) {
    if (t === undefined) {
      t = b;
      b = a;
      a = this;
    }

    for (let i = 0; i < this.ELEMENTS; ++i) {
      const ai = a[i];
      this[i] = ai + t * (b[i] - ai);
    }

    return this.check();
  }

  min(vector) {
    for (let i = 0; i < this.ELEMENTS; ++i) {
      this[i] = Math.min(vector[i], this[i]);
    }

    return this.check();
  }

  max(vector) {
    for (let i = 0; i < this.ELEMENTS; ++i) {
      this[i] = Math.max(vector[i], this[i]);
    }

    return this.check();
  }

  clamp(minVector, maxVector) {
    for (let i = 0; i < this.ELEMENTS; ++i) {
      this[i] = Math.min(Math.max(this[i], minVector[i]), maxVector[i]);
    }

    return this.check();
  }

  add(...vectors) {
    for (const vector of vectors) {
      for (let i = 0; i < this.ELEMENTS; ++i) {
        this[i] += vector[i];
      }
    }

    return this.check();
  }

  subtract(...vectors) {
    for (const vector of vectors) {
      for (let i = 0; i < this.ELEMENTS; ++i) {
        this[i] -= vector[i];
      }
    }

    return this.check();
  }

  scale(scale) {
    if (Array.isArray(scale)) {
      return this.multiply(scale);
    }

    for (let i = 0; i < this.ELEMENTS; ++i) {
      this[i] *= scale;
    }

    return this.check();
  }

  sub(a) {
    return this.subtract(a);
  }

  setScalar(a) {
    for (let i = 0; i < this.ELEMENTS; ++i) {
      this[i] = a;
    }

    return this.check();
  }

  addScalar(a) {
    for (let i = 0; i < this.ELEMENTS; ++i) {
      this[i] += a;
    }

    return this.check();
  }

  subScalar(a) {
    return this.addScalar(-a);
  }

  multiplyScalar(scalar) {
    for (let i = 0; i < this.ELEMENTS; ++i) {
      this[i] *= scalar;
    }

    return this.check();
  }

  divideScalar(a) {
    return this.scale(1 / a);
  }

  clampScalar(min, max) {
    for (let i = 0; i < this.ELEMENTS; ++i) {
      this[i] = Math.min(Math.max(this[i], min), max);
    }

    return this.check();
  }

  multiplyByScalar(scalar) {
    return this.scale(scalar);
  }

  get elements() {
    return this;
  }

  check() {
    if (_lib_common__WEBPACK_IMPORTED_MODULE_1__/* .config.debug */ .vc.debug && !this.validate()) {
      throw new Error("math.gl: ".concat(this.constructor.name, " some fields set to invalid numbers'"));
    }

    return this;
  }

  validate() {
    let valid = this.length === this.ELEMENTS;

    for (let i = 0; i < this.ELEMENTS; ++i) {
      valid = valid && Number.isFinite(this[i]);
    }

    return valid;
  }

}
//# sourceMappingURL=math-array.js.map

/***/ }),

/***/ 37293:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Matrix4)
});

// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/lib/validators.js
var validators = __webpack_require__(86281);
// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/classes/base/math-array.js
var math_array = __webpack_require__(6357);
// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/lib/common.js
var common = __webpack_require__(14034);
// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/lib/assert.js
var assert = __webpack_require__(50394);
;// CONCATENATED MODULE: ./node_modules/@math.gl/core/dist/esm/classes/base/matrix.js




class Matrix extends math_array/* default */.Z {
  get ELEMENTS() {
    (0,assert/* default */.Z)(false);
    return 0;
  }

  get RANK() {
    (0,assert/* default */.Z)(false);
    return 0;
  }

  toString() {
    let string = '[';

    if (common/* config.printRowMajor */.vc.printRowMajor) {
      string += 'row-major:';

      for (let row = 0; row < this.RANK; ++row) {
        for (let col = 0; col < this.RANK; ++col) {
          string += " ".concat(this[col * this.RANK + row]);
        }
      }
    } else {
      string += 'column-major:';

      for (let i = 0; i < this.ELEMENTS; ++i) {
        string += " ".concat(this[i]);
      }
    }

    string += ']';
    return string;
  }

  getElementIndex(row, col) {
    return col * this.RANK + row;
  }

  getElement(row, col) {
    return this[col * this.RANK + row];
  }

  setElement(row, col, value) {
    this[col * this.RANK + row] = (0,validators/* checkNumber */.u5)(value);
    return this;
  }

  getColumn(columnIndex, result = new Array(this.RANK).fill(-0)) {
    const firstIndex = columnIndex * this.RANK;

    for (let i = 0; i < this.RANK; ++i) {
      result[i] = this[firstIndex + i];
    }

    return result;
  }

  setColumn(columnIndex, columnVector) {
    const firstIndex = columnIndex * this.RANK;

    for (let i = 0; i < this.RANK; ++i) {
      this[firstIndex + i] = columnVector[i];
    }

    return this;
  }

}
//# sourceMappingURL=matrix.js.map
// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/lib/gl-matrix-extras.js
var gl_matrix_extras = __webpack_require__(1031);
// EXTERNAL MODULE: ./node_modules/gl-matrix/esm/mat4.js
var mat4 = __webpack_require__(85975);
// EXTERNAL MODULE: ./node_modules/gl-matrix/esm/vec2.js
var vec2 = __webpack_require__(31437);
// EXTERNAL MODULE: ./node_modules/gl-matrix/esm/vec3.js
var vec3 = __webpack_require__(77160);
// EXTERNAL MODULE: ./node_modules/gl-matrix/esm/vec4.js
var vec4 = __webpack_require__(7778);
;// CONCATENATED MODULE: ./node_modules/@math.gl/core/dist/esm/classes/matrix4.js







const IDENTITY = Object.freeze([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]);
const ZERO = Object.freeze([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);
const INDICES = Object.freeze({
  COL0ROW0: 0,
  COL0ROW1: 1,
  COL0ROW2: 2,
  COL0ROW3: 3,
  COL1ROW0: 4,
  COL1ROW1: 5,
  COL1ROW2: 6,
  COL1ROW3: 7,
  COL2ROW0: 8,
  COL2ROW1: 9,
  COL2ROW2: 10,
  COL2ROW3: 11,
  COL3ROW0: 12,
  COL3ROW1: 13,
  COL3ROW2: 14,
  COL3ROW3: 15
});
const constants = {};
class Matrix4 extends Matrix {
  static get IDENTITY() {
    constants.IDENTITY = constants.IDENTITY || Object.freeze(new Matrix4(IDENTITY));
    return constants.IDENTITY;
  }

  static get ZERO() {
    constants.ZERO = constants.ZERO || Object.freeze(new Matrix4(ZERO));
    return constants.ZERO;
  }

  get INDICES() {
    return INDICES;
  }

  get ELEMENTS() {
    return 16;
  }

  get RANK() {
    return 4;
  }

  constructor(array) {
    super(-0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0);

    if (arguments.length === 1 && Array.isArray(array)) {
      this.copy(array);
    } else {
      this.identity();
    }
  }

  copy(array) {
    this[0] = array[0];
    this[1] = array[1];
    this[2] = array[2];
    this[3] = array[3];
    this[4] = array[4];
    this[5] = array[5];
    this[6] = array[6];
    this[7] = array[7];
    this[8] = array[8];
    this[9] = array[9];
    this[10] = array[10];
    this[11] = array[11];
    this[12] = array[12];
    this[13] = array[13];
    this[14] = array[14];
    this[15] = array[15];
    return this.check();
  }

  set(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33) {
    this[0] = m00;
    this[1] = m10;
    this[2] = m20;
    this[3] = m30;
    this[4] = m01;
    this[5] = m11;
    this[6] = m21;
    this[7] = m31;
    this[8] = m02;
    this[9] = m12;
    this[10] = m22;
    this[11] = m32;
    this[12] = m03;
    this[13] = m13;
    this[14] = m23;
    this[15] = m33;
    return this.check();
  }

  setRowMajor(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33) {
    this[0] = m00;
    this[1] = m10;
    this[2] = m20;
    this[3] = m30;
    this[4] = m01;
    this[5] = m11;
    this[6] = m21;
    this[7] = m31;
    this[8] = m02;
    this[9] = m12;
    this[10] = m22;
    this[11] = m32;
    this[12] = m03;
    this[13] = m13;
    this[14] = m23;
    this[15] = m33;
    return this.check();
  }

  toRowMajor(result) {
    result[0] = this[0];
    result[1] = this[4];
    result[2] = this[8];
    result[3] = this[12];
    result[4] = this[1];
    result[5] = this[5];
    result[6] = this[9];
    result[7] = this[13];
    result[8] = this[2];
    result[9] = this[6];
    result[10] = this[10];
    result[11] = this[14];
    result[12] = this[3];
    result[13] = this[7];
    result[14] = this[11];
    result[15] = this[15];
    return result;
  }

  identity() {
    return this.copy(IDENTITY);
  }

  fromQuaternion(q) {
    mat4/* fromQuat */.en(this, q);
    return this.check();
  }

  frustum({
    left,
    right,
    bottom,
    top,
    near,
    far
  }) {
    if (far === Infinity) {
      Matrix4._computeInfinitePerspectiveOffCenter(this, left, right, bottom, top, near);
    } else {
      mat4/* frustum */.oy(this, left, right, bottom, top, near, far);
    }

    return this.check();
  }

  static _computeInfinitePerspectiveOffCenter(result, left, right, bottom, top, near) {
    const column0Row0 = 2.0 * near / (right - left);
    const column1Row1 = 2.0 * near / (top - bottom);
    const column2Row0 = (right + left) / (right - left);
    const column2Row1 = (top + bottom) / (top - bottom);
    const column2Row2 = -1.0;
    const column2Row3 = -1.0;
    const column3Row2 = -2.0 * near;
    result[0] = column0Row0;
    result[1] = 0.0;
    result[2] = 0.0;
    result[3] = 0.0;
    result[4] = 0.0;
    result[5] = column1Row1;
    result[6] = 0.0;
    result[7] = 0.0;
    result[8] = column2Row0;
    result[9] = column2Row1;
    result[10] = column2Row2;
    result[11] = column2Row3;
    result[12] = 0.0;
    result[13] = 0.0;
    result[14] = column3Row2;
    result[15] = 0.0;
    return result;
  }

  lookAt(eye, center, up) {
    if (arguments.length === 1) {
      ({
        eye,
        center,
        up
      } = eye);
    }

    center = center || [0, 0, 0];
    up = up || [0, 1, 0];
    mat4/* lookAt */.zB(this, eye, center, up);
    return this.check();
  }

  ortho({
    left,
    right,
    bottom,
    top,
    near = 0.1,
    far = 500
  }) {
    mat4/* ortho */.M5(this, left, right, bottom, top, near, far);
    return this.check();
  }

  orthographic({
    fovy = 45 * Math.PI / 180,
    aspect = 1,
    focalDistance = 1,
    near = 0.1,
    far = 500
  }) {
    if (fovy > Math.PI * 2) {
      throw Error('radians');
    }

    const halfY = fovy / 2;
    const top = focalDistance * Math.tan(halfY);
    const right = top * aspect;
    return new Matrix4().ortho({
      left: -right,
      right,
      bottom: -top,
      top,
      near,
      far
    });
  }

  perspective({
    fovy = undefined,
    fov = 45 * Math.PI / 180,
    aspect = 1,
    near = 0.1,
    far = 500
  } = {}) {
    fovy = fovy || fov;

    if (fovy > Math.PI * 2) {
      throw Error('radians');
    }

    mat4/* perspective */.G3(this, fovy, aspect, near, far);
    return this.check();
  }

  determinant() {
    return mat4/* determinant */.GH(this);
  }

  getScale(result = [-0, -0, -0]) {
    result[0] = Math.sqrt(this[0] * this[0] + this[1] * this[1] + this[2] * this[2]);
    result[1] = Math.sqrt(this[4] * this[4] + this[5] * this[5] + this[6] * this[6]);
    result[2] = Math.sqrt(this[8] * this[8] + this[9] * this[9] + this[10] * this[10]);
    return result;
  }

  getTranslation(result = [-0, -0, -0]) {
    result[0] = this[12];
    result[1] = this[13];
    result[2] = this[14];
    return result;
  }

  getRotation(result = [-0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0], scaleResult = null) {
    const scale = this.getScale(scaleResult || [-0, -0, -0]);
    const inverseScale0 = 1 / scale[0];
    const inverseScale1 = 1 / scale[1];
    const inverseScale2 = 1 / scale[2];
    result[0] = this[0] * inverseScale0;
    result[1] = this[1] * inverseScale1;
    result[2] = this[2] * inverseScale2;
    result[3] = 0;
    result[4] = this[4] * inverseScale0;
    result[5] = this[5] * inverseScale1;
    result[6] = this[6] * inverseScale2;
    result[7] = 0;
    result[8] = this[8] * inverseScale0;
    result[9] = this[9] * inverseScale1;
    result[10] = this[10] * inverseScale2;
    result[11] = 0;
    result[12] = 0;
    result[13] = 0;
    result[14] = 0;
    result[15] = 1;
    return result;
  }

  getRotationMatrix3(result = [-0, -0, -0, -0, -0, -0, -0, -0, -0], scaleResult = null) {
    const scale = this.getScale(scaleResult || [-0, -0, -0]);
    const inverseScale0 = 1 / scale[0];
    const inverseScale1 = 1 / scale[1];
    const inverseScale2 = 1 / scale[2];
    result[0] = this[0] * inverseScale0;
    result[1] = this[1] * inverseScale1;
    result[2] = this[2] * inverseScale2;
    result[3] = this[4] * inverseScale0;
    result[4] = this[5] * inverseScale1;
    result[5] = this[6] * inverseScale2;
    result[6] = this[8] * inverseScale0;
    result[7] = this[9] * inverseScale1;
    result[8] = this[10] * inverseScale2;
    return result;
  }

  transpose() {
    mat4/* transpose */.p4(this, this);
    return this.check();
  }

  invert() {
    mat4/* invert */.U_(this, this);
    return this.check();
  }

  multiplyLeft(a) {
    mat4/* multiply */.Jp(this, a, this);
    return this.check();
  }

  multiplyRight(a) {
    mat4/* multiply */.Jp(this, this, a);
    return this.check();
  }

  rotateX(radians) {
    mat4/* rotateX */.lM(this, this, radians);
    return this.check();
  }

  rotateY(radians) {
    mat4/* rotateY */.uD(this, this, radians);
    return this.check();
  }

  rotateZ(radians) {
    mat4/* rotateZ */.jI(this, this, radians);
    return this.check();
  }

  rotateXYZ([rx, ry, rz]) {
    return this.rotateX(rx).rotateY(ry).rotateZ(rz);
  }

  rotateAxis(radians, axis) {
    mat4/* rotate */.U1(this, this, radians, axis);
    return this.check();
  }

  scale(factor) {
    if (Array.isArray(factor)) {
      mat4/* scale */.bA(this, this, factor);
    } else {
      mat4/* scale */.bA(this, this, [factor, factor, factor]);
    }

    return this.check();
  }

  translate(vec) {
    mat4/* translate */.Iu(this, this, vec);
    return this.check();
  }

  transform(vector, result) {
    if (vector.length === 4) {
      result = vec4/* transformMat4 */.fF(result || [-0, -0, -0, -0], vector, this);
      (0,validators/* checkVector */.IL)(result, 4);
      return result;
    }

    return this.transformAsPoint(vector, result);
  }

  transformAsPoint(vector, result) {
    const {
      length
    } = vector;

    switch (length) {
      case 2:
        result = vec2/* transformMat4 */.fF(result || [-0, -0], vector, this);
        break;

      case 3:
        result = vec3/* transformMat4 */.fF(result || [-0, -0, -0], vector, this);
        break;

      default:
        throw new Error('Illegal vector');
    }

    (0,validators/* checkVector */.IL)(result, vector.length);
    return result;
  }

  transformAsVector(vector, result) {
    switch (vector.length) {
      case 2:
        result = (0,gl_matrix_extras/* vec2_transformMat4AsVector */.pb)(result || [-0, -0], vector, this);
        break;

      case 3:
        result = (0,gl_matrix_extras/* vec3_transformMat4AsVector */.pL)(result || [-0, -0, -0], vector, this);
        break;

      default:
        throw new Error('Illegal vector');
    }

    (0,validators/* checkVector */.IL)(result, vector.length);
    return result;
  }

  makeRotationX(radians) {
    return this.identity().rotateX(radians);
  }

  makeTranslation(x, y, z) {
    return this.identity().translate([x, y, z]);
  }

  transformPoint(vector, result) {
    (0,validators/* deprecated */.x9)('Matrix4.transformPoint', '3.0');
    return this.transformAsPoint(vector, result);
  }

  transformVector(vector, result) {
    (0,validators/* deprecated */.x9)('Matrix4.transformVector', '3.0');
    return this.transformAsPoint(vector, result);
  }

  transformDirection(vector, result) {
    (0,validators/* deprecated */.x9)('Matrix4.transformDirection', '3.0');
    return this.transformAsVector(vector, result);
  }

}
//# sourceMappingURL=matrix4.js.map

/***/ }),

/***/ 51681:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Vector3)
});

// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/classes/base/math-array.js
var math_array = __webpack_require__(6357);
// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/lib/validators.js
var validators = __webpack_require__(86281);
// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/lib/assert.js
var assert = __webpack_require__(50394);
;// CONCATENATED MODULE: ./node_modules/@math.gl/core/dist/esm/classes/base/vector.js



class Vector extends math_array/* default */.Z {
  get ELEMENTS() {
    (0,assert/* default */.Z)(false);
    return 0;
  }

  copy(vector) {
    (0,assert/* default */.Z)(false);
    return this;
  }

  get x() {
    return this[0];
  }

  set x(value) {
    this[0] = (0,validators/* checkNumber */.u5)(value);
  }

  get y() {
    return this[1];
  }

  set y(value) {
    this[1] = (0,validators/* checkNumber */.u5)(value);
  }

  len() {
    return Math.sqrt(this.lengthSquared());
  }

  magnitude() {
    return this.len();
  }

  lengthSquared() {
    let length = 0;

    for (let i = 0; i < this.ELEMENTS; ++i) {
      length += this[i] * this[i];
    }

    return length;
  }

  magnitudeSquared() {
    return this.lengthSquared();
  }

  distance(mathArray) {
    return Math.sqrt(this.distanceSquared(mathArray));
  }

  distanceSquared(mathArray) {
    let length = 0;

    for (let i = 0; i < this.ELEMENTS; ++i) {
      const dist = this[i] - mathArray[i];
      length += dist * dist;
    }

    return (0,validators/* checkNumber */.u5)(length);
  }

  dot(mathArray) {
    let product = 0;

    for (let i = 0; i < this.ELEMENTS; ++i) {
      product += this[i] * mathArray[i];
    }

    return (0,validators/* checkNumber */.u5)(product);
  }

  normalize() {
    const length = this.magnitude();

    if (length !== 0) {
      for (let i = 0; i < this.ELEMENTS; ++i) {
        this[i] /= length;
      }
    }

    return this.check();
  }

  multiply(...vectors) {
    for (const vector of vectors) {
      for (let i = 0; i < this.ELEMENTS; ++i) {
        this[i] *= vector[i];
      }
    }

    return this.check();
  }

  divide(...vectors) {
    for (const vector of vectors) {
      for (let i = 0; i < this.ELEMENTS; ++i) {
        this[i] /= vector[i];
      }
    }

    return this.check();
  }

  lengthSq() {
    return this.lengthSquared();
  }

  distanceTo(vector) {
    return this.distance(vector);
  }

  distanceToSquared(vector) {
    return this.distanceSquared(vector);
  }

  getComponent(i) {
    (0,assert/* default */.Z)(i >= 0 && i < this.ELEMENTS, 'index is out of range');
    return (0,validators/* checkNumber */.u5)(this[i]);
  }

  setComponent(i, value) {
    (0,assert/* default */.Z)(i >= 0 && i < this.ELEMENTS, 'index is out of range');
    this[i] = value;
    return this.check();
  }

  addVectors(a, b) {
    return this.copy(a).add(b);
  }

  subVectors(a, b) {
    return this.copy(a).subtract(b);
  }

  multiplyVectors(a, b) {
    return this.copy(a).multiply(b);
  }

  addScaledVector(a, b) {
    return this.add(new this.constructor(a).multiplyScalar(b));
  }

}
//# sourceMappingURL=vector.js.map
// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/lib/common.js
var common = __webpack_require__(14034);
// EXTERNAL MODULE: ./node_modules/gl-matrix/esm/vec3.js
var vec3 = __webpack_require__(77160);
// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/lib/gl-matrix-extras.js
var gl_matrix_extras = __webpack_require__(1031);
;// CONCATENATED MODULE: ./node_modules/@math.gl/core/dist/esm/classes/vector3.js





const ORIGIN = [0, 0, 0];
const constants = {};
class Vector3 extends Vector {
  static get ZERO() {
    return constants.ZERO = constants.ZERO || Object.freeze(new Vector3(0, 0, 0, 0));
  }

  constructor(x = 0, y = 0, z = 0) {
    super(-0, -0, -0);

    if (arguments.length === 1 && (0,common/* isArray */.kJ)(x)) {
      this.copy(x);
    } else {
      if (common/* config.debug */.vc.debug) {
        (0,validators/* checkNumber */.u5)(x);
        (0,validators/* checkNumber */.u5)(y);
        (0,validators/* checkNumber */.u5)(z);
      }

      this[0] = x;
      this[1] = y;
      this[2] = z;
    }
  }

  set(x, y, z) {
    this[0] = x;
    this[1] = y;
    this[2] = z;
    return this.check();
  }

  copy(array) {
    this[0] = array[0];
    this[1] = array[1];
    this[2] = array[2];
    return this.check();
  }

  fromObject(object) {
    if (common/* config.debug */.vc.debug) {
      (0,validators/* checkNumber */.u5)(object.x);
      (0,validators/* checkNumber */.u5)(object.y);
      (0,validators/* checkNumber */.u5)(object.z);
    }

    this[0] = object.x;
    this[1] = object.y;
    this[2] = object.z;
    return this.check();
  }

  toObject(object) {
    object.x = this[0];
    object.y = this[1];
    object.z = this[2];
    return object;
  }

  get ELEMENTS() {
    return 3;
  }

  get z() {
    return this[2];
  }

  set z(value) {
    this[2] = (0,validators/* checkNumber */.u5)(value);
  }

  angle(vector) {
    return vec3/* angle */.EU(this, vector);
  }

  cross(vector) {
    vec3/* cross */.kC(this, this, vector);
    return this.check();
  }

  rotateX({
    radians,
    origin = ORIGIN
  }) {
    vec3/* rotateX */.lM(this, this, origin, radians);
    return this.check();
  }

  rotateY({
    radians,
    origin = ORIGIN
  }) {
    vec3/* rotateY */.uD(this, this, origin, radians);
    return this.check();
  }

  rotateZ({
    radians,
    origin = ORIGIN
  }) {
    vec3/* rotateZ */.jI(this, this, origin, radians);
    return this.check();
  }

  transform(matrix4) {
    return this.transformAsPoint(matrix4);
  }

  transformAsPoint(matrix4) {
    vec3/* transformMat4 */.fF(this, this, matrix4);
    return this.check();
  }

  transformAsVector(matrix4) {
    (0,gl_matrix_extras/* vec3_transformMat4AsVector */.pL)(this, this, matrix4);
    return this.check();
  }

  transformByMatrix3(matrix3) {
    vec3/* transformMat3 */.kK(this, this, matrix3);
    return this.check();
  }

  transformByMatrix2(matrix2) {
    (0,gl_matrix_extras/* vec3_transformMat2 */.eQ)(this, this, matrix2);
    return this.check();
  }

  transformByQuaternion(quaternion) {
    vec3/* transformQuat */.VC(this, this, quaternion);
    return this.check();
  }

}
//# sourceMappingURL=vector3.js.map

/***/ }),

/***/ 50394:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ assert)
/* harmony export */ });
function assert(condition, message) {
  if (!condition) {
    throw new Error("math.gl assertion ".concat(message));
  }
}
//# sourceMappingURL=assert.js.map

/***/ }),

/***/ 14034:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "vc": () => (/* binding */ config),
/* harmony export */   "Bw": () => (/* binding */ formatValue),
/* harmony export */   "kJ": () => (/* binding */ isArray),
/* harmony export */   "uZ": () => (/* binding */ clamp),
/* harmony export */   "t7": () => (/* binding */ lerp),
/* harmony export */   "fS": () => (/* binding */ equals)
/* harmony export */ });
/* unused harmony exports configure, clone, toRadians, toDegrees, radians, degrees, sin, cos, tan, asin, acos, atan, exactEquals, withEpsilon */

const RADIANS_TO_DEGREES = 1 / Math.PI * 180;
const DEGREES_TO_RADIANS = 1 / 180 * Math.PI;
const config = {};
config.EPSILON = 1e-12;
config.debug = false;
config.precision = 4;
config.printTypes = false;
config.printDegrees = false;
config.printRowMajor = true;

function configure(options = {}) {
  for (const key in options) {
    assert(key in config);
    config[key] = options[key];
  }

  return config;
}

function round(value) {
  return Math.round(value / config.EPSILON) * config.EPSILON;
}

function formatValue(value, {
  precision = config.precision || 4
} = {}) {
  value = round(value);
  return "".concat(parseFloat(value.toPrecision(precision)));
}
function isArray(value) {
  return Array.isArray(value) || ArrayBuffer.isView(value) && !(value instanceof DataView);
}

function duplicateArray(array) {
  return array.clone ? array.clone() : new Array(array.length);
}

function clone(array) {
  return array.clone ? array.clone() : new Array(...array);
}

function map(value, func, result) {
  if (isArray(value)) {
    result = result || duplicateArray(value);

    for (let i = 0; i < result.length && i < value.length; ++i) {
      result[i] = func(value[i], i, result);
    }

    return result;
  }

  return func(value);
}

function toRadians(degrees) {
  return radians(degrees);
}
function toDegrees(radians) {
  return degrees(radians);
}
function radians(degrees, result) {
  return map(degrees, degrees => degrees * DEGREES_TO_RADIANS, result);
}
function degrees(radians, result) {
  return map(radians, radians => radians * RADIANS_TO_DEGREES, result);
}
function sin(radians) {
  return map(radians, angle => Math.sin(angle));
}
function cos(radians) {
  return map(radians, angle => Math.cos(angle));
}
function tan(radians) {
  return map(radians, angle => Math.tan(angle));
}
function asin(radians) {
  return map(radians, angle => Math.asin(angle));
}
function acos(radians) {
  return map(radians, angle => Math.acos(angle));
}
function atan(radians) {
  return map(radians, angle => Math.atan(angle));
}
function clamp(value, min, max) {
  return map(value, value => Math.max(min, Math.min(max, value)));
}
function lerp(a, b, t) {
  if (isArray(a)) {
    return a.map((ai, i) => lerp(ai, b[i], t));
  }

  return t * b + (1 - t) * a;
}
function equals(a, b, epsilon) {
  const oldEpsilon = config.EPSILON;

  if (epsilon) {
    config.EPSILON = epsilon;
  }

  try {
    if (a === b) {
      return true;
    }

    if (isArray(a) && isArray(b)) {
      if (a.length !== b.length) {
        return false;
      }

      for (let i = 0; i < a.length; ++i) {
        if (!equals(a[i], b[i])) {
          return false;
        }
      }

      return true;
    }

    if (a && a.equals) {
      return a.equals(b);
    }

    if (b && b.equals) {
      return b.equals(a);
    }

    if (Number.isFinite(a) && Number.isFinite(b)) {
      return Math.abs(a - b) <= config.EPSILON * Math.max(1.0, Math.abs(a), Math.abs(b));
    }

    return false;
  } finally {
    config.EPSILON = oldEpsilon;
  }
}
function exactEquals(a, b) {
  if (a === b) {
    return true;
  }

  if (a && typeof a === 'object' && b && typeof b === 'object') {
    if (a.constructor !== b.constructor) {
      return false;
    }

    if (a.exactEquals) {
      return a.exactEquals(b);
    }
  }

  if (isArray(a) && isArray(b)) {
    if (a.length !== b.length) {
      return false;
    }

    for (let i = 0; i < a.length; ++i) {
      if (!exactEquals(a[i], b[i])) {
        return false;
      }
    }

    return true;
  }

  return false;
}
function withEpsilon(EPSILON, func) {
  const oldPrecision = config.EPSILON;
  config.EPSILON = EPSILON;
  let value;

  try {
    value = func();
  } finally {
    config.EPSILON = oldPrecision;
  }

  return value;
}
//# sourceMappingURL=common.js.map

/***/ }),

/***/ 1031:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "pb": () => (/* binding */ vec2_transformMat4AsVector),
/* harmony export */   "pL": () => (/* binding */ vec3_transformMat4AsVector),
/* harmony export */   "eQ": () => (/* binding */ vec3_transformMat2)
/* harmony export */ });
/* unused harmony exports vec4_transformMat2, vec4_transformMat3 */
function vec2_transformMat4AsVector(out, a, m) {
  const x = a[0];
  const y = a[1];
  const w = m[3] * x + m[7] * y || 1.0;
  out[0] = (m[0] * x + m[4] * y) / w;
  out[1] = (m[1] * x + m[5] * y) / w;
  return out;
}
function vec3_transformMat4AsVector(out, a, m) {
  const x = a[0];
  const y = a[1];
  const z = a[2];
  const w = m[3] * x + m[7] * y + m[11] * z || 1.0;
  out[0] = (m[0] * x + m[4] * y + m[8] * z) / w;
  out[1] = (m[1] * x + m[5] * y + m[9] * z) / w;
  out[2] = (m[2] * x + m[6] * y + m[10] * z) / w;
  return out;
}
function vec3_transformMat2(out, a, m) {
  const x = a[0];
  const y = a[1];
  out[0] = m[0] * x + m[2] * y;
  out[1] = m[1] * x + m[3] * y;
  out[2] = a[2];
  return out;
}
function vec4_transformMat2(out, a, m) {
  const x = a[0];
  const y = a[1];
  out[0] = m[0] * x + m[2] * y;
  out[1] = m[1] * x + m[3] * y;
  out[2] = a[2];
  out[3] = a[3];
  return out;
}
function vec4_transformMat3(out, a, m) {
  const x = a[0];
  const y = a[1];
  const z = a[2];
  out[0] = m[0] * x + m[3] * y + m[6] * z;
  out[1] = m[1] * x + m[4] * y + m[7] * z;
  out[2] = m[2] * x + m[5] * y + m[8] * z;
  out[3] = a[3];
  return out;
}
//# sourceMappingURL=gl-matrix-extras.js.map

/***/ }),

/***/ 86281:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "u5": () => (/* binding */ checkNumber),
/* harmony export */   "IL": () => (/* binding */ checkVector),
/* harmony export */   "x9": () => (/* binding */ deprecated)
/* harmony export */ });
/* unused harmony export validateVector */
/* harmony import */ var _common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14034);

function validateVector(v, length) {
  if (v.length !== length) {
    return false;
  }

  for (let i = 0; i < v.length; ++i) {
    if (!Number.isFinite(v[i])) {
      return false;
    }
  }

  return true;
}
function checkNumber(value) {
  if (!Number.isFinite(value)) {
    throw new Error("Invalid number ".concat(value));
  }

  return value;
}
function checkVector(v, length, callerName = '') {
  if (_common__WEBPACK_IMPORTED_MODULE_0__/* .config.debug */ .vc.debug && !validateVector(v, length)) {
    throw new Error("math.gl: ".concat(callerName, " some fields set to invalid numbers'"));
  }

  return v;
}
const map = {};
function deprecated(method, version) {
  if (!map[method]) {
    map[method] = true;
    console.warn("".concat(method, " has been removed in version ").concat(version, ", see upgrade guide for more information"));
  }
}
//# sourceMappingURL=validators.js.map

/***/ }),

/***/ 17013:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "DW": () => (/* reexport */ WebMercatorViewport),
  "eG": () => (/* reexport */ addMetersToLngLat),
  "Xg": () => (/* reexport */ fitBounds),
  "if": () => (/* reexport */ flyToViewport),
  "zX": () => (/* reexport */ getBounds),
  "ro": () => (/* reexport */ getDistanceScales),
  "up": () => (/* reexport */ getFlyToDuration),
  "Bf": () => (/* reexport */ getMeterZoom),
  "wl": () => (/* reexport */ getProjectionParameters),
  "lf": () => (/* reexport */ getViewMatrix),
  "w5": () => (/* reexport */ lngLatToWorld),
  "QA": () => (/* reexport */ normalizeViewportProps),
  "CT": () => (/* reexport */ pixelsToWorld),
  "es": () => (/* reexport */ worldToLngLat),
  "aW": () => (/* reexport */ worldToPixels)
});

// UNUSED EXPORTS: altitudeToFovy, default, fovyToAltitude, getProjectionMatrix, scaleToZoom, zoomToScale

// EXTERNAL MODULE: ./node_modules/gl-matrix/esm/vec4.js
var vec4 = __webpack_require__(7778);
;// CONCATENATED MODULE: ./node_modules/@math.gl/web-mercator/dist/esm/math-utils.js

function createMat4() {
  return [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
}
function transformVector(matrix, vector) {
  const result = vec4/* transformMat4 */.fF([], vector, matrix);
  vec4/* scale */.bA(result, result, 1 / result[3]);
  return result;
}
function mod(value, divisor) {
  const modulus = value % divisor;
  return modulus < 0 ? divisor + modulus : modulus;
}
function lerp(start, end, step) {
  return step * end + (1 - step) * start;
}

function ieLog2(x) {
  return Math.log(x) * Math.LOG2E;
}

const log2 = Math.log2 || ieLog2;
//# sourceMappingURL=math-utils.js.map
// EXTERNAL MODULE: ./node_modules/gl-matrix/esm/mat4.js
var mat4 = __webpack_require__(85975);
// EXTERNAL MODULE: ./node_modules/gl-matrix/esm/vec2.js
var vec2 = __webpack_require__(31437);
// EXTERNAL MODULE: ./node_modules/gl-matrix/esm/vec3.js
var vec3 = __webpack_require__(77160);
;// CONCATENATED MODULE: ./node_modules/@math.gl/web-mercator/dist/esm/assert.js
function assert(condition, message) {
  if (!condition) {
    throw new Error(message || '@math.gl/web-mercator: assertion failed.');
  }
}
//# sourceMappingURL=assert.js.map
;// CONCATENATED MODULE: ./node_modules/@math.gl/web-mercator/dist/esm/web-mercator-utils.js





const PI = Math.PI;
const PI_4 = PI / 4;
const DEGREES_TO_RADIANS = PI / 180;
const RADIANS_TO_DEGREES = 180 / PI;
const TILE_SIZE = 512;
const EARTH_CIRCUMFERENCE = 40.03e6;
const DEFAULT_ALTITUDE = 1.5;
function zoomToScale(zoom) {
  return Math.pow(2, zoom);
}
function scaleToZoom(scale) {
  return log2(scale);
}
function lngLatToWorld([lng, lat]) {
  assert(Number.isFinite(lng));
  assert(Number.isFinite(lat) && lat >= -90 && lat <= 90, 'invalid latitude');
  const lambda2 = lng * DEGREES_TO_RADIANS;
  const phi2 = lat * DEGREES_TO_RADIANS;
  const x = TILE_SIZE * (lambda2 + PI) / (2 * PI);
  const y = TILE_SIZE * (PI + Math.log(Math.tan(PI_4 + phi2 * 0.5))) / (2 * PI);
  return [x, y];
}
function worldToLngLat([x, y]) {
  const lambda2 = x / TILE_SIZE * (2 * PI) - PI;
  const phi2 = 2 * (Math.atan(Math.exp(y / TILE_SIZE * (2 * PI) - PI)) - PI_4);
  return [lambda2 * RADIANS_TO_DEGREES, phi2 * RADIANS_TO_DEGREES];
}
function getMeterZoom({
  latitude
}) {
  assert(Number.isFinite(latitude));
  const latCosine = Math.cos(latitude * DEGREES_TO_RADIANS);
  return scaleToZoom(EARTH_CIRCUMFERENCE * latCosine) - 9;
}
function getDistanceScales({
  latitude,
  longitude,
  highPrecision = false
}) {
  assert(Number.isFinite(latitude) && Number.isFinite(longitude));
  const result = {};
  const worldSize = TILE_SIZE;
  const latCosine = Math.cos(latitude * DEGREES_TO_RADIANS);
  const unitsPerDegreeX = worldSize / 360;
  const unitsPerDegreeY = unitsPerDegreeX / latCosine;
  const altUnitsPerMeter = worldSize / EARTH_CIRCUMFERENCE / latCosine;
  result.unitsPerMeter = [altUnitsPerMeter, altUnitsPerMeter, altUnitsPerMeter];
  result.metersPerUnit = [1 / altUnitsPerMeter, 1 / altUnitsPerMeter, 1 / altUnitsPerMeter];
  result.unitsPerDegree = [unitsPerDegreeX, unitsPerDegreeY, altUnitsPerMeter];
  result.degreesPerUnit = [1 / unitsPerDegreeX, 1 / unitsPerDegreeY, 1 / altUnitsPerMeter];

  if (highPrecision) {
    const latCosine2 = DEGREES_TO_RADIANS * Math.tan(latitude * DEGREES_TO_RADIANS) / latCosine;
    const unitsPerDegreeY2 = unitsPerDegreeX * latCosine2 / 2;
    const altUnitsPerDegree2 = worldSize / EARTH_CIRCUMFERENCE * latCosine2;
    const altUnitsPerMeter2 = altUnitsPerDegree2 / unitsPerDegreeY * altUnitsPerMeter;
    result.unitsPerDegree2 = [0, unitsPerDegreeY2, altUnitsPerDegree2];
    result.unitsPerMeter2 = [altUnitsPerMeter2, 0, altUnitsPerMeter2];
  }

  return result;
}
function addMetersToLngLat(lngLatZ, xyz) {
  const [longitude, latitude, z0] = lngLatZ;
  const [x, y, z] = xyz;
  const {
    unitsPerMeter,
    unitsPerMeter2
  } = getDistanceScales({
    longitude,
    latitude,
    highPrecision: true
  });
  const worldspace = lngLatToWorld(lngLatZ);
  worldspace[0] += x * (unitsPerMeter[0] + unitsPerMeter2[0] * y);
  worldspace[1] += y * (unitsPerMeter[1] + unitsPerMeter2[1] * y);
  const newLngLat = worldToLngLat(worldspace);
  const newZ = (z0 || 0) + (z || 0);
  return Number.isFinite(z0) || Number.isFinite(z) ? [newLngLat[0], newLngLat[1], newZ] : newLngLat;
}
function getViewMatrix({
  height,
  pitch,
  bearing,
  altitude,
  scale,
  center = null
}) {
  const vm = createMat4();
  mat4/* translate */.Iu(vm, vm, [0, 0, -altitude]);
  mat4/* rotateX */.lM(vm, vm, -pitch * DEGREES_TO_RADIANS);
  mat4/* rotateZ */.jI(vm, vm, bearing * DEGREES_TO_RADIANS);
  scale /= height;
  mat4/* scale */.bA(vm, vm, [scale, scale, scale]);

  if (center) {
    mat4/* translate */.Iu(vm, vm, vec3/* negate */.tk([], center));
  }

  return vm;
}
function getProjectionParameters({
  width,
  height,
  fovy = altitudeToFovy(DEFAULT_ALTITUDE),
  altitude,
  pitch = 0,
  nearZMultiplier = 1,
  farZMultiplier = 1
}) {
  if (altitude !== undefined) {
    fovy = altitudeToFovy(altitude);
  }

  const halfFov = 0.5 * fovy * DEGREES_TO_RADIANS;
  const focalDistance = fovyToAltitude(fovy);
  const pitchRadians = pitch * DEGREES_TO_RADIANS;
  const topHalfSurfaceDistance = Math.sin(halfFov) * focalDistance / Math.sin(Math.min(Math.max(Math.PI / 2 - pitchRadians - halfFov, 0.01), Math.PI - 0.01));
  const farZ = Math.sin(pitchRadians) * topHalfSurfaceDistance + focalDistance;
  return {
    fov: 2 * halfFov,
    aspect: width / height,
    focalDistance,
    near: nearZMultiplier,
    far: farZ * farZMultiplier
  };
}
function getProjectionMatrix({
  width,
  height,
  pitch,
  altitude,
  fovy,
  nearZMultiplier,
  farZMultiplier
}) {
  const {
    fov,
    aspect,
    near,
    far
  } = getProjectionParameters({
    width,
    height,
    altitude,
    fovy,
    pitch,
    nearZMultiplier,
    farZMultiplier
  });
  const projectionMatrix = mat4/* perspective */.G3([], fov, aspect, near, far);
  return projectionMatrix;
}
function altitudeToFovy(altitude) {
  return 2 * Math.atan(0.5 / altitude) * RADIANS_TO_DEGREES;
}
function fovyToAltitude(fovy) {
  return 0.5 / Math.tan(0.5 * fovy * DEGREES_TO_RADIANS);
}
function worldToPixels(xyz, pixelProjectionMatrix) {
  const [x, y, z = 0] = xyz;
  assert(Number.isFinite(x) && Number.isFinite(y) && Number.isFinite(z));
  return transformVector(pixelProjectionMatrix, [x, y, z, 1]);
}
function pixelsToWorld(xyz, pixelUnprojectionMatrix, targetZ = 0) {
  const [x, y, z] = xyz;
  assert(Number.isFinite(x) && Number.isFinite(y), 'invalid pixel coordinate');

  if (Number.isFinite(z)) {
    const coord = transformVector(pixelUnprojectionMatrix, [x, y, z, 1]);
    return coord;
  }

  const coord0 = transformVector(pixelUnprojectionMatrix, [x, y, 0, 1]);
  const coord1 = transformVector(pixelUnprojectionMatrix, [x, y, 1, 1]);
  const z0 = coord0[2];
  const z1 = coord1[2];
  const t = z0 === z1 ? 0 : ((targetZ || 0) - z0) / (z1 - z0);
  return vec2/* lerp */.t7([], coord0, coord1, t);
}
//# sourceMappingURL=web-mercator-utils.js.map
;// CONCATENATED MODULE: ./node_modules/@math.gl/web-mercator/dist/esm/fit-bounds.js



function fitBounds({
  width,
  height,
  bounds,
  minExtent = 0,
  maxZoom = 24,
  padding = 0,
  offset = [0, 0]
}) {
  const [[west, south], [east, north]] = bounds;

  if (Number.isFinite(padding)) {
    const p = padding;
    padding = {
      top: p,
      bottom: p,
      left: p,
      right: p
    };
  } else {
    assert(Number.isFinite(padding.top) && Number.isFinite(padding.bottom) && Number.isFinite(padding.left) && Number.isFinite(padding.right));
  }

  const viewport = new WebMercatorViewport({
    width,
    height,
    longitude: 0,
    latitude: 0,
    zoom: 0
  });
  const nw = viewport.project([west, north]);
  const se = viewport.project([east, south]);
  const size = [Math.max(Math.abs(se[0] - nw[0]), minExtent), Math.max(Math.abs(se[1] - nw[1]), minExtent)];
  const targetSize = [width - padding.left - padding.right - Math.abs(offset[0]) * 2, height - padding.top - padding.bottom - Math.abs(offset[1]) * 2];
  assert(targetSize[0] > 0 && targetSize[1] > 0);
  const scaleX = targetSize[0] / size[0];
  const scaleY = targetSize[1] / size[1];
  const offsetX = (padding.right - padding.left) / 2 / scaleX;
  const offsetY = (padding.bottom - padding.top) / 2 / scaleY;
  const center = [(se[0] + nw[0]) / 2 + offsetX, (se[1] + nw[1]) / 2 + offsetY];
  const centerLngLat = viewport.unproject(center);
  const zoom = Math.min(maxZoom, viewport.zoom + log2(Math.abs(Math.min(scaleX, scaleY))));
  assert(Number.isFinite(zoom));
  return {
    longitude: centerLngLat[0],
    latitude: centerLngLat[1],
    zoom
  };
}
//# sourceMappingURL=fit-bounds.js.map
;// CONCATENATED MODULE: ./node_modules/@math.gl/web-mercator/dist/esm/get-bounds.js



const get_bounds_DEGREES_TO_RADIANS = Math.PI / 180;
function getBounds(viewport, z = 0) {
  const {
    width,
    height,
    unproject
  } = viewport;
  const unprojectOps = {
    targetZ: z
  };
  const bottomLeft = unproject([0, height], unprojectOps);
  const bottomRight = unproject([width, height], unprojectOps);
  let topLeft;
  let topRight;
  const halfFov = viewport.fovy ? 0.5 * viewport.fovy * get_bounds_DEGREES_TO_RADIANS : Math.atan(0.5 / viewport.altitude);
  const angleToGround = (90 - viewport.pitch) * get_bounds_DEGREES_TO_RADIANS;

  if (halfFov > angleToGround - 0.01) {
    topLeft = unprojectOnFarPlane(viewport, 0, z);
    topRight = unprojectOnFarPlane(viewport, width, z);
  } else {
    topLeft = unproject([0, 0], unprojectOps);
    topRight = unproject([width, 0], unprojectOps);
  }

  return [bottomLeft, bottomRight, topRight, topLeft];
}

function unprojectOnFarPlane(viewport, x, targetZ) {
  const {
    pixelUnprojectionMatrix
  } = viewport;
  const coord0 = transformVector(pixelUnprojectionMatrix, [x, 0, 1, 1]);
  const coord1 = transformVector(pixelUnprojectionMatrix, [x, viewport.height, 1, 1]);
  const z = targetZ * viewport.distanceScales.unitsPerMeter[2];
  const t = (z - coord0[2]) / (coord1[2] - coord0[2]);
  const coord = vec2/* lerp */.t7([], coord0, coord1, t);
  const result = worldToLngLat(coord);
  result[2] = targetZ;
  return result;
}
//# sourceMappingURL=get-bounds.js.map
;// CONCATENATED MODULE: ./node_modules/@math.gl/web-mercator/dist/esm/web-mercator-viewport.js







class WebMercatorViewport {
  constructor({
    width,
    height,
    latitude = 0,
    longitude = 0,
    zoom = 0,
    pitch = 0,
    bearing = 0,
    altitude = null,
    fovy = null,
    position = null,
    nearZMultiplier = 0.02,
    farZMultiplier = 1.01
  } = {
    width: 1,
    height: 1
  }) {
    width = width || 1;
    height = height || 1;

    if (fovy === null && altitude === null) {
      altitude = DEFAULT_ALTITUDE;
      fovy = altitudeToFovy(altitude);
    } else if (fovy === null) {
      fovy = altitudeToFovy(altitude);
    } else if (altitude === null) {
      altitude = fovyToAltitude(fovy);
    }

    const scale = zoomToScale(zoom);
    altitude = Math.max(0.75, altitude);
    const distanceScales = getDistanceScales({
      longitude,
      latitude
    });
    const center = lngLatToWorld([longitude, latitude]);
    center[2] = 0;

    if (position) {
      vec3/* add */.IH(center, center, vec3/* mul */.dC([], position, distanceScales.unitsPerMeter));
    }

    this.projectionMatrix = getProjectionMatrix({
      width,
      height,
      pitch,
      fovy,
      nearZMultiplier,
      farZMultiplier
    });
    this.viewMatrix = getViewMatrix({
      height,
      scale,
      center,
      pitch,
      bearing,
      altitude
    });
    this.width = width;
    this.height = height;
    this.scale = scale;
    this.latitude = latitude;
    this.longitude = longitude;
    this.zoom = zoom;
    this.pitch = pitch;
    this.bearing = bearing;
    this.altitude = altitude;
    this.fovy = fovy;
    this.center = center;
    this.meterOffset = position || [0, 0, 0];
    this.distanceScales = distanceScales;

    this._initMatrices();

    this.equals = this.equals.bind(this);
    this.project = this.project.bind(this);
    this.unproject = this.unproject.bind(this);
    this.projectPosition = this.projectPosition.bind(this);
    this.unprojectPosition = this.unprojectPosition.bind(this);
    Object.freeze(this);
  }

  _initMatrices() {
    const {
      width,
      height,
      projectionMatrix,
      viewMatrix
    } = this;
    const vpm = createMat4();
    mat4/* multiply */.Jp(vpm, vpm, projectionMatrix);
    mat4/* multiply */.Jp(vpm, vpm, viewMatrix);
    this.viewProjectionMatrix = vpm;
    const m = createMat4();
    mat4/* scale */.bA(m, m, [width / 2, -height / 2, 1]);
    mat4/* translate */.Iu(m, m, [1, -1, 0]);
    mat4/* multiply */.Jp(m, m, vpm);
    const mInverse = mat4/* invert */.U_(createMat4(), m);

    if (!mInverse) {
      throw new Error('Pixel project matrix not invertible');
    }

    this.pixelProjectionMatrix = m;
    this.pixelUnprojectionMatrix = mInverse;
  }

  equals(viewport) {
    if (!(viewport instanceof WebMercatorViewport)) {
      return false;
    }

    return viewport.width === this.width && viewport.height === this.height && mat4/* equals */.fS(viewport.projectionMatrix, this.projectionMatrix) && mat4/* equals */.fS(viewport.viewMatrix, this.viewMatrix);
  }

  project(xyz, {
    topLeft = true
  } = {}) {
    const worldPosition = this.projectPosition(xyz);
    const coord = worldToPixels(worldPosition, this.pixelProjectionMatrix);
    const [x, y] = coord;
    const y2 = topLeft ? y : this.height - y;
    return xyz.length === 2 ? [x, y2] : [x, y2, coord[2]];
  }

  unproject(xyz, {
    topLeft = true,
    targetZ = undefined
  } = {}) {
    const [x, y, z] = xyz;
    const y2 = topLeft ? y : this.height - y;
    const targetZWorld = targetZ && targetZ * this.distanceScales.unitsPerMeter[2];
    const coord = pixelsToWorld([x, y2, z], this.pixelUnprojectionMatrix, targetZWorld);
    const [X, Y, Z] = this.unprojectPosition(coord);

    if (Number.isFinite(z)) {
      return [X, Y, Z];
    }

    return Number.isFinite(targetZ) ? [X, Y, targetZ] : [X, Y];
  }

  projectPosition(xyz) {
    const [X, Y] = lngLatToWorld(xyz);
    const Z = (xyz[2] || 0) * this.distanceScales.unitsPerMeter[2];
    return [X, Y, Z];
  }

  unprojectPosition(xyz) {
    const [X, Y] = worldToLngLat(xyz);
    const Z = (xyz[2] || 0) * this.distanceScales.metersPerUnit[2];
    return [X, Y, Z];
  }

  projectFlat(lngLat) {
    return lngLatToWorld(lngLat);
  }

  unprojectFlat(xy) {
    return worldToLngLat(xy);
  }

  getMapCenterByLngLatPosition({
    lngLat,
    pos
  }) {
    const fromLocation = pixelsToWorld(pos, this.pixelUnprojectionMatrix);
    const toLocation = lngLatToWorld(lngLat);
    const translate = vec2/* add */.IH([], toLocation, vec2/* negate */.tk([], fromLocation));
    const newCenter = vec2/* add */.IH([], this.center, translate);
    return worldToLngLat(newCenter);
  }

  getLocationAtPoint({
    lngLat,
    pos
  }) {
    return this.getMapCenterByLngLatPosition({
      lngLat,
      pos
    });
  }

  fitBounds(bounds, options = {}) {
    const {
      width,
      height
    } = this;
    const {
      longitude,
      latitude,
      zoom
    } = fitBounds(Object.assign({
      width,
      height,
      bounds
    }, options));
    return new WebMercatorViewport({
      width,
      height,
      longitude,
      latitude,
      zoom
    });
  }

  getBounds(options) {
    const corners = this.getBoundingRegion(options);
    const west = Math.min(...corners.map(p => p[0]));
    const east = Math.max(...corners.map(p => p[0]));
    const south = Math.min(...corners.map(p => p[1]));
    const north = Math.max(...corners.map(p => p[1]));
    return [[west, south], [east, north]];
  }

  getBoundingRegion(options = {}) {
    return getBounds(this, options.z || 0);
  }

}
//# sourceMappingURL=web-mercator-viewport.js.map
;// CONCATENATED MODULE: ./node_modules/@math.gl/web-mercator/dist/esm/normalize-viewport-props.js


const MAX_LATITUDE = 85.05113;
const MIN_LATITUDE = -85.05113;
function normalizeViewportProps({
  width,
  height,
  longitude,
  latitude,
  zoom,
  pitch = 0,
  bearing = 0
}) {
  if (longitude < -180 || longitude > 180) {
    longitude = mod(longitude + 180, 360) - 180;
  }

  if (bearing < -180 || bearing > 180) {
    bearing = mod(bearing + 180, 360) - 180;
  }

  let flatViewport = new WebMercatorViewport({
    width,
    height,
    longitude,
    latitude,
    zoom
  });
  let topY = flatViewport.project([longitude, MAX_LATITUDE])[1];
  let bottomY = flatViewport.project([longitude, MIN_LATITUDE])[1];
  let shiftY = 0;

  if (bottomY - topY < height) {
    zoom += log2(height / (bottomY - topY));
    flatViewport = new WebMercatorViewport({
      width,
      height,
      longitude,
      latitude,
      zoom
    });
    topY = flatViewport.project([longitude, MAX_LATITUDE])[1];
    bottomY = flatViewport.project([longitude, MIN_LATITUDE])[1];
  }

  if (topY > 0) {
    shiftY = topY;
  } else if (bottomY < height) {
    shiftY = bottomY - height;
  }

  if (shiftY) {
    latitude = flatViewport.unproject([width / 2, height / 2 + shiftY])[1];
  }

  return {
    width,
    height,
    longitude,
    latitude,
    zoom,
    pitch,
    bearing
  };
}
//# sourceMappingURL=normalize-viewport-props.js.map
;// CONCATENATED MODULE: ./node_modules/@math.gl/web-mercator/dist/esm/fly-to-viewport.js



const EPSILON = 0.01;
const VIEWPORT_TRANSITION_PROPS = ['longitude', 'latitude', 'zoom'];
const DEFAULT_OPTS = {
  curve: 1.414,
  speed: 1.2
};
function flyToViewport(startProps, endProps, t, opts = {}) {
  const viewport = {};
  const {
    startZoom,
    startCenterXY,
    uDelta,
    w0,
    u1,
    S,
    rho,
    rho2,
    r0
  } = getFlyToTransitionParams(startProps, endProps, opts);

  if (u1 < EPSILON) {
    for (const key of VIEWPORT_TRANSITION_PROPS) {
      const startValue = startProps[key];
      const endValue = endProps[key];
      viewport[key] = lerp(startValue, endValue, t);
    }

    return viewport;
  }

  const s = t * S;
  const w = Math.cosh(r0) / Math.cosh(r0 + rho * s);
  const u = w0 * ((Math.cosh(r0) * Math.tanh(r0 + rho * s) - Math.sinh(r0)) / rho2) / u1;
  const scaleIncrement = 1 / w;
  const newZoom = startZoom + scaleToZoom(scaleIncrement);
  const newCenterWorld = vec2/* scale */.bA([], uDelta, u);
  vec2/* add */.IH(newCenterWorld, newCenterWorld, startCenterXY);
  const newCenter = worldToLngLat(newCenterWorld);
  viewport.longitude = newCenter[0];
  viewport.latitude = newCenter[1];
  viewport.zoom = newZoom;
  return viewport;
}
function getFlyToDuration(startProps, endProps, opts = {}) {
  opts = Object.assign({}, DEFAULT_OPTS, opts);
  const {
    screenSpeed,
    speed,
    maxDuration
  } = opts;
  const {
    S,
    rho
  } = getFlyToTransitionParams(startProps, endProps, opts);
  const length = 1000 * S;
  let duration;

  if (Number.isFinite(screenSpeed)) {
    duration = length / (screenSpeed / rho);
  } else {
    duration = length / speed;
  }

  return Number.isFinite(maxDuration) && duration > maxDuration ? 0 : duration;
}

function getFlyToTransitionParams(startProps, endProps, opts) {
  opts = Object.assign({}, DEFAULT_OPTS, opts);
  const rho = opts.curve;
  const startZoom = startProps.zoom;
  const startCenter = [startProps.longitude, startProps.latitude];
  const startScale = zoomToScale(startZoom);
  const endZoom = endProps.zoom;
  const endCenter = [endProps.longitude, endProps.latitude];
  const scale = zoomToScale(endZoom - startZoom);
  const startCenterXY = lngLatToWorld(startCenter);
  const endCenterXY = lngLatToWorld(endCenter);
  const uDelta = vec2/* sub */.lu([], endCenterXY, startCenterXY);
  const w0 = Math.max(startProps.width, startProps.height);
  const w1 = w0 / scale;
  const u1 = vec2/* length */.kE(uDelta) * startScale;

  const _u1 = Math.max(u1, EPSILON);

  const rho2 = rho * rho;
  const b0 = (w1 * w1 - w0 * w0 + rho2 * rho2 * _u1 * _u1) / (2 * w0 * rho2 * _u1);
  const b1 = (w1 * w1 - w0 * w0 - rho2 * rho2 * _u1 * _u1) / (2 * w1 * rho2 * _u1);
  const r0 = Math.log(Math.sqrt(b0 * b0 + 1) - b0);
  const r1 = Math.log(Math.sqrt(b1 * b1 + 1) - b1);
  const S = (r1 - r0) / rho;
  return {
    startZoom,
    startCenterXY,
    uDelta,
    w0,
    u1,
    S,
    rho,
    rho2,
    r0,
    r1
  };
}
//# sourceMappingURL=fly-to-viewport.js.map
;// CONCATENATED MODULE: ./node_modules/@math.gl/web-mercator/dist/esm/index.js







//# sourceMappingURL=index.js.map

/***/ }),

/***/ 26203:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "jk": () => (/* reexport */ Stats)
});

// UNUSED EXPORTS: Stat, _getHiResTimestamp

;// CONCATENATED MODULE: ./node_modules/@probe.gl/stats/dist/esm/utils/hi-res-timestamp.js
/* provided dependency */ var process = __webpack_require__(34155);
function getHiResTimestamp() {
  let timestamp;

  if (typeof window !== 'undefined' && window.performance) {
    timestamp = window.performance.now();
  } else if (typeof process !== 'undefined' && process.hrtime) {
    const timeParts = process.hrtime();
    timestamp = timeParts[0] * 1000 + timeParts[1] / 1e6;
  } else {
    timestamp = Date.now();
  }

  return timestamp;
}
//# sourceMappingURL=hi-res-timestamp.js.map
;// CONCATENATED MODULE: ./node_modules/@probe.gl/stats/dist/esm/lib/stat.js

class Stat {
  constructor(name, type) {
    this.name = name;
    this.type = type;
    this.sampleSize = 1;
    this.reset();
  }

  setSampleSize(samples) {
    this.sampleSize = samples;
    return this;
  }

  incrementCount() {
    this.addCount(1);
    return this;
  }

  decrementCount() {
    this.subtractCount(1);
    return this;
  }

  addCount(value) {
    this._count += value;
    this._samples++;

    this._checkSampling();

    return this;
  }

  subtractCount(value) {
    this._count -= value;
    this._samples++;

    this._checkSampling();

    return this;
  }

  addTime(time) {
    this._time += time;
    this.lastTiming = time;
    this._samples++;

    this._checkSampling();

    return this;
  }

  timeStart() {
    this._startTime = getHiResTimestamp();
    this._timerPending = true;
    return this;
  }

  timeEnd() {
    if (!this._timerPending) {
      return this;
    }

    this.addTime(getHiResTimestamp() - this._startTime);
    this._timerPending = false;

    this._checkSampling();

    return this;
  }

  getSampleAverageCount() {
    return this.sampleSize > 0 ? this.lastSampleCount / this.sampleSize : 0;
  }

  getSampleAverageTime() {
    return this.sampleSize > 0 ? this.lastSampleTime / this.sampleSize : 0;
  }

  getSampleHz() {
    return this.lastSampleTime > 0 ? this.sampleSize / (this.lastSampleTime / 1000) : 0;
  }

  getAverageCount() {
    return this.samples > 0 ? this.count / this.samples : 0;
  }

  getAverageTime() {
    return this.samples > 0 ? this.time / this.samples : 0;
  }

  getHz() {
    return this.time > 0 ? this.samples / (this.time / 1000) : 0;
  }

  reset() {
    this.time = 0;
    this.count = 0;
    this.samples = 0;
    this.lastTiming = 0;
    this.lastSampleTime = 0;
    this.lastSampleCount = 0;
    this._count = 0;
    this._time = 0;
    this._samples = 0;
    this._startTime = 0;
    this._timerPending = false;
    return this;
  }

  _checkSampling() {
    if (this._samples === this.sampleSize) {
      this.lastSampleTime = this._time;
      this.lastSampleCount = this._count;
      this.count += this._count;
      this.time += this._time;
      this.samples += this._samples;
      this._time = 0;
      this._count = 0;
      this._samples = 0;
    }
  }

}
//# sourceMappingURL=stat.js.map
;// CONCATENATED MODULE: ./node_modules/@probe.gl/stats/dist/esm/lib/stats.js

class Stats {
  constructor({
    id,
    stats
  }) {
    this.id = id;
    this.stats = {};

    this._initializeStats(stats);

    Object.seal(this);
  }

  get(name, type = 'count') {
    return this._getOrCreate({
      name,
      type
    });
  }

  get size() {
    return Object.keys(this.stats).length;
  }

  reset() {
    for (const key in this.stats) {
      this.stats[key].reset();
    }

    return this;
  }

  forEach(fn) {
    for (const key in this.stats) {
      fn(this.stats[key]);
    }
  }

  getTable() {
    const table = {};
    this.forEach(stat => {
      table[stat.name] = {
        time: stat.time || 0,
        count: stat.count || 0,
        average: stat.getAverageTime() || 0,
        hz: stat.getHz() || 0
      };
    });
    return table;
  }

  _initializeStats(stats = []) {
    stats.forEach(stat => this._getOrCreate(stat));
  }

  _getOrCreate(stat) {
    if (!stat || !stat.name) {
      return null;
    }

    const {
      name,
      type
    } = stat;

    if (!this.stats[name]) {
      if (stat instanceof Stat) {
        this.stats[name] = stat;
      } else {
        this.stats[name] = new Stat(name, type);
      }
    }

    return this.stats[name];
  }

}
//# sourceMappingURL=stats.js.map
;// CONCATENATED MODULE: ./node_modules/@probe.gl/stats/dist/esm/index.js



//# sourceMappingURL=index.js.map

/***/ }),

/***/ 85011:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ esm_DeckGLContainer)
});

// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(45697);
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__(87462);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js + 2 modules
var toConsumableArray = __webpack_require__(93433);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/defineProperty.js
var defineProperty = __webpack_require__(4942);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/slicedToArray.js + 1 modules
var slicedToArray = __webpack_require__(29439);
// EXTERNAL MODULE: ./node_modules/@math.gl/web-mercator/dist/esm/index.js + 8 modules
var esm = __webpack_require__(17013);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/viewport-mercator-project/module.js



// EXTERNAL MODULE: ./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js
var ResizeObserver_es = __webpack_require__(91033);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/classCallCheck.js
var classCallCheck = __webpack_require__(15671);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/createClass.js
var createClass = __webpack_require__(43144);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/globals.js
var window_ = typeof window !== 'undefined' ? window : __webpack_require__.g;
var global_ = typeof __webpack_require__.g !== 'undefined' ? __webpack_require__.g : window;
var document_ = typeof document !== 'undefined' ? document : {};

//# sourceMappingURL=globals.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/style-utils.js


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var refProps = ['type', 'source', 'source-layer', 'minzoom', 'maxzoom', 'filter', 'layout'];
function normalizeStyle(style) {
  if (!style) {
    return null;
  }

  if (typeof style === 'string') {
    return style;
  }

  if (style.toJS) {
    style = style.toJS();
  }

  var layerIndex = {};

  var _iterator = _createForOfIteratorHelper(style.layers),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var layer = _step.value;
      layerIndex[layer.id] = layer;
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  var layers = style.layers.map(function (layer) {
    var layerRef = layerIndex[layer.ref];
    var normalizedLayer = null;

    if ('interactive' in layer) {
      normalizedLayer = _objectSpread({}, layer);
      delete normalizedLayer.interactive;
    }

    if (layerRef) {
      normalizedLayer = normalizedLayer || _objectSpread({}, layer);
      delete normalizedLayer.ref;

      var _iterator2 = _createForOfIteratorHelper(refProps),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var propName = _step2.value;

          if (propName in layerRef) {
            normalizedLayer[propName] = layerRef[propName];
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }

    return normalizedLayer || layer;
  });
  return _objectSpread(_objectSpread({}, style), {}, {
    layers: layers
  });
}
//# sourceMappingURL=style-utils.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/mapbox/mapbox.js
/* provided dependency */ var process = __webpack_require__(34155);







function noop() {}

function defaultOnError(event) {
  if (event) {
    console.error(event.error);
  }
}

var propTypes = {
  container: prop_types.object,
  gl: prop_types.object,
  mapboxApiAccessToken: prop_types.string,
  mapboxApiUrl: prop_types.string,
  attributionControl: prop_types.bool,
  preserveDrawingBuffer: prop_types.bool,
  reuseMaps: prop_types.bool,
  transformRequest: prop_types.func,
  mapOptions: prop_types.object,
  mapStyle: prop_types.oneOfType([prop_types.string, prop_types.object]),
  preventStyleDiffing: prop_types.bool,
  visible: prop_types.bool,
  asyncRender: prop_types.bool,
  onLoad: prop_types.func,
  onError: prop_types.func,
  width: prop_types.number,
  height: prop_types.number,
  viewState: prop_types.object,
  longitude: prop_types.number,
  latitude: prop_types.number,
  zoom: prop_types.number,
  bearing: prop_types.number,
  pitch: prop_types.number,
  altitude: prop_types.number
};
var defaultProps = {
  container: document_.body,
  mapboxApiAccessToken: getAccessToken(),
  mapboxApiUrl: 'https://api.mapbox.com',
  preserveDrawingBuffer: false,
  attributionControl: true,
  reuseMaps: false,
  mapOptions: {},
  mapStyle: 'mapbox://styles/mapbox/light-v8',
  preventStyleDiffing: false,
  visible: true,
  asyncRender: false,
  onLoad: noop,
  onError: defaultOnError,
  width: 0,
  height: 0,
  longitude: 0,
  latitude: 0,
  zoom: 0,
  bearing: 0,
  pitch: 0,
  altitude: 1.5
};
function getAccessToken() {
  var accessToken = null;

  if (typeof window !== 'undefined' && window.location) {
    var match = window.location.search.match(/access_token=([^&\/]*)/);
    accessToken = match && match[1];
  }

  if (!accessToken && typeof process !== 'undefined') {
    accessToken = accessToken || process.env.MapboxAccessToken || process.env.REACT_APP_MAPBOX_ACCESS_TOKEN;
  }

  return accessToken || 'no-token';
}

function checkPropTypes(props) {
  var component = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'component';

  if (props.debug) {
    prop_types.checkPropTypes(propTypes, props, 'prop', component);
  }
}

var Mapbox = function () {
  function Mapbox(props) {
    var _this = this;

    (0,classCallCheck/* default */.Z)(this, Mapbox);

    (0,defineProperty/* default */.Z)(this, "props", defaultProps);

    (0,defineProperty/* default */.Z)(this, "width", 0);

    (0,defineProperty/* default */.Z)(this, "height", 0);

    (0,defineProperty/* default */.Z)(this, "_fireLoadEvent", function () {
      _this.props.onLoad({
        type: 'load',
        target: _this._map
      });
    });

    if (!props.mapboxgl) {
      throw new Error('Mapbox not available');
    }

    this.mapboxgl = props.mapboxgl;

    if (!Mapbox.initialized) {
      Mapbox.initialized = true;

      this._checkStyleSheet(this.mapboxgl.version);
    }

    this._initialize(props);
  }

  (0,createClass/* default */.Z)(Mapbox, [{
    key: "finalize",
    value: function finalize() {
      this._destroy();

      return this;
    }
  }, {
    key: "setProps",
    value: function setProps(props) {
      this._update(this.props, props);

      return this;
    }
  }, {
    key: "redraw",
    value: function redraw() {
      var map = this._map;

      if (map.style) {
        if (map._frame) {
          map._frame.cancel();

          map._frame = null;
        }

        map._render();
      }
    }
  }, {
    key: "getMap",
    value: function getMap() {
      return this._map;
    }
  }, {
    key: "_reuse",
    value: function _reuse(props) {
      this._map = Mapbox.savedMap;

      var oldContainer = this._map.getContainer();

      var newContainer = props.container;
      newContainer.classList.add('mapboxgl-map');

      while (oldContainer.childNodes.length > 0) {
        newContainer.appendChild(oldContainer.childNodes[0]);
      }

      this._map._container = newContainer;
      Mapbox.savedMap = null;

      if (props.mapStyle) {
        this._map.setStyle(normalizeStyle(props.mapStyle), {
          diff: false
        });
      }

      if (this._map.isStyleLoaded()) {
        this._fireLoadEvent();
      } else {
        this._map.once('styledata', this._fireLoadEvent);
      }
    }
  }, {
    key: "_create",
    value: function _create(props) {
      if (props.reuseMaps && Mapbox.savedMap) {
        this._reuse(props);
      } else {
        if (props.gl) {
          var getContext = HTMLCanvasElement.prototype.getContext;

          HTMLCanvasElement.prototype.getContext = function () {
            HTMLCanvasElement.prototype.getContext = getContext;
            return props.gl;
          };
        }

        var mapOptions = {
          container: props.container,
          center: [0, 0],
          zoom: 8,
          pitch: 0,
          bearing: 0,
          maxZoom: 24,
          style: normalizeStyle(props.mapStyle),
          interactive: false,
          trackResize: false,
          attributionControl: props.attributionControl,
          preserveDrawingBuffer: props.preserveDrawingBuffer
        };

        if (props.transformRequest) {
          mapOptions.transformRequest = props.transformRequest;
        }

        this._map = new this.mapboxgl.Map(Object.assign({}, mapOptions, props.mapOptions));

        this._map.once('load', props.onLoad);

        this._map.on('error', props.onError);
      }

      return this;
    }
  }, {
    key: "_destroy",
    value: function _destroy() {
      if (!this._map) {
        return;
      }

      if (!Mapbox.savedMap) {
        Mapbox.savedMap = this._map;

        this._map.off('load', this.props.onLoad);

        this._map.off('error', this.props.onError);

        this._map.off('styledata', this._fireLoadEvent);
      } else {
        this._map.remove();
      }

      this._map = null;
    }
  }, {
    key: "_initialize",
    value: function _initialize(props) {
      var _this2 = this;

      props = Object.assign({}, defaultProps, props);
      checkPropTypes(props, 'Mapbox');
      this.mapboxgl.accessToken = props.mapboxApiAccessToken || defaultProps.mapboxApiAccessToken;
      this.mapboxgl.baseApiUrl = props.mapboxApiUrl;

      this._create(props);

      var _props = props,
          container = _props.container;
      Object.defineProperty(container, 'offsetWidth', {
        get: function get() {
          return _this2.width;
        }
      });
      Object.defineProperty(container, 'clientWidth', {
        get: function get() {
          return _this2.width;
        }
      });
      Object.defineProperty(container, 'offsetHeight', {
        get: function get() {
          return _this2.height;
        }
      });
      Object.defineProperty(container, 'clientHeight', {
        get: function get() {
          return _this2.height;
        }
      });

      var canvas = this._map.getCanvas();

      if (canvas) {
        canvas.style.outline = 'none';
      }

      this._updateMapViewport({}, props);

      this._updateMapSize({}, props);

      this.props = props;
    }
  }, {
    key: "_update",
    value: function _update(oldProps, newProps) {
      if (!this._map) {
        return;
      }

      newProps = Object.assign({}, this.props, newProps);
      checkPropTypes(newProps, 'Mapbox');

      var viewportChanged = this._updateMapViewport(oldProps, newProps);

      var sizeChanged = this._updateMapSize(oldProps, newProps);

      this._updateMapStyle(oldProps, newProps);

      if (!newProps.asyncRender && (viewportChanged || sizeChanged)) {
        this.redraw();
      }

      this.props = newProps;
    }
  }, {
    key: "_updateMapStyle",
    value: function _updateMapStyle(oldProps, newProps) {
      var styleChanged = oldProps.mapStyle !== newProps.mapStyle;

      if (styleChanged) {
        this._map.setStyle(normalizeStyle(newProps.mapStyle), {
          diff: !newProps.preventStyleDiffing
        });
      }
    }
  }, {
    key: "_updateMapSize",
    value: function _updateMapSize(oldProps, newProps) {
      var sizeChanged = oldProps.width !== newProps.width || oldProps.height !== newProps.height;

      if (sizeChanged) {
        this.width = newProps.width;
        this.height = newProps.height;

        this._map.resize();
      }

      return sizeChanged;
    }
  }, {
    key: "_updateMapViewport",
    value: function _updateMapViewport(oldProps, newProps) {
      var oldViewState = this._getViewState(oldProps);

      var newViewState = this._getViewState(newProps);

      var viewportChanged = newViewState.latitude !== oldViewState.latitude || newViewState.longitude !== oldViewState.longitude || newViewState.zoom !== oldViewState.zoom || newViewState.pitch !== oldViewState.pitch || newViewState.bearing !== oldViewState.bearing || newViewState.altitude !== oldViewState.altitude;

      if (viewportChanged) {
        this._map.jumpTo(this._viewStateToMapboxProps(newViewState));

        if (newViewState.altitude !== oldViewState.altitude) {
          this._map.transform.altitude = newViewState.altitude;
        }
      }

      return viewportChanged;
    }
  }, {
    key: "_getViewState",
    value: function _getViewState(props) {
      var _ref = props.viewState || props,
          longitude = _ref.longitude,
          latitude = _ref.latitude,
          zoom = _ref.zoom,
          _ref$pitch = _ref.pitch,
          pitch = _ref$pitch === void 0 ? 0 : _ref$pitch,
          _ref$bearing = _ref.bearing,
          bearing = _ref$bearing === void 0 ? 0 : _ref$bearing,
          _ref$altitude = _ref.altitude,
          altitude = _ref$altitude === void 0 ? 1.5 : _ref$altitude;

      return {
        longitude: longitude,
        latitude: latitude,
        zoom: zoom,
        pitch: pitch,
        bearing: bearing,
        altitude: altitude
      };
    }
  }, {
    key: "_checkStyleSheet",
    value: function _checkStyleSheet() {
      var mapboxVersion = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '0.47.0';

      if (typeof document_ === 'undefined') {
        return;
      }

      try {
        var testElement = document_.createElement('div');
        testElement.className = 'mapboxgl-map';
        testElement.style.display = 'none';
        document_.body.appendChild(testElement);
        var isCssLoaded = window.getComputedStyle(testElement).position !== 'static';

        if (!isCssLoaded) {
          var link = document_.createElement('link');
          link.setAttribute('rel', 'stylesheet');
          link.setAttribute('type', 'text/css');
          link.setAttribute('href', "https://api.tiles.mapbox.com/mapbox-gl-js/v".concat(mapboxVersion, "/mapbox-gl.css"));
          document_.head.appendChild(link);
        }
      } catch (error) {}
    }
  }, {
    key: "_viewStateToMapboxProps",
    value: function _viewStateToMapboxProps(viewState) {
      return {
        center: [viewState.longitude, viewState.latitude],
        zoom: viewState.zoom,
        bearing: viewState.bearing,
        pitch: viewState.pitch
      };
    }
  }]);

  return Mapbox;
}();

(0,defineProperty/* default */.Z)(Mapbox, "initialized", false);

(0,defineProperty/* default */.Z)(Mapbox, "propTypes", propTypes);

(0,defineProperty/* default */.Z)(Mapbox, "defaultProps", defaultProps);

(0,defineProperty/* default */.Z)(Mapbox, "savedMap", null);


//# sourceMappingURL=mapbox.js.map
// EXTERNAL MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/mapbox-gl/dist/mapbox-gl.js
var mapbox_gl = __webpack_require__(56669);
var mapbox_gl_default = /*#__PURE__*/__webpack_require__.n(mapbox_gl);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/mapboxgl.browser.js

//# sourceMappingURL=mapboxgl.browser.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/math-utils.js
var EPSILON = 1e-7;

function isArray(value) {
  return Array.isArray(value) || ArrayBuffer.isView(value);
}

function equals(a, b) {
  if (a === b) {
    return true;
  }

  if (isArray(a) && isArray(b)) {
    if (a.length !== b.length) {
      return false;
    }

    for (var i = 0; i < a.length; ++i) {
      if (!equals(a[i], b[i])) {
        return false;
      }
    }

    return true;
  }

  return Math.abs(a - b) <= EPSILON;
}
function clamp(value, min, max) {
  return Math.max(min, Math.min(max, value));
}
function lerp(a, b, t) {
  if (isArray(a)) {
    return a.map(function (ai, i) {
      return lerp(ai, b[i], t);
    });
  }

  return t * b + (1 - t) * a;
}
//# sourceMappingURL=math-utils.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/assert.js
function assert(condition, message) {
  if (!condition) {
    throw new Error(message || 'react-map-gl: assertion failed.');
  }
}
//# sourceMappingURL=assert.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/map-state.js





function map_state_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function map_state_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { map_state_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { map_state_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }




var MAPBOX_LIMITS = {
  minZoom: 0,
  maxZoom: 24,
  minPitch: 0,
  maxPitch: 85
};
var DEFAULT_STATE = {
  pitch: 0,
  bearing: 0,
  altitude: 1.5
};
var PITCH_MOUSE_THRESHOLD = 5;
var PITCH_ACCEL = 1.2;

var MapState = function () {
  function MapState(_ref) {
    var width = _ref.width,
        height = _ref.height,
        latitude = _ref.latitude,
        longitude = _ref.longitude,
        zoom = _ref.zoom,
        _ref$bearing = _ref.bearing,
        bearing = _ref$bearing === void 0 ? DEFAULT_STATE.bearing : _ref$bearing,
        _ref$pitch = _ref.pitch,
        pitch = _ref$pitch === void 0 ? DEFAULT_STATE.pitch : _ref$pitch,
        _ref$altitude = _ref.altitude,
        altitude = _ref$altitude === void 0 ? DEFAULT_STATE.altitude : _ref$altitude,
        _ref$maxZoom = _ref.maxZoom,
        maxZoom = _ref$maxZoom === void 0 ? MAPBOX_LIMITS.maxZoom : _ref$maxZoom,
        _ref$minZoom = _ref.minZoom,
        minZoom = _ref$minZoom === void 0 ? MAPBOX_LIMITS.minZoom : _ref$minZoom,
        _ref$maxPitch = _ref.maxPitch,
        maxPitch = _ref$maxPitch === void 0 ? MAPBOX_LIMITS.maxPitch : _ref$maxPitch,
        _ref$minPitch = _ref.minPitch,
        minPitch = _ref$minPitch === void 0 ? MAPBOX_LIMITS.minPitch : _ref$minPitch,
        transitionDuration = _ref.transitionDuration,
        transitionEasing = _ref.transitionEasing,
        transitionInterpolator = _ref.transitionInterpolator,
        transitionInterruption = _ref.transitionInterruption,
        startPanLngLat = _ref.startPanLngLat,
        startZoomLngLat = _ref.startZoomLngLat,
        startRotatePos = _ref.startRotatePos,
        startBearing = _ref.startBearing,
        startPitch = _ref.startPitch,
        startZoom = _ref.startZoom;

    (0,classCallCheck/* default */.Z)(this, MapState);

    assert(Number.isFinite(width), '`width` must be supplied');
    assert(Number.isFinite(height), '`height` must be supplied');
    assert(Number.isFinite(longitude), '`longitude` must be supplied');
    assert(Number.isFinite(latitude), '`latitude` must be supplied');
    assert(Number.isFinite(zoom), '`zoom` must be supplied');
    this._viewportProps = this._applyConstraints({
      width: width,
      height: height,
      latitude: latitude,
      longitude: longitude,
      zoom: zoom,
      bearing: bearing,
      pitch: pitch,
      altitude: altitude,
      maxZoom: maxZoom,
      minZoom: minZoom,
      maxPitch: maxPitch,
      minPitch: minPitch,
      transitionDuration: transitionDuration,
      transitionEasing: transitionEasing,
      transitionInterpolator: transitionInterpolator,
      transitionInterruption: transitionInterruption
    });
    this._state = {
      startPanLngLat: startPanLngLat,
      startZoomLngLat: startZoomLngLat,
      startRotatePos: startRotatePos,
      startBearing: startBearing,
      startPitch: startPitch,
      startZoom: startZoom
    };
  }

  (0,createClass/* default */.Z)(MapState, [{
    key: "getViewportProps",
    value: function getViewportProps() {
      return this._viewportProps;
    }
  }, {
    key: "getState",
    value: function getState() {
      return this._state;
    }
  }, {
    key: "panStart",
    value: function panStart(_ref2) {
      var pos = _ref2.pos;
      return this._getUpdatedMapState({
        startPanLngLat: this._unproject(pos)
      });
    }
  }, {
    key: "pan",
    value: function pan(_ref3) {
      var pos = _ref3.pos,
          startPos = _ref3.startPos;

      var startPanLngLat = this._state.startPanLngLat || this._unproject(startPos);

      if (!startPanLngLat) {
        return this;
      }

      var _this$_calculateNewLn = this._calculateNewLngLat({
        startPanLngLat: startPanLngLat,
        pos: pos
      }),
          _this$_calculateNewLn2 = (0,slicedToArray/* default */.Z)(_this$_calculateNewLn, 2),
          longitude = _this$_calculateNewLn2[0],
          latitude = _this$_calculateNewLn2[1];

      return this._getUpdatedMapState({
        longitude: longitude,
        latitude: latitude
      });
    }
  }, {
    key: "panEnd",
    value: function panEnd() {
      return this._getUpdatedMapState({
        startPanLngLat: null
      });
    }
  }, {
    key: "rotateStart",
    value: function rotateStart(_ref4) {
      var pos = _ref4.pos;
      return this._getUpdatedMapState({
        startRotatePos: pos,
        startBearing: this._viewportProps.bearing,
        startPitch: this._viewportProps.pitch
      });
    }
  }, {
    key: "rotate",
    value: function rotate(_ref5) {
      var pos = _ref5.pos,
          _ref5$deltaAngleX = _ref5.deltaAngleX,
          deltaAngleX = _ref5$deltaAngleX === void 0 ? 0 : _ref5$deltaAngleX,
          _ref5$deltaAngleY = _ref5.deltaAngleY,
          deltaAngleY = _ref5$deltaAngleY === void 0 ? 0 : _ref5$deltaAngleY;
      var _this$_state = this._state,
          startRotatePos = _this$_state.startRotatePos,
          startBearing = _this$_state.startBearing,
          startPitch = _this$_state.startPitch;

      if (!Number.isFinite(startBearing) || !Number.isFinite(startPitch)) {
        return this;
      }

      var newRotation;

      if (pos) {
        newRotation = this._calculateNewPitchAndBearing(map_state_objectSpread(map_state_objectSpread({}, this._getRotationParams(pos, startRotatePos)), {}, {
          startBearing: startBearing,
          startPitch: startPitch
        }));
      } else {
        newRotation = {
          bearing: startBearing + deltaAngleX,
          pitch: startPitch + deltaAngleY
        };
      }

      return this._getUpdatedMapState(newRotation);
    }
  }, {
    key: "rotateEnd",
    value: function rotateEnd() {
      return this._getUpdatedMapState({
        startBearing: null,
        startPitch: null
      });
    }
  }, {
    key: "zoomStart",
    value: function zoomStart(_ref6) {
      var pos = _ref6.pos;
      return this._getUpdatedMapState({
        startZoomLngLat: this._unproject(pos),
        startZoom: this._viewportProps.zoom
      });
    }
  }, {
    key: "zoom",
    value: function zoom(_ref7) {
      var pos = _ref7.pos,
          startPos = _ref7.startPos,
          scale = _ref7.scale;
      assert(scale > 0, '`scale` must be a positive number');
      var _this$_state2 = this._state,
          startZoom = _this$_state2.startZoom,
          startZoomLngLat = _this$_state2.startZoomLngLat;

      if (!Number.isFinite(startZoom)) {
        startZoom = this._viewportProps.zoom;
        startZoomLngLat = this._unproject(startPos) || this._unproject(pos);
      }

      assert(startZoomLngLat, '`startZoomLngLat` prop is required ' + 'for zoom behavior to calculate where to position the map.');

      var zoom = this._calculateNewZoom({
        scale: scale,
        startZoom: startZoom || 0
      });

      var zoomedViewport = new esm/* WebMercatorViewport */.DW(Object.assign({}, this._viewportProps, {
        zoom: zoom
      }));

      var _zoomedViewport$getMa = zoomedViewport.getMapCenterByLngLatPosition({
        lngLat: startZoomLngLat,
        pos: pos
      }),
          _zoomedViewport$getMa2 = (0,slicedToArray/* default */.Z)(_zoomedViewport$getMa, 2),
          longitude = _zoomedViewport$getMa2[0],
          latitude = _zoomedViewport$getMa2[1];

      return this._getUpdatedMapState({
        zoom: zoom,
        longitude: longitude,
        latitude: latitude
      });
    }
  }, {
    key: "zoomEnd",
    value: function zoomEnd() {
      return this._getUpdatedMapState({
        startZoomLngLat: null,
        startZoom: null
      });
    }
  }, {
    key: "_getUpdatedMapState",
    value: function _getUpdatedMapState(newProps) {
      return new MapState(Object.assign({}, this._viewportProps, this._state, newProps));
    }
  }, {
    key: "_applyConstraints",
    value: function _applyConstraints(props) {
      var maxZoom = props.maxZoom,
          minZoom = props.minZoom,
          zoom = props.zoom;
      props.zoom = clamp(zoom, minZoom, maxZoom);
      var maxPitch = props.maxPitch,
          minPitch = props.minPitch,
          pitch = props.pitch;
      props.pitch = clamp(pitch, minPitch, maxPitch);
      Object.assign(props, (0,esm/* normalizeViewportProps */.QA)(props));
      return props;
    }
  }, {
    key: "_unproject",
    value: function _unproject(pos) {
      var viewport = new esm/* WebMercatorViewport */.DW(this._viewportProps);
      return pos && viewport.unproject(pos);
    }
  }, {
    key: "_calculateNewLngLat",
    value: function _calculateNewLngLat(_ref8) {
      var startPanLngLat = _ref8.startPanLngLat,
          pos = _ref8.pos;
      var viewport = new esm/* WebMercatorViewport */.DW(this._viewportProps);
      return viewport.getMapCenterByLngLatPosition({
        lngLat: startPanLngLat,
        pos: pos
      });
    }
  }, {
    key: "_calculateNewZoom",
    value: function _calculateNewZoom(_ref9) {
      var scale = _ref9.scale,
          startZoom = _ref9.startZoom;
      var _this$_viewportProps = this._viewportProps,
          maxZoom = _this$_viewportProps.maxZoom,
          minZoom = _this$_viewportProps.minZoom;
      var zoom = startZoom + Math.log2(scale);
      return clamp(zoom, minZoom, maxZoom);
    }
  }, {
    key: "_calculateNewPitchAndBearing",
    value: function _calculateNewPitchAndBearing(_ref10) {
      var deltaScaleX = _ref10.deltaScaleX,
          deltaScaleY = _ref10.deltaScaleY,
          startBearing = _ref10.startBearing,
          startPitch = _ref10.startPitch;
      deltaScaleY = clamp(deltaScaleY, -1, 1);
      var _this$_viewportProps2 = this._viewportProps,
          minPitch = _this$_viewportProps2.minPitch,
          maxPitch = _this$_viewportProps2.maxPitch;
      var bearing = startBearing + 180 * deltaScaleX;
      var pitch = startPitch;

      if (deltaScaleY > 0) {
        pitch = startPitch + deltaScaleY * (maxPitch - startPitch);
      } else if (deltaScaleY < 0) {
        pitch = startPitch - deltaScaleY * (minPitch - startPitch);
      }

      return {
        pitch: pitch,
        bearing: bearing
      };
    }
  }, {
    key: "_getRotationParams",
    value: function _getRotationParams(pos, startPos) {
      var deltaX = pos[0] - startPos[0];
      var deltaY = pos[1] - startPos[1];
      var centerY = pos[1];
      var startY = startPos[1];
      var _this$_viewportProps3 = this._viewportProps,
          width = _this$_viewportProps3.width,
          height = _this$_viewportProps3.height;
      var deltaScaleX = deltaX / width;
      var deltaScaleY = 0;

      if (deltaY > 0) {
        if (Math.abs(height - startY) > PITCH_MOUSE_THRESHOLD) {
          deltaScaleY = deltaY / (startY - height) * PITCH_ACCEL;
        }
      } else if (deltaY < 0) {
        if (startY > PITCH_MOUSE_THRESHOLD) {
          deltaScaleY = 1 - centerY / startY;
        }
      }

      deltaScaleY = Math.min(1, Math.max(-1, deltaScaleY));
      return {
        deltaScaleX: deltaScaleX,
        deltaScaleY: deltaScaleY
      };
    }
  }]);

  return MapState;
}();


//# sourceMappingURL=map-state.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/map-constraints.js


function decapitalize(s) {
  return s[0].toLowerCase() + s.slice(1);
}

function checkVisibilityConstraints(props) {
  var constraints = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : MAPBOX_LIMITS;

  for (var constraintName in constraints) {
    var type = constraintName.slice(0, 3);
    var propName = decapitalize(constraintName.slice(3));

    if (type === 'min' && props[propName] < constraints[constraintName]) {
      return false;
    }

    if (type === 'max' && props[propName] > constraints[constraintName]) {
      return false;
    }
  }

  return true;
}
//# sourceMappingURL=map-constraints.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/map-context.js



function map_context_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function map_context_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { map_context_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { map_context_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var MapContext = (0,react.createContext)({
  viewport: null,
  map: null,
  container: null,
  onViewportChange: null,
  onViewStateChange: null,
  eventManager: null
});
var MapContextProvider = MapContext.Provider;

function WrappedProvider(_ref) {
  var value = _ref.value,
      children = _ref.children;

  var _useState = (0,react.useState)(null),
      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),
      map = _useState2[0],
      setMap = _useState2[1];

  var context = (0,react.useContext)(MapContext);
  value = map_context_objectSpread(map_context_objectSpread({
    setMap: setMap
  }, context), {}, {
    map: context && context.map || map
  }, value);
  return react.createElement(MapContextProvider, {
    value: value
  }, children);
}

MapContext.Provider = WrappedProvider;
/* harmony default export */ const map_context = (MapContext);
//# sourceMappingURL=map-context.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/use-isomorphic-layout-effect.js

var useIsomorphicLayoutEffect = typeof window !== 'undefined' ? react.useLayoutEffect : react.useEffect;
/* harmony default export */ const use_isomorphic_layout_effect = (useIsomorphicLayoutEffect);
//# sourceMappingURL=use-isomorphic-layout-effect.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/terrain.js
function getTerrainElevation(map, _ref) {
  var longitude = _ref.longitude,
      latitude = _ref.latitude;

  if (map && map.queryTerrainElevation) {
    return map.queryTerrainElevation([longitude, latitude]) || 0;
  }

  return 0;
}
//# sourceMappingURL=terrain.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/static-map.js



function static_map_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function static_map_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { static_map_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { static_map_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }













var TOKEN_DOC_URL = 'https://visgl.github.io/react-map-gl/docs/get-started/mapbox-tokens';
var NO_TOKEN_WARNING = 'A valid API access token is required to use Mapbox data';

function static_map_noop() {}

function getViewport(_ref) {
  var map = _ref.map,
      props = _ref.props,
      width = _ref.width,
      height = _ref.height;

  var viewportProps = static_map_objectSpread(static_map_objectSpread(static_map_objectSpread({}, props), props.viewState), {}, {
    width: width,
    height: height
  });

  viewportProps.position = [0, 0, getTerrainElevation(map, viewportProps)];
  return new esm/* WebMercatorViewport */.DW(viewportProps);
}
var UNAUTHORIZED_ERROR_CODE = 401;
var CONTAINER_STYLE = {
  position: 'absolute',
  width: '100%',
  height: '100%',
  overflow: 'hidden'
};
var static_map_propTypes = Object.assign({}, Mapbox.propTypes, {
  width: prop_types.oneOfType([prop_types.number, prop_types.string]),
  height: prop_types.oneOfType([prop_types.number, prop_types.string]),
  onResize: prop_types.func,
  disableTokenWarning: prop_types.bool,
  visible: prop_types.bool,
  className: prop_types.string,
  style: prop_types.object,
  visibilityConstraints: prop_types.object
});
var static_map_defaultProps = Object.assign({}, Mapbox.defaultProps, {
  disableTokenWarning: false,
  visible: true,
  onResize: static_map_noop,
  className: '',
  style: null,
  visibilityConstraints: MAPBOX_LIMITS
});

function NoTokenWarning() {
  var style = {
    position: 'absolute',
    left: 0,
    top: 0
  };
  return react.createElement("div", {
    key: "warning",
    id: "no-token-warning",
    style: style
  }, react.createElement("h3", {
    key: "header"
  }, NO_TOKEN_WARNING), react.createElement("div", {
    key: "text"
  }, "For information on setting up your basemap, read"), react.createElement("a", {
    key: "link",
    href: TOKEN_DOC_URL
  }, "Note on Map Tokens"));
}

function getRefHandles(mapboxRef) {
  return {
    getMap: function getMap() {
      return mapboxRef.current && mapboxRef.current.getMap();
    },
    queryRenderedFeatures: function queryRenderedFeatures(geometry) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var map = mapboxRef.current && mapboxRef.current.getMap();
      return map && map.queryRenderedFeatures(geometry, options);
    }
  };
}

var StaticMap = (0,react.forwardRef)(function (props, ref) {
  var _useState = (0,react.useState)(true),
      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),
      accessTokenValid = _useState2[0],
      setTokenState = _useState2[1];

  var _useState3 = (0,react.useState)({
    width: 0,
    height: 0
  }),
      _useState4 = (0,slicedToArray/* default */.Z)(_useState3, 2),
      size = _useState4[0],
      setSize = _useState4[1];

  var mapboxRef = (0,react.useRef)(null);
  var mapDivRef = (0,react.useRef)(null);
  var containerRef = (0,react.useRef)(null);
  var overlayRef = (0,react.useRef)(null);
  var context = (0,react.useContext)(map_context);
  use_isomorphic_layout_effect(function () {
    if (!StaticMap.supported()) {
      return undefined;
    }

    var mapbox = new Mapbox(static_map_objectSpread(static_map_objectSpread(static_map_objectSpread({}, props), size), {}, {
      mapboxgl: (mapbox_gl_default()),
      container: mapDivRef.current,
      onError: function onError(evt) {
        var statusCode = evt.error && evt.error.status || evt.status;

        if (statusCode === UNAUTHORIZED_ERROR_CODE && accessTokenValid) {
          console.error(NO_TOKEN_WARNING);
          setTokenState(false);
        }

        props.onError(evt);
      }
    }));
    mapboxRef.current = mapbox;

    if (context && context.setMap) {
      context.setMap(mapbox.getMap());
    }

    var resizeObserver = new ResizeObserver_es["default"](function (entries) {
      if (entries[0].contentRect) {
        var _entries$0$contentRec = entries[0].contentRect,
            _width = _entries$0$contentRec.width,
            _height = _entries$0$contentRec.height;
        setSize({
          width: _width,
          height: _height
        });
        props.onResize({
          width: _width,
          height: _height
        });
      }
    });
    resizeObserver.observe(containerRef.current);
    return function () {
      mapbox.finalize();
      mapboxRef.current = null;
      resizeObserver.disconnect();
    };
  }, []);
  use_isomorphic_layout_effect(function () {
    if (mapboxRef.current) {
      mapboxRef.current.setProps(static_map_objectSpread(static_map_objectSpread({}, props), size));
    }
  });
  var map = mapboxRef.current && mapboxRef.current.getMap();
  (0,react.useImperativeHandle)(ref, function () {
    return getRefHandles(mapboxRef);
  }, []);
  var preventScroll = (0,react.useCallback)(function (_ref2) {
    var target = _ref2.target;

    if (target === overlayRef.current) {
      target.scrollTo(0, 0);
    }
  }, []);
  var overlays = map && react.createElement(MapContextProvider, {
    value: static_map_objectSpread(static_map_objectSpread({}, context), {}, {
      viewport: context.viewport || getViewport(static_map_objectSpread({
        map: map,
        props: props
      }, size)),
      map: map,
      container: context.container || containerRef.current
    })
  }, react.createElement("div", {
    key: "map-overlays",
    className: "overlays",
    ref: overlayRef,
    style: CONTAINER_STYLE,
    onScroll: preventScroll
  }, props.children));
  var className = props.className,
      width = props.width,
      height = props.height,
      style = props.style,
      visibilityConstraints = props.visibilityConstraints;
  var mapContainerStyle = Object.assign({
    position: 'relative'
  }, style, {
    width: width,
    height: height
  });
  var visible = props.visible && checkVisibilityConstraints(props.viewState || props, visibilityConstraints);
  var mapStyle = Object.assign({}, CONTAINER_STYLE, {
    visibility: visible ? 'inherit' : 'hidden'
  });
  return react.createElement("div", {
    key: "map-container",
    ref: containerRef,
    style: mapContainerStyle
  }, react.createElement("div", {
    key: "map-mapbox",
    ref: mapDivRef,
    style: mapStyle,
    className: className
  }), overlays, !accessTokenValid && !props.disableTokenWarning && react.createElement(NoTokenWarning, null));
});

StaticMap.supported = function () {
  return (mapbox_gl_default()) && mapbox_gl_default().supported();
};

StaticMap.propTypes = static_map_propTypes;
StaticMap.defaultProps = static_map_defaultProps;
/* harmony default export */ const static_map = (StaticMap);
//# sourceMappingURL=static-map.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/transition/transition-interpolator.js




function transition_interpolator_createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = transition_interpolator_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function transition_interpolator_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return transition_interpolator_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return transition_interpolator_arrayLikeToArray(o, minLen); }

function transition_interpolator_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }




var TransitionInterpolator = function () {
  function TransitionInterpolator() {
    (0,classCallCheck/* default */.Z)(this, TransitionInterpolator);

    (0,defineProperty/* default */.Z)(this, "propNames", []);
  }

  (0,createClass/* default */.Z)(TransitionInterpolator, [{
    key: "arePropsEqual",
    value: function arePropsEqual(currentProps, nextProps) {
      var _iterator = transition_interpolator_createForOfIteratorHelper(this.propNames || []),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var key = _step.value;

          if (!equals(currentProps[key], nextProps[key])) {
            return false;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return true;
    }
  }, {
    key: "initializeProps",
    value: function initializeProps(startProps, endProps) {
      return {
        start: startProps,
        end: endProps
      };
    }
  }, {
    key: "interpolateProps",
    value: function interpolateProps(startProps, endProps, t) {
      assert(false, 'interpolateProps is not implemented');
    }
  }, {
    key: "getDuration",
    value: function getDuration(startProps, endProps) {
      return endProps.transitionDuration;
    }
  }]);

  return TransitionInterpolator;
}();


//# sourceMappingURL=transition-interpolator.js.map
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js
var assertThisInitialized = __webpack_require__(97326);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/inherits.js
var inherits = __webpack_require__(60136);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(82963);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(61120);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/transition/transition-utils.js
var WRAPPED_ANGULAR_PROPS = {
  longitude: 1,
  bearing: 1
};
function mod(value, divisor) {
  var modulus = value % divisor;
  return modulus < 0 ? divisor + modulus : modulus;
}
function isValid(prop) {
  return Number.isFinite(prop) || Array.isArray(prop);
}

function isWrappedAngularProp(propName) {
  return propName in WRAPPED_ANGULAR_PROPS;
}

function getEndValueByShortestPath(propName, startValue, endValue) {
  if (isWrappedAngularProp(propName) && Math.abs(endValue - startValue) > 180) {
    endValue = endValue < 0 ? endValue + 360 : endValue - 360;
  }

  return endValue;
}
//# sourceMappingURL=transition-utils.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/transition/viewport-fly-to-interpolator.js








function viewport_fly_to_interpolator_createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = viewport_fly_to_interpolator_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function viewport_fly_to_interpolator_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return viewport_fly_to_interpolator_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return viewport_fly_to_interpolator_arrayLikeToArray(o, minLen); }

function viewport_fly_to_interpolator_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0,getPrototypeOf/* default */.Z)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0,getPrototypeOf/* default */.Z)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0,possibleConstructorReturn/* default */.Z)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var VIEWPORT_TRANSITION_PROPS = ['longitude', 'latitude', 'zoom', 'bearing', 'pitch'];
var REQUIRED_PROPS = ['latitude', 'longitude', 'zoom', 'width', 'height'];
var LINEARLY_INTERPOLATED_PROPS = ['bearing', 'pitch'];
var DEFAULT_OPTS = {
  speed: 1.2,
  curve: 1.414
};

var ViewportFlyToInterpolator = function (_TransitionInterpolat) {
  (0,inherits/* default */.Z)(ViewportFlyToInterpolator, _TransitionInterpolat);

  var _super = _createSuper(ViewportFlyToInterpolator);

  function ViewportFlyToInterpolator() {
    var _this;

    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    (0,classCallCheck/* default */.Z)(this, ViewportFlyToInterpolator);

    _this = _super.call(this);

    (0,defineProperty/* default */.Z)((0,assertThisInitialized/* default */.Z)(_this), "propNames", VIEWPORT_TRANSITION_PROPS);

    _this.props = Object.assign({}, DEFAULT_OPTS, props);
    return _this;
  }

  (0,createClass/* default */.Z)(ViewportFlyToInterpolator, [{
    key: "initializeProps",
    value: function initializeProps(startProps, endProps) {
      var startViewportProps = {};
      var endViewportProps = {};

      var _iterator = viewport_fly_to_interpolator_createForOfIteratorHelper(REQUIRED_PROPS),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var key = _step.value;
          var startValue = startProps[key];
          var endValue = endProps[key];
          assert(isValid(startValue) && isValid(endValue), "".concat(key, " must be supplied for transition"));
          startViewportProps[key] = startValue;
          endViewportProps[key] = getEndValueByShortestPath(key, startValue, endValue);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      var _iterator2 = viewport_fly_to_interpolator_createForOfIteratorHelper(LINEARLY_INTERPOLATED_PROPS),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _key = _step2.value;

          var _startValue = startProps[_key] || 0;

          var _endValue = endProps[_key] || 0;

          startViewportProps[_key] = _startValue;
          endViewportProps[_key] = getEndValueByShortestPath(_key, _startValue, _endValue);
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      return {
        start: startViewportProps,
        end: endViewportProps
      };
    }
  }, {
    key: "interpolateProps",
    value: function interpolateProps(startProps, endProps, t) {
      var viewport = (0,esm/* flyToViewport */["if"])(startProps, endProps, t, this.props);

      var _iterator3 = viewport_fly_to_interpolator_createForOfIteratorHelper(LINEARLY_INTERPOLATED_PROPS),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var key = _step3.value;
          viewport[key] = lerp(startProps[key], endProps[key], t);
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      return viewport;
    }
  }, {
    key: "getDuration",
    value: function getDuration(startProps, endProps) {
      var transitionDuration = endProps.transitionDuration;

      if (transitionDuration === 'auto') {
        transitionDuration = (0,esm/* getFlyToDuration */.up)(startProps, endProps, this.props);
      }

      return transitionDuration;
    }
  }]);

  return ViewportFlyToInterpolator;
}(TransitionInterpolator);


//# sourceMappingURL=viewport-fly-to-interpolator.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/transition/linear-interpolator.js







function linear_interpolator_createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = linear_interpolator_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function linear_interpolator_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return linear_interpolator_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return linear_interpolator_arrayLikeToArray(o, minLen); }

function linear_interpolator_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function linear_interpolator_createSuper(Derived) { var hasNativeReflectConstruct = linear_interpolator_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0,getPrototypeOf/* default */.Z)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0,getPrototypeOf/* default */.Z)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0,possibleConstructorReturn/* default */.Z)(this, result); }; }

function linear_interpolator_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var linear_interpolator_VIEWPORT_TRANSITION_PROPS = ['longitude', 'latitude', 'zoom', 'bearing', 'pitch'];

var LinearInterpolator = function (_TransitionInterpolat) {
  (0,inherits/* default */.Z)(LinearInterpolator, _TransitionInterpolat);

  var _super = linear_interpolator_createSuper(LinearInterpolator);

  function LinearInterpolator() {
    var _this;

    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    (0,classCallCheck/* default */.Z)(this, LinearInterpolator);

    _this = _super.call(this);

    if (Array.isArray(opts)) {
      opts = {
        transitionProps: opts
      };
    }

    _this.propNames = opts.transitionProps || linear_interpolator_VIEWPORT_TRANSITION_PROPS;

    if (opts.around) {
      _this.around = opts.around;
    }

    return _this;
  }

  (0,createClass/* default */.Z)(LinearInterpolator, [{
    key: "initializeProps",
    value: function initializeProps(startProps, endProps) {
      var startViewportProps = {};
      var endViewportProps = {};

      if (this.around) {
        startViewportProps.around = this.around;
        var aroundLngLat = new esm/* WebMercatorViewport */.DW(startProps).unproject(this.around);
        Object.assign(endViewportProps, endProps, {
          around: new esm/* WebMercatorViewport */.DW(endProps).project(aroundLngLat),
          aroundLngLat: aroundLngLat
        });
      }

      var _iterator = linear_interpolator_createForOfIteratorHelper(this.propNames),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var key = _step.value;
          var startValue = startProps[key];
          var endValue = endProps[key];
          assert(isValid(startValue) && isValid(endValue), "".concat(key, " must be supplied for transition"));
          startViewportProps[key] = startValue;
          endViewportProps[key] = getEndValueByShortestPath(key, startValue, endValue);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return {
        start: startViewportProps,
        end: endViewportProps
      };
    }
  }, {
    key: "interpolateProps",
    value: function interpolateProps(startProps, endProps, t) {
      var viewport = {};

      var _iterator2 = linear_interpolator_createForOfIteratorHelper(this.propNames),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var key = _step2.value;
          viewport[key] = lerp(startProps[key], endProps[key], t);
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      if (endProps.around) {
        var _WebMercatorViewport$ = new esm/* WebMercatorViewport */.DW(Object.assign({}, endProps, viewport)).getMapCenterByLngLatPosition({
          lngLat: endProps.aroundLngLat,
          pos: lerp(startProps.around, endProps.around, t)
        }),
            _WebMercatorViewport$2 = (0,slicedToArray/* default */.Z)(_WebMercatorViewport$, 2),
            longitude = _WebMercatorViewport$2[0],
            latitude = _WebMercatorViewport$2[1];

        viewport.longitude = longitude;
        viewport.latitude = latitude;
      }

      return viewport;
    }
  }]);

  return LinearInterpolator;
}(TransitionInterpolator);


//# sourceMappingURL=linear-interpolator.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/transition/index.js



//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/transition-manager.js







var transition_manager_noop = function noop() {};

function cropEasingFunction(easing, x0) {
  var y0 = easing(x0);
  return function (t) {
    return 1 / (1 - y0) * (easing(t * (1 - x0) + x0) - y0);
  };
}
var TRANSITION_EVENTS = {
  BREAK: 1,
  SNAP_TO_END: 2,
  IGNORE: 3,
  UPDATE: 4
};
var DEFAULT_PROPS = {
  transitionDuration: 0,
  transitionEasing: function transitionEasing(t) {
    return t;
  },
  transitionInterpolator: new LinearInterpolator(),
  transitionInterruption: TRANSITION_EVENTS.BREAK,
  onTransitionStart: transition_manager_noop,
  onTransitionInterrupt: transition_manager_noop,
  onTransitionEnd: transition_manager_noop
};

var TransitionManager = function () {
  function TransitionManager() {
    var _this = this;

    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    (0,classCallCheck/* default */.Z)(this, TransitionManager);

    (0,defineProperty/* default */.Z)(this, "_animationFrame", null);

    (0,defineProperty/* default */.Z)(this, "_onTransitionFrame", function () {
      _this._animationFrame = requestAnimationFrame(_this._onTransitionFrame);

      _this._updateViewport();
    });

    this.props = null;
    this.onViewportChange = opts.onViewportChange || transition_manager_noop;
    this.onStateChange = opts.onStateChange || transition_manager_noop;
    this.time = opts.getTime || Date.now;
  }

  (0,createClass/* default */.Z)(TransitionManager, [{
    key: "getViewportInTransition",
    value: function getViewportInTransition() {
      return this._animationFrame ? this.state.propsInTransition : null;
    }
  }, {
    key: "processViewportChange",
    value: function processViewportChange(nextProps) {
      var currentProps = this.props;
      this.props = nextProps;

      if (!currentProps || this._shouldIgnoreViewportChange(currentProps, nextProps)) {
        return false;
      }

      if (this._isTransitionEnabled(nextProps)) {
        var startProps = Object.assign({}, currentProps);
        var endProps = Object.assign({}, nextProps);

        if (this._isTransitionInProgress()) {
          currentProps.onTransitionInterrupt();

          if (this.state.interruption === TRANSITION_EVENTS.SNAP_TO_END) {
            Object.assign(startProps, this.state.endProps);
          } else {
            Object.assign(startProps, this.state.propsInTransition);
          }

          if (this.state.interruption === TRANSITION_EVENTS.UPDATE) {
            var currentTime = this.time();
            var x0 = (currentTime - this.state.startTime) / this.state.duration;
            endProps.transitionDuration = this.state.duration - (currentTime - this.state.startTime);
            endProps.transitionEasing = cropEasingFunction(this.state.easing, x0);
            endProps.transitionInterpolator = startProps.transitionInterpolator;
          }
        }

        endProps.onTransitionStart();

        this._triggerTransition(startProps, endProps);

        return true;
      }

      if (this._isTransitionInProgress()) {
        currentProps.onTransitionInterrupt();

        this._endTransition();
      }

      return false;
    }
  }, {
    key: "_isTransitionInProgress",
    value: function _isTransitionInProgress() {
      return Boolean(this._animationFrame);
    }
  }, {
    key: "_isTransitionEnabled",
    value: function _isTransitionEnabled(props) {
      var transitionDuration = props.transitionDuration,
          transitionInterpolator = props.transitionInterpolator;
      return (transitionDuration > 0 || transitionDuration === 'auto') && Boolean(transitionInterpolator);
    }
  }, {
    key: "_isUpdateDueToCurrentTransition",
    value: function _isUpdateDueToCurrentTransition(props) {
      if (this.state.propsInTransition) {
        return this.state.interpolator.arePropsEqual(props, this.state.propsInTransition);
      }

      return false;
    }
  }, {
    key: "_shouldIgnoreViewportChange",
    value: function _shouldIgnoreViewportChange(currentProps, nextProps) {
      if (!currentProps) {
        return true;
      }

      if (this._isTransitionInProgress()) {
        return this.state.interruption === TRANSITION_EVENTS.IGNORE || this._isUpdateDueToCurrentTransition(nextProps);
      }

      if (this._isTransitionEnabled(nextProps)) {
        return nextProps.transitionInterpolator.arePropsEqual(currentProps, nextProps);
      }

      return true;
    }
  }, {
    key: "_triggerTransition",
    value: function _triggerTransition(startProps, endProps) {
      assert(this._isTransitionEnabled(endProps));

      if (this._animationFrame) {
        cancelAnimationFrame(this._animationFrame);
      }

      var transitionInterpolator = endProps.transitionInterpolator;
      var duration = transitionInterpolator.getDuration ? transitionInterpolator.getDuration(startProps, endProps) : endProps.transitionDuration;

      if (duration === 0) {
        return;
      }

      var initialProps = endProps.transitionInterpolator.initializeProps(startProps, endProps);
      var interactionState = {
        inTransition: true,
        isZooming: startProps.zoom !== endProps.zoom,
        isPanning: startProps.longitude !== endProps.longitude || startProps.latitude !== endProps.latitude,
        isRotating: startProps.bearing !== endProps.bearing || startProps.pitch !== endProps.pitch
      };
      this.state = {
        duration: duration,
        easing: endProps.transitionEasing,
        interpolator: endProps.transitionInterpolator,
        interruption: endProps.transitionInterruption,
        startTime: this.time(),
        startProps: initialProps.start,
        endProps: initialProps.end,
        animation: null,
        propsInTransition: {}
      };

      this._onTransitionFrame();

      this.onStateChange(interactionState);
    }
  }, {
    key: "_endTransition",
    value: function _endTransition() {
      if (this._animationFrame) {
        cancelAnimationFrame(this._animationFrame);
        this._animationFrame = null;
      }

      this.onStateChange({
        inTransition: false,
        isZooming: false,
        isPanning: false,
        isRotating: false
      });
    }
  }, {
    key: "_updateViewport",
    value: function _updateViewport() {
      var currentTime = this.time();
      var _this$state = this.state,
          startTime = _this$state.startTime,
          duration = _this$state.duration,
          easing = _this$state.easing,
          interpolator = _this$state.interpolator,
          startProps = _this$state.startProps,
          endProps = _this$state.endProps;
      var shouldEnd = false;
      var t = (currentTime - startTime) / duration;

      if (t >= 1) {
        t = 1;
        shouldEnd = true;
      }

      t = easing(t);
      var viewport = interpolator.interpolateProps(startProps, endProps, t);
      var mapState = new MapState(Object.assign({}, this.props, viewport));
      this.state.propsInTransition = mapState.getViewportProps();
      this.onViewportChange(this.state.propsInTransition, this.props);

      if (shouldEnd) {
        this._endTransition();

        this.props.onTransitionEnd();
      }
    }
  }]);

  return TransitionManager;
}();

(0,defineProperty/* default */.Z)(TransitionManager, "defaultProps", DEFAULT_PROPS);


//# sourceMappingURL=transition-manager.js.map
// EXTERNAL MODULE: ./node_modules/mjolnir.js/dist/esm/index.js + 11 modules
var dist_esm = __webpack_require__(42317);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/map-controller.js




function map_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function map_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { map_controller_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { map_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }




var NO_TRANSITION_PROPS = {
  transitionDuration: 0
};
var LINEAR_TRANSITION_PROPS = {
  transitionDuration: 300,
  transitionEasing: function transitionEasing(t) {
    return t;
  },
  transitionInterpolator: new LinearInterpolator(),
  transitionInterruption: TRANSITION_EVENTS.BREAK
};
var DEFAULT_INERTIA = 300;

var INERTIA_EASING = function INERTIA_EASING(t) {
  return 1 - (1 - t) * (1 - t);
};

var EVENT_TYPES = {
  WHEEL: ['wheel'],
  PAN: ['panstart', 'panmove', 'panend'],
  PINCH: ['pinchstart', 'pinchmove', 'pinchend'],
  TRIPLE_PAN: ['tripanstart', 'tripanmove', 'tripanend'],
  DOUBLE_TAP: ['doubletap'],
  KEYBOARD: ['keydown']
};

var MapController = function () {
  function MapController() {
    var _this = this;

    (0,classCallCheck/* default */.Z)(this, MapController);

    (0,defineProperty/* default */.Z)(this, "events", []);

    (0,defineProperty/* default */.Z)(this, "scrollZoom", true);

    (0,defineProperty/* default */.Z)(this, "dragPan", true);

    (0,defineProperty/* default */.Z)(this, "dragRotate", true);

    (0,defineProperty/* default */.Z)(this, "doubleClickZoom", true);

    (0,defineProperty/* default */.Z)(this, "touchZoom", true);

    (0,defineProperty/* default */.Z)(this, "touchRotate", false);

    (0,defineProperty/* default */.Z)(this, "keyboard", true);

    (0,defineProperty/* default */.Z)(this, "_interactionState", {
      isDragging: false
    });

    (0,defineProperty/* default */.Z)(this, "_events", {});

    (0,defineProperty/* default */.Z)(this, "_setInteractionState", function (newState) {
      Object.assign(_this._interactionState, newState);

      if (_this.onStateChange) {
        _this.onStateChange(_this._interactionState);
      }
    });

    (0,defineProperty/* default */.Z)(this, "_onTransition", function (newViewport, oldViewport) {
      _this.onViewportChange(newViewport, _this._interactionState, oldViewport);
    });

    this.handleEvent = this.handleEvent.bind(this);
    this._transitionManager = new TransitionManager({
      onViewportChange: this._onTransition,
      onStateChange: this._setInteractionState
    });
  }

  (0,createClass/* default */.Z)(MapController, [{
    key: "handleEvent",
    value: function handleEvent(event) {
      this.mapState = this.getMapState();
      var eventStartBlocked = this._eventStartBlocked;

      switch (event.type) {
        case 'panstart':
          return eventStartBlocked ? false : this._onPanStart(event);

        case 'panmove':
          return this._onPan(event);

        case 'panend':
          return this._onPanEnd(event);

        case 'pinchstart':
          return eventStartBlocked ? false : this._onPinchStart(event);

        case 'pinchmove':
          return this._onPinch(event);

        case 'pinchend':
          return this._onPinchEnd(event);

        case 'tripanstart':
          return eventStartBlocked ? false : this._onTriplePanStart(event);

        case 'tripanmove':
          return this._onTriplePan(event);

        case 'tripanend':
          return this._onTriplePanEnd(event);

        case 'doubletap':
          return this._onDoubleTap(event);

        case 'wheel':
          return this._onWheel(event);

        case 'keydown':
          return this._onKeyDown(event);

        default:
          return false;
      }
    }
  }, {
    key: "getCenter",
    value: function getCenter(event) {
      var _event$offsetCenter = event.offsetCenter,
          x = _event$offsetCenter.x,
          y = _event$offsetCenter.y;
      return [x, y];
    }
  }, {
    key: "isFunctionKeyPressed",
    value: function isFunctionKeyPressed(event) {
      var srcEvent = event.srcEvent;
      return Boolean(srcEvent.metaKey || srcEvent.altKey || srcEvent.ctrlKey || srcEvent.shiftKey);
    }
  }, {
    key: "blockEvents",
    value: function blockEvents(timeout) {
      var _this2 = this;

      var timer = setTimeout(function () {
        if (_this2._eventStartBlocked === timer) {
          _this2._eventStartBlocked = null;
        }
      }, timeout);
      this._eventStartBlocked = timer;
    }
  }, {
    key: "updateViewport",
    value: function updateViewport(newMapState, extraProps, interactionState) {
      var oldViewport = this.mapState instanceof MapState ? this.mapState.getViewportProps() : this.mapState;

      var newViewport = map_controller_objectSpread(map_controller_objectSpread({}, newMapState.getViewportProps()), extraProps);

      var viewStateChanged = Object.keys(newViewport).some(function (key) {
        return oldViewport[key] !== newViewport[key];
      });
      this._state = newMapState.getState();

      this._setInteractionState(interactionState);

      if (viewStateChanged) {
        this.onViewportChange(newViewport, this._interactionState, oldViewport);
      }
    }
  }, {
    key: "getMapState",
    value: function getMapState(overrides) {
      return new MapState(map_controller_objectSpread(map_controller_objectSpread(map_controller_objectSpread({}, this.mapStateProps), this._state), overrides));
    }
  }, {
    key: "isDragging",
    value: function isDragging() {
      return this._interactionState.isDragging;
    }
  }, {
    key: "setOptions",
    value: function setOptions(options) {
      var onViewportChange = options.onViewportChange,
          onStateChange = options.onStateChange,
          _options$eventManager = options.eventManager,
          eventManager = _options$eventManager === void 0 ? this.eventManager : _options$eventManager,
          _options$isInteractiv = options.isInteractive,
          isInteractive = _options$isInteractiv === void 0 ? true : _options$isInteractiv,
          _options$scrollZoom = options.scrollZoom,
          scrollZoom = _options$scrollZoom === void 0 ? this.scrollZoom : _options$scrollZoom,
          _options$dragPan = options.dragPan,
          dragPan = _options$dragPan === void 0 ? this.dragPan : _options$dragPan,
          _options$dragRotate = options.dragRotate,
          dragRotate = _options$dragRotate === void 0 ? this.dragRotate : _options$dragRotate,
          _options$doubleClickZ = options.doubleClickZoom,
          doubleClickZoom = _options$doubleClickZ === void 0 ? this.doubleClickZoom : _options$doubleClickZ,
          _options$touchZoom = options.touchZoom,
          touchZoom = _options$touchZoom === void 0 ? this.touchZoom : _options$touchZoom,
          _options$touchRotate = options.touchRotate,
          touchRotate = _options$touchRotate === void 0 ? this.touchRotate : _options$touchRotate,
          _options$keyboard = options.keyboard,
          keyboard = _options$keyboard === void 0 ? this.keyboard : _options$keyboard;
      this.onViewportChange = onViewportChange;
      this.onStateChange = onStateChange;
      var prevOptions = this.mapStateProps || {};
      var dimensionChanged = prevOptions.height !== options.height || prevOptions.width !== options.width;
      this.mapStateProps = options;

      if (dimensionChanged) {
        this.mapState = prevOptions;
        this.updateViewport(new MapState(options));
      }

      this._transitionManager.processViewportChange(options);

      if (this.eventManager !== eventManager) {
        this.eventManager = eventManager;
        this._events = {};
        this.toggleEvents(this.events, true);
      }

      this.toggleEvents(EVENT_TYPES.WHEEL, isInteractive && Boolean(scrollZoom));
      this.toggleEvents(EVENT_TYPES.PAN, isInteractive && Boolean(dragPan || dragRotate));
      this.toggleEvents(EVENT_TYPES.PINCH, isInteractive && Boolean(touchZoom || touchRotate));
      this.toggleEvents(EVENT_TYPES.TRIPLE_PAN, isInteractive && Boolean(touchRotate));
      this.toggleEvents(EVENT_TYPES.DOUBLE_TAP, isInteractive && Boolean(doubleClickZoom));
      this.toggleEvents(EVENT_TYPES.KEYBOARD, isInteractive && Boolean(keyboard));
      this.scrollZoom = scrollZoom;
      this.dragPan = dragPan;
      this.dragRotate = dragRotate;
      this.doubleClickZoom = doubleClickZoom;
      this.touchZoom = touchZoom;
      this.touchRotate = touchRotate;
      this.keyboard = keyboard;
    }
  }, {
    key: "toggleEvents",
    value: function toggleEvents(eventNames, enabled) {
      var _this3 = this;

      if (this.eventManager) {
        eventNames.forEach(function (eventName) {
          if (_this3._events[eventName] !== enabled) {
            _this3._events[eventName] = enabled;

            if (enabled) {
              _this3.eventManager.on(eventName, _this3.handleEvent);
            } else {
              _this3.eventManager.off(eventName, _this3.handleEvent);
            }
          }
        });
      }
    }
  }, {
    key: "_onPanStart",
    value: function _onPanStart(event) {
      var pos = this.getCenter(event);
      this._panRotate = this.isFunctionKeyPressed(event) || event.rightButton;
      var newMapState = this._panRotate ? this.mapState.rotateStart({
        pos: pos
      }) : this.mapState.panStart({
        pos: pos
      });
      this.updateViewport(newMapState, NO_TRANSITION_PROPS, {
        isDragging: true
      });
      return true;
    }
  }, {
    key: "_onPan",
    value: function _onPan(event) {
      if (!this.isDragging()) {
        return false;
      }

      return this._panRotate ? this._onPanRotate(event) : this._onPanMove(event);
    }
  }, {
    key: "_onPanEnd",
    value: function _onPanEnd(event) {
      if (!this.isDragging()) {
        return false;
      }

      return this._panRotate ? this._onPanRotateEnd(event) : this._onPanMoveEnd(event);
    }
  }, {
    key: "_onPanMove",
    value: function _onPanMove(event) {
      if (!this.dragPan) {
        return false;
      }

      var pos = this.getCenter(event);
      var newMapState = this.mapState.pan({
        pos: pos
      });
      this.updateViewport(newMapState, NO_TRANSITION_PROPS, {
        isPanning: true
      });
      return true;
    }
  }, {
    key: "_onPanMoveEnd",
    value: function _onPanMoveEnd(event) {
      if (this.dragPan) {
        var _this$dragPan$inertia = this.dragPan.inertia,
            inertia = _this$dragPan$inertia === void 0 ? DEFAULT_INERTIA : _this$dragPan$inertia;

        if (inertia && event.velocity) {
          var pos = this.getCenter(event);
          var endPos = [pos[0] + event.velocityX * inertia / 2, pos[1] + event.velocityY * inertia / 2];
          var newControllerState = this.mapState.pan({
            pos: endPos
          }).panEnd();
          this.updateViewport(newControllerState, map_controller_objectSpread(map_controller_objectSpread({}, LINEAR_TRANSITION_PROPS), {}, {
            transitionDuration: inertia,
            transitionEasing: INERTIA_EASING
          }), {
            isDragging: false,
            isPanning: true
          });
          return true;
        }
      }

      var newMapState = this.mapState.panEnd();
      this.updateViewport(newMapState, null, {
        isDragging: false,
        isPanning: false
      });
      return true;
    }
  }, {
    key: "_onPanRotate",
    value: function _onPanRotate(event) {
      if (!this.dragRotate) {
        return false;
      }

      var pos = this.getCenter(event);
      var newMapState = this.mapState.rotate({
        pos: pos
      });
      this.updateViewport(newMapState, NO_TRANSITION_PROPS, {
        isRotating: true
      });
      return true;
    }
  }, {
    key: "_onPanRotateEnd",
    value: function _onPanRotateEnd(event) {
      if (this.dragRotate) {
        var _this$dragRotate$iner = this.dragRotate.inertia,
            inertia = _this$dragRotate$iner === void 0 ? DEFAULT_INERTIA : _this$dragRotate$iner;

        if (inertia && event.velocity) {
          var pos = this.getCenter(event);
          var endPos = [pos[0] + event.velocityX * inertia / 2, pos[1] + event.velocityY * inertia / 2];
          var newControllerState = this.mapState.rotate({
            pos: endPos
          }).rotateEnd();
          this.updateViewport(newControllerState, map_controller_objectSpread(map_controller_objectSpread({}, LINEAR_TRANSITION_PROPS), {}, {
            transitionDuration: inertia,
            transitionEasing: INERTIA_EASING
          }), {
            isDragging: false,
            isRotating: true
          });
          return true;
        }
      }

      var newMapState = this.mapState.panEnd();
      this.updateViewport(newMapState, null, {
        isDragging: false,
        isRotating: false
      });
      return true;
    }
  }, {
    key: "_onWheel",
    value: function _onWheel(event) {
      if (!this.scrollZoom) {
        return false;
      }

      var _this$scrollZoom = this.scrollZoom,
          _this$scrollZoom$spee = _this$scrollZoom.speed,
          speed = _this$scrollZoom$spee === void 0 ? 0.01 : _this$scrollZoom$spee,
          _this$scrollZoom$smoo = _this$scrollZoom.smooth,
          smooth = _this$scrollZoom$smoo === void 0 ? false : _this$scrollZoom$smoo;
      event.preventDefault();
      var pos = this.getCenter(event);
      var delta = event.delta;
      var scale = 2 / (1 + Math.exp(-Math.abs(delta * speed)));

      if (delta < 0 && scale !== 0) {
        scale = 1 / scale;
      }

      var newMapState = this.mapState.zoom({
        pos: pos,
        scale: scale
      });
      this.updateViewport(newMapState, map_controller_objectSpread(map_controller_objectSpread({}, LINEAR_TRANSITION_PROPS), {}, {
        transitionInterpolator: new LinearInterpolator({
          around: pos
        }),
        transitionDuration: smooth ? 250 : 1
      }), {
        isPanning: true,
        isZooming: true
      });
      return true;
    }
  }, {
    key: "_onPinchStart",
    value: function _onPinchStart(event) {
      var pos = this.getCenter(event);
      var newMapState = this.mapState.zoomStart({
        pos: pos
      }).rotateStart({
        pos: pos
      });
      this._startPinchRotation = event.rotation;
      this._lastPinchEvent = event;
      this.updateViewport(newMapState, NO_TRANSITION_PROPS, {
        isDragging: true
      });
      return true;
    }
  }, {
    key: "_onPinch",
    value: function _onPinch(event) {
      if (!this.isDragging()) {
        return false;
      }

      if (!this.touchZoom && !this.touchRotate) {
        return false;
      }

      var newMapState = this.mapState;

      if (this.touchZoom) {
        var scale = event.scale;
        var pos = this.getCenter(event);
        newMapState = newMapState.zoom({
          pos: pos,
          scale: scale
        });
      }

      if (this.touchRotate) {
        var rotation = event.rotation;
        newMapState = newMapState.rotate({
          deltaAngleX: this._startPinchRotation - rotation
        });
      }

      this.updateViewport(newMapState, NO_TRANSITION_PROPS, {
        isDragging: true,
        isPanning: Boolean(this.touchZoom),
        isZooming: Boolean(this.touchZoom),
        isRotating: Boolean(this.touchRotate)
      });
      this._lastPinchEvent = event;
      return true;
    }
  }, {
    key: "_onPinchEnd",
    value: function _onPinchEnd(event) {
      if (!this.isDragging()) {
        return false;
      }

      if (this.touchZoom) {
        var _this$touchZoom$inert = this.touchZoom.inertia,
            inertia = _this$touchZoom$inert === void 0 ? DEFAULT_INERTIA : _this$touchZoom$inert;
        var _lastPinchEvent = this._lastPinchEvent;

        if (inertia && _lastPinchEvent && event.scale !== _lastPinchEvent.scale) {
          var pos = this.getCenter(event);

          var _newMapState = this.mapState.rotateEnd();

          var z = Math.log2(event.scale);

          var velocityZ = (z - Math.log2(_lastPinchEvent.scale)) / (event.deltaTime - _lastPinchEvent.deltaTime);

          var endScale = Math.pow(2, z + velocityZ * inertia / 2);
          _newMapState = _newMapState.zoom({
            pos: pos,
            scale: endScale
          }).zoomEnd();
          this.updateViewport(_newMapState, map_controller_objectSpread(map_controller_objectSpread({}, LINEAR_TRANSITION_PROPS), {}, {
            transitionInterpolator: new LinearInterpolator({
              around: pos
            }),
            transitionDuration: inertia,
            transitionEasing: INERTIA_EASING
          }), {
            isDragging: false,
            isPanning: Boolean(this.touchZoom),
            isZooming: Boolean(this.touchZoom),
            isRotating: false
          });
          this.blockEvents(inertia);
          return true;
        }
      }

      var newMapState = this.mapState.zoomEnd().rotateEnd();
      this._state.startPinchRotation = 0;
      this.updateViewport(newMapState, null, {
        isDragging: false,
        isPanning: false,
        isZooming: false,
        isRotating: false
      });
      this._startPinchRotation = null;
      this._lastPinchEvent = null;
      return true;
    }
  }, {
    key: "_onTriplePanStart",
    value: function _onTriplePanStart(event) {
      var pos = this.getCenter(event);
      var newMapState = this.mapState.rotateStart({
        pos: pos
      });
      this.updateViewport(newMapState, NO_TRANSITION_PROPS, {
        isDragging: true
      });
      return true;
    }
  }, {
    key: "_onTriplePan",
    value: function _onTriplePan(event) {
      if (!this.isDragging()) {
        return false;
      }

      if (!this.touchRotate) {
        return false;
      }

      var pos = this.getCenter(event);
      pos[0] -= event.deltaX;
      var newMapState = this.mapState.rotate({
        pos: pos
      });
      this.updateViewport(newMapState, NO_TRANSITION_PROPS, {
        isRotating: true
      });
      return true;
    }
  }, {
    key: "_onTriplePanEnd",
    value: function _onTriplePanEnd(event) {
      if (!this.isDragging()) {
        return false;
      }

      if (this.touchRotate) {
        var _this$touchRotate$ine = this.touchRotate.inertia,
            inertia = _this$touchRotate$ine === void 0 ? DEFAULT_INERTIA : _this$touchRotate$ine;

        if (inertia && event.velocityY) {
          var pos = this.getCenter(event);
          var endPos = [pos[0], pos[1] += event.velocityY * inertia / 2];

          var _newMapState2 = this.mapState.rotate({
            pos: endPos
          });

          this.updateViewport(_newMapState2, map_controller_objectSpread(map_controller_objectSpread({}, LINEAR_TRANSITION_PROPS), {}, {
            transitionDuration: inertia,
            transitionEasing: INERTIA_EASING
          }), {
            isDragging: false,
            isRotating: true
          });
          this.blockEvents(inertia);
          return false;
        }
      }

      var newMapState = this.mapState.rotateEnd();
      this.updateViewport(newMapState, null, {
        isDragging: false,
        isRotating: false
      });
      return true;
    }
  }, {
    key: "_onDoubleTap",
    value: function _onDoubleTap(event) {
      if (!this.doubleClickZoom) {
        return false;
      }

      var pos = this.getCenter(event);
      var isZoomOut = this.isFunctionKeyPressed(event);
      var newMapState = this.mapState.zoom({
        pos: pos,
        scale: isZoomOut ? 0.5 : 2
      });
      this.updateViewport(newMapState, Object.assign({}, LINEAR_TRANSITION_PROPS, {
        transitionInterpolator: new LinearInterpolator({
          around: pos
        })
      }), {
        isZooming: true
      });
      return true;
    }
  }, {
    key: "_onKeyDown",
    value: function _onKeyDown(event) {
      if (!this.keyboard) {
        return false;
      }

      var funcKey = this.isFunctionKeyPressed(event);
      var _this$keyboard = this.keyboard,
          _this$keyboard$zoomSp = _this$keyboard.zoomSpeed,
          zoomSpeed = _this$keyboard$zoomSp === void 0 ? 2 : _this$keyboard$zoomSp,
          _this$keyboard$moveSp = _this$keyboard.moveSpeed,
          moveSpeed = _this$keyboard$moveSp === void 0 ? 100 : _this$keyboard$moveSp,
          _this$keyboard$rotate = _this$keyboard.rotateSpeedX,
          rotateSpeedX = _this$keyboard$rotate === void 0 ? 15 : _this$keyboard$rotate,
          _this$keyboard$rotate2 = _this$keyboard.rotateSpeedY,
          rotateSpeedY = _this$keyboard$rotate2 === void 0 ? 10 : _this$keyboard$rotate2;
      var mapStateProps = this.mapStateProps;
      var newMapState;

      switch (event.srcEvent.keyCode) {
        case 189:
          if (funcKey) {
            newMapState = this.getMapState({
              zoom: mapStateProps.zoom - Math.log2(zoomSpeed) - 1
            });
          } else {
            newMapState = this.getMapState({
              zoom: mapStateProps.zoom - Math.log2(zoomSpeed)
            });
          }

          break;

        case 187:
          if (funcKey) {
            newMapState = this.getMapState({
              zoom: mapStateProps.zoom + Math.log2(zoomSpeed) + 1
            });
          } else {
            newMapState = this.getMapState({
              zoom: mapStateProps.zoom + Math.log2(zoomSpeed)
            });
          }

          break;

        case 37:
          if (funcKey) {
            newMapState = this.getMapState({
              bearing: mapStateProps.bearing - rotateSpeedX
            });
          } else {
            newMapState = this.mapState.pan({
              pos: [moveSpeed, 0],
              startPos: [0, 0]
            });
          }

          break;

        case 39:
          if (funcKey) {
            newMapState = this.getMapState({
              bearing: mapStateProps.bearing + rotateSpeedX
            });
          } else {
            newMapState = this.mapState.pan({
              pos: [-moveSpeed, 0],
              startPos: [0, 0]
            });
          }

          break;

        case 38:
          if (funcKey) {
            newMapState = this.getMapState({
              pitch: mapStateProps.pitch + rotateSpeedY
            });
          } else {
            newMapState = this.mapState.pan({
              pos: [0, moveSpeed],
              startPos: [0, 0]
            });
          }

          break;

        case 40:
          if (funcKey) {
            newMapState = this.getMapState({
              pitch: mapStateProps.pitch - rotateSpeedY
            });
          } else {
            newMapState = this.mapState.pan({
              pos: [0, -moveSpeed],
              startPos: [0, 0]
            });
          }

          break;

        default:
          return false;
      }

      return this.updateViewport(newMapState, LINEAR_TRANSITION_PROPS);
    }
  }]);

  return MapController;
}();


//# sourceMappingURL=map-controller.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/interactive-map.js




function interactive_map_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function interactive_map_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { interactive_map_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { interactive_map_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }












var interactive_map_propTypes = Object.assign({}, static_map.propTypes, {
  maxZoom: prop_types.number,
  minZoom: prop_types.number,
  maxPitch: prop_types.number,
  minPitch: prop_types.number,
  onViewStateChange: prop_types.func,
  onViewportChange: prop_types.func,
  onInteractionStateChange: prop_types.func,
  transitionDuration: prop_types.oneOfType([prop_types.number, prop_types.string]),
  transitionInterpolator: prop_types.object,
  transitionInterruption: prop_types.number,
  transitionEasing: prop_types.func,
  onTransitionStart: prop_types.func,
  onTransitionInterrupt: prop_types.func,
  onTransitionEnd: prop_types.func,
  scrollZoom: prop_types.oneOfType([prop_types.bool, prop_types.object]),
  dragPan: prop_types.oneOfType([prop_types.bool, prop_types.object]),
  dragRotate: prop_types.oneOfType([prop_types.bool, prop_types.object]),
  doubleClickZoom: prop_types.bool,
  touchZoom: prop_types.oneOfType([prop_types.bool, prop_types.object]),
  touchRotate: prop_types.oneOfType([prop_types.bool, prop_types.object]),
  keyboard: prop_types.oneOfType([prop_types.bool, prop_types.object]),
  onHover: prop_types.func,
  onClick: prop_types.func,
  onDblClick: prop_types.func,
  onContextMenu: prop_types.func,
  onMouseDown: prop_types.func,
  onMouseMove: prop_types.func,
  onMouseUp: prop_types.func,
  onTouchStart: prop_types.func,
  onTouchMove: prop_types.func,
  onTouchEnd: prop_types.func,
  onMouseEnter: prop_types.func,
  onMouseLeave: prop_types.func,
  onMouseOut: prop_types.func,
  onWheel: prop_types.func,
  touchAction: prop_types.string,
  eventRecognizerOptions: prop_types.object,
  clickRadius: prop_types.number,
  interactiveLayerIds: prop_types.array,
  getCursor: prop_types.func,
  controller: prop_types.instanceOf(MapController)
});

var getDefaultCursor = function getDefaultCursor(_ref) {
  var isDragging = _ref.isDragging,
      isHovering = _ref.isHovering;
  return isDragging ? 'grabbing' : isHovering ? 'pointer' : 'grab';
};

var interactive_map_defaultProps = Object.assign({}, static_map.defaultProps, MAPBOX_LIMITS, TransitionManager.defaultProps, {
  onViewStateChange: null,
  onViewportChange: null,
  onClick: null,
  onNativeClick: null,
  onHover: null,
  onContextMenu: function onContextMenu(event) {
    return event.preventDefault();
  },
  scrollZoom: true,
  dragPan: true,
  dragRotate: true,
  doubleClickZoom: true,
  touchZoom: true,
  touchRotate: false,
  keyboard: true,
  touchAction: 'none',
  eventRecognizerOptions: {},
  clickRadius: 0,
  getCursor: getDefaultCursor
});

function normalizeEvent(event) {
  if (event.lngLat || !event.offsetCenter) {
    return event;
  }

  var _event$offsetCenter = event.offsetCenter,
      x = _event$offsetCenter.x,
      y = _event$offsetCenter.y;

  if (!Number.isFinite(x) || !Number.isFinite(y)) {
    return event;
  }

  var pos = [x, y];
  event.point = pos;
  var viewport = this.viewport;
  var location = viewport.unproject(pos, {
    targetZ: viewport.meterOffset[2]
  });
  event.lngLat = [location[0], location[1]];
  return event;
}

function getFeatures(pos) {
  var map = this.map;

  if (!map || !pos) {
    return null;
  }

  var queryParams = {};
  var size = this.props.clickRadius;

  if (this.props.interactiveLayerIds) {
    queryParams.layers = this.props.interactiveLayerIds;
  }

  try {
    return map.queryRenderedFeatures(size ? [[pos[0] - size, pos[1] + size], [pos[0] + size, pos[1] - size]] : pos, queryParams);
  } catch (_unused) {
    return null;
  }
}

function onEvent(callbackName, event) {
  var func = this.props[callbackName];

  if (func) {
    func(normalizeEvent.call(this, event));
  }
}

function onPointerDown(event) {
  onEvent.call(this, event.pointerType === 'touch' ? 'onTouchStart' : 'onMouseDown', event);
}

function onPointerUp(event) {
  onEvent.call(this, event.pointerType === 'touch' ? 'onTouchEnd' : 'onMouseUp', event);
}

function onPointerMove(event) {
  onEvent.call(this, event.pointerType === 'touch' ? 'onTouchMove' : 'onMouseMove', event);

  if (!this.state.isDragging) {
    var _this$props = this.props,
        onHover = _this$props.onHover,
        interactiveLayerIds = _this$props.interactiveLayerIds;
    var features;
    event = normalizeEvent.call(this, event);

    if (interactiveLayerIds || onHover) {
      features = getFeatures.call(this, event.point);
    }

    var isHovering = Boolean(interactiveLayerIds && features && features.length > 0);
    var isEntering = isHovering && !this.state.isHovering;
    var isExiting = !isHovering && this.state.isHovering;

    if (onHover || isEntering) {
      event.features = features;

      if (onHover) {
        onHover(event);
      }
    }

    if (isEntering) {
      onEvent.call(this, 'onMouseEnter', event);
    }

    if (isExiting) {
      onEvent.call(this, 'onMouseLeave', event);
    }

    if (isEntering || isExiting) {
      this.setState({
        isHovering: isHovering
      });
    }
  }
}

function onPointerClick(event) {
  var _this$props2 = this.props,
      onClick = _this$props2.onClick,
      onNativeClick = _this$props2.onNativeClick,
      onDblClick = _this$props2.onDblClick,
      doubleClickZoom = _this$props2.doubleClickZoom;
  var callbacks = [];
  var isDoubleClickEnabled = onDblClick || doubleClickZoom;

  switch (event.type) {
    case 'anyclick':
      callbacks.push(onNativeClick);

      if (!isDoubleClickEnabled) {
        callbacks.push(onClick);
      }

      break;

    case 'click':
      if (isDoubleClickEnabled) {
        callbacks.push(onClick);
      }

      break;

    default:
  }

  callbacks = callbacks.filter(Boolean);

  if (callbacks.length) {
    event = normalizeEvent.call(this, event);
    event.features = getFeatures.call(this, event.point);
    callbacks.forEach(function (cb) {
      return cb(event);
    });
  }
}

function interactive_map_getRefHandles(staticMapRef) {
  return {
    getMap: staticMapRef.current && staticMapRef.current.getMap,
    queryRenderedFeatures: staticMapRef.current && staticMapRef.current.queryRenderedFeatures
  };
}

var InteractiveMap = (0,react.forwardRef)(function (props, ref) {
  var parentContext = (0,react.useContext)(map_context);
  var controller = (0,react.useMemo)(function () {
    return props.controller || new MapController();
  }, []);
  var eventManager = (0,react.useMemo)(function () {
    return new dist_esm/* EventManager */.Q(null, {
      touchAction: props.touchAction,
      recognizerOptions: props.eventRecognizerOptions
    });
  }, []);
  var eventCanvasRef = (0,react.useRef)(null);
  var staticMapRef = (0,react.useRef)(null);

  var _thisRef = (0,react.useRef)({
    width: 0,
    height: 0,
    state: {
      isHovering: false,
      isDragging: false
    }
  });

  var thisRef = _thisRef.current;
  thisRef.props = props;
  thisRef.map = staticMapRef.current && staticMapRef.current.getMap();

  thisRef.setState = function (newState) {
    thisRef.state = interactive_map_objectSpread(interactive_map_objectSpread({}, thisRef.state), newState);
    eventCanvasRef.current.style.cursor = props.getCursor(thisRef.state);
  };

  var inRender = true;
  var viewportUpdateRequested;
  var stateUpdateRequested;

  var handleViewportChange = function handleViewportChange(viewState, interactionState, oldViewState) {
    if (inRender) {
      viewportUpdateRequested = [viewState, interactionState, oldViewState];
      return;
    }

    var _thisRef$props = thisRef.props,
        onViewStateChange = _thisRef$props.onViewStateChange,
        onViewportChange = _thisRef$props.onViewportChange;
    Object.defineProperty(viewState, 'position', {
      get: function get() {
        return [0, 0, getTerrainElevation(thisRef.map, viewState)];
      }
    });

    if (onViewStateChange) {
      onViewStateChange({
        viewState: viewState,
        interactionState: interactionState,
        oldViewState: oldViewState
      });
    }

    if (onViewportChange) {
      onViewportChange(viewState, interactionState, oldViewState);
    }
  };

  (0,react.useImperativeHandle)(ref, function () {
    return interactive_map_getRefHandles(staticMapRef);
  }, []);
  var context = (0,react.useMemo)(function () {
    return interactive_map_objectSpread(interactive_map_objectSpread({}, parentContext), {}, {
      eventManager: eventManager,
      container: parentContext.container || eventCanvasRef.current
    });
  }, [parentContext, eventCanvasRef.current]);
  context.onViewportChange = handleViewportChange;
  context.viewport = parentContext.viewport || getViewport(thisRef);
  thisRef.viewport = context.viewport;

  var handleInteractionStateChange = function handleInteractionStateChange(interactionState) {
    var _interactionState$isD = interactionState.isDragging,
        isDragging = _interactionState$isD === void 0 ? false : _interactionState$isD;

    if (isDragging !== thisRef.state.isDragging) {
      thisRef.setState({
        isDragging: isDragging
      });
    }

    if (inRender) {
      stateUpdateRequested = interactionState;
      return;
    }

    var onInteractionStateChange = thisRef.props.onInteractionStateChange;

    if (onInteractionStateChange) {
      onInteractionStateChange(interactionState);
    }
  };

  var updateControllerOpts = function updateControllerOpts() {
    if (thisRef.width && thisRef.height) {
      controller.setOptions(interactive_map_objectSpread(interactive_map_objectSpread(interactive_map_objectSpread({}, thisRef.props), thisRef.props.viewState), {}, {
        isInteractive: Boolean(thisRef.props.onViewStateChange || thisRef.props.onViewportChange),
        onViewportChange: handleViewportChange,
        onStateChange: handleInteractionStateChange,
        eventManager: eventManager,
        width: thisRef.width,
        height: thisRef.height
      }));
    }
  };

  var onResize = function onResize(_ref2) {
    var width = _ref2.width,
        height = _ref2.height;
    thisRef.width = width;
    thisRef.height = height;
    updateControllerOpts();
    thisRef.props.onResize({
      width: width,
      height: height
    });
  };

  (0,react.useEffect)(function () {
    eventManager.setElement(eventCanvasRef.current);
    eventManager.on({
      pointerdown: onPointerDown.bind(thisRef),
      pointermove: onPointerMove.bind(thisRef),
      pointerup: onPointerUp.bind(thisRef),
      pointerleave: onEvent.bind(thisRef, 'onMouseOut'),
      click: onPointerClick.bind(thisRef),
      anyclick: onPointerClick.bind(thisRef),
      dblclick: onEvent.bind(thisRef, 'onDblClick'),
      wheel: onEvent.bind(thisRef, 'onWheel'),
      contextmenu: onEvent.bind(thisRef, 'onContextMenu')
    });
    return function () {
      eventManager.destroy();
    };
  }, []);
  use_isomorphic_layout_effect(function () {
    if (viewportUpdateRequested) {
      handleViewportChange.apply(void 0, (0,toConsumableArray/* default */.Z)(viewportUpdateRequested));
    }

    if (stateUpdateRequested) {
      handleInteractionStateChange(stateUpdateRequested);
    }
  });
  updateControllerOpts();
  var width = props.width,
      height = props.height,
      style = props.style,
      getCursor = props.getCursor;
  var eventCanvasStyle = (0,react.useMemo)(function () {
    return interactive_map_objectSpread(interactive_map_objectSpread({
      position: 'relative'
    }, style), {}, {
      width: width,
      height: height,
      cursor: getCursor(thisRef.state)
    });
  }, [style, width, height, getCursor, thisRef.state]);

  if (!viewportUpdateRequested || !thisRef._child) {
    thisRef._child = react.createElement(MapContextProvider, {
      value: context
    }, react.createElement("div", {
      key: "event-canvas",
      ref: eventCanvasRef,
      style: eventCanvasStyle
    }, react.createElement(static_map, (0,esm_extends/* default */.Z)({}, props, {
      width: "100%",
      height: "100%",
      style: null,
      onResize: onResize,
      ref: staticMapRef
    }))));
  }

  inRender = false;
  return thisRef._child;
});
InteractiveMap.supported = static_map.supported;
InteractiveMap.propTypes = interactive_map_propTypes;
InteractiveMap.defaultProps = interactive_map_defaultProps;
/* harmony default export */ const interactive_map = ((/* unused pure expression or super */ null && (InteractiveMap)));
//# sourceMappingURL=interactive-map.js.map
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/typeof.js
var esm_typeof = __webpack_require__(71002);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/deep-equal.js

function deepEqual(a, b) {
  if (a === b) {
    return true;
  }

  if (!a || !b) {
    return false;
  }

  if (Array.isArray(a)) {
    if (!Array.isArray(b) || a.length !== b.length) {
      return false;
    }

    for (var i = 0; i < a.length; i++) {
      if (!deepEqual(a[i], b[i])) {
        return false;
      }
    }

    return true;
  } else if (Array.isArray(b)) {
    return false;
  }

  if ((0,esm_typeof/* default */.Z)(a) === 'object' && (0,esm_typeof/* default */.Z)(b) === 'object') {
    var aKeys = Object.keys(a);
    var bKeys = Object.keys(b);

    if (aKeys.length !== bKeys.length) {
      return false;
    }

    for (var _i = 0, _aKeys = aKeys; _i < _aKeys.length; _i++) {
      var key = _aKeys[_i];

      if (!b.hasOwnProperty(key)) {
        return false;
      }

      if (!deepEqual(a[key], b[key])) {
        return false;
      }
    }

    return true;
  }

  return false;
}
//# sourceMappingURL=deep-equal.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/source.js



function source_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function source_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { source_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { source_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }








var source_propTypes = {
  type: prop_types.string.isRequired,
  id: prop_types.string
};
var sourceCounter = 0;

function createSource(map, id, props) {
  if (map.style && map.style._loaded) {
    var options = source_objectSpread({}, props);

    delete options.id;
    delete options.children;
    map.addSource(id, options);
    return map.getSource(id);
  }

  return null;
}

function updateSource(source, props, prevProps) {
  assert(props.id === prevProps.id, 'source id changed');
  assert(props.type === prevProps.type, 'source type changed');
  var changedKey = '';
  var changedKeyCount = 0;

  for (var key in props) {
    if (key !== 'children' && key !== 'id' && !deepEqual(prevProps[key], props[key])) {
      changedKey = key;
      changedKeyCount++;
    }
  }

  if (!changedKeyCount) {
    return;
  }

  var type = props.type;

  if (type === 'geojson') {
    source.setData(props.data);
  } else if (type === 'image') {
    source.updateImage({
      url: props.url,
      coordinates: props.coordinates
    });
  } else if ((type === 'canvas' || type === 'video') && changedKeyCount === 1 && changedKey === 'coordinates') {
    source.setCoordinates(props.coordinates);
  } else if (type === 'vector' && source.setUrl) {
    switch (changedKey) {
      case 'url':
        source.setUrl(props.url);
        break;

      case 'tiles':
        source.setTiles(props.tiles);
        break;

      default:
    }
  } else {
    console.warn("Unable to update <Source> prop: ".concat(changedKey));
  }
}

function Source(props) {
  var context = (0,react.useContext)(map_context);
  var propsRef = (0,react.useRef)({
    id: props.id,
    type: props.type
  });

  var _useState = (0,react.useState)(0),
      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),
      setStyleLoaded = _useState2[1];

  var id = (0,react.useMemo)(function () {
    return props.id || "jsx-source-".concat(sourceCounter++);
  }, []);
  var map = context.map;
  (0,react.useEffect)(function () {
    if (map) {
      var forceUpdate = function forceUpdate() {
        return setStyleLoaded(function (version) {
          return version + 1;
        });
      };

      map.on('styledata', forceUpdate);
      return function () {
        map.off('styledata', forceUpdate);
        requestAnimationFrame(function () {
          if (map.style && map.style._loaded && map.getSource(id)) {
            map.removeSource(id);
          }
        });
      };
    }

    return undefined;
  }, [map, id]);
  var source = map && map.style && map.getSource(id);

  if (source) {
    updateSource(source, props, propsRef.current);
  } else {
    source = createSource(map, id, props);
  }

  propsRef.current = props;
  return source && react.Children.map(props.children, function (child) {
    return child && (0,react.cloneElement)(child, {
      source: id
    });
  }) || null;
}

Source.propTypes = source_propTypes;
/* harmony default export */ const source = ((/* unused pure expression or super */ null && (Source)));
//# sourceMappingURL=source.js.map
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js
var objectWithoutProperties = __webpack_require__(45987);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/layer.js




function layer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function layer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { layer_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { layer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }






var LAYER_TYPES = ['fill', 'line', 'symbol', 'circle', 'fill-extrusion', 'raster', 'background', 'heatmap', 'hillshade', 'sky'];
var layer_propTypes = {
  type: prop_types.oneOf(LAYER_TYPES).isRequired,
  id: prop_types.string,
  source: prop_types.string,
  beforeId: prop_types.string
};

function diffLayerStyles(map, id, props, prevProps) {
  var _props$layout = props.layout,
      layout = _props$layout === void 0 ? {} : _props$layout,
      _props$paint = props.paint,
      paint = _props$paint === void 0 ? {} : _props$paint,
      filter = props.filter,
      minzoom = props.minzoom,
      maxzoom = props.maxzoom,
      beforeId = props.beforeId,
      otherProps = (0,objectWithoutProperties/* default */.Z)(props, ["layout", "paint", "filter", "minzoom", "maxzoom", "beforeId"]);

  if (beforeId !== prevProps.beforeId) {
    map.moveLayer(id, beforeId);
  }

  if (layout !== prevProps.layout) {
    var prevLayout = prevProps.layout || {};

    for (var key in layout) {
      if (!deepEqual(layout[key], prevLayout[key])) {
        map.setLayoutProperty(id, key, layout[key]);
      }
    }

    for (var _key in prevLayout) {
      if (!layout.hasOwnProperty(_key)) {
        map.setLayoutProperty(id, _key, undefined);
      }
    }
  }

  if (paint !== prevProps.paint) {
    var prevPaint = prevProps.paint || {};

    for (var _key2 in paint) {
      if (!deepEqual(paint[_key2], prevPaint[_key2])) {
        map.setPaintProperty(id, _key2, paint[_key2]);
      }
    }

    for (var _key3 in prevPaint) {
      if (!paint.hasOwnProperty(_key3)) {
        map.setPaintProperty(id, _key3, undefined);
      }
    }
  }

  if (!deepEqual(filter, prevProps.filter)) {
    map.setFilter(id, filter);
  }

  if (minzoom !== prevProps.minzoom || maxzoom !== prevProps.maxzoom) {
    map.setLayerZoomRange(id, minzoom, maxzoom);
  }

  for (var _key4 in otherProps) {
    if (!deepEqual(otherProps[_key4], prevProps[_key4])) {
      map.setLayerProperty(id, _key4, otherProps[_key4]);
    }
  }
}

function createLayer(map, id, props) {
  if (map.style && map.style._loaded) {
    var options = layer_objectSpread(layer_objectSpread({}, props), {}, {
      id: id
    });

    delete options.beforeId;
    map.addLayer(options, props.beforeId);
  }
}

function updateLayer(map, id, props, prevProps) {
  assert(props.id === prevProps.id, 'layer id changed');
  assert(props.type === prevProps.type, 'layer type changed');

  try {
    diffLayerStyles(map, id, props, prevProps);
  } catch (error) {
    console.warn(error);
  }
}

var layerCounter = 0;

function Layer(props) {
  var context = (0,react.useContext)(map_context);
  var propsRef = (0,react.useRef)({
    id: props.id,
    type: props.type
  });

  var _useState = (0,react.useState)(0),
      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),
      setStyleLoaded = _useState2[1];

  var id = (0,react.useMemo)(function () {
    return props.id || "jsx-layer-".concat(layerCounter++);
  }, []);
  var map = context.map;
  (0,react.useEffect)(function () {
    if (map) {
      var forceUpdate = function forceUpdate() {
        return setStyleLoaded(function (version) {
          return version + 1;
        });
      };

      map.on('styledata', forceUpdate);
      return function () {
        map.off('styledata', forceUpdate);

        if (map.style && map.style._loaded) {
          map.removeLayer(id);
        }
      };
    }

    return undefined;
  }, [map]);
  var layer = map && map.style && map.getLayer(id);

  if (layer) {
    updateLayer(map, id, props, propsRef.current);
  } else {
    createLayer(map, id, props);
  }

  propsRef.current = props;
  return null;
}

Layer.propTypes = layer_propTypes;
/* harmony default export */ const components_layer = ((/* unused pure expression or super */ null && (Layer)));
//# sourceMappingURL=layer.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/use-map-control.js



var mapControlDefaultProps = {
  captureScroll: false,
  captureDrag: true,
  captureClick: true,
  captureDoubleClick: true,
  capturePointerMove: false
};
var mapControlPropTypes = {
  captureScroll: prop_types.bool,
  captureDrag: prop_types.bool,
  captureClick: prop_types.bool,
  captureDoubleClick: prop_types.bool,
  capturePointerMove: prop_types.bool
};

function onMount(thisRef) {
  var ref = thisRef.containerRef.current;
  var eventManager = thisRef.context.eventManager;

  if (!ref || !eventManager) {
    return undefined;
  }

  var events = {
    wheel: function wheel(evt) {
      var props = thisRef.props;

      if (props.captureScroll) {
        evt.stopPropagation();
      }

      if (props.onScroll) {
        props.onScroll(evt, thisRef);
      }
    },
    panstart: function panstart(evt) {
      var props = thisRef.props;

      if (props.captureDrag) {
        evt.stopPropagation();
      }

      if (props.onDragStart) {
        props.onDragStart(evt, thisRef);
      }
    },
    anyclick: function anyclick(evt) {
      var props = thisRef.props;

      if (props.captureClick) {
        evt.stopPropagation();
      }

      if (props.onClick) {
        props.onClick(evt, thisRef);
      }
    },
    click: function click(evt) {
      var props = thisRef.props;

      if (props.captureClick) {
        evt.stopPropagation();
      }

      if (props.onClick) {
        props.onClick(evt, thisRef);
      }
    },
    dblclick: function dblclick(evt) {
      var props = thisRef.props;

      if (props.captureDoubleClick) {
        evt.stopPropagation();
      }

      if (props.onDoubleClick) {
        props.onDoubleClick(evt, thisRef);
      }
    },
    pointermove: function pointermove(evt) {
      var props = thisRef.props;

      if (props.capturePointerMove) {
        evt.stopPropagation();
      }

      if (props.onPointerMove) {
        props.onPointerMove(evt, thisRef);
      }
    }
  };
  eventManager.watch(events, ref);
  return function () {
    eventManager.off(events);
  };
}

function useMapControl() {
  var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var context = (0,react.useContext)(map_context);
  var containerRef = (0,react.useRef)(null);

  var _thisRef = (0,react.useRef)({
    props: props,
    state: {},
    context: context,
    containerRef: containerRef
  });

  var thisRef = _thisRef.current;
  thisRef.props = props;
  thisRef.context = context;
  (0,react.useEffect)(function () {
    return onMount(thisRef);
  }, [context.eventManager]);
  return thisRef;
}
//# sourceMappingURL=use-map-control.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/base-control.js









function base_control_createSuper(Derived) { var hasNativeReflectConstruct = base_control_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0,getPrototypeOf/* default */.Z)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0,getPrototypeOf/* default */.Z)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0,possibleConstructorReturn/* default */.Z)(this, result); }; }

function base_control_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }





function Control(props) {
  var instance = props.instance;

  var _useMapControl = useMapControl(props),
      context = _useMapControl.context,
      containerRef = _useMapControl.containerRef;

  instance._context = context;
  instance._containerRef = containerRef;
  return instance._render();
}

var BaseControl = function (_PureComponent) {
  (0,inherits/* default */.Z)(BaseControl, _PureComponent);

  var _super = base_control_createSuper(BaseControl);

  function BaseControl() {
    var _this;

    (0,classCallCheck/* default */.Z)(this, BaseControl);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    (0,defineProperty/* default */.Z)((0,assertThisInitialized/* default */.Z)(_this), "_context", {});

    (0,defineProperty/* default */.Z)((0,assertThisInitialized/* default */.Z)(_this), "_containerRef", (0,react.createRef)());

    (0,defineProperty/* default */.Z)((0,assertThisInitialized/* default */.Z)(_this), "_onScroll", function (evt) {});

    (0,defineProperty/* default */.Z)((0,assertThisInitialized/* default */.Z)(_this), "_onDragStart", function (evt) {});

    (0,defineProperty/* default */.Z)((0,assertThisInitialized/* default */.Z)(_this), "_onDblClick", function (evt) {});

    (0,defineProperty/* default */.Z)((0,assertThisInitialized/* default */.Z)(_this), "_onClick", function (evt) {});

    (0,defineProperty/* default */.Z)((0,assertThisInitialized/* default */.Z)(_this), "_onPointerMove", function (evt) {});

    return _this;
  }

  (0,createClass/* default */.Z)(BaseControl, [{
    key: "_render",
    value: function _render() {
      throw new Error('_render() not implemented');
    }
  }, {
    key: "render",
    value: function render() {
      return react.createElement(Control, (0,esm_extends/* default */.Z)({
        instance: this
      }, this.props, {
        onScroll: this._onScroll,
        onDragStart: this._onDragStart,
        onDblClick: this._onDblClick,
        onClick: this._onClick,
        onPointerMove: this._onPointerMove
      }));
    }
  }]);

  return BaseControl;
}(react.PureComponent);

(0,defineProperty/* default */.Z)(BaseControl, "propTypes", mapControlPropTypes);

(0,defineProperty/* default */.Z)(BaseControl, "defaultProps", mapControlDefaultProps);


//# sourceMappingURL=base-control.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/draggable-control.js



function draggable_control_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function draggable_control_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { draggable_control_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { draggable_control_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }




var draggableControlPropTypes = Object.assign({}, mapControlPropTypes, {
  draggable: prop_types.bool,
  onDrag: prop_types.func,
  onDragEnd: prop_types.func,
  onDragStart: prop_types.func,
  offsetLeft: prop_types.number,
  offsetTop: prop_types.number
});
var draggableControlDefaultProps = Object.assign({}, mapControlDefaultProps, {
  draggable: false,
  offsetLeft: 0,
  offsetTop: 0
});

function getDragEventPosition(event) {
  var _event$offsetCenter = event.offsetCenter,
      x = _event$offsetCenter.x,
      y = _event$offsetCenter.y;
  return [x, y];
}

function getDragEventOffset(event, container) {
  var _event$center = event.center,
      x = _event$center.x,
      y = _event$center.y;

  if (container) {
    var rect = container.getBoundingClientRect();
    return [rect.left - x, rect.top - y];
  }

  return null;
}

function getDragLngLat(dragPos, dragOffset, props, context) {
  var x = dragPos[0] + dragOffset[0] - props.offsetLeft;
  var y = dragPos[1] + dragOffset[1] - props.offsetTop;
  return context.viewport.unproject([x, y]);
}

function onDragStart(event, _ref) {
  var props = _ref.props,
      callbacks = _ref.callbacks,
      state = _ref.state,
      context = _ref.context,
      containerRef = _ref.containerRef;
  var draggable = props.draggable;

  if (!draggable) {
    return;
  }

  event.stopPropagation();
  var dragPos = getDragEventPosition(event);
  var dragOffset = getDragEventOffset(event, containerRef.current);
  state.setDragPos(dragPos);
  state.setDragOffset(dragOffset);

  if (callbacks.onDragStart && dragOffset) {
    var callbackEvent = Object.assign({}, event);
    callbackEvent.lngLat = getDragLngLat(dragPos, dragOffset, props, context);
    callbacks.onDragStart(callbackEvent);
  }
}

function onDrag(event, _ref2) {
  var props = _ref2.props,
      callbacks = _ref2.callbacks,
      state = _ref2.state,
      context = _ref2.context;
  event.stopPropagation();
  var dragPos = getDragEventPosition(event);
  state.setDragPos(dragPos);
  var dragOffset = state.dragOffset;

  if (callbacks.onDrag && dragOffset) {
    var callbackEvent = Object.assign({}, event);
    callbackEvent.lngLat = getDragLngLat(dragPos, dragOffset, props, context);
    callbacks.onDrag(callbackEvent);
  }
}

function onDragEnd(event, _ref3) {
  var props = _ref3.props,
      callbacks = _ref3.callbacks,
      state = _ref3.state,
      context = _ref3.context;
  event.stopPropagation();
  var dragPos = state.dragPos,
      dragOffset = state.dragOffset;
  state.setDragPos(null);
  state.setDragOffset(null);

  if (callbacks.onDragEnd && dragPos && dragOffset) {
    var callbackEvent = Object.assign({}, event);
    callbackEvent.lngLat = getDragLngLat(dragPos, dragOffset, props, context);
    callbacks.onDragEnd(callbackEvent);
  }
}

function onDragCancel(event, _ref4) {
  var state = _ref4.state;
  event.stopPropagation();
  state.setDragPos(null);
  state.setDragOffset(null);
}

function registerEvents(thisRef) {
  var eventManager = thisRef.context.eventManager;

  if (!eventManager || !thisRef.state.dragPos) {
    return undefined;
  }

  var events = {
    panmove: function panmove(evt) {
      return onDrag(evt, thisRef);
    },
    panend: function panend(evt) {
      return onDragEnd(evt, thisRef);
    },
    pancancel: function pancancel(evt) {
      return onDragCancel(evt, thisRef);
    }
  };
  eventManager.watch(events);
  return function () {
    eventManager.off(events);
  };
}

function useDraggableControl(props) {
  var _useState = (0,react.useState)(null),
      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),
      dragPos = _useState2[0],
      setDragPos = _useState2[1];

  var _useState3 = (0,react.useState)(null),
      _useState4 = (0,slicedToArray/* default */.Z)(_useState3, 2),
      dragOffset = _useState4[0],
      setDragOffset = _useState4[1];

  var thisRef = useMapControl(draggable_control_objectSpread(draggable_control_objectSpread({}, props), {}, {
    onDragStart: onDragStart
  }));
  thisRef.callbacks = props;
  thisRef.state.dragPos = dragPos;
  thisRef.state.setDragPos = setDragPos;
  thisRef.state.dragOffset = dragOffset;
  thisRef.state.setDragOffset = setDragOffset;
  (0,react.useEffect)(function () {
    return registerEvents(thisRef);
  }, [thisRef.context.eventManager, Boolean(dragPos)]);
  return thisRef;
}
//# sourceMappingURL=draggable-control.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/crisp-pixel.js
var pixelRatio = typeof window !== 'undefined' && window.devicePixelRatio || 1;
var crispPixel = function crispPixel(size) {
  return Math.round(size * pixelRatio) / pixelRatio;
};
var crispPercentage = function crispPercentage(el, percentage) {
  var dimension = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'x';

  if (el === null) {
    return percentage;
  }

  var origSize = dimension === 'x' ? el.offsetWidth : el.offsetHeight;
  return crispPixel(percentage / 100 * origSize) / origSize * 100;
};
//# sourceMappingURL=crisp-pixel.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/marker.js







var marker_propTypes = Object.assign({}, draggableControlPropTypes, {
  className: prop_types.string,
  longitude: prop_types.number.isRequired,
  latitude: prop_types.number.isRequired
});
var marker_defaultProps = Object.assign({}, draggableControlDefaultProps, {
  className: ''
});

function getPosition(_ref) {
  var props = _ref.props,
      state = _ref.state,
      context = _ref.context;
  var longitude = props.longitude,
      latitude = props.latitude,
      offsetLeft = props.offsetLeft,
      offsetTop = props.offsetTop;
  var dragPos = state.dragPos,
      dragOffset = state.dragOffset;
  var viewport = context.viewport,
      map = context.map;

  if (dragPos && dragOffset) {
    return [dragPos[0] + dragOffset[0], dragPos[1] + dragOffset[1]];
  }

  var altitude = getTerrainElevation(map, {
    longitude: longitude,
    latitude: latitude
  });

  var _viewport$project = viewport.project([longitude, latitude, altitude]),
      _viewport$project2 = (0,slicedToArray/* default */.Z)(_viewport$project, 2),
      x = _viewport$project2[0],
      y = _viewport$project2[1];

  x += offsetLeft;
  y += offsetTop;
  return [x, y];
}

function Marker(props) {
  var thisRef = useDraggableControl(props);
  var state = thisRef.state,
      containerRef = thisRef.containerRef;
  var children = props.children,
      className = props.className,
      draggable = props.draggable;
  var dragPos = state.dragPos;

  var _getPosition = getPosition(thisRef),
      _getPosition2 = (0,slicedToArray/* default */.Z)(_getPosition, 2),
      x = _getPosition2[0],
      y = _getPosition2[1];

  var transform = "translate(".concat(crispPixel(x), "px, ").concat(crispPixel(y), "px)");
  var cursor = draggable ? dragPos ? 'grabbing' : 'grab' : 'auto';
  var control = (0,react.useMemo)(function () {
    var containerStyle = {
      position: 'absolute',
      left: 0,
      top: 0,
      transform: transform,
      cursor: cursor
    };
    return react.createElement("div", {
      className: "mapboxgl-marker ".concat(className),
      ref: thisRef.containerRef,
      style: containerStyle
    }, children);
  }, [children, className]);
  var container = containerRef.current;

  if (container) {
    container.style.transform = transform;
    container.style.cursor = cursor;
  }

  return control;
}

Marker.defaultProps = marker_defaultProps;
Marker.propTypes = marker_propTypes;
/* harmony default export */ const marker = (react.memo(Marker));
//# sourceMappingURL=marker.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/dynamic-position.js
var ANCHOR_POSITION = {
  top: {
    x: 0.5,
    y: 0
  },
  'top-left': {
    x: 0,
    y: 0
  },
  'top-right': {
    x: 1,
    y: 0
  },
  bottom: {
    x: 0.5,
    y: 1
  },
  'bottom-left': {
    x: 0,
    y: 1
  },
  'bottom-right': {
    x: 1,
    y: 1
  },
  left: {
    x: 0,
    y: 0.5
  },
  right: {
    x: 1,
    y: 0.5
  }
};
var ANCHOR_TYPES = Object.keys(ANCHOR_POSITION);
function getDynamicPosition(_ref) {
  var x = _ref.x,
      y = _ref.y,
      width = _ref.width,
      height = _ref.height,
      selfWidth = _ref.selfWidth,
      selfHeight = _ref.selfHeight,
      anchor = _ref.anchor,
      _ref$padding = _ref.padding,
      padding = _ref$padding === void 0 ? 0 : _ref$padding;
  var _ANCHOR_POSITION$anch = ANCHOR_POSITION[anchor],
      anchorX = _ANCHOR_POSITION$anch.x,
      anchorY = _ANCHOR_POSITION$anch.y;
  var top = y - anchorY * selfHeight;
  var bottom = top + selfHeight;
  var cutoffY = Math.max(0, padding - top) + Math.max(0, bottom - height + padding);

  if (cutoffY > 0) {
    var bestAnchorY = anchorY;
    var minCutoff = cutoffY;

    for (anchorY = 0; anchorY <= 1; anchorY += 0.5) {
      top = y - anchorY * selfHeight;
      bottom = top + selfHeight;
      cutoffY = Math.max(0, padding - top) + Math.max(0, bottom - height + padding);

      if (cutoffY < minCutoff) {
        minCutoff = cutoffY;
        bestAnchorY = anchorY;
      }
    }

    anchorY = bestAnchorY;
  }

  var xStep = 0.5;

  if (anchorY === 0.5) {
    anchorX = Math.floor(anchorX);
    xStep = 1;
  }

  var left = x - anchorX * selfWidth;
  var right = left + selfWidth;
  var cutoffX = Math.max(0, padding - left) + Math.max(0, right - width + padding);

  if (cutoffX > 0) {
    var bestAnchorX = anchorX;
    var _minCutoff = cutoffX;

    for (anchorX = 0; anchorX <= 1; anchorX += xStep) {
      left = x - anchorX * selfWidth;
      right = left + selfWidth;
      cutoffX = Math.max(0, padding - left) + Math.max(0, right - width + padding);

      if (cutoffX < _minCutoff) {
        _minCutoff = cutoffX;
        bestAnchorX = anchorX;
      }
    }

    anchorX = bestAnchorX;
  }

  return ANCHOR_TYPES.find(function (positionType) {
    var anchorPosition = ANCHOR_POSITION[positionType];
    return anchorPosition.x === anchorX && anchorPosition.y === anchorY;
  }) || anchor;
}
//# sourceMappingURL=dynamic-position.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/popup.js



function popup_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function popup_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { popup_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { popup_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }








var popup_propTypes = Object.assign({}, mapControlPropTypes, {
  className: prop_types.string,
  longitude: prop_types.number.isRequired,
  latitude: prop_types.number.isRequired,
  altitude: prop_types.number,
  offsetLeft: prop_types.number,
  offsetTop: prop_types.number,
  tipSize: prop_types.number,
  closeButton: prop_types.bool,
  closeOnClick: prop_types.bool,
  anchor: prop_types.oneOf(Object.keys(ANCHOR_POSITION)),
  dynamicPosition: prop_types.bool,
  sortByDepth: prop_types.bool,
  onClose: prop_types.func
});
var popup_defaultProps = Object.assign({}, mapControlDefaultProps, {
  className: '',
  offsetLeft: 0,
  offsetTop: 0,
  tipSize: 10,
  anchor: 'bottom',
  dynamicPosition: true,
  sortByDepth: false,
  closeButton: true,
  closeOnClick: true,
  onClose: function onClose() {}
});

function popup_getPosition(props, viewport, el, _ref) {
  var _ref2 = (0,slicedToArray/* default */.Z)(_ref, 2),
      x = _ref2[0],
      y = _ref2[1];

  var anchor = props.anchor,
      dynamicPosition = props.dynamicPosition,
      tipSize = props.tipSize;

  if (el) {
    return dynamicPosition ? getDynamicPosition({
      x: x,
      y: y,
      anchor: anchor,
      padding: tipSize,
      width: viewport.width,
      height: viewport.height,
      selfWidth: el.clientWidth,
      selfHeight: el.clientHeight
    }) : anchor;
  }

  return anchor;
}

function getContainerStyle(props, viewport, el, _ref3, positionType) {
  var _ref4 = (0,slicedToArray/* default */.Z)(_ref3, 3),
      x = _ref4[0],
      y = _ref4[1],
      z = _ref4[2];

  var offsetLeft = props.offsetLeft,
      offsetTop = props.offsetTop,
      sortByDepth = props.sortByDepth;
  var anchorPosition = ANCHOR_POSITION[positionType];
  var left = x + offsetLeft;
  var top = y + offsetTop;
  var xPercentage = crispPercentage(el, -anchorPosition.x * 100);
  var yPercentage = crispPercentage(el, -anchorPosition.y * 100, 'y');
  var style = {
    position: 'absolute',
    transform: "\n      translate(".concat(xPercentage, "%, ").concat(yPercentage, "%)\n      translate(").concat(crispPixel(left), "px, ").concat(crispPixel(top), "px)\n    "),
    display: undefined,
    zIndex: undefined
  };

  if (!sortByDepth) {
    return style;
  }

  if (z > 1 || z < -1 || x < 0 || x > viewport.width || y < 0 || y > viewport.height) {
    style.display = 'none';
  } else {
    style.zIndex = Math.floor((1 - z) / 2 * 100000);
  }

  return style;
}

function onClick(evt, _ref5) {
  var props = _ref5.props,
      context = _ref5.context;

  if (props.closeOnClick || evt.target.className === 'mapboxgl-popup-close-button') {
    props.onClose();

    if (context.eventManager) {
      context.eventManager.once('click', function (e) {
        return e.stopPropagation();
      }, evt.target);
    }
  }
}

function Popup(props) {
  var contentRef = (0,react.useRef)(null);
  var thisRef = useMapControl(popup_objectSpread(popup_objectSpread({}, props), {}, {
    onClick: onClick
  }));
  var context = thisRef.context,
      containerRef = thisRef.containerRef;

  var _useState = (0,react.useState)(false),
      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),
      setLoaded = _useState2[1];

  (0,react.useEffect)(function () {
    setLoaded(true);
  }, [contentRef.current]);
  var viewport = context.viewport,
      map = context.map;
  var className = props.className,
      longitude = props.longitude,
      latitude = props.latitude,
      tipSize = props.tipSize,
      closeButton = props.closeButton,
      children = props.children;
  var altitude = props.altitude;

  if (altitude === undefined) {
    altitude = getTerrainElevation(map, {
      longitude: longitude,
      latitude: latitude
    });
  }

  var position = viewport.project([longitude, latitude, altitude]);
  var positionType = popup_getPosition(props, viewport, contentRef.current, position);
  var containerStyle = getContainerStyle(props, viewport, containerRef.current, position, positionType);
  var onReactClick = (0,react.useCallback)(function (e) {
    return !context.eventManager && onClick(e, thisRef);
  }, [context.eventManager]);
  return react.createElement("div", {
    className: "mapboxgl-popup mapboxgl-popup-anchor-".concat(positionType, " ").concat(className),
    style: containerStyle,
    ref: containerRef
  }, react.createElement("div", {
    key: "tip",
    className: "mapboxgl-popup-tip",
    style: {
      borderWidth: tipSize
    }
  }), react.createElement("div", {
    key: "content",
    ref: contentRef,
    className: "mapboxgl-popup-content",
    onClick: onReactClick
  }, closeButton && react.createElement("button", {
    key: "close-button",
    className: "mapboxgl-popup-close-button",
    type: "button"
  }, "\xD7"), children));
}

Popup.propTypes = popup_propTypes;
Popup.defaultProps = popup_defaultProps;
/* harmony default export */ const popup = (react.memo(Popup));
//# sourceMappingURL=popup.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/attribution-control.js



function attribution_control_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function attribution_control_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { attribution_control_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { attribution_control_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }






var attribution_control_propTypes = Object.assign({}, mapControlPropTypes, {
  toggleLabel: prop_types.string,
  className: prop_types.string,
  style: prop_types.object,
  compact: prop_types.bool,
  customAttribution: prop_types.oneOfType([prop_types.string, prop_types.arrayOf(prop_types.string)])
});
var attribution_control_defaultProps = Object.assign({}, mapControlDefaultProps, {
  className: '',
  toggleLabel: 'Toggle Attribution'
});

function setupAttributioncontrol(opts, map, container, attributionContainer) {
  var control = new (mapbox_gl_default()).AttributionControl(opts);
  control._map = map;
  control._container = container;
  control._innerContainer = attributionContainer;

  control._updateAttributions();

  control._updateEditLink();

  map.on('styledata', control._updateData);
  map.on('sourcedata', control._updateData);
  return control;
}

function removeAttributionControl(control) {
  control._map.off('styledata', control._updateData);

  control._map.off('sourcedata', control._updateData);
}

function AttributionControl(props) {
  var _useMapControl = useMapControl(props),
      context = _useMapControl.context,
      containerRef = _useMapControl.containerRef;

  var innerContainerRef = (0,react.useRef)(null);

  var _useState = (0,react.useState)(false),
      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),
      showCompact = _useState2[0],
      setShowCompact = _useState2[1];

  (0,react.useEffect)(function () {
    var control;

    if (context.map) {
      control = setupAttributioncontrol({
        customAttribution: props.customAttribution
      }, context.map, containerRef.current, innerContainerRef.current);
    }

    return function () {
      return control && removeAttributionControl(control);
    };
  }, [context.map]);
  var compact = props.compact === undefined ? context.viewport.width <= 640 : props.compact;
  (0,react.useEffect)(function () {
    if (!compact && showCompact) {
      setShowCompact(false);
    }
  }, [compact]);
  var toggleAttribution = (0,react.useCallback)(function () {
    return setShowCompact(function (value) {
      return !value;
    });
  }, []);
  var style = (0,react.useMemo)(function () {
    return attribution_control_objectSpread({
      position: 'absolute'
    }, props.style);
  }, [props.style]);
  return react.createElement("div", {
    style: style,
    className: props.className
  }, react.createElement("div", {
    ref: containerRef,
    "aria-pressed": showCompact,
    className: "mapboxgl-ctrl mapboxgl-ctrl-attrib ".concat(compact ? 'mapboxgl-compact' : '', " ").concat(showCompact ? 'mapboxgl-compact-show' : '')
  }, react.createElement("button", {
    type: "button",
    className: "mapboxgl-ctrl-attrib-button",
    title: props.toggleLabel,
    onClick: toggleAttribution
  }), react.createElement("div", {
    ref: innerContainerRef,
    className: "mapboxgl-ctrl-attrib-inner",
    role: "list"
  })));
}

AttributionControl.propTypes = attribution_control_propTypes;
AttributionControl.defaultProps = attribution_control_defaultProps;
/* harmony default export */ const attribution_control = (react.memo(AttributionControl));
//# sourceMappingURL=attribution-control.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/fullscreen-control.js



function fullscreen_control_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function fullscreen_control_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { fullscreen_control_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { fullscreen_control_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }







var fullscreen_control_propTypes = Object.assign({}, mapControlPropTypes, {
  className: prop_types.string,
  style: prop_types.object,
  container: prop_types.object,
  label: prop_types.string
});
var fullscreen_control_defaultProps = Object.assign({}, mapControlDefaultProps, {
  className: '',
  container: null,
  label: 'Toggle fullscreen'
});

function FullscreenControl(props) {
  var _useMapControl = useMapControl(props),
      context = _useMapControl.context,
      containerRef = _useMapControl.containerRef;

  var _useState = (0,react.useState)(false),
      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),
      isFullscreen = _useState2[0],
      setIsFullscreen = _useState2[1];

  var _useState3 = (0,react.useState)(false),
      _useState4 = (0,slicedToArray/* default */.Z)(_useState3, 2),
      showButton = _useState4[0],
      setShowButton = _useState4[1];

  var _useState5 = (0,react.useState)(null),
      _useState6 = (0,slicedToArray/* default */.Z)(_useState5, 2),
      mapboxFullscreenControl = _useState6[0],
      createMapboxFullscreenControl = _useState6[1];

  (0,react.useEffect)(function () {
    var control = new (mapbox_gl_default()).FullscreenControl();
    createMapboxFullscreenControl(control);
    setShowButton(control._checkFullscreenSupport());

    var onFullscreenChange = function onFullscreenChange() {
      var nextState = !control._fullscreen;
      control._fullscreen = nextState;
      setIsFullscreen(nextState);
    };

    document_.addEventListener(control._fullscreenchange, onFullscreenChange);
    return function () {
      document_.removeEventListener(control._fullscreenchange, onFullscreenChange);
    };
  }, []);

  var onClickFullscreen = function onClickFullscreen() {
    if (mapboxFullscreenControl) {
      mapboxFullscreenControl._container = props.container || context.container;

      mapboxFullscreenControl._onClickFullscreen();
    }
  };

  var style = (0,react.useMemo)(function () {
    return fullscreen_control_objectSpread({
      position: 'absolute'
    }, props.style);
  }, [props.style]);

  if (!showButton) {
    return null;
  }

  var className = props.className,
      label = props.label;
  var type = isFullscreen ? 'shrink' : 'fullscreen';
  return react.createElement("div", {
    style: style,
    className: className
  }, react.createElement("div", {
    className: "mapboxgl-ctrl mapboxgl-ctrl-group",
    ref: containerRef
  }, react.createElement("button", {
    key: type,
    className: "mapboxgl-ctrl-icon mapboxgl-ctrl-".concat(type),
    type: "button",
    title: label,
    onClick: onClickFullscreen
  }, react.createElement("span", {
    className: "mapboxgl-ctrl-icon",
    "aria-hidden": "true"
  }))));
}

FullscreenControl.propTypes = fullscreen_control_propTypes;
FullscreenControl.defaultProps = fullscreen_control_defaultProps;
/* harmony default export */ const fullscreen_control = (react.memo(FullscreenControl));
//# sourceMappingURL=fullscreen-control.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/geolocate-utils.js
var supported;
function isGeolocationSupported() {
  if (supported !== undefined) {
    return Promise.resolve(supported);
  }

  if (window.navigator.permissions !== undefined) {
    return window.navigator.permissions.query({
      name: 'geolocation'
    }).then(function (p) {
      supported = p.state !== 'denied';
      return supported;
    });
  }

  supported = Boolean(window.navigator.geolocation);
  return Promise.resolve(supported);
}
//# sourceMappingURL=geolocate-utils.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/geolocate-control.js



function geolocate_control_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function geolocate_control_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { geolocate_control_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { geolocate_control_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }











var geolocate_control_noop = function noop() {};

var geolocate_control_propTypes = Object.assign({}, mapControlPropTypes, {
  className: prop_types.string,
  style: prop_types.object,
  label: prop_types.string,
  disabledLabel: prop_types.string,
  auto: prop_types.bool,
  positionOptions: prop_types.object,
  fitBoundsOptions: prop_types.object,
  trackUserLocation: prop_types.bool,
  showUserLocation: prop_types.bool,
  showAccuracyCircle: prop_types.bool,
  onViewStateChange: prop_types.func,
  onViewportChange: prop_types.func,
  onGeolocate: prop_types.func
});
var geolocate_control_defaultProps = Object.assign({}, mapControlDefaultProps, {
  className: '',
  label: 'Find My Location',
  disabledLabel: 'Location Not Available',
  auto: false,
  positionOptions: {
    enableHighAccuracy: false,
    timeout: 6000
  },
  fitBoundsOptions: {
    maxZoom: 15
  },
  trackUserLocation: false,
  showUserLocation: true,
  showAccuracyCircle: true,
  onGeolocate: function onGeolocate() {}
});

function getBounds(position) {
  var center = new (mapbox_gl_default()).LngLat(position.coords.longitude, position.coords.latitude);
  var radius = position.coords.accuracy;
  var bounds = center.toBounds(radius);
  return [[bounds._ne.lng, bounds._ne.lat], [bounds._sw.lng, bounds._sw.lat]];
}

function setupMapboxGeolocateControl(context, props, geolocateButton) {
  var control = new (mapbox_gl_default()).GeolocateControl(props);
  control._container = document_.createElement('div');
  control._map = {
    on: function on() {},
    _getUIString: function _getUIString() {
      return '';
    }
  };

  control._setupUI(true);

  control._map = context.map;
  control._geolocateButton = geolocateButton;
  var eventManager = context.eventManager;

  if (control.options.trackUserLocation && eventManager) {
    eventManager.on('panstart', function () {
      if (control._watchState === 'ACTIVE_LOCK') {
        control._watchState = 'BACKGROUND';
        geolocateButton.classList.add('mapboxgl-ctrl-geolocate-background');
        geolocateButton.classList.remove('mapboxgl-ctrl-geolocate-active');
      }
    });
  }

  control.on('geolocate', props.onGeolocate);
  return control;
}

function updateCamera(position, _ref) {
  var context = _ref.context,
      props = _ref.props;
  var bounds = getBounds(position);

  var _context$viewport$fit = context.viewport.fitBounds(bounds, props.fitBoundsOptions),
      longitude = _context$viewport$fit.longitude,
      latitude = _context$viewport$fit.latitude,
      zoom = _context$viewport$fit.zoom;

  var newViewState = Object.assign({}, context.viewport, {
    longitude: longitude,
    latitude: latitude,
    zoom: zoom
  });
  var mapState = new MapState(newViewState);
  var viewState = Object.assign({}, mapState.getViewportProps(), LINEAR_TRANSITION_PROPS);
  var onViewportChange = props.onViewportChange || context.onViewportChange || geolocate_control_noop;
  var onViewStateChange = props.onViewStateChange || context.onViewStateChange || geolocate_control_noop;
  onViewStateChange({
    viewState: viewState
  });
  onViewportChange(viewState);
}

function GeolocateControl(props) {
  var thisRef = useMapControl(props);
  var context = thisRef.context,
      containerRef = thisRef.containerRef;
  var geolocateButtonRef = (0,react.useRef)(null);

  var _useState = (0,react.useState)(null),
      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),
      mapboxGeolocateControl = _useState2[0],
      createMapboxGeolocateControl = _useState2[1];

  var _useState3 = (0,react.useState)(false),
      _useState4 = (0,slicedToArray/* default */.Z)(_useState3, 2),
      supportsGeolocation = _useState4[0],
      setSupportsGeolocation = _useState4[1];

  (0,react.useEffect)(function () {
    var control;

    if (context.map) {
      isGeolocationSupported().then(function (result) {
        setSupportsGeolocation(result);

        if (geolocateButtonRef.current) {
          control = setupMapboxGeolocateControl(context, props, geolocateButtonRef.current);

          control._updateCamera = function (position) {
            return updateCamera(position, thisRef);
          };

          createMapboxGeolocateControl(control);
        }
      });
    }

    return function () {
      if (control) {
        control._clearWatch();
      }
    };
  }, [context.map]);
  var triggerGeolocate = (0,react.useCallback)(function () {
    if (mapboxGeolocateControl) {
      mapboxGeolocateControl.options = thisRef.props;
      mapboxGeolocateControl.trigger();
    }
  }, [mapboxGeolocateControl]);
  (0,react.useEffect)(function () {
    if (props.auto) {
      triggerGeolocate();
    }
  }, [mapboxGeolocateControl, props.auto]);
  (0,react.useEffect)(function () {
    if (mapboxGeolocateControl) {
      mapboxGeolocateControl._onZoom();
    }
  }, [context.viewport.zoom]);
  var className = props.className,
      label = props.label,
      disabledLabel = props.disabledLabel,
      trackUserLocation = props.trackUserLocation;
  var style = (0,react.useMemo)(function () {
    return geolocate_control_objectSpread({
      position: 'absolute'
    }, props.style);
  }, [props.style]);
  return react.createElement("div", {
    style: style,
    className: className
  }, react.createElement("div", {
    key: "geolocate-control",
    className: "mapboxgl-ctrl mapboxgl-ctrl-group",
    ref: containerRef
  }, react.createElement("button", {
    key: "geolocate",
    className: "mapboxgl-ctrl-icon mapboxgl-ctrl-geolocate",
    ref: geolocateButtonRef,
    disabled: !supportsGeolocation,
    "aria-pressed": !trackUserLocation,
    type: "button",
    title: supportsGeolocation ? label : disabledLabel,
    "aria-label": supportsGeolocation ? label : disabledLabel,
    onClick: triggerGeolocate
  }, react.createElement("span", {
    className: "mapboxgl-ctrl-icon",
    "aria-hidden": "true"
  }))));
}

GeolocateControl.propTypes = geolocate_control_propTypes;
GeolocateControl.defaultProps = geolocate_control_defaultProps;
/* harmony default export */ const geolocate_control = (react.memo(GeolocateControl));
//# sourceMappingURL=geolocate-control.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/version.js
function compareVersions(version1, version2) {
  var v1 = (version1 || '').split('.').map(Number);
  var v2 = (version2 || '').split('.').map(Number);

  for (var i = 0; i < 3; i++) {
    var part1 = v1[i] || 0;
    var part2 = v2[i] || 0;

    if (part1 < part2) {
      return -1;
    }

    if (part1 > part2) {
      return 1;
    }
  }

  return 0;
}
//# sourceMappingURL=version.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/navigation-control.js


function navigation_control_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function navigation_control_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { navigation_control_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { navigation_control_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }









var navigation_control_noop = function noop() {};

var navigation_control_propTypes = Object.assign({}, mapControlPropTypes, {
  className: prop_types.string,
  style: prop_types.object,
  onViewStateChange: prop_types.func,
  onViewportChange: prop_types.func,
  showCompass: prop_types.bool,
  showZoom: prop_types.bool,
  zoomInLabel: prop_types.string,
  zoomOutLabel: prop_types.string,
  compassLabel: prop_types.string
});
var navigation_control_defaultProps = Object.assign({}, mapControlDefaultProps, {
  className: '',
  showCompass: true,
  showZoom: true,
  zoomInLabel: 'Zoom In',
  zoomOutLabel: 'Zoom Out',
  compassLabel: 'Reset North'
});
var VERSION_LEGACY = 1;
var VERSION_1_6 = 2;

function getUIVersion(mapboxVersion) {
  return compareVersions(mapboxVersion, '1.6.0') >= 0 ? VERSION_1_6 : VERSION_LEGACY;
}

function updateViewport(context, props, opts) {
  var viewport = context.viewport;
  var mapState = new MapState(Object.assign({}, viewport, opts));
  var viewState = Object.assign({}, mapState.getViewportProps(), LINEAR_TRANSITION_PROPS);
  var onViewportChange = props.onViewportChange || context.onViewportChange || navigation_control_noop;
  var onViewStateChange = props.onViewStateChange || context.onViewStateChange || navigation_control_noop;
  onViewStateChange({
    viewState: viewState
  });
  onViewportChange(viewState);
}

function renderButton(type, label, callback, children) {
  return react.createElement("button", {
    key: type,
    className: "mapboxgl-ctrl-icon mapboxgl-ctrl-".concat(type),
    type: "button",
    title: label,
    onClick: callback
  }, children || react.createElement("span", {
    className: "mapboxgl-ctrl-icon",
    "aria-hidden": "true"
  }));
}

function renderCompass(context) {
  var uiVersion = (0,react.useMemo)(function () {
    return context.map ? getUIVersion(context.map.version) : VERSION_1_6;
  }, [context.map]);
  var bearing = context.viewport.bearing;
  var style = {
    transform: "rotate(".concat(-bearing, "deg)")
  };
  return uiVersion === VERSION_1_6 ? react.createElement("span", {
    className: "mapboxgl-ctrl-icon",
    "aria-hidden": "true",
    style: style
  }) : react.createElement("span", {
    className: "mapboxgl-ctrl-compass-arrow",
    style: style
  });
}

function NavigationControl(props) {
  var _useMapControl = useMapControl(props),
      context = _useMapControl.context,
      containerRef = _useMapControl.containerRef;

  var onZoomIn = function onZoomIn() {
    updateViewport(context, props, {
      zoom: context.viewport.zoom + 1
    });
  };

  var onZoomOut = function onZoomOut() {
    updateViewport(context, props, {
      zoom: context.viewport.zoom - 1
    });
  };

  var onResetNorth = function onResetNorth() {
    updateViewport(context, props, {
      bearing: 0,
      pitch: 0
    });
  };

  var className = props.className,
      showCompass = props.showCompass,
      showZoom = props.showZoom,
      zoomInLabel = props.zoomInLabel,
      zoomOutLabel = props.zoomOutLabel,
      compassLabel = props.compassLabel;
  var style = (0,react.useMemo)(function () {
    return navigation_control_objectSpread({
      position: 'absolute'
    }, props.style);
  }, [props.style]);
  return react.createElement("div", {
    style: style,
    className: className
  }, react.createElement("div", {
    className: "mapboxgl-ctrl mapboxgl-ctrl-group",
    ref: containerRef
  }, showZoom && renderButton('zoom-in', zoomInLabel, onZoomIn), showZoom && renderButton('zoom-out', zoomOutLabel, onZoomOut), showCompass && renderButton('compass', compassLabel, onResetNorth, renderCompass(context))));
}

NavigationControl.propTypes = navigation_control_propTypes;
NavigationControl.defaultProps = navigation_control_defaultProps;
/* harmony default export */ const navigation_control = (react.memo(NavigationControl));
//# sourceMappingURL=navigation-control.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/components/scale-control.js



function scale_control_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function scale_control_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { scale_control_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { scale_control_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }






var scale_control_propTypes = Object.assign({}, mapControlPropTypes, {
  className: prop_types.string,
  style: prop_types.object,
  maxWidth: prop_types.number,
  unit: prop_types.oneOf(['imperial', 'metric', 'nautical'])
});
var scale_control_defaultProps = Object.assign({}, mapControlDefaultProps, {
  className: '',
  maxWidth: 100,
  unit: 'metric'
});

function ScaleControl(props) {
  var _useMapControl = useMapControl(props),
      context = _useMapControl.context,
      containerRef = _useMapControl.containerRef;

  var _useState = (0,react.useState)(null),
      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),
      mapboxScaleControl = _useState2[0],
      createMapboxScaleControl = _useState2[1];

  (0,react.useEffect)(function () {
    if (context.map) {
      var control = new (mapbox_gl_default()).ScaleControl();
      control._map = context.map;
      control._container = containerRef.current;
      createMapboxScaleControl(control);
    }
  }, [context.map]);

  if (mapboxScaleControl) {
    mapboxScaleControl.options = props;

    mapboxScaleControl._onMove();
  }

  var style = (0,react.useMemo)(function () {
    return scale_control_objectSpread({
      position: 'absolute'
    }, props.style);
  }, [props.style]);
  return react.createElement("div", {
    style: style,
    className: props.className
  }, react.createElement("div", {
    ref: containerRef,
    className: "mapboxgl-ctrl mapboxgl-ctrl-scale"
  }));
}

ScaleControl.propTypes = scale_control_propTypes;
ScaleControl.defaultProps = scale_control_defaultProps;
/* harmony default export */ const scale_control = (react.memo(ScaleControl));
//# sourceMappingURL=scale-control.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/overlays/canvas-overlay.js





var canvas_overlay_pixelRatio = typeof window !== 'undefined' && window.devicePixelRatio || 1;
var canvas_overlay_propTypes = Object.assign({}, mapControlPropTypes, {
  redraw: prop_types.func.isRequired
});
var canvas_overlay_defaultProps = {
  captureScroll: false,
  captureDrag: false,
  captureClick: false,
  captureDoubleClick: false,
  capturePointerMove: false
};

function CanvasOverlay(props) {
  var _useMapControl = useMapControl(props),
      context = _useMapControl.context,
      containerRef = _useMapControl.containerRef;

  var _useState = (0,react.useState)(null),
      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),
      ctx = _useState2[0],
      setDrawingContext = _useState2[1];

  (0,react.useEffect)(function () {
    setDrawingContext(containerRef.current.getContext('2d'));
  }, []);
  var viewport = context.viewport,
      isDragging = context.isDragging;

  if (ctx) {
    ctx.save();
    ctx.scale(canvas_overlay_pixelRatio, canvas_overlay_pixelRatio);
    props.redraw({
      width: viewport.width,
      height: viewport.height,
      ctx: ctx,
      isDragging: isDragging,
      project: viewport.project,
      unproject: viewport.unproject
    });
    ctx.restore();
  }

  return react.createElement("canvas", {
    ref: containerRef,
    width: viewport.width * canvas_overlay_pixelRatio,
    height: viewport.height * canvas_overlay_pixelRatio,
    style: {
      width: "".concat(viewport.width, "px"),
      height: "".concat(viewport.height, "px"),
      position: 'absolute',
      left: 0,
      top: 0
    }
  });
}

CanvasOverlay.propTypes = canvas_overlay_propTypes;
CanvasOverlay.defaultProps = canvas_overlay_defaultProps;
/* harmony default export */ const canvas_overlay = ((/* unused pure expression or super */ null && (CanvasOverlay)));
//# sourceMappingURL=canvas-overlay.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/overlays/html-overlay.js


function html_overlay_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function html_overlay_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { html_overlay_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { html_overlay_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }




var html_overlay_propTypes = Object.assign({}, mapControlPropTypes, {
  redraw: prop_types.func.isRequired,
  style: prop_types.object
});
var html_overlay_defaultProps = {
  captureScroll: false,
  captureDrag: false,
  captureClick: false,
  captureDoubleClick: false,
  capturePointerMove: false
};

function HTMLOverlay(props) {
  var _useMapControl = useMapControl(props),
      context = _useMapControl.context,
      containerRef = _useMapControl.containerRef;

  var viewport = context.viewport,
      isDragging = context.isDragging;

  var style = html_overlay_objectSpread({
    position: 'absolute',
    left: 0,
    top: 0,
    width: viewport.width,
    height: viewport.height
  }, props.style);

  return react.createElement("div", {
    ref: containerRef,
    style: style
  }, props.redraw({
    width: viewport.width,
    height: viewport.height,
    isDragging: isDragging,
    project: viewport.project,
    unproject: viewport.unproject
  }));
}

HTMLOverlay.propTypes = html_overlay_propTypes;
HTMLOverlay.defaultProps = html_overlay_defaultProps;
/* harmony default export */ const html_overlay = ((/* unused pure expression or super */ null && (HTMLOverlay)));
//# sourceMappingURL=html-overlay.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/overlays/svg-overlay.js


function svg_overlay_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function svg_overlay_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { svg_overlay_ownKeys(Object(source), true).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { svg_overlay_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }




var svg_overlay_propTypes = Object.assign({}, mapControlPropTypes, {
  redraw: prop_types.func.isRequired,
  style: prop_types.object
});
var svg_overlay_defaultProps = {
  captureScroll: false,
  captureDrag: false,
  captureClick: false,
  captureDoubleClick: false,
  capturePointerMove: false
};

function SVGOverlay(props) {
  var _useMapControl = useMapControl(props),
      context = _useMapControl.context,
      containerRef = _useMapControl.containerRef;

  var viewport = context.viewport,
      isDragging = context.isDragging;

  var style = svg_overlay_objectSpread({
    position: 'absolute',
    left: 0,
    top: 0
  }, props.style);

  return react.createElement("svg", {
    width: viewport.width,
    height: viewport.height,
    ref: containerRef,
    style: style
  }, props.redraw({
    width: viewport.width,
    height: viewport.height,
    isDragging: isDragging,
    project: viewport.project,
    unproject: viewport.unproject
  }));
}

SVGOverlay.propTypes = svg_overlay_propTypes;
SVGOverlay.defaultProps = svg_overlay_defaultProps;
/* harmony default export */ const svg_overlay = ((/* unused pure expression or super */ null && (SVGOverlay)));
//# sourceMappingURL=svg-overlay.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/utils/set-rtl-text-plugin.js

var setRTLTextPlugin = (mapbox_gl_default()) ? (mapbox_gl_default()).setRTLTextPlugin : function () {};
/* harmony default export */ const set_rtl_text_plugin = ((/* unused pure expression or super */ null && (setRTLTextPlugin)));
//# sourceMappingURL=set-rtl-text-plugin.js.map
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/node_modules/react-map-gl/dist/esm/index.js
























//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/engine/dist/esm/animation/timeline.js
let channelHandles = 1;
let animationHandles = 1;
class Timeline {
  constructor() {
    this.time = 0;
    this.channels = new Map();
    this.animations = new Map();
    this.playing = false;
    this.lastEngineTime = -1;
  }

  addChannel(props) {
    const {
      delay = 0,
      duration = Number.POSITIVE_INFINITY,
      rate = 1,
      repeat = 1
    } = props;
    const handle = channelHandles++;
    const channel = {
      time: 0,
      delay,
      duration,
      rate,
      repeat
    };

    this._setChannelTime(channel, this.time);

    this.channels.set(handle, channel);
    return handle;
  }

  removeChannel(handle) {
    this.channels.delete(handle);

    for (const [animationHandle, animation] of this.animations) {
      if (animation.channel === handle) {
        this.detachAnimation(animationHandle);
      }
    }
  }

  isFinished(handle) {
    const channel = this.channels.get(handle);

    if (channel === undefined) {
      return false;
    }

    return this.time >= channel.delay + channel.duration * channel.repeat;
  }

  getTime(handle) {
    if (handle === undefined) {
      return this.time;
    }

    const channel = this.channels.get(handle);

    if (channel === undefined) {
      return -1;
    }

    return channel.time;
  }

  setTime(time) {
    this.time = Math.max(0, time);
    const channels = this.channels.values();

    for (const channel of channels) {
      this._setChannelTime(channel, this.time);
    }

    const animations = this.animations.values();

    for (const animationData of animations) {
      const {
        animation,
        channel
      } = animationData;
      animation.setTime(this.getTime(channel));
    }
  }

  play() {
    this.playing = true;
  }

  pause() {
    this.playing = false;
    this.lastEngineTime = -1;
  }

  reset() {
    this.setTime(0);
  }

  attachAnimation(animation, channelHandle) {
    const animationHandle = animationHandles++;
    this.animations.set(animationHandle, {
      animation,
      channel: channelHandle
    });
    animation.setTime(this.getTime(channelHandle));
    return animationHandle;
  }

  detachAnimation(handle) {
    this.animations.delete(handle);
  }

  update(engineTime) {
    if (this.playing) {
      if (this.lastEngineTime === -1) {
        this.lastEngineTime = engineTime;
      }

      this.setTime(this.time + (engineTime - this.lastEngineTime));
      this.lastEngineTime = engineTime;
    }
  }

  _setChannelTime(channel, time) {
    const offsetTime = time - channel.delay;
    const totalDuration = channel.duration * channel.repeat;

    if (offsetTime >= totalDuration) {
      channel.time = channel.duration * channel.rate;
    } else {
      channel.time = Math.max(0, offsetTime) % channel.duration;
      channel.time *= channel.rate;
    }
  }

}
//# sourceMappingURL=timeline.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/lifecycle/constants.js
var constants = __webpack_require__(85409);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/log.js
var log = __webpack_require__(80744);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/debug/index.js
var debug = __webpack_require__(63803);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/flatten.js
var flatten = __webpack_require__(61855);
// EXTERNAL MODULE: ./node_modules/@probe.gl/stats/dist/esm/index.js + 3 modules
var stats_dist_esm = __webpack_require__(26203);
// EXTERNAL MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/api/load.js + 23 modules
var load = __webpack_require__(73838);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/resource/resource.js

class Resource {
  constructor(id, data, context) {
    this.id = id;
    this.context = context;
    this._loadCount = 0;
    this._subscribers = new Set();
    this.setData(data);
  }

  subscribe(consumer) {
    this._subscribers.add(consumer);
  }

  unsubscribe(consumer) {
    this._subscribers.delete(consumer);
  }

  inUse() {
    return this._subscribers.size > 0;
  }

  delete() {}

  getData() {
    return this.isLoaded ? this._error ? Promise.reject(this._error) : this._content : this._loader.then(() => this.getData());
  }

  setData(data, forceUpdate) {
    if (data === this._data && !forceUpdate) {
      return;
    }

    this._data = data;
    const loadCount = ++this._loadCount;
    let loader = data;

    if (typeof data === 'string') {
      loader = (0,load/* load */.z)(data);
    }

    if (loader instanceof Promise) {
      this.isLoaded = false;
      this._loader = loader.then(result => {
        if (this._loadCount === loadCount) {
          this.isLoaded = true;
          this._error = null;
          this._content = result;
        }
      }).catch(error => {
        if (this._loadCount === loadCount) {
          this.isLoaded = true;
          this._error = error || true;
        }
      });
    } else {
      this.isLoaded = true;
      this._error = null;
      this._content = data;
    }

    for (const subscriber of this._subscribers) {
      subscriber.onChange(this.getData());
    }
  }

}
//# sourceMappingURL=resource.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/resource/resource-manager.js

class ResourceManager {
  constructor({
    gl,
    protocol
  }) {
    this.protocol = protocol || 'resource://';
    this._context = {
      gl,
      resourceManager: this
    };
    this._resources = {};
    this._consumers = {};
    this._pruneRequest = null;
  }

  contains(resourceId) {
    if (resourceId.startsWith(this.protocol)) {
      return true;
    }

    return resourceId in this._resources;
  }

  add({
    resourceId,
    data,
    forceUpdate = false,
    persistent = true
  }) {
    let res = this._resources[resourceId];

    if (res) {
      res.setData(data, forceUpdate);
    } else {
      res = new Resource(resourceId, data, this._context);
      this._resources[resourceId] = res;
    }

    res.persistent = persistent;
  }

  remove(resourceId) {
    const res = this._resources[resourceId];

    if (res) {
      res.delete();
      delete this._resources[resourceId];
    }
  }

  unsubscribe({
    consumerId
  }) {
    const consumer = this._consumers[consumerId];

    if (consumer) {
      for (const requestId in consumer) {
        const request = consumer[requestId];

        if (request.resource) {
          request.resource.unsubscribe(request);
        }
      }

      delete this._consumers[consumerId];
      this.prune();
    }
  }

  subscribe({
    resourceId,
    onChange,
    consumerId,
    requestId = 'default'
  }) {
    const {
      _resources: resources,
      protocol
    } = this;

    if (resourceId.startsWith(protocol)) {
      resourceId = resourceId.replace(protocol, '');

      if (!resources[resourceId]) {
        this.add({
          resourceId,
          data: null,
          persistent: false
        });
      }
    }

    const res = resources[resourceId];

    this._track(consumerId, requestId, res, onChange);

    if (res) {
      return res.getData();
    }

    return undefined;
  }

  prune() {
    if (!this._pruneRequest) {
      this._pruneRequest = setTimeout(() => this._prune(), 0);
    }
  }

  finalize() {
    for (const key in this._resources) {
      this._resources[key].delete();
    }
  }

  _track(consumerId, requestId, resource, onChange) {
    const consumers = this._consumers;
    const consumer = consumers[consumerId] = consumers[consumerId] || {};
    const request = consumer[requestId] || {};

    if (request.resource) {
      request.resource.unsubscribe(request);
      request.resource = null;
      this.prune();
    }

    if (resource) {
      consumer[requestId] = request;
      request.onChange = onChange;
      request.resource = resource;
      resource.subscribe(request);
    }
  }

  _prune() {
    this._pruneRequest = null;

    for (const key of Object.keys(this._resources)) {
      const res = this._resources[key];

      if (!res.persistent && !res.inUse()) {
        res.delete();
        delete this._resources[key];
      }
    }
  }

}
//# sourceMappingURL=resource-manager.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/viewports/viewport.js
var viewports_viewport = __webpack_require__(7013);
// EXTERNAL MODULE: ./node_modules/@luma.gl/engine/dist/esm/lib/program-manager.js + 8 modules
var program_manager = __webpack_require__(68432);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/shaderlib/misc/geometry.js
const vs = "\nstruct VertexGeometry {\n  vec4 position;\n  vec3 worldPosition;\n  vec3 worldPositionAlt;\n  vec3 normal;\n  vec2 uv;\n  vec3 pickingColor;\n} geometry;\n";
const fs = "\n#define SMOOTH_EDGE_RADIUS 0.5\n\nstruct FragmentGeometry {\n  vec2 uv;\n} geometry;\n\nfloat smoothedge(float edge, float x) {\n  return smoothstep(edge - SMOOTH_EDGE_RADIUS, edge + SMOOTH_EDGE_RADIUS, x);\n}\n";
/* harmony default export */ const geometry = ({
  name: 'geometry',
  vs,
  fs
});
//# sourceMappingURL=geometry.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.js + 2 modules
var project = __webpack_require__(68020);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/shaderlib/index.js







const DEFAULT_MODULES = [geometry, project/* default */.Z];
const SHADER_HOOKS = ['vs:DECKGL_FILTER_SIZE(inout vec3 size, VertexGeometry geometry)', 'vs:DECKGL_FILTER_GL_POSITION(inout vec4 position, VertexGeometry geometry)', 'vs:DECKGL_FILTER_COLOR(inout vec4 color, VertexGeometry geometry)', 'fs:DECKGL_FILTER_COLOR(inout vec4 color, FragmentGeometry geometry)'];
function createProgramManager(gl) {
  const programManager = program_manager/* default.getDefaultProgramManager */.Z.getDefaultProgramManager(gl);

  for (const shaderModule of DEFAULT_MODULES) {
    programManager.addDefaultModule(shaderModule);
  }

  for (const shaderHook of SHADER_HOOKS) {
    programManager.addShaderHook(shaderHook);
  }

  return programManager;
}

//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/layer-manager.js









const TRACE_SET_LAYERS = 'layerManager.setLayers';
const TRACE_ACTIVATE_VIEWPORT = 'layerManager.activateViewport';
const INITIAL_CONTEXT = Object.seal({
  layerManager: null,
  resourceManager: null,
  deck: null,
  gl: null,
  stats: null,
  shaderCache: null,
  pickingFBO: null,
  mousePosition: null,
  userData: {}
});
class LayerManager {
  constructor(gl, {
    deck,
    stats,
    viewport,
    timeline
  } = {}) {
    this.lastRenderedLayers = [];
    this.layers = [];
    this.resourceManager = new ResourceManager({
      gl,
      protocol: 'deck://'
    });
    this.context = { ...INITIAL_CONTEXT,
      layerManager: this,
      gl,
      deck,
      programManager: gl && createProgramManager(gl),
      stats: stats || new stats_dist_esm/* Stats */.jk({
        id: 'deck.gl'
      }),
      viewport: viewport || new viewports_viewport/* default */.Z({
        id: 'DEFAULT-INITIAL-VIEWPORT'
      }),
      timeline: timeline || new Timeline(),
      resourceManager: this.resourceManager
    };
    this._nextLayers = null;
    this._needsRedraw = 'Initial render';
    this._needsUpdate = false;
    this._debug = false;
    this.activateViewport = this.activateViewport.bind(this);
    Object.seal(this);
  }

  finalize() {
    this.resourceManager.finalize();

    for (const layer of this.layers) {
      this._finalizeLayer(layer);
    }
  }

  needsRedraw(opts = {
    clearRedrawFlags: false
  }) {
    let redraw = this._needsRedraw;

    if (opts.clearRedrawFlags) {
      this._needsRedraw = false;
    }

    for (const layer of this.layers) {
      const layerNeedsRedraw = layer.getNeedsRedraw(opts);
      redraw = redraw || layerNeedsRedraw;
    }

    return redraw;
  }

  needsUpdate() {
    if (this._nextLayers && this._nextLayers !== this.lastRenderedLayers) {
      return 'layers changed';
    }

    return this._needsUpdate;
  }

  setNeedsRedraw(reason) {
    this._needsRedraw = this._needsRedraw || reason;
  }

  setNeedsUpdate(reason) {
    this._needsUpdate = this._needsUpdate || reason;
  }

  getLayers({
    layerIds = null
  } = {}) {
    return layerIds ? this.layers.filter(layer => layerIds.find(layerId => layer.id.indexOf(layerId) === 0)) : this.layers;
  }

  setProps(props) {
    if ('debug' in props) {
      this._debug = props.debug;
    }

    if ('userData' in props) {
      this.context.userData = props.userData;
    }

    if ('layers' in props) {
      this._nextLayers = props.layers;
    }

    if ('onError' in props) {
      this.context.onError = props.onError;
    }
  }

  setLayers(newLayers, reason) {
    (0,debug/* default */.Z)(TRACE_SET_LAYERS, this, reason, newLayers);
    this.lastRenderedLayers = newLayers;
    newLayers = (0,flatten/* flatten */.x)(newLayers, Boolean);

    for (const layer of newLayers) {
      layer.context = this.context;
    }

    this._updateLayers(this.layers, newLayers);

    return this;
  }

  updateLayers() {
    const reason = this.needsUpdate();

    if (reason) {
      this.setNeedsRedraw("updating layers: ".concat(reason));
      this.setLayers(this._nextLayers || this.lastRenderedLayers, reason);
    }

    this._nextLayers = null;
  }

  activateViewport(viewport) {
    (0,debug/* default */.Z)(TRACE_ACTIVATE_VIEWPORT, this, viewport);

    if (viewport) {
      this.context.viewport = viewport;
    }

    return this;
  }

  _handleError(stage, error, layer) {
    layer.raiseError(error, "".concat(stage, " of ").concat(layer));
  }

  _updateLayers(oldLayers, newLayers) {
    const oldLayerMap = {};

    for (const oldLayer of oldLayers) {
      if (oldLayerMap[oldLayer.id]) {
        log/* default.warn */.Z.warn("Multiple old layers with same id ".concat(oldLayer.id))();
      } else {
        oldLayerMap[oldLayer.id] = oldLayer;
      }
    }

    const generatedLayers = [];

    this._updateSublayersRecursively(newLayers, oldLayerMap, generatedLayers);

    this._finalizeOldLayers(oldLayerMap);

    let needsUpdate = false;

    for (const layer of generatedLayers) {
      if (layer.hasUniformTransition()) {
        needsUpdate = true;
        break;
      }
    }

    this._needsUpdate = needsUpdate;
    this.layers = generatedLayers;
  }

  _updateSublayersRecursively(newLayers, oldLayerMap, generatedLayers) {
    for (const newLayer of newLayers) {
      newLayer.context = this.context;
      const oldLayer = oldLayerMap[newLayer.id];

      if (oldLayer === null) {
        log/* default.warn */.Z.warn("Multiple new layers with same id ".concat(newLayer.id))();
      }

      oldLayerMap[newLayer.id] = null;
      let sublayers = null;

      try {
        if (this._debug && oldLayer !== newLayer) {
          newLayer.validateProps();
        }

        if (!oldLayer) {
          this._initializeLayer(newLayer);
        } else {
          this._transferLayerState(oldLayer, newLayer);

          this._updateLayer(newLayer);
        }

        generatedLayers.push(newLayer);
        sublayers = newLayer.isComposite && newLayer.getSubLayers();
      } catch (err) {
        this._handleError('matching', err, newLayer);
      }

      if (sublayers) {
        this._updateSublayersRecursively(sublayers, oldLayerMap, generatedLayers);
      }
    }
  }

  _finalizeOldLayers(oldLayerMap) {
    for (const layerId in oldLayerMap) {
      const layer = oldLayerMap[layerId];

      if (layer) {
        this._finalizeLayer(layer);
      }
    }
  }

  _initializeLayer(layer) {
    try {
      layer._initialize();

      layer.lifecycle = constants/* LIFECYCLE.INITIALIZED */.d.INITIALIZED;
    } catch (err) {
      this._handleError('initialization', err, layer);
    }
  }

  _transferLayerState(oldLayer, newLayer) {
    newLayer._transferState(oldLayer);

    newLayer.lifecycle = constants/* LIFECYCLE.MATCHED */.d.MATCHED;

    if (newLayer !== oldLayer) {
      oldLayer.lifecycle = constants/* LIFECYCLE.AWAITING_GC */.d.AWAITING_GC;
    }
  }

  _updateLayer(layer) {
    try {
      layer._update();
    } catch (err) {
      this._handleError('update', err, layer);
    }
  }

  _finalizeLayer(layer) {
    this._needsRedraw = this._needsRedraw || "finalized ".concat(layer);
    layer.lifecycle = constants/* LIFECYCLE.AWAITING_FINALIZATION */.d.AWAITING_FINALIZATION;

    try {
      layer._finalize();

      layer.lifecycle = constants/* LIFECYCLE.FINALIZED */.d.FINALIZED;
    } catch (err) {
      this._handleError('finalization', err, layer);
    }
  }

}
//# sourceMappingURL=layer-manager.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/deep-equal.js
function deep_equal_deepEqual(a, b) {
  if (a === b) {
    return true;
  }

  if (!a || !b) {
    return false;
  }

  for (const key in a) {
    const aValue = a[key];
    const bValue = b[key];
    const equals = aValue === bValue || Array.isArray(aValue) && Array.isArray(bValue) && deep_equal_deepEqual(aValue, bValue);

    if (!equals) {
      return false;
    }
  }

  return true;
}
//# sourceMappingURL=deep-equal.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/view-manager.js



class ViewManager {
  constructor(props = {}) {
    this.views = [];
    this.width = 100;
    this.height = 100;
    this.viewState = {};
    this.controllers = {};
    this.timeline = props.timeline;
    this._viewports = [];
    this._viewportMap = {};
    this._isUpdating = false;
    this._needsRedraw = 'Initial render';
    this._needsUpdate = true;
    this._eventManager = props.eventManager;
    this._eventCallbacks = {
      onViewStateChange: props.onViewStateChange,
      onInteractionStateChange: props.onInteractionStateChange
    };
    Object.seal(this);
    this.setProps(props);
  }

  finalize() {
    for (const key in this.controllers) {
      if (this.controllers[key]) {
        this.controllers[key].finalize();
      }
    }

    this.controllers = {};
  }

  needsRedraw(opts = {
    clearRedrawFlags: false
  }) {
    const redraw = this._needsRedraw;

    if (opts.clearRedrawFlags) {
      this._needsRedraw = false;
    }

    return redraw;
  }

  setNeedsUpdate(reason) {
    this._needsUpdate = this._needsUpdate || reason;
    this._needsRedraw = this._needsRedraw || reason;
  }

  updateViewStates() {
    for (const viewId in this.controllers) {
      const controller = this.controllers[viewId];

      if (controller) {
        controller.updateTransition();
      }
    }
  }

  getViewports(rect) {
    if (rect) {
      return this._viewports.filter(viewport => viewport.containsPixel(rect));
    }

    return this._viewports;
  }

  getViews() {
    const viewMap = {};
    this.views.forEach(view => {
      viewMap[view.id] = view;
    });
    return viewMap;
  }

  getView(viewOrViewId) {
    return typeof viewOrViewId === 'string' ? this.views.find(view => view.id === viewOrViewId) : viewOrViewId;
  }

  getViewState(viewId) {
    const view = this.getView(viewId);
    const viewState = view && this.viewState[view.getViewStateId()] || this.viewState;
    return view ? view.filterViewState(viewState) : viewState;
  }

  getViewport(viewId) {
    return this._viewportMap[viewId];
  }

  unproject(xyz, opts) {
    const viewports = this.getViewports();
    const pixel = {
      x: xyz[0],
      y: xyz[1]
    };

    for (let i = viewports.length - 1; i >= 0; --i) {
      const viewport = viewports[i];

      if (viewport.containsPixel(pixel)) {
        const p = xyz.slice();
        p[0] -= viewport.x;
        p[1] -= viewport.y;
        return viewport.unproject(p, opts);
      }
    }

    return null;
  }

  setProps(props) {
    if ('views' in props) {
      this._setViews(props.views);
    }

    if ('viewState' in props) {
      this._setViewState(props.viewState);
    }

    if ('width' in props || 'height' in props) {
      this._setSize(props.width, props.height);
    }

    if (!this._isUpdating) {
      this._update();
    }
  }

  _update() {
    this._isUpdating = true;

    if (this._needsUpdate) {
      this._needsUpdate = false;

      this._rebuildViewports();
    }

    if (this._needsUpdate) {
      this._needsUpdate = false;

      this._rebuildViewports();
    }

    this._isUpdating = false;
  }

  _setSize(width, height) {
    if (width !== this.width || height !== this.height) {
      this.width = width;
      this.height = height;
      this.setNeedsUpdate('Size changed');
    }
  }

  _setViews(views) {
    views = (0,flatten/* flatten */.x)(views, Boolean);

    const viewsChanged = this._diffViews(views, this.views);

    if (viewsChanged) {
      this.setNeedsUpdate('views changed');
    }

    this.views = views;
  }

  _setViewState(viewState) {
    if (viewState) {
      const viewStateChanged = !deep_equal_deepEqual(viewState, this.viewState);

      if (viewStateChanged) {
        this.setNeedsUpdate('viewState changed');
      }

      this.viewState = viewState;
    } else {
      log/* default.warn */.Z.warn('missing `viewState` or `initialViewState`')();
    }
  }

  _onViewStateChange(viewId, event) {
    event.viewId = viewId;

    if (this._eventCallbacks.onViewStateChange) {
      this._eventCallbacks.onViewStateChange(event);
    }
  }

  _createController(view, props) {
    const Controller = props.type;
    const controller = new Controller({
      timeline: this.timeline,
      eventManager: this._eventManager,
      onViewStateChange: this._onViewStateChange.bind(this, props.id),
      onStateChange: this._eventCallbacks.onInteractionStateChange,
      makeViewport: viewState => view._getViewport(viewState, {
        width: viewState.width,
        height: viewState.height
      }),
      ...props
    });
    return controller;
  }

  _updateController(view, viewState, viewport, controller) {
    let controllerProps = view.controller;

    if (controllerProps) {
      controllerProps = { ...viewState,
        ...view.props,
        ...controllerProps,
        id: view.id,
        x: viewport.x,
        y: viewport.y,
        width: viewport.width,
        height: viewport.height
      };

      if (controller) {
        controller.setProps(controllerProps);
      } else {
        controller = this._createController(view, controllerProps);
      }

      return controller;
    }

    return null;
  }

  _rebuildViewports() {
    const {
      width,
      height,
      views
    } = this;
    const oldControllers = this.controllers;
    this._viewports = [];
    this.controllers = {};
    let invalidateControllers = false;

    for (let i = views.length; i--;) {
      const view = views[i];
      const viewState = this.getViewState(view);
      const viewport = view.makeViewport({
        width,
        height,
        viewState
      });
      let oldController = oldControllers[view.id];

      if (view.controller && !oldController) {
        invalidateControllers = true;
      }

      if ((invalidateControllers || !view.controller) && oldController) {
        oldController.finalize();
        oldController = null;
      }

      this.controllers[view.id] = this._updateController(view, viewState, viewport, oldController);

      this._viewports.unshift(viewport);
    }

    for (const id in oldControllers) {
      if (oldControllers[id] && !this.controllers[id]) {
        oldControllers[id].finalize();
      }
    }

    this._buildViewportMap();
  }

  _buildViewportMap() {
    this._viewportMap = {};

    this._viewports.forEach(viewport => {
      if (viewport.id) {
        this._viewportMap[viewport.id] = this._viewportMap[viewport.id] || viewport;
      }
    });
  }

  _diffViews(newViews, oldViews) {
    if (newViews.length !== oldViews.length) {
      return true;
    }

    return newViews.some((_, i) => !newViews[i].equals(oldViews[i]));
  }

}
//# sourceMappingURL=view-manager.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/positions.js
const PERCENT_OR_PIXELS_REGEX = /([0-9]+\.?[0-9]*)(%|px)/;
function parsePosition(value) {
  switch (typeof value) {
    case 'number':
      return {
        position: value,
        relative: false
      };

    case 'string':
      const match = value.match(PERCENT_OR_PIXELS_REGEX);

      if (match && match.length >= 3) {
        const relative = match[2] === '%';
        const position = parseFloat(match[1]);
        return {
          position: relative ? position / 100 : position,
          relative
        };
      }

    default:
      throw new Error("Could not parse position string ".concat(value));
  }
}
function positions_getPosition(position, extent) {
  return position.relative ? Math.round(position.position * extent) : position.position;
}
//# sourceMappingURL=positions.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/assert.js
var utils_assert = __webpack_require__(75304);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/views/view.js




class View {
  constructor(props = {}) {
    const {
      id = null,
      x = 0,
      y = 0,
      width = '100%',
      height = '100%',
      projectionMatrix = null,
      fovy = 50,
      near = 0.1,
      far = 1000,
      modelMatrix = null,
      viewportInstance = null,
      type = viewports_viewport/* default */.Z
    } = props;
    (0,utils_assert/* default */.Z)(!viewportInstance || viewportInstance instanceof viewports_viewport/* default */.Z);
    this.viewportInstance = viewportInstance;
    this.id = id || this.constructor.displayName || 'view';
    this.type = type;
    this.props = { ...props,
      id: this.id,
      projectionMatrix,
      fovy,
      near,
      far,
      modelMatrix
    };

    this._parseDimensions({
      x,
      y,
      width,
      height
    });

    this.equals = this.equals.bind(this);
    Object.seal(this);
  }

  equals(view) {
    if (this === view) {
      return true;
    }

    if (this.viewportInstance) {
      return view.viewportInstance && this.viewportInstance.equals(view.viewportInstance);
    }

    const viewChanged = deep_equal_deepEqual(this.props, view.props);
    return viewChanged;
  }

  makeViewport({
    width,
    height,
    viewState
  }) {
    if (this.viewportInstance) {
      return this.viewportInstance;
    }

    viewState = this.filterViewState(viewState);
    const viewportDimensions = this.getDimensions({
      width,
      height
    });
    return this._getViewport(viewState, viewportDimensions);
  }

  getViewStateId() {
    switch (typeof this.props.viewState) {
      case 'string':
        return this.props.viewState;

      case 'object':
        return this.props.viewState && this.props.viewState.id;

      default:
        return this.id;
    }
  }

  filterViewState(viewState) {
    if (this.props.viewState && typeof this.props.viewState === 'object') {
      if (!this.props.viewState.id) {
        return this.props.viewState;
      }

      const newViewState = { ...viewState
      };

      for (const key in this.props.viewState) {
        if (key !== 'id') {
          newViewState[key] = this.props.viewState[key];
        }
      }

      return newViewState;
    }

    return viewState;
  }

  getDimensions({
    width,
    height
  }) {
    return {
      x: positions_getPosition(this._x, width),
      y: positions_getPosition(this._y, height),
      width: positions_getPosition(this._width, width),
      height: positions_getPosition(this._height, height)
    };
  }

  _getControllerProps(defaultOpts) {
    let opts = this.props.controller;

    if (!opts) {
      return null;
    }

    if (opts === true) {
      return defaultOpts;
    }

    if (typeof opts === 'function') {
      opts = {
        type: opts
      };
    }

    return { ...defaultOpts,
      ...opts
    };
  }

  _getViewport(viewState, viewportDimensions) {
    const {
      type: ViewportType
    } = this;
    return new ViewportType({ ...viewState,
      ...this.props,
      ...viewportDimensions
    });
  }

  _parseDimensions({
    x,
    y,
    width,
    height
  }) {
    this._x = parsePosition(x);
    this._y = parsePosition(y);
    this._width = parsePosition(width);
    this._height = parsePosition(height);
  }

}
//# sourceMappingURL=view.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/viewports/web-mercator-viewport.js
var web_mercator_viewport = __webpack_require__(96935);
// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/lib/common.js
var common = __webpack_require__(14034);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/transitions/transition.js
var transition = __webpack_require__(26395);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/controllers/transition-manager.js


const controllers_transition_manager_noop = () => {};

const transition_manager_TRANSITION_EVENTS = {
  BREAK: 1,
  SNAP_TO_END: 2,
  IGNORE: 3
};
const transition_manager_DEFAULT_PROPS = {
  transitionEasing: t => t,
  transitionInterruption: transition_manager_TRANSITION_EVENTS.BREAK,
  onTransitionStart: controllers_transition_manager_noop,
  onTransitionInterrupt: controllers_transition_manager_noop,
  onTransitionEnd: controllers_transition_manager_noop
};
class transition_manager_TransitionManager {
  constructor(ControllerState, props = {}) {
    this.ControllerState = ControllerState;
    this.props = { ...transition_manager_DEFAULT_PROPS,
      ...props
    };
    this.propsInTransition = null;
    this.transition = new transition/* default */.Z(props.timeline);
    this.onViewStateChange = props.onViewStateChange || controllers_transition_manager_noop;
    this.onStateChange = props.onStateChange || controllers_transition_manager_noop;
    this._onTransitionUpdate = this._onTransitionUpdate.bind(this);
  }

  finalize() {
    this.transition.cancel();
  }

  getViewportInTransition() {
    return this.propsInTransition;
  }

  processViewStateChange(nextProps) {
    let transitionTriggered = false;
    const currentProps = this.props;
    nextProps = { ...transition_manager_DEFAULT_PROPS,
      ...nextProps
    };
    this.props = nextProps;

    if (this._shouldIgnoreViewportChange(currentProps, nextProps)) {
      return transitionTriggered;
    }

    if (this._isTransitionEnabled(nextProps)) {
      const {
        interruption,
        endProps
      } = this.transition.settings;
      const startProps = { ...currentProps,
        ...(interruption === transition_manager_TRANSITION_EVENTS.SNAP_TO_END ? endProps : this.propsInTransition || currentProps)
      };

      this._triggerTransition(startProps, nextProps);

      transitionTriggered = true;
    } else {
      this.transition.cancel();
    }

    return transitionTriggered;
  }

  updateTransition() {
    this.transition.update();
  }

  _isTransitionEnabled(props) {
    const {
      transitionDuration,
      transitionInterpolator
    } = props;
    return (transitionDuration > 0 || transitionDuration === 'auto') && Boolean(transitionInterpolator);
  }

  _isUpdateDueToCurrentTransition(props) {
    if (this.transition.inProgress) {
      return this.transition.settings.interpolator.arePropsEqual(props, this.propsInTransition);
    }

    return false;
  }

  _shouldIgnoreViewportChange(currentProps, nextProps) {
    if (this.transition.inProgress) {
      return this.transition.settings.interruption === transition_manager_TRANSITION_EVENTS.IGNORE || this._isUpdateDueToCurrentTransition(nextProps);
    } else if (this._isTransitionEnabled(nextProps)) {
      return nextProps.transitionInterpolator.arePropsEqual(currentProps, nextProps);
    }

    return true;
  }

  _triggerTransition(startProps, endProps) {
    const startViewstate = new this.ControllerState(startProps);
    const endViewStateProps = new this.ControllerState(endProps).shortestPathFrom(startViewstate);
    const {
      transitionInterpolator
    } = endProps;
    const duration = transitionInterpolator.getDuration ? transitionInterpolator.getDuration(startProps, endProps) : endProps.transitionDuration;

    if (duration === 0) {
      return;
    }

    const initialProps = endProps.transitionInterpolator.initializeProps(startProps, endViewStateProps);
    this.propsInTransition = {};
    this.duration = duration;
    this.transition.start({
      duration,
      easing: endProps.transitionEasing,
      interpolator: endProps.transitionInterpolator,
      interruption: endProps.transitionInterruption,
      startProps: initialProps.start,
      endProps: initialProps.end,
      onStart: endProps.onTransitionStart,
      onUpdate: this._onTransitionUpdate,
      onInterrupt: this._onTransitionEnd(endProps.onTransitionInterrupt),
      onEnd: this._onTransitionEnd(endProps.onTransitionEnd)
    });
    this.onStateChange({
      inTransition: true
    });
    this.updateTransition();
  }

  _onTransitionEnd(callback) {
    return transition => {
      this.propsInTransition = null;
      this.onStateChange({
        inTransition: false,
        isZooming: false,
        isPanning: false,
        isRotating: false
      });
      callback(transition);
    };
  }

  _onTransitionUpdate(transition) {
    const {
      time,
      settings: {
        interpolator,
        startProps,
        endProps,
        duration,
        easing
      }
    } = transition;
    const t = easing(time / duration);
    const viewport = interpolator.interpolateProps(startProps, endProps, t);
    this.propsInTransition = new this.ControllerState({ ...this.props,
      ...viewport
    }).getViewportProps();
    this.onViewStateChange({
      viewState: this.propsInTransition,
      oldViewState: this.props
    });
  }

}
//# sourceMappingURL=transition-manager.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/transitions/transition-interpolator.js


class transition_interpolator_TransitionInterpolator {
  constructor(opts = {}) {
    if (Array.isArray(opts)) {
      opts = {
        compare: opts,
        extract: opts,
        required: opts
      };
    }

    const {
      compare,
      extract,
      required
    } = opts;
    this._propsToCompare = compare;
    this._propsToExtract = extract;
    this._requiredProps = required;
  }

  arePropsEqual(currentProps, nextProps) {
    for (const key of this._propsToCompare || Object.keys(nextProps)) {
      if (!(key in currentProps) || !(key in nextProps) || !(0,common/* equals */.fS)(currentProps[key], nextProps[key])) {
        return false;
      }
    }

    return true;
  }

  initializeProps(startProps, endProps) {
    let result;

    if (this._propsToExtract) {
      const startViewStateProps = {};
      const endViewStateProps = {};

      for (const key of this._propsToExtract) {
        startViewStateProps[key] = startProps[key];
        endViewStateProps[key] = endProps[key];
      }

      result = {
        start: startViewStateProps,
        end: endViewStateProps
      };
    } else {
      result = {
        start: startProps,
        end: endProps
      };
    }

    this._checkRequiredProps(result.start);

    this._checkRequiredProps(result.end);

    return result;
  }

  interpolateProps(startProps, endProps, t) {
    return endProps;
  }

  getDuration(startProps, endProps) {
    return endProps.transitionDuration;
  }

  _checkRequiredProps(props) {
    if (!this._requiredProps) {
      return;
    }

    this._requiredProps.forEach(propName => {
      const value = props[propName];
      (0,utils_assert/* default */.Z)(Number.isFinite(value) || Array.isArray(value), "".concat(propName, " is required for transition"));
    });
  }

}
//# sourceMappingURL=transition-interpolator.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/transitions/linear-interpolator.js


const linear_interpolator_DEFAULT_PROPS = ['longitude', 'latitude', 'zoom', 'bearing', 'pitch'];
const DEFAULT_REQUIRED_PROPS = ['longitude', 'latitude', 'zoom'];
class linear_interpolator_LinearInterpolator extends transition_interpolator_TransitionInterpolator {
  constructor(opts = {}) {
    const transitionProps = Array.isArray(opts) ? opts : opts.transitionProps;
    super(transitionProps || {
      compare: linear_interpolator_DEFAULT_PROPS,
      extract: linear_interpolator_DEFAULT_PROPS,
      required: DEFAULT_REQUIRED_PROPS
    });
    this.opts = opts;
  }

  initializeProps(startProps, endProps) {
    const result = super.initializeProps(startProps, endProps);
    const {
      makeViewport,
      around
    } = this.opts;

    if (makeViewport && around) {
      const startViewport = makeViewport(startProps);
      const endViewport = makeViewport(endProps);
      const aroundPosition = startViewport.unproject(around);
      result.start.around = around;
      Object.assign(result.end, {
        around: endViewport.project(aroundPosition),
        aroundPosition,
        width: endProps.width,
        height: endProps.height
      });
    }

    return result;
  }

  interpolateProps(startProps, endProps, t) {
    const propsInTransition = {};

    for (const key of this._propsToExtract) {
      propsInTransition[key] = (0,common/* lerp */.t7)(startProps[key] || 0, endProps[key] || 0, t);
    }

    if (endProps.aroundPosition) {
      const viewport = this.opts.makeViewport({ ...endProps,
        ...propsInTransition
      });
      Object.assign(propsInTransition, viewport.panByPosition(endProps.aroundPosition, (0,common/* lerp */.t7)(startProps.around, endProps.around, t)));
    }

    return propsInTransition;
  }

}
//# sourceMappingURL=linear-interpolator.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/controllers/controller.js


const controller_NO_TRANSITION_PROPS = {
  transitionDuration: 0
};
const controller_LINEAR_TRANSITION_PROPS = {
  transitionDuration: 300,
  transitionEasing: t => t,
  transitionInterruption: transition_manager_TRANSITION_EVENTS.BREAK
};
const controller_DEFAULT_INERTIA = 300;

const controller_INERTIA_EASING = t => 1 - (1 - t) * (1 - t);

const controller_EVENT_TYPES = {
  WHEEL: ['wheel'],
  PAN: ['panstart', 'panmove', 'panend'],
  PINCH: ['pinchstart', 'pinchmove', 'pinchend'],
  TRIPLE_PAN: ['tripanstart', 'tripanmove', 'tripanend'],
  DOUBLE_TAP: ['doubletap'],
  KEYBOARD: ['keydown']
};
class Controller {
  constructor(ControllerState, options = {}) {
    this.ControllerState = ControllerState;
    this.controllerState = null;
    this.controllerStateProps = null;
    this.eventManager = null;
    this.transitionManager = new transition_manager_TransitionManager(ControllerState, { ...options,
      onViewStateChange: this._onTransition.bind(this),
      onStateChange: this._setInteractionState.bind(this)
    });
    const linearTransitionProps = this.linearTransitionProps;
    this._transition = linearTransitionProps && { ...controller_LINEAR_TRANSITION_PROPS,
      transitionInterpolator: new linear_interpolator_LinearInterpolator({
        transitionProps: linearTransitionProps
      })
    };
    this._events = null;
    this._interactionState = {
      isDragging: false
    };
    this._customEvents = [];
    this.onViewStateChange = null;
    this.onStateChange = null;
    this.handleEvent = this.handleEvent.bind(this);
    this.setProps(options);
  }

  get linearTransitionProps() {
    return null;
  }

  set events(customEvents) {
    this.toggleEvents(this._customEvents, false);
    this.toggleEvents(customEvents, true);
    this._customEvents = customEvents;
    this.setProps(this.controllerStateProps);
  }

  finalize() {
    for (const eventName in this._events) {
      if (this._events[eventName]) {
        this.eventManager.off(eventName, this.handleEvent);
      }
    }

    this.transitionManager.finalize();
  }

  handleEvent(event) {
    const {
      ControllerState
    } = this;
    this.controllerState = new ControllerState({
      makeViewport: this.makeViewport,
      ...this.controllerStateProps,
      ...this._state
    });
    const eventStartBlocked = this._eventStartBlocked;

    switch (event.type) {
      case 'panstart':
        return eventStartBlocked ? false : this._onPanStart(event);

      case 'panmove':
        return this._onPan(event);

      case 'panend':
        return this._onPanEnd(event);

      case 'pinchstart':
        return eventStartBlocked ? false : this._onPinchStart(event);

      case 'pinchmove':
        return this._onPinch(event);

      case 'pinchend':
        return this._onPinchEnd(event);

      case 'tripanstart':
        return eventStartBlocked ? false : this._onTriplePanStart(event);

      case 'tripanmove':
        return this._onTriplePan(event);

      case 'tripanend':
        return this._onTriplePanEnd(event);

      case 'doubletap':
        return this._onDoubleTap(event);

      case 'wheel':
        return this._onWheel(event);

      case 'keydown':
        return this._onKeyDown(event);

      default:
        return false;
    }
  }

  getCenter(event) {
    const {
      x,
      y
    } = this.controllerStateProps;
    const {
      offsetCenter
    } = event;
    return [offsetCenter.x - x, offsetCenter.y - y];
  }

  isPointInBounds(pos, event) {
    const {
      width,
      height
    } = this.controllerStateProps;

    if (event && event.handled) {
      return false;
    }

    const inside = pos[0] >= 0 && pos[0] <= width && pos[1] >= 0 && pos[1] <= height;

    if (inside && event) {
      event.stopPropagation();
    }

    return inside;
  }

  isFunctionKeyPressed(event) {
    const {
      srcEvent
    } = event;
    return Boolean(srcEvent.metaKey || srcEvent.altKey || srcEvent.ctrlKey || srcEvent.shiftKey);
  }

  isDragging() {
    return this._interactionState.isDragging;
  }

  blockEvents(timeout) {
    const timer = setTimeout(() => {
      if (this._eventStartBlocked === timer) {
        this._eventStartBlocked = null;
      }
    }, timeout);
    this._eventStartBlocked = timer;
  }

  setProps(props) {
    if ('onViewStateChange' in props) {
      this.onViewStateChange = props.onViewStateChange;
    }

    if ('onStateChange' in props) {
      this.onStateChange = props.onStateChange;
    }

    if ('makeViewport' in props) {
      this.makeViewport = props.makeViewport;
    }

    if ('dragMode' in props) {
      this.dragMode = props.dragMode;
    }

    this.controllerStateProps = props;

    if ('eventManager' in props && this.eventManager !== props.eventManager) {
      this.eventManager = props.eventManager;
      this._events = {};
      this.toggleEvents(this._customEvents, true);
    }

    if (!('transitionInterpolator' in props)) {
      props.transitionInterpolator = this._getTransitionProps().transitionInterpolator;
    }

    this.transitionManager.processViewStateChange(props);
    let {
      inertia
    } = props;

    if (inertia === true) {
      inertia = controller_DEFAULT_INERTIA;
    }

    this.inertia = inertia;
    const {
      scrollZoom = true,
      dragPan = true,
      dragRotate = true,
      doubleClickZoom = true,
      touchZoom = true,
      touchRotate = false,
      keyboard = true
    } = props;
    const isInteractive = Boolean(this.onViewStateChange);
    this.toggleEvents(controller_EVENT_TYPES.WHEEL, isInteractive && scrollZoom);
    this.toggleEvents(controller_EVENT_TYPES.PAN, isInteractive && (dragPan || dragRotate));
    this.toggleEvents(controller_EVENT_TYPES.PINCH, isInteractive && (touchZoom || touchRotate));
    this.toggleEvents(controller_EVENT_TYPES.TRIPLE_PAN, isInteractive && touchRotate);
    this.toggleEvents(controller_EVENT_TYPES.DOUBLE_TAP, isInteractive && doubleClickZoom);
    this.toggleEvents(controller_EVENT_TYPES.KEYBOARD, isInteractive && keyboard);
    this.scrollZoom = scrollZoom;
    this.dragPan = dragPan;
    this.dragRotate = dragRotate;
    this.doubleClickZoom = doubleClickZoom;
    this.touchZoom = touchZoom;
    this.touchRotate = touchRotate;
    this.keyboard = keyboard;
  }

  updateTransition() {
    this.transitionManager.updateTransition();
  }

  toggleEvents(eventNames, enabled) {
    if (this.eventManager) {
      eventNames.forEach(eventName => {
        if (this._events[eventName] !== enabled) {
          this._events[eventName] = enabled;

          if (enabled) {
            this.eventManager.on(eventName, this.handleEvent);
          } else {
            this.eventManager.off(eventName, this.handleEvent);
          }
        }
      });
    }
  }

  updateViewport(newControllerState, extraProps = {}, interactionState = {}) {
    const viewState = { ...newControllerState.getViewportProps(),
      ...extraProps
    };
    const changed = this.controllerState !== newControllerState;
    this._state = newControllerState.getState();

    this._setInteractionState(interactionState);

    if (changed) {
      const oldViewState = this.controllerState ? this.controllerState.getViewportProps() : null;

      if (this.onViewStateChange) {
        this.onViewStateChange({
          viewState,
          interactionState: this._interactionState,
          oldViewState
        });
      }
    }
  }

  _onTransition(params) {
    if (this.onViewStateChange) {
      params.interactionState = this._interactionState;
      this.onViewStateChange(params);
    }
  }

  _setInteractionState(newStates) {
    Object.assign(this._interactionState, newStates);

    if (this.onStateChange) {
      this.onStateChange(this._interactionState);
    }
  }

  _onPanStart(event) {
    const pos = this.getCenter(event);

    if (!this.isPointInBounds(pos, event)) {
      return false;
    }

    let alternateMode = this.isFunctionKeyPressed(event) || event.rightButton;

    if (this.invertPan || this.dragMode === 'pan') {
      alternateMode = !alternateMode;
    }

    const newControllerState = this.controllerState[alternateMode ? 'panStart' : 'rotateStart']({
      pos
    });
    this._panMove = alternateMode;
    this.updateViewport(newControllerState, controller_NO_TRANSITION_PROPS, {
      isDragging: true
    });
    return true;
  }

  _onPan(event) {
    if (!this.isDragging()) {
      return false;
    }

    return this._panMove ? this._onPanMove(event) : this._onPanRotate(event);
  }

  _onPanEnd(event) {
    if (!this.isDragging()) {
      return false;
    }

    return this._panMove ? this._onPanMoveEnd(event) : this._onPanRotateEnd(event);
  }

  _onPanMove(event) {
    if (!this.dragPan) {
      return false;
    }

    const pos = this.getCenter(event);
    const newControllerState = this.controllerState.pan({
      pos
    });
    this.updateViewport(newControllerState, controller_NO_TRANSITION_PROPS, {
      isDragging: true,
      isPanning: true
    });
    return true;
  }

  _onPanMoveEnd(event) {
    const {
      inertia
    } = this;

    if (this.dragPan && inertia && event.velocity) {
      const pos = this.getCenter(event);
      const endPos = [pos[0] + event.velocityX * inertia / 2, pos[1] + event.velocityY * inertia / 2];
      const newControllerState = this.controllerState.pan({
        pos: endPos
      }).panEnd();
      this.updateViewport(newControllerState, { ...this._getTransitionProps(),
        transitionDuration: inertia,
        transitionEasing: controller_INERTIA_EASING
      }, {
        isDragging: false,
        isPanning: true
      });
    } else {
      const newControllerState = this.controllerState.panEnd();
      this.updateViewport(newControllerState, null, {
        isDragging: false,
        isPanning: false
      });
    }

    return true;
  }

  _onPanRotate(event) {
    if (!this.dragRotate) {
      return false;
    }

    const pos = this.getCenter(event);
    const newControllerState = this.controllerState.rotate({
      pos
    });
    this.updateViewport(newControllerState, controller_NO_TRANSITION_PROPS, {
      isDragging: true,
      isRotating: true
    });
    return true;
  }

  _onPanRotateEnd(event) {
    const {
      inertia
    } = this;

    if (this.dragRotate && inertia && event.velocity) {
      const pos = this.getCenter(event);
      const endPos = [pos[0] + event.velocityX * inertia / 2, pos[1] + event.velocityY * inertia / 2];
      const newControllerState = this.controllerState.rotate({
        pos: endPos
      }).rotateEnd();
      this.updateViewport(newControllerState, { ...this._getTransitionProps(),
        transitionDuration: inertia,
        transitionEasing: controller_INERTIA_EASING
      }, {
        isDragging: false,
        isRotating: true
      });
    } else {
      const newControllerState = this.controllerState.rotateEnd();
      this.updateViewport(newControllerState, null, {
        isDragging: false,
        isRotating: false
      });
    }

    return true;
  }

  _onWheel(event) {
    if (!this.scrollZoom) {
      return false;
    }

    event.preventDefault();
    const pos = this.getCenter(event);

    if (!this.isPointInBounds(pos, event)) {
      return false;
    }

    const {
      speed = 0.01,
      smooth = false
    } = this.scrollZoom;
    const {
      delta
    } = event;
    let scale = 2 / (1 + Math.exp(-Math.abs(delta * speed)));

    if (delta < 0 && scale !== 0) {
      scale = 1 / scale;
    }

    const newControllerState = this.controllerState.zoom({
      pos,
      scale
    });
    this.updateViewport(newControllerState, { ...this._getTransitionProps({
        around: pos
      }),
      transitionDuration: smooth ? 250 : 1
    }, {
      isZooming: true,
      isPanning: true
    });
    return true;
  }

  _onTriplePanStart(event) {
    const pos = this.getCenter(event);

    if (!this.isPointInBounds(pos, event)) {
      return false;
    }

    const newControllerState = this.controllerState.rotateStart({
      pos
    });
    this.updateViewport(newControllerState, controller_NO_TRANSITION_PROPS, {
      isDragging: true
    });
    return true;
  }

  _onTriplePan(event) {
    if (!this.touchRotate) {
      return false;
    }

    if (!this.isDragging()) {
      return false;
    }

    const pos = this.getCenter(event);
    pos[0] -= event.deltaX;
    const newControllerState = this.controllerState.rotate({
      pos
    });
    this.updateViewport(newControllerState, controller_NO_TRANSITION_PROPS, {
      isDragging: true,
      isRotating: true
    });
    return true;
  }

  _onTriplePanEnd(event) {
    if (!this.isDragging()) {
      return false;
    }

    const {
      inertia
    } = this;

    if (this.touchRotate && inertia && event.velocityY) {
      const pos = this.getCenter(event);
      const endPos = [pos[0], pos[1] += event.velocityY * inertia / 2];
      const newControllerState = this.controllerState.rotate({
        pos: endPos
      });
      this.updateViewport(newControllerState, { ...this._getTransitionProps(),
        transitionDuration: inertia,
        transitionEasing: controller_INERTIA_EASING
      }, {
        isDragging: false,
        isRotating: true
      });
      this.blockEvents(inertia);
    } else {
      const newControllerState = this.controllerState.rotateEnd();
      this.updateViewport(newControllerState, null, {
        isDragging: false,
        isRotating: false
      });
    }

    return true;
  }

  _onPinchStart(event) {
    const pos = this.getCenter(event);

    if (!this.isPointInBounds(pos, event)) {
      return false;
    }

    const newControllerState = this.controllerState.zoomStart({
      pos
    }).rotateStart({
      pos
    });
    this._startPinchRotation = event.rotation;
    this._lastPinchEvent = event;
    this.updateViewport(newControllerState, controller_NO_TRANSITION_PROPS, {
      isDragging: true
    });
    return true;
  }

  _onPinch(event) {
    if (!this.touchZoom && !this.touchRotate) {
      return false;
    }

    if (!this.isDragging()) {
      return false;
    }

    let newControllerState = this.controllerState;

    if (this.touchZoom) {
      const {
        scale
      } = event;
      const pos = this.getCenter(event);
      newControllerState = newControllerState.zoom({
        pos,
        scale
      });
    }

    if (this.touchRotate) {
      const {
        rotation
      } = event;
      newControllerState = newControllerState.rotate({
        deltaAngleX: this._startPinchRotation - rotation
      });
    }

    this.updateViewport(newControllerState, controller_NO_TRANSITION_PROPS, {
      isDragging: true,
      isPanning: this.touchZoom,
      isZooming: this.touchZoom,
      isRotating: this.touchRotate
    });
    this._lastPinchEvent = event;
    return true;
  }

  _onPinchEnd(event) {
    if (!this.isDragging()) {
      return false;
    }

    const {
      inertia,
      _lastPinchEvent
    } = this;

    if (this.touchZoom && inertia && _lastPinchEvent && event.scale !== _lastPinchEvent.scale) {
      const pos = this.getCenter(event);
      let newControllerState = this.controllerState.rotateEnd();
      const z = Math.log2(event.scale);

      const velocityZ = (z - Math.log2(_lastPinchEvent.scale)) / (event.deltaTime - _lastPinchEvent.deltaTime);

      const endScale = Math.pow(2, z + velocityZ * inertia / 2);
      newControllerState = newControllerState.zoom({
        pos,
        scale: endScale
      }).zoomEnd();
      this.updateViewport(newControllerState, { ...this._getTransitionProps({
          around: pos
        }),
        transitionDuration: inertia,
        transitionEasing: controller_INERTIA_EASING
      }, {
        isDragging: false,
        isPanning: this.touchZoom,
        isZooming: this.touchZoom,
        isRotating: false
      });
      this.blockEvents(inertia);
    } else {
      const newControllerState = this.controllerState.zoomEnd().rotateEnd();
      this.updateViewport(newControllerState, null, {
        isDragging: false,
        isPanning: false,
        isZooming: false,
        isRotating: false
      });
    }

    this._startPinchRotation = null;
    this._lastPinchEvent = null;
    return true;
  }

  _onDoubleTap(event) {
    if (!this.doubleClickZoom) {
      return false;
    }

    const pos = this.getCenter(event);

    if (!this.isPointInBounds(pos, event)) {
      return false;
    }

    const isZoomOut = this.isFunctionKeyPressed(event);
    const newControllerState = this.controllerState.zoom({
      pos,
      scale: isZoomOut ? 0.5 : 2
    });
    this.updateViewport(newControllerState, this._getTransitionProps({
      around: pos
    }), {
      isZooming: true,
      isPanning: true
    });
    this.blockEvents(100);
    return true;
  }

  _onKeyDown(event) {
    if (!this.keyboard) {
      return false;
    }

    const funcKey = this.isFunctionKeyPressed(event);
    const {
      zoomSpeed,
      moveSpeed,
      rotateSpeedX,
      rotateSpeedY
    } = this.keyboard;
    const {
      controllerState
    } = this;
    let newControllerState;
    const interactionState = {};

    switch (event.srcEvent.code) {
      case 'Minus':
        newControllerState = funcKey ? controllerState.zoomOut(zoomSpeed).zoomOut(zoomSpeed) : controllerState.zoomOut(zoomSpeed);
        interactionState.isZooming = true;
        break;

      case 'Equal':
        newControllerState = funcKey ? controllerState.zoomIn(zoomSpeed).zoomIn(zoomSpeed) : controllerState.zoomIn(zoomSpeed);
        interactionState.isZooming = true;
        break;

      case 'ArrowLeft':
        if (funcKey) {
          newControllerState = controllerState.rotateLeft(rotateSpeedX);
          interactionState.isRotating = true;
        } else {
          newControllerState = controllerState.moveLeft(moveSpeed);
          interactionState.isPanning = true;
        }

        break;

      case 'ArrowRight':
        if (funcKey) {
          newControllerState = controllerState.rotateRight(rotateSpeedX);
          interactionState.isRotating = true;
        } else {
          newControllerState = controllerState.moveRight(moveSpeed);
          interactionState.isPanning = true;
        }

        break;

      case 'ArrowUp':
        if (funcKey) {
          newControllerState = controllerState.rotateUp(rotateSpeedY);
          interactionState.isRotating = true;
        } else {
          newControllerState = controllerState.moveUp(moveSpeed);
          interactionState.isPanning = true;
        }

        break;

      case 'ArrowDown':
        if (funcKey) {
          newControllerState = controllerState.rotateDown(rotateSpeedY);
          interactionState.isRotating = true;
        } else {
          newControllerState = controllerState.moveDown(moveSpeed);
          interactionState.isPanning = true;
        }

        break;

      default:
        return false;
    }

    this.updateViewport(newControllerState, this._getTransitionProps(), interactionState);
    return true;
  }

  _getTransitionProps(opts) {
    const {
      _transition
    } = this;

    if (!_transition) {
      return controller_NO_TRANSITION_PROPS;
    }

    return opts ? { ..._transition,
      transitionInterpolator: new linear_interpolator_LinearInterpolator({ ...opts,
        transitionProps: this.linearTransitionProps,
        makeViewport: this.controllerState.makeViewport
      })
    } : _transition;
  }

}
//# sourceMappingURL=controller.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/controllers/view-state.js
class ViewState {
  constructor(opts) {
    this._viewportProps = this._applyConstraints(opts);
  }

  getViewportProps() {
    return this._viewportProps;
  }

  getState() {
    return this._state;
  }

  shortestPathFrom(viewState) {
    return this._viewportProps;
  }

  _applyConstraints(props) {
    return props;
  }

}
//# sourceMappingURL=view-state.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/controllers/map-controller.js





const map_controller_PITCH_MOUSE_THRESHOLD = 5;
const map_controller_PITCH_ACCEL = 1.2;
const map_controller_DEFAULT_STATE = {
  pitch: 0,
  bearing: 0,
  altitude: 1.5,
  minZoom: 0,
  maxZoom: 20,
  minPitch: 0,
  maxPitch: 60
};
class map_controller_MapState extends ViewState {
  constructor({
    makeViewport,
    width,
    height,
    latitude,
    longitude,
    zoom,
    bearing = map_controller_DEFAULT_STATE.bearing,
    pitch = map_controller_DEFAULT_STATE.pitch,
    altitude = map_controller_DEFAULT_STATE.altitude,
    maxZoom = map_controller_DEFAULT_STATE.maxZoom,
    minZoom = map_controller_DEFAULT_STATE.minZoom,
    maxPitch = map_controller_DEFAULT_STATE.maxPitch,
    minPitch = map_controller_DEFAULT_STATE.minPitch,
    startPanLngLat,
    startZoomLngLat,
    startRotatePos,
    startBearing,
    startPitch,
    startZoom,
    normalize
  } = {}) {
    (0,utils_assert/* default */.Z)(Number.isFinite(longitude));
    (0,utils_assert/* default */.Z)(Number.isFinite(latitude));
    (0,utils_assert/* default */.Z)(Number.isFinite(zoom));
    super({
      width,
      height,
      latitude,
      longitude,
      zoom,
      bearing,
      pitch,
      altitude,
      maxZoom,
      minZoom,
      maxPitch,
      minPitch,
      normalize
    });
    this._state = {
      startPanLngLat,
      startZoomLngLat,
      startRotatePos,
      startBearing,
      startPitch,
      startZoom
    };
    this.makeViewport = makeViewport;
  }

  panStart({
    pos
  }) {
    return this._getUpdatedState({
      startPanLngLat: this._unproject(pos)
    });
  }

  pan({
    pos,
    startPos
  }) {
    const startPanLngLat = this._state.startPanLngLat || this._unproject(startPos);

    if (!startPanLngLat) {
      return this;
    }

    const viewport = this.makeViewport(this._viewportProps);
    const newProps = viewport.panByPosition(startPanLngLat, pos);
    return this._getUpdatedState(newProps);
  }

  panEnd() {
    return this._getUpdatedState({
      startPanLngLat: null
    });
  }

  rotateStart({
    pos
  }) {
    return this._getUpdatedState({
      startRotatePos: pos,
      startBearing: this._viewportProps.bearing,
      startPitch: this._viewportProps.pitch
    });
  }

  rotate({
    pos,
    deltaAngleX = 0,
    deltaAngleY = 0
  }) {
    const {
      startRotatePos,
      startBearing,
      startPitch
    } = this._state;

    if (!startRotatePos || !Number.isFinite(startBearing) || !Number.isFinite(startPitch)) {
      return this;
    }

    let newRotation;

    if (pos) {
      newRotation = this._calculateNewPitchAndBearing({ ...this._getRotationParams(pos, startRotatePos),
        startBearing,
        startPitch
      });
    } else {
      newRotation = {
        bearing: startBearing + deltaAngleX,
        pitch: startPitch + deltaAngleY
      };
    }

    return this._getUpdatedState(newRotation);
  }

  rotateEnd() {
    return this._getUpdatedState({
      startBearing: null,
      startPitch: null
    });
  }

  zoomStart({
    pos
  }) {
    return this._getUpdatedState({
      startZoomLngLat: this._unproject(pos),
      startZoom: this._viewportProps.zoom
    });
  }

  zoom({
    pos,
    startPos,
    scale
  }) {
    let {
      startZoom,
      startZoomLngLat
    } = this._state;

    if (!Number.isFinite(startZoom)) {
      startZoom = this._viewportProps.zoom;
      startZoomLngLat = this._unproject(startPos) || this._unproject(pos);
    }

    const zoom = this._calculateNewZoom({
      scale,
      startZoom
    });

    const zoomedViewport = this.makeViewport({ ...this._viewportProps,
      zoom
    });
    return this._getUpdatedState({
      zoom,
      ...zoomedViewport.panByPosition(startZoomLngLat, pos)
    });
  }

  zoomEnd() {
    return this._getUpdatedState({
      startZoomLngLat: null,
      startZoom: null
    });
  }

  zoomIn(speed = 2) {
    return this._zoomFromCenter(speed);
  }

  zoomOut(speed = 2) {
    return this._zoomFromCenter(1 / speed);
  }

  moveLeft(speed = 100) {
    return this._panFromCenter([speed, 0]);
  }

  moveRight(speed = 100) {
    return this._panFromCenter([-speed, 0]);
  }

  moveUp(speed = 100) {
    return this._panFromCenter([0, speed]);
  }

  moveDown(speed = 100) {
    return this._panFromCenter([0, -speed]);
  }

  rotateLeft(speed = 15) {
    return this._getUpdatedState({
      bearing: this._viewportProps.bearing - speed
    });
  }

  rotateRight(speed = 15) {
    return this._getUpdatedState({
      bearing: this._viewportProps.bearing + speed
    });
  }

  rotateUp(speed = 10) {
    return this._getUpdatedState({
      pitch: this._viewportProps.pitch + speed
    });
  }

  rotateDown(speed = 10) {
    return this._getUpdatedState({
      pitch: this._viewportProps.pitch - speed
    });
  }

  shortestPathFrom(viewState) {
    const fromProps = viewState.getViewportProps();
    const props = { ...this._viewportProps
    };
    const {
      bearing,
      longitude
    } = props;

    if (Math.abs(bearing - fromProps.bearing) > 180) {
      props.bearing = bearing < 0 ? bearing + 360 : bearing - 360;
    }

    if (Math.abs(longitude - fromProps.longitude) > 180) {
      props.longitude = longitude < 0 ? longitude + 360 : longitude - 360;
    }

    return props;
  }

  _zoomFromCenter(scale) {
    const {
      width,
      height
    } = this._viewportProps;
    return this.zoom({
      pos: [width / 2, height / 2],
      scale
    });
  }

  _panFromCenter(offset) {
    const {
      width,
      height
    } = this._viewportProps;
    return this.pan({
      startPos: [width / 2, height / 2],
      pos: [width / 2 + offset[0], height / 2 + offset[1]]
    });
  }

  _getUpdatedState(newProps) {
    return new this.constructor({
      makeViewport: this.makeViewport,
      ...this._viewportProps,
      ...this._state,
      ...newProps
    });
  }

  _applyConstraints(props) {
    const {
      maxZoom,
      minZoom,
      zoom
    } = props;
    props.zoom = (0,common/* clamp */.uZ)(zoom, minZoom, maxZoom);
    const {
      maxPitch,
      minPitch,
      pitch
    } = props;
    props.pitch = (0,common/* clamp */.uZ)(pitch, minPitch, maxPitch);
    const {
      normalize = true
    } = props;

    if (normalize) {
      Object.assign(props, (0,esm/* normalizeViewportProps */.QA)(props));
    }

    return props;
  }

  _unproject(pos) {
    const viewport = this.makeViewport(this._viewportProps);
    return pos && viewport.unproject(pos);
  }

  _calculateNewZoom({
    scale,
    startZoom
  }) {
    const {
      maxZoom,
      minZoom
    } = this._viewportProps;
    const zoom = startZoom + Math.log2(scale);
    return (0,common/* clamp */.uZ)(zoom, minZoom, maxZoom);
  }

  _calculateNewPitchAndBearing({
    deltaScaleX,
    deltaScaleY,
    startBearing,
    startPitch
  }) {
    deltaScaleY = (0,common/* clamp */.uZ)(deltaScaleY, -1, 1);
    const {
      minPitch,
      maxPitch
    } = this._viewportProps;
    const bearing = startBearing + 180 * deltaScaleX;
    let pitch = startPitch;

    if (deltaScaleY > 0) {
      pitch = startPitch + deltaScaleY * (maxPitch - startPitch);
    } else if (deltaScaleY < 0) {
      pitch = startPitch - deltaScaleY * (minPitch - startPitch);
    }

    return {
      pitch,
      bearing
    };
  }

  _getRotationParams(pos, startPos) {
    const deltaX = pos[0] - startPos[0];
    const deltaY = pos[1] - startPos[1];
    const centerY = pos[1];
    const startY = startPos[1];
    const {
      width,
      height
    } = this._viewportProps;
    const deltaScaleX = deltaX / width;
    let deltaScaleY = 0;

    if (deltaY > 0) {
      if (Math.abs(height - startY) > map_controller_PITCH_MOUSE_THRESHOLD) {
        deltaScaleY = deltaY / (startY - height) * map_controller_PITCH_ACCEL;
      }
    } else if (deltaY < 0) {
      if (startY > map_controller_PITCH_MOUSE_THRESHOLD) {
        deltaScaleY = 1 - centerY / startY;
      }
    }

    deltaScaleY = Math.min(1, Math.max(-1, deltaScaleY));
    return {
      deltaScaleX,
      deltaScaleY
    };
  }

}
class map_controller_MapController extends Controller {
  constructor(props) {
    props.dragMode = props.dragMode || 'pan';
    super(map_controller_MapState, props);
  }

  setProps(props) {
    const oldProps = this.controllerStateProps;
    super.setProps(props);
    const dimensionChanged = !oldProps || oldProps.height !== props.height;

    if (dimensionChanged) {
      this.updateViewport(new this.ControllerState({
        makeViewport: this.makeViewport,
        ...this.controllerStateProps,
        ...this._state
      }));
    }
  }

  get linearTransitionProps() {
    return ['longitude', 'latitude', 'zoom', 'bearing', 'pitch'];
  }

}
//# sourceMappingURL=map-controller.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/views/map-view.js



class MapView extends View {
  constructor(props) {
    super({ ...props,
      type: web_mercator_viewport/* default */.Z
    });
  }

  get controller() {
    return this._getControllerProps({
      type: map_controller_MapController
    });
  }

}
MapView.displayName = 'MapView';
//# sourceMappingURL=map-view.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/texture-2d.js + 1 modules
var texture_2d = __webpack_require__(4912);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/effects/lighting/ambient-light.js
const DEFAULT_LIGHT_COLOR = [255, 255, 255];
const DEFAULT_LIGHT_INTENSITY = 1.0;
let idCount = 0;
class AmbientLight {
  constructor(props = {}) {
    const {
      color = DEFAULT_LIGHT_COLOR
    } = props;
    const {
      intensity = DEFAULT_LIGHT_INTENSITY
    } = props;
    this.id = props.id || "ambient-".concat(idCount++);
    this.color = color;
    this.intensity = intensity;
    this.type = 'ambient';
  }

}
//# sourceMappingURL=ambient-light.js.map
// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/classes/vector3.js + 1 modules
var vector3 = __webpack_require__(51681);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/effects/lighting/directional-light.js

const directional_light_DEFAULT_LIGHT_COLOR = [255, 255, 255];
const directional_light_DEFAULT_LIGHT_INTENSITY = 1.0;
const DEFAULT_LIGHT_DIRECTION = [0.0, 0.0, -1.0];
let directional_light_idCount = 0;
class DirectionalLight {
  constructor(props = {}) {
    const {
      color = directional_light_DEFAULT_LIGHT_COLOR
    } = props;
    const {
      intensity = directional_light_DEFAULT_LIGHT_INTENSITY
    } = props;
    const {
      direction = DEFAULT_LIGHT_DIRECTION
    } = props;
    const {
      _shadow = false
    } = props;
    this.id = props.id || "directional-".concat(directional_light_idCount++);
    this.color = color;
    this.intensity = intensity;
    this.type = 'directional';
    this.direction = new vector3/* default */.Z(direction).normalize().toArray();
    this.shadow = _shadow;
  }

  getProjectedLight() {
    return this;
  }

}
//# sourceMappingURL=directional-light.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/effect.js
class Effect {
  constructor(props = {}) {
    const {
      id = 'effect'
    } = props;
    this.id = id;
    this.props = { ...props
    };
  }

  preRender() {}

  getModuleParameters() {}

  cleanup() {}

}
//# sourceMappingURL=effect.js.map
// EXTERNAL MODULE: ./node_modules/@math.gl/core/dist/esm/classes/matrix4.js + 1 modules
var matrix4 = __webpack_require__(37293);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/passes/pass.js
class Pass {
  constructor(gl, props = {}) {
    const {
      id = 'pass'
    } = props;
    this.id = id;
    this.gl = gl;
    this.props = { ...props
    };
  }

  setProps(props) {
    Object.assign(this.props, props);
  }

  render() {}

  cleanup() {}

}
//# sourceMappingURL=pass.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/gltools/dist/esm/index.js + 13 modules
var gltools_dist_esm = __webpack_require__(39450);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/clear.js
var clear = __webpack_require__(26047);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/passes/layers-pass.js


class LayersPass extends Pass {
  render(props) {
    const gl = this.gl;
    (0,gltools_dist_esm/* setParameters */.dR)(gl, {
      framebuffer: props.target
    });
    return this._drawLayers(props);
  }

  _drawLayers(props) {
    const {
      viewports,
      views,
      onViewportActive,
      clearCanvas = true
    } = props;
    props.pass = props.pass || 'unknown';
    const gl = this.gl;

    if (clearCanvas) {
      clearGLCanvas(gl);
    }

    const renderStats = [];

    for (const viewportOrDescriptor of viewports) {
      const viewport = viewportOrDescriptor.viewport || viewportOrDescriptor;
      const view = views && views[viewport.id];
      onViewportActive(viewport);

      const drawLayerParams = this._getDrawLayerParams(viewport, props);

      props.view = view;
      const subViewports = viewport.subViewports || [viewport];

      for (const subViewport of subViewports) {
        props.viewport = subViewport;

        const stats = this._drawLayersInViewport(gl, props, drawLayerParams);

        renderStats.push(stats);
      }
    }

    return renderStats;
  }

  _getDrawLayerParams(viewport, {
    layers,
    pass,
    layerFilter,
    effects,
    moduleParameters
  }) {
    const drawLayerParams = [];
    const indexResolver = layerIndexResolver();
    const drawContext = {
      viewport,
      isPicking: pass.startsWith('picking'),
      renderPass: pass
    };

    for (let layerIndex = 0; layerIndex < layers.length; layerIndex++) {
      const layer = layers[layerIndex];

      const shouldDrawLayer = this._shouldDrawLayer(layer, drawContext, layerFilter);

      const layerRenderIndex = indexResolver(layer, shouldDrawLayer);
      const layerParam = {
        shouldDrawLayer,
        layerRenderIndex
      };

      if (shouldDrawLayer) {
        layerParam.moduleParameters = this._getModuleParameters(layer, effects, pass, moduleParameters);
        layerParam.layerParameters = this.getLayerParameters(layer, layerIndex);
      }

      drawLayerParams[layerIndex] = layerParam;
    }

    return drawLayerParams;
  }

  _drawLayersInViewport(gl, {
    layers,
    pass,
    viewport,
    view
  }, drawLayerParams) {
    const glViewport = getGLViewport(gl, {
      viewport
    });

    if (view && view.props.clear) {
      const clearOpts = view.props.clear === true ? {
        color: true,
        depth: true
      } : view.props.clear;
      (0,gltools_dist_esm/* withParameters */.s8)(gl, {
        scissorTest: true,
        scissor: glViewport
      }, () => (0,clear/* clear */.Z)(gl, clearOpts));
    }

    const renderStatus = {
      totalCount: layers.length,
      visibleCount: 0,
      compositeCount: 0,
      pickableCount: 0
    };
    (0,gltools_dist_esm/* setParameters */.dR)(gl, {
      viewport: glViewport
    });

    for (let layerIndex = 0; layerIndex < layers.length; layerIndex++) {
      const layer = layers[layerIndex];
      const {
        shouldDrawLayer,
        layerRenderIndex,
        moduleParameters,
        layerParameters
      } = drawLayerParams[layerIndex];

      if (shouldDrawLayer && layer.props.pickable) {
        renderStatus.pickableCount++;
      }

      if (layer.isComposite) {
        renderStatus.compositeCount++;
      } else if (shouldDrawLayer) {
        renderStatus.visibleCount++;
        moduleParameters.viewport = viewport;

        try {
          layer.drawLayer({
            moduleParameters,
            uniforms: {
              layerIndex: layerRenderIndex
            },
            parameters: layerParameters
          });
        } catch (err) {
          layer.raiseError(err, "drawing ".concat(layer, " to ").concat(pass));
        }
      }
    }

    return renderStatus;
  }

  shouldDrawLayer(layer) {
    return true;
  }

  getModuleParameters(layer, effects) {
    return null;
  }

  getLayerParameters(layer, layerIndex) {
    return layer.props.parameters;
  }

  _shouldDrawLayer(layer, drawContext, layerFilter) {
    const shouldDrawLayer = this.shouldDrawLayer(layer) && layer.props.visible;

    if (!shouldDrawLayer) {
      return false;
    }

    drawContext.layer = layer;

    if (layerFilter && !layerFilter(drawContext)) {
      return false;
    }

    let parent = layer.parent;

    while (parent) {
      if (!parent.filterSubLayer(drawContext)) {
        return false;
      }

      drawContext.layer = parent;
      parent = parent.parent;
    }

    layer.activateViewport(drawContext.viewport);
    return true;
  }

  _getModuleParameters(layer, effects, pass, overrides) {
    const moduleParameters = Object.assign(Object.create(layer.props), {
      autoWrapLongitude: layer.wrapLongitude,
      viewport: layer.context.viewport,
      mousePosition: layer.context.mousePosition,
      pickingActive: 0,
      devicePixelRatio: (0,gltools_dist_esm/* cssToDeviceRatio */.w)(this.gl)
    });

    if (effects) {
      for (const effect of effects) {
        Object.assign(moduleParameters, effect.getModuleParameters(layer));
      }
    }

    return Object.assign(moduleParameters, this.getModuleParameters(layer, effects), overrides);
  }

}
function layerIndexResolver(startIndex = 0, layerIndices = {}) {
  const resolvers = {};

  const resolveLayerIndex = (layer, isDrawn) => {
    const indexOverride = layer.props._offset;
    const layerId = layer.id;
    const parentId = layer.parent && layer.parent.id;
    let index;

    if (parentId && !(parentId in layerIndices)) {
      resolveLayerIndex(layer.parent, false);
    }

    if (parentId in resolvers) {
      const resolver = resolvers[parentId] = resolvers[parentId] || layerIndexResolver(layerIndices[parentId], layerIndices);
      index = resolver(layer, isDrawn);
      resolvers[layerId] = resolver;
    } else if (Number.isFinite(indexOverride)) {
      index = indexOverride + (layerIndices[parentId] || 0);
      resolvers[layerId] = null;
    } else {
      index = startIndex;
    }

    if (isDrawn && index >= startIndex) {
      startIndex = index + 1;
    }

    layerIndices[layerId] = index;
    return index;
  };

  return resolveLayerIndex;
}

function getGLViewport(gl, {
  viewport
}) {
  const height = gl.canvas ? gl.canvas.clientHeight || gl.canvas.height : 100;
  const dimensions = viewport;
  const pixelRatio = (0,gltools_dist_esm/* cssToDeviceRatio */.w)(gl);
  return [dimensions.x * pixelRatio, (height - dimensions.y - dimensions.height) * pixelRatio, dimensions.width * pixelRatio, dimensions.height * pixelRatio];
}

function clearGLCanvas(gl) {
  const width = gl.drawingBufferWidth;
  const height = gl.drawingBufferHeight;
  (0,gltools_dist_esm/* setParameters */.dR)(gl, {
    viewport: [0, 0, width, height]
  });
  gl.clear(16384 | 256);
}
//# sourceMappingURL=layers-pass.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/renderbuffer.js + 1 modules
var renderbuffer = __webpack_require__(49830);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/framebuffer.js
var framebuffer = __webpack_require__(53849);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/passes/shadow-pass.js


class ShadowPass extends LayersPass {
  constructor(gl, props) {
    super(gl, props);
    this.shadowMap = new texture_2d/* default */.Z(gl, {
      width: 1,
      height: 1,
      parameters: {
        [10241]: 9729,
        [10240]: 9729,
        [10242]: 33071,
        [10243]: 33071
      }
    });
    this.depthBuffer = new renderbuffer/* default */.Z(gl, {
      format: 33189,
      width: 1,
      height: 1
    });
    this.fbo = new framebuffer/* default */.Z(gl, {
      id: 'shadowmap',
      width: 1,
      height: 1,
      attachments: {
        [36064]: this.shadowMap,
        [36096]: this.depthBuffer
      }
    });
  }

  render(params) {
    const target = this.fbo;
    (0,gltools_dist_esm/* withParameters */.s8)(this.gl, {
      depthRange: [0, 1],
      depthTest: true,
      blend: false,
      clearColor: [1, 1, 1, 1]
    }, () => {
      const viewport = params.viewports[0];
      const pixelRatio = (0,gltools_dist_esm/* cssToDeviceRatio */.w)(this.gl);
      const width = viewport.width * pixelRatio;
      const height = viewport.height * pixelRatio;

      if (width !== target.width || height !== target.height) {
        target.resize({
          width,
          height
        });
      }

      super.render({ ...params,
        target,
        pass: 'shadow'
      });
    });
  }

  shouldDrawLayer(layer) {
    return layer.props.shadowEnabled !== false;
  }

  getModuleParameters() {
    return {
      drawToShadowMap: true
    };
  }

  delete() {
    if (this.fbo) {
      this.fbo.delete();
      this.fbo = null;
    }

    if (this.shadowMap) {
      this.shadowMap.delete();
      this.shadowMap = null;
    }

    if (this.depthBuffer) {
      this.depthBuffer.delete();
      this.depthBuffer = null;
    }
  }

}
//# sourceMappingURL=shadow-pass.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/constants.js
var lib_constants = __webpack_require__(24088);
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/memoize.js
var memoize = __webpack_require__(88177);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/shaderlib/shadow/shadow.js





const shadow_vs = "\nconst int max_lights = 2;\nuniform mat4 shadow_uViewProjectionMatrices[max_lights];\nuniform vec4 shadow_uProjectCenters[max_lights];\nuniform bool shadow_uDrawShadowMap;\nuniform bool shadow_uUseShadowMap;\nuniform int shadow_uLightId;\nuniform float shadow_uLightCount;\n\nvarying vec3 shadow_vPosition[max_lights];\n\nvec4 shadow_setVertexPosition(vec4 position_commonspace) {\n  if (shadow_uDrawShadowMap) {\n    return project_common_position_to_clipspace(position_commonspace, shadow_uViewProjectionMatrices[shadow_uLightId], shadow_uProjectCenters[shadow_uLightId]);\n  }\n  if (shadow_uUseShadowMap) {\n    for (int i = 0; i < max_lights; i++) {\n      if(i < int(shadow_uLightCount)) {\n        vec4 shadowMap_position = project_common_position_to_clipspace(position_commonspace, shadow_uViewProjectionMatrices[i], shadow_uProjectCenters[i]);\n        shadow_vPosition[i] = (shadowMap_position.xyz / shadowMap_position.w + 1.0) / 2.0;\n      }\n    }\n  }\n  return gl_Position;\n}\n";
const shadow_fs = "\nconst int max_lights = 2;\nuniform bool shadow_uDrawShadowMap;\nuniform bool shadow_uUseShadowMap;\nuniform sampler2D shadow_uShadowMap0;\nuniform sampler2D shadow_uShadowMap1;\nuniform vec4 shadow_uColor;\nuniform float shadow_uLightCount;\n\nvarying vec3 shadow_vPosition[max_lights];\n\nconst vec4 bitPackShift = vec4(1.0, 255.0, 65025.0, 16581375.0);\nconst vec4 bitUnpackShift = 1.0 / bitPackShift;\nconst vec4 bitMask = vec4(1.0 / 255.0, 1.0 / 255.0, 1.0 / 255.0,  0.0);\n\nfloat shadow_getShadowWeight(vec3 position, sampler2D shadowMap) {\n  vec4 rgbaDepth = texture2D(shadowMap, position.xy);\n\n  float z = dot(rgbaDepth, bitUnpackShift);\n  return smoothstep(0.001, 0.01, position.z - z);\n}\n\nvec4 shadow_filterShadowColor(vec4 color) {\n  if (shadow_uDrawShadowMap) {\n    vec4 rgbaDepth = fract(gl_FragCoord.z * bitPackShift);\n    rgbaDepth -= rgbaDepth.gbaa * bitMask;\n    return rgbaDepth;\n  }\n  if (shadow_uUseShadowMap) {\n    float shadowAlpha = 0.0;\n    shadowAlpha += shadow_getShadowWeight(shadow_vPosition[0], shadow_uShadowMap0);\n    if(shadow_uLightCount > 1.0) {\n      shadowAlpha += shadow_getShadowWeight(shadow_vPosition[1], shadow_uShadowMap1);\n    }\n    shadowAlpha *= shadow_uColor.a / shadow_uLightCount;\n    float blendedAlpha = shadowAlpha + color.a * (1.0 - shadowAlpha);\n\n    return vec4(\n      mix(color.rgb, shadow_uColor.rgb, shadowAlpha / blendedAlpha),\n      blendedAlpha\n    );\n  }\n  return color;\n}\n";
const getMemoizedViewportCenterPosition = (0,memoize/* default */.Z)(getViewportCenterPosition);
const getMemoizedViewProjectionMatrices = (0,memoize/* default */.Z)(getViewProjectionMatrices);
const DEFAULT_SHADOW_COLOR = [0, 0, 0, 1.0];
const VECTOR_TO_POINT_MATRIX = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0];

function screenToCommonSpace(xyz, pixelUnprojectionMatrix) {
  const [x, y, z] = xyz;
  const coord = (0,esm/* pixelsToWorld */.CT)([x, y, z], pixelUnprojectionMatrix);

  if (Number.isFinite(z)) {
    return coord;
  }

  return [coord[0], coord[1], 0];
}

function getViewportCenterPosition({
  viewport,
  center
}) {
  return new matrix4/* default */.Z(viewport.viewProjectionMatrix).invert().transform(center);
}

function getViewProjectionMatrices({
  viewport,
  shadowMatrices
}) {
  const projectionMatrices = [];
  const pixelUnprojectionMatrix = viewport.pixelUnprojectionMatrix;
  const farZ = viewport.isGeospatial ? undefined : 1;
  const corners = [[0, 0, farZ], [viewport.width, 0, farZ], [0, viewport.height, farZ], [viewport.width, viewport.height, farZ], [0, 0, -1], [viewport.width, 0, -1], [0, viewport.height, -1], [viewport.width, viewport.height, -1]].map(pixel => screenToCommonSpace(pixel, pixelUnprojectionMatrix));

  for (const shadowMatrix of shadowMatrices) {
    const viewMatrix = shadowMatrix.clone().translate(new vector3/* default */.Z(viewport.center).negate());
    const positions = corners.map(corner => viewMatrix.transform(corner));
    const projectionMatrix = new matrix4/* default */.Z().ortho({
      left: Math.min(...positions.map(position => position[0])),
      right: Math.max(...positions.map(position => position[0])),
      bottom: Math.min(...positions.map(position => position[1])),
      top: Math.max(...positions.map(position => position[1])),
      near: Math.min(...positions.map(position => -position[2])),
      far: Math.max(...positions.map(position => -position[2]))
    });
    projectionMatrices.push(projectionMatrix.multiplyRight(shadowMatrix));
  }

  return projectionMatrices;
}

function createShadowUniforms(opts = {}, context = {}) {
  const uniforms = {
    shadow_uDrawShadowMap: Boolean(opts.drawToShadowMap),
    shadow_uUseShadowMap: opts.shadowMaps ? opts.shadowMaps.length > 0 : false,
    shadow_uColor: opts.shadowColor || DEFAULT_SHADOW_COLOR,
    shadow_uLightId: opts.shadowLightId || 0,
    shadow_uLightCount: opts.shadowMatrices.length
  };
  const center = getMemoizedViewportCenterPosition({
    viewport: opts.viewport,
    center: context.project_uCenter
  });
  const projectCenters = [];
  const viewProjectionMatrices = getMemoizedViewProjectionMatrices({
    shadowMatrices: opts.shadowMatrices,
    viewport: opts.viewport
  }).slice();

  for (let i = 0; i < opts.shadowMatrices.length; i++) {
    const viewProjectionMatrix = viewProjectionMatrices[i];
    const viewProjectionMatrixCentered = viewProjectionMatrix.clone().translate(new vector3/* default */.Z(opts.viewport.center).negate());

    if (context.project_uCoordinateSystem === lib_constants/* COORDINATE_SYSTEM.LNGLAT */.Df.LNGLAT && context.project_uProjectionMode === lib_constants/* PROJECTION_MODE.WEB_MERCATOR */.zG.WEB_MERCATOR) {
      viewProjectionMatrices[i] = viewProjectionMatrixCentered;
      projectCenters[i] = center;
    } else {
      viewProjectionMatrices[i] = viewProjectionMatrix.clone().multiplyRight(VECTOR_TO_POINT_MATRIX);
      projectCenters[i] = viewProjectionMatrixCentered.transform(center);
    }
  }

  for (let i = 0; i < viewProjectionMatrices.length; i++) {
    uniforms["shadow_uViewProjectionMatrices[".concat(i, "]")] = viewProjectionMatrices[i];
    uniforms["shadow_uProjectCenters[".concat(i, "]")] = projectCenters[i];

    if (opts.shadowMaps && opts.shadowMaps.length > 0) {
      uniforms["shadow_uShadowMap".concat(i)] = opts.shadowMaps[i];
    } else {
      uniforms["shadow_uShadowMap".concat(i)] = opts.dummyShadowMap;
    }
  }

  return uniforms;
}

/* harmony default export */ const shadow = ({
  name: 'shadow',
  dependencies: [project/* default */.Z],
  vs: shadow_vs,
  fs: shadow_fs,
  inject: {
    'vs:DECKGL_FILTER_GL_POSITION': "\n    position = shadow_setVertexPosition(geometry.position);\n    ",
    'fs:DECKGL_FILTER_COLOR': "\n    color = shadow_filterShadowColor(color);\n    "
  },
  getUniforms: (opts = {}, context = {}) => {
    if (opts.drawToShadowMap || opts.shadowMaps && opts.shadowMaps.length > 0) {
      const {
        shadowEnabled = true
      } = opts;
      return shadowEnabled && opts.shadowMatrices && opts.shadowMatrices.length > 0 ? createShadowUniforms(opts, context) : {
        shadow_uDrawShadowMap: false,
        shadow_uUseShadowMap: false
      };
    }

    return {};
  }
});
//# sourceMappingURL=shadow.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/effects/lighting/lighting-effect.js







const DEFAULT_AMBIENT_LIGHT_PROPS = {
  color: [255, 255, 255],
  intensity: 1.0
};
const DEFAULT_DIRECTIONAL_LIGHT_PROPS = [{
  color: [255, 255, 255],
  intensity: 1.0,
  direction: [-1, 3, -1]
}, {
  color: [255, 255, 255],
  intensity: 0.9,
  direction: [1, -8, -2.5]
}];
const lighting_effect_DEFAULT_SHADOW_COLOR = [0, 0, 0, 200 / 255];
class LightingEffect extends Effect {
  constructor(props) {
    super(props);
    this.ambientLight = null;
    this.directionalLights = [];
    this.pointLights = [];
    this.shadowColor = lighting_effect_DEFAULT_SHADOW_COLOR;
    this.shadowPasses = [];
    this.shadowMaps = [];
    this.dummyShadowMap = null;
    this.shadow = false;
    this.programManager = null;

    for (const key in props) {
      const lightSource = props[key];

      switch (lightSource.type) {
        case 'ambient':
          this.ambientLight = lightSource;
          break;

        case 'directional':
          this.directionalLights.push(lightSource);
          break;

        case 'point':
          this.pointLights.push(lightSource);
          break;

        default:
      }
    }

    this._applyDefaultLights();

    this.shadow = this.directionalLights.some(light => light.shadow);
  }

  preRender(gl, {
    layers,
    layerFilter,
    viewports,
    onViewportActive,
    views
  }) {
    if (!this.shadow) return;
    this.shadowMatrices = this._createLightMatrix();

    if (this.shadowPasses.length === 0) {
      this._createShadowPasses(gl);
    }

    if (!this.programManager) {
      this.programManager = program_manager/* default.getDefaultProgramManager */.Z.getDefaultProgramManager(gl);

      if (shadow) {
        this.programManager.addDefaultModule(shadow);
      }
    }

    if (!this.dummyShadowMap) {
      this.dummyShadowMap = new texture_2d/* default */.Z(gl, {
        width: 1,
        height: 1
      });
    }

    for (let i = 0; i < this.shadowPasses.length; i++) {
      const shadowPass = this.shadowPasses[i];
      shadowPass.render({
        layers,
        layerFilter,
        viewports,
        onViewportActive,
        views,
        moduleParameters: {
          shadowLightId: i,
          dummyShadowMap: this.dummyShadowMap,
          shadowMatrices: this.shadowMatrices
        }
      });
    }
  }

  getModuleParameters(layer) {
    const parameters = this.shadow ? {
      shadowMaps: this.shadowMaps,
      dummyShadowMap: this.dummyShadowMap,
      shadowColor: this.shadowColor,
      shadowMatrices: this.shadowMatrices
    } : {};
    parameters.lightSources = {
      ambientLight: this.ambientLight,
      directionalLights: this.directionalLights.map(directionalLight => directionalLight.getProjectedLight({
        layer
      })),
      pointLights: this.pointLights.map(pointLight => pointLight.getProjectedLight({
        layer
      }))
    };
    return parameters;
  }

  cleanup() {
    for (const shadowPass of this.shadowPasses) {
      shadowPass.delete();
    }

    this.shadowPasses.length = 0;
    this.shadowMaps.length = 0;

    if (this.dummyShadowMap) {
      this.dummyShadowMap.delete();
      this.dummyShadowMap = null;
    }

    if (this.shadow && this.programManager) {
      this.programManager.removeDefaultModule(shadow);
      this.programManager = null;
    }
  }

  _createLightMatrix() {
    const lightMatrices = [];

    for (const light of this.directionalLights) {
      const viewMatrix = new matrix4/* default */.Z().lookAt({
        eye: new vector3/* default */.Z(light.direction).negate()
      });
      lightMatrices.push(viewMatrix);
    }

    return lightMatrices;
  }

  _createShadowPasses(gl) {
    for (let i = 0; i < this.directionalLights.length; i++) {
      const shadowPass = new ShadowPass(gl);
      this.shadowPasses[i] = shadowPass;
      this.shadowMaps[i] = shadowPass.shadowMap;
    }
  }

  _applyDefaultLights() {
    const {
      ambientLight,
      pointLights,
      directionalLights
    } = this;

    if (!ambientLight && pointLights.length === 0 && directionalLights.length === 0) {
      this.ambientLight = new AmbientLight(DEFAULT_AMBIENT_LIGHT_PROPS);
      this.directionalLights.push(new DirectionalLight(DEFAULT_DIRECTIONAL_LIGHT_PROPS[0]), new DirectionalLight(DEFAULT_DIRECTIONAL_LIGHT_PROPS[1]));
    }
  }

}
//# sourceMappingURL=lighting-effect.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/effect-manager.js


const DEFAULT_LIGHTING_EFFECT = new LightingEffect();
class EffectManager {
  constructor() {
    this.effects = [];
    this._internalEffects = [];
    this._needsRedraw = 'Initial render';
    this.setEffects();
  }

  setProps(props) {
    if ('effects' in props) {
      if (props.effects.length !== this.effects.length || !deep_equal_deepEqual(props.effects, this.effects)) {
        this.setEffects(props.effects);
        this._needsRedraw = 'effects changed';
      }
    }
  }

  needsRedraw(opts = {
    clearRedrawFlags: false
  }) {
    const redraw = this._needsRedraw;

    if (opts.clearRedrawFlags) {
      this._needsRedraw = false;
    }

    return redraw;
  }

  getEffects() {
    return this._internalEffects;
  }

  finalize() {
    this.cleanup();
  }

  setEffects(effects = []) {
    this.cleanup();
    this.effects = effects;

    this._createInternalEffects();
  }

  cleanup() {
    for (const effect of this.effects) {
      effect.cleanup();
    }

    for (const effect of this._internalEffects) {
      effect.cleanup();
    }

    this.effects.length = 0;
    this._internalEffects.length = 0;
  }

  _createInternalEffects() {
    this._internalEffects = this.effects.slice();

    if (!this.effects.some(effect => effect instanceof LightingEffect)) {
      this._internalEffects.push(DEFAULT_LIGHTING_EFFECT);
    }
  }

}
//# sourceMappingURL=effect-manager.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/passes/draw-layers-pass.js

class DrawLayersPass extends LayersPass {}
//# sourceMappingURL=draw-layers-pass.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/passes/pick-layers-pass.js


const PICKING_PARAMETERS = {
  blendFunc: [1, 0, 32771, 0],
  blendEquation: 32774
};
class PickLayersPass extends LayersPass {
  render(props) {
    if (props.pickingFBO) {
      this.useAlpha = true;

      this._drawPickingBuffer(props);
    } else {
      this.useAlpha = false;
      super.render(props);
    }
  }

  _drawPickingBuffer({
    layers,
    layerFilter,
    views,
    viewports,
    onViewportActive,
    pickingFBO,
    deviceRect: {
      x,
      y,
      width,
      height
    },
    pass = 'picking',
    redrawReason,
    pickZ
  }) {
    const gl = this.gl;
    this.pickZ = pickZ;
    return (0,gltools_dist_esm/* withParameters */.s8)(gl, {
      scissorTest: true,
      scissor: [x, y, width, height],
      clearColor: [0, 0, 0, 0],
      depthMask: true,
      depthTest: true,
      depthRange: [0, 1],
      colorMask: [true, true, true, true],
      ...PICKING_PARAMETERS,
      blend: !pickZ
    }, () => {
      super.render({
        target: pickingFBO,
        layers,
        layerFilter,
        views,
        viewports,
        onViewportActive,
        pass,
        redrawReason
      });
    });
  }

  shouldDrawLayer(layer) {
    return layer.props.pickable;
  }

  getModuleParameters() {
    return {
      pickingActive: 1,
      pickingAttribute: this.pickZ,
      lightSources: {}
    };
  }

  getLayerParameters(layer, layerIndex) {
    const pickParameters = this.pickZ ? {
      blend: false
    } : { ...PICKING_PARAMETERS,
      blend: true,
      blendColor: [0, 0, 0, this.useAlpha ? (layerIndex + 1) / 255 : 1]
    };
    return { ...layer.props.parameters,
      ...pickParameters
    };
  }

}
//# sourceMappingURL=pick-layers-pass.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/deck-renderer.js




const TRACE_RENDER_LAYERS = 'deckRenderer.renderLayers';
class DeckRenderer {
  constructor(gl) {
    this.gl = gl;
    this.layerFilter = null;
    this.drawPickingColors = false;
    this.drawLayersPass = new DrawLayersPass(gl);
    this.pickLayersPass = new PickLayersPass(gl);
    this.renderCount = 0;
    this._needsRedraw = 'Initial render';
    this.renderBuffers = [];
    this.lastPostProcessEffect = null;
  }

  setProps(props) {
    if ('layerFilter' in props && this.layerFilter !== props.layerFilter) {
      this.layerFilter = props.layerFilter;
      this._needsRedraw = 'layerFilter changed';
    }

    if ('drawPickingColors' in props && this.drawPickingColors !== props.drawPickingColors) {
      this.drawPickingColors = props.drawPickingColors;
      this._needsRedraw = 'drawPickingColors changed';
    }
  }

  renderLayers(opts) {
    const layerPass = this.drawPickingColors ? this.pickLayersPass : this.drawLayersPass;
    opts.layerFilter = this.layerFilter;
    opts.effects = opts.effects || [];
    opts.target = opts.target || framebuffer/* default.getDefaultFramebuffer */.Z.getDefaultFramebuffer(this.gl);

    this._preRender(opts.effects, opts);

    const outputBuffer = this.lastPostProcessEffect ? this.renderBuffers[0] : opts.target;
    const renderStats = layerPass.render({ ...opts,
      target: outputBuffer
    });

    this._postRender(opts.effects, opts);

    this.renderCount++;
    (0,debug/* default */.Z)(TRACE_RENDER_LAYERS, this, renderStats, opts);
  }

  needsRedraw(opts = {
    clearRedrawFlags: false
  }) {
    const redraw = this._needsRedraw;

    if (opts.clearRedrawFlags) {
      this._needsRedraw = false;
    }

    return redraw;
  }

  finalize() {
    const {
      renderBuffers
    } = this;

    for (const buffer of renderBuffers) {
      buffer.delete();
    }

    renderBuffers.length = 0;
  }

  _preRender(effects, opts) {
    let lastPostProcessEffect = null;

    for (const effect of effects) {
      effect.preRender(this.gl, opts);

      if (effect.postRender) {
        lastPostProcessEffect = effect;
      }
    }

    if (lastPostProcessEffect) {
      this._resizeRenderBuffers();
    }

    this.lastPostProcessEffect = lastPostProcessEffect;
  }

  _resizeRenderBuffers() {
    const {
      renderBuffers
    } = this;

    if (renderBuffers.length === 0) {
      renderBuffers.push(new framebuffer/* default */.Z(this.gl), new framebuffer/* default */.Z(this.gl));
    }

    for (const buffer of renderBuffers) {
      buffer.resize();
    }
  }

  _postRender(effects, opts) {
    const {
      renderBuffers
    } = this;
    const params = {
      inputBuffer: renderBuffers[0],
      swapBuffer: renderBuffers[1],
      target: null
    };

    for (const effect of effects) {
      if (effect.postRender) {
        if (effect === this.lastPostProcessEffect) {
          params.target = opts.target;
          effect.postRender(this.gl, params);
          break;
        }

        const buffer = effect.postRender(this.gl, params);
        params.inputBuffer = buffer;
        params.swapBuffer = buffer === renderBuffers[0] ? renderBuffers[1] : renderBuffers[0];
      }
    }
  }

}
//# sourceMappingURL=deck-renderer.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/copy-and-blit.js + 1 modules
var copy_and_blit = __webpack_require__(1953);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/picking/query-object.js

const NO_PICKED_OBJECT = {
  pickedColor: null,
  pickedLayer: null,
  pickedObjectIndex: -1
};
function getClosestObject({
  pickedColors,
  layers,
  deviceX,
  deviceY,
  deviceRadius,
  deviceRect
}) {
  if (pickedColors) {
    const {
      x,
      y,
      width,
      height
    } = deviceRect;
    let minSquareDistanceToCenter = deviceRadius * deviceRadius;
    let closestPixelIndex = -1;
    let i = 0;

    for (let row = 0; row < height; row++) {
      const dy = row + y - deviceY;
      const dy2 = dy * dy;

      if (dy2 > minSquareDistanceToCenter) {
        i += 4 * width;
      } else {
        for (let col = 0; col < width; col++) {
          const pickedLayerIndex = pickedColors[i + 3] - 1;

          if (pickedLayerIndex >= 0) {
            const dx = col + x - deviceX;
            const d2 = dx * dx + dy2;

            if (d2 <= minSquareDistanceToCenter) {
              minSquareDistanceToCenter = d2;
              closestPixelIndex = i;
            }
          }

          i += 4;
        }
      }
    }

    if (closestPixelIndex >= 0) {
      const pickedLayerIndex = pickedColors[closestPixelIndex + 3] - 1;
      const pickedColor = pickedColors.slice(closestPixelIndex, closestPixelIndex + 4);
      const pickedLayer = layers[pickedLayerIndex];

      if (pickedLayer) {
        const pickedObjectIndex = pickedLayer.decodePickingColor(pickedColor);
        const dy = Math.floor(closestPixelIndex / 4 / width);
        const dx = closestPixelIndex / 4 - dy * width;
        return {
          pickedColor,
          pickedLayer,
          pickedObjectIndex,
          pickedX: x + dx,
          pickedY: y + dy
        };
      }

      log/* default.error */.Z.error('Picked non-existent layer. Is picking buffer corrupt?')();
    }
  }

  return NO_PICKED_OBJECT;
}
function getUniqueObjects({
  pickedColors,
  layers
}) {
  const uniqueColors = new Map();

  if (pickedColors) {
    for (let i = 0; i < pickedColors.length; i += 4) {
      const pickedLayerIndex = pickedColors[i + 3] - 1;

      if (pickedLayerIndex >= 0) {
        const pickedColor = pickedColors.slice(i, i + 4);
        const colorKey = pickedColor.join(',');

        if (!uniqueColors.has(colorKey)) {
          const pickedLayer = layers[pickedLayerIndex];

          if (pickedLayer) {
            uniqueColors.set(colorKey, {
              pickedColor,
              pickedLayer,
              pickedObjectIndex: pickedLayer.decodePickingColor(pickedColor)
            });
          } else {
            log/* default.error */.Z.error('Picked non-existent layer. Is picking buffer corrupt?')();
          }
        }
      }
    }
  }

  return Array.from(uniqueColors.values());
}
//# sourceMappingURL=query-object.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/picking/pick-info.js
function getEmptyPickingInfo({
  pickInfo,
  mode,
  viewports,
  layerFilter,
  pixelRatio,
  x,
  y,
  z
}) {
  const layer = pickInfo && pickInfo.pickedLayer;

  const viewportFilter = layerFilter && layer && (v => layerFilter({
    layer,
    viewport: v,
    isPicking: true,
    renderPass: "picking:".concat(mode)
  }));

  const viewport = getViewportFromCoordinates(viewports, {
    x,
    y
  }, viewportFilter);
  const coordinate = viewport && viewport.unproject([x - viewport.x, y - viewport.y], {
    targetZ: z
  });
  return {
    color: null,
    layer: null,
    viewport,
    index: -1,
    picked: false,
    x,
    y,
    pixel: [x, y],
    coordinate,
    devicePixel: pickInfo && [pickInfo.pickedX, pickInfo.pickedY],
    pixelRatio
  };
}
function processPickInfo(opts) {
  const {
    pickInfo,
    lastPickedInfo,
    mode,
    layers
  } = opts;
  const {
    pickedColor,
    pickedLayer,
    pickedObjectIndex
  } = pickInfo;
  const affectedLayers = pickedLayer ? [pickedLayer] : [];

  if (mode === 'hover') {
    const lastPickedObjectIndex = lastPickedInfo.index;
    const lastPickedLayerId = lastPickedInfo.layerId;
    const pickedLayerId = pickedLayer && pickedLayer.props.id;

    if (pickedLayerId !== lastPickedLayerId || pickedObjectIndex !== lastPickedObjectIndex) {
      if (pickedLayerId !== lastPickedLayerId) {
        const lastPickedLayer = layers.find(layer => layer.props.id === lastPickedLayerId);

        if (lastPickedLayer) {
          affectedLayers.unshift(lastPickedLayer);
        }
      }

      lastPickedInfo.layerId = pickedLayerId;
      lastPickedInfo.index = pickedObjectIndex;
      lastPickedInfo.info = null;
    }
  }

  const baseInfo = getEmptyPickingInfo(opts);
  const infos = new Map();
  infos.set(null, baseInfo);
  affectedLayers.forEach(layer => {
    let info = { ...baseInfo
    };

    if (layer === pickedLayer) {
      info.color = pickedColor;
      info.index = pickedObjectIndex;
      info.picked = true;
    }

    info = getLayerPickingInfo({
      layer,
      info,
      mode
    });

    if (layer === pickedLayer && mode === 'hover') {
      lastPickedInfo.info = info;
    }

    infos.set(info.layer.id, info);

    if (mode === 'hover') {
      info.layer.updateAutoHighlight(info);
    }
  });
  return infos;
}
function getLayerPickingInfo({
  layer,
  info,
  mode
}) {
  while (layer && info) {
    const sourceLayer = info.layer || null;
    info.sourceLayer = sourceLayer;
    info.layer = layer;
    info = layer.getPickingInfo({
      info,
      mode,
      sourceLayer
    });
    layer = layer.parent;
  }

  return info;
}

function getViewportFromCoordinates(viewports, pixel, filter) {
  for (let i = viewports.length - 1; i >= 0; i--) {
    const viewport = viewports[i];

    if (viewport.containsPixel(pixel) && (!filter || filter(viewport))) {
      return viewport;
    }
  }

  return viewports[0];
}
//# sourceMappingURL=pick-info.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/deck-picker.js





class DeckPicker {
  constructor(gl) {
    this.gl = gl;
    this.pickingFBO = null;
    this.pickLayersPass = new PickLayersPass(gl);
    this.layerFilter = null;
    this.lastPickedInfo = {
      index: -1,
      layerId: null,
      info: null
    };
  }

  setProps(props) {
    if ('layerFilter' in props) {
      this.layerFilter = props.layerFilter;
    }

    if ('_pickable' in props) {
      this._pickable = props._pickable;
    }
  }

  finalize() {
    if (this.pickingFBO) {
      this.pickingFBO.delete();
    }

    if (this.depthFBO) {
      this.depthFBO.color.delete();
      this.depthFBO.delete();
    }
  }

  pickObject(opts) {
    return this._pickClosestObject(opts);
  }

  pickObjects(opts) {
    return this._pickVisibleObjects(opts);
  }

  getLastPickedObject({
    x,
    y,
    layers,
    viewports
  }, lastPickedInfo = this.lastPickedInfo.info) {
    const lastPickedLayerId = lastPickedInfo && lastPickedInfo.layer && lastPickedInfo.layer.id;
    const lastPickedViewportId = lastPickedInfo && lastPickedInfo.viewport && lastPickedInfo.viewport.id;
    const layer = lastPickedLayerId ? layers.find(l => l.id === lastPickedLayerId) : null;
    const viewport = lastPickedViewportId && viewports.find(v => v.id === lastPickedViewportId) || viewports[0];
    const coordinate = viewport && viewport.unproject([x - viewport.x, y - viewport.y]);
    const info = {
      x,
      y,
      viewport,
      coordinate,
      layer
    };

    if (layer) {
      return { ...lastPickedInfo,
        ...info
      };
    }

    return Object.assign(info, {
      color: null,
      object: null,
      index: -1
    });
  }

  _resizeBuffer() {
    const {
      gl
    } = this;

    if (!this.pickingFBO) {
      this.pickingFBO = new framebuffer/* default */.Z(gl);

      if (framebuffer/* default.isSupported */.Z.isSupported(gl, {
        colorBufferFloat: true
      })) {
        this.depthFBO = new framebuffer/* default */.Z(gl);
        this.depthFBO.attach({
          [36064]: new texture_2d/* default */.Z(gl, {
            format: (0,gltools_dist_esm/* isWebGL2 */.D0)(gl) ? 34836 : 6408,
            type: 5126
          })
        });
      }
    }

    this.pickingFBO.resize({
      width: gl.canvas.width,
      height: gl.canvas.height
    });

    if (this.depthFBO) {
      this.depthFBO.resize({
        width: gl.canvas.width,
        height: gl.canvas.height
      });
    }

    return this.pickingFBO;
  }

  _getPickable(layers) {
    if (this._pickable === false) {
      return null;
    }

    const pickableLayers = layers.filter(layer => layer.isPickable() && !layer.isComposite);

    if (pickableLayers.length > 255) {
      log/* default.warn */.Z.warn('Too many pickable layers, only picking the first 255')();
      return pickableLayers.slice(0, 255);
    }

    return pickableLayers.length ? pickableLayers : null;
  }

  _pickClosestObject({
    layers,
    views,
    viewports,
    x,
    y,
    radius = 0,
    depth = 1,
    mode = 'query',
    unproject3D,
    onViewportActive
  }) {
    layers = this._getPickable(layers);

    if (!layers) {
      return {
        result: [],
        emptyInfo: getEmptyPickingInfo({
          viewports,
          x,
          y
        })
      };
    }

    this._resizeBuffer();

    const pixelRatio = (0,gltools_dist_esm/* cssToDeviceRatio */.w)(this.gl);
    const devicePixelRange = (0,gltools_dist_esm/* cssToDevicePixels */.JY)(this.gl, [x, y], true);
    const devicePixel = [devicePixelRange.x + Math.floor(devicePixelRange.width / 2), devicePixelRange.y + Math.floor(devicePixelRange.height / 2)];
    const deviceRadius = Math.round(radius * pixelRatio);
    const {
      width,
      height
    } = this.pickingFBO;

    const deviceRect = this._getPickingRect({
      deviceX: devicePixel[0],
      deviceY: devicePixel[1],
      deviceRadius,
      deviceWidth: width,
      deviceHeight: height
    });

    let infos;
    const result = [];
    const affectedLayers = {};

    for (let i = 0; i < depth; i++) {
      const pickedColors = deviceRect && this._drawAndSample({
        layers,
        views,
        viewports,
        onViewportActive,
        deviceRect,
        pass: "picking:".concat(mode),
        redrawReason: mode
      });

      const pickInfo = getClosestObject({
        pickedColors,
        layers,
        deviceX: devicePixel[0],
        deviceY: devicePixel[1],
        deviceRadius,
        deviceRect
      });
      let z;

      if (pickInfo.pickedLayer && unproject3D && this.depthFBO) {
        const zValues = this._drawAndSample({
          layers: [pickInfo.pickedLayer],
          views,
          viewports,
          onViewportActive,
          deviceRect: {
            x: pickInfo.pickedX,
            y: pickInfo.pickedY,
            width: 1,
            height: 1
          },
          pass: "picking:".concat(mode),
          redrawReason: 'pick-z',
          pickZ: true
        });

        z = zValues[0] * viewports[0].distanceScales.metersPerUnit[2] + viewports[0].position[2];
      }

      if (pickInfo.pickedColor && i + 1 < depth) {
        const layerId = pickInfo.pickedColor[3] - 1;
        affectedLayers[layerId] = true;
        layers[layerId].disablePickingIndex(pickInfo.pickedObjectIndex);
      }

      infos = processPickInfo({
        pickInfo,
        lastPickedInfo: this.lastPickedInfo,
        mode,
        layers,
        layerFilter: this.layerFilter,
        viewports,
        x,
        y,
        z,
        pixelRatio
      });

      for (const info of infos.values()) {
        if (info.layer) {
          result.push(info);
        }
      }

      if (!pickInfo.pickedColor) {
        break;
      }
    }

    for (const layerId in affectedLayers) {
      layers[layerId].restorePickingColors();
    }

    return {
      result,
      emptyInfo: infos && infos.get(null)
    };
  }

  _pickVisibleObjects({
    layers,
    views,
    viewports,
    x,
    y,
    width = 1,
    height = 1,
    mode = 'query',
    maxObjects = null,
    onViewportActive
  }) {
    layers = this._getPickable(layers);

    if (!layers) {
      return [];
    }

    this._resizeBuffer();

    const pixelRatio = (0,gltools_dist_esm/* cssToDeviceRatio */.w)(this.gl);
    const leftTop = (0,gltools_dist_esm/* cssToDevicePixels */.JY)(this.gl, [x, y], true);
    const deviceLeft = leftTop.x;
    const deviceTop = leftTop.y + leftTop.height;
    const rightBottom = (0,gltools_dist_esm/* cssToDevicePixels */.JY)(this.gl, [x + width, y + height], true);
    const deviceRight = rightBottom.x + rightBottom.width;
    const deviceBottom = rightBottom.y;
    const deviceRect = {
      x: deviceLeft,
      y: deviceBottom,
      width: deviceRight - deviceLeft,
      height: deviceTop - deviceBottom
    };

    const pickedColors = this._drawAndSample({
      layers,
      views,
      viewports,
      onViewportActive,
      deviceRect,
      pass: "picking:".concat(mode),
      redrawReason: mode
    });

    const pickInfos = getUniqueObjects({
      pickedColors,
      layers
    });
    const uniqueInfos = new Map();
    const isMaxObjects = Number.isFinite(maxObjects);

    for (let i = 0; i < pickInfos.length; i++) {
      if (isMaxObjects && uniqueInfos.size >= maxObjects) {
        break;
      }

      const pickInfo = pickInfos[i];
      let info = {
        color: pickInfo.pickedColor,
        layer: null,
        index: pickInfo.pickedObjectIndex,
        picked: true,
        x,
        y,
        width,
        height,
        pixelRatio
      };
      info = getLayerPickingInfo({
        layer: pickInfo.pickedLayer,
        info,
        mode
      });

      if (!uniqueInfos.has(info.object)) {
        uniqueInfos.set(info.object, info);
      }
    }

    return Array.from(uniqueInfos.values());
  }

  _drawAndSample({
    layers,
    views,
    viewports,
    onViewportActive,
    deviceRect,
    pass,
    redrawReason,
    pickZ
  }) {
    if (layers.length < 1) {
      return null;
    }

    const pickingFBO = pickZ ? this.depthFBO : this.pickingFBO;
    this.pickLayersPass.render({
      layers,
      layerFilter: this.layerFilter,
      views,
      viewports,
      onViewportActive,
      pickingFBO,
      deviceRect,
      pass,
      redrawReason,
      pickZ
    });
    const {
      x,
      y,
      width,
      height
    } = deviceRect;
    const pickedColors = new (pickZ ? Float32Array : Uint8Array)(width * height * 4);
    (0,copy_and_blit/* readPixelsToArray */.z6)(pickingFBO, {
      sourceX: x,
      sourceY: y,
      sourceWidth: width,
      sourceHeight: height,
      target: pickedColors
    });
    return pickedColors;
  }

  _getPickingRect({
    deviceX,
    deviceY,
    deviceRadius,
    deviceWidth,
    deviceHeight
  }) {
    const x = Math.max(0, deviceX - deviceRadius);
    const y = Math.max(0, deviceY - deviceRadius);
    const width = Math.min(deviceWidth, deviceX + deviceRadius + 1) - x;
    const height = Math.min(deviceHeight, deviceY + deviceRadius + 1) - y;

    if (width <= 0 || height <= 0) {
      return null;
    }

    return {
      x,
      y,
      width,
      height
    };
  }

}
//# sourceMappingURL=deck-picker.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/tooltip.js
const defaultStyle = {
  zIndex: 1,
  position: 'absolute',
  pointerEvents: 'none',
  color: '#a0a7b4',
  backgroundColor: '#29323c',
  padding: '10px',
  top: 0,
  left: 0,
  display: 'none'
};
class Tooltip {
  constructor(canvas) {
    const canvasParent = canvas.parentElement;

    if (canvasParent) {
      this.el = document.createElement('div');
      this.el.className = 'deck-tooltip';
      Object.assign(this.el.style, defaultStyle);
      canvasParent.appendChild(this.el);
    }

    this.isVisible = false;
  }

  setTooltip(displayInfo, x, y) {
    const el = this.el;

    if (typeof displayInfo === 'string') {
      el.innerText = displayInfo;
    } else if (!displayInfo) {
      this.isVisible = false;
      el.style.display = 'none';
      return;
    } else {
      if ('text' in displayInfo) {
        el.innerText = displayInfo.text;
      }

      if ('html' in displayInfo) {
        el.innerHTML = displayInfo.html;
      }

      if ('className' in displayInfo) {
        el.className = displayInfo.className;
      }

      Object.assign(el.style, displayInfo.style);
    }

    this.isVisible = true;
    el.style.display = 'block';
    el.style.transform = "translate(".concat(x, "px, ").concat(y, "px)");
  }

  remove() {
    if (this.el) {
      this.el.remove();
    }
  }

}
//# sourceMappingURL=tooltip.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/typed-array-manager.js
var typed_array_manager = __webpack_require__(36610);
// EXTERNAL MODULE: ./node_modules/@loaders.gl/core/dist/esm/lib/api/register-loaders.js
var register_loaders = __webpack_require__(6228);
// EXTERNAL MODULE: ./node_modules/@loaders.gl/images/dist/esm/image-loader.js + 11 modules
var image_loader = __webpack_require__(98949);
// EXTERNAL MODULE: ./node_modules/probe.gl/dist/es5/env/index.js
var env = __webpack_require__(89718);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/utils/json-loader.js
function isJSON(text) {
  const firstChar = text[0];
  const lastChar = text[text.length - 1];
  return firstChar === '{' && lastChar === '}' || firstChar === '[' && lastChar === ']';
}

/* harmony default export */ const json_loader = ({
  name: 'JSON',
  extensions: ['json', 'geojson'],
  mimeTypes: ['application/json', 'application/geo+json'],
  testText: isJSON,
  parseTextSync: JSON.parse
});
//# sourceMappingURL=json-loader.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/init.js






const version =  true ? "8.5.2" : 0;
const existingVersion = env/* global.deck */.CO.deck && env/* global.deck.VERSION */.CO.deck.VERSION;

if (existingVersion && existingVersion !== version) {
  throw new Error("deck.gl - multiple versions detected: ".concat(existingVersion, " vs ").concat(version));
}

if (!existingVersion) {
  log/* default.log */.Z.log(1, "deck.gl ".concat(version))();
  env/* global.deck */.CO.deck = Object.assign(env/* global.deck */.CO.deck || {}, {
    VERSION: version,
    version,
    log: log/* default */.Z,
    _registerLoggers: debug/* register */.z
  });
  (0,register_loaders/* registerLoaders */.fh)([json_loader, [image_loader/* ImageLoader */.S, {
    imagebitmap: {
      premultiplyAlpha: 'none'
    }
  }]]);
}

/* harmony default export */ const init = (env/* global.deck */.CO.deck);
//# sourceMappingURL=init.js.map
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/init.js
var esm_init = __webpack_require__(49835);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/utils/assert.js
var esm_utils_assert = __webpack_require__(22525);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/resource.js
var resource = __webpack_require__(87577);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/features/features.js
var features = __webpack_require__(44211);
// EXTERNAL MODULE: ./node_modules/@luma.gl/webgl/dist/esm/features/webgl-features-table.js
var webgl_features_table = __webpack_require__(6948);
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/classes/query.js




const GL_QUERY_RESULT = 0x8866;
const GL_QUERY_RESULT_AVAILABLE = 0x8867;
const GL_TIME_ELAPSED_EXT = 0x88bf;
const GL_GPU_DISJOINT_EXT = 0x8fbb;
const GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 0x8c88;
const GL_ANY_SAMPLES_PASSED = 0x8c2f;
const GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 0x8d6a;
class Query extends resource/* default */.Z {
  static isSupported(gl, opts = []) {
    const webgl2 = (0,gltools_dist_esm/* isWebGL2 */.D0)(gl);
    const hasTimerQuery = (0,features/* hasFeatures */.ag)(gl, webgl_features_table/* FEATURES.TIMER_QUERY */.h.TIMER_QUERY);
    let supported = webgl2 || hasTimerQuery;

    for (const key of opts) {
      switch (key) {
        case 'queries':
          supported = supported && webgl2;
          break;

        case 'timers':
          supported = supported && hasTimerQuery;
          break;

        default:
          (0,esm_utils_assert/* default */.Z)(false);
      }
    }

    return supported;
  }

  constructor(gl, opts = {}) {
    super(gl, opts);
    this.target = null;
    this._queryPending = false;
    this._pollingPromise = null;
    Object.seal(this);
  }

  beginTimeElapsedQuery() {
    return this.begin(GL_TIME_ELAPSED_EXT);
  }

  beginOcclusionQuery({
    conservative = false
  } = {}) {
    return this.begin(conservative ? GL_ANY_SAMPLES_PASSED_CONSERVATIVE : GL_ANY_SAMPLES_PASSED);
  }

  beginTransformFeedbackQuery() {
    return this.begin(GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN);
  }

  begin(target) {
    if (this._queryPending) {
      return this;
    }

    this.target = target;
    this.gl2.beginQuery(this.target, this.handle);
    return this;
  }

  end() {
    if (this._queryPending) {
      return this;
    }

    if (this.target) {
      this.gl2.endQuery(this.target);
      this.target = null;
      this._queryPending = true;
    }

    return this;
  }

  isResultAvailable() {
    if (!this._queryPending) {
      return false;
    }

    const resultAvailable = this.gl2.getQueryParameter(this.handle, GL_QUERY_RESULT_AVAILABLE);

    if (resultAvailable) {
      this._queryPending = false;
    }

    return resultAvailable;
  }

  isTimerDisjoint() {
    return this.gl2.getParameter(GL_GPU_DISJOINT_EXT);
  }

  getResult() {
    return this.gl2.getQueryParameter(this.handle, GL_QUERY_RESULT);
  }

  getTimerMilliseconds() {
    return this.getResult() / 1e6;
  }

  createPoll(limit = Number.POSITIVE_INFINITY) {
    if (this._pollingPromise) {
      return this._pollingPromise;
    }

    let counter = 0;
    this._pollingPromise = new Promise((resolve, reject) => {
      const poll = () => {
        if (this.isResultAvailable()) {
          resolve(this.getResult());
          this._pollingPromise = null;
        } else if (counter++ > limit) {
          reject('Timed out');
          this._pollingPromise = null;
        } else {
          requestAnimationFrame(poll);
        }
      };

      requestAnimationFrame(poll);
    });
    return this._pollingPromise;
  }

  _createHandle() {
    return Query.isSupported(this.gl) ? this.gl2.createQuery() : null;
  }

  _deleteHandle() {
    this.gl2.deleteQuery(this.handle);
  }

}
//# sourceMappingURL=query.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/webgl/dist/esm/webgl-utils/request-animation-frame.js
function request_animation_frame_requestAnimationFrame(callback) {
  return typeof window !== 'undefined' && window.requestAnimationFrame ? window.requestAnimationFrame(callback) : setTimeout(callback, 1000 / 60);
}
function request_animation_frame_cancelAnimationFrame(timerId) {
  return typeof window !== 'undefined' && window.cancelAnimationFrame ? window.cancelAnimationFrame(timerId) : clearTimeout(timerId);
}
//# sourceMappingURL=request-animation-frame.js.map
;// CONCATENATED MODULE: ./node_modules/@luma.gl/engine/dist/esm/lib/animation-loop.js



const isPage = (0,env/* isBrowser */.jU)() && typeof document !== 'undefined';
let statIdCounter = 0;
class AnimationLoop {
  constructor(props = {}) {
    const {
      onCreateContext = opts => (0,gltools_dist_esm/* createGLContext */.s9)(opts),
      onAddHTML = null,
      onInitialize = () => {},
      onRender = () => {},
      onFinalize = () => {},
      onError,
      gl = null,
      glOptions = {},
      debug = false,
      createFramebuffer = false,
      autoResizeViewport = true,
      autoResizeDrawingBuffer = true,
      stats = esm_init/* lumaStats.get */.l.get("animation-loop-".concat(statIdCounter++))
    } = props;
    let {
      useDevicePixels = true
    } = props;

    if ('useDevicePixelRatio' in props) {
      gltools_dist_esm/* log.deprecated */.cM.deprecated('useDevicePixelRatio', 'useDevicePixels')();
      useDevicePixels = props.useDevicePixelRatio;
    }

    this.props = {
      onCreateContext,
      onAddHTML,
      onInitialize,
      onRender,
      onFinalize,
      onError,
      gl,
      glOptions,
      debug,
      createFramebuffer
    };
    this.gl = gl;
    this.needsRedraw = null;
    this.timeline = null;
    this.stats = stats;
    this.cpuTime = this.stats.get('CPU Time');
    this.gpuTime = this.stats.get('GPU Time');
    this.frameRate = this.stats.get('Frame Rate');
    this._initialized = false;
    this._running = false;
    this._animationFrameId = null;
    this._nextFramePromise = null;
    this._resolveNextFrame = null;
    this._cpuStartTime = 0;
    this.setProps({
      autoResizeViewport,
      autoResizeDrawingBuffer,
      useDevicePixels
    });
    this.start = this.start.bind(this);
    this.stop = this.stop.bind(this);
    this._pageLoadPromise = null;
    this._onMousemove = this._onMousemove.bind(this);
    this._onMouseleave = this._onMouseleave.bind(this);
  }

  delete() {
    this.stop();

    this._setDisplay(null);
  }

  setNeedsRedraw(reason) {
    (0,esm_utils_assert/* default */.Z)(typeof reason === 'string');
    this.needsRedraw = this.needsRedraw || reason;
    return this;
  }

  setProps(props) {
    if ('autoResizeViewport' in props) {
      this.autoResizeViewport = props.autoResizeViewport;
    }

    if ('autoResizeDrawingBuffer' in props) {
      this.autoResizeDrawingBuffer = props.autoResizeDrawingBuffer;
    }

    if ('useDevicePixels' in props) {
      this.useDevicePixels = props.useDevicePixels;
    }

    return this;
  }

  start(opts = {}) {
    if (this._running) {
      return this;
    }

    this._running = true;

    const startPromise = this._getPageLoadPromise().then(() => {
      if (!this._running || this._initialized) {
        return null;
      }

      this._createWebGLContext(opts);

      this._createFramebuffer();

      this._startEventHandling();

      this._initializeCallbackData();

      this._updateCallbackData();

      this._resizeCanvasDrawingBuffer();

      this._resizeViewport();

      this._gpuTimeQuery = Query.isSupported(this.gl, ['timers']) ? new Query(this.gl) : null;
      this._initialized = true;
      return this.onInitialize(this.animationProps);
    }).then(appContext => {
      if (this._running) {
        this._addCallbackData(appContext || {});

        if (appContext !== false) {
          this._startLoop();
        }
      }
    });

    if (this.props.onError) {
      startPromise.catch(this.props.onError);
    }

    return this;
  }

  redraw() {
    if (this.isContextLost()) {
      return this;
    }

    this._beginTimers();

    this._setupFrame();

    this._updateCallbackData();

    this._renderFrame(this.animationProps);

    this._clearNeedsRedraw();

    if (this.offScreen && this.gl.commit) {
      this.gl.commit();
    }

    if (this._resolveNextFrame) {
      this._resolveNextFrame(this);

      this._nextFramePromise = null;
      this._resolveNextFrame = null;
    }

    this._endTimers();

    return this;
  }

  stop() {
    if (this._running) {
      this._finalizeCallbackData();

      request_animation_frame_cancelAnimationFrame(this._animationFrameId);
      this._nextFramePromise = null;
      this._resolveNextFrame = null;
      this._animationFrameId = null;
      this._running = false;
    }

    return this;
  }

  attachTimeline(timeline) {
    this.timeline = timeline;
    return this.timeline;
  }

  detachTimeline() {
    this.timeline = null;
  }

  waitForRender() {
    this.setNeedsRedraw('waitForRender');

    if (!this._nextFramePromise) {
      this._nextFramePromise = new Promise(resolve => {
        this._resolveNextFrame = resolve;
      });
    }

    return this._nextFramePromise;
  }

  async toDataURL() {
    this.setNeedsRedraw('toDataURL');
    await this.waitForRender();
    return this.gl.canvas.toDataURL();
  }

  isContextLost() {
    return this.gl.isContextLost();
  }

  onCreateContext(...args) {
    return this.props.onCreateContext(...args);
  }

  onInitialize(...args) {
    return this.props.onInitialize(...args);
  }

  onRender(...args) {
    return this.props.onRender(...args);
  }

  onFinalize(...args) {
    return this.props.onFinalize(...args);
  }

  getHTMLControlValue(id, defaultValue = 1) {
    const element = document.getElementById(id);
    return element ? Number(element.value) : defaultValue;
  }

  setViewParameters() {
    gltools_dist_esm/* log.removed */.cM.removed('AnimationLoop.setViewParameters', 'AnimationLoop.setProps')();
    return this;
  }

  _startLoop() {
    const renderFrame = () => {
      if (!this._running) {
        return;
      }

      this.redraw();
      this._animationFrameId = this._requestAnimationFrame(renderFrame);
    };

    request_animation_frame_cancelAnimationFrame(this._animationFrameId);
    this._animationFrameId = this._requestAnimationFrame(renderFrame);
  }

  _getPageLoadPromise() {
    if (!this._pageLoadPromise) {
      this._pageLoadPromise = isPage ? new Promise((resolve, reject) => {
        if (isPage && document.readyState === 'complete') {
          resolve(document);
          return;
        }

        window.addEventListener('load', () => {
          resolve(document);
        });
      }) : Promise.resolve({});
    }

    return this._pageLoadPromise;
  }

  _setDisplay(display) {
    if (this.display) {
      this.display.delete();
      this.display.animationLoop = null;
    }

    if (display) {
      display.animationLoop = this;
    }

    this.display = display;
  }

  _requestAnimationFrame(renderFrameCallback) {
    if (this.display && this.display.requestAnimationFrame(renderFrameCallback)) {
      return;
    }

    request_animation_frame_requestAnimationFrame(renderFrameCallback);
  }

  _renderFrame(...args) {
    if (this.display) {
      this.display._renderFrame(...args);

      return;
    }

    this.onRender(...args);
  }

  _clearNeedsRedraw() {
    this.needsRedraw = null;
  }

  _setupFrame() {
    this._resizeCanvasDrawingBuffer();

    this._resizeViewport();

    this._resizeFramebuffer();
  }

  _initializeCallbackData() {
    this.animationProps = {
      gl: this.gl,
      stop: this.stop,
      canvas: this.gl.canvas,
      framebuffer: this.framebuffer,
      useDevicePixels: this.useDevicePixels,
      needsRedraw: null,
      startTime: Date.now(),
      engineTime: 0,
      tick: 0,
      tock: 0,
      time: 0,
      _timeline: this.timeline,
      _loop: this,
      _animationLoop: this,
      _mousePosition: null
    };
  }

  _updateCallbackData() {
    const {
      width,
      height,
      aspect
    } = this._getSizeAndAspect();

    if (width !== this.animationProps.width || height !== this.animationProps.height) {
      this.setNeedsRedraw('drawing buffer resized');
    }

    if (aspect !== this.animationProps.aspect) {
      this.setNeedsRedraw('drawing buffer aspect changed');
    }

    this.animationProps.width = width;
    this.animationProps.height = height;
    this.animationProps.aspect = aspect;
    this.animationProps.needsRedraw = this.needsRedraw;
    this.animationProps.engineTime = Date.now() - this.animationProps.startTime;

    if (this.timeline) {
      this.timeline.update(this.animationProps.engineTime);
    }

    this.animationProps.tick = Math.floor(this.animationProps.time / 1000 * 60);
    this.animationProps.tock++;
    this.animationProps.time = this.timeline ? this.timeline.getTime() : this.animationProps.engineTime;
    this.animationProps._offScreen = this.offScreen;
  }

  _finalizeCallbackData() {
    this.onFinalize(this.animationProps);
  }

  _addCallbackData(appContext) {
    if (typeof appContext === 'object' && appContext !== null) {
      this.animationProps = Object.assign({}, this.animationProps, appContext);
    }
  }

  _createWebGLContext(opts) {
    this.offScreen = opts.canvas && typeof OffscreenCanvas !== 'undefined' && opts.canvas instanceof OffscreenCanvas;
    opts = Object.assign({}, opts, this.props.glOptions);
    this.gl = this.props.gl ? (0,gltools_dist_esm/* instrumentGLContext */.yW)(this.props.gl, opts) : this.onCreateContext(opts);

    if (!(0,gltools_dist_esm/* isWebGL */.UF)(this.gl)) {
      throw new Error('AnimationLoop.onCreateContext - illegal context returned');
    }

    (0,gltools_dist_esm/* resetParameters */.kL)(this.gl);

    this._createInfoDiv();
  }

  _createInfoDiv() {
    if (this.gl.canvas && this.props.onAddHTML) {
      const wrapperDiv = document.createElement('div');
      document.body.appendChild(wrapperDiv);
      wrapperDiv.style.position = 'relative';
      const div = document.createElement('div');
      div.style.position = 'absolute';
      div.style.left = '10px';
      div.style.bottom = '10px';
      div.style.width = '300px';
      div.style.background = 'white';
      wrapperDiv.appendChild(this.gl.canvas);
      wrapperDiv.appendChild(div);
      const html = this.props.onAddHTML(div);

      if (html) {
        div.innerHTML = html;
      }
    }
  }

  _getSizeAndAspect() {
    const width = this.gl.drawingBufferWidth;
    const height = this.gl.drawingBufferHeight;
    let aspect = 1;
    const {
      canvas
    } = this.gl;

    if (canvas && canvas.clientHeight) {
      aspect = canvas.clientWidth / canvas.clientHeight;
    } else if (width > 0 && height > 0) {
      aspect = width / height;
    }

    return {
      width,
      height,
      aspect
    };
  }

  _resizeViewport() {
    if (this.autoResizeViewport) {
      this.gl.viewport(0, 0, this.gl.drawingBufferWidth, this.gl.drawingBufferHeight);
    }
  }

  _resizeCanvasDrawingBuffer() {
    if (this.autoResizeDrawingBuffer) {
      (0,gltools_dist_esm/* resizeGLContext */.aQ)(this.gl, {
        useDevicePixels: this.useDevicePixels
      });
    }
  }

  _createFramebuffer() {
    if (this.props.createFramebuffer) {
      this.framebuffer = new framebuffer/* default */.Z(this.gl);
    }
  }

  _resizeFramebuffer() {
    if (this.framebuffer) {
      this.framebuffer.resize({
        width: this.gl.drawingBufferWidth,
        height: this.gl.drawingBufferHeight
      });
    }
  }

  _beginTimers() {
    this.frameRate.timeEnd();
    this.frameRate.timeStart();

    if (this._gpuTimeQuery && this._gpuTimeQuery.isResultAvailable() && !this._gpuTimeQuery.isTimerDisjoint()) {
      this.stats.get('GPU Time').addTime(this._gpuTimeQuery.getTimerMilliseconds());
    }

    if (this._gpuTimeQuery) {
      this._gpuTimeQuery.beginTimeElapsedQuery();
    }

    this.cpuTime.timeStart();
  }

  _endTimers() {
    this.cpuTime.timeEnd();

    if (this._gpuTimeQuery) {
      this._gpuTimeQuery.end();
    }
  }

  _startEventHandling() {
    const {
      canvas
    } = this.gl;

    if (canvas) {
      canvas.addEventListener('mousemove', this._onMousemove);
      canvas.addEventListener('mouseleave', this._onMouseleave);
    }
  }

  _onMousemove(e) {
    this.animationProps._mousePosition = [e.offsetX, e.offsetY];
  }

  _onMouseleave(e) {
    this.animationProps._mousePosition = null;
  }

}
//# sourceMappingURL=animation-loop.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/deck.js



















function deck_noop() {}

const getCursor = ({
  isDragging
}) => isDragging ? 'grabbing' : 'grab';

function getPropTypes(PropTypes) {
  return {
    id: PropTypes.string,
    width: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    height: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    layers: PropTypes.oneOfType([PropTypes.object, PropTypes.array]),
    layerFilter: PropTypes.func,
    views: PropTypes.oneOfType([PropTypes.object, PropTypes.array]),
    viewState: PropTypes.object,
    effects: PropTypes.arrayOf(PropTypes.instanceOf(Effect)),
    controller: PropTypes.oneOfType([PropTypes.func, PropTypes.bool, PropTypes.object]),
    gl: PropTypes.object,
    glOptions: PropTypes.object,
    parameters: PropTypes.object,
    pickingRadius: PropTypes.number,
    useDevicePixels: PropTypes.oneOfType([PropTypes.bool, PropTypes.number]),
    touchAction: PropTypes.string,
    eventRecognizerOptions: PropTypes.object,
    onWebGLInitialized: PropTypes.func,
    onResize: PropTypes.func,
    onViewStateChange: PropTypes.func,
    onInteractionStateChange: PropTypes.func,
    onBeforeRender: PropTypes.func,
    onAfterRender: PropTypes.func,
    onLoad: PropTypes.func,
    onError: PropTypes.func,
    debug: PropTypes.bool,
    drawPickingColors: PropTypes.bool,
    _framebuffer: PropTypes.object,
    _animate: PropTypes.bool,
    _pickable: PropTypes.bool,
    _typedArrayManagerProps: PropTypes.object
  };
}

const deck_defaultProps = {
  id: '',
  width: '100%',
  height: '100%',
  pickingRadius: 0,
  layerFilter: null,
  glOptions: {},
  gl: null,
  layers: [],
  effects: [],
  views: null,
  controller: null,
  useDevicePixels: true,
  touchAction: 'none',
  eventRecognizerOptions: {},
  _framebuffer: null,
  _animate: false,
  _pickable: true,
  _typedArrayManagerProps: {},
  onWebGLInitialized: deck_noop,
  onResize: deck_noop,
  onViewStateChange: deck_noop,
  onInteractionStateChange: deck_noop,
  onBeforeRender: deck_noop,
  onAfterRender: deck_noop,
  onLoad: deck_noop,
  onError: (error, layer) => log/* default.error */.Z.error(error)(),
  _onMetrics: null,
  getCursor,
  debug: false,
  drawPickingColors: false
};
class Deck {
  constructor(props) {
    props = { ...deck_defaultProps,
      ...props
    };
    this.props = {};
    this.width = 0;
    this.height = 0;
    this.viewManager = null;
    this.layerManager = null;
    this.effectManager = null;
    this.deckRenderer = null;
    this.deckPicker = null;
    this._needsRedraw = true;
    this._pickRequest = {};
    this._lastPointerDownInfo = null;
    this.viewState = null;
    this.interactiveState = {
      isHovering: false,
      isDragging: false
    };
    this._onEvent = this._onEvent.bind(this);
    this._onPointerDown = this._onPointerDown.bind(this);
    this._onPointerMove = this._onPointerMove.bind(this);

    if (props.viewState && props.initialViewState) {
      log/* default.warn */.Z.warn('View state tracking is disabled. Use either `initialViewState` for auto update or `viewState` for manual update.')();
    }

    if ((0,env/* getBrowser */.qs)() === 'IE') {
      log/* default.warn */.Z.warn('IE 11 support will be deprecated in v8.0')();
    }

    if (!props.gl) {
      if (typeof document !== 'undefined') {
        this.canvas = this._createCanvas(props);
      }
    }

    this.animationLoop = this._createAnimationLoop(props);
    this.stats = new stats_dist_esm/* Stats */.jk({
      id: 'deck.gl'
    });
    this.metrics = {
      fps: 0,
      setPropsTime: 0,
      updateAttributesTime: 0,
      framesRedrawn: 0,
      pickTime: 0,
      pickCount: 0,
      gpuTime: 0,
      gpuTimePerFrame: 0,
      cpuTime: 0,
      cpuTimePerFrame: 0,
      bufferMemory: 0,
      textureMemory: 0,
      renderbufferMemory: 0,
      gpuMemory: 0
    };
    this._metricsCounter = 0;
    this.setProps(props);

    if (props._typedArrayManagerProps) {
      typed_array_manager/* default.setProps */.Z.setProps(props._typedArrayManagerProps);
    }

    this.animationLoop.start();
  }

  finalize() {
    this.animationLoop.stop();
    this.animationLoop = null;
    this._lastPointerDownInfo = null;

    if (this.layerManager) {
      this.layerManager.finalize();
      this.layerManager = null;
      this.viewManager.finalize();
      this.viewManager = null;
      this.effectManager.finalize();
      this.effectManager = null;
      this.deckRenderer.finalize();
      this.deckRenderer = null;
      this.deckPicker.finalize();
      this.deckPicker = null;
      this.eventManager.destroy();
      this.eventManager = null;
      this.tooltip.remove();
      this.tooltip = null;
    }

    if (!this.props.canvas && !this.props.gl && this.canvas) {
      this.canvas.parentElement.removeChild(this.canvas);
      this.canvas = null;
    }
  }

  setProps(props) {
    this.stats.get('setProps Time').timeStart();

    if ('onLayerHover' in props) {
      log/* default.removed */.Z.removed('onLayerHover', 'onHover')();
    }

    if ('onLayerClick' in props) {
      log/* default.removed */.Z.removed('onLayerClick', 'onClick')();
    }

    if (props.initialViewState && !deep_equal_deepEqual(this.props.initialViewState, props.initialViewState)) {
      this.viewState = props.initialViewState;
    }

    Object.assign(this.props, props);

    this._setCanvasSize(this.props);

    const resolvedProps = Object.create(this.props);
    Object.assign(resolvedProps, {
      views: this._getViews(),
      width: this.width,
      height: this.height,
      viewState: this._getViewState()
    });
    this.animationLoop.setProps(resolvedProps);

    if (this.layerManager) {
      this.viewManager.setProps(resolvedProps);
      this.layerManager.activateViewport(this.getViewports()[0]);
      this.layerManager.setProps(resolvedProps);
      this.effectManager.setProps(resolvedProps);
      this.deckRenderer.setProps(resolvedProps);
      this.deckPicker.setProps(resolvedProps);
    }

    this.stats.get('setProps Time').timeEnd();
  }

  needsRedraw(opts = {
    clearRedrawFlags: false
  }) {
    if (this.props._animate) {
      return 'Deck._animate';
    }

    let redraw = this._needsRedraw;

    if (opts.clearRedrawFlags) {
      this._needsRedraw = false;
    }

    const viewManagerNeedsRedraw = this.viewManager.needsRedraw(opts);
    const layerManagerNeedsRedraw = this.layerManager.needsRedraw(opts);
    const effectManagerNeedsRedraw = this.effectManager.needsRedraw(opts);
    const deckRendererNeedsRedraw = this.deckRenderer.needsRedraw(opts);
    redraw = redraw || viewManagerNeedsRedraw || layerManagerNeedsRedraw || effectManagerNeedsRedraw || deckRendererNeedsRedraw;
    return redraw;
  }

  redraw(force) {
    if (!this.layerManager) {
      return;
    }

    const redrawReason = force || this.needsRedraw({
      clearRedrawFlags: true
    });

    if (!redrawReason) {
      return;
    }

    this.stats.get('Redraw Count').incrementCount();

    if (this.props._customRender) {
      this.props._customRender(redrawReason);
    } else {
      this._drawLayers(redrawReason);
    }
  }

  getViews() {
    return this.viewManager.views;
  }

  getViewports(rect) {
    return this.viewManager.getViewports(rect);
  }

  pickObject(opts) {
    const infos = this._pick('pickObject', 'pickObject Time', opts).result;

    return infos.length ? infos[0] : null;
  }

  pickMultipleObjects(opts) {
    opts.depth = opts.depth || 10;
    return this._pick('pickObject', 'pickMultipleObjects Time', opts).result;
  }

  pickObjects(opts) {
    return this._pick('pickObjects', 'pickObjects Time', opts);
  }

  _addResources(resources, forceUpdate = false) {
    for (const id in resources) {
      this.layerManager.resourceManager.add({
        resourceId: id,
        data: resources[id],
        forceUpdate
      });
    }
  }

  _removeResources(resourceIds) {
    for (const id of resourceIds) {
      this.layerManager.resourceManager.remove(id);
    }
  }

  _pick(method, statKey, opts) {
    const {
      stats
    } = this;
    stats.get('Pick Count').incrementCount();
    stats.get(statKey).timeStart();
    const infos = this.deckPicker[method]({
      layers: this.layerManager.getLayers(opts),
      views: this.viewManager.getViews(),
      viewports: this.getViewports(opts),
      onViewportActive: this.layerManager.activateViewport,
      ...opts
    });
    stats.get(statKey).timeEnd();
    return infos;
  }

  _createCanvas(props) {
    let canvas = props.canvas;

    if (typeof canvas === 'string') {
      canvas = document.getElementById(canvas);
      (0,utils_assert/* default */.Z)(canvas);
    }

    if (!canvas) {
      canvas = document.createElement('canvas');
      canvas.id = props.id || 'deckgl-overlay';
      const parent = props.parent || document.body;
      parent.appendChild(canvas);
    }

    Object.assign(canvas.style, props.style);
    return canvas;
  }

  _setCanvasSize(props) {
    if (!this.canvas) {
      return;
    }

    let {
      width,
      height
    } = props;

    if (width || width === 0) {
      width = Number.isFinite(width) ? "".concat(width, "px") : width;
      this.canvas.style.width = width;
    }

    if (height || height === 0) {
      height = Number.isFinite(height) ? "".concat(height, "px") : height;
      this.canvas.style.position = 'absolute';
      this.canvas.style.height = height;
    }
  }

  _updateCanvasSize() {
    if (this._checkForCanvasSizeChange()) {
      const {
        width,
        height
      } = this;
      this.viewManager.setProps({
        width,
        height
      });
      this.props.onResize({
        width: this.width,
        height: this.height
      });
    }
  }

  _checkForCanvasSizeChange() {
    const {
      canvas
    } = this;

    if (!canvas) {
      return false;
    }

    const newWidth = canvas.clientWidth || canvas.width;
    const newHeight = canvas.clientHeight || canvas.height;

    if (newWidth !== this.width || newHeight !== this.height) {
      this.width = newWidth;
      this.height = newHeight;
      return true;
    }

    return false;
  }

  _createAnimationLoop(props) {
    const {
      width,
      height,
      gl,
      glOptions,
      debug,
      onError,
      onBeforeRender,
      onAfterRender,
      useDevicePixels,
      autoResizeDrawingBuffer
    } = props;
    return new AnimationLoop({
      width,
      height,
      useDevicePixels,
      autoResizeDrawingBuffer,
      autoResizeViewport: false,
      gl,
      onCreateContext: opts => (0,gltools_dist_esm/* createGLContext */.s9)({ ...glOptions,
        ...opts,
        canvas: this.canvas,
        debug,
        onContextLost: () => this._onContextLost()
      }),
      onInitialize: context => this._setGLContext(context.gl),
      onRender: this._onRenderFrame.bind(this),
      onBeforeRender,
      onAfterRender,
      onError
    });
  }

  _getViewState() {
    return this.props.viewState || this.viewState;
  }

  _getViews() {
    let views = this.props.views || [new MapView({
      id: 'default-view'
    })];
    views = Array.isArray(views) ? views : [views];

    if (views.length && this.props.controller) {
      views[0].props.controller = this.props.controller;
    }

    return views;
  }

  _onContextLost() {
    const {
      onError
    } = this.props;

    if (this.animationLoop && onError) {
      onError(new Error("WebGL context is lost"));
    }
  }

  _onPointerMove(event) {
    const {
      _pickRequest
    } = this;

    if (event.type === 'pointerleave') {
      _pickRequest.x = -1;
      _pickRequest.y = -1;
      _pickRequest.radius = 0;
    } else if (event.leftButton || event.rightButton) {
      return;
    } else {
      const pos = event.offsetCenter;

      if (!pos) {
        return;
      }

      _pickRequest.x = pos.x;
      _pickRequest.y = pos.y;
      _pickRequest.radius = this.props.pickingRadius;
    }

    if (this.layerManager) {
      this.layerManager.context.mousePosition = {
        x: _pickRequest.x,
        y: _pickRequest.y
      };
    }

    _pickRequest.event = event;
    _pickRequest.mode = 'hover';
  }

  _pickAndCallback() {
    const {
      _pickRequest
    } = this;

    if (_pickRequest.event) {
      const {
        result,
        emptyInfo
      } = this._pick('pickObject', 'pickObject Time', _pickRequest);

      this.interactiveState.isHovering = result.length > 0;
      let pickedInfo = emptyInfo;
      let handled = false;

      for (const info of result) {
        pickedInfo = info;
        handled = info.layer.onHover(info, _pickRequest.event);
      }

      if (!handled && this.props.onHover) {
        this.props.onHover(pickedInfo, _pickRequest.event);
      }

      if (this.props.getTooltip) {
        const displayInfo = this.props.getTooltip(pickedInfo);
        this.tooltip.setTooltip(displayInfo, pickedInfo.x, pickedInfo.y);
      }

      _pickRequest.event = null;
    }
  }

  _updateCursor() {
    const container = this.props.parent || this.canvas;

    if (container) {
      container.style.cursor = this.props.getCursor(this.interactiveState);
    }
  }

  _setGLContext(gl) {
    if (this.layerManager) {
      return;
    }

    if (!this.canvas) {
      this.canvas = gl.canvas;
      (0,gltools_dist_esm/* instrumentGLContext */.yW)(gl, {
        enable: true,
        copyState: true
      });
    }

    this.tooltip = new Tooltip(this.canvas);
    (0,gltools_dist_esm/* setParameters */.dR)(gl, {
      blend: true,
      blendFunc: [770, 771, 1, 771],
      polygonOffsetFill: true,
      depthTest: true,
      depthFunc: 515
    });
    this.props.onWebGLInitialized(gl);
    const timeline = new Timeline();
    timeline.play();
    this.animationLoop.attachTimeline(timeline);
    this.eventManager = new dist_esm/* EventManager */.Q(this.props.parent || gl.canvas, {
      touchAction: this.props.touchAction,
      recognizerOptions: this.props.eventRecognizerOptions,
      events: {
        pointerdown: this._onPointerDown,
        pointermove: this._onPointerMove,
        pointerleave: this._onPointerMove
      }
    });

    for (const eventType in lib_constants/* EVENTS */.FP) {
      this.eventManager.on(eventType, this._onEvent);
    }

    this.viewManager = new ViewManager({
      timeline,
      eventManager: this.eventManager,
      onViewStateChange: this._onViewStateChange.bind(this),
      onInteractionStateChange: this._onInteractionStateChange.bind(this),
      views: this._getViews(),
      viewState: this._getViewState(),
      width: this.width,
      height: this.height
    });
    const viewport = this.viewManager.getViewports()[0];
    this.layerManager = new LayerManager(gl, {
      deck: this,
      stats: this.stats,
      viewport,
      timeline
    });
    this.effectManager = new EffectManager();
    this.deckRenderer = new DeckRenderer(gl);
    this.deckPicker = new DeckPicker(gl);
    this.setProps(this.props);

    this._updateCanvasSize();

    this.props.onLoad();
  }

  _drawLayers(redrawReason, renderOptions) {
    const {
      gl
    } = this.layerManager.context;
    (0,gltools_dist_esm/* setParameters */.dR)(gl, this.props.parameters);
    this.props.onBeforeRender({
      gl
    });
    this.deckRenderer.renderLayers({
      target: this.props._framebuffer,
      layers: this.layerManager.getLayers(),
      viewports: this.viewManager.getViewports(),
      onViewportActive: this.layerManager.activateViewport,
      views: this.viewManager.getViews(),
      pass: 'screen',
      redrawReason,
      effects: this.effectManager.getEffects(),
      ...renderOptions
    });
    this.props.onAfterRender({
      gl
    });
  }

  _onRenderFrame(animationProps) {
    this._getFrameStats();

    if (this._metricsCounter++ % 60 === 0) {
      this._getMetrics();

      this.stats.reset();
      log/* default.table */.Z.table(4, this.metrics)();

      if (this.props._onMetrics) {
        this.props._onMetrics(this.metrics);
      }
    }

    this._updateCanvasSize();

    this._updateCursor();

    if (this.tooltip.isVisible && this.viewManager.needsRedraw()) {
      this.tooltip.setTooltip(null);
    }

    this.layerManager.updateLayers();

    this._pickAndCallback();

    this.redraw(false);

    if (this.viewManager) {
      this.viewManager.updateViewStates();
    }
  }

  _onViewStateChange(params) {
    const viewState = this.props.onViewStateChange(params) || params.viewState;

    if (this.viewState) {
      this.viewState = { ...this.viewState,
        [params.viewId]: viewState
      };

      if (!this.props.viewState) {
        if (this.viewManager) {
          this.viewManager.setProps({
            viewState: this.viewState
          });
        }
      }
    }
  }

  _onInteractionStateChange(interactionState) {
    this.interactiveState.isDragging = interactionState.isDragging;
    this.props.onInteractionStateChange(interactionState);
  }

  _onEvent(event) {
    const eventOptions = lib_constants/* EVENTS */.FP[event.type];
    const pos = event.offsetCenter;

    if (!eventOptions || !pos) {
      return;
    }

    const layers = this.layerManager.getLayers();
    const info = this.deckPicker.getLastPickedObject({
      x: pos.x,
      y: pos.y,
      layers,
      viewports: this.getViewports(pos)
    }, this._lastPointerDownInfo);
    const {
      layer
    } = info;
    const layerHandler = layer && (layer[eventOptions.handler] || layer.props[eventOptions.handler]);
    const rootHandler = this.props[eventOptions.handler];
    let handled = false;

    if (layerHandler) {
      handled = layerHandler.call(layer, info, event);
    }

    if (!handled && rootHandler) {
      rootHandler(info, event);
    }
  }

  _onPointerDown(event) {
    const pos = event.offsetCenter;
    this._lastPointerDownInfo = this.pickObject({
      x: pos.x,
      y: pos.y,
      radius: this.props.pickingRadius
    });
  }

  _getFrameStats() {
    const {
      stats
    } = this;
    stats.get('frameRate').timeEnd();
    stats.get('frameRate').timeStart();
    const animationLoopStats = this.animationLoop.stats;
    stats.get('GPU Time').addTime(animationLoopStats.get('GPU Time').lastTiming);
    stats.get('CPU Time').addTime(animationLoopStats.get('CPU Time').lastTiming);
  }

  _getMetrics() {
    const {
      metrics,
      stats
    } = this;
    metrics.fps = stats.get('frameRate').getHz();
    metrics.setPropsTime = stats.get('setProps Time').time;
    metrics.updateAttributesTime = stats.get('Update Attributes').time;
    metrics.framesRedrawn = stats.get('Redraw Count').count;
    metrics.pickTime = stats.get('pickObject Time').time + stats.get('pickMultipleObjects Time').time + stats.get('pickObjects Time').time;
    metrics.pickCount = stats.get('Pick Count').count;
    metrics.gpuTime = stats.get('GPU Time').time;
    metrics.cpuTime = stats.get('CPU Time').time;
    metrics.gpuTimePerFrame = stats.get('GPU Time').getAverageTime();
    metrics.cpuTimePerFrame = stats.get('CPU Time').getAverageTime();
    const memoryStats = esm_init/* lumaStats.get */.l.get('Memory Usage');
    metrics.bufferMemory = memoryStats.get('Buffer Memory').count;
    metrics.textureMemory = memoryStats.get('Texture Memory').count;
    metrics.renderbufferMemory = memoryStats.get('Renderbuffer Memory').count;
    metrics.gpuMemory = memoryStats.get('GPU Memory').count;
  }

}
Deck.getPropTypes = getPropTypes;
Deck.defaultProps = deck_defaultProps;
Deck.VERSION = init.VERSION;
//# sourceMappingURL=deck.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/react/dist/esm/utils/use-isomorphic-layout-effect.js

const use_isomorphic_layout_effect_useIsomorphicLayoutEffect = typeof window !== 'undefined' ? react.useLayoutEffect : react.useEffect;
/* harmony default export */ const utils_use_isomorphic_layout_effect = (use_isomorphic_layout_effect_useIsomorphicLayoutEffect);
//# sourceMappingURL=use-isomorphic-layout-effect.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/react/dist/esm/utils/inherits-from.js
function inheritsFrom(Type, ParentType) {
  while (Type) {
    if (Type === ParentType) {
      return true;
    }

    Type = Object.getPrototypeOf(Type);
  }

  return false;
}
//# sourceMappingURL=inherits-from.js.map
// EXTERNAL MODULE: ./node_modules/@deck.gl/core/dist/esm/lib/layer.js + 11 modules
var lib_layer = __webpack_require__(95772);
;// CONCATENATED MODULE: ./node_modules/@deck.gl/react/dist/esm/utils/extract-jsx-layers.js




function wrapInView(node) {
  if (!node) {
    return node;
  }

  if (typeof node === 'function') {
    return (0,react.createElement)(View, {}, node);
  }

  if (Array.isArray(node)) {
    return node.map(wrapInView);
  }

  if (node.type === react.Fragment) {
    return wrapInView(node.props.children);
  }

  if (inheritsFrom(node.type, View)) {
    return node;
  }

  return node;
}

function extractJSXLayers({
  children,
  layers,
  views
}) {
  const reactChildren = [];
  const jsxLayers = [];
  const jsxViews = {};
  react.Children.forEach(wrapInView(children), reactElement => {
    if (reactElement) {
      const ElementType = reactElement.type;

      if (inheritsFrom(ElementType, lib_layer/* default */.Z)) {
        const layer = extract_jsx_layers_createLayer(ElementType, reactElement.props);
        jsxLayers.push(layer);
      } else {
        reactChildren.push(reactElement);
      }

      if (ElementType !== View && inheritsFrom(ElementType, View) && reactElement.props.id) {
        const view = new ElementType(reactElement.props);
        jsxViews[view.id] = view;
      }
    }
  });

  if (Object.keys(jsxViews).length > 0) {
    if (Array.isArray(views)) {
      views.forEach(view => {
        jsxViews[view.id] = view;
      });
    } else if (views) {
      jsxViews[views.id] = views;
    }

    views = Object.values(jsxViews);
  }

  layers = jsxLayers.length > 0 ? [...jsxLayers, ...layers] : layers;
  return {
    layers,
    children: reactChildren,
    views
  };
}

function extract_jsx_layers_createLayer(LayerType, reactProps) {
  const props = {};
  const defaultProps = LayerType.defaultProps || {};

  for (const key in reactProps) {
    if (defaultProps[key] !== reactProps[key]) {
      props[key] = reactProps[key];
    }
  }

  return new LayerType(props);
}
//# sourceMappingURL=extract-jsx-layers.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/react/dist/esm/utils/evaluate-children.js

const MAP_STYLE = {
  position: 'absolute',
  zIndex: -1
};
function evaluateChildren(children, childProps) {
  if (!children) {
    return children;
  }

  if (typeof children === 'function') {
    return children(childProps);
  }

  if (Array.isArray(children)) {
    return children.map(child => evaluateChildren(child, childProps));
  }

  if (isReactMap(children)) {
    childProps.style = MAP_STYLE;
    return (0,react.cloneElement)(children, childProps);
  }

  if (needsDeckGLViewProps(children)) {
    return (0,react.cloneElement)(children, childProps);
  }

  return children;
}

function isReactMap(child) {
  const componentClass = child && child.type;
  const componentProps = componentClass && componentClass.defaultProps;
  return componentProps && componentProps.mapStyle;
}

function needsDeckGLViewProps(child) {
  const componentClass = child && child.type;
  return componentClass && componentClass.deckGLViewProps;
}
//# sourceMappingURL=evaluate-children.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/react/dist/esm/utils/position-children-under-views.js




function positionChildrenUnderViews({
  children,
  deck,
  ContextProvider
}) {
  const {
    viewManager
  } = deck || {};

  if (!viewManager || !viewManager.views.length) {
    return [];
  }

  const views = {};
  const defaultViewId = viewManager.views[0].id;

  for (const child of children) {
    let viewId = defaultViewId;
    let viewChildren = child;

    if (inheritsFrom(child.type, View)) {
      viewId = child.props.id || defaultViewId;
      viewChildren = child.props.children;
    }

    const viewport = viewManager.getViewport(viewId);
    const viewState = viewManager.getViewState(viewId);

    if (viewport) {
      const {
        x,
        y,
        width,
        height
      } = viewport;
      viewChildren = evaluateChildren(viewChildren, {
        x,
        y,
        width,
        height,
        viewport,
        viewState
      });

      if (!views[viewId]) {
        views[viewId] = {
          viewport,
          children: []
        };
      }

      views[viewId].children.push(viewChildren);
    }
  }

  return Object.keys(views).map(viewId => {
    const {
      viewport,
      children: viewChildren
    } = views[viewId];
    const {
      x,
      y,
      width,
      height
    } = viewport;
    const style = {
      position: 'absolute',
      left: x,
      top: y,
      width,
      height
    };
    const key = "view-".concat(viewId);
    const viewElement = (0,react.createElement)('div', {
      key,
      id: key,
      style
    }, ...viewChildren);

    if (ContextProvider) {
      const contextValue = {
        viewport,
        container: deck.canvas.offsetParent,
        eventManager: deck.eventManager,
        onViewStateChange: params => {
          params.viewId = viewId;

          deck._onViewStateChange(params);
        }
      };
      return (0,react.createElement)(ContextProvider, {
        key,
        value: contextValue
      }, viewElement);
    }

    return viewElement;
  });
}
//# sourceMappingURL=position-children-under-views.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/react/dist/esm/utils/extract-styles.js
const CANVAS_ONLY_STYLES = {
  mixBlendMode: null
};
function extractStyles({
  width,
  height,
  style
}) {
  const containerStyle = {
    position: 'absolute',
    zIndex: 0,
    left: 0,
    top: 0,
    width,
    height
  };
  const canvasStyle = {
    left: 0,
    top: 0
  };

  if (style) {
    for (const key in style) {
      if (key in CANVAS_ONLY_STYLES) {
        canvasStyle[key] = style[key];
      } else {
        containerStyle[key] = style[key];
      }
    }
  }

  return {
    containerStyle,
    canvasStyle
  };
}
//# sourceMappingURL=extract-styles.js.map
;// CONCATENATED MODULE: ./node_modules/@deck.gl/react/dist/esm/deckgl.js








function deckgl_getRefHandles(thisRef) {
  const handles = {
    pickObject: opts => thisRef.deck.pickObject(opts),
    pickMultipleObjects: opts => thisRef.deck.pickMultipleObjects(opts),
    pickObjects: opts => thisRef.deck.pickObjects(opts)
  };
  Object.defineProperty(handles, 'deck', {
    get: () => thisRef.deck
  });
  return handles;
}

function redrawDeck(thisRef) {
  if (thisRef.redrawReason) {
    thisRef.deck._drawLayers(thisRef.redrawReason);

    thisRef.redrawReason = null;
  }
}

function createDeckInstance(thisRef, props) {
  const DeckClass = props.Deck || Deck;
  const deck = new DeckClass({ ...props,
    style: null,
    width: '100%',
    height: '100%',
    _customRender: redrawReason => {
      thisRef.redrawReason = redrawReason;
      const viewports = deck.viewManager.getViewports();

      if (thisRef.lastRenderedViewports !== viewports) {
        thisRef.forceUpdate(v => v + 1);
      } else {
        redrawDeck(thisRef);
      }
    }
  });
  return deck;
}

const DeckGL = (0,react.forwardRef)((props, ref) => {
  const _thisRef = (0,react.useRef)({});

  const thisRef = _thisRef.current;
  const [version, setVersion] = (0,react.useState)(0);
  thisRef.forceUpdate = setVersion;
  const containerRef = (0,react.useRef)(null);
  const canvasRef = (0,react.useRef)(null);
  const jsxProps = (0,react.useMemo)(() => extractJSXLayers(props), [props.layers, props.views, props.children]);
  let inRender = true;

  const handleViewStateChange = params => {
    if (inRender && props.viewState) {
      thisRef.viewStateUpdateRequested = params;
      return null;
    }

    thisRef.viewStateUpdateRequested = null;
    return props.onViewStateChange(params);
  };

  const handleInteractionStateChange = params => {
    if (inRender) {
      thisRef.interactionStateUpdateRequested = params;
    } else {
      thisRef.interactionStateUpdateRequested = null;
      props.onInteractionStateChange(params);
    }
  };

  const deckProps = (0,react.useMemo)(() => {
    const forwardProps = { ...props,
      style: null,
      width: '100%',
      height: '100%',
      layers: jsxProps.layers,
      views: jsxProps.views,
      onViewStateChange: handleViewStateChange,
      onInteractionStateChange: handleInteractionStateChange
    };

    if (thisRef.deck) {
      thisRef.deck.setProps(forwardProps);
    }

    return forwardProps;
  }, [props]);
  (0,react.useEffect)(() => {
    thisRef.deck = createDeckInstance(thisRef, { ...deckProps,
      parent: containerRef.current,
      canvas: canvasRef.current
    });
    return () => thisRef.deck.finalize();
  }, []);
  utils_use_isomorphic_layout_effect(() => {
    redrawDeck(thisRef);
    const {
      viewStateUpdateRequested,
      interactionStateUpdateRequested
    } = thisRef;

    if (viewStateUpdateRequested) {
      handleViewStateChange(viewStateUpdateRequested);
    }

    if (interactionStateUpdateRequested) {
      handleInteractionStateChange(interactionStateUpdateRequested);
    }
  });
  (0,react.useImperativeHandle)(ref, () => deckgl_getRefHandles(thisRef), []);
  const {
    viewManager
  } = thisRef.deck || {};
  const currentViewports = viewManager && viewManager.getViewports();
  const {
    ContextProvider,
    width,
    height,
    id,
    style
  } = props;
  const {
    containerStyle,
    canvasStyle
  } = (0,react.useMemo)(() => extractStyles({
    width,
    height,
    style
  }), [width, height, style]);

  if (!thisRef.viewStateUpdateRequested && thisRef.lastRenderedViewports === currentViewports || thisRef.version !== version) {
      thisRef.lastRenderedViewports = currentViewports;
      thisRef.version = version;
      const childrenUnderViews = positionChildrenUnderViews({
        children: jsxProps.children,
        deck: thisRef.deck,
        ContextProvider
      });
      const canvas = (0,react.createElement)('canvas', {
        key: 'canvas',
        id: id || 'deckgl-overlay',
        ref: canvasRef,
        style: canvasStyle
      });
      thisRef.control = (0,react.createElement)('div', {
        id: "".concat(id || 'deckgl', "-wrapper"),
        ref: containerRef,
        style: containerStyle
      }, [canvas, childrenUnderViews]);
    }

  inRender = false;
  return thisRef.control;
});
DeckGL.propTypes = Deck.getPropTypes((prop_types_default()));
DeckGL.defaultProps = Deck.defaultProps;
/* harmony default export */ const deckgl = (DeckGL);
//# sourceMappingURL=deckgl.js.map
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/style/index.js
var style = __webpack_require__(37840);
// EXTERNAL MODULE: ./node_modules/xss/lib/index.js
var lib = __webpack_require__(68924);
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Tooltip.js



function Tooltip_Tooltip(props) {
  const {
    tooltip
  } = props;

  if (typeof tooltip === 'undefined' || tooltip === null) {
    return null;
  }

  const {
    x,
    y,
    content
  } = tooltip; // eslint-disable-next-line react-hooks/rules-of-hooks

  const style = (0,react.useMemo)(() => ({
    position: 'absolute',
    top: y + "px",
    left: x + "px",
    padding: '8px',
    margin: '8px',
    background: 'rgba(0, 0, 0, 0.8)',
    color: '#fff',
    maxWidth: '300px',
    fontSize: '12px',
    zIndex: 9,
    pointerEvents: 'none'
  }), [x, y]);

  if (typeof content === 'string') {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    const contentHtml = (0,react.useMemo)(() => ({
      __html: (0,lib.filterXSS)(content, {
        stripIgnoreTag: true
      })
    }), [content]);
    return react.createElement("div", {
      style: style
    }, react.createElement("div", {
      // eslint-disable-next-line react/no-danger
      dangerouslySetInnerHTML: contentHtml
    }));
  }

  return react.createElement("div", {
    style: style
  }, content);
}
;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/css/deckgl.css
// extracted by mini-css-extract-plugin

;// CONCATENATED MODULE: ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/DeckGLContainer.js
function _templateObject() {
  const data = _taggedTemplateLiteralLoose(["\n  .deckgl-tooltip > div {\n    overflow: hidden;\n    text-overflow: ellipsis;\n  }\n"]);

  _templateObject = function _templateObject() {
    return data;
  };

  return data;
}

function _taggedTemplateLiteralLoose(strings, raw) { if (!raw) { raw = strings.slice(0); } strings.raw = raw; return strings; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* eslint-disable react/jsx-sort-default-props */

/* eslint-disable react/sort-prop-types */

/* eslint-disable react/jsx-handler-names */

/* eslint-disable react/forbid-prop-types */

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




 // eslint-disable-next-line import/extensions




const TICK = 250; // milliseconds

const DeckGLContainer_propTypes = {
  viewport: (prop_types_default()).object.isRequired,
  layers: (prop_types_default()).array.isRequired,
  setControlValue: (prop_types_default()).func,
  mapStyle: (prop_types_default()).string,
  mapboxApiAccessToken: (prop_types_default()).string.isRequired,
  children: (prop_types_default()).node,
  bottomMargin: (prop_types_default()).number,
  width: (prop_types_default()).number.isRequired,
  height: (prop_types_default()).number.isRequired
};
const DeckGLContainer_defaultProps = {
  mapStyle: 'light',
  setControlValue: () => {},
  children: null,
  bottomMargin: 0
};

class DeckGLContainer extends react.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "setTooltip", tooltip => {
      this.setState({
        tooltip
      });
    });

    this.tick = this.tick.bind(this);
    this.onViewStateChange = this.onViewStateChange.bind(this); // This has to be placed after this.tick is bound to this

    this.state = {
      timer: setInterval(this.tick, TICK),
      tooltip: null,
      viewState: props.viewport
    };
  }

  componentWillUnmount() {
    clearInterval(this.state.timer);
  }

  onViewStateChange(_ref) {
    let {
      viewState
    } = _ref;
    this.setState({
      viewState,
      lastUpdate: Date.now()
    });
  }

  tick() {
    // Rate limiting updating viewport controls as it triggers lotsa renders
    const {
      lastUpdate
    } = this.state;

    if (lastUpdate && Date.now() - lastUpdate > TICK) {
      const setCV = this.props.setControlValue;

      if (setCV) {
        setCV('viewport', this.state.viewState);
      }

      this.setState({
        lastUpdate: null
      });
    }
  }

  layers() {
    // Support for layer factory
    if (this.props.layers.some(l => typeof l === 'function')) {
      return this.props.layers.map(l => typeof l === 'function' ? l() : l);
    }

    return this.props.layers;
  }

  render() {
    const {
      children,
      bottomMargin,
      height,
      width
    } = this.props;
    const {
      viewState,
      tooltip
    } = this.state;
    const adjustedHeight = height - bottomMargin;
    const layers = this.layers();
    return react.createElement(react.Fragment, null, react.createElement("div", {
      style: {
        position: 'relative',
        width,
        height: adjustedHeight
      }
    }, react.createElement(deckgl, {
      initWebGLParameters: true,
      controller: true,
      width: width,
      height: adjustedHeight,
      layers: layers,
      viewState: viewState,
      glOptions: {
        preserveDrawingBuffer: true
      },
      onViewStateChange: this.onViewStateChange
    }, react.createElement(static_map, {
      preserveDrawingBuffer: true,
      mapStyle: this.props.mapStyle,
      mapboxApiAccessToken: this.props.mapboxApiAccessToken
    })), children), react.createElement(Tooltip_Tooltip, {
      tooltip: tooltip
    }));
  }

}

DeckGLContainer.propTypes = DeckGLContainer_propTypes;
DeckGLContainer.defaultProps = DeckGLContainer_defaultProps;
/* harmony default export */ const esm_DeckGLContainer = ((0,style/* styled */.iK)(DeckGLContainer)(_templateObject()));

/***/ }),

/***/ 57981:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ TooltipRow)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67294);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45697);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired)
};
class TooltipRow extends react__WEBPACK_IMPORTED_MODULE_0__.PureComponent {
  render() {
    const {
      label,
      value
    } = this.props;
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, label, react__WEBPACK_IMPORTED_MODULE_0__.createElement("strong", null, value));
  }

}
TooltipRow.propTypes = propTypes;

/***/ }),

/***/ 37032:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "N": () => (/* binding */ commonLayerProps),
/* harmony export */   "Z": () => (/* binding */ getAggFunc)
/* harmony export */ });
/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4065);
/* harmony import */ var _utils_sandbox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88574);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


function commonLayerProps(formData, setTooltip, setTooltipContent, onSelect) {
  const fd = formData;
  let onHover;
  let tooltipContentGenerator = setTooltipContent;

  if (fd.js_tooltip) {
    tooltipContentGenerator = (0,_utils_sandbox__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(fd.js_tooltip);
  }

  if (tooltipContentGenerator) {
    onHover = o => {
      if (o.picked) {
        setTooltip({
          content: tooltipContentGenerator(o),
          x: o.x,
          y: o.y
        });
      } else {
        setTooltip(null);
      }
    };
  }

  let onClick;

  if (fd.js_onclick_href) {
    onClick = o => {
      const href = (0,_utils_sandbox__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(fd.js_onclick_href)(o);
      window.open(href);
    };
  } else if (fd.table_filter && onSelect !== undefined) {
    onClick = o => onSelect(o.object[fd.line_column]);
  }

  return {
    onClick,
    onHover,
    pickable: Boolean(onHover)
  };
}
const percentiles = {
  p1: 0.01,
  p5: 0.05,
  p95: 0.95,
  p99: 0.99
};
/* Get an a stat function that operates on arrays, aligns with control=js_agg_function  */

function getAggFunc(type, accessor) {
  if (type === void 0) {
    type = 'sum';
  }

  if (accessor === void 0) {
    accessor = null;
  }

  if (type === 'count') {
    return arr => arr.length;
  }

  let d3func;

  if (type in percentiles) {
    d3func = (arr, acc) => {
      let sortedArr;

      if (accessor) {
        sortedArr = arr.sort((o1, o2) => d3_array__WEBPACK_IMPORTED_MODULE_0__.ascending(accessor(o1), accessor(o2)));
      } else {
        sortedArr = arr.sort(d3_array__WEBPACK_IMPORTED_MODULE_0__.ascending);
      }

      return d3_array__WEBPACK_IMPORTED_MODULE_0__.quantile(sortedArr, percentiles[type], acc);
    };
  } else {
    d3func = d3_array__WEBPACK_IMPORTED_MODULE_0__[type];
  }

  if (!accessor) {
    return arr => d3func(arr);
  }

  return arr => d3func(arr.map(x => accessor(x)));
}

/***/ }),

/***/ 15191:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "hexToRGB": () => (/* binding */ hexToRGB)
/* harmony export */ });
/* harmony import */ var d3_color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16372);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
 // eslint-disable-next-line import/prefer-default-export

function hexToRGB(hex, alpha) {
  if (alpha === void 0) {
    alpha = 255;
  }

  if (!hex) {
    return [0, 0, 0, alpha];
  }

  const {
    r,
    g,
    b
  } = (0,d3_color__WEBPACK_IMPORTED_MODULE_0__/* .rgb */ .B8)(hex);
  return [r, g, b, alpha];
}

/***/ }),

/***/ 88574:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ sandboxedEval)
});

// NAMESPACE OBJECT: ./node_modules/underscore/modules/index.js
var modules_namespaceObject = {};
__webpack_require__.r(modules_namespaceObject);
__webpack_require__.d(modules_namespaceObject, {
  "VERSION": () => (VERSION),
  "after": () => (after),
  "all": () => (every),
  "allKeys": () => (allKeys),
  "any": () => (some),
  "assign": () => (extendOwn),
  "before": () => (before),
  "bind": () => (bind),
  "bindAll": () => (bindAll),
  "chain": () => (chain),
  "chunk": () => (chunk),
  "clone": () => (clone),
  "collect": () => (map),
  "compact": () => (compact),
  "compose": () => (compose),
  "constant": () => (constant),
  "contains": () => (contains),
  "countBy": () => (countBy),
  "create": () => (create),
  "debounce": () => (debounce),
  "default": () => (underscore_array_methods),
  "defaults": () => (defaults),
  "defer": () => (defer),
  "delay": () => (delay),
  "detect": () => (find),
  "difference": () => (difference),
  "drop": () => (rest),
  "each": () => (each),
  "escape": () => (modules_escape),
  "every": () => (every),
  "extend": () => (extend),
  "extendOwn": () => (extendOwn),
  "filter": () => (filter),
  "find": () => (find),
  "findIndex": () => (findIndex),
  "findKey": () => (findKey),
  "findLastIndex": () => (findLastIndex),
  "findWhere": () => (findWhere),
  "first": () => (first),
  "flatten": () => (flatten_flatten),
  "foldl": () => (reduce),
  "foldr": () => (reduceRight),
  "forEach": () => (each),
  "functions": () => (functions),
  "get": () => (get),
  "groupBy": () => (groupBy),
  "has": () => (has_has),
  "head": () => (first),
  "identity": () => (identity),
  "include": () => (contains),
  "includes": () => (contains),
  "indexBy": () => (indexBy),
  "indexOf": () => (indexOf),
  "initial": () => (initial),
  "inject": () => (reduce),
  "intersection": () => (intersection),
  "invert": () => (invert),
  "invoke": () => (invoke),
  "isArguments": () => (modules_isArguments),
  "isArray": () => (isArray),
  "isArrayBuffer": () => (isArrayBuffer),
  "isBoolean": () => (isBoolean),
  "isDataView": () => (modules_isDataView),
  "isDate": () => (isDate),
  "isElement": () => (isElement),
  "isEmpty": () => (isEmpty),
  "isEqual": () => (isEqual),
  "isError": () => (isError),
  "isFinite": () => (isFinite_isFinite),
  "isFunction": () => (modules_isFunction),
  "isMap": () => (isMap),
  "isMatch": () => (isMatch),
  "isNaN": () => (isNaN_isNaN),
  "isNull": () => (isNull),
  "isNumber": () => (isNumber),
  "isObject": () => (isObject),
  "isRegExp": () => (isRegExp),
  "isSet": () => (isSet),
  "isString": () => (isString),
  "isSymbol": () => (isSymbol),
  "isTypedArray": () => (modules_isTypedArray),
  "isUndefined": () => (isUndefined),
  "isWeakMap": () => (isWeakMap),
  "isWeakSet": () => (isWeakSet),
  "iteratee": () => (iteratee),
  "keys": () => (keys),
  "last": () => (last),
  "lastIndexOf": () => (lastIndexOf),
  "map": () => (map),
  "mapObject": () => (mapObject),
  "matcher": () => (matcher),
  "matches": () => (matcher),
  "max": () => (max),
  "memoize": () => (memoize),
  "methods": () => (functions),
  "min": () => (min),
  "mixin": () => (mixin),
  "negate": () => (negate),
  "noop": () => (noop),
  "now": () => (now),
  "object": () => (object),
  "omit": () => (omit),
  "once": () => (once),
  "pairs": () => (pairs),
  "partial": () => (modules_partial),
  "partition": () => (partition),
  "pick": () => (pick),
  "pluck": () => (pluck),
  "property": () => (property),
  "propertyOf": () => (propertyOf),
  "random": () => (random),
  "range": () => (range),
  "reduce": () => (reduce),
  "reduceRight": () => (reduceRight),
  "reject": () => (reject),
  "rest": () => (rest),
  "restArguments": () => (restArguments),
  "result": () => (result),
  "sample": () => (sample),
  "select": () => (filter),
  "shuffle": () => (shuffle),
  "size": () => (size),
  "some": () => (some),
  "sortBy": () => (sortBy),
  "sortedIndex": () => (sortedIndex),
  "tail": () => (rest),
  "take": () => (first),
  "tap": () => (tap),
  "template": () => (template),
  "templateSettings": () => (templateSettings),
  "throttle": () => (throttle),
  "times": () => (times),
  "toArray": () => (toArray),
  "toPath": () => (toPath),
  "transpose": () => (unzip),
  "unescape": () => (modules_unescape),
  "union": () => (union),
  "uniq": () => (uniq),
  "unique": () => (uniq),
  "uniqueId": () => (uniqueId),
  "unzip": () => (unzip),
  "values": () => (values),
  "where": () => (where),
  "without": () => (without),
  "wrap": () => (wrap),
  "zip": () => (zip)
});

// EXTERNAL MODULE: vm (ignored)
var vm_ignored_ = __webpack_require__(95751);
var vm_ignored_default = /*#__PURE__*/__webpack_require__.n(vm_ignored_);
;// CONCATENATED MODULE: ./node_modules/underscore/modules/_setup.js
// Current version.
var VERSION = '1.12.0';

// Establish the root object, `window` (`self`) in the browser, `global`
// on the server, or `this` in some virtual machines. We use `self`
// instead of `window` for `WebWorker` support.
var root = typeof self == 'object' && self.self === self && self ||
          typeof __webpack_require__.g == 'object' && __webpack_require__.g.global === __webpack_require__.g && __webpack_require__.g ||
          Function('return this')() ||
          {};

// Save bytes in the minified (but not gzipped) version:
var ArrayProto = Array.prototype, ObjProto = Object.prototype;
var SymbolProto = typeof Symbol !== 'undefined' ? Symbol.prototype : null;

// Create quick reference variables for speed access to core prototypes.
var push = ArrayProto.push,
    slice = ArrayProto.slice,
    _setup_toString = ObjProto.toString,
    _setup_hasOwnProperty = ObjProto.hasOwnProperty;

// Modern feature detection.
var supportsArrayBuffer = typeof ArrayBuffer !== 'undefined',
    supportsDataView = typeof DataView !== 'undefined';

// All **ECMAScript 5+** native function implementations that we hope to use
// are declared here.
var nativeIsArray = Array.isArray,
    nativeKeys = Object.keys,
    nativeCreate = Object.create,
    nativeIsView = supportsArrayBuffer && ArrayBuffer.isView;

// Create references to these builtin functions because we override them.
var _isNaN = isNaN,
    _isFinite = isFinite;

// Keys in IE < 9 that won't be iterated by `for key in ...` and thus missed.
var hasEnumBug = !{toString: null}.propertyIsEnumerable('toString');
var nonEnumerableProps = ['valueOf', 'isPrototypeOf', 'toString',
  'propertyIsEnumerable', 'hasOwnProperty', 'toLocaleString'];

// The largest integer that can be represented exactly.
var MAX_ARRAY_INDEX = Math.pow(2, 53) - 1;

;// CONCATENATED MODULE: ./node_modules/underscore/modules/restArguments.js
// Some functions take a variable number of arguments, or a few expected
// arguments at the beginning and then a variable number of values to operate
// on. This helper accumulates all remaining arguments past the function’s
// argument length (or an explicit `startIndex`), into an array that becomes
// the last argument. Similar to ES6’s "rest parameter".
function restArguments(func, startIndex) {
  startIndex = startIndex == null ? func.length - 1 : +startIndex;
  return function() {
    var length = Math.max(arguments.length - startIndex, 0),
        rest = Array(length),
        index = 0;
    for (; index < length; index++) {
      rest[index] = arguments[index + startIndex];
    }
    switch (startIndex) {
      case 0: return func.call(this, rest);
      case 1: return func.call(this, arguments[0], rest);
      case 2: return func.call(this, arguments[0], arguments[1], rest);
    }
    var args = Array(startIndex + 1);
    for (index = 0; index < startIndex; index++) {
      args[index] = arguments[index];
    }
    args[startIndex] = rest;
    return func.apply(this, args);
  };
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isObject.js
// Is a given variable an object?
function isObject(obj) {
  var type = typeof obj;
  return type === 'function' || type === 'object' && !!obj;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isNull.js
// Is a given value equal to null?
function isNull(obj) {
  return obj === null;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isUndefined.js
// Is a given variable undefined?
function isUndefined(obj) {
  return obj === void 0;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isBoolean.js


// Is a given value a boolean?
function isBoolean(obj) {
  return obj === true || obj === false || _setup_toString.call(obj) === '[object Boolean]';
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isElement.js
// Is a given value a DOM element?
function isElement(obj) {
  return !!(obj && obj.nodeType === 1);
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_tagTester.js


// Internal function for creating a `toString`-based type tester.
function tagTester(name) {
  var tag = '[object ' + name + ']';
  return function(obj) {
    return _setup_toString.call(obj) === tag;
  };
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isString.js


/* harmony default export */ const isString = (tagTester('String'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isNumber.js


/* harmony default export */ const isNumber = (tagTester('Number'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isDate.js


/* harmony default export */ const isDate = (tagTester('Date'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isRegExp.js


/* harmony default export */ const isRegExp = (tagTester('RegExp'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isError.js


/* harmony default export */ const isError = (tagTester('Error'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isSymbol.js


/* harmony default export */ const isSymbol = (tagTester('Symbol'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isArrayBuffer.js


/* harmony default export */ const isArrayBuffer = (tagTester('ArrayBuffer'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isFunction.js



var isFunction = tagTester('Function');

// Optimize `isFunction` if appropriate. Work around some `typeof` bugs in old
// v8, IE 11 (#1621), Safari 8 (#1929), and PhantomJS (#2236).
var nodelist = root.document && root.document.childNodes;
if ( true && typeof Int8Array != 'object' && typeof nodelist != 'function') {
  isFunction = function(obj) {
    return typeof obj == 'function' || false;
  };
}

/* harmony default export */ const modules_isFunction = (isFunction);

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_hasObjectTag.js


/* harmony default export */ const _hasObjectTag = (tagTester('Object'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_stringTagBug.js



// In IE 10 - Edge 13, `DataView` has string tag `'[object Object]'`.
// In IE 11, the most common among them, this problem also applies to
// `Map`, `WeakMap` and `Set`.
var hasStringTagBug = (
      supportsDataView && _hasObjectTag(new DataView(new ArrayBuffer(8)))
    ),
    isIE11 = (typeof Map !== 'undefined' && _hasObjectTag(new Map));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isDataView.js





var isDataView = tagTester('DataView');

// In IE 10 - Edge 13, we need a different heuristic
// to determine whether an object is a `DataView`.
function ie10IsDataView(obj) {
  return obj != null && modules_isFunction(obj.getInt8) && isArrayBuffer(obj.buffer);
}

/* harmony default export */ const modules_isDataView = (hasStringTagBug ? ie10IsDataView : isDataView);

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isArray.js



// Is a given value an array?
// Delegates to ECMA5's native `Array.isArray`.
/* harmony default export */ const isArray = (nativeIsArray || tagTester('Array'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_has.js


// Internal function to check whether `key` is an own property name of `obj`.
function has(obj, key) {
  return obj != null && _setup_hasOwnProperty.call(obj, key);
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isArguments.js



var isArguments = tagTester('Arguments');

// Define a fallback version of the method in browsers (ahem, IE < 9), where
// there isn't any inspectable "Arguments" type.
(function() {
  if (!isArguments(arguments)) {
    isArguments = function(obj) {
      return has(obj, 'callee');
    };
  }
}());

/* harmony default export */ const modules_isArguments = (isArguments);

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isFinite.js



// Is a given object a finite number?
function isFinite_isFinite(obj) {
  return !isSymbol(obj) && _isFinite(obj) && !isNaN(parseFloat(obj));
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isNaN.js



// Is the given value `NaN`?
function isNaN_isNaN(obj) {
  return isNumber(obj) && _isNaN(obj);
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/constant.js
// Predicate-generating function. Often useful outside of Underscore.
function constant(value) {
  return function() {
    return value;
  };
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_createSizePropertyCheck.js


// Common internal logic for `isArrayLike` and `isBufferLike`.
function createSizePropertyCheck(getSizeProperty) {
  return function(collection) {
    var sizeProperty = getSizeProperty(collection);
    return typeof sizeProperty == 'number' && sizeProperty >= 0 && sizeProperty <= MAX_ARRAY_INDEX;
  }
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_shallowProperty.js
// Internal helper to generate a function to obtain property `key` from `obj`.
function shallowProperty(key) {
  return function(obj) {
    return obj == null ? void 0 : obj[key];
  };
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_getByteLength.js


// Internal helper to obtain the `byteLength` property of an object.
/* harmony default export */ const _getByteLength = (shallowProperty('byteLength'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_isBufferLike.js



// Internal helper to determine whether we should spend extensive checks against
// `ArrayBuffer` et al.
/* harmony default export */ const _isBufferLike = (createSizePropertyCheck(_getByteLength));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isTypedArray.js





// Is a given value a typed array?
var typedArrayPattern = /\[object ((I|Ui)nt(8|16|32)|Float(32|64)|Uint8Clamped|Big(I|Ui)nt64)Array\]/;
function isTypedArray(obj) {
  // `ArrayBuffer.isView` is the most future-proof, so use it when available.
  // Otherwise, fall back on the above regular expression.
  return nativeIsView ? (nativeIsView(obj) && !modules_isDataView(obj)) :
                _isBufferLike(obj) && typedArrayPattern.test(_setup_toString.call(obj));
}

/* harmony default export */ const modules_isTypedArray = (supportsArrayBuffer ? isTypedArray : constant(false));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_getLength.js


// Internal helper to obtain the `length` property of an object.
/* harmony default export */ const _getLength = (shallowProperty('length'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_collectNonEnumProps.js




// Internal helper to create a simple lookup structure.
// `collectNonEnumProps` used to depend on `_.contains`, but this led to
// circular imports. `emulatedSet` is a one-off solution that only works for
// arrays of strings.
function emulatedSet(keys) {
  var hash = {};
  for (var l = keys.length, i = 0; i < l; ++i) hash[keys[i]] = true;
  return {
    contains: function(key) { return hash[key]; },
    push: function(key) {
      hash[key] = true;
      return keys.push(key);
    }
  };
}

// Internal helper. Checks `keys` for the presence of keys in IE < 9 that won't
// be iterated by `for key in ...` and thus missed. Extends `keys` in place if
// needed.
function collectNonEnumProps(obj, keys) {
  keys = emulatedSet(keys);
  var nonEnumIdx = nonEnumerableProps.length;
  var constructor = obj.constructor;
  var proto = modules_isFunction(constructor) && constructor.prototype || ObjProto;

  // Constructor is a special case.
  var prop = 'constructor';
  if (has(obj, prop) && !keys.contains(prop)) keys.push(prop);

  while (nonEnumIdx--) {
    prop = nonEnumerableProps[nonEnumIdx];
    if (prop in obj && obj[prop] !== proto[prop] && !keys.contains(prop)) {
      keys.push(prop);
    }
  }
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/keys.js





// Retrieve the names of an object's own properties.
// Delegates to **ECMAScript 5**'s native `Object.keys`.
function keys(obj) {
  if (!isObject(obj)) return [];
  if (nativeKeys) return nativeKeys(obj);
  var keys = [];
  for (var key in obj) if (has(obj, key)) keys.push(key);
  // Ahem, IE < 9.
  if (hasEnumBug) collectNonEnumProps(obj, keys);
  return keys;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isEmpty.js






// Is a given array, string, or object empty?
// An "empty" object has no enumerable own-properties.
function isEmpty(obj) {
  if (obj == null) return true;
  // Skip the more expensive `toString`-based type checks if `obj` has no
  // `.length`.
  var length = _getLength(obj);
  if (typeof length == 'number' && (
    isArray(obj) || isString(obj) || modules_isArguments(obj)
  )) return length === 0;
  return _getLength(keys(obj)) === 0;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isMatch.js


// Returns whether an object has a given set of `key:value` pairs.
function isMatch(object, attrs) {
  var _keys = keys(attrs), length = _keys.length;
  if (object == null) return !length;
  var obj = Object(object);
  for (var i = 0; i < length; i++) {
    var key = _keys[i];
    if (attrs[key] !== obj[key] || !(key in obj)) return false;
  }
  return true;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/underscore.js


// If Underscore is called as a function, it returns a wrapped object that can
// be used OO-style. This wrapper holds altered versions of all functions added
// through `_.mixin`. Wrapped objects may be chained.
function _(obj) {
  if (obj instanceof _) return obj;
  if (!(this instanceof _)) return new _(obj);
  this._wrapped = obj;
}

_.VERSION = VERSION;

// Extracts the result from a wrapped and chained object.
_.prototype.value = function() {
  return this._wrapped;
};

// Provide unwrapping proxies for some methods used in engine operations
// such as arithmetic and JSON stringification.
_.prototype.valueOf = _.prototype.toJSON = _.prototype.value;

_.prototype.toString = function() {
  return String(this._wrapped);
};

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_toBufferView.js


// Internal function to wrap or shallow-copy an ArrayBuffer,
// typed array or DataView to a new view, reusing the buffer.
function toBufferView(bufferSource) {
  return new Uint8Array(
    bufferSource.buffer || bufferSource,
    bufferSource.byteOffset || 0,
    _getByteLength(bufferSource)
  );
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isEqual.js











// We use this string twice, so give it a name for minification.
var tagDataView = '[object DataView]';

// Internal recursive comparison function for `_.isEqual`.
function eq(a, b, aStack, bStack) {
  // Identical objects are equal. `0 === -0`, but they aren't identical.
  // See the [Harmony `egal` proposal](https://wiki.ecmascript.org/doku.php?id=harmony:egal).
  if (a === b) return a !== 0 || 1 / a === 1 / b;
  // `null` or `undefined` only equal to itself (strict comparison).
  if (a == null || b == null) return false;
  // `NaN`s are equivalent, but non-reflexive.
  if (a !== a) return b !== b;
  // Exhaust primitive checks
  var type = typeof a;
  if (type !== 'function' && type !== 'object' && typeof b != 'object') return false;
  return deepEq(a, b, aStack, bStack);
}

// Internal recursive comparison function for `_.isEqual`.
function deepEq(a, b, aStack, bStack) {
  // Unwrap any wrapped objects.
  if (a instanceof _) a = a._wrapped;
  if (b instanceof _) b = b._wrapped;
  // Compare `[[Class]]` names.
  var className = _setup_toString.call(a);
  if (className !== _setup_toString.call(b)) return false;
  // Work around a bug in IE 10 - Edge 13.
  if (hasStringTagBug && className == '[object Object]' && modules_isDataView(a)) {
    if (!modules_isDataView(b)) return false;
    className = tagDataView;
  }
  switch (className) {
    // These types are compared by value.
    case '[object RegExp]':
      // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')
    case '[object String]':
      // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
      // equivalent to `new String("5")`.
      return '' + a === '' + b;
    case '[object Number]':
      // `NaN`s are equivalent, but non-reflexive.
      // Object(NaN) is equivalent to NaN.
      if (+a !== +a) return +b !== +b;
      // An `egal` comparison is performed for other numeric values.
      return +a === 0 ? 1 / +a === 1 / b : +a === +b;
    case '[object Date]':
    case '[object Boolean]':
      // Coerce dates and booleans to numeric primitive values. Dates are compared by their
      // millisecond representations. Note that invalid dates with millisecond representations
      // of `NaN` are not equivalent.
      return +a === +b;
    case '[object Symbol]':
      return SymbolProto.valueOf.call(a) === SymbolProto.valueOf.call(b);
    case '[object ArrayBuffer]':
    case tagDataView:
      // Coerce to typed array so we can fall through.
      return deepEq(toBufferView(a), toBufferView(b), aStack, bStack);
  }

  var areArrays = className === '[object Array]';
  if (!areArrays && modules_isTypedArray(a)) {
      var byteLength = _getByteLength(a);
      if (byteLength !== _getByteLength(b)) return false;
      if (a.buffer === b.buffer && a.byteOffset === b.byteOffset) return true;
      areArrays = true;
  }
  if (!areArrays) {
    if (typeof a != 'object' || typeof b != 'object') return false;

    // Objects with different constructors are not equivalent, but `Object`s or `Array`s
    // from different frames are.
    var aCtor = a.constructor, bCtor = b.constructor;
    if (aCtor !== bCtor && !(modules_isFunction(aCtor) && aCtor instanceof aCtor &&
                             modules_isFunction(bCtor) && bCtor instanceof bCtor)
                        && ('constructor' in a && 'constructor' in b)) {
      return false;
    }
  }
  // Assume equality for cyclic structures. The algorithm for detecting cyclic
  // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.

  // Initializing stack of traversed objects.
  // It's done here since we only need them for objects and arrays comparison.
  aStack = aStack || [];
  bStack = bStack || [];
  var length = aStack.length;
  while (length--) {
    // Linear search. Performance is inversely proportional to the number of
    // unique nested structures.
    if (aStack[length] === a) return bStack[length] === b;
  }

  // Add the first object to the stack of traversed objects.
  aStack.push(a);
  bStack.push(b);

  // Recursively compare objects and arrays.
  if (areArrays) {
    // Compare array lengths to determine if a deep comparison is necessary.
    length = a.length;
    if (length !== b.length) return false;
    // Deep compare the contents, ignoring non-numeric properties.
    while (length--) {
      if (!eq(a[length], b[length], aStack, bStack)) return false;
    }
  } else {
    // Deep compare objects.
    var _keys = keys(a), key;
    length = _keys.length;
    // Ensure that both objects contain the same number of properties before comparing deep equality.
    if (keys(b).length !== length) return false;
    while (length--) {
      // Deep compare each member
      key = _keys[length];
      if (!(has(b, key) && eq(a[key], b[key], aStack, bStack))) return false;
    }
  }
  // Remove the first object from the stack of traversed objects.
  aStack.pop();
  bStack.pop();
  return true;
}

// Perform a deep comparison to check if two objects are equal.
function isEqual(a, b) {
  return eq(a, b);
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/allKeys.js




// Retrieve all the enumerable property names of an object.
function allKeys(obj) {
  if (!isObject(obj)) return [];
  var keys = [];
  for (var key in obj) keys.push(key);
  // Ahem, IE < 9.
  if (hasEnumBug) collectNonEnumProps(obj, keys);
  return keys;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_methodFingerprint.js




// Since the regular `Object.prototype.toString` type tests don't work for
// some types in IE 11, we use a fingerprinting heuristic instead, based
// on the methods. It's not great, but it's the best we got.
// The fingerprint method lists are defined below.
function ie11fingerprint(methods) {
  var length = _getLength(methods);
  return function(obj) {
    if (obj == null) return false;
    // `Map`, `WeakMap` and `Set` have no enumerable keys.
    var keys = allKeys(obj);
    if (_getLength(keys)) return false;
    for (var i = 0; i < length; i++) {
      if (!modules_isFunction(obj[methods[i]])) return false;
    }
    // If we are testing against `WeakMap`, we need to ensure that
    // `obj` doesn't have a `forEach` method in order to distinguish
    // it from a regular `Map`.
    return methods !== weakMapMethods || !modules_isFunction(obj[forEachName]);
  };
}

// In the interest of compact minification, we write
// each string in the fingerprints only once.
var forEachName = 'forEach',
    hasName = 'has',
    commonInit = ['clear', 'delete'],
    mapTail = ['get', hasName, 'set'];

// `Map`, `WeakMap` and `Set` each have slightly different
// combinations of the above sublists.
var mapMethods = commonInit.concat(forEachName, mapTail),
    weakMapMethods = commonInit.concat(mapTail),
    setMethods = ['add'].concat(commonInit, forEachName, hasName);

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isMap.js




/* harmony default export */ const isMap = (isIE11 ? ie11fingerprint(mapMethods) : tagTester('Map'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isWeakMap.js




/* harmony default export */ const isWeakMap = (isIE11 ? ie11fingerprint(weakMapMethods) : tagTester('WeakMap'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isSet.js




/* harmony default export */ const isSet = (isIE11 ? ie11fingerprint(setMethods) : tagTester('Set'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/isWeakSet.js


/* harmony default export */ const isWeakSet = (tagTester('WeakSet'));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/values.js


// Retrieve the values of an object's properties.
function values(obj) {
  var _keys = keys(obj);
  var length = _keys.length;
  var values = Array(length);
  for (var i = 0; i < length; i++) {
    values[i] = obj[_keys[i]];
  }
  return values;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/pairs.js


// Convert an object into a list of `[key, value]` pairs.
// The opposite of `_.object` with one argument.
function pairs(obj) {
  var _keys = keys(obj);
  var length = _keys.length;
  var pairs = Array(length);
  for (var i = 0; i < length; i++) {
    pairs[i] = [_keys[i], obj[_keys[i]]];
  }
  return pairs;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/invert.js


// Invert the keys and values of an object. The values must be serializable.
function invert(obj) {
  var result = {};
  var _keys = keys(obj);
  for (var i = 0, length = _keys.length; i < length; i++) {
    result[obj[_keys[i]]] = _keys[i];
  }
  return result;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/functions.js


// Return a sorted list of the function names available on the object.
function functions(obj) {
  var names = [];
  for (var key in obj) {
    if (modules_isFunction(obj[key])) names.push(key);
  }
  return names.sort();
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_createAssigner.js
// An internal function for creating assigner functions.
function createAssigner(keysFunc, defaults) {
  return function(obj) {
    var length = arguments.length;
    if (defaults) obj = Object(obj);
    if (length < 2 || obj == null) return obj;
    for (var index = 1; index < length; index++) {
      var source = arguments[index],
          keys = keysFunc(source),
          l = keys.length;
      for (var i = 0; i < l; i++) {
        var key = keys[i];
        if (!defaults || obj[key] === void 0) obj[key] = source[key];
      }
    }
    return obj;
  };
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/extend.js



// Extend a given object with all the properties in passed-in object(s).
/* harmony default export */ const extend = (createAssigner(allKeys));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/extendOwn.js



// Assigns a given object with all the own properties in the passed-in
// object(s).
// (https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/assign)
/* harmony default export */ const extendOwn = (createAssigner(keys));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/defaults.js



// Fill in a given object with default properties.
/* harmony default export */ const defaults = (createAssigner(allKeys, true));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_baseCreate.js



// Create a naked function reference for surrogate-prototype-swapping.
function ctor() {
  return function(){};
}

// An internal function for creating a new object that inherits from another.
function baseCreate(prototype) {
  if (!isObject(prototype)) return {};
  if (nativeCreate) return nativeCreate(prototype);
  var Ctor = ctor();
  Ctor.prototype = prototype;
  var result = new Ctor;
  Ctor.prototype = null;
  return result;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/create.js



// Creates an object that inherits from the given prototype object.
// If additional properties are provided then they will be added to the
// created object.
function create(prototype, props) {
  var result = baseCreate(prototype);
  if (props) extendOwn(result, props);
  return result;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/clone.js




// Create a (shallow-cloned) duplicate of an object.
function clone(obj) {
  if (!isObject(obj)) return obj;
  return isArray(obj) ? obj.slice() : extend({}, obj);
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/tap.js
// Invokes `interceptor` with the `obj` and then returns `obj`.
// The primary purpose of this method is to "tap into" a method chain, in
// order to perform operations on intermediate results within the chain.
function tap(obj, interceptor) {
  interceptor(obj);
  return obj;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/toPath.js



// Normalize a (deep) property `path` to array.
// Like `_.iteratee`, this function can be customized.
function toPath(path) {
  return isArray(path) ? path : [path];
}
_.toPath = toPath;

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_toPath.js



// Internal wrapper for `_.toPath` to enable minification.
// Similar to `cb` for `_.iteratee`.
function _toPath_toPath(path) {
  return _.toPath(path);
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_deepGet.js
// Internal function to obtain a nested property in `obj` along `path`.
function deepGet(obj, path) {
  var length = path.length;
  for (var i = 0; i < length; i++) {
    if (obj == null) return void 0;
    obj = obj[path[i]];
  }
  return length ? obj : void 0;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/get.js




// Get the value of the (deep) property on `path` from `object`.
// If any property in `path` does not exist or if the value is
// `undefined`, return `defaultValue` instead.
// The `path` is normalized through `_.toPath`.
function get(object, path, defaultValue) {
  var value = deepGet(object, _toPath_toPath(path));
  return isUndefined(value) ? defaultValue : value;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/has.js



// Shortcut function for checking if an object has a given property directly on
// itself (in other words, not on a prototype). Unlike the internal `has`
// function, this public version can also traverse nested properties.
function has_has(obj, path) {
  path = _toPath_toPath(path);
  var length = path.length;
  for (var i = 0; i < length; i++) {
    var key = path[i];
    if (!has(obj, key)) return false;
    obj = obj[key];
  }
  return !!length;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/identity.js
// Keep the identity function around for default iteratees.
function identity(value) {
  return value;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/matcher.js



// Returns a predicate for checking whether an object has a given set of
// `key:value` pairs.
function matcher(attrs) {
  attrs = extendOwn({}, attrs);
  return function(obj) {
    return isMatch(obj, attrs);
  };
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/property.js



// Creates a function that, when passed an object, will traverse that object’s
// properties down the given `path`, specified as an array of keys or indices.
function property(path) {
  path = _toPath_toPath(path);
  return function(obj) {
    return deepGet(obj, path);
  };
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_optimizeCb.js
// Internal function that returns an efficient (for current engines) version
// of the passed-in callback, to be repeatedly applied in other Underscore
// functions.
function optimizeCb(func, context, argCount) {
  if (context === void 0) return func;
  switch (argCount == null ? 3 : argCount) {
    case 1: return function(value) {
      return func.call(context, value);
    };
    // The 2-argument case is omitted because we’re not using it.
    case 3: return function(value, index, collection) {
      return func.call(context, value, index, collection);
    };
    case 4: return function(accumulator, value, index, collection) {
      return func.call(context, accumulator, value, index, collection);
    };
  }
  return function() {
    return func.apply(context, arguments);
  };
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_baseIteratee.js








// An internal function to generate callbacks that can be applied to each
// element in a collection, returning the desired result — either `_.identity`,
// an arbitrary callback, a property matcher, or a property accessor.
function baseIteratee(value, context, argCount) {
  if (value == null) return identity;
  if (modules_isFunction(value)) return optimizeCb(value, context, argCount);
  if (isObject(value) && !isArray(value)) return matcher(value);
  return property(value);
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/iteratee.js



// External wrapper for our callback generator. Users may customize
// `_.iteratee` if they want additional predicate/iteratee shorthand styles.
// This abstraction hides the internal-only `argCount` argument.
function iteratee(value, context) {
  return baseIteratee(value, context, Infinity);
}
_.iteratee = iteratee;

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_cb.js




// The function we call internally to generate a callback. It invokes
// `_.iteratee` if overridden, otherwise `baseIteratee`.
function cb(value, context, argCount) {
  if (_.iteratee !== iteratee) return _.iteratee(value, context);
  return baseIteratee(value, context, argCount);
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/mapObject.js



// Returns the results of applying the `iteratee` to each element of `obj`.
// In contrast to `_.map` it returns an object.
function mapObject(obj, iteratee, context) {
  iteratee = cb(iteratee, context);
  var _keys = keys(obj),
      length = _keys.length,
      results = {};
  for (var index = 0; index < length; index++) {
    var currentKey = _keys[index];
    results[currentKey] = iteratee(obj[currentKey], currentKey, obj);
  }
  return results;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/noop.js
// Predicate-generating function. Often useful outside of Underscore.
function noop(){}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/propertyOf.js



// Generates a function for a given object that returns a given property.
function propertyOf(obj) {
  if (obj == null) return noop;
  return function(path) {
    return get(obj, path);
  };
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/times.js


// Run a function **n** times.
function times(n, iteratee, context) {
  var accum = Array(Math.max(0, n));
  iteratee = optimizeCb(iteratee, context, 1);
  for (var i = 0; i < n; i++) accum[i] = iteratee(i);
  return accum;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/random.js
// Return a random integer between `min` and `max` (inclusive).
function random(min, max) {
  if (max == null) {
    max = min;
    min = 0;
  }
  return min + Math.floor(Math.random() * (max - min + 1));
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/now.js
// A (possibly faster) way to get the current timestamp as an integer.
/* harmony default export */ const now = (Date.now || function() {
  return new Date().getTime();
});

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_createEscaper.js


// Internal helper to generate functions for escaping and unescaping strings
// to/from HTML interpolation.
function createEscaper(map) {
  var escaper = function(match) {
    return map[match];
  };
  // Regexes for identifying a key that needs to be escaped.
  var source = '(?:' + keys(map).join('|') + ')';
  var testRegexp = RegExp(source);
  var replaceRegexp = RegExp(source, 'g');
  return function(string) {
    string = string == null ? '' : '' + string;
    return testRegexp.test(string) ? string.replace(replaceRegexp, escaper) : string;
  };
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_escapeMap.js
// Internal list of HTML entities for escaping.
/* harmony default export */ const _escapeMap = ({
  '&': '&amp;',
  '<': '&lt;',
  '>': '&gt;',
  '"': '&quot;',
  "'": '&#x27;',
  '`': '&#x60;'
});

;// CONCATENATED MODULE: ./node_modules/underscore/modules/escape.js



// Function for escaping strings to HTML interpolation.
/* harmony default export */ const modules_escape = (createEscaper(_escapeMap));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_unescapeMap.js



// Internal list of HTML entities for unescaping.
/* harmony default export */ const _unescapeMap = (invert(_escapeMap));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/unescape.js



// Function for unescaping strings from HTML interpolation.
/* harmony default export */ const modules_unescape = (createEscaper(_unescapeMap));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/templateSettings.js


// By default, Underscore uses ERB-style template delimiters. Change the
// following template settings to use alternative delimiters.
/* harmony default export */ const templateSettings = (_.templateSettings = {
  evaluate: /<%([\s\S]+?)%>/g,
  interpolate: /<%=([\s\S]+?)%>/g,
  escape: /<%-([\s\S]+?)%>/g
});

;// CONCATENATED MODULE: ./node_modules/underscore/modules/template.js




// When customizing `_.templateSettings`, if you don't want to define an
// interpolation, evaluation or escaping regex, we need one that is
// guaranteed not to match.
var noMatch = /(.)^/;

// Certain characters need to be escaped so that they can be put into a
// string literal.
var escapes = {
  "'": "'",
  '\\': '\\',
  '\r': 'r',
  '\n': 'n',
  '\u2028': 'u2028',
  '\u2029': 'u2029'
};

var escapeRegExp = /\\|'|\r|\n|\u2028|\u2029/g;

function escapeChar(match) {
  return '\\' + escapes[match];
}

// JavaScript micro-templating, similar to John Resig's implementation.
// Underscore templating handles arbitrary delimiters, preserves whitespace,
// and correctly escapes quotes within interpolated code.
// NB: `oldSettings` only exists for backwards compatibility.
function template(text, settings, oldSettings) {
  if (!settings && oldSettings) settings = oldSettings;
  settings = defaults({}, settings, _.templateSettings);

  // Combine delimiters into one regular expression via alternation.
  var matcher = RegExp([
    (settings.escape || noMatch).source,
    (settings.interpolate || noMatch).source,
    (settings.evaluate || noMatch).source
  ].join('|') + '|$', 'g');

  // Compile the template source, escaping string literals appropriately.
  var index = 0;
  var source = "__p+='";
  text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {
    source += text.slice(index, offset).replace(escapeRegExp, escapeChar);
    index = offset + match.length;

    if (escape) {
      source += "'+\n((__t=(" + escape + "))==null?'':_.escape(__t))+\n'";
    } else if (interpolate) {
      source += "'+\n((__t=(" + interpolate + "))==null?'':__t)+\n'";
    } else if (evaluate) {
      source += "';\n" + evaluate + "\n__p+='";
    }

    // Adobe VMs need the match returned to produce the correct offset.
    return match;
  });
  source += "';\n";

  // If a variable is not specified, place data values in local scope.
  if (!settings.variable) source = 'with(obj||{}){\n' + source + '}\n';

  source = "var __t,__p='',__j=Array.prototype.join," +
    "print=function(){__p+=__j.call(arguments,'');};\n" +
    source + 'return __p;\n';

  var render;
  try {
    render = new Function(settings.variable || 'obj', '_', source);
  } catch (e) {
    e.source = source;
    throw e;
  }

  var template = function(data) {
    return render.call(this, data, _);
  };

  // Provide the compiled source as a convenience for precompilation.
  var argument = settings.variable || 'obj';
  template.source = 'function(' + argument + '){\n' + source + '}';

  return template;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/result.js



// Traverses the children of `obj` along `path`. If a child is a function, it
// is invoked with its parent as context. Returns the value of the final
// child, or `fallback` if any child is undefined.
function result(obj, path, fallback) {
  path = _toPath_toPath(path);
  var length = path.length;
  if (!length) {
    return modules_isFunction(fallback) ? fallback.call(obj) : fallback;
  }
  for (var i = 0; i < length; i++) {
    var prop = obj == null ? void 0 : obj[path[i]];
    if (prop === void 0) {
      prop = fallback;
      i = length; // Ensure we don't continue iterating.
    }
    obj = modules_isFunction(prop) ? prop.call(obj) : prop;
  }
  return obj;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/uniqueId.js
// Generate a unique integer id (unique within the entire client session).
// Useful for temporary DOM ids.
var idCounter = 0;
function uniqueId(prefix) {
  var id = ++idCounter + '';
  return prefix ? prefix + id : id;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/chain.js


// Start chaining a wrapped Underscore object.
function chain(obj) {
  var instance = _(obj);
  instance._chain = true;
  return instance;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_executeBound.js



// Internal function to execute `sourceFunc` bound to `context` with optional
// `args`. Determines whether to execute a function as a constructor or as a
// normal function.
function executeBound(sourceFunc, boundFunc, context, callingContext, args) {
  if (!(callingContext instanceof boundFunc)) return sourceFunc.apply(context, args);
  var self = baseCreate(sourceFunc.prototype);
  var result = sourceFunc.apply(self, args);
  if (isObject(result)) return result;
  return self;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/partial.js




// Partially apply a function by creating a version that has had some of its
// arguments pre-filled, without changing its dynamic `this` context. `_` acts
// as a placeholder by default, allowing any combination of arguments to be
// pre-filled. Set `_.partial.placeholder` for a custom placeholder argument.
var partial = restArguments(function(func, boundArgs) {
  var placeholder = partial.placeholder;
  var bound = function() {
    var position = 0, length = boundArgs.length;
    var args = Array(length);
    for (var i = 0; i < length; i++) {
      args[i] = boundArgs[i] === placeholder ? arguments[position++] : boundArgs[i];
    }
    while (position < arguments.length) args.push(arguments[position++]);
    return executeBound(func, bound, this, this, args);
  };
  return bound;
});

partial.placeholder = _;
/* harmony default export */ const modules_partial = (partial);

;// CONCATENATED MODULE: ./node_modules/underscore/modules/bind.js




// Create a function bound to a given object (assigning `this`, and arguments,
// optionally).
/* harmony default export */ const bind = (restArguments(function(func, context, args) {
  if (!modules_isFunction(func)) throw new TypeError('Bind must be called on a function');
  var bound = restArguments(function(callArgs) {
    return executeBound(func, bound, context, this, args.concat(callArgs));
  });
  return bound;
}));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_isArrayLike.js



// Internal helper for collection methods to determine whether a collection
// should be iterated as an array or as an object.
// Related: https://people.mozilla.org/~jorendorff/es6-draft.html#sec-tolength
// Avoids a very nasty iOS 8 JIT bug on ARM-64. #2094
/* harmony default export */ const _isArrayLike = (createSizePropertyCheck(_getLength));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/_flatten.js





// Internal implementation of a recursive `flatten` function.
function flatten(input, depth, strict, output) {
  output = output || [];
  if (!depth && depth !== 0) {
    depth = Infinity;
  } else if (depth <= 0) {
    return output.concat(input);
  }
  var idx = output.length;
  for (var i = 0, length = _getLength(input); i < length; i++) {
    var value = input[i];
    if (_isArrayLike(value) && (isArray(value) || modules_isArguments(value))) {
      // Flatten current level of array or arguments object.
      if (depth > 1) {
        flatten(value, depth - 1, strict, output);
        idx = output.length;
      } else {
        var j = 0, len = value.length;
        while (j < len) output[idx++] = value[j++];
      }
    } else if (!strict) {
      output[idx++] = value;
    }
  }
  return output;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/bindAll.js




// Bind a number of an object's methods to that object. Remaining arguments
// are the method names to be bound. Useful for ensuring that all callbacks
// defined on an object belong to it.
/* harmony default export */ const bindAll = (restArguments(function(obj, keys) {
  keys = flatten(keys, false, false);
  var index = keys.length;
  if (index < 1) throw new Error('bindAll must be passed function names');
  while (index--) {
    var key = keys[index];
    obj[key] = bind(obj[key], obj);
  }
  return obj;
}));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/memoize.js


// Memoize an expensive function by storing its results.
function memoize(func, hasher) {
  var memoize = function(key) {
    var cache = memoize.cache;
    var address = '' + (hasher ? hasher.apply(this, arguments) : key);
    if (!has(cache, address)) cache[address] = func.apply(this, arguments);
    return cache[address];
  };
  memoize.cache = {};
  return memoize;
}

;// CONCATENATED MODULE: ./node_modules/underscore/modules/delay.js


// Delays a function for the given number of milliseconds, and then calls
// it with the arguments supplied.
/* harmony default export */ const delay = (restArguments(function(func, wait, args) {
  return setTimeout(function() {
    return func.apply(null, args);
  }, wait);
}));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/defer.js




// Defers a function, scheduling it to run after the current call stack has
// cleared.
/* harmony default export */ const defer = (modules_partial(delay, _, 1));

;// CONCATENATED MODULE: ./node_modules/underscore/modules/throttle.js


// Returns a function, that, when invoked, will only be triggered at most once
// during a given window of time. Normally, the throttled function will run
// as much as it can, without ever going more than once per `wait` duration;
// but if you'd like to disable the execution on the leading edge, pass
// `{leading: false}`. To disable execution on the trailing edge, ditto.
function throttle(func, wait, options) {
  var timeout, context, args, result;
  var previous = 0;
  if (!options) options = {};

  var later = function() {
    previous = options.leading === false ? 0 : now();
    timeout = null;
    result = func.apply(context, args);
    if (!timeout) context = args = null;
  };

  var throttled = function() {
    var _now = now();
    if (!previous && options.leading === false) previous = _now;
    var remaining = wait - (_now - previous);
    context = this;
    args = arguments;
    if (remaining <= 0 || remaining > wait) {
      if (timeout) {
        clearTimeout(timeout);
        timeout = null;
      }
      previous = _now;
      result = func.apply(context, args);
      if (!timeout) context = args = null;
    } else if (!timeout && options.trailing !== false) {
      timeout = setTimeout(later, 