"use strict";
(globalThis["webpackChunkunblock"] = globalThis["webpackChunkunblock"] || []).push([[2825],{

/***/ 68073:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ ModalTrigger)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67294);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45697);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var src_components_Modal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(74069);
/* harmony import */ var src_components_Button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35932);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11965);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */





const propTypes = {
  dialogClassName: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  triggerNode: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node.isRequired),
  modalTitle: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),
  modalBody: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node), // not required because it can be generated by beforeOpen
  modalFooter: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),
  beforeOpen: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),
  onExit: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),
  isButton: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  tooltip: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  maxWidth: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  responsive: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  resizable: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  resizableConfig: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  draggable: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  draggableConfig: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object) };


const defaultProps = {
  beforeOpen: () => {},
  onExit: () => {},
  isButton: false,
  className: '',
  modalTitle: '',
  resizable: false,
  draggable: false };


class ModalTrigger extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
  constructor(props) {
    super(props);
    this.state = {
      showModal: false };

    this.open = this.open.bind(this);
    this.close = this.close.bind(this);
  }

  close() {
    this.setState(() => ({ showModal: false }));
  }

  open(e) {
    e.preventDefault();
    this.props.beforeOpen();
    this.setState(() => ({ showModal: true }));
  }

  renderModal() {
    return (
      (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)(src_components_Modal__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        wrapClassName: this.props.dialogClassName,
        className: this.props.className,
        show: this.state.showModal,
        onHide: this.close,
        afterClose: this.props.onExit,
        title: this.props.modalTitle,
        footer: this.props.modalFooter,
        hideFooter: !this.props.modalFooter,
        width: this.props.width,
        maxWidth: this.props.maxWidth,
        responsive: this.props.responsive,
        resizable: this.props.resizable,
        resizableConfig: this.props.resizableConfig,
        draggable: this.props.draggable,
        draggableConfig: this.props.draggableConfig },

      this.props.modalBody));


  }

  render() {
    if (this.props.isButton) {
      return (
        (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
        (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)(src_components_Button__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
          className: "modal-trigger",

          tooltip: this.props.tooltip,
          onClick: this.open },

        this.props.triggerNode),

        this.renderModal()));


    }
    /* eslint-disable jsx-a11y/interactive-supports-focus */
    return (
      (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
      (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", { onClick: this.open, role: "button" },
      this.props.triggerNode),

      this.renderModal()));


  }}


ModalTrigger.propTypes = propTypes;
ModalTrigger.defaultProps = defaultProps;

/***/ }),

/***/ 75017:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ OnPasteSelect)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5872);
/* harmony import */ var _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67294);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45697);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var src_components_Select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(79676);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11965);
 /**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




class OnPasteSelect extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
  constructor(props) {
    super(props);
    this.onPaste = this.onPaste.bind(this);
  }

  onPaste(evt) {
    if (!this.props.isMulti) {
      return;
    }
    evt.preventDefault();
    const clipboard = evt.clipboardData.getData('Text');
    if (!clipboard) {
      return;
    }
    const regex = `[${this.props.separator}]+`;
    const values = clipboard.split(new RegExp(regex)).map((v) => v.trim());
    const validator = this.props.isValidNewOption;
    const selected = this.props.value || [];
    const existingOptions = {};
    const existing = {};
    this.props.options.forEach((v) => {
      existingOptions[v[this.props.valueKey]] = 1;
    });
    let options = [];
    selected.forEach((v) => {
      options.push({ [this.props.labelKey]: v, [this.props.valueKey]: v });
      existing[v] = 1;
    });
    options = options.concat(
    values.
    filter((v) => {
      const notExists = !existing[v];
      existing[v] = 1;
      return (
        notExists && (
        validator ? validator({ [this.props.labelKey]: v }) : !!v));

    }).
    map((v) => {
      const opt = { [this.props.labelKey]: v, [this.props.valueKey]: v };
      if (!existingOptions[v]) {
        this.props.options.unshift(opt);
      }
      return opt;
    }));

    if (options.length) {
      if (this.props.onChange) {
        this.props.onChange(options);
      }
    }
  }

  render() {
    const { selectWrap: SelectComponent, ...restProps } = this.props;
    return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)(SelectComponent, _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default()({}, restProps, { onPaste: this.onPaste }));
  }}


OnPasteSelect.propTypes = {
  separator: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().array),
  selectWrap: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().elementType),
  selectRef: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func.isRequired),
  valueKey: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  labelKey: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  options: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().array),
  isMulti: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  value: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().any),
  isValidNewOption: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func),
  noResultsText: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  forceOverflow: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool) };

OnPasteSelect.defaultProps = {
  separator: [',', '\n', '\t', ';'],
  selectWrap: src_components_Select__WEBPACK_IMPORTED_MODULE_3__/* .Select */ .OC,
  valueKey: 'value',
  labelKey: 'label',
  options: [],
  isMulti: false };

/***/ }),

/***/ 1836:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "zQ": () => (/* binding */ fDuration),
/* harmony export */   "zO": () => (/* binding */ now),
/* harmony export */   "xG": () => (/* binding */ epochTimeXHoursAgo),
/* harmony export */   "x_": () => (/* binding */ epochTimeXDaysAgo),
/* harmony export */   "pu": () => (/* binding */ epochTimeXYearsAgo)
/* harmony export */ });
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(30381);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const fDuration = function (t1, t2, format = 'HH:mm:ss.SS') {
  const diffSec = t2 - t1;
  const duration = moment__WEBPACK_IMPORTED_MODULE_0___default()(new Date(diffSec));
  return duration.utc().format(format);
};

const now = function () {
  // seconds from EPOCH as a float
  return moment__WEBPACK_IMPORTED_MODULE_0___default()().utc().valueOf();
};

const epochTimeXHoursAgo = function (h) {
  return moment__WEBPACK_IMPORTED_MODULE_0___default()().subtract(h, 'hours').utc().valueOf();
};

const epochTimeXDaysAgo = function (d) {
  return moment__WEBPACK_IMPORTED_MODULE_0___default()().subtract(d, 'days').utc().valueOf();
};

const epochTimeXYearsAgo = function (y) {
  return moment__WEBPACK_IMPORTED_MODULE_0___default()().subtract(y, 'years').utc().valueOf();
};

/***/ }),

/***/ 44904:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IY": () => (/* binding */ STATE_TYPE_MAP),
/* harmony export */   "Em": () => (/* binding */ STATUS_OPTIONS),
/* harmony export */   "v3": () => (/* binding */ TIME_OPTIONS),
/* harmony export */   "eU": () => (/* binding */ SQL_EDITOR_GUTTER_HEIGHT),
/* harmony export */   "ev": () => (/* binding */ SQL_EDITOR_GUTTER_MARGIN),
/* harmony export */   "rp": () => (/* binding */ SQL_TOOLBAR_HEIGHT),
/* harmony export */   "Yo": () => (/* binding */ KB_STORAGE),
/* harmony export */   "TU": () => (/* binding */ BYTES_PER_CHAR),
/* harmony export */   "U$": () => (/* binding */ LOCALSTORAGE_MAX_QUERY_AGE_MS),
/* harmony export */   "b$": () => (/* binding */ LOCALSTORAGE_MAX_USAGE_KB),
/* harmony export */   "rD": () => (/* binding */ LOCALSTORAGE_WARNING_THRESHOLD),
/* harmony export */   "N2": () => (/* binding */ LOCALSTORAGE_WARNING_MESSAGE_THROTTLE_MS),
/* harmony export */   "Yn": () => (/* binding */ SQL_KEYWORD_AUTOCOMPLETE_SCORE),
/* harmony export */   "GJ": () => (/* binding */ SQL_FUNCTIONS_AUTOCOMPLETE_SCORE),
/* harmony export */   "iJ": () => (/* binding */ SCHEMA_AUTOCOMPLETE_SCORE),
/* harmony export */   "lr": () => (/* binding */ TABLE_AUTOCOMPLETE_SCORE),
/* harmony export */   "OI": () => (/* binding */ COLUMN_AUTOCOMPLETE_SCORE)
/* harmony export */ });
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const STATE_TYPE_MAP = {
  offline: 'danger',
  failed: 'danger',
  pending: 'info',
  fetching: 'info',
  running: 'warning',
  stopped: 'danger',
  success: 'success' };

const STATUS_OPTIONS = {
  success: 'success',
  failed: 'failed',
  running: 'running',
  offline: 'offline',
  pending: 'pending' };

const TIME_OPTIONS = [
'now',
'1 hour ago',
'1 day ago',
'7 days ago',
'28 days ago',
'90 days ago',
'1 year ago'];

// SqlEditor layout constants
const SQL_EDITOR_GUTTER_HEIGHT = 5;
const SQL_EDITOR_GUTTER_MARGIN = 3;
const SQL_TOOLBAR_HEIGHT = 51;
// kilobyte storage
const KB_STORAGE = 1024;
const BYTES_PER_CHAR = 2;
// browser's localStorage max usage constants
const LOCALSTORAGE_MAX_QUERY_AGE_MS = 24 * 60 * 60 * 1000; // 24 hours
const LOCALSTORAGE_MAX_USAGE_KB = 5 * 1024; // 5M
const LOCALSTORAGE_WARNING_THRESHOLD = 0.9;
const LOCALSTORAGE_WARNING_MESSAGE_THROTTLE_MS = 8000; // danger type toast duration
// autocomplete score weights
const SQL_KEYWORD_AUTOCOMPLETE_SCORE = 100;
const SQL_FUNCTIONS_AUTOCOMPLETE_SCORE = 90;
const SCHEMA_AUTOCOMPLETE_SCORE = 60;
const TABLE_AUTOCOMPLETE_SCORE = 55;
const COLUMN_AUTOCOMPLETE_SCORE = 50;

/***/ }),

/***/ 33313:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44904);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

const SQL_KEYWORDS = [
'AND',
'AS',
'ASC',
'AVG',
'BY',
'CASE',
'COUNT',
'CREATE',
'CROSS',
'DATABASE',
'DEFAULT',
'DELETE',
'DESC',
'DISTINCT',
'DROP',
'ELSE',
'END',
'FOREIGN',
'FROM',
'GRANT',
'GROUP',
'HAVING',
'IF',
'INNER',
'INSERT',
'JOIN',
'KEY',
'LEFT',
'LIMIT',
'MAX',
'MIN',
'NATURAL',
'NOT',
'NULL',
'OFFSET',
'ON',
'OR',
'ORDER',
'OUTER',
'PRIMARY',
'REFERENCES',
'RIGHT',
'SELECT',
'SUM',
'TABLE',
'THEN',
'TYPE',
'UNION',
'UPDATE',
'WHEN',
'WHERE'];

const SQL_DATA_TYPES = [
'BIGINT',
'BINARY',
'BIT',
'CHAR',
'DATE',
'DECIMAL',
'DOUBLE',
'FLOAT',
'INT',
'INTEGER',
'MONEY',
'NUMBER',
'NUMERIC',
'REAL',
'SET',
'TEXT',
'TIMESTAMP',
'VARCHAR'];

const allKeywords = SQL_KEYWORDS.concat(SQL_DATA_TYPES);
const sqlKeywords = allKeywords.map((keyword) => ({
  meta: 'sql',
  name: keyword,
  score: _constants__WEBPACK_IMPORTED_MODULE_0__/* .SQL_KEYWORD_AUTOCOMPLETE_SCORE */ .Yn,
  value: keyword }));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (sqlKeywords);

/***/ }),

/***/ 29487:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Alert)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5872);
/* harmony import */ var _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11965);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67294);
/* harmony import */ var src_common_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(82191);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(37840);
/* harmony import */ var src_components_Icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38097);
 /**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




function Alert(props) {
  const { type = 'info', description, showIcon = true, closable = true, roomBelow = false, children } = props;
  const theme = (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_4__/* .useTheme */ .Fg)();
  const { colors, typography, gridUnit } = theme;
  const { alert, error, info, success } = colors;
  let baseColor = info;
  let AlertIcon = src_components_Icons__WEBPACK_IMPORTED_MODULE_3__/* ["default"].InfoSolid */ .Z.InfoSolid;
  if (type === 'error') {
    baseColor = error;
    AlertIcon = src_components_Icons__WEBPACK_IMPORTED_MODULE_3__/* ["default"].ErrorSolid */ .Z.ErrorSolid;
  } else
  if (type === 'warning') {
    baseColor = alert;
    AlertIcon = src_components_Icons__WEBPACK_IMPORTED_MODULE_3__/* ["default"].AlertSolid */ .Z.AlertSolid;
  } else
  if (type === 'success') {
    baseColor = success;
    AlertIcon = src_components_Icons__WEBPACK_IMPORTED_MODULE_3__/* ["default"].CircleCheckSolid */ .Z.CircleCheckSolid;
  }
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_5__.jsx)(src_common_components__WEBPACK_IMPORTED_MODULE_2__/* .Alert */ .bZ, _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default()({ role: "alert", showIcon: showIcon, icon: (0,_emotion_react__WEBPACK_IMPORTED_MODULE_5__.jsx)(AlertIcon, { "aria-label": `${type} icon` }), closeText: closable && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_5__.jsx)(src_components_Icons__WEBPACK_IMPORTED_MODULE_3__/* ["default"].XSmall */ .Z.XSmall, { "aria-label": "close icon" }), css: /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_5__.css)({
      marginBottom: roomBelow ? gridUnit * 4 : 0,
      padding: `${gridUnit * 2}px ${gridUnit * 3}px`,
      alignItems: 'flex-start',
      border: 0,
      backgroundColor: baseColor.light2,
      '& .ant-alert-icon': {
        marginRight: gridUnit * 2 },

      '& .ant-alert-message': {
        color: baseColor.dark2,
        fontSize: typography.sizes.m,
        fontWeight: description ?
        typography.weights.bold :
        typography.weights.normal },

      '& .ant-alert-description': {
        color: baseColor.dark2,
        fontSize: typography.sizes.m } },  true ? "" : 0,  true ? "" : 0) },

  props),
  children);

}

/***/ }),

/***/ 94670:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "iO": () => (/* binding */ SQLEditor),
/* harmony export */   "up": () => (/* binding */ FullSQLEditor),
/* harmony export */   "cE": () => (/* binding */ MarkdownEditor),
/* harmony export */   "YH": () => (/* binding */ TextAreaEditor),
/* harmony export */   "ry": () => (/* binding */ CssEditor),
/* harmony export */   "Ad": () => (/* binding */ JsonEditor),
/* harmony export */   "Z5": () => (/* binding */ ConfigEditor)
/* harmony export */ });
/* unused harmony export default */
/* harmony import */ var _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5872);
/* harmony import */ var _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(15306);
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67294);
/* harmony import */ var src_components_AsyncEsmComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(67913);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11965);
 /**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


/**
 * Async loaders to import brace modules. Must manually create call `import(...)`
 * promises because webpack can only analyze asycn imports statically.
 */
const aceModuleLoaders = {
  'mode/sql': () => __webpack_require__.e(/* import() */ 8883).then(__webpack_require__.t.bind(__webpack_require__, 48883, 23)),
  'mode/markdown': () => Promise.all(/* import() */[__webpack_require__.e(9794), __webpack_require__.e(5802), __webpack_require__.e(4832), __webpack_require__.e(6061)]).then(__webpack_require__.t.bind(__webpack_require__, 66061, 23)),
  'mode/css': () => Promise.all(/* import() */[__webpack_require__.e(5802), __webpack_require__.e(4972)]).then(__webpack_require__.t.bind(__webpack_require__, 94972, 23)),
  'mode/json': () => __webpack_require__.e(/* import() */ 8750).then(__webpack_require__.t.bind(__webpack_require__, 58750, 23)),
  'mode/yaml': () => __webpack_require__.e(/* import() */ 6977).then(__webpack_require__.t.bind(__webpack_require__, 60741, 23)),
  'mode/html': () => Promise.all(/* import() */[__webpack_require__.e(9794), __webpack_require__.e(5802), __webpack_require__.e(4832), __webpack_require__.e(1258)]).then(__webpack_require__.t.bind(__webpack_require__, 71258, 23)),
  'mode/javascript': () => Promise.all(/* import() */[__webpack_require__.e(9794), __webpack_require__.e(4579)]).then(__webpack_require__.t.bind(__webpack_require__, 54579, 23)),
  'theme/textmate': () => __webpack_require__.e(/* import() */ 2089).then(__webpack_require__.t.bind(__webpack_require__, 2089, 23)),
  'theme/github': () => __webpack_require__.e(/* import() */ 440).then(__webpack_require__.t.bind(__webpack_require__, 50440, 23)),
  'ext/language_tools': () => __webpack_require__.e(/* import() */ 5335).then(__webpack_require__.t.bind(__webpack_require__, 75335, 23)) };

/**
 * Get an async AceEditor with automatical loading of specified ace modules.
 */
function AsyncAceEditor(aceModules, { defaultMode, defaultTheme, defaultTabSize = 2, placeholder } = {}) {
  return (0,src_components_AsyncEsmComponent__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(async () => {var _aceModules$find, _aceModules$find2;
    const { default: ace } = await __webpack_require__.e(/* import() */ 8616).then(__webpack_require__.t.bind(__webpack_require__, 38616, 23));
    const { default: ReactAceEditor } = await Promise.all(/* import() */[__webpack_require__.e(1216), __webpack_require__.e(4981)]).then(__webpack_require__.bind(__webpack_require__, 74981));
    await Promise.all(aceModules.map((x) => aceModuleLoaders[x]()));
    const inferredMode = defaultMode || ((_aceModules$find =
    aceModules.find((x) => x.startsWith('mode/'))) == null ? void 0 : _aceModules$find.replace('mode/', ''));
    const inferredTheme = defaultTheme || ((_aceModules$find2 =
    aceModules.find((x) => x.startsWith('theme/'))) == null ? void 0 : _aceModules$find2.replace('theme/', ''));
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.forwardRef(function ExtendedAceEditor({ keywords, mode = inferredMode, theme = inferredTheme, tabSize = defaultTabSize, defaultValue = '', ...props }, ref) {
      if (keywords) {
        const langTools = ace.acequire('ace/ext/language_tools');
        const completer = {
          getCompletions: (editor, session, pos, prefix, callback) => {
            // If the prefix starts with a number, don't try to autocomplete
            if (!Number.isNaN(parseInt(prefix, 10))) {
              return;
            }
            if (session.getMode().$id === `ace/mode/${mode}`) {
              callback(null, keywords);
            }
          } };

        langTools.setCompleters([completer]);
      }
      return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)(ReactAceEditor, _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default()({ ref: ref, mode: mode, theme: theme, tabSize: tabSize, defaultValue: defaultValue }, props));
    });
  }, placeholder);
}
const SQLEditor = AsyncAceEditor([
'mode/sql',
'theme/github',
'ext/language_tools']);

const FullSQLEditor = AsyncAceEditor(['mode/sql', 'theme/github', 'ext/language_tools'], {
  // a custom placeholder in SQL lab for less jumpy re-renders
  placeholder: () => {
    const gutterBackground = '#e8e8e8'; // from ace-github theme
    return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", { style: {
        height: '100%' } },

    (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", { style: { width: 41, height: '100%', background: gutterBackground } }),

    (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", { className: "ace_content" }));

  } });

const MarkdownEditor = AsyncAceEditor([
'mode/markdown',
'theme/textmate']);

const TextAreaEditor = AsyncAceEditor([
'mode/markdown',
'mode/sql',
'mode/json',
'mode/html',
'mode/javascript',
'theme/textmate']);

const CssEditor = AsyncAceEditor(['mode/css', 'theme/github']);
const JsonEditor = AsyncAceEditor(['mode/json', 'theme/github']);
/**
 * JSON or Yaml config editor.
 */
const ConfigEditor = AsyncAceEditor([
'mode/json',
'mode/yaml',
'theme/github']);

/***/ }),

/***/ 67913:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ AsyncEsmComponent)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5872);
/* harmony import */ var _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67294);
/* harmony import */ var _Loading__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38703);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11965);
 /**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


function DefaultPlaceholder({ width, height, showLoadingForImport = false, placeholderStyle: style }) {
  return (
    // since `width` defaults to 100%, we can display the placeholder once
    // height is specified.
    height && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", { key: "async-asm-placeholder", style: { width, height, ...style } },
    showLoadingForImport && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Loading__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, { position: "floating" })) ||

    // `|| null` is for in case of height=0.
    null);
}
/**
 * Asynchronously import an ES module as a React component, render a placeholder
 * first (if provided) and re-render once import is complete.
 */
function AsyncEsmComponent(
/**
 * A promise generator that returns the React component to render.
 */
loadComponent,
/**
 * Placeholder while still importing.
 */
placeholder = DefaultPlaceholder) {
  let promise;
  let component;
  /**
   * Safely wait for promise, make sure the loader function only execute once.
   */
  function waitForPromise() {
    if (!promise) {
      // load component on initialization
      promise =
      loadComponent instanceof Promise ? loadComponent : loadComponent();
    }
    if (!component) {
      promise.then((result) => {
        component = result.default ||
        result;
      });
    }
    return promise;
  }
  const AsyncComponent = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.forwardRef(function AsyncComponent(props, ref) {
    const [loaded, setLoaded] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(component !== undefined);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      let isMounted = true;
      if (!loaded) {
        // update state to trigger a re-render
        waitForPromise().then(() => {
          if (isMounted) {
            setLoaded(true);
          }
        });
      }
      return () => {
        isMounted = false;
      };
    });
    const Component = component || placeholder;
    return Component ?
    // placeholder does not get the ref
    (0,_emotion_react__WEBPACK_IMPORTED_MODULE_3__.jsx)(Component, _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default()({ ref: Component === component ? ref : null }, props)) : null;
  });
  // preload the async component before rendering
  AsyncComponent.preload = waitForPromise;
  return AsyncComponent;
}

/***/ }),

/***/ 72875:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ ErrorMessageWithStackTrace)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67294);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(60650);
/* harmony import */ var _getErrorMessageComponentRegistry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(92869);
/* harmony import */ var _ErrorAlert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(91178);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11965);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const DEFAULT_TITLE = (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__.t)('Unexpected error');
function ErrorMessageWithStackTrace({ title = DEFAULT_TITLE, error, subtitle, copyText, link, stackTrace, source }) {
  // Check if a custom error message component was registered for this message
  if (error) {
    const ErrorMessageComponent = (0,_getErrorMessageComponentRegistry__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)().get(error.error_type);
    if (ErrorMessageComponent) {
      return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)(ErrorMessageComponent, { error: error, source: source, subtitle: subtitle });
    }
  }
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)(_ErrorAlert__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, { level: "warning", title: title, subtitle: subtitle, copyText: copyText, source: source, body: link || stackTrace ? (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
    link && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)("a", { href: link, target: "_blank", rel: "noopener noreferrer" }, "(Request Access)"),


    (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)("br", null),
    stackTrace && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)("pre", null, stackTrace)) :
    undefined });
}

/***/ }),

/***/ 38703:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Loading)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67294);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(37840);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94184);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11965);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const LoaderImg = _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__/* .styled.img */ .iK.img`
  z-index: 99;
  width: 50px;
  position: relative;
  margin: 10px;
  &.inline {
    margin: 0px;
    width: 30px;
  }
  &.inline-centered {
    margin: 0 auto;
    width: 30px;
    display: block;
  }
  &.floating {
    padding: 0;
    margin: 0;
    position: absolute;
    left: 50%;
    top: 50%;
    transform: translate(-50%, -50%);
  }
`;
function Loading({ position = 'floating', image = '/static/assets/images/loading.gif', className }) {
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_3__.jsx)(LoaderImg, { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('loading', position, className), alt: "Loading...", src: image, role: "status", "aria-live": "polite", "aria-label": "Loading" });
}

/***/ }),

/***/ 79676:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "JY": () => (/* reexport */ AsyncCreatableSelect),
  "a7": () => (/* reexport */ CreatableSelect),
  "OC": () => (/* reexport */ Select),
  "ZP": () => (/* reexport */ DeprecatedSelect)
});

// UNUSED EXPORTS: AsyncSelect, DEFAULT_CLASS_NAME, DEFAULT_CLASS_NAME_PREFIX, DEFAULT_COMPONENTS, DEFAULT_STYLES, NativeGraySelect, NativeSelect, OnPasteSelect, PaginatedSelect, VALUE_LABELED_STYLES, defaultTheme

// EXTERNAL MODULE: ./node_modules/@babel/runtime-corejs3/helpers/extends.js
var helpers_extends = __webpack_require__(5872);
var extends_default = /*#__PURE__*/__webpack_require__.n(helpers_extends);
// EXTERNAL MODULE: ./node_modules/lodash/merge.js
var merge = __webpack_require__(82492);
var merge_default = /*#__PURE__*/__webpack_require__.n(merge);
// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(67294);
// EXTERNAL MODULE: ./node_modules/react-select/dist/react-select.browser.esm.js + 1 modules
var react_select_browser_esm = __webpack_require__(37789);
// EXTERNAL MODULE: ./node_modules/react-select/dist/index-4322c0ed.browser.esm.js
var index_4322c0ed_browser_esm = __webpack_require__(29584);
// EXTERNAL MODULE: ./node_modules/react-select/dist/Select-9fdb8cd0.browser.esm.js
var Select_9fdb8cd0_browser_esm = __webpack_require__(26678);
// EXTERNAL MODULE: ./node_modules/react-select-async-paginate/es/index.js + 8 modules
var es = __webpack_require__(56433);
// EXTERNAL MODULE: ./node_modules/react-sortable-hoc/dist/react-sortable-hoc.esm.js
var react_sortable_hoc_esm = __webpack_require__(95742);
// EXTERNAL MODULE: ./node_modules/array-move/index.js
var array_move = __webpack_require__(80454);
var array_move_default = /*#__PURE__*/__webpack_require__.n(array_move);
// EXTERNAL MODULE: ./node_modules/@superset-ui/core/esm/style/index.js
var style = __webpack_require__(37840);
// EXTERNAL MODULE: ./node_modules/react-select/async/dist/react-select.browser.esm.js
var dist_react_select_browser_esm = __webpack_require__(75429);
// EXTERNAL MODULE: ./node_modules/react-select/creatable/dist/react-select.browser.esm.js
var creatable_dist_react_select_browser_esm = __webpack_require__(12766);
// EXTERNAL MODULE: ./node_modules/react-select/async-creatable/dist/react-select.browser.esm.js
var async_creatable_dist_react_select_browser_esm = __webpack_require__(36144);
// EXTERNAL MODULE: ./node_modules/react-window/dist/index.esm.js
var index_esm = __webpack_require__(74061);
// EXTERNAL MODULE: ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js + 1 modules
var emotion_react_browser_esm = __webpack_require__(11965);
;// CONCATENATED MODULE: ./src/components/Select/WindowedSelect/WindowedMenuList.tsx
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


const DEFAULT_OPTION_HEIGHT = 30;
/**
 * Get the index of the last selected option.
 */
function getLastSelected(children) {
  return Array.isArray(children) ?
  children.findIndex(({ props: { isFocused = false } = {} }) => isFocused) || 0 :
  -1;
}
/**
 * Calculate probable option height as set in theme configs
 */
function detectHeight({ spacing: { baseUnit, lineHeight } }) {
  // Option item expects 2 * baseUnit for each of top and bottom padding.
  return baseUnit * 4 + lineHeight;
}
function WindowedMenuList({ children, ...props }) {
  const { maxHeight, selectProps, theme, getStyles, cx, innerRef, isMulti, className } = props;
  const {
    // Expose react-window VariableSizeList instance and HTML elements
    windowListRef: windowListRef_, windowListInnerRef } = selectProps;
  const defaultWindowListRef = (0,react.useRef)(null);
  const windowListRef = windowListRef_ || defaultWindowListRef;
  // try get default option height from theme configs
  let { optionHeight } = selectProps;
  if (!optionHeight) {
    optionHeight = theme ? detectHeight(theme) : DEFAULT_OPTION_HEIGHT;
  }
  const itemCount = children.length;
  const totalHeight = optionHeight * itemCount;
  const Row = ({ data, index, style }) => (0,emotion_react_browser_esm.jsx)("div", { style: style }, data[index]);
  (0,react.useEffect)(() => {
    const lastSelected = getLastSelected(children);
    if (windowListRef.current && lastSelected) {
      windowListRef.current.scrollToItem(lastSelected);
    }
  }, [children, windowListRef]);
  return (0,emotion_react_browser_esm.jsx)(index_esm/* FixedSizeList */.t7, { css: getStyles('menuList', props), className: cx({
      'menu-list': true,
      'menu-list--is-multi': isMulti },
    className), ref: windowListRef, outerRef: innerRef, innerRef: windowListInnerRef, height: Math.min(totalHeight, maxHeight), width: "100%", itemData: children, itemCount: children.length, itemSize: optionHeight },
  Row);

}
;// CONCATENATED MODULE: ./src/components/Select/WindowedSelect/windowed.tsx
 /**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const { MenuList: DefaultMenuList } = index_4322c0ed_browser_esm.y;
const DEFAULT_WINDOW_THRESHOLD = 100;
function MenuList({ children, ...props }) {
  const { windowThreshold = DEFAULT_WINDOW_THRESHOLD } = props.selectProps;
  if (Array.isArray(children) && children.length > windowThreshold) {
    return (0,emotion_react_browser_esm.jsx)(WindowedMenuList, props,
    children);

  }
  return (0,emotion_react_browser_esm.jsx)(DefaultMenuList, props, children);
}
/**
 * Add "windowThreshold" option to a react-select component, turn the options
 * list into a virtualized list when appropriate.
 *
 * @param SelectComponent the React component to render Select
 */
function windowed(SelectComponent) {
  function WindowedSelect(props, ref) {
    const { components: components_ = {}, ...restProps } = props;
    const components = { ...components_, MenuList };
    return (0,emotion_react_browser_esm.jsx)(SelectComponent, extends_default()({ components: components, ref: ref }, restProps));
  }
  return /*#__PURE__*/react.forwardRef(WindowedSelect);
}
;// CONCATENATED MODULE: ./src/components/Select/WindowedSelect/index.tsx
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






const WindowedSelect = windowed(react_select_browser_esm/* default */.ZP);
const WindowedAsyncSelect = windowed(dist_react_select_browser_esm/* default */.ZP);
const WindowedCreatableSelect = windowed(creatable_dist_react_select_browser_esm/* default */.ZP);
const WindowedAsyncCreatableSelect = windowed(async_creatable_dist_react_select_browser_esm/* default */.Z);
/* harmony default export */ const Select_WindowedSelect = ((/* unused pure expression or super */ null && (WindowedSelect)));
;// CONCATENATED MODULE: ./src/components/Select/styles.tsx
 /**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



const DEFAULT_CLASS_NAME = 'Select';
const DEFAULT_CLASS_NAME_PREFIX = 'Select';
const colors = (theme) => ({
  primary: theme.colors.success.base,
  danger: theme.colors.error.base,
  warning: theme.colors.warning.base,
  indicator: theme.colors.info.base,
  almostBlack: theme.colors.grayscale.dark1,
  grayDark: theme.colors.grayscale.dark1,
  grayLight: theme.colors.grayscale.light2,
  gray: theme.colors.grayscale.light1,
  grayBg: theme.colors.grayscale.light4,
  grayBgDarker: theme.colors.grayscale.light3,
  grayBgDarkest: theme.colors.grayscale.light2,
  grayHeading: theme.colors.grayscale.light1,
  menuHover: theme.colors.grayscale.light3,
  lightest: theme.colors.grayscale.light5,
  darkest: theme.colors.grayscale.dark2,
  grayBorder: theme.colors.grayscale.light2,
  grayBorderLight: theme.colors.grayscale.light3,
  grayBorderDark: theme.colors.grayscale.light1,
  textDefault: theme.colors.grayscale.dark1,
  textDarkest: theme.colors.grayscale.dark2,
  dangerLight: theme.colors.error.light1 });

const defaultTheme = (theme) => ({
  borderRadius: theme.borderRadius,
  zIndex: 11,
  colors: colors(theme),
  spacing: {
    baseUnit: 3,
    menuGutter: 0,
    controlHeight: 34,
    lineHeight: 19,
    fontSize: 14,
    minWidth: '6.5em' } });


const DEFAULT_STYLES = {
  container: (provider, { theme: { spacing: { minWidth } } }) => [
  provider,
  emotion_react_browser_esm.css`
      min-width: ${minWidth};
    `],

  placeholder: (provider) => [
  provider,
  emotion_react_browser_esm.css`
      white-space: nowrap;
    `],

  indicatorSeparator: () => emotion_react_browser_esm.css`
    display: none;
  `,
  indicatorsContainer: (provider) => [
  provider,
  emotion_react_browser_esm.css`
      i {
        width: 1em;
        display: inline-block;
      }
    `],

  clearIndicator: (provider) => [
  provider,
  emotion_react_browser_esm.css`
      padding: 4px 0 4px 6px;
    `],

  control: (provider, { isFocused, menuIsOpen, theme: { borderRadius, colors } }) => {
    const isPseudoFocused = isFocused && !menuIsOpen;
    let borderColor = colors.grayBorder;
    if (isPseudoFocused || menuIsOpen) {
      borderColor = colors.grayBorderDark;
    }
    return [
    provider,
    emotion_react_browser_esm.css`
        border-color: ${borderColor};
        box-shadow: ${isPseudoFocused ?
    'inset 0 1px 1px rgba(0,0,0,.075), 0 0 0 3px rgba(0,0,0,.1)' :
    'none'};
        border-radius: ${menuIsOpen ?
    `${borderRadius}px ${borderRadius}px 0 0` :
    `${borderRadius}px`};
        &:hover {
          border-color: ${borderColor};
          box-shadow: 0 1px 0 rgba(0, 0, 0, 0.06);
        }
        flex-wrap: nowrap;
        padding-left: 1px;
      `];

  },
  menu: (provider, { theme: { zIndex } }) => [
  provider,
  emotion_react_browser_esm.css`
      padding-bottom: 2em;
      z-index: ${zIndex}; /* override at least multi-page pagination */
      width: auto;
      min-width: 100%;
      max-width: 80vw;
      background: none;
      box-shadow: none;
      border: 0;
    `],

  menuList: (provider, { theme: { borderRadius, colors } }) => [
  provider,
  emotion_react_browser_esm.css`
      background: ${colors.lightest};
      border-radius: 0 0 ${borderRadius}px ${borderRadius}px;
      border: 1px solid ${colors.grayBorderDark};
      box-shadow: 0 1px 0 rgba(0, 0, 0, 0.06);
      margin-top: -1px;
      border-top-color: ${colors.grayBorderLight};
      min-width: 100%;
      width: auto;
      border-radius: 0 0 ${borderRadius}px ${borderRadius}px;
      padding-top: 0;
      padding-bottom: 0;
    `],

  option: (provider, { isDisabled, isFocused, isSelected, theme: { colors, spacing: { lineHeight, fontSize } } }) => {
    let color = colors.textDefault;
    let backgroundColor = colors.lightest;
    if (isFocused) {
      backgroundColor = colors.grayBgDarker;
    } else
    if (isDisabled) {
      color = '#ccc';
    }
    return [
    provider,
    emotion_react_browser_esm.css`
        cursor: pointer;
        line-height: ${lineHeight}px;
        font-size: ${fontSize}px;
        background-color: ${backgroundColor};
        color: ${color};
        font-weight: ${isSelected ? 600 : 400};
        white-space: nowrap;
        &:hover:active {
          background-color: ${colors.grayBg};
        }
      `];

  },
  valueContainer: (provider, { isMulti, hasValue, theme: { spacing: { baseUnit } } }) => [
  provider,
  emotion_react_browser_esm.css`
      padding-left: ${isMulti && hasValue ? 1 : baseUnit * 3}px;
    `],

  multiValueLabel: (provider, { theme: { spacing: { baseUnit } } }) => ({
    ...provider,
    paddingLeft: baseUnit * 1.2,
    paddingRight: baseUnit * 1.2 }),

  input: (provider, { selectProps }) => {var _selectProps$value;return [
    provider,
    emotion_react_browser_esm.css`
      margin-left: 0;
      vertical-align: middle;
      ${selectProps != null && selectProps.isMulti && selectProps != null && (_selectProps$value = selectProps.value) != null && _selectProps$value.length ?
    'padding: 0 6px; width: 100%' :
    'padding: 0; flex: 1 1 auto;'};
    `];},

  menuPortal: (base) => ({
    ...base,
    zIndex: 1030 // must be same or higher of antd popover
  }) };

const INPUT_TAG_BASE_STYLES = {
  background: 'none',
  border: 'none',
  outline: 'none',
  padding: 0 };

const { ClearIndicator, DropdownIndicator, Option, Input, SelectContainer } = index_4322c0ed_browser_esm.y;
const DEFAULT_COMPONENTS = {
  SelectContainer: ({ children, ...props }) => {
    const { selectProps: { assistiveText } } = props;
    return (0,emotion_react_browser_esm.jsx)("div", null,
    (0,emotion_react_browser_esm.jsx)(SelectContainer, props, children),
    assistiveText && (0,emotion_react_browser_esm.jsx)("span", { css: (theme) => ({
        marginLeft: 3,
        fontSize: theme.typography.sizes.s,
        color: theme.colors.grayscale.light1 }) },

    assistiveText));


  },
  Option: ({ children, innerProps, data, ...props }) => (0,emotion_react_browser_esm.jsx)(Option, extends_default()({}, props, { data: data, css: data != null && data.style ? data.style : null, innerProps: innerProps }),
  children),

  ClearIndicator: (props) => (0,emotion_react_browser_esm.jsx)(ClearIndicator, props,
  (0,emotion_react_browser_esm.jsx)("i", { className: "fa" }, "\xD7")),

  DropdownIndicator: (props) => (0,emotion_react_browser_esm.jsx)(DropdownIndicator, props,
  (0,emotion_react_browser_esm.jsx)("i", { className: `fa fa-caret-${props.selectProps.menuIsOpen ? 'up' : 'down'}` })),

  Input: (props) => {
    const { getStyles } = props;
    return (0,emotion_react_browser_esm.jsx)(Input, extends_default()({}, props, { css: getStyles('input', props), autoComplete: "chrome-off", inputStyle: INPUT_TAG_BASE_STYLES }));
  } };

const VALUE_LABELED_STYLES = {
  valueContainer: (provider, { getValue, theme: { spacing: { baseUnit } }, isMulti }) => ({
    ...provider,
    paddingLeft: getValue().length > 0 ? 1 : baseUnit * 3,
    overflow: isMulti && getValue().length > 0 ? 'visible' : 'hidden' }),

  // render single value as is they are multi-value
  singleValue: (provider, props) => {
    const { getStyles } = props;
    return {
      ...getStyles('multiValue', props),
      '.metric-option': getStyles('multiValueLabel', props) };

  } };
// EXTERNAL MODULE: ./src/components/Select/utils.ts
var utils = __webpack_require__(55083);
;// CONCATENATED MODULE: ./src/components/Select/DeprecatedSelect.tsx
 /**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */










function styled(SelectComponent) {
  const SortableSelectComponent = (0,react_sortable_hoc_esm/* SortableContainer */.JN)(SelectComponent, {
    withRef: true });

  // default components for the given OptionType
  const supersetDefaultComponents = DEFAULT_COMPONENTS;
  const getSortableMultiValue = (MultiValue) => (0,react_sortable_hoc_esm/* SortableElement */.W8)((props) => {
    const onMouseDown = (e) => {
      e.preventDefault();
      e.stopPropagation();
    };
    const innerProps = { onMouseDown };
    return (0,emotion_react_browser_esm.jsx)(MultiValue, extends_default()({}, props, { innerProps: innerProps }));
  });
  /**
   * Superset styled `Select` component. Apply Superset themed stylesheets and
   * consolidate props API for backward compatibility with react-select v1.
   */
  function StyledSelect(selectProps) {
    let stateManager; // reference to react-select StateManager
    const {
      // additional props for Superset Select
      selectRef, labelKey = 'label', valueKey = 'value', themeConfig, stylesConfig = {}, optionRenderer, valueRenderer,
      // whether value is rendered as `option-label` in input,
      // useful for AdhocMetric and AdhocFilter
      valueRenderedAsLabel: valueRenderedAsLabel_, onPaste, multi = false, // same as `isMulti`, used for backward compatibility
      clearable, // same as `isClearable`
      sortable = true, // whether to enable drag & drop sorting
      forceOverflow, // whether the dropdown should be forcefully overflowing
      // react-select props
      className = DEFAULT_CLASS_NAME, classNamePrefix = DEFAULT_CLASS_NAME_PREFIX, options, value: value_, components: components_, isMulti: isMulti_, isClearable: isClearable_, minMenuHeight = 100, // apply different defaults
      maxMenuHeight = 220, filterOption, ignoreAccents = false, // default is `true`, but it is slow
      getOptionValue = (option) => typeof option === 'string' ? option : option[valueKey], getOptionLabel = (option) => typeof option === 'string' ?
      option :
      option[labelKey] || option[valueKey], formatOptionLabel = (option, { context }) => {
        if (context === 'value') {
          return valueRenderer ? valueRenderer(option) : getOptionLabel(option);
        }
        return optionRenderer ? optionRenderer(option) : getOptionLabel(option);
      }, ...restProps } = selectProps;
    // `value` may be rendered values (strings), we want option objects
    const value = (0,utils/* findValue */.d)(value_, options || [], valueKey);
    // Add backward compability to v1 API
    const isMulti = isMulti_ === undefined ? multi : isMulti_;
    const isClearable = isClearable_ === undefined ? clearable : isClearable_;
    // Sort is only applied when there are multiple selected values
    const shouldAllowSort = isMulti && sortable && Array.isArray(value) && value.length > 1;
    const MaybeSortableSelect = shouldAllowSort ?
    SortableSelectComponent :
    SelectComponent;
    const components = { ...supersetDefaultComponents, ...components_ };
    // Make multi-select sortable as per https://react-select.netlify.app/advanced
    if (shouldAllowSort) {
      components.MultiValue = getSortableMultiValue(components.MultiValue || index_4322c0ed_browser_esm.y.MultiValue);
      const sortableContainerProps = {
        getHelperDimensions: ({ node }) => node.getBoundingClientRect(),
        axis: 'xy',
        onSortEnd: ({ oldIndex, newIndex }) => {
          const newValue = array_move_default()(value, oldIndex, newIndex);
          if (restProps.onChange) {
            restProps.onChange(newValue, { action: 'set-value' });
          }
        },
        distance: 4 };

      Object.assign(restProps, sortableContainerProps);
    }
    // When values are rendered as labels, adjust valueContainer padding
    const valueRenderedAsLabel = valueRenderedAsLabel_ === undefined ? isMulti : valueRenderedAsLabel_;
    if (valueRenderedAsLabel && !stylesConfig.valueContainer) {
      Object.assign(stylesConfig, VALUE_LABELED_STYLES);
    }
    // Handle onPaste event
    if (onPaste) {
      const Input = components.Input ||
      index_4322c0ed_browser_esm.y.Input;
      components.Input = (props) => (0,emotion_react_browser_esm.jsx)(Input, extends_default()({}, props, { onPaste: onPaste }));
    }
    // for CreaTable
    if (SelectComponent === WindowedCreatableSelect) {
      restProps.getNewOptionData = (inputValue, label) => ({
        label: label || inputValue,
        [valueKey]: inputValue,
        isNew: true });

    }
    // handle forcing dropdown overflow
    // use only when setting overflow:visible isn't possible on the container element
    if (forceOverflow) {
      Object.assign(restProps, {
        closeMenuOnScroll: (e) => {var _stateManager, _stateManager$state, _target$classList;
          // ensure menu is open
          const menuIsOpen = (_stateManager = stateManager) == null ? void 0 : (_stateManager$state = _stateManager.state) == null ? void 0 : _stateManager$state.
          menuIsOpen;
          const target = e.target;
          return menuIsOpen &&
          target &&
          !((_target$classList = target.classList) != null && _target$classList.contains('Select__menu-list'));
        },
        menuPosition: 'fixed' });

    }
    // Make sure always return StateManager for the refs.
    // To get the real `Select` component, keep tap into `obj.select`:
    //   - for normal <Select /> component: StateManager -> Select,
    //   - for <Creatable />: StateManager -> Creatable -> Select
    const setRef = (instance) => {
      stateManager =
      shouldAllowSort && instance && 'refs' in instance ?
      instance.refs.wrappedInstance // obtain StateManger from SortableContainer
      : instance;
      if (typeof selectRef === 'function') {
        selectRef(stateManager);
      } else
      if (selectRef && 'current' in selectRef) {
        selectRef.current = stateManager;
      }
    };
    const theme = (0,style/* useTheme */.Fg)();
    return (0,emotion_react_browser_esm.jsx)(MaybeSortableSelect, extends_default()({ ref: setRef, className: className, classNamePrefix: classNamePrefix, isMulti: isMulti, isClearable: isClearable, options: options, value: value, minMenuHeight: minMenuHeight, maxMenuHeight: maxMenuHeight, filterOption:
      // filterOption may be NULL
      filterOption !== undefined ?
      filterOption :
      (0,Select_9fdb8cd0_browser_esm.c)({ ignoreAccents }), styles: { ...DEFAULT_STYLES, ...stylesConfig }
      // merge default theme from `react-select`, default theme for Superset,
      // and the theme from props.
      , theme: (reactSelectTheme) => merge_default()(reactSelectTheme, defaultTheme(theme), themeConfig), formatOptionLabel: formatOptionLabel, getOptionLabel: getOptionLabel, getOptionValue: getOptionValue, components: components }, restProps));
  }
  // React.memo makes sure the component does no rerender given the same props
  return /*#__PURE__*/react.memo(StyledSelect);
}
const Select = styled(WindowedSelect);
const AsyncSelect = styled(WindowedAsyncSelect);
const CreatableSelect = styled(WindowedCreatableSelect);
const AsyncCreatableSelect = styled(WindowedAsyncCreatableSelect);
const PaginatedSelect = (0,es/* withAsyncPaginate */.yf)(styled(react_select_browser_esm/* default */.ZP));
/* harmony default export */ const DeprecatedSelect = (Select);
// EXTERNAL MODULE: ./src/components/Select/OnPasteSelect.jsx
var OnPasteSelect = __webpack_require__(75017);
// EXTERNAL MODULE: ./node_modules/antd/lib/select/index.js
var lib_select = __webpack_require__(64749);
;// CONCATENATED MODULE: ./src/components/Select/NativeSelect.tsx
 /**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const StyledNativeSelect = (0,style/* styled */.iK)((props) => (0,emotion_react_browser_esm.jsx)(lib_select["default"], extends_default()({ getPopupContainer: (trigger) => trigger.parentNode }, props)))`
  display: block;
`;
const StyledNativeGraySelect = (0,style/* styled */.iK)(lib_select["default"])`
  &.ant-select-single {
    .ant-select-selector {
      height: 36px;
      padding: 0 11px;
      background-color: ${({ theme }) => theme.colors.grayscale.light3};
      border: none;

      .ant-select-selection-search-input {
        height: 100%;
      }

      .ant-select-selection-item,
      .ant-select-selection-placeholder {
        line-height: 35px;
        color: ${({ theme }) => theme.colors.grayscale.dark1};
      }
    }
  }
`;
const NativeSelect = Object.assign(StyledNativeSelect, {
  Option: lib_select["default"].Option });

const NativeGraySelect = Object.assign(StyledNativeGraySelect, {
  Option: lib_select["default"].Option });
;// CONCATENATED MODULE: ./src/components/Select/index.ts
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */






/***/ }),

/***/ 71989:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Xv": () => (/* binding */ EditableTabs),
/* harmony export */   "cl": () => (/* binding */ LineEditableTabs),
/* harmony export */   "ZP": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export StyledLineEditableTabs */
/* harmony import */ var _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5872);
/* harmony import */ var _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67294);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11965);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(37840);
/* harmony import */ var antd_lib_tabs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1350);
/* harmony import */ var src_components_Icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38097);
 /**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




const StyledTabs = ({ animated = false, fullWidth = true, allowOverflow = true, ...props }) => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_3__.jsx)(antd_lib_tabs__WEBPACK_IMPORTED_MODULE_4__["default"], _babel_runtime_corejs3_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default()({ animated: animated }, props, { css: (theme) => _emotion_react__WEBPACK_IMPORTED_MODULE_3__.css`
      overflow: ${allowOverflow ? 'visible' : 'hidden'};

      .ant-tabs-content-holder {
        overflow: ${allowOverflow ? 'visible' : 'auto'};
      }
      .ant-tabs-tab {
        flex: 1 1 auto;
        &.ant-tabs-tab-active .ant-tabs-tab-btn {
          color: inherit;
        }
        &:hover {
          .anchor-link-container {
            cursor: pointer;
            .fa.fa-link {
              visibility: visible;
            }
          }
        }
        .short-link-trigger.btn {
          padding: 0 ${theme.gridUnit}px;
          & > .fa.fa-link {
            top: 0;
          }
        }
      }
      ${fullWidth &&
  _emotion_react__WEBPACK_IMPORTED_MODULE_3__.css`
        .ant-tabs-nav-list {
          width: 100%;
        }
      `};

      .ant-tabs-tab-btn {
        display: flex;
        flex: 1 1 auto;
        align-items: center;
        justify-content: center;
        font-size: ${theme.typography.sizes.s}px;
        text-align: center;
        text-transform: uppercase;
        user-select: none;
        .required {
          margin-left: ${theme.gridUnit / 2}px;
          color: ${theme.colors.error.base};
        }
      }
      .ant-tabs-ink-bar {
        background: ${theme.colors.secondary.base};
      }
    ` }));
const StyledTabPane = (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_5__/* .styled */ .iK)(antd_lib_tabs__WEBPACK_IMPORTED_MODULE_4__["default"].TabPane)``;
const Tabs = Object.assign(StyledTabs, {
  TabPane: StyledTabPane });

const StyledEditableTabs = (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_5__/* .styled */ .iK)(StyledTabs)`
  .ant-tabs-content-holder {
    background: white;
  }

  & > .ant-tabs-nav {
    margin-bottom: 0;
  }

  .ant-tabs-tab-remove {
    padding-top: 0;
    padding-bottom: 0;
    height: ${({ theme }) => theme.gridUnit * 6}px;
  }

  ${({ fullWidth }) => fullWidth &&
_emotion_react__WEBPACK_IMPORTED_MODULE_3__.css`
      .ant-tabs-nav-list {
        width: 100%;
      }
    `}
`;
const StyledCancelXIcon = (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_5__/* .styled */ .iK)(src_components_Icons__WEBPACK_IMPORTED_MODULE_2__/* ["default"].CancelX */ .Z.CancelX)`
  color: ${({ theme }) => theme.colors.grayscale.base};
`;
const EditableTabs = Object.assign(StyledEditableTabs, {
  TabPane: StyledTabPane });

EditableTabs.defaultProps = {
  type: 'editable-card',
  fullWidth: false,
  animated: { inkBar: true, tabPane: false } };

EditableTabs.TabPane.defaultProps = {
  closeIcon: (0,_emotion_react__WEBPACK_IMPORTED_MODULE_3__.jsx)(StyledCancelXIcon, { role: "button", tabIndex: 0 }) };

const StyledLineEditableTabs = (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_5__/* .styled */ .iK)(EditableTabs)`
  &.ant-tabs-card > .ant-tabs-nav .ant-tabs-tab {
    margin: 0 ${({ theme }) => theme.gridUnit * 4}px;
    padding: ${({ theme }) => `${theme.gridUnit * 3}px ${theme.gridUnit}px`};
    background: transparent;
    border: none;
  }

  &.ant-tabs-card > .ant-tabs-nav .ant-tabs-ink-bar {
    visibility: visible;
  }

  .ant-tabs-tab-btn {
    font-size: ${({ theme }) => theme.typography.sizes.m}px;
  }

  .ant-tabs-tab-remove {
    margin-left: 0;
    padding-right: 0;
  }

  .ant-tabs-nav-add {
    min-width: unset !important;
    background: transparent !important;
    border: none !important;
  }
`;
const LineEditableTabs = Object.assign(StyledLineEditableTabs, {
  TabPane: StyledTabPane });

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tabs);

/***/ }),

/***/ 40637:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Xv": () => (/* reexport safe */ _Tabs__WEBPACK_IMPORTED_MODULE_0__.Xv),
/* harmony export */   "cl": () => (/* reexport safe */ _Tabs__WEBPACK_IMPORTED_MODULE_0__.cl),
/* harmony export */   "ZP": () => (/* reexport safe */ _Tabs__WEBPACK_IMPORTED_MODULE_0__.ZP)
/* harmony export */ });
/* harmony import */ var _Tabs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71989);
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



/***/ }),

/***/ 86057:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11965);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67294);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37840);
/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(78019);
/* harmony import */ var src_components_Icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38097);
/* harmony import */ var src_components_Tooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58593);
 /**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




function WarningIconWithTooltip({ warningMarkdown, size }) {
  const theme = (0,_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__/* .useTheme */ .Fg)();
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)(src_components_Tooltip__WEBPACK_IMPORTED_MODULE_2__/* .Tooltip */ .u, { id: "warning-tooltip", title: (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)(_superset_ui_core__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, { source: warningMarkdown }) },
  (0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.jsx)(src_components_Icons__WEBPACK_IMPORTED_MODULE_1__/* ["default"].AlertSolid */ .Z.AlertSolid, { iconColor: theme.colors.alert.base, iconSize: size, css: /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_4__.css)({ marginRight: theme.gridUnit * 2 },  true ? "" : 0,  true ? "" : 0) }));

}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WarningIconWithTooltip);

/***/ }),

/***/ 99543:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SJ": () => (/* binding */ addToObject),
/* harmony export */   "wK": () => (/* binding */ alterInObject),
/* harmony export */   "gf": () => (/* binding */ alterInArr),
/* harmony export */   "gP": () => (/* binding */ removeFromArr),
/* harmony export */   "p1": () => (/* binding */ getFromArr),
/* harmony export */   "_0": () => (/* binding */ addToArr),
/* harmony export */   "zd": () => (/* binding */ extendArr),
/* harmony export */   "hU": () => (/* binding */ initEnhancer),
/* harmony export */   "E8": () => (/* binding */ areArraysShallowEqual),
/* harmony export */   "JB": () => (/* binding */ areObjectsEqual)
/* harmony export */ });
/* harmony import */ var lodash_isUndefined__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(52353);
/* harmony import */ var lodash_isUndefined__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isUndefined__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_omitBy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14176);
/* harmony import */ var lodash_omitBy__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_omitBy__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18446);
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isEqual__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var shortid__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14670);
/* harmony import */ var shortid__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(shortid__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var redux__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(14890);
/* harmony import */ var redux_localstorage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(64417);
/* harmony import */ var redux_localstorage__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(redux_localstorage__WEBPACK_IMPORTED_MODULE_4__);
 /**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */




function addToObject(state, arrKey, obj) {
  const newObject = { ...state[arrKey] };
  const copiedObject = { ...obj };
  if (!copiedObject.id) {
    copiedObject.id = shortid__WEBPACK_IMPORTED_MODULE_3___default().generate();
  }
  newObject[copiedObject.id] = copiedObject;
  return { ...state, [arrKey]: newObject };
}
function alterInObject(state, arrKey, obj, alterations) {
  const newObject = { ...state[arrKey] };
  newObject[obj.id] = { ...newObject[obj.id], ...alterations };
  return { ...state, [arrKey]: newObject };
}
function alterInArr(state, arrKey, obj, alterations, idKey = 'id') {
  // Finds an item in an array in the state and replaces it with a
  // new object with an altered property
  const newArr = [];
  state[arrKey].forEach((arrItem) => {
    if (obj[idKey] === arrItem[idKey]) {
      newArr.push({ ...arrItem, ...alterations });
    } else
    {
      newArr.push(arrItem);
    }
  });
  return { ...state, [arrKey]: newArr };
}
function removeFromArr(state, arrKey, obj, idKey = 'id') {
  const newArr = [];
  state[arrKey].forEach((arrItem) => {
    if (!(obj[idKey] === arrItem[idKey])) {
      newArr.push(arrItem);
    }
  });
  return { ...state, [arrKey]: newArr };
}
function getFromArr(arr, id) {
  let obj;
  arr.forEach((o) => {
    if (o.id === id) {
      obj = o;
    }
  });
  return obj;
}
function addToArr(state, arrKey, obj, prepend = false) {
  const newObj = { ...obj };
  if (!newObj.id) {
    newObj.id = shortid__WEBPACK_IMPORTED_MODULE_3___default().generate();
  }
  const newState = {};
  if (prepend) {
    newState[arrKey] = [newObj, ...state[arrKey]];
  } else
  {
    newState[arrKey] = [...state[arrKey], newObj];
  }
  return { ...state, ...newState };
}
function extendArr(state, arrKey, arr, prepend = false) {
  const newArr = [...arr];
  newArr.forEach((el) => {
    if (!el.id) {
      /* eslint-disable no-param-reassign */
      el.id = shortid__WEBPACK_IMPORTED_MODULE_3___default().generate();
    }
  });
  const newState = {};
  if (prepend) {
    newState[arrKey] = [...newArr, ...state[arrKey]];
  } else
  {
    newState[arrKey] = [...state[arrKey], ...newArr];
  }
  return { ...state, ...newState };
}
function initEnhancer(persist = true, persistConfig = {}) {
  const { paths, config } = persistConfig;
  const composeEnhancers =  false ?
  /* eslint-disable-next-line no-underscore-dangle, dot-notation */
  0 :
  redux__WEBPACK_IMPORTED_MODULE_5__/* .compose */ .qC;
  return persist ?
  composeEnhancers(redux_localstorage__WEBPACK_IMPORTED_MODULE_4___default()(paths, config)) :
  composeEnhancers();
}
function areArraysShallowEqual(arr1, arr2) {
  // returns whether 2 arrays are shallow equal
  // used in shouldComponentUpdate when denormalizing arrays
  // where the array object is different every time, but the content might
  // be the same
  if (!arr1 || !arr2) {
    return false;
  }
  if (arr1.length !== arr2.length) {
    return false;
  }
  const { length } = arr1;
  for (let i = 0; i < length; i += 1) {
    if (arr1[i] !== arr2[i]) {
      return false;
    }
  }
  return true;
}
function areObjectsEqual(obj1, obj2, opts = { ignoreUndefined: false }) {
  let comp1 = obj1;
  let comp2 = obj2;
  if (opts.ignoreUndefined) {
    comp1 = lodash_omitBy__WEBPACK_IMPORTED_MODULE_1___default()(obj1, (lodash_isUndefined__WEBPACK_IMPORTED_MODULE_0___default()));
    comp2 = lodash_omitBy__WEBPACK_IMPORTED_MODULE_1___default()(obj2, (lodash_isUndefined__WEBPACK_IMPORTED_MODULE_0___default()));
  }
  return lodash_isEqual__WEBPACK_IMPORTED_MODULE_2___default()(comp1, comp2);
}

/***/ })

}]);