# SPDX-FileCopyrightText: 2022 Shadowserver Foundation
#
# SPDX-License-Identifier: AGPL-3.0-or-later

# -*- coding: utf-8 -*-

import os
import unittest

import intelmq.lib.test as test
import intelmq.lib.utils as utils
from intelmq.bots.parsers.shadowserver.parser import ShadowserverParserBot

with open(os.path.join(os.path.dirname(__file__),
                       'testdata/malware_url.csv')) as handle:
    EXAMPLE_FILE = handle.read()
EXAMPLE_LINES = EXAMPLE_FILE.splitlines()

EXAMPLE_REPORT = {'feed.name': 'Malware URL',
                  "raw": utils.base64_encode(EXAMPLE_FILE),
                  "__type": "Report",
                  "time.observation": "2022-01-07T00:00:00+00:00",
                  "extra.file_name": "2022-01-07-malware_url-test.csv",
                  }
EVENTS = [
{
   '__type' : 'Event',
   'classification.identifier' : 'malware-url',
   'classification.taxonomy' : 'malicious-code',
   'classification.type' : 'malware-distribution',
   'extra.application' : 'http',
   'source.url' : 'http://41.86.0.0:50008/Mozi.m',
   'feed.name' : 'Malware URL',
   'malware.hash.sha256' : '12013662c71da69de977c04cd7021f13a70cf7bed4ca6c82acbc100464d4b0ef',
   'malware.name' : 'cve-2016-10372',
   'raw': utils.base64_encode('\n'.join([EXAMPLE_LINES[0],
                                     EXAMPLE_LINES[1]])),
   'source.asn' : 37203,
   'source.geolocation.cc' : 'LR',
   'source.geolocation.city' : 'MONROVIA',
   'source.geolocation.region' : 'MONTSERRADO',
   'source.ip' : '41.86.0.0',
   'time.observation' : '2022-01-07T00:00:00+00:00',
   'time.source' : '2022-01-07T00:02:07+00:00'
},
{
   '__type' : 'Event',
   'classification.identifier' : 'malware-url',
   'classification.taxonomy' : 'malicious-code',
   'classification.type' : 'malware-distribution',
   'extra.application' : 'http',
   'extra.source.naics' : 517311,
   'source.url' : 'http://42.225.0.0:38173/Mozi.m',
   'feed.name' : 'Malware URL',
   'malware.name' : 'cve-2018-10562',
   'raw': utils.base64_encode('\n'.join([EXAMPLE_LINES[0],
                                     EXAMPLE_LINES[2]])),
   'source.asn' : 4837,
   'source.geolocation.cc' : 'CN',
   'source.geolocation.city' : 'ZHUMADIAN',
   'source.geolocation.region' : 'HENAN SHENG',
   'source.ip' : '42.225.0.0',
   'time.observation' : '2022-01-07T00:00:00+00:00',
   'time.source' : '2022-01-07T00:03:14+00:00'
},
{
   '__type' : 'Event',
   'classification.identifier' : 'malware-url',
   'classification.taxonomy' : 'malicious-code',
   'classification.type' : 'malware-distribution',
   'extra.application' : 'http',
   'extra.source.naics' : 517311,
   'source.url' : 'http://211.52.0.0:53029/Mozi.m',
   'feed.name' : 'Malware URL',
   'malware.name' : 'cve-2018-10562',
   'raw': utils.base64_encode('\n'.join([EXAMPLE_LINES[0],
                                     EXAMPLE_LINES[3]])),
   'source.asn' : 4766,
   'source.geolocation.cc' : 'KR',
   'source.geolocation.city' : 'SAGOK-MYEON',
   'source.geolocation.region' : 'CHUNGCHEONGNAM-DO',
   'source.ip' : '211.52.0.0',
   'time.observation' : '2022-01-07T00:00:00+00:00',
   'time.source' : '2022-01-07T00:10:26+00:00'
}
]


class TestShadowserverParserBot(test.BotTestCase, unittest.TestCase):
    """
    A TestCase for a ShadowserverParserBot.
    """

    @classmethod
    def set_bot(cls):
        cls.bot_reference = ShadowserverParserBot
        cls.default_input_message = EXAMPLE_REPORT

    def test_event(self):
        """ Test if correct Event has been produced. """
        self.run_bot()
        for i, EVENT in enumerate(EVENTS):
            self.assertMessageEqual(i, EVENT)


if __name__ == '__main__':  # pragma: no cover
    unittest.main()
