
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: src/ai/backend/web:dist

from setuptools import setup

setup(**{
    'author': 'Lablup Inc. and contributors',
    'classifiers': [
        'Intended Audience :: Developers',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Environment :: No Input/Output (Daemon)',
        'Topic :: Scientific/Engineering',
        'Topic :: Software Development',
        'Development Status :: 5 - Production/Stable',
        'License :: OSI Approved :: GNU Lesser General Public License v3 or later (LGPLv3+)',
    ],
    'description': 'Backend.AI WebUI Host',
    'install_requires': (
        'Jinja2~=3.1.2',
        'aiohttp_cors~=0.7',
        'aiohttp~=3.8.1',
        'aiotools~=1.5.9',
        'backend.ai-cli==22.09.16',
        'backend.ai-client==22.09.16',
        'backend.ai-common==22.09.16',
        'backend.ai-plugin==22.09.16',
        'click>=7.1.2',
        'coloredlogs~=15.0',
        'pycryptodome>=3.14.1',
        'redis[hiredis]~=4.3.4',
        'setproctitle~=1.2.2',
        'tomli~=2.0.1',
        'trafaret~=2.1',
        'types-pkg_resources',
        'uvloop>=0.17; sys_platform != "Windows"',
        'yarl>=1.7',
    ),
    'license': 'LGPLv3',
    'long_description': """# Backend.AI Web Server

[![GitHub version](https://badge.fury.io/gh/lablup%2Fbackend.ai-webserver.svg)](https://badge.fury.io/gh/lablup%2Fbackend.ai-webserver) [![PyPI version](https://badge.fury.io/py/backend.ai-webserver.svg)](https://badge.fury.io/py/backend.ai-webserver)

A webapp hosting daemon which serves our `webui` as a SPA and proxies API requests


## Installation

Prepare a Python virtualenv (Python 3.9 or higher) and a Redis server (6.2 or higher).

```console
$ git clone https://github.com/lablup/backend.ai-webserver webserver
$ cd webserver
$ pip install -U -e .
$ cp webserver.sample.conf webserver.conf
```

## Mode

If `service.mode` is set "webui" (the default), the webserver handles
PWA-style fallbacks (e.g., serving `index.html` when there are no matching
files for the requested URL path).
The PWA must exclude `/server` and `/func` URL prefixes from its own routing
to work with the webserver's web sessions and the API proxy.

If it is set "static", the webserver serves the static files as-is,
without any fallbacks or hooking, while preserving the `/server` and `/func`
prefixed URLs and their functionalities.

If you want to serve web UI in webserver with "webui" mode, prepare static web UI source by choosing one of the followings.

### Option 1: Build web UI from source

Build **[backend.ai-webui](https://github.com/lablup/backend.ai-webui)** and copy all files under `build/bundle`
into the `src/ai/backend/web/static` directory.

### Option 2: Use pre-built web UI

To download and deploy web UI from pre-built source, do the following:

```console
git submodule init
git submodule update
cd src/ai/backend/web/static
git checkout main  # or target branch
git fetch
git pull
```
### Setup configuration for webserver

You don't have to write `config.toml` for the web UI as this webserver auto-generates it on-the-fly.

Edit `webserver.conf` to match with your environment.


## Usage

To execute web server, run command below. (for debugging, append a `--debug` flag)


```console
$ python -m ai.backend.web.server
```
""",
    'long_description_content_type': 'text/markdown',
    'name': 'backend.ai-webserver',
    'namespace_packages': (
    ),
    'package_data': {
        'ai.backend.web': (
            'VERSION',
            'py.typed',
            'static/README.md',
            'static/config.toml',
            'static/default.toml',
            'static/dist/components/backend-ai-agent-summary-view-698e86ff.js',
            'static/dist/components/backend-ai-agent-view-40af0c17.js',
            'static/dist/components/backend-ai-change-forgot-password-view-f38e5a01.js',
            'static/dist/components/backend-ai-chart-3b2d562e.js',
            'static/dist/components/backend-ai-credential-view-35ce43ec.js',
            'static/dist/components/backend-ai-data-view-c0e7f84e.js',
            'static/dist/components/backend-ai-edu-applauncher-ddb88b6f.js',
            'static/dist/components/backend-ai-email-verification-view-46dae755.js',
            'static/dist/components/backend-ai-environment-view-4a82c145.js',
            'static/dist/components/backend-ai-error-view-2570ded8.js',
            'static/dist/components/backend-ai-import-view-1ebe8edf.js',
            'static/dist/components/backend-ai-information-view-aab134e5.js',
            'static/dist/components/backend-ai-list-status-70fdca8d.js',
            'static/dist/components/backend-ai-maintenance-view-804a5469.js',
            'static/dist/components/backend-ai-permission-denied-view-a276962c.js',
            'static/dist/components/backend-ai-session-launcher-7e6ae96a.js',
            'static/dist/components/backend-ai-session-view-c5f88e7e.js',
            'static/dist/components/backend-ai-settings-view-4fe45669.js',
            'static/dist/components/backend-ai-statistics-view-4ba6d421.js',
            'static/dist/components/backend-ai-summary-view-a165cb63.js',
            'static/dist/components/backend-ai-usersettings-view-f9bed114.js',
            'static/dist/components/backend-ai-webui-40033228.js',
            'static/dist/components/backend-ai-webui.js',
            'static/dist/components/chart-js-54dd1ab5.js',
            'static/dist/components/dom-repeat-743402fd.js',
            'static/dist/components/expansion-9ed0d968.js',
            'static/dist/components/input-behavior-b68fcb29.js',
            'static/dist/components/json_to_csv-6fce0343.js',
            'static/dist/components/label-c131d4c3.js',
            'static/dist/components/lablup-activity-panel-e5620827.js',
            'static/dist/components/lablup-codemirror-11912269.js',
            'static/dist/components/lablup-grid-sort-filter-column-f1de0eca.js',
            'static/dist/components/lablup-loading-spinner-597745a9.js',
            'static/dist/components/lablup-progress-bar-7e4c7fd5.js',
            'static/dist/components/mwc-check-list-item-0132c648.js',
            'static/dist/components/mwc-switch-1bc0aa46.js',
            'static/dist/components/mwc-tab-bar-d6347470.js',
            'static/dist/components/progress-spinner-90783f23.js',
            'static/dist/components/radio-behavior-8d7f3314.js',
            'static/dist/components/select-f46db480.js',
            'static/dist/components/slider-5f500024.js',
            'static/dist/components/switch-22c50ae9.js',
            'static/dist/components/tab-group-db2a7c79.js',
            'static/dist/components/textarea-b5c6c64b.js',
            'static/dist/components/textfield-309de3d3.js',
            'static/dist/components/translate-unsafe-html-c8954f6b.js',
            'static/dist/components/vaadin-grid-474fcd24.js',
            'static/dist/components/vaadin-grid-filter-column-bf757e1e.js',
            'static/dist/components/vaadin-grid-selection-column-7e3d5c44.js',
            'static/dist/components/vaadin-grid-sort-column-b778c90f.js',
            'static/dist/components/vaadin-icons-7d848d50.js',
            'static/dist/components/vaadin-item-adda4d14.js',
            'static/dist/components/vaadin-item-styles-86cff5de.js',
            'static/index.html',
            'static/manifest.json',
            'static/manifest/app.js',
            'static/manifest/backend-ai.icns',
            'static/manifest/backend-ai.ico',
            'static/manifest/backend-ai.iconset/icon_128x128@1x.png',
            'static/manifest/backend-ai.iconset/icon_128x128@2x.png',
            'static/manifest/backend-ai.iconset/icon_16x16@1x.png',
            'static/manifest/backend-ai.iconset/icon_16x16@2x.png',
            'static/manifest/backend-ai.iconset/icon_256x256@1x.png',
            'static/manifest/backend-ai.iconset/icon_256x256@2x.png',
            'static/manifest/backend-ai.iconset/icon_32x32@1x.png',
            'static/manifest/backend-ai.iconset/icon_32x32@2x.png',
            'static/manifest/backend-ai.iconset/icon_512x512@1x.png',
            'static/manifest/backend-ai.iconset/icon_512x512@2x.png',
            'static/manifest/backend.ai-brand-simple.svg',
            'static/manifest/backend.ai-brand-white.svg',
            'static/manifest/backend.ai-brand.svg',
            'static/manifest/backend.ai-text.svg',
            'static/manifest/favicon.ico',
            'static/resources/app_template.json',
            'static/resources/badge-dark.svg',
            'static/resources/badge.svg',
            'static/resources/custom-kt.css',
            'static/resources/custom-original.css',
            'static/resources/custom.css',
            'static/resources/documents/privacy-policy.en.html',
            'static/resources/documents/privacy-policy.ko.html',
            'static/resources/documents/terms-of-service.en.html',
            'static/resources/documents/terms-of-service.ko.html',
            'static/resources/fashion-how-white.svg',
            'static/resources/fashion-how.svg',
            'static/resources/fonts/MaterialIcons-Regular.woff',
            'static/resources/fonts/MaterialIcons-Regular.woff2',
            'static/resources/fonts/MaterialIcons-Regular.woff2_',
            'static/resources/fonts/MaterialIcons-Regular.woff_',
            'static/resources/fonts/fa-brands-400.woff',
            'static/resources/fonts/fa-brands-400.woff2',
            'static/resources/fonts/fa-regular-400.woff',
            'static/resources/fonts/fa-regular-400.woff2',
            'static/resources/fonts/fa-solid-900.woff',
            'static/resources/fonts/fa-solid-900.woff2',
            'static/resources/fonts/font-awesome-all.min.css',
            'static/resources/fonts/font-awesome.css',
            'static/resources/fonts/fonts.css',
            'static/resources/fonts/montserrat-v13-latin-100.woff',
            'static/resources/fonts/montserrat-v13-latin-100.woff2',
            'static/resources/fonts/montserrat-v13-latin-100italic.woff',
            'static/resources/fonts/montserrat-v13-latin-100italic.woff2',
            'static/resources/fonts/montserrat-v13-latin-italic.woff',
            'static/resources/fonts/montserrat-v13-latin-italic.woff2',
            'static/resources/fonts/montserrat-v13-latin-regular.woff',
            'static/resources/fonts/montserrat-v13-latin-regular.woff2',
            'static/resources/fonts/quicksand-v13-latin-300.woff',
            'static/resources/fonts/quicksand-v13-latin-300.woff2',
            'static/resources/fonts/quicksand-v13-latin-500.woff',
            'static/resources/fonts/quicksand-v13-latin-500.woff2',
            'static/resources/fonts/quicksand-v13-latin-700.woff',
            'static/resources/fonts/quicksand-v13-latin-700.woff2',
            'static/resources/fonts/quicksand-v13-latin-regular.woff',
            'static/resources/fonts/quicksand-v13-latin-regular.woff2',
            'static/resources/fonts/roboto-v19-latin-100.woff',
            'static/resources/fonts/roboto-v19-latin-100.woff2',
            'static/resources/fonts/roboto-v19-latin-100italic.woff',
            'static/resources/fonts/roboto-v19-latin-100italic.woff2',
            'static/resources/fonts/roboto-v19-latin-300.woff',
            'static/resources/fonts/roboto-v19-latin-300.woff2',
            'static/resources/fonts/roboto-v19-latin-300italic.woff',
            'static/resources/fonts/roboto-v19-latin-300italic.woff2',
            'static/resources/fonts/roboto-v19-latin-900.woff',
            'static/resources/fonts/roboto-v19-latin-900.woff2',
            'static/resources/fonts/roboto-v19-latin-900italic.woff',
            'static/resources/fonts/roboto-v19-latin-900italic.woff2',
            'static/resources/fonts/roboto-v19-latin-italic.woff',
            'static/resources/fonts/roboto-v19-latin-italic.woff2',
            'static/resources/fonts/roboto-v19-latin-regular.woff',
            'static/resources/fonts/roboto-v19-latin-regular.woff2',
            'static/resources/fonts/ubuntu-v14-latin-300.woff',
            'static/resources/fonts/ubuntu-v14-latin-300.woff2',
            'static/resources/fonts/ubuntu-v14-latin-300italic.woff',
            'static/resources/fonts/ubuntu-v14-latin-300italic.woff2',
            'static/resources/fonts/ubuntu-v14-latin-500.woff',
            'static/resources/fonts/ubuntu-v14-latin-500.woff2',
            'static/resources/fonts/ubuntu-v14-latin-500italic.woff',
            'static/resources/fonts/ubuntu-v14-latin-500italic.woff2',
            'static/resources/fonts/ubuntu-v14-latin-700.woff',
            'static/resources/fonts/ubuntu-v14-latin-700.woff2',
            'static/resources/fonts/ubuntu-v14-latin-700italic.woff',
            'static/resources/fonts/ubuntu-v14-latin-700italic.woff2',
            'static/resources/fonts/ubuntu-v14-latin-italic.woff',
            'static/resources/fonts/ubuntu-v14-latin-italic.woff2',
            'static/resources/fonts/ubuntu-v14-latin-regular.woff',
            'static/resources/fonts/ubuntu-v14-latin-regular.woff2',
            'static/resources/i18n/de.json',
            'static/resources/i18n/el.json',
            'static/resources/i18n/en.json',
            'static/resources/i18n/es.json',
            'static/resources/i18n/fi.json',
            'static/resources/i18n/fr.json',
            'static/resources/i18n/id.json',
            'static/resources/i18n/it.json',
            'static/resources/i18n/ja.json',
            'static/resources/i18n/ko.json',
            'static/resources/i18n/mn.json',
            'static/resources/i18n/ms.json',
            'static/resources/i18n/pl.json',
            'static/resources/i18n/pt.json',
            'static/resources/i18n/pt_BR.json',
            'static/resources/i18n/ru.json',
            'static/resources/i18n/tr.json',
            'static/resources/i18n/vi.json',
            'static/resources/i18n/zh_CN.json',
            'static/resources/i18n/zh_TW.json',
            'static/resources/icons/LICENSE.md',
            'static/resources/icons/ROCm.png',
            'static/resources/icons/ROCm_black.png',
            'static/resources/icons/apache-spark.svg',
            'static/resources/icons/aws.png',
            'static/resources/icons/azure.png',
            'static/resources/icons/c.svg',
            'static/resources/icons/caffe.png',
            'static/resources/icons/caffe2.svg',
            'static/resources/icons/ceph.png',
            'static/resources/icons/check-list.svg',
            'static/resources/icons/cpp.svg',
            'static/resources/icons/default.png',
            'static/resources/icons/default_app.svg',
            'static/resources/icons/file_type_cuda.svg',
            'static/resources/icons/file_type_python.svg',
            'static/resources/icons/filebrowser.svg',
            'static/resources/icons/flux.png',
            'static/resources/icons/gcc.png',
            'static/resources/icons/gcp.png',
            'static/resources/icons/gdrive.png',
            'static/resources/icons/h2o.png',
            'static/resources/icons/haskell.png',
            'static/resources/icons/javascript.png',
            'static/resources/icons/julia.png',
            'static/resources/icons/jupyter.png',
            'static/resources/icons/jupyterlab.png',
            'static/resources/icons/lablup.png',
            'static/resources/icons/local.png',
            'static/resources/icons/lua.png',
            'static/resources/icons/matlab.png',
            'static/resources/icons/mlflow.png',
            'static/resources/icons/mxnet.svg',
            'static/resources/icons/nbp.png',
            'static/resources/icons/nni.png',
            'static/resources/icons/nni.svg',
            'static/resources/icons/nodejs.png',
            'static/resources/icons/novnc.svg',
            'static/resources/icons/nvidia.png',
            'static/resources/icons/octave.png',
            'static/resources/icons/openstack.png',
            'static/resources/icons/php.png',
            'static/resources/icons/purestorage.png',
            'static/resources/icons/python.png',
            'static/resources/icons/pytorch.svg',
            'static/resources/icons/r-lang.svg',
            'static/resources/icons/rust.svg',
            'static/resources/icons/sftp.png',
            'static/resources/icons/sftp2.png',
            'static/resources/icons/swift-tensorflow.png',
            'static/resources/icons/swift.svg',
            'static/resources/icons/tensorflow.png',
            'static/resources/icons/terminal.svg',
            'static/resources/icons/texlive.png',
            'static/resources/icons/tpu.svg',
            'static/resources/icons/ubuntu.svg',
            'static/resources/icons/vscode.svg',
            'static/resources/icons/xfce.png',
            'static/resources/icons/xrdp.svg',
            'static/resources/image_metadata.json',
            'static/resources/images/401_unauthorized_access.svg',
            'static/resources/images/404_not_found.svg',
            'static/resources/images/launcher-background.png',
            'static/resources/images/loading-background-large.jpg',
            'static/resources/images/loading-background.jpg',
            'static/resources/images/web-terminal-guide-1.png',
            'static/resources/images/web-terminal-guide-2.png',
            'static/resources/images/web-terminal-guide-3.png',
            'static/resources/images/web-terminal-guide-4.png',
            'static/resources/logo.png',
            'static/resources/menu_icons/icon_create_a_key_pair.svg',
            'static/resources/menu_icons/icon_keypair_management.svg',
            'static/resources/menu_icons/icon_upload_files.svg',
            'static/resources/storage_metadata.json',
            'static/resources/templates/under_construction.html',
            'static/src/lib/bundles/webcomponents-ce.js',
            'static/src/lib/bundles/webcomponents-ce.js.map',
            'static/src/lib/bundles/webcomponents-pf_dom.js',
            'static/src/lib/bundles/webcomponents-pf_dom.js.map',
            'static/src/lib/bundles/webcomponents-pf_js.js',
            'static/src/lib/bundles/webcomponents-pf_js.js.map',
            'static/src/lib/bundles/webcomponents-sd-ce-pf.js',
            'static/src/lib/bundles/webcomponents-sd-ce-pf.js.map',
            'static/src/lib/bundles/webcomponents-sd-ce.js',
            'static/src/lib/bundles/webcomponents-sd-ce.js.map',
            'static/src/lib/bundles/webcomponents-sd.js',
            'static/src/lib/bundles/webcomponents-sd.js.map',
            'static/src/lib/web-animations-js/web-animations-next-lite.min.js',
            'static/src/lib/webcomponents-loader.js',
            'static/sw.js',
            'static/sw.js.map',
            'static/version.json',
            'static/workbox-6da860f9.js',
            'static/workbox-6da860f9.js.map',
            'templates/config.toml.j2',
            'templates/config_ini.toml.j2',
        ),
    },
    'packages': (
        'ai.backend.web',
    ),
    'project_urls': {
        'Documentation': 'https://docs.backend.ai/',
        'Source': 'https://github.com/lablup/backend.ai',
    },
    'python_requires': '>=3.10,<3.11',
    'url': 'https://github.com/lablup/backend.ai',
    'version': '22.09.16',
    'zip_safe': False,
})
