# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['gmn_python_api']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4>=4.10.0,<5.0.0',
 'click>=7.1.2,<8.0.0',
 'numpy>1.20.3',
 'pandas>=1.1.0,<=1.3.5',
 'requests>=2.21.0,<3.0.0',
 'types-requests>=2.27.8,<3.0.0']

entry_points = \
{'console_scripts': ['gmn-python-api = gmn_python_api.__main__:main']}

setup_kwargs = {
    'name': 'gmn-python-api',
    'version': '0.0.2',
    'description': 'GMN Python API',
    'long_description': 'GMN Python API\n==============\n\n|PyPI| |Status| |Python Version| |License|\n\n|Read the Docs| |Tests| |Codecov|\n\n|pre-commit| |Black|\n\n.. |PyPI| image:: https://img.shields.io/pypi/v/gmn-python-api.svg\n   :target: https://pypi.org/project/gmn-python-api/\n   :alt: PyPI\n.. |Status| image:: https://img.shields.io/pypi/status/gmn-python-api.svg\n   :target: https://pypi.org/project/gmn-python-api/\n   :alt: Status\n.. |Python Version| image:: https://img.shields.io/pypi/pyversions/gmn-python-api\n   :target: https://pypi.org/project/gmn-python-api\n   :alt: Python Version\n.. |License| image:: https://img.shields.io/github/license/gmn-data-platform/gmn-python-api\n   :target: https://opensource.org/licenses/MIT\n   :alt: License\n.. |Read the Docs| image:: https://img.shields.io/readthedocs/gmn-python-api/latest.svg?label=Read%20the%20Docs\n   :target: https://gmn-python-api.readthedocs.io/\n   :alt: Read the documentation at https://gmn-python-api.readthedocs.io/\n.. |Tests| image:: https://github.com/gmn-data-platform/gmn-python-api/workflows/Tests/badge.svg\n   :target: https://github.com/gmn-data-platform/gmn-python-api/actions?query=workflow%3ATests+branch%3Amain\n   :alt: Tests\n.. |Codecov| image:: https://codecov.io/gh/gmn-data-platform/gmn-python-api/branch/main/graph/badge.svg\n   :target: https://codecov.io/gh/gmn-data-platform/gmn-python-api\n   :alt: Codecov\n.. |pre-commit| image:: https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white\n   :target: https://github.com/pre-commit/pre-commit\n   :alt: pre-commit\n.. |Black| image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :target: https://github.com/psf/black\n   :alt: Black\n\nPython API for accessing open `Global Meteor Network`_ (GMN) meteor trajectory `data`_.\nGlobal meteor data is generated by the GMN every 6 hours using a network of low-light cameras.\nMeteor properties (radiants, orbits, magnitudes and masses) are produced by the GMN and are available through this API.\n\n`Demo on Google Colab`_\n\nFeatures\n--------\n\n* Listing available daily and monthly csv trajectory summary files from the `GMN data directory`_.\n\n* Downloading specific daily and monthly csv trajectory summary files from the data directory.\n\n* Functions for loading the trajectory summary data into a Pandas_ DataFrame or Numpy_ array.\n\n* TODO: Functions for loading data from the future GMN Data Platform REST API.\n\nRequirements\n------------\n\n* Python 3.7, 3.8, 3.9 or 3.10\n\n\nInstallation\n------------\n\nYou can install *GMN Python API* via pip_ from `PyPI`_:\n\n.. code:: console\n\n   $ pip install gmn-python-api\n\nOr for the latest development code, through TestPyPI_ or directly from GitHub_ via pip_:\n\n.. code:: console\n\n   $ pip install -i https://test.pypi.org/simple/ --extra-index-url https://pypi.org/simple gmn-python-api==<version>\n   Or\n   $ pip install git+https://github.com/gmn-data-platform/gmn-python-api\n\nSee the Troubleshooting_ section if you encounter installation issues.\n\nUsage\n-----\n\nSimple example:\n\n.. code:: python\n\n   from datetime import datetime\n   from gmn_python_api.data_directory import get_daily_file_content_by_date\n   from gmn_python_api.trajectory_summary_reader import read_trajectory_summary_as_dataframe\n\n   # Load the contents of a specific daily trajectory summary file into a Pandas DataFrame\n   trajectory_summary_file_content = get_daily_file_content_by_date(datetime(2019, 7, 24))\n   trajectory_summary_dataframe = read_trajectory_summary_as_dataframe(trajectory_summary_file_content)\n\n   print("For the 24th of July 2019, the following data was recorded by the GMN:")\n   print(f"- {trajectory_summary_dataframe[\'Vgeo (km/s)\'].max()} km/s was the fastest geostationary velocity out of all meteors for that day.")\n   print(f"- {trajectory_summary_dataframe.loc[trajectory_summary_dataframe[\'IAU (code)\'] == \'PER\'].shape[0]} meteors were estimated to be part of the Perseids shower.")\n   print(f"- Station #{trajectory_summary_dataframe[\'Num (stat)\'].mode().values[0]} recorded the highest number of meteors.")\n\n   # Output:\n   # For the 24th of July 2019, the following data was recorded by the GMN:\n   # - 65.38499 km/s was the fastest geostationary velocity out of all meteors for that day.\n   # - 8 meteors were estimated to be part of the Perseids shower.\n   # - Station #2 recorded the highest number of meteors.\n\nPlease see the Usage_ and API_ section for more details. Or Troubleshooting_ for common problems.\n\n\nContributing\n------------\n\nContributions are very welcome.\nTo learn more, see the `Contributor Guide`_.\n\n\nLicense\n-------\n\nDistributed under the terms of the `MIT license`_,\n*GMN Python API* is free and open source software.\n\n\nIssues\n------\n\nIf you encounter any problems,\nplease `file an issue`_ along with a detailed description.\n\n\nCredits\n-------\n\n`Hypermodern Python Cookiecutter`_ template.\n\n.. _Cookiecutter: https://github.com/audreyr/cookiecutter\n.. _MIT license: https://opensource.org/licenses/MIT\n.. _PyPI: https://pypi.org/project/gmn-python-api/\n.. _TestPyPI: https://test.pypi.org/project/gmn-python-api/\n.. _Hypermodern Python Cookiecutter: https://github.com/cjolowicz/cookiecutter-hypermodern-python\n.. _file an issue: https://github.com/gmn-data-platform/gmn-python-api/issues\n.. _pip: https://pip.pypa.io/\n.. github-only\n.. _Contributor Guide: https://gmn-python-api.readthedocs.io/en/latest/contributing.html\n.. _Usage: https://gmn-python-api.readthedocs.io/en/latest/usage.html\n.. _API: https://gmn-python-api.readthedocs.io/en/latest/autoapi/gmn_python_api/index.html\n.. _Global Meteor Network: https://globalmeteornetwork.org/\n.. _data: https://globalmeteornetwork.org/data/\n.. _Demo on Google Colab: https://colab.research.google.com/github/gmn-data-platform/gmn-python-api/blob/main/global_meteor_network_data_analysis_template.ipynb\n.. _GMN data directory: https://globalmeteornetwork.org/data/traj_summary_data/\n.. _Pandas: https://pandas.pydata.org/\n.. _Numpy: https://numpy.org/\n.. _GitHub: https://github.com/gmn-data-platform/gmn-python-api\n.. _Troubleshooting: https://gmn-python-api.readthedocs.io/en/latest/troubleshooting.html\n',
    'author': 'Ricky Bassom',
    'author_email': 'rickybas12@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/gmn-data-platform/gmn-python-api',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<4.0.0',
}


setup(**setup_kwargs)
