# Copyright 2021 The Tekton Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Tekton

    Tekton Pipeline  # noqa: E501

    The version of the OpenAPI document: v0.17.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tekton_pipeline.configuration import Configuration


class V1beta1PipelineRunSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'params': 'list[V1beta1Param]',
        'pipeline_ref': 'V1beta1PipelineRef',
        'pipeline_spec': 'V1beta1PipelineSpec',
        'pod_template': 'PodTemplate',
        'resources': 'list[V1beta1PipelineResourceBinding]',
        'service_account_name': 'str',
        'service_account_names': 'list[V1beta1PipelineRunSpecServiceAccountName]',
        'status': 'str',
        'task_run_specs': 'list[V1beta1PipelineTaskRunSpec]',
        'timeout': 'V1Duration',
        'timeouts': 'V1beta1TimeoutFields',
        'workspaces': 'list[V1beta1WorkspaceBinding]'
    }

    attribute_map = {
        'params': 'params',
        'pipeline_ref': 'pipelineRef',
        'pipeline_spec': 'pipelineSpec',
        'pod_template': 'podTemplate',
        'resources': 'resources',
        'service_account_name': 'serviceAccountName',
        'service_account_names': 'serviceAccountNames',
        'status': 'status',
        'task_run_specs': 'taskRunSpecs',
        'timeout': 'timeout',
        'timeouts': 'timeouts',
        'workspaces': 'workspaces'
    }

    def __init__(self, params=None, pipeline_ref=None, pipeline_spec=None, pod_template=None, resources=None, service_account_name=None, service_account_names=None, status=None, task_run_specs=None, timeout=None, timeouts=None, workspaces=None, local_vars_configuration=None):  # noqa: E501
        """V1beta1PipelineRunSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._params = None
        self._pipeline_ref = None
        self._pipeline_spec = None
        self._pod_template = None
        self._resources = None
        self._service_account_name = None
        self._service_account_names = None
        self._status = None
        self._task_run_specs = None
        self._timeout = None
        self._timeouts = None
        self._workspaces = None
        self.discriminator = None

        if params is not None:
            self.params = params
        if pipeline_ref is not None:
            self.pipeline_ref = pipeline_ref
        if pipeline_spec is not None:
            self.pipeline_spec = pipeline_spec
        if pod_template is not None:
            self.pod_template = pod_template
        if resources is not None:
            self.resources = resources
        if service_account_name is not None:
            self.service_account_name = service_account_name
        if service_account_names is not None:
            self.service_account_names = service_account_names
        if status is not None:
            self.status = status
        if task_run_specs is not None:
            self.task_run_specs = task_run_specs
        if timeout is not None:
            self.timeout = timeout
        if timeouts is not None:
            self.timeouts = timeouts
        if workspaces is not None:
            self.workspaces = workspaces

    @property
    def params(self):
        """Gets the params of this V1beta1PipelineRunSpec.  # noqa: E501

        Params is a list of parameter names and values.  # noqa: E501

        :return: The params of this V1beta1PipelineRunSpec.  # noqa: E501
        :rtype: list[V1beta1Param]
        """
        return self._params

    @params.setter
    def params(self, params):
        """Sets the params of this V1beta1PipelineRunSpec.

        Params is a list of parameter names and values.  # noqa: E501

        :param params: The params of this V1beta1PipelineRunSpec.  # noqa: E501
        :type: list[V1beta1Param]
        """

        self._params = params

    @property
    def pipeline_ref(self):
        """Gets the pipeline_ref of this V1beta1PipelineRunSpec.  # noqa: E501


        :return: The pipeline_ref of this V1beta1PipelineRunSpec.  # noqa: E501
        :rtype: V1beta1PipelineRef
        """
        return self._pipeline_ref

    @pipeline_ref.setter
    def pipeline_ref(self, pipeline_ref):
        """Sets the pipeline_ref of this V1beta1PipelineRunSpec.


        :param pipeline_ref: The pipeline_ref of this V1beta1PipelineRunSpec.  # noqa: E501
        :type: V1beta1PipelineRef
        """

        self._pipeline_ref = pipeline_ref

    @property
    def pipeline_spec(self):
        """Gets the pipeline_spec of this V1beta1PipelineRunSpec.  # noqa: E501


        :return: The pipeline_spec of this V1beta1PipelineRunSpec.  # noqa: E501
        :rtype: V1beta1PipelineSpec
        """
        return self._pipeline_spec

    @pipeline_spec.setter
    def pipeline_spec(self, pipeline_spec):
        """Sets the pipeline_spec of this V1beta1PipelineRunSpec.


        :param pipeline_spec: The pipeline_spec of this V1beta1PipelineRunSpec.  # noqa: E501
        :type: V1beta1PipelineSpec
        """

        self._pipeline_spec = pipeline_spec

    @property
    def pod_template(self):
        """Gets the pod_template of this V1beta1PipelineRunSpec.  # noqa: E501


        :return: The pod_template of this V1beta1PipelineRunSpec.  # noqa: E501
        :rtype: PodTemplate
        """
        return self._pod_template

    @pod_template.setter
    def pod_template(self, pod_template):
        """Sets the pod_template of this V1beta1PipelineRunSpec.


        :param pod_template: The pod_template of this V1beta1PipelineRunSpec.  # noqa: E501
        :type: PodTemplate
        """

        self._pod_template = pod_template

    @property
    def resources(self):
        """Gets the resources of this V1beta1PipelineRunSpec.  # noqa: E501

        Resources is a list of bindings specifying which actual instances of PipelineResources to use for the resources the Pipeline has declared it needs.  # noqa: E501

        :return: The resources of this V1beta1PipelineRunSpec.  # noqa: E501
        :rtype: list[V1beta1PipelineResourceBinding]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this V1beta1PipelineRunSpec.

        Resources is a list of bindings specifying which actual instances of PipelineResources to use for the resources the Pipeline has declared it needs.  # noqa: E501

        :param resources: The resources of this V1beta1PipelineRunSpec.  # noqa: E501
        :type: list[V1beta1PipelineResourceBinding]
        """

        self._resources = resources

    @property
    def service_account_name(self):
        """Gets the service_account_name of this V1beta1PipelineRunSpec.  # noqa: E501


        :return: The service_account_name of this V1beta1PipelineRunSpec.  # noqa: E501
        :rtype: str
        """
        return self._service_account_name

    @service_account_name.setter
    def service_account_name(self, service_account_name):
        """Sets the service_account_name of this V1beta1PipelineRunSpec.


        :param service_account_name: The service_account_name of this V1beta1PipelineRunSpec.  # noqa: E501
        :type: str
        """

        self._service_account_name = service_account_name

    @property
    def service_account_names(self):
        """Gets the service_account_names of this V1beta1PipelineRunSpec.  # noqa: E501

        Deprecated: use taskRunSpecs.ServiceAccountName instead  # noqa: E501

        :return: The service_account_names of this V1beta1PipelineRunSpec.  # noqa: E501
        :rtype: list[V1beta1PipelineRunSpecServiceAccountName]
        """
        return self._service_account_names

    @service_account_names.setter
    def service_account_names(self, service_account_names):
        """Sets the service_account_names of this V1beta1PipelineRunSpec.

        Deprecated: use taskRunSpecs.ServiceAccountName instead  # noqa: E501

        :param service_account_names: The service_account_names of this V1beta1PipelineRunSpec.  # noqa: E501
        :type: list[V1beta1PipelineRunSpecServiceAccountName]
        """

        self._service_account_names = service_account_names

    @property
    def status(self):
        """Gets the status of this V1beta1PipelineRunSpec.  # noqa: E501

        Used for cancelling a pipelinerun (and maybe more later on)  # noqa: E501

        :return: The status of this V1beta1PipelineRunSpec.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this V1beta1PipelineRunSpec.

        Used for cancelling a pipelinerun (and maybe more later on)  # noqa: E501

        :param status: The status of this V1beta1PipelineRunSpec.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def task_run_specs(self):
        """Gets the task_run_specs of this V1beta1PipelineRunSpec.  # noqa: E501

        TaskRunSpecs holds a set of runtime specs  # noqa: E501

        :return: The task_run_specs of this V1beta1PipelineRunSpec.  # noqa: E501
        :rtype: list[V1beta1PipelineTaskRunSpec]
        """
        return self._task_run_specs

    @task_run_specs.setter
    def task_run_specs(self, task_run_specs):
        """Sets the task_run_specs of this V1beta1PipelineRunSpec.

        TaskRunSpecs holds a set of runtime specs  # noqa: E501

        :param task_run_specs: The task_run_specs of this V1beta1PipelineRunSpec.  # noqa: E501
        :type: list[V1beta1PipelineTaskRunSpec]
        """

        self._task_run_specs = task_run_specs

    @property
    def timeout(self):
        """Gets the timeout of this V1beta1PipelineRunSpec.  # noqa: E501


        :return: The timeout of this V1beta1PipelineRunSpec.  # noqa: E501
        :rtype: V1Duration
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """Sets the timeout of this V1beta1PipelineRunSpec.


        :param timeout: The timeout of this V1beta1PipelineRunSpec.  # noqa: E501
        :type: V1Duration
        """

        self._timeout = timeout

    @property
    def timeouts(self):
        """Gets the timeouts of this V1beta1PipelineRunSpec.  # noqa: E501


        :return: The timeouts of this V1beta1PipelineRunSpec.  # noqa: E501
        :rtype: V1beta1TimeoutFields
        """
        return self._timeouts

    @timeouts.setter
    def timeouts(self, timeouts):
        """Sets the timeouts of this V1beta1PipelineRunSpec.


        :param timeouts: The timeouts of this V1beta1PipelineRunSpec.  # noqa: E501
        :type: V1beta1TimeoutFields
        """

        self._timeouts = timeouts

    @property
    def workspaces(self):
        """Gets the workspaces of this V1beta1PipelineRunSpec.  # noqa: E501

        Workspaces holds a set of workspace bindings that must match names with those declared in the pipeline.  # noqa: E501

        :return: The workspaces of this V1beta1PipelineRunSpec.  # noqa: E501
        :rtype: list[V1beta1WorkspaceBinding]
        """
        return self._workspaces

    @workspaces.setter
    def workspaces(self, workspaces):
        """Sets the workspaces of this V1beta1PipelineRunSpec.

        Workspaces holds a set of workspace bindings that must match names with those declared in the pipeline.  # noqa: E501

        :param workspaces: The workspaces of this V1beta1PipelineRunSpec.  # noqa: E501
        :type: list[V1beta1WorkspaceBinding]
        """

        self._workspaces = workspaces

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1beta1PipelineRunSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1beta1PipelineRunSpec):
            return True

        return self.to_dict() != other.to_dict()
