# Copyright 2021 The Tekton Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Tekton

    Tekton Pipeline  # noqa: E501

    The version of the OpenAPI document: v0.17.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tekton_pipeline.configuration import Configuration


class V1beta1CloudEventDeliveryState(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'condition': 'str',
        'message': 'str',
        'retry_count': 'int',
        'sent_at': 'V1Time'
    }

    attribute_map = {
        'condition': 'condition',
        'message': 'message',
        'retry_count': 'retryCount',
        'sent_at': 'sentAt'
    }

    def __init__(self, condition=None, message='', retry_count=0, sent_at=None, local_vars_configuration=None):  # noqa: E501
        """V1beta1CloudEventDeliveryState - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._condition = None
        self._message = None
        self._retry_count = None
        self._sent_at = None
        self.discriminator = None

        if condition is not None:
            self.condition = condition
        self.message = message
        self.retry_count = retry_count
        if sent_at is not None:
            self.sent_at = sent_at

    @property
    def condition(self):
        """Gets the condition of this V1beta1CloudEventDeliveryState.  # noqa: E501

        Current status  # noqa: E501

        :return: The condition of this V1beta1CloudEventDeliveryState.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this V1beta1CloudEventDeliveryState.

        Current status  # noqa: E501

        :param condition: The condition of this V1beta1CloudEventDeliveryState.  # noqa: E501
        :type: str
        """

        self._condition = condition

    @property
    def message(self):
        """Gets the message of this V1beta1CloudEventDeliveryState.  # noqa: E501

        Error is the text of error (if any)  # noqa: E501

        :return: The message of this V1beta1CloudEventDeliveryState.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this V1beta1CloudEventDeliveryState.

        Error is the text of error (if any)  # noqa: E501

        :param message: The message of this V1beta1CloudEventDeliveryState.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and message is None:  # noqa: E501
            raise ValueError("Invalid value for `message`, must not be `None`")  # noqa: E501

        self._message = message

    @property
    def retry_count(self):
        """Gets the retry_count of this V1beta1CloudEventDeliveryState.  # noqa: E501

        RetryCount is the number of attempts of sending the cloud event  # noqa: E501

        :return: The retry_count of this V1beta1CloudEventDeliveryState.  # noqa: E501
        :rtype: int
        """
        return self._retry_count

    @retry_count.setter
    def retry_count(self, retry_count):
        """Sets the retry_count of this V1beta1CloudEventDeliveryState.

        RetryCount is the number of attempts of sending the cloud event  # noqa: E501

        :param retry_count: The retry_count of this V1beta1CloudEventDeliveryState.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and retry_count is None:  # noqa: E501
            raise ValueError("Invalid value for `retry_count`, must not be `None`")  # noqa: E501

        self._retry_count = retry_count

    @property
    def sent_at(self):
        """Gets the sent_at of this V1beta1CloudEventDeliveryState.  # noqa: E501


        :return: The sent_at of this V1beta1CloudEventDeliveryState.  # noqa: E501
        :rtype: V1Time
        """
        return self._sent_at

    @sent_at.setter
    def sent_at(self, sent_at):
        """Sets the sent_at of this V1beta1CloudEventDeliveryState.


        :param sent_at: The sent_at of this V1beta1CloudEventDeliveryState.  # noqa: E501
        :type: V1Time
        """

        self._sent_at = sent_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1beta1CloudEventDeliveryState):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1beta1CloudEventDeliveryState):
            return True

        return self.to_dict() != other.to_dict()
