# Spectral Explorer

**Spectral Explorer** is an interactive program that allows users to explore a detailed, fictional world generated by an AI model. Users can begin an adventure with their own input or a default prompt, setting the stage for the creation of a multi-layered narrative.

---

## Motivations
We set out to create a tool that could push the bounds on what is possible for AI generated text-based adventure games. We were unsatisfied with the current limitations of such experiences, and intended to address at least one of the current issues. While our project has not perfected this genre of game, it can be used as a foundation for future projects, as in this state, it can successfully generate a detailed and consistent narrative for a world that the player can explore.

---
## Features

### **Dynamic World Creation**
- Generates a fictional world with a deep and cohesive structure.  
- Key stages of generation include:
  - **World History**: Lays the foundation for the world's culture and events.  
  - **Regions**: Highlights distinct areas, each with unique characteristics and dynamics.  
  - **Sub-Regions**: Explores smaller, detailed areas within regions, enhancing immersion.

### **Interactive Exploration**
- Users can navigate and explore specific regions or sub-regions within the world.  
- Upon entering a sub-region, users receive vivid descriptions of their surroundings.  
- Interactive features allow users to:
  - Ask questions about the environment.
  - Perform actions.
  - Move to different areas.

### **Layered Context**
- Detailed context, including information about and the history of the world and important regions, is passed to the AI model at each stage of the generation process.  
- Ensures consistency and a holistic narrative across the world.  
- Addresses common issues in AI-generated text adventures, such as disjointed or unconnected storylines.

---

## Applications Beyond Gaming

The methodology used in Spectral Explorer—breaking down and contextualizing information at multiple levels—has broader implications, including:

- **AI-Driven Tutorials:**  
  Teaching complex tasks in a structured, easy-to-follow manner.  
- **Generating Structured Explanations:**  
  Providing clear, multi-layered insights across various domains.  

Spectral Explorer demonstrates the potential for AI to go beyond entertainment and contribute to education and content generation in innovative ways.

---

## Usage

- **Example Workflow Using Terminal:**
  1. python3 -m pip install --index-url https://test.pypi.org/simple/ --no-deps spectral-explorer 
  2. pip install openai 
  3. pip install pillow
  4. pip install devtools
  5. Use LM studio to run llama-3.2-1b-instruct model on http://localhost:1234/v1/
  6. Run the following from examples/example_slim_usage.py
  ```python
  import sys
  import threading
  sys.path.append("..")
  sys.path.append(".")
  from spectral_explorer.run import SpectralRuntime
  import dotenv
  import os

  # Get our API key for OpenAI
  # Create the runtime
  runtime = SpectralRuntime(
      {
          'model': "llama-3.2-1b-instruct",
          'url': 'http://localhost:1234/v1/',
          'update-schema': True
      }
  )

  runtime.run_backend_logic()
  ```

- **Example Workflow Using OpenAI API key:**
  1. python3 -m pip install --index-url https://test.pypi.org/simple/ --no-deps spectral-explorer
  2. pip install openai
  3. pip install pillow
  4. pip install devtools
  5. Add your own API key to a .env file as OPENAI_KEY
  6. Run the following from examples/example_openai_usage.py:
  ```python
  import sys
  sys.path.append("..")
  sys.path.append(".")
  from spectral_explorer.run import SpectralRuntime
  import dotenv
  import os


  #get our api key for open-ai
  dotenv.load_dotenv()

  #create the runtime, to connect with openai
  runtime = SpectralRuntime(
      {
          'model': 'gpt-4o-mini',
          'api-key': os.getenv("OPENAI_KEY")
      }
  )

  runtime.run_backend_logic()
  ```

- **Example Workflow with Frontend:**
  1. python3 -m pip install --index-url https://test.pypi.org/simple/ --no-deps spectral-explorer
  2. pip install openai
  3. pip install pillow
  4. pip install devtools
  5. Use LM studio to run llama-3.2-1b-instruct model on http://localhost:1234/v1/
  6. Run the code in examples/example_usage_visual.py
  
---

## Config

The following are the defaults for runtime:
```python
DEFAULT_RUNTIME_CONFIG= {
    'output_dir': './saves',
    'url': None,
    'api-key': 'lm-studio',
    'model': 'mistral-nemo-instruct-2407',
    'frontend-active':False ,
    'save-name': '/world.pkl',
    'story-prompt': "write about the history of a magical world called akhel. "
                "Focus on important events that might impact the world, or the citizens of it.",
    'update-schema': False, #set for true when using LM studio or if any schema problems arise
}

DEFAULT_FRONTEND_CONFIG = {
    'title': 'Spectral Explorer Example',
    'size': "1000x800",
    'show-image': False,
    'image-location': '',
    'notes-location': './notes'
}
```
When creating a SpectralRuntime() object, the config will default to these values, but you may overload these variables. \
### Runtime Config:
  - **output_dir** refers to the directory the program will save your game to. You should create your own saves folder or overload the variable with a different folder
  - **url** defaults to openai when None
  - **api-key** defaults to lm studio
  - **model** defaults to our preferred model
  - **frontend-active** defaults to not having a frontend and will use the terminal
  - **save-name** name of save file
  - **story-prompt** initial prompt for the model
  - **update-schema** should be set to true if using LM studio or if any schema problems arise

### Frontend Config: 
  - **title** title of frontend window
  - **size** size of frontend window
  - **show-image** whether or not to show an image in the background
  - **image-location** where the image file saved is locally
  - **notes-location** where notes are saved locally

---

## Future Works

- **State consistency**
    This project did not address the issue of maintaining changes to the environment over time or over multiple locations. 

- **Objectives and termination conditions:**
    There is currently no way to win or lose in this program and there is no clear objective.

- **Visuals**
    To further build off the use of AI to generate a text-based game, one could use the text of the game to generate AI images to act as the background of the current subregion/region.

---

## Authors and Contributors

### Authors
- **[Nicholas Hotelling]**  
  - Role: Backend Developer
  - Contributions: Implemented the heirarchical world generation system, implemented world navigation system, model tuning and prompt engineering.
  - Contact: [nicholashotelling@gmail.com] | [GitHub Profile](https://github.com/FunkiDunki)

- **[Baylor Pond]**  
  - Role: Documentation Specialist, Assistant Developer  
  - Contributions: Created README, connected backend to frontend using multi-thread approach, and assisted in project vision and implementation structure
  - Contact: [baylorpond@gmail.com] | [GitHub Profile](https://github.com/BPond4)

- **[Nicholas Perlich]**  
  - Role: Frontend Developer  
  - Contributions: Created a frontend for a better user experience and created a cohesive format to code structure and display for clear understanding and ease of adding to the code base
  - Contact: [nicholasperlich2003@gmail.com] | [GitHub Profile](https://github.com/NickPerlich)
---