# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VaultClusterArgs', 'VaultCluster']

@pulumi.input_type
class VaultClusterArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 hvn_id: pulumi.Input[str],
                 audit_log_config: Optional[pulumi.Input['VaultClusterAuditLogConfigArgs']] = None,
                 metrics_config: Optional[pulumi.Input['VaultClusterMetricsConfigArgs']] = None,
                 min_vault_version: Optional[pulumi.Input[str]] = None,
                 paths_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 primary_link: Optional[pulumi.Input[str]] = None,
                 public_endpoint: Optional[pulumi.Input[bool]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VaultCluster resource.
        :param pulumi.Input[str] cluster_id: The ID of the HCP Vault cluster.
        :param pulumi.Input[str] hvn_id: The ID of the HVN this HCP Vault cluster is associated to.
        :param pulumi.Input['VaultClusterAuditLogConfigArgs'] audit_log_config: The audit logs configuration for export.
               (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        :param pulumi.Input['VaultClusterMetricsConfigArgs'] metrics_config: The metrics configuration for export.
               (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        :param pulumi.Input[str] min_vault_version: The minimum Vault version to use when creating the cluster. If not specified, it is defaulted to the version that is
               currently recommended by HCP.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths_filters: The performance replication [paths filter](https://learn.hashicorp.com/tutorials/vault/paths-filter). Applies to
               performance replication secondaries only and operates in "deny" mode only.
        :param pulumi.Input[str] primary_link: The `self_link` of the HCP Vault Plus tier cluster which is the primary in the performance replication setup with this
               HCP Vault Plus tier cluster. If not specified, it is a standalone Plus tier HCP Vault cluster.
        :param pulumi.Input[bool] public_endpoint: Denotes that the cluster has a public endpoint. Defaults to false.
        :param pulumi.Input[str] tier: Tier of the HCP Vault cluster. Valid options for tiers - `dev`, `starter_small`, `standard_small`, `standard_medium`,
               `standard_large`, `plus_small`, `plus_medium`, `plus_large`. See [pricing
               information](https://cloud.hashicorp.com/pricing/vault).
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "hvn_id", hvn_id)
        if audit_log_config is not None:
            pulumi.set(__self__, "audit_log_config", audit_log_config)
        if metrics_config is not None:
            pulumi.set(__self__, "metrics_config", metrics_config)
        if min_vault_version is not None:
            pulumi.set(__self__, "min_vault_version", min_vault_version)
        if paths_filters is not None:
            pulumi.set(__self__, "paths_filters", paths_filters)
        if primary_link is not None:
            pulumi.set(__self__, "primary_link", primary_link)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The ID of the HCP Vault cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="hvnId")
    def hvn_id(self) -> pulumi.Input[str]:
        """
        The ID of the HVN this HCP Vault cluster is associated to.
        """
        return pulumi.get(self, "hvn_id")

    @hvn_id.setter
    def hvn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "hvn_id", value)

    @property
    @pulumi.getter(name="auditLogConfig")
    def audit_log_config(self) -> Optional[pulumi.Input['VaultClusterAuditLogConfigArgs']]:
        """
        The audit logs configuration for export.
        (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        """
        return pulumi.get(self, "audit_log_config")

    @audit_log_config.setter
    def audit_log_config(self, value: Optional[pulumi.Input['VaultClusterAuditLogConfigArgs']]):
        pulumi.set(self, "audit_log_config", value)

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> Optional[pulumi.Input['VaultClusterMetricsConfigArgs']]:
        """
        The metrics configuration for export.
        (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        """
        return pulumi.get(self, "metrics_config")

    @metrics_config.setter
    def metrics_config(self, value: Optional[pulumi.Input['VaultClusterMetricsConfigArgs']]):
        pulumi.set(self, "metrics_config", value)

    @property
    @pulumi.getter(name="minVaultVersion")
    def min_vault_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum Vault version to use when creating the cluster. If not specified, it is defaulted to the version that is
        currently recommended by HCP.
        """
        return pulumi.get(self, "min_vault_version")

    @min_vault_version.setter
    def min_vault_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_vault_version", value)

    @property
    @pulumi.getter(name="pathsFilters")
    def paths_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The performance replication [paths filter](https://learn.hashicorp.com/tutorials/vault/paths-filter). Applies to
        performance replication secondaries only and operates in "deny" mode only.
        """
        return pulumi.get(self, "paths_filters")

    @paths_filters.setter
    def paths_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths_filters", value)

    @property
    @pulumi.getter(name="primaryLink")
    def primary_link(self) -> Optional[pulumi.Input[str]]:
        """
        The `self_link` of the HCP Vault Plus tier cluster which is the primary in the performance replication setup with this
        HCP Vault Plus tier cluster. If not specified, it is a standalone Plus tier HCP Vault cluster.
        """
        return pulumi.get(self, "primary_link")

    @primary_link.setter
    def primary_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_link", value)

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes that the cluster has a public endpoint. Defaults to false.
        """
        return pulumi.get(self, "public_endpoint")

    @public_endpoint.setter
    def public_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_endpoint", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Tier of the HCP Vault cluster. Valid options for tiers - `dev`, `starter_small`, `standard_small`, `standard_medium`,
        `standard_large`, `plus_small`, `plus_medium`, `plus_large`. See [pricing
        information](https://cloud.hashicorp.com/pricing/vault).
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class _VaultClusterState:
    def __init__(__self__, *,
                 audit_log_config: Optional[pulumi.Input['VaultClusterAuditLogConfigArgs']] = None,
                 cloud_provider: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 hvn_id: Optional[pulumi.Input[str]] = None,
                 metrics_config: Optional[pulumi.Input['VaultClusterMetricsConfigArgs']] = None,
                 min_vault_version: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 paths_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 primary_link: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 public_endpoint: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 vault_private_endpoint_url: Optional[pulumi.Input[str]] = None,
                 vault_public_endpoint_url: Optional[pulumi.Input[str]] = None,
                 vault_version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VaultCluster resources.
        :param pulumi.Input['VaultClusterAuditLogConfigArgs'] audit_log_config: The audit logs configuration for export.
               (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        :param pulumi.Input[str] cloud_provider: The provider where the HCP Vault cluster is located.
        :param pulumi.Input[str] cluster_id: The ID of the HCP Vault cluster.
        :param pulumi.Input[str] created_at: The time that the Vault cluster was created.
        :param pulumi.Input[str] hvn_id: The ID of the HVN this HCP Vault cluster is associated to.
        :param pulumi.Input['VaultClusterMetricsConfigArgs'] metrics_config: The metrics configuration for export.
               (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        :param pulumi.Input[str] min_vault_version: The minimum Vault version to use when creating the cluster. If not specified, it is defaulted to the version that is
               currently recommended by HCP.
        :param pulumi.Input[str] namespace: The name of the customer namespace this HCP Vault cluster is located in.
        :param pulumi.Input[str] organization_id: The ID of the organization this HCP Vault cluster is located in.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths_filters: The performance replication [paths filter](https://learn.hashicorp.com/tutorials/vault/paths-filter). Applies to
               performance replication secondaries only and operates in "deny" mode only.
        :param pulumi.Input[str] primary_link: The `self_link` of the HCP Vault Plus tier cluster which is the primary in the performance replication setup with this
               HCP Vault Plus tier cluster. If not specified, it is a standalone Plus tier HCP Vault cluster.
        :param pulumi.Input[str] project_id: The ID of the project this HCP Vault cluster is located in.
        :param pulumi.Input[bool] public_endpoint: Denotes that the cluster has a public endpoint. Defaults to false.
        :param pulumi.Input[str] region: The region where the HCP Vault cluster is located.
        :param pulumi.Input[str] self_link: A unique URL identifying the Vault cluster.
        :param pulumi.Input[str] tier: Tier of the HCP Vault cluster. Valid options for tiers - `dev`, `starter_small`, `standard_small`, `standard_medium`,
               `standard_large`, `plus_small`, `plus_medium`, `plus_large`. See [pricing
               information](https://cloud.hashicorp.com/pricing/vault).
        :param pulumi.Input[str] vault_private_endpoint_url: The private URL for the Vault cluster.
        :param pulumi.Input[str] vault_public_endpoint_url: The public URL for the Vault cluster. This will be empty if `public_endpoint` is `false`.
        :param pulumi.Input[str] vault_version: The Vault version of the cluster.
        """
        if audit_log_config is not None:
            pulumi.set(__self__, "audit_log_config", audit_log_config)
        if cloud_provider is not None:
            pulumi.set(__self__, "cloud_provider", cloud_provider)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if hvn_id is not None:
            pulumi.set(__self__, "hvn_id", hvn_id)
        if metrics_config is not None:
            pulumi.set(__self__, "metrics_config", metrics_config)
        if min_vault_version is not None:
            pulumi.set(__self__, "min_vault_version", min_vault_version)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if paths_filters is not None:
            pulumi.set(__self__, "paths_filters", paths_filters)
        if primary_link is not None:
            pulumi.set(__self__, "primary_link", primary_link)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if vault_private_endpoint_url is not None:
            pulumi.set(__self__, "vault_private_endpoint_url", vault_private_endpoint_url)
        if vault_public_endpoint_url is not None:
            pulumi.set(__self__, "vault_public_endpoint_url", vault_public_endpoint_url)
        if vault_version is not None:
            pulumi.set(__self__, "vault_version", vault_version)

    @property
    @pulumi.getter(name="auditLogConfig")
    def audit_log_config(self) -> Optional[pulumi.Input['VaultClusterAuditLogConfigArgs']]:
        """
        The audit logs configuration for export.
        (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        """
        return pulumi.get(self, "audit_log_config")

    @audit_log_config.setter
    def audit_log_config(self, value: Optional[pulumi.Input['VaultClusterAuditLogConfigArgs']]):
        pulumi.set(self, "audit_log_config", value)

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> Optional[pulumi.Input[str]]:
        """
        The provider where the HCP Vault cluster is located.
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_provider", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the HCP Vault cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the Vault cluster was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="hvnId")
    def hvn_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the HVN this HCP Vault cluster is associated to.
        """
        return pulumi.get(self, "hvn_id")

    @hvn_id.setter
    def hvn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hvn_id", value)

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> Optional[pulumi.Input['VaultClusterMetricsConfigArgs']]:
        """
        The metrics configuration for export.
        (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        """
        return pulumi.get(self, "metrics_config")

    @metrics_config.setter
    def metrics_config(self, value: Optional[pulumi.Input['VaultClusterMetricsConfigArgs']]):
        pulumi.set(self, "metrics_config", value)

    @property
    @pulumi.getter(name="minVaultVersion")
    def min_vault_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum Vault version to use when creating the cluster. If not specified, it is defaulted to the version that is
        currently recommended by HCP.
        """
        return pulumi.get(self, "min_vault_version")

    @min_vault_version.setter
    def min_vault_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_vault_version", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the customer namespace this HCP Vault cluster is located in.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the organization this HCP Vault cluster is located in.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="pathsFilters")
    def paths_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The performance replication [paths filter](https://learn.hashicorp.com/tutorials/vault/paths-filter). Applies to
        performance replication secondaries only and operates in "deny" mode only.
        """
        return pulumi.get(self, "paths_filters")

    @paths_filters.setter
    def paths_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths_filters", value)

    @property
    @pulumi.getter(name="primaryLink")
    def primary_link(self) -> Optional[pulumi.Input[str]]:
        """
        The `self_link` of the HCP Vault Plus tier cluster which is the primary in the performance replication setup with this
        HCP Vault Plus tier cluster. If not specified, it is a standalone Plus tier HCP Vault cluster.
        """
        return pulumi.get(self, "primary_link")

    @primary_link.setter
    def primary_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_link", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project this HCP Vault cluster is located in.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes that the cluster has a public endpoint. Defaults to false.
        """
        return pulumi.get(self, "public_endpoint")

    @public_endpoint.setter
    def public_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_endpoint", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region where the HCP Vault cluster is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        A unique URL identifying the Vault cluster.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Tier of the HCP Vault cluster. Valid options for tiers - `dev`, `starter_small`, `standard_small`, `standard_medium`,
        `standard_large`, `plus_small`, `plus_medium`, `plus_large`. See [pricing
        information](https://cloud.hashicorp.com/pricing/vault).
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="vaultPrivateEndpointUrl")
    def vault_private_endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        The private URL for the Vault cluster.
        """
        return pulumi.get(self, "vault_private_endpoint_url")

    @vault_private_endpoint_url.setter
    def vault_private_endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_private_endpoint_url", value)

    @property
    @pulumi.getter(name="vaultPublicEndpointUrl")
    def vault_public_endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        The public URL for the Vault cluster. This will be empty if `public_endpoint` is `false`.
        """
        return pulumi.get(self, "vault_public_endpoint_url")

    @vault_public_endpoint_url.setter
    def vault_public_endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_public_endpoint_url", value)

    @property
    @pulumi.getter(name="vaultVersion")
    def vault_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Vault version of the cluster.
        """
        return pulumi.get(self, "vault_version")

    @vault_version.setter
    def vault_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_version", value)


class VaultCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_log_config: Optional[pulumi.Input[pulumi.InputType['VaultClusterAuditLogConfigArgs']]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 hvn_id: Optional[pulumi.Input[str]] = None,
                 metrics_config: Optional[pulumi.Input[pulumi.InputType['VaultClusterMetricsConfigArgs']]] = None,
                 min_vault_version: Optional[pulumi.Input[str]] = None,
                 paths_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 primary_link: Optional[pulumi.Input[str]] = None,
                 public_endpoint: Optional[pulumi.Input[bool]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        # The import ID is {cluster_id}

        ```sh
         $ pulumi import hcp:index/vaultCluster:VaultCluster example vault-cluster
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['VaultClusterAuditLogConfigArgs']] audit_log_config: The audit logs configuration for export.
               (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        :param pulumi.Input[str] cluster_id: The ID of the HCP Vault cluster.
        :param pulumi.Input[str] hvn_id: The ID of the HVN this HCP Vault cluster is associated to.
        :param pulumi.Input[pulumi.InputType['VaultClusterMetricsConfigArgs']] metrics_config: The metrics configuration for export.
               (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        :param pulumi.Input[str] min_vault_version: The minimum Vault version to use when creating the cluster. If not specified, it is defaulted to the version that is
               currently recommended by HCP.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths_filters: The performance replication [paths filter](https://learn.hashicorp.com/tutorials/vault/paths-filter). Applies to
               performance replication secondaries only and operates in "deny" mode only.
        :param pulumi.Input[str] primary_link: The `self_link` of the HCP Vault Plus tier cluster which is the primary in the performance replication setup with this
               HCP Vault Plus tier cluster. If not specified, it is a standalone Plus tier HCP Vault cluster.
        :param pulumi.Input[bool] public_endpoint: Denotes that the cluster has a public endpoint. Defaults to false.
        :param pulumi.Input[str] tier: Tier of the HCP Vault cluster. Valid options for tiers - `dev`, `starter_small`, `standard_small`, `standard_medium`,
               `standard_large`, `plus_small`, `plus_medium`, `plus_large`. See [pricing
               information](https://cloud.hashicorp.com/pricing/vault).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VaultClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        # The import ID is {cluster_id}

        ```sh
         $ pulumi import hcp:index/vaultCluster:VaultCluster example vault-cluster
        ```

        :param str resource_name: The name of the resource.
        :param VaultClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VaultClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_log_config: Optional[pulumi.Input[pulumi.InputType['VaultClusterAuditLogConfigArgs']]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 hvn_id: Optional[pulumi.Input[str]] = None,
                 metrics_config: Optional[pulumi.Input[pulumi.InputType['VaultClusterMetricsConfigArgs']]] = None,
                 min_vault_version: Optional[pulumi.Input[str]] = None,
                 paths_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 primary_link: Optional[pulumi.Input[str]] = None,
                 public_endpoint: Optional[pulumi.Input[bool]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VaultClusterArgs.__new__(VaultClusterArgs)

            __props__.__dict__["audit_log_config"] = audit_log_config
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if hvn_id is None and not opts.urn:
                raise TypeError("Missing required property 'hvn_id'")
            __props__.__dict__["hvn_id"] = hvn_id
            __props__.__dict__["metrics_config"] = metrics_config
            __props__.__dict__["min_vault_version"] = min_vault_version
            __props__.__dict__["paths_filters"] = paths_filters
            __props__.__dict__["primary_link"] = primary_link
            __props__.__dict__["public_endpoint"] = public_endpoint
            __props__.__dict__["tier"] = tier
            __props__.__dict__["cloud_provider"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["namespace"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["vault_private_endpoint_url"] = None
            __props__.__dict__["vault_public_endpoint_url"] = None
            __props__.__dict__["vault_version"] = None
        super(VaultCluster, __self__).__init__(
            'hcp:index/vaultCluster:VaultCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_log_config: Optional[pulumi.Input[pulumi.InputType['VaultClusterAuditLogConfigArgs']]] = None,
            cloud_provider: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            hvn_id: Optional[pulumi.Input[str]] = None,
            metrics_config: Optional[pulumi.Input[pulumi.InputType['VaultClusterMetricsConfigArgs']]] = None,
            min_vault_version: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            paths_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            primary_link: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            public_endpoint: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            tier: Optional[pulumi.Input[str]] = None,
            vault_private_endpoint_url: Optional[pulumi.Input[str]] = None,
            vault_public_endpoint_url: Optional[pulumi.Input[str]] = None,
            vault_version: Optional[pulumi.Input[str]] = None) -> 'VaultCluster':
        """
        Get an existing VaultCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['VaultClusterAuditLogConfigArgs']] audit_log_config: The audit logs configuration for export.
               (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        :param pulumi.Input[str] cloud_provider: The provider where the HCP Vault cluster is located.
        :param pulumi.Input[str] cluster_id: The ID of the HCP Vault cluster.
        :param pulumi.Input[str] created_at: The time that the Vault cluster was created.
        :param pulumi.Input[str] hvn_id: The ID of the HVN this HCP Vault cluster is associated to.
        :param pulumi.Input[pulumi.InputType['VaultClusterMetricsConfigArgs']] metrics_config: The metrics configuration for export.
               (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        :param pulumi.Input[str] min_vault_version: The minimum Vault version to use when creating the cluster. If not specified, it is defaulted to the version that is
               currently recommended by HCP.
        :param pulumi.Input[str] namespace: The name of the customer namespace this HCP Vault cluster is located in.
        :param pulumi.Input[str] organization_id: The ID of the organization this HCP Vault cluster is located in.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths_filters: The performance replication [paths filter](https://learn.hashicorp.com/tutorials/vault/paths-filter). Applies to
               performance replication secondaries only and operates in "deny" mode only.
        :param pulumi.Input[str] primary_link: The `self_link` of the HCP Vault Plus tier cluster which is the primary in the performance replication setup with this
               HCP Vault Plus tier cluster. If not specified, it is a standalone Plus tier HCP Vault cluster.
        :param pulumi.Input[str] project_id: The ID of the project this HCP Vault cluster is located in.
        :param pulumi.Input[bool] public_endpoint: Denotes that the cluster has a public endpoint. Defaults to false.
        :param pulumi.Input[str] region: The region where the HCP Vault cluster is located.
        :param pulumi.Input[str] self_link: A unique URL identifying the Vault cluster.
        :param pulumi.Input[str] tier: Tier of the HCP Vault cluster. Valid options for tiers - `dev`, `starter_small`, `standard_small`, `standard_medium`,
               `standard_large`, `plus_small`, `plus_medium`, `plus_large`. See [pricing
               information](https://cloud.hashicorp.com/pricing/vault).
        :param pulumi.Input[str] vault_private_endpoint_url: The private URL for the Vault cluster.
        :param pulumi.Input[str] vault_public_endpoint_url: The public URL for the Vault cluster. This will be empty if `public_endpoint` is `false`.
        :param pulumi.Input[str] vault_version: The Vault version of the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VaultClusterState.__new__(_VaultClusterState)

        __props__.__dict__["audit_log_config"] = audit_log_config
        __props__.__dict__["cloud_provider"] = cloud_provider
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["hvn_id"] = hvn_id
        __props__.__dict__["metrics_config"] = metrics_config
        __props__.__dict__["min_vault_version"] = min_vault_version
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["paths_filters"] = paths_filters
        __props__.__dict__["primary_link"] = primary_link
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_endpoint"] = public_endpoint
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["tier"] = tier
        __props__.__dict__["vault_private_endpoint_url"] = vault_private_endpoint_url
        __props__.__dict__["vault_public_endpoint_url"] = vault_public_endpoint_url
        __props__.__dict__["vault_version"] = vault_version
        return VaultCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="auditLogConfig")
    def audit_log_config(self) -> pulumi.Output[Optional['outputs.VaultClusterAuditLogConfig']]:
        """
        The audit logs configuration for export.
        (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        """
        return pulumi.get(self, "audit_log_config")

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Output[str]:
        """
        The provider where the HCP Vault cluster is located.
        """
        return pulumi.get(self, "cloud_provider")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The ID of the HCP Vault cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The time that the Vault cluster was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="hvnId")
    def hvn_id(self) -> pulumi.Output[str]:
        """
        The ID of the HVN this HCP Vault cluster is associated to.
        """
        return pulumi.get(self, "hvn_id")

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> pulumi.Output[Optional['outputs.VaultClusterMetricsConfig']]:
        """
        The metrics configuration for export.
        (https://learn.hashicorp.com/tutorials/cloud/vault-metrics-guide#metrics-streaming-configuration)
        """
        return pulumi.get(self, "metrics_config")

    @property
    @pulumi.getter(name="minVaultVersion")
    def min_vault_version(self) -> pulumi.Output[Optional[str]]:
        """
        The minimum Vault version to use when creating the cluster. If not specified, it is defaulted to the version that is
        currently recommended by HCP.
        """
        return pulumi.get(self, "min_vault_version")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The name of the customer namespace this HCP Vault cluster is located in.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The ID of the organization this HCP Vault cluster is located in.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="pathsFilters")
    def paths_filters(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The performance replication [paths filter](https://learn.hashicorp.com/tutorials/vault/paths-filter). Applies to
        performance replication secondaries only and operates in "deny" mode only.
        """
        return pulumi.get(self, "paths_filters")

    @property
    @pulumi.getter(name="primaryLink")
    def primary_link(self) -> pulumi.Output[Optional[str]]:
        """
        The `self_link` of the HCP Vault Plus tier cluster which is the primary in the performance replication setup with this
        HCP Vault Plus tier cluster. If not specified, it is a standalone Plus tier HCP Vault cluster.
        """
        return pulumi.get(self, "primary_link")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the project this HCP Vault cluster is located in.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> pulumi.Output[Optional[bool]]:
        """
        Denotes that the cluster has a public endpoint. Defaults to false.
        """
        return pulumi.get(self, "public_endpoint")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region where the HCP Vault cluster is located.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        A unique URL identifying the Vault cluster.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[str]:
        """
        Tier of the HCP Vault cluster. Valid options for tiers - `dev`, `starter_small`, `standard_small`, `standard_medium`,
        `standard_large`, `plus_small`, `plus_medium`, `plus_large`. See [pricing
        information](https://cloud.hashicorp.com/pricing/vault).
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="vaultPrivateEndpointUrl")
    def vault_private_endpoint_url(self) -> pulumi.Output[str]:
        """
        The private URL for the Vault cluster.
        """
        return pulumi.get(self, "vault_private_endpoint_url")

    @property
    @pulumi.getter(name="vaultPublicEndpointUrl")
    def vault_public_endpoint_url(self) -> pulumi.Output[str]:
        """
        The public URL for the Vault cluster. This will be empty if `public_endpoint` is `false`.
        """
        return pulumi.get(self, "vault_public_endpoint_url")

    @property
    @pulumi.getter(name="vaultVersion")
    def vault_version(self) -> pulumi.Output[str]:
        """
        The Vault version of the cluster.
        """
        return pulumi.get(self, "vault_version")

