"use strict";
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.FSxMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class FSxMetrics {
    static dataReadBytesSum(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'DataReadBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static dataWriteBytesSum(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'DataWriteBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static freeDataStorageCapacitySum(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'FreeDataStorageCapacity',
            dimensions,
            statistic: 'Sum',
        };
    }
    static dataReadOperationsSum(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'DataReadOperations',
            dimensions,
            statistic: 'Sum',
        };
    }
    static dataWriteOperationsSum(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'DataWriteOperations',
            dimensions,
            statistic: 'Sum',
        };
    }
    static metadataOperationsSum(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'MetadataOperations',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.FSxMetrics = FSxMetrics;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnN4LWNhbm5lZC1tZXRyaWNzLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImZzeC1jYW5uZWQtbWV0cmljcy5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLCtFQUErRTs7O0FBRS9FLDRCQUE0QixDQUFDLGlFQUFpRTtBQUU5RixNQUFhLFVBQVU7SUFDZCxNQUFNLENBQUMsZ0JBQWdCLENBQUMsVUFBb0M7UUFDakUsT0FBTztZQUNMLFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSxlQUFlO1lBQzNCLFVBQVU7WUFDVixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0lBQ0osQ0FBQztJQUNNLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxVQUFvQztRQUNsRSxPQUFPO1lBQ0wsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLGdCQUFnQjtZQUM1QixVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDakIsQ0FBQztJQUNKLENBQUM7SUFDTSxNQUFNLENBQUMsMEJBQTBCLENBQUMsVUFBb0M7UUFDM0UsT0FBTztZQUNMLFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSx5QkFBeUI7WUFDckMsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ2pCLENBQUM7SUFDSixDQUFDO0lBQ00sTUFBTSxDQUFDLHFCQUFxQixDQUFDLFVBQW9DO1FBQ3RFLE9BQU87WUFDTCxTQUFTLEVBQUUsU0FBUztZQUNwQixVQUFVLEVBQUUsb0JBQW9CO1lBQ2hDLFVBQVU7WUFDVixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0lBQ0osQ0FBQztJQUNNLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQyxVQUFvQztRQUN2RSxPQUFPO1lBQ0wsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLHFCQUFxQjtZQUNqQyxVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDakIsQ0FBQztJQUNKLENBQUM7SUFDTSxNQUFNLENBQUMscUJBQXFCLENBQUMsVUFBb0M7UUFDdEUsT0FBTztZQUNMLFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSxvQkFBb0I7WUFDaEMsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ2pCLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFqREQsZ0NBaURDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTItMjAyMSBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuICovIC8vIFRoaXMgaXMgZ2VuZXJhdGVkIGNvZGUgLSBsaW5lIGxlbmd0aHMgYXJlIGRpZmZpY3VsdCB0byBjb250cm9sXG5cbmV4cG9ydCBjbGFzcyBGU3hNZXRyaWNzIHtcbiAgcHVibGljIHN0YXRpYyBkYXRhUmVhZEJ5dGVzU3VtKGRpbWVuc2lvbnM6IHsgRmlsZVN5c3RlbUlkOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvRlN4JyxcbiAgICAgIG1ldHJpY05hbWU6ICdEYXRhUmVhZEJ5dGVzJyxcbiAgICAgIGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyBkYXRhV3JpdGVCeXRlc1N1bShkaW1lbnNpb25zOiB7IEZpbGVTeXN0ZW1JZDogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL0ZTeCcsXG4gICAgICBtZXRyaWNOYW1lOiAnRGF0YVdyaXRlQnl0ZXMnLFxuICAgICAgZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIGZyZWVEYXRhU3RvcmFnZUNhcGFjaXR5U3VtKGRpbWVuc2lvbnM6IHsgRmlsZVN5c3RlbUlkOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvRlN4JyxcbiAgICAgIG1ldHJpY05hbWU6ICdGcmVlRGF0YVN0b3JhZ2VDYXBhY2l0eScsXG4gICAgICBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgZGF0YVJlYWRPcGVyYXRpb25zU3VtKGRpbWVuc2lvbnM6IHsgRmlsZVN5c3RlbUlkOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvRlN4JyxcbiAgICAgIG1ldHJpY05hbWU6ICdEYXRhUmVhZE9wZXJhdGlvbnMnLFxuICAgICAgZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIGRhdGFXcml0ZU9wZXJhdGlvbnNTdW0oZGltZW5zaW9uczogeyBGaWxlU3lzdGVtSWQ6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9GU3gnLFxuICAgICAgbWV0cmljTmFtZTogJ0RhdGFXcml0ZU9wZXJhdGlvbnMnLFxuICAgICAgZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIG1ldGFkYXRhT3BlcmF0aW9uc1N1bShkaW1lbnNpb25zOiB7IEZpbGVTeXN0ZW1JZDogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL0ZTeCcsXG4gICAgICBtZXRyaWNOYW1lOiAnTWV0YWRhdGFPcGVyYXRpb25zJyxcbiAgICAgIGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==