"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketLambdaAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Authorize WebSocket Api routes via a lambda function
 */
class WebSocketLambdaAuthorizer {
    constructor(id, handler, props = {}) {
        this.id = id;
        this.handler = handler;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_WebSocketLambdaAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(options) {
        var _b, _c;
        if (this.webSocketApi && (this.webSocketApi.apiId !== options.route.webSocketApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            this.webSocketApi = options.route.webSocketApi;
            this.authorizer = new aws_apigatewayv2_alpha_1.WebSocketAuthorizer(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                identitySource: (_b = this.props.identitySource) !== null && _b !== void 0 ? _b : [
                    'route.request.header.Authorization',
                ],
                type: aws_apigatewayv2_alpha_1.WebSocketAuthorizerType.LAMBDA,
                authorizerName: (_c = this.props.authorizerName) !== null && _c !== void 0 ? _c : this.id,
                authorizerUri: lambdaAuthorizerArn(this.handler),
            });
            this.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: aws_cdk_lib_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.webSocketApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.WebSocketLambdaAuthorizer = WebSocketLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
WebSocketLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.WebSocketLambdaAuthorizer", version: "2.21.0-alpha.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${aws_cdk_lib_1.Stack.of(handler).partition}:apigateway:${aws_cdk_lib_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,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