# plotrisk_python_client
farm API documentation

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.1
- Package version: 0.0.2
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import plotrisk_python_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import plotrisk_python_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import plotrisk_python_client
from plotrisk_python_client.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = plotrisk_python_client.PlotRiskResourceApi(plotrisk_python_client.ApiClient(configuration))
ca_id = 789 # int | Unique identifier for plot/CA , e.g. caId= 1234
_date = '_date_example' # str | Indicates captured satellite date in yyyy-MM-dd format. The date must be picked from the satellite data API response. e.g. date=2022-03-15
image_name = 'image_name_example' # str | Plot image name, e.g imageName = NDRE .
image_type = 'image_type_example' # str | Plot image type, e.g imageType = TIFF (optional)

try:
    # downloadImage
    api_response = api_instance.download_image_using_get(ca_id, _date, image_name, image_type=image_type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling PlotRiskResourceApi->download_image_using_get: %s\n" % e)

# create an instance of the API class
api_instance = plotrisk_python_client.PlotRiskResourceApi(plotrisk_python_client.ApiClient(configuration))
name = 'name_example' # str | Filter by Plot/CA name, e.g name=test (optional)
page = plotrisk_python_client.Ref() # Ref | Page represents page no. in a paginated response.Page starts from 0, valid page can be zero or a positive number. (optional)
size = plotrisk_python_client.Ref() # Ref | Size represents the number of records that are displayed when a page loads. Default size is 50. (optional)
sort = plotrisk_python_client.Ref() # Ref | Sort the result based on given field/fields in natural sorting order (Ascending). Multiple sorting criteria are supported,  e.g.  sort = name ,<asc|desc> (optional)

try:
    # getPlots
    api_response = api_instance.get_plots_using_get(name=name, page=page, size=size, sort=sort)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling PlotRiskResourceApi->get_plots_using_get: %s\n" % e)

# create an instance of the API class
api_instance = plotrisk_python_client.PlotRiskResourceApi(plotrisk_python_client.ApiClient(configuration))
ca_ids = plotrisk_python_client.Ref() # Ref | Unique identifiers for plot/CA, e.g. caIds=1234,5678 (optional)
captured_date_time = 'captured_date_time_example' # str | Indicates timestamp when satellite insights processed, e.g. date = 2021-12-23T00:00:00Z (optional)
category = 'category_example' # str | Cloud mask parameter. (optional)
max_cloud_coverage = 'max_cloud_coverage_example' # str | Cloud coverage refers the fraction of sky covered with clouds, filters record where cloudCoverge <= maxCloudCoverage (optional)
min_cloud_coverage = 'min_cloud_coverage_example' # str | Cloud coverage refers the fraction of sky covered with clouds, filters record where cloudCoverge >= minCloudCoverage (optional)
order_by = 'order_by_example' # str | Order the result in ascending or descending format. Default order is 'ASC' (optional)
page = plotrisk_python_client.Ref() # Ref | Page represents page no. in a paginated response.Page starts from 0, valid page can be zero or a positive number. (optional)
select = plotrisk_python_client.Ref() # Ref | Select specific field or fields to return as part of result, e.g select = fieldName  (optional)
size = plotrisk_python_client.Ref() # Ref | Size represents the number of records that are displayed when a page loads,it can be between 10 to 300. Default size is 50. (optional)
sort_by = 'sort_by_example' # str | Sort the result based on given field/fields in natural sorting order (ASC). Maximum 2 fields are allowed. (optional)

try:
    # GetSatellite
    api_response = api_instance.get_satellite_using_get(ca_ids=ca_ids, captured_date_time=captured_date_time, category=category, max_cloud_coverage=max_cloud_coverage, min_cloud_coverage=min_cloud_coverage, order_by=order_by, page=page, select=select, size=size, sort_by=sort_by)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling PlotRiskResourceApi->get_satellite_using_get: %s\n" % e)

# create an instance of the API class
api_instance = plotrisk_python_client.PlotRiskResourceApi(plotrisk_python_client.ApiClient(configuration))
ca_ids = plotrisk_python_client.Ref() # Ref | Unique identifiers for plot/CA, e.g. caIds=1234,5678 (optional)
_date = '_date_example' # str | Indicates timestamp when satellite insights processed, e.g. date = 2021-12-23T00:00:00Z (optional)
date_from = 'date_from_example' # str | Filter records for specific date range e.g. dateFrom = 2021-12-23T00:00:00Z (optional)
date_to = 'date_to_example' # str | Filter records for specific date range e.g. dateTo = 2021-12-23T00:00:00Z (optional)
order_by = 'order_by_example' # str | Order the result in ascending or descending format. Default order is 'ASC' (optional)
page = plotrisk_python_client.Ref() # Ref | Page represents page no. in a paginated response.Page starts from 0, valid page can be zero or a positive number. (optional)
size = plotrisk_python_client.Ref() # Ref | Size represents the number of records that are displayed when a page loads,it can be between 10 to 300. Default size is 50. (optional)
sort_by = 'sort_by_example' # str | Sort the result based on given field/fields in natural sorting order (ASC). Maximum 2 fields are allowed. (optional)

try:
    # getWeather
    api_response = api_instance.get_weather_using_get(ca_ids=ca_ids, _date=_date, date_from=date_from, date_to=date_to, order_by=order_by, page=page, size=size, sort_by=sort_by)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling PlotRiskResourceApi->get_weather_using_get: %s\n" % e)

# create an instance of the API class
api_instance = plotrisk_python_client.PlotRiskResourceApi(plotrisk_python_client.ApiClient(configuration))
ca_ids = plotrisk_python_client.Ref() # Ref | Unique identifiers for plot/CA, e.g. caIds=1234,5678 (optional)
order_by = 'order_by_example' # str | Order the result in ascending or descending format. Default order is 'ASC' (optional)
page = plotrisk_python_client.Ref() # Ref | Page represents page no. in a paginated response.Page starts from 0, valid page can be zero or a positive number. (optional)
size = plotrisk_python_client.Ref() # Ref | Size represents the number of records that are displayed when a page loads,it can be between 10 to 300. Default size is 50. (optional)
sort_by = 'sort_by_example' # str | Sort the result based on given field/fields in natural sorting order (ASC). Maximum 2 fields are allowed. (optional)

try:
    # getYield
    api_response = api_instance.get_yield_using_get(ca_ids=ca_ids, order_by=order_by, page=page, size=size, sort_by=sort_by)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling PlotRiskResourceApi->get_yield_using_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *//eu-v2dev.cropin.co.in/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PlotRiskResourceApi* | [**download_image_using_get**](docs/PlotRiskResourceApi.md#download_image_using_get) | **GET** /api/plot-risk/download | downloadImage
*PlotRiskResourceApi* | [**get_plots_using_get**](docs/PlotRiskResourceApi.md#get_plots_using_get) | **GET** /api/plot-risk/plots | getPlots
*PlotRiskResourceApi* | [**get_satellite_using_get**](docs/PlotRiskResourceApi.md#get_satellite_using_get) | **GET** /api/plot-risk/satellite | GetSatellite
*PlotRiskResourceApi* | [**get_weather_using_get**](docs/PlotRiskResourceApi.md#get_weather_using_get) | **GET** /api/plot-risk/weather | getWeather
*PlotRiskResourceApi* | [**get_yield_using_get**](docs/PlotRiskResourceApi.md#get_yield_using_get) | **GET** /api/plot-risk/yield | getYield

## Documentation For Models

 - [AddPlanFilterAndBulkSelectDto](docs/AddPlanFilterAndBulkSelectDto.md)
 - [AddressDto](docs/AddressDto.md)
 - [Area](docs/Area.md)
 - [AreaAuditDto](docs/AreaAuditDto.md)
 - [AssetConciseDto](docs/AssetConciseDto.md)
 - [AssetDto](docs/AssetDto.md)
 - [AssetsFarmerFilterDto](docs/AssetsFarmerFilterDto.md)
 - [AvailableAssetsDto](docs/AvailableAssetsDto.md)
 - [AvailableFarmerDto](docs/AvailableFarmerDto.md)
 - [BatchDetailsDto](docs/BatchDetailsDto.md)
 - [BatchDetailsReportDto](docs/BatchDetailsReportDto.md)
 - [BatchDetailsReportResponse](docs/BatchDetailsReportResponse.md)
 - [BatchNumberCounter](docs/BatchNumberCounter.md)
 - [BatchReportDto](docs/BatchReportDto.md)
 - [BatchReportSearchDto](docs/BatchReportSearchDto.md)
 - [BatchReportsDto](docs/BatchReportsDto.md)
 - [BatchSampleDto](docs/BatchSampleDto.md)
 - [BoundaryMetrics](docs/BoundaryMetrics.md)
 - [BulkCADto](docs/BulkCADto.md)
 - [BulkCropVarietyDto](docs/BulkCropVarietyDto.md)
 - [BulkCroppableAreaDto](docs/BulkCroppableAreaDto.md)
 - [BulkCroppableUnitDto](docs/BulkCroppableUnitDto.md)
 - [BulkPlanDto](docs/BulkPlanDto.md)
 - [BulkProcessDto](docs/BulkProcessDto.md)
 - [BulkUploadESDto](docs/BulkUploadESDto.md)
 - [BulkUploadTaskDto](docs/BulkUploadTaskDto.md)
 - [CAConciseDto](docs/CAConciseDto.md)
 - [CUConciseDto](docs/CUConciseDto.md)
 - [CUVarietyDto](docs/CUVarietyDto.md)
 - [CaDtoForForm](docs/CaDtoForForm.md)
 - [CaStatusCountDto](docs/CaStatusCountDto.md)
 - [CaUserUpdateDto](docs/CaUserUpdateDto.md)
 - [ChemicalDetailsDto](docs/ChemicalDetailsDto.md)
 - [ChemicalTypeDto](docs/ChemicalTypeDto.md)
 - [ClosePlotReasonDto](docs/ClosePlotReasonDto.md)
 - [CompanyDto](docs/CompanyDto.md)
 - [CompanyLookUpValuesDto](docs/CompanyLookUpValuesDto.md)
 - [ContractorDto](docs/ContractorDto.md)
 - [CropDetails](docs/CropDetails.md)
 - [CropDto](docs/CropDto.md)
 - [CropIssueDto](docs/CropIssueDto.md)
 - [CropMetric](docs/CropMetric.md)
 - [CropPreference](docs/CropPreference.md)
 - [CropStageDBDto](docs/CropStageDBDto.md)
 - [CropStageDto](docs/CropStageDto.md)
 - [CropStageSRDto](docs/CropStageSRDto.md)
 - [CropUnitDto](docs/CropUnitDto.md)
 - [CroppableAreaCropStageDto](docs/CroppableAreaCropStageDto.md)
 - [CroppableAreaDTO](docs/CroppableAreaDTO.md)
 - [CroppableAreaDto](docs/CroppableAreaDto.md)
 - [CroppableAreaDtoPlotRisk](docs/CroppableAreaDtoPlotRisk.md)
 - [CroppableAreaDtoV1](docs/CroppableAreaDtoV1.md)
 - [CroppableAreaSelectAllFilterDto](docs/CroppableAreaSelectAllFilterDto.md)
 - [CroppableAreaUserDto](docs/CroppableAreaUserDto.md)
 - [CustomErrorResponse](docs/CustomErrorResponse.md)
 - [DashBoardPlotDto](docs/DashBoardPlotDto.md)
 - [DeltaSyncCaUserDto](docs/DeltaSyncCaUserDto.md)
 - [DepartmentDto](docs/DepartmentDto.md)
 - [DetailingMassUploadDto](docs/DetailingMassUploadDto.md)
 - [DetailingMassUploadFilterDto](docs/DetailingMassUploadFilterDto.md)
 - [EmployeeDto](docs/EmployeeDto.md)
 - [FarmResourceDto](docs/FarmResourceDto.md)
 - [FarmResourceTypeDto](docs/FarmResourceTypeDto.md)
 - [FarmerConciseDto](docs/FarmerConciseDto.md)
 - [FarmerDTO](docs/FarmerDTO.md)
 - [FarmerDto](docs/FarmerDto.md)
 - [FarmerFilterDto](docs/FarmerFilterDto.md)
 - [FarmerSyncDto](docs/FarmerSyncDto.md)
 - [File](docs/File.md)
 - [FilledFormDto](docs/FilledFormDto.md)
 - [FilledFormSummaryDto](docs/FilledFormSummaryDto.md)
 - [FilterAssetDto](docs/FilterAssetDto.md)
 - [FormDto](docs/FormDto.md)
 - [FormTypeDto](docs/FormTypeDto.md)
 - [FormUserRelation](docs/FormUserRelation.md)
 - [FormsByTypeDto](docs/FormsByTypeDto.md)
 - [Gdd](docs/Gdd.md)
 - [HarvestDto](docs/HarvestDto.md)
 - [HarvestGradeDto](docs/HarvestGradeDto.md)
 - [HarvestLossDto](docs/HarvestLossDto.md)
 - [HarvestLossPercentageDto](docs/HarvestLossPercentageDto.md)
 - [HarvestQuantity](docs/HarvestQuantity.md)
 - [HarvestReasonDto](docs/HarvestReasonDto.md)
 - [HashMapOfstringAndobject](docs/HashMapOfstringAndobject.md)
 - [InputStream](docs/InputStream.md)
 - [IrrigationTypeDto](docs/IrrigationTypeDto.md)
 - [KeycloakResourceDto](docs/KeycloakResourceDto.md)
 - [LanguageId](docs/LanguageId.md)
 - [LanguageMaster](docs/LanguageMaster.md)
 - [LanguageMasterDto](docs/LanguageMasterDto.md)
 - [LanguageTranslateDto](docs/LanguageTranslateDto.md)
 - [LocaleDto](docs/LocaleDto.md)
 - [LocationDto](docs/LocationDto.md)
 - [LookUpValuesDto](docs/LookUpValuesDto.md)
 - [Lookup](docs/Lookup.md)
 - [LookupDto](docs/LookupDto.md)
 - [MapOfstringAndstring](docs/MapOfstringAndstring.md)
 - [MarkerDto](docs/MarkerDto.md)
 - [MergeBatchDetailsDto](docs/MergeBatchDetailsDto.md)
 - [Metrics](docs/Metrics.md)
 - [MigrationDto](docs/MigrationDto.md)
 - [ModelInfo](docs/ModelInfo.md)
 - [NewVarietyDto](docs/NewVarietyDto.md)
 - [Number](docs/Number.md)
 - [OperationDto](docs/OperationDto.md)
 - [OptionalOfCroppableAreaDto](docs/OptionalOfCroppableAreaDto.md)
 - [PageOfCroppableAreaDto](docs/PageOfCroppableAreaDto.md)
 - [PermissionDto](docs/PermissionDto.md)
 - [PlanDto](docs/PlanDto.md)
 - [PlanDtoForBulkVarieties](docs/PlanDtoForBulkVarieties.md)
 - [PlanTypeDto](docs/PlanTypeDto.md)
 - [PlanTypePreciseDto](docs/PlanTypePreciseDto.md)
 - [PlanTypePreference](docs/PlanTypePreference.md)
 - [PlotImageResponse](docs/PlotImageResponse.md)
 - [PoPDto](docs/PoPDto.md)
 - [Preferences](docs/Preferences.md)
 - [PreferencesDto](docs/PreferencesDto.md)
 - [ProjectAssetDto](docs/ProjectAssetDto.md)
 - [ProjectDto](docs/ProjectDto.md)
 - [ProjectFilterDto](docs/ProjectFilterDto.md)
 - [Quantity](docs/Quantity.md)
 - [Resource](docs/Resource.md)
 - [RootTraceDto](docs/RootTraceDto.md)
 - [SKUTypeDTO](docs/SKUTypeDTO.md)
 - [SatelliteMetricsResponse](docs/SatelliteMetricsResponse.md)
 - [Schedule](docs/Schedule.md)
 - [ScheduleDto](docs/ScheduleDto.md)
 - [ScreenConfigDto](docs/ScreenConfigDto.md)
 - [SeedGradeDto](docs/SeedGradeDto.md)
 - [SeedInputDto](docs/SeedInputDto.md)
 - [SeedInputReasonDto](docs/SeedInputReasonDto.md)
 - [SoilTypeDto](docs/SoilTypeDto.md)
 - [Sort](docs/Sort.md)
 - [SplitCropUnitsDto](docs/SplitCropUnitsDto.md)
 - [TagDto](docs/TagDto.md)
 - [TargetDto](docs/TargetDto.md)
 - [TaskBulkUploadDto](docs/TaskBulkUploadDto.md)
 - [TaskCaDetailsDto](docs/TaskCaDetailsDto.md)
 - [TaskCaStatsDto](docs/TaskCaStatsDto.md)
 - [TaskDetailsESDto](docs/TaskDetailsESDto.md)
 - [TaskDto](docs/TaskDto.md)
 - [TaskESCAChildrenDto](docs/TaskESCAChildrenDto.md)
 - [TaskESCADto](docs/TaskESCADto.md)
 - [TaskNameDto](docs/TaskNameDto.md)
 - [TaskSyncDto](docs/TaskSyncDto.md)
 - [URI](docs/URI.md)
 - [URL](docs/URL.md)
 - [URLStreamHandler](docs/URLStreamHandler.md)
 - [UnitConversionDto](docs/UnitConversionDto.md)
 - [UnitMasterDto](docs/UnitMasterDto.md)
 - [UnitOfConcentrationDto](docs/UnitOfConcentrationDto.md)
 - [UnitOfMeasureDto](docs/UnitOfMeasureDto.md)
 - [UserCompanyDto](docs/UserCompanyDto.md)
 - [UserDto](docs/UserDto.md)
 - [UserRoleDto](docs/UserRoleDto.md)
 - [UserSyncDto](docs/UserSyncDto.md)
 - [UserTargetDto](docs/UserTargetDto.md)
 - [ValidateAssetsFarmerFilterDto](docs/ValidateAssetsFarmerFilterDto.md)
 - [ValidateFarmerFilterDto](docs/ValidateFarmerFilterDto.md)
 - [ValidatedAssetFilterDto](docs/ValidatedAssetFilterDto.md)
 - [ValidtateAssetFilterDto](docs/ValidtateAssetFilterDto.md)
 - [VarietyConsiceDto](docs/VarietyConsiceDto.md)
 - [VarietyCropStageDto](docs/VarietyCropStageDto.md)
 - [VarietyDto](docs/VarietyDto.md)
 - [VendorDto](docs/VendorDto.md)
 - [Weather](docs/Weather.md)
 - [WeatherDataResponse](docs/WeatherDataResponse.md)
 - [YieldResponse](docs/YieldResponse.md)
 - [YieldsData](docs/YieldsData.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author


