"""File-format dicts for BioLogic"""

import numpy as np

__version__ = "0.1"

mpr_label = b"BIO-LOGIC MODULAR FILE\x1a                         \x00\x00\x00\x00"

hdr_dtype = np.dtype(
    [
        ("shortname", "S10"),
        ("longname", "S25"),
        ("length", "<u4"),
        ("version", "<u4"),
        ("date", "S8"),
    ]
)

#
bl_log_pos_dtype = {
    ("User", 139, 143, "a4"),
    ("Directory", 594, 639, "a45"),
    ("File", 640, 684, "a45"),
    ("Host", 850, 863, "a13"),
    ("Comments", 1213, 1255, "a42"),
    ("Acquisition started on", 585, 593, "<f8"),
}


# bl_flags = {
#     1: ["mode", (np.uint8(0x03), np.uint8)],
#     2: ["ox/red", (np.uint8(0x04), np.bool_)],
#     3: ["error", (np.uint8(0x08), np.bool_)],
#     21: ["control changes", (np.uint8(0x10), np.bool_)],
#     31: ["Ns changes", (np.uint8(0x20), np.bool_)],
#     65: ["counter inc.", (np.uint8(0x80), np.bool_)],
#     131: ["Ns", (np.uint8(0x03), np.bool_)], # must check this
# }

bl_flags = {
    1: ["mode", (3, np.uint8)],
    2: ["ox/red", (4, np.bool_)],
    3: ["error", (8, np.bool_)],
    21: ["control changes", (16, np.bool_)],
    31: ["Ns changes", (32, np.bool_)],
    65: ["counter inc.", (128, np.bool_)],
    131: ["Ns", (256, np.bool_)],  # must check this
}

# colno: [dtype, ColHeader, unit, BL_name, cellpyname]
bl_dtypes = {
    1: ["u1", "flags", "int", "mode", ""],
    2: ["u1", "flags", "int", "ox/red", ""],
    3: ["u1", "flags", "int", "error", ""],
    4: ["<f8", "time", "s", "time/s", ""],
    5: ["<f8", "control", "V/mA", "", ""],
    6: ["<f4", "Ewe", "V", "Ewe/V", ""],
    7: ["<f8", "dQ", "mAh", "", ""],
    8: ["<f4", "I", "mA", "I/mA", ""],
    9: ["<f4", "Ece", "", "Ece/V", ""],
    10: ["<f4", "NN_10", "", "", ""],
    11: ["<f8", "I", "mA", "", ""],
    12: ["<f4", "NN_12", "", "", ""],
    13: ["<f8", "QminusQnull", "mA.h", "(Q-Qo)/mA.h", ""],
    14: ["<f4", "NN_14", "", "", ""],
    15: ["<f4", "NN_15", "", "", ""],
    16: ["<f4", "NN_16", "", "", ""],
    17: ["<f4", "NN_17", "", "", ""],
    18: ["<f4", "NN_18", "", "", ""],
    19: ["<f4", "control", "V/mA", "", ""],
    20: ["<f4", "control", "mA", "control/mA", ""],
    21: ["u1", "flags", "int", "control changes", ""],
    22: ["<f4", "NN_22", "", "", ""],
    23: ["<f8", "dQ", "mAh", "", ""],
    24: ["<f8", "cycleno", "int", "", ""],
    25: ["<f4", "NN_25", "", "", ""],
    26: ["<f4", "NN_26", "", "", ""],
    27: ["<f4", "NN_27", "", "", ""],
    28: ["<f4", "NN_28", "", "", ""],
    29: ["<f4", "NN_29", "", "", ""],
    30: ["<f4", "NN_30", "", "", ""],
    31: ["u1", "flags", "int", "Ns changes", ""],
    32: ["<f4", "freq", "Hz", "freq/Hz", ""],
    33: ["<f4", "absEwe", "V", "", ""],
    34: ["<f4", "absI", "A", "", ""],
    35: ["<f4", "phaseZ", "deg", "Phase(Z)/deg", ""],
    36: ["<f4", "absZ", "Ohm", "|Z|/Ohm", ""],
    37: ["<f4", "ReZ", "Ohm", "", ""],
    38: ["<f4", "negImZ", "Ohm", "", ""],
    39: ["<u2", "Irange", "int", "I range", ""],
    40: ["<f4", "NN_40", "", "", ""],
    41: ["<f4", "NN_41", "", "", ""],
    42: ["<f4", "NN_42", "", "", ""],
    43: ["<f4", "NN_43", "", "", ""],
    44: ["<f4", "NN_44", "", "", ""],
    45: ["<f4", "NN_45", "", "", ""],
    46: ["<f4", "NN_46", "", "", ""],
    47: ["<f4", "NN_47", "", "", ""],
    48: ["<f4", "NN_48", "", "", ""],
    49: ["<f4", "NN_49", "", "", ""],
    50: ["<f4", "NN_50", "", "", ""],
    51: ["<f4", "NN_51", "", "", ""],
    52: ["<f4", "NN_52", "", "", ""],
    53: ["<f4", "NN_53", "", "", ""],
    54: ["<f4", "NN_54", "", "", ""],
    55: ["<f4", "NN_55", "", "", ""],
    56: ["<f4", "NN_56", "", "", ""],
    57: ["<f4", "NN_57", "", "", ""],
    58: ["<f4", "NN_58", "", "", ""],
    59: ["<f4", "NN_59", "", "", ""],
    60: ["<f4", "NN_60", "", "", ""],
    61: ["<f4", "NN_61", "", "", ""],
    62: ["<f4", "NN_62", "", "", ""],
    63: ["<f4", "NN_63", "", "", ""],
    64: ["<f4", "NN_64", "", "", ""],
    65: ["u1", "flags", "int", "counter inc.", ""],
    66: ["<f4", "NN_66", "", "", ""],
    67: ["<f4", "NN_67", "", "", ""],
    68: ["<f4", "NN_68", "", "", ""],
    69: ["<f4", "NN_69", "", "", ""],
    70: ["<f4", "P", "W", "", ""],
    71: ["<f4", "QminusQnull", "C", "", ""],
    72: ["<f4", "NN_72", "", "", ""],
    73: ["<f4", "NN_73", "", "", ""],
    74: ["<f8", "Energy", "W.h", "Energy/W.h", ""],
    75: ["<f4", "NN_75", "", "", ""],
    76: ["<f4", "I", "mA", "", ""],
    77: ["<f4", "Ewe", "V", "", ""],
    78: ["<f4", "NN_78", "", "", ""],
    79: ["<f4", "NN_79", "", "", ""],
    80: ["<f4", "NN_80", "", "", ""],
    81: ["<f4", "NN_81", "", "", ""],
    82: ["<f4", "NN_82", "", "", ""],
    83: ["<f4", "NN_83", "", "", ""],
    84: ["<f4", "NN_84", "", "", ""],
    85: ["<f4", "NN_85", "", "", ""],
    86: ["<f4", "NN_86", "", "", ""],
    87: ["<f4", "NN_87", "", "", ""],
    88: ["<f4", "NN_88", "", "", ""],
    89: ["<f4", "NN_89", "", "", ""],
    90: ["<f4", "NN_90", "", "", ""],
    91: ["<f4", "NN_91", "", "", ""],
    92: ["<f4", "NN_92", "", "", ""],
    93: ["<f4", "NN_93", "", "", ""],
    94: ["<f4", "NN_94", "", "", ""],
    95: ["<f4", "NN_95", "", "", ""],
    96: ["<f4", "absEce", "V", "|Ece|/V", ""],
    97: ["<f4", "NN_97", "", "", ""],
    98: ["<f4", "phaseZce", "deg", "Phase(Zce)/deg", ""],
    99: ["<f4", "absZce", "Ohm", "|Zce|/Ohm", ""],
    100: ["<f4", "ReZce", "Ohm", "Re(Zce)/Ohm", ""],
    101: ["<f4", "NN_101", "", "NAME?", ""],
    102: ["<f4", "NN_102", "", "", ""],
    103: ["<f4", "NN_103", "", "", ""],
    104: ["<f4", "NN_104", "", "", ""],
    105: ["<f4", "NN_105", "", "", ""],
    106: ["<f4", "NN_106", "", "", ""],
    107: ["<f4", "NN_107", "", "", ""],
    108: ["<f4", "NN_108", "", "", ""],
    109: ["<f4", "NN_109", "", "", ""],
    110: ["<f4", "NN_110", "", "", ""],
    111: ["<f4", "NN_111", "", "", ""],
    112: ["<f4", "NN_112", "", "", ""],
    113: ["<f4", "NN_113", "", "", ""],
    114: ["<f4", "NN_114", "", "", ""],
    115: ["<f4", "NN_115", "", "", ""],
    116: ["<f4", "NN_116", "", "", ""],
    117: ["<f4", "NN_117", "", "", ""],
    118: ["<f4", "NN_118", "", "", ""],
    119: ["<f4", "NN_119", "", "", ""],
    120: ["<f4", "NN_120", "", "", ""],
    121: ["<f4", "NN_121", "", "", ""],
    122: ["<f4", "NN_122", "", "", ""],
    123: ["<f8", "NN_123", "", "", ""],
    124: ["<f8", "NN_124", "", "", ""],
    125: ["<f8", "capacitance_charge", "microF", "Capacitance charge/micronF", ""],
    126: ["<f8", "NN_126", "", "", ""],
    127: ["<f4", "NN_127", "", "", ""],
    128: ["<f4", "NN_128", "", "", ""],
    129: ["<f4", "NN_129", "", "", ""],
    130: ["<f4", "NN_130", "", "", ""],
    131: ["<u2", "flags2", "", "Ns", ""],
    132: ["<f4", "NN_132", "", "", ""],
    133: ["<f4", "NN_133", "", "", ""],
    134: ["<f4", "NN_134", "", "", ""],
    135: ["<f4", "NN_135", "", "", ""],
    136: ["<f4", "NN_136", "", "", ""],
    137: ["<f4", "NN_137", "", "", ""],
    138: ["<f4", "NN_138", "", "", ""],
    139: ["<f4", "NN_139", "", "", ""],
    140: ["<f4", "NN_140", "", "", ""],
    141: ["<f4", "NN_141", "", "", ""],
    142: ["<f4", "NN_142", "", "", ""],
    143: ["<f4", "NN_143", "", "", ""],
    144: ["<f4", "NN_144", "", "", ""],
    145: ["<f4", "NN_145", "", "", ""],
    146: ["<f4", "NN_146", "", "", ""],
    147: ["<f4", "NN_147", "", "", ""],
    148: ["<f4", "NN_148", "", "", ""],
    149: ["<f4", "NN_149", "", "", ""],
    150: ["<f4", "NN_150", "", "", ""],
    151: ["<f4", "NN_151", "", "", ""],
    152: ["<f4", "NN_152", "", "", ""],
    153: ["<f4", "NN_153", "", "", ""],
    154: ["<f4", "NN_154", "", "", ""],
    155: ["<f4", "NN_155", "", "", ""],
    156: ["<f4", "NN_156", "", "", ""],
    157: ["<f4", "NN_157", "", "", ""],
    158: ["<f4", "NN_158", "", "", ""],
    159: ["<f4", "NN_159", "", "", ""],
    160: ["<f4", "NN_160", "", "", ""],
    161: ["<f4", "NN_161", "", "", ""],
    162: ["<f4", "NN_162", "", "", ""],
    163: ["<f4", "NN_163", "", "", ""],
    164: ["<f4", "NN_164", "", "", ""],
    165: ["<f4", "NN_165", "", "", ""],
    166: ["<f4", "NN_166", "", "", ""],
    167: ["<f4", "NN_167", "", "", ""],
    168: ["<f4", "NN_168", "", "", ""],
    169: ["<f4", "NN_169", "", "", ""],
    170: ["<f4", "NN_170", "", "", ""],
    171: ["<f4", "NN_171", "", "", ""],
    172: ["<f4", "NN_172", "", "", ""],
    173: ["<f4", "NN_173", "", "", ""],
    174: ["<f4", "NN_174", "", "", ""],
    175: ["<f4", "NN_175", "", "", ""],
    176: ["<f4", "NN_176", "", "", ""],
    177: ["<f4", "NN_177", "", "", ""],
    178: ["<f4", "NN_178", "", "", ""],
    179: ["<f4", "NN_179", "", "", ""],
    180: ["<f4", "NN_180", "", "", ""],
    181: ["<f4", "NN_181", "", "", ""],
    182: ["<f4", "NN_182", "", "", ""],
    183: ["<f4", "NN_183", "", "", ""],
    184: ["<f4", "NN_184", "", "", ""],
    185: ["<f4", "NN_185", "", "", ""],
    186: ["<f4", "NN_186", "", "", ""],
    187: ["<f4", "NN_187", "", "", ""],
    188: ["<f4", "NN_188", "", "", ""],
    189: ["<f4", "NN_189", "", "", ""],
    190: ["<f4", "NN_190", "", "", ""],
    191: ["<f4", "NN_191", "", "", ""],
    192: ["<f4", "NN_192", "", "", ""],
    193: ["<f4", "NN_193", "", "", ""],
    194: ["<f4", "NN_194", "", "", ""],
    195: ["<f4", "NN_195", "", "", ""],
    196: ["<f4", "NN_196", "", "", ""],
    197: ["<f4", "NN_197", "", "", ""],
    198: ["<f4", "NN_198", "", "", ""],
    199: ["<f4", "NN_199", "", "", ""],
    200: ["<f4", "NN_200", "", "", ""],
    201: ["<f4", "NN_201", "", "", ""],
    202: ["<f4", "NN_202", "", "", ""],
    203: ["<f4", "NN_203", "", "", ""],
    204: ["<f4", "NN_204", "", "", ""],
    205: ["<f4", "NN_205", "", "", ""],
    206: ["<f4", "NN_206", "", "", ""],
    207: ["<f4", "NN_207", "", "", ""],
    208: ["<f4", "NN_208", "", "", ""],
    209: ["<f4", "NN_209", "", "", ""],
    210: ["<f4", "NN_210", "", "", ""],
    211: ["<f4", "NN_211", "", "", ""],
    212: ["<f4", "NN_212", "", "", ""],
    213: ["<f4", "NN_213", "", "", ""],
    214: ["<f4", "NN_214", "", "", ""],
    215: ["<f4", "NN_215", "", "", ""],
    216: ["<f4", "NN_216", "", "", ""],
    217: ["<f4", "NN_217", "", "", ""],
    218: ["<f4", "NN_218", "", "", ""],
    219: ["<f4", "NN_219", "", "", ""],
    220: ["<f4", "NN_220", "", "", ""],
    221: ["<f4", "NN_221", "", "", ""],
    222: ["<f4", "NN_222", "", "", ""],
    223: ["<f4", "NN_223", "", "", ""],
    224: ["<f4", "NN_224", "", "", ""],
    225: ["<f4", "NN_225", "", "", ""],
    226: ["<f4", "NN_226", "", "", ""],
    227: ["<f4", "NN_227", "", "", ""],
    228: ["<f4", "NN_228", "", "", ""],
    229: ["<f4", "NN_229", "", "", ""],
    230: ["<f4", "NN_230", "", "", ""],
    231: ["<f4", "NN_231", "", "", ""],
    232: ["<f4", "NN_232", "", "", ""],
    233: ["<f4", "NN_233", "", "", ""],
    234: ["<f4", "NN_234", "", "", ""],
    235: ["<f4", "NN_235", "", "", ""],
    236: ["<f4", "NN_236", "", "", ""],
    237: ["<f4", "NN_237", "", "", ""],
    238: ["<f4", "NN_238", "", "", ""],
    239: ["<f4", "NN_239", "", "", ""],
    240: ["<f4", "NN_240", "", "", ""],
    241: ["<f4", "NN_241", "", "", ""],
    242: ["<f4", "NN_242", "", "", ""],
    243: ["<f4", "NN_243", "", "", ""],
    244: ["<f4", "NN_244", "", "", ""],
    245: ["<f4", "NN_245", "", "", ""],
    246: ["<f4", "NN_246", "", "", ""],
    247: ["<f4", "NN_247", "", "", ""],
    248: ["<f4", "NN_248", "", "", ""],
    249: ["<f4", "NN_249", "", "", ""],
    250: ["<f4", "NN_250", "", "", ""],
    251: ["<f4", "NN_251", "", "", ""],
    252: ["<f4", "NN_252", "", "", ""],
    253: ["<f4", "NN_253", "", "", ""],
    254: ["<f4", "NN_254", "", "", ""],
    255: ["<f4", "NN_255", "", "", ""],
    256: ["<f4", "NN_256", "", "", ""],
    257: ["<f4", "NN_257", "", "", ""],
    258: ["<f4", "NN_258", "", "", ""],
    259: ["<f4", "NN_259", "", "", ""],
    260: ["<f4", "NN_260", "", "", ""],
    261: ["<f4", "NN_261", "", "", ""],
    262: ["<f4", "NN_262", "", "", ""],
    263: ["<f4", "NN_263", "", "", ""],
    264: ["<f4", "NN_264", "", "", ""],
    265: ["<f4", "NN_265", "", "", ""],
    266: ["<f4", "NN_266", "", "", ""],
    267: ["<f4", "NN_267", "", "", ""],
    268: ["<f4", "NN_268", "", "", ""],
    269: ["<f4", "NN_269", "", "", ""],
    270: ["<f4", "NN_270", "", "", ""],
    271: ["<f4", "NN_271", "", "", ""],
    272: ["<f4", "NN_272", "", "", ""],
    273: ["<f4", "NN_273", "", "", ""],
    274: ["<f4", "NN_274", "", "", ""],
    275: ["<f4", "NN_275", "", "", ""],
    276: ["<f4", "NN_276", "", "", ""],
    277: ["<f4", "NN_277", "", "", ""],
    278: ["<f4", "NN_278", "", "", ""],
    279: ["<f4", "NN_279", "", "", ""],
    280: ["<f4", "NN_280", "", "", ""],
    281: ["<f4", "NN_281", "", "", ""],
    282: ["<f4", "NN_282", "", "", ""],
    283: ["<f4", "NN_283", "", "", ""],
    284: ["<f4", "NN_284", "", "", ""],
    285: ["<f4", "NN_285", "", "", ""],
    286: ["<f4", "NN_286", "", "", ""],
    287: ["<f4", "NN_287", "", "", ""],
    288: ["<f4", "NN_288", "", "", ""],
    289: ["<f4", "NN_289", "", "", ""],
    290: ["<f4", "NN_290", "", "", ""],
    291: ["<f4", "NN_291", "", "", ""],
    292: ["<f4", "NN_292", "", "", ""],
    293: ["<f4", "NN_293", "", "", ""],
    294: ["<f4", "NN_294", "", "", ""],
    295: ["<f4", "NN_295", "", "", ""],
    296: ["<f4", "NN_296", "", "", ""],
    297: ["<f4", "NN_297", "", "", ""],
    298: ["<f4", "NN_298", "", "", ""],
    299: ["<f4", "NN_299", "", "", ""],
    300: ["<f4", "NN_300", "", "", ""],
    301: ["<f4", "NN_301", "", "", ""],
    302: ["<f4", "NN_302", "", "", ""],
    303: ["<f4", "NN_303", "", "", ""],
    304: ["<f4", "NN_304", "", "", ""],
    305: ["<f4", "NN_305", "", "", ""],
    306: ["<f4", "NN_306", "", "", ""],
    307: ["<f4", "NN_307", "", "", ""],
    308: ["<f4", "NN_308", "", "", ""],
    309: ["<f4", "NN_309", "", "", ""],
    310: ["<f4", "NN_310", "", "", ""],
    311: ["<f4", "NN_311", "", "", ""],
    312: ["<f4", "NN_312", "", "", ""],
    313: ["<f4", "NN_313", "", "", ""],
    314: ["<f4", "NN_314", "", "", ""],
    315: ["<f4", "NN_315", "", "", ""],
    316: ["<f4", "NN_316", "", "", ""],
    317: ["<f4", "NN_317", "", "", ""],
    318: ["<f4", "NN_318", "", "", ""],
    319: ["<f4", "NN_319", "", "", ""],
    320: ["<f4", "NN_320", "", "", ""],
    321: ["<f4", "NN_321", "", "", ""],
    322: ["<f4", "NN_322", "", "", ""],
    323: ["<f4", "NN_323", "", "", ""],
    324: ["<f4", "NN_324", "", "", ""],
    325: ["<f4", "NN_325", "", "", ""],
    326: ["<f4", "NN_326", "", "", ""],
    327: ["<f4", "NN_327", "", "", ""],
    328: ["<f4", "NN_328", "", "", ""],
    329: ["<f4", "NN_329", "", "", ""],
    330: ["<f4", "NN_330", "", "", ""],
    331: ["<f4", "NN_331", "", "", ""],
    332: ["<f4", "NN_332", "", "", ""],
    333: ["<f4", "NN_333", "", "", ""],
    334: ["<f4", "NN_334", "", "", ""],
    335: ["<f4", "NN_335", "", "", ""],
    336: ["<f4", "NN_336", "", "", ""],
    337: ["<f4", "NN_337", "", "", ""],
    338: ["<f4", "NN_338", "", "", ""],
    339: ["<f4", "NN_339", "", "", ""],
    340: ["<f4", "NN_340", "", "", ""],
    341: ["<f4", "NN_341", "", "", ""],
    342: ["<f4", "NN_342", "", "", ""],
    343: ["<f4", "NN_343", "", "", ""],
    344: ["<f4", "NN_344", "", "", ""],
    345: ["<f4", "NN_345", "", "", ""],
    346: ["<f4", "NN_346", "", "", ""],
    347: ["<f4", "NN_347", "", "", ""],
    348: ["<f4", "NN_348", "", "", ""],
    349: ["<f4", "NN_349", "", "", ""],
    350: ["<f4", "NN_350", "", "", ""],
    351: ["<f4", "NN_351", "", "", ""],
    352: ["<f4", "NN_352", "", "", ""],
    353: ["<f4", "NN_353", "", "", ""],
    354: ["<f4", "NN_354", "", "", ""],
    355: ["<f4", "NN_355", "", "", ""],
    356: ["<f4", "NN_356", "", "", ""],
    357: ["<f4", "NN_357", "", "", ""],
    358: ["<f4", "NN_358", "", "", ""],
    359: ["<f4", "NN_359", "", "", ""],
    360: ["<f4", "NN_360", "", "", ""],
    361: ["<f4", "NN_361", "", "", ""],
    362: ["<f4", "NN_362", "", "", ""],
    363: ["<f4", "NN_363", "", "", ""],
    364: ["<f4", "NN_364", "", "", ""],
    365: ["<f4", "NN_365", "", "", ""],
    366: ["<f4", "NN_366", "", "", ""],
    367: ["<f4", "NN_367", "", "", ""],
    368: ["<f4", "NN_368", "", "", ""],
    369: ["<f4", "NN_369", "", "", ""],
    370: ["<f4", "NN_370", "", "", ""],
    371: ["<f4", "NN_371", "", "", ""],
    372: ["<f4", "NN_372", "", "", ""],
    373: ["<f4", "NN_373", "", "", ""],
    374: ["<f4", "NN_374", "", "", ""],
    375: ["<f4", "NN_375", "", "", ""],
    376: ["<f4", "NN_376", "", "", ""],
    377: ["<f4", "NN_377", "", "", ""],
    378: ["<f4", "NN_378", "", "", ""],
    379: ["<f4", "NN_379", "", "", ""],
    380: ["<f4", "NN_380", "", "", ""],
    381: ["<f4", "NN_381", "", "", ""],
    382: ["<f4", "NN_382", "", "", ""],
    383: ["<f4", "NN_383", "", "", ""],
    384: ["<f4", "NN_384", "", "", ""],
    385: ["<f4", "NN_385", "", "", ""],
    386: ["<f4", "NN_386", "", "", ""],
    387: ["<f4", "NN_387", "", "", ""],
    388: ["<f4", "NN_388", "", "", ""],
    389: ["<f4", "NN_389", "", "", ""],
    390: ["<f4", "NN_390", "", "", ""],
    391: ["<f4", "NN_391", "", "", ""],
    392: ["<f4", "NN_392", "", "", ""],
    393: ["<f4", "NN_393", "", "", ""],
    394: ["<f4", "NN_394", "", "", ""],
    395: ["<f4", "NN_395", "", "", ""],
    396: ["<f4", "NN_396", "", "", ""],
    397: ["<f4", "NN_397", "", "", ""],
    398: ["<f4", "NN_398", "", "", ""],
    399: ["<f4", "NN_399", "", "", ""],
    400: ["<f4", "NN_400", "", "", ""],
    401: ["<f4", "NN_401", "", "", ""],
    402: ["<f4", "NN_402", "", "", ""],
    403: ["<f4", "NN_403", "", "", ""],
    404: ["<f4", "NN_404", "", "", ""],
    405: ["<f4", "NN_405", "", "", ""],
    406: ["<f4", "NN_406", "", "", ""],
    407: ["<f4", "NN_407", "", "", ""],
    408: ["<f4", "NN_408", "", "", ""],
    409: ["<f4", "NN_409", "", "", ""],
    410: ["<f4", "NN_410", "", "", ""],
    411: ["<f4", "NN_411", "", "", ""],
    412: ["<f4", "NN_412", "", "", ""],
    413: ["<f4", "NN_413", "", "", ""],
    414: ["<f4", "NN_414", "", "", ""],
    415: ["<f4", "NN_415", "", "", ""],
    416: ["<f4", "NN_416", "", "", ""],
    417: ["<f4", "NN_417", "", "", ""],
    418: ["<f4", "NN_418", "", "", ""],
    419: ["<f4", "NN_419", "", "", ""],
    420: ["<f4", "NN_420", "", "", ""],
    421: ["<f4", "NN_421", "", "", ""],
    422: ["<f4", "NN_422", "", "", ""],
    423: ["<f4", "NN_423", "", "", ""],
    424: ["<f4", "NN_424", "", "", ""],
    425: ["<f4", "NN_425", "", "", ""],
    426: ["<f4", "NN_426", "", "", ""],
    427: ["<f4", "NN_427", "", "", ""],
    428: ["<f4", "NN_428", "", "", ""],
    429: ["<f4", "NN_429", "", "", ""],
    430: ["<f4", "phaseDiffZ", "deg", "Phase(Zwe-ce)/deg", ""],
    431: ["<f4", "absDiffZ", "Ohm", "|Zwe-ce|/Ohm", ""],
    432: ["<f4", "ReDiffZ", "Ohm", "Re(Zwe-ce)/Ohm", ""],
    433: ["<f4", "NN_433", "", "NAME?", ""],
    434: ["<f4", "QminusQnull", "C", "", ""],
    435: ["<f4", "dQ", "C", "", ""],
    436: ["<f4", "NN_436", "", "", ""],
    437: ["<f4", "NN_437", "", "", ""],
    438: ["<f4", "NN_438", "", "", ""],
    439: ["<f4", "NN_439", "", "", ""],
    440: ["<f4", "NN_440", "", "", ""],
    441: ["<f4", "NN_441", "", "", ""],
    442: ["<f4", "NN_442", "", "", ""],
    443: ["<f4", "NN_443", "", "", ""],
    444: ["<f4", "NN_444", "", "", ""],
    445: ["<f4", "NN_445", "", "", ""],
    446: ["<f4", "NN_446", "", "", ""],
    447: ["<f4", "NN_447", "", "", ""],
    448: ["<f4", "NN_448", "", "", ""],
    449: ["<f4", "NN_449", "", "", ""],
    450: ["<f4", "NN_450", "", "", ""],
    451: ["<f4", "NN_451", "", "", ""],
    452: ["<f4", "NN_452", "", "", ""],
    453: ["<f4", "NN_453", "", "", ""],
    454: ["<f4", "NN_454", "", "", ""],
    455: ["<f4", "NN_455", "", "", ""],
    456: ["<f4", "NN_456", "", "", ""],
    457: ["<f4", "NN_457", "", "", ""],
    458: ["<f4", "NN_458", "", "", ""],
    459: ["<f4", "NN_459", "", "", ""],
    460: ["<f4", "NN_460", "", "", ""],
    461: ["<f4", "NN_461", "", "", ""],
    462: ["<f4", "NN_462", "", "", ""],
    463: ["<f4", "NN_463", "", "", ""],
    464: ["<f4", "NN_464", "", "", ""],
    465: ["<f4", "NN_465", "", "", ""],
    466: ["<f4", "NN_466", "", "", ""],
    467: ["<f8", "QChargeDischarge", "mA.h", "Q charge/discharge/mA.h", ""],
    468: ["<f4", "half_cycle", "", "half cycle", ""],
    469: ["<f4", "NN_469", "", "", ""],
    470: ["<f4", "NN_470", "", "", ""],
    471: ["<f4", "avEce", "V", "<Ece>/V", ""],
    472: ["<f4", "NN_472", "", "", ""],
    473: ["<f4", "NN_473", "", "", ""],
    474: ["<f4", "NN_474", "", "", ""],
    475: ["<f4", "NN_475", "", "", ""],
    476: ["<f4", "NN_476", "", "", ""],
    477: ["<f4", "NN_477", "", "", ""],
    478: ["<f4", "NN_478", "", "", ""],
    479: ["<f4", "NN_479", "", "", ""],
    480: ["<f4", "NN_480", "", "", ""],
    481: ["<f4", "NN_481", "", "", ""],
    482: ["<f4", "NN_482", "", "", ""],
    483: ["<f4", "NN_483", "", "", ""],
    484: ["<f4", "NN_484", "", "", ""],
    485: ["<f4", "NN_485", "", "", ""],
    486: ["<f4", "NN_486", "", "", ""],
    487: ["<f4", "NN_487", "", "", ""],
    488: ["<f4", "NN_488", "", "", ""],
    489: ["<f4", "NN_489", "", "", ""],
    490: ["<f4", "NN_490", "", "", ""],
    491: ["<f4", "NN_491", "", "", ""],
    492: ["<f4", "NN_492", "", "", ""],
    493: ["<f4", "NN_493", "", "", ""],
    494: ["<f4", "NN_494", "", "", ""],
    495: ["<f4", "NN_495", "", "", ""],
    496: ["<f4", "NN_496", "", "", ""],
    497: ["<f4", "NN_497", "", "", ""],
    498: ["<f4", "NN_498", "", "", ""],
    499: ["<f4", "NN_499", "", "", ""],
    500: ["<f4", "NN_500", "", "", ""],
}
