"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const cloudfront = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudfront-custom');
new cloudfront.CloudFrontWebDistribution(stack, 'AnAmazingWebsiteProbably', {
    originConfigs: [
        {
            originHeaders: {
                "X-Custom-Header": "somevalue",
            },
            customOriginSource: {
                domainName: "brelandm.a2z.com",
            },
            behaviors: [
                {
                    isDefaultBehavior: true,
                }
            ]
        }
    ],
    aliasConfiguration: {
        acmCertRef: 'testACM',
        names: ['test.test.com'],
        sslMethod: cloudfront.SSLMethod.SNI,
        securityPolicy: cloudfront.SecurityPolicyProtocol.TLSv1
    }
});
app.run();
//# sourceMappingURL=data:application/json;base64,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