# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rsync_watch']

package_data = \
{'': ['*']}

install_requires = \
['command-watcher>=0.4.0,<0.5.0', 'conf2levels>=0.5.0,<0.6.0']

entry_points = \
{'console_scripts': ['rsync-watch.py = rsync_watch:main']}

setup_kwargs = {
    'name': 'rsync-watch',
    'version': '0.5.0',
    'description': 'A Python script to monitor the execution of a rsync task.',
    'long_description': '|pypi.org| |Documentation Status|\n\nrsync-watch.py\n==============\n\nA Python script to monitor the execution of a rsync task.\n\nFeatures\n--------\n\n-  The script ``rsync-watch.py`` parses the ``rsync --stats`` output and\n   sends this statistics to a monitoring system like Nagios or Icinga\n   using the NSCA protocol.\n\n-  The script ``rsync-watch.py`` can be configured to perform various\n   checks before starting the rsync process.\n\n\n\n:: \n\n    usage: rsync-watch.py [-h] [--host-name HOST_NAME]\n                          [--dest-user-group USER_GROUP_NAME]\n                          [--rsync-args RSYNC_ARGS]\n                          [--action-check-failed {exception,skip}]\n                          [--check-file FILE_PATH] [--check-ping DESTINATION]\n                          [--check-ssh-login SSH_LOGIN] [-v]\n                          [--email-from-addr EMAIL_FROM_ADDR]\n                          [--email-to-addr EMAIL_TO_ADDR]\n                          [--email-to-addr-critical EMAIL_TO_ADDR_CRITICAL]\n                          [--email-smtp-login EMAIL_SMTP_LOGIN]\n                          [--email-smtp-password EMAIL_SMTP_PASSWORD]\n                          [--email-smtp-server EMAIL_SMTP_SERVER]\n                          [--nsca-remote-host NSCA_REMOTE_HOST]\n                          [--nsca-password NSCA_PASSWORD]\n                          [--nsca-encryption-method NSCA_ENCRYPTION_METHOD]\n                          [--nsca-port NSCA_PORT] [--icinga-url ICINGA_URL]\n                          [--icinga-user ICINGA_USER]\n                          [--icinga-password ICINGA_PASSWORD]\n                          [--beep-activated BEEP_ACTIVATED]\n                          src dest\n\n    A Python script to monitor the execution of a rsync task.\n\n    positional arguments:\n      src                   The source ([[USER@]HOST:]SRC)\n      dest                  The destination ([[USER@]HOST:]DEST)\n\n    options:\n      -h, --help            show this help message and exit\n      --host-name HOST_NAME\n                            The hostname to submit over NSCA to the monitoring.\n      --dest-user-group USER_GROUP_NAME\n                            Both the user name and the group name of the\n                            destination will be set to this name.\n      --rsync-args RSYNC_ARGS\n                            Rsync CLI arguments. Insert some rsync command line\n                            arguments.Wrap all arguments in one string, for\n                            example: --rsync-args \'--exclude "this folder"\'\n      -v, --version         show program\'s version number and exit\n\n    checks:\n      Perform different checks before running the rsync task.\n\n      --action-check-failed {exception,skip}\n                            Select action what to do when a check failed.\n      --check-file FILE_PATH\n                            Check if a file exists on the local machine.\n      --check-ping DESTINATION\n                            Check if a remote host is reachable by pinging.\n                            DESTINATION can a IP address or a host name or a full\n                            qualified host name.\n      --check-ssh-login SSH_LOGIN\n                            Check if a remote host is reachable over the network\n                            by SSHing into it. SSH_LOGIN: “root@192.168.1.1” or\n                            “root@example.com” or “example.com”.\n\n    email:\n      Generated by the config_reader.\n\n      --email-from-addr EMAIL_FROM_ADDR\n                            The email address of the sender.\n      --email-to-addr EMAIL_TO_ADDR\n                            The email address of the recipient.\n      --email-to-addr-critical EMAIL_TO_ADDR_CRITICAL\n                            The email address of the recipient to send critical\n                            messages to.\n      --email-smtp-login EMAIL_SMTP_LOGIN\n                            The SMTP login name.\n      --email-smtp-password EMAIL_SMTP_PASSWORD\n                            The SMTP password.\n      --email-smtp-server EMAIL_SMTP_SERVER\n                            The URL of the SMTP server, for example:\n                            `smtp.example.com:587`.\n\n    nsca:\n      Generated by the config_reader.\n\n      --nsca-remote-host NSCA_REMOTE_HOST\n                            The IP address of the NSCA remote host.\n      --nsca-password NSCA_PASSWORD\n                            The NSCA password.\n      --nsca-encryption-method NSCA_ENCRYPTION_METHOD\n                            The NSCA encryption method. The supported encryption\n                            methods are: 0 1 2 3 4 8 11 14 15 16\n      --nsca-port NSCA_PORT\n                            The NSCA port.\n\n    icinga:\n      Generated by the config_reader.\n\n      --icinga-url ICINGA_URL\n                            The HTTP URL. /v1/actions/process-check-result is\n                            appended.\n      --icinga-user ICINGA_USER\n                            The user for the HTTP authentification.\n      --icinga-password ICINGA_PASSWORD\n                            The password for the HTTP authentification.\n\n    beep:\n      Generated by the config_reader.\n\n      --beep-activated BEEP_ACTIVATED\n                            Activate the beep channel to report auditive messages.\n\n\n\n\n.. |pypi.org| image:: http://img.shields.io/pypi/v/rsync_watch.svg\n   :target: https://pypi.python.org/pypi/rsync_watch\n.. |Documentation Status| image:: https://readthedocs.org/projects/rsync-watch/badge/?version=latest\n   :target: https://rsync-watch.readthedocs.io/en/latest/?badge=latest',
    'author': 'Josef Friedrich',
    'author_email': 'josef@friedrich.rocks',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/Josef-Friedrich/rsync-watch',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
