# Contributing to wradlib

The wradlib project encourages everyone to contribute to the developement of wradlib. This paper describes the general guidelines for contributing to wradlib. There is more information on [wradlib's community effort](https://wradlib.org/community) at the project's main website [wradlib.org](https://wradlib.org).

In general wradlib uses GitHub Pull Requests for contribution. Second, the [wradlib developers](CONTRIBUTORS.txt) have GitHub Commit Access to the project's main repository.

## Code of Conduct

Contributors to wradlib are expected to act respectfully toward others in accordance with the [OSGeo Code of Conduct](http://www.osgeo.org/code_of_conduct).

## Contributions and Licensing

All contributions shall comply to the project [license](LICENSE.txt).

## GitHub

Source code, testing, bug tracking as well as docs and wiki are handled via GitHub.

## Documentation

* wradlib's documentation source is contained in [wradlib-docs](https://github.com/wradlib/wradlib-docs) repository, and mainly written in reStructuredText.
* Jupyter Notebooks in [wradlib-notebooks](https://github.com/wradlib/wradlib-notebooks) repository are utilized to extend the documentation with examples and tutorials.
* wradlib uses [Sphinx](http://sphinx-doc.org/) and [nbsphinx](https://github.com/spatialaudio/nbsphinx) to compile docs on [readthedocs.org](https://readthedocs.org/projects/wradlib-docs/).

## Issue tracking

Using wradlib's [GitHub issue tracker](https://github.com/wradlib/wradlib/issues) users can file bug reports or discuss feature requests. Bug reports should contain
used wradlib as well as Python and OS version, error messages and instructions to reproduce the bug.

## Forking wradlib

For this purpose, you need to have a [GitHub Account](https://github.com/signup/free) and [Git](https://git-scm.com/). Then fork wradlib, make changes and create a pull request. A [step-by-step guide](http://docs.wradlib.org/en/latest/community.html#how-to-contribute-to) can be found in the docs.

## Development

To keep the code as clean as much all code contributions should be in line with [PEP 8](https://www.python.org/dev/peps/pep-0008/) conventions.


