"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.addCdkConstructVersionTag = exports.Datadog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const loglevel_1 = require("loglevel");
const transport_1 = require("./common/transport");
const index_1 = require("./index");
const versionJson = require("../version.json");
/**
 * @stability stable
 */
class Datadog extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        if (((_b = process.env.DD_CONSTRUCT_DEBUG_LOGS) === null || _b === void 0 ? void 0 : _b.toLowerCase()) == "true") {
            loglevel_1.default.setLevel("debug");
        }
        super(scope, id);
        this.scope = scope;
        this.props = props;
        index_1.validateProps(this.props);
        this.transport = new transport_1.Transport(this.props.flushMetricsToLogs, this.props.site, this.props.apiKey, this.props.apiKeySecretArn, this.props.apiKmsKey, this.props.extensionLayerVersion);
    }
    /**
     * @stability stable
     */
    addLambdaFunctions(lambdaFunctions) {
        const baseProps = index_1.handleSettingPropDefaults(this.props);
        if (this.props !== undefined && lambdaFunctions.length > 0) {
            const region = `${lambdaFunctions[0].env.region}`;
            loglevel_1.default.debug(`Using region: ${region}`);
            if (baseProps.addLayers) {
                index_1.applyLayers(this.scope, region, lambdaFunctions, this.props.pythonLayerVersion, this.props.nodeLayerVersion, this.props.extensionLayerVersion);
            }
            index_1.redirectHandlers(lambdaFunctions, baseProps.addLayers);
            if (this.props.forwarderArn !== undefined) {
                if (this.props.extensionLayerVersion !== undefined) {
                    loglevel_1.default.debug(`Skipping adding subscriptions to the lambda log groups since the extension is enabled`);
                }
                else {
                    loglevel_1.default.debug(`Adding log subscriptions using provided Forwarder ARN: ${this.props.forwarderArn}`);
                    index_1.addForwarder(this.scope, lambdaFunctions, this.props.forwarderArn);
                }
            }
            else {
                loglevel_1.default.debug("Forwarder ARN not provided, no log group subscriptions will be added");
            }
            addCdkConstructVersionTag(lambdaFunctions);
            index_1.applyEnvVariables(lambdaFunctions, baseProps);
            index_1.setDDEnvVariables(lambdaFunctions, this.props);
            setTags(lambdaFunctions, this.props);
            this.transport.applyEnvVars(lambdaFunctions);
        }
    }
    /**
     * @stability stable
     */
    addGitCommitMetadata(lambdaFunctions, gitCommitSha, gitRepoUrl) {
        index_1.setGitCommitEnvironmentVariables(lambdaFunctions, gitCommitSha, gitRepoUrl);
    }
    /**
     * @stability stable
     */
    addForwarderToNonLambdaLogGroups(logGroups) {
        if (this.props.forwarderArn !== undefined) {
            index_1.addForwarderToLogGroups(this.scope, logGroups, this.props.forwarderArn);
        }
        else {
            loglevel_1.default.debug("Forwarder ARN not provided, no non lambda log group subscriptions will be added");
        }
    }
}
exports.Datadog = Datadog;
_a = JSII_RTTI_SYMBOL_1;
Datadog[_a] = { fqn: "datadog-cdk-constructs.Datadog", version: "0.8.4" };
function addCdkConstructVersionTag(lambdaFunctions) {
    loglevel_1.default.debug(`Adding CDK Construct version tag: ${versionJson.version}`);
    lambdaFunctions.forEach((functionName) => {
        cdk.Tags.of(functionName).add(index_1.TagKeys.CDK, `v${versionJson.version}`, {
            includeResourceTypes: ["AWS::Lambda::Function"],
        });
    });
}
exports.addCdkConstructVersionTag = addCdkConstructVersionTag;
function setTags(lambdaFunctions, props) {
    loglevel_1.default.debug(`Adding datadog tags`);
    lambdaFunctions.forEach((functionName) => {
        if (props.forwarderArn) {
            if (props.env) {
                cdk.Tags.of(functionName).add(index_1.TagKeys.ENV, props.env);
            }
            if (props.service) {
                cdk.Tags.of(functionName).add(index_1.TagKeys.SERVICE, props.service);
            }
            if (props.version) {
                cdk.Tags.of(functionName).add(index_1.TagKeys.VERSION, props.version);
            }
            if (props.tags) {
                const tagsArray = props.tags.split(",");
                tagsArray.forEach((tag) => {
                    const [key, value] = tag.split(":");
                    if (key && value) {
                        cdk.Tags.of(functionName).add(key, value);
                    }
                });
            }
        }
    });
}
//# sourceMappingURL=data:application/json;base64,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