"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.setDDEnvVariables = exports.applyEnvVariables = exports.setGitCommitEnvironmentVariables = exports.DD_TAGS = exports.DD_VERSION_ENV_VAR = exports.DD_SERVICE_ENV_VAR = exports.DD_ENV_ENV_VAR = exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR = exports.ENABLE_DD_LOGS_ENV_VAR = exports.LOG_LEVEL_ENV_VAR = exports.INJECT_LOG_CONTEXT_ENV_VAR = exports.ENABLE_XRAY_TRACE_MERGING_ENV_VAR = exports.ENABLE_DD_TRACING_ENV_VAR = void 0;
const loglevel_1 = require("loglevel");
exports.ENABLE_DD_TRACING_ENV_VAR = "DD_TRACE_ENABLED";
exports.ENABLE_XRAY_TRACE_MERGING_ENV_VAR = "DD_MERGE_XRAY_TRACES";
exports.INJECT_LOG_CONTEXT_ENV_VAR = "DD_LOGS_INJECTION";
exports.LOG_LEVEL_ENV_VAR = "DD_LOG_LEVEL";
exports.ENABLE_DD_LOGS_ENV_VAR = "DD_SERVERLESS_LOGS_ENABLED";
exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR = "DD_CAPTURE_LAMBDA_PAYLOAD";
exports.DD_ENV_ENV_VAR = "DD_ENV";
exports.DD_SERVICE_ENV_VAR = "DD_SERVICE";
exports.DD_VERSION_ENV_VAR = "DD_VERSION";
exports.DD_TAGS = "DD_TAGS";
function setGitCommitEnvironmentVariables(lambdas, hash, gitRepoUrl) {
    // We're using an any type here because AWS does not expose the `environment` field in their type
    lambdas.forEach((lambda) => {
        if (lambda.environment[exports.DD_TAGS] !== undefined) {
            lambda.environment[exports.DD_TAGS].value += `,git.commit.sha:${hash}`;
        }
        else {
            lambda.addEnvironment(exports.DD_TAGS, `git.commit.sha:${hash}`);
        }
        if (gitRepoUrl) {
            lambda.environment[exports.DD_TAGS].value += `,git.repository_url:${gitRepoUrl}`;
        }
    });
}
exports.setGitCommitEnvironmentVariables = setGitCommitEnvironmentVariables;
function applyEnvVariables(lambdas, baseProps) {
    loglevel_1.default.debug(`Setting environment variables...`);
    lambdas.forEach((lam) => {
        lam.addEnvironment(exports.ENABLE_DD_TRACING_ENV_VAR, baseProps.enableDatadogTracing.toString().toLowerCase());
        lam.addEnvironment(exports.ENABLE_XRAY_TRACE_MERGING_ENV_VAR, baseProps.enableMergeXrayTraces.toString().toLowerCase());
        lam.addEnvironment(exports.INJECT_LOG_CONTEXT_ENV_VAR, baseProps.injectLogContext.toString().toLowerCase());
        lam.addEnvironment(exports.ENABLE_DD_LOGS_ENV_VAR, baseProps.enableDatadogLogs.toString().toLowerCase());
        lam.addEnvironment(exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR, baseProps.captureLambdaPayload.toString().toLowerCase());
        if (baseProps.logLevel) {
            lam.addEnvironment(exports.LOG_LEVEL_ENV_VAR, baseProps.logLevel);
        }
    });
}
exports.applyEnvVariables = applyEnvVariables;
function setDDEnvVariables(lambdas, props) {
    lambdas.forEach((lam) => {
        if (props.extensionLayerVersion) {
            if (props.env) {
                lam.addEnvironment(exports.DD_ENV_ENV_VAR, props.env);
            }
            if (props.service) {
                lam.addEnvironment(exports.DD_SERVICE_ENV_VAR, props.service);
            }
            if (props.version) {
                lam.addEnvironment(exports.DD_VERSION_ENV_VAR, props.version);
            }
            if (props.tags) {
                lam.addEnvironment(exports.DD_TAGS, props.tags);
            }
        }
    });
}
exports.setDDEnvVariables = setDDEnvVariables;
//# sourceMappingURL=data:application/json;base64,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