"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleSettingPropDefaults = exports.checkForMultipleApiKeys = exports.validateProps = void 0;
const loglevel_1 = require("loglevel");
const constants_1 = require("./constants");
function validateProps(props) {
    loglevel_1.default.debug("Validating props...");
    checkForMultipleApiKeys(props);
    const siteList = [
        "datadoghq.com",
        "datadoghq.eu",
        "us3.datadoghq.com",
        "us5.datadoghq.com",
        "ddog-gov.com",
    ];
    if (props.site !== undefined &&
        !siteList.includes(props.site.toLowerCase()) &&
        !(props.site.startsWith("${Token[") && props.site.endsWith("]}"))) {
        throw new Error("Warning: Invalid site URL. Must be either datadoghq.com, datadoghq.eu, us3.datadoghq.com, us5.datadoghq.com, or ddog-gov.com.");
    }
    if (props.apiKey === undefined &&
        props.apiKmsKey === undefined &&
        props.apiKeySecretArn === undefined &&
        props.flushMetricsToLogs === false) {
        throw new Error("When `flushMetricsToLogs` is false, `apiKey`, `apiKeySecretArn`, or `apiKmsKey` must also be set.");
    }
    if (props.extensionLayerVersion !== undefined) {
        if (props.apiKey === undefined && props.apiKeySecretArn === undefined && props.apiKmsKey === undefined) {
            throw new Error("When `extensionLayer` is set, `apiKey`, `apiKeySecretArn`, or `apiKmsKey` must also be set.");
        }
    }
}
exports.validateProps = validateProps;
function checkForMultipleApiKeys(props) {
    let multipleApiKeysMessage;
    if (props.apiKey !== undefined && props.apiKmsKey !== undefined && props.apiKeySecretArn !== undefined) {
        multipleApiKeysMessage = "`apiKey`, `apiKmsKey`, and `apiKeySecretArn`";
    }
    else if (props.apiKey !== undefined && props.apiKmsKey !== undefined) {
        multipleApiKeysMessage = "`apiKey` and `apiKmsKey`";
    }
    else if (props.apiKey !== undefined && props.apiKeySecretArn !== undefined) {
        multipleApiKeysMessage = "`apiKey` and `apiKeySecretArn`";
    }
    else if (props.apiKmsKey !== undefined && props.apiKeySecretArn !== undefined) {
        multipleApiKeysMessage = "`apiKmsKey` and `apiKeySecretArn`";
    }
    if (multipleApiKeysMessage) {
        throw new Error(`${multipleApiKeysMessage} should not be set at the same time.`);
    }
}
exports.checkForMultipleApiKeys = checkForMultipleApiKeys;
function handleSettingPropDefaults(props) {
    let addLayers = props.addLayers;
    let enableDatadogTracing = props.enableDatadogTracing;
    let enableMergeXrayTraces = props.enableMergeXrayTraces;
    let injectLogContext = props.injectLogContext;
    const logLevel = props.logLevel;
    let enableDatadogLogs = props.enableDatadogLogs;
    let captureLambdaPayload = props.captureLambdaPayload;
    if (addLayers === undefined) {
        loglevel_1.default.debug(`No value provided for addLayers, defaulting to ${constants_1.DefaultDatadogProps.addLayers}`);
        addLayers = constants_1.DefaultDatadogProps.addLayers;
    }
    if (enableDatadogTracing === undefined) {
        loglevel_1.default.debug(`No value provided for enableDatadogTracing, defaulting to ${constants_1.DefaultDatadogProps.enableDatadogTracing}`);
        enableDatadogTracing = constants_1.DefaultDatadogProps.enableDatadogTracing;
    }
    if (enableMergeXrayTraces === undefined) {
        loglevel_1.default.debug(`No value provided for enableMergeXrayTraces, defaulting to ${constants_1.DefaultDatadogProps.enableMergeXrayTraces}`);
        enableMergeXrayTraces = constants_1.DefaultDatadogProps.enableMergeXrayTraces;
    }
    if (injectLogContext === undefined) {
        loglevel_1.default.debug(`No value provided for injectLogContext, defaulting to ${constants_1.DefaultDatadogProps.injectLogContext}`);
        injectLogContext = constants_1.DefaultDatadogProps.injectLogContext;
    }
    if (logLevel === undefined) {
        loglevel_1.default.debug(`No value provided for logLevel`);
    }
    if (enableDatadogLogs === undefined) {
        loglevel_1.default.debug(`No value provided for enableDatadogLogs, defaulting to ${constants_1.DefaultDatadogProps.enableDatadogLogs}`);
        enableDatadogLogs = constants_1.DefaultDatadogProps.enableDatadogLogs;
    }
    if (captureLambdaPayload === undefined) {
        loglevel_1.default.debug(`No value provided for captureLambdaPayload, default to ${constants_1.DefaultDatadogProps.captureLambdaPayload}`);
        captureLambdaPayload = constants_1.DefaultDatadogProps.captureLambdaPayload;
    }
    return {
        addLayers: addLayers,
        enableDatadogTracing: enableDatadogTracing,
        enableMergeXrayTraces: enableMergeXrayTraces,
        injectLogContext: injectLogContext,
        logLevel: logLevel,
        enableDatadogLogs: enableDatadogLogs,
        captureLambdaPayload: captureLambdaPayload,
    };
}
exports.handleSettingPropDefaults = handleSettingPropDefaults;
//# sourceMappingURL=data:application/json;base64,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