"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesResource = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * Represents a resource within the Kubernetes system.
 *
 * Alternatively, you can use `cluster.addResource(resource[, resource, ...])`
 * to define resources on this cluster.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 */
class KubernetesResource extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = props.cluster._attachKubectlResourceScope(this);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: KubernetesResource.RESOURCE_TYPE,
            properties: {
                // `toJsonString` enables embedding CDK tokens in the manifest and will
                // render a CloudFormation-compatible JSON string (similar to
                // StepFunctions, CloudWatch Dashboards etc).
                Manifest: stack.toJsonString(props.manifest),
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._kubectlCreationRole.roleArn,
            },
        });
    }
}
exports.KubernetesResource = KubernetesResource;
/**
 * The CloudFormation reosurce type.
 */
KubernetesResource.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesResource';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiazhzLXJlc291cmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiazhzLXJlc291cmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUFpRTtBQXNDakU7Ozs7Ozs7R0FPRztBQUNILE1BQWEsa0JBQW1CLFNBQVEsZ0JBQVM7SUFNL0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE4QjtRQUN0RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sS0FBSyxHQUFHLFlBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDN0IsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQywyQkFBMkIsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUVqRSxJQUFJLHFCQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNuQyxZQUFZLEVBQUUsUUFBUSxDQUFDLFlBQVk7WUFDbkMsWUFBWSxFQUFFLGtCQUFrQixDQUFDLGFBQWE7WUFDOUMsVUFBVSxFQUFFO2dCQUNWLHVFQUF1RTtnQkFDdkUsNkRBQTZEO2dCQUM3RCw2Q0FBNkM7Z0JBQzdDLFFBQVEsRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUM7Z0JBQzVDLFdBQVcsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLFdBQVc7Z0JBQ3RDLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLG9CQUFvQixDQUFDLE9BQU87YUFDcEQ7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDOztBQXhCSCxnREF5QkM7QUF4QkM7O0dBRUc7QUFDb0IsZ0NBQWEsR0FBRyx1Q0FBdUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCwgQ3VzdG9tUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBDbHVzdGVyIH0gZnJvbSAnLi9jbHVzdGVyJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBLdWJlcm5ldGVzUmVzb3VyY2VzXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgS3ViZXJuZXRlc1Jlc291cmNlUHJvcHMge1xuICAvKipcbiAgICogVGhlIEVLUyBjbHVzdGVyIHRvIGFwcGx5IHRoaXMgY29uZmlndXJhdGlvbiB0by5cbiAgICpcbiAgICogW2Rpc2FibGUtYXdzbGludDpyZWYtdmlhLWludGVyZmFjZV1cbiAgICovXG4gIHJlYWRvbmx5IGNsdXN0ZXI6IENsdXN0ZXI7XG5cbiAgLyoqXG4gICAqIFRoZSByZXNvdXJjZSBtYW5pZmVzdC5cbiAgICpcbiAgICogQ29uc2lzdHMgb2YgYW55IG51bWJlciBvZiBjaGlsZCByZXNvdXJjZXMuXG4gICAqXG4gICAqIFdoZW4gdGhlIHJlc291cmNlIGlzIGNyZWF0ZWQvdXBkYXRlZCwgdGhpcyBtYW5pZmVzdCB3aWxsIGJlIGFwcGxpZWQgdG8gdGhlXG4gICAqIGNsdXN0ZXIgdGhyb3VnaCBga3ViZWN0bCBhcHBseWAgYW5kIHdoZW4gdGhlIHJlc291cmNlIG9yIHRoZSBzdGFjayBpc1xuICAgKiBkZWxldGVkLCB0aGUgbWFuaWZlc3Qgd2lsbCBiZSBkZWxldGVkIHRocm91Z2ggYGt1YmVjdGwgZGVsZXRlYC5cbiAgICpcbiAgICogQGV4YW1wbGVcbiAgICpcbiAgICoge1xuICAgKiAgIGFwaVZlcnNpb246ICd2MScsXG4gICAqICAga2luZDogJ1BvZCcsXG4gICAqICAgbWV0YWRhdGE6IHsgbmFtZTogJ215cG9kJyB9LFxuICAgKiAgIHNwZWM6IHtcbiAgICogICAgIGNvbnRhaW5lcnM6IFsgeyBuYW1lOiAnaGVsbG8nLCBpbWFnZTogJ3BhdWxib3V3ZXIvaGVsbG8ta3ViZXJuZXRlczoxLjUnLCBwb3J0czogWyB7IGNvbnRhaW5lclBvcnQ6IDgwODAgfSBdIH0gXVxuICAgKiAgIH1cbiAgICogfVxuICAgKlxuICAgKi9cbiAgcmVhZG9ubHkgbWFuaWZlc3Q6IGFueVtdO1xufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgYSByZXNvdXJjZSB3aXRoaW4gdGhlIEt1YmVybmV0ZXMgc3lzdGVtLlxuICpcbiAqIEFsdGVybmF0aXZlbHksIHlvdSBjYW4gdXNlIGBjbHVzdGVyLmFkZFJlc291cmNlKHJlc291cmNlWywgcmVzb3VyY2UsIC4uLl0pYFxuICogdG8gZGVmaW5lIHJlc291cmNlcyBvbiB0aGlzIGNsdXN0ZXIuXG4gKlxuICogQXBwbGllcy9kZWxldGVzIHRoZSByZXNvdXJjZXMgdXNpbmcgYGt1YmVjdGxgIGluIHN5bmMgd2l0aCB0aGUgcmVzb3VyY2UuXG4gKi9cbmV4cG9ydCBjbGFzcyBLdWJlcm5ldGVzUmVzb3VyY2UgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICAvKipcbiAgICogVGhlIENsb3VkRm9ybWF0aW9uIHJlb3N1cmNlIHR5cGUuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJFU09VUkNFX1RZUEUgPSAnQ3VzdG9tOjpBV1NDREstRUtTLUt1YmVybmV0ZXNSZXNvdXJjZSc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEt1YmVybmV0ZXNSZXNvdXJjZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IHN0YWNrID0gU3RhY2sub2YodGhpcyk7XG4gICAgY29uc3QgcHJvdmlkZXIgPSBwcm9wcy5jbHVzdGVyLl9hdHRhY2hLdWJlY3RsUmVzb3VyY2VTY29wZSh0aGlzKTtcblxuICAgIG5ldyBDdXN0b21SZXNvdXJjZSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBzZXJ2aWNlVG9rZW46IHByb3ZpZGVyLnNlcnZpY2VUb2tlbixcbiAgICAgIHJlc291cmNlVHlwZTogS3ViZXJuZXRlc1Jlc291cmNlLlJFU09VUkNFX1RZUEUsXG4gICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIC8vIGB0b0pzb25TdHJpbmdgIGVuYWJsZXMgZW1iZWRkaW5nIENESyB0b2tlbnMgaW4gdGhlIG1hbmlmZXN0IGFuZCB3aWxsXG4gICAgICAgIC8vIHJlbmRlciBhIENsb3VkRm9ybWF0aW9uLWNvbXBhdGlibGUgSlNPTiBzdHJpbmcgKHNpbWlsYXIgdG9cbiAgICAgICAgLy8gU3RlcEZ1bmN0aW9ucywgQ2xvdWRXYXRjaCBEYXNoYm9hcmRzIGV0YykuXG4gICAgICAgIE1hbmlmZXN0OiBzdGFjay50b0pzb25TdHJpbmcocHJvcHMubWFuaWZlc3QpLFxuICAgICAgICBDbHVzdGVyTmFtZTogcHJvcHMuY2x1c3Rlci5jbHVzdGVyTmFtZSxcbiAgICAgICAgUm9sZUFybjogcHJvcHMuY2x1c3Rlci5fa3ViZWN0bENyZWF0aW9uUm9sZS5yb2xlQXJuLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxufVxuIl19