"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateCluster = void 0;
const cluster_1 = require("./cluster");
/**
 * Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 */
class FargateCluster extends cluster_1.Cluster {
    constructor(scope, id, props) {
        var _a, _b, _c, _d;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            kubectlEnabled: true,
            coreDnsComputeType: (_a = props.coreDnsComputeType) !== null && _a !== void 0 ? _a : cluster_1.CoreDnsComputeType.FARGATE,
            version: props.version,
        });
        this.addFargateProfile((_c = (_b = props.defaultProfile) === null || _b === void 0 ? void 0 : _b.fargateProfileName) !== null && _c !== void 0 ? _c : (props.defaultProfile ? 'custom' : 'default'), (_d = props.defaultProfile) !== null && _d !== void 0 ? _d : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ],
        });
    }
}
exports.FargateCluster = FargateCluster;
//# sourceMappingURL=data:application/json;base64,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